"use strict";
import "./NodeLink.js";
import * as Lit from "../../../../ui/lit/lit.js";
import { BaseInsightComponent } from "./BaseInsightComponent.js";
const { html } = Lit;
export class Viewport extends BaseInsightComponent {
  static litTagName = Lit.StaticHtml.literal`devtools-performance-viewport`;
  internalName = "viewport";
  hasAskAiSupport() {
    return true;
  }
  getEstimatedSavingsTime() {
    return this.model?.metricSavings?.INP ?? null;
  }
  renderContent() {
    if (!this.model || !this.model.viewportEvent) {
      return Lit.nothing;
    }
    const backendNodeId = this.model.viewportEvent.args.data.node_id;
    if (backendNodeId === void 0) {
      return Lit.nothing;
    }
    return html`
      <div>
        <devtools-performance-node-link
          .data=${{
      backendNodeId,
      frame: this.model.viewportEvent.args.data.frame ?? "",
      options: { tooltip: this.model.viewportEvent.args.data.content },
      fallbackHtmlSnippet: `<meta name=viewport content="${this.model.viewportEvent.args.data.content}">`
    }}>
        </devtools-performance-node-link>
      </div>`;
  }
}
customElements.define("devtools-performance-viewport", Viewport);
//# sourceMappingURL=Viewport.js.map
