// gen/third_party/devtools-frontend/src/front_end/ui/legacy/components/quick_open/quick_open-meta.prebundle.js
import * as i18n from "./../../../../core/i18n/i18n.js";
import * as UI from "./../../legacy.js";
var UIStrings = {
  /**
   * @description Title of action that opens a file
   */
  openFile: "Open file",
  /**
   * @description Title of command that runs a Quick Open command
   */
  runCommand: "Run command"
};
var str_ = i18n.i18n.registerUIStrings("ui/legacy/components/quick_open/quick_open-meta.ts", UIStrings);
var i18nLazyString = i18n.i18n.getLazilyComputedLocalizedString.bind(void 0, str_);
var loadedQuickOpenModule;
async function loadQuickOpenModule() {
  if (!loadedQuickOpenModule) {
    loadedQuickOpenModule = await import("./quick_open.js");
  }
  return loadedQuickOpenModule;
}
UI.ActionRegistration.registerActionExtension({
  actionId: "quick-open.show-command-menu",
  category: UI.ActionRegistration.ActionCategory.GLOBAL,
  title: i18nLazyString(UIStrings.runCommand),
  async loadActionDelegate() {
    const QuickOpen = await loadQuickOpenModule();
    return new QuickOpen.CommandMenu.ShowActionDelegate();
  },
  bindings: [
    {
      platform: UI.ActionRegistration.Platforms.WINDOWS_LINUX,
      shortcut: "Ctrl+Shift+P",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.DEVTOOLS_DEFAULT,
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    },
    {
      platform: UI.ActionRegistration.Platforms.MAC,
      shortcut: "Meta+Shift+P",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.DEVTOOLS_DEFAULT,
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    },
    {
      shortcut: "F1",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    }
  ]
});
UI.ActionRegistration.registerActionExtension({
  actionId: "quick-open.show",
  category: UI.ActionRegistration.ActionCategory.GLOBAL,
  title: i18nLazyString(UIStrings.openFile),
  async loadActionDelegate() {
    const QuickOpen = await loadQuickOpenModule();
    return new QuickOpen.QuickOpen.ShowActionDelegate();
  },
  order: 100,
  bindings: [
    {
      platform: UI.ActionRegistration.Platforms.MAC,
      shortcut: "Meta+P",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.DEVTOOLS_DEFAULT,
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    },
    {
      platform: UI.ActionRegistration.Platforms.MAC,
      shortcut: "Meta+O",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.DEVTOOLS_DEFAULT,
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    },
    {
      platform: UI.ActionRegistration.Platforms.WINDOWS_LINUX,
      shortcut: "Ctrl+P",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.DEVTOOLS_DEFAULT,
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    },
    {
      platform: UI.ActionRegistration.Platforms.WINDOWS_LINUX,
      shortcut: "Ctrl+O",
      keybindSets: [
        UI.ActionRegistration.KeybindSet.DEVTOOLS_DEFAULT,
        UI.ActionRegistration.KeybindSet.VS_CODE
      ]
    }
  ]
});
UI.ContextMenu.registerItem({
  location: UI.ContextMenu.ItemLocation.MAIN_MENU_DEFAULT,
  actionId: "quick-open.show-command-menu",
  order: void 0
});
UI.ContextMenu.registerItem({
  location: UI.ContextMenu.ItemLocation.MAIN_MENU_DEFAULT,
  actionId: "quick-open.show",
  order: void 0
});
//# sourceMappingURL=quick_open-meta.js.map
