// ui/accessibility/mojom/ax_node_data.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_node_data.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_enums$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/ax_enums.mojom', '../ax_enums.mojom.js');
  }
  var ax_relative_bounds$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_relative_bounds.mojom', 'ax_relative_bounds.mojom.js');
  }



  function AXBitsetData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXBitsetData.prototype.initDefaults_ = function() {
    this.setBits = 0;
    this.values = 0;
  };
  AXBitsetData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXBitsetData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AXBitsetData.encodedSize = codec.kStructHeaderSize + 8;

  AXBitsetData.decode = function(decoder) {
    var packed;
    var val = new AXBitsetData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.setBits =
        decoder.decodeStruct(codec.Uint32);
    val.values =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AXBitsetData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXBitsetData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.setBits);
    encoder.encodeStruct(codec.Uint32, val.values);
  };
  function AXNodeData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXNodeData.prototype.initDefaults_ = function() {
    this.id = 0;
    this.role = 0;
    this.state = 0;
    this.actions = 0;
    this.stringAttributes = null;
    this.intAttributes = null;
    this.floatAttributes = null;
    this.boolAttributes = null;
    this.intlistAttributes = null;
    this.stringlistAttributes = null;
    this.htmlAttributes = null;
    this.childIds = null;
    this.relativeBounds = null;
    this.boolAttributesData = null;
  };
  AXNodeData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXNodeData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AXNodeData.role
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ax_enums$.Role);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AXNodeData.stringAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 24, false, new codec.Enum(ax_enums$.StringAttribute), codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.intAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 32, false, new codec.Enum(ax_enums$.IntAttribute), codec.Int32, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.floatAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, false, new codec.Enum(ax_enums$.FloatAttribute), codec.Float, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.boolAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 48, true, new codec.Enum(ax_enums$.BoolAttribute), codec.PackedBool, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.intlistAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 56, false, new codec.Enum(ax_enums$.IntListAttribute), new codec.ArrayOf(codec.Int32), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.stringlistAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 64, false, new codec.Enum(ax_enums$.StringListAttribute), new codec.ArrayOf(codec.String), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.htmlAttributes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 72, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.childIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 80, 4, codec.Int32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.relativeBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, ax_relative_bounds$.AXRelativeBounds, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXNodeData.boolAttributesData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, AXBitsetData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXNodeData.encodedSize = codec.kStructHeaderSize + 104;

  AXNodeData.decode = function(decoder) {
    var packed;
    var val = new AXNodeData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.role =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Role));
    val.state =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.actions =
        decoder.decodeStruct(codec.Uint64);
    val.stringAttributes =
        decoder.decodeMapPointer(new codec.Enum(ax_enums$.StringAttribute), codec.String);
    val.intAttributes =
        decoder.decodeMapPointer(new codec.Enum(ax_enums$.IntAttribute), codec.Int32);
    val.floatAttributes =
        decoder.decodeMapPointer(new codec.Enum(ax_enums$.FloatAttribute), codec.Float);
    val.boolAttributes =
        decoder.decodeMapPointer(new codec.Enum(ax_enums$.BoolAttribute), codec.PackedBool);
    val.intlistAttributes =
        decoder.decodeMapPointer(new codec.Enum(ax_enums$.IntListAttribute), new codec.ArrayOf(codec.Int32));
    val.stringlistAttributes =
        decoder.decodeMapPointer(new codec.Enum(ax_enums$.StringListAttribute), new codec.ArrayOf(codec.String));
    val.htmlAttributes =
        decoder.decodeMapPointer(codec.String, codec.String);
    val.childIds =
        decoder.decodeArrayPointer(codec.Int32);
    val.relativeBounds =
        decoder.decodeStructPointer(ax_relative_bounds$.AXRelativeBounds);
    val.boolAttributesData =
        decoder.decodeStructPointer(AXBitsetData);
    return val;
  };

  AXNodeData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXNodeData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.role);
    encoder.encodeStruct(codec.Uint32, val.state);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.actions);
    encoder.encodeMapPointer(new codec.Enum(ax_enums$.StringAttribute), codec.String, val.stringAttributes);
    encoder.encodeMapPointer(new codec.Enum(ax_enums$.IntAttribute), codec.Int32, val.intAttributes);
    encoder.encodeMapPointer(new codec.Enum(ax_enums$.FloatAttribute), codec.Float, val.floatAttributes);
    encoder.encodeMapPointer(new codec.Enum(ax_enums$.BoolAttribute), codec.PackedBool, val.boolAttributes);
    encoder.encodeMapPointer(new codec.Enum(ax_enums$.IntListAttribute), new codec.ArrayOf(codec.Int32), val.intlistAttributes);
    encoder.encodeMapPointer(new codec.Enum(ax_enums$.StringListAttribute), new codec.ArrayOf(codec.String), val.stringlistAttributes);
    encoder.encodeMapPointer(codec.String, codec.String, val.htmlAttributes);
    encoder.encodeArrayPointer(codec.Int32, val.childIds);
    encoder.encodeStructPointer(ax_relative_bounds$.AXRelativeBounds, val.relativeBounds);
    encoder.encodeStructPointer(AXBitsetData, val.boolAttributesData);
  };
  exports.AXBitsetData = AXBitsetData;
  exports.AXNodeData = AXNodeData;
})();