// ui/display/mojom/display_configuration_params.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/display/mojom/display_configuration_params.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('display.mojom');
  var display_mode$ =
      mojo.internal.exposeNamespace('display.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/display/mojom/display_mode.mojom', 'display_mode.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../gfx/geometry/mojom/geometry.mojom.js');
  }



  function DisplayConfigurationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DisplayConfigurationParams.prototype.initDefaults_ = function() {
    this.id = 0;
    this.origin = null;
    this.mode = null;
    this.enableVrr = false;
  };
  DisplayConfigurationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DisplayConfigurationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DisplayConfigurationParams.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplayConfigurationParams.mode
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, display_mode$.DisplayMode, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DisplayConfigurationParams.encodedSize = codec.kStructHeaderSize + 32;

  DisplayConfigurationParams.decode = function(decoder) {
    var packed;
    var val = new DisplayConfigurationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int64);
    val.origin =
        decoder.decodeStructPointer(geometry$.Point);
    val.mode =
        decoder.decodeStructPointer(display_mode$.DisplayMode);
    packed = decoder.readUint8();
    val.enableVrr = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DisplayConfigurationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DisplayConfigurationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.id);
    encoder.encodeStructPointer(geometry$.Point, val.origin);
    encoder.encodeStructPointer(display_mode$.DisplayMode, val.mode);
    packed = 0;
    packed |= (val.enableVrr & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.DisplayConfigurationParams = DisplayConfigurationParams;
})();