// ui/display/mojom/screen_infos.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/display/mojom/screen_infos.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('display.mojom');
  var screen_info$ =
      mojo.internal.exposeNamespace('display.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/display/mojom/screen_info.mojom', 'screen_info.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../gfx/geometry/mojom/geometry.mojom.js');
  }



  function ScreenInfos(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScreenInfos.prototype.initDefaults_ = function() {
    this.screenInfos = null;
    this.currentDisplayId = 0;
    this.systemCursorSize = null;
  };
  ScreenInfos.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScreenInfos.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScreenInfos.screenInfos
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(screen_info$.ScreenInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ScreenInfos.systemCursorSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ScreenInfos.encodedSize = codec.kStructHeaderSize + 24;

  ScreenInfos.decode = function(decoder) {
    var packed;
    var val = new ScreenInfos();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.screenInfos =
        decoder.decodeArrayPointer(new codec.PointerTo(screen_info$.ScreenInfo));
    val.currentDisplayId =
        decoder.decodeStruct(codec.Int64);
    val.systemCursorSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  ScreenInfos.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScreenInfos.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(screen_info$.ScreenInfo), val.screenInfos);
    encoder.encodeStruct(codec.Int64, val.currentDisplayId);
    encoder.encodeStructPointer(geometry$.Size, val.systemCursorSize);
  };
  exports.ScreenInfos = ScreenInfos;
})();