// ui/events/mojom/event.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  PointF as gfx_mojom_PointF,
  PointFSpec as gfx_mojom_PointFSpec,
  Vector2d as gfx_mojom_Vector2d,
  Vector2dSpec as gfx_mojom_Vector2dSpec
} from '../../gfx/geometry/mojom/geometry.mojom.m.js';

import {
  LatencyInfo as ui_mojom_LatencyInfo,
  LatencyInfoSpec as ui_mojom_LatencyInfoSpec
} from '../../latency/mojom/latency_info.mojom.m.js';

import {
  EventMomentumPhase as ui_mojom_EventMomentumPhase,
  EventMomentumPhaseSpec as ui_mojom_EventMomentumPhaseSpec,
  EventPointerType as ui_mojom_EventPointerType,
  EventPointerTypeSpec as ui_mojom_EventPointerTypeSpec,
  EventType as ui_mojom_EventType,
  EventTypeSpec as ui_mojom_EventTypeSpec,
  GestureDeviceType as ui_mojom_GestureDeviceType,
  GestureDeviceTypeSpec as ui_mojom_GestureDeviceTypeSpec,
  ScrollEventPhase as ui_mojom_ScrollEventPhase,
  ScrollEventPhaseSpec as ui_mojom_ScrollEventPhaseSpec
} from './event_constants.mojom.m.js';



/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocationDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GesturePinchDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GestureSwipeDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GestureDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScrollDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PointerDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MouseDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TouchDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const GestureDataDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    KeyDataSpec.$,
    'KeyData',
    [
      mojo.internal.StructField(
        'keyCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domCode', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domKey', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isChar', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class KeyData {
  constructor() {
    /** @type { !number } */
    this.keyCode;
    /** @type { !number } */
    this.domCode;
    /** @type { !number } */
    this.domKey;
    /** @type { !boolean } */
    this.isChar;
  }
}



mojo.internal.Struct(
    LocationDataSpec.$,
    'LocationData',
    [
      mojo.internal.StructField(
        'relativeLocation', 0,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rootLocation', 8,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LocationData {
  constructor() {
    /** @type { !gfx_mojom_PointF } */
    this.relativeLocation;
    /** @type { !gfx_mojom_PointF } */
    this.rootLocation;
  }
}



mojo.internal.Struct(
    GesturePinchDataSpec.$,
    'GesturePinchData',
    [
      mojo.internal.StructField(
        'scale', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GesturePinchData {
  constructor() {
    /** @type { !number } */
    this.scale;
  }
}



mojo.internal.Struct(
    GestureSwipeDataSpec.$,
    'GestureSwipeData',
    [
      mojo.internal.StructField(
        'left', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'right', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'up', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'down', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GestureSwipeData {
  constructor() {
    /** @type { !boolean } */
    this.left;
    /** @type { !boolean } */
    this.right;
    /** @type { !boolean } */
    this.up;
    /** @type { !boolean } */
    this.down;
  }
}



mojo.internal.Struct(
    GestureDataSpec.$,
    'GestureData',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        LocationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceType', 8,
        0,
        ui_mojom_GestureDeviceTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 16,
        0,
        GestureDataDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class GestureData {
  constructor() {
    /** @type { !LocationData } */
    this.location;
    /** @type { !ui_mojom_GestureDeviceType } */
    this.deviceType;
    /** @type { (GestureDataDetails|undefined) } */
    this.details;
  }
}



mojo.internal.Struct(
    ScrollDataSpec.$,
    'ScrollData',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        LocationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'xOffset', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'yOffset', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'xOffsetOrdinal', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'yOffsetOrdinal', 20,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fingerCount', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'momentumPhase', 28,
        0,
        ui_mojom_EventMomentumPhaseSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollEventPhase', 32,
        0,
        ui_mojom_ScrollEventPhaseSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ScrollData {
  constructor() {
    /** @type { !LocationData } */
    this.location;
    /** @type { !number } */
    this.xOffset;
    /** @type { !number } */
    this.yOffset;
    /** @type { !number } */
    this.xOffsetOrdinal;
    /** @type { !number } */
    this.yOffsetOrdinal;
    /** @type { !number } */
    this.fingerCount;
    /** @type { !ui_mojom_EventMomentumPhase } */
    this.momentumPhase;
    /** @type { !ui_mojom_ScrollEventPhase } */
    this.scrollEventPhase;
  }
}



mojo.internal.Struct(
    PointerDetailsSpec.$,
    'PointerDetails',
    [
      mojo.internal.StructField(
        'pointerType', 0,
        0,
        ui_mojom_EventPointerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'radiusX', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'radiusY', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'force', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tiltX', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tiltY', 20,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tangentialPressure', 24,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'twist', 28,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offsetX', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offsetY', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PointerDetails {
  constructor() {
    /** @type { !ui_mojom_EventPointerType } */
    this.pointerType;
    /** @type { !number } */
    this.radiusX;
    /** @type { !number } */
    this.radiusY;
    /** @type { !number } */
    this.force;
    /** @type { !number } */
    this.tiltX;
    /** @type { !number } */
    this.tiltY;
    /** @type { !number } */
    this.tangentialPressure;
    /** @type { !number } */
    this.twist;
    /** @type { !number } */
    this.id;
    /** @type { !number } */
    this.offsetX;
    /** @type { !number } */
    this.offsetY;
  }
}



mojo.internal.Struct(
    MouseDataSpec.$,
    'MouseData',
    [
      mojo.internal.StructField(
        'changedButtonFlags', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'location', 8,
        0,
        LocationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerDetails', 16,
        0,
        PointerDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wheelOffset', 24,
        0,
        gfx_mojom_Vector2dSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tick120ths', 32,
        0,
        gfx_mojom_Vector2dSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class MouseData {
  constructor() {
    /** @type { !number } */
    this.changedButtonFlags;
    /** @type { !LocationData } */
    this.location;
    /** @type { !PointerDetails } */
    this.pointerDetails;
    /** @type { !gfx_mojom_Vector2d } */
    this.wheelOffset;
    /** @type { !gfx_mojom_Vector2d } */
    this.tick120ths;
  }
}



mojo.internal.Struct(
    TouchDataSpec.$,
    'TouchData',
    [
      mojo.internal.StructField(
        'mayCauseScrolling', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hovering', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'location', 8,
        0,
        LocationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerDetails', 16,
        0,
        PointerDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TouchData {
  constructor() {
    /** @type { !boolean } */
    this.mayCauseScrolling;
    /** @type { !boolean } */
    this.hovering;
    /** @type { !LocationData } */
    this.location;
    /** @type { !PointerDetails } */
    this.pointerDetails;
  }
}



mojo.internal.Struct(
    EventSpec.$,
    'Event',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        ui_mojom_EventTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeStamp', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'latency', 16,
        0,
        ui_mojom_LatencyInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyData', 24,
        0,
        KeyDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gestureData', 32,
        0,
        GestureDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollData', 40,
        0,
        ScrollDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'touchData', 48,
        0,
        TouchDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseData', 56,
        0,
        MouseDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'properties', 64,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class Event {
  constructor() {
    /** @type { !ui_mojom_EventType } */
    this.action;
    /** @type { !number } */
    this.flags;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timeStamp;
    /** @type { !ui_mojom_LatencyInfo } */
    this.latency;
    /** @type { (KeyData|undefined) } */
    this.keyData;
    /** @type { (GestureData|undefined) } */
    this.gestureData;
    /** @type { (ScrollData|undefined) } */
    this.scrollData;
    /** @type { (TouchData|undefined) } */
    this.touchData;
    /** @type { (MouseData|undefined) } */
    this.mouseData;
    /** @type { (Object<!string, !Array<!number>>|undefined) } */
    this.properties;
  }
}

mojo.internal.Union(
    GestureDataDetailsSpec.$, 'GestureDataDetails',
    {
      'pinch': {
        'ordinal': 0,
        'type': GesturePinchDataSpec.$,
      },
      'swipe': {
        'ordinal': 1,
        'type': GestureSwipeDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   pinch: (!GesturePinchData|undefined),
 *   swipe: (!GestureSwipeData|undefined),
 * } }
 */
export const GestureDataDetails = {};
