// ui/gfx/mojom/gpu_extra_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gfx/mojom/gpu_extra_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gfx.mojom');
  var buffer_types$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/buffer_types.mojom', 'buffer_types.mojom.js');
  }



  function ANGLEFeature(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ANGLEFeature.prototype.initDefaults_ = function() {
    this.name = null;
    this.category = null;
    this.status = null;
  };
  ANGLEFeature.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ANGLEFeature.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ANGLEFeature.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ANGLEFeature.category
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ANGLEFeature.status
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ANGLEFeature.encodedSize = codec.kStructHeaderSize + 24;

  ANGLEFeature.decode = function(decoder) {
    var packed;
    var val = new ANGLEFeature();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.category =
        decoder.decodeStruct(codec.String);
    val.status =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ANGLEFeature.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ANGLEFeature.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.category);
    encoder.encodeStruct(codec.String, val.status);
  };
  function GpuExtraInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GpuExtraInfo.prototype.initDefaults_ = function() {
    this.angleFeatures = null;
    this.gpuMemoryBufferSupportX11 = null;
  };
  GpuExtraInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GpuExtraInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuExtraInfo.angleFeatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ANGLEFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuExtraInfo.gpuMemoryBufferSupportX11
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(buffer_types$.BufferUsageAndFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GpuExtraInfo.encodedSize = codec.kStructHeaderSize + 16;

  GpuExtraInfo.decode = function(decoder) {
    var packed;
    var val = new GpuExtraInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.angleFeatures =
        decoder.decodeArrayPointer(new codec.PointerTo(ANGLEFeature));
    val.gpuMemoryBufferSupportX11 =
        decoder.decodeArrayPointer(new codec.PointerTo(buffer_types$.BufferUsageAndFormat));
    return val;
  };

  GpuExtraInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GpuExtraInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ANGLEFeature), val.angleFeatures);
    encoder.encodeArrayPointer(new codec.PointerTo(buffer_types$.BufferUsageAndFormat), val.gpuMemoryBufferSupportX11);
  };
  exports.ANGLEFeature = ANGLEFeature;
  exports.GpuExtraInfo = GpuExtraInfo;
})();