// ui/gfx/mojom/native_handle_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gfx/mojom/native_handle_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gfx.mojom');
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }



  function NativePixmapPlane(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NativePixmapPlane.prototype.initDefaults_ = function() {
    this.stride = 0;
    this.bufferHandle = null;
    this.offset = 0;
    this.size = 0;
  };
  NativePixmapPlane.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NativePixmapPlane.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate NativePixmapPlane.bufferHandle
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NativePixmapPlane.encodedSize = codec.kStructHeaderSize + 24;

  NativePixmapPlane.decode = function(decoder) {
    var packed;
    var val = new NativePixmapPlane();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stride =
        decoder.decodeStruct(codec.Uint32);
    val.bufferHandle =
        decoder.decodeStruct(codec.Handle);
    val.offset =
        decoder.decodeStruct(codec.Uint64);
    val.size =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  NativePixmapPlane.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NativePixmapPlane.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.stride);
    encoder.encodeStruct(codec.Handle, val.bufferHandle);
    encoder.encodeStruct(codec.Uint64, val.offset);
    encoder.encodeStruct(codec.Uint64, val.size);
  };
  function NativePixmapHandle(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NativePixmapHandle.prototype.initDefaults_ = function() {
    this.planes = null;
    this.modifier = 0;
    this.supportsZeroCopyWebgpuImport = false;
  };
  NativePixmapHandle.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NativePixmapHandle.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NativePixmapHandle.planes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(NativePixmapPlane), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  NativePixmapHandle.encodedSize = codec.kStructHeaderSize + 24;

  NativePixmapHandle.decode = function(decoder) {
    var packed;
    var val = new NativePixmapHandle();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.planes =
        decoder.decodeArrayPointer(new codec.PointerTo(NativePixmapPlane));
    val.modifier =
        decoder.decodeStruct(codec.Uint64);
    packed = decoder.readUint8();
    val.supportsZeroCopyWebgpuImport = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NativePixmapHandle.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NativePixmapHandle.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(NativePixmapPlane), val.planes);
    encoder.encodeStruct(codec.Uint64, val.modifier);
    packed = 0;
    packed |= (val.supportsZeroCopyWebgpuImport & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function GpuMemoryBufferPlatformHandle(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GpuMemoryBufferPlatformHandle.Tags = {
    sharedMemoryHandle: 0,
    nativePixmapHandle: 1,
  };

  GpuMemoryBufferPlatformHandle.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GpuMemoryBufferPlatformHandle.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "sharedMemoryHandle",
        "nativePixmapHandle",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GpuMemoryBufferPlatformHandle member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GpuMemoryBufferPlatformHandle.prototype, "sharedMemoryHandle", {
    get: function() {
      if (this.$tag != GpuMemoryBufferPlatformHandle.Tags.sharedMemoryHandle) {
        throw new ReferenceError(
            "GpuMemoryBufferPlatformHandle.sharedMemoryHandle is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GpuMemoryBufferPlatformHandle.Tags.sharedMemoryHandle;
      this.$data = value;
    }
  });
  Object.defineProperty(GpuMemoryBufferPlatformHandle.prototype, "nativePixmapHandle", {
    get: function() {
      if (this.$tag != GpuMemoryBufferPlatformHandle.Tags.nativePixmapHandle) {
        throw new ReferenceError(
            "GpuMemoryBufferPlatformHandle.nativePixmapHandle is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GpuMemoryBufferPlatformHandle.Tags.nativePixmapHandle;
      this.$data = value;
    }
  });


    GpuMemoryBufferPlatformHandle.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GpuMemoryBufferPlatformHandle.Tags.sharedMemoryHandle:
          encoder.encodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion, val.sharedMemoryHandle);
          break;
        case GpuMemoryBufferPlatformHandle.Tags.nativePixmapHandle:
          encoder.encodeStructPointer(NativePixmapHandle, val.nativePixmapHandle);
          break;
      }
      encoder.align();
    };


    GpuMemoryBufferPlatformHandle.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GpuMemoryBufferPlatformHandle();
      var tag = decoder.readUint32();
      switch (tag) {
        case GpuMemoryBufferPlatformHandle.Tags.sharedMemoryHandle:
          result.sharedMemoryHandle = decoder.decodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion);
          break;
        case GpuMemoryBufferPlatformHandle.Tags.nativePixmapHandle:
          result.nativePixmapHandle = decoder.decodeStructPointer(NativePixmapHandle);
          break;
      }
      decoder.align();

      return result;
    };


    GpuMemoryBufferPlatformHandle.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GpuMemoryBufferPlatformHandle.Tags.sharedMemoryHandle:
          

    // validate GpuMemoryBufferPlatformHandle.sharedMemoryHandle
    err = messageValidator.validateStructPointer(data_offset, shared_memory$.UnsafeSharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GpuMemoryBufferPlatformHandle.Tags.nativePixmapHandle:
          

    // validate GpuMemoryBufferPlatformHandle.nativePixmapHandle
    err = messageValidator.validateStructPointer(data_offset, NativePixmapHandle, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GpuMemoryBufferPlatformHandle.encodedSize = 16;
  exports.NativePixmapPlane = NativePixmapPlane;
  exports.NativePixmapHandle = NativePixmapHandle;
  exports.GpuMemoryBufferPlatformHandle = GpuMemoryBufferPlatformHandle;
})();