// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ClusterSpec as historyClusters_mojom_ClusterSpec, URLVisitSpec as historyClusters_mojom_URLVisitSpec } from './history_cluster_types.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { ClickModifiersSpec as ui_mojom_ClickModifiersSpec } from '//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js';
import { PointSpec as gfx_mojom_PointSpec } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const ClusterActionSpec = { $: mojo.internal.Enum() };
export var ClusterAction;
(function (ClusterAction) {
    ClusterAction[ClusterAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    ClusterAction[ClusterAction["MAX_VALUE"] = 3] = "MAX_VALUE";
    ClusterAction[ClusterAction["kDeleted"] = 0] = "kDeleted";
    ClusterAction[ClusterAction["kOpenedInTabGroup"] = 1] = "kOpenedInTabGroup";
    ClusterAction[ClusterAction["kRelatedSearchClicked"] = 2] = "kRelatedSearchClicked";
    ClusterAction[ClusterAction["kVisitClicked"] = 3] = "kVisitClicked";
})(ClusterAction || (ClusterAction = {}));
export const RelatedSearchActionSpec = { $: mojo.internal.Enum() };
export var RelatedSearchAction;
(function (RelatedSearchAction) {
    RelatedSearchAction[RelatedSearchAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    RelatedSearchAction[RelatedSearchAction["MAX_VALUE"] = 0] = "MAX_VALUE";
    RelatedSearchAction[RelatedSearchAction["kClicked"] = 0] = "kClicked";
})(RelatedSearchAction || (RelatedSearchAction = {}));
export const VisitActionSpec = { $: mojo.internal.Enum() };
export var VisitAction;
(function (VisitAction) {
    VisitAction[VisitAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    VisitAction[VisitAction["MAX_VALUE"] = 2] = "MAX_VALUE";
    VisitAction[VisitAction["kClicked"] = 0] = "kClicked";
    VisitAction[VisitAction["kHidden"] = 1] = "kHidden";
    VisitAction[VisitAction["kDeleted"] = 2] = "kDeleted";
})(VisitAction || (VisitAction = {}));
export const VisitTypeSpec = { $: mojo.internal.Enum() };
export var VisitType;
(function (VisitType) {
    VisitType[VisitType["MIN_VALUE"] = 0] = "MIN_VALUE";
    VisitType[VisitType["MAX_VALUE"] = 1] = "MAX_VALUE";
    VisitType[VisitType["kSRP"] = 0] = "kSRP";
    VisitType[VisitType["kNonSRP"] = 1] = "kNonSRP";
})(VisitType || (VisitType = {}));
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_clusters.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    openHistoryUrl(url, clickModifiers) {
        this.proxy.sendMessage(0, PageHandler_OpenHistoryUrl_ParamsSpec.$, null, [
            url,
            clickModifiers
        ], false);
    }
    setPage(page) {
        this.proxy.sendMessage(1, PageHandler_SetPage_ParamsSpec.$, null, [
            page
        ], false);
    }
    showContextMenuForSearchbox(query, point) {
        this.proxy.sendMessage(2, PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$, null, [
            query,
            point
        ], false);
    }
    showContextMenuForURL(url, point) {
        this.proxy.sendMessage(3, PageHandler_ShowContextMenuForURL_ParamsSpec.$, null, [
            url,
            point
        ], false);
    }
    showSidePanelUI() {
        this.proxy.sendMessage(4, PageHandler_ShowSidePanelUI_ParamsSpec.$, null, [], false);
    }
    toggleVisibility(visible) {
        return this.proxy.sendMessage(5, PageHandler_ToggleVisibility_ParamsSpec.$, PageHandler_ToggleVisibility_ResponseParamsSpec.$, [
            visible
        ], false);
    }
    startQueryClusters(query, beginTime, recluster) {
        this.proxy.sendMessage(6, PageHandler_StartQueryClusters_ParamsSpec.$, null, [
            query,
            beginTime,
            recluster
        ], false);
    }
    loadMoreClusters(query) {
        this.proxy.sendMessage(7, PageHandler_LoadMoreClusters_ParamsSpec.$, null, [
            query
        ], false);
    }
    hideVisits(visits) {
        return this.proxy.sendMessage(8, PageHandler_HideVisits_ParamsSpec.$, PageHandler_HideVisits_ResponseParamsSpec.$, [
            visits
        ], false);
    }
    removeVisits(visits) {
        return this.proxy.sendMessage(9, PageHandler_RemoveVisits_ParamsSpec.$, PageHandler_RemoveVisits_ResponseParamsSpec.$, [
            visits
        ], false);
    }
    removeVisitByUrlAndTime(url, timestamp) {
        return this.proxy.sendMessage(10, PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$, PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$, [
            url,
            timestamp
        ], false);
    }
    openVisitUrlsInTabGroup(visits, tabGroupName) {
        this.proxy.sendMessage(11, PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$, null, [
            visits,
            tabGroupName
        ], false);
    }
    recordVisitAction(visitAction, visitIndex, visitType) {
        this.proxy.sendMessage(12, PageHandler_RecordVisitAction_ParamsSpec.$, null, [
            visitAction,
            visitIndex,
            visitType
        ], false);
    }
    recordRelatedSearchAction(action, visitIndex) {
        this.proxy.sendMessage(13, PageHandler_RecordRelatedSearchAction_ParamsSpec.$, null, [
            action,
            visitIndex
        ], false);
    }
    recordClusterAction(clusterAction, clusterIndex) {
        this.proxy.sendMessage(14, PageHandler_RecordClusterAction_ParamsSpec.$, null, [
            clusterAction,
            clusterIndex
        ], false);
    }
    recordToggledVisibility(visible) {
        this.proxy.sendMessage(15, PageHandler_RecordToggledVisibility_ParamsSpec.$, null, [
            visible
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_OpenHistoryUrl_ParamsSpec.$, null, impl.openHistoryUrl.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_SetPage_ParamsSpec.$, null, impl.setPage.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$, null, impl.showContextMenuForSearchbox.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_ShowContextMenuForURL_ParamsSpec.$, null, impl.showContextMenuForURL.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_ShowSidePanelUI_ParamsSpec.$, null, impl.showSidePanelUI.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_ToggleVisibility_ParamsSpec.$, PageHandler_ToggleVisibility_ResponseParamsSpec.$, impl.toggleVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_StartQueryClusters_ParamsSpec.$, null, impl.startQueryClusters.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_LoadMoreClusters_ParamsSpec.$, null, impl.loadMoreClusters.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_HideVisits_ParamsSpec.$, PageHandler_HideVisits_ResponseParamsSpec.$, impl.hideVisits.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_RemoveVisits_ParamsSpec.$, PageHandler_RemoveVisits_ResponseParamsSpec.$, impl.removeVisits.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$, PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$, impl.removeVisitByUrlAndTime.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$, null, impl.openVisitUrlsInTabGroup.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_RecordVisitAction_ParamsSpec.$, null, impl.recordVisitAction.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_RecordRelatedSearchAction_ParamsSpec.$, null, impl.recordRelatedSearchAction.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_RecordClusterAction_ParamsSpec.$, null, impl.recordClusterAction.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_RecordToggledVisibility_ParamsSpec.$, null, impl.recordToggledVisibility.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "history_clusters.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    openHistoryUrl;
    setPage;
    showContextMenuForSearchbox;
    showContextMenuForURL;
    showSidePanelUI;
    toggleVisibility;
    startQueryClusters;
    loadMoreClusters;
    hideVisits;
    removeVisits;
    removeVisitByUrlAndTime;
    openVisitUrlsInTabGroup;
    recordVisitAction;
    recordRelatedSearchAction;
    recordClusterAction;
    recordToggledVisibility;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.openHistoryUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_OpenHistoryUrl_ParamsSpec.$, null, this.openHistoryUrl.createReceiverHandler(false /* expectsResponse */), false);
        this.setPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_SetPage_ParamsSpec.$, null, this.setPage.createReceiverHandler(false /* expectsResponse */), false);
        this.showContextMenuForSearchbox =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$, null, this.showContextMenuForSearchbox.createReceiverHandler(false /* expectsResponse */), false);
        this.showContextMenuForURL =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_ShowContextMenuForURL_ParamsSpec.$, null, this.showContextMenuForURL.createReceiverHandler(false /* expectsResponse */), false);
        this.showSidePanelUI =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_ShowSidePanelUI_ParamsSpec.$, null, this.showSidePanelUI.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_ToggleVisibility_ParamsSpec.$, PageHandler_ToggleVisibility_ResponseParamsSpec.$, this.toggleVisibility.createReceiverHandler(true /* expectsResponse */), false);
        this.startQueryClusters =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_StartQueryClusters_ParamsSpec.$, null, this.startQueryClusters.createReceiverHandler(false /* expectsResponse */), false);
        this.loadMoreClusters =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_LoadMoreClusters_ParamsSpec.$, null, this.loadMoreClusters.createReceiverHandler(false /* expectsResponse */), false);
        this.hideVisits =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_HideVisits_ParamsSpec.$, PageHandler_HideVisits_ResponseParamsSpec.$, this.hideVisits.createReceiverHandler(true /* expectsResponse */), false);
        this.removeVisits =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_RemoveVisits_ParamsSpec.$, PageHandler_RemoveVisits_ResponseParamsSpec.$, this.removeVisits.createReceiverHandler(true /* expectsResponse */), false);
        this.removeVisitByUrlAndTime =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$, PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$, this.removeVisitByUrlAndTime.createReceiverHandler(true /* expectsResponse */), false);
        this.openVisitUrlsInTabGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$, null, this.openVisitUrlsInTabGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.recordVisitAction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_RecordVisitAction_ParamsSpec.$, null, this.recordVisitAction.createReceiverHandler(false /* expectsResponse */), false);
        this.recordRelatedSearchAction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_RecordRelatedSearchAction_ParamsSpec.$, null, this.recordRelatedSearchAction.createReceiverHandler(false /* expectsResponse */), false);
        this.recordClusterAction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_RecordClusterAction_ParamsSpec.$, null, this.recordClusterAction.createReceiverHandler(false /* expectsResponse */), false);
        this.recordToggledVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_RecordToggledVisibility_ParamsSpec.$, null, this.recordToggledVisibility.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_clusters.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onClustersQueryResult(result) {
        this.proxy.sendMessage(0, Page_OnClustersQueryResult_ParamsSpec.$, null, [
            result
        ], false);
    }
    onClusterImageUpdated(clusterIndex, imageUrl) {
        this.proxy.sendMessage(1, Page_OnClusterImageUpdated_ParamsSpec.$, null, [
            clusterIndex,
            imageUrl
        ], false);
    }
    onVisitsHidden(hiddenVisits) {
        this.proxy.sendMessage(2, Page_OnVisitsHidden_ParamsSpec.$, null, [
            hiddenVisits
        ], false);
    }
    onVisitsRemoved(removedVisits) {
        this.proxy.sendMessage(3, Page_OnVisitsRemoved_ParamsSpec.$, null, [
            removedVisits
        ], false);
    }
    onHistoryDeleted() {
        this.proxy.sendMessage(4, Page_OnHistoryDeleted_ParamsSpec.$, null, [], false);
    }
    onQueryChangedByUser(query) {
        this.proxy.sendMessage(5, Page_OnQueryChangedByUser_ParamsSpec.$, null, [
            query
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnClustersQueryResult_ParamsSpec.$, null, impl.onClustersQueryResult.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_OnClusterImageUpdated_ParamsSpec.$, null, impl.onClusterImageUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_OnVisitsHidden_ParamsSpec.$, null, impl.onVisitsHidden.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_OnVisitsRemoved_ParamsSpec.$, null, impl.onVisitsRemoved.bind(impl), false);
        this.helper_internal_.registerHandler(4, Page_OnHistoryDeleted_ParamsSpec.$, null, impl.onHistoryDeleted.bind(impl), false);
        this.helper_internal_.registerHandler(5, Page_OnQueryChangedByUser_ParamsSpec.$, null, impl.onQueryChangedByUser.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "history_clusters.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onClustersQueryResult;
    onClusterImageUpdated;
    onVisitsHidden;
    onVisitsRemoved;
    onHistoryDeleted;
    onQueryChangedByUser;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onClustersQueryResult =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnClustersQueryResult_ParamsSpec.$, null, this.onClustersQueryResult.createReceiverHandler(false /* expectsResponse */), false);
        this.onClusterImageUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_OnClusterImageUpdated_ParamsSpec.$, null, this.onClusterImageUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onVisitsHidden =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_OnVisitsHidden_ParamsSpec.$, null, this.onVisitsHidden.createReceiverHandler(false /* expectsResponse */), false);
        this.onVisitsRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_OnVisitsRemoved_ParamsSpec.$, null, this.onVisitsRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onHistoryDeleted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Page_OnHistoryDeleted_ParamsSpec.$, null, this.onHistoryDeleted.createReceiverHandler(false /* expectsResponse */), false);
        this.onQueryChangedByUser =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Page_OnQueryChangedByUser_ParamsSpec.$, null, this.onQueryChangedByUser.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const QueryResultSpec = { $: {} };
export const PageHandler_OpenHistoryUrl_ParamsSpec = { $: {} };
export const PageHandler_SetPage_ParamsSpec = { $: {} };
export const PageHandler_ShowContextMenuForSearchbox_ParamsSpec = { $: {} };
export const PageHandler_ShowContextMenuForURL_ParamsSpec = { $: {} };
export const PageHandler_ShowSidePanelUI_ParamsSpec = { $: {} };
export const PageHandler_ToggleVisibility_ParamsSpec = { $: {} };
export const PageHandler_ToggleVisibility_ResponseParamsSpec = { $: {} };
export const PageHandler_StartQueryClusters_ParamsSpec = { $: {} };
export const PageHandler_LoadMoreClusters_ParamsSpec = { $: {} };
export const PageHandler_HideVisits_ParamsSpec = { $: {} };
export const PageHandler_HideVisits_ResponseParamsSpec = { $: {} };
export const PageHandler_RemoveVisits_ParamsSpec = { $: {} };
export const PageHandler_RemoveVisits_ResponseParamsSpec = { $: {} };
export const PageHandler_RemoveVisitByUrlAndTime_ParamsSpec = { $: {} };
export const PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec = { $: {} };
export const PageHandler_RecordVisitAction_ParamsSpec = { $: {} };
export const PageHandler_RecordRelatedSearchAction_ParamsSpec = { $: {} };
export const PageHandler_RecordClusterAction_ParamsSpec = { $: {} };
export const PageHandler_RecordToggledVisibility_ParamsSpec = { $: {} };
export const Page_OnClustersQueryResult_ParamsSpec = { $: {} };
export const Page_OnClusterImageUpdated_ParamsSpec = { $: {} };
export const Page_OnVisitsHidden_ParamsSpec = { $: {} };
export const Page_OnVisitsRemoved_ParamsSpec = { $: {} };
export const Page_OnHistoryDeleted_ParamsSpec = { $: {} };
export const Page_OnQueryChangedByUser_ParamsSpec = { $: {} };
mojo.internal.Struct(QueryResultSpec.$, 'QueryResult', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('clusters', 8, 0, mojo.internal.Array(historyClusters_mojom_ClusterSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canLoadMore', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isContinuation', 16, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_OpenHistoryUrl_ParamsSpec.$, 'PageHandler_OpenHistoryUrl_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('clickModifiers', 8, 0, ui_mojom_ClickModifiersSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$, 'PageHandler_SetPage_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$, 'PageHandler_ShowContextMenuForSearchbox_Params', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('point', 8, 0, gfx_mojom_PointSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ShowContextMenuForURL_ParamsSpec.$, 'PageHandler_ShowContextMenuForURL_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('point', 8, 0, gfx_mojom_PointSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ShowSidePanelUI_ParamsSpec.$, 'PageHandler_ShowSidePanelUI_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ToggleVisibility_ParamsSpec.$, 'PageHandler_ToggleVisibility_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ToggleVisibility_ResponseParamsSpec.$, 'PageHandler_ToggleVisibility_ResponseParams', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_StartQueryClusters_ParamsSpec.$, 'PageHandler_StartQueryClusters_Params', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('beginTime', 8, 0, mojoBase_mojom_TimeSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('recluster', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_LoadMoreClusters_ParamsSpec.$, 'PageHandler_LoadMoreClusters_Params', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_HideVisits_ParamsSpec.$, 'PageHandler_HideVisits_Params', [
    mojo.internal.StructField('visits', 0, 0, mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_HideVisits_ResponseParamsSpec.$, 'PageHandler_HideVisits_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RemoveVisits_ParamsSpec.$, 'PageHandler_RemoveVisits_Params', [
    mojo.internal.StructField('visits', 0, 0, mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RemoveVisits_ResponseParamsSpec.$, 'PageHandler_RemoveVisits_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$, 'PageHandler_RemoveVisitByUrlAndTime_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timestamp', 8, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$, 'PageHandler_RemoveVisitByUrlAndTime_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$, 'PageHandler_OpenVisitUrlsInTabGroup_Params', [
    mojo.internal.StructField('visits', 0, 0, mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabGroupName', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_RecordVisitAction_ParamsSpec.$, 'PageHandler_RecordVisitAction_Params', [
    mojo.internal.StructField('visitAction', 0, 0, VisitActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('visitIndex', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('visitType', 8, 0, VisitTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_RecordRelatedSearchAction_ParamsSpec.$, 'PageHandler_RecordRelatedSearchAction_Params', [
    mojo.internal.StructField('action', 0, 0, RelatedSearchActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('visitIndex', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RecordClusterAction_ParamsSpec.$, 'PageHandler_RecordClusterAction_Params', [
    mojo.internal.StructField('clusterAction', 0, 0, ClusterActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('clusterIndex', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RecordToggledVisibility_ParamsSpec.$, 'PageHandler_RecordToggledVisibility_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnClustersQueryResult_ParamsSpec.$, 'Page_OnClustersQueryResult_Params', [
    mojo.internal.StructField('result', 0, 0, QueryResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnClusterImageUpdated_ParamsSpec.$, 'Page_OnClusterImageUpdated_Params', [
    mojo.internal.StructField('clusterIndex', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageUrl', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_OnVisitsHidden_ParamsSpec.$, 'Page_OnVisitsHidden_Params', [
    mojo.internal.StructField('hiddenVisits', 0, 0, mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnVisitsRemoved_ParamsSpec.$, 'Page_OnVisitsRemoved_Params', [
    mojo.internal.StructField('removedVisits', 0, 0, mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnHistoryDeleted_ParamsSpec.$, 'Page_OnHistoryDeleted_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnQueryChangedByUser_ParamsSpec.$, 'Page_OnQueryChangedByUser_Params', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
