require=(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({"../audits/accessibility/aria-allowed-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAAllowedAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-allowed-attr',description:'Element aria-* attributes are allowed for this role',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAAllowedAttr;},{"./axe-audit":2}],"../audits/accessibility/aria-required-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIARequiredAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-attr',description:'Elements with ARIA roles have the required aria-* attributes',requiredArtifacts:['Accessibility']};}}
module.exports=ARIARequiredAttr;},{"./axe-audit":2}],"../audits/accessibility/aria-valid-attr-value":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-valid-attr-value',description:'Element aria-* attributes have valid values',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":2}],"../audits/accessibility/aria-valid-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-valid-attr',description:'Element aria-* attributes are valid and not misspelled or non-existent.',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":2}],"../audits/accessibility/color-contrast":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ColorContrast extends AxeAudit{static get meta(){return{category:'Accessibility',name:'color-contrast',description:'Background and foreground colors have a sufficient contrast ratio',requiredArtifacts:['Accessibility']};}}
module.exports=ColorContrast;},{"./axe-audit":2}],"../audits/accessibility/image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ImageAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'image-alt',description:'Every image element has an alt attribute',requiredArtifacts:['Accessibility']};}}
module.exports=ImageAlt;},{"./axe-audit":2}],"../audits/accessibility/label":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Label extends AxeAudit{static get meta(){return{category:'Accessibility',name:'label',description:'Every form element has a label',requiredArtifacts:['Accessibility']};}}
module.exports=Label;},{"./axe-audit":2}],"../audits/accessibility/tabindex":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TabIndex extends AxeAudit{static get meta(){return{category:'Accessibility',name:'tabindex',description:'No element has a `tabindex` attribute greater than 0',requiredArtifacts:['Accessibility']};}}
module.exports=TabIndex;},{"./axe-audit":2}],"../audits/cache-start-url":[function(require,module,exports){'use strict';const Audit=require('./audit');class CacheStartUrl extends Audit{static get meta(){return{category:'Manifest',name:'cache-start-url',description:'Cache contains start_url from manifest (alpha)',requiredArtifacts:['CacheContents','Manifest','URL']};}
static audit(artifacts){let cacheHasStartUrl=false;const manifest=artifacts.Manifest.value;const cacheContents=artifacts.CacheContents;if(!(manifest&&manifest.start_url&&manifest.start_url.value)){return CacheStartUrl.generateAuditResult({rawValue:false,debugString:'start_url not present in Manifest'});}
if(!Array.isArray(cacheContents)){return CacheStartUrl.generateAuditResult({rawValue:false,debugString:cacheContents.debugString||'No cache detected'});}
const startURL=manifest.start_url.value;const altStartURL=startURL.replace(/\?utm_([^=]*)=([^&]|$)*/,'').replace(/\?$/,'');cacheHasStartUrl=cacheContents.find(req=>{return(startURL===req||altStartURL===req);});return CacheStartUrl.generateAuditResult({rawValue:(cacheHasStartUrl!==undefined)});}}
module.exports=CacheStartUrl;},{"./audit":3}],"../audits/content-width":[function(require,module,exports){'use strict';const Audit=require('./audit');class ContentWidth extends Audit{static get meta(){return{category:'Mobile Friendly',name:'content-width',description:'Content is sized correctly for the viewport',helpText:'If the width of your app\'s content doesn\'t match the width '+'of the viewport, your app might not be optimized for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/content-sized-correctly-for-viewport).',requiredArtifacts:['ContentWidth']};}
static audit(artifacts){const scrollWidth=artifacts.ContentWidth.scrollWidth;const viewportWidth=artifacts.ContentWidth.viewportWidth;const widthsMatch=scrollWidth===viewportWidth&&scrollWidth!==-1;return ContentWidth.generateAuditResult({rawValue:widthsMatch,debugString:this.createDebugString(widthsMatch,artifacts.ContentWidth)});}
static createDebugString(match,artifact){if(match){return'';}
return'The content scroll size is '+artifact.scrollWidth+'px, '+'whereas the viewport size is '+artifact.viewportWidth+'px.';}}
module.exports=ContentWidth;},{"./audit":3}],"../audits/critical-request-chains":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../formatters/formatter');class CriticalRequestChains extends Audit{static get meta(){return{category:'Performance',name:'critical-request-chains',description:'Critical Request Chains',optimalValue:0,helpText:'The Critical Request Chains below show you what resources are '+'required for first render of this page. Improve page load by reducing '+'the length of chains, reducing the download size of resources, or '+'deferring the download of unnecessary resources. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains).',requiredArtifacts:['networkRecords']};}
static audit(artifacts){const networkRecords=artifacts.networkRecords[Audit.DEFAULT_PASS];return artifacts.requestCriticalRequestChains(networkRecords).then(chains=>{let chainCount=0;function walk(node,depth){const children=Object.keys(node);if(children.length===0){chainCount++;}
children.forEach(id=>{const child=node[id];walk(child.children,depth+1);},'');}
const initialNavigationKey=Object.keys(chains)[0];const initialNavChildren=chains[initialNavigationKey].children;if(initialNavChildren&&Object.keys(initialNavChildren).length>0){walk(initialNavChildren,0);}
return CriticalRequestChains.generateAuditResult({rawValue:chainCount<=this.meta.optimalValue,displayValue:chainCount,optimalValue:this.meta.optimalValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.CRITICAL_REQUEST_CHAINS,value:chains}});});}}
module.exports=CriticalRequestChains;},{"../formatters/formatter":8,"./audit":3}],"../audits/dobetterweb/appcache-manifest":[function(require,module,exports){'use strict';const Audit=require('../audit');class AppCacheManifestAttr extends Audit{static get meta(){return{category:'Offline',name:'appcache-manifest',description:'Site does not use Application Cache',helpText:'Application Cache has been [deprecated](https://html.spec.whatwg.org/multipage/browsers.html#offline) by [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/Using_Service_Workers). Consider implementing an offline solution using the [Cache Storage API](https://developer.mozilla.org/en-US/docs/Web/API/Cache).',requiredArtifacts:['AppCacheManifest']};}
static audit(artifacts){if(artifacts.AppCacheManifest===-1){return AppCacheManifestAttr.generateAuditResult({rawValue:false,debugString:'Unable to determine if you\'re using AppCache.'});}
const usingAppcache=artifacts.AppCacheManifest!==null;const displayValue=usingAppcache?`<html manifest="${artifacts.AppCacheManifest}">`:'';return AppCacheManifestAttr.generateAuditResult({rawValue:!usingAppcache,displayValue:displayValue});}}
module.exports=AppCacheManifestAttr;},{"../audit":3}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class ExternalAnchorsUseRelNoopenerAudit extends Audit{static get meta(){return{category:'Performance',name:'external-anchors-use-rel-noopener',description:'Site opens external anchors using rel="noopener"',helpText:'Open new tabs using `rel="noopener"` to improve performance and '+'prevent security vulnerabilities. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/noopener).',requiredArtifacts:['URL','AnchorsWithNoRelNoopener']};}
static audit(artifacts){if(artifacts.AnchorsWithNoRelNoopener===-1){return ExternalAnchorsUseRelNoopenerAudit.generateAuditResult({rawValue:-1,debugString:'Unknown error with the AnchorsWithNoRelNoopener gatherer.'});}
let debugString;const pageHost=new URL(artifacts.URL.finalUrl).host;const failingAnchors=artifacts.AnchorsWithNoRelNoopener.usages.filter(anchor=>{try{return anchor.href===''||new URL(anchor.href).host!==pageHost;}catch(err){debugString='Lighthouse was unable to determine the destination '+'of some anchor tags. If they are not used as hyperlinks, '+'consider removing the _blank target.';return true;}}).map(anchor=>{return{url:'<a'+
(anchor.href?` href="${anchor.href}"`:'')+
(anchor.target?` target="${anchor.target}"`:'')+
(anchor.rel?` rel="${anchor.rel}"`:'')+'>'};});return ExternalAnchorsUseRelNoopenerAudit.generateAuditResult({rawValue:failingAnchors.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:failingAnchors},debugString});}}
module.exports=ExternalAnchorsUseRelNoopenerAudit;},{"../../formatters/formatter":8,"../../lib/url-shim":30,"../audit":3}],"../audits/dobetterweb/geolocation-on-start":[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class GeolocationOnStart extends Audit{static get meta(){return{category:'UX',name:'geolocation-on-start',description:'Page does not automatically request geolocation on page load',helpText:'Users are mistrustful of or confused by sites that request their '+'location without context. Consider tying the request to user gestures instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/geolocation-on-load).',requiredArtifacts:['GeolocationOnStart']};}
static audit(artifacts){if(artifacts.GeolocationOnStart.value===-1){let debugString='Unknown error with the GeolocationOnStart gatherer';if(artifacts.GeolocationOnStart.debugString){debugString=artifacts.GeolocationOnStart.debugString;}
return GeolocationOnStart.generateAuditResult({rawValue:-1,debugString});}
const results=artifacts.GeolocationOnStart.usage.map(err=>{return Object.assign({label:`line: ${err.line}, col: ${err.col}`},err);});return GeolocationOnStart.generateAuditResult({rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results}});}}
module.exports=GeolocationOnStart;},{"../../formatters/formatter":8,"../audit":3}],"../audits/dobetterweb/link-blocking-first-paint":[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class LinkBlockingFirstPaintAudit extends Audit{static get meta(){return{category:'Performance',name:'link-blocking-first-paint',description:'Site does not use <link> that delay first paint',helpText:'Link elements are blocking the first paint of your page. Consider '+'inlining critical links and deferring non-critical ones. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['TagsBlockingFirstPaint']};}
static computeAuditResultForTags(artifacts,tagFilter){const artifact=artifacts.TagsBlockingFirstPaint;if(artifact.value===-1){return{rawValue:-1,debugString:artifact.debugString};}
let totalSpendTime=0;const results=artifact.items.filter(item=>item.tag.tagName===tagFilter).map(item=>{totalSpendTime+=item.spendTime;return{url:item.tag.url,label:`delayed first paint by ${item.spendTime}ms`};});let displayValue='';if(results.length>1){displayValue=`${results.length} resources delayed first paint by ${totalSpendTime}ms`;}else if(results.length===1){displayValue=`${results.length} resource delayed first paint by ${totalSpendTime}ms`;}
return{displayValue,rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results}};}
static audit(artifacts){const result=LinkBlockingFirstPaintAudit.computeAuditResultForTags(artifacts,'LINK');return LinkBlockingFirstPaintAudit.generateAuditResult(result);}}
module.exports=LinkBlockingFirstPaintAudit;},{"../../formatters/formatter":8,"../audit":3}],"../audits/dobetterweb/no-console-time":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class NoConsoleTimeAudit extends Audit{static get meta(){return{category:'JavaScript',name:'no-console-time',description:'Site does not use `console.time()` in its own scripts',helpText:'Consider using `performance.mark()` and `performance.measure()` '+'from the User Timing API instead. They provide high-precision timestamps, '+'independent of the system clock, and are integrated in the Chrome DevTools Timeline. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/console-time).',requiredArtifacts:['URL','ConsoleTimeUsage']};}
static audit(artifacts){if(artifacts.ConsoleTimeUsage.value===-1){let debugString='Unknown error with the ConsoleTimeUsage gatherer';if(artifacts.ConsoleTimeUsage.debugString){debugString=artifacts.ConsoleTimeUsage.debugString;}
return NoConsoleTimeAudit.generateAuditResult({rawValue:-1,debugString});}
let debugString;const results=artifacts.ConsoleTimeUsage.usage.filter(err=>{if(err.isEval){return!!err.url;}
if(URL.isValid(err.url)){return URL.hostsMatch(artifacts.URL.finalUrl,err.url);}
debugString=URL.INVALID_URL_DEBUG_STRING;return true;}).map(err=>{return Object.assign({label:`line: ${err.line}, col: ${err.col}`},err);});return NoConsoleTimeAudit.generateAuditResult({rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results},debugString});}}
module.exports=NoConsoleTimeAudit;},{"../../formatters/formatter":8,"../../lib/url-shim":30,"../audit":3}],"../audits/dobetterweb/no-datenow":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class NoDateNowAudit extends Audit{static get meta(){return{category:'JavaScript',name:'no-datenow',description:'Site does not use `Date.now()` in its own scripts',helpText:'Consider using `performance.now()` from the User Timing API '+'instead. It provides high-precision timestamps, independent of the system '+'clock. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/date-now).',requiredArtifacts:['URL','DateNowUse']};}
static audit(artifacts){if(artifacts.DateNowUse.value===-1){let debugString='Unknown error with the DateNowUse gatherer';if(artifacts.DateNowUse.debugString){debugString=artifacts.DateNowUse.debugString;}
return NoDateNowAudit.generateAuditResult({rawValue:-1,debugString});}
let debugString;const results=artifacts.DateNowUse.usage.filter(err=>{if(err.isEval){return!!err.url;}
if(URL.isValid(err.url)){return URL.hostsMatch(artifacts.URL.finalUrl,err.url);}
debugString=URL.INVALID_URL_DEBUG_STRING;return true;}).map(err=>{return Object.assign({label:`line: ${err.line}, col: ${err.col}`,url:err.url},err);});return NoDateNowAudit.generateAuditResult({rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results},debugString});}}
module.exports=NoDateNowAudit;},{"../../formatters/formatter":8,"../../lib/url-shim":30,"../audit":3}],"../audits/dobetterweb/no-document-write":[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class NoDocWriteAudit extends Audit{static get meta(){return{category:'Performance',name:'no-document-write',description:'Site does not use document.write()',helpText:'For users on slow connections, external scripts dynamically injected via '+'`document.write()` can delay page load by tens of seconds. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/document-write).',requiredArtifacts:['DocWriteUse']};}
static audit(artifacts){if(artifacts.DocWriteUse.value===-1){let debugString='Unknown error with the DocWriteUse gatherer';if(artifacts.DocWriteUse.debugString){debugString=artifacts.DocWriteUse.debugString;}
return NoDocWriteAudit.generateAuditResult({rawValue:-1,debugString});}
const results=artifacts.DocWriteUse.usage.map(err=>{return Object.assign({label:`line: ${err.line}, col: ${err.col}`},err);});return NoDocWriteAudit.generateAuditResult({rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results}});}}
module.exports=NoDocWriteAudit;},{"../../formatters/formatter":8,"../audit":3}],"../audits/dobetterweb/no-mutation-events":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const EventHelpers=require('../../lib/event-helpers');const Formatter=require('../../formatters/formatter');class NoMutationEventsAudit extends Audit{static get MUTATION_EVENTS(){return['DOMAttrModified','DOMAttributeNameChanged','DOMCharacterDataModified','DOMElementNameChanged','DOMNodeInserted','DOMNodeInsertedIntoDocument','DOMNodeRemoved','DOMNodeRemovedFromDocument','DOMSubtreeModified'];}
static get meta(){return{category:'JavaScript',name:'no-mutation-events',description:'Site does not use Mutation Events in its own scripts',helpText:'Mutation Events are deprecated and harm performance. Consider using Mutation '+'Observers instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/mutation-events).',requiredArtifacts:['URL','EventListeners']};}
static audit(artifacts){if(artifacts.EventListeners.rawValue===-1){return NoMutationEventsAudit.generateAuditResult(artifacts.EventListeners);}
let debugString;const listeners=artifacts.EventListeners;const results=listeners.filter(loc=>{const isMutationEvent=this.MUTATION_EVENTS.indexOf(loc.type)!==-1;let sameHost=URL.hostsMatch(artifacts.URL.finalUrl,loc.url);if(!URL.isValid(loc.url)){sameHost=true;debugString=URL.INVALID_URL_DEBUG_STRING;}
return sameHost&&isMutationEvent;}).map(EventHelpers.addFormattedCodeSnippet);const groupedResults=EventHelpers.groupCodeSnippetsByLocation(results);return NoMutationEventsAudit.generateAuditResult({rawValue:groupedResults.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:groupedResults},debugString});}}
module.exports=NoMutationEventsAudit;},{"../../formatters/formatter":8,"../../lib/event-helpers":22,"../../lib/url-shim":30,"../audit":3}],"../audits/dobetterweb/no-old-flexbox":[function(require,module,exports){'use strict';const Audit=require('../audit');const StyleHelpers=require('../../lib/styles-helpers');const Formatter=require('../../formatters/formatter');class NoOldFlexboxAudit extends Audit{static get meta(){return{category:'CSS',name:'no-old-flexbox',description:'Site does not use the old CSS flexbox',helpText:'The 2009 spec of Flexbox is deprecated and is 2.3x slower than the latest '+'spec. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/old-flexbox).',requiredArtifacts:['Styles']};}
static audit(artifacts){if(artifacts.Styles.rawValue===-1){return NoOldFlexboxAudit.generateAuditResult(artifacts.Styles);}
const propsNames=['box-flex','box-orient','box-flex-group','display'];const propsNamesWithPrefixes=StyleHelpers.addVendorPrefixes(propsNames);const propsValues=['box','flexbox'];const sheetsUsingDisplayBox=StyleHelpers.filterStylesheetsByUsage(artifacts.Styles,propsNamesWithPrefixes,propsValues);const urlList=[];sheetsUsingDisplayBox.forEach(sheet=>{sheet.parsedContent.forEach(props=>{const formattedStyleRule=StyleHelpers.getFormattedStyleRule(sheet.content,props);urlList.push({url:sheet.header.sourceURL,label:formattedStyleRule.location,code:formattedStyleRule.styleRule});});});return NoOldFlexboxAudit.generateAuditResult({rawValue:sheetsUsingDisplayBox.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:urlList}});}}
module.exports=NoOldFlexboxAudit;},{"../../formatters/formatter":8,"../../lib/styles-helpers":27,"../audit":3}],"../audits/dobetterweb/no-websql":[function(require,module,exports){'use strict';const Audit=require('../audit');class NoWebSQLAudit extends Audit{static get meta(){return{category:'Offline',name:'no-websql',description:'Site does not use WebSQL DB.',helpText:'Web SQL is deprecated. Consider using IndexedDB instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/web-sql).',requiredArtifacts:['WebSQL']};}
static audit(artifacts){if(artifacts.WebSQL.database===-1){return NoWebSQLAudit.generateAuditResult({rawValue:-1,debugString:artifacts.WebSQL.debugString});}
const db=artifacts.WebSQL.database;const displayValue=(db&&db.database?`db name: ${db.database.name}, version: ${db.database.version}`:'');return NoWebSQLAudit.generateAuditResult({rawValue:!db,displayValue:displayValue});}}
module.exports=NoWebSQLAudit;},{"../audit":3}],"../audits/dobetterweb/notification-on-start":[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class NotificationOnStart extends Audit{static get meta(){return{category:'UX',name:'notification-on-start',description:'Page does not automatically request notification permissions on page load',helpText:'Users are mistrustful of or confused by sites that request to send '+'notifications without context. Consider tying the request to user gestures '+'instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/notifications-on-load).',requiredArtifacts:['NotificationOnStart']};}
static audit(artifacts){if(artifacts.NotificationOnStart.value===-1){let debugString='Unknown error with the NotificationOnStart gatherer';if(artifacts.NotificationOnStart.debugString){debugString=artifacts.NotificationOnStart.debugString;}
return NotificationOnStart.generateAuditResult({rawValue:-1,debugString});}
const results=artifacts.NotificationOnStart.usage.map(err=>{return Object.assign({label:`line: ${err.line}, col: ${err.col}`},err);});return NotificationOnStart.generateAuditResult({rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results}});}}
module.exports=NotificationOnStart;},{"../../formatters/formatter":8,"../audit":3}],"../audits/dobetterweb/script-blocking-first-paint":[function(require,module,exports){'use strict';const Audit=require('../audit');const LinkBlockingFirstPaintAudit=require('./link-blocking-first-paint');class ScriptBlockingFirstPaint extends Audit{static get meta(){return{category:'Performance',name:'script-blocking-first-paint',description:'Site does not use <script> in head that delays first paint',helpText:'Script elements are blocking the first paint of your page. Consider inlining '+'critical scripts and deferring non-critical ones. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['TagsBlockingFirstPaint']};}
static audit(artifacts){const result=LinkBlockingFirstPaintAudit.computeAuditResultForTags(artifacts,'SCRIPT');return ScriptBlockingFirstPaint.generateAuditResult(result);}}
module.exports=ScriptBlockingFirstPaint;},{"../audit":3,"./link-blocking-first-paint":"../audits/dobetterweb/link-blocking-first-paint"}],"../audits/dobetterweb/uses-http2":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class UsesHTTP2Audit extends Audit{static get meta(){return{category:'Performance',name:'uses-http2',description:'Site uses HTTP/2 for its own resources',helpText:'HTTP/2 offers many benefits over HTTP/1.1, including binary headers, '+'multiplexing, and server push. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http2).',requiredArtifacts:['URL','networkRecords']};}
static audit(artifacts){const networkRecords=artifacts.networkRecords[Audit.DEFAULT_PASS];const finalHost=new URL(artifacts.URL.finalUrl).host;const resources=networkRecords.filter(record=>{const requestHost=new URL(record._url).host;const sameHost=requestHost===finalHost;const notH2=/HTTP\/[01][\.\d]?/i.test(record.protocol);return sameHost&&notH2;}).map(record=>{return{label:record.protocol,url:record.url};});let displayValue='';if(resources.length>1){displayValue=`${resources.length} requests were not handled over h2`;}else if(resources.length===1){displayValue=`${resources.length} request was not handled over h2`;}
return UsesHTTP2Audit.generateAuditResult({rawValue:resources.length===0,displayValue:displayValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:resources}});}}
module.exports=UsesHTTP2Audit;},{"../../formatters/formatter":8,"../../lib/url-shim":30,"../audit":3}],"../audits/dobetterweb/uses-passive-event-listeners":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const EventHelpers=require('../../lib/event-helpers');const Formatter=require('../../formatters/formatter');class PassiveEventsAudit extends Audit{static get SCROLL_BLOCKING_EVENTS(){return['wheel','mousewheel','touchstart','touchmove'];}
static get meta(){return{category:'JavaScript',name:'uses-passive-event-listeners',description:'Site uses passive listeners to improve scrolling performance',helpText:'Consider marking your touch and wheel event listeners as `passive` '+'to improve your page\'s scroll performance. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/passive-event-listeners).',requiredArtifacts:['URL','EventListeners']};}
static audit(artifacts){if(artifacts.EventListeners.rawValue===-1){return PassiveEventsAudit.generateAuditResult(artifacts.EventListeners);}
let debugString;const listeners=artifacts.EventListeners;const results=listeners.filter(loc=>{const isScrollBlocking=this.SCROLL_BLOCKING_EVENTS.indexOf(loc.type)!==-1;const mentionsPreventDefault=loc.handler.description.match(/\.preventDefault\(\s*\)/g);let sameHost=URL.hostsMatch(artifacts.URL.finalUrl,loc.url);if(!URL.isValid(loc.url)){sameHost=true;debugString=URL.INVALID_URL_DEBUG_STRING;}
return sameHost&&isScrollBlocking&&!loc.passive&&!mentionsPreventDefault;}).map(EventHelpers.addFormattedCodeSnippet);const groupedResults=EventHelpers.groupCodeSnippetsByLocation(results);return PassiveEventsAudit.generateAuditResult({rawValue:groupedResults.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:groupedResults},debugString});}}
module.exports=PassiveEventsAudit;},{"../../formatters/formatter":8,"../../lib/event-helpers":22,"../../lib/url-shim":30,"../audit":3}],"../audits/estimated-input-latency":[function(require,module,exports){'use strict';const Audit=require('./audit');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../formatters/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=50;const SCORING_MEDIAN=100;class EstimatedInputLatency extends Audit{static get meta(){return{category:'Performance',name:'estimated-input-latency',description:'Estimated Input Latency',optimalValue:SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString()+'ms',helpText:'The score above is an estimate of how long your app takes to respond to user '+'input, in milliseconds. There is a 90% probability that a user encounters this amount '+'of latency, or less. 10% of the time a user can expect additional latency. If your '+'score is higher than Lighthouse\'s target score, users may perceive your app as '+'laggy. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency).',requiredArtifacts:['traces']};}
static calculate(speedline,trace){const startTime=speedline.first;const tracingProcessor=new TracingProcessor();const model=tracingProcessor.init(trace);const latencyPercentiles=TracingProcessor.getRiskToResponsiveness(model,trace,startTime);const ninetieth=latencyPercentiles.find(result=>result.percentile===0.9);const rawValue=parseFloat(ninetieth.time.toFixed(1));const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);const score=100*distribution.computeComplementaryPercentile(ninetieth.time);return EstimatedInputLatency.generateAuditResult({score:Math.round(score),optimalValue:this.meta.optimalValue,rawValue,displayValue:`${rawValue}ms`,extendedInfo:{value:latencyPercentiles,formatter:Formatter.SUPPORTED_FORMATS.NULL}});}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestSpeedline(trace).then(speedline=>EstimatedInputLatency.calculate(speedline,trace)).catch(err=>{return EstimatedInputLatency.generateAuditResult({rawValue:-1,debugString:'Speedline unable to parse trace contents: '+err.message});});}}
module.exports=EstimatedInputLatency;},{"../formatters/formatter":8,"../lib/traces/tracing-processor":29,"./audit":3}],"../audits/first-meaningful-paint":[function(require,module,exports){'use strict';const Audit=require('./audit');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../formatters/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1600;const SCORING_MEDIAN=4000;const FCPFMP_TOLERANCE=32*1000;class FirstMeaningfulPaint extends Audit{static get meta(){return{category:'Performance',name:'first-meaningful-paint',description:'First meaningful paint',optimalValue:SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString()+'ms',helpText:'First meaningful paint measures when the primary content of a page is visible. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint).',requiredArtifacts:['traces']};}
static audit(artifacts){return new Promise((resolve,reject)=>{const traceContents=artifacts.traces[this.DEFAULT_PASS].traceEvents;const evts=this.collectEvents(traceContents);const result=this.calculateScore(evts);resolve(FirstMeaningfulPaint.generateAuditResult({score:result.score,rawValue:parseFloat(result.duration),displayValue:`${result.duration}ms`,debugString:result.debugString,optimalValue:this.meta.optimalValue,extendedInfo:{value:result.extendedInfo,formatter:Formatter.SUPPORTED_FORMATS.NULL}}));}).catch(err=>{return FirstMeaningfulPaint.generateAuditResult({rawValue:-1,debugString:err.message});});}
static calculateScore(evts){const firstMeaningfulPaint=(evts.firstMeaningfulPaint.ts-evts.navigationStart.ts)/1000;const firstContentfulPaint=(evts.firstContentfulPaint.ts-evts.navigationStart.ts)/1000;const extendedInfo={timestamps:{navStart:evts.navigationStart.ts,fCP:evts.firstContentfulPaint.ts,fMP:evts.firstMeaningfulPaint.ts},timings:{navStart:0,fCP:parseFloat(firstContentfulPaint.toFixed(3)),fMP:parseFloat(firstMeaningfulPaint.toFixed(3))}};const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(firstMeaningfulPaint);score=Math.min(100,score);score=Math.max(0,score);return{duration:`${firstMeaningfulPaint.toFixed(1)}`,score:Math.round(score),rawValue:parseFloat(firstMeaningfulPaint.toFixed(1)),extendedInfo};}
static collectEvents(traceData){const events=traceData.filter(e=>{return e.cat.includes('blink.user_timing')||e.name==='TracingStartedInPage';}).sort((event0,event1)=>event0.ts-event1.ts);const startedInPageEvt=events.find(e=>e.name==='TracingStartedInPage');const frameEvents=events.filter(e=>e.args.frame===startedInPageEvt.args.data.page);const firstFCP=frameEvents.find(e=>e.name==='firstContentfulPaint');const navigationStart=frameEvents.filter(e=>e.name==='navigationStart'&&e.ts<firstFCP.ts).pop();const firstMeaningfulPaint=frameEvents.find(e=>e.name==='firstMeaningfulPaint'&&e.ts>=(firstFCP.ts-FCPFMP_TOLERANCE));if(!firstMeaningfulPaint){throw new Error('No usable `firstMeaningfulPaint` event found in trace');}
if(!navigationStart){throw new Error('No `navigationStart` event found in trace');}
return{navigationStart,firstMeaningfulPaint,firstContentfulPaint:firstFCP};}}
module.exports=FirstMeaningfulPaint;},{"../formatters/formatter":8,"../lib/traces/tracing-processor":29,"./audit":3}],"../audits/is-on-https":[function(require,module,exports){'use strict';const Audit=require('./audit');class HTTPS extends Audit{static get meta(){return{category:'Security',name:'is-on-https',description:'Site is on HTTPS',helpText:'All sites should be protected with HTTPS, even ones that don\'t handle '+'sensitive data. HTTPS prevents intruders from tampering with or passively listening '+'in on the communications between your app and your users, and is a prerequisite for '+'HTTP/2 and many new web platform APIs. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/https).',requiredArtifacts:['HTTPS']};}
static audit(artifacts){return HTTPS.generateAuditResult({rawValue:artifacts.HTTPS.value,debugString:artifacts.HTTPS.debugString});}}
module.exports=HTTPS;},{"./audit":3}],"../audits/manifest-background-color":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../formatters/formatter');class ManifestBackgroundColor extends Audit{static get meta(){return{category:'Manifest',name:'manifest-background-color',description:'Manifest contains `background_color`',requiredArtifacts:['Manifest']};}
static getBackgroundColorValue(manifest){return manifest!==undefined&&manifest.background_color.value;}
static audit(artifacts){const bgColor=ManifestBackgroundColor.getBackgroundColorValue(artifacts.Manifest.value);return ManifestBackgroundColor.generateAuditResult({rawValue:!!bgColor,extendedInfo:{value:bgColor,formatter:Formatter.SUPPORTED_FORMATS.NULL}});}}
module.exports=ManifestBackgroundColor;},{"../formatters/formatter":8,"./audit":3}],"../audits/manifest-display":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestDisplay extends Audit{static get meta(){return{category:'Manifest',name:'manifest-display',description:'Manifest\'s `display` property is set',requiredArtifacts:['Manifest']};}
static hasRecommendedValue(val){return['browser','fullscreen','minimal-ui','standalone'].indexOf(val)!==-1;}
static audit(artifacts){const manifest=artifacts.Manifest.value;const displayValue=manifest&&manifest.display.value;const hasRecommendedValue=ManifestDisplay.hasRecommendedValue(displayValue);const auditResult={rawValue:hasRecommendedValue,displayValue};if(!hasRecommendedValue){auditResult.debugString='Manifest display property should be set.';}
return ManifestDisplay.generateAuditResult(auditResult);}}
module.exports=ManifestDisplay;},{"./audit":3}],"../audits/manifest-exists":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestExists extends Audit{static get meta(){return{category:'Manifest',name:'manifest-exists',description:'Manifest exists',requiredArtifacts:['Manifest']};}
static audit(artifacts){return ManifestExists.generateAuditResult({rawValue:typeof artifacts.Manifest.value!=='undefined',debugString:artifacts.Manifest.debugString});}}
module.exports=ManifestExists;},{"./audit":3}],"../audits/manifest-icons-min-144":[function(require,module,exports){'use strict';const Audit=require('./audit');const icons=require('../lib/icons');class ManifestIconsMin144 extends Audit{static get meta(){return{category:'Manifest',name:'manifest-icons-min-144',description:'Manifest contains icons at least 144px',requiredArtifacts:['Manifest']};}
static audit(artifacts){const manifest=artifacts.Manifest.value;if(icons.doExist(manifest)===false){return ManifestIconsMin144.generateAuditResult({rawValue:false,debugString:'WARNING: No icons found in the manifest'});}
const matchingIcons=icons.sizeAtLeast(144,(manifest));let displayValue;let debugString;if(matchingIcons.length){displayValue=`found sizes: ${matchingIcons.join(', ')}`;}else{debugString='WARNING: No icons are at least 144px';}
return ManifestIconsMin144.generateAuditResult({rawValue:!!matchingIcons.length,displayValue,debugString});}}
module.exports=ManifestIconsMin144;},{"../lib/icons":23,"./audit":3}],"../audits/manifest-icons-min-192":[function(require,module,exports){'use strict';const Audit=require('./audit');const icons=require('../lib/icons');class ManifestIconsMin192 extends Audit{static get meta(){return{category:'Manifest',name:'manifest-icons-min-192',description:'Manifest contains icons at least 192px',requiredArtifacts:['Manifest']};}
static audit(artifacts){const manifest=artifacts.Manifest.value;if(icons.doExist(manifest)===false){return ManifestIconsMin192.generateAuditResult({rawValue:false,debugString:'WARNING: No icons found in the manifest'});}
const matchingIcons=icons.sizeAtLeast(192,(manifest));let displayValue;let debugString;if(matchingIcons.length){displayValue=`found sizes: ${matchingIcons.join(', ')}`;}else{debugString='WARNING: No icons are at least 192px';}
return ManifestIconsMin192.generateAuditResult({rawValue:!!matchingIcons.length,displayValue,debugString});}}
module.exports=ManifestIconsMin192;},{"../lib/icons":23,"./audit":3}],"../audits/manifest-name":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestName extends Audit{static get meta(){return{category:'Manifest',name:'manifest-name',description:'Manifest contains `name`',requiredArtifacts:['Manifest']};}
static audit(artifacts){let hasName=false;const manifest=artifacts.Manifest.value;if(manifest&&manifest.name){hasName=(!!manifest.name.value);}
return ManifestName.generateAuditResult({rawValue:hasName});}}
module.exports=ManifestName;},{"./audit":3}],"../audits/manifest-short-name-length":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestShortNameLength extends Audit{static get meta(){return{category:'Manifest',name:'manifest-short-name-length',description:'Manifest\'s `short_name` won\'t be truncated when displayed on homescreen',requiredArtifacts:['Manifest']};}
static audit(artifacts){let isShortNameShortEnough=false;let debugString;const manifest=artifacts.Manifest.value;const suggestedLength=12;if(manifest){const manifestValue=manifest.short_name.value||manifest.name.value||'';isShortNameShortEnough=manifestValue&&manifestValue.length<=suggestedLength;if(!isShortNameShortEnough){debugString=`${suggestedLength} chars is the suggested maximum homescreen label length`;debugString+=` (Found: ${manifestValue.length} chars).`;}}
return ManifestShortNameLength.generateAuditResult({rawValue:isShortNameShortEnough,debugString});}}
module.exports=ManifestShortNameLength;},{"./audit":3}],"../audits/manifest-short-name":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestShortName extends Audit{static get meta(){return{category:'Manifest',name:'manifest-short-name',description:'Manifest contains `short_name`',requiredArtifacts:['Manifest']};}
static audit(artifacts){let hasShortName=false;const manifest=artifacts.Manifest.value;if(manifest){hasShortName=!!(manifest.short_name.value||manifest.name.value);}
return ManifestShortName.generateAuditResult({rawValue:hasShortName});}}
module.exports=ManifestShortName;},{"./audit":3}],"../audits/manifest-start-url":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestStartUrl extends Audit{static get meta(){return{category:'Manifest',name:'manifest-start-url',description:'Manifest contains `start_url`',requiredArtifacts:['Manifest']};}
static audit(artifacts){let hasStartUrl=false;const manifest=artifacts.Manifest.value;if(manifest&&manifest.start_url){hasStartUrl=(!!manifest.start_url.value);}
return ManifestStartUrl.generateAuditResult({rawValue:hasStartUrl});}}
module.exports=ManifestStartUrl;},{"./audit":3}],"../audits/manifest-theme-color":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestThemeColor extends Audit{static get meta(){return{category:'Manifest',name:'manifest-theme-color',description:'Manifest contains `theme_color`',requiredArtifacts:['Manifest']};}
static audit(artifacts){let hasThemeColor=false;const manifest=artifacts.Manifest.value;if(manifest&&manifest.theme_color){hasThemeColor=(!!manifest.theme_color.value);}
return ManifestThemeColor.generateAuditResult({rawValue:hasThemeColor});}}
module.exports=ManifestThemeColor;},{"./audit":3}],"../audits/redirects-http":[function(require,module,exports){'use strict';const Audit=require('./audit');class RedirectsHTTP extends Audit{static get meta(){return{category:'Security',name:'redirects-http',description:'Site redirects HTTP traffic to HTTPS',helpText:'If you\'ve already set up HTTPS, make sure that you redirect all HTTP traffic '+'to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-redirects-to-https).',requiredArtifacts:['HTTPRedirect']};}
static audit(artifacts){return RedirectsHTTP.generateAuditResult({rawValue:artifacts.HTTPRedirect.value,debugString:artifacts.HTTPRedirect.debugString});}}
module.exports=RedirectsHTTP;},{"./audit":3}],"../audits/screenshots":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../formatters/formatter');class Screenshots extends Audit{static get meta(){return{category:'Performance',name:'screenshots',description:'Screenshots of all captured frames',requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestScreenshots(trace).then(screenshots=>{if(typeof screenshots==='undefined'){return Screenshots.generateAuditResult({rawValue:-1,debugString:'No screenshot artifact'});}
return Screenshots.generateAuditResult({rawValue:screenshots.length||0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.NULL,value:screenshots}});});}}
module.exports=Screenshots;},{"../formatters/formatter":8,"./audit":3}],"../audits/service-worker":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');function getActivatedServiceWorker(versions,url){const origin=new URL(url).origin;return versions.find(v=>v.status==='activated'&&new URL(v.scriptURL).origin===origin);}
class ServiceWorker extends Audit{static get meta(){return{category:'Offline',name:'service-worker',description:'Has a registered Service Worker',helpText:'The service worker is the technology that enables your app to use many '+'Progressive Web App features, such as offline, add to homescreen, and push '+'notifications. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/registered-service-worker).',requiredArtifacts:['URL','ServiceWorker']};}
static audit(artifacts){if(!artifacts.ServiceWorker.versions){return ServiceWorker.generateAuditResult({rawValue:false,debugString:artifacts.ServiceWorker.debugString});}
const version=getActivatedServiceWorker(artifacts.ServiceWorker.versions,artifacts.URL.finalUrl);const debugString=version?undefined:'No active service worker found for this origin.';return ServiceWorker.generateAuditResult({rawValue:!!version,debugString:debugString});}}
module.exports=ServiceWorker;},{"../lib/url-shim":30,"./audit":3}],"../audits/speed-index-metric":[function(require,module,exports){'use strict';const Audit=require('./audit');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../formatters/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1250;const SCORING_MEDIAN=5500;class SpeedIndexMetric extends Audit{static get meta(){return{category:'Performance',name:'speed-index-metric',description:'Perceptual Speed Index',helpText:'Speed Index shows how quickly the contents of a page are visibly populated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index).',optimalValue:SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString(),requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestSpeedline(trace).then(speedline=>{if(speedline.frames.length===0){return SpeedIndexMetric.generateAuditResult({rawValue:-1,debugString:'Trace unable to find visual progress frames.'});}
if(speedline.speedIndex===0){return SpeedIndexMetric.generateAuditResult({rawValue:-1,debugString:'Error in Speedline calculating Speed Index (speedIndex of 0).'});}
const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(speedline.perceptualSpeedIndex);score=Math.min(100,score);score=Math.max(0,score);const extendedInfo={timings:{firstVisualChange:speedline.first,visuallyComplete:speedline.complete,speedIndex:speedline.speedIndex,perceptualSpeedIndex:speedline.perceptualSpeedIndex},timestamps:{firstVisualChange:(speedline.first+speedline.beginning)*1000,visuallyComplete:(speedline.complete+speedline.beginning)*1000,speedIndex:(speedline.speedIndex+speedline.beginning)*1000,perceptualSpeedIndex:(speedline.perceptualSpeedIndex+speedline.beginning)*1000},frames:speedline.frames.map(frame=>{return{timestamp:frame.getTimeStamp(),progress:frame.getPerceptualProgress()};})};return SpeedIndexMetric.generateAuditResult({score:Math.round(score),rawValue:Math.round(speedline.perceptualSpeedIndex),optimalValue:this.meta.optimalValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.SPEEDLINE,value:extendedInfo}});}).catch(err=>{return SpeedIndexMetric.generateAuditResult({rawValue:-1,debugString:err.message});});}}
module.exports=SpeedIndexMetric;},{"../formatters/formatter":8,"../lib/traces/tracing-processor":29,"./audit":3}],"../audits/theme-color-meta":[function(require,module,exports){'use strict';const validColor=require('../lib/web-inspector').Color.parse;const Audit=require('./audit');class ThemeColor extends Audit{static get meta(){return{category:'HTML',name:'theme-color-meta',description:'HTML has a `<meta name="theme-color">` tag',requiredArtifacts:['ThemeColor']};}
static audit(artifacts){const themeColorMeta=artifacts.ThemeColor;if(themeColorMeta===null||themeColorMeta===-1){return ThemeColor.generateAuditResult({rawValue:false,debugString:'No valid theme-color meta tag found.'});}
if(!validColor(themeColorMeta)){return ThemeColor.generateAuditResult({displayValue:themeColorMeta,rawValue:false,debugString:'The theme-color meta tag did not contain a valid CSS color.'});}
return ThemeColor.generateAuditResult({displayValue:themeColorMeta,rawValue:true});}}
module.exports=ThemeColor;},{"../lib/web-inspector":31,"./audit":3}],"../audits/time-to-interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const TracingProcessor=require('../lib/traces/tracing-processor');const FMPMetric=require('./first-meaningful-paint');const Formatter=require('../formatters/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=5000;const SCORING_TARGET=5000;class TTIMetric extends Audit{static get meta(){return{category:'Performance',name:'time-to-interactive',description:'Time To Interactive (alpha)',helpText:'Time to Interactive identifies the time at which your app appears to be ready '+'enough to interact with. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/time-to-interactive).',optimalValue:SCORING_TARGET.toLocaleString()+'ms',requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const pendingSpeedline=artifacts.requestSpeedline(trace);const pendingFMP=FMPMetric.audit(artifacts);return Promise.all([pendingSpeedline,pendingFMP]).then(results=>{const speedline=results[0];const fmpResult=results[1];if(fmpResult.rawValue===-1){return generateError(fmpResult.debugString);}
const tracingProcessor=new TracingProcessor();const trace=artifacts.traces[Audit.DEFAULT_PASS];const model=tracingProcessor.init(trace);const endOfTraceTime=model.bounds.max;const fmpTiming=fmpResult.rawValue;const fmpResultExt=fmpResult.extendedInfo.value;const fMPtsInMS=fmpResultExt.timestamps.fMP/1000;const navStartTsInMS=fmpResultExt.timestamps.navStart/1000;let visuallyReadyTiming=0;if(speedline.frames){const eightyFivePctVC=speedline.frames.find(frame=>{return frame.getTimeStamp()>=fMPtsInMS&&frame.getProgress()>=85;});if(eightyFivePctVC){visuallyReadyTiming=eightyFivePctVC.getTimeStamp()-navStartTsInMS;}}
let startTime=Math.max(fmpTiming,visuallyReadyTiming)-50;let endTime;let currentLatency=Infinity;const percentiles=[0.9];const threshold=50;const foundLatencies=[];while(currentLatency>threshold){startTime+=50;endTime=startTime+500;if(endTime>endOfTraceTime){return generateError('Entire trace was found to be busy.');}
const latencies=TracingProcessor.getRiskToResponsiveness(model,trace,startTime,endTime,percentiles);const estLatency=latencies[0].time;foundLatencies.push({estLatency:estLatency,startTime:startTime.toFixed(1)});currentLatency=estLatency;}
const timeToInteractive=startTime;const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(startTime);score=Math.min(100,score);score=Math.max(0,score);score=Math.round(score);const extendedInfo={timings:{fMP:parseFloat(fmpTiming.toFixed(3)),visuallyReady:parseFloat(visuallyReadyTiming.toFixed(3)),timeToInteractive:parseFloat(startTime.toFixed(3))},timestamps:{fMP:fMPtsInMS*1000,visuallyReady:(visuallyReadyTiming+navStartTsInMS)*1000,timeToInteractive:(timeToInteractive+navStartTsInMS)*1000},expectedLatencyAtTTI:parseFloat(currentLatency.toFixed(3)),foundLatencies};return TTIMetric.generateAuditResult({score,rawValue:parseFloat(timeToInteractive.toFixed(1)),displayValue:`${parseFloat(timeToInteractive.toFixed(1))}ms`,optimalValue:this.meta.optimalValue,debugString:speedline.debugString,extendedInfo:{value:extendedInfo,formatter:Formatter.SUPPORTED_FORMATS.NULL}});}).catch(err=>{return generateError(err);});}}
module.exports=TTIMetric;function generateError(err){return TTIMetric.generateAuditResult({value:-1,rawValue:-1,optimalValue:TTIMetric.meta.optimalValue,debugString:err.message||err});}},{"../formatters/formatter":8,"../lib/traces/tracing-processor":29,"./audit":3,"./first-meaningful-paint":"../audits/first-meaningful-paint"}],"../audits/unused-css-rules":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../formatters/formatter');const PREVIEW_LENGTH=100;const ALLOWABLE_UNUSED_RULES_RATIO=0.10;class UnusedCSSRules extends Audit{static get meta(){return{category:'Best Practices',name:'unused-css-rules',description:'Site does not have more than 10% unused CSS',helpText:'Remove unused rules from stylesheets to reduce unnecessary '+'bytes consumed by network activity. [Learn more](https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery)',requiredArtifacts:['CSSUsage','Styles']};}
static indexStylesheetsById(styles){return styles.reduce((indexed,stylesheet)=>{indexed[stylesheet.header.styleSheetId]=Object.assign({used:[],unused:[],},stylesheet);return indexed;},{});}
static countUnusedRules(rules,indexedStylesheets){let unused=0;rules.forEach(rule=>{const stylesheetInfo=indexedStylesheets[rule.styleSheetId];if(rule.used){stylesheetInfo.used.push(rule);}else{unused++;stylesheetInfo.unused.push(rule);}});return unused;}
static mapSheetToResult(stylesheetInfo){const numUsed=stylesheetInfo.used.length;const numUnused=stylesheetInfo.unused.length;const percentUsed=Math.round(100*numUsed/(numUsed+numUnused))||0;let contentPreview=stylesheetInfo.content;if(contentPreview.length>PREVIEW_LENGTH){const firstRuleStart=contentPreview.indexOf('{');const firstRuleEnd=contentPreview.indexOf('}');if(firstRuleStart===-1||firstRuleEnd===-1||firstRuleStart>firstRuleEnd||firstRuleStart>PREVIEW_LENGTH){contentPreview=contentPreview.slice(0,PREVIEW_LENGTH)+'...';}else if(firstRuleEnd<PREVIEW_LENGTH){contentPreview=contentPreview.slice(0,firstRuleEnd+1)+' ...';}else{const lastSemicolonIndex=contentPreview.slice(0,PREVIEW_LENGTH).lastIndexOf(';');contentPreview=lastSemicolonIndex<firstRuleStart?contentPreview.slice(0,PREVIEW_LENGTH)+'... } ...':contentPreview.slice(0,lastSemicolonIndex+1)+' ... } ...';}}
return{url:stylesheetInfo.header.sourceURL||'inline',label:`${percentUsed}% rules used`,code:contentPreview.trim(),};}
static audit(artifacts){const styles=artifacts.Styles;const usage=artifacts.CSSUsage;if(styles.rawValue===-1){return UnusedCSSRules.generateAuditResult(styles);}else if(usage.rawValue===-1){return UnusedCSSRules.generateAuditResult(usage);}
const indexedSheets=UnusedCSSRules.indexStylesheetsById(styles);const unused=UnusedCSSRules.countUnusedRules(usage,indexedSheets);const unusedRatio=(unused/usage.length)||0;const results=Object.keys(indexedSheets).map(sheetId=>{return UnusedCSSRules.mapSheetToResult(indexedSheets[sheetId]);});let displayValue='';if(unused>1){displayValue=`${unused} CSS rules were unused`;}else if(unused===1){displayValue=`${unused} CSS rule was unused`;}
return UnusedCSSRules.generateAuditResult({displayValue,rawValue:unusedRatio<ALLOWABLE_UNUSED_RULES_RATIO,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URLLIST,value:results}});}}
module.exports=UnusedCSSRules;},{"../formatters/formatter":8,"./audit":3}],"../audits/user-timings":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../formatters/formatter');const TimelineModel=require('../lib/traces/devtools-timeline-model');function filterTrace(traceData){const userTimings=[];const measuresStartTimes={};let traceStartFound=false;let navigationStartTime;const timelineModel=new TimelineModel(traceData);const modeledTraceData=timelineModel.timelineModel();modeledTraceData.mainThreadEvents().filter(ut=>{if(ut.name==='TracingStartedInPage'||ut.name==='navigationStart'){return true;}
if(ut.hasCategory('blink.user_timing')){return ut.name!=='requestStart'&&ut.name!=='paintNonDefaultBackgroundColor'&&ut.args.frame===undefined;}
return false;}).forEach(ut=>{if(ut.phase==='R'||ut.phase.toUpperCase()==='I'){if(ut.name==='TracingStartedInPage'&&!traceStartFound){traceStartFound=true;return;}
if(ut.name==='navigationStart'&&traceStartFound&&!navigationStartTime){navigationStartTime=ut.startTime;}
if(ut.name!=='navigationStart'){userTimings.push({name:ut.name,isMark:true,args:ut.args,startTime:ut.startTime});}}else if(ut.phase.toLowerCase()==='b'){measuresStartTimes[ut.name]=ut.startTime;}else if(ut.phase.toLowerCase()==='e'){userTimings.push({name:ut.name,isMark:false,args:ut.args,startTime:measuresStartTimes[ut.name],duration:ut.startTime-measuresStartTimes[ut.name],endTime:ut.startTime});}});userTimings.forEach(ut=>{ut.startTime-=navigationStartTime;if(!ut.isMark){ut.endTime-=navigationStartTime;ut.duration=ut.duration;}});return userTimings;}
class UserTimings extends Audit{static get meta(){return{category:'Performance',name:'user-timings',description:'User Timing marks and measures',helpText:'Consider instrumenting your app with the User Timing API to create custom, '+'real-world measurements of key user experiences. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing).',requiredArtifacts:['traces']};}
static audit(artifacts){const traceContents=artifacts.traces[Audit.DEFAULT_PASS].traceEvents;const userTimings=filterTrace(traceContents);return UserTimings.generateAuditResult({rawValue:true,displayValue:userTimings.length,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.USER_TIMINGS,value:userTimings}});}}
module.exports=UserTimings;},{"../formatters/formatter":8,"../lib/traces/devtools-timeline-model":28,"./audit":3}],"../audits/viewport":[function(require,module,exports){'use strict';const Audit=require('./audit');class Viewport extends Audit{static get meta(){return{category:'Mobile Friendly',name:'viewport',description:'HTML has a `<meta name="viewport">` tag',helpText:'Add a viewport meta tag to optimize your app for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/has-viewport-meta-tag").',requiredArtifacts:['Viewport']};}
static audit(artifacts){const hasMobileViewport=typeof artifacts.Viewport==='string'&&artifacts.Viewport.includes('width=');return Viewport.generateAuditResult({rawValue:!!hasMobileViewport});}}
module.exports=Viewport;},{"./audit":3}],"../audits/without-javascript":[function(require,module,exports){'use strict';const Audit=require('./audit');class WithoutJavaScript extends Audit{static get meta(){return{category:'JavaScript',name:'without-javascript',description:'Page contains some content when its scripts are not available',helpText:'Your app should display some content when JavaScript is disabled, even if it\'s '+'just a warning to the user that JavaScript is required to use the app. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/no-js).',requiredArtifacts:['HTMLWithoutJavaScript']};}
static audit(artifacts){const artifact=artifacts.HTMLWithoutJavaScript;if(typeof artifact.value!=='string'){return WithoutJavaScript.generateAuditResult({rawValue:-1,debugString:artifact.debugString||'HTMLWithoutJavaScript gatherer did not complete successfully'});}
if(artifact.value.trim()===''){return WithoutJavaScript.generateAuditResult({rawValue:false,debugString:'The page body should render some content if its scripts are not available.'});}
return WithoutJavaScript.generateAuditResult({rawValue:true});}}
module.exports=WithoutJavaScript;},{"./audit":3}],"../audits/works-offline":[function(require,module,exports){'use strict';const Audit=require('./audit');class WorksOffline extends Audit{static get meta(){return{category:'Offline',name:'works-offline',description:'URL responds with a 200 when offline',helpText:'If you\'re building a Progressive Web App, consider using a service worker so '+'that your app can work offline. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-200-when-offline).',requiredArtifacts:['Offline']};}
static audit(artifacts){return WorksOffline.generateAuditResult({rawValue:artifacts.Offline===200});}}
module.exports=WorksOffline;},{"./audit":3}],"./computed/computed-artifact":[function(require,module,exports){'use strict';class ComputedArtifact{constructor(){this.cache=new Map();}
compute_(artifact){throw new Error('compute_() not implemented for computed artifact '+this.name);}
request(artifact){if(this.cache.has(artifact)){return Promise.resolve(this.cache.get(artifact));}
return Promise.resolve(this.compute_(artifact)).then(computedArtifact=>{this.cache.set(artifact,computedArtifact);return computedArtifact;});}}
module.exports=ComputedArtifact;},{}],"./computed/critical-request-chains":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const WebInspector=require('../../lib/web-inspector');const includes=(arr,elm)=>arr.indexOf(elm)>-1;class CriticalRequestChains extends ComputedArtifact{get name(){return'CriticalRequestChains';}
isCritical(request){const resourceTypeCategory=request._resourceType&&request._resourceType._category;if(resourceTypeCategory===WebInspector.resourceTypes.XHR._category){return false;}
if(request.mimeType==='image/x-icon'||(request.parsedURL&&request.parsedURL.lastPathComponent==='favicon.ico')){return false;}
return includes(['VeryHigh','High','Medium'],request.priority());}
compute_(networkRecords){const requestIdToRequests=new Map();for(const request of networkRecords){requestIdToRequests.set(request.requestId,request);}
const criticalRequests=networkRecords.filter(req=>this.isCritical(req));const flattenRequest=request=>{return{url:request._url,startTime:request.startTime,endTime:request.endTime,responseReceivedTime:request.responseReceivedTime,transferSize:request.transferSize};};const criticalRequestChains={};for(const request of criticalRequests){const ancestors=[];let ancestorRequest=request.initiatorRequest();let node=criticalRequestChains;while(ancestorRequest){const ancestorIsCritical=this.isCritical(ancestorRequest);if(!ancestorIsCritical||includes(ancestors,ancestorRequest.requestId)){ancestors.length=0;node=undefined;break;}
ancestors.push(ancestorRequest.requestId);ancestorRequest=ancestorRequest.initiatorRequest();}
let ancestor=ancestors.pop();while(ancestor){const parentRequest=requestIdToRequests.get(ancestor);const parentRequestId=parentRequest.requestId;if(!node[parentRequestId]){node[parentRequestId]={request:flattenRequest(parentRequest),children:{}};}
ancestor=ancestors.pop();node=node[parentRequestId].children;}
if(!node){continue;}
if(node[request.requestId]){continue;}
node[request.requestId]={request:flattenRequest(request),children:{}};}
return criticalRequestChains;}}
module.exports=CriticalRequestChains;},{"../../lib/web-inspector":31,"./computed-artifact":"./computed/computed-artifact"}],"./computed/pushed-requests":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class PushedRequests extends ComputedArtifact{get name(){return'PushedRequests';}
compute_(records){const pushedRecords=records.filter(r=>r._timing&&!!r._timing.pushStart);return pushedRecords;}}
module.exports=PushedRequests;},{"./computed-artifact":"./computed/computed-artifact"}],"./computed/screenshots":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const DevtoolsTimelineModel=require('../../lib/traces/devtools-timeline-model');class ScreenshotFilmstrip extends ComputedArtifact{get name(){return'Screenshots';}
fetchScreenshot(frame){return frame.imageDataPromise().then(data=>'data:image/jpg;base64,'+data);}
compute_(trace){const model=new DevtoolsTimelineModel(trace.traceEvents);const filmStripFrames=model.filmStripModel().frames();const frameFetches=filmStripFrames.map(frame=>this.fetchScreenshot(frame));return Promise.all(frameFetches).then(images=>{const result=filmStripFrames.map((frame,i)=>({timestamp:frame.timestamp,datauri:images[i]}));return result;});}}
module.exports=ScreenshotFilmstrip;},{"../../lib/traces/devtools-timeline-model":28,"./computed-artifact":"./computed/computed-artifact"}],"./computed/speedline":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const speedline=require('speedline');class Speedline extends ComputedArtifact{get name(){return'Speedline';}
compute_(trace){return Promise.resolve().then(_=>{return speedline(trace.traceEvents);}).then(speedlineResults=>{return speedlineResults;});}}
module.exports=Speedline;},{"./computed-artifact":"./computed/computed-artifact","speedline":284}],"./gatherers/accessibility":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('./gatherer');const axe=Buffer("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","base64");function runA11yChecks(){return axe.run(document,{runOnly:{type:'rule',values:['aria-allowed-attr','aria-required-attr','aria-valid-attr','aria-valid-attr-value','color-contrast','image-alt','label','tabindex']}});}
class Accessibility extends Gatherer{static _errorAccessibility(errorString){return{raw:undefined,value:undefined,debugString:errorString};}
afterPass(options){const driver=options.driver;const expression=`(function () {
      ${axe};
      return (${runA11yChecks.toString()}());
    })()`;return driver.evaluateAsync(expression).then(returnedValue=>{if(!returnedValue){return Accessibility._errorAccessibility('Unable to parse axe results');}
if(returnedValue.error){return Accessibility._errorAccessibility(returnedValue.error);}
return returnedValue;},_=>{return Accessibility._errorAccessibility('Axe results timed out');});}}
module.exports=Accessibility;}).call(this,require("buffer").Buffer)},{"./gatherer":18,"buffer":200}],"./gatherers/cache-contents":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getCacheContents(){return caches.keys().then(cacheNames=>Promise.all(cacheNames.map(cacheName=>caches.open(cacheName)))).then(caches=>{const requests=[];return Promise.all(caches.map(cache=>{return cache.keys().then(reqs=>{requests.push(...reqs.map(r=>r.url));});})).then(_=>{return requests;});});}
class CacheContents extends Gatherer{static _error(errorString){return{raw:undefined,value:undefined,debugString:errorString};}
afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${getCacheContents.toString()}())`).then(returnedValue=>{if(!returnedValue){return CacheContents._error('Unable to retrieve cache contents');}
return returnedValue;},_=>{return CacheContents._error('Unable to retrieve cache contents');});}}
module.exports=CacheContents;},{"./gatherer":18}],"./gatherers/content-width":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getContentWidth(){return Promise.resolve({scrollWidth:window.innerWidth,viewportWidth:window.outerWidth});}
class ContentWidth extends Gatherer{afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${getContentWidth.toString()}())`).then(returnedValue=>{if(!Number.isFinite(returnedValue.scrollWidth)||!Number.isFinite(returnedValue.viewportWidth)){throw new Error(`ContentWidth results were not numeric: ${JSON.stringify(returnedValue)}`);}
return returnedValue;},_=>{return{scrollWidth:-1,viewportWidth:-1};});}}
module.exports=ContentWidth;},{"./gatherer":18}],"./gatherers/css-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class CSSUsage extends Gatherer{beforePass(options){return options.driver.sendCommand('DOM.enable').then(_=>options.driver.sendCommand('CSS.enable')).then(_=>options.driver.sendCommand('CSS.startRuleUsageTracking'));}
afterPass(options){const driver=options.driver;return driver.sendCommand('CSS.stopRuleUsageTracking').then(results=>{return driver.sendCommand('CSS.disable').then(_=>driver.sendCommand('DOM.disable')).then(_=>results.ruleUsage);}).catch(err=>{return{rawValue:-1,debugString:err,};});}}
module.exports=CSSUsage;},{"./gatherer":18}],"./gatherers/dobetterweb/all-event-listeners":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class EventListeners extends Gatherer{listenForScriptParsedEvents(){return this.driver.sendCommand('Debugger.enable').then(_=>{this.driver.on('Debugger.scriptParsed',script=>{this._parsedScripts.set(script.scriptId,script);});});}
unlistenForScriptParsedEvents(){this.driver.off('Debugger.scriptParsed',this.listenForScriptParsedEvents);return this.driver.sendCommand('Debugger.disable');}
_listEventListeners(nodeIdOrObject){let promise;if(typeof nodeIdOrObject==='string'){promise=this.driver.sendCommand('Runtime.evaluate',{expression:nodeIdOrObject,objectGroup:'event-listeners-gatherer'});}else{promise=this.driver.sendCommand('DOM.resolveNode',{nodeId:nodeIdOrObject,objectGroup:'event-listeners-gatherer'});}
return promise.then(result=>{const obj=result.object||result.result;return this.driver.sendCommand('DOMDebugger.getEventListeners',{objectId:obj.objectId}).then(results=>{return{listeners:results.listeners,tagName:obj.description};});});}
getEventListeners(nodeId){const matchedListeners=[];return this._listEventListeners(nodeId).then(results=>{results.listeners.forEach(listener=>{const script=this._parsedScripts.get(listener.scriptId);if(script){const combo=Object.assign(listener,script);combo.objectName=results.tagName;combo.line=combo.lineNumber+1;combo.col=combo.columnNumber+1;matchedListeners.push(combo);}});return matchedListeners;});}
collectListeners(nodes){return nodes.reduce((chain,node)=>{return chain.then(prevArr=>{return this.getEventListeners(node.element?node.element.nodeId:node).then(result=>prevArr.concat(result));});},Promise.resolve([]));}
beforePass(options){this.driver=options.driver;this._parsedScripts=new Map();return this.listenForScriptParsedEvents();}
afterPass(options){return this.unlistenForScriptParsedEvents().then(_=>options.driver.querySelectorAll('body, body /deep/ *')).then(nodes=>{nodes.push('document','window');return this.collectListeners(nodes);}).catch(_=>{return{rawValue:-1,debugString:'Unable to collect passive events listener usage.'};});}}
module.exports=EventListeners;},{"../gatherer":18}],"./gatherers/dobetterweb/anchors-with-no-rel-noopener":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AnchorsWithNoRelNoopener extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelectorAll('a[target="_blank"]:not([rel~="noopener"])').then(failingNodeList=>{const failingNodes=failingNodeList.map(node=>{return Promise.all([node.getProperty('href'),node.getAttribute('rel'),node.getAttribute('target')]);});return Promise.all(failingNodes);}).then(failingNodes=>{return{usages:failingNodes.map(node=>{return{href:node[0],rel:node[1],target:node[2]};})};}).catch(_=>{return-1;});}}
module.exports=AnchorsWithNoRelNoopener;},{"../gatherer":18}],"./gatherers/dobetterweb/appcache":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AppCacheManifest extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('html').then(node=>node&&node.getAttribute('manifest')).catch(_=>{return-1;});}}
module.exports=AppCacheManifest;},{"../gatherer":18}],"./gatherers/dobetterweb/console-time-usage":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class ConsoleTimeUsage extends Gatherer{beforePass(options){this.collectUsage=options.driver.captureFunctionCallSites('console.time');}
afterPass(){return this.collectUsage().then(consoleTimeUsage=>{return{usage:consoleTimeUsage};},e=>{return{value:-1,debugString:e.message};});}}
module.exports=ConsoleTimeUsage;},{"../gatherer":18}],"./gatherers/dobetterweb/datenow":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class DateNowUse extends Gatherer{beforePass(options){this.collectUsage=options.driver.captureFunctionCallSites('Date.now');}
afterPass(){return this.collectUsage().then(dateNowUses=>{return{usage:dateNowUses};},e=>{return{value:-1,debugString:e.message};});}}
module.exports=DateNowUse;},{"../gatherer":18}],"./gatherers/dobetterweb/document-write":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class DocWriteUse extends Gatherer{beforePass(options){this.collectUsage=options.driver.captureFunctionCallSites('document.write');}
afterPass(){return this.collectUsage().then(DocWriteUses=>{return{usage:DocWriteUses};},e=>{return{value:-1,debugString:e.message};});}}
module.exports=DocWriteUse;},{"../gatherer":18}],"./gatherers/dobetterweb/geolocation-on-start":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class GeolocationOnStart extends Gatherer{beforePass(options){this.collectCurrentPosUsage=options.driver.captureFunctionCallSites('navigator.geolocation.getCurrentPosition');this.collectWatchPosUsage=options.driver.captureFunctionCallSites('navigator.geolocation.watchPosition');}
afterPass(options){return options.driver.queryPermissionState('geolocation').then(state=>{if(state==='granted'||state==='denied'){return{value:-1,debugString:'Unable to determine if this permission was requested '+'on page load because it had already been set. '+'Try resetting the permission and run Lighthouse again.'};}
return this.collectCurrentPosUsage().then(results=>{return this.collectWatchPosUsage().then(results2=>results.concat(results2));}).then(results=>{return{usage:results};});}).catch(e=>{return{value:-1,debugString:e&&e.message};});}}
module.exports=GeolocationOnStart;},{"../gatherer":18}],"./gatherers/dobetterweb/notification-on-start":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class NotificationOnStart extends Gatherer{beforePass(options){this.collectNotificationUsage=options.driver.captureFunctionCallSites('Notification.requestPermission');}
afterPass(options){return options.driver.queryPermissionState('notifications').then(state=>{if(state==='granted'||state==='denied'){return{value:-1,debugString:'Unable to determine if this permission was requested '+'on page load because it had already been set. '+'Try resetting the permission and run Lighthouse again.'};}
return this.collectNotificationUsage().then(results=>{return{usage:results};});}).catch(e=>{return{value:-1,debugString:e&&e.message};});}}
module.exports=NotificationOnStart;},{"../gatherer":18}],"./gatherers/dobetterweb/tags-blocking-first-paint":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function saveAsyncLinks(){function checkForLinks(){document.querySelectorAll('link').forEach(link=>{if(link.rel==='preload'||link.disabled){window.__asyncLinks[link.href]=true;}});}
window.__asyncLinks=window.__asyncLinks||{};setInterval(checkForLinks,100);checkForLinks();}
function collectTagsThatBlockFirstPaint(){return new Promise((resolve,reject)=>{try{const tagList=[...document.querySelectorAll('link, head script[src]')].filter(tag=>{if(tag.tagName==='SCRIPT'){return!tag.hasAttribute('async')&&!tag.hasAttribute('defer')&&!/^data:/.test(tag.src);}
const blockingStylesheet=(tag.rel==='stylesheet'&&window.matchMedia(tag.media).matches&&!tag.disabled);const blockingImport=tag.rel==='import'&&!tag.hasAttribute('async');return blockingStylesheet||blockingImport;}).map(tag=>{return{tagName:tag.tagName,url:tag.tagName==='LINK'?tag.href:tag.src,src:tag.src,href:tag.href,rel:tag.rel,media:tag.media,disabled:tag.disabled};}).filter(tag=>!window.__asyncLinks[tag.url]);resolve(tagList);}catch(e){const friendly='Unable to gather Scripts/Stylesheets/HTML Imports on the page';reject(new Error(`${friendly}: ${e.message}`));}});}
function filteredAndIndexedByUrl(networkRecords){return networkRecords.reduce((prev,record)=>{const isParserGenerated=record._initiator.type==='parser';const isParserScriptOrStyle=/(css|script)/.test(record._mimeType)&&isParserGenerated;const isFailedRequest=record._failed;const isHtml=record._mimeType&&record._mimeType.indexOf('html')>-1;if(isHtml||isParserScriptOrStyle||(isFailedRequest&&isParserGenerated)){prev[record._url]={transferSize:record._transferSize,startTime:record._startTime,endTime:record._endTime};}
return prev;},{});}
class TagsBlockingFirstPaint extends Gatherer{constructor(){super();this._filteredAndIndexedByUrl=filteredAndIndexedByUrl;}
static findBlockingTags(driver,networkRecords){const scriptSrc=`(${collectTagsThatBlockFirstPaint.toString()}())`;return driver.evaluateAsync(scriptSrc).then(tags=>{const requests=filteredAndIndexedByUrl(networkRecords);let totalTransferSize=0;let totalSpendTime=0;const blockingTags=tags.reduce((prev,tag)=>{const request=requests[tag.url];if(request){const data={tag,transferSize:request.transferSize,spendTime:Math.round((request.endTime-request.startTime)*1000)};totalTransferSize+=data.transferSize;totalSpendTime+=data.spendTime;prev.push(data);}
return prev;},[]);return{items:blockingTags,total:{transferSize:totalTransferSize,spendTime:totalSpendTime}};});}
beforePass(options){const scriptSrc=`(${saveAsyncLinks.toString()})()`;return options.driver.evaluateScriptOnLoad(scriptSrc);}
afterPass(options,tracingData){return TagsBlockingFirstPaint.findBlockingTags(options.driver,tracingData.networkRecords).catch(err=>{return{value:-1,debugString:err.message};});}}
module.exports=TagsBlockingFirstPaint;},{"../gatherer":18}],"./gatherers/dobetterweb/websql":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const MAX_WAIT_TIMEOUT=500;class WebSQL extends Gatherer{listenForDatabaseEvents(driver){let timeout;return new Promise((resolve,reject)=>{driver.once('Database.addDatabase',db=>{clearTimeout(timeout);driver.sendCommand('Database.disable').then(_=>resolve(db),reject);});driver.sendCommand('Database.enable').catch(reject);timeout=setTimeout(function(){resolve(null);},MAX_WAIT_TIMEOUT);});}
afterPass(options){return this.listenForDatabaseEvents(options.driver).then(database=>{const artifact={database};if(!database){artifact.debugString='No WebSQL databases were opened';}
return artifact;}).catch(_=>{return{database:-1,debugString:'Unable to gather WebSQL database state'};});}}
module.exports=WebSQL;},{"../gatherer":18}],"./gatherers/html-without-javascript":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getBodyText(){const body=document.querySelector('body');return Promise.resolve(body?body.innerText:'');}
class HTMLWithoutJavaScript extends Gatherer{beforePass(options){options.disableJavaScript=true;}
afterPass(options){options.disableJavaScript=false;return options.driver.evaluateAsync(`(${getBodyText.toString()}())`).then(result=>{if(typeof result!=='string'){throw new Error('result was not a string');}
return{value:result};}).catch(err=>{return{value:-1,debugString:`Unable to get document body innerText: ${err.message}`};});}}
module.exports=HTMLWithoutJavaScript;},{"./gatherer":18}],"./gatherers/html":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTML extends Gatherer{afterPass(options){const driver=options.driver;return driver.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>driver.sendCommand('DOM.getOuterHTML',{nodeId:nodeId})).then(nodeHTML=>{return nodeHTML.outerHTML;}).catch(_=>{return{value:-1,debugString:'Unable to get document HTML'};});}}
module.exports=HTML;},{"./gatherer":18}],"./gatherers/http-redirect":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTTPRedirect extends Gatherer{constructor(){super();this._preRedirectURL=undefined;}
beforePass(options){this._preRedirectURL=options.url;options.url=this._preRedirectURL.replace(/^https/,'http');}
afterPass(options){options.url=this._preRedirectURL;const timeout=options._testTimeout||10000;const securityPromise=options.driver.getSecurityState().then(state=>{return{value:state.schemeIsCryptographic};},_=>{return{value:false,debugString:'Error requesting security state'};});let noSecurityChangesTimeout;const timeoutPromise=new Promise((resolve,reject)=>{noSecurityChangesTimeout=setTimeout(_=>{resolve({value:false,debugString:'Timed out waiting for HTTP redirection.'});},timeout);});return Promise.race([securityPromise,timeoutPromise]).then(result=>{clearTimeout(noSecurityChangesTimeout);return result;});}}
module.exports=HTTPRedirect;},{"./gatherer":18}],"./gatherers/https":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTTPS extends Gatherer{constructor(){super();this._noSecurityChangesTimeout=undefined;}
afterPass(options){const timeout=options._testTimeout||10000;const securityPromise=options.driver.getSecurityState().then(state=>{return{value:state.schemeIsCryptographic};},_=>{return{value:false,debugString:'Error requesting page security state.'};});let noSecurityChangesTimeout;const timeoutPromise=new Promise((resolve,reject)=>{noSecurityChangesTimeout=setTimeout(_=>{resolve({value:false,debugString:'Timed out waiting for page security state.'});},timeout);});return Promise.race([securityPromise,timeoutPromise]).then(result=>{clearTimeout(noSecurityChangesTimeout);return result;});}}
module.exports=HTTPS;},{"./gatherer":18}],"./gatherers/manifest":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');class Manifest extends Gatherer{static _errorManifest(errorString){return{raw:undefined,value:undefined,debugString:errorString};}
afterPass(options){return options.driver.sendCommand('Page.getAppManifest').then(response=>{if(!response.data){let errorString;if(response.url){errorString=`Unable to retrieve manifest at ${response.url}`;}else{errorString='No manifest found.';}
return Manifest._errorManifest(errorString);}
return manifestParser(response.data,response.url,options.url);},err=>{return Manifest._errorManifest('Unable to retrieve manifest: '+err);});}}
module.exports=Manifest;},{"../../lib/manifest-parser":25,"./gatherer":18}],"./gatherers/offline":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class Offline extends Gatherer{beforePass(options){return options.driver.goOffline();}
afterPass(options,tracingData){const navigationRecord=tracingData.networkRecords.filter(record=>{return record._url===options.url&&record._fetchedViaServiceWorker;}).pop();return options.driver.goOnline(options).then(_=>{return navigationRecord?navigationRecord.statusCode:-1;});}}
module.exports=Offline;},{"./gatherer":18}],"./gatherers/service-worker":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ServiceWorker extends Gatherer{beforePass(options){const driver=options.driver;return driver.getServiceWorkerVersions().then(data=>{return{versions:data.versions};}).catch(err=>{return{debugString:`Error in querying Service Worker status: ${err.message}`};});}}
module.exports=ServiceWorker;},{"./gatherer":18}],"./gatherers/styles":[function(require,module,exports){'use strict';const WebInspector=require('../../lib/web-inspector');const Gatherer=require('./gatherer');const log=require('../../lib/log.js');function getCSSPropsInStyleSheet(parseTree){const results=[];parseTree.traverseByType('declaration',function(node,index,parent){if(parent.type==='arguments'){return;}
const keyVal=node.toString().split(':').map(item=>item.trim());results.push({property:{name:keyVal[0],val:keyVal[1]},declarationRange:node.declarationRange,selector:parent.selectors.toString()});});return results;}
class Styles extends Gatherer{constructor(){super();this._activeStyleSheetIds=[];this._activeStyleHeaders={};this._onStyleSheetAdded=this.onStyleSheetAdded.bind(this);this._onStyleSheetRemoved=this.onStyleSheetRemoved.bind(this);}
onStyleSheetAdded(styleHeader){if(styleHeader.header.origin!=='regular'){return;}
this._activeStyleHeaders[styleHeader.header.styleSheetId]=styleHeader;this._activeStyleSheetIds.push(styleHeader.header.styleSheetId);}
onStyleSheetRemoved(styleHeader){delete this._activeStyleHeaders[styleHeader.styleSheetId];const idx=this._activeStyleSheetIds.indexOf(styleHeader.styleSheetId);if(idx!==-1){this._activeStyleSheetIds.splice(idx,1);}}
beginStylesCollect(driver){driver.on('CSS.styleSheetAdded',this._onStyleSheetAdded);driver.on('CSS.styleSheetRemoved',this._onStyleSheetRemoved);return driver.sendCommand('DOM.enable').then(_=>driver.sendCommand('CSS.enable'));}
endStylesCollect(driver){return new Promise((resolve,reject)=>{if(!this._activeStyleSheetIds.length){resolve([]);return;}
const parser=new WebInspector.SCSSParser();const contentPromises=this._activeStyleSheetIds.map(sheetId=>{return driver.sendCommand('CSS.getStyleSheetText',{styleSheetId:sheetId}).then(content=>{const styleHeader=this._activeStyleHeaders[sheetId];styleHeader.content=content.text;const parsedContent=parser.parse(styleHeader.content);if(parsedContent.error){log.warn('Styles Gatherer',`Could not parse content: ${parsedContent.error}`);styleHeader.parsedContent=[];}else{styleHeader.parsedContent=getCSSPropsInStyleSheet(parsedContent);}
return styleHeader;});});Promise.all(contentPromises).then(styleHeaders=>{driver.off('CSS.styleSheetAdded',this._onStyleSheetAdded);driver.off('CSS.styleSheetRemoved',this._onStyleSheetRemoved);resolve(styleHeaders);}).catch(err=>reject(err));});}
beforePass(options){return this.beginStylesCollect(options.driver);}
afterPass(options){return this.endStylesCollect(options.driver).then(stylesheets=>{const map=new Map(stylesheets.map(s=>[s.content,s]));return stylesheets.map(stylesheet=>{const idInMap=map.get(stylesheet.content).header.styleSheetId;stylesheet.isDuplicate=idInMap!==stylesheet.header.styleSheetId;return stylesheet;});},err=>{return{rawValue:-1,debugString:err};});}}
module.exports=Styles;},{"../../lib/log.js":24,"../../lib/web-inspector":31,"./gatherer":18}],"./gatherers/theme-color":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ThemeColor extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('head meta[name="theme-color"]').then(node=>node&&node.getAttribute('content')).catch(_=>{return-1;});}}
module.exports=ThemeColor;},{"./gatherer":18}],"./gatherers/url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class URL extends Gatherer{afterPass(options){return{initialUrl:options.initialUrl,finalUrl:options.url};}}
module.exports=URL;},{"./gatherer":18}],"./gatherers/viewport":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class Viewport extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('head meta[name="viewport"]').then(node=>node&&node.getAttribute('content')).catch(_=>{return-1;});}}
module.exports=Viewport;},{"./gatherer":18}],1:[function(require,module,exports){'use strict';class Aggregate{static _filterResultsByAuditNames(results,expected){const expectedNames=Object.keys(expected);return results.filter(r=>expectedNames.indexOf((r.name))!==-1);}
static _getTotalWeight(expected){const expectedNames=Object.keys(expected);const totalWeight=expectedNames.reduce((last,e)=>last+(expected[e].weight||0),0);return totalWeight;}
static _remapResultsByName(results){const remapped={};results.forEach(r=>{if(remapped[r.name]){throw new Error(`Cannot remap: ${r.name} already exists`);}
remapped[r.name]=r;});return remapped;}
static _convertToWeight(result,expected,name){let weight=0;if(typeof expected==='undefined'||typeof expected.expectedValue==='undefined'||typeof expected.weight==='undefined'){const msg=`aggregations: ${name} audit does not contain expectedValue or weight properties`;throw new Error(msg);}
if(typeof result==='undefined'||typeof result.score==='undefined'){let msg=`${name} audit result is undefined or does not contain score property`;if(result&&result.debugString){msg+=': '+result.debugString;}
throw new Error(msg);}
if(typeof result.score!==typeof expected.expectedValue){const expectedType=typeof expected.expectedValue;const resultType=typeof result.rawValue;let msg=`Expected expectedValue of type ${expectedType}, got ${resultType}`;if(result.debugString){msg+=': '+result.debugString;}
throw new Error(msg);}
switch(typeof expected.expectedValue){case'boolean':weight=this._convertBooleanToWeight(result.score,expected.expectedValue,expected.weight);break;case'number':weight=this._convertNumberToWeight(result.score,expected.expectedValue,expected.weight);break;default:weight=0;break;}
return weight;}
static _convertNumberToWeight(resultValue,expectedValue,weight){return(resultValue/expectedValue)*weight;}
static _convertBooleanToWeight(resultValue,expectedValue,weight){return(resultValue===expectedValue)?weight:0;}
static compare(results,items,aggregationIsScored){return items.map(item=>{const expectedNames=Object.keys(item.audits);const filteredAndRemappedResults=Aggregate._remapResultsByName(Aggregate._filterResultsByAuditNames(results,item.audits));const subItems=[];let overallScore=0;let maxScore=1;expectedNames.forEach(e=>{if(item.audits[e].comingSoon){subItems.push({score:'¯\\_(ツ)_/¯',name:'coming-soon',category:item.audits[e].category,description:item.audits[e].description,comingSoon:true});return;}
if(!filteredAndRemappedResults[e]){throw new Error(`aggregations: expected audit results not found under audit name ${e}`);}
subItems.push(filteredAndRemappedResults[e].name);if(!aggregationIsScored){return;}
overallScore+=Aggregate._convertToWeight(filteredAndRemappedResults[e],item.audits[e],e);});if(aggregationIsScored){maxScore=Aggregate._getTotalWeight(item.audits);}
return{overall:(overallScore/maxScore),name:item.name,description:item.description,subItems:subItems};});}
static getTotal(scores){return scores.reduce((total,s)=>total+s.overall,0)/scores.length;}
static aggregate(aggregation,auditResults){const score=Aggregate.compare(auditResults,aggregation.items,aggregation.scored);return{name:aggregation.name,description:aggregation.description,scored:aggregation.scored,total:(aggregation.scored?Aggregate.getTotal(score):null),categorizable:aggregation.categorizable,score:score};}}
module.exports=Aggregate;},{}],2:[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../formatters/formatter');class AxeAudit extends Audit{static audit(artifacts){const violations=artifacts.Accessibility.violations||[];const rule=violations.find(result=>result.id===this.meta.name);return this.generateAuditResult({rawValue:typeof rule==='undefined',debugString:this.createDebugString(rule),extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,value:rule}});}
static createDebugString(rule){if(typeof rule==='undefined'){return'';}
const elementsStr=rule.nodes.length===1?'element':'elements';return`${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;}}
module.exports=AxeAudit;},{"../../formatters/formatter":8,"../audit":3}],3:[function(require,module,exports){'use strict';const DEFAULT_PASS='defaultPass';class Audit{static get DEFAULT_PASS(){return DEFAULT_PASS;}
static get meta(){throw new Error('Audit meta information must be overridden.');}
static generateAuditResult(result){if(typeof result.rawValue==='undefined'){throw new Error('generateAuditResult requires a rawValue');}
const score=typeof result.score==='undefined'?result.rawValue:result.score;let displayValue=result.displayValue;if(typeof displayValue==='undefined'){displayValue=result.rawValue?result.rawValue:'';}
if(displayValue===score){displayValue='';}
return{score,displayValue:`${displayValue}`,rawValue:result.rawValue,debugString:result.debugString,optimalValue:result.optimalValue,extendedInfo:result.extendedInfo,name:this.meta.name,category:this.meta.category,description:this.meta.description,helpText:this.meta.helpText};}}
module.exports=Audit;},{}],4:[function(require,module,exports){(function(__dirname){'use strict';const defaultConfigPath='./default.json';const defaultConfig=require('./default.json');const recordsFromLogs=require('../lib/network-recorder').recordsFromLogs;const GatherRunner=require('../gather/gather-runner');const log=require('../lib/log');const path=require('path');const Audit=require('../audits/audit');const Runner=require('../runner');const _flatten=arr=>[].concat(...arr);const _uniq=arr=>Array.from(new Set(arr));function cleanTrace(trace){const traceEvents=trace.traceEvents;const threads=[];const countsByThread={};const traceStartEvents=[];const makeMockEvent=(evt,ts)=>{return{pid:evt.pid,tid:evt.tid,ts:ts||0,ph:'I',cat:'disabled-by-default-devtools.timeline',name:'TracingStartedInPage',args:{data:{page:evt.frame}},s:'t'};};let frame;let data;let name;let counter;traceEvents.forEach((evt,idx)=>{if(evt.name.startsWith('TracingStartedIn')){traceStartEvents.push(idx);}
data=evt.args&&(evt.args.data||evt.args.beginData||evt.args.counters);frame=(evt.args&&evt.args.frame)||data&&(data.frame||data.page);if(!frame){return;}
name=`pid${evt.pid}-tid${evt.tid}-frame${frame}`;counter=countsByThread[name];if(!counter){counter={pid:evt.pid,tid:evt.tid,frame:frame,count:0};countsByThread[name]=counter;threads.push(counter);}
counter.count++;});threads.sort((a,b)=>b.count-a.count);const mostActiveFrame=threads[0];const ts=traceEvents[traceStartEvents[0]]&&traceEvents[traceStartEvents[0]].ts;let i=0;for(const dup of traceStartEvents){traceEvents.splice(dup-i,1);i++;}
traceEvents.unshift(makeMockEvent(mostActiveFrame,ts));return trace;}
function validatePasses(passes,audits,rootPath){if(!Array.isArray(passes)){return;}
const requiredGatherers=Config.getGatherersNeededByAudits(audits);passes.forEach(pass=>{pass.gatherers.forEach(gatherer=>{const GathererClass=GatherRunner.getGathererClass(gatherer,rootPath);const isGatherRequiredByAudits=requiredGatherers.has(GathererClass.name);if(isGatherRequiredByAudits===false){const msg=`${GathererClass.name} gatherer requested, however no audit requires it.`;log.warn('config',msg);}});});const usedNames=new Set();passes.forEach((pass,index)=>{if(!pass.recordNetwork&&!pass.recordTrace){return;}
const passName=pass.passName||Audit.DEFAULT_PASS;if(usedNames.has(passName)){log.warn('config',`passes[${index}] may overwrite trace or network `+`data of earlier pass without a unique passName (repeated name: ${passName}.`);}
usedNames.add(passName);});}
function assertValidAudit(auditDefinition,auditPath){const auditName=auditPath||auditDefinition.meta.name;if(typeof auditDefinition.audit!=='function'){throw new Error(`${auditName} has no audit() method.`);}
if(typeof auditDefinition.meta.name!=='string'){throw new Error(`${auditName} has no meta.name property, or the property is not a string.`);}
if(typeof auditDefinition.meta.category!=='string'){throw new Error(`${auditName} has no meta.category property, or the property is not a string.`);}
if(typeof auditDefinition.meta.description!=='string'){throw new Error(`${auditName} has no meta.description property, or the property is not a string.`);}
if(!Array.isArray(auditDefinition.meta.requiredArtifacts)){throw new Error(`${auditName} has no meta.requiredArtifacts property, or the property is not an array.`);}
if(typeof auditDefinition.generateAuditResult!=='function'){throw new Error(`${auditName} has no generateAuditResult() method. `+'Did you inherit from the proper base class?');}}
function expandArtifacts(artifacts){if(!artifacts){return null;}
if(artifacts.traces){Object.keys(artifacts.traces).forEach(key=>{log.log('info','Normalizng trace contents into expected state...');let trace=require(artifacts.traces[key]);if(Array.isArray(trace)){trace={traceEvents:trace};}
trace=cleanTrace(trace);artifacts.traces[key]=trace;});}
if(artifacts.performanceLog){if(typeof artifacts.performanceLog==='string'){const log=require(artifacts.performanceLog);artifacts.networkRecords={[Audit.DEFAULT_PASS]:recordsFromLogs(log)};}else{artifacts.networkRecords={};Object.keys(artifacts.performanceLog).forEach(key=>{const log=require(artifacts.performanceLog[key]);artifacts.networkRecords[key]=recordsFromLogs(log);});}}
return artifacts;}
class Config{constructor(configJSON,configPath){if(!configJSON){configJSON=defaultConfig;configPath=path.resolve(__dirname,defaultConfigPath);}
if(configPath&&!path.isAbsolute(configPath)){throw new Error('configPath must be an absolute path.');}
const inputConfig=configJSON;configJSON=JSON.parse(JSON.stringify(inputConfig));if(Array.isArray(inputConfig.passes)){configJSON.passes.forEach((pass,i)=>{pass.gatherers=Array.from(inputConfig.passes[i].gatherers);});}
if(Array.isArray(inputConfig.audits)){configJSON.audits=Array.from(inputConfig.audits);}
this._configDir=configPath?path.dirname(configPath):undefined;this._passes=configJSON.passes||null;this._auditResults=configJSON.auditResults||null;if(this._auditResults&&!Array.isArray(this._auditResults)){throw new Error('config.auditResults must be an array');}
this._aggregations=configJSON.aggregations||null;this._audits=Config.requireAudits(configJSON.audits,this._configDir);this._artifacts=expandArtifacts(configJSON.artifacts);validatePasses(configJSON.passes,this._audits,this._configDir);}
static getMapOfAuditPathToName(config){const auditObjectsAll=Config.requireAudits(config.audits);const auditPathToName=new Map(auditObjectsAll.map((AuditClass,index)=>{const auditPath=config.audits[index];const auditName=AuditClass.meta.name;return[auditPath,auditName];}));return auditPathToName;}
static getAuditsNeededByAggregations(aggregations){const requestedItems=_flatten(aggregations.map(aggregation=>aggregation.items));const requestedAudits=_flatten(requestedItems.map(item=>Object.keys(item.audits)));return new Set(requestedAudits);}
static getGatherersNeededByAudits(audits){if(!audits){return new Set();}
return audits.reduce((list,audit)=>{audit.meta.requiredArtifacts.forEach(artifact=>list.add(artifact));return list;},new Set());}
static selectPassesNeededByGatherers(passes,requiredGatherers){const filteredPasses=passes.map(pass=>{pass.gatherers=pass.gatherers.filter(gathererName=>{gathererName=GatherRunner.getGathererClass(gathererName).name;return requiredGatherers.has(gathererName);});return pass;}).filter(pass=>pass.gatherers.length>0);if(filteredPasses.length===0){if(requiredGatherers.has('traces')||requiredGatherers.has('networkRecords')){filteredPasses.push({recordNetwork:requiredGatherers.has('networkRecords'),recordTrace:requiredGatherers.has('traces'),gatherers:[]});}}
return filteredPasses;}
static getAggregationsByTags(aggregations,chosenTags){const isAggregationSelected=agg=>agg.tags.some(itemTag=>chosenTags.includes(itemTag));const chosenAggregations=[];aggregations.forEach(aggregation=>{if(aggregation.items.length===1){if(isAggregationSelected(aggregation)){chosenAggregations.push(aggregation);}
return;}
aggregation.items=aggregation.items.filter(isAggregationSelected);if(aggregation.items.length&&!isAggregationSelected(aggregation)){aggregation.items.forEach(item=>{item.scored=false;item.categorizable=false;item.items=[{audits:item.audits}];delete item.audits;chosenAggregations.push(item);});return;};if(aggregation.items.length===0){return;}
chosenAggregations.push(aggregation);});return chosenAggregations;}
static rebuildConfigFromTags(config,chosenTags){config.aggregations=Config.getAggregationsByTags(config.aggregations,chosenTags);const requestedAuditNames=Config.getAuditsNeededByAggregations(config.aggregations);const auditPathToName=Config.getMapOfAuditPathToName(config);config.audits=config.audits.filter(auditPath=>requestedAuditNames.has(auditPathToName.get(auditPath)));const auditObjectsSelected=Config.requireAudits(config.audits);const requiredGatherers=Config.getGatherersNeededByAudits(auditObjectsSelected);config.passes=Config.selectPassesNeededByGatherers(config.passes,requiredGatherers);}
static requireAudits(audits,configPath){if(!audits){return null;}
const coreList=Runner.getAuditList();return audits.map(pathOrAuditClass=>{let AuditClass;if(typeof pathOrAuditClass==='string'){const path=pathOrAuditClass;const coreAudit=coreList.find(a=>a===`${path}.js`);let requirePath=`../audits/${path}`;if(!coreAudit){requirePath=Runner.resolvePlugin(path,configPath,'audit');}
AuditClass=require(requirePath);assertValidAudit(AuditClass,path);}else{AuditClass=pathOrAuditClass;assertValidAudit(AuditClass);}
return AuditClass;});}
get configDir(){return this._configDir;}
get passes(){return this._passes;}
get audits(){return this._audits;}
get auditResults(){return this._auditResults;}
get artifacts(){return this._artifacts;}
get aggregations(){return this._aggregations;}}
module.exports=Config;}).call(this,"/../lighthouse-core/config")},{"../audits/audit":3,"../gather/gather-runner":17,"../lib/log":24,"../lib/network-recorder":26,"../runner":33,"./default.json":5,"path":204}],5:[function(require,module,exports){module.exports={"passes":[{"recordNetwork":true,"recordTrace":true,"gatherers":["url","https","viewport","theme-color","manifest","accessibility","content-width"]},{"passName":"offlinePass","recordNetwork":true,"gatherers":["service-worker","offline"]},{"gatherers":["http-redirect","html-without-javascript"]},{"recordNetwork":true,"passName":"dbw","gatherers":["styles","css-usage","dobetterweb/all-event-listeners","dobetterweb/anchors-with-no-rel-noopener","dobetterweb/appcache","dobetterweb/console-time-usage","dobetterweb/datenow","dobetterweb/document-write","dobetterweb/geolocation-on-start","dobetterweb/notification-on-start","dobetterweb/tags-blocking-first-paint","dobetterweb/websql"]}],"audits":["is-on-https","redirects-http","service-worker","works-offline","viewport","manifest-display","without-javascript","first-meaningful-paint","speed-index-metric","estimated-input-latency","time-to-interactive","user-timings","critical-request-chains","manifest-exists","manifest-background-color","manifest-theme-color","manifest-icons-min-192","manifest-icons-min-144","manifest-name","manifest-short-name","manifest-short-name-length","manifest-start-url","theme-color-meta","unused-css-rules","content-width","accessibility/aria-allowed-attr","accessibility/aria-required-attr","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/color-contrast","accessibility/image-alt","accessibility/label","accessibility/tabindex","dobetterweb/external-anchors-use-rel-noopener","dobetterweb/appcache-manifest","dobetterweb/geolocation-on-start","dobetterweb/link-blocking-first-paint","dobetterweb/no-console-time","dobetterweb/no-datenow","dobetterweb/no-document-write","dobetterweb/no-mutation-events","dobetterweb/no-old-flexbox","dobetterweb/no-websql","dobetterweb/notification-on-start","dobetterweb/script-blocking-first-paint","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners"],"aggregations":[{"name":"Progressive Web App","description":"These audits validate the aspects of a Progressive Web App.","id":"pwa_parent","tags":["pwa"],"scored":true,"categorizable":true,"items":[{"name":"App can load on offline/flaky connections","description":"Ensuring your web app can respond when the network connection is unavailable or flaky is critical to providing your users a good experience. This is achieved through use of a [Service Worker](https://developers.google.com/web/fundamentals/primers/service-worker/).","tags":["pwa"],"audits":{"service-worker":{"expectedValue":true,"weight":1},"works-offline":{"expectedValue":true,"weight":1}}},{"name":"Page load performance is fast","description":"Users notice if sites and apps don't perform well. These top-level metrics capture the most important perceived performance concerns.","id":"perf_metrics","tags":["pwa","perf"],"audits":{"first-meaningful-paint":{"expectedValue":100,"weight":1},"speed-index-metric":{"expectedValue":100,"weight":1},"estimated-input-latency":{"expectedValue":100,"weight":1},"time-to-interactive":{"expectedValue":100,"weight":1},"scrolling-60fps":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Content scrolls at 60fps","category":"UX"},"touch-150ms":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Touch input gets a response in < 150ms","category":"UX"},"fmp-no-jank":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"App is interactive without jank after the first meaningful paint","category":"UX"}}},{"name":"Site is progressively enhanced","description":"Progressive enhancement means that everyone can access the basic content and functionality of a page in any browser, and those without certain browser features may receive a reduced but still functional experience.","id":"progressive_enhancement","tags":["pwa"],"audits":{"without-javascript":{"expectedValue":true,"weight":1}}},{"name":"Network connection is secure","description":"Security is an important part of the web for both developers and users. Moving forward, Transport Layer Security (TLS) support will be required for many APIs.","id":"network_security","tags":["pwa"],"audits":{"is-on-https":{"expectedValue":true,"weight":1},"redirects-http":{"expectedValue":true,"weight":1}}},{"name":"User can be prompted to Add to Homescreen","description":"While users can manually add your site to their homescreen in the browser menu, the [prompt (aka app install banner)](https://developers.google.com/web/updates/2015/03/increasing-engagement-with-app-install-banners-in-chrome-for-android) will proactively prompt the user to install the app if the below requirements are met and the user has visited your site at least twice (with at least five minutes between visits).","tags":["pwa"],"id":"a2hs","see":"https://github.com/GoogleChrome/lighthouse/issues/23","audits":{"service-worker":{"expectedValue":true,"weight":1},"manifest-exists":{"expectedValue":true,"weight":1},"manifest-start-url":{"expectedValue":true,"weight":1},"manifest-icons-min-144":{"expectedValue":true,"weight":1},"manifest-short-name":{"expectedValue":true,"weight":1}}},{"name":"Installed web app will launch with custom splash screen","description":"A default splash screen will be constructed, but meeting these requirements guarantee a high-quality and customizable [splash screen](https://developers.google.com/web/updates/2015/10/splashscreen) the user sees between tapping the home screen icon and your app's first paint.","tags":["pwa"],"id":"splash_screen","see":"https://github.com/GoogleChrome/lighthouse/issues/24","audits":{"manifest-exists":{"expectedValue":true,"weight":1},"manifest-name":{"expectedValue":true,"weight":1},"manifest-background-color":{"expectedValue":true,"weight":1},"manifest-theme-color":{"expectedValue":true,"weight":1},"manifest-icons-min-192":{"expectedValue":true,"weight":1}}},{"name":"Address bar matches brand colors","description":"The browser address bar can be themed to match your site. A `theme-color` [meta tag](https://developers.google.com/web/updates/2014/11/Support-for-theme-color-in-Chrome-39-for-Android) will upgrade the address bar when a user browses the site, and the [manifest theme-color](https://developers.google.com/web/updates/2015/08/using-manifest-to-set-sitewide-theme-color) will apply the same theme site-wide once it's been added to homescreen.","tags":["pwa"],"id":"omnibox","audits":{"manifest-exists":{"expectedValue":true,"weight":1},"theme-color-meta":{"expectedValue":true,"weight":1},"manifest-theme-color":{"expectedValue":true,"weight":1}}},{"name":"Design is mobile-friendly","description":"Users increasingly experience your app on mobile devices, so it's important to ensure that the experience can adapt to smaller screens.","id":"mobile_friendly","tags":["pwa"],"audits":{"viewport":{"expectedValue":true,"weight":1},"content-width":{"expectedValue":true,"weight":1}}}]},{"name":"Best Practices","description":"We've compiled some recommendations for modernizing your web app and avoiding performance pitfalls. These audits do not affect your score but are worth a look.","id":"best_practices_parent","tags":["best_practices"],"scored":false,"categorizable":true,"items":[{"name":"Using modern offline features","id":"modern_offline","tags":["best_practices"],"audits":{"appcache-manifest":{"expectedValue":false},"no-websql":{"expectedValue":false}}},{"name":"Using modern protocols","id":"modern_network","tags":["best_practices"],"audits":{"is-on-https":{"expectedValue":false},"uses-http2":{"expectedValue":false,"description":"Resources made by this application should be severed over HTTP/2 for improved performance."}}},{"name":"Using bytes efficiently","id":"byte_efficiency","tags":["best_practices"],"audits":{"unused-css-rules":{"expectedValue":false}}},{"name":"Using modern CSS features","id":"modern_css","tags":["best_practices"],"audits":{"no-old-flexbox":{"expectedValue":false}}},{"name":"Using modern JavaScript features","id":"modern_js","tags":["best_practices"],"audits":{"uses-passive-event-listeners":{"expectedValue":true},"no-mutation-events":{"expectedValue":false}}},{"name":"Avoiding APIs that harm the user experience","id":"ux_harmful_apis","tags":["best_practices"],"audits":{"no-document-write":{"expectedValue":false},"link-blocking-first-paint":{"expectedValue":false},"script-blocking-first-paint":{"expectedValue":false},"external-anchors-use-rel-noopener":{"expectedValue":true},"geolocation-on-start":{"expectedValue":false},"notification-on-start":{"expectedValue":false}}},{"name":"Accessibility","id":"a11y","tags":["best_practices"],"audits":{"aria-allowed-attr":{"expectedValue":true,"weight":1},"aria-required-attr":{"expectedValue":true,"weight":1},"aria-valid-attr":{"expectedValue":true,"weight":1},"aria-valid-attr-value":{"expectedValue":true,"weight":1},"color-contrast":{"expectedValue":true,"weight":1},"image-alt":{"expectedValue":true,"weight":1},"label":{"expectedValue":true,"weight":1},"tabindex":{"expectedValue":true,"weight":1}}},{"name":"Other","id":"other_best_practices","tags":["best_practices"],"audits":{"manifest-short-name-length":{"expectedValue":true,"weight":1},"manifest-display":{"expectedValue":true,"weight":1},"serviceworker-push":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Service worker makes use of push notifications, if appropriate","category":"UX"},"tap-targets":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Tap targets are appropriately sized for touch","category":"UX"},"payments-autocomplete":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Payment forms marked up with `autocomplete` attributes","category":"UX"},"login-autocomplete":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Login forms marked up with `autocomplete` attributes","category":"UX"},"input-type":{"expectedValue":true,"weight":0,"comingSoon":true,"description":"Input fields use appropriate `type` attributes for custom keyboards","category":"UX"}}}]},{"name":"Performance Metrics","description":"These encapsulate your app's performance.","id":"perf_diagnostics","tags":["perf"],"scored":false,"categorizable":false,"items":[{"audits":{"critical-request-chains":{"expectedValue":0,"weight":1},"user-timings":{"expectedValue":0,"weight":1}}}]},{"name":"Fancier stuff","description":"A list of newer features that you could be using in your app. These audits do not affect your score and are just suggestions.","id":"fancy_best_practices","tags":["best_practices"],"scored":false,"categorizable":true,"items":[{"name":"New JavaScript features","audits":{"no-datenow":{"expectedValue":false},"no-console-time":{"expectedValue":false}}}]}]}},{}],6:[function(require,module,exports){'use strict';const path=require('path');const Formatter=require('./formatter');const html="<details class=\"subitem__details\">\n  <summary class=\"subitem__detail\">\n    {{#if (gt this.nodes.length 1)}}\n      {{this.nodes.length}} elements fail this test\n    {{else}}\n      {{this.nodes.length}} element fails this test\n    {{/if}}\n    <a href=\"{{ this.helpUrl }}\" target=\"_blank\"><small>learn more</small></a>\n  </summary>\n  <ul class=\"subitem__details\">\n  {{#each this.nodes}}\n    <li class=\"subitem__detail\"><code>{{ this.target }}</code></li>\n  {{/each}}\n  </ul>\n</details>\n";class Accessibilty extends Formatter{static getFormatter(type){switch(type){case'pretty':return function(info){if(info===null||typeof info==='undefined'||typeof info.impact==='undefined'||typeof info.helpUrl==='undefined'||typeof info.nodes==='undefined'||!Array.isArray(info.nodes)){return'';}
const output=`      - Rating: ${info.impact}\n`+`      - See: ${info.helpUrl}\n`+`      - Nodes: ${info.nodes.length} nodes identified (see HTML output for details)\n`;return output;};case'html':return html;default:throw new Error('Unknown formatter type');}}
static getHelpers(){return{gt(a,b){return a>b;}};}}
module.exports=Accessibilty;},{"./formatter":8,"path":204}],7:[function(require,module,exports){(function(process){'use strict';const URL=require('../lib/url-shim');const path=require('path');const Formatter=require('./formatter');const html="<style>\n.tree-marker {\n  width: 12px;\n  height: 26px;\n  display: block;\n  float: left;\n  background-position: top left;\n}\n\n.horiz-down {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPmhvcml6LWRvd248L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0iaG9yaXotZG93biIgZmlsbD0iI0Q4RDhEOCI+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM4IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSg3LjAwMDAwMCwgMTMuMDAwMDAwKSByb3RhdGUoLTI3MC4wMDAwMDApIHRyYW5zbGF0ZSgtNy4wMDAwMDAsIC0xMy4wMDAwMDApICIgeD0iNiIgeT0iNCIgd2lkdGg9IjIiIGhlaWdodD0iMTgiPjwvcmVjdD4KICAgICAgICAgICAgPHJlY3QgaWQ9IlJlY3RhbmdsZS0xMzkiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDguMDAwMDAwLCAxOS4wMDAwMDApIHJvdGF0ZSgtMjcwLjAwMDAwMCkgdHJhbnNsYXRlKC04LjAwMDAwMCwgLTE5LjAwMDAwMCkgIiB4PSIxIiB5PSIxOCIgd2lkdGg9IjE0IiBoZWlnaHQ9IjIiPjwvcmVjdD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==');\n}\n\n.right {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnJpZ2h0PC90aXRsZT4KICAgIDxkZXNjPkNyZWF0ZWQgd2l0aCBTa2V0Y2guPC9kZXNjPgogICAgPGRlZnM+PC9kZWZzPgogICAgPGcgaWQ9IlBhZ2UtMSIgc3Ryb2tlPSJub25lIiBzdHJva2Utd2lkdGg9IjEiIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+CiAgICAgICAgPGcgaWQ9InJpZ2h0IiBmaWxsPSIjRDhEOEQ4Ij4KICAgICAgICAgICAgPHJlY3QgaWQ9IlJlY3RhbmdsZS0xMzgiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDguMDAwMDAwLCAxMy4wMDAwMDApIHJvdGF0ZSgtMjcwLjAwMDAwMCkgdHJhbnNsYXRlKC04LjAwMDAwMCwgLTEzLjAwMDAwMCkgIiB4PSI3IiB5PSI1IiB3aWR0aD0iMiIgaGVpZ2h0PSIxNiI+PC9yZWN0PgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+');\n}\n\n.up-right {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnVwLXJpZ2h0PC90aXRsZT4KICAgIDxkZXNjPkNyZWF0ZWQgd2l0aCBTa2V0Y2guPC9kZXNjPgogICAgPGRlZnM+PC9kZWZzPgogICAgPGcgaWQ9IlBhZ2UtMSIgc3Ryb2tlPSJub25lIiBzdHJva2Utd2lkdGg9IjEiIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+CiAgICAgICAgPGcgaWQ9InVwLXJpZ2h0IiBmaWxsPSIjRDhEOEQ4Ij4KICAgICAgICAgICAgPHJlY3QgaWQ9IlJlY3RhbmdsZS0xMzgiIHg9IjciIHk9IjAiIHdpZHRoPSIyIiBoZWlnaHQ9IjE0Ij48L3JlY3Q+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM5IiB4PSI5IiB5PSIxMiIgd2lkdGg9IjciIGhlaWdodD0iMiI+PC9yZWN0PgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+');\n}\n\n.vert-right {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnZlcnQtcmlnaHQ8L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0idmVydC1yaWdodCIgZmlsbD0iI0Q4RDhEOCI+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM4IiB4PSI3IiB5PSIwIiB3aWR0aD0iMiIgaGVpZ2h0PSIyNyI+PC9yZWN0PgogICAgICAgICAgICA8cmVjdCBpZD0iUmVjdGFuZ2xlLTEzOSIgeD0iOSIgeT0iMTIiIHdpZHRoPSI3IiBoZWlnaHQ9IjIiPjwvcmVjdD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==');\n}\n\n.vert {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnZlcnQ8L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0idmVydCIgZmlsbD0iI0Q4RDhEOCI+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM4IiB4PSI3IiB5PSIwIiB3aWR0aD0iMiIgaGVpZ2h0PSIyNiI+PC9yZWN0PgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+');\n}\n\n.space {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMTZweCIgdmlld0JveD0iMCAwIDE2IDE2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPmhvcml6LWRvd248L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0iaG9yaXotZG93biI+PC9nPgogICAgPC9nPgo8L3N2Zz4=');\n}\n\n.cnc-tree {\n  font-size: 14px;\n  width: 100%;\n  overflow-x: auto;\n}\n\n.cnc-node {\n  height: 26px;\n  line-height: 26px;\n  white-space: nowrap;\n}\n\n.cnc-node__tree-value {\n  margin-left: 10px;\n}\n\n.cnc-node__chain-duration {\n  font-weight: bold;\n}\n\n.cnc-node__tree-hostname {\n  color: #999;\n}\n\n</style>\n\n{{#*inline \"writeNode\"}}\n  <div class=\"cnc-node\" title=\"{{ this.node.request.url }}\">\n    <span class=\"cnc-node__tree-marker\">\n    {{#each treeMarkers as |separator| }}\n      {{#separator}}\n      <span class=\"tree-marker vert\"></span>\n      <span class=\"tree-marker space\"></span>\n      {{else}}\n      <span class=\"tree-marker space\"></span>\n      <span class=\"tree-marker space\"></span>\n      {{/separator}}\n    {{/each}}\n    {{#isLastChild}}\n      <span class=\"tree-marker up-right\"></span>\n      <span class=\"tree-marker right\"></span>\n    {{else}}\n      <span class=\"tree-marker vert-right\"></span>\n      <span class=\"tree-marker right\"></span>\n    {{/isLastChild}}\n\n    {{#hasChildren}}\n      <span class=\"tree-marker horiz-down\"></span>\n    {{else}}\n      <span class=\"tree-marker right\"></span>\n    {{/hasChildren}}\n    </span>\n\n    <span class=\"cnc-node__tree-value\">\n      {{#parseURL this.node.request.url }}\n        <span class=\"cnc-node__tree-file\">{{ this.file }}</span>\n        <span class=\"cnc-node__tree-hostname\">({{ this.hostname }})</span>\n      {{/parseURL}}\n      {{#unless hasChildren}}\n        - <span class=\"cnc-node__chain-duration\">{{chainDuration startTime this.node.request.endTime }}ms, {{formatTransferSize this.transferSize}}KB</span>\n      {{/unless}}\n    </span>\n  </div>\n\n  {{#each this.node.children as |child| }}\n    {{#createContextFor ../node.children @key ../treeMarkers ../isLastChild ../startTime ../transferSize }}\n      {{> writeNode this }}\n    {{/createContextFor }}\n  {{/each}}\n{{/inline}}\n\n<ul class=\"subitem__details\">\n  <li class=\"subitem__detail\">Longest request chain (shorter is better): <strong>{{longestChain this}}</strong></li>\n  <li class=\"subitem__detail\">Longest chain duration (shorter is better): <strong>{{formatTime (longestDuration this)}}ms</strong></li>\n  <li class=\"subitem__detail\">Longest chain transfer size (smaller is better): <strong>{{formatTransferSize (longestChainTransferSize this)}}KB</strong></li>\n  <li class=\"subitem__detail\">\n    <div>Initial navigation</div>\n    {{#createTreeRenderContext this}}\n      {{#each this.tree }}\n        {{#createContextFor ../tree @key undefined undefined ../startTime ../transferSize }}\n          {{> writeNode this }}\n        {{/createContextFor}}\n      {{/each}}\n    {{/createTreeRenderContext}}\n  </li>\n</ul>\n";const isWindows=process.platform==='win32';const heavyHorizontal=isWindows?'\u2500':'━';const heavyVertical=isWindows?'\u2502 ':'┃ ';const heavyUpAndRight=isWindows?'\u2514':'┗';const heavyUpAndRightLong=heavyUpAndRight+heavyHorizontal;const heavyVerticalAndRight=isWindows?'\u251C':'┣';const heavyVerticalAndRightLong=heavyVerticalAndRight+heavyHorizontal;const heavyDownAndHorizontal=isWindows?'\u252C':'┳';class CriticalRequestChains extends Formatter{static getFormatter(type){switch(type){case'pretty':return function(info){if(info===null||typeof info==='undefined'){return'';}
const longestChain=CriticalRequestChains._getLongestChainLength(info);const longestDuration=CriticalRequestChains._getLongestChainDuration(info).toFixed(2);const longestTransferSize=CriticalRequestChains.formatTransferSize(CriticalRequestChains._getLongestChainTransferSize(info));const urlTree=CriticalRequestChains._createURLTreeOutput(info);const output=`    - Longest request chain (shorter is better): ${longestChain}\n`+`    - Longest chain duration (shorter is better): ${longestDuration}ms\n`+`    - Longest chain transfer size (smaller is better): ${longestTransferSize}KB\n`+'    - Initial navigation\n'+'      '+urlTree.replace(/\n/g,'\n      ')+'\n';return output;};case'html':return html;default:throw new Error('Unknown formatter type');}}
static _traverse(tree,cb){function walk(node,depth,startTime,transferSize){const children=Object.keys(node);if(children.length===0){return;}
if(!transferSize){transferSize=0;}
children.forEach(id=>{const child=node[id];if(!startTime){startTime=child.request.startTime;}
cb({depth,id,node:child,chainDuration:(child.request.endTime-startTime)*1000,chainTransferSize:(transferSize+child.request.transferSize)});walk(child.children,depth+1,startTime);},'');}
walk(tree,0);}
static _getLongestChainLength(tree){let longestChain=0;this._traverse(tree,opts=>{const depth=opts.depth;if(depth>longestChain){longestChain=depth;}});return(longestChain+1);}
static _getLongestChainDuration(tree){let longestChainDuration=0;this._traverse(tree,opts=>{const duration=opts.chainDuration;if(duration>longestChainDuration){longestChainDuration=duration;}});return longestChainDuration;}
static _getLongestChainTransferSize(tree){let transferSize=0;this._traverse(tree,opts=>{const chainTransferSize=opts.chainTransferSize;if(chainTransferSize>transferSize){transferSize=chainTransferSize;}});return transferSize;}
static _createURLTreeOutput(tree){function write(opts){const node=opts.node;const depth=opts.depth;const treeMarkers=opts.treeMarkers;let startTime=opts.startTime;const transferSize=opts.transferSize;return Object.keys(node).reduce((output,id,currentIndex,arr)=>{const hasChildren=(Object.keys(node[id].children).length>0);const isLastChild=(currentIndex===arr.length-1);const ancestorTreeMarker=treeMarkers.reduce((markers,marker)=>{return markers+(marker?heavyVertical:'  ');},'');const newTreeMakers=treeMarkers.slice(0);newTreeMakers.push(!isLastChild);const treeMarker=ancestorTreeMarker+
(isLastChild?heavyUpAndRightLong:heavyVerticalAndRightLong)+
(hasChildren?heavyDownAndHorizontal:heavyHorizontal);const parsedURL=CriticalRequestChains.parseURL(node[id].request.url);if(!startTime){startTime=node[id].request.startTime;}
const duration=((node[id].request.endTime-startTime)*1000).toFixed(2);const chainTransferSize=transferSize+node[id].request.transferSize;const formattedTransferSize=CriticalRequestChains.formatTransferSize(chainTransferSize);return output+`${treeMarker} ${parsedURL.file} (${parsedURL.hostname})`+
(hasChildren?'':` - ${duration}ms, ${formattedTransferSize}KB`)+'\n'+
write({node:node[id].children,depth:depth+1,treeMarkers:newTreeMakers,startTime,transferSize:chainTransferSize});},'');}
return write({node:tree,depth:0,treeMarkers:[],startTime:0,transferSize:0});}
static formatTime(time){return time.toFixed(2);}
static formatTransferSize(size){return(size/1024).toFixed(2);}
static parseURL(resourceURL,opts){const parsedURL={file:URL.getDisplayName(resourceURL),hostname:new URL(resourceURL).hostname};if(opts){return opts.fn(parsedURL);}
return parsedURL;}
static getHelpers(){return{longestChain(info){return CriticalRequestChains._getLongestChainLength(info);},longestDuration(info){return CriticalRequestChains._getLongestChainDuration(info);},longestChainTransferSize(info){return CriticalRequestChains._getLongestChainTransferSize(info);},chainDuration(startTime,endTime){return((endTime-startTime)*1000).toFixed(2);},formatTransferSize:CriticalRequestChains.formatTransferSize,parseURL:CriticalRequestChains.parseURL,formatTime:CriticalRequestChains.formatTime,createContextFor(parent,id,treeMarkers,parentIsLastChild,startTime,transferSize,opts){const node=parent[id];const siblings=Object.keys(parent);const isLastChild=siblings.indexOf(id)===(siblings.length-1);const hasChildren=Object.keys(node.children).length>0;const newTreeMarkers=Array.isArray(treeMarkers)?treeMarkers.slice(0):[];if(typeof parentIsLastChild!=='undefined'){newTreeMarkers.push(!parentIsLastChild);}
return opts.fn({node,isLastChild,hasChildren,startTime,transferSize:(transferSize+node.request.transferSize),treeMarkers:newTreeMarkers});},createTreeRenderContext(tree,opts){const transferSize=0;let startTime=0;const rootNodes=Object.keys(tree);if(rootNodes.length>0){startTime=tree[rootNodes[0]].request.startTime;}
return opts.fn({tree,startTime,transferSize});}};}}
module.exports=CriticalRequestChains;}).call(this,require('_process'))},{"../lib/url-shim":30,"./formatter":8,"_process":205,"path":204}],8:[function(require,module,exports){'use strict';class Formatter{static get CAPITAL_LETTERS(){return/([A-Z])/g;}
static get SUPPORTED_FORMATS(){if(!this._formatters){this._getFormatters();}
if(!this._supportedFormatsNames){this._generateSupportedFormats();}
return this._supportedFormatsNames;}
static _getFormatters(){this._formatters={accessibility:require('./accessibility'),criticalRequestChains:require('./critical-request-chains'),urllist:require('./url-list'),null:require('./null-formatter'),speedline:require('./speedline-formatter'),userTimings:require('./user-timings')};}
static _generateSupportedFormats(){const formatNames=Object.keys(this._formatters);this._supportedFormatsNames=formatNames.reduce((prev,format)=>{const formatName=format.replace(Formatter.CAPITAL_LETTERS,'_$1').toUpperCase();prev[formatName]=format;return prev;},{});}
static getByName(name){if(!this._formatters){this._getFormatters();}
if(!this._formatters[name]){throw new Error(`Unknown formatter: ${name}`);}
return this._formatters[name];}
static getFormatter(){throw new Error('Formatter must implement getPrettyFormatter()');}
static getHelpers(){}}
module.exports=Formatter;},{"./accessibility":6,"./critical-request-chains":7,"./null-formatter":9,"./speedline-formatter":10,"./url-list":11,"./user-timings":12}],9:[function(require,module,exports){'use strict';const Formatter=require('./formatter');class NullFormatter extends Formatter{static getFormatter(type){switch(type){case'pretty':return _=>'';case'html':return'';default:throw new Error('Unknown formatter type');}}}
module.exports=NullFormatter;},{"./formatter":8}],10:[function(require,module,exports){'use strict';const Formatter=require('./formatter');const path=require('path');const html="<style>\n  .speedline-measures {\n    font-size: 14px\n  }\n</style>\n\n<ul class=\"subitem__details\">\n  <li class=\"subitem__detail\">First Visual Change: <strong>{{this.first}}ms</strong></li>\n  <li class=\"subitem__detail\">Last Visual Change: <strong>{{this.complete}}ms</strong></li>\n</ul>\n";class SpeedlineFormatter extends Formatter{static getFormatter(type){switch(type){case'pretty':return function(info){if(!info||!Array.isArray(info.frames)){return'';}
const output=`    - First Visual Change: ${info.first}ms\n`+`    - Last Visual Change: ${info.complete}ms\n`;return output;};case'html':return html;default:throw new Error('Unknown formatter type');}}}
module.exports=SpeedlineFormatter;},{"./formatter":8,"path":204}],11:[function(require,module,exports){'use strict';const Formatter=require('./formatter');const path=require('path');const html="<style>\n  .http-resource__protocol,\n  .http-resource__code {\n    color: var(--secondary-text-color);\n  }\n  .http-resource__code {\n    text-overflow: ellipsis;\n    overflow: hidden;\n    white-space: pre-line;\n  }\n</style>\n\n<details class=\"subitem__details\">\n  <summary class=\"subitem__detail\">URLs</summary>\n  <ul class=\"subitem__details\">\n  {{#each this}}\n    <li class=\"subitem__detail http-resource\">\n      <span class=\"http-resource__url\">{{this.url}}</span>\n      {{#if this.label}}\n        <span class=\"http-resource__protocol\">({{this.label}})</span>\n      {{/if}}\n      {{#if this.code}}\n        <pre class=\"http-resource__code\">{{this.code}}</pre>\n      {{/if}}\n    </li>\n  {{/each}}\n  </ul>\n</details>\n";class UrlList extends Formatter{static getFormatter(type){switch(type){case'pretty':return resources=>{if(!Array.isArray(resources)){return'';}
let output='';resources.forEach(resource=>{output+=`      ${resource.url}`;if(resource.label){output+=` (${resource.label})`;}
output+='\n';});return output;};case'html':return html;default:throw new Error('Unknown formatter type');}}}
module.exports=UrlList;},{"./formatter":8,"path":204}],12:[function(require,module,exports){'use strict';const Formatter=require('./formatter');const path=require('path');const html="<style>\n  .ut-measure_listing-duration {\n    font-weight: bold\n  }\n</style>\n\n<ul class=\"subitem__details\">\n  {{#each this}}\n    <li class=\"subitem__detail\">\n      {{#if this.isMark}}\n        <strong class=\"ut-measure_listing-duration\">Mark: {{ decimal this.startTime }}ms</strong> - {{ this.name }}\n      {{else}}\n        <strong class=\"ut-measure_listing-duration\">Measure {{ decimal this.duration }}ms</strong> - {{ this.name }}\n      {{/if}}\n    </li>\n  {{/each}}\n</ul>\n";class UserTimings extends Formatter{static getFormatter(type){switch(type){case'pretty':return events=>{if(!Array.isArray(events)){return'';}
const measuresStr=events.filter(e=>!e.isMark).reduce((prev,event)=>{let output=prev+`    - measure ${event.name}: \t`;output+=`duration: ${event.duration.toFixed(1)}ms,\t`;output+=`start: ${event.startTime.toFixed(1)}ms,\tend: ${event.endTime.toFixed(1)}`;return output+'\n';},'');const marksStr=events.filter(e=>e.isMark).reduce((prev,event)=>{return prev+`    - mark ${event.name}: \t time: ${event.startTime.toFixed(1)}ms\n`;},'');return measuresStr+marksStr;};case'html':return html;default:throw new Error('Unknown formatter type');}}}
module.exports=UserTimings;},{"./formatter":8,"path":204}],13:[function(require,module,exports){'use strict';const EventEmitter=require('events').EventEmitter;const log=require('../../lib/log.js');class Connection{constructor(){this._lastCommandId=0;this._callbacks=new Map();this._eventEmitter=new EventEmitter();}
connect(){return Promise.reject(new Error('Not implemented'));}
disconnect(){return Promise.reject(new Error('Not implemented'));}
sendCommand(method,params){log.formatProtocol('method => browser',{method,params},'verbose');const id=++this._lastCommandId;params=params||{};const message=JSON.stringify({id,method,params});this.sendRawMessage(message);return new Promise((resolve,reject)=>{this._callbacks.set(id,{resolve,reject,method});});}
on(eventName,cb){if(eventName!=='notification'){throw new Error('Only supports "notification" events');}
this._eventEmitter.on(eventName,cb);}
sendRawMessage(message){return Promise.reject(new Error('Not implemented'));}
handleRawMessage(message){const object=JSON.parse(message);if(object.id){const callback=this._callbacks.get(object.id);this._callbacks.delete(object.id);return callback.resolve(Promise.resolve().then(_=>{if(object.error){return this.handleRawError(object.error,callback.method);}
log.formatProtocol('method <= browser OK',{method:callback.method,params:object.result},'verbose');return object.result;}));}
log.formatProtocol('<= event',{method:object.method,params:object.params},'verbose');this.emitNotification(object.method,object.params);}
handleRawError(error,method){if(error.message&&error.message.includes('DOM agent hasn\'t been enabled')){return;}
log.formatProtocol('method <= browser ERR',{method},'error');throw new Error(`Protocol error (${method}): ${error.message}`);}
emitNotification(method,params){this._eventEmitter.emit('notification',{method,params});}
dispose(){this._eventEmitter.removeAllListeners();this._eventEmitter=null;}}
module.exports=Connection;},{"../../lib/log.js":24,"events":201}],14:[function(require,module,exports){'use strict';const Connection=require('./connection.js');const log=require('../../lib/log.js');class ExtensionConnection extends Connection{constructor(){super();this._tabId=null;this._onEvent=this._onEvent.bind(this);this._onUnexpectedDetach=this._onUnexpectedDetach.bind(this);}
_onEvent(source,method,params){log.log('<=',method,params);this.emitNotification(method,params);}
_onUnexpectedDetach(debuggee,detachReason){this._detachCleanup();throw new Error('Lighthouse detached from browser: '+detachReason);}
_detachCleanup(){this._tabId=null;chrome.debugger.onEvent.removeListener(this._onEvent);chrome.debugger.onDetach.removeListener(this._onUnexpectedDetach);this.dispose();}
connect(){if(this._tabId!==null){return Promise.resolve();}
return this._queryCurrentTab().then(tab=>{const tabId=this._tabId=tab.id;chrome.debugger.onEvent.addListener(this._onEvent);chrome.debugger.onDetach.addListener(this._onUnexpectedDetach);return new Promise((resolve,reject)=>{chrome.debugger.attach({tabId},'1.1',_=>{if(chrome.runtime.lastError){return reject(new Error(chrome.runtime.lastError.message));}
resolve(tabId);});});});}
disconnect(){if(this._tabId===null){log.warn('ExtensionConnection','disconnect() was called without an established connection.');return Promise.resolve();}
const tabId=this._tabId;return new Promise((resolve,reject)=>{chrome.debugger.detach({tabId},_=>{if(chrome.runtime.lastError){return reject(new Error(chrome.runtime.lastError.message));}
chrome.tabs.reload(tabId);resolve();});}).then(_=>this._detachCleanup());}
sendCommand(command,params){return new Promise((resolve,reject)=>{log.formatProtocol('method => browser',{method:command,params:params},'verbose');if(!this._tabId){log.error('ExtensionConnection','No tabId set for sendCommand');}
chrome.debugger.sendCommand({tabId:this._tabId},command,params,result=>{if(chrome.runtime.lastError){const message=chrome.runtime.lastError.message;let error;try{error=JSON.parse(message);}catch(e){}
error=error||{message:'Unknown debugger protocol error.'};try{return resolve(this.handleRawError(error,command));}catch(err){return reject(err);}}
log.formatProtocol('method <= browser OK',{method:command,params:result},'verbose');resolve(result);});});}
_queryCurrentTab(){return new Promise((resolve,reject)=>{const queryOpts={active:true,lastFocusedWindow:true,windowType:'normal'};chrome.tabs.query(queryOpts,(tabs=>{if(chrome.runtime.lastError){return reject(chrome.runtime.lastError);}
if(tabs.length===0){const message='Couldn\'t resolve current tab. Please file a bug.';return reject(new Error(message));}
resolve(tabs[0]);}));});}
getCurrentTabURL(){return this._queryCurrentTab().then(tab=>tab.url);}}
module.exports=ExtensionConnection;},{"../../lib/log.js":24,"./connection.js":13}],15:[function(require,module,exports){'use strict';const Connection=require('./connection.js');class Port{on(eventName,cb){}
send(message){}
close(){}}
class RawConnection extends Connection{constructor(port){super();this._port=port;this._port.on('message',this.handleRawMessage.bind(this));this._port.on('close',this.dispose.bind(this));}
connect(){return Promise.resolve();}
disconnect(){this._port.close();return Promise.resolve();}
sendRawMessage(message){this._port.send(message);}}
module.exports=RawConnection;},{"./connection.js":13}],16:[function(require,module,exports){'use strict';const NetworkRecorder=require('../lib/network-recorder');const emulation=require('../lib/emulation');const Element=require('../lib/element');const EventEmitter=require('events').EventEmitter;const URL=require('../lib/url-shim');const log=require('../lib/log.js');const MAX_WAIT_FOR_FULLY_LOADED=25*1000;const PAUSE_AFTER_LOAD=500;class Driver{constructor(connection){this._traceEvents=[];this._traceCategories=Driver.traceCategories;this._eventEmitter=new EventEmitter();this._connection=connection;this.online=true;connection.on('notification',event=>this._eventEmitter.emit(event.method,event.params));}
static get traceCategories(){return['-*','toplevel','blink.console','blink.user_timing','benchmark','latencyInfo','devtools.timeline','disabled-by-default-devtools.timeline','disabled-by-default-devtools.timeline.frame','disabled-by-default-devtools.timeline.stack','disabled-by-default-devtools.screenshot'];}
connect(){return this._connection.connect();}
disconnect(){return this._connection.disconnect();}
on(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen for event =>',{method:eventName},'verbose');this._eventEmitter.on(eventName,cb);}
once(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen once for event =>',{method:eventName},'verbose');this._eventEmitter.once(eventName,cb);}
off(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to remove an event listener.');}
this._eventEmitter.removeListener(eventName,cb);}
sendCommand(method,params){return this._connection.sendCommand(method,params);}
evaluateScriptOnLoad(scriptSource){return this.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource});}
evaluateAsync(expression){return new Promise((resolve,reject)=>{const asyncTimeout=setTimeout((_=>reject(new Error('The asynchronous expression exceeded the allotted time of 60s'))),60000);this.sendCommand('Runtime.evaluate',{expression:`(function wrapInNativePromise() {
          const __nativePromise = window.__nativePromise || Promise;
          return new __nativePromise(function (resolve) {
            return __nativePromise.resolve()
              .then(_ => ${expression})
              .catch(${wrapRuntimeEvalErrorInBrowser.toString()})
              .then(resolve);
          });
        }())`,includeCommandLineAPI:true,awaitPromise:true,returnByValue:true}).then(result=>{clearTimeout(asyncTimeout);const value=result.result.value;if(result.exceptionDetails){reject(new Error('an unexpected driver error occurred'));}if(value&&value.__failedInBrowser){reject(Object.assign(new Error(),value));}else{resolve(value);}}).catch(err=>{clearTimeout(asyncTimeout);reject(err);});});}
getSecurityState(){return new Promise((resolve,reject)=>{this.once('Security.securityStateChanged',data=>{this.sendCommand('Security.disable').then(_=>resolve(data),reject);});this.sendCommand('Security.enable').catch(reject);});}
getServiceWorkerVersions(){return new Promise((resolve,reject)=>{this.once('ServiceWorker.workerVersionUpdated',data=>{this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);});this.sendCommand('ServiceWorker.enable').catch(reject);});}
getServiceWorkerRegistrations(){return new Promise((resolve,reject)=>{this.once('ServiceWorker.workerRegistrationUpdated',data=>{this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);});this.sendCommand('ServiceWorker.enable').catch(reject);});}
assertNoSameOriginServiceWorkerClients(pageUrl){let registrations;let versions;return this.getServiceWorkerRegistrations().then(data=>{registrations=data.registrations;}).then(_=>this.getServiceWorkerVersions()).then(data=>{versions=data.versions;}).then(_=>{const origin=new URL(pageUrl).origin;registrations.filter(reg=>{const swOrigin=new URL(reg.scopeURL).origin;return origin===swOrigin;}).forEach(reg=>{versions.forEach(ver=>{if(ver.registrationId!==reg.registrationId){return;}
if(ver.controlledClients&&ver.controlledClients.length>0){throw new Error('You probably have multiple tabs open to the same origin.');}});});});}
enableUrlUpdateIfRedirected(opts){this._networkRecorder.on('requestloaded',redirectRequest=>{if(!redirectRequest.redirectSource){return;}
const earlierRequest=redirectRequest.redirectSource;if(earlierRequest.url===opts.url){opts.url=redirectRequest.url;}});}
_waitForNetworkIdle(pauseAfterLoadMs){let idleTimeout;let cancel;const promise=new Promise((resolve,reject)=>{const onIdle=()=>{this._networkRecorder.once('networkbusy',onBusy);idleTimeout=setTimeout(_=>{cancel();resolve();},pauseAfterLoadMs);};const onBusy=()=>{this._networkRecorder.once('networkidle',onIdle);clearTimeout(idleTimeout);};cancel=()=>{clearTimeout(idleTimeout);this._networkRecorder.removeListener('networkbusy',onBusy);this._networkRecorder.removeListener('networkidle',onIdle);};if(this._networkRecorder.isIdle()){onIdle();}else{onBusy();}});return{promise,cancel};}
_waitForLoadEvent(pauseAfterLoadMs){let loadListener;let loadTimeout;const promise=new Promise((resolve,reject)=>{loadListener=function(){loadTimeout=setTimeout(resolve,pauseAfterLoadMs);};this.once('Page.loadEventFired',loadListener);});const cancel=()=>{this.off('Page.loadEventFired',loadListener);clearTimeout(loadTimeout);};return{promise,cancel};}
_waitForFullyLoaded(pauseAfterLoadMs){let maxTimeoutHandle;const waitForLoadEvent=this._waitForLoadEvent(pauseAfterLoadMs);const waitForNetworkIdle=this._waitForNetworkIdle(pauseAfterLoadMs);const loadPromise=Promise.all([waitForLoadEvent.promise,waitForNetworkIdle.promise]).then(_=>{return function(){log.verbose('Driver','loadEventFired and network considered idle');clearTimeout(maxTimeoutHandle);};});const maxTimeoutPromise=new Promise((resolve,reject)=>{maxTimeoutHandle=setTimeout(resolve,MAX_WAIT_FOR_FULLY_LOADED);}).then(_=>{return function(){log.warn('Driver','Timed out waiting for page load. Moving on...');waitForLoadEvent.cancel();waitForNetworkIdle.cancel();};});return Promise.race([loadPromise,maxTimeoutPromise]).then(cleanup=>cleanup());}
gotoURL(url,options){const _options=options||{};const waitForLoad=_options.waitForLoad||false;const disableJS=_options.disableJavaScript||false;const pauseAfterLoadMs=(_options.flags&&_options.flags.pauseAfterLoad)||PAUSE_AFTER_LOAD;return this.sendCommand('Page.enable').then(_=>this.sendCommand('Emulation.setScriptExecutionDisabled',{value:disableJS})).then(_=>this.sendCommand('Page.navigate',{url})).then(_=>waitForLoad&&this._waitForFullyLoaded(pauseAfterLoadMs));}
getObjectProperty(objectId,propName){return new Promise((resolve,reject)=>{this.sendCommand('Runtime.getProperties',{objectId,accessorPropertiesOnly:true,generatePreview:false,ownProperties:false,}).then(properties=>{const propertyForName=properties.result.find(property=>property.name===propName);if(propertyForName){resolve(propertyForName.value.value);}else{reject(null);}});});}
queryPermissionState(name){const expressionToEval=`
      navigator.permissions.query({name: '${name}'}).then(result => {
        return result.state;
      })
    `;return this.evaluateAsync(expressionToEval);}
querySelector(selector){return this.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>this.sendCommand('DOM.querySelector',{nodeId,selector})).then(element=>{if(element.nodeId===0){return null;}
return new Element(element,this);});}
querySelectorAll(selector){return this.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>this.sendCommand('DOM.querySelectorAll',{nodeId,selector})).then(nodeList=>{const elementList=[];nodeList.nodeIds.forEach(nodeId=>{if(nodeId!==0){elementList.push(new Element({nodeId},this));}});return elementList;});}
beginTrace(){const tracingOpts={categories:this._traceCategories.join(','),transferMode:'ReturnAsStream',options:'sampling-frequency=10000'};return this.sendCommand('Debugger.disable').then(_=>this.sendCommand('CSS.disable')).then(_=>this.sendCommand('DOM.disable')).then(_=>this.sendCommand('Page.enable')).then(_=>this.sendCommand('Tracing.start',tracingOpts));}
endTrace(){return new Promise((resolve,reject)=>{this.once('Tracing.tracingComplete',streamHandle=>{this._readTraceFromStream(streamHandle).then(traceContents=>resolve(traceContents),reject);});this.sendCommand('Tracing.end').catch(reject);});}
_readTraceFromStream(streamHandle){return new Promise((resolve,reject)=>{let isEOF=false;let result='';const readArguments={handle:streamHandle.stream};const onChunkRead=response=>{if(isEOF){return;}
result+=response.data;if(response.eof){isEOF=true;return resolve(JSON.parse(result));}
return this.sendCommand('IO.read',readArguments).then(onChunkRead);};this.sendCommand('IO.read',readArguments).then(onChunkRead).catch(reject);});}
beginNetworkCollect(opts){return new Promise((resolve,reject)=>{this._networkRecords=[];this._networkRecorder=new NetworkRecorder(this._networkRecords);this.enableUrlUpdateIfRedirected(opts);this.on('Network.requestWillBeSent',this._networkRecorder.onRequestWillBeSent);this.on('Network.requestServedFromCache',this._networkRecorder.onRequestServedFromCache);this.on('Network.responseReceived',this._networkRecorder.onResponseReceived);this.on('Network.dataReceived',this._networkRecorder.onDataReceived);this.on('Network.loadingFinished',this._networkRecorder.onLoadingFinished);this.on('Network.loadingFailed',this._networkRecorder.onLoadingFailed);this.on('Network.resourceChangedPriority',this._networkRecorder.onResourceChangedPriority);this.sendCommand('Network.enable').then(resolve,reject);});}
endNetworkCollect(){return new Promise((resolve,reject)=>{this.off('Network.requestWillBeSent',this._networkRecorder.onRequestWillBeSent);this.off('Network.requestServedFromCache',this._networkRecorder.onRequestServedFromCache);this.off('Network.responseReceived',this._networkRecorder.onResponseReceived);this.off('Network.dataReceived',this._networkRecorder.onDataReceived);this.off('Network.loadingFinished',this._networkRecorder.onLoadingFinished);this.off('Network.loadingFailed',this._networkRecorder.onLoadingFailed);this.off('Network.resourceChangedPriority',this._networkRecorder.onResourceChangedPriority);resolve(this._networkRecords);this._networkRecorder=null;this._networkRecords=[];});}
enableRuntimeEvents(){return this.sendCommand('Runtime.enable');}
beginEmulation(flags){const emulations=[];if(!flags.disableDeviceEmulation){emulations.push(emulation.enableNexus5X(this));}
if(!flags.disableNetworkThrottling){emulations.push(emulation.enableNetworkThrottling(this));}
if(!flags.disableCpuThrottling){emulations.push(emulation.enableCPUThrottling(this));}
return Promise.all(emulations);}
goOffline(){return this.sendCommand('Network.enable').then(_=>{return emulation.goOffline(this);}).then(_=>{this.online=false;});}
goOnline(options){return this.sendCommand('Network.enable').then(_=>{if(!options.flags.disableNetworkThrottling){return emulation.enableNetworkThrottling(this);}
return emulation.disableNetworkThrottling(this);}).then(_=>{this.online=true;});}
cleanAndDisableBrowserCaches(){return Promise.all([this.clearBrowserCache(),this.disableBrowserCache()]);}
clearBrowserCache(){return this.sendCommand('Network.clearBrowserCache');}
disableBrowserCache(){return this.sendCommand('Network.setCacheDisabled',{cacheDisabled:true});}
clearDataForOrigin(url){const origin=new URL(url).origin;const typesToClear=['appcache','file_systems','indexeddb','local_storage','shader_cache','websql','service_workers','cache_storage'].join(',');return this.sendCommand('Storage.clearDataForOrigin',{origin:origin,storageTypes:typesToClear});}
cacheNatives(){return this.evaluateScriptOnLoad(`window.__nativePromise = Promise;
        window.__nativeError = Error;`);}
captureFunctionCallSites(funcName){const globalVarToPopulate=`window['__${funcName}StackTraces']`;const collectUsage=()=>{return this.evaluateAsync(`Promise.resolve(Array.from(${globalVarToPopulate}).map(item => JSON.parse(item)))`).then(result=>{if(!Array.isArray(result)){throw new Error('Driver failure: Expected evaluateAsync results to be an array '+`but got "${JSON.stringify(result)}" instead.`);}
return result.filter(item=>!item.isExtension);});};const funcBody=captureJSCallUsage.toString();this.evaluateScriptOnLoad(`
        ${globalVarToPopulate} = new Set();
        (${funcName} = ${funcBody}(${funcName}, ${globalVarToPopulate}))`);return collectUsage;}
blockUrlPatterns(urlPatterns){const promiseArr=urlPatterns.map(url=>this.sendCommand('Network.addBlockedURL',{url}));return Promise.all(promiseArr);}}
function captureJSCallUsage(funcRef,set){const __nativeError=window.__nativeError||Error;const originalFunc=funcRef;const originalPrepareStackTrace=__nativeError.prepareStackTrace;return function(){const args=[...arguments];__nativeError.prepareStackTrace=function(error,structStackTrace){const callFrame=structStackTrace[1];let url=callFrame.getFileName()||callFrame.getEvalOrigin();const line=callFrame.getLineNumber();const col=callFrame.getColumnNumber();const isEval=callFrame.isEval();let isExtension=false;const stackTrace=structStackTrace.slice(1).map(callsite=>callsite.toString());if(isEval){url=stackTrace[1];}
if(stackTrace[0].startsWith('<anonymous>')){url=stackTrace[0];isExtension=true;}
return{url,args,line,col,isEval,isExtension};};const e=new __nativeError(`__called ${funcRef.name}__`);set.add(JSON.stringify(e.stack));__nativeError.prepareStackTrace=originalPrepareStackTrace;return originalFunc.apply(this,arguments);};}
function wrapRuntimeEvalErrorInBrowser(err){err=err||new Error();const fallbackMessage=typeof err==='string'?err:'unknown error';return{__failedInBrowser:true,name:err.name||'Error',message:err.message||fallbackMessage,stack:err.stack||(new Error()).stack,};}
module.exports=Driver;},{"../lib/element":20,"../lib/emulation":21,"../lib/log.js":24,"../lib/network-recorder":26,"../lib/url-shim":30,"events":201}],17:[function(require,module,exports){'use strict';const log=require('../lib/log.js');const Audit=require('../audits/audit');const path=require('path');class GatherRunner{static loadBlank(driver){return driver.gotoURL('about:blank').then(_=>new Promise((resolve,reject)=>setTimeout(resolve,300)));}
static loadPage(driver,options){return Promise.resolve().then(_=>options.config.recordTrace&&driver.beginTrace()).then(_=>driver.beginNetworkCollect(options)).then(_=>driver.gotoURL(options.url,{waitForLoad:true,disableJavaScript:!!options.disableJavaScript,flags:options.flags,}));}
static setupDriver(driver,options){log.log('status','Initializing…');return driver.assertNoSameOriginServiceWorkerClients(options.url).then(_=>driver.beginEmulation(options.flags)).then(_=>driver.enableRuntimeEvents()).then(_=>driver.cacheNatives()).then(_=>driver.cleanAndDisableBrowserCaches()).then(_=>driver.clearDataForOrigin(options.url)).then(_=>driver.blockUrlPatterns(options.flags.blockedUrlPatterns||[]));}
static disposeDriver(driver){log.log('status','Disconnecting from browser...');driver.disconnect();}
static recoverOrThrow(promise){return promise.catch(err=>{if(!err.recoverable){throw err;}});}
static beforePass(options,gathererResults){const pass=GatherRunner.loadBlank(options.driver);return options.config.gatherers.reduce((chain,gatherer)=>{return chain.then(_=>{const artifactPromise=Promise.resolve().then(_=>gatherer.beforePass(options));gathererResults[gatherer.name]=[artifactPromise];return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static pass(options,gathererResults){const driver=options.driver;const config=options.config;const gatherers=config.gatherers;const gatherernames=gatherers.map(g=>g.name).join(', ');const status='Loading page & waiting for onload';log.log('status',status,gatherernames);const pass=GatherRunner.loadPage(driver,options).then(_=>{log.log('statusEnd',status);});return gatherers.reduce((chain,gatherer)=>{return chain.then(_=>{const artifactPromise=Promise.resolve().then(_=>gatherer.pass(options));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static afterPass(options,gathererResults){const driver=options.driver;const config=options.config;const gatherers=config.gatherers;const passData={};let pass=Promise.resolve();if(config.recordTrace){pass=pass.then(_=>{log.log('status','Retrieving trace');return driver.endTrace();}).then(traceContents=>{passData.trace=Array.isArray(traceContents)?{traceEvents:traceContents}:traceContents;log.verbose('statusEnd','Retrieving trace');});}
const status='Retrieving network records';pass=pass.then(_=>{log.log('status',status);return driver.endNetworkCollect();}).then(networkRecords=>{const mainRecord=networkRecords.find(record=>record.url===options.url);if(driver.online&&mainRecord.failed){log.error('GatherRunner',mainRecord.localizedFailDescription);const error=new Error(`Unable to load the page: ${mainRecord.localizedFailDescription}`);error.code='PAGE_LOAD_ERROR';return Promise.reject(error);}
config.recordNetwork&&(passData.networkRecords=networkRecords);log.verbose('statusEnd',status);});pass=gatherers.reduce((chain,gatherer)=>{const status=`Retrieving: ${gatherer.name}`;return chain.then(_=>{log.log('status',status);const artifactPromise=Promise.resolve().then(_=>gatherer.afterPass(options,passData));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);}).then(_=>{log.verbose('statusEnd',status);});},pass);return pass.then(_=>passData);}
static collectArtifacts(gathererResults){const artifacts={};return Object.keys(gathererResults).reduce((chain,gathererName)=>{return chain.then(_=>{const phaseResultsPromises=gathererResults[gathererName];return Promise.all(phaseResultsPromises).then(phaseResults=>{const definedResults=phaseResults.filter(element=>element!==undefined);const artifact=definedResults[definedResults.length-1];if(artifact===undefined){throw new Error(`${gathererName} failed to provide an artifact.`);}
artifacts[gathererName]=artifact;},err=>{artifacts[gathererName]=err;});});},Promise.resolve()).then(_=>{return artifacts;});}
static run(passes,options){const driver=options.driver;const tracingData={traces:{},networkRecords:{}};if(typeof options.url!=='string'||options.url.length===0){return Promise.reject(new Error('You must provide a url to the driver'));}
if(typeof options.flags==='undefined'){options.flags={};}
if(typeof options.config==='undefined'){return Promise.reject(new Error('You must provide a config'));}
if(typeof options.flags.disableCpuThrottling==='undefined'){options.flags.disableCpuThrottling=true;}
passes=this.instantiateGatherers(passes,options.config.configDir);const gathererResults={};return driver.connect().then(_=>GatherRunner.loadBlank(driver)).then(_=>GatherRunner.setupDriver(driver,options)).then(_=>{let urlAfterRedirects;return passes.reduce((chain,config,passIndex)=>{const runOptions=Object.assign({},options,{config});return chain.then(_=>GatherRunner.beforePass(runOptions,gathererResults)).then(_=>GatherRunner.pass(runOptions,gathererResults)).then(_=>GatherRunner.afterPass(runOptions,gathererResults)).then(passData=>{const passName=config.passName||Audit.DEFAULT_PASS;config.recordTrace&&(tracingData.traces[passName]=passData.trace);config.recordNetwork&&(tracingData.networkRecords[passName]=passData.networkRecords);if(passIndex===0){urlAfterRedirects=runOptions.url;}});},Promise.resolve()).then(_=>{options.url=urlAfterRedirects;});}).then(_=>GatherRunner.disposeDriver(driver)).then(_=>GatherRunner.collectArtifacts(gathererResults)).then(artifacts=>{const computedArtifacts=this.instantiateComputedArtifacts();Object.assign(artifacts,computedArtifacts,tracingData);return artifacts;}).catch(err=>{GatherRunner.disposeDriver(driver);throw err;});}
static getGathererClass(nameOrGathererClass,configPath){const Runner=require('../runner');const coreList=Runner.getGathererList();let GathererClass;if(typeof nameOrGathererClass==='string'){const name=nameOrGathererClass;const coreGatherer=coreList.find(a=>a===`${name}.js`);let requirePath=`./gatherers/${name}`;if(!coreGatherer){requirePath=Runner.resolvePlugin(name,configPath,'gatherer');}
GathererClass=require(requirePath);this.assertValidGatherer(GathererClass,name);}else{GathererClass=nameOrGathererClass;this.assertValidGatherer(GathererClass);}
return GathererClass;}
static assertValidGatherer(GathererDefinition,gathererName){const gathererInstance=new GathererDefinition();gathererName=gathererName||gathererInstance.name||'gatherer';if(typeof gathererInstance.beforePass!=='function'){throw new Error(`${gathererName} has no beforePass() method.`);}
if(typeof gathererInstance.pass!=='function'){throw new Error(`${gathererName} has no pass() method.`);}
if(typeof gathererInstance.afterPass!=='function'){throw new Error(`${gathererName} has no afterPass() method.`);}}
static instantiateComputedArtifacts(){const computedArtifacts={};["computed-artifact.js","critical-request-chains.js","pushed-requests.js","screenshots.js","speedline.js"].forEach(function(file){file=file.replace(/\.js$/,'');const ArtifactClass=require('./computed/'+file);const artifact=new ArtifactClass();computedArtifacts['request'+artifact.name]=artifact.request.bind(artifact);});return computedArtifacts;}
static instantiateGatherers(passes,rootPath){return passes.map(pass=>{pass.gatherers=pass.gatherers.map(gatherer=>{if(typeof gatherer!=='string'){return gatherer;}
const GathererClass=GatherRunner.getGathererClass(gatherer,rootPath);return new GathererClass();});return pass;});}}
module.exports=GatherRunner;},{"../audits/audit":3,"../lib/log.js":24,"../runner":33,"path":204}],18:[function(require,module,exports){'use strict';class Gatherer{get name(){return this.constructor.name;}
beforePass(options){}
pass(options){}
afterPass(options,loadData){}}
module.exports=Gatherer;},{}],19:[function(require,module,exports){'use strict';const log=require('./log.js');class ConsoleQuieter{static mute(opts){ConsoleQuieter._logs=ConsoleQuieter._logs||[];console.log=function(){ConsoleQuieter._logs.push({type:'log',args:arguments,prefix:opts.prefix});};console.warn=function(){ConsoleQuieter._logs.push({type:'warn',args:arguments,prefix:opts.prefix});};console.error=function(){ConsoleQuieter._logs.push({type:'error',args:arguments,prefix:opts.prefix});};}
static unmuteAndFlush(){console.log=ConsoleQuieter._consolelog;console.warn=ConsoleQuieter._consolewarn;console.error=ConsoleQuieter._consoleerror;ConsoleQuieter._logs.forEach(entry=>{log.verbose(`${entry.prefix}-${entry.type}`,...entry.args);});ConsoleQuieter._logs=[];}}
ConsoleQuieter._consolelog=console.log.bind(console);ConsoleQuieter._consolewarn=console.warn.bind(console);ConsoleQuieter._consoleerror=console.error.bind(console);module.exports=ConsoleQuieter;},{"./log.js":24}],20:[function(require,module,exports){'use strict';class Element{constructor(element,driver){if(!element||!driver){throw Error('Driver and element required to create Element');}
this.driver=driver;this.element=element;}
getAttribute(name){return this.driver.sendCommand('DOM.getAttributes',{nodeId:this.element.nodeId}).then(resp=>{const attrIndex=resp.attributes.indexOf(name);if(attrIndex===-1){return null;}
return resp.attributes[attrIndex+1];});}
getProperty(propName){return this.driver.sendCommand('DOM.resolveNode',{nodeId:this.element.nodeId}).then(resp=>{return this.driver.getObjectProperty(resp.object.objectId,propName);});}}
module.exports=Element;},{}],21:[function(require,module,exports){'use strict';const NEXUS5X_EMULATION_METRICS={mobile:true,screenWidth:412,screenHeight:732,width:412,height:732,positionX:0,positionY:0,scale:1,deviceScaleFactor:2.625,fitWindow:false,screenOrientation:{angle:0,type:'portraitPrimary'}};const NEXUS5X_USERAGENT={userAgent:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5 Build/MRA58N) AppleWebKit/537.36'+'(KHTML, like Gecko) Chrome/52.0.2743.8 Mobile Safari/537.36'};const TYPICAL_MOBILE_THROTTLING_METRICS={latency:150,downloadThroughput:Math.floor(1.6*1024*1024/8),uploadThroughput:Math.floor(750*1024/8),offline:false};const OFFLINE_METRICS={offline:true,latency:0,downloadThroughput:0,uploadThroughput:0};const NO_THROTTLING_METRICS={latency:0,downloadThroughput:0,uploadThroughput:0,offline:false};const NO_CPU_THROTTLE_METRICS={rate:1};const CPU_THROTTLE_METRICS={rate:5};function enableNexus5X(driver){const injectedTouchEventsFunction=function(){const touchEvents=['ontouchstart','ontouchend','ontouchmove','ontouchcancel'];const recepients=[window.__proto__,document.__proto__];for(let i=0;i<touchEvents.length;++i){for(let j=0;j<recepients.length;++j){if(!(touchEvents[i]in recepients[j])){Object.defineProperty(recepients[j],touchEvents[i],{value:null,writable:true,configurable:true,enumerable:true});}}}};return Promise.all([driver.sendCommand('Emulation.setDeviceMetricsOverride',NEXUS5X_EMULATION_METRICS),driver.sendCommand('Network.enable'),driver.sendCommand('Network.setUserAgentOverride',NEXUS5X_USERAGENT),driver.sendCommand('Emulation.setTouchEmulationEnabled',{enabled:true,configuration:'mobile'}),driver.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource:'('+injectedTouchEventsFunction.toString()+')()'})]);}
function enableNetworkThrottling(driver){return driver.sendCommand('Network.emulateNetworkConditions',TYPICAL_MOBILE_THROTTLING_METRICS);}
function disableNetworkThrottling(driver){return driver.sendCommand('Network.emulateNetworkConditions',NO_THROTTLING_METRICS);}
function goOffline(driver){return driver.sendCommand('Network.emulateNetworkConditions',OFFLINE_METRICS);}
function enableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',CPU_THROTTLE_METRICS);}
function disableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',NO_CPU_THROTTLE_METRICS);}
module.exports={enableNexus5X,enableNetworkThrottling,disableNetworkThrottling,enableCPUThrottling,disableCPUThrottling,goOffline};},{}],22:[function(require,module,exports){'use strict';function addFormattedCodeSnippet(listener){const handler=listener.handler?listener.handler.description:'...';const objectName=listener.objectName.toLowerCase().replace('#document','document');return Object.assign({label:`line: ${listener.line}, col: ${listener.col}`,code:`${objectName}.addEventListener('${listener.type}', ${handler})`},listener);}
function groupCodeSnippetsByLocation(listeners){const locToListenersMap=new Map();listeners.forEach(loc=>{const key=JSON.stringify({line:loc.line,col:loc.col,url:loc.url,type:loc.type});if(locToListenersMap.has(key)){locToListenersMap.get(key).push(loc);}else{locToListenersMap.set(key,[loc]);}});const results=[];locToListenersMap.forEach((listenersForLocation,key)=>{const lineColUrlObj=JSON.parse(key);const codeSnippets=listenersForLocation.reduce((prev,loc)=>{return prev+loc.code.trim()+'\n\n';},'');lineColUrlObj.code=codeSnippets;lineColUrlObj.label=listenersForLocation[0].label;results.push(lineColUrlObj);});return results;}
module.exports={addFormattedCodeSnippet,groupCodeSnippetsByLocation};},{}],23:[function(require,module,exports){'use strict';function doExist(manifest){if(!manifest||!manifest.icons){return false;}
if(manifest.icons.value.length===0){return false;}
return true;}
function sizeAtLeast(sizeRequirement,manifest){const iconValues=manifest.icons.value;const nestedSizes=iconValues.map(icon=>icon.value.sizes.value);const flattenedSizes=[].concat(...nestedSizes);return flattenedSizes.filter(size=>typeof size==='string').filter(size=>/\d+x\d+/.test(size)).filter(size=>{const sizeStrs=size.split(/x/i);const sizeNums=[parseFloat(sizeStrs[0]),parseFloat(sizeStrs[1])];const areIconsBigEnough=sizeNums[0]>=sizeRequirement&&sizeNums[1]>=sizeRequirement;const areIconsSquare=sizeNums[0]===sizeNums[1];return areIconsBigEnough&&areIconsSquare;});}
module.exports={doExist,sizeAtLeast};},{}],24:[function(require,module,exports){(function(process){'use strict';const debug=require('debug');const EventEmitter=require('events').EventEmitter;const isWindows=process.platform==='win32';const isBrowser=process.browser;const colors={red:isBrowser?'crimson':1,yellow:isBrowser?'gold':3,cyan:isBrowser?'darkturquoise':6,green:isBrowser?'forestgreen':2,blue:isBrowser?'steelblue':4,magenta:isBrowser?'palevioletred':5};debug.colors=[colors.cyan,colors.green,colors.blue,colors.magenta];class Emitter extends EventEmitter{issueStatus(title,args){if(title==='status'||title==='statusEnd'){this.emit(title,args);}}
issueWarning(args){this.emit('warning',args);}}
const loggersByTitle={};const loggingBufferColumns=25;class Log{static _logToStdErr(title,argsArray){const args=[...argsArray];const log=Log.loggerfn(title);log(...args);}
static loggerfn(title){let log=loggersByTitle[title];if(!log){log=debug(title);loggersByTitle[title]=log;if(title.endsWith('error')){log.color=colors.red;}else if(title.endsWith('warn')){log.color=colors.yellow;}}
return log;}
static setLevel(level){switch(level){case'silent':debug.disable();break;case'verbose':debug.enable('*');break;case'error':debug.enable('*:error');break;default:debug.enable('*, -*:verbose');}}
static formatProtocol(prefix,data,level){const columns=(!process||process.browser)?Infinity:process.stdout.columns;const maxLength=columns-data.method.length-prefix.length-loggingBufferColumns;const snippet=(data.params&&data.method!=='IO.read')?JSON.stringify(data.params).substr(0,maxLength):'';Log._logToStdErr(`${prefix}:${level || ''}`,[data.method,snippet]);}
static log(title){Log.events.issueStatus(title,arguments);return Log._logToStdErr(title,Array.from(arguments).slice(1));}
static warn(title){Log.events.issueWarning(arguments);return Log._logToStdErr(`${title}:warn`,Array.from(arguments).slice(1));}
static error(title){return Log._logToStdErr(`${title}:error`,Array.from(arguments).slice(1));}
static verbose(title){Log.events.issueStatus(title);return Log._logToStdErr(`${title}:verbose`,Array.from(arguments).slice(1));}
static greenify(str){return`${Log.green}${str}${Log.reset}`;}
static redify(str){return`${Log.red}${str}${Log.reset}`;}
static get green(){return'\x1B[32m';}
static get red(){return'\x1B[31m';}
static get yellow(){return'\x1b[33m';}
static get purple(){return'\x1b[95m';}
static get reset(){return'\x1B[0m';}
static get bold(){return'\x1b[1m';}
static get tick(){return isWindows?'\u221A':'✓';}
static get cross(){return isWindows?'\u00D7':'✘';}
static get whiteSmallSquare(){return isWindows?'\u0387':'▫';}
static get doubleLightHorizontal(){return'──';}}
Log.events=new Emitter();module.exports=Log;}).call(this,require('_process'))},{"_process":205,"debug":234,"events":201}],25:[function(require,module,exports){'use strict';const URL=require('./url-shim');const validateColor=require('./web-inspector').Color.parse;const ALLOWED_DISPLAY_VALUES=['fullscreen','standalone','minimal-ui','browser'];const DEFAULT_DISPLAY_MODE='browser';const ALLOWED_ORIENTATION_VALUES=['any','natural','landscape','portrait','portrait-primary','portrait-secondary','landscape-primary','landscape-secondary'];function parseString(raw,trim){let value;let debugString;if(typeof raw==='string'){value=trim?raw.trim():raw;}else{if(raw!==undefined){debugString='ERROR: expected a string.';}
value=undefined;}
return{raw,value,debugString};}
function parseColor(raw){const color=parseString(raw);if(color.value===undefined){return color;}
const validatedColor=validateColor(color.raw);if(!validatedColor){color.value=undefined;color.debugString='ERROR: color parsing failed.';}
return color;}
function parseName(jsonInput){return parseString(jsonInput.name,true);}
function parseShortName(jsonInput){return parseString(jsonInput.short_name,true);}
function checkSameOrigin(url1,url2){const parsed1=new URL(url1);const parsed2=new URL(url2);return parsed1.origin===parsed2.origin;}
function parseStartUrl(jsonInput,manifestUrl,documentUrl){const raw=jsonInput.start_url;if(raw===''){return{raw,value:documentUrl,debugString:'ERROR: start_url string empty'};}
const parsedAsString=parseString(raw);if(!parsedAsString.value){parsedAsString.value=documentUrl;return parsedAsString;}
let startUrl;try{startUrl=new URL(raw,manifestUrl).href;}catch(e){return{raw,value:documentUrl,debugString:'ERROR: invalid start_url relative to ${manifestUrl}'};}
if(!checkSameOrigin(startUrl,documentUrl)){return{raw,value:documentUrl,debugString:'ERROR: start_url must be same-origin as document'};}
return{raw,value:startUrl};}
function parseDisplay(jsonInput){const display=parseString(jsonInput.display,true);if(!display.value){display.value=DEFAULT_DISPLAY_MODE;return display;}
display.value=display.value.toLowerCase();if(ALLOWED_DISPLAY_VALUES.indexOf(display.value)===-1){display.debugString='ERROR: \'display\' has invalid value '+display.value+` will fall back to ${DEFAULT_DISPLAY_MODE}.`;display.value=DEFAULT_DISPLAY_MODE;}
return display;}
function parseOrientation(jsonInput){const orientation=parseString(jsonInput.orientation,true);if(orientation.value&&ALLOWED_ORIENTATION_VALUES.indexOf(orientation.value.toLowerCase())===-1){orientation.value=undefined;orientation.debugString='ERROR: \'orientation\' has an invalid value, will be ignored.';}
return orientation;}
function parseIcon(raw,manifestUrl){const src=parseString(raw.src,true);if(src.value===''){src.value=undefined;}
if(src.value){src.value=new URL(src.value,manifestUrl).href;}
const type=parseString(raw.type,true);const density={raw:raw.density,value:1,debugString:undefined};if(density.raw!==undefined){density.value=parseFloat(density.raw);if(isNaN(density.value)||!isFinite(density.value)||density.value<=0){density.value=1;density.debugString='ERROR: icon density cannot be NaN, +∞, or less than or equal to +0.';}}
const sizes=parseString(raw.sizes);if(sizes.value!==undefined){const set=new Set();sizes.value.trim().split(/\s+/).forEach(size=>set.add(size.toLowerCase()));sizes.value=set.size>0?Array.from(set):undefined;}
return{raw,value:{src,type,density,sizes},debugString:undefined};}
function parseIcons(jsonInput,manifestUrl){const raw=jsonInput.icons;if(raw===undefined){return{raw,value:[],debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:[],debugString:'ERROR: \'icons\' expected to be an array but is not.'};}
const value=raw.filter(icon=>icon.src!==undefined).map(icon=>parseIcon(icon,manifestUrl)).filter(parsedIcon=>parsedIcon.value.src.value!==undefined);return{raw,value,debugString:undefined};}
function parseApplication(raw){const platform=parseString(raw.platform,true);const id=parseString(raw.id,true);const appUrl=parseString(raw.url,true);if(appUrl.value){try{appUrl.value=new URL(appUrl.value).href;}catch(e){appUrl.value=undefined;appUrl.debugString='ERROR: invalid application URL ${raw.url}';}}
return{raw,value:{platform,id,url:appUrl},debugString:undefined};}
function parseRelatedApplications(jsonInput){const raw=jsonInput.related_applications;if(raw===undefined){return{raw,value:undefined,debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:undefined,debugString:'ERROR: \'related_applications\' expected to be an array but is not.'};}
const value=raw.filter(application=>!!application.platform).map(parseApplication).filter(parsedApp=>!!parsedApp.value.id.value||!!parsedApp.value.url.value);return{raw,value,debugString:undefined};}
function parsePreferRelatedApplications(jsonInput){const raw=jsonInput.prefer_related_applications;let value;let debugString;if(typeof raw==='boolean'){value=raw;}else{if(raw!==undefined){debugString='ERROR: \'prefer_related_applications\' expected to be a boolean.';}
value=undefined;}
return{raw,value,debugString};}
function parseThemeColor(jsonInput){return parseColor(jsonInput.theme_color);}
function parseBackgroundColor(jsonInput){return parseColor(jsonInput.background_color);}
function parse(string,manifestUrl,documentUrl){if(manifestUrl===undefined||documentUrl===undefined){throw new Error('Manifest and document URLs required for manifest parsing.');}
let jsonInput;try{jsonInput=JSON.parse(string);}catch(e){return{raw:string,value:undefined,debugString:'ERROR: file isn\'t valid JSON: '+e};}
const manifest={name:parseName(jsonInput),short_name:parseShortName(jsonInput),start_url:parseStartUrl(jsonInput,manifestUrl,documentUrl),display:parseDisplay(jsonInput),orientation:parseOrientation(jsonInput),icons:parseIcons(jsonInput,manifestUrl),related_applications:parseRelatedApplications(jsonInput),prefer_related_applications:parsePreferRelatedApplications(jsonInput),theme_color:parseThemeColor(jsonInput),background_color:parseBackgroundColor(jsonInput)};return{raw:string,value:manifest,debugString:undefined};}
module.exports=parse;},{"./url-shim":30,"./web-inspector":31}],26:[function(require,module,exports){'use strict';const NetworkManager=require('./web-inspector').NetworkManager;const EventEmitter=require('events').EventEmitter;const log=require('../lib/log.js');class NetworkRecorder extends EventEmitter{constructor(recordArray){super();this._records=recordArray;this.networkManager=NetworkManager.createWithFakeTarget();this.startedRequestCount=0;this.finishedRequestCount=0;this.networkManager.addEventListener(this.EventTypes.RequestStarted,this.onRequestStarted.bind(this));this.networkManager.addEventListener(this.EventTypes.RequestFinished,this.onRequestFinished.bind(this));this.onRequestWillBeSent=this.onRequestWillBeSent.bind(this);this.onRequestServedFromCache=this.onRequestServedFromCache.bind(this);this.onResponseReceived=this.onResponseReceived.bind(this);this.onDataReceived=this.onDataReceived.bind(this);this.onLoadingFinished=this.onLoadingFinished.bind(this);this.onLoadingFailed=this.onLoadingFailed.bind(this);this.onResourceChangedPriority=this.onResourceChangedPriority.bind(this);}
get EventTypes(){return NetworkManager.Events;}
activeRequestCount(){return this.startedRequestCount-this.finishedRequestCount;}
isIdle(){return this.activeRequestCount()===0;}
onRequestStarted(){this.startedRequestCount++;const activeCount=this.activeRequestCount();log.verbose('NetworkRecorder',`Request started. ${activeCount} requests in progress`+` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);if(activeCount===1){this.emit('networkbusy');}}
onRequestFinished(request){this.finishedRequestCount++;this._records.push(request.data);this.emit('requestloaded',request.data);const activeCount=this.activeRequestCount();log.verbose('NetworkRecorder',`Request finished. ${activeCount} requests in progress`+` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);if(this.isIdle()){this.emit('networkidle');}}
onRequestWillBeSent(data){this.networkManager._dispatcher.requestWillBeSent(data.requestId,data.frameId,data.loaderId,data.documentURL,data.request,data.timestamp,data.wallTime,data.initiator,data.redirectResponse,data.type);}
onRequestServedFromCache(data){this.networkManager._dispatcher.requestServedFromCache(data.requestId);}
onResponseReceived(data){this.networkManager._dispatcher.responseReceived(data.requestId,data.frameId,data.loaderId,data.timestamp,data.type,data.response);}
onDataReceived(data){this.networkManager._dispatcher.dataReceived(data.requestId,data.timestamp,data.dataLength,data.encodedDataLength);}
onLoadingFinished(data){this.networkManager._dispatcher.loadingFinished(data.requestId,data.timestamp,data.encodedDataLength);}
onLoadingFailed(data){this.networkManager._dispatcher.loadingFailed(data.requestId,data.timestamp,data.type,data.errorText,data.canceled,data.blockedReason);}
onResourceChangedPriority(data){this.networkManager._dispatcher.resourceChangedPriority(data.requestId,data.newPriority,data.timestamp);}
static recordsFromLogs(logs){const records=[];const nr=new NetworkRecorder(records);const dispatcher=method=>{switch(method){case'Network.requestWillBeSent':return nr.onRequestWillBeSent;case'Network.requestServedFromCache':return nr.onRequestServedFromCache;case'Network.responseReceived':return nr.onResponseReceived;case'Network.dataReceived':return nr.onDataReceived;case'Network.loadingFinished':return nr.onLoadingFinished;case'Network.loadingFailed':return nr.onLoadingFailed;case'Network.resourceChangedPriority':return nr.onResourceChangedPriority;default:return()=>{};}};logs.forEach(networkEvent=>{dispatcher(networkEvent.method)(networkEvent.params);});return records;}}
module.exports=NetworkRecorder;},{"../lib/log.js":24,"./web-inspector":31,"events":201}],27:[function(require,module,exports){'use strict';function filterStylesheetsByUsage(stylesheets,propName,propVal){if(!propName&&!propVal){return[];}
const deepClone=stylesheets.map(sheet=>Object.assign({},sheet));return deepClone.filter(s=>{if(s.isDuplicate){return false;}
s.parsedContent=s.parsedContent.filter(item=>{let usedName='';let usedVal='';if(propName){propName=Array.isArray(propName)?propName:[propName];usedName=propName.indexOf(item.property.name)>-1;}
if(propVal){propVal=Array.isArray(propVal)?propVal:[propVal];usedVal=propVal.indexOf(item.property.val)>-1;}
if(propName&&!propVal){return usedName;}else if(!propName&&propVal){return usedVal;}else if(propName&&propVal){return usedName&&usedVal;}
return false;});return s.parsedContent.length>0;});}
function getFormattedStyleRule(content,parsedContent){const lines=content.split('\n');const declarationRange=parsedContent.declarationRange;const startLine=declarationRange.startLine;const endLine=declarationRange.endLine;const start=declarationRange.startColumn;const end=declarationRange.endColumn;let rule;if(startLine===endLine){rule=lines[startLine].substring(start,end);}else{rule=lines.slice(startLine,endLine+1).reduce((prev,line)=>{prev.push(line);return prev;},[]).join('\n');}
const block=`
${parsedContent.selector} {
  ${rule}
}`;return{styleRule:block.trim(),location:`line: ${startLine}, row: ${start}, col: ${end}`};}
function addVendorPrefixes(propsNames){const vendorPrefixes=['-o-','-ms-','-moz-','-webkit-'];propsNames=Array.isArray(propsNames)?propsNames:[propsNames];let propsNamesWithPrefixes=propsNames;for(const prefix of vendorPrefixes){const temp=propsNames.map(propName=>`${prefix}${propName}`);propsNamesWithPrefixes=propsNamesWithPrefixes.concat(temp);}
return propsNamesWithPrefixes;}
module.exports={filterStylesheetsByUsage,getFormattedStyleRule,addVendorPrefixes};},{}],28:[function(require,module,exports){'use strict';const WebInspector=require('../web-inspector');const ConsoleQuieter=require('../console-quieter');const TimelineModelTreeView=require('devtools-timeline-model/lib/timeline-model-treeview.js')(WebInspector);class TimelineModel{constructor(events){this.init(events);}
init(events){this._tracingModel=new WebInspector.TracingModel(new WebInspector.TempFileBackingStorage('tracing'));this._timelineModel=new WebInspector.TimelineModel(WebInspector.TimelineUIUtils.visibleEventsFilter());if(typeof events==='string'){events=JSON.parse(events);}
if(events.hasOwnProperty('traceEvents')){events=events.traceEvents;}
this._tracingModel.reset();ConsoleQuieter.mute({prefix:'timelineModel'});this._tracingModel.addEvents(events);this._tracingModel.tracingComplete();this._timelineModel.setEvents(this._tracingModel);ConsoleQuieter.unmuteAndFlush();return this;}
_createAggregator(){return WebInspector.AggregatedTimelineTreeView.prototype._createAggregator();}
timelineModel(){return this._timelineModel;}
tracingModel(){return this._tracingModel;}
topDown(){const filters=[];filters.push(WebInspector.TimelineUIUtils.visibleEventsFilter());filters.push(new WebInspector.ExcludeTopLevelFilter());const nonessentialEvents=[WebInspector.TimelineModel.RecordType.EventDispatch,WebInspector.TimelineModel.RecordType.FunctionCall,WebInspector.TimelineModel.RecordType.TimerFire];filters.push(new WebInspector.ExclusiveNameFilter(nonessentialEvents));const topDown=WebInspector.TimelineProfileTree.buildTopDown(this._timelineModel.mainThreadEvents(),filters,0,Infinity,WebInspector.TimelineAggregator.eventId);return topDown;}
bottomUp(){const topDown=this.topDown();const noGrouping=WebInspector.TimelineAggregator.GroupBy.None;const noGroupAggregator=this._createAggregator().groupFunction(noGrouping);return WebInspector.TimelineProfileTree.buildBottomUp(topDown,noGroupAggregator);}
bottomUpGroupBy(grouping){const topDown=this.topDown();const groupSetting=WebInspector.TimelineAggregator.GroupBy[grouping];const groupingAggregator=this._createAggregator().groupFunction(groupSetting);const bottomUpGrouped=WebInspector.TimelineProfileTree.buildBottomUp(topDown,groupingAggregator);new TimelineModelTreeView(bottomUpGrouped).sortingChanged('self','desc');return bottomUpGrouped;}
frameModel(){const frameModel=new WebInspector.TimelineFrameModel(event=>WebInspector.TimelineUIUtils.eventStyle(event).category.name);frameModel.addTraceEvents({},this._timelineModel.inspectedTargetEvents(),this._timelineModel.sessionId()||'');return frameModel;}
filmStripModel(){return new WebInspector.FilmStripModel(this._tracingModel);}
interactionModel(){const irModel=new WebInspector.TimelineIRModel();irModel.populate(this._timelineModel);return irModel;}}
module.exports=TimelineModel;},{"../console-quieter":19,"../web-inspector":31,"devtools-timeline-model/lib/timeline-model-treeview.js":236}],29:[function(require,module,exports){(function(global){'use strict';if(typeof global.window==='undefined'){global.window=global;}
const BASE_RESPONSE_LATENCY=16;const glMatrixModule=require('gl-matrix');Object.keys(glMatrixModule).forEach(exportName=>{global[exportName]=glMatrixModule[exportName];});global.JSZip={};global.mannwhitneyu={};global.HTMLImportsLoader={};global.HTMLImportsLoader.hrefToAbsolutePath=function(path){if(path==='/gl-matrix-min.js'){return'../../../lib/empty-stub.js';}
if(path==='/jszip.min.js'){return'../../../lib/empty-stub.js';}
if(path==='/mannwhitneyu.js'){return'../../../lib/empty-stub.js';}};require('../../third_party/traceviewer-js/');const traceviewer=global.tr;class TraceProcessor{get RESPONSE(){return'Response';}
get ANIMATION(){return'Animation';}
get LOAD(){return'Load';}
init(trace){const io=new traceviewer.importer.ImportOptions();io.showImportWarnings=false;io.pruneEmptyContainers=false;io.shiftWorldToZero=true;const model=new traceviewer.Model();const importer=new traceviewer.importer.Import(model,io);importer.importTraces([trace]);return model;}
static _findMainThreadFromIds(model,processId,threadId){const modelHelper=model.getOrCreateHelper(traceviewer.model.helpers.ChromeModelHelper);const renderHelpers=traceviewer.b.dictionaryValues(modelHelper.rendererHelpers);const mainThread=renderHelpers.find(helper=>{return helper.mainThread&&helper.pid===processId&&helper.mainThread.tid===threadId;}).mainThread;return mainThread;}
static _riskPercentiles(durations,totalTime,percentiles,clippedLength){clippedLength=clippedLength||0;let busyTime=0;for(let i=0;i<durations.length;i++){busyTime+=durations[i];}
busyTime-=clippedLength;let completedTime=totalTime-busyTime;let duration=0;let cdfTime=completedTime;const results=[];let durationIndex=-1;let remainingCount=durations.length+1;if(clippedLength>0){remainingCount--;}
for(const percentile of percentiles){const percentileTime=percentile*totalTime;while(cdfTime<percentileTime&&durationIndex<durations.length-1){completedTime+=duration;remainingCount-=(duration<0?-1:1);if(clippedLength>0&&clippedLength<durations[durationIndex+1]){duration=-clippedLength;clippedLength=0;}else{durationIndex++;duration=durations[durationIndex];}
cdfTime=completedTime+Math.abs(duration)*remainingCount;}
results.push({percentile,time:Math.max(0,(percentileTime-completedTime)/remainingCount)+BASE_RESPONSE_LATENCY});}
return results;}
static getRiskToResponsiveness(model,trace,startTime,endTime,percentiles){startTime=startTime===undefined?model.bounds.min:startTime;endTime=endTime===undefined?model.bounds.max:endTime;const totalTime=endTime-startTime;if(percentiles){percentiles.sort((a,b)=>a-b);}else{percentiles=[0.5,0.75,0.9,0.99,1];}
const ret=TraceProcessor.getMainThreadTopLevelEventDurations(model,trace,startTime,endTime);return TraceProcessor._riskPercentiles(ret.durations,totalTime,percentiles,ret.clippedLength);}
static getMainThreadTopLevelEventDurations(model,trace,startTime,endTime){const startEvent=trace.traceEvents.find(event=>{return event.name==='TracingStartedInPage';});const mainThread=TraceProcessor._findMainThreadFromIds(model,startEvent.pid,startEvent.tid);const durations=[];let clippedLength=0;mainThread.sliceGroup.topLevelSlices.forEach(slice=>{if(slice.end<=startTime||slice.start>=endTime){return;}
let duration=slice.duration;let sliceStart=slice.start;if(sliceStart<startTime){sliceStart=startTime;duration=slice.end-sliceStart;}
if(slice.end>endTime){clippedLength=duration-(endTime-sliceStart);}
durations.push(duration);});durations.sort((a,b)=>a-b);return{durations,clippedLength};}
static getLogNormalDistribution(median,falloff){const location=Math.log(median);const logRatio=Math.log(falloff/median);const shape=0.5*Math.sqrt(1-3*logRatio-
Math.sqrt((logRatio-3)*(logRatio-3)-8));return new traceviewer.b.Statistics.LogNormalDistribution(location,shape);}}
module.exports=TraceProcessor;}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../third_party/traceviewer-js/":85,"gl-matrix":237}],30:[function(require,module,exports){'use strict';const URL=(typeof self!=='undefined'&&self.URL)||require('whatwg-url').URL;URL.INVALID_URL_DEBUG_STRING='Lighthouse was unable to determine the URL of some script executions. '+'It\'s possible a Chrome extension or other eval\'d code is the source.';URL.isValid=function isValid(url){try{new URL(url);return true;}catch(e){return false;}};URL.hostsMatch=function hostsMatch(urlA,urlB){try{return new URL(urlA).host===new URL(urlB).host;}catch(e){return false;}};URL.getDisplayName=function getDisplayName(url){const parsed=new URL(url);let name=parsed.protocol==='about:'?parsed.href:parsed.pathname.replace(/\?.*/,'').split('/').slice(-2).join('/');const MAX_LENGTH=64;name=name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,'$1\u2026');if(name.length>MAX_LENGTH){const dotIndex=name.lastIndexOf('.');name=name.slice(0,MAX_LENGTH-1-(name.length-dotIndex))+`\u2026${name.slice(dotIndex)}`;}
return name;};module.exports=URL;},{"whatwg-url":199}],31:[function(require,module,exports){(function(global){'use strict';module.exports=(function(){if(global.WebInspector){return global.WebInspector;}
if(global.self!==global){global.self=global;}
if(typeof global.window==='undefined'){global.window=global;}
global.Runtime={};global.Runtime.experiments={isEnabled(experimentName){switch(experimentName){case'timelineLatencyInfo':return true;default:return false;}}};global.Runtime.queryParam=function(arg){switch(arg){case'remoteFrontend':return false;case'ws':return false;default:throw Error('Mock queryParam case not implemented.');}};global.TreeElement={};global.WorkerRuntime={};global.Protocol={Agents(){}};global.WebInspector={};const WebInspector=global.WebInspector;WebInspector._moduleSettings={cacheDisabled:{addChangeListener(){},get(){return false;}},monitoringXHREnabled:{addChangeListener(){},get(){return false;}},showNativeFunctionsInJSProfile:{addChangeListener(){},get(){return true;}}};WebInspector.moduleSetting=function(settingName){return this._moduleSettings[settingName];};global.NetworkAgent={RequestMixedContentType:{Blockable:'blockable',OptionallyBlockable:'optionally-blockable',None:'none'},BlockedReason:{CSP:'csp',MixedContent:'mixed-content',Origin:'origin',Inspector:'inspector',Other:'other'},InitiatorType:{Other:'other',Parser:'parser',Redirect:'redirect',Script:'script'}};global.SecurityAgent={SecurityState:{Unknown:'unknown',Neutral:'neutral',Insecure:'insecure',Warning:'warning',Secure:'secure',Info:'info'}};global.PageAgent={ResourceType:{Document:'document',Stylesheet:'stylesheet',Image:'image',Media:'media',Font:'font',Script:'script',TextTrack:'texttrack',XHR:'xhr',Fetch:'fetch',EventSource:'eventsource',WebSocket:'websocket',Manifest:'manifest',Other:'other'}};require('chrome-devtools-frontend/front_end/common/Object.js');require('chrome-devtools-frontend/front_end/common/ParsedURL.js');require('chrome-devtools-frontend/front_end/common/ResourceType.js');require('chrome-devtools-frontend/front_end/common/UIString.js');require('chrome-devtools-frontend/front_end/platform/utilities.js');require('chrome-devtools-frontend/front_end/sdk/Target.js');require('chrome-devtools-frontend/front_end/sdk/TargetManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkRequest.js');WebInspector.targetManager={observeTargets(){},addEventListener(){}};WebInspector.settings={createSetting(){return{get(){return false;},addChangeListener(){}};}};WebInspector.console={error(){}};WebInspector.VBox=function(){};WebInspector.HBox=function(){};WebInspector.ViewportDataGrid=function(){};WebInspector.ViewportDataGridNode=function(){};global.WorkerRuntime.Worker=function(){};require('chrome-devtools-frontend/front_end/common/SegmentedRange.js');require('chrome-devtools-frontend/front_end/bindings/TempFile.js');require('chrome-devtools-frontend/front_end/sdk/TracingModel.js');require('chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js');require('chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js');require('chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js');require('chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js');require('chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js');require('chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js');require('chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js');WebInspector.DeferredTempFile=function(){};WebInspector.DeferredTempFile.prototype={write:function(){},finishWriting:function(){}};WebInspector.ConsoleMessage=function(){};WebInspector.ConsoleMessage.MessageSource={Network:'network'};WebInspector.ConsoleMessage.MessageLevel={Log:'log'};WebInspector.ConsoleMessage.MessageType={Log:'log'};WebInspector.NetworkLog=function(target){this._requests=new Map();target.networkManager.addEventListener(WebInspector.NetworkManager.Events.RequestStarted,this._onRequestStarted,this);};WebInspector.NetworkLog.prototype={requestForURL:function(url){return this._requests.get(url)||null;},_onRequestStarted:function(event){const request=event.data;if(this._requests.has(request.url)){return;}
this._requests.set(request.url,request);}};require('chrome-devtools-frontend/front_end/common/Color.js');WebInspector.NetworkManager.createWithFakeTarget=function(){const fakeNetworkAgent={enable(){}};const fakeConsoleModel={addMessage(){},target(){}};const fakeTarget={_modelByConstructor:new Map(),get consoleModel(){return fakeConsoleModel;},networkAgent(){return fakeNetworkAgent;},registerNetworkDispatcher(){},model(){}};fakeTarget.networkManager=new WebInspector.NetworkManager(fakeTarget);fakeTarget.networkLog=new WebInspector.NetworkLog(fakeTarget);WebInspector.NetworkLog.fromTarget=()=>{return fakeTarget.networkLog;};return fakeTarget.networkManager;};require('chrome-devtools-frontend/front_end/common/TextRange.js');const gonzales=require('chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js');require('chrome-devtools-frontend/front_end/gonzales/SCSSParser.js');WebInspector.SCSSParser.prototype.parse=function(content){let ast=null;try{ast=gonzales.parse(content,{syntax:'css'});}catch(e){return{error:e};}
const rootBlock={properties:[],node:ast};const blocks=[rootBlock];ast.selectors=[];WebInspector.SCSSParser.extractNodes(ast,blocks,rootBlock);return ast;};return WebInspector;})();}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"chrome-devtools-frontend/front_end/bindings/TempFile.js":206,"chrome-devtools-frontend/front_end/common/Color.js":207,"chrome-devtools-frontend/front_end/common/Object.js":208,"chrome-devtools-frontend/front_end/common/ParsedURL.js":209,"chrome-devtools-frontend/front_end/common/ResourceType.js":210,"chrome-devtools-frontend/front_end/common/SegmentedRange.js":211,"chrome-devtools-frontend/front_end/common/TextRange.js":212,"chrome-devtools-frontend/front_end/common/UIString.js":213,"chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js":214,"chrome-devtools-frontend/front_end/gonzales/SCSSParser.js":215,"chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js":216,"chrome-devtools-frontend/front_end/platform/utilities.js":217,"chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js":218,"chrome-devtools-frontend/front_end/sdk/NetworkManager.js":219,"chrome-devtools-frontend/front_end/sdk/NetworkRequest.js":220,"chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js":221,"chrome-devtools-frontend/front_end/sdk/Target.js":222,"chrome-devtools-frontend/front_end/sdk/TargetManager.js":223,"chrome-devtools-frontend/front_end/sdk/TracingModel.js":224,"chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js":225,"chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js":226,"chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js":227,"chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js":228,"chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js":229,"chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js":230,"chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js":231,"chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js":232,"chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js":233}],32:[function(require,module,exports){'use strict';const Formatter=require('../formatters/formatter');const Handlebars=require('handlebars');const path=require('path');const marked=require('marked');const RATINGS={GOOD:{label:'good',minScore:75},AVERAGE:{label:'average',minScore:45},POOR:{label:'poor'}};function calculateRating(value){let rating=RATINGS.POOR.label;if(value>=RATINGS.GOOD.minScore){rating=RATINGS.GOOD.label;}else if(value>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
class ReportGenerator{constructor(){const getTotalScore=aggregation=>{return Math.round(aggregation.total*100);};const getItemRating=value=>{if(typeof value==='boolean'){return value?RATINGS.GOOD.label:RATINGS.POOR.label;}
return calculateRating(value);};Handlebars.registerHelper('nameToLink',name=>{return name.toLowerCase().replace(/\s/,'-');});Handlebars.registerHelper('getTotalScore',getTotalScore);Handlebars.registerHelper('getTotalScoreRating',aggregation=>{const totalScore=getTotalScore(aggregation);return calculateRating(totalScore);});Handlebars.registerHelper('getItemRating',getItemRating);Handlebars.registerHelper('shouldShowHelpText',value=>(getItemRating(value)!==RATINGS.GOOD.label));Handlebars.registerHelper('decimal',number=>{if(number&&number.toFixed){return number.toFixed(2);}
return number;});Handlebars.registerHelper('is-bool',value=>(typeof value==='boolean'));Handlebars.registerHelper('not',value=>!value);Handlebars.registerHelper('if_not_eq',function(lhs,rhs,options){if(lhs!==rhs){return options.fn(this);}else{return options.inverse(this);}});Handlebars.registerHelper('and',function(){let arg=false;for(let i=0,n=arguments.length-1;i<n;i++){arg=arguments[i];if(!arg){break;}}
return arg;});Handlebars.registerHelper('sanitize',function(str,opts){const renderer=new marked.Renderer();renderer.link=(href,title,text)=>{title=title||text;return`<a href="${href}" target="_blank" rel="noopener" title="${title}">${text}</a>`;};renderer.codespan=function(str){return`<code>${str}</code>`;};renderer.paragraph=function(str){return str;};try{str=marked(str,{renderer,sanitize:true});}catch(e){}
return new Handlebars.SafeString(str);});}
_formatTime(date){const options={day:'numeric',month:'numeric',year:'numeric',hour:'numeric',minute:'numeric',second:'numeric',timeZoneName:'short'};let formatter=new Intl.DateTimeFormat('en-US',options);const tz=formatter.resolvedOptions().timeZone;if(!tz||tz.toLowerCase()==='etc/unknown'){options.timeZone='UTC';formatter=new Intl.DateTimeFormat('en-US',options);}
return formatter.format(new Date(date));}
_escapeScriptTags(jsonStr){return jsonStr.replace(/<\/script>/g,'<\\/script>');}
getReportTemplate(){return"<!--\n\nCopyright 2016 Google Inc. All rights reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n-->\n<!doctype html>\n\n<html data-report-context=\"{{reportContext}}\">\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, minimum-scale=1.0\">\n  <link rel=\"shortcut icon\" href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAEfElEQVR4Aa2WA5B0RxDH/z3zuDp/tq2Lbdu2XUoxKMW2bdu2nZxte/dpplO3hTjZ2s0z5zftpkVrFXJYGCBAggEoUPY2p0XkOLoJNoE+yH5II3vLOQJyHL0bsgpiC9G1meishuiBzJEhchm9HXIL0fu5e949TuX1cvVbxplbiu6O3BjiP19HEFMpuNI9Z4O8XpIlKb6SbrnQOG0WeQGkKATAgAVdz3Sw/G6BenwoXAnls/JH1IqZ0fN70DeN2Q84b4AA0jBWkHewfXsUh0ykKSZTcVGamoincKR7xyrKpGH8uxDGv0vgmOqXZuf1o87ccP6wCpIkgb5ePZw2Yvj0icN+eshdMUcFIRVgAwIyGHTKUGqLEluUOWJqkpISRRi2S+BDgAuyAYHhwYsIxCACM/wMSQEBNXkLAjhvFVnEP2WMYzdvO6/4muDZMVCavSD8ujHDQkmxe90VP8y+5s1oznSoCJSfkRkC07yBhd3XRz+m1bd9/tN14XMd3kutI4/5s1qfnmEPjWgIcL5GZoCQUcbA56Cpw4g8TguxZBYiloomfGRCE1SAigKIxZKfG1rCW7cddOhIFIEEEWutIeLmyy+nXni8bMkMDiORv5uaxHW+NRSbFhbL0AeBI9MOyZyRbkpO2D2WVQ7lgSg/L6IsA8xJ0zMiX5GMpFnc37L+/bs3uX/d8rrPkYJQXFAuIgJ8UNwMLaest7Hy3Vs2e/S4OZ9dB4YV09CgAnOR0IwkzR5p2+SNSzd+9Jhp394M6YbJBRCuISYAFJpN5SQAy2q/SP1wg3JnRIlFDAIRokwi6If4XyoaQzohYgmAASGiCWv4W6QqR5asQgBNVGjBAWDLcSAug1Fj9FOvaH7tztd+fOhDzZXbYoiVKBwgkAiGMdYzPnVN1V6PfXLI9dUb9vHtZBwZ6RAYlHegAVkNBAjnzKzf4om6WVso2zFD3/HGyYZpGimjsJJJgBKUmOCarfdpXLYdAbY/QVplwVLHHMMEc4FGZhg2HBFZfppYg6GF4bkJGXiLWz6aYfg+CyoEoDVcC4ahmaGk6Ttx2x9b9t3Lmz9+9tp3Li5yw0CD8sumTExi8ujGoFwzbRuxgZ45tR/M+OlpZ+ATuHP9otluvxfqJBGzBmn6bwALhmQApAT5knyoYcRKsKC3Y+U3rxZ/8xzGPkNsLcwNSIcp3ZfqFpkxUNIgB7CZDQUAikjTHwEENjSYaFxiEIiACuYZozx1yC8dSZZ31U9cXl9W1bfvosDYkXRoMMcjuyjggcq37cGl0UBK95RQV5LasqOVACnNQiMSxKCFlSFFEp0EG3p1v15Rr+b/oqdWcVETOx0whpXwe3k+yAKHwB+63hR1JDjSUYnwp9PoPNG3TDSvkFVLxA/TMQTMBDsRLZrGPDVUO34TrX9LzfyQ3ToiQBVBJ6BtsCRGjEJiZqLfezDAabY0AaRAAeQE5CgjJG+u6NnS+HFH451NqSZO8879PNjpLl3xFnEMYQWUAzBIAxrEyHUhsJjcQBABzEEWA2Jkc/Ojk38Fe4MpHMjZ+XoAAAAASUVORK5CYII=\">\n  <title>Lighthouse report: {{ url }}</title>\n  <style>{{{ css }}}</style>\n  {{#each scripts }}\n    <script>{{{ this }}}</script>\n  {{/each}}\n</head>\n<body>\n\n<div class=\"js-report report\">\n  <section class=\"report-body js-report-body\" status=\"stable\">\n    <div class=\"report-body__header\">\n      <div class=\"report-body__metadata\">\n        <div class=\"report-body__url\">Results for: <a href=\"{{ url }}\" target=\"_blank\">{{ url }}</a></div>\n        <div class=\"report-body__url\">Generated on: {{generatedTime}}</div>\n      </div>\n      <div class=\"report-body__buttons\">\n        <span class=\"export-section\">\n          <button class=\"export-button js-export\" title=\"Export report in different formats\">Export...</button>\n          <ul class=\"export-dropdown\">\n            <a href=\"#\" data-action=\"print\">Print...</a>\n            <a href=\"#\" data-action=\"copy\">Copy JSON...</a>\n            <a href=\"#\" data-action=\"save-html\">Save as HTML...</a>\n            <a href=\"#\" data-action=\"save-json\">Save as JSON...</a>\n          </ul>\n        </span>\n        <button class=\"report-body__icon rerun-button js-rerun-button\" title=\"Rerun this test\"></button>\n        <button class=\"report-body__icon share js-share\"></button>\n        {{#if_not_eq reportContext \"viewer\"}}\n          <button class=\"report-body__icon print js-print\"></button>\n        {{/if_not_eq}}\n      </div>\n    </div>\n    <div class=\"report-body__content\">\n      <div class=\"report-body__menu-container\">\n        <div class=\"menu\">\n          <div class=\"menu__header\">\n            <h1 class=\"menu__header-title\">Lighthouse</h1>\n            <div class=\"menu__header-version\">Version: {{lighthouseVersion}}</div>\n          </div>\n          <ul class=\"menu__nav\">\n            {{#each aggregations}}\n            <li class=\"menu__nav-item\">\n              <a class=\"menu__link\" href=\"#{{nameToLink this.name}}\">\n                {{ this.name }}\n              </a>\n            </li>\n            {{/each}}\n          </ul>\n        </div>\n      </div>\n\n      <div class=\"report-body__aggregations-container\">\n      {{#each aggregations}}\n      <section class=\"js-breakdown aggregations\" id=\"{{nameToLink this.name}}\">\n        <header class=\"aggregations__header\">\n          <h1>{{ this.name }}</h1>\n          <p class=\"aggregations__desc\">{{ sanitize this.description }}</p>\n          {{#if this.scored}}\n          <div class=\"section-result\">\n            <span class=\"section-result__score score-{{ getTotalScoreRating this }}-bg\">\n              <span class=\"section-result__points\">{{ getTotalScore this }}</span>\n              <span class=\"section-result__divider\">/</span>\n              <span class=\"section-result__total\">100</span>\n            </span>\n          </div>\n          {{/if}}\n        </header>\n\n        <div class=\"js-report-by-user-feature\">\n          {{#each this.score as |aggregation|}}\n            <section class=\"aggregation\">\n\n            {{#if aggregation.name }}\n            <header class=\"aggregation__header\">\n              <h2>{{ aggregation.name }}</h2>\n              {{#if aggregation.description }}\n                <p class=\"aggregation__desc\">{{ sanitize aggregation.description }}</p>\n              {{/if}}\n            </header>\n            {{/if}}\n\n            <ul class=\"subitems\">\n              {{#each aggregation.subItems as |subItem| }}\n                <li class=\"subitem {{#if subItem.comingSoon}}--coming-soon{{/if}} {{#if (shouldShowHelpText subItem.score)}}--show-help{{/if}}\">\n\n                  <p class=\"subitem__desc\">\n                    {{#unless ../../scored }}\n                      <strong class=\"subitem__category\">{{ subItem.category }}:</strong>\n                    {{/unless}}\n\n                    {{ sanitize subItem.description }}\n\n                    {{~#if (and subItem.displayValue (not (is-bool subItem.displayValue))) ~}}\n                      <strong class=\"subitem__raw-value\">: {{ subItem.displayValue }}</strong>\n                    {{/if}}\n\n                    {{#if subItem.optimalValue }}\n                      <small>(target: {{ subItem.optimalValue }})</small>\n                    {{/if}}\n\n                    {{#if subItem.comingSoon}}\n                      <small class=\"subitem__tease\">(Coming soon)</small>\n                    {{/if}}\n\n                    {{#if subItem.helpText }}\n                      <input type=\"checkbox\" class=\"subitem__help-toggle\" title=\"Toggle help text\"  {{#if (shouldShowHelpText subItem.score)}}checked{{/if}}>\n                      <span class=\"subitem__help\">\n                        {{ sanitize subItem.helpText }}\n                      </span>\n                    {{/if}}\n                  </p>\n\n                  {{#if subItem.debugString }}\n                    <div class=\"subitem__debug\">\n                      {{ subItem.debugString }}\n                    </div>\n                  {{/if}}\n\n                  <div class=\"subitem-result\">\n                    {{#if subItem.comingSoon}}\n                          <span class=\"subitem-result__unknown score-unknown-bg\">N/A</span>\n                    {{else}}\n                      {{#if (is-bool subItem.score)}}\n                        {{#if subItem.score}}\n                          <span class=\"subitem-result__good score-good-bg\">Pass</span>\n                        {{else}}\n                          <span class=\"subitem-result__poor score-poor-bg\">Fail</span>\n                        {{/if}}\n                      {{else}}\n                        <span class=\"subitem-result__points score-{{ getItemRating subItem.score }}-bg\">\n                          {{ subItem.score }}\n                        </span>\n                      {{/if}}\n                    {{/if}}\n                  </div>\n\n                  {{#if subItem.extendedInfo.value}}\n                    {{> (lookup . 'name') subItem.extendedInfo.value }}\n                  {{/if}}\n                </li>\n              {{/each}}\n            </ul>\n          </section>\n          {{/each}}\n        </div>\n      </section>\n      {{/each}}\n      </div>\n    </div>\n\n    <footer class=\"footer\">\n      Generated by <b>Lighthouse</b> {{lighthouseVersion}} on {{generatedTime}} | <a href=\"https://github.com/GoogleChrome/Lighthouse/issues\" target=\"_blank\">File an issue</a>\n    </footer>\n  </section>\n</div>\n";}
getExceptionTemplate(){return"<!--\n\nCopyright 2016 Google Inc. All rights reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n-->\n<!doctype html>\n<html>\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"viewport\" content=\"width=device-width\">\n  <title>Lighthouse report - error</title>\n  <style>{{{ css }}}</style>\n</head>\n<body>\n\n  <div class=\"js-report report\">\n    <section class=\"report-body\">\n      <div class=\"report-body__header\"></div>\n\n      <div class=\"report-body__content\">\n\n        <div class=\"report-error\">\n          <h1 class=\"error-message\">⚠️ Error: {{{ errMessage }}}</h1>\n          <p class=\"error-stack\"> {{{ errStack }}}</p>\n          <big>\n            ➡ <a target=\"_blank\" href=\"https://github.com/GoogleChrome/lighthouse/issues\">Please report this bug</a>\n          </big>\n          <div class=\"error-results\"><pre>{{{ results }}}</pre></div>\n        </div>\n\n      </div>\n\n    </section>\n    <footer class=\"footer\">\n      Generated by <b>Lighthouse</b> on {{generatedTime}} | <a href=\"https://github.com/GoogleChrome/Lighthouse/issues\" target=\"_blank\">File an issue</a>\n    </footer>\n  </div>\n\n</body>\n</html>\n";}
getReportCSS(){return"/**\n * Copyright 2016 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n* {\n  box-sizing: border-box;\n}\n\nspan, div, p, section, header, h1, h2, li, ul {\n  margin: 0;\n  padding: 0;\n  line-height: inherit;\n}\n\n:root {\n  --text-font-family: \"Roboto\", -apple-system, BlinkMacSystemFont,  \"Segoe UI\", \"Oxygen\", \"Ubuntu\", \"Cantarell\", \"Fira Sans\", \"Droid Sans\", \"Helvetica Neue\", sans-serif;\n  --text-color: #212121;\n  --secondary-text-color: #757575;\n  --accent-color: #719EA8;\n  --poor-color: #eb211e;\n  --good-color: #1ac123;\n  --average-color: #ffae00;\n  --unknown-color: #b3b3b3;\n  --gutter-gap: 12px;\n  --gutter-width: 40px;\n  --body-font-size: 14px;\n  --body-line-height: 20px;\n  --subitem-font-size: 14px;\n  --subitem-line-height: 20px;\n  --subheading-font-size: 16px;\n  --subheading-line-height: 24px;\n  --subheading-color: var(--accent-color);\n  --heading-font-size: 24px;\n  --heading-line-height: 32px;\n  --subitem-indent: 24px;\n  --max-line-length: none;\n\n  --report-width: 1280px;\n  --report-menu-width: 280px;\n  --report-header-height: 58px;\n}\n\n:root[data-report-context=\"devtools\"] {\n  --text-font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n  --text-color: #222;\n  --secondary-text-color: #606060;\n  --accent-color: #3879d9;\n  --body-font-size: 13px;\n  --body-line-height: 17px;\n  --subitem-font-size: 14px;\n  --subitem-line-height: 18px;\n  --subheading-font-size: 16px;\n  --subheading-line-height: 20px;\n  --subheading-color: inherit;\n  --report-header-height: 0;\n  --heading-font-size: 20px;\n  --heading-line-height: 24px;\n  --subitem-indent: 24px;\n  --max-line-length: calc(60 * var(--body-font-size));\n}\n\nhtml {\n  font-family: var(--text-font-family);\n  font-size: var(--body-font-size);\n  line-height: 1;\n  margin: 0;\n  padding: 0;\n}\n\nhtml, body {\n  height: 100%;\n}\n\n/* When deep linking to a section, bump the heading down so it's not covered by the top nav. */\n:target.aggregations {\n  padding-top: calc(var(--report-header-height) + var(--heading-line-height)) !important;\n}\n\na {\n  color: #15c;\n}\n\nbody {\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  margin: 0;\n  background: #f5f5f5;\n}\n\n.report-error {\n  font-family: consolas, monospace;\n}\n\n.error-stack {\n  white-space: pre-wrap;\n}\n\n.error-results {\n  background: #dedede;\n  max-height: 600px;\n  overflow: auto;\n  border-radius: 2px;\n}\n\n.report {\n  width: 100%;\n  margin: 0 auto;\n  max-width: var(--report-width);\n  background: #FFF;\n  box-shadow: 0 0 6px 0 rgba(0,0,0,0.26);\n}\n\n.report-body__icon {\n  width: 24px;\n  height: 24px;\n  border: none;\n  cursor: pointer;\n  flex: 0 0 auto;\n  background-repeat: no-repeat;\n  background-position: center center;\n  background-size: contain;\n  background-color: transparent;\n  margin-left: 8px;\n}\n\n.report-body__icon.print {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path d=\"M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z\"/><path fill=\"none\" d=\"M0 0h24v24H0z\"/></svg>');\n}\n\n.report-body__icon.share {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path fill=\"none\" d=\"M0 0h24v24H0z\"/><path d=\"M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z\"/></svg>');\n  display: none;\n}\n\n.report-body__icon.copy {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z\"/></svg>');\n  display: none;\n}\n\n.report-body__icon.rerun-button {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24px\" height=\"24px\" viewBox=\"0 0 24 24\" fill=\"#000000\"><path d=\"M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z\"/><path d=\"M0 0h24v24H0z\" fill=\"none\"/></svg>');\n  display: none;\n}\n\n.rerun-button[status=running] {\n  animation: rotate 1000ms infinite;\n}\n\n@keyframes rotate {\n  from {\n    transform: none;\n  }\n  to {\n    transform: rotate(360deg);\n  }\n}\n\n.score-container__overall-score {\n  color: #FFF;\n  font-size: 92px;\n  font-weight: 100;\n  position: relative;\n  display: inline-block;\n  text-align: center;\n  min-width: 70px;\n}\n\n.score-container__overall-score::after {\n  content: 'Your score';\n  position: absolute;\n  bottom: -4px;\n  font-size: 14px;\n  font-weight: 500;\n  text-align: center;\n  width: 100%;\n  left: 0;\n  opacity: 0.5;\n}\n\n.score-container__max-score {\n  color: #57A0A8;\n  font-size: 28px;\n  font-weight: 500;\n}\n\n.report-body {\n  position: relative;\n}\n\n.report-body__content {\n  margin-left: var(--report-menu-width);\n  position: relative;\n}\n\n.report-body__aggregations-container {\n  padding-top: var(--report-header-height);\n  will-change: transform;\n}\n\n.report-body__menu-container {\n  height: 100%;\n  width: 100%;\n  min-width: 230px;\n  max-width: var(--report-width);\n  position: fixed;\n  will-change: transform;\n  left: 50%;\n  transform: translateX(-50%);\n  top: 0;\n  pointer-events: none;\n}\n\n.menu {\n  width: var(--report-menu-width);\n  background: #FFFFFF;\n  height: 100%;\n  top: 0;\n  left: 0;\n  pointer-events: auto;\n  border-right: 1px solid #DFDFDF;\n}\n\n.menu__header {\n  background: #2238b3;\n  padding: 0 20px;\n  height: 115px;\n  line-height: 54px;\n  color: #FFF;\n  font-family: var(--text-font-family);\n  font-size: 18px;\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  align-self: center;\n  justify-content: center;\n}\n\n.menu__header::after {\n  content: '';\n  display: block;\n  width: 90px;\n  height: 90px;\n  position: absolute;\n  top: 0;\n  right: 0;\n  background: url('data:image/svg+xml;utf-8,<svg width=\"86\" height=\"86\" viewBox=\"0 0 86 86\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"><title>Beta</title><defs><path id=\"b\" d=\"M-11.704 13.144H125.58v30H-11.703z\"/><filter x=\"-50%\" y=\"-50%\" width=\"200%\" height=\"200%\" filterUnits=\"objectBoundingBox\" id=\"a\"><feOffset dy=\"1\" in=\"SourceAlpha\" result=\"shadowOffsetOuter1\"/><feGaussianBlur stdDeviation=\"1\" in=\"shadowOffsetOuter1\" result=\"shadowBlurOuter1\"/><feColorMatrix values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.5 0\" in=\"shadowBlurOuter1\"/></filter><path id=\"d\" d=\"M.4 16.972h119v28.4H.4z\"/><filter x=\"-50%\" y=\"-50%\" width=\"200%\" height=\"200%\" filterUnits=\"objectBoundingBox\" id=\"c\"><feGaussianBlur stdDeviation=\"3.5\" in=\"SourceAlpha\" result=\"shadowBlurInner1\"/><feOffset in=\"shadowBlurInner1\" result=\"shadowOffsetInner1\"/><feComposite in=\"shadowOffsetInner1\" in2=\"SourceAlpha\" operator=\"arithmetic\" k2=\"-1\" k3=\"1\" result=\"shadowInnerInner1\"/><feColorMatrix values=\"0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.689509737 0\" in=\"shadowInnerInner1\"/></filter><text id=\"f\" font-family=\"Arial-BoldMT, Arial\" font-size=\"13\" font-weight=\"bold\" fill=\"#FFF\"><tspan x=\"37.556\" y=\"34.556\">BETA</tspan></text><filter x=\"-50%\" y=\"-50%\" width=\"200%\" height=\"200%\" filterUnits=\"objectBoundingBox\" id=\"e\"><feOffset dy=\"1\" in=\"SourceAlpha\" result=\"shadowOffsetOuter1\"/><feGaussianBlur stdDeviation=\".5\" in=\"shadowOffsetOuter1\" result=\"shadowBlurOuter1\"/><feColorMatrix values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.140964674 0\" in=\"shadowBlurOuter1\"/></filter></defs><g fill=\"none\" fill-rule=\"evenodd\"><g mask=\"url(#mask-2)\" transform=\"rotate(45 55.44 24.523)\"><use fill=\"#000\" filter=\"url(#a)\" xlink:href=\"#b\"/><use fill=\"#CF3A3C\" xlink:href=\"#b\"/></g><use filter=\"url(#c)\" xlink:href=\"#d\" mask=\"url(#mask-2)\" transform=\"rotate(45 58.4 27.55)\" fill=\"#000\"/><g mask=\"url(#mask-2)\" transform=\"rotate(45 52.556 36.435)\" fill=\"#FFF\"><use filter=\"url(#e)\" xlink:href=\"#f\"/><use xlink:href=\"#f\"/></g><path d=\"M8.5-.5l88.204 88.204M8.5-39.5l88.204 88.204\" stroke=\"#FFF\" stroke-linecap=\"square\" stroke-dasharray=\"1,2\" opacity=\".386\" mask=\"url(#mask-2)\" transform=\"translate(-3)\"/></g></svg>') top right no-repeat;\n}\n\n.menu__header-title {\n  font-family: var(--text-font-family);\n  font-weight: 300;\n  color: #fff;\n  margin: 0;\n  padding: 0;\n  line-height: 1.5;\n}\n\n.menu__header-version {\n  opacity: 0.4;\n  color: #fff;\n  font-family: var(--text-font-family);\n  font-size: 14px;\n  line-height: 1.5;\n}\n\n.menu__nav {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n}\n\n.menu__nav-item {\n  height: 40px;\n  line-height: 40px;\n  border-top: 1px solid #EBEBEB;\n}\n\n.menu__link {\n  padding: 0 20px;\n  text-decoration: none;\n  color: #777;\n  display: flex;\n}\n\n.menu__link:hover {\n  background-color: #448aff;\n  color: #FFF;\n}\n\n.menu__link-label {\n  flex: 1;\n  color: #49525F;\n  font-weight: 500;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n\n.menu__link-score {\n  padding-left: 20px;\n}\n\n.report-body__metadata {\n  flex: 1 1 0;\n  white-space: nowrap;\n}\n\n.report-body__buttons {\n  display: flex;\n  align-items: center;\n  flex-shrink: 0;\n}\n\n.report-body__url {\n  font-family: var(--text-font-family);\n  white-space: nowrap;\n  font-size: 13px;\n  font-weight: 400;\n  color: var(--secondary-text-color);\n  line-height: 20px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.report-body__url a {\n  color: currentColor;\n}\n\n.report-body__breakdown {\n  flex: 1;\n  max-width: 100%;\n}\n\n.report-body__breakdown-item {\n  padding-bottom: 6px;\n}\n\n.report-body__breakdown-item:last-of-type {\n  border: none;\n}\n\n.report-body__header {\n  height: var(--report-header-height);\n  border-bottom: 1px solid #EBEBEB;\n  background: #FAFAFA;\n  margin-left: var(--report-menu-width);\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  justify-content: flex-start;\n  padding: 0 var(--heading-line-height);\n  position: fixed;\n  will-change: transform;\n  z-index: 1;\n  max-width: calc( var(--report-width) - var(--report-menu-width));\n  width: calc(100vw - var(--report-menu-width));\n}\n\n.report-section__title {\n  -webkit-font-smoothing: antialiased;\n  font-family: var(--text-font-family);\n  font-size: 28px;\n  font-weight: 500;\n  color: #49525F;\n  display: flex;\n  margin: 0.4em 0 0.3em 0;\n}\n\n.report-section__title-main {\n  flex: 1;\n}\n\n.report-section__title-score-total {\n  font-weight: 500;\n}\n\n.report-section__title-score-max {\n  font-weight: 400;\n  font-size: 18px;\n  margin-left: -4px;\n}\n\n.report-section__subtitle {\n  -webkit-font-smoothing: antialiased;\n  font-family: var(--text-font-family);\n  font-size: 18px;\n  font-weight: 500;\n  color: #719EA8;\n  display: flex;\n  margin: 24px 0 16px 0;\n}\n\n.report-section__description {\n  color: #5F6875;\n  font-size: 16px;\n  margin: 0 0 1em 0;\n  line-height: 1.4;\n  max-width: 750px;\n}\n.report-section__description:empty {\n  margin: 0;\n}\n\n.report-section__aggregation-description {\n  font-style: italic;\n  color: #777;\n  font-size: 14px;\n  margin: 0.6em 0 0.8em 0;\n  line-height: 1.4;\n  max-width: 750px;\n}\n\n.report-section__label {\n  flex: 1;\n}\n\n.report-section__individual-results {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n}\n\n.report-section__item {\n  padding-left: 32px;\n  background: url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNXB4IiBoZWlnaHQ9IjVweCIgdmlld0JveD0iMCAwIDUgNSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxjaXJjbGUgaWQ9Ik92YWwtNzAiIHN0cm9rZT0ibm9uZSIgZmlsbD0iIzY0NjQ2NCIgZmlsbC1ydWxlPSJldmVub2RkIiBjeD0iMi41IiBjeT0iMi41IiByPSIyLjUiPjwvY2lyY2xlPgo8L3N2Zz4K') 14px 8px no-repeat;\n  line-height: 24px;\n}\n\n.report-section__item-details {\n  display: flex;\n}\n\n.report-section__item-category {\n  font-weight: 700;\n}\n\n.report-section__item-extended-info {\n  font-size: 15px;\n  color: #555;\n  font-style: italic;\n  margin: 0px 0px 16px 24px;\n  max-width: 90%;\n}\n\n.report-section__item-extended-info:empty {\n  margin: 0;\n}\n\n.report-section__item-helptext {\n  font-size: 14px;\n  color: #999;\n  font-style: italic;\n  padding: 8px 0px 16px 24px;\n  max-width: 90%;\n}\n\n.report-section__item-help-toggle {\n  color: currentColor;\n  border-radius: 50%;\n  width: 21px;\n  height: 21px;\n  display: inline-flex;\n  justify-content: center;\n  align-items: center;\n  cursor: pointer;\n  transition: all 0.2s cubic-bezier(0,0,0.3,1);\n  font-size: 90%;\n  font-weight: 600;\n  margin-left: 8px;\n  vertical-align: top;\n  opacity: 0.6;\n  box-shadow: 0 1px 2px rgba(0,0,0,0.5);\n}\n\n.report-section__item-help-toggle:hover {\n  opacity: 1;\n  box-shadow: 0 1px 2px rgba(0,0,0,0.7);\n}\n\n.report-section__item-raw-value {\n  color: #777;\n}\n\n.report-section__item-description {\n  flex: 1;\n}\n\n.footer {\n  margin-top: 40px;\n  margin-left: var(--report-menu-width);\n  height: 130px;\n  line-height: 90px;\n  text-align: center;\n  font-size: 12px;\n  border-top: 1px solid #EBEBEB;\n  color: #999;\n}\n\n.coming-soon, .coming-soon * {\n  color: #AAA;\n}\n\n.coming-soon .report-section__item-value {\n  font-size: 70%;\n}\n\n.devtabs {\n  flex: 0 1 auto;\n  background: right 0 / auto 27px no-repeat url(tabs_right.png),\n              0 0 / auto 27px no-repeat url(tabs_left.png),\n              0 0 / auto 27px repeat-x url(tabs_center.png);\n  height: 27px;\n}\n\n.aggregations__header {\n  position: relative;\n}\n\n.aggregations__header > h1 {\n  font-size: var(--heading-font-size);\n  font-weight: normal;\n  line-height: var(--heading-line-height);\n}\n\n.aggregations {\n  padding: var(--heading-line-height);\n  padding-left: calc(var(--heading-line-height) + var(--gutter-width) + var(--gutter-gap));\n}\n\n.aggregations:not(:first-child) {\n  border-top: 1px solid #ccc;\n}\n\n.aggregations__desc {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  margin-top: calc(var(--body-line-height) / 2);\n}\n\n.section-result {\n  position: absolute;\n  top: 0;\n  left: calc((var(--gutter-width) + var(--gutter-gap)) * -1);\n  width: var(--gutter-width);\n\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n\n.section-result__score {\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  background: #000;\n  color: #fff;\n  text-align: center;\n  padding: 4px 8px;\n  border-radius: 2px;\n}\n\n.section-result__points {\n  font-size: var(--heading-font-size);\n}\n\n.section-result__divider {\n  display: none;\n}\n\n.section-result__total {\n  font-size: var(--body-font-size);\n  margin-top: 2px;\n  border-top: 1px solid #fff;\n  padding-top: 4px;\n}\n\n.aggregation__header {\n  max-width: var(--max-line-length);\n}\n\n.aggregation__header > h2 {\n  font-size: var(--subheading-font-size);\n  font-weight: normal;\n  line-height: var(--subheading-line-height);\n  color: var(--subheading-color);\n}\n\n.aggregation {\n  margin-top: var(--subheading-line-height);\n  max-width: var(--max-line-length);\n}\n\n.aggregation__desc {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  margin-top: calc(var(--body-line-height) / 2);\n}\n\n.subitems {\n  list-style: none;\n  margin-top: var(--subitem-line-height);\n}\n\n.subitem {\n  position: relative;\n  font-size: var(--subitem-font-size);\n  padding-left: calc(var(--subitem-indent) + var(--gutter-width) + var(--gutter-gap));\n  margin-top: calc(var(--subitem-line-height) / 2);\n}\n\n.subitem.--coming-soon {\n  color: var(--secondary-text-color);\n}\n\n.subitem strong {\n  font-weight: bold;\n}\n\n.subitem small {\n  font-size: var(--body-font-size);\n}\n\n.subitem__desc {\n  line-height: var(--subitem-line-height);\n}\n\n.subitem-result {\n  position: absolute;\n  top: 0;\n  left: var(--subitem-indent);\n  width: var(--gutter-width);\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n\n.subitem-result__good, .subitem-result__poor, .subitem-result__unknown {\n  position: relative;\n  display: block;\n  overflow: hidden;\n  margin-top: calc((var(--subitem-line-height) - 16px) / 2);\n  width: 16px;\n  height: 16px;\n  border-radius: 50%;\n  color: transparent;\n  background-color: #000;\n}\n\n.subitem-result__good::after, .subitem-result__poor::after, .subitem-result__unknown::after {\n  content: '';\n  position: absolute;\n  left: 0;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  -webkit-mask: center center / 12px 12px no-repeat;\n  background-color: #fff;\n}\n\n.subitem-result__good::after { -webkit-mask-image: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>good</title><path d=\"M9.17 2.33L4.5 7 2.83 5.33 1.5 6.66l3 3 6-6z\" fill=\"#FFF\" fill-rule=\"evenodd\"/></svg>'); }\n.subitem-result__poor::after { -webkit-mask-image: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>poor</title><path d=\"M8.33 2.33l1.33 1.33-2.335 2.335L9.66 8.33 8.33 9.66 5.995 7.325 3.66 9.66 2.33 8.33l2.335-2.335L2.33 3.66l1.33-1.33 2.335 2.335z\" fill=\"#FFF\" fill-rule=\"evenodd\"/></svg>'); }\n.subitem-result__unknown::after { -webkit-mask-image: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>neutral</title><path d=\"M2 5h8v2H2z\" fill=\"#FFF\" fill-rule=\"evenodd\"/></svg>'); }\n\n.subitem-result__points {\n  margin-top: calc((var(--subitem-line-height) - var(--subitem-font-size) - 4px) / 2);\n  background: #000;\n  padding: 2px 4px;\n  border-radius: 1px;\n  color: #fff;\n  border-radius: 2px;\n}\n\n.subitem__details {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  margin-left: var(--subitem-indent);\n}\n\n.subitem__detail {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  margin-top: calc(var(--body-line-height) / 2);\n}\n\n.subitem__help-toggle {\n  -webkit-appearance: none;\n  position: relative;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  border-radius: 50%;\n  border: 1px solid #ccc;\n  vertical-align: middle;\n  margin-left: .5em;\n  outline: 0;\n}\n\n.subitem__help-toggle::after {\n  content: '';\n  position: absolute;\n  left: 0;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  -webkit-mask: 1px 1px / 12px 12px no-repeat;\n  -webkit-mask-image: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>help</title><path d=\"M5.216 7.457c0-.237.011-.452.033-.645.021-.194.058-.372.11-.535a1.918 1.918 0 0 1 .55-.847 3.65 3.65 0 0 0 .545-.597c.133-.19.2-.398.2-.623 0-.28-.053-.485-.16-.616-.107-.13-.268-.196-.482-.196a.583.583 0 0 0-.457.207.834.834 0 0 0-.15.271c-.04.111-.062.244-.065.398H3.67c.003-.401.067-.745.19-1.032a1.96 1.96 0 0 1 .5-.707c.208-.185.455-.32.738-.406A3.13 3.13 0 0 1 6.012 2c.359 0 .682.046.968.137.287.091.53.227.729.406.2.18.352.401.457.667.105.265.158.571.158.919 0 .233-.03.44-.091.624-.061.182-.145.353-.252.51-.107.158-.233.311-.378.46-.145.149-.3.306-.465.47a2.084 2.084 0 0 0-.24.275c-.063.09-.115.183-.152.282a1.57 1.57 0 0 0-.084.323 2.966 2.966 0 0 0-.033.384H5.216zm-.202 1.634a.96.96 0 0 1 .067-.36.828.828 0 0 1 .19-.287.913.913 0 0 1 .291-.191.969.969 0 0 1 .376-.07c.138 0 .263.023.375.07.112.046.21.11.292.19.082.081.146.177.19.288a.96.96 0 0 1 .067.36.96.96 0 0 1-.067.36.828.828 0 0 1-.19.288.913.913 0 0 1-.292.191.969.969 0 0 1-.375.07.969.969 0 0 1-.376-.07.913.913 0 0 1-.291-.19.828.828 0 0 1-.19-.288.96.96 0 0 1-.067-.36z\" fill=\"#000\" fill-rule=\"evenodd\"/></svg>');\n  background-color: var(--secondary-text-color);\n  cursor: pointer;\n}\n\n.subitem__help-toggle:hover {\n  border-color: var(--secondary-text-color);\n}\n\n.subitem__help-toggle:checked {\n  background-color: var(--accent-color);\n  border-color: var(--accent-color);\n}\n\n.subitem__help-toggle:checked::after {\n  background-color: #fff;\n}\n\n.subitem__help {\n  display: none;\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  margin-top: calc(var(--body-line-height) / 2);\n  margin-left: var(--subitem-indent);\n}\n\n.subitem__help-toggle:checked + .subitem__help {\n  display: block;\n}\n\n.subitem__debug {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  margin-top: calc(var(--body-line-height) / 2);\n  margin-left: var(--subitem-indent);\n  color: var(--poor-color);\n}\n\n.score-good-bg {\n  background-color: var(--good-color);\n}\n.score-average-bg {\n  background-color: var(--average-color);\n}\n.score-poor-bg {\n  background-color: var(--poor-color);\n}\n.score-unknown-bg {\n  background-color: var(--unknown-color);\n}\n\n.export-section {\n  position: relative;\n}\n\n.export-button {\n  display: inline-flex;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  box-sizing: border-box;\n  min-width: 5.14em;\n  padding: 0.7em 1.1em;\n  letter-spacing: 0.02em;\n  border-radius: 3px;\n  cursor: pointer;\n  color: var(--secondary-text-color);\n  outline: 0;\n  font-weight: 500;\n  display: none;\n}\n\n.export-dropdown {\n  position: absolute;\n  background-color: #fafafa;\n  border: 1px solid #ccc;\n  border-radius: 3px;\n  margin: 0;\n  padding: 8px 0;\n  cursor: pointer;\n  top: 36px;\n  left: 0;\n  z-index: 1;\n  box-shadow: 1px 1px 3px #ccc;\n  min-width: 125px;\n  list-style: none;\n  line-height: 1.5em;\n  visibility: hidden;\n  clip: rect(0, 140px, 0, 0);\n  opacity: 0;\n  transition: all 200ms cubic-bezier(0,0,0.2,1);\n}\n\n.export-button:focus,\n.export-button.active {\n  box-shadow: 1px 1px 3px #ccc;\n}\n\n.export-button.active + .export-dropdown {\n  visibility: visible;\n  opacity: 1;\n  clip: rect(0, 140px, 200px, 0);\n}\n\n.export-dropdown a {\n  display: block;\n  color: currentColor;\n  text-decoration: none;\n  white-space: nowrap;\n  padding: 0 12px;\n}\n\n.export-dropdown a:hover,\n.export-dropdown a:focus {\n  background-color: rgb(239,239,239);\n  outline: 0;\n}\n\n@media print {\n  body {\n    -webkit-print-color-adjust: exact; /* print background colors */\n  }\n\n  .report {\n    box-shadow: none;\n  }\n\n  .report-body__header,\n  .report-body__menu-container {\n    display: none;\n  }\n\n  .report-body__content {\n    margin-left: 0;\n  }\n}\n\n\n@media screen and (max-width: 400px) {\n  .report-body__metadata {\n    margin-right: 8px;\n    max-width: 65%;\n  }\n}\n\n@media screen and (max-width: 767px) {\n  :root {\n    --subitem-indent: 8px;\n    --gutter-width: 16px;\n  }\n  .aggregations {\n    padding-right: 8px;\n  }\n  .report-body__menu-container {\n    display: none;\n  }\n  .report-body__content,\n  .report-body__header {\n    margin-left: 0;\n  }\n  .report-body__header {\n    width: 100%;\n    padding: 8px;\n  }\n  .export-dropdown {\n    right: 0;\n    left: initial;\n  }\n  .footer {\n    margin-top: 0;\n    margin-left: 0;\n    height: auto;\n  }\n}\n\n:root[data-report-context=\"devtools\"] .report {\n  margin: 10px 10px;\n  padding: 10px;\n  box-shadow: none;\n  max-width: none;\n  width: auto;\n}\n\n:root[data-report-context=\"devtools\"] .report-body__aggregations-container > section:first-child {\n  padding-top: calc(var(--heading-line-height) / 3);\n}\n:root[data-report-context=\"devtools\"] .report-body__menu-container {\n  display: none;\n}\n\n:root[data-report-context=\"devtools\"] .report-body__header {\n  display: none;\n}\n\n:root[data-report-context=\"devtools\"] .report-body__content {\n  margin-left: 0;\n}\n\n:root[data-report-context=\"devtools\"] .footer {\n  display: none;\n}\n\n:root[data-report-context=\"viewer\"] .share,\n:root[data-report-context=\"viewer\"] .export-button {\n  display: initial;\n}\n";}
getReportJS(reportContext){if(reportContext==='devtools'){return[];}else{return["/**\n * @license\n * Copyright 2016 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/* global window, document */\n\n'use strict';\n\nwindow.addEventListener('DOMContentLoaded', _ => {\n  const printButton = document.querySelector('.js-print');\n  printButton.addEventListener('click', _ => {\n    window.print();\n  });\n});\n"];}}
_createPWAAuditsByCategory(aggregations){const items={};aggregations.forEach(aggregation=>{if(!aggregation.categorizable){return;}
aggregation.score.forEach(score=>{score.subItems.forEach(subItem=>{if(!items[subItem.category]){items[subItem.category]={};}
if(!items[subItem.category][subItem.name]){items[subItem.category][subItem.name]=subItem;}});});});return items;}
renderException(err,results){const template=Handlebars.compile(this.getExceptionTemplate());return template({errMessage:err.message,errStack:err.stack,css:this.getReportCSS(),results:JSON.stringify(results,null,2)});}
generateHTML(results,reportContext){reportContext=reportContext||'extension';Object.keys(results.audits).forEach(audit=>{audit=results.audits[audit];if(!audit.extendedInfo){return;}
if(!audit.extendedInfo.formatter){return;}
const formatter=Formatter.getByName(audit.extendedInfo.formatter);const helpers=formatter.getHelpers();if(helpers){Handlebars.registerHelper(helpers);}
Handlebars.registerPartial(audit.name,formatter.getFormatter('html'));});results.aggregations.forEach(aggregation=>{aggregation.score.forEach(score=>{score.subItems=score.subItems.map(subItem=>results.audits[subItem]||subItem);});});const template=Handlebars.compile(this.getReportTemplate());return template({url:results.url,lighthouseVersion:results.lighthouseVersion,generatedTime:this._formatTime(results.generatedTime),lhresults:this._escapeScriptTags(JSON.stringify(results,null,2)),css:this.getReportCSS(),reportContext:reportContext,scripts:this.getReportJS(reportContext),aggregations:results.aggregations,auditsByCategory:this._createPWAAuditsByCategory(results.aggregations)});}}
module.exports=ReportGenerator;},{"../formatters/formatter":8,"handlebars":276,"marked":281,"path":204}],33:[function(require,module,exports){(function(process,__dirname){'use strict';const Driver=require('./gather/driver.js');const GatherRunner=require('./gather/gather-runner');const Aggregate=require('./aggregator/aggregate');const Audit=require('./audits/audit');const log=require('./lib/log');const path=require('path');const URL=require('./lib/url-shim');class Runner{static run(connection,opts){opts.flags=opts.flags||{};const config=opts.config;opts.initialUrl=opts.url;if(typeof opts.initialUrl!=='string'||opts.initialUrl.length===0){return Promise.reject(new Error('You must provide a url to the driver'));}
let parsedURL;try{parsedURL=new URL(opts.url);}catch(e){const err=new Error('The url provided should have a proper protocol and hostname.');return Promise.reject(err);}
if(parsedURL.protocol!=='https:'&&parsedURL.hostname!=='localhost'){log.warn('Lighthouse','The URL provided should be on HTTPS');log.warn('Lighthouse','Performance stats will be skewed redirecting from HTTP to HTTPS.');}
opts.url=parsedURL.href;const validPassesAndAudits=config.passes&&config.audits;const validArtifactsAndAudits=config.artifacts&&config.audits;let run=Promise.resolve();if(validPassesAndAudits||validArtifactsAndAudits){if(validPassesAndAudits){opts.driver=opts.driverMock||new Driver(connection);run=run.then(_=>GatherRunner.run(config.passes,opts));}else if(validArtifactsAndAudits){run=run.then(_=>{return Object.assign(GatherRunner.instantiateComputedArtifacts(),config.artifacts);});}
run=run.then(artifacts=>{for(const passName of Object.keys(artifacts.traces||{})){const trace=artifacts.traces[passName];if(!Array.isArray(trace.traceEvents)){throw new Error(passName+' trace was invalid. `traceEvents` was not an array.');}}
return artifacts;});const auditResults=[];for(const audit of config.audits){run=run.then(artifacts=>{return Runner._runAudit(audit,artifacts).then(ret=>auditResults.push(ret)).then(_=>artifacts);});}
run=run.then(artifacts=>{return{artifacts,auditResults};});}else if(config.auditResults){const artifacts=Object.assign(GatherRunner.instantiateComputedArtifacts(),config.artifacts||{});run=run.then(_=>{return{artifacts,auditResults:config.auditResults};});}else{const err=Error('The config must provide passes and audits, artifacts and audits, or auditResults');return Promise.reject(err);}
run=run.then(runResults=>{const formattedAudits=runResults.auditResults.reduce((formatted,audit)=>{formatted[audit.name]=audit;return formatted;},{});let aggregations=[];if(config.aggregations){aggregations=config.aggregations.map(a=>Aggregate.aggregate(a,runResults.auditResults));}
return{lighthouseVersion:require('../package').version,generatedTime:(new Date()).toJSON(),initialUrl:opts.initialUrl,url:opts.url,audits:formattedAudits,artifacts:runResults.artifacts,aggregations};});return run;}
static _runAudit(audit,artifacts){const status=`Evaluating: ${audit.meta.description}`;return Promise.resolve().then(_=>{log.log('status',status);for(const artifactName of audit.meta.requiredArtifacts){const noArtifact=typeof artifacts[artifactName]==='undefined';const noTrace=artifactName==='traces'&&!artifacts.traces[Audit.DEFAULT_PASS];if(noArtifact||noTrace){log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name}, did not run.`);return audit.generateAuditResult({rawValue:-1,debugString:`Required ${artifactName} gatherer did not run.`});}}
return audit.audit(artifacts);}).then(result=>{log.verbose('statusEnd',status);return result;});}
static getAuditList(){const fileList=[...["accessibility","audit.js","cache-start-url.js","content-width.js","critical-request-chains.js","dobetterweb","estimated-input-latency.js","first-meaningful-paint.js","is-on-https.js","manifest-background-color.js","manifest-display.js","manifest-exists.js","manifest-icons-min-144.js","manifest-icons-min-192.js","manifest-name.js","manifest-short-name-length.js","manifest-short-name.js","manifest-start-url.js","manifest-theme-color.js","redirects-http.js","screenshots.js","service-worker.js","speed-index-metric.js","theme-color-meta.js","time-to-interactive.js","unused-css-rules.js","user-timings.js","viewport.js","without-javascript.js","works-offline.js"],...["appcache-manifest.js","external-anchors-use-rel-noopener.js","geolocation-on-start.js","link-blocking-first-paint.js","no-console-time.js","no-datenow.js","no-document-write.js","no-mutation-events.js","no-old-flexbox.js","no-websql.js","notification-on-start.js","script-blocking-first-paint.js","uses-http2.js","uses-passive-event-listeners.js"].map(f=>`dobetterweb/${f}`),...["aria-allowed-attr.js","aria-required-attr.js","aria-valid-attr-value.js","aria-valid-attr.js","axe-audit.js","color-contrast.js","image-alt.js","label.js","tabindex.js"].map(f=>`accessibility/${f}`)];return fileList.filter(f=>{return/\.js$/.test(f)&&f!=='audit.js'&&f!=='accessibility/axe-audit.js';}).sort();}
static getGathererList(){const fileList=[...["accessibility.js","cache-contents.js","content-width.js","css-usage.js","dobetterweb","gatherer.js","html-without-javascript.js","html.js","http-redirect.js","https.js","manifest.js","offline.js","service-worker.js","styles.js","theme-color.js","url.js","viewport.js"],...["all-event-listeners.js","anchors-with-no-rel-noopener.js","appcache.js","console-time-usage.js","datenow.js","document-write.js","geolocation-on-start.js","notification-on-start.js","tags-blocking-first-paint.js","websql.js"].map(f=>`dobetterweb/${f}`)];return fileList.filter(f=>/\.js$/.test(f)&&f!=='gatherer.js').sort();}
static resolvePlugin(plugin,configDir,category){try{return require.resolve(plugin);}catch(e){}
const cwdPath=path.resolve(process.cwd(),plugin);try{return require.resolve(cwdPath);}catch(e){}
const errorString='Unable to locate '+
(category?`${category}: `:'')+`${plugin} (tried to require() from '${__dirname}' and load from '${cwdPath}'`;if(!configDir){throw new Error(errorString+')');}
const relativePath=path.resolve(configDir,plugin);try{return require.resolve(relativePath);}catch(requireError){}
throw new Error(errorString+` and '${relativePath}')`);}}
module.exports=Runner;}).call(this,require('_process'),"/../lighthouse-core")},{"../package":286,"./aggregator/aggregate":1,"./audits/audit":3,"./gather/driver.js":16,"./gather/gather-runner":17,"./lib/log":24,"./lib/url-shim":30,"_process":205,"path":204}],34:[function(require,module,exports){(function(global){"use strict";'use strict';global.tr=function(){if(global.tr){console.warn('Base was multiply initialized. First init wins.');return global.tr;}function exportPath(name){var parts=name.split('.');var cur=global;for(var part;parts.length&&(part=parts.shift());){if(part in cur){cur=cur[part];}else{cur=cur[part]={};}}return cur;};function isExported(name){var parts=name.split('.');var cur=global;for(var part;parts.length&&(part=parts.shift());){if(part in cur){cur=cur[part];}else{return false;}}return true;}function isDefined(name){var parts=name.split('.');var curObject=global;for(var i=0;i<parts.length;i++){var partName=parts[i];var nextObject=curObject[partName];if(nextObject===undefined)return false;curObject=nextObject;}return true;}var panicElement=undefined;var rawPanicMessages=[];function showPanicElementIfNeeded(){if(panicElement)return;var panicOverlay=document.createElement('div');panicOverlay.style.backgroundColor='white';panicOverlay.style.border='3px solid red';panicOverlay.style.boxSizing='border-box';panicOverlay.style.color='black';panicOverlay.style.display='-webkit-flex';panicOverlay.style.height='100%';panicOverlay.style.left=0;panicOverlay.style.padding='8px';panicOverlay.style.position='fixed';panicOverlay.style.top=0;panicOverlay.style.webkitFlexDirection='column';panicOverlay.style.width='100%';panicElement=document.createElement('div');panicElement.style.webkitFlex='1 1 auto';panicElement.style.overflow='auto';panicOverlay.appendChild(panicElement);if(!document.body){setTimeout(function(){document.body.appendChild(panicOverlay);},150);}else{document.body.appendChild(panicOverlay);}}function showPanic(panicTitle,panicDetails){if(tr.isHeadless){if(panicDetails instanceof Error)throw panicDetails;throw new Error('Panic: '+panicTitle+':\n'+panicDetails);}if(panicDetails instanceof Error)panicDetails=panicDetails.stack;showPanicElementIfNeeded();var panicMessageEl=document.createElement('div');panicMessageEl.innerHTML='<h2 id="message"></h2>'+'<pre id="details"></pre>';panicMessageEl.querySelector('#message').textContent=panicTitle;panicMessageEl.querySelector('#details').textContent=panicDetails;panicElement.appendChild(panicMessageEl);rawPanicMessages.push({title:panicTitle,details:panicDetails});}function hasPanic(){return rawPanicMessages.length!==0;}function getPanicText(){return rawPanicMessages.map(function(msg){return msg.title;}).join(', ');}function exportTo(namespace,fn){var obj=exportPath(namespace);var exports=fn();for(var propertyName in exports){var propertyDescriptor=Object.getOwnPropertyDescriptor(exports,propertyName);if(propertyDescriptor)Object.defineProperty(obj,propertyName,propertyDescriptor);}};function initialize(){if(global.isVinn){tr.isVinn=true;}else if(global.process&&global.process.versions.node){tr.isNode=true;}else{tr.isVinn=false;tr.isNode=false;tr.doc=document;tr.isMac=/Mac/.test(navigator.platform);tr.isWindows=/Win/.test(navigator.platform);tr.isChromeOS=/CrOS/.test(navigator.userAgent);tr.isLinux=/Linux/.test(navigator.userAgent);}tr.isHeadless=tr.isVinn||tr.isNode;}return{initialize:initialize,exportTo:exportTo,isExported:isExported,isDefined:isDefined,showPanic:showPanic,hasPanic:hasPanic,getPanicText:getPanicText};}();tr.initialize();}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{}],35:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function Base64(){}function b64ToUint6(nChr){if(nChr>64&&nChr<91)return nChr-65;if(nChr>96&&nChr<123)return nChr-71;if(nChr>47&&nChr<58)return nChr+4;if(nChr===43)return 62;if(nChr===47)return 63;return 0;}Base64.getDecodedBufferLength=function(input){return input.length*3+1>>2;};Base64.EncodeArrayBufferToString=function(input){var binary='';var bytes=new Uint8Array(input);var len=bytes.byteLength;for(var i=0;i<len;i++)binary+=String.fromCharCode(bytes[i]);return btoa(binary);};Base64.DecodeToTypedArray=function(input,output){var nInLen=input.length;var nOutLen=nInLen*3+1>>2;var nMod3=0;var nMod4=0;var nUint24=0;var nOutIdx=0;if(nOutLen>output.byteLength)throw new Error('Output buffer too small to decode.');for(var nInIdx=0;nInIdx<nInLen;nInIdx++){nMod4=nInIdx&3;nUint24|=b64ToUint6(input.charCodeAt(nInIdx))<<18-6*nMod4;if(nMod4===3||nInLen-nInIdx===1){for(nMod3=0;nMod3<3&&nOutIdx<nOutLen;nMod3++,nOutIdx++){output.setUint8(nOutIdx,nUint24>>>(16>>>nMod3&24)&255);}nUint24=0;}}return nOutIdx-1;};Base64.btoa=function(input){return btoa(input);};Base64.atob=function(input){return atob(input);};return{Base64:Base64};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],36:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){var categoryPartsFor={};function getCategoryParts(category){var parts=categoryPartsFor[category];if(parts!==undefined)return parts;parts=category.split(',');categoryPartsFor[category]=parts;return parts;}return{getCategoryParts:getCategoryParts};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],37:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function clamp01(value){return Math.max(0,Math.min(1,value));}function Color(opt_r,opt_g,opt_b,opt_a){this.r=Math.floor(opt_r)||0;this.g=Math.floor(opt_g)||0;this.b=Math.floor(opt_b)||0;this.a=opt_a;}Color.fromString=function(str){var tmp;var values;if(str.substr(0,4)=='rgb('){tmp=str.substr(4,str.length-5);values=tmp.split(',').map(function(v){return v.replace(/^\s+/,'','g');});if(values.length!=3)throw new Error('Malformatted rgb-expression');return new Color(parseInt(values[0]),parseInt(values[1]),parseInt(values[2]));}else if(str.substr(0,5)=='rgba('){tmp=str.substr(5,str.length-6);values=tmp.split(',').map(function(v){return v.replace(/^\s+/,'','g');});if(values.length!=4)throw new Error('Malformatted rgb-expression');return new Color(parseInt(values[0]),parseInt(values[1]),parseInt(values[2]),parseFloat(values[3]));}else if(str[0]=='#'&&str.length==7){return new Color(parseInt(str.substr(1,2),16),parseInt(str.substr(3,2),16),parseInt(str.substr(5,2),16));}else{throw new Error('Unrecognized string format.');}};Color.lerp=function(a,b,percent){if(a.a!==undefined&&b.a!==undefined)return Color.lerpRGBA(a,b,percent);return Color.lerpRGB(a,b,percent);};Color.lerpRGB=function(a,b,percent){return new Color((b.r-a.r)*percent+a.r,(b.g-a.g)*percent+a.g,(b.b-a.b)*percent+a.b);};Color.lerpRGBA=function(a,b,percent){return new Color((b.r-a.r)*percent+a.r,(b.g-a.g)*percent+a.g,(b.b-a.b)*percent+a.b,(b.a-a.a)*percent+a.a);};Color.fromDict=function(dict){return new Color(dict.r,dict.g,dict.b,dict.a);};Color.fromHSLExplicit=function(h,s,l,a){var r,g,b;function hue2rgb(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p;}if(s===0){r=g=b=l;}else{var q=l<0.5?l*(1+s):l+s-l*s;var p=2*l-q;r=hue2rgb(p,q,h+1/3);g=hue2rgb(p,q,h);b=hue2rgb(p,q,h-1/3);}return new Color(Math.floor(r*255),Math.floor(g*255),Math.floor(b*255),a);};Color.fromHSL=function(hsl){return Color.fromHSLExplicit(hsl.h,hsl.s,hsl.l,hsl.a);};Color.prototype={clone:function(){var c=new Color();c.r=this.r;c.g=this.g;c.b=this.b;c.a=this.a;return c;},blendOver:function(bgColor){var oneMinusThisAlpha=1-this.a;var outA=this.a+bgColor.a*oneMinusThisAlpha;var bgBlend=bgColor.a*oneMinusThisAlpha/bgColor.a;return new Color(this.r*this.a+bgColor.r*bgBlend,this.g*this.a+bgColor.g*bgBlend,this.b*this.a+bgColor.b*bgBlend,outA);},brighten:function(opt_k){var k;k=opt_k||0.45;return new Color(Math.min(255,this.r+Math.floor(this.r*k)),Math.min(255,this.g+Math.floor(this.g*k)),Math.min(255,this.b+Math.floor(this.b*k)),this.a);},lighten:function(k,opt_maxL){var maxL=opt_maxL!==undefined?opt_maxL:1.0;var hsl=this.toHSL();hsl.l=clamp01(hsl.l+k);return Color.fromHSL(hsl);},darken:function(opt_k){var k;if(opt_k!==undefined)k=opt_k;else k=0.45;return new Color(Math.min(255,this.r-Math.floor(this.r*k)),Math.min(255,this.g-Math.floor(this.g*k)),Math.min(255,this.b-Math.floor(this.b*k)),this.a);},desaturate:function(opt_desaturateFactor){var desaturateFactor;if(opt_desaturateFactor!==undefined)desaturateFactor=opt_desaturateFactor;else desaturateFactor=1;var hsl=this.toHSL();hsl.s=clamp01(hsl.s*(1-desaturateFactor));return Color.fromHSL(hsl);},withAlpha:function(a){return new Color(this.r,this.g,this.b,a);},toString:function(){if(this.a!==undefined){return'rgba('+this.r+','+this.g+','+this.b+','+this.a+')';}return'rgb('+this.r+','+this.g+','+this.b+')';},toHSL:function(){var r=this.r/255;var g=this.g/255;var b=this.b/255;var max=Math.max(r,g,b);var min=Math.min(r,g,b);var h,s;var l=(max+min)/2;if(min===max){h=0;s=0;}else{var delta=max-min;if(l>0.5)s=delta/(2-max-min);else s=delta/(max+min);if(r===max){h=(g-b)/delta;if(g<b)h+=6;}else if(g===max){h=2+(b-r)/delta;}else{h=4+(r-g)/delta;}h/=6;}return{h:h,s:s,l:l,a:this.a};},toStringWithAlphaOverride:function(alpha){return'rgba('+this.r+','+this.g+','+this.b+','+alpha+')';}};return{Color:Color};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],38:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./color.js");require("./iteration_helpers.js");'use strict';global.tr.exportTo('tr.b',function(){var generalPurposeColors=[new tr.b.Color(122,98,135),new tr.b.Color(150,83,105),new tr.b.Color(44,56,189),new tr.b.Color(99,86,147),new tr.b.Color(104,129,107),new tr.b.Color(130,178,55),new tr.b.Color(87,109,147),new tr.b.Color(111,145,88),new tr.b.Color(81,152,131),new tr.b.Color(142,91,111),new tr.b.Color(81,163,70),new tr.b.Color(148,94,86),new tr.b.Color(144,89,118),new tr.b.Color(83,150,97),new tr.b.Color(105,94,139),new tr.b.Color(89,144,122),new tr.b.Color(105,119,128),new tr.b.Color(96,128,137),new tr.b.Color(145,88,145),new tr.b.Color(88,145,144),new tr.b.Color(90,100,143),new tr.b.Color(121,97,136),new tr.b.Color(111,160,73),new tr.b.Color(112,91,142),new tr.b.Color(86,147,86),new tr.b.Color(63,100,170),new tr.b.Color(81,152,107),new tr.b.Color(60,164,173),new tr.b.Color(143,72,161),new tr.b.Color(159,74,86)];var reservedColorsByName={thread_state_uninterruptible:new tr.b.Color(182,125,143),thread_state_iowait:new tr.b.Color(255,140,0),thread_state_running:new tr.b.Color(126,200,148),thread_state_runnable:new tr.b.Color(133,160,210),thread_state_sleeping:new tr.b.Color(240,240,240),thread_state_unknown:new tr.b.Color(199,155,125),background_memory_dump:new tr.b.Color(0,180,180),light_memory_dump:new tr.b.Color(0,0,180),detailed_memory_dump:new tr.b.Color(180,0,180),generic_work:new tr.b.Color(125,125,125),good:new tr.b.Color(0,125,0),bad:new tr.b.Color(180,125,0),terrible:new tr.b.Color(180,0,0),black:new tr.b.Color(0,0,0),rail_response:new tr.b.Color(67,135,253),rail_animation:new tr.b.Color(244,74,63),rail_idle:new tr.b.Color(238,142,0),rail_load:new tr.b.Color(13,168,97),startup:new tr.b.Color(230,230,0),used_memory_column:new tr.b.Color(0,0,255),older_used_memory_column:new tr.b.Color(153,204,255),tracing_memory_column:new tr.b.Color(153,153,153),heap_dump_stack_frame:new tr.b.Color(128,128,128),heap_dump_object_type:new tr.b.Color(0,0,255),heap_dump_child_node_arrow:new tr.b.Color(204,102,0),cq_build_running:new tr.b.Color(255,255,119),cq_build_passed:new tr.b.Color(153,238,102),cq_build_failed:new tr.b.Color(238,136,136),cq_build_abandoned:new tr.b.Color(187,187,187),cq_build_attempt_runnig:new tr.b.Color(222,222,75),cq_build_attempt_passed:new tr.b.Color(103,218,35),cq_build_attempt_failed:new tr.b.Color(197,81,81)};var numGeneralPurposeColorIds=generalPurposeColors.length;var numReservedColorIds=tr.b.dictionaryLength(reservedColorsByName);var numColorsPerVariant=numGeneralPurposeColorIds+numReservedColorIds;function ColorScheme(){}var paletteBase=[];paletteBase.push.apply(paletteBase,generalPurposeColors);paletteBase.push.apply(paletteBase,tr.b.dictionaryValues(reservedColorsByName));ColorScheme.colors=[];ColorScheme.properties={};ColorScheme.properties={numColorsPerVariant:numColorsPerVariant};function pushVariant(func){var variantColors=paletteBase.map(func);ColorScheme.colors.push.apply(ColorScheme.colors,variantColors);}pushVariant(function(c){return c;});ColorScheme.properties.brightenedOffsets=[];ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.lighten(0.3,0.9);});ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.lighten(0.48,0.9);});ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.lighten(0.65,0.9);});ColorScheme.properties.dimmedOffsets=[];ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.desaturate();});ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.desaturate(0.5);});ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.desaturate(0.3);});ColorScheme.colorsAsStrings=ColorScheme.colors.map(function(c){return c.toString();});var reservedColorNameToIdMap=function(){var m=new Map();var i=generalPurposeColors.length;tr.b.iterItems(reservedColorsByName,function(key,value){m.set(key,i++);});return m;}();ColorScheme.getColorIdForReservedName=function(name){var id=reservedColorNameToIdMap.get(name);if(id===undefined)throw new Error('Unrecognized color ')+name;return id;};ColorScheme.getColorForReservedNameAsString=function(reservedName){var id=ColorScheme.getColorIdForReservedName(reservedName);return ColorScheme.colorsAsStrings[id];};ColorScheme.getStringHash=function(name){var hash=0;for(var i=0;i<name.length;++i)hash=(hash+37*hash+11*name.charCodeAt(i))%0xFFFFFFFF;return hash;};var stringColorIdCache=new Map();ColorScheme.getColorIdForGeneralPurposeString=function(string){if(stringColorIdCache.get(string)===undefined){var hash=ColorScheme.getStringHash(string);stringColorIdCache.set(string,hash%numGeneralPurposeColorIds);}return stringColorIdCache.get(string);};return{ColorScheme:ColorScheme};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34,"./color.js":37,"./iteration_helpers.js":47}],39:[function(require,module,exports){(function(global){"use strict";require("./event_target.js");'use strict';global.tr.exportTo('tr.b',function(){var Event;if(tr.isHeadless){function HeadlessEvent(type,opt_bubbles,opt_preventable){this.type=type;this.bubbles=opt_bubbles!==undefined?!!opt_bubbles:false;this.cancelable=opt_preventable!==undefined?!!opt_preventable:false;this.defaultPrevented=false;this.cancelBubble=false;};HeadlessEvent.prototype={preventDefault:function(){this.defaultPrevented=true;},stopPropagation:function(){this.cancelBubble=true;}};Event=HeadlessEvent;}else{function TrEvent(type,opt_bubbles,opt_preventable){var e=tr.doc.createEvent('Event');e.initEvent(type,!!opt_bubbles,!!opt_preventable);e.__proto__=global.Event.prototype;return e;};TrEvent.prototype={__proto__:global.Event.prototype};Event=TrEvent;}function dispatchSimpleEvent(target,type,opt_bubbles,opt_cancelable,opt_fields){var e=new tr.b.Event(type,opt_bubbles,opt_cancelable);if(opt_fields){tr.b.iterItems(opt_fields,function(name,value){e[name]=value;});}return target.dispatchEvent(e);}return{Event:Event,dispatchSimpleEvent:dispatchSimpleEvent};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./event_target.js":40}],40:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function EventTarget(){}EventTarget.decorate=function(target){for(var k in EventTarget.prototype){if(k=='decorate')continue;var v=EventTarget.prototype[k];if(typeof v!=='function')continue;target[k]=v;}};EventTarget.prototype={addEventListener:function(type,handler){if(!this.listeners_)this.listeners_=Object.create(null);if(!(type in this.listeners_)){this.listeners_[type]=[handler];}else{var handlers=this.listeners_[type];if(handlers.indexOf(handler)<0)handlers.push(handler);}},removeEventListener:function(type,handler){if(!this.listeners_)return;if(type in this.listeners_){var handlers=this.listeners_[type];var index=handlers.indexOf(handler);if(index>=0){if(handlers.length==1)delete this.listeners_[type];else handlers.splice(index,1);}}},dispatchEvent:function(event){if(!this.listeners_)return true;var self=this;event.__defineGetter__('target',function(){return self;});var realPreventDefault=event.preventDefault;event.preventDefault=function(){realPreventDefault.call(this);this.rawReturnValue=false;};var type=event.type;var prevented=0;if(type in this.listeners_){var handlers=this.listeners_[type].concat();for(var i=0,handler;handler=handlers[i];i++){if(handler.handleEvent)prevented|=handler.handleEvent.call(handler,event)===false;else prevented|=handler.call(this,event)===false;}}return!prevented&&event.rawReturnValue;},hasEventListener:function(type){return this.listeners_[type]!==undefined;}};var EventTargetHelper={decorate:function(target){for(var k in EventTargetHelper){if(k=='decorate')continue;var v=EventTargetHelper[k];if(typeof v!=='function')continue;target[k]=v;}target.listenerCounts_={};},addEventListener:function(type,listener,useCapture){this.__proto__.addEventListener.call(this,type,listener,useCapture);if(this.listenerCounts_[type]===undefined)this.listenerCounts_[type]=0;this.listenerCounts_[type]++;},removeEventListener:function(type,listener,useCapture){this.__proto__.removeEventListener.call(this,type,listener,useCapture);this.listenerCounts_[type]--;},hasEventListener:function(type){return this.listenerCounts_[type]>0;}};return{EventTarget:EventTarget,EventTargetHelper:EventTargetHelper};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],41:[function(require,module,exports){(function(global){"use strict";require("./event_target.js");require("./extension_registry_base.js");require("./extension_registry_basic.js");require("./extension_registry_type_based.js");require("./iteration_helpers.js");'use strict';global.tr.exportTo('tr.b',function(){function decorateExtensionRegistry(registry,registryOptions){if(registry.register)throw new Error('Already has registry');registryOptions.freeze();if(registryOptions.mode==tr.b.BASIC_REGISTRY_MODE){tr.b._decorateBasicExtensionRegistry(registry,registryOptions);}else if(registryOptions.mode==tr.b.TYPE_BASED_REGISTRY_MODE){tr.b._decorateTypeBasedExtensionRegistry(registry,registryOptions);}else{throw new Error('Unrecognized mode');}if(registry.addEventListener===undefined)tr.b.EventTarget.decorate(registry);}return{decorateExtensionRegistry:decorateExtensionRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./event_target.js":40,"./extension_registry_base.js":42,"./extension_registry_basic.js":43,"./extension_registry_type_based.js":44,"./iteration_helpers.js":47}],42:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function RegisteredTypeInfo(constructor,metadata){this.constructor=constructor;this.metadata=metadata;};var BASIC_REGISTRY_MODE='BASIC_REGISTRY_MODE';var TYPE_BASED_REGISTRY_MODE='TYPE_BASED_REGISTRY_MODE';var ALL_MODES={BASIC_REGISTRY_MODE:true,TYPE_BASED_REGISTRY_MODE:true};function ExtensionRegistryOptions(mode){if(mode===undefined)throw new Error('Mode is required');if(!ALL_MODES[mode])throw new Error('Not a mode.');this.mode_=mode;this.defaultMetadata_={};this.defaultConstructor_=undefined;this.defaultTypeInfo_=undefined;this.frozen_=false;}ExtensionRegistryOptions.prototype={freeze:function(){if(this.frozen_)throw new Error('Frozen');this.frozen_=true;},get mode(){return this.mode_;},get defaultMetadata(){return this.defaultMetadata_;},set defaultMetadata(defaultMetadata){if(this.frozen_)throw new Error('Frozen');this.defaultMetadata_=defaultMetadata;this.defaultTypeInfo_=undefined;},get defaultConstructor(){return this.defaultConstructor_;},set defaultConstructor(defaultConstructor){if(this.frozen_)throw new Error('Frozen');this.defaultConstructor_=defaultConstructor;this.defaultTypeInfo_=undefined;},get defaultTypeInfo(){if(this.defaultTypeInfo_===undefined&&this.defaultConstructor_){this.defaultTypeInfo_=new RegisteredTypeInfo(this.defaultConstructor,this.defaultMetadata);}return this.defaultTypeInfo_;},validateConstructor:function(constructor){if(!this.mandatoryBaseClass)return;var curProto=constructor.prototype.__proto__;var ok=false;while(curProto){if(curProto===this.mandatoryBaseClass.prototype){ok=true;break;}curProto=curProto.__proto__;}if(!ok)throw new Error(constructor+'must be subclass of '+registry);}};return{BASIC_REGISTRY_MODE:BASIC_REGISTRY_MODE,TYPE_BASED_REGISTRY_MODE:TYPE_BASED_REGISTRY_MODE,ExtensionRegistryOptions:ExtensionRegistryOptions,RegisteredTypeInfo:RegisteredTypeInfo};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],43:[function(require,module,exports){(function(global){"use strict";require("./event.js");require("./extension_registry_base.js");'use strict';global.tr.exportTo('tr.b',function(){var RegisteredTypeInfo=tr.b.RegisteredTypeInfo;var ExtensionRegistryOptions=tr.b.ExtensionRegistryOptions;function decorateBasicExtensionRegistry(registry,extensionRegistryOptions){var savedStateStack=[];registry.registeredTypeInfos_=[];registry.register=function(constructor,opt_metadata){if(registry.findIndexOfRegisteredConstructor(constructor)!==undefined)throw new Error('Handler already registered for '+constructor);extensionRegistryOptions.validateConstructor(constructor);var metadata={};for(var k in extensionRegistryOptions.defaultMetadata)metadata[k]=extensionRegistryOptions.defaultMetadata[k];if(opt_metadata){for(var k in opt_metadata)metadata[k]=opt_metadata[k];}var typeInfo=new RegisteredTypeInfo(constructor,metadata);var e=new tr.b.Event('will-register');e.typeInfo=typeInfo;registry.dispatchEvent(e);registry.registeredTypeInfos_.push(typeInfo);e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.pushCleanStateBeforeTest=function(){savedStateStack.push(registry.registeredTypeInfos_);registry.registeredTypeInfos_=[];var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.popCleanStateAfterTest=function(){registry.registeredTypeInfos_=savedStateStack[0];savedStateStack.splice(0,1);var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.findIndexOfRegisteredConstructor=function(constructor){for(var i=0;i<registry.registeredTypeInfos_.length;i++)if(registry.registeredTypeInfos_[i].constructor==constructor)return i;return undefined;};registry.unregister=function(constructor){var foundIndex=registry.findIndexOfRegisteredConstructor(constructor);if(foundIndex===undefined)throw new Error(constructor+' not registered');registry.registeredTypeInfos_.splice(foundIndex,1);var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.getAllRegisteredTypeInfos=function(){return registry.registeredTypeInfos_;};registry.findTypeInfo=function(constructor){var foundIndex=this.findIndexOfRegisteredConstructor(constructor);if(foundIndex!==undefined)return this.registeredTypeInfos_[foundIndex];return undefined;};registry.findTypeInfoMatching=function(predicate,opt_this){opt_this=opt_this?opt_this:undefined;for(var i=0;i<registry.registeredTypeInfos_.length;++i){var typeInfo=registry.registeredTypeInfos_[i];if(predicate.call(opt_this,typeInfo))return typeInfo;}return extensionRegistryOptions.defaultTypeInfo;};registry.findTypeInfoWithName=function(name){if(typeof name!=='string')throw new Error('Name is not a string.');var typeInfo=registry.findTypeInfoMatching(function(ti){return ti.constructor.name===name;});if(typeInfo)return typeInfo;return undefined;};}return{_decorateBasicExtensionRegistry:decorateBasicExtensionRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./event.js":39,"./extension_registry_base.js":42}],44:[function(require,module,exports){(function(global){"use strict";require("./category_util.js");require("./event.js");require("./extension_registry_base.js");'use strict';global.tr.exportTo('tr.b',function(){var getCategoryParts=tr.b.getCategoryParts;var RegisteredTypeInfo=tr.b.RegisteredTypeInfo;var ExtensionRegistryOptions=tr.b.ExtensionRegistryOptions;function decorateTypeBasedExtensionRegistry(registry,extensionRegistryOptions){var savedStateStack=[];registry.registeredTypeInfos_=[];registry.categoryPartToTypeInfoMap_=new Map();registry.typeNameToTypeInfoMap_=new Map();registry.register=function(constructor,metadata){extensionRegistryOptions.validateConstructor(constructor);var typeInfo=new RegisteredTypeInfo(constructor,metadata||extensionRegistryOptions.defaultMetadata);typeInfo.typeNames=[];typeInfo.categoryParts=[];if(metadata&&metadata.typeName)typeInfo.typeNames.push(metadata.typeName);if(metadata&&metadata.typeNames){typeInfo.typeNames.push.apply(typeInfo.typeNames,metadata.typeNames);}if(metadata&&metadata.categoryParts){typeInfo.categoryParts.push.apply(typeInfo.categoryParts,metadata.categoryParts);}if(typeInfo.typeNames.length===0&&typeInfo.categoryParts.length===0)throw new Error('typeName or typeNames must be provided');typeInfo.typeNames.forEach(function(typeName){if(registry.typeNameToTypeInfoMap_.has(typeName))throw new Error('typeName '+typeName+' already registered');});typeInfo.categoryParts.forEach(function(categoryPart){if(registry.categoryPartToTypeInfoMap_.has(categoryPart)){throw new Error('categoryPart '+categoryPart+' already registered');}});var e=new tr.b.Event('will-register');e.typeInfo=typeInfo;registry.dispatchEvent(e);typeInfo.typeNames.forEach(function(typeName){registry.typeNameToTypeInfoMap_.set(typeName,typeInfo);});typeInfo.categoryParts.forEach(function(categoryPart){registry.categoryPartToTypeInfoMap_.set(categoryPart,typeInfo);});registry.registeredTypeInfos_.push(typeInfo);var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.pushCleanStateBeforeTest=function(){savedStateStack.push({registeredTypeInfos:registry.registeredTypeInfos_,typeNameToTypeInfoMap:registry.typeNameToTypeInfoMap_,categoryPartToTypeInfoMap:registry.categoryPartToTypeInfoMap_});registry.registeredTypeInfos_=[];registry.typeNameToTypeInfoMap_=new Map();registry.categoryPartToTypeInfoMap_=new Map();var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.popCleanStateAfterTest=function(){var state=savedStateStack[0];savedStateStack.splice(0,1);registry.registeredTypeInfos_=state.registeredTypeInfos;registry.typeNameToTypeInfoMap_=state.typeNameToTypeInfoMap;registry.categoryPartToTypeInfoMap_=state.categoryPartToTypeInfoMap;var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.unregister=function(constructor){var typeInfoIndex=-1;for(var i=0;i<registry.registeredTypeInfos_.length;i++){if(registry.registeredTypeInfos_[i].constructor==constructor){typeInfoIndex=i;break;}}if(typeInfoIndex===-1)throw new Error(constructor+' not registered');var typeInfo=registry.registeredTypeInfos_[typeInfoIndex];registry.registeredTypeInfos_.splice(typeInfoIndex,1);typeInfo.typeNames.forEach(function(typeName){registry.typeNameToTypeInfoMap_.delete(typeName);});typeInfo.categoryParts.forEach(function(categoryPart){registry.categoryPartToTypeInfoMap_.delete(categoryPart);});var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.getTypeInfo=function(category,typeName){if(category){var categoryParts=getCategoryParts(category);for(var i=0;i<categoryParts.length;i++){var categoryPart=categoryParts[i];var typeInfo=registry.categoryPartToTypeInfoMap_.get(categoryPart);if(typeInfo!==undefined)return typeInfo;}}var typeInfo=registry.typeNameToTypeInfoMap_.get(typeName);if(typeInfo!==undefined)return typeInfo;return extensionRegistryOptions.defaultTypeInfo;};registry.getConstructor=function(category,typeName){var typeInfo=registry.getTypeInfo(category,typeName);if(typeInfo)return typeInfo.constructor;return undefined;};}return{_decorateTypeBasedExtensionRegistry:decorateTypeBasedExtensionRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./category_util.js":36,"./event.js":39,"./extension_registry_base.js":42}],45:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){var nextGUID=1;var UUID4_PATTERN='xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx';var GUID={allocateSimple:function(){return nextGUID++;},getLastSimpleGuid:function(){return nextGUID-1;},allocateUUID4:function(){return UUID4_PATTERN.replace(/[xy]/g,function(c){var r=parseInt(Math.random()*16);if(c==='y')r=(r&3)+8;return r.toString(16);});}};return{GUID:GUID};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],46:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function max(a,b){if(a===undefined)return b;if(b===undefined)return a;return Math.max(a,b);}function IntervalTree(beginPositionCb,endPositionCb){this.beginPositionCb_=beginPositionCb;this.endPositionCb_=endPositionCb;this.root_=undefined;this.size_=0;}IntervalTree.prototype={insert:function(datum){var startPosition=this.beginPositionCb_(datum);var endPosition=this.endPositionCb_(datum);var node=new IntervalTreeNode(datum,startPosition,endPosition);this.size_++;this.root_=this.insertNode_(this.root_,node);this.root_.colour=Colour.BLACK;return datum;},insertNode_:function(root,node){if(root===undefined)return node;if(root.leftNode&&root.leftNode.isRed&&root.rightNode&&root.rightNode.isRed)this.flipNodeColour_(root);if(node.key<root.key)root.leftNode=this.insertNode_(root.leftNode,node);else if(node.key===root.key)root.merge(node);else root.rightNode=this.insertNode_(root.rightNode,node);if(root.rightNode&&root.rightNode.isRed&&(root.leftNode===undefined||!root.leftNode.isRed))root=this.rotateLeft_(root);if(root.leftNode&&root.leftNode.isRed&&root.leftNode.leftNode&&root.leftNode.leftNode.isRed)root=this.rotateRight_(root);return root;},rotateRight_:function(node){var sibling=node.leftNode;node.leftNode=sibling.rightNode;sibling.rightNode=node;sibling.colour=node.colour;node.colour=Colour.RED;return sibling;},rotateLeft_:function(node){var sibling=node.rightNode;node.rightNode=sibling.leftNode;sibling.leftNode=node;sibling.colour=node.colour;node.colour=Colour.RED;return sibling;},flipNodeColour_:function(node){node.colour=this.flipColour_(node.colour);node.leftNode.colour=this.flipColour_(node.leftNode.colour);node.rightNode.colour=this.flipColour_(node.rightNode.colour);},flipColour_:function(colour){return colour===Colour.RED?Colour.BLACK:Colour.RED;},updateHighValues:function(){this.updateHighValues_(this.root_);},updateHighValues_:function(node){if(node===undefined)return undefined;node.maxHighLeft=this.updateHighValues_(node.leftNode);node.maxHighRight=this.updateHighValues_(node.rightNode);return max(max(node.maxHighLeft,node.highValue),node.maxHighRight);},validateFindArguments_:function(queryLow,queryHigh){if(queryLow===undefined||queryHigh===undefined)throw new Error('queryLow and queryHigh must be defined');if(typeof queryLow!=='number'||typeof queryHigh!=='number')throw new Error('queryLow and queryHigh must be numbers');},findIntersection:function(queryLow,queryHigh){this.validateFindArguments_(queryLow,queryHigh);if(this.root_===undefined)return[];var ret=[];this.root_.appendIntersectionsInto_(ret,queryLow,queryHigh);return ret;},get size(){return this.size_;},get root(){return this.root_;},dump_:function(){if(this.root_===undefined)return[];return this.root_.dump();}};var Colour={RED:'red',BLACK:'black'};function IntervalTreeNode(datum,lowValue,highValue){this.lowValue_=lowValue;this.data_=[{datum:datum,high:highValue,low:lowValue}];this.colour_=Colour.RED;this.parentNode_=undefined;this.leftNode_=undefined;this.rightNode_=undefined;this.maxHighLeft_=undefined;this.maxHighRight_=undefined;}IntervalTreeNode.prototype={appendIntersectionsInto_:function(ret,queryLow,queryHigh){if(this.lowValue_>=queryHigh){if(!this.leftNode_)return;return this.leftNode_.appendIntersectionsInto_(ret,queryLow,queryHigh);}if(this.maxHighLeft_>queryLow){this.leftNode_.appendIntersectionsInto_(ret,queryLow,queryHigh);}if(this.highValue>queryLow){for(var i=this.data.length-1;i>=0;--i){if(this.data[i].high<queryLow)break;ret.push(this.data[i].datum);}}if(this.rightNode_){this.rightNode_.appendIntersectionsInto_(ret,queryLow,queryHigh);}},get colour(){return this.colour_;},set colour(colour){this.colour_=colour;},get key(){return this.lowValue_;},get lowValue(){return this.lowValue_;},get highValue(){return this.data_[this.data_.length-1].high;},set leftNode(left){this.leftNode_=left;},get leftNode(){return this.leftNode_;},get hasLeftNode(){return this.leftNode_!==undefined;},set rightNode(right){this.rightNode_=right;},get rightNode(){return this.rightNode_;},get hasRightNode(){return this.rightNode_!==undefined;},set parentNode(parent){this.parentNode_=parent;},get parentNode(){return this.parentNode_;},get isRootNode(){return this.parentNode_===undefined;},set maxHighLeft(high){this.maxHighLeft_=high;},get maxHighLeft(){return this.maxHighLeft_;},set maxHighRight(high){this.maxHighRight_=high;},get maxHighRight(){return this.maxHighRight_;},get data(){return this.data_;},get isRed(){return this.colour_===Colour.RED;},merge:function(node){for(var i=0;i<node.data.length;i++)this.data_.push(node.data[i]);this.data_.sort(function(a,b){return a.high-b.high;});},dump:function(){var ret={};if(this.leftNode_)ret['left']=this.leftNode_.dump();ret['data']=this.data_.map(function(d){return[d.low,d.high];});if(this.rightNode_)ret['right']=this.rightNode_.dump();return ret;}};return{IntervalTree:IntervalTree};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],47:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function asArray(x){var values=[];if(x[Symbol.iterator])for(var value of x)values.push(value);else for(var i=0;i<x.length;i++)values.push(x[i]);return values;}function getOnlyElement(iterable){var iterator=iterable[Symbol.iterator]();var firstIteration=iterator.next();if(firstIteration.done)throw new Error('getOnlyElement was passed an empty iterable.');var secondIteration=iterator.next();if(!secondIteration.done)throw new Error('getOnlyElement was passed an iterable with multiple elements.');return firstIteration.value;}function getFirstElement(iterable){var iterator=iterable[Symbol.iterator]();var result=iterator.next();if(result.done)throw new Error('getFirstElement was passed an empty iterable.');return result.value;}function compareArrays(x,y,elementCmp){var minLength=Math.min(x.length,y.length);for(var i=0;i<minLength;i++){var tmp=elementCmp(x[i],y[i]);if(tmp)return tmp;}if(x.length==y.length)return 0;if(x[i]===undefined)return-1;return 1;}function comparePossiblyUndefinedValues(x,y,cmp,opt_this){if(x!==undefined&&y!==undefined)return cmp.call(opt_this,x,y);if(x!==undefined)return-1;if(y!==undefined)return 1;return 0;}function compareNumericWithNaNs(x,y){if(!isNaN(x)&&!isNaN(y))return x-y;if(isNaN(x))return 1;if(isNaN(y))return-1;return 0;}function concatenateArrays(){var values=[];for(var i=0;i<arguments.length;i++){if(!(arguments[i]instanceof Array))throw new Error('Arguments '+i+'is not an array');values.push.apply(values,arguments[i]);}return values;}function concatenateObjects(){var result={};for(var i=0;i<arguments.length;i++){var object=arguments[i];for(var j in object){result[j]=object[j];}}return result;}function cloneDictionary(dict){var clone={};for(var k in dict){clone[k]=dict[k];}return clone;}function dictionaryKeys(dict){var keys=[];for(var key in dict)keys.push(key);return keys;}function dictionaryValues(dict){var values=[];for(var key in dict)values.push(dict[key]);return values;}function dictionaryLength(dict){var n=0;for(var key in dict)n++;return n;}function dictionaryContainsValue(dict,value){for(var key in dict)if(dict[key]===value)return true;return false;}function every(iterable,predicate){for(var x of iterable)if(!predicate(x))return false;return true;}function group(ary,callback,opt_this,opt_arrayConstructor){var arrayConstructor=opt_arrayConstructor||Array;var results={};for(var element of ary){var key=callback.call(opt_this,element);if(!(key in results))results[key]=new arrayConstructor();results[key].push(element);}return results;}function groupIntoMap(ary,callback,opt_this,opt_arrayConstructor){var arrayConstructor=opt_arrayConstructor||Array;var results=new Map();for(var element of ary){var key=callback.call(opt_this,element);var items=results.get(key);if(items===undefined){items=new arrayConstructor();results.set(key,items);}items.push(element);}return results;}function iterItems(dict,fn,opt_this){opt_this=opt_this||this;var keys=Object.keys(dict);for(var i=0;i<keys.length;i++){var key=keys[i];fn.call(opt_this,key,dict[key]);}}function mapItems(dict,fn,opt_this){opt_this=opt_this||this;var result={};var keys=Object.keys(dict);for(var i=0;i<keys.length;i++){var key=keys[i];result[key]=fn.call(opt_this,key,dict[key]);}return result;}function filterItems(dict,predicate,opt_this){opt_this=opt_this||this;var result={};var keys=Object.keys(dict);for(var i=0;i<keys.length;i++){var key=keys[i];var value=dict[key];if(predicate.call(opt_this,key,value))result[key]=value;}return result;}function iterObjectFieldsRecursively(object,func){if(!(object instanceof Object))return;if(object instanceof Array){for(var i=0;i<object.length;i++){func(object,i,object[i]);iterObjectFieldsRecursively(object[i],func);}return;}for(var key in object){var value=object[key];func(object,key,value);iterObjectFieldsRecursively(value,func);}}function invertArrayOfDicts(array,opt_dictGetter,opt_this){opt_this=opt_this||this;var result={};for(var i=0;i<array.length;i++){var item=array[i];if(item===undefined)continue;var dict=opt_dictGetter?opt_dictGetter.call(opt_this,item):item;if(dict===undefined)continue;for(var key in dict){var valueList=result[key];if(valueList===undefined)result[key]=valueList=new Array(array.length);valueList[i]=dict[key];}}return result;}function arrayToDict(array,valueToKeyFn,opt_this){opt_this=opt_this||this;var result={};var length=array.length;for(var i=0;i<length;i++){var value=array[i];var key=valueToKeyFn.call(opt_this,value);result[key]=value;}return result;}function identity(d){return d;}function findFirstIndexInArray(ary,opt_func,opt_this){var func=opt_func||identity;for(var i=0;i<ary.length;i++){if(func.call(opt_this,ary[i],i))return i;}return-1;}function findFirstInArray(ary,opt_func,opt_this){var i=findFirstIndexInArray(ary,opt_func,opt_func);if(i===-1)return undefined;return ary[i];}function findFirstKeyInDictMatching(dict,opt_func,opt_this){var func=opt_func||identity;for(var key in dict){if(func.call(opt_this,key,dict[key]))return key;}return undefined;}function mapValues(map){var values=[];for(var value of map.values())values.push(value);return values;}function iterMapItems(map,fn,opt_this){opt_this=opt_this||this;for(var key of map.keys())fn.call(opt_this,key,map.get(key));}return{asArray:asArray,concatenateArrays:concatenateArrays,concatenateObjects:concatenateObjects,compareArrays:compareArrays,comparePossiblyUndefinedValues:comparePossiblyUndefinedValues,compareNumericWithNaNs:compareNumericWithNaNs,cloneDictionary:cloneDictionary,dictionaryLength:dictionaryLength,dictionaryKeys:dictionaryKeys,dictionaryValues:dictionaryValues,dictionaryContainsValue:dictionaryContainsValue,every:every,getOnlyElement:getOnlyElement,getFirstElement:getFirstElement,group:group,groupIntoMap:groupIntoMap,iterItems:iterItems,mapItems:mapItems,filterItems:filterItems,iterObjectFieldsRecursively:iterObjectFieldsRecursively,invertArrayOfDicts:invertArrayOfDicts,arrayToDict:arrayToDict,identity:identity,findFirstIndexInArray:findFirstIndexInArray,findFirstInArray:findFirstInArray,findFirstKeyInDictMatching:findFirstKeyInDictMatching,mapValues:mapValues,iterMapItems:iterMapItems};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],48:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';(function(){if(tr.isNode){var glMatrixAbsPath=HTMLImportsLoader.hrefToAbsolutePath('/gl-matrix-min.js');var glMatrixModule=require(glMatrixAbsPath);for(var exportName in glMatrixModule){global[exportName]=glMatrixModule[exportName];}}})(this);'use strict';global.tr.exportTo('tr.b',function(){function approximately(x,y,delta){if(delta===undefined)delta=1e-9;return Math.abs(x-y)<delta;}function clamp(x,lo,hi){return Math.min(Math.max(x,lo),hi);}function lerp(percentage,lo,hi){var range=hi-lo;return lo+percentage*range;}function normalize(value,lo,hi){return(value-lo)/(hi-lo);}function deg2rad(deg){return Math.PI*deg/180.0;}function erf(x){var sign=x>=0?1:-1;x=Math.abs(x);var a1=0.254829592;var a2=-0.284496736;var a3=1.421413741;var a4=-1.453152027;var a5=1.061405429;var p=0.3275911;var t=1.0/(1.0+p*x);var y=1.0-((((a5*t+a4)*t+a3)*t+a2)*t+a1)*t*Math.exp(-x*x);return sign*y;}var tmpVec2=vec2.create();var tmpVec2b=vec2.create();var tmpVec4=vec4.create();var tmpMat2d=mat2d.create();vec2.createFromArray=function(arr){if(arr.length!=2)throw new Error('Should be length 2');var v=vec2.create();vec2.set(v,arr[0],arr[1]);return v;};vec2.createXY=function(x,y){var v=vec2.create();vec2.set(v,x,y);return v;};vec2.toString=function(a){return'['+a[0]+', '+a[1]+']';};vec2.addTwoScaledUnitVectors=function(out,u1,scale1,u2,scale2){vec2.scale(tmpVec2,u1,scale1);vec2.scale(tmpVec2b,u2,scale2);vec2.add(out,tmpVec2,tmpVec2b);};vec2.interpolatePiecewiseFunction=function(points,x){if(x<points[0][0])return points[0][1];for(var i=1;i<points.length;++i){if(x<points[i][0]){var percent=normalize(x,points[i-1][0],points[i][0]);return lerp(percent,points[i-1][1],points[i][1]);}}return points[points.length-1][1];};vec3.createXYZ=function(x,y,z){var v=vec3.create();vec3.set(v,x,y,z);return v;};vec3.toString=function(a){return'vec3('+a[0]+', '+a[1]+', '+a[2]+')';};mat2d.translateXY=function(out,x,y){vec2.set(tmpVec2,x,y);mat2d.translate(out,out,tmpVec2);};mat2d.scaleXY=function(out,x,y){vec2.set(tmpVec2,x,y);mat2d.scale(out,out,tmpVec2);};vec4.unitize=function(out,a){out[0]=a[0]/a[3];out[1]=a[1]/a[3];out[2]=a[2]/a[3];out[3]=1;return out;};vec2.copyFromVec4=function(out,a){vec4.unitize(tmpVec4,a);vec2.copy(out,tmpVec4);};return{approximately:approximately,clamp:clamp,lerp:lerp,normalize:normalize,deg2rad:deg2rad,erf:erf};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],49:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function MultiDimensionalViewNode(title,valueCount){this.title=title;var dimensions=title.length;this.children=new Array(dimensions);for(var i=0;i<dimensions;i++)this.children[i]=new Map();this.values=new Array(valueCount);for(var v=0;v<valueCount;v++)this.values[v]={self:0,total:0,totalState:NOT_PROVIDED};}MultiDimensionalViewNode.TotalState={NOT_PROVIDED:0,LOWER_BOUND:1,EXACT:2};var NOT_PROVIDED=MultiDimensionalViewNode.TotalState.NOT_PROVIDED;var LOWER_BOUND=MultiDimensionalViewNode.TotalState.LOWER_BOUND;var EXACT=MultiDimensionalViewNode.TotalState.EXACT;MultiDimensionalViewNode.prototype={get subRows(){return tr.b.mapValues(this.children[0]);}};function MultiDimensionalViewBuilder(dimensions,valueCount){if(typeof dimensions!=='number'||dimensions<0)throw new Error('Dimensions must be a non-negative number');this.dimensions_=dimensions;if(typeof valueCount!=='number'||valueCount<0)throw new Error('Number of values must be a non-negative number');this.valueCount_=valueCount;this.buildRoot_=this.createRootNode_();this.topDownTreeViewRoot_=undefined;this.topDownHeavyViewRoot_=undefined;this.bottomUpHeavyViewNode_=undefined;this.maxDimensionDepths_=new Array(dimensions);for(var d=0;d<dimensions;d++)this.maxDimensionDepths_[d]=0;}MultiDimensionalViewBuilder.ValueKind={SELF:0,TOTAL:1};MultiDimensionalViewBuilder.ViewType={TOP_DOWN_TREE_VIEW:0,TOP_DOWN_HEAVY_VIEW:1,BOTTOM_UP_HEAVY_VIEW:2};MultiDimensionalViewBuilder.prototype={addPath:function(path,values,valueKind){if(this.buildRoot_===undefined){throw new Error('Paths cannot be added after either view has been built');}if(path.length!==this.dimensions_)throw new Error('Path must be '+this.dimensions_+'-dimensional');if(values.length!==this.valueCount_)throw new Error('Must provide '+this.valueCount_+' values');var isTotal;switch(valueKind){case MultiDimensionalViewBuilder.ValueKind.SELF:isTotal=false;break;case MultiDimensionalViewBuilder.ValueKind.TOTAL:isTotal=true;break;default:throw new Error('Invalid value kind: '+valueKind);}var node=this.buildRoot_;for(var d=0;d<path.length;d++){var singleDimensionPath=path[d];var singleDimensionPathLength=singleDimensionPath.length;this.maxDimensionDepths_[d]=Math.max(this.maxDimensionDepths_[d],singleDimensionPathLength);for(var i=0;i<singleDimensionPathLength;i++)node=this.getOrCreateChildNode_(node,d,singleDimensionPath[i]);}for(var v=0;v<this.valueCount_;v++){var addedValue=values[v];if(addedValue===undefined)continue;var nodeValue=node.values[v];if(isTotal){nodeValue.total+=addedValue;nodeValue.totalState=EXACT;}else{nodeValue.self+=addedValue;nodeValue.totalState=Math.max(nodeValue.totalState,LOWER_BOUND);}}},buildView:function(viewType){switch(viewType){case MultiDimensionalViewBuilder.ViewType.TOP_DOWN_TREE_VIEW:return this.buildTopDownTreeView();case MultiDimensionalViewBuilder.ViewType.TOP_DOWN_HEAVY_VIEW:return this.buildTopDownHeavyView();case MultiDimensionalViewBuilder.ViewType.BOTTOM_UP_HEAVY_VIEW:return this.buildBottomUpHeavyView();default:throw new Error('Unknown multi-dimensional view type: '+viewType);}},buildTopDownTreeView:function(){if(this.topDownTreeViewRoot_===undefined){var treeViewRoot=this.buildRoot_;this.buildRoot_=undefined;this.setUpMissingChildRelationships_(treeViewRoot,0);this.finalizeTotalValues_(treeViewRoot,0,new WeakMap());this.topDownTreeViewRoot_=treeViewRoot;}return this.topDownTreeViewRoot_;},buildTopDownHeavyView:function(){if(this.topDownHeavyViewRoot_===undefined){this.topDownHeavyViewRoot_=this.buildGenericHeavyView_(this.addDimensionToTopDownHeavyViewNode_.bind(this));}return this.topDownHeavyViewRoot_;},buildBottomUpHeavyView:function(){if(this.bottomUpHeavyViewNode_===undefined){this.bottomUpHeavyViewNode_=this.buildGenericHeavyView_(this.addDimensionToBottomUpHeavyViewNode_.bind(this));}return this.bottomUpHeavyViewNode_;},createRootNode_:function(){return new MultiDimensionalViewNode(new Array(this.dimensions_),this.valueCount_);},getOrCreateChildNode_:function(parentNode,dimension,childDimensionTitle){if(dimension<0||dimension>=this.dimensions_)throw new Error('Invalid dimension');var dimensionChildren=parentNode.children[dimension];var childNode=dimensionChildren.get(childDimensionTitle);if(childNode!==undefined)return childNode;var childTitle=parentNode.title.slice();childTitle[dimension]=childDimensionTitle;childNode=new MultiDimensionalViewNode(childTitle,this.valueCount_);dimensionChildren.set(childDimensionTitle,childNode);return childNode;},setUpMissingChildRelationships_:function(node,firstDimensionToSetUp){for(var d=firstDimensionToSetUp;d<this.dimensions_;d++){var currentDimensionChildTitles=new Set(node.children[d].keys());for(var i=0;i<d;i++){for(var previousDimensionChildNode of node.children[i].values()){for(var previousDimensionGrandChildTitle of previousDimensionChildNode.children[d].keys()){currentDimensionChildTitles.add(previousDimensionGrandChildTitle);}}}for(var currentDimensionChildTitle of currentDimensionChildTitles){var currentDimensionChildNode=this.getOrCreateChildNode_(node,d,currentDimensionChildTitle);for(var i=0;i<d;i++){for(var previousDimensionChildNode of node.children[i].values()){var previousDimensionGrandChildNode=previousDimensionChildNode.children[d].get(currentDimensionChildTitle);if(previousDimensionGrandChildNode!==undefined){currentDimensionChildNode.children[i].set(previousDimensionChildNode.title[i],previousDimensionGrandChildNode);}}}this.setUpMissingChildRelationships_(currentDimensionChildNode,d);}}},finalizeTotalValues_:function(node,firstDimensionToFinalize,dimensionalSelfSumsMap){var dimensionalSelfSums=new Array(this.dimensions_);var minResidual=new Array(this.valueCount_);for(var v=0;v<this.valueCount_;v++)minResidual[v]=0;var nodeValues=node.values;var nodeSelfSums=new Array(this.valueCount_);for(var v=0;v<this.valueCount_;v++)nodeSelfSums[v]=nodeValues[v].self;for(var d=0;d<this.dimensions_;d++){var childResidualSums=new Array(this.valueCount_);for(var v=0;v<this.valueCount_;v++)childResidualSums[v]=0;for(var childNode of node.children[d].values()){if(d>=firstDimensionToFinalize)this.finalizeTotalValues_(childNode,d,dimensionalSelfSumsMap);var childNodeSelfSums=dimensionalSelfSumsMap.get(childNode);var childNodeValues=childNode.values;for(var v=0;v<this.valueCount_;v++){nodeSelfSums[v]+=childNodeSelfSums[d][v];var residual=childNodeValues[v].total-childNodeSelfSums[this.dimensions_-1][v];childResidualSums[v]+=residual;if(childNodeValues[v].totalState>NOT_PROVIDED){nodeValues[v].totalState=Math.max(nodeValues[v].totalState,LOWER_BOUND);}}}dimensionalSelfSums[d]=nodeSelfSums.slice();for(var v=0;v<this.valueCount_;v++)minResidual[v]=Math.max(minResidual[v],childResidualSums[v]);}for(var v=0;v<this.valueCount_;v++){nodeValues[v].total=Math.max(nodeValues[v].total,nodeSelfSums[v]+minResidual[v]);}if(dimensionalSelfSumsMap.has(node))throw new Error('Internal error: Node finalized more than once');dimensionalSelfSumsMap.set(node,dimensionalSelfSums);},buildGenericHeavyView_:function(treeViewNodeHandler){var treeViewRoot=this.buildTopDownTreeView();var heavyViewRoot=this.createRootNode_();heavyViewRoot.values=treeViewRoot.values;var recursionDepthTrackers=new Array(this.dimensions_);for(var d=0;d<this.dimensions_;d++){recursionDepthTrackers[d]=new RecursionDepthTracker(this.maxDimensionDepths_[d],d);}this.addDimensionsToGenericHeavyViewNode_(treeViewRoot,heavyViewRoot,0,recursionDepthTrackers,false,treeViewNodeHandler);this.setUpMissingChildRelationships_(heavyViewRoot,0);return heavyViewRoot;},addDimensionsToGenericHeavyViewNode_:function(treeViewParentNode,heavyViewParentNode,startDimension,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler){for(var d=startDimension;d<this.dimensions_;d++){this.addDimensionDescendantsToGenericHeavyViewNode_(treeViewParentNode,heavyViewParentNode,d,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler);}},addDimensionDescendantsToGenericHeavyViewNode_:function(treeViewParentNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler){var treeViewChildren=treeViewParentNode.children[currentDimension];var recursionDepthTracker=recursionDepthTrackers[currentDimension];for(var treeViewChildNode of treeViewChildren.values()){recursionDepthTracker.push(treeViewChildNode);treeViewNodeHandler(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive);this.addDimensionDescendantsToGenericHeavyViewNode_(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler);recursionDepthTracker.pop();}},addDimensionToTopDownHeavyViewNode_:function(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive){this.addDimensionToTopDownHeavyViewNodeRecursively_(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,1);},addDimensionToTopDownHeavyViewNodeRecursively_:function(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,subTreeDepth){var recursionDepthTracker=recursionDepthTrackers[currentDimension];var currentDimensionRecursive=subTreeDepth<=recursionDepthTracker.recursionDepth;var currentOrPreviousDimensionsRecursive=currentDimensionRecursive||previousDimensionsRecursive;var dimensionTitle=treeViewChildNode.title[currentDimension];var heavyViewChildNode=this.getOrCreateChildNode_(heavyViewParentNode,currentDimension,dimensionTitle);this.addNodeValues_(treeViewChildNode,heavyViewChildNode,!currentOrPreviousDimensionsRecursive);this.addDimensionsToGenericHeavyViewNode_(treeViewChildNode,heavyViewChildNode,currentDimension+1,recursionDepthTrackers,currentOrPreviousDimensionsRecursive,this.addDimensionToTopDownHeavyViewNode_.bind(this));for(var treeViewGrandChildNode of treeViewChildNode.children[currentDimension].values()){recursionDepthTracker.push(treeViewGrandChildNode);this.addDimensionToTopDownHeavyViewNodeRecursively_(treeViewGrandChildNode,heavyViewChildNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,subTreeDepth+1);recursionDepthTracker.pop();}},addDimensionToBottomUpHeavyViewNode_:function(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive){var recursionDepthTracker=recursionDepthTrackers[currentDimension];var bottomIndex=recursionDepthTracker.bottomIndex;var topIndex=recursionDepthTracker.topIndex;var firstNonRecursiveIndex=bottomIndex+recursionDepthTracker.recursionDepth;var viewNodePath=recursionDepthTracker.viewNodePath;var trackerAncestorNode=recursionDepthTracker.trackerAncestorNode;var heavyViewDescendantNode=heavyViewParentNode;for(var i=bottomIndex;i<topIndex;i++){var treeViewAncestorNode=viewNodePath[i];var dimensionTitle=treeViewAncestorNode.title[currentDimension];heavyViewDescendantNode=this.getOrCreateChildNode_(heavyViewDescendantNode,currentDimension,dimensionTitle);var currentDimensionRecursive=i<firstNonRecursiveIndex;var currentOrPreviousDimensionsRecursive=currentDimensionRecursive||previousDimensionsRecursive;this.addNodeValues_(treeViewChildNode,heavyViewDescendantNode,!currentOrPreviousDimensionsRecursive);this.addDimensionsToGenericHeavyViewNode_(treeViewChildNode,heavyViewDescendantNode,currentDimension+1,recursionDepthTrackers,currentOrPreviousDimensionsRecursive,this.addDimensionToBottomUpHeavyViewNode_.bind(this));}},addNodeValues_:function(sourceNode,targetNode,addTotal){var targetNodeValues=targetNode.values;var sourceNodeValues=sourceNode.values;for(var v=0;v<this.valueCount_;v++){var targetNodeValue=targetNodeValues[v];var sourceNodeValue=sourceNodeValues[v];targetNodeValue.self+=sourceNodeValue.self;if(addTotal){targetNodeValue.total+=sourceNodeValue.total;if(sourceNodeValue.totalState>NOT_PROVIDED){targetNodeValue.totalState=Math.max(targetNodeValue.totalState,LOWER_BOUND);}}}}};function RecursionDepthTracker(maxDepth,dimension){this.titlePath=new Array(maxDepth);this.viewNodePath=new Array(maxDepth);this.bottomIndex=this.topIndex=maxDepth;this.dimension_=dimension;this.currentTrackerNode_=this.createNode_(0,undefined);}RecursionDepthTracker.prototype={push:function(viewNode){if(this.bottomIndex===0)throw new Error('Cannot push to a full tracker');var title=viewNode.title[this.dimension_];this.bottomIndex--;this.titlePath[this.bottomIndex]=title;this.viewNodePath[this.bottomIndex]=viewNode;var childTrackerNode=this.currentTrackerNode_.children.get(title);if(childTrackerNode!==undefined){this.currentTrackerNode_=childTrackerNode;return;}var maxLengths=zFunction(this.titlePath,this.bottomIndex);var recursionDepth=0;for(var i=0;i<maxLengths.length;i++)recursionDepth=Math.max(recursionDepth,maxLengths[i]);childTrackerNode=this.createNode_(recursionDepth,this.currentTrackerNode_);this.currentTrackerNode_.children.set(title,childTrackerNode);this.currentTrackerNode_=childTrackerNode;},pop:function(){if(this.bottomIndex===this.topIndex)throw new Error('Cannot pop from an empty tracker');this.titlePath[this.bottomIndex]=undefined;this.viewNodePath[this.bottomIndex]=undefined;this.bottomIndex++;this.currentTrackerNode_=this.currentTrackerNode_.parent;},get recursionDepth(){return this.currentTrackerNode_.recursionDepth;},createNode_:function(recursionDepth,parent){return{recursionDepth:recursionDepth,parent:parent,children:new Map()};}};function zFunction(list,startIndex){var n=list.length-startIndex;if(n===0)return[];var z=new Array(n);z[0]=0;for(var i=1,left=0,right=0;i<n;++i){var maxLength;if(i<=right)maxLength=Math.min(right-i+1,z[i-left]);else maxLength=0;while(i+maxLength<n&&list[startIndex+maxLength]===list[startIndex+i+maxLength]){++maxLength;}if(i+maxLength-1>right){left=i;right=i+maxLength-1;}z[i]=maxLength;}return z;}return{MultiDimensionalViewBuilder:MultiDimensionalViewBuilder,MultiDimensionalViewNode:MultiDimensionalViewNode,RecursionDepthTracker:RecursionDepthTracker,zFunction:zFunction};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],50:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){var PERCENTILE_PRECISION=1e-7;function PiecewiseLinearFunction(){this.pieces=[];}PiecewiseLinearFunction.prototype={push:function(x1,y1,x2,y2){if(x1>=x2)throw new Error('Invalid segment');if(this.pieces.length>0&&this.pieces[this.pieces.length-1].x2>x1){throw new Error('Potentially overlapping segments');}if(x1<x2)this.pieces.push(new Piece(x1,y1,x2,y2));},partBelow:function(y){return this.pieces.reduce((acc,p)=>acc+p.partBelow(y),0);},get min(){return this.pieces.reduce((acc,p)=>Math.min(acc,p.min),Infinity);},get max(){return this.pieces.reduce((acc,p)=>Math.max(acc,p.max),-Infinity);},get average(){var weightedSum=0;var totalWeight=0;this.pieces.forEach(function(piece){weightedSum+=piece.width*piece.average;totalWeight+=piece.width;});if(totalWeight===0)return 0;return weightedSum/totalWeight;},percentile:function(percent){if(!(percent>=0&&percent<=1))throw new Error('percent must be [0,1]');var lower=this.min;var upper=this.max;var total=this.partBelow(upper);if(total===0)return 0;while(upper-lower>PERCENTILE_PRECISION){var middle=(lower+upper)/2;var below=this.partBelow(middle);if(below/total<percent)lower=middle;else upper=middle;}return(lower+upper)/2;}};function Piece(x1,y1,x2,y2){this.x1=x1;this.y1=y1;this.x2=x2;this.y2=y2;}Piece.prototype={partBelow:function(y){var width=this.width;if(width===0)return 0;var minY=this.min;var maxY=this.max;if(y>=maxY)return width;if(y<minY)return 0;return(y-minY)/(maxY-minY)*width;},get min(){return Math.min(this.y1,this.y2);},get max(){return Math.max(this.y1,this.y2);},get average(){return(this.y1+this.y2)/2;},get width(){return this.x2-this.x1;}};return{PiecewiseLinearFunction:PiecewiseLinearFunction};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],51:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){var tmpVec2s=[];for(var i=0;i<8;i++)tmpVec2s[i]=vec2.create();var tmpVec2a=vec4.create();var tmpVec4a=vec4.create();var tmpVec4b=vec4.create();var tmpMat4=mat4.create();var tmpMat4b=mat4.create();var p00=vec2.createXY(0,0);var p10=vec2.createXY(1,0);var p01=vec2.createXY(0,1);var p11=vec2.createXY(1,1);var lerpingVecA=vec2.create();var lerpingVecB=vec2.create();function lerpVec2(out,a,b,amt){vec2.scale(lerpingVecA,a,amt);vec2.scale(lerpingVecB,b,1-amt);vec2.add(out,lerpingVecA,lerpingVecB);vec2.normalize(out,out);return out;}function Quad(){this.p1=vec2.create();this.p2=vec2.create();this.p3=vec2.create();this.p4=vec2.create();}Quad.fromXYWH=function(x,y,w,h){var q=new Quad();vec2.set(q.p1,x,y);vec2.set(q.p2,x+w,y);vec2.set(q.p3,x+w,y+h);vec2.set(q.p4,x,y+h);return q;};Quad.fromRect=function(r){return new Quad.fromXYWH(r.x,r.y,r.width,r.height);};Quad.from4Vecs=function(p1,p2,p3,p4){var q=new Quad();vec2.set(q.p1,p1[0],p1[1]);vec2.set(q.p2,p2[0],p2[1]);vec2.set(q.p3,p3[0],p3[1]);vec2.set(q.p4,p4[0],p4[1]);return q;};Quad.from8Array=function(arr){if(arr.length!=8)throw new Error('Array must be 8 long');var q=new Quad();q.p1[0]=arr[0];q.p1[1]=arr[1];q.p2[0]=arr[2];q.p2[1]=arr[3];q.p3[0]=arr[4];q.p3[1]=arr[5];q.p4[0]=arr[6];q.p4[1]=arr[7];return q;};Quad.prototype={pointInside:function(point){return pointInImplicitQuad(point,this.p1,this.p2,this.p3,this.p4);},boundingRect:function(){var x0=Math.min(this.p1[0],this.p2[0],this.p3[0],this.p4[0]);var y0=Math.min(this.p1[1],this.p2[1],this.p3[1],this.p4[1]);var x1=Math.max(this.p1[0],this.p2[0],this.p3[0],this.p4[0]);var y1=Math.max(this.p1[1],this.p2[1],this.p3[1],this.p4[1]);return new tr.b.Rect.fromXYWH(x0,y0,x1-x0,y1-y0);},clone:function(){var q=new Quad();vec2.copy(q.p1,this.p1);vec2.copy(q.p2,this.p2);vec2.copy(q.p3,this.p3);vec2.copy(q.p4,this.p4);return q;},scale:function(s){var q=new Quad();this.scaleFast(q,s);return q;},scaleFast:function(dstQuad,s){vec2.copy(dstQuad.p1,this.p1,s);vec2.copy(dstQuad.p2,this.p2,s);vec2.copy(dstQuad.p3,this.p3,s);vec2.copy(dstQuad.p3,this.p3,s);},isRectangle:function(){var bounds=this.boundingRect();return bounds.x==this.p1[0]&&bounds.y==this.p1[1]&&bounds.width==this.p2[0]-this.p1[0]&&bounds.y==this.p2[1]&&bounds.width==this.p3[0]-this.p1[0]&&bounds.height==this.p3[1]-this.p2[1]&&bounds.x==this.p4[0]&&bounds.height==this.p4[1]-this.p2[1];},projectUnitRect:function(rect){var q=new Quad();this.projectUnitRectFast(q,rect);return q;},projectUnitRectFast:function(dstQuad,rect){var v12=tmpVec2s[0];var v14=tmpVec2s[1];var v23=tmpVec2s[2];var v43=tmpVec2s[3];var l12,l14,l23,l43;vec2.sub(v12,this.p2,this.p1);l12=vec2.length(v12);vec2.scale(v12,v12,1/l12);vec2.sub(v14,this.p4,this.p1);l14=vec2.length(v14);vec2.scale(v14,v14,1/l14);vec2.sub(v23,this.p3,this.p2);l23=vec2.length(v23);vec2.scale(v23,v23,1/l23);vec2.sub(v43,this.p3,this.p4);l43=vec2.length(v43);vec2.scale(v43,v43,1/l43);var b12=tmpVec2s[0];var b14=tmpVec2s[1];var b23=tmpVec2s[2];var b43=tmpVec2s[3];lerpVec2(b12,v12,v43,rect.y);lerpVec2(b43,v12,v43,1-rect.bottom);lerpVec2(b14,v14,v23,rect.x);lerpVec2(b23,v14,v23,1-rect.right);vec2.addTwoScaledUnitVectors(tmpVec2a,b12,l12*rect.x,b14,l14*rect.y);vec2.add(dstQuad.p1,this.p1,tmpVec2a);vec2.addTwoScaledUnitVectors(tmpVec2a,b12,l12*-(1.0-rect.right),b23,l23*rect.y);vec2.add(dstQuad.p2,this.p2,tmpVec2a);vec2.addTwoScaledUnitVectors(tmpVec2a,b43,l43*-(1.0-rect.right),b23,l23*-(1.0-rect.bottom));vec2.add(dstQuad.p3,this.p3,tmpVec2a);vec2.addTwoScaledUnitVectors(tmpVec2a,b43,l43*rect.left,b14,l14*-(1.0-rect.bottom));vec2.add(dstQuad.p4,this.p4,tmpVec2a);},toString:function(){return'Quad('+vec2.toString(this.p1)+', '+vec2.toString(this.p2)+', '+vec2.toString(this.p3)+', '+vec2.toString(this.p4)+')';}};function sign(p1,p2,p3){return(p1[0]-p3[0])*(p2[1]-p3[1])-(p2[0]-p3[0])*(p1[1]-p3[1]);}function pointInTriangle2(pt,p1,p2,p3){var b1=sign(pt,p1,p2)<0.0;var b2=sign(pt,p2,p3)<0.0;var b3=sign(pt,p3,p1)<0.0;return b1==b2&&b2==b3;}function pointInImplicitQuad(point,p1,p2,p3,p4){return pointInTriangle2(point,p1,p2,p3)||pointInTriangle2(point,p1,p3,p4);}return{pointInTriangle2:pointInTriangle2,pointInImplicitQuad:pointInImplicitQuad,Quad:Quad};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34,"./math.js":48}],52:[function(require,module,exports){(function(global){"use strict";require("./utils.js");'use strict';global.tr.exportTo('tr.b',function(){var ESTIMATED_IDLE_PERIOD_LENGTH_MILLISECONDS=10;var REQUEST_IDLE_CALLBACK_TIMEOUT_MILLISECONDS=100;var recordRAFStacks=false;var pendingPreAFs=[];var pendingRAFs=[];var pendingIdleCallbacks=[];var currentRAFDispatchList=undefined;var rafScheduled=false;var idleWorkScheduled=false;function scheduleRAF(){if(rafScheduled)return;rafScheduled=true;if(tr.isHeadless){Promise.resolve().then(function(){processRequests(false,0);},function(e){console.log(e.stack);throw e;});}else{if(window.requestAnimationFrame){window.requestAnimationFrame(processRequests.bind(this,false));}else{var delta=Date.now()-window.performance.now();window.webkitRequestAnimationFrame(function(domTimeStamp){processRequests(false,domTimeStamp-delta);});}}}function nativeRequestIdleCallbackSupported(){return!tr.isHeadless&&window.requestIdleCallback;}function scheduleIdleWork(){if(idleWorkScheduled)return;if(!nativeRequestIdleCallbackSupported()){scheduleRAF();return;}idleWorkScheduled=true;window.requestIdleCallback(function(deadline,didTimeout){processIdleWork(false,deadline);},{timeout:REQUEST_IDLE_CALLBACK_TIMEOUT_MILLISECONDS});}function onAnimationFrameError(e,opt_stack){console.log(e.stack);if(tr.isHeadless)throw e;if(opt_stack)console.log(opt_stack);if(e.message)console.error(e.message,e.stack);else console.error(e);}function runTask(task,frameBeginTime){try{task.callback.call(task.context,frameBeginTime);}catch(e){tr.b.onAnimationFrameError(e,task.stack);}}function processRequests(forceAllTasksToRun,frameBeginTime){rafScheduled=false;var currentPreAFs=pendingPreAFs;currentRAFDispatchList=pendingRAFs;pendingPreAFs=[];pendingRAFs=[];var hasRAFTasks=currentPreAFs.length||currentRAFDispatchList.length;for(var i=0;i<currentPreAFs.length;i++)runTask(currentPreAFs[i],frameBeginTime);while(currentRAFDispatchList.length>0)runTask(currentRAFDispatchList.shift(),frameBeginTime);currentRAFDispatchList=undefined;if(!hasRAFTasks&&!nativeRequestIdleCallbackSupported()||forceAllTasksToRun){var rafCompletionDeadline=frameBeginTime+ESTIMATED_IDLE_PERIOD_LENGTH_MILLISECONDS;processIdleWork(forceAllTasksToRun,{timeRemaining:function(){return rafCompletionDeadline-window.performance.now();}});}if(pendingIdleCallbacks.length>0)scheduleIdleWork();}function processIdleWork(forceAllTasksToRun,deadline){idleWorkScheduled=false;while(pendingIdleCallbacks.length>0){runTask(pendingIdleCallbacks.shift());if(!forceAllTasksToRun&&(tr.isHeadless||deadline.timeRemaining()<=0)){break;}}if(pendingIdleCallbacks.length>0)scheduleIdleWork();}function getStack_(){if(!recordRAFStacks)return'';var stackLines=tr.b.stackTrace();stackLines.shift();return stackLines.join('\n');}function requestPreAnimationFrame(callback,opt_this){pendingPreAFs.push({callback:callback,context:opt_this||global,stack:getStack_()});scheduleRAF();}function requestAnimationFrameInThisFrameIfPossible(callback,opt_this){if(!currentRAFDispatchList){requestAnimationFrame(callback,opt_this);return;}currentRAFDispatchList.push({callback:callback,context:opt_this||global,stack:getStack_()});return;}function requestAnimationFrame(callback,opt_this){pendingRAFs.push({callback:callback,context:opt_this||global,stack:getStack_()});scheduleRAF();}function requestIdleCallback(callback,opt_this){pendingIdleCallbacks.push({callback:callback,context:opt_this||global,stack:getStack_()});scheduleIdleWork();}function forcePendingRAFTasksToRun(frameBeginTime){if(!rafScheduled)return;processRequests(false,frameBeginTime);}function forceAllPendingTasksToRunForTest(){if(!rafScheduled&&!idleWorkScheduled)return;processRequests(true,0);}return{onAnimationFrameError:onAnimationFrameError,requestPreAnimationFrame:requestPreAnimationFrame,requestAnimationFrame:requestAnimationFrame,requestAnimationFrameInThisFrameIfPossible:requestAnimationFrameInThisFrameIfPossible,requestIdleCallback:requestIdleCallback,forcePendingRAFTasksToRun:forcePendingRAFTasksToRun,forceAllPendingTasksToRunForTest:forceAllPendingTasksToRunForTest};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./utils.js":65}],53:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./iteration_helpers.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){function Range(){this.isEmpty_=true;this.min_=undefined;this.max_=undefined;}Range.prototype={__proto__:Object.prototype,reset:function(){this.isEmpty_=true;this.min_=undefined;this.max_=undefined;},get isEmpty(){return this.isEmpty_;},addRange:function(range){if(range.isEmpty)return;this.addValue(range.min);this.addValue(range.max);},addValue:function(value){if(this.isEmpty_){this.max_=value;this.min_=value;this.isEmpty_=false;return;}this.max_=Math.max(this.max_,value);this.min_=Math.min(this.min_,value);},set min(min){this.isEmpty_=false;this.min_=min;},get min(){if(this.isEmpty_)return undefined;return this.min_;},get max(){if(this.isEmpty_)return undefined;return this.max_;},set max(max){this.isEmpty_=false;this.max_=max;},get range(){if(this.isEmpty_)return undefined;return this.max_-this.min_;},get center(){return(this.min_+this.max_)*0.5;},get duration(){if(this.isEmpty_)return 0;return this.max_-this.min_;},normalize:function(x){return tr.b.normalize(x,this.min,this.max);},lerp:function(x){return tr.b.lerp(x,this.min,this.max);},equals:function(that){if(this.isEmpty&&that.isEmpty)return true;if(this.isEmpty!=that.isEmpty)return false;return tr.b.approximately(this.min,that.min)&&tr.b.approximately(this.max,that.max);},containsExplicitRangeInclusive:function(min,max){if(this.isEmpty)return false;return this.min_<=min&&max<=this.max_;},containsExplicitRangeExclusive:function(min,max){if(this.isEmpty)return false;return this.min_<min&&max<this.max_;},intersectsExplicitRangeInclusive:function(min,max){if(this.isEmpty)return false;return this.min_<=max&&min<=this.max_;},intersectsExplicitRangeExclusive:function(min,max){if(this.isEmpty)return false;return this.min_<max&&min<this.max_;},containsRangeInclusive:function(range){if(range.isEmpty)return false;return this.containsExplicitRangeInclusive(range.min_,range.max_);},containsRangeExclusive:function(range){if(range.isEmpty)return false;return this.containsExplicitRangeExclusive(range.min_,range.max_);},intersectsRangeInclusive:function(range){if(range.isEmpty)return false;return this.intersectsExplicitRangeInclusive(range.min_,range.max_);},intersectsRangeExclusive:function(range){if(range.isEmpty)return false;return this.intersectsExplicitRangeExclusive(range.min_,range.max_);},findExplicitIntersectionDuration:function(min,max){var min=Math.max(this.min,min);var max=Math.min(this.max,max);if(max<min)return 0;return max-min;},findIntersection:function(range){if(this.isEmpty||range.isEmpty)return new Range();var min=Math.max(this.min,range.min);var max=Math.min(this.max,range.max);if(max<min)return new Range();return Range.fromExplicitRange(min,max);},toJSON:function(){if(this.isEmpty_)return{isEmpty:true};return{isEmpty:false,max:this.max,min:this.min};},filterArray:function(array,opt_keyFunc,opt_this){if(this.isEmpty_)return[];function binSearch(test){var i0=0;var i1=array.length;while(i0<i1){var i=Math.trunc((i0+i1)/2);if(test(i))i1=i;else i0=i+1;}return i1;}var keyFunc=opt_keyFunc||tr.b.identity;function getValue(index){return keyFunc.call(opt_this,array[index]);}var first=binSearch(function(i){return this.min_===undefined||this.min_<=getValue(i);}.bind(this));var last=binSearch(function(i){return this.max_!==undefined&&this.max_<getValue(i);}.bind(this));return array.slice(first,last);}};Range.fromDict=function(d){if(d.isEmpty===true){return new Range();}else if(d.isEmpty===false){var range=new Range();range.min=d.min;range.max=d.max;return range;}else{throw new Error('Not a range');}};Range.fromExplicitRange=function(min,max){var range=new Range();range.min=min;range.max=max;return range;};Range.compareByMinTimes=function(a,b){if(!a.isEmpty&&!b.isEmpty)return a.min_-b.min_;if(a.isEmpty&&!b.isEmpty)return-1;if(!a.isEmpty&&b.isEmpty)return 1;return 0;};Range.PERCENT_RANGE=Range.fromExplicitRange(0,1);Object.freeze(Range.PERCENT_RANGE);return{Range:Range};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34,"./iteration_helpers.js":47,"./math.js":48}],54:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./iteration_helpers.js");'use strict';global.tr.exportTo('tr.b',function(){function convertEventsToRanges(events){return events.map(function(event){return tr.b.Range.fromExplicitRange(event.start,event.end);});}function mergeRanges(inRanges,mergeThreshold,mergeFunction){var remainingEvents=inRanges.slice();remainingEvents.sort(function(x,y){return x.min-y.min;});if(remainingEvents.length<=1){var merged=[];if(remainingEvents.length==1){merged.push(mergeFunction(remainingEvents));}return merged;}var mergedEvents=[];var currentMergeBuffer=[];var rightEdge;function beginMerging(){currentMergeBuffer.push(remainingEvents[0]);remainingEvents.splice(0,1);rightEdge=currentMergeBuffer[0].max;}function flushCurrentMergeBuffer(){if(currentMergeBuffer.length==0)return;mergedEvents.push(mergeFunction(currentMergeBuffer));currentMergeBuffer=[];if(remainingEvents.length!=0)beginMerging();}beginMerging();while(remainingEvents.length){var currentEvent=remainingEvents[0];var distanceFromRightEdge=currentEvent.min-rightEdge;if(distanceFromRightEdge<mergeThreshold){rightEdge=Math.max(rightEdge,currentEvent.max);remainingEvents.splice(0,1);currentMergeBuffer.push(currentEvent);continue;}flushCurrentMergeBuffer();}flushCurrentMergeBuffer();return mergedEvents;}function findEmptyRangesBetweenRanges(inRanges,opt_totalRange){if(opt_totalRange&&opt_totalRange.isEmpty)opt_totalRange=undefined;var emptyRanges=[];if(!inRanges.length){if(opt_totalRange)emptyRanges.push(opt_totalRange);return emptyRanges;}inRanges=inRanges.slice();inRanges.sort(function(x,y){return x.min-y.min;});if(opt_totalRange&&opt_totalRange.min<inRanges[0].min){emptyRanges.push(tr.b.Range.fromExplicitRange(opt_totalRange.min,inRanges[0].min));}inRanges.forEach(function(range,index){for(var otherIndex=0;otherIndex<inRanges.length;++otherIndex){if(index===otherIndex)continue;var other=inRanges[otherIndex];if(other.min>range.max){emptyRanges.push(tr.b.Range.fromExplicitRange(range.max,other.min));return;}if(other.max>range.max){return;}}if(opt_totalRange&&range.max<opt_totalRange.max){emptyRanges.push(tr.b.Range.fromExplicitRange(range.max,opt_totalRange.max));}});return emptyRanges;}return{convertEventsToRanges:convertEventsToRanges,findEmptyRangesBetweenRanges:findEmptyRangesBetweenRanges,mergeRanges:mergeRanges};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34,"./iteration_helpers.js":47}],55:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){function Rect(){this.x=0;this.y=0;this.width=0;this.height=0;};Rect.fromXYWH=function(x,y,w,h){var rect=new Rect();rect.x=x;rect.y=y;rect.width=w;rect.height=h;return rect;};Rect.fromArray=function(ary){if(ary.length!=4)throw new Error('ary.length must be 4');var rect=new Rect();rect.x=ary[0];rect.y=ary[1];rect.width=ary[2];rect.height=ary[3];return rect;};Rect.prototype={__proto__:Object.prototype,get left(){return this.x;},get top(){return this.y;},get right(){return this.x+this.width;},get bottom(){return this.y+this.height;},toString:function(){return'Rect('+this.x+', '+this.y+', '+this.width+', '+this.height+')';},toArray:function(){return[this.x,this.y,this.width,this.height];},clone:function(){var rect=new Rect();rect.x=this.x;rect.y=this.y;rect.width=this.width;rect.height=this.height;return rect;},enlarge:function(pad){var rect=new Rect();this.enlargeFast(rect,pad);return rect;},enlargeFast:function(out,pad){out.x=this.x-pad;out.y=this.y-pad;out.width=this.width+2*pad;out.height=this.height+2*pad;return out;},size:function(){return{width:this.width,height:this.height};},scale:function(s){var rect=new Rect();this.scaleFast(rect,s);return rect;},scaleSize:function(s){return Rect.fromXYWH(this.x,this.y,this.width*s,this.height*s);},scaleFast:function(out,s){out.x=this.x*s;out.y=this.y*s;out.width=this.width*s;out.height=this.height*s;return out;},translate:function(v){var rect=new Rect();this.translateFast(rect,v);return rect;},translateFast:function(out,v){out.x=this.x+v[0];out.y=this.x+v[1];out.width=this.width;out.height=this.height;return out;},asUVRectInside:function(containingRect){var rect=new Rect();rect.x=(this.x-containingRect.x)/containingRect.width;rect.y=(this.y-containingRect.y)/containingRect.height;rect.width=this.width/containingRect.width;rect.height=this.height/containingRect.height;return rect;},intersects:function(that){var ok=true;ok&=this.x<that.right;ok&=this.right>that.x;ok&=this.y<that.bottom;ok&=this.bottom>that.y;return ok;},equalTo:function(rect){return rect&&this.x===rect.x&&this.y===rect.y&&this.width===rect.width&&this.height===rect.height;}};return{Rect:Rect};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34,"./math.js":48}],56:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){class RunningStatistics{constructor(){this.mean_=0;this.count_=0;this.max_=-Infinity;this.min_=Infinity;this.sum_=0;this.variance_=0;this.meanlogs_=0;}get count(){return this.count_;}get geometricMean(){if(this.meanlogs_===undefined)return 0;return Math.exp(this.meanlogs_);}get mean(){if(this.count_==0)return undefined;return this.mean_;}get max(){return this.max_;}get min(){return this.min_;}get sum(){return this.sum_;}get variance(){if(this.count_==0)return undefined;if(this.count_==1)return 0;return this.variance_/(this.count_-1);}get stddev(){if(this.count_==0)return undefined;return Math.sqrt(this.variance);}add(x){this.count_++;this.max_=Math.max(this.max_,x);this.min_=Math.min(this.min_,x);this.sum_+=x;if(x<=0)this.meanlogs_=undefined;else if(this.meanlogs_!==undefined)this.meanlogs_+=(Math.log(Math.abs(x))-this.meanlogs_)/this.count;if(this.count_===1){this.mean_=x;this.variance_=0;}else{var oldMean=this.mean_;var oldVariance=this.variance_;if(oldMean===Infinity||oldMean===-Infinity){this.mean_=this.sum_/this.count_;}else{this.mean_=oldMean+(x-oldMean)/this.count_;}this.variance_=oldVariance+(x-oldMean)*(x-this.mean_);}}merge(other){var result=new RunningStatistics();result.count_=this.count_+other.count_;result.sum_=this.sum_+other.sum_;result.min_=Math.min(this.min_,other.min_);result.max_=Math.max(this.max_,other.max_);if(result.count===0){result.mean_=0;result.variance_=0;result.meanlogs_=0;}else{result.mean_=result.sum/result.count;var deltaMean=(this.mean||0)-(other.mean||0);result.variance_=this.variance_+other.variance_+this.count*other.count*deltaMean*deltaMean/result.count;if(this.meanlogs_===undefined||other.meanlogs_===undefined){result.meanlogs_=undefined;}else{result.meanlogs_=(this.count*this.meanlogs_+other.count*other.meanlogs_)/result.count;}}return result;}asDict(){if(!this.count){return[];}return[this.count_,this.max_,this.meanlogs_,this.mean_,this.min_,this.sum_,this.variance_];}static fromDict(dict){var result=new RunningStatistics();if(dict.length!=7){return result;}var _dict=_slicedToArray(dict,7);result.count_=_dict[0];result.max_=_dict[1];result.meanlogs_=_dict[2];result.mean_=_dict[3];result.min_=_dict[4];result.sum_=_dict[5];result.variance_=_dict[6];return result;}}return{RunningStatistics:RunningStatistics};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],57:[function(require,module,exports){(function(global){"use strict";require("./color.js");require("./iteration_helpers.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){function SinebowColorGenerator(opt_a,opt_brightness){this.a_=opt_a===undefined?1:opt_a;this.brightness_=opt_brightness===undefined?1:opt_brightness;this.colorIndex_=0;this.keyToColor={};}SinebowColorGenerator.prototype={colorForKey:function(key){if(!this.keyToColor[key])this.keyToColor[key]=this.nextColor();return this.keyToColor[key];},nextColor:function(){var components=SinebowColorGenerator.nthColor(this.colorIndex_++);return tr.b.Color.fromString(SinebowColorGenerator.calculateColor(components[0],components[1],components[2],this.a_,this.brightness_));}};SinebowColorGenerator.PHI=(1+Math.sqrt(5))/2;SinebowColorGenerator.sinebow_=function(h){h+=0.5;h=-h;var r=Math.sin(Math.PI*h);var g=Math.sin(Math.PI*(h+1/3));var b=Math.sin(Math.PI*(h+2/3));r*=r;g*=g;b*=b;var y=2*(0.2989*r+0.5870*g+0.1140*b);r/=y;g/=y;b/=y;return[256*r,256*g,256*b];};SinebowColorGenerator.nthColor=function(n){return SinebowColorGenerator.sinebow_(n*this.PHI);};SinebowColorGenerator.calculateColor=function(r,g,b,a,brightness){if(brightness<=1){r*=brightness;g*=brightness;b*=brightness;}else{r=tr.b.lerp(tr.b.normalize(brightness,1,2),r,255);g=tr.b.lerp(tr.b.normalize(brightness,1,2),g,255);b=tr.b.lerp(tr.b.normalize(brightness,1,2),b,255);}r=Math.round(r);g=Math.round(g);b=Math.round(b);return'rgba('+r+','+g+','+b+', '+a+')';};return{SinebowColorGenerator:SinebowColorGenerator};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./color.js":37,"./iteration_helpers.js":47,"./math.js":48}],58:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function findLowIndexInSortedArray(ary,mapFn,loVal){if(ary.length==0)return 1;var low=0;var high=ary.length-1;var i,comparison;var hitPos=-1;while(low<=high){i=Math.floor((low+high)/2);comparison=mapFn(ary[i])-loVal;if(comparison<0){low=i+1;continue;}else if(comparison>0){high=i-1;continue;}else{hitPos=i;high=i-1;}}return hitPos!=-1?hitPos:low;}function findHighIndexInSortedArray(ary,mapFn,loVal,hiVal){var lo=loVal||0;var hi=hiVal!==undefined?hiVal:ary.length;while(lo<hi){var mid=lo+hi>>1;if(mapFn(ary[mid])>=0)lo=mid+1;else hi=mid;}return hi;}function findIndexInSortedIntervals(ary,mapLoFn,mapWidthFn,loVal){var first=findLowIndexInSortedArray(ary,mapLoFn,loVal);if(first==0){if(loVal>=mapLoFn(ary[0])&&loVal<mapLoFn(ary[0])+mapWidthFn(ary[0],0)){return 0;}else{return-1;}}else if(first<ary.length){if(loVal>=mapLoFn(ary[first])&&loVal<mapLoFn(ary[first])+mapWidthFn(ary[first],first)){return first;}else if(loVal>=mapLoFn(ary[first-1])&&loVal<mapLoFn(ary[first-1])+mapWidthFn(ary[first-1],first-1)){return first-1;}else{return ary.length;}}else if(first==ary.length){if(loVal>=mapLoFn(ary[first-1])&&loVal<mapLoFn(ary[first-1])+mapWidthFn(ary[first-1],first-1)){return first-1;}else{return ary.length;}}else{return ary.length;}}function findIndexInSortedClosedIntervals(ary,mapLoFn,mapHiFn,val){var i=findLowIndexInSortedArray(ary,mapLoFn,val);if(i===0){if(val>=mapLoFn(ary[0],0)&&val<=mapHiFn(ary[0],0)){return 0;}else{return-1;}}else if(i<ary.length){if(val>=mapLoFn(ary[i-1],i-1)&&val<=mapHiFn(ary[i-1],i-1)){return i-1;}else if(val>=mapLoFn(ary[i],i)&&val<=mapHiFn(ary[i],i)){return i;}else{return ary.length;}}else if(i==ary.length){if(val>=mapLoFn(ary[i-1],i-1)&&val<=mapHiFn(ary[i-1],i-1)){return i-1;}else{return ary.length;}}else{return ary.length;}}function iterateOverIntersectingIntervals(ary,mapLoFn,mapWidthFn,loVal,hiVal,cb){if(ary.length==0)return;if(loVal>hiVal)return;var i=findLowIndexInSortedArray(ary,mapLoFn,loVal);if(i==-1){return;}if(i>0){var hi=mapLoFn(ary[i-1])+mapWidthFn(ary[i-1],i-1);if(hi>=loVal){cb(ary[i-1],i-1);}}if(i==ary.length){return;}for(var n=ary.length;i<n;i++){var lo=mapLoFn(ary[i]);if(lo>=hiVal)break;cb(ary[i],i);}}function getIntersectingIntervals(ary,mapLoFn,mapWidthFn,loVal,hiVal){var tmp=[];iterateOverIntersectingIntervals(ary,mapLoFn,mapWidthFn,loVal,hiVal,function(d){tmp.push(d);});return tmp;}function findClosestElementInSortedArray(ary,mapFn,val,maxDiff){if(ary.length===0)return null;var aftIdx=findLowIndexInSortedArray(ary,mapFn,val);var befIdx=aftIdx>0?aftIdx-1:0;if(aftIdx===ary.length)aftIdx-=1;var befDiff=Math.abs(val-mapFn(ary[befIdx]));var aftDiff=Math.abs(val-mapFn(ary[aftIdx]));if(befDiff>maxDiff&&aftDiff>maxDiff)return null;var idx=befDiff<aftDiff?befIdx:aftIdx;return ary[idx];}function findClosestIntervalInSortedIntervals(ary,mapLoFn,mapHiFn,val,maxDiff){if(ary.length===0)return null;var idx=findLowIndexInSortedArray(ary,mapLoFn,val);if(idx>0)idx-=1;var hiInt=ary[idx];var loInt=hiInt;if(val>mapHiFn(hiInt)&&idx+1<ary.length)loInt=ary[idx+1];var loDiff=Math.abs(val-mapLoFn(loInt));var hiDiff=Math.abs(val-mapHiFn(hiInt));if(loDiff>maxDiff&&hiDiff>maxDiff)return null;if(loDiff<hiDiff)return loInt;else return hiInt;}return{findLowIndexInSortedArray:findLowIndexInSortedArray,findHighIndexInSortedArray:findHighIndexInSortedArray,findIndexInSortedIntervals:findIndexInSortedIntervals,findIndexInSortedClosedIntervals:findIndexInSortedClosedIntervals,iterateOverIntersectingIntervals:iterateOverIntersectingIntervals,getIntersectingIntervals:getIntersectingIntervals,findClosestElementInSortedArray:findClosestElementInSortedArray,findClosestIntervalInSortedIntervals:findClosestIntervalInSortedIntervals};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],59:[function(require,module,exports){(function(global){"use strict";require("./math.js");require("./range.js");'use strict';(function(){if(tr.isNode){var mwuAbsPath=HTMLImportsLoader.hrefToAbsolutePath('/mannwhitneyu.js');var mwuModule=require(mwuAbsPath);for(var exportName in mwuModule){global[exportName]=mwuModule[exportName];}}})(this);'use strict';global.tr.exportTo('tr.b',function(){var identity=x=>x;var Statistics={};Statistics.divideIfPossibleOrZero=function(numerator,denominator){if(denominator===0)return 0;return numerator/denominator;};Statistics.sum=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=0;var i=0;for(var elt of ary)ret+=func.call(opt_this,elt,i++);return ret;};Statistics.mean=function(ary,opt_func,opt_this){var func=opt_func||identity;var sum=0;var i=0;for(var elt of ary)sum+=func.call(opt_this,elt,i++);if(i===0)return undefined;return sum/i;};Statistics.geometricMean=function(ary,opt_func,opt_this){var func=opt_func||identity;var i=0;var logsum=0;for(var elt of ary){var x=func.call(opt_this,elt,i++);if(x<=0)return 0;logsum+=Math.log(Math.abs(x));}if(i===0)return 1;return Math.exp(logsum/i);};Statistics.weightedMean=function(ary,weightCallback,opt_valueCallback,opt_this){var valueCallback=opt_valueCallback||identity;var numerator=0;var denominator=0;var i=-1;for(var elt of ary){i++;var value=valueCallback.call(opt_this,elt,i);if(value===undefined)continue;var weight=weightCallback.call(opt_this,elt,i,value);numerator+=weight*value;denominator+=weight;}if(denominator===0)return undefined;return numerator/denominator;};Statistics.variance=function(ary,opt_func,opt_this){if(ary.length===0)return undefined;if(ary.length===1)return 0;var func=opt_func||identity;var mean=Statistics.mean(ary,func,opt_this);var sumOfSquaredDistances=Statistics.sum(ary,function(d,i){var v=func.call(this,d,i)-mean;return v*v;},opt_this);return sumOfSquaredDistances/(ary.length-1);};Statistics.stddev=function(ary,opt_func,opt_this){if(ary.length==0)return undefined;return Math.sqrt(Statistics.variance(ary,opt_func,opt_this));};Statistics.max=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=-Infinity;var i=0;for(var elt of ary)ret=Math.max(ret,func.call(opt_this,elt,i++));return ret;};Statistics.min=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=Infinity;var i=0;for(var elt of ary)ret=Math.min(ret,func.call(opt_this,elt,i++));return ret;};Statistics.range=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=new tr.b.Range();var i=0;for(var elt of ary)ret.addValue(func.call(opt_this,elt,i++));return ret;};Statistics.percentile=function(ary,percent,opt_func,opt_this){if(!(percent>=0&&percent<=1))throw new Error('percent must be [0,1]');var func=opt_func||identity;var tmp=new Array(ary.length);var i=0;for(var elt of ary)tmp[i]=func.call(opt_this,elt,i++);tmp.sort((a,b)=>a-b);var idx=Math.floor((ary.length-1)*percent);return tmp[idx];};Statistics.normalizeSamples=function(samples){if(samples.length===0){return{normalized_samples:samples,scale:1.0};}samples=samples.slice().sort(function(a,b){return a-b;});var low=Math.min.apply(null,samples);var high=Math.max.apply(null,samples);var newLow=0.5/samples.length;var newHigh=(samples.length-0.5)/samples.length;if(high-low===0.0){samples=Array.apply(null,new Array(samples.length)).map(function(){return 0.5;});return{normalized_samples:samples,scale:1.0};}var scale=(newHigh-newLow)/(high-low);for(var i=0;i<samples.length;i++){samples[i]=(samples[i]-low)*scale+newLow;}return{normalized_samples:samples,scale:scale};};Statistics.discrepancy=function(samples,opt_locationCount){if(samples.length===0)return 0.0;var maxLocalDiscrepancy=0;var invSampleCount=1.0/samples.length;var locations=[];var countLess=[];var countLessEqual=[];if(opt_locationCount!==undefined){var sampleIndex=0;for(var i=0;i<opt_locationCount;i++){var location=i/(opt_locationCount-1);locations.push(location);while(sampleIndex<samples.length&&samples[sampleIndex]<location){sampleIndex+=1;}countLess.push(sampleIndex);while(sampleIndex<samples.length&&samples[sampleIndex]<=location){sampleIndex+=1;}countLessEqual.push(sampleIndex);}}else{if(samples[0]>0.0){locations.push(0.0);countLess.push(0);countLessEqual.push(0);}for(var i=0;i<samples.length;i++){locations.push(samples[i]);countLess.push(i);countLessEqual.push(i+1);}if(samples[-1]<1.0){locations.push(1.0);countLess.push(samples.length);countLessEqual.push(samples.length);}}var maxDiff=0;var minDiff=0;for(var i=1;i<locations.length;i++){var length=locations[i]-locations[i-1];var countClosed=countLessEqual[i]-countLess[i-1];var countOpen=countLess[i]-countLessEqual[i-1];var countClosedIncrement=countLessEqual[i]-countLessEqual[i-1];var countOpenIncrement=countLess[i]-countLess[i-1];maxDiff=Math.max(countClosedIncrement*invSampleCount-length+maxDiff,countClosed*invSampleCount-length);minDiff=Math.min(countOpenIncrement*invSampleCount-length+minDiff,countOpen*invSampleCount-length);maxLocalDiscrepancy=Math.max(maxDiff,-minDiff,maxLocalDiscrepancy);}return maxLocalDiscrepancy;};Statistics.timestampsDiscrepancy=function(timestamps,opt_absolute,opt_locationCount){if(timestamps.length===0)return 0.0;if(opt_absolute===undefined)opt_absolute=true;if(Array.isArray(timestamps[0])){var rangeDiscrepancies=timestamps.map(function(r){return Statistics.timestampsDiscrepancy(r);});return Math.max.apply(null,rangeDiscrepancies);}var s=Statistics.normalizeSamples(timestamps);var samples=s.normalized_samples;var sampleScale=s.scale;var discrepancy=Statistics.discrepancy(samples,opt_locationCount);var invSampleCount=1.0/samples.length;if(opt_absolute===true){discrepancy/=sampleScale;}else{discrepancy=tr.b.clamp((discrepancy-invSampleCount)/(1.0-invSampleCount),0.0,1.0);}return discrepancy;};Statistics.durationsDiscrepancy=function(durations,opt_absolute,opt_locationCount){if(durations.length===0)return 0.0;var timestamps=durations.reduce(function(prev,curr,index,array){prev.push(prev[prev.length-1]+curr);return prev;},[0]);return Statistics.timestampsDiscrepancy(timestamps,opt_absolute,opt_locationCount);};Statistics.uniformlySampleArray=function(samples,count){if(samples.length<=count){return samples;}while(samples.length>count){var i=parseInt(Math.random()*samples.length);samples.splice(i,1);}return samples;};Statistics.uniformlySampleStream=function(samples,streamLength,newElement,numSamples){if(streamLength<=numSamples){if(samples.length>=streamLength)samples[streamLength-1]=newElement;else samples.push(newElement);return;}var probToKeep=numSamples/streamLength;if(Math.random()>probToKeep)return;var index=Math.floor(Math.random()*numSamples);samples[index]=newElement;};Statistics.mergeSampledStreams=function(samplesA,streamLengthA,samplesB,streamLengthB,numSamples){if(streamLengthB<numSamples){var nbElements=Math.min(streamLengthB,samplesB.length);for(var i=0;i<nbElements;++i){Statistics.uniformlySampleStream(samplesA,streamLengthA+i+1,samplesB[i],numSamples);}return;}if(streamLengthA<numSamples){var nbElements=Math.min(streamLengthA,samplesA.length);var tempSamples=samplesB.slice();for(var i=0;i<nbElements;++i){Statistics.uniformlySampleStream(tempSamples,streamLengthB+i+1,samplesA[i],numSamples);}for(var i=0;i<tempSamples.length;++i){samplesA[i]=tempSamples[i];}return;}var nbElements=Math.min(numSamples,samplesB.length);var probOfSwapping=streamLengthB/(streamLengthA+streamLengthB);for(var i=0;i<nbElements;++i){if(Math.random()<probOfSwapping){samplesA[i]=samplesB[i];}}};function Distribution(){}Distribution.prototype={computeDensity:function(x){throw Error('Not implemented');},computePercentile:function(x){throw Error('Not implemented');},computeComplementaryPercentile:function(x){return 1-this.computePercentile(x);},get mean(){throw Error('Not implemented');},get mode(){throw Error('Not implemented');},get median(){throw Error('Not implemented');},get standardDeviation(){throw Error('Not implemented');},get variance(){throw Error('Not implemented');}};Statistics.UniformDistribution=function(opt_range){if(!opt_range)opt_range=tr.b.Range.fromExplicitRange(0,1);this.range=opt_range;};Statistics.UniformDistribution.prototype={__proto__:Distribution.prototype,computeDensity:function(x){return 1/this.range.range;},computePercentile:function(x){return tr.b.normalize(x,this.range.min,this.range.max);},get mean(){return this.range.center;},get mode(){return undefined;},get median(){return this.mean;},get standardDeviation(){return Math.sqrt(this.variance);},get variance(){return Math.pow(this.range.range,2)/12;}};Statistics.NormalDistribution=function(opt_mean,opt_variance){this.mean_=opt_mean||0;this.variance_=opt_variance||1;this.standardDeviation_=Math.sqrt(this.variance_);};Statistics.NormalDistribution.prototype={__proto__:Distribution.prototype,computeDensity:function(x){var scale=1.0/(this.standardDeviation*Math.sqrt(2.0*Math.PI));var exponent=-Math.pow(x-this.mean,2)/(2.0*this.variance);return scale*Math.exp(exponent);},computePercentile:function(x){var standardizedX=(x-this.mean)/Math.sqrt(2.0*this.variance);return(1.0+tr.b.erf(standardizedX))/2.0;},get mean(){return this.mean_;},get median(){return this.mean;},get mode(){return this.mean;},get standardDeviation(){return this.standardDeviation_;},get variance(){return this.variance_;}};Statistics.LogNormalDistribution=function(opt_location,opt_shape){this.normalDistribution_=new Statistics.NormalDistribution(opt_location,Math.pow(opt_shape||1,2));};Statistics.LogNormalDistribution.prototype={__proto__:Statistics.NormalDistribution.prototype,computeDensity:function(x){return this.normalDistribution_.computeDensity(Math.log(x))/x;},computePercentile:function(x){return this.normalDistribution_.computePercentile(Math.log(x));},get mean(){return Math.exp(this.normalDistribution_.mean+this.normalDistribution_.variance/2);},get variance(){var nm=this.normalDistribution_.mean;var nv=this.normalDistribution_.variance;return Math.exp(2*(nm+nv))-Math.exp(2*nm+nv);},get standardDeviation(){return Math.sqrt(this.variance);},get median(){return Math.exp(this.normalDistribution_.mean);},get mode(){return Math.exp(this.normalDistribution_.mean-this.normalDistribution_.variance);}};Statistics.LogNormalDistribution.fromMedianAndDiminishingReturns=function(median,diminishingReturns){diminishingReturns=Math.log(diminishingReturns/median);var shape=Math.sqrt(1-3*diminishingReturns-Math.sqrt(Math.pow(diminishingReturns-3,2)-8))/2;var location=Math.log(median);return new Statistics.LogNormalDistribution(location,shape);};Statistics.DEFAULT_ALPHA=0.05;Statistics.Significance={INSIGNIFICANT:-1,DONT_CARE:0,SIGNIFICANT:1};Statistics.mwu=function(a,b,opt_alpha){var result=mannwhitneyu.test(a,b);var alpha=opt_alpha||Statistics.DEFAULT_ALPHA;result.significance=result.p<alpha?Statistics.Significance.SIGNIFICANT:Statistics.Significance.INSIGNIFICANT;return result;};return{Statistics:Statistics};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./math.js":48,"./range.js":53}],60:[function(require,module,exports){(function(global){"use strict";require("./raf.js");require("./timing.js");'use strict';global.tr.exportTo('tr.b',function(){var Timing=tr.b.Timing;function Task(runCb,thisArg){if(runCb!==undefined&&thisArg===undefined)throw new Error('Almost certainly, you meant to pass a thisArg.');this.runCb_=runCb;this.thisArg_=thisArg;this.afterTask_=undefined;this.subTasks_=[];}Task.prototype={get name(){return this.runCb_.name;},subTask:function(cb,thisArg){if(cb instanceof Task)this.subTasks_.push(cb);else this.subTasks_.push(new Task(cb,thisArg));return this.subTasks_[this.subTasks_.length-1];},run:function(){if(this.runCb_!==undefined)this.runCb_.call(this.thisArg_,this);var subTasks=this.subTasks_;this.subTasks_=undefined;if(!subTasks.length)return this.afterTask_;for(var i=1;i<subTasks.length;i++)subTasks[i-1].afterTask_=subTasks[i];subTasks[subTasks.length-1].afterTask_=this.afterTask_;return subTasks[0];},after:function(cb,thisArg){if(this.afterTask_)throw new Error('Has an after task already');if(cb instanceof Task)this.afterTask_=cb;else this.afterTask_=new Task(cb,thisArg);return this.afterTask_;},timedAfter:function(groupName,cb,thisArg,opt_args){if(cb.name==='')throw new Error('Anonymous Task is not allowed');return this.namedTimedAfter(groupName,cb.name,cb,thisArg,opt_args);},namedTimedAfter:function(groupName,name,cb,thisArg,opt_args){if(this.afterTask_)throw new Error('Has an after task already');var realTask;if(cb instanceof Task)realTask=cb;else realTask=new Task(cb,thisArg);this.afterTask_=new Task(function(task){var markedTask=Timing.mark(groupName,name,opt_args);task.subTask(realTask,thisArg);task.subTask(function(){markedTask.end();},thisArg);},thisArg);return this.afterTask_;},enqueue:function(cb,thisArg){var lastTask=this;while(lastTask.afterTask_)lastTask=lastTask.afterTask_;return lastTask.after(cb,thisArg);}};Task.RunSynchronously=function(task){var curTask=task;while(curTask)curTask=curTask.run();};Task.RunWhenIdle=function(task){return new Promise(function(resolve,reject){var curTask=task;function runAnother(){try{curTask=curTask.run();}catch(e){reject(e);console.error(e.stack);return;}if(curTask){tr.b.requestIdleCallback(runAnother);return;}resolve();}tr.b.requestIdleCallback(runAnother);});};return{Task:Task};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./raf.js":52,"./timing.js":62}],61:[function(require,module,exports){(function(global){"use strict";require("./unit_scale.js");'use strict';global.tr.exportTo('tr.b',function(){var msDisplayMode={scale:1e-3,suffix:'ms',roundedLess:function(a,b){return Math.round(a*1000)<Math.round(b*1000);},formatSpec:{unit:'s',unitPrefix:tr.b.UnitScale.Metric.MILLI,minimumFractionDigits:3}};var nsDisplayMode={scale:1e-9,suffix:'ns',roundedLess:function(a,b){return Math.round(a*1000000)<Math.round(b*1000000);},formatSpec:{unit:'s',unitPrefix:tr.b.UnitScale.Metric.NANO,maximumFractionDigits:0}};var TimeDisplayModes={ns:nsDisplayMode,ms:msDisplayMode};return{TimeDisplayModes:TimeDisplayModes};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./unit_scale.js":64}],62:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./base64.js");'use strict';global.tr.exportTo('tr.b',function(){var Base64=tr.b.Base64;function computeUserTimingMarkName(groupName,functionName,opt_args){if(groupName===undefined)throw new Error('getMeasureString should have group name');if(functionName===undefined)throw new Error('getMeasureString should have function name');var userTimingMarkName=groupName+':'+functionName;if(opt_args!==undefined){userTimingMarkName+='/';userTimingMarkName+=Base64.btoa(JSON.stringify(opt_args));}return userTimingMarkName;}function Timing(){}Timing.nextMarkNumber=0;Timing.mark=function(groupName,functionName,opt_args){if(tr.isHeadless){return{end:function(){}};}var userTimingMarkName=computeUserTimingMarkName(groupName,functionName,opt_args);var markBeginName='tvcm.mark'+Timing.nextMarkNumber++;var markEndName='tvcm.mark'+Timing.nextMarkNumber++;window.performance.mark(markBeginName);return{end:function(){window.performance.mark(markEndName);window.performance.measure(userTimingMarkName,markBeginName,markEndName);}};};Timing.wrap=function(groupName,callback,opt_args){if(groupName===undefined)throw new Error('Timing.wrap should have group name');if(callback.name==='')throw new Error('Anonymous function is not allowed');return Timing.wrapNamedFunction(groupName,callback.name,callback,opt_args);};Timing.wrapNamedFunction=function(groupName,functionName,callback,opt_args){function timedNamedFunction(){var markedTime=Timing.mark(groupName,functionName,opt_args);try{callback.apply(this,arguments);}finally{markedTime.end();}}return timedNamedFunction;};function TimedNamedPromise(groupName,name,executor,opt_args){var markedTime=Timing.mark(groupName,name,opt_args);var promise=new Promise(executor);promise.then(function(result){markedTime.end();return result;},function(e){markedTime.end();throw e;});return promise;}return{_computeUserTimingMarkName:computeUserTimingMarkName,TimedNamedPromise:TimedNamedPromise,Timing:Timing};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34,"./base64.js":35}],63:[function(require,module,exports){(function(global){"use strict";require("./event.js");require("./event_target.js");require("./iteration_helpers.js");require("./time_display_modes.js");require("./unit_scale.js");'use strict';global.tr.exportTo('tr.b',function(){var TimeDisplayModes=tr.b.TimeDisplayModes;var PLUS_MINUS_SIGN=String.fromCharCode(177);function max(a,b){if(a===undefined)return b;if(b===undefined)return a;return a.scale>b.scale?a:b;}var ImprovementDirection={DONT_CARE:0,BIGGER_IS_BETTER:1,SMALLER_IS_BETTER:2};function Unit(unitName,jsonName,basePrefix,isDelta,improvementDirection,formatSpec){this.unitName=unitName;this.jsonName=jsonName;this.basePrefix=basePrefix;this.isDelta=isDelta;this.improvementDirection=improvementDirection;this.formatSpec_=formatSpec;this.baseUnit=undefined;this.correspondingDeltaUnit=undefined;}Unit.prototype={asJSON:function(){return this.jsonName;},get unitString(){var formatSpec=this.formatSpec_;if(typeof formatSpec==='function')formatSpec=formatSpec();if(!formatSpec.unit){return'';}var unitString='';var unitPrefix=formatSpec.unitPrefix;if(unitPrefix!==undefined){var selectedPrefix;if(unitPrefix instanceof Array){selectedPrefix=unitPrefix[0];}else{selectedPrefix=unitPrefix;}unitString+=selectedPrefix.symbol||'';}unitString+=formatSpec.unit;return unitString;},format:function(value,opt_context){var context=opt_context||{};var formatSpec=this.formatSpec_;if(typeof formatSpec==='function')formatSpec=formatSpec();function resolveProperty(propertyName){if(propertyName in context)return context[propertyName];else if(propertyName in formatSpec)return formatSpec[propertyName];else return undefined;}var signString='';if(value<0){signString='-';value=-value;}else if(this.isDelta){signString=value===0?PLUS_MINUS_SIGN:'+';}var unitString='';if(formatSpec.unit){if(formatSpec.unitHasPrecedingSpace!==false)unitString+=' ';var unitPrefix=resolveProperty('unitPrefix');if(unitPrefix!==undefined){var selectedPrefix;if(unitPrefix instanceof Array){var i=0;while(i<unitPrefix.length-1&&value/unitPrefix[i+1].value>=1){i++;}selectedPrefix=unitPrefix[i];}else{selectedPrefix=unitPrefix;}unitString+=selectedPrefix.symbol||'';value=tr.b.convertUnit(value,this.basePrefix,selectedPrefix);}else{value=tr.b.convertUnit(value,this.basePrefix,tr.b.UnitScale.Metric.NONE);}unitString+=formatSpec.unit;}var minimumFractionDigits=resolveProperty('minimumFractionDigits');var maximumFractionDigits=resolveProperty('maximumFractionDigits');if(minimumFractionDigits>maximumFractionDigits){if('minimumFractionDigits'in context&&!('maximumFractionDigits'in context)){maximumFractionDigits=minimumFractionDigits;}else if('maximumFractionDigits'in context&&!('minimumFractionDigits'in context)){minimumFractionDigits=maximumFractionDigits;}}var numberString=value.toLocaleString(undefined,{minimumFractionDigits:minimumFractionDigits,maximumFractionDigits:maximumFractionDigits});return signString+numberString+unitString;}};Unit.reset=function(){Unit.currentTimeDisplayMode=TimeDisplayModes.ms;};Unit.timestampFromUs=function(us){return tr.b.convertUnit(us,tr.b.UnitScale.Metric.MICRO,tr.b.UnitScale.Metric.MILLI);};Object.defineProperty(Unit,'currentTimeDisplayMode',{get:function(){return Unit.currentTimeDisplayMode_;},set:function(value){if(Unit.currentTimeDisplayMode_===value)return;Unit.currentTimeDisplayMode_=value;Unit.dispatchEvent(new tr.b.Event('display-mode-changed'));}});Unit.didPreferredTimeDisplayUnitChange=function(){var largest=undefined;var els=tr.b.findDeepElementsMatching(document.body,'tr-v-ui-preferred-display-unit');els.forEach(function(el){largest=max(largest,el.preferredTimeDisplayMode);});Unit.currentDisplayUnit=largest===undefined?TimeDisplayModes.ms:largest;};Unit.byName={};Unit.byJSONName={};Unit.fromJSON=function(object){var u=Unit.byJSONName[object];if(u){return u;}throw new Error('Unrecognized unit');};Unit.define=function(params){var definedUnits=[];tr.b.iterItems(ImprovementDirection,function(_,improvementDirection){var regularUnit=Unit.defineUnitVariant_(params,false,improvementDirection);var deltaUnit=Unit.defineUnitVariant_(params,true,improvementDirection);regularUnit.correspondingDeltaUnit=deltaUnit;deltaUnit.correspondingDeltaUnit=deltaUnit;definedUnits.push(regularUnit,deltaUnit);});var baseUnit=Unit.byName[params.baseUnitName];definedUnits.forEach(u=>u.baseUnit=baseUnit);};Unit.nameSuffixForImprovementDirection=function(improvementDirection){switch(improvementDirection){case ImprovementDirection.DONT_CARE:return'';case ImprovementDirection.BIGGER_IS_BETTER:return'_biggerIsBetter';case ImprovementDirection.SMALLER_IS_BETTER:return'_smallerIsBetter';default:throw new Error('Unknown improvement direction: '+improvementDirection);}};Unit.defineUnitVariant_=function(params,isDelta,improvementDirection){var nameSuffix=isDelta?'Delta':'';nameSuffix+=Unit.nameSuffixForImprovementDirection(improvementDirection);var unitName=params.baseUnitName+nameSuffix;var jsonName=params.baseJsonName+nameSuffix;if(Unit.byName[unitName]!==undefined)throw new Error('Unit \''+unitName+'\' already exists');if(Unit.byJSONName[jsonName]!==undefined)throw new Error('JSON unit \''+jsonName+'\' alread exists');var basePrefix=params.basePrefix?params.basePrefix:tr.b.UnitScale.Metric.NONE;var unit=new Unit(unitName,jsonName,basePrefix,isDelta,improvementDirection,params.formatSpec);Unit.byName[unitName]=unit;Unit.byJSONName[jsonName]=unit;return unit;};tr.b.EventTarget.decorate(Unit);Unit.reset();Unit.define({baseUnitName:'timeDurationInMs',baseJsonName:'ms',basePrefix:tr.b.UnitScale.Metric.MILLI,formatSpec:function(){return Unit.currentTimeDisplayMode_.formatSpec;}});Unit.define({baseUnitName:'timeStampInMs',baseJsonName:'tsMs',basePrefix:tr.b.UnitScale.Metric.MILLI,formatSpec:function(){return Unit.currentTimeDisplayMode_.formatSpec;}});Unit.define({baseUnitName:'normalizedPercentage',baseJsonName:'n%',formatSpec:{unit:'%',unitPrefix:{value:0.01},unitHasPrecedingSpace:false,minimumFractionDigits:3,maximumFractionDigits:3}});Unit.define({baseUnitName:'sizeInBytes',baseJsonName:'sizeInBytes',formatSpec:{unit:'B',unitPrefix:tr.b.UnitScale.Binary.AUTO,minimumFractionDigits:1,maximumFractionDigits:1}});Unit.define({baseUnitName:'energyInJoules',baseJsonName:'J',formatSpec:{unit:'J',minimumFractionDigits:3}});Unit.define({baseUnitName:'powerInWatts',baseJsonName:'W',formatSpec:{unit:'W',minimumFractionDigits:3}});Unit.define({baseUnitName:'unitlessNumber',baseJsonName:'unitless',formatSpec:{minimumFractionDigits:3,maximumFractionDigits:3}});Unit.define({baseUnitName:'count',baseJsonName:'count',formatSpec:{minimumFractionDigits:0,maximumFractionDigits:0}});Unit.define({baseUnitName:'sigma',baseJsonName:'sigma',formatSpec:{unit:String.fromCharCode(963),minimumFractionDigits:1,maximumFractionDigits:1}});return{ImprovementDirection:ImprovementDirection,Unit:Unit};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./event.js":39,"./event_target.js":40,"./iteration_helpers.js":47,"./time_display_modes.js":61,"./unit_scale.js":64}],64:[function(require,module,exports){(function(global){"use strict";require("./iteration_helpers.js");'use strict';var GREEK_SMALL_LETTER_MU=String.fromCharCode(956);global.tr.exportTo('tr.b',function(){var UnitScale={};function defineUnitScale(name,prefixes){if(UnitScale[name]!==undefined)throw new Error('Unit scale \''+name+'\' already exists');if(prefixes.AUTO!==undefined){throw new Error('\'AUTO\' unit prefix will be added automatically '+'for unit scale \''+name+'\'');}prefixes.AUTO=tr.b.dictionaryValues(prefixes);prefixes.AUTO.sort((a,b)=>a.value-b.value);UnitScale[name]=prefixes;}function convertUnit(value,fromPrefix,toPrefix){if(value===undefined)return undefined;return value*(fromPrefix.value/toPrefix.value);}defineUnitScale('Binary',{NONE:{value:Math.pow(1024,0),symbol:''},KIBI:{value:Math.pow(1024,1),symbol:'Ki'},MEBI:{value:Math.pow(1024,2),symbol:'Mi'},GIBI:{value:Math.pow(1024,3),symbol:'Gi'},TEBI:{value:Math.pow(1024,4),symbol:'Ti'}});defineUnitScale('Metric',{NANO:{value:1e-9,symbol:'n'},MICRO:{value:1e-6,symbol:GREEK_SMALL_LETTER_MU},MILLI:{value:1e-3,symbol:'m'},NONE:{value:1,symbol:''},KILO:{value:1e3,symbol:'k'},MEGA:{value:1e6,symbol:'M'},GIGA:{value:1e9,symbol:'G'}});return{UnitScale:UnitScale,convertUnit:convertUnit};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./iteration_helpers.js":47}],65:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function addSingletonGetter(ctor){ctor.getInstance=function(){return ctor.instance_||(ctor.instance_=new ctor());};}function deepCopy(value){if(!(value instanceof Object)){if(value===undefined||value===null)return value;if(typeof value=='string')return value.substring();if(typeof value=='boolean')return value;if(typeof value=='number')return value;throw new Error('Unrecognized: '+typeof value);}var object=value;if(object instanceof Array){var res=new Array(object.length);for(var i=0;i<object.length;i++)res[i]=deepCopy(object[i]);return res;}if(object.__proto__!=Object.prototype)throw new Error('Can only clone simple types');var res={};for(var key in object){res[key]=deepCopy(object[key]);}return res;}function normalizeException(e){if(e===undefined||e===null){return{typeName:'UndefinedError',message:'Unknown: null or undefined exception',stack:'Unknown'};}if(typeof e=='string'){return{typeName:'StringError',message:e,stack:[e]};}var typeName;if(e.name){typeName=e.name;}else if(e.constructor){if(e.constructor.name){typeName=e.constructor.name;}else{typeName='AnonymousError';}}else{typeName='ErrorWithNoConstructor';}var msg=e.message?e.message:'Unknown';return{typeName:typeName,message:msg,stack:e.stack?e.stack:[msg]};}function stackTraceAsString(){return new Error().stack+'';}function stackTrace(){var stack=stackTraceAsString();stack=stack.split('\n');return stack.slice(2);}function getUsingPath(path,fromDict){var parts=path.split('.');var cur=fromDict;for(var part;parts.length&&(part=parts.shift());){if(!parts.length){return cur[part];}else if(part in cur){cur=cur[part];}else{return undefined;}}return undefined;}function formatDate(date){return date.toISOString().replace('T',' ').slice(0,19);}return{addSingletonGetter:addSingletonGetter,deepCopy:deepCopy,normalizeException:normalizeException,stackTrace:stackTrace,stackTraceAsString:stackTraceAsString,formatDate:formatDate,getUsingPath:getUsingPath};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./base.js":34}],66:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/extension_registry.js");'use strict';global.tr.exportTo('tr.c',function(){function Auditor(model){this.model_=model;}Auditor.prototype={__proto__:Object.prototype,get model(){return this.model_;},runAnnotate:function(){},installUserFriendlyCategoryDriverIfNeeded:function(){},runAudit:function(){}};var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);options.defaultMetadata={};options.mandatoryBaseClass=Auditor;tr.b.decorateExtensionRegistry(Auditor,options);return{Auditor:Auditor};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/extension_registry.js":41}],67:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.c',function(){function makeCaseInsensitiveRegex(pattern){pattern=pattern.replace(/[.*+?^${}()|[\]\\]/g,'\\$&');return new RegExp(pattern,'i');}function Filter(){}Filter.prototype={__proto__:Object.prototype,matchCounter:function(counter){return true;},matchCpu:function(cpu){return true;},matchProcess:function(process){return true;},matchSlice:function(slice){return true;},matchThread:function(thread){return true;}};function TitleOrCategoryFilter(text){Filter.call(this);this.regex_=makeCaseInsensitiveRegex(text);if(!text.length)throw new Error('Filter text is empty.');}TitleOrCategoryFilter.prototype={__proto__:Filter.prototype,matchSlice:function(slice){if(slice.title===undefined&&slice.category===undefined)return false;return this.regex_.test(slice.title)||!!slice.category&&this.regex_.test(slice.category);}};function ExactTitleFilter(text){Filter.call(this);this.text_=text;if(!text.length)throw new Error('Filter text is empty.');}ExactTitleFilter.prototype={__proto__:Filter.prototype,matchSlice:function(slice){return slice.title===this.text_;}};function FullTextFilter(text){Filter.call(this);this.regex_=makeCaseInsensitiveRegex(text);this.titleOrCategoryFilter_=new TitleOrCategoryFilter(text);}FullTextFilter.prototype={__proto__:Filter.prototype,matchObject_:function(obj){for(var key in obj){if(!obj.hasOwnProperty(key))continue;if(this.regex_.test(key))return true;if(this.regex_.test(obj[key]))return true;}return false;},matchSlice:function(slice){if(this.titleOrCategoryFilter_.matchSlice(slice))return true;return this.matchObject_(slice.args);}};return{Filter:Filter,TitleOrCategoryFilter:TitleOrCategoryFilter,ExactTitleFilter:ExactTitleFilter,FullTextFilter:FullTextFilter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],68:[function(require,module,exports){(function(global){"use strict";require("../../../model/async_slice.js");require("../../../model/event_set.js");require("../../../model/helpers/chrome_model_helper.js");'use strict';global.tr.exportTo('tr.e.cc',function(){var AsyncSlice=tr.model.AsyncSlice;var EventSet=tr.model.EventSet;var UI_COMP_NAME='INPUT_EVENT_LATENCY_UI_COMPONENT';var ORIGINAL_COMP_NAME='INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT';var BEGIN_COMP_NAME='INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT';var END_COMP_NAME='INPUT_EVENT_LATENCY_TERMINATED_FRAME_SWAP_COMPONENT';var MAIN_RENDERER_THREAD_NAME='CrRendererMain';var COMPOSITOR_THREAD_NAME='Compositor';var POSTTASK_FLOW_EVENT='disabled-by-default-toplevel.flow';var IPC_FLOW_EVENT='disabled-by-default-ipc.flow';var INPUT_EVENT_TYPE_NAMES={CHAR:'Char',CLICK:'GestureClick',CONTEXT_MENU:'ContextMenu',FLING_CANCEL:'GestureFlingCancel',FLING_START:'GestureFlingStart',KEY_DOWN:'KeyDown',KEY_DOWN_RAW:'RawKeyDown',KEY_UP:'KeyUp',LATENCY_SCROLL_UPDATE:'ScrollUpdate',MOUSE_DOWN:'MouseDown',MOUSE_ENTER:'MouseEnter',MOUSE_LEAVE:'MouseLeave',MOUSE_MOVE:'MouseMove',MOUSE_UP:'MouseUp',MOUSE_WHEEL:'MouseWheel',PINCH_BEGIN:'GesturePinchBegin',PINCH_END:'GesturePinchEnd',PINCH_UPDATE:'GesturePinchUpdate',SCROLL_BEGIN:'GestureScrollBegin',SCROLL_END:'GestureScrollEnd',SCROLL_UPDATE:'GestureScrollUpdate',SCROLL_UPDATE_RENDERER:'ScrollUpdate',SHOW_PRESS:'GestureShowPress',TAP:'GestureTap',TAP_CANCEL:'GestureTapCancel',TAP_DOWN:'GestureTapDown',TOUCH_CANCEL:'TouchCancel',TOUCH_END:'TouchEnd',TOUCH_MOVE:'TouchMove',TOUCH_START:'TouchStart',UNKNOWN:'UNKNOWN'};function InputLatencyAsyncSlice(){AsyncSlice.apply(this,arguments);this.associatedEvents_=new EventSet();this.typeName_=undefined;if(!this.isLegacyEvent)this.determineModernTypeName_();}InputLatencyAsyncSlice.prototype={__proto__:AsyncSlice.prototype,get isLegacyEvent(){return this.title==='InputLatency';},get typeName(){if(!this.typeName_)this.determineLegacyTypeName_();return this.typeName_;},checkTypeName_:function(){if(!this.typeName_)throw'Unable to determine typeName';var found=false;for(var typeName in INPUT_EVENT_TYPE_NAMES){if(this.typeName===INPUT_EVENT_TYPE_NAMES[typeName]){found=true;break;}}if(!found)this.typeName_=INPUT_EVENT_TYPE_NAMES.UNKNOWN;},determineModernTypeName_:function(){var lastColonIndex=this.title.lastIndexOf(':');if(lastColonIndex<0)return;var characterAfterLastColonIndex=lastColonIndex+1;this.typeName_=this.title.slice(characterAfterLastColonIndex);this.checkTypeName_();},determineLegacyTypeName_:function(){for(var subSlice of this.enumerateAllDescendents()){var subSliceIsAInputLatencyAsyncSlice=subSlice instanceof InputLatencyAsyncSlice;if(!subSliceIsAInputLatencyAsyncSlice)continue;if(!subSlice.typeName)continue;if(this.typeName_&&subSlice.typeName_){var subSliceHasDifferentTypeName=this.typeName_!==subSlice.typeName_;if(subSliceHasDifferentTypeName){throw'InputLatencyAsyncSlice.determineLegacyTypeName_() '+' found multiple typeNames';}}this.typeName_=subSlice.typeName_;}if(!this.typeName_)throw'InputLatencyAsyncSlice.determineLegacyTypeName_() failed';this.checkTypeName_();},getRendererHelper:function(sourceSlices){var traceModel=this.startThread.parent.model;var modelHelper=traceModel.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);if(!modelHelper)return undefined;var mainThread=undefined;var compositorThread=undefined;for(var i in sourceSlices){if(sourceSlices[i].parentContainer.name===MAIN_RENDERER_THREAD_NAME)mainThread=sourceSlices[i].parentContainer;else if(sourceSlices[i].parentContainer.name===COMPOSITOR_THREAD_NAME)compositorThread=sourceSlices[i].parentContainer;if(mainThread&&compositorThread)break;}var rendererHelpers=modelHelper.rendererHelpers;var pids=Object.keys(rendererHelpers);for(var i=0;i<pids.length;i++){var pid=pids[i];var rendererHelper=rendererHelpers[pid];if(rendererHelper.mainThread===mainThread||rendererHelper.compositorThread===compositorThread)return rendererHelper;}return undefined;},addEntireSliceHierarchy:function(slice){this.associatedEvents_.push(slice);slice.iterateAllSubsequentSlices(function(subsequentSlice){this.associatedEvents_.push(subsequentSlice);},this);},addDirectlyAssociatedEvents:function(flowEvents){var slices=[];flowEvents.forEach(function(flowEvent){this.associatedEvents_.push(flowEvent);var newSource=flowEvent.startSlice.mostTopLevelSlice;if(slices.indexOf(newSource)===-1)slices.push(newSource);},this);var lastFlowEvent=flowEvents[flowEvents.length-1];var lastSource=lastFlowEvent.endSlice.mostTopLevelSlice;if(slices.indexOf(lastSource)===-1)slices.push(lastSource);return slices;},addScrollUpdateEvents:function(rendererHelper){if(!rendererHelper||!rendererHelper.compositorThread)return;var compositorThread=rendererHelper.compositorThread;var gestureScrollUpdateStart=this.start;var gestureScrollUpdateEnd=this.end;var allCompositorAsyncSlices=compositorThread.asyncSliceGroup.slices;for(var i in allCompositorAsyncSlices){var slice=allCompositorAsyncSlices[i];if(slice.title!=='Latency::ScrollUpdate')continue;var parentId=slice.args.data.INPUT_EVENT_LATENCY_FORWARD_SCROLL_UPDATE_TO_MAIN_COMPONENT.sequence_number;if(parentId===undefined){if(slice.start<gestureScrollUpdateStart||slice.start>=gestureScrollUpdateEnd)continue;}else{if(parseInt(parentId)!==parseInt(this.id))continue;}slice.associatedEvents.forEach(function(event){this.associatedEvents_.push(event);},this);break;}},belongToOtherInputs:function(slice,flowEvents){var fromOtherInputs=false;slice.iterateEntireHierarchy(function(subsequentSlice){if(fromOtherInputs)return;subsequentSlice.inFlowEvents.forEach(function(inflow){if(fromOtherInputs)return;if(inflow.category.indexOf('input')>-1){if(flowEvents.indexOf(inflow)===-1)fromOtherInputs=true;}},this);},this);return fromOtherInputs;},triggerOtherInputs:function(event,flowEvents){if(event.outFlowEvents===undefined||event.outFlowEvents.length===0)return false;var flow=event.outFlowEvents[0];if(flow.category!==POSTTASK_FLOW_EVENT||!flow.endSlice)return false;var endSlice=flow.endSlice;if(this.belongToOtherInputs(endSlice.mostTopLevelSlice,flowEvents))return true;return false;},followSubsequentSlices:function(event,queue,visited,flowEvents){var stopFollowing=false;var inputAck=false;event.iterateAllSubsequentSlices(function(slice){if(stopFollowing)return;if(slice.title==='TaskQueueManager::RunTask')return;if(slice.title==='ThreadProxy::ScheduledActionSendBeginMainFrame')return;if(slice.title==='Scheduler::ScheduleBeginImplFrameDeadline'){if(this.triggerOtherInputs(slice,flowEvents))return;}if(slice.title==='CompositorImpl::PostComposite'){if(this.triggerOtherInputs(slice,flowEvents))return;}if(slice.title==='InputRouterImpl::ProcessInputEventAck')inputAck=true;if(inputAck&&slice.title==='InputRouterImpl::FilterAndSendWebInputEvent')stopFollowing=true;this.followCurrentSlice(slice,queue,visited);},this);},followCurrentSlice:function(event,queue,visited){event.outFlowEvents.forEach(function(outflow){if((outflow.category===POSTTASK_FLOW_EVENT||outflow.category===IPC_FLOW_EVENT)&&outflow.endSlice){this.associatedEvents_.push(outflow);var nextEvent=outflow.endSlice.mostTopLevelSlice;if(!visited.contains(nextEvent)){visited.push(nextEvent);queue.push(nextEvent);}}},this);},backtraceFromDraw:function(beginImplFrame,visited){var pendingEventQueue=[];pendingEventQueue.push(beginImplFrame.mostTopLevelSlice);while(pendingEventQueue.length!==0){var event=pendingEventQueue.pop();this.addEntireSliceHierarchy(event);event.inFlowEvents.forEach(function(inflow){if(inflow.category===POSTTASK_FLOW_EVENT&&inflow.startSlice){var nextEvent=inflow.startSlice.mostTopLevelSlice;if(!visited.contains(nextEvent)){visited.push(nextEvent);pendingEventQueue.push(nextEvent);}}},this);}},sortRasterizerSlices:function(rasterWorkerThreads,sortedRasterizerSlices){rasterWorkerThreads.forEach(function(rasterizer){Array.prototype.push.apply(sortedRasterizerSlices,rasterizer.sliceGroup.slices);},this);sortedRasterizerSlices.sort(function(a,b){if(a.start!==b.start)return a.start-b.start;return a.guid-b.guid;});},addRasterizationEvents:function(prepareTiles,rendererHelper,visited,flowEvents,sortedRasterizerSlices){if(!prepareTiles.args.prepare_tiles_id)return;if(!rendererHelper||!rendererHelper.rasterWorkerThreads)return;var rasterWorkerThreads=rendererHelper.rasterWorkerThreads;var prepareTileId=prepareTiles.args.prepare_tiles_id;var pendingEventQueue=[];if(sortedRasterizerSlices.length===0)this.sortRasterizerSlices(rasterWorkerThreads,sortedRasterizerSlices);var numFinishedTasks=0;var RASTER_TASK_TITLE='RasterizerTaskImpl::RunOnWorkerThread';var IMAGEDECODE_TASK_TITLE='ImageDecodeTaskImpl::RunOnWorkerThread';var FINISHED_TASK_TITLE='TaskSetFinishedTaskImpl::RunOnWorkerThread';for(var i=0;i<sortedRasterizerSlices.length;i++){var task=sortedRasterizerSlices[i];if(task.title===RASTER_TASK_TITLE||task.title===IMAGEDECODE_TASK_TITLE){if(task.args.source_prepare_tiles_id===prepareTileId)this.addEntireSliceHierarchy(task.mostTopLevelSlice);}else if(task.title===FINISHED_TASK_TITLE){if(task.start>prepareTiles.start){pendingEventQueue.push(task.mostTopLevelSlice);if(++numFinishedTasks===3)break;}}}while(pendingEventQueue.length!=0){var event=pendingEventQueue.pop();this.addEntireSliceHierarchy(event);this.followSubsequentSlices(event,pendingEventQueue,visited,flowEvents);}},addOtherCausallyRelatedEvents:function(rendererHelper,sourceSlices,flowEvents,sortedRasterizerSlices){var pendingEventQueue=[];var visitedEvents=new EventSet();var beginImplFrame=undefined;var prepareTiles=undefined;var sortedRasterizerSlices=[];sourceSlices.forEach(function(sourceSlice){if(!visitedEvents.contains(sourceSlice)){visitedEvents.push(sourceSlice);pendingEventQueue.push(sourceSlice);}},this);while(pendingEventQueue.length!=0){var event=pendingEventQueue.pop();this.addEntireSliceHierarchy(event);this.followCurrentSlice(event,pendingEventQueue,visitedEvents);this.followSubsequentSlices(event,pendingEventQueue,visitedEvents,flowEvents);var COMPOSITOR_PREPARE_TILES='TileManager::PrepareTiles';prepareTiles=event.findDescendentSlice(COMPOSITOR_PREPARE_TILES);if(prepareTiles)this.addRasterizationEvents(prepareTiles,rendererHelper,visitedEvents,flowEvents,sortedRasterizerSlices);var COMPOSITOR_ON_BIFD='Scheduler::OnBeginImplFrameDeadline';beginImplFrame=event.findDescendentSlice(COMPOSITOR_ON_BIFD);if(beginImplFrame)this.backtraceFromDraw(beginImplFrame,visitedEvents);}var INPUT_GSU='InputLatency::GestureScrollUpdate';if(this.title===INPUT_GSU)this.addScrollUpdateEvents(rendererHelper);},get associatedEvents(){if(this.associatedEvents_.length!==0)return this.associatedEvents_;var modelIndices=this.startThread.parent.model.modelIndices;var flowEvents=modelIndices.getFlowEventsWithId(this.id);if(flowEvents.length===0)return this.associatedEvents_;var sourceSlices=this.addDirectlyAssociatedEvents(flowEvents);var rendererHelper=this.getRendererHelper(sourceSlices);this.addOtherCausallyRelatedEvents(rendererHelper,sourceSlices,flowEvents);return this.associatedEvents_;},get inputLatency(){if(!('data'in this.args))return undefined;var data=this.args.data;if(!(END_COMP_NAME in data))return undefined;var latency=0;var endTime=data[END_COMP_NAME].time;if(ORIGINAL_COMP_NAME in data){latency=endTime-data[ORIGINAL_COMP_NAME].time;}else if(UI_COMP_NAME in data){latency=endTime-data[UI_COMP_NAME].time;}else if(BEGIN_COMP_NAME in data){latency=endTime-data[BEGIN_COMP_NAME].time;}else{throw new Error('No valid begin latency component');}return latency;}};var eventTypeNames=['Char','ContextMenu','GestureClick','GestureFlingCancel','GestureFlingStart','GestureScrollBegin','GestureScrollEnd','GestureScrollUpdate','GestureShowPress','GestureTap','GestureTapCancel','GestureTapDown','GesturePinchBegin','GesturePinchEnd','GesturePinchUpdate','KeyDown','KeyUp','MouseDown','MouseEnter','MouseLeave','MouseMove','MouseUp','MouseWheel','RawKeyDown','ScrollUpdate','TouchCancel','TouchEnd','TouchMove','TouchStart'];var allTypeNames=['InputLatency'];eventTypeNames.forEach(function(eventTypeName){allTypeNames.push('InputLatency:'+eventTypeName);allTypeNames.push('InputLatency::'+eventTypeName);});AsyncSlice.subTypes.register(InputLatencyAsyncSlice,{typeNames:allTypeNames,categoryParts:['latencyInfo']});return{InputLatencyAsyncSlice:InputLatencyAsyncSlice,INPUT_EVENT_TYPE_NAMES:INPUT_EVENT_TYPE_NAMES};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../../model/async_slice.js":109,"../../../model/event_set.js":126,"../../../model/helpers/chrome_model_helper.js":133}],69:[function(require,module,exports){(function(global){"use strict";require("../../base/event.js");require("../../base/iteration_helpers.js");require("../../base/sinebow_color_generator.js");'use strict';global.tr.exportTo('tr.e.chrome',function(){var SAME_AS_PARENT='same-as-parent';var TITLES_FOR_USER_FRIENDLY_CATEGORY={composite:['CompositingInputsUpdater::update','ThreadProxy::SetNeedsUpdateLayers','LayerTreeHost::UpdateLayers::CalcDrawProps','UpdateLayerTree'],gc:['minorGC','majorGC','MajorGC','MinorGC','V8.GCScavenger','V8.GCIncrementalMarking','V8.GCIdleNotification','V8.GCContext','V8.GCCompactor','V8GCController::traceDOMWrappers'],iframe_creation:['WebLocalFrameImpl::createChildframe'],imageDecode:['Decode Image','ImageFrameGenerator::decode','ImageFrameGenerator::decodeAndScale'],input:['HitTest','ScrollableArea::scrollPositionChanged','EventHandler::handleMouseMoveEvent'],layout:['FrameView::invalidateTree','FrameView::layout','FrameView::performLayout','FrameView::performPostLayoutTasks','FrameView::performPreLayoutTasks','Layer::updateLayerPositionsAfterLayout','Layout','LayoutView::hitTest','ResourceLoadPriorityOptimizer::updateAllImageResourcePriorities','WebViewImpl::layout'],parseHTML:['ParseHTML','HTMLDocumentParser::didReceiveParsedChunkFromBackgroundParser','HTMLDocumentParser::processParsedChunkFromBackgroundParser'],raster:['DisplayListRasterSource::PerformSolidColorAnalysis','Picture::Raster','RasterBufferImpl::Playback','RasterTask','RasterizerTaskImpl::RunOnWorkerThread','SkCanvas::drawImageRect()','SkCanvas::drawPicture()','SkCanvas::drawTextBlob()','TileTaskWorkerPool::PlaybackToMemory'],record:['ContentLayerDelegate::paintContents','DeprecatedPaintLayerCompositor::updateIfNeededRecursive','DeprecatedPaintLayerCompositor::updateLayerPositionsAfterLayout','Paint','Picture::Record','PictureLayer::Update','RenderLayer::updateLayerPositionsAfterLayout'],style:['CSSParserImpl::parseStyleSheet.parse','CSSParserImpl::parseStyleSheet.tokenize','Document::updateStyle','Document::updateStyleInvalidationIfNeeded','ParseAuthorStyleSheet','RuleSet::addRulesFromSheet','StyleElement::processStyleSheet','StyleEngine::createResolver','StyleSheetContents::parseAuthorStyleSheet','UpdateLayoutTree'],script_parse_and_compile:['v8.parseOnBackground','V8.ScriptCompiler'],script_execute:['V8.Execute','WindowProxy::initialize'],resource_loading:['ResourceFetcher::requestResource','ResourceDispatcher::OnReceivedData','ResourceDispatcher::OnRequestComplete','ResourceDispatcher::OnReceivedResponse','Resource::appendData'],renderer_misc:['DecodeFont','ThreadState::completeSweep'],v8_runtime:[],[SAME_AS_PARENT]:['SyncChannel::Send']};var COLOR_FOR_USER_FRIENDLY_CATEGORY=new tr.b.SinebowColorGenerator();var USER_FRIENDLY_CATEGORY_FOR_TITLE=new Map();for(var category in TITLES_FOR_USER_FRIENDLY_CATEGORY){TITLES_FOR_USER_FRIENDLY_CATEGORY[category].forEach(function(title){USER_FRIENDLY_CATEGORY_FOR_TITLE.set(title,category);});}var USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY={netlog:'net',overhead:'overhead',startup:'startup',gpu:'gpu'};function ChromeUserFriendlyCategoryDriver(){}ChromeUserFriendlyCategoryDriver.fromEvent=function(event){var userFriendlyCategory=USER_FRIENDLY_CATEGORY_FOR_TITLE.get(event.title);if(userFriendlyCategory){if(userFriendlyCategory==SAME_AS_PARENT){if(event.parentSlice)return ChromeUserFriendlyCategoryDriver.fromEvent(event.parentSlice);}else{return userFriendlyCategory;}}var eventCategoryParts=tr.b.getCategoryParts(event.category);for(var i=0;i<eventCategoryParts.length;++i){var eventCategory=eventCategoryParts[i];userFriendlyCategory=USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY[eventCategory];if(userFriendlyCategory)return userFriendlyCategory;}return'other';};ChromeUserFriendlyCategoryDriver.getColor=function(ufc){return COLOR_FOR_USER_FRIENDLY_CATEGORY.colorForKey(ufc);};ChromeUserFriendlyCategoryDriver.ALL_TITLES=['other'];for(var category in TITLES_FOR_USER_FRIENDLY_CATEGORY){if(category===SAME_AS_PARENT)continue;ChromeUserFriendlyCategoryDriver.ALL_TITLES.push(category);}for(var category of tr.b.dictionaryValues(USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY)){ChromeUserFriendlyCategoryDriver.ALL_TITLES.push(category);}ChromeUserFriendlyCategoryDriver.ALL_TITLES.sort();for(var category of ChromeUserFriendlyCategoryDriver.ALL_TITLES)ChromeUserFriendlyCategoryDriver.getColor(category);return{ChromeUserFriendlyCategoryDriver:ChromeUserFriendlyCategoryDriver};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/event.js":39,"../../base/iteration_helpers.js":47,"../../base/sinebow_color_generator.js":57}],70:[function(require,module,exports){(function(global){"use strict";require("../../model/source_info/js_source_info.js");'use strict';global.tr.exportTo('tr.e.importer',function(){function TraceCodeEntry(address,size,name,scriptId){this.id_=tr.b.GUID.allocateSimple();this.address_=address;this.size_=size;var rePrefix=/^(\w*:)?([*~]?)(.*)$/m;var tokens=rePrefix.exec(name);var prefix=tokens[1];var state=tokens[2];var body=tokens[3];if(state==='*'){state=tr.model.source_info.JSSourceState.OPTIMIZED;}else if(state==='~'){state=tr.model.source_info.JSSourceState.OPTIMIZABLE;}else if(state===''){state=tr.model.source_info.JSSourceState.COMPILED;}else{console.warning('Unknown v8 code state '+state);state=tr.model.source_info.JSSourceState.UNKNOWN;}var rawName;var rawUrl;if(prefix==='Script:'){rawName='';rawUrl=body;}else{var spacePos=body.lastIndexOf(' ');rawName=spacePos!==-1?body.substr(0,spacePos):body;rawUrl=spacePos!==-1?body.substr(spacePos+1):'';}function splitLineAndColumn(url){var lineColumnRegEx=/(?::(\d+))?(?::(\d+))?$/;var lineColumnMatch=lineColumnRegEx.exec(url);var lineNumber;var columnNumber;if(typeof lineColumnMatch[1]==='string'){lineNumber=parseInt(lineColumnMatch[1],10);lineNumber=isNaN(lineNumber)?undefined:lineNumber-1;}if(typeof lineColumnMatch[2]==='string'){columnNumber=parseInt(lineColumnMatch[2],10);columnNumber=isNaN(columnNumber)?undefined:columnNumber-1;}return{url:url.substring(0,url.length-lineColumnMatch[0].length),lineNumber:lineNumber,columnNumber:columnNumber};}var nativeSuffix=' native';var isNative=rawName.endsWith(nativeSuffix);this.name_=isNative?rawName.slice(0,-nativeSuffix.length):rawName;var urlData=splitLineAndColumn(rawUrl);var url=urlData.url||'';var line=urlData.lineNumber||0;var column=urlData.columnNumber||0;this.sourceInfo_=new tr.model.source_info.JSSourceInfo(url,line,column,isNative,scriptId,state);};TraceCodeEntry.prototype={get id(){return this.id_;},get sourceInfo(){return this.sourceInfo_;},get name(){return this.name_;},set address(address){this.address_=address;},get address(){return this.address_;},set size(size){this.size_=size;},get size(){return this.size_;}};return{TraceCodeEntry:TraceCodeEntry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../model/source_info/js_source_info.js":159}],71:[function(require,module,exports){(function(global){"use strict";require("./trace_code_entry.js");'use strict';global.tr.exportTo('tr.e.importer',function(){function TraceCodeMap(){this.banks_=new Map();}TraceCodeMap.prototype={addEntry:function(addressHex,size,name,scriptId){var entry=new tr.e.importer.TraceCodeEntry(this.getAddress_(addressHex),size,name,scriptId);this.addEntry_(addressHex,entry);},moveEntry:function(oldAddressHex,newAddressHex,size){var entry=this.getBank_(oldAddressHex).removeEntry(this.getAddress_(oldAddressHex));if(!entry)return;entry.address=this.getAddress_(newAddressHex);entry.size=size;this.addEntry_(newAddressHex,entry);},lookupEntry:function(addressHex){return this.getBank_(addressHex).lookupEntry(this.getAddress_(addressHex));},addEntry_:function(addressHex,entry){this.getBank_(addressHex).addEntry(entry);},getAddress_:function(addressHex){var bankSizeHexDigits=13;addressHex=addressHex.slice(2);return parseInt(addressHex.slice(-bankSizeHexDigits),16);},getBank_:function(addressHex){addressHex=addressHex.slice(2);var bankSizeHexDigits=13;var maxHexDigits=16;var bankName=addressHex.slice(-maxHexDigits,-bankSizeHexDigits);var bank=this.banks_.get(bankName);if(!bank){bank=new TraceCodeBank();this.banks_.set(bankName,bank);}return bank;}};function TraceCodeBank(){this.entries_=[];}TraceCodeBank.prototype={removeEntry:function(address){if(this.entries_.length===0)return undefined;var index=tr.b.findLowIndexInSortedArray(this.entries_,function(entry){return entry.address;},address);var entry=this.entries_[index];if(!entry||entry.address!==address)return undefined;this.entries_.splice(index,1);return entry;},lookupEntry:function(address){var index=tr.b.findHighIndexInSortedArray(this.entries_,function(e){return address-e.address;})-1;var entry=this.entries_[index];return entry&&address<entry.address+entry.size?entry:undefined;},addEntry:function(newEntry){if(this.entries_.length===0)this.entries_.push(newEntry);var endAddress=newEntry.address+newEntry.size;var lastIndex=tr.b.findLowIndexInSortedArray(this.entries_,function(entry){return entry.address;},endAddress);var index;for(index=lastIndex-1;index>=0;--index){var entry=this.entries_[index];var entryEndAddress=entry.address+entry.size;if(entryEndAddress<=newEntry.address)break;}++index;this.entries_.splice(index,lastIndex-index,newEntry);}};return{TraceCodeMap:TraceCodeMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./trace_code_entry.js":70}],72:[function(require,module,exports){(function(global){"use strict";require("../../base/base64.js");require("../../base/color_scheme.js");require("../../base/range.js");require("../../base/unit.js");require("../../base/utils.js");require("./trace_code_entry.js");require("./trace_code_map.js");require("./v8/codemap.js");require("../../importer/context_processor.js");require("../../importer/importer.js");require("../../model/comment_box_annotation.js");require("../../model/constants.js");require("../../model/container_memory_dump.js");require("../../model/counter_series.js");require("../../model/flow_event.js");require("../../model/global_memory_dump.js");require("../../model/heap_dump.js");require("../../model/instant_event.js");require("../../model/memory_allocator_dump.js");require("../../model/model.js");require("../../model/process_memory_dump.js");require("../../model/rect_annotation.js");require("../../model/scoped_id.js");require("../../model/slice_group.js");require("../../model/vm_region.js");require("../../model/x_marker_annotation.js");require("../../value/numeric.js");'use strict';global.tr.exportTo('tr.e.importer',function(){var Base64=tr.b.Base64;var deepCopy=tr.b.deepCopy;var ColorScheme=tr.b.ColorScheme;function getEventColor(event,opt_customName){if(event.cname)return ColorScheme.getColorIdForReservedName(event.cname);else if(opt_customName||event.name){return ColorScheme.getColorIdForGeneralPurposeString(opt_customName||event.name);}}var PRODUCER='producer';var CONSUMER='consumer';var STEP='step';var BACKGROUND=tr.model.ContainerMemoryDump.LevelOfDetail.BACKGROUND;var LIGHT=tr.model.ContainerMemoryDump.LevelOfDetail.LIGHT;var DETAILED=tr.model.ContainerMemoryDump.LevelOfDetail.DETAILED;var MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER=[undefined,BACKGROUND,LIGHT,DETAILED];var GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX='global/';var ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX='ClockSyncEvent.';var BYTE_STAT_NAME_MAP={'pc':'privateCleanResident','pd':'privateDirtyResident','sc':'sharedCleanResident','sd':'sharedDirtyResident','pss':'proportionalResident','sw':'swapped'};var WEAK_MEMORY_ALLOCATOR_DUMP_FLAG=1<<0;var OBJECT_TYPE_NAME_PATTERNS=[{prefix:'const char *WTF::getStringWithTypeName() [T = ',suffix:']'},{prefix:'const char* WTF::getStringWithTypeName() [with T = ',suffix:']'},{prefix:'const char *__cdecl WTF::getStringWithTypeName<',suffix:'>(void)'}];var SUBTRACE_FIELDS=new Set(['powerTraceAsString','systemTraceEvents']);var NON_METADATA_FIELDS=new Set(['samples','stackFrames','traceAnnotations','traceEvents']);for(var subtraceField in SUBTRACE_FIELDS)NON_METADATA_FIELDS.add(subtraceField);function TraceEventImporter(model,eventData){this.importPriority=1;this.model_=model;this.events_=undefined;this.sampleEvents_=undefined;this.stackFrameEvents_=undefined;this.subtraces_=[];this.eventsWereFromString_=false;this.softwareMeasuredCpuCount_=undefined;this.allAsyncEvents_=[];this.allFlowEvents_=[];this.allObjectEvents_=[];this.contextProcessorPerThread={};this.traceEventSampleStackFramesByName_={};this.v8ProcessCodeMaps_={};this.v8ProcessRootStackFrame_={};this.v8SamplingData_=[];this.asyncClockSyncStart_=undefined;this.asyncClockSyncFinish_=undefined;this.allMemoryDumpEvents_={};this.objectTypeNameMap_={};this.clockDomainId_=tr.model.ClockDomainId.UNKNOWN_CHROME_LEGACY;this.toModelTime_=undefined;if(typeof eventData==='string'||eventData instanceof String){eventData=eventData.trim();if(eventData[0]==='['){eventData=eventData.replace(/\s*,\s*$/,'');if(eventData[eventData.length-1]!==']')eventData=eventData+']';}this.events_=JSON.parse(eventData);this.eventsWereFromString_=true;}else{this.events_=eventData;}this.traceAnnotations_=this.events_.traceAnnotations;if(this.events_.traceEvents){var container=this.events_;this.events_=this.events_.traceEvents;for(var subtraceField of SUBTRACE_FIELDS)if(container[subtraceField])this.subtraces_.push(container[subtraceField]);this.sampleEvents_=container.samples;this.stackFrameEvents_=container.stackFrames;if(container.displayTimeUnit){var unitName=container.displayTimeUnit;var unit=tr.b.TimeDisplayModes[unitName];if(unit===undefined){throw new Error('Unit '+unitName+' is not supported.');}this.model_.intrinsicTimeUnit=unit;}for(var fieldName in container){if(NON_METADATA_FIELDS.has(fieldName))continue;this.model_.metadata.push({name:fieldName,value:container[fieldName]});if(fieldName==='metadata'){var metadata=container[fieldName];if(metadata['highres-ticks'])this.model_.isTimeHighResolution=metadata['highres-ticks'];if(metadata['clock-domain'])this.clockDomainId_=metadata['clock-domain'];}}}}TraceEventImporter.canImport=function(eventData){if(typeof eventData==='string'||eventData instanceof String){eventData=eventData.trim();return eventData[0]==='{'||eventData[0]==='[';}if(eventData instanceof Array&&eventData.length&&eventData[0].ph)return true;if(eventData.traceEvents){if(eventData.traceEvents instanceof Array){if(eventData.traceEvents.length&&eventData.traceEvents[0].ph)return true;if(eventData.samples.length&&eventData.stackFrames!==undefined)return true;}}return false;};TraceEventImporter.prototype={__proto__:tr.importer.Importer.prototype,get importerName(){return'TraceEventImporter';},extractSubtraces:function(){var subtraces=this.subtraces_;this.subtraces_=[];return subtraces;},deepCopyIfNeeded_:function(obj){if(obj===undefined)obj={};if(this.eventsWereFromString_)return obj;return deepCopy(obj);},deepCopyAlways_:function(obj){if(obj===undefined)obj={};return deepCopy(obj);},processAsyncEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allAsyncEvents_.push({sequenceNumber:this.allAsyncEvents_.length,event:event,thread:thread});},processFlowEvent:function(event,opt_slice){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allFlowEvents_.push({refGuid:tr.b.GUID.getLastSimpleGuid(),sequenceNumber:this.allFlowEvents_.length,event:event,slice:opt_slice,thread:thread});},processCounterEvent:function(event){var ctrName;if(event.id!==undefined)ctrName=event.name+'['+event.id+']';else ctrName=event.name;var ctr=this.model_.getOrCreateProcess(event.pid).getOrCreateCounter(event.cat,ctrName);var reservedColorId=event.cname?getEventColor(event):undefined;if(ctr.numSeries===0){for(var seriesName in event.args){var colorId=reservedColorId||getEventColor(event,ctr.name+'.'+seriesName);ctr.addSeries(new tr.model.CounterSeries(seriesName,colorId));}if(ctr.numSeries===0){this.model_.importWarning({type:'counter_parse_error',message:'Expected counter '+event.name+' to have at least one argument to use as a value.'});delete ctr.parent.counters[ctr.name];return;}}var ts=this.toModelTimeFromUs_(event.ts);ctr.series.forEach(function(series){var val=event.args[series.name]?event.args[series.name]:0;series.addCounterSample(ts,val);});},scopedIdForEvent_:function(event){return new tr.model.ScopedId(event.scope||tr.model.OBJECT_DEFAULT_SCOPE,event.id);},processObjectEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allObjectEvents_.push({sequenceNumber:this.allObjectEvents_.length,event:event,thread:thread});if(thread.guid in this.contextProcessorPerThread){var processor=this.contextProcessorPerThread[thread.guid];var scopedId=this.scopedIdForEvent_(event);if(event.ph==='D')processor.destroyContext(scopedId);processor.invalidateContextCacheForSnapshot(scopedId);}},processContextEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);if(!(thread.guid in this.contextProcessorPerThread)){this.contextProcessorPerThread[thread.guid]=new tr.importer.ContextProcessor(this.model_);}var scopedId=this.scopedIdForEvent_(event);var contextType=event.name;var processor=this.contextProcessorPerThread[thread.guid];if(event.ph==='('){processor.enterContext(contextType,scopedId);}else if(event.ph===')'){processor.leaveContext(contextType,scopedId);}else{this.model_.importWarning({type:'unknown_context_phase',message:'Unknown context event phase: '+event.ph+'.'});}},setContextsFromThread_:function(thread,slice){if(thread.guid in this.contextProcessorPerThread){slice.contexts=this.contextProcessorPerThread[thread.guid].activeContexts;}},processDurationEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var ts=this.toModelTimeFromUs_(event.ts);if(!thread.sliceGroup.isTimestampValidForBeginOrEnd(ts)){this.model_.importWarning({type:'duration_parse_error',message:'Timestamps are moving backward.'});return;}if(event.ph==='B'){var slice=thread.sliceGroup.beginSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args),this.toModelTimeFromUs_(event.tts),event.argsStripped,getEventColor(event));slice.startStackFrame=this.getStackFrameForEvent_(event);this.setContextsFromThread_(thread,slice);}else if(event.ph==='I'||event.ph==='i'||event.ph==='R'){if(event.s!==undefined&&event.s!=='t')throw new Error('This should never happen');thread.sliceGroup.beginSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args),this.toModelTimeFromUs_(event.tts),event.argsStripped,getEventColor(event));var slice=thread.sliceGroup.endSlice(this.toModelTimeFromUs_(event.ts),this.toModelTimeFromUs_(event.tts));slice.startStackFrame=this.getStackFrameForEvent_(event);slice.endStackFrame=undefined;}else{if(!thread.sliceGroup.openSliceCount){this.model_.importWarning({type:'duration_parse_error',message:'E phase event without a matching B phase event.'});return;}var slice=thread.sliceGroup.endSlice(this.toModelTimeFromUs_(event.ts),this.toModelTimeFromUs_(event.tts),getEventColor(event));if(event.name&&slice.title!=event.name){this.model_.importWarning({type:'title_match_error',message:'Titles do not match. Title is '+slice.title+' in openSlice, and is '+event.name+' in endSlice'});}slice.endStackFrame=this.getStackFrameForEvent_(event);this.mergeArgsInto_(slice.args,event.args,slice.title);}},mergeArgsInto_:function(dstArgs,srcArgs,eventName){for(var arg in srcArgs){if(dstArgs[arg]!==undefined){this.model_.importWarning({type:'arg_merge_error',message:'Different phases of '+eventName+' provided values for argument '+arg+'.'+' The last provided value will be used.'});}dstArgs[arg]=this.deepCopyIfNeeded_(srcArgs[arg]);}},processCompleteEvent:function(event){if(event.cat!==undefined&&event.cat.indexOf('trace_event_overhead')>-1)return undefined;var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);if(event.flow_out){if(event.flow_in)event.flowPhase=STEP;else event.flowPhase=PRODUCER;}else if(event.flow_in){event.flowPhase=CONSUMER;}var slice=thread.sliceGroup.pushCompleteSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.maybeToModelTimeFromUs_(event.dur),this.maybeToModelTimeFromUs_(event.tts),this.maybeToModelTimeFromUs_(event.tdur),this.deepCopyIfNeeded_(event.args),event.argsStripped,getEventColor(event),event.bind_id);slice.startStackFrame=this.getStackFrameForEvent_(event);slice.endStackFrame=this.getStackFrameForEvent_(event,true);this.setContextsFromThread_(thread,slice);return slice;},processJitCodeEvent:function(event){if(this.v8ProcessCodeMaps_[event.pid]===undefined)this.v8ProcessCodeMaps_[event.pid]=new tr.e.importer.TraceCodeMap();var map=this.v8ProcessCodeMaps_[event.pid];var data=event.args.data;if(event.name==='JitCodeMoved')map.moveEntry(data.code_start,data.new_code_start,data.code_len);else map.addEntry(data.code_start,data.code_len,data.name,data.script_id);},processMetadataEvent:function(event){if(event.name==='JitCodeAdded'||event.name==='JitCodeMoved'){this.v8SamplingData_.push(event);return;}if(event.argsStripped)return;if(event.name==='process_name'){var process=this.model_.getOrCreateProcess(event.pid);process.name=event.args.name;}else if(event.name==='process_labels'){var process=this.model_.getOrCreateProcess(event.pid);var labels=event.args.labels.split(',');for(var i=0;i<labels.length;i++)process.addLabelIfNeeded(labels[i]);}else if(event.name==='process_sort_index'){var process=this.model_.getOrCreateProcess(event.pid);process.sortIndex=event.args.sort_index;}else if(event.name==='thread_name'){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);thread.name=event.args.name;}else if(event.name==='thread_sort_index'){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);thread.sortIndex=event.args.sort_index;}else if(event.name==='num_cpus'){var n=event.args.number;if(this.softwareMeasuredCpuCount_!==undefined)n=Math.max(n,this.softwareMeasuredCpuCount_);this.softwareMeasuredCpuCount_=n;}else if(event.name==='stackFrames'){var stackFrames=event.args.stackFrames;if(stackFrames===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'No stack frames found in a \''+event.name+'\' metadata event'});}else{this.importStackFrames_(stackFrames,'p'+event.pid+':');}}else if(event.name==='typeNames'){var objectTypeNameMap=event.args.typeNames;if(objectTypeNameMap===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'No mapping from object type IDs to names found in a \''+event.name+'\' metadata event'});}else{this.importObjectTypeNameMap_(objectTypeNameMap,event.pid);}}else if(event.name==='TraceConfig'){this.model_.metadata.push({name:'TraceConfig',value:event.args.value});}else{this.model_.importWarning({type:'metadata_parse_error',message:'Unrecognized metadata name: '+event.name});}},processInstantEvent:function(event){if(event.name==='JitCodeAdded'||event.name==='JitCodeMoved'){this.v8SamplingData_.push(event);return;}if(event.s==='t'||event.s===undefined){this.processDurationEvent(event);return;}var constructor;switch(event.s){case'g':constructor=tr.model.GlobalInstantEvent;break;case'p':constructor=tr.model.ProcessInstantEvent;break;default:this.model_.importWarning({type:'instant_parse_error',message:'I phase event with unknown "s" field value.'});return;}var instantEvent=new constructor(event.cat,event.name,getEventColor(event),this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args));switch(instantEvent.type){case tr.model.InstantEventType.GLOBAL:this.model_.instantEvents.push(instantEvent);break;case tr.model.InstantEventType.PROCESS:var process=this.model_.getOrCreateProcess(event.pid);process.instantEvents.push(instantEvent);break;default:throw new Error('Unknown instant event type: '+event.s);}},processV8Sample:function(event){var data=event.args.data;if(data.vm_state==='js'&&!data.stack.length)return;var rootStackFrame=this.v8ProcessRootStackFrame_[event.pid];if(!rootStackFrame){rootStackFrame=new tr.model.StackFrame(undefined,'v8-root-stack-frame','v8-root-stack-frame',0);this.v8ProcessRootStackFrame_[event.pid]=rootStackFrame;}function findChildWithEntryID(stackFrame,entryID){return tr.b.findFirstInArray(stackFrame.children,function(child){return child.entryID===entryID;});}var model=this.model_;function addStackFrame(lastStackFrame,entry){var childFrame=findChildWithEntryID(lastStackFrame,entry.id);if(childFrame)return childFrame;var frame=new tr.model.StackFrame(lastStackFrame,tr.b.GUID.allocateSimple(),entry.name,ColorScheme.getColorIdForGeneralPurposeString(entry.name),entry.sourceInfo);frame.entryID=entry.id;model.addStackFrame(frame);return frame;}var lastStackFrame=rootStackFrame;if(data.stack.length>0&&this.v8ProcessCodeMaps_[event.pid]){var map=this.v8ProcessCodeMaps_[event.pid];data.stack.reverse();for(var i=0;i<data.stack.length;i++){var entry=map.lookupEntry(data.stack[i]);if(entry===undefined){entry={id:'unknown',name:'unknown',sourceInfo:undefined};}lastStackFrame=addStackFrame(lastStackFrame,entry);}}else{var entry={id:data.vm_state,name:data.vm_state,sourceInfo:undefined};lastStackFrame=addStackFrame(lastStackFrame,entry);}var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var sample=new tr.model.Sample(undefined,thread,'V8 Sample',this.toModelTimeFromUs_(event.ts),lastStackFrame,1,this.deepCopyIfNeeded_(event.args));this.model_.samples.push(sample);},processTraceSampleEvent:function(event){if(event.name==='V8Sample'){this.v8SamplingData_.push(event);return;}var stackFrame=this.getStackFrameForEvent_(event);if(stackFrame===undefined){stackFrame=this.traceEventSampleStackFramesByName_[event.name];}if(stackFrame===undefined){var id='te-'+tr.b.GUID.allocateSimple();stackFrame=new tr.model.StackFrame(undefined,id,event.name,ColorScheme.getColorIdForGeneralPurposeString(event.name));this.model_.addStackFrame(stackFrame);this.traceEventSampleStackFramesByName_[event.name]=stackFrame;}var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var sample=new tr.model.Sample(undefined,thread,'Trace Event Sample',this.toModelTimeFromUs_(event.ts),stackFrame,1,this.deepCopyIfNeeded_(event.args));this.setContextsFromThread_(thread,sample);this.model_.samples.push(sample);},processMemoryDumpEvent:function(event){if(event.ph!=='v')throw new Error('Invalid memory dump event phase "'+event.ph+'".');var dumpId=event.id;if(dumpId===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory dump event (phase \''+event.ph+'\') without a dump ID.'});return;}var pid=event.pid;if(pid===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory dump event (phase\''+event.ph+'\', dump ID \''+dumpId+'\') without a PID.'});return;}var allEvents=this.allMemoryDumpEvents_;var dumpIdEvents=allEvents[dumpId];if(dumpIdEvents===undefined)allEvents[dumpId]=dumpIdEvents={};var processEvents=dumpIdEvents[pid];if(processEvents===undefined)dumpIdEvents[pid]=processEvents=[];processEvents.push(event);},processClockSyncEvent:function(event){if(event.ph!=='c')throw new Error('Invalid clock sync event phase "'+event.ph+'".');var syncId=event.args.sync_id;if(syncId===undefined){this.model_.importWarning({type:'clock_sync_parse_error',message:'Clock sync at time '+event.ts+' without an ID.'});return;}if(event.args&&event.args.issue_ts!==undefined){this.model_.clockSyncManager.addClockSyncMarker(this.clockDomainId_,syncId,tr.b.Unit.timestampFromUs(event.args.issue_ts),tr.b.Unit.timestampFromUs(event.ts));}else{this.model_.clockSyncManager.addClockSyncMarker(this.clockDomainId_,syncId,tr.b.Unit.timestampFromUs(event.ts));}},processV8Events:function(){this.v8SamplingData_.sort(function(a,b){if(a.ts!==b.ts)return a.ts-b.ts;if(a.ph==='M'||a.ph==='I')return-1;else if(b.ph==='M'||b.ph==='I')return 1;return 0;});var length=this.v8SamplingData_.length;for(var i=0;i<length;++i){var event=this.v8SamplingData_[i];if(event.ph==='M'||event.ph==='I'){this.processJitCodeEvent(event);}else if(event.ph==='P'){this.processV8Sample(event);}}},initBackcompatClockSyncEventTracker_:function(event){if(event.name!==undefined&&event.name.startsWith(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX)&&event.ph==='S')this.asyncClockSyncStart_=event;if(event.name!==undefined&&event.name.startsWith(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX)&&event.ph==='F')this.asyncClockSyncFinish_=event;if(this.asyncClockSyncStart_==undefined||this.asyncClockSyncFinish_==undefined)return;var syncId=this.asyncClockSyncStart_.name.substring(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX.length);if(syncId!==this.asyncClockSyncFinish_.name.substring(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX.length)){throw new Error('Inconsistent clock sync id of async clock sync '+'events.');}var clockSyncEvent={ph:'c',args:{sync_id:syncId,issue_ts:this.asyncClockSyncStart_.ts},ts:this.asyncClockSyncFinish_.ts};this.asyncClockSyncStart_=undefined;this.asyncClockSyncFinish_=undefined;return clockSyncEvent;},importClockSyncMarkers:function(){var asyncClockSyncStart,asyncClockSyncFinish;for(var i=0;i<this.events_.length;i++){var event=this.events_[i];var possibleBackCompatClockSyncEvent=this.initBackcompatClockSyncEventTracker_(event);if(possibleBackCompatClockSyncEvent)this.processClockSyncEvent(possibleBackCompatClockSyncEvent);if(event.ph!=='c')continue;var eventSizeInBytes=this.model_.importOptions.trackDetailedModelStats?JSON.stringify(event).length:undefined;this.model_.stats.willProcessBasicTraceEvent('clock_sync',event.cat,event.name,event.ts,eventSizeInBytes);this.processClockSyncEvent(event);}},importEvents:function(){if(this.stackFrameEvents_)this.importStackFrames_(this.stackFrameEvents_,'g');if(this.traceAnnotations_)this.importAnnotations_();var importOptions=this.model_.importOptions;var trackDetailedModelStats=importOptions.trackDetailedModelStats;var modelStats=this.model_.stats;var events=this.events_;for(var eI=0;eI<events.length;eI++){var event=events[eI];if(event.args==='__stripped__'){event.argsStripped=true;event.args=undefined;}var eventSizeInBytes;if(trackDetailedModelStats)eventSizeInBytes=JSON.stringify(event).length;else eventSizeInBytes=undefined;if(event.ph==='B'||event.ph==='E'){modelStats.willProcessBasicTraceEvent('begin_end (non-compact)',event.cat,event.name,event.ts,eventSizeInBytes);this.processDurationEvent(event);}else if(event.ph==='X'){modelStats.willProcessBasicTraceEvent('begin_end (compact)',event.cat,event.name,event.ts,eventSizeInBytes);var slice=this.processCompleteEvent(event);if(slice!==undefined&&event.bind_id!==undefined)this.processFlowEvent(event,slice);}else if(event.ph==='b'||event.ph==='e'||event.ph==='n'||event.ph==='S'||event.ph==='F'||event.ph==='T'||event.ph==='p'){modelStats.willProcessBasicTraceEvent('async',event.cat,event.name,event.ts,eventSizeInBytes);this.processAsyncEvent(event);}else if(event.ph==='I'||event.ph==='i'||event.ph==='R'){modelStats.willProcessBasicTraceEvent('instant',event.cat,event.name,event.ts,eventSizeInBytes);this.processInstantEvent(event);}else if(event.ph==='P'){modelStats.willProcessBasicTraceEvent('samples',event.cat,event.name,event.ts,eventSizeInBytes);this.processTraceSampleEvent(event);}else if(event.ph==='C'){modelStats.willProcessBasicTraceEvent('counters',event.cat,event.name,event.ts,eventSizeInBytes);this.processCounterEvent(event);}else if(event.ph==='M'){modelStats.willProcessBasicTraceEvent('metadata',event.cat,event.name,event.ts,eventSizeInBytes);this.processMetadataEvent(event);}else if(event.ph==='N'||event.ph==='D'||event.ph==='O'){modelStats.willProcessBasicTraceEvent('objects',event.cat,event.name,event.ts,eventSizeInBytes);this.processObjectEvent(event);}else if(event.ph==='s'||event.ph==='t'||event.ph==='f'){modelStats.willProcessBasicTraceEvent('flows',event.cat,event.name,event.ts,eventSizeInBytes);this.processFlowEvent(event);}else if(event.ph==='v'){modelStats.willProcessBasicTraceEvent('memory_dumps',event.cat,event.name,event.ts,eventSizeInBytes);this.processMemoryDumpEvent(event);}else if(event.ph==='('||event.ph===')'){this.processContextEvent(event);}else if(event.ph==='c'){}else{modelStats.willProcessBasicTraceEvent('unknown',event.cat,event.name,event.ts,eventSizeInBytes);this.model_.importWarning({type:'parse_error',message:'Unrecognized event phase: '+event.ph+' ('+event.name+')'});}}this.processV8Events();tr.b.iterItems(this.v8ProcessRootStackFrame_,function(name,frame){frame.removeAllChildren();});},importStackFrames_:function(rawStackFrames,idPrefix){var model=this.model_;for(var id in rawStackFrames){var rawStackFrame=rawStackFrames[id];var fullId=idPrefix+id;var textForColor=rawStackFrame.category?rawStackFrame.category:rawStackFrame.name;var stackFrame=new tr.model.StackFrame(undefined,fullId,rawStackFrame.name,ColorScheme.getColorIdForGeneralPurposeString(textForColor));model.addStackFrame(stackFrame);}for(var id in rawStackFrames){var fullId=idPrefix+id;var stackFrame=model.stackFrames[fullId];if(stackFrame===undefined)throw new Error('Internal error');var rawStackFrame=rawStackFrames[id];var parentId=rawStackFrame.parent;var parentStackFrame;if(parentId===undefined){parentStackFrame=undefined;}else{var parentFullId=idPrefix+parentId;parentStackFrame=model.stackFrames[parentFullId];if(parentStackFrame===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'Missing parent frame with ID '+parentFullId+' for stack frame \''+stackFrame.name+'\' (ID '+fullId+').'});}}stackFrame.parentFrame=parentStackFrame;}},importObjectTypeNameMap_:function(rawObjectTypeNameMap,pid){if(pid in this.objectTypeNameMap_){this.model_.importWarning({type:'metadata_parse_error',message:'Mapping from object type IDs to names provided for pid='+pid+' multiple times.'});return;}var objectTypeNamePrefix=undefined;var objectTypeNameSuffix=undefined;var objectTypeNameMap={};for(var objectTypeId in rawObjectTypeNameMap){var rawObjectTypeName=rawObjectTypeNameMap[objectTypeId];if(objectTypeNamePrefix===undefined){for(var i=0;i<OBJECT_TYPE_NAME_PATTERNS.length;i++){var pattern=OBJECT_TYPE_NAME_PATTERNS[i];if(rawObjectTypeName.startsWith(pattern.prefix)&&rawObjectTypeName.endsWith(pattern.suffix)){objectTypeNamePrefix=pattern.prefix;objectTypeNameSuffix=pattern.suffix;break;}}}if(objectTypeNamePrefix!==undefined&&rawObjectTypeName.startsWith(objectTypeNamePrefix)&&rawObjectTypeName.endsWith(objectTypeNameSuffix)){objectTypeNameMap[objectTypeId]=rawObjectTypeName.substring(objectTypeNamePrefix.length,rawObjectTypeName.length-objectTypeNameSuffix.length);}else{objectTypeNameMap[objectTypeId]=rawObjectTypeName;}}this.objectTypeNameMap_[pid]=objectTypeNameMap;},importAnnotations_:function(){for(var id in this.traceAnnotations_){var annotation=tr.model.Annotation.fromDictIfPossible(this.traceAnnotations_[id]);if(!annotation){this.model_.importWarning({type:'annotation_warning',message:'Unrecognized traceAnnotation typeName \"'+this.traceAnnotations_[id].typeName+'\"'});continue;}this.model_.addAnnotation(annotation);}},finalizeImport:function(){if(this.softwareMeasuredCpuCount_!==undefined){this.model_.kernel.softwareMeasuredCpuCount=this.softwareMeasuredCpuCount_;}this.createAsyncSlices_();this.createFlowSlices_();this.createExplicitObjects_();this.createImplicitObjects_();this.createMemoryDumps_();},getStackFrameForEvent_:function(event,opt_lookForEndEvent){var sf;var stack;if(opt_lookForEndEvent){sf=event.esf;stack=event.estack;}else{sf=event.sf;stack=event.stack;}if(stack!==undefined&&sf!==undefined){this.model_.importWarning({type:'stack_frame_and_stack_error',message:'Event at '+event.ts+' cannot have both a stack and a stackframe.'});return undefined;}if(stack!==undefined)return this.model_.resolveStackToStackFrame_(event.pid,stack);if(sf===undefined)return undefined;var stackFrame=this.model_.stackFrames['g'+sf];if(stackFrame===undefined){this.model_.importWarning({type:'sample_import_error',message:'No frame for '+sf});return;}return stackFrame;},resolveStackToStackFrame_:function(pid,stack){return undefined;},importSampleData:function(){if(!this.sampleEvents_)return;var m=this.model_;var events=this.sampleEvents_;if(this.events_.length===0){for(var i=0;i<events.length;i++){var event=events[i];m.getOrCreateProcess(event.tid).getOrCreateThread(event.tid);}}var threadsByTid={};m.getAllThreads().forEach(function(t){threadsByTid[t.tid]=t;});for(var i=0;i<events.length;i++){var event=events[i];var thread=threadsByTid[event.tid];if(thread===undefined){m.importWarning({type:'sample_import_error',message:'Thread '+events.tid+'not found'});continue;}var cpu;if(event.cpu!==undefined)cpu=m.kernel.getOrCreateCpu(event.cpu);var stackFrame=this.getStackFrameForEvent_(event);var sample=new tr.model.Sample(cpu,thread,event.name,this.toModelTimeFromUs_(event.ts),stackFrame,event.weight);m.samples.push(sample);}},createAsyncSlices_:function(){if(this.allAsyncEvents_.length===0)return;this.allAsyncEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!==0)return d;return x.sequenceNumber-y.sequenceNumber;});var legacyEvents=[];var nestableAsyncEventsByKey={};var nestableMeasureAsyncEventsByKey={};for(var i=0;i<this.allAsyncEvents_.length;i++){var asyncEventState=this.allAsyncEvents_[i];var event=asyncEventState.event;if(event.ph==='S'||event.ph==='F'||event.ph==='T'||event.ph==='p'){legacyEvents.push(asyncEventState);continue;}if(event.cat===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require a '+'cat parameter.'});continue;}if(event.name===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require a '+'name parameter.'});continue;}if(event.id===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require an '+'id parameter.'});continue;}if(event.cat==='blink.user_timing'){var matched=/([^\/:]+):([^\/:]+)\/?(.*)/.exec(event.name);if(matched!==null){var key=matched[1]+':'+event.cat;event.args=JSON.parse(Base64.atob(matched[3])||'{}');if(nestableMeasureAsyncEventsByKey[key]===undefined)nestableMeasureAsyncEventsByKey[key]=[];nestableMeasureAsyncEventsByKey[key].push(asyncEventState);continue;}}var key=event.cat+':'+event.id;if(nestableAsyncEventsByKey[key]===undefined)nestableAsyncEventsByKey[key]=[];nestableAsyncEventsByKey[key].push(asyncEventState);}this.createLegacyAsyncSlices_(legacyEvents);this.createNestableAsyncSlices_(nestableMeasureAsyncEventsByKey);this.createNestableAsyncSlices_(nestableAsyncEventsByKey);},createLegacyAsyncSlices_:function(legacyEvents){if(legacyEvents.length===0)return;legacyEvents.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var asyncEventStatesByNameThenID={};for(var i=0;i<legacyEvents.length;i++){var asyncEventState=legacyEvents[i];var event=asyncEventState.event;var name=event.name;if(name===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Async events (ph: S, T, p, or F) require a name '+' parameter.'});continue;}var id=event.id;if(id===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Async events (ph: S, T, p, or F) require an id parameter.'});continue;}if(event.ph==='S'){if(asyncEventStatesByNameThenID[name]===undefined)asyncEventStatesByNameThenID[name]={};if(asyncEventStatesByNameThenID[name][id]){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', a slice of the same id '+id+' was alrady open.'});continue;}asyncEventStatesByNameThenID[name][id]=[];asyncEventStatesByNameThenID[name][id].push(asyncEventState);}else{if(asyncEventStatesByNameThenID[name]===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', no slice named '+name+' was open.'});continue;}if(asyncEventStatesByNameThenID[name][id]===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', no slice named '+name+' with id='+id+' was open.'});continue;}var events=asyncEventStatesByNameThenID[name][id];events.push(asyncEventState);if(event.ph==='F'){var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(events[0].event.cat,name);var slice=new asyncSliceConstructor(events[0].event.cat,name,getEventColor(events[0].event),this.toModelTimeFromUs_(events[0].event.ts),tr.b.concatenateObjects(events[0].event.args,events[events.length-1].event.args),this.toModelTimeFromUs_(event.ts-events[0].event.ts),true,undefined,undefined,events[0].event.argsStripped);slice.startThread=events[0].thread;slice.endThread=asyncEventState.thread;slice.id=id;var stepType=events[1].event.ph;var isValid=true;for(var j=1;j<events.length-1;++j){if(events[j].event.ph==='T'||events[j].event.ph==='p'){isValid=this.assertStepTypeMatches_(stepType,events[j]);if(!isValid)break;}if(events[j].event.ph==='S'){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had a step before the start event.'});continue;}if(events[j].event.ph==='F'){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had a step after the finish event.'});continue;}var startIndex=j+(stepType==='T'?0:-1);var endIndex=startIndex+1;var subName=events[j].event.name;if(!events[j].event.argsStripped&&(events[j].event.ph==='T'||events[j].event.ph==='p'))subName=subName+':'+events[j].event.args.step;var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(events[0].event.cat,subName);var subSlice=new asyncSliceConstructor(events[0].event.cat,subName,getEventColor(event,subName+j),this.toModelTimeFromUs_(events[startIndex].event.ts),this.deepCopyIfNeeded_(events[j].event.args),this.toModelTimeFromUs_(events[endIndex].event.ts-events[startIndex].event.ts),undefined,undefined,events[startIndex].event.argsStripped);subSlice.startThread=events[startIndex].thread;subSlice.endThread=events[endIndex].thread;subSlice.id=id;slice.subSlices.push(subSlice);}if(isValid){slice.startThread.asyncSliceGroup.push(slice);}delete asyncEventStatesByNameThenID[name][id];}}}},createNestableAsyncSlices_:function(nestableEventsByKey){for(var key in nestableEventsByKey){var eventStateEntries=nestableEventsByKey[key];var parentStack=[];for(var i=0;i<eventStateEntries.length;++i){var eventStateEntry=eventStateEntries[i];if(eventStateEntry.event.ph==='e'){var parentIndex=-1;for(var k=parentStack.length-1;k>=0;--k){if(parentStack[k].event.name===eventStateEntry.event.name){parentIndex=k;break;}}if(parentIndex===-1){eventStateEntry.finished=false;}else{parentStack[parentIndex].end=eventStateEntry;while(parentIndex<parentStack.length){parentStack.pop();}}}if(parentStack.length>0)eventStateEntry.parentEntry=parentStack[parentStack.length-1];if(eventStateEntry.event.ph==='b'){parentStack.push(eventStateEntry);}}var topLevelSlices=[];for(var i=0;i<eventStateEntries.length;++i){var eventStateEntry=eventStateEntries[i];if(eventStateEntry.event.ph==='e'&&eventStateEntry.finished===undefined){continue;}var startState=undefined;var endState=undefined;var sliceArgs=eventStateEntry.event.args||{};var sliceError=undefined;if(eventStateEntry.event.ph==='n'){startState=eventStateEntry;endState=eventStateEntry;}else if(eventStateEntry.event.ph==='b'){if(eventStateEntry.end===undefined){eventStateEntry.end=eventStateEntries[eventStateEntries.length-1];sliceError='Slice has no matching END. End time has been adjusted.';this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async BEGIN event at '+eventStateEntry.event.ts+' with name='+eventStateEntry.event.name+' and id='+eventStateEntry.event.id+' was unmatched.'});}else{function concatenateArguments(args1,args2){if(args1.params===undefined||args2.params===undefined)return tr.b.concatenateObjects(args1,args2);var args3={};args3.params=tr.b.concatenateObjects(args1.params,args2.params);return tr.b.concatenateObjects(args1,args2,args3);}var endArgs=eventStateEntry.end.event.args||{};sliceArgs=concatenateArguments(sliceArgs,endArgs);}startState=eventStateEntry;endState=eventStateEntry.end;}else{sliceError='Slice has no matching BEGIN. Start time has been adjusted.';this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async END event at '+eventStateEntry.event.ts+' with name='+eventStateEntry.event.name+' and id='+eventStateEntry.event.id+' was unmatched.'});startState=eventStateEntries[0];endState=eventStateEntry;}var isTopLevel=eventStateEntry.parentEntry===undefined;var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(eventStateEntry.event.cat,eventStateEntry.event.name);var threadStart=undefined;var threadDuration=undefined;if(startState.event.tts&&startState.event.use_async_tts){threadStart=this.toModelTimeFromUs_(startState.event.tts);if(endState.event.tts){var threadEnd=this.toModelTimeFromUs_(endState.event.tts);threadDuration=threadEnd-threadStart;}}var slice=new asyncSliceConstructor(eventStateEntry.event.cat,eventStateEntry.event.name,getEventColor(endState.event),this.toModelTimeFromUs_(startState.event.ts),sliceArgs,this.toModelTimeFromUs_(endState.event.ts-startState.event.ts),isTopLevel,threadStart,threadDuration,startState.event.argsStripped);slice.startThread=startState.thread;slice.endThread=endState.thread;slice.startStackFrame=this.getStackFrameForEvent_(startState.event);slice.endStackFrame=this.getStackFrameForEvent_(endState.event);slice.id=key;if(sliceError!==undefined)slice.error=sliceError;eventStateEntry.slice=slice;if(isTopLevel){topLevelSlices.push(slice);}else if(eventStateEntry.parentEntry.slice!==undefined){eventStateEntry.parentEntry.slice.subSlices.push(slice);}}for(var si=0;si<topLevelSlices.length;si++){topLevelSlices[si].startThread.asyncSliceGroup.push(topLevelSlices[si]);}}},assertStepTypeMatches_:function(stepType,event){if(stepType!=event.event.ph){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had both begin and end steps, which is not allowed.'});return false;}return true;},createFlowSlices_:function(){if(this.allFlowEvents_.length===0)return;var that=this;function validateFlowEvent(){if(event.name===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow events (ph: s, t or f) require a name parameter.'});return false;}if(event.ph==='s'||event.ph==='f'||event.ph==='t'){if(event.id===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow events (ph: s, t or f) require an id parameter.'});return false;}return true;}if(event.bind_id){if(event.flow_in===undefined&&event.flow_out===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow producer or consumer require flow_in or flow_out.'});return false;}return true;}return false;}var createFlowEvent=function(thread,event,opt_slice){var startSlice,flowId,flowStartTs;if(event.bind_id){startSlice=opt_slice;flowId=event.bind_id;flowStartTs=this.toModelTimeFromUs_(event.ts+event.dur);}else{var ts=this.toModelTimeFromUs_(event.ts);startSlice=thread.sliceGroup.findSliceAtTs(ts);if(startSlice===undefined)return undefined;flowId=event.id;flowStartTs=ts;}var flowEvent=new tr.model.FlowEvent(event.cat,flowId,event.name,getEventColor(event),flowStartTs,that.deepCopyAlways_(event.args));flowEvent.startSlice=startSlice;flowEvent.startStackFrame=that.getStackFrameForEvent_(event);flowEvent.endStackFrame=undefined;startSlice.outFlowEvents.push(flowEvent);return flowEvent;}.bind(this);var finishFlowEventWith=function(flowEvent,thread,event,refGuid,bindToParent,opt_slice){var endSlice;if(event.bind_id){endSlice=opt_slice;}else{var ts=this.toModelTimeFromUs_(event.ts);if(bindToParent){endSlice=thread.sliceGroup.findSliceAtTs(ts);}else{endSlice=thread.sliceGroup.findNextSliceAfter(ts,refGuid);}if(endSlice===undefined)return false;}endSlice.inFlowEvents.push(flowEvent);flowEvent.endSlice=endSlice;flowEvent.duration=this.toModelTimeFromUs_(event.ts)-flowEvent.start;flowEvent.endStackFrame=that.getStackFrameForEvent_(event);that.mergeArgsInto_(flowEvent.args,event.args,flowEvent.title);return true;}.bind(this);function processFlowConsumer(flowIdToEvent,sliceGuidToEvent,event,slice){var flowEvent=flowIdToEvent[event.bind_id];if(flowEvent===undefined){that.model_.importWarning({type:'flow_slice_ordering_error',message:'Flow consumer '+event.bind_id+' does not have '+'a flow producer'});return false;}else if(flowEvent.endSlice){var flowProducer=flowEvent.startSlice;flowEvent=createFlowEvent(undefined,sliceGuidToEvent[flowProducer.guid],flowProducer);}var ok=finishFlowEventWith(flowEvent,undefined,event,refGuid,undefined,slice);if(ok){that.model_.flowEvents.push(flowEvent);}else{that.model_.importWarning({type:'flow_slice_end_error',message:'Flow consumer '+event.bind_id+' does not end '+'at an actual slice, so cannot be created.'});return false;}return true;}function processFlowProducer(flowIdToEvent,flowStatus,event,slice){if(flowIdToEvent[event.bind_id]&&flowStatus[event.bind_id]){that.model_.importWarning({type:'flow_slice_start_error',message:'Flow producer '+event.bind_id+' already seen'});return false;}var flowEvent=createFlowEvent(undefined,event,slice);if(!flowEvent){that.model_.importWarning({type:'flow_slice_start_error',message:'Flow producer '+event.bind_id+' does not start'+'a flow'});return false;}flowIdToEvent[event.bind_id]=flowEvent;}this.allFlowEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var flowIdToEvent={};var sliceGuidToEvent={};var flowStatus={};for(var i=0;i<this.allFlowEvents_.length;++i){var data=this.allFlowEvents_[i];var refGuid=data.refGuid;var event=data.event;var thread=data.thread;if(!validateFlowEvent(event))continue;if(event.bind_id){var slice=data.slice;sliceGuidToEvent[slice.guid]=event;if(event.flowPhase===PRODUCER){if(!processFlowProducer(flowIdToEvent,flowStatus,event,slice))continue;flowStatus[event.bind_id]=true;}else{if(!processFlowConsumer(flowIdToEvent,sliceGuidToEvent,event,slice))continue;flowStatus[event.bind_id]=false;if(event.flowPhase===STEP){if(!processFlowProducer(flowIdToEvent,flowStatus,event,slice))continue;flowStatus[event.bind_id]=true;}}continue;}var flowEvent;if(event.ph==='s'){if(flowIdToEvent[event.id]){this.model_.importWarning({type:'flow_slice_start_error',message:'event id '+event.id+' already seen when '+'encountering start of flow event.'});continue;}flowEvent=createFlowEvent(thread,event);if(!flowEvent){this.model_.importWarning({type:'flow_slice_start_error',message:'event id '+event.id+' does not start '+'at an actual slice, so cannot be created.'});continue;}flowIdToEvent[event.id]=flowEvent;}else if(event.ph==='t'||event.ph==='f'){flowEvent=flowIdToEvent[event.id];if(flowEvent===undefined){this.model_.importWarning({type:'flow_slice_ordering_error',message:'Found flow phase '+event.ph+' for id: '+event.id+' but no flow start found.'});continue;}var bindToParent=event.ph==='t';if(event.ph==='f'){if(event.bp===undefined){if(event.cat.indexOf('input')>-1)bindToParent=true;else if(event.cat.indexOf('ipc.flow')>-1)bindToParent=true;}else{if(event.bp!=='e'){this.model_.importWarning({type:'flow_slice_bind_point_error',message:'Flow event with invalid binding point (event.bp).'});continue;}bindToParent=true;}}var ok=finishFlowEventWith(flowEvent,thread,event,refGuid,bindToParent);if(ok){that.model_.flowEvents.push(flowEvent);}else{this.model_.importWarning({type:'flow_slice_end_error',message:'event id '+event.id+' does not end '+'at an actual slice, so cannot be created.'});}flowIdToEvent[event.id]=undefined;if(ok&&event.ph==='t'){flowEvent=createFlowEvent(thread,event);flowIdToEvent[event.id]=flowEvent;}}}},createExplicitObjects_:function(){if(this.allObjectEvents_.length===0)return;var processEvent=function(objectEventState){var event=objectEventState.event;var scopedId=this.scopedIdForEvent_(event);var thread=objectEventState.thread;if(event.name===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+JSON.stringify(event)+': '+'Object events require an name parameter.'});}if(scopedId.id===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+JSON.stringify(event)+': '+'Object events require an id parameter.'});}var process=thread.parent;var ts=this.toModelTimeFromUs_(event.ts);var instance;if(event.ph==='N'){try{instance=process.objects.idWasCreated(scopedId,event.cat,event.name,ts);}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing create of '+scopedId+' at ts='+ts+': '+e});return;}}else if(event.ph==='O'){if(event.args.snapshot===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+scopedId+' at ts='+ts+': '+'Snapshots must have args: {snapshot: ...}'});return;}var snapshot;try{var args=this.deepCopyIfNeeded_(event.args.snapshot);var cat;if(args.cat){cat=args.cat;delete args.cat;}else{cat=event.cat;}var baseTypename;if(args.base_type){baseTypename=args.base_type;delete args.base_type;}else{baseTypename=undefined;}snapshot=process.objects.addSnapshot(scopedId,cat,event.name,ts,args,baseTypename);snapshot.snapshottedOnThread=thread;}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing snapshot of '+scopedId+' at ts='+ts+': '+e});return;}instance=snapshot.objectInstance;}else if(event.ph==='D'){try{process.objects.idWasDeleted(scopedId,event.cat,event.name,ts);var instanceMap=process.objects.getOrCreateInstanceMap_(scopedId);instance=instanceMap.lastInstance;}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing delete of '+scopedId+' at ts='+ts+': '+e});return;}}if(instance)instance.colorId=getEventColor(event,instance.typeName);}.bind(this);this.allObjectEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var allObjectEvents=this.allObjectEvents_;for(var i=0;i<allObjectEvents.length;i++){var objectEventState=allObjectEvents[i];try{processEvent.call(this,objectEventState);}catch(e){this.model_.importWarning({type:'object_parse_error',message:e.message});}}},createImplicitObjects_:function(){tr.b.iterItems(this.model_.processes,function(pid,process){this.createImplicitObjectsForProcess_(process);},this);},createImplicitObjectsForProcess_:function(process){function processField(referencingObject,referencingObjectFieldName,referencingObjectFieldValue,containingSnapshot){if(!referencingObjectFieldValue)return;if(referencingObjectFieldValue instanceof tr.model.ObjectSnapshot)return null;if(referencingObjectFieldValue.id===undefined)return;var implicitSnapshot=referencingObjectFieldValue;var rawId=implicitSnapshot.id;var m=/(.+)\/(.+)/.exec(rawId);if(!m)throw new Error('Implicit snapshots must have names.');delete implicitSnapshot.id;var name=m[1];var id=m[2];var res;var cat;if(implicitSnapshot.cat!==undefined)cat=implicitSnapshot.cat;else cat=containingSnapshot.objectInstance.category;var baseTypename;if(implicitSnapshot.base_type)baseTypename=implicitSnapshot.base_type;else baseTypename=undefined;var scope=containingSnapshot.objectInstance.scopedId.scope;try{res=process.objects.addSnapshot(new tr.model.ScopedId(scope,id),cat,name,containingSnapshot.ts,implicitSnapshot,baseTypename);}catch(e){this.model_.importWarning({type:'object_snapshot_parse_error',message:'While processing implicit snapshot of '+rawId+' at ts='+containingSnapshot.ts+': '+e});return;}res.objectInstance.hasImplicitSnapshots=true;res.containingSnapshot=containingSnapshot;res.snapshottedOnThread=containingSnapshot.snapshottedOnThread;referencingObject[referencingObjectFieldName]=res;if(!(res instanceof tr.model.ObjectSnapshot))throw new Error('Created object must be instanceof snapshot');return res.args;}function iterObject(object,func,containingSnapshot,thisArg){if(!(object instanceof Object))return;if(object instanceof Array){for(var i=0;i<object.length;i++){var res=func.call(thisArg,object,i,object[i],containingSnapshot);if(res===null)continue;if(res)iterObject(res,func,containingSnapshot,thisArg);else iterObject(object[i],func,containingSnapshot,thisArg);}return;}for(var key in object){var res=func.call(thisArg,object,key,object[key],containingSnapshot);if(res===null)continue;if(res)iterObject(res,func,containingSnapshot,thisArg);else iterObject(object[key],func,containingSnapshot,thisArg);}}process.objects.iterObjectInstances(function(instance){instance.snapshots.forEach(function(snapshot){if(snapshot.args.id!==undefined)throw new Error('args cannot have an id field inside it');iterObject(snapshot.args,processField,snapshot,this);},this);},this);},createMemoryDumps_:function(){for(var dumpId in this.allMemoryDumpEvents_)this.createGlobalMemoryDump_(this.allMemoryDumpEvents_[dumpId],dumpId);},createGlobalMemoryDump_:function(dumpIdEvents,dumpId){var globalRange=new tr.b.Range();for(var pid in dumpIdEvents){var processEvents=dumpIdEvents[pid];for(var i=0;i<processEvents.length;i++)globalRange.addValue(this.toModelTimeFromUs_(processEvents[i].ts));}if(globalRange.isEmpty)throw new Error('Internal error: Global memory dump without events');var globalMemoryDump=new tr.model.GlobalMemoryDump(this.model_,globalRange.min);globalMemoryDump.duration=globalRange.range;this.model_.globalMemoryDumps.push(globalMemoryDump);var globalMemoryAllocatorDumpsByFullName={};var levelsOfDetail={};var allMemoryAllocatorDumpsByGuid={};for(var pid in dumpIdEvents){this.createProcessMemoryDump_(globalMemoryDump,globalMemoryAllocatorDumpsByFullName,levelsOfDetail,allMemoryAllocatorDumpsByGuid,dumpIdEvents[pid],pid,dumpId);}globalMemoryDump.levelOfDetail=levelsOfDetail.global;globalMemoryDump.memoryAllocatorDumps=this.inferMemoryAllocatorDumpTree_(globalMemoryAllocatorDumpsByFullName);this.parseMemoryDumpAllocatorEdges_(allMemoryAllocatorDumpsByGuid,dumpIdEvents,dumpId);},createProcessMemoryDump_:function(globalMemoryDump,globalMemoryAllocatorDumpsByFullName,levelsOfDetail,allMemoryAllocatorDumpsByGuid,processEvents,pid,dumpId){var processRange=new tr.b.Range();for(var i=0;i<processEvents.length;i++)processRange.addValue(this.toModelTimeFromUs_(processEvents[i].ts));if(processRange.isEmpty)throw new Error('Internal error: Process memory dump without events');var process=this.model_.getOrCreateProcess(pid);var processMemoryDump=new tr.model.ProcessMemoryDump(globalMemoryDump,process,processRange.min);processMemoryDump.duration=processRange.range;process.memoryDumps.push(processMemoryDump);globalMemoryDump.processMemoryDumps[pid]=processMemoryDump;var processMemoryAllocatorDumpsByFullName={};for(var i=0;i<processEvents.length;i++){var processEvent=processEvents[i];var dumps=processEvent.args.dumps;if(dumps===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'\'dumps\' field not found in a process memory dump'+' event for PID='+pid+' and dump ID='+dumpId+'.'});continue;}this.parseMemoryDumpTotals_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpVmRegions_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpHeapDumps_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpLevelOfDetail_(levelsOfDetail,dumps,pid,dumpId);this.parseMemoryDumpAllocatorDumps_(processMemoryDump,globalMemoryDump,processMemoryAllocatorDumpsByFullName,globalMemoryAllocatorDumpsByFullName,allMemoryAllocatorDumpsByGuid,dumps,pid,dumpId);}if(levelsOfDetail.process===undefined){levelsOfDetail.process=processMemoryDump.vmRegions?DETAILED:LIGHT;}if(!this.updateMemoryDumpLevelOfDetail_(levelsOfDetail,'global',levelsOfDetail.process)){this.model_.importWarning({type:'memory_dump_parse_error',message:'diffent levels of detail provided for global memory'+' dump (dump ID='+dumpId+').'});}processMemoryDump.levelOfDetail=levelsOfDetail.process;delete levelsOfDetail.process;processMemoryDump.memoryAllocatorDumps=this.inferMemoryAllocatorDumpTree_(processMemoryAllocatorDumpsByFullName);},parseMemoryDumpTotals_:function(processMemoryDump,dumps,pid,dumpId){var rawTotals=dumps.process_totals;if(rawTotals===undefined)return;if(processMemoryDump.totals!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Process totals provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var totals={};var platformSpecificTotals=undefined;for(var rawTotalName in rawTotals){var rawTotalValue=rawTotals[rawTotalName];if(rawTotalValue===undefined)continue;if(rawTotalName==='resident_set_bytes'){totals.residentBytes=parseInt(rawTotalValue,16);continue;}if(rawTotalName==='peak_resident_set_bytes'){totals.peakResidentBytes=parseInt(rawTotalValue,16);continue;}if(rawTotalName==='is_peak_rss_resetable'){totals.arePeakResidentBytesResettable=!!rawTotalValue;continue;}if(platformSpecificTotals===undefined){platformSpecificTotals={};totals.platformSpecific=platformSpecificTotals;}platformSpecificTotals[rawTotalName]=parseInt(rawTotalValue,16);}if(totals.peakResidentBytes===undefined&&totals.arePeakResidentBytesResettable!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Optional field peak_resident_set_bytes found'+' but is_peak_rss_resetable not found in'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});}if(totals.arePeakResidentBytesResettable!==undefined&&totals.peakResidentBytes===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Optional field is_peak_rss_resetable found'+' but peak_resident_set_bytes not found in'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});}processMemoryDump.totals=totals;},parseMemoryDumpVmRegions_:function(processMemoryDump,dumps,pid,dumpId){var rawProcessMmaps=dumps.process_mmaps;if(rawProcessMmaps===undefined)return;var rawVmRegions=rawProcessMmaps.vm_regions;if(rawVmRegions===undefined)return;if(processMemoryDump.vmRegions!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'VM regions provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var vmRegions=new Array(rawVmRegions.length);for(var i=0;i<rawVmRegions.length;i++){var rawVmRegion=rawVmRegions[i];var byteStats={};var rawByteStats=rawVmRegion.bs;for(var rawByteStatName in rawByteStats){var rawByteStatValue=rawByteStats[rawByteStatName];if(rawByteStatValue===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Byte stat \''+rawByteStatName+'\' of VM region '+i+' ('+rawVmRegion.mf+') in process memory dump for '+'PID='+pid+' and dump ID='+dumpId+' does not have a value.'});continue;}var byteStatName=BYTE_STAT_NAME_MAP[rawByteStatName];if(byteStatName===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Unknown byte stat name \''+rawByteStatName+'\' ('+rawByteStatValue+') of VM region '+i+' ('+rawVmRegion.mf+') in process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});continue;}byteStats[byteStatName]=parseInt(rawByteStatValue,16);}vmRegions[i]=new tr.model.VMRegion(parseInt(rawVmRegion.sa,16),parseInt(rawVmRegion.sz,16),rawVmRegion.pf,rawVmRegion.mf,byteStats);}processMemoryDump.vmRegions=tr.model.VMRegionClassificationNode.fromRegions(vmRegions);},parseMemoryDumpHeapDumps_:function(processMemoryDump,dumps,pid,dumpId){var rawHeapDumps=dumps.heaps;if(rawHeapDumps===undefined)return;if(processMemoryDump.heapDumps!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Heap dumps provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var model=this.model_;var idPrefix='p'+pid+':';var heapDumps={};var objectTypeNameMap=this.objectTypeNameMap_[pid];if(objectTypeNameMap===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing mapping from object type IDs to names.'});}for(var allocatorName in rawHeapDumps){var entries=rawHeapDumps[allocatorName].entries;if(entries===undefined||entries.length===0){this.model_.importWarning({type:'memory_dump_parse_error',message:'No heap entries in a '+allocatorName+' heap dump for PID='+pid+' and dump ID='+dumpId+'.'});continue;}var isOldFormat=entries[0].bt===undefined;if(!isOldFormat&&objectTypeNameMap===undefined){continue;}var heapDump=new tr.model.HeapDump(processMemoryDump,allocatorName);for(var i=0;i<entries.length;i++){var entry=entries[i];var leafStackFrameIndex=entry.bt;var leafStackFrame;if(isOldFormat){if(leafStackFrameIndex===undefined){leafStackFrame=undefined;}else{var leafStackFrameId=idPrefix+leafStackFrameIndex;if(leafStackFrameIndex===''){leafStackFrame=undefined;}else{leafStackFrame=model.stackFrames[leafStackFrameId];if(leafStackFrame===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing leaf stack frame (ID '+leafStackFrameId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}}leafStackFrameId+=':self';if(model.stackFrames[leafStackFrameId]!==undefined){leafStackFrame=model.stackFrames[leafStackFrameId];}else{leafStackFrame=new tr.model.StackFrame(leafStackFrame,leafStackFrameId,'<self>',undefined);model.addStackFrame(leafStackFrame);}}}else{if(leafStackFrameIndex===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing stack frame ID of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}var leafStackFrameId=idPrefix+leafStackFrameIndex;if(leafStackFrameIndex===''){leafStackFrame=undefined;}else{leafStackFrame=model.stackFrames[leafStackFrameId];if(leafStackFrame===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing leaf stack frame (ID '+leafStackFrameId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}}}var objectTypeId=entry.type;var objectTypeName;if(objectTypeId===undefined){objectTypeName=undefined;}else if(objectTypeNameMap===undefined){continue;}else{objectTypeName=objectTypeNameMap[objectTypeId];if(objectTypeName===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing object type name (ID '+objectTypeId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for pid='+pid+'.'});continue;}}var size=parseInt(entry.size,16);var count=entry.count===undefined?undefined:parseInt(entry.count,16);heapDump.addEntry(leafStackFrame,objectTypeName,size,count);}if(heapDump.entries.length>0)heapDumps[allocatorName]=heapDump;}if(Object.keys(heapDumps).length>0)processMemoryDump.heapDumps=heapDumps;},parseMemoryDumpLevelOfDetail_:function(levelsOfDetail,dumps,pid,dumpId){var rawLevelOfDetail=dumps.level_of_detail;var level;switch(rawLevelOfDetail){case'background':level=BACKGROUND;break;case'light':level=LIGHT;break;case'detailed':level=DETAILED;break;case undefined:level=undefined;break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'unknown raw level of detail \''+rawLevelOfDetail+'\' of process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}if(!this.updateMemoryDumpLevelOfDetail_(levelsOfDetail,'process',level)){this.model_.importWarning({type:'memory_dump_parse_error',message:'diffent levels of detail provided for process memory'+' dump for PID='+pid+' (dump ID='+dumpId+').'});}},updateMemoryDumpLevelOfDetail_:function(levelsOfDetail,scope,level){if(!(scope in levelsOfDetail)||level===levelsOfDetail[scope]){levelsOfDetail[scope]=level;return true;}if(MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER.indexOf(level)>MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER.indexOf(levelsOfDetail[scope])){levelsOfDetail[scope]=level;}return false;},parseMemoryDumpAllocatorDumps_:function(processMemoryDump,globalMemoryDump,processMemoryAllocatorDumpsByFullName,globalMemoryAllocatorDumpsByFullName,allMemoryAllocatorDumpsByGuid,dumps,pid,dumpId){var rawAllocatorDumps=dumps.allocators;if(rawAllocatorDumps===undefined)return;for(var fullName in rawAllocatorDumps){var rawAllocatorDump=rawAllocatorDumps[fullName];var guid=rawAllocatorDump.guid;if(guid===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' for PID='+pid+' and dump ID='+dumpId+' does not have a GUID.'});}var flags=rawAllocatorDump.flags||0;var isWeakDump=!!(flags&WEAK_MEMORY_ALLOCATOR_DUMP_FLAG);var containerMemoryDump;var dstIndex;if(fullName.startsWith(GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX)){fullName=fullName.substring(GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX.length);containerMemoryDump=globalMemoryDump;dstIndex=globalMemoryAllocatorDumpsByFullName;}else{containerMemoryDump=processMemoryDump;dstIndex=processMemoryAllocatorDumpsByFullName;}var allocatorDump=allMemoryAllocatorDumpsByGuid[guid];if(allocatorDump===undefined){if(fullName in dstIndex){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple GUIDs provided for'+' memory allocator dump '+fullName+': '+dstIndex[fullName].guid+', '+guid+' (ignored) for'+' PID='+pid+' and dump ID='+dumpId+'.'});continue;}allocatorDump=new tr.model.MemoryAllocatorDump(containerMemoryDump,fullName,guid);allocatorDump.weak=isWeakDump;dstIndex[fullName]=allocatorDump;if(guid!==undefined)allMemoryAllocatorDumpsByGuid[guid]=allocatorDump;}else{if(allocatorDump.containerMemoryDump!==containerMemoryDump){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+' dumped in different contexts.'});continue;}if(allocatorDump.fullName!==fullName){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump with GUID='+guid+' for PID='+pid+' and dump ID='+dumpId+' has multiple names: '+allocatorDump.fullName+', '+fullName+' (ignored).'});continue;}if(!isWeakDump){allocatorDump.weak=false;}}var attributes=rawAllocatorDump.attrs;if(attributes===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+' does not have attributes.'});attributes={};}for(var attrName in attributes){var attrArgs=attributes[attrName];var attrType=attrArgs.type;var attrValue=attrArgs.value;switch(attrType){case'scalar':if(attrName in allocatorDump.numerics){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple values provided for scalar attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+'.'});break;}var unit=attrArgs.units==='bytes'?tr.b.Unit.byName.sizeInBytes_smallerIsBetter:tr.b.Unit.byName.unitlessNumber_smallerIsBetter;var value=parseInt(attrValue,16);allocatorDump.addNumeric(attrName,new tr.v.ScalarNumeric(unit,value));break;case'string':if(attrName in allocatorDump.diagnostics){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple values provided for string attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+'.'});break;}allocatorDump.addDiagnostic(attrName,attrValue);break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'Unknown type provided for attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+': '+attrType});break;}}}},inferMemoryAllocatorDumpTree_:function(memoryAllocatorDumpsByFullName){var rootAllocatorDumps=[];var fullNames=Object.keys(memoryAllocatorDumpsByFullName);fullNames.sort();for(var i=0;i<fullNames.length;i++){var fullName=fullNames[i];var allocatorDump=memoryAllocatorDumpsByFullName[fullName];while(true){var lastSlashIndex=fullName.lastIndexOf('/');if(lastSlashIndex===-1){rootAllocatorDumps.push(allocatorDump);break;}var parentFullName=fullName.substring(0,lastSlashIndex);var parentAllocatorDump=memoryAllocatorDumpsByFullName[parentFullName];var parentAlreadyExisted=true;if(parentAllocatorDump===undefined){parentAlreadyExisted=false;parentAllocatorDump=new tr.model.MemoryAllocatorDump(allocatorDump.containerMemoryDump,parentFullName);if(allocatorDump.weak!==false){parentAllocatorDump.weak=undefined;}memoryAllocatorDumpsByFullName[parentFullName]=parentAllocatorDump;}allocatorDump.parent=parentAllocatorDump;parentAllocatorDump.children.push(allocatorDump);if(parentAlreadyExisted){if(!allocatorDump.weak){while(parentAllocatorDump!==undefined&&parentAllocatorDump.weak===undefined){parentAllocatorDump.weak=false;parentAllocatorDump=parentAllocatorDump.parent;}}break;}fullName=parentFullName;allocatorDump=parentAllocatorDump;}}for(var fullName in memoryAllocatorDumpsByFullName){var allocatorDump=memoryAllocatorDumpsByFullName[fullName];if(allocatorDump.weak===undefined)allocatorDump.weak=true;}return rootAllocatorDumps;},parseMemoryDumpAllocatorEdges_:function(allMemoryAllocatorDumpsByGuid,dumpIdEvents,dumpId){for(var pid in dumpIdEvents){var processEvents=dumpIdEvents[pid];for(var i=0;i<processEvents.length;i++){var processEvent=processEvents[i];var dumps=processEvent.args.dumps;if(dumps===undefined)continue;var rawEdges=dumps.allocators_graph;if(rawEdges===undefined)continue;for(var j=0;j<rawEdges.length;j++){var rawEdge=rawEdges[j];var sourceGuid=rawEdge.source;var sourceDump=allMemoryAllocatorDumpsByGuid[sourceGuid];if(sourceDump===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Edge for PID='+pid+' and dump ID='+dumpId+' is missing source memory allocator dump (GUID='+sourceGuid+').'});continue;}var targetGuid=rawEdge.target;var targetDump=allMemoryAllocatorDumpsByGuid[targetGuid];if(targetDump===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Edge for PID='+pid+' and dump ID='+dumpId+' is missing target memory allocator dump (GUID='+targetGuid+').'});continue;}var importance=rawEdge.importance;var edge=new tr.model.MemoryAllocatorDumpLink(sourceDump,targetDump,importance);switch(rawEdge.type){case'ownership':if(sourceDump.owns!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+sourceDump.fullName+' (GUID='+sourceGuid+') already owns a memory'+' allocator dump ('+sourceDump.owns.target.fullName+').'});}else{sourceDump.owns=edge;targetDump.ownedBy.push(edge);}break;case'retention':sourceDump.retains.push(edge);targetDump.retainedBy.push(edge);break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'Invalid edge type: '+rawEdge.type+' (PID='+pid+', dump ID='+dumpId+', source='+sourceGuid+', target='+targetGuid+', importance='+importance+').'});}}}}},toModelTimeFromUs_:function(ts){if(!this.toModelTime_){this.toModelTime_=this.model_.clockSyncManager.getModelTimeTransformer(this.clockDomainId_);}return this.toModelTime_(tr.b.Unit.timestampFromUs(ts));},maybeToModelTimeFromUs_:function(ts){if(ts===undefined)return undefined;return this.toModelTimeFromUs_(ts);}};tr.importer.Importer.register(TraceEventImporter);return{TraceEventImporter:TraceEventImporter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base64.js":35,"../../base/color_scheme.js":38,"../../base/range.js":53,"../../base/unit.js":63,"../../base/utils.js":65,"../../importer/context_processor.js":76,"../../importer/importer.js":82,"../../model/comment_box_annotation.js":112,"../../model/constants.js":114,"../../model/container_memory_dump.js":115,"../../model/counter_series.js":118,"../../model/flow_event.js":127,"../../model/global_memory_dump.js":129,"../../model/heap_dump.js":130,"../../model/instant_event.js":136,"../../model/memory_allocator_dump.js":140,"../../model/model.js":141,"../../model/process_memory_dump.js":151,"../../model/rect_annotation.js":152,"../../model/scoped_id.js":154,"../../model/slice_group.js":158,"../../model/vm_region.js":174,"../../model/x_marker_annotation.js":175,"../../value/numeric.js":196,"./trace_code_entry.js":70,"./trace_code_map.js":71,"./v8/codemap.js":73}],73:[function(require,module,exports){(function(global){"use strict";require("./splaytree.js");'use strict';global.tr.exportTo('tr.e.importer.v8',function(){function CodeMap(){this.dynamics_=new tr.e.importer.v8.SplayTree();this.dynamicsNameGen_=new tr.e.importer.v8.CodeMap.NameGenerator();this.statics_=new tr.e.importer.v8.SplayTree();this.libraries_=new tr.e.importer.v8.SplayTree();this.pages_=[];}CodeMap.PAGE_ALIGNMENT=12;CodeMap.PAGE_SIZE=1<<CodeMap.PAGE_ALIGNMENT;CodeMap.prototype.addCode=function(start,codeEntry){this.deleteAllCoveredNodes_(this.dynamics_,start,start+codeEntry.size);this.dynamics_.insert(start,codeEntry);};CodeMap.prototype.moveCode=function(from,to){var removedNode=this.dynamics_.remove(from);this.deleteAllCoveredNodes_(this.dynamics_,to,to+removedNode.value.size);this.dynamics_.insert(to,removedNode.value);};CodeMap.prototype.deleteCode=function(start){var removedNode=this.dynamics_.remove(start);};CodeMap.prototype.addLibrary=function(start,codeEntry){this.markPages_(start,start+codeEntry.size);this.libraries_.insert(start,codeEntry);};CodeMap.prototype.addStaticCode=function(start,codeEntry){this.statics_.insert(start,codeEntry);};CodeMap.prototype.markPages_=function(start,end){for(var addr=start;addr<=end;addr+=CodeMap.PAGE_SIZE){this.pages_[addr>>>CodeMap.PAGE_ALIGNMENT]=1;}};CodeMap.prototype.deleteAllCoveredNodes_=function(tree,start,end){var toDelete=[];var addr=end-1;while(addr>=start){var node=tree.findGreatestLessThan(addr);if(!node)break;var start2=node.key,end2=start2+node.value.size;if(start2<end&&start<end2)toDelete.push(start2);addr=start2-1;}for(var i=0,l=toDelete.length;i<l;++i)tree.remove(toDelete[i]);};CodeMap.prototype.isAddressBelongsTo_=function(addr,node){return addr>=node.key&&addr<node.key+node.value.size;};CodeMap.prototype.findInTree_=function(tree,addr){var node=tree.findGreatestLessThan(addr);return node&&this.isAddressBelongsTo_(addr,node)?node.value:null;};CodeMap.prototype.findEntryInLibraries=function(addr){var pageAddr=addr>>>CodeMap.PAGE_ALIGNMENT;if(pageAddr in this.pages_)return this.findInTree_(this.libraries_,addr);return undefined;};CodeMap.prototype.findEntry=function(addr){var pageAddr=addr>>>CodeMap.PAGE_ALIGNMENT;if(pageAddr in this.pages_){return this.findInTree_(this.statics_,addr)||this.findInTree_(this.libraries_,addr);}var min=this.dynamics_.findMin();var max=this.dynamics_.findMax();if(max!=null&&addr<max.key+max.value.size&&addr>=min.key){var dynaEntry=this.findInTree_(this.dynamics_,addr);if(dynaEntry==null)return null;if(!dynaEntry.nameUpdated_){dynaEntry.name=this.dynamicsNameGen_.getName(dynaEntry.name);dynaEntry.nameUpdated_=true;}return dynaEntry;}return null;};CodeMap.prototype.findDynamicEntryByStartAddress=function(addr){var node=this.dynamics_.find(addr);return node?node.value:null;};CodeMap.prototype.getAllDynamicEntries=function(){return this.dynamics_.exportValues();};CodeMap.prototype.getAllDynamicEntriesWithAddresses=function(){return this.dynamics_.exportKeysAndValues();};CodeMap.prototype.getAllStaticEntries=function(){return this.statics_.exportValues();};CodeMap.prototype.getAllLibrariesEntries=function(){return this.libraries_.exportValues();};CodeMap.CodeState={COMPILED:0,OPTIMIZABLE:1,OPTIMIZED:2};CodeMap.CodeEntry=function(size,opt_name,opt_type){this.id=tr.b.GUID.allocateSimple();this.size=size;this.name_=opt_name||'';this.type=opt_type||'';this.nameUpdated_=false;};CodeMap.CodeEntry.prototype={__proto__:Object.prototype,get name(){return this.name_;},set name(value){this.name_=value;},toString:function(){this.name_+': '+this.size.toString(16);}};CodeMap.CodeEntry.TYPE={SHARED_LIB:'SHARED_LIB',CPP:'CPP'};CodeMap.DynamicFuncCodeEntry=function(size,type,func,state){CodeMap.CodeEntry.call(this,size,'',type);this.func=func;this.state=state;};CodeMap.DynamicFuncCodeEntry.STATE_PREFIX=['','~','*'];CodeMap.DynamicFuncCodeEntry.prototype={__proto__:CodeMap.CodeEntry.prototype,get name(){return CodeMap.DynamicFuncCodeEntry.STATE_PREFIX[this.state]+this.func.name;},set name(value){this.name_=value;},getRawName:function(){return this.func.getName();},isJSFunction:function(){return true;},toString:function(){return this.type+': '+this.name+': '+this.size.toString(16);}};CodeMap.FunctionEntry=function(name){CodeMap.CodeEntry.call(this,0,name);};CodeMap.FunctionEntry.prototype={__proto__:CodeMap.CodeEntry.prototype,get name(){var name=this.name_;if(name.length==0){name='<anonymous>';}else if(name.charAt(0)==' '){name='<anonymous>'+name;}return name;},set name(value){this.name_=value;}};CodeMap.NameGenerator=function(){this.knownNames_={};};CodeMap.NameGenerator.prototype.getName=function(name){if(!(name in this.knownNames_)){this.knownNames_[name]=0;return name;}var count=++this.knownNames_[name];return name+' {'+count+'}';};return{CodeMap:CodeMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./splaytree.js":74}],74:[function(require,module,exports){(function(global){"use strict";require("../../../base/base.js");'use strict';global.tr.exportTo('tr.e.importer.v8',function(){function SplayTree(){};SplayTree.prototype.root_=null;SplayTree.prototype.isEmpty=function(){return!this.root_;};SplayTree.prototype.insert=function(key,value){if(this.isEmpty()){this.root_=new SplayTree.Node(key,value);return;}this.splay_(key);if(this.root_.key==key){return;}var node=new SplayTree.Node(key,value);if(key>this.root_.key){node.left=this.root_;node.right=this.root_.right;this.root_.right=null;}else{node.right=this.root_;node.left=this.root_.left;this.root_.left=null;}this.root_=node;};SplayTree.prototype.remove=function(key){if(this.isEmpty()){throw Error('Key not found: '+key);}this.splay_(key);if(this.root_.key!=key){throw Error('Key not found: '+key);}var removed=this.root_;if(!this.root_.left){this.root_=this.root_.right;}else{var right=this.root_.right;this.root_=this.root_.left;this.splay_(key);this.root_.right=right;}return removed;};SplayTree.prototype.find=function(key){if(this.isEmpty()){return null;}this.splay_(key);return this.root_.key==key?this.root_:null;};SplayTree.prototype.findMin=function(){if(this.isEmpty()){return null;}var current=this.root_;while(current.left){current=current.left;}return current;};SplayTree.prototype.findMax=function(opt_startNode){if(this.isEmpty()){return null;}var current=opt_startNode||this.root_;while(current.right){current=current.right;}return current;};SplayTree.prototype.findGreatestLessThan=function(key){if(this.isEmpty()){return null;}this.splay_(key);if(this.root_.key<=key){return this.root_;}else if(this.root_.left){return this.findMax(this.root_.left);}else{return null;}};SplayTree.prototype.exportKeysAndValues=function(){var result=[];this.traverse_(function(node){result.push([node.key,node.value]);});return result;};SplayTree.prototype.exportValues=function(){var result=[];this.traverse_(function(node){result.push(node.value);});return result;};SplayTree.prototype.splay_=function(key){if(this.isEmpty()){return;}var dummy,left,right;dummy=left=right=new SplayTree.Node(null,null);var current=this.root_;while(true){if(key<current.key){if(!current.left){break;}if(key<current.left.key){var tmp=current.left;current.left=tmp.right;tmp.right=current;current=tmp;if(!current.left){break;}}right.left=current;right=current;current=current.left;}else if(key>current.key){if(!current.right){break;}if(key>current.right.key){var tmp=current.right;current.right=tmp.left;tmp.left=current;current=tmp;if(!current.right){break;}}left.right=current;left=current;current=current.right;}else{break;}}left.right=current.left;right.left=current.right;current.left=dummy.right;current.right=dummy.left;this.root_=current;};SplayTree.prototype.traverse_=function(f){var nodesToVisit=[this.root_];while(nodesToVisit.length>0){var node=nodesToVisit.shift();if(node==null){continue;}f(node);nodesToVisit.push(node.left);nodesToVisit.push(node.right);}};SplayTree.Node=function(key,value){this.key=key;this.value=value;};SplayTree.Node.prototype.left=null;SplayTree.Node.prototype.right=null;return{SplayTree:SplayTree};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../../base/base.js":34}],75:[function(require,module,exports){"use strict";require("./importer/trace_event_importer.js");require("../model/model.js");},{"../model/model.js":141,"./importer/trace_event_importer.js":72}],76:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.importer',function(){function ContextProcessor(model){this.model_=model;this.activeContexts_=[];this.stackPerType_={};this.contextCache_={};this.contextSetCache_={};this.cachedEntryForActiveContexts_=undefined;this.seenSnapshots_={};};ContextProcessor.prototype={enterContext:function(contextType,scopedId){var newActiveContexts=[this.getOrCreateContext_(contextType,scopedId)];for(var oldContext of this.activeContexts_){if(oldContext.type===contextType){this.pushContext_(oldContext);}else{newActiveContexts.push(oldContext);}}this.activeContexts_=newActiveContexts;this.cachedEntryForActiveContexts_=undefined;},leaveContext:function(contextType,scopedId){this.leaveContextImpl_(context=>context.type===contextType&&context.snapshot.scope===scopedId.scope&&context.snapshot.idRef===scopedId.id);},destroyContext:function(scopedId){tr.b.iterItems(this.stackPerType_,function(contextType,stack){var newLength=0;for(var i=0;i<stack.length;++i){if(stack[i].snapshot.scope!==scopedId.scope||stack[i].snapshot.idRef!==scopedId.id){stack[newLength++]=stack[i];}}stack.length=newLength;});this.leaveContextImpl_(context=>context.snapshot.scope===scopedId.scope&&context.snapshot.idRef===scopedId.id);},leaveContextImpl_:function(predicate){var newActiveContexts=[];for(var oldContext of this.activeContexts_){if(predicate(oldContext)){var previousContext=this.popContext_(oldContext.type);if(previousContext)newActiveContexts.push(previousContext);}else{newActiveContexts.push(oldContext);}}this.activeContexts_=newActiveContexts;this.cachedEntryForActiveContexts_=undefined;},getOrCreateContext_:function(contextType,scopedId){var context={type:contextType,snapshot:{scope:scopedId.scope,idRef:scopedId.id}};var key=this.getContextKey_(context);if(key in this.contextCache_)return this.contextCache_[key];this.contextCache_[key]=context;var snapshotKey=this.getSnapshotKey_(scopedId);this.seenSnapshots_[snapshotKey]=true;return context;},pushContext_:function(context){if(!(context.type in this.stackPerType_))this.stackPerType_[context.type]=[];this.stackPerType_[context.type].push(context);},popContext_:function(contextType){if(!(contextType in this.stackPerType_))return undefined;return this.stackPerType_[contextType].pop();},getContextKey_:function(context){return[context.type,context.snapshot.scope,context.snapshot.idRef].join('\x00');},getSnapshotKey_:function(scopedId){return[scopedId.scope,scopedId.idRef].join('\x00');},get activeContexts(){if(this.cachedEntryForActiveContexts_===undefined){var key=[];for(var context of this.activeContexts_)key.push(this.getContextKey_(context));key.sort();key=key.join('\x00');if(key in this.contextSetCache_){this.cachedEntryForActiveContexts_=this.contextSetCache_[key];}else{this.activeContexts_.sort(function(a,b){var keyA=this.getContextKey_(a);var keyB=this.getContextKey_(b);if(keyA<keyB)return-1;if(keyA>keyB)return 1;return 0;}.bind(this));this.contextSetCache_[key]=Object.freeze(this.activeContexts_);this.cachedEntryForActiveContexts_=this.contextSetCache_[key];}}return this.cachedEntryForActiveContexts_;},invalidateContextCacheForSnapshot:function(scopedId){var snapshotKey=this.getSnapshotKey_(scopedId);if(!(snapshotKey in this.seenSnapshots_))return;this.contextCache_={};this.contextSetCache_={};this.cachedEntryForActiveContexts_=undefined;this.activeContexts_=this.activeContexts_.map(function(context){if(context.snapshot.scope!==scopedId.scope||context.snapshot.idRef!==scopedId.id)return context;return{type:context.type,snapshot:{scope:context.snapshot.scope,idRef:context.snapshot.idRef}};});this.seenSnapshots_={};}};return{ContextProcessor:ContextProcessor};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],77:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("./importer.js");'use strict';global.tr.exportTo('tr.importer',function(){function EmptyImporter(events){this.importPriority=0;};EmptyImporter.canImport=function(eventData){if(eventData instanceof Array&&eventData.length==0)return true;if(typeof eventData==='string'||eventData instanceof String){return eventData.length==0;}return false;};EmptyImporter.prototype={__proto__:tr.importer.Importer.prototype,get importerName(){return'EmptyImporter';}};tr.importer.Importer.register(EmptyImporter);return{EmptyImporter:EmptyImporter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"./importer.js":82}],78:[function(require,module,exports){(function(global){"use strict";require("../base/range_utils.js");require("../extras/chrome/cc/input_latency_async_slice.js");require("./proto_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){var ProtoExpectation=tr.importer.ProtoExpectation;var INPUT_TYPE=tr.e.cc.INPUT_EVENT_TYPE_NAMES;var KEYBOARD_TYPE_NAMES=[INPUT_TYPE.CHAR,INPUT_TYPE.KEY_DOWN_RAW,INPUT_TYPE.KEY_DOWN,INPUT_TYPE.KEY_UP];var MOUSE_RESPONSE_TYPE_NAMES=[INPUT_TYPE.CLICK,INPUT_TYPE.CONTEXT_MENU];var MOUSE_WHEEL_TYPE_NAMES=[INPUT_TYPE.MOUSE_WHEEL];var MOUSE_DRAG_TYPE_NAMES=[INPUT_TYPE.MOUSE_DOWN,INPUT_TYPE.MOUSE_MOVE,INPUT_TYPE.MOUSE_UP];var TAP_TYPE_NAMES=[INPUT_TYPE.TAP,INPUT_TYPE.TAP_CANCEL,INPUT_TYPE.TAP_DOWN];var PINCH_TYPE_NAMES=[INPUT_TYPE.PINCH_BEGIN,INPUT_TYPE.PINCH_END,INPUT_TYPE.PINCH_UPDATE];var FLING_TYPE_NAMES=[INPUT_TYPE.FLING_CANCEL,INPUT_TYPE.FLING_START];var TOUCH_TYPE_NAMES=[INPUT_TYPE.TOUCH_END,INPUT_TYPE.TOUCH_MOVE,INPUT_TYPE.TOUCH_START];var SCROLL_TYPE_NAMES=[INPUT_TYPE.SCROLL_BEGIN,INPUT_TYPE.SCROLL_END,INPUT_TYPE.SCROLL_UPDATE];var ALL_HANDLED_TYPE_NAMES=[].concat(KEYBOARD_TYPE_NAMES,MOUSE_RESPONSE_TYPE_NAMES,MOUSE_WHEEL_TYPE_NAMES,MOUSE_DRAG_TYPE_NAMES,PINCH_TYPE_NAMES,TAP_TYPE_NAMES,FLING_TYPE_NAMES,TOUCH_TYPE_NAMES,SCROLL_TYPE_NAMES);var RENDERER_FLING_TITLE='InputHandlerProxy::HandleGestureFling::started';var PLAYBACK_EVENT_TITLE='VideoPlayback';var CSS_ANIMATION_TITLE='Animation';var INPUT_MERGE_THRESHOLD_MS=200;var ANIMATION_MERGE_THRESHOLD_MS=32;var MOUSE_WHEEL_THRESHOLD_MS=40;var MOUSE_MOVE_THRESHOLD_MS=40;var KEYBOARD_IR_NAME='Keyboard';var MOUSE_IR_NAME='Mouse';var MOUSEWHEEL_IR_NAME='MouseWheel';var TAP_IR_NAME='Tap';var PINCH_IR_NAME='Pinch';var FLING_IR_NAME='Fling';var TOUCH_IR_NAME='Touch';var SCROLL_IR_NAME='Scroll';var CSS_IR_NAME='CSS';var WEBGL_IR_NAME='WebGL';var VIDEO_IR_NAME='Video';function compareEvents(x,y){if(x.start!==y.start)return x.start-y.start;if(x.end!==y.end)return x.end-y.end;if(x.guid&&y.guid)return x.guid-y.guid;return 0;}function forEventTypesIn(events,typeNames,cb,opt_this){events.forEach(function(event){if(typeNames.indexOf(event.typeName)>=0){cb.call(opt_this,event);}});}function causedFrame(event){return event.associatedEvents.some(x=>x.title===tr.model.helpers.IMPL_RENDERING_STATS);}function getSortedFrameEventsByProcess(modelHelper){var frameEventsByPid={};tr.b.iterItems(modelHelper.rendererHelpers,function(pid,rendererHelper){frameEventsByPid[pid]=rendererHelper.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE,modelHelper.model.bounds);});return frameEventsByPid;}function getSortedInputEvents(modelHelper){var inputEvents=[];var browserProcess=modelHelper.browserHelper.process;var mainThread=browserProcess.findAtMostOneThreadNamed('CrBrowserMain');for(var slice of mainThread.asyncSliceGroup.getDescendantEvents()){if(!slice.isTopLevel)continue;if(!(slice instanceof tr.e.cc.InputLatencyAsyncSlice))continue;if(isNaN(slice.start)||isNaN(slice.duration)||isNaN(slice.end))continue;inputEvents.push(slice);}return inputEvents.sort(compareEvents);}function findProtoExpectations(modelHelper,sortedInputEvents){var protoExpectations=[];var handlers=[handleKeyboardEvents,handleMouseResponseEvents,handleMouseWheelEvents,handleMouseDragEvents,handleTapResponseEvents,handlePinchEvents,handleFlingEvents,handleTouchEvents,handleScrollEvents,handleCSSAnimations,handleWebGLAnimations,handleVideoAnimations];handlers.forEach(function(handler){protoExpectations.push.apply(protoExpectations,handler(modelHelper,sortedInputEvents));});protoExpectations.sort(compareEvents);return protoExpectations;}function handleKeyboardEvents(modelHelper,sortedInputEvents){var protoExpectations=[];forEventTypesIn(sortedInputEvents,KEYBOARD_TYPE_NAMES,function(event){var pe=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,KEYBOARD_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);});return protoExpectations;}function handleMouseResponseEvents(modelHelper,sortedInputEvents){var protoExpectations=[];forEventTypesIn(sortedInputEvents,MOUSE_RESPONSE_TYPE_NAMES,function(event){var pe=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);});return protoExpectations;}function handleMouseWheelEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var prevEvent_=undefined;forEventTypesIn(sortedInputEvents,MOUSE_WHEEL_TYPE_NAMES,function(event){var prevEvent=prevEvent_;prevEvent_=event;if(currentPE&&prevEvent.start+MOUSE_WHEEL_THRESHOLD_MS>=event.start){if(currentPE.irType===ProtoExpectation.ANIMATION_TYPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,MOUSEWHEEL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}return;}currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSEWHEEL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);});return protoExpectations;}function handleMouseDragEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var mouseDownEvent=undefined;forEventTypesIn(sortedInputEvents,MOUSE_DRAG_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.MOUSE_DOWN:if(causedFrame(event)){var pe=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);}else{mouseDownEvent=event;}break;case INPUT_TYPE.MOUSE_MOVE:if(!causedFrame(event)){var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}else if(!currentPE||!currentPE.isNear(event,MOUSE_MOVE_THRESHOLD_MS)){currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);currentPE.pushEvent(event);if(mouseDownEvent){currentPE.associatedEvents.push(mouseDownEvent);mouseDownEvent=undefined;}protoExpectations.push(currentPE);}else{if(currentPE.irType===ProtoExpectation.ANIMATION_TYPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,MOUSE_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}}break;case INPUT_TYPE.MOUSE_UP:if(!mouseDownEvent){var pe=new ProtoExpectation(causedFrame(event)?ProtoExpectation.RESPONSE_TYPE:ProtoExpectation.IGNORED_TYPE,MOUSE_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);break;}if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);if(mouseDownEvent)currentPE.associatedEvents.push(mouseDownEvent);currentPE.pushEvent(event);protoExpectations.push(currentPE);}mouseDownEvent=undefined;currentPE=undefined;break;}});if(mouseDownEvent){currentPE=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);currentPE.pushEvent(mouseDownEvent);protoExpectations.push(currentPE);}return protoExpectations;}function handleTapResponseEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;forEventTypesIn(sortedInputEvents,TAP_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.TAP_DOWN:currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TAP_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);break;case INPUT_TYPE.TAP:if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TAP_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}currentPE=undefined;break;case INPUT_TYPE.TAP_CANCEL:if(!currentPE){var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);break;}if(currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TAP_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}currentPE=undefined;break;}});return protoExpectations;}function handlePinchEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var sawFirstUpdate=false;var modelBounds=modelHelper.model.bounds;forEventTypesIn(sortedInputEvents,PINCH_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.PINCH_BEGIN:if(currentPE&&currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE.pushEvent(event);break;}currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,PINCH_IR_NAME);currentPE.pushEvent(event);currentPE.isAnimationBegin=true;protoExpectations.push(currentPE);sawFirstUpdate=false;break;case INPUT_TYPE.PINCH_UPDATE:if(!currentPE||currentPE.irType===ProtoExpectation.RESPONSE_TYPE&&sawFirstUpdate||!currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,PINCH_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}else{currentPE.pushEvent(event);sawFirstUpdate=true;}break;case INPUT_TYPE.PINCH_END:if(currentPE){currentPE.pushEvent(event);}else{var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}currentPE=undefined;break;}});return protoExpectations;}function handleFlingEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;function isRendererFling(event){return event.title===RENDERER_FLING_TITLE;}var browserHelper=modelHelper.browserHelper;var flingEvents=browserHelper.getAllAsyncSlicesMatching(isRendererFling);forEventTypesIn(sortedInputEvents,FLING_TYPE_NAMES,function(event){flingEvents.push(event);});flingEvents.sort(compareEvents);flingEvents.forEach(function(event){if(event.title===RENDERER_FLING_TITLE){if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,FLING_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}return;}switch(event.typeName){case INPUT_TYPE.FLING_START:if(currentPE){console.error('Another FlingStart? File a bug with this trace!');currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,FLING_IR_NAME);currentPE.pushEvent(event);currentPE.end=0;protoExpectations.push(currentPE);}break;case INPUT_TYPE.FLING_CANCEL:if(currentPE){currentPE.pushEvent(event);currentPE.end=event.start;currentPE=undefined;}else{var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}break;}});if(currentPE&&!currentPE.end)currentPE.end=modelHelper.model.bounds.max;return protoExpectations;}function handleTouchEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var sawFirstMove=false;forEventTypesIn(sortedInputEvents,TOUCH_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.TOUCH_START:if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TOUCH_IR_NAME);currentPE.pushEvent(event);currentPE.isAnimationBegin=true;protoExpectations.push(currentPE);sawFirstMove=false;}break;case INPUT_TYPE.TOUCH_MOVE:if(!currentPE){currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,TOUCH_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);break;}if(sawFirstMove&&currentPE.irType===ProtoExpectation.RESPONSE_TYPE||!currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){var prevEnd=currentPE.end;currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,TOUCH_IR_NAME);currentPE.pushEvent(event);currentPE.start=prevEnd;protoExpectations.push(currentPE);}else{currentPE.pushEvent(event);sawFirstMove=true;}break;case INPUT_TYPE.TOUCH_END:if(!currentPE){var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);break;}if(currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE.pushEvent(event);}else{var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}currentPE=undefined;break;}});return protoExpectations;}function handleScrollEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var sawFirstUpdate=false;forEventTypesIn(sortedInputEvents,SCROLL_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.SCROLL_BEGIN:currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,SCROLL_IR_NAME);currentPE.pushEvent(event);currentPE.isAnimationBegin=true;protoExpectations.push(currentPE);sawFirstUpdate=false;break;case INPUT_TYPE.SCROLL_UPDATE:if(currentPE){if(currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)&&(currentPE.irType===ProtoExpectation.ANIMATION_TYPE||!sawFirstUpdate)){currentPE.pushEvent(event);sawFirstUpdate=true;}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,SCROLL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,SCROLL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}break;case INPUT_TYPE.SCROLL_END:if(!currentPE){console.error('ScrollEnd without ScrollUpdate? '+'File a bug with this trace!');var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);break;}currentPE.pushEvent(event);break;}});return protoExpectations;}function handleVideoAnimations(modelHelper,sortedInputEvents){var events=[];for(var pid in modelHelper.rendererHelpers){for(var asyncSlice of modelHelper.rendererHelpers[pid].mainThread.asyncSliceGroup.slices){if(asyncSlice.title===PLAYBACK_EVENT_TITLE)events.push(asyncSlice);}}events.sort(tr.importer.compareEvents);var protoExpectations=[];for(var event of events){var currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,VIDEO_IR_NAME);currentPE.start=event.start;currentPE.end=event.end;currentPE.pushEvent(event);protoExpectations.push(currentPE);}return protoExpectations;}function handleCSSAnimations(modelHelper,sortedInputEvents){var animationEvents=modelHelper.browserHelper.getAllAsyncSlicesMatching(function(event){return event.title===CSS_ANIMATION_TITLE&&event.isTopLevel&&event.duration>0;});var animationRanges=[];function pushAnimationRange(start,end,animation){var range=tr.b.Range.fromExplicitRange(start,end);range.animation=animation;animationRanges.push(range);}animationEvents.forEach(function(animation){if(animation.subSlices.length===0){pushAnimationRange(animation.start,animation.end,animation);}else{var start=undefined;animation.subSlices.forEach(function(sub){if(sub.args.data.state==='running'&&start===undefined){start=sub.start;}else if(sub.args.data.state==='paused'||sub.args.data.state==='idle'||sub.args.data.state==='finished'){if(start===undefined){start=modelHelper.model.bounds.min;}pushAnimationRange(start,sub.start,animation);start=undefined;}});if(start!==undefined)pushAnimationRange(start,animation.end,animation);}});return animationRanges.map(function(range){var protoExpectation=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,CSS_IR_NAME);protoExpectation.start=range.min;protoExpectation.end=range.max;protoExpectation.associatedEvents.push(range.animation);return protoExpectation;});}function findWebGLEvents(modelHelper,mailboxEvents,animationEvents){for(var event of modelHelper.model.getDescendantEvents()){if(event.title==='DrawingBuffer::prepareMailbox')mailboxEvents.push(event);else if(event.title==='PageAnimator::serviceScriptedAnimations')animationEvents.push(event);}}function findMailboxEventsNearAnimationEvents(mailboxEvents,animationEvents){if(animationEvents.length===0)return[];mailboxEvents.sort(compareEvents);animationEvents.sort(compareEvents);var animationIterator=animationEvents[Symbol.iterator]();var animationEvent=animationIterator.next().value;var filteredEvents=[];for(var event of mailboxEvents){while(animationEvent&&animationEvent.start<event.start-ANIMATION_MERGE_THRESHOLD_MS)animationEvent=animationIterator.next().value;if(!animationEvent)break;if(animationEvent.start<event.start+ANIMATION_MERGE_THRESHOLD_MS)filteredEvents.push(event);}return filteredEvents;}function createProtoExpectationsFromMailboxEvents(mailboxEvents){var protoExpectations=[];var currentPE=undefined;for(var event of mailboxEvents){if(currentPE===undefined||!currentPE.isNear(event,ANIMATION_MERGE_THRESHOLD_MS)){currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,WEBGL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}else{currentPE.pushEvent(event);}}return protoExpectations;}function handleWebGLAnimations(modelHelper,sortedInputEvents){var prepareMailboxEvents=[];var scriptedAnimationEvents=[];findWebGLEvents(modelHelper,prepareMailboxEvents,scriptedAnimationEvents);var webGLMailboxEvents=findMailboxEventsNearAnimationEvents(prepareMailboxEvents,scriptedAnimationEvents);return createProtoExpectationsFromMailboxEvents(webGLMailboxEvents);}function postProcessProtoExpectations(modelHelper,protoExpectations){protoExpectations=findFrameEventsForAnimations(modelHelper,protoExpectations);protoExpectations=mergeIntersectingResponses(protoExpectations);protoExpectations=mergeIntersectingAnimations(protoExpectations);protoExpectations=fixResponseAnimationStarts(protoExpectations);protoExpectations=fixTapResponseTouchAnimations(protoExpectations);return protoExpectations;}function mergeIntersectingResponses(protoExpectations){var newPEs=[];while(protoExpectations.length){var pe=protoExpectations.shift();newPEs.push(pe);if(pe.irType!==ProtoExpectation.RESPONSE_TYPE)continue;for(var i=0;i<protoExpectations.length;++i){var otherPE=protoExpectations[i];if(otherPE.irType!==pe.irType)continue;if(!otherPE.intersects(pe))continue;var typeNames=pe.associatedEvents.map(function(event){return event.typeName;});if(otherPE.containsTypeNames(typeNames))continue;pe.merge(otherPE);protoExpectations.splice(i,1);--i;}}return newPEs;}function mergeIntersectingAnimations(protoExpectations){var newPEs=[];while(protoExpectations.length){var pe=protoExpectations.shift();newPEs.push(pe);if(pe.irType!==ProtoExpectation.ANIMATION_TYPE)continue;var isCSS=pe.containsSliceTitle(CSS_ANIMATION_TITLE);var isFling=pe.containsTypeNames([INPUT_TYPE.FLING_START]);var isVideo=pe.containsTypeNames([VIDEO_IR_NAME]);for(var i=0;i<protoExpectations.length;++i){var otherPE=protoExpectations[i];if(otherPE.irType!==pe.irType)continue;if(isCSS!=otherPE.containsSliceTitle(CSS_ANIMATION_TITLE))continue;if(isCSS){if(!pe.isNear(otherPE,ANIMATION_MERGE_THRESHOLD_MS))continue;}else if(!otherPE.intersects(pe)){continue;}if(isFling!==otherPE.containsTypeNames([INPUT_TYPE.FLING_START]))continue;if(isVideo!==otherPE.containsTypeNames([VIDEO_IR_NAME]))continue;pe.merge(otherPE);protoExpectations.splice(i,1);--i;}}return newPEs;}function fixResponseAnimationStarts(protoExpectations){protoExpectations.forEach(function(ape){if(ape.irType!==ProtoExpectation.ANIMATION_TYPE)return;protoExpectations.forEach(function(rpe){if(rpe.irType!==ProtoExpectation.RESPONSE_TYPE)return;if(!ape.containsTimestampInclusive(rpe.end))return;if(ape.containsTimestampInclusive(rpe.start))return;ape.start=rpe.end;});});return protoExpectations;}function fixTapResponseTouchAnimations(protoExpectations){function isTapResponse(pe){return pe.irType===ProtoExpectation.RESPONSE_TYPE&&pe.containsTypeNames([INPUT_TYPE.TAP]);}function isTouchAnimation(pe){return pe.irType===ProtoExpectation.ANIMATION_TYPE&&pe.containsTypeNames([INPUT_TYPE.TOUCH_MOVE])&&!pe.containsTypeNames([INPUT_TYPE.SCROLL_UPDATE,INPUT_TYPE.PINCH_UPDATE]);}var newPEs=[];while(protoExpectations.length){var pe=protoExpectations.shift();newPEs.push(pe);var peIsTapResponse=isTapResponse(pe);var peIsTouchAnimation=isTouchAnimation(pe);if(!peIsTapResponse&&!peIsTouchAnimation)continue;for(var i=0;i<protoExpectations.length;++i){var otherPE=protoExpectations[i];if(!otherPE.intersects(pe))continue;if(peIsTapResponse&&!isTouchAnimation(otherPE))continue;if(peIsTouchAnimation&&!isTapResponse(otherPE))continue;pe.irType=ProtoExpectation.RESPONSE_TYPE;pe.merge(otherPE);protoExpectations.splice(i,1);--i;}}return newPEs;}function findFrameEventsForAnimations(modelHelper,protoExpectations){var newPEs=[];var frameEventsByPid=getSortedFrameEventsByProcess(modelHelper);for(var pe of protoExpectations){if(pe.irType!==ProtoExpectation.ANIMATION_TYPE){newPEs.push(pe);continue;}var frameEvents=[];for(var pid of Object.keys(modelHelper.rendererHelpers)){var range=tr.b.Range.fromExplicitRange(pe.start,pe.end);frameEvents.push.apply(frameEvents,range.filterArray(frameEventsByPid[pid],e=>e.start));}if(frameEvents.length===0&&!pe.names.has(WEBGL_IR_NAME)){pe.irType=ProtoExpectation.IGNORED_TYPE;newPEs.push(pe);continue;}pe.associatedEvents.addEventSet(frameEvents);newPEs.push(pe);}return newPEs;}function checkAllInputEventsHandled(sortedInputEvents,protoExpectations){var handledEvents=[];protoExpectations.forEach(function(protoExpectation){protoExpectation.associatedEvents.forEach(function(event){if(event.title===CSS_ANIMATION_TITLE&&event.subSlices.length>0)return;if(handledEvents.indexOf(event)>=0&&event.title!==tr.model.helpers.IMPL_RENDERING_STATS){console.error('double-handled event',event.typeName,parseInt(event.start),parseInt(event.end),protoExpectation);return;}handledEvents.push(event);});});sortedInputEvents.forEach(function(event){if(handledEvents.indexOf(event)<0){console.error('UNHANDLED INPUT EVENT!',event.typeName,parseInt(event.start),parseInt(event.end));}});}function findInputExpectations(modelHelper){var sortedInputEvents=getSortedInputEvents(modelHelper);var protoExpectations=findProtoExpectations(modelHelper,sortedInputEvents);protoExpectations=postProcessProtoExpectations(modelHelper,protoExpectations);checkAllInputEventsHandled(sortedInputEvents,protoExpectations);var irs=[];protoExpectations.forEach(function(protoExpectation){var ir=protoExpectation.createInteractionRecord(modelHelper.model);if(ir)irs.push(ir);});return irs;}return{findInputExpectations:findInputExpectations,compareEvents:compareEvents,CSS_ANIMATION_TITLE:CSS_ANIMATION_TITLE};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range_utils.js":54,"../extras/chrome/cc/input_latency_async_slice.js":68,"./proto_expectation.js":83}],79:[function(require,module,exports){(function(global){"use strict";require("../model/user_model/load_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){var NAVIGATION_START='NavigationTiming navigationStart';var FIRST_CONTENTFUL_PAINT_TITLE='firstContentfulPaint';function findLoadExpectations(modelHelper){var events=[];for(var event of modelHelper.model.getDescendantEvents()){if(event.title===NAVIGATION_START||event.title===FIRST_CONTENTFUL_PAINT_TITLE)events.push(event);}events.sort(tr.importer.compareEvents);var loads=[];var startEvent=undefined;for(var event of events){if(event.title===NAVIGATION_START){startEvent=event;}else if(event.title===FIRST_CONTENTFUL_PAINT_TITLE){if(startEvent){loads.push(new tr.model.um.LoadExpectation(modelHelper.model,tr.model.um.LOAD_SUBTYPE_NAMES.SUCCESSFUL,startEvent.start,event.start-startEvent.start));startEvent=undefined;}}}if(startEvent){loads.push(new tr.model.um.LoadExpectation(modelHelper.model,tr.model.um.LOAD_SUBTYPE_NAMES.SUCCESSFUL,startEvent.start,modelHelper.model.bounds.max-startEvent.start));}return loads;}return{findLoadExpectations:findLoadExpectations};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../model/user_model/load_expectation.js":169}],80:[function(require,module,exports){(function(global){"use strict";require("../model/user_model/startup_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){function getAllFrameEvents(modelHelper){var frameEvents=[];frameEvents.push.apply(frameEvents,modelHelper.browserHelper.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE,modelHelper.model.bounds));tr.b.iterItems(modelHelper.rendererHelpers,function(pid,renderer){frameEvents.push.apply(frameEvents,renderer.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE,modelHelper.model.bounds));});return frameEvents.sort(tr.importer.compareEvents);}function getStartupEvents(modelHelper){function isStartupSlice(slice){return slice.title==='BrowserMainLoop::CreateThreads';}var events=modelHelper.browserHelper.getAllAsyncSlicesMatching(isStartupSlice);var deduper=new tr.model.EventSet();events.forEach(function(event){var sliceGroup=event.parentContainer.sliceGroup;var slice=sliceGroup&&sliceGroup.findFirstSlice();if(slice)deduper.push(slice);});return deduper.toArray();}function findStartupExpectations(modelHelper){var openingEvents=getStartupEvents(modelHelper);var closingEvents=getAllFrameEvents(modelHelper);var startups=[];openingEvents.forEach(function(openingEvent){closingEvents.forEach(function(closingEvent){if(openingEvent.closingEvent)return;if(closingEvent.openingEvent)return;if(closingEvent.start<=openingEvent.start)return;if(openingEvent.parentContainer.parent.pid!==closingEvent.parentContainer.parent.pid)return;openingEvent.closingEvent=closingEvent;closingEvent.openingEvent=openingEvent;var se=new tr.model.um.StartupExpectation(modelHelper.model,openingEvent.start,closingEvent.end-openingEvent.start);se.associatedEvents.push(openingEvent);se.associatedEvents.push(closingEvent);startups.push(se);});});return startups;}return{findStartupExpectations:findStartupExpectations};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../model/user_model/startup_expectation.js":171}],81:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/timing.js");require("./empty_importer.js");require("./importer.js");require("./user_model_builder.js");require("../ui/base/overlay.js");'use strict';global.tr.exportTo('tr.importer',function(){var Timing=tr.b.Timing;function ImportOptions(){this.shiftWorldToZero=true;this.pruneEmptyContainers=true;this.showImportWarnings=true;this.trackDetailedModelStats=false;this.customizeModelCallback=undefined;var auditorTypes=tr.c.Auditor.getAllRegisteredTypeInfos();this.auditorConstructors=auditorTypes.map(function(typeInfo){return typeInfo.constructor;});}function Import(model,opt_options){if(model===undefined)throw new Error('Must provide model to import into.');this.importing_=false;this.importOptions_=opt_options||new ImportOptions();this.model_=model;this.model_.importOptions=this.importOptions_;}Import.prototype={__proto__:Object.prototype,importTraces:function(traces){var progressMeter={update:function(msg){}};tr.b.Task.RunSynchronously(this.createImportTracesTask(progressMeter,traces));},importTracesWithProgressDialog:function(traces){if(tr.isHeadless)throw new Error('Cannot use this method in headless mode.');var overlay=tr.ui.b.Overlay();overlay.title='Importing...';overlay.userCanClose=false;overlay.msgEl=document.createElement('div');Polymer.dom(overlay).appendChild(overlay.msgEl);overlay.msgEl.style.margin='20px';overlay.update=function(msg){Polymer.dom(this.msgEl).textContent=msg;};overlay.visible=true;var promise=tr.b.Task.RunWhenIdle(this.createImportTracesTask(overlay,traces));promise.then(function(){overlay.visible=false;},function(err){overlay.visible=false;});return promise;},createImportTracesTask:function(progressMeter,traces){if(this.importing_)throw new Error('Already importing.');this.importing_=true;var importTask=new tr.b.Task(function prepareImport(){progressMeter.update('I will now import your traces for you...');},this);var lastTask=importTask;var importers=[];lastTask=lastTask.timedAfter('TraceImport',function createImports(){traces=traces.slice(0);progressMeter.update('Creating importers...');for(var i=0;i<traces.length;++i)importers.push(this.createImporter_(traces[i]));for(var i=0;i<importers.length;i++){var subtraces=importers[i].extractSubtraces();for(var j=0;j<subtraces.length;j++){try{traces.push(subtraces[j]);importers.push(this.createImporter_(subtraces[j]));}catch(error){console.warn(error.name+': '+error.message);continue;}}}if(traces.length&&!this.hasEventDataDecoder_(importers)){throw new Error('Could not find an importer for the provided eventData.');}importers.sort(function(x,y){return x.importPriority-y.importPriority;});},this);lastTask=lastTask.timedAfter('TraceImport',function importClockSyncMarkers(task){importers.forEach(function(importer,index){task.subTask(Timing.wrapNamedFunction('TraceImport',importer.importerName,function runImportClockSyncMarkersOnOneImporter(){progressMeter.update('Importing clock sync markers '+(index+1)+' of '+importers.length);importer.importClockSyncMarkers();}),this);},this);},this);lastTask=lastTask.timedAfter('TraceImport',function runImport(task){importers.forEach(function(importer,index){task.subTask(Timing.wrapNamedFunction('TraceImport',importer.importerName,function runImportEventsOnOneImporter(){progressMeter.update('Importing '+(index+1)+' of '+importers.length);importer.importEvents();}),this);},this);},this);if(this.importOptions_.customizeModelCallback){lastTask=lastTask.timedAfter('TraceImport',function runCustomizeCallbacks(task){this.importOptions_.customizeModelCallback(this.model_);},this);}lastTask=lastTask.timedAfter('TraceImport',function importSampleData(task){importers.forEach(function(importer,index){progressMeter.update('Importing sample data '+(index+1)+'/'+importers.length);importer.importSampleData();},this);},this);lastTask=lastTask.timedAfter('TraceImport',function runAutoclosers(){progressMeter.update('Autoclosing open slices...');this.model_.autoCloseOpenSlices();this.model_.createSubSlices();},this);lastTask=lastTask.timedAfter('TraceImport',function finalizeImport(task){importers.forEach(function(importer,index){progressMeter.update('Finalizing import '+(index+1)+'/'+importers.length);importer.finalizeImport();},this);},this);lastTask=lastTask.timedAfter('TraceImport',function runPreinits(){progressMeter.update('Initializing objects (step 1/2)...');this.model_.preInitializeObjects();},this);if(this.importOptions_.pruneEmptyContainers){lastTask=lastTask.timedAfter('TraceImport',function runPruneEmptyContainers(){progressMeter.update('Pruning empty containers...');this.model_.pruneEmptyContainers();},this);}lastTask=lastTask.timedAfter('TraceImport',function runMergeKernelWithuserland(){progressMeter.update('Merging kernel with userland...');this.model_.mergeKernelWithUserland();},this);var auditors=[];lastTask=lastTask.timedAfter('TraceImport',function createAuditorsAndRunAnnotate(){progressMeter.update('Adding arbitrary data to model...');auditors=this.importOptions_.auditorConstructors.map(function(auditorConstructor){return new auditorConstructor(this.model_);},this);auditors.forEach(function(auditor){auditor.runAnnotate();auditor.installUserFriendlyCategoryDriverIfNeeded();});},this);lastTask=lastTask.timedAfter('TraceImport',function computeWorldBounds(){progressMeter.update('Computing final world bounds...');this.model_.computeWorldBounds(this.importOptions_.shiftWorldToZero);},this);lastTask=lastTask.timedAfter('TraceImport',function buildFlowEventIntervalTree(){progressMeter.update('Building flow event map...');this.model_.buildFlowEventIntervalTree();},this);lastTask=lastTask.timedAfter('TraceImport',function joinRefs(){progressMeter.update('Joining object refs...');this.model_.joinRefs();},this);lastTask=lastTask.timedAfter('TraceImport',function cleanupUndeletedObjects(){progressMeter.update('Cleaning up undeleted objects...');this.model_.cleanupUndeletedObjects();},this);lastTask=lastTask.timedAfter('TraceImport',function sortMemoryDumps(){progressMeter.update('Sorting memory dumps...');this.model_.sortMemoryDumps();},this);lastTask=lastTask.timedAfter('TraceImport',function finalizeMemoryGraphs(){progressMeter.update('Finalizing memory dump graphs...');this.model_.finalizeMemoryGraphs();},this);lastTask=lastTask.timedAfter('TraceImport',function initializeObjects(){progressMeter.update('Initializing objects (step 2/2)...');this.model_.initializeObjects();},this);lastTask=lastTask.timedAfter('TraceImport',function buildEventIndices(){progressMeter.update('Building event indices...');this.model_.buildEventIndices();},this);lastTask=lastTask.timedAfter('TraceImport',function buildUserModel(){progressMeter.update('Building UserModel...');var userModelBuilder=new tr.importer.UserModelBuilder(this.model_);userModelBuilder.buildUserModel();},this);lastTask=lastTask.timedAfter('TraceImport',function sortExpectations(){progressMeter.update('Sorting user expectations...');this.model_.userModel.sortExpectations();},this);lastTask=lastTask.timedAfter('TraceImport',function runAudits(){progressMeter.update('Running auditors...');auditors.forEach(function(auditor){auditor.runAudit();});},this);lastTask=lastTask.timedAfter('TraceImport',function sortAlerts(){progressMeter.update('Updating alerts...');this.model_.sortAlerts();},this);lastTask=lastTask.timedAfter('TraceImport',function lastUpdateBounds(){progressMeter.update('Update bounds...');this.model_.updateBounds();},this);lastTask=lastTask.timedAfter('TraceImport',function addModelWarnings(){progressMeter.update('Looking for warnings...');if(!this.model_.isTimeHighResolution){this.model_.importWarning({type:'low_resolution_timer',message:'Trace time is low resolution, trace may be unusable.',showToUser:true});}},this);lastTask.after(function(){this.importing_=false;},this);return importTask;},createImporter_:function(eventData){var importerConstructor=tr.importer.Importer.findImporterFor(eventData);if(!importerConstructor){throw new Error('Couldn\'t create an importer for the provided '+'eventData.');}return new importerConstructor(this.model_,eventData);},hasEventDataDecoder_:function(importers){for(var i=0;i<importers.length;++i){if(!importers[i].isTraceDataContainer())return true;}return false;}};return{ImportOptions:ImportOptions,Import:Import};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/timing.js":62,"../ui/base/overlay.js":180,"./empty_importer.js":77,"./importer.js":82,"./user_model_builder.js":84}],82:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/extension_registry.js");'use strict';global.tr.exportTo('tr.importer',function(){function Importer(){}Importer.prototype={__proto__:Object.prototype,get importerName(){return'Importer';},isTraceDataContainer:function(){return false;},extractSubtraces:function(){return[];},importClockSyncMarkers:function(){},importEvents:function(){},importSampleData:function(){},finalizeImport:function(){}};var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);options.defaultMetadata={};options.mandatoryBaseClass=Importer;tr.b.decorateExtensionRegistry(Importer,options);Importer.findImporterFor=function(eventData){var typeInfo=Importer.findTypeInfoMatching(function(ti){return ti.constructor.canImport(eventData);});if(typeInfo)return typeInfo.constructor;return undefined;};return{Importer:Importer};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/extension_registry.js":41}],83:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/range_utils.js");require("../core/auditor.js");require("../model/event_info.js");require("../model/user_model/animation_expectation.js");require("../model/user_model/response_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){function ProtoExpectation(irType,name){this.irType=irType;this.names=new Set(name?[name]:undefined);this.start=Infinity;this.end=-Infinity;this.associatedEvents=new tr.model.EventSet();this.isAnimationBegin=false;}ProtoExpectation.RESPONSE_TYPE='r';ProtoExpectation.ANIMATION_TYPE='a';ProtoExpectation.IGNORED_TYPE='ignored';ProtoExpectation.prototype={get isValid(){return this.end>this.start;},containsTypeNames:function(typeNames){return this.associatedEvents.some(x=>typeNames.indexOf(x.typeName)>=0);},containsSliceTitle:function(title){return this.associatedEvents.some(x=>title===x.title);},createInteractionRecord:function(model){if(!this.isValid){console.error('Invalid ProtoExpectation: '+this.debug()+' File a bug with this trace!');return undefined;}var initiatorTitles=[];this.names.forEach(function(name){initiatorTitles.push(name);});initiatorTitles=initiatorTitles.sort().join(',');var duration=this.end-this.start;var ir=undefined;switch(this.irType){case ProtoExpectation.RESPONSE_TYPE:ir=new tr.model.um.ResponseExpectation(model,initiatorTitles,this.start,duration,this.isAnimationBegin);break;case ProtoExpectation.ANIMATION_TYPE:ir=new tr.model.um.AnimationExpectation(model,initiatorTitles,this.start,duration);break;}if(!ir)return undefined;ir.sourceEvents.addEventSet(this.associatedEvents);function pushAssociatedEvents(event){ir.associatedEvents.push(event);if(event.associatedEvents)ir.associatedEvents.addEventSet(event.associatedEvents);}this.associatedEvents.forEach(function(event){pushAssociatedEvents(event);if(event.subSlices)event.subSlices.forEach(pushAssociatedEvents);});return ir;},merge:function(other){other.names.forEach(function(name){this.names.add(name);}.bind(this));this.associatedEvents.addEventSet(other.associatedEvents);this.start=Math.min(this.start,other.start);this.end=Math.max(this.end,other.end);if(other.isAnimationBegin)this.isAnimationBegin=true;},pushEvent:function(event){this.start=Math.min(this.start,event.start);this.end=Math.max(this.end,event.end);this.associatedEvents.push(event);},containsTimestampInclusive:function(timestamp){return this.start<=timestamp&&timestamp<=this.end;},intersects:function(other){return other.start<this.end&&other.end>this.start;},isNear:function(event,threshold){return this.end+threshold>event.start;},debug:function(){var debugString=this.irType+'(';debugString+=parseInt(this.start)+' ';debugString+=parseInt(this.end);this.associatedEvents.forEach(function(event){debugString+=' '+event.typeName;});return debugString+')';}};return{ProtoExpectation:ProtoExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/range_utils.js":54,"../core/auditor.js":66,"../model/event_info.js":124,"../model/user_model/animation_expectation.js":167,"../model/user_model/response_expectation.js":170}],84:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/range_utils.js");require("../core/auditor.js");require("../extras/chrome/cc/input_latency_async_slice.js");require("./find_input_expectations.js");require("./find_load_expectations.js");require("./find_startup_expectations.js");require("../model/event_info.js");require("../model/ir_coverage.js");require("../model/user_model/idle_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){var INSIGNIFICANT_MS=1;function UserModelBuilder(model){this.model=model;this.modelHelper=model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);};UserModelBuilder.supportsModelHelper=function(modelHelper){return modelHelper.browserHelper!==undefined;};UserModelBuilder.prototype={buildUserModel:function(){if(!this.modelHelper||!this.modelHelper.browserHelper)return;var expectations=undefined;try{expectations=this.findUserExpectations();}catch(error){this.model.importWarning({type:'UserModelBuilder',message:error,showToUser:true});return;}expectations.forEach(function(expectation){this.model.userModel.expectations.push(expectation);},this);},findUserExpectations:function(){var expectations=[];expectations.push.apply(expectations,tr.importer.findStartupExpectations(this.modelHelper));expectations.push.apply(expectations,tr.importer.findLoadExpectations(this.modelHelper));expectations.push.apply(expectations,tr.importer.findInputExpectations(this.modelHelper));expectations.push.apply(expectations,this.findIdleExpectations(expectations));this.collectUnassociatedEvents_(expectations);return expectations;},collectUnassociatedEvents_:function(rirs){var vacuumIRs=[];rirs.forEach(function(ir){if(ir instanceof tr.model.um.IdleExpectation||ir instanceof tr.model.um.LoadExpectation||ir instanceof tr.model.um.StartupExpectation)vacuumIRs.push(ir);});if(vacuumIRs.length===0)return;var allAssociatedEvents=tr.model.getAssociatedEvents(rirs);var unassociatedEvents=tr.model.getUnassociatedEvents(this.model,allAssociatedEvents);unassociatedEvents.forEach(function(event){if(!(event instanceof tr.model.ThreadSlice))return;if(!event.isTopLevel)return;for(var iri=0;iri<vacuumIRs.length;++iri){var ir=vacuumIRs[iri];if(event.start>=ir.start&&event.start<ir.end){ir.associatedEvents.addEventSet(event.entireHierarchy);return;}}});},findIdleExpectations:function(otherIRs){if(this.model.bounds.isEmpty)return;var emptyRanges=tr.b.findEmptyRangesBetweenRanges(tr.b.convertEventsToRanges(otherIRs),this.model.bounds);var irs=[];var model=this.model;emptyRanges.forEach(function(range){if(range.max<range.min+INSIGNIFICANT_MS)return;irs.push(new tr.model.um.IdleExpectation(model,range.min,range.max-range.min));});return irs;}};function createCustomizeModelLinesFromModel(model){var modelLines=[];modelLines.push('      audits.addEvent(model.browserMain,');modelLines.push('          {title: \'model start\', start: 0, end: 1});');var typeNames={};for(var typeName in tr.e.cc.INPUT_EVENT_TYPE_NAMES){typeNames[tr.e.cc.INPUT_EVENT_TYPE_NAMES[typeName]]=typeName;}var modelEvents=new tr.model.EventSet();model.userModel.expectations.forEach(function(ir,index){modelEvents.addEventSet(ir.sourceEvents);});modelEvents=modelEvents.toArray();modelEvents.sort(tr.importer.compareEvents);modelEvents.forEach(function(event){var startAndEnd='start: '+parseInt(event.start)+', '+'end: '+parseInt(event.end)+'});';if(event instanceof tr.e.cc.InputLatencyAsyncSlice){modelLines.push('      audits.addInputEvent(model, INPUT_TYPE.'+typeNames[event.typeName]+',');}else if(event.title==='RenderFrameImpl::didCommitProvisionalLoad'){modelLines.push('      audits.addCommitLoadEvent(model,');}else if(event.title==='InputHandlerProxy::HandleGestureFling::started'){modelLines.push('      audits.addFlingAnimationEvent(model,');}else if(event.title===tr.model.helpers.IMPL_RENDERING_STATS){modelLines.push('      audits.addFrameEvent(model,');}else if(event.title===tr.importer.CSS_ANIMATION_TITLE){modelLines.push('      audits.addEvent(model.rendererMain, {');modelLines.push('        title: \'Animation\', '+startAndEnd);return;}else{throw'You must extend createCustomizeModelLinesFromModel()'+'to support this event:\n'+event.title+'\n';}modelLines.push('          {'+startAndEnd);});modelLines.push('      audits.addEvent(model.browserMain,');modelLines.push('          {'+'title: \'model end\', '+'start: '+(parseInt(model.bounds.max)-1)+', '+'end: '+parseInt(model.bounds.max)+'});');return modelLines;}function createExpectedIRLinesFromModel(model){var expectedLines=[];var irCount=model.userModel.expectations.length;model.userModel.expectations.forEach(function(ir,index){var irString='      {';irString+='title: \''+ir.title+'\', ';irString+='start: '+parseInt(ir.start)+', ';irString+='end: '+parseInt(ir.end)+', ';irString+='eventCount: '+ir.sourceEvents.length;irString+='}';if(index<irCount-1)irString+=',';expectedLines.push(irString);});return expectedLines;}function createIRFinderTestCaseStringFromModel(model){var filename=window.location.hash.substr(1);var testName=filename.substr(filename.lastIndexOf('/')+1);testName=testName.substr(0,testName.indexOf('.'));try{var testLines=[];testLines.push('  /*');testLines.push('    This test was generated from');testLines.push('    '+filename+'');testLines.push('   */');testLines.push('  test(\''+testName+'\', function() {');testLines.push('    var verifier = new UserExpectationVerifier();');testLines.push('    verifier.customizeModelCallback = function(model) {');testLines.push.apply(testLines,createCustomizeModelLinesFromModel(model));testLines.push('    };');testLines.push('    verifier.expectedIRs = [');testLines.push.apply(testLines,createExpectedIRLinesFromModel(model));testLines.push('    ];');testLines.push('    verifier.verify();');testLines.push('  });');return testLines.join('\n');}catch(error){return error;}}return{UserModelBuilder:UserModelBuilder,createIRFinderTestCaseStringFromModel:createIRFinderTestCaseStringFromModel};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/range_utils.js":54,"../core/auditor.js":66,"../extras/chrome/cc/input_latency_async_slice.js":68,"../model/event_info.js":124,"../model/ir_coverage.js":137,"../model/user_model/idle_expectation.js":168,"./find_input_expectations.js":78,"./find_load_expectations.js":79,"./find_startup_expectations.js":80}],85:[function(require,module,exports){"use strict";require("./importer/import.js");require("./model/model.js");require("./extras/lean_config.js");require("./metrics/all_metrics.js");},{"./extras/lean_config.js":75,"./importer/import.js":81,"./metrics/all_metrics.js":86,"./model/model.js":141}],86:[function(require,module,exports){"use strict";require("./blink/gc_metric.js");require("./cpu_process_metric.js");require("./sample_metric.js");require("./system_health/clock_sync_latency_metric.js");require("./system_health/hazard_metric.js");require("./system_health/loading_metric.js");require("./system_health/memory_metric.js");require("./system_health/power_metric.js");require("./system_health/responsiveness_metric.js");require("./system_health/system_health_metrics.js");require("./system_health/webview_startup_metric.js");require("./tracing_metric.js");require("./v8/execution_metric.js");require("./v8/gc_metric.js");require("./v8/v8_metrics.js");},{"./blink/gc_metric.js":87,"./cpu_process_metric.js":88,"./sample_metric.js":90,"./system_health/clock_sync_latency_metric.js":91,"./system_health/hazard_metric.js":93,"./system_health/loading_metric.js":94,"./system_health/memory_metric.js":96,"./system_health/power_metric.js":97,"./system_health/responsiveness_metric.js":98,"./system_health/system_health_metrics.js":99,"./system_health/webview_startup_metric.js":101,"./tracing_metric.js":102,"./v8/execution_metric.js":103,"./v8/gc_metric.js":104,"./v8/v8_metrics.js":106}],87:[function(require,module,exports){(function(global){"use strict";require("../../base/range.js");require("../../base/unit.js");require("../metric_registry.js");require("../v8/utils.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.blink',function(){var BLINK_GC_EVENTS={'BlinkGCMarking':'blink-gc-marking','ThreadState::completeSweep':'blink-gc-complete-sweep','ThreadState::performIdleLazySweep':'blink-gc-idle-lazy-sweep'};function isBlinkGarbageCollectionEvent(event){return event.title in BLINK_GC_EVENTS;}function blinkGarbageCollectionEventName(event){return BLINK_GC_EVENTS[event.title];}function blinkGcMetric(values,model){addDurationOfTopEvents(values,model);addTotalDurationOfTopEvents(values,model);addIdleTimesOfTopEvents(values,model);addTotalIdleTimesOfTopEvents(values,model);}tr.metrics.MetricRegistry.register(blinkGcMetric);var timeDurationInMs_smallerIsBetter=tr.b.Unit.byName.timeDurationInMs_smallerIsBetter;var percentage_biggerIsBetter=tr.b.Unit.byName.normalizedPercentage_biggerIsBetter;var CUSTOM_BOUNDARIES=tr.v.HistogramBinBoundaries.createLinear(0,20,200).addExponentialBins(200,100);function createNumericForTopEventTime(name){var n=new tr.v.Histogram(name,timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);n.customizeSummaryOptions({avg:true,count:true,max:true,min:false,std:true,sum:true,percentile:[0.90]});return n;}function createNumericForIdleTime(name){var n=new tr.v.Histogram(name,timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);n.customizeSummaryOptions({avg:true,count:false,max:true,min:false,std:false,sum:true,percentile:[]});return n;}function createPercentage(name,numerator,denominator){var histogram=new tr.v.Histogram(name,percentage_biggerIsBetter);if(denominator===0)histogram.addSample(0);else histogram.addSample(numerator/denominator);return histogram;}function addDurationOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isBlinkGarbageCollectionEvent,blinkGarbageCollectionEventName,function(name,events){var cpuDuration=createNumericForTopEventTime(name);events.forEach(function(event){cpuDuration.addSample(event.cpuDuration);});values.addHistogram(cpuDuration);});}function addTotalDurationOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isBlinkGarbageCollectionEvent,event=>'blink-gc-total',function(name,events){var cpuDuration=createNumericForTopEventTime(name);events.forEach(function(event){cpuDuration.addSample(event.cpuDuration);});values.addHistogram(cpuDuration);});}function addIdleTimesOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isBlinkGarbageCollectionEvent,blinkGarbageCollectionEventName,function(name,events){addIdleTimes(values,model,name,events);});}function addTotalIdleTimesOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isBlinkGarbageCollectionEvent,event=>'blink-gc-total',function(name,events){addIdleTimes(values,model,name,events);});}function addIdleTimes(values,model,name,events){var cpuDuration=createNumericForIdleTime(name+'_cpu');var insideIdle=createNumericForIdleTime(name+'_inside_idle');var outsideIdle=createNumericForIdleTime(name+'_outside_idle');var idleDeadlineOverrun=createNumericForIdleTime(name+'_idle_deadline_overrun');events.forEach(function(event){var idleTask=tr.metrics.v8.utils.findParent(event,tr.metrics.v8.utils.isIdleTask);var inside=0;var overrun=0;if(idleTask){var allottedTime=idleTask['args']['allotted_time_ms'];if(event.duration>allottedTime){overrun=event.duration-allottedTime;inside=event.cpuDuration*allottedTime/event.duration;}else{inside=event.cpuDuration;}}cpuDuration.addSample(event.cpuDuration);insideIdle.addSample(inside);outsideIdle.addSample(event.cpuDuration-inside);idleDeadlineOverrun.addSample(overrun);});values.addHistogram(idleDeadlineOverrun);values.addHistogram(outsideIdle);var percentage=createPercentage(name+'_percentage_idle',insideIdle.sum,cpuDuration.sum);values.addHistogram(percentage);}return{blinkGcMetric:blinkGcMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/range.js":53,"../../base/unit.js":63,"../../value/histogram.js":195,"../metric_registry.js":89,"../v8/utils.js":105}],88:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("./metric_registry.js");require("../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){function getCpuSnapshotsFromModel(model){var snapshots=[];for(var pid in model.processes){var snapshotInstances=model.processes[pid].objects.getAllInstancesNamed('CPUSnapshots');if(!snapshotInstances)continue;for(var object of snapshotInstances[0].snapshots)snapshots.push(object.args.processes);}return snapshots;}function getProcessSumsFromSnapshot(snapshot){var processSums=new Map();for(var processData of snapshot){var processName=processData.name;if(!processSums.has(processName))processSums.set(processName,{sum:0.0,paths:new Set()});processSums.get(processName).sum+=parseFloat(processData.pCpu);if(processData.path)processSums.get(processName).paths.add(processData.path);}return processSums;}function buildNumericsFromSnapshots(snapshots){var processNumerics=new Map();for(var snapshot of snapshots){var processSums=getProcessSumsFromSnapshot(snapshot);for(var _ref of processSums.entries()){var _ref2=_slicedToArray(_ref,2);var processName=_ref2[0];var processData=_ref2[1];if(!processNumerics.has(processName)){processNumerics.set(processName,{numeric:new tr.v.Histogram('cpu:percent:'+processName,tr.b.Unit.byName.normalizedPercentage_smallerIsBetter),paths:new Set()});}processNumerics.get(processName).numeric.addSample(processData.sum/100.0);for(var path of processData.paths)processNumerics.get(processName).paths.add(path);}}return processNumerics;}function cpuProcessMetric(values,model){var snapshots=getCpuSnapshotsFromModel(model);var processNumerics=buildNumericsFromSnapshots(snapshots);for(var _ref3 of processNumerics){var _ref4=_slicedToArray(_ref3,2);var processName=_ref4[0];var processData=_ref4[1];var numeric=processData.numeric;var missingSnapshotCount=snapshots.length-numeric.numValues;for(var i=0;i<missingSnapshotCount;i++)numeric.addSample(0);numeric.diagnostics.set('paths',new tr.v.d.Generic([...processData.paths]));values.addHistogram(numeric);}}tr.metrics.MetricRegistry.register(cpuProcessMetric);return{cpuProcessMetric:cpuProcessMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../value/histogram.js":195,"./metric_registry.js":89}],89:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/extension_registry.js");require("../base/iteration_helpers.js");'use strict';global.tr.exportTo('tr.metrics',function(){function MetricRegistry(){}var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);options.defaultMetadata={};tr.b.decorateExtensionRegistry(MetricRegistry,options);MetricRegistry.addEventListener('will-register',function(e){var metric=e.typeInfo.constructor;if(!(metric instanceof Function))throw new Error('Metrics must be functions');if(metric.length<2){throw new Error('Metrics take a ValueSet and a Model and '+'optionally an options dictionary');}});return{MetricRegistry:MetricRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/extension_registry.js":41,"../base/iteration_helpers.js":47}],90:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("./metric_registry.js");require("../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics',function(){function sampleMetric(values,model){var hist=new tr.v.Histogram('foo',tr.b.Unit.byName.sizeInBytes_smallerIsBetter);hist.addSample(9);hist.addSample(91,{bar:new tr.v.d.Generic({hello:42})});for(var expectation of model.userModel.expectations){if(expectation instanceof tr.model.um.ResponseExpectation){}else if(expectation instanceof tr.model.um.AnimationExpectation){}else if(expectation instanceof tr.model.um.IdleExpectation){}else if(expectation instanceof tr.model.um.LoadExpectation){}}var chromeHelper=model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);tr.b.iterItems(model.processes,function(pid,process){});values.addHistogram(hist);}tr.metrics.MetricRegistry.register(sampleMetric);return{sampleMetric:sampleMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"../value/histogram.js":195,"./metric_registry.js":89}],91:[function(require,module,exports){(function(global){"use strict";require("../metric_registry.js");require("./utils.js");require("../../model/model.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){function syncIsComplete(markers){return markers.length===2;}function syncInvolvesTelemetry(markers){for(var marker of markers)if(marker.domainId===tr.model.ClockDomainId.TELEMETRY)return true;return false;}function clockSyncLatencyMetric(values,model){for(var markers of model.clockSyncManager.markersBySyncId.values()){var latency=undefined;var targetDomain=undefined;if(!syncIsComplete(markers)||!syncInvolvesTelemetry(markers))continue;for(var marker of markers){var domain=marker.domainId;if(domain===tr.model.ClockDomainId.TELEMETRY)latency=marker.endTs-marker.startTs;else targetDomain=domain.toLowerCase();}var hist=new tr.v.Histogram('clock_sync_latency_'+targetDomain,tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,tr.v.HistogramBinBoundaries.createExponential(1e-3,1e3,30));hist.description='Clock sync latency for domain '+targetDomain;hist.addSample(latency);values.addHistogram(hist);}}tr.metrics.MetricRegistry.register(clockSyncLatencyMetric);return{clockSyncLatencyMetric:clockSyncLatencyMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../model/model.js":141,"../../value/histogram.js":195,"../metric_registry.js":89,"./utils.js":100}],92:[function(require,module,exports){(function(global){"use strict";require("../metric_registry.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){var CPU_TIME_PERCENTAGE_BOUNDARIES=tr.v.HistogramBinBoundaries.createExponential(0.01,50,200);function cpuTimeMetric(values,model,opt_options){var rangeOfInterest=model.bounds;if(opt_options&&opt_options.rangeOfInterest)rangeOfInterest=opt_options.rangeOfInterest;var allProcessCpuTime=0;for(var pid in model.processes){var process=model.processes[pid];var processCpuTime=0;for(var tid in process.threads){var thread=process.threads[tid];var threadCpuTime=0;thread.sliceGroup.topLevelSlices.forEach(function(slice){if(slice.duration===0)return;if(!slice.cpuDuration)return;var sliceRange=tr.b.Range.fromExplicitRange(slice.start,slice.end);var intersection=rangeOfInterest.findIntersection(sliceRange);var fractionOfSliceInsideRangeOfInterest=intersection.duration/slice.duration;threadCpuTime+=slice.cpuDuration*fractionOfSliceInsideRangeOfInterest;});processCpuTime+=threadCpuTime;}allProcessCpuTime+=processCpuTime;}var normalizedAllProcessCpuTime=0;if(rangeOfInterest.duration>0){normalizedAllProcessCpuTime=allProcessCpuTime/rangeOfInterest.duration;}var unit=tr.b.Unit.byName.normalizedPercentage_smallerIsBetter;var cpuTimeHist=new tr.v.Histogram('cpu_time_percentage',unit,CPU_TIME_PERCENTAGE_BOUNDARIES);cpuTimeHist.description='Percent CPU utilization, normalized against a single core. Can be '+'greater than 100% if machine has multiple cores.';cpuTimeHist.addSample(normalizedAllProcessCpuTime);values.addHistogram(cpuTimeHist);}tr.metrics.MetricRegistry.register(cpuTimeMetric,{supportsRangeOfInterest:true});return{cpuTimeMetric:cpuTimeMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../value/histogram.js":195,"../metric_registry.js":89}],93:[function(require,module,exports){(function(global){"use strict";require("../metric_registry.js");require("./long_tasks_metric.js");require("../../value/numeric.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){var MS_PER_S=1000;var RESPONSE_RISK=tr.b.Statistics.LogNormalDistribution.fromMedianAndDiminishingReturns(100/MS_PER_S,50/MS_PER_S);function computeResponsivenessRisk(durationMs){durationMs+=16;return RESPONSE_RISK.computePercentile(durationMs/MS_PER_S);}function perceptualBlendSmallerIsBetter(hazardScore){return Math.exp(hazardScore);}function computeHazardForLongTasksInRangeOnThread(thread,opt_range){var taskHazardScores=[];tr.metrics.sh.iterateLongTopLevelTasksOnThreadInRange(thread,opt_range,function(task){taskHazardScores.push(computeResponsivenessRisk(task.duration));});return tr.b.Statistics.weightedMean(taskHazardScores,perceptualBlendSmallerIsBetter);}function computeHazardForLongTasks(model){var threadHazardScores=[];tr.metrics.sh.iterateRendererMainThreads(model,function(thread){threadHazardScores.push(computeHazardForLongTasksInRangeOnThread(thread));});return tr.b.Statistics.weightedMean(threadHazardScores,perceptualBlendSmallerIsBetter);}function hazardMetric(values,model){var overallHazard=computeHazardForLongTasks(model);if(overallHazard===undefined)overallHazard=0;var hist=new tr.v.Histogram('hazard',tr.b.Unit.byName.normalizedPercentage_smallerIsBetter);hist.addSample(overallHazard);values.addHistogram(hist);}tr.metrics.MetricRegistry.register(hazardMetric);return{hazardMetric:hazardMetric,computeHazardForLongTasksInRangeOnThread:computeHazardForLongTasksInRangeOnThread,computeHazardForLongTasks:computeHazardForLongTasks,computeResponsivenessRisk:computeResponsivenessRisk};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../value/numeric.js":196,"../metric_registry.js":89,"./long_tasks_metric.js":95}],94:[function(require,module,exports){(function(global){"use strict";require("../../base/category_util.js");require("../../base/statistics.js");require("../metric_registry.js");require("./utils.js");require("../../model/helpers/chrome_model_helper.js");require("../../model/timed_event.js");require("../../value/histogram.js");require("../../value/numeric.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){var RESPONSIVENESS_THRESHOLD=50;var INTERACTIVE_WINDOW_SIZE=5*1000;var timeDurationInMs_smallerIsBetter=tr.b.Unit.byName.timeDurationInMs_smallerIsBetter;var RelatedEventSet=tr.v.d.RelatedEventSet;function hasCategoryAndName(event,category,title){return event.title===title&&event.category&&tr.b.getCategoryParts(event.category).indexOf(category)!==-1;}function findTargetRendererHelper(chromeHelper){var largestPid=-1;for(var pid in chromeHelper.rendererHelpers){var rendererHelper=chromeHelper.rendererHelpers[pid];if(rendererHelper.isChromeTracingUI)continue;if(pid>largestPid)largestPid=pid;}if(largestPid===-1)return undefined;return chromeHelper.rendererHelpers[largestPid];}function createBreakdownDiagnostic(rendererHelper,start,end){var breakdownDict=rendererHelper.generateTimeBreakdownTree(start,end);var breakdownDiagnostic=new tr.v.d.Breakdown();breakdownDiagnostic.colorScheme=tr.v.d.COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER;for(var label in breakdownDict){breakdownDiagnostic.set(label,breakdownDict[label].total);}return breakdownDiagnostic;}function NavigationStartFinder(rendererHelper){this.navigationStartsForFrameId_={};for(var ev of rendererHelper.mainThread.sliceGroup.childEvents()){if(!hasCategoryAndName(ev,'blink.user_timing','navigationStart'))continue;var frameIdRef=ev.args['frame'];var list=this.navigationStartsForFrameId_[frameIdRef];if(list===undefined)this.navigationStartsForFrameId_[frameIdRef]=list=[];list.unshift(ev);}}NavigationStartFinder.prototype={findNavigationStartEventForFrameBeforeTimestamp:function(frameIdRef,ts){var list=this.navigationStartsForFrameId_[frameIdRef];if(list===undefined){console.warn('No navigationStartEvent found for frame id "'+frameIdRef+'"');return undefined;}var eventBeforeTimestamp;for(var ev of list){if(ev.start>ts)continue;if(eventBeforeTimestamp===undefined)eventBeforeTimestamp=ev;}if(eventBeforeTimestamp===undefined){console.warn('Failed to find navigationStartEvent.');return undefined;}return eventBeforeTimestamp;}};var FIRST_PAINT_BOUNDARIES=tr.v.HistogramBinBoundaries.createLinear(0,1e3,20).addLinearBins(3e3,20).addExponentialBins(20e3,20);function createHistogram(name){var histogram=new tr.v.Histogram(name,timeDurationInMs_smallerIsBetter,FIRST_PAINT_BOUNDARIES);histogram.customizeSummaryOptions({avg:true,count:false,max:true,min:true,std:true,sum:false,percentile:[0.90,0.95,0.99]});return histogram;}function findFrameLoaderSnapshotAt(rendererHelper,frameIdRef,ts){var snapshot;var objects=rendererHelper.process.objects;var frameLoaderInstances=objects.instancesByTypeName_['FrameLoader'];if(frameLoaderInstances===undefined){console.warn('Failed to find FrameLoader for frameId "'+frameIdRef+'" at ts '+ts+', the trace maybe incomplete or from an old'+'Chrome.');return undefined;}var snapshot;for(var instance of frameLoaderInstances){if(!instance.isAliveAt(ts))continue;var maybeSnapshot=instance.getSnapshotAt(ts);if(frameIdRef!==maybeSnapshot.args['frame']['id_ref'])continue;snapshot=maybeSnapshot;}return snapshot;}function findAllUserTimingEvents(rendererHelper,title){var targetEvents=[];for(var ev of rendererHelper.process.getDescendantEvents()){if(!hasCategoryAndName(ev,'blink.user_timing',title))continue;targetEvents.push(ev);}return targetEvents;}function findFirstMeaningfulPaintCandidates(rendererHelper){var isTelemetryInternalEvent=prepareTelemetryInternalEventPredicate(rendererHelper);var candidatesForFrameId={};for(var ev of rendererHelper.process.getDescendantEvents()){if(!hasCategoryAndName(ev,'loading','firstMeaningfulPaintCandidate'))continue;if(isTelemetryInternalEvent(ev))continue;var frameIdRef=ev.args['frame'];if(frameIdRef===undefined)continue;var list=candidatesForFrameId[frameIdRef];if(list===undefined)candidatesForFrameId[frameIdRef]=list=[];list.push(ev);}return candidatesForFrameId;}function prepareTelemetryInternalEventPredicate(rendererHelper){var ignoreRegions=[];var internalRegionStart;for(var slice of rendererHelper.mainThread.asyncSliceGroup.getDescendantEvents()){if(!!slice.title.match(/^telemetry\.internal\.[^.]*\.start$/))internalRegionStart=slice.start;if(!!slice.title.match(/^telemetry\.internal\.[^.]*\.end$/)){var timedEvent=new tr.model.TimedEvent(internalRegionStart);timedEvent.duration=slice.end-internalRegionStart;ignoreRegions.push(timedEvent);}}return function isTelemetryInternalEvent(slice){for(var region of ignoreRegions)if(region.bounds(slice))return true;return false;};}var URL_BLACKLIST=['about:blank','data:text/html,pluginplaceholderdata'];function shouldIgnoreURL(url){return URL_BLACKLIST.indexOf(url)>=0;}var METRICS=[{valueName:'timeToFirstContentfulPaint',title:'firstContentfulPaint',description:'time to first contentful paint'},{valueName:'timeToOnload',title:'loadEventStart',description:'time to onload. '+'This is temporary metric used for PCv1/v2 sanity checking'}];function timeToFirstContentfulPaintMetric(values,model){var chromeHelper=model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);var rendererHelper=findTargetRendererHelper(chromeHelper);var isTelemetryInternalEvent=prepareTelemetryInternalEventPredicate(rendererHelper);var navigationStartFinder=new NavigationStartFinder(rendererHelper);for(var metric of METRICS){var histogram=createHistogram(metric.valueName);histogram.description=metric.description;var targetEvents=findAllUserTimingEvents(rendererHelper,metric.title);for(var ev of targetEvents){if(isTelemetryInternalEvent(ev))continue;var frameIdRef=ev.args['frame'];var snapshot=findFrameLoaderSnapshotAt(rendererHelper,frameIdRef,ev.start);if(snapshot===undefined||!snapshot.args.isLoadingMainFrame)continue;var url=snapshot.args.documentLoaderURL;if(shouldIgnoreURL(url))continue;var navigationStartEvent=navigationStartFinder.findNavigationStartEventForFrameBeforeTimestamp(frameIdRef,ev.start);if(navigationStartEvent===undefined)continue;var timeToEvent=ev.start-navigationStartEvent.start;histogram.addSample(timeToEvent,{url:new tr.v.d.Generic(url)});}values.addHistogram(histogram);}}function addTimeToInteractiveSampleToHistogram(histogram,rendererHelper,navigationStart,firstMeaningfulPaint,url){if(shouldIgnoreURL(url))return;var navigationStartTime=navigationStart.start;var firstInteractive=Infinity;var firstInteractiveCandidate=firstMeaningfulPaint;var lastLongTaskEvent=undefined;for(var ev of[...rendererHelper.mainThread.sliceGroup.childEvents()]){if(ev.start<firstInteractiveCandidate)continue;var interactiveDurationSoFar=ev.start-firstInteractiveCandidate;if(interactiveDurationSoFar>=INTERACTIVE_WINDOW_SIZE){firstInteractive=firstInteractiveCandidate;break;}if(ev.title==='TaskQueueManager::ProcessTaskFromWorkQueue'&&ev.duration>RESPONSIVENESS_THRESHOLD){firstInteractiveCandidate=ev.end-50;lastLongTaskEvent=ev;}}var breakdownDiagnostic=createBreakdownDiagnostic(rendererHelper,navigationStartTime,firstInteractive);var timeToFirstInteractive=firstInteractive-navigationStartTime;histogram.addSample(timeToFirstInteractive,{"Start":new RelatedEventSet(navigationStart),"Last long task":new RelatedEventSet(lastLongTaskEvent),"Navigation infos":new tr.v.d.Generic({url:url,pid:rendererHelper.pid,start:navigationStartTime,interactive:firstInteractive}),"Breakdown of [navStart, Interactive]":breakdownDiagnostic});}function timeToFirstMeaningfulPaintAndTimeToInteractiveMetrics(values,model){var chromeHelper=model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);var rendererHelper=findTargetRendererHelper(chromeHelper);var navigationStartFinder=new NavigationStartFinder(rendererHelper);var firstMeaningfulPaintHistogram=createHistogram('timeToFirstMeaningfulPaint');firstMeaningfulPaintHistogram.description='time to first meaningful paint';var firstInteractiveHistogram=createHistogram('timeToFirstInteractive');firstInteractiveHistogram.description='time to first interactive';function addFirstMeaningfulPaintSampleToHistogram(frameIdRef,navigationStart,fmpMarkerEvent){var snapshot=findFrameLoaderSnapshotAt(rendererHelper,frameIdRef,fmpMarkerEvent.start);if(snapshot===undefined||!snapshot.args.isLoadingMainFrame)return;var url=snapshot.args.documentLoaderURL;if(shouldIgnoreURL(url))return;var timeToFirstMeaningfulPaint=fmpMarkerEvent.start-navigationStart.start;var extraDiagnostic={url:url,pid:rendererHelper.pid};var breakdownDiagnostic=createBreakdownDiagnostic(rendererHelper,navigationStart.start,fmpMarkerEvent.start);firstMeaningfulPaintHistogram.addSample(timeToFirstMeaningfulPaint,{"Breakdown of [navStart, FMP]":breakdownDiagnostic,"Start":new RelatedEventSet(navigationStart),"End":new RelatedEventSet(fmpMarkerEvent),"Navigation infos":new tr.v.d.Generic({url:url,pid:rendererHelper.pid,start:navigationStart.start,fmp:fmpMarkerEvent.start})});return{firstMeaningfulPaint:fmpMarkerEvent.start,url:url};}var candidatesForFrameId=findFirstMeaningfulPaintCandidates(rendererHelper);for(var frameIdRef in candidatesForFrameId){var navigationStart;var lastCandidate;for(var ev of candidatesForFrameId[frameIdRef]){var navigationStartForThisCandidate=navigationStartFinder.findNavigationStartEventForFrameBeforeTimestamp(frameIdRef,ev.start);if(navigationStartForThisCandidate===undefined)continue;if(navigationStart!==navigationStartForThisCandidate){if(navigationStart!==undefined&&lastCandidate!==undefined){data=addFirstMeaningfulPaintSampleToHistogram(frameIdRef,navigationStart,lastCandidate);if(data!==undefined)addTimeToInteractiveSampleToHistogram(firstInteractiveHistogram,rendererHelper,navigationStart,data.firstMeaningfulPaint,data.url);}navigationStart=navigationStartForThisCandidate;}lastCandidate=ev;}if(lastCandidate!==undefined){var data=addFirstMeaningfulPaintSampleToHistogram(frameIdRef,navigationStart,lastCandidate);if(data!==undefined)addTimeToInteractiveSampleToHistogram(firstInteractiveHistogram,rendererHelper,navigationStart,data.firstMeaningfulPaint,data.url);}}values.addHistogram(firstMeaningfulPaintHistogram);values.addHistogram(firstInteractiveHistogram);}function loadingMetric(values,model){timeToFirstContentfulPaintMetric(values,model);timeToFirstMeaningfulPaintAndTimeToInteractiveMetrics(values,model);}tr.metrics.MetricRegistry.register(loadingMetric);return{loadingMetric:loadingMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/category_util.js":36,"../../base/statistics.js":59,"../../model/helpers/chrome_model_helper.js":133,"../../model/timed_event.js":166,"../../value/histogram.js":195,"../../value/numeric.js":196,"../metric_registry.js":89,"./utils.js":100}],95:[function(require,module,exports){(function(global){"use strict";require("../../extras/chrome/chrome_user_friendly_category_driver.js");require("../metric_registry.js");require("../../model/helpers/chrome_model_helper.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){var LONG_TASK_MS=50;var LONGEST_TASK_MS=1000;function iterateLongTopLevelTasksOnThreadInRange(thread,opt_range,cb,opt_this){thread.sliceGroup.topLevelSlices.forEach(function(slice){if(opt_range&&!opt_range.intersectsExplicitRangeInclusive(slice.start,slice.end))return;if(slice.duration<LONG_TASK_MS)return;cb.call(opt_this,slice);});}function iterateRendererMainThreads(model,cb,opt_this){var modelHelper=model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);tr.b.dictionaryValues(modelHelper.rendererHelpers).forEach(function(rendererHelper){if(!rendererHelper.mainThread)return;cb.call(opt_this,rendererHelper.mainThread);});}function longTasksMetric(values,model,opt_options){var rangeOfInterest=opt_options?opt_options.rangeOfInterest:undefined;var longTaskHist=new tr.v.Histogram('long tasks',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,tr.v.HistogramBinBoundaries.createLinear(LONG_TASK_MS,LONGEST_TASK_MS,40));longTaskHist.description='durations of long tasks';var slices=new tr.model.EventSet();iterateRendererMainThreads(model,function(thread){iterateLongTopLevelTasksOnThreadInRange(thread,rangeOfInterest,function(task){longTaskHist.addSample(task.duration,{relatedEvents:new tr.v.d.RelatedEventSet([task])});slices.push(task);slices.addEventSet(task.descendentSlices);});});values.addHistogram(longTaskHist);var sampleForEvent=undefined;var breakdown=tr.v.d.RelatedHistogramBreakdown.buildFromEvents(values,'long tasks ',slices,e=>model.getUserFriendlyCategoryFromEvent(e)||'unknown',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,sampleForEvent,tr.v.HistogramBinBoundaries.createExponential(1,LONGEST_TASK_MS,40));breakdown.colorScheme=tr.v.d.COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER;longTaskHist.diagnostics.set('category',breakdown);}tr.metrics.MetricRegistry.register(longTasksMetric,{supportsRangeOfInterest:true});return{longTasksMetric:longTasksMetric,iterateLongTopLevelTasksOnThreadInRange:iterateLongTopLevelTasksOnThreadInRange,iterateRendererMainThreads:iterateRendererMainThreads,LONG_TASK_MS:LONG_TASK_MS,LONGEST_TASK_MS:LONGEST_TASK_MS};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../extras/chrome/chrome_user_friendly_category_driver.js":69,"../../model/helpers/chrome_model_helper.js":133,"../../value/histogram.js":195,"../metric_registry.js":89}],96:[function(require,module,exports){(function(global){"use strict";require("../../base/iteration_helpers.js");require("../../base/multi_dimensional_view.js");require("../../base/range.js");require("../../base/unit.js");require("../metric_registry.js");require("../../model/container_memory_dump.js");require("../../model/helpers/chrome_model_helper.js");require("../../model/memory_allocator_dump.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){var BACKGROUND=tr.model.ContainerMemoryDump.LevelOfDetail.BACKGROUND;var LIGHT=tr.model.ContainerMemoryDump.LevelOfDetail.LIGHT;var DETAILED=tr.model.ContainerMemoryDump.LevelOfDetail.DETAILED;var sizeInBytes_smallerIsBetter=tr.b.Unit.byName.sizeInBytes_smallerIsBetter;var count_smallerIsBetter=tr.b.Unit.byName.count_smallerIsBetter;var DISPLAYED_SIZE_NUMERIC_NAME=tr.model.MemoryAllocatorDump.DISPLAYED_SIZE_NUMERIC_NAME;var LEVEL_OF_DETAIL_NAMES=new Map();LEVEL_OF_DETAIL_NAMES.set(BACKGROUND,'background');LEVEL_OF_DETAIL_NAMES.set(LIGHT,'light');LEVEL_OF_DETAIL_NAMES.set(DETAILED,'detailed');var BOUNDARIES_FOR_UNIT_MAP=new WeakMap();BOUNDARIES_FOR_UNIT_MAP.set(count_smallerIsBetter,tr.v.HistogramBinBoundaries.createLinear(0,20,20));BOUNDARIES_FOR_UNIT_MAP.set(sizeInBytes_smallerIsBetter,new tr.v.HistogramBinBoundaries(0).addBinBoundary(1024).addExponentialBins(16*1024*1024*1024,4*24));function memoryMetric(values,model,opt_options){var rangeOfInterest=opt_options?opt_options.rangeOfInterest:undefined;var browserNameToGlobalDumps=splitGlobalDumpsByBrowserName(model,rangeOfInterest);addGeneralMemoryDumpValues(browserNameToGlobalDumps,values);addDetailedMemoryDumpValues(browserNameToGlobalDumps,values);addMemoryDumpCountValues(browserNameToGlobalDumps,values);}function splitGlobalDumpsByBrowserName(model,opt_rangeOfInterest){var chromeModelHelper=model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);var browserNameToGlobalDumps=new Map();var globalDumpToBrowserHelper=new WeakMap();if(chromeModelHelper){chromeModelHelper.browserHelpers.forEach(function(helper){var globalDumps=skipDumpsThatDoNotIntersectRange(helper.process.memoryDumps.map(d=>d.globalMemoryDump),opt_rangeOfInterest);globalDumps.forEach(function(globalDump){var existingHelper=globalDumpToBrowserHelper.get(globalDump);if(existingHelper!==undefined){throw new Error('Memory dump ID clash across multiple browsers '+'with PIDs: '+existingHelper.pid+' and '+helper.pid);}globalDumpToBrowserHelper.set(globalDump,helper);});makeKeyUniqueAndSet(browserNameToGlobalDumps,canonicalizeName(helper.browserName),globalDumps);});}var unclassifiedGlobalDumps=skipDumpsThatDoNotIntersectRange(model.globalMemoryDumps.filter(g=>!globalDumpToBrowserHelper.has(g)),opt_rangeOfInterest);if(unclassifiedGlobalDumps.length>0){makeKeyUniqueAndSet(browserNameToGlobalDumps,'unknown_browser',unclassifiedGlobalDumps);}return browserNameToGlobalDumps;}function skipDumpsThatDoNotIntersectRange(dumps,opt_range){if(!opt_range)return dumps;return dumps.filter(d=>opt_range.intersectsExplicitRangeInclusive(d.start,d.end));}function canonicalizeName(name){return name.toLowerCase().replace(' ','_');}var USER_FRIENDLY_BROWSER_NAMES={'chrome':'Chrome','webview':'WebView','unknown_browser':'an unknown browser'};function convertBrowserNameToUserFriendlyName(browserName){for(var baseName in USER_FRIENDLY_BROWSER_NAMES){if(!browserName.startsWith(baseName))continue;var userFriendlyBaseName=USER_FRIENDLY_BROWSER_NAMES[baseName];var suffix=browserName.substring(baseName.length);if(suffix.length===0)return userFriendlyBaseName;else if(/^\d+$/.test(suffix))return userFriendlyBaseName+'('+suffix+')';}return'\''+browserName+'\' browser';}function canonicalizeProcessName(rawProcessName){if(!rawProcessName)return'unknown_processes';var baseCanonicalName=canonicalizeName(rawProcessName);switch(baseCanonicalName){case'renderer':return'renderer_processes';case'browser':return'browser_process';default:return baseCanonicalName;}}function convertProcessNameToUserFriendlyName(processName,opt_requirePlural){switch(processName){case'browser_process':return opt_requirePlural?'browser processes':'the browser process';case'renderer_processes':return'renderer processes';case'gpu_process':return opt_requirePlural?'GPU processes':'the GPU process';case'ppapi_process':return opt_requirePlural?'PPAPI processes':'the PPAPI process';case'all_processes':return'all processes';case'unknown_processes':return'unknown processes';default:return'\''+processName+'\' processes';}}function makeKeyUniqueAndSet(map,key,value){var uniqueKey=key;var nextIndex=2;while(map.has(uniqueKey)){uniqueKey=key+nextIndex;nextIndex++;}map.set(uniqueKey,value);}function addGeneralMemoryDumpValues(browserNameToGlobalDumps,values){addMemoryDumpValues(browserNameToGlobalDumps,gmd=>true,function(processDump,addProcessScalar){addProcessScalar({source:'process_count',value:1,unit:count_smallerIsBetter,descriptionPrefixBuilder:buildProcessCountDescriptionPrefix});if(processDump.totals!==undefined){tr.b.iterItems(SYSTEM_TOTAL_VALUE_PROPERTIES,function(propertyName,propertySpec){addProcessScalar({source:'reported_by_os',property:propertyName,component:['system_memory'],value:propertySpec.getPropertyFunction(processDump),unit:sizeInBytes_smallerIsBetter,descriptionPrefixBuilder:propertySpec.descriptionPrefixBuilder});});}if(processDump.memoryAllocatorDumps===undefined)return;processDump.memoryAllocatorDumps.forEach(function(rootAllocatorDump){tr.b.iterItems(CHROME_VALUE_PROPERTIES,function(propertyName,descriptionPrefixBuilder){addProcessScalar({source:'reported_by_chrome',component:[rootAllocatorDump.name],property:propertyName,value:rootAllocatorDump.numerics[propertyName],descriptionPrefixBuilder:descriptionPrefixBuilder});});if(rootAllocatorDump.numerics['allocated_objects_size']===undefined){var allocatedObjectsDump=rootAllocatorDump.getDescendantDumpByFullName('allocated_objects');if(allocatedObjectsDump!==undefined){addProcessScalar({source:'reported_by_chrome',component:[rootAllocatorDump.name],property:'allocated_objects_size',value:allocatedObjectsDump.numerics['size'],descriptionPrefixBuilder:CHROME_VALUE_PROPERTIES['allocated_objects_size']});}}});addV8MemoryDumpValues(processDump,addProcessScalar);},function(componentTree){var tracingNode=componentTree.children[1].get('tracing');if(tracingNode===undefined)return;for(var i=0;i<componentTree.values.length;i++)componentTree.values[i].total-=tracingNode.values[i].total;},values);}function addV8MemoryDumpValues(processDump,addProcessScalar){var v8Dump=processDump.getMemoryAllocatorDumpByFullName('v8');if(v8Dump===undefined)return;v8Dump.children.forEach(function(isolateDump){var mallocDump=isolateDump.getDescendantDumpByFullName('malloc');if(mallocDump!==undefined){addV8ComponentValues(mallocDump,['v8','allocated_by_malloc'],addProcessScalar);}var heapDump=isolateDump.getDescendantDumpByFullName('heap_spaces');if(heapDump!==undefined){addV8ComponentValues(heapDump,['v8','heap'],addProcessScalar);heapDump.children.forEach(function(spaceDump){if(spaceDump.name==='other_spaces')return;addV8ComponentValues(spaceDump,['v8','heap',spaceDump.name],addProcessScalar);});}});addProcessScalar({source:'reported_by_chrome',component:['v8'],property:'code_and_metadata_size',value:v8Dump.numerics['code_and_metadata_size'],descriptionPrefixBuilder:buildCodeAndMetadataSizeValueDescriptionPrefix});addProcessScalar({source:'reported_by_chrome',component:['v8'],property:'code_and_metadata_size',value:v8Dump.numerics['bytecode_and_metadata_size'],descriptionPrefixBuilder:buildCodeAndMetadataSizeValueDescriptionPrefix});}function addV8ComponentValues(componentDump,componentPath,addProcessScalar){tr.b.iterItems(CHROME_VALUE_PROPERTIES,function(propertyName,descriptionPrefixBuilder){addProcessScalar({source:'reported_by_chrome',component:componentPath,property:propertyName,value:componentDump.numerics[propertyName],descriptionPrefixBuilder:descriptionPrefixBuilder});});}function buildProcessCountDescriptionPrefix(componentPath,processName){if(componentPath.length>0){throw new Error('Unexpected process count non-empty component path: '+componentPath.join(':'));}return'total number of '+convertProcessNameToUserFriendlyName(processName,true);}function buildChromeValueDescriptionPrefix(formatSpec,componentPath,processName){var nameParts=[];if(componentPath.length===0){nameParts.push('total');if(formatSpec.totalUserFriendlyPropertyName){nameParts.push(formatSpec.totalUserFriendlyPropertyName);}else{if(formatSpec.userFriendlyPropertyNamePrefix)nameParts.push(formatSpec.userFriendlyPropertyNamePrefix);nameParts.push(formatSpec.userFriendlyPropertyName);}nameParts.push('reported by Chrome for');}else{if(formatSpec.componentPreposition===undefined){if(formatSpec.userFriendlyPropertyNamePrefix)nameParts.push(formatSpec.userFriendlyPropertyNamePrefix);nameParts.push(componentPath.join(':'));nameParts.push(formatSpec.userFriendlyPropertyName);}else{if(formatSpec.userFriendlyPropertyNamePrefix)nameParts.push(formatSpec.userFriendlyPropertyNamePrefix);nameParts.push(formatSpec.userFriendlyPropertyName);nameParts.push(formatSpec.componentPreposition);if(componentPath[componentPath.length-1]==='allocated_by_malloc'){nameParts.push('objects allocated by malloc for');nameParts.push(componentPath.slice(0,componentPath.length-1).join(':'));}else{nameParts.push(componentPath.join(':'));}}nameParts.push('in');}nameParts.push(convertProcessNameToUserFriendlyName(processName));return nameParts.join(' ');}var CHROME_VALUE_PROPERTIES={'effective_size':buildChromeValueDescriptionPrefix.bind(undefined,{userFriendlyPropertyName:'effective size',componentPreposition:'of'}),'allocated_objects_size':buildChromeValueDescriptionPrefix.bind(undefined,{userFriendlyPropertyName:'size of all objects allocated',totalUserFriendlyPropertyName:'size of all allocated objects',componentPreposition:'by'}),'locked_size':buildChromeValueDescriptionPrefix.bind(undefined,{userFriendlyPropertyName:'locked (pinned) size',componentPreposition:'of'}),'peak_size':buildChromeValueDescriptionPrefix.bind(undefined,{userFriendlyPropertyName:'peak size',componentPreposition:'of'})};var SYSTEM_TOTAL_VALUE_PROPERTIES={'resident_size':{getPropertyFunction:function(processDump){return processDump.totals.residentBytes;},descriptionPrefixBuilder:buildOsValueDescriptionPrefix.bind(undefined,'resident set size (RSS)')},'peak_resident_size':{getPropertyFunction:function(processDump){return processDump.totals.peakResidentBytes;},descriptionPrefixBuilder:buildOsValueDescriptionPrefix.bind(undefined,'peak resident set size')}};function addDetailedMemoryDumpValues(browserNameToGlobalDumps,values){addMemoryDumpValues(browserNameToGlobalDumps,g=>g.levelOfDetail===DETAILED,function(processDump,addProcessScalar){tr.b.iterItems(SYSTEM_VALUE_COMPONENTS,function(componentName,componentSpec){tr.b.iterItems(SYSTEM_VALUE_PROPERTIES,function(propertyName,propertySpec){var node=getDescendantVmRegionClassificationNode(processDump.vmRegions,componentSpec.classificationPath);var componentPath=['system_memory'];if(componentName)componentPath.push(componentName);addProcessScalar({source:'reported_by_os',component:componentPath,property:propertyName,value:node===undefined?0:node.byteStats[propertySpec.byteStat]||0,unit:sizeInBytes_smallerIsBetter,descriptionPrefixBuilder:propertySpec.descriptionPrefixBuilder});});});var memtrackDump=processDump.getMemoryAllocatorDumpByFullName('gpu/android_memtrack');if(memtrackDump!==undefined){var descriptionPrefixBuilder=SYSTEM_VALUE_PROPERTIES['proportional_resident_size'].descriptionPrefixBuilder;memtrackDump.children.forEach(function(memtrackChildDump){var childName=memtrackChildDump.name;addProcessScalar({source:'reported_by_os',component:['gpu_memory',childName],property:'proportional_resident_size',value:memtrackChildDump.numerics['memtrack_pss'],descriptionPrefixBuilder:descriptionPrefixBuilder});});}},function(componentTree){},values);}var SYSTEM_VALUE_COMPONENTS={'':{classificationPath:[]},'java_heap':{classificationPath:['Android','Java runtime','Spaces'],userFriendlyName:'the Java heap'},'ashmem':{classificationPath:['Android','Ashmem'],userFriendlyName:'ashmem'},'native_heap':{classificationPath:['Native heap'],userFriendlyName:'the native heap'}};var SYSTEM_VALUE_PROPERTIES={'proportional_resident_size':{byteStat:'proportionalResident',descriptionPrefixBuilder:buildOsValueDescriptionPrefix.bind(undefined,'proportional resident size (PSS)')},'private_dirty_size':{byteStat:'privateDirtyResident',descriptionPrefixBuilder:buildOsValueDescriptionPrefix.bind(undefined,'private dirty size')}};function buildOsValueDescriptionPrefix(userFriendlyPropertyName,componentPath,processName){if(componentPath.length>2){throw new Error('OS value component path for \''+userFriendlyPropertyName+'\' too long: '+componentPath.join(':'));}var nameParts=[];if(componentPath.length<2)nameParts.push('total');nameParts.push(userFriendlyPropertyName);if(componentPath.length>0){switch(componentPath[0]){case'system_memory':if(componentPath.length>1){var userFriendlyComponentName=SYSTEM_VALUE_COMPONENTS[componentPath[1]].userFriendlyName;if(userFriendlyComponentName===undefined){throw new Error('System value sub-component for \''+userFriendlyPropertyName+'\' unknown: '+componentPath.join(':'));}nameParts.push('of',userFriendlyComponentName,'in');}else{nameParts.push('of system memory (RAM) used by');}break;case'gpu_memory':if(componentPath.length>1){nameParts.push('of the',componentPath[1]);nameParts.push('Android memtrack component in');}else{nameParts.push('of GPU memory (Android memtrack) used by');}break;default:throw new Error('OS value component for \''+userFriendlyPropertyName+'\' unknown: '+componentPath.join(':'));}}else{nameParts.push('reported by the OS for');}nameParts.push(convertProcessNameToUserFriendlyName(processName));return nameParts.join(' ');}function buildCodeAndMetadataSizeValueDescriptionPrefix(componentPath,processName){return buildChromeValueDescriptionPrefix({userFriendlyPropertyNamePrefix:'size of',userFriendlyPropertyName:'code and metadata'},componentPath,processName);}function getDescendantVmRegionClassificationNode(node,path){for(var i=0;i<path.length;i++){if(node===undefined)break;node=tr.b.findFirstInArray(node.children,c=>c.title===path[i]);}return node;}function addMemoryDumpCountValues(browserNameToGlobalDumps,values){browserNameToGlobalDumps.forEach(function(globalDumps,browserName){var totalDumpCount=0;var levelOfDetailNameToDumpCount={};LEVEL_OF_DETAIL_NAMES.forEach(function(levelOfDetailName){levelOfDetailNameToDumpCount[levelOfDetailName]=0;});globalDumps.forEach(function(globalDump){totalDumpCount++;var levelOfDetailName=LEVEL_OF_DETAIL_NAMES.get(globalDump.levelOfDetail);if(!(levelOfDetailName in levelOfDetailNameToDumpCount))return;levelOfDetailNameToDumpCount[levelOfDetailName]++;});reportMemoryDumpCountAsValue(browserName,undefined,totalDumpCount,values);tr.b.iterItems(levelOfDetailNameToDumpCount,function(levelOfDetailName,levelOfDetailDumpCount){reportMemoryDumpCountAsValue(browserName,levelOfDetailName,levelOfDetailDumpCount,values);});});}function reportMemoryDumpCountAsValue(browserName,levelOfDetailName,levelOfDetailDumpCount,values){var nameParts=['memory',browserName,'all_processes','dump_count'];if(levelOfDetailName!==undefined)nameParts.push(levelOfDetailName);var name=nameParts.join(':');var histogram=new tr.v.Histogram(name,count_smallerIsBetter,BOUNDARIES_FOR_UNIT_MAP.get(count_smallerIsBetter));histogram.addSample(levelOfDetailDumpCount);histogram.description=['total number of',levelOfDetailName||'all','memory dumps added by',convertBrowserNameToUserFriendlyName(browserName),'to the trace'].join(' ');values.addHistogram(histogram);}function addMemoryDumpValues(browserNameToGlobalDumps,customGlobalDumpFilter,customProcessDumpValueExtractor,customComponentTreeModifier,values){browserNameToGlobalDumps.forEach(function(globalDumps,browserName){var filteredGlobalDumps=globalDumps.filter(customGlobalDumpFilter);var sourceToPropertyToData=extractDataFromGlobalDumps(filteredGlobalDumps,customProcessDumpValueExtractor);reportDataAsValues(sourceToPropertyToData,browserName,customComponentTreeModifier,values);});}function extractDataFromGlobalDumps(globalDumps,customProcessDumpValueExtractor){var sourceToPropertyToData=new Map();var dumpCount=globalDumps.length;globalDumps.forEach(function(globalDump,dumpIndex){tr.b.iterItems(globalDump.processMemoryDumps,function(_,processDump){extractDataFromProcessDump(processDump,sourceToPropertyToData,dumpIndex,dumpCount,customProcessDumpValueExtractor);});});return sourceToPropertyToData;}function extractDataFromProcessDump(processDump,sourceToPropertyToData,dumpIndex,dumpCount,customProcessDumpValueExtractor){var rawProcessName=processDump.process.name;var processNamePath=[canonicalizeProcessName(rawProcessName)];customProcessDumpValueExtractor(processDump,function addProcessScalar(spec){if(spec.value===undefined)return;var component=spec.component||[];function createDetailsForErrorMessage(){var propertyUserFriendlyName=spec.property===undefined?'(undefined)':spec.property;var componentUserFriendlyName=component.length===0?'(empty)':component.join(':');return['source=',spec.source,', property=',propertyUserFriendlyName,', component=',componentUserFriendlyName,' in ',processDump.process.userFriendlyName].join('');}var value,unit;if(spec.value instanceof tr.v.ScalarNumeric){value=spec.value.value;unit=spec.value.unit;if(spec.unit!==undefined){throw new Error('Histogram value for '+createDetailsForErrorMessage()+' already specifies a unit');}}else{value=spec.value;unit=spec.unit;}var propertyToData=sourceToPropertyToData.get(spec.source);if(propertyToData===undefined){propertyToData=new Map();sourceToPropertyToData.set(spec.source,propertyToData);}var data=propertyToData.get(spec.property);if(data===undefined){data={processAndComponentTreeBuilder:new tr.b.MultiDimensionalViewBuilder(2,dumpCount),unit:unit,descriptionPrefixBuilder:spec.descriptionPrefixBuilder};propertyToData.set(spec.property,data);}else if(data.unit!==unit){throw new Error('Multiple units provided for '+createDetailsForErrorMessage()+':'+data.unit.unitName+' and '+unit.unitName);}else if(data.descriptionPrefixBuilder!==spec.descriptionPrefixBuilder){throw new Error('Multiple description prefix builders provided for'+createDetailsForErrorMessage());}var values=new Array(dumpCount);values[dumpIndex]=value;data.processAndComponentTreeBuilder.addPath([processNamePath,component],values,tr.b.MultiDimensionalViewBuilder.ValueKind.TOTAL);});}function reportDataAsValues(sourceToPropertyToData,browserName,customComponentTreeModifier,values){sourceToPropertyToData.forEach(function(propertyToData,sourceName){propertyToData.forEach(function(data,propertyName){var tree=data.processAndComponentTreeBuilder.buildTopDownTreeView();var unit=data.unit;var descriptionPrefixBuilder=data.descriptionPrefixBuilder;customComponentTreeModifier(tree);reportComponentDataAsValues(browserName,sourceName,propertyName,'all_processes',[],tree,unit,descriptionPrefixBuilder,values);tree.children[0].forEach(function(processTree,processName){if(processTree.children[0].size>0){throw new Error('Multi-dimensional view node for source='+sourceName+', property='+(propertyName===undefined?'(undefined)':propertyName)+', process='+processName+' has children wrt the process name dimension');}customComponentTreeModifier(processTree);reportComponentDataAsValues(browserName,sourceName,propertyName,processName,[],processTree,unit,descriptionPrefixBuilder,values);});});});}function reportComponentDataAsValues(browserName,sourceName,propertyName,processName,componentPath,componentNode,unit,descriptionPrefixBuilder,values){var nameParts=['memory',browserName,processName,sourceName].concat(componentPath);if(propertyName!==undefined)nameParts.push(propertyName);var name=nameParts.join(':');var numeric=buildMemoryNumericFromNode(name,componentNode,unit);numeric.description=[descriptionPrefixBuilder(componentPath,processName),'in',convertBrowserNameToUserFriendlyName(browserName)].join(' ');values.addHistogram(numeric);var depth=componentPath.length;componentPath.push(undefined);componentNode.children[1].forEach(function(childNode,childName){componentPath[depth]=childName;reportComponentDataAsValues(browserName,sourceName,propertyName,processName,componentPath,childNode,unit,descriptionPrefixBuilder,values);});componentPath.pop();}function buildMemoryNumericFromNode(name,node,unit){var histogram=new tr.v.Histogram(name,unit,BOUNDARIES_FOR_UNIT_MAP.get(unit));node.values.forEach(v=>histogram.addSample(v.total));return histogram;}tr.metrics.MetricRegistry.register(memoryMetric,{supportsRangeOfInterest:true});return{memoryMetric:memoryMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/iteration_helpers.js":47,"../../base/multi_dimensional_view.js":49,"../../base/range.js":53,"../../base/unit.js":63,"../../model/container_memory_dump.js":115,"../../model/helpers/chrome_model_helper.js":133,"../../model/memory_allocator_dump.js":140,"../../value/histogram.js":195,"../metric_registry.js":89}],97:[function(require,module,exports){(function(global){"use strict";require("../../base/statistics.js");require("../metric_registry.js");require("./loading_metric.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){var FRAMES_PER_SEC=60;var FRAME_MS=tr.b.convertUnit(1.0/FRAMES_PER_SEC,tr.b.UnitScale.Metric.NONE,tr.b.UnitScale.Metric.MILLI);function getPowerData_(model,start,end){var durationInMs=end-start;var durationInS=tr.b.convertUnit(durationInMs,tr.b.UnitScale.Metric.MILLI,tr.b.UnitScale.Metric.NONE);var energyInJ=model.device.powerSeries.getEnergyConsumedInJ(start,end);var powerInW=energyInJ/durationInS;return{duration:durationInMs,energy:energyInJ,power:powerInW};}function getNavigationTTIIntervals_(model){var values=new tr.v.ValueSet();tr.metrics.sh.loadingMetric(values,model);var ttiValues=values.getValuesNamed('timeToFirstInteractive');var intervals=[];for(var bin of tr.b.getOnlyElement(ttiValues).allBins){for(var diagnostics of bin.diagnosticMaps){var breakdown=diagnostics.get('Navigation infos');intervals.push(tr.b.Range.fromExplicitRange(breakdown.value.start,breakdown.value.interactive));}}return intervals.sort((x,y)=>x.min-y.min);}function makeTimeHistogram_(values,title,description){var hist=new tr.v.Histogram(title+':time',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter);hist.customizeSummaryOptions({avg:false,count:false,max:true,min:true,std:false,sum:true});hist.description='Time spent in '+description;values.addHistogram(hist);return hist;}function makeEnergyHistogram_(values,title,description){var hist=new tr.v.Histogram(title+':energy',tr.b.Unit.byName.energyInJoules_smallerIsBetter);hist.customizeSummaryOptions({avg:false,count:false,max:true,min:true,std:false,sum:true});hist.description='Energy consumed in '+description;values.addHistogram(hist);return hist;}function makePowerHistogram_(values,title,description){var hist=new tr.v.Histogram(title+':power',tr.b.Unit.byName.powerInWatts_smallerIsBetter);hist.customizeSummaryOptions({avg:true,count:false,max:true,min:true,std:false,sum:false});hist.description='Energy consumption rate in '+description;values.addHistogram(hist);return hist;}function storePowerData_(data,timeHist,energyHist,powerHist){if(timeHist!==undefined)timeHist.addSample(data.duration);if(energyHist!==undefined)energyHist.addSample(data.energy);if(powerHist!==undefined)powerHist.addSample(data.power);}function createHistograms_(model,values){var hists={};hists.railStageToTimeHist=new Map();hists.railStageToEnergyHist=new Map();hists.railStageToPowerHist=new Map();hists.scrollTimeHist=makeTimeHistogram_(values,'scroll','scrolling');hists.scrollEnergyHist=makeEnergyHistogram_(values,'scroll','scrolling');hists.scrollPowerHist=makePowerHistogram_(values,'scroll','scrolling');hists.loadTimeHist=makeTimeHistogram_(values,'load','page loads');hists.loadEnergyHist=makeEnergyHistogram_(values,'load','page loads');hists.afterLoadTimeHist=makeTimeHistogram_(values,'after_load','period after load');hists.afterLoadPowerHist=makePowerHistogram_(values,'after_load','period after load');hists.videoPowerHist=makePowerHistogram_(values,'video','video playback');hists.frameEnergyHist=makeEnergyHistogram_(values,'per_frame','each frame');for(var exp of model.userModel.expectations){var currTitle=exp.title.toLowerCase().replace(' ','_');if(!hists.railStageToTimeHist.has(currTitle)){var timeHist=makeTimeHistogram_(values,currTitle,'RAIL stage '+currTitle);var energyHist=makeEnergyHistogram_(values,currTitle,'RAIL stage '+currTitle);var powerHist=makePowerHistogram_(values,currTitle,'RAIL stage '+currTitle);hists.railStageToTimeHist.set(currTitle,timeHist);hists.railStageToEnergyHist.set(currTitle,energyHist);hists.railStageToPowerHist.set(currTitle,powerHist);}}return hists;}function processInteractionRecord_(exp,model,hists){var currTitle=exp.title.toLowerCase().replace(' ','_');var data=getPowerData_(model,exp.start,exp.end);storePowerData_(data,hists.railStageToTimeHist.get(currTitle),hists.railStageToEnergyHist.get(currTitle),hists.railStageToPowerHist.get(currTitle));if(exp.title.indexOf("Scroll")!==-1){storePowerData_(data,hists.scrollTimeHist,hists.scrollEnergyHist,hists.scrollPowerHist);}if(exp.title.indexOf("Video")!==-1)storePowerData_(data,undefined,undefined,hists.videoPowerHist);}function computeLoadingMetric_(model,hists){var intervals=getNavigationTTIIntervals_(model);var lastLoadTime=undefined;for(var interval of intervals){var loadData=getPowerData_(model,interval.min,interval.max);storePowerData_(loadData,hists.loadTimeHist,hists.loadEnergyHist,undefined);lastLoadTime=lastLoadTime==undefined?interval.max:Math.max(lastLoadTime,interval.max);}if(lastLoadTime!==undefined){var afterLoadData=getPowerData_(model,lastLoadTime,model.bounds.max);storePowerData_(afterLoadData,hists.afterLoadTimeHist,undefined,hists.afterLoadPowerHist);}}function computeFrameBasedPowerMetric_(model,hists){model.device.powerSeries.updateBounds();var currentTime=model.device.powerSeries.bounds.min;while(currentTime<model.device.powerSeries.bounds.max){var frameData=getPowerData_(model,currentTime,currentTime+FRAME_MS);hists.frameEnergyHist.addSample(frameData.energy);currentTime+=FRAME_MS;}}function powerMetric(values,model){if(!model.device.powerSeries)return;var hists=createHistograms_(model,values);for(var exp of model.userModel.expectations)processInteractionRecord_(exp,model,hists);computeLoadingMetric_(model,hists);computeFrameBasedPowerMetric_(model,hists);}tr.metrics.MetricRegistry.register(powerMetric);return{powerMetric:powerMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/statistics.js":59,"../../value/histogram.js":195,"../metric_registry.js":89,"./loading_metric.js":94}],98:[function(require,module,exports){(function(global){"use strict";require("../../base/statistics.js");require("../metric_registry.js");require("./utils.js");require("../../model/user_model/animation_expectation.js");require("../../model/user_model/load_expectation.js");require("../../model/user_model/response_expectation.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){function computeAnimationThroughput(animationExpectation){if(animationExpectation.frameEvents===undefined||animationExpectation.frameEvents.length===0)throw new Error('Animation missing frameEvents '+animationExpectation.stableId);var durationInS=tr.b.convertUnit(animationExpectation.duration,tr.b.UnitScale.Metric.MILLI,tr.b.UnitScale.Metric.NONE);return animationExpectation.frameEvents.length/durationInS;}function computeAnimationframeTimeDiscrepancy(animationExpectation){if(animationExpectation.frameEvents===undefined||animationExpectation.frameEvents.length===0)throw new Error('Animation missing frameEvents '+animationExpectation.stableId);var frameTimestamps=animationExpectation.frameEvents;frameTimestamps=frameTimestamps.toArray().map(function(event){return event.start;});var absolute=true;return tr.b.Statistics.timestampsDiscrepancy(frameTimestamps,absolute);}function responsivenessMetric(values,model,opt_options){var responseNumeric=new tr.v.Histogram('response latency',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,tr.v.HistogramBinBoundaries.createLinear(100,1e3,50));var throughputNumeric=new tr.v.Histogram('animation throughput',tr.b.Unit.byName.unitlessNumber_biggerIsBetter,tr.v.HistogramBinBoundaries.createLinear(10,60,10));var frameTimeDiscrepancyNumeric=new tr.v.Histogram('animation frameTimeDiscrepancy',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,tr.v.HistogramBinBoundaries.createLinear(0,1e3,50).addExponentialBins(1e4,10));var latencyNumeric=new tr.v.Histogram('animation latency',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,tr.v.HistogramBinBoundaries.createLinear(0,300,60));model.userModel.expectations.forEach(function(ue){if(opt_options&&opt_options.rangeOfInterest&&!opt_options.rangeOfInterest.intersectsExplicitRangeInclusive(ue.start,ue.end))return;var sampleDiagnosticMap=tr.v.d.DiagnosticMap.fromObject({relatedEvents:new tr.v.d.RelatedEventSet([ue])});if(ue instanceof tr.model.um.IdleExpectation){return;}else if(ue instanceof tr.model.um.StartupExpectation){return;}else if(ue instanceof tr.model.um.LoadExpectation){}else if(ue instanceof tr.model.um.ResponseExpectation){responseNumeric.addSample(ue.duration,sampleDiagnosticMap);}else if(ue instanceof tr.model.um.AnimationExpectation){if(ue.frameEvents===undefined||ue.frameEvents.length===0){return;}var throughput=computeAnimationThroughput(ue);if(throughput===undefined)throw new Error('Missing throughput for '+ue.stableId);throughputNumeric.addSample(throughput,sampleDiagnosticMap);var frameTimeDiscrepancy=computeAnimationframeTimeDiscrepancy(ue);if(frameTimeDiscrepancy===undefined)throw new Error('Missing frameTimeDiscrepancy for '+ue.stableId);frameTimeDiscrepancyNumeric.addSample(frameTimeDiscrepancy,sampleDiagnosticMap);ue.associatedEvents.forEach(function(event){if(!(event instanceof tr.e.cc.InputLatencyAsyncSlice))return;latencyNumeric.addSample(event.duration,sampleDiagnosticMap);});}else{throw new Error('Unrecognized stage for '+ue.stableId);}});[responseNumeric,throughputNumeric,frameTimeDiscrepancyNumeric,latencyNumeric].forEach(function(numeric){numeric.customizeSummaryOptions({avg:true,max:true,min:true,std:true});});values.addHistogram(responseNumeric);values.addHistogram(throughputNumeric);values.addHistogram(frameTimeDiscrepancyNumeric);values.addHistogram(latencyNumeric);}tr.metrics.MetricRegistry.register(responsivenessMetric,{supportsRangeOfInterest:true});return{responsivenessMetric:responsivenessMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/statistics.js":59,"../../model/user_model/animation_expectation.js":167,"../../model/user_model/load_expectation.js":169,"../../model/user_model/response_expectation.js":170,"../../value/histogram.js":195,"../metric_registry.js":89,"./utils.js":100}],99:[function(require,module,exports){(function(global){"use strict";require("./cpu_time_metric.js");require("./hazard_metric.js");require("./long_tasks_metric.js");require("./power_metric.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){function systemHealthMetrics(values,model){tr.metrics.sh.responsivenessMetric(values,model);tr.metrics.sh.longTasksMetric(values,model);tr.metrics.sh.hazardMetric(values,model);tr.metrics.sh.powerMetric(values,model);tr.metrics.sh.cpuTimeMetric(values,model);}tr.metrics.MetricRegistry.register(systemHealthMetrics);return{systemHealthMetrics:systemHealthMetrics};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./cpu_time_metric.js":92,"./hazard_metric.js":93,"./long_tasks_metric.js":95,"./power_metric.js":97}],100:[function(require,module,exports){(function(global){"use strict";require("../../model/user_model/user_expectation.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){function perceptualBlend(ir,index,score){return Math.exp(1-score);}function filterExpectationsByRange(irs,opt_range){var filteredExpectations=[];irs.forEach(function(ir){if(!(ir instanceof tr.model.um.UserExpectation))return;if(!opt_range||opt_range.intersectsExplicitRangeInclusive(ir.start,ir.end))filteredExpectations.push(ir);});return filteredExpectations;}return{perceptualBlend:perceptualBlend,filterExpectationsByRange:filterExpectationsByRange};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../model/user_model/user_expectation.js":172}],101:[function(require,module,exports){(function(global){"use strict";require("../metric_registry.js");require("./utils.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.sh',function(){function webviewStartupMetric(values,model){var startupWallHist=new tr.v.Histogram('webview_startup_wall_time',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter);startupWallHist.description='WebView startup wall time';var startupCPUHist=new tr.v.Histogram('webview_startup_cpu_time',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter);startupCPUHist.description='WebView startup CPU time';var loadWallHist=new tr.v.Histogram('webview_url_load_wall_time',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter);loadWallHist.description='WebView blank URL load wall time';var loadCPUHist=new tr.v.Histogram('webview_url_load_cpu_time',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter);loadCPUHist.description='WebView blank URL load CPU time';for(var slice of model.getDescendantEvents()){if(!(slice instanceof tr.model.ThreadSlice))continue;if(slice.title==='WebViewStartupInterval'){startupWallHist.addSample(slice.duration);startupCPUHist.addSample(slice.cpuDuration);}if(slice.title==='WebViewBlankUrlLoadInterval'){loadWallHist.addSample(slice.duration);loadCPUHist.addSample(slice.cpuDuration);}}values.addHistogram(startupWallHist);values.addHistogram(startupCPUHist);values.addHistogram(loadWallHist);values.addHistogram(loadCPUHist);}tr.metrics.MetricRegistry.register(webviewStartupMetric);return{webviewStartupMetric:webviewStartupMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../value/histogram.js":195,"../metric_registry.js":89,"./utils.js":100}],102:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");require("./metric_registry.js");require("../value/diagnostics/diagnostic_map.js");require("../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics',function(){var MEMORY_INFRA_TRACING_CATEGORY='disabled-by-default-memory-infra';var TIME_BOUNDARIES=tr.v.HistogramBinBoundaries.createExponential(1e-3,1e5,30);var BYTE_BOUNDARIES=tr.v.HistogramBinBoundaries.createExponential(1,1e9,30);var COUNT_BOUNDARIES=tr.v.HistogramBinBoundaries.createExponential(1,1e5,30);function addTimeDurationValue(valueName,duration,allValues){var hist=new tr.v.Histogram(valueName,tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,TIME_BOUNDARIES);hist.addSample(duration);allValues.addHistogram(hist);}function addMemoryInfraValues(values,model,categoryNamesToTotalEventSizes){var memoryDumpCount=model.globalMemoryDumps.length;if(memoryDumpCount===0)return;var totalOverhead=0;var nonMemoryInfraThreadOverhead=0;var overheadByProvider={};tr.b.iterItems(model.processes,function(pid,process){tr.b.iterItems(process.threads,function(tid,thread){tr.b.iterItems(thread.sliceGroup.slices,(unusedSliceId,slice)=>{if(slice.category!==MEMORY_INFRA_TRACING_CATEGORY)return;totalOverhead+=slice.duration;if(thread.name!=='MemoryInfra')nonMemoryInfraThreadOverhead+=slice.duration;if(slice.args&&slice.args['dump_provider.name']){var providerName=slice.args['dump_provider.name'];var durationAndCount=overheadByProvider[providerName];if(durationAndCount===undefined){overheadByProvider[providerName]=durationAndCount={duration:0,count:0};}durationAndCount.duration+=slice.duration;durationAndCount.count++;}});});});addTimeDurationValue('Average CPU overhead on all threads per memory-infra dump',totalOverhead/memoryDumpCount,values);addTimeDurationValue('Average CPU overhead on non-memory-infra threads per memory-infra '+'dump',nonMemoryInfraThreadOverhead/memoryDumpCount,values);tr.b.iterItems(overheadByProvider,function(providerName,overhead){addTimeDurationValue('Average CPU overhead of '+providerName+' per OnMemoryDump call',overhead.duration/overhead.count,values);});var memoryInfraEventsSize=categoryNamesToTotalEventSizes.get(MEMORY_INFRA_TRACING_CATEGORY);var memoryInfraTraceBytesValue=new tr.v.Histogram('Total trace size of memory-infra dumps in bytes',tr.b.Unit.byName.sizeInBytes_smallerIsBetter,BYTE_BOUNDARIES);memoryInfraTraceBytesValue.addSample(memoryInfraEventsSize);values.addHistogram(memoryInfraTraceBytesValue);var traceBytesPerDumpValue=new tr.v.Histogram('Average trace size of memory-infra dumps in bytes',tr.b.Unit.byName.sizeInBytes_smallerIsBetter,BYTE_BOUNDARIES);traceBytesPerDumpValue.addSample(memoryInfraEventsSize/memoryDumpCount);values.addHistogram(traceBytesPerDumpValue);}function tracingMetric(values,model){if(!model.stats.hasEventSizesinBytes){throw new Error('Model stats does not have event size information. '+'Please enable ImportOptions.trackDetailedModelStats.');}var eventStats=model.stats.allTraceEventStatsInTimeIntervals;eventStats.sort(function(a,b){return a.timeInterval-b.timeInterval;});var totalTraceBytes=eventStats.reduce((a,b)=>a+b.totalEventSizeinBytes,0);var maxEventCountPerSec=0;var maxEventBytesPerSec=0;var INTERVALS_PER_SEC=Math.floor(1000/model.stats.TIME_INTERVAL_SIZE_IN_MS);var runningEventNumPerSec=0;var runningEventBytesPerSec=0;var start=0;var end=0;while(end<eventStats.length){runningEventNumPerSec+=eventStats[end].numEvents;runningEventBytesPerSec+=eventStats[end].totalEventSizeinBytes;end++;while(eventStats[end-1].timeInterval-eventStats[start].timeInterval>=INTERVALS_PER_SEC){runningEventNumPerSec-=eventStats[start].numEvents;runningEventBytesPerSec-=eventStats[start].totalEventSizeinBytes;start++;}maxEventCountPerSec=Math.max(maxEventCountPerSec,runningEventNumPerSec);maxEventBytesPerSec=Math.max(maxEventBytesPerSec,runningEventBytesPerSec);}var stats=model.stats.allTraceEventStats;var categoryNamesToTotalEventSizes=stats.reduce((map,stat)=>map.set(stat.category,(map.get(stat.category)||0)+stat.totalEventSizeinBytes),new Map());var maxCatNameAndBytes=Array.from(categoryNamesToTotalEventSizes.entries()).reduce((a,b)=>b[1]>=a[1]?b:a);var maxEventBytesPerCategory=maxCatNameAndBytes[1];var categoryWithMaxEventBytes=maxCatNameAndBytes[0];var maxEventCountPerSecValue=new tr.v.Histogram('Max number of events per second',tr.b.Unit.byName.count_smallerIsBetter,COUNT_BOUNDARIES);maxEventCountPerSecValue.addSample(maxEventCountPerSec);var maxEventBytesPerSecValue=new tr.v.Histogram('Max event size in bytes per second',tr.b.Unit.byName.sizeInBytes_smallerIsBetter,BYTE_BOUNDARIES);maxEventBytesPerSecValue.addSample(maxEventBytesPerSec);var totalTraceBytesValue=new tr.v.Histogram('Total trace size in bytes',tr.b.Unit.byName.sizeInBytes_smallerIsBetter,BYTE_BOUNDARIES);totalTraceBytesValue.addSample(totalTraceBytes);var biggestCategory={name:categoryWithMaxEventBytes,size_in_bytes:maxEventBytesPerCategory};totalTraceBytesValue.diagnostics.set('category_with_max_event_size',new tr.v.d.Generic(biggestCategory));values.addHistogram(totalTraceBytesValue);maxEventCountPerSecValue.diagnostics.set('category_with_max_event_size',new tr.v.d.Generic(biggestCategory));values.addHistogram(maxEventCountPerSecValue);maxEventBytesPerSecValue.diagnostics.set('category_with_max_event_size',new tr.v.d.Generic(biggestCategory));values.addHistogram(maxEventBytesPerSecValue);addMemoryInfraValues(values,model,categoryNamesToTotalEventSizes);}tr.metrics.MetricRegistry.register(tracingMetric);return{tracingMetric:tracingMetric,MEMORY_INFRA_TRACING_CATEGORY:MEMORY_INFRA_TRACING_CATEGORY};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47,"../value/diagnostics/diagnostic_map.js":185,"../value/histogram.js":195,"./metric_registry.js":89}],103:[function(require,module,exports){(function(global){"use strict";require("../../base/range.js");require("../../base/unit.js");require("../metric_registry.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.v8',function(){var CUSTOM_BOUNDARIES=tr.v.HistogramBinBoundaries.createLinear(4,200,100);function computeExecuteMetrics(values,model){var cpuTotalExecution=new tr.v.Histogram('v8_execution_cpu_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuTotalExecution.description='cpu total time spent in script execution';var wallTotalExecution=new tr.v.Histogram('v8_execution_wall_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallTotalExecution.description='wall total time spent in script execution';var cpuSelfExecution=new tr.v.Histogram('v8_execution_cpu_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuSelfExecution.description='cpu self time spent in script execution';var wallSelfExecution=new tr.v.Histogram('v8_execution_wall_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallSelfExecution.description='wall self time spent in script execution';for(var e of model.findTopmostSlicesNamed('V8.Execute')){cpuTotalExecution.addSample(e.cpuDuration);wallTotalExecution.addSample(e.duration);cpuSelfExecution.addSample(e.cpuSelfTime);wallSelfExecution.addSample(e.selfTime);}values.addHistogram(cpuTotalExecution);values.addHistogram(wallTotalExecution);values.addHistogram(cpuSelfExecution);values.addHistogram(wallSelfExecution);}function computeParseLazyMetrics(values,model){var cpuSelfParseLazy=new tr.v.Histogram('v8_parse_lazy_cpu_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuSelfParseLazy.description='cpu self time spent performing lazy parsing';var wallSelfParseLazy=new tr.v.Histogram('v8_parse_lazy_wall_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallSelfParseLazy.description='wall self time spent performing lazy parsing';for(var e of model.findTopmostSlicesNamed('V8.ParseLazyMicroSeconds')){cpuSelfParseLazy.addSample(e.cpuSelfTime);wallSelfParseLazy.addSample(e.selfTime);}for(var e of model.findTopmostSlicesNamed('V8.ParseLazy')){cpuSelfParseLazy.addSample(e.cpuSelfTime);wallSelfParseLazy.addSample(e.selfTime);}values.addHistogram(cpuSelfParseLazy);values.addHistogram(wallSelfParseLazy);}function computeCompileFullCodeMetrics(values,model){var cpuSelfCompileFullCode=new tr.v.Histogram('v8_compile_full_code_cpu_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuSelfCompileFullCode.description='cpu self time spent performing compiling full code';var wallSelfCompileFullCode=new tr.v.Histogram('v8_compile_full_code_wall_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallSelfCompileFullCode.description='wall self time spent performing compiling full code';for(var e of model.findTopmostSlicesNamed('V8.CompileFullCode')){cpuSelfCompileFullCode.addSample(e.cpuSelfTime);wallSelfCompileFullCode.addSample(e.selfTime);}values.addHistogram(cpuSelfCompileFullCode);values.addHistogram(wallSelfCompileFullCode);}function computeCompileIgnitionMetrics(values,model){var cpuSelfCompileIgnition=new tr.v.Histogram('v8_compile_ignition_cpu_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuSelfCompileIgnition.description='cpu self time spent in compile ignition';var wallSelfCompileIgnition=new tr.v.Histogram('v8_compile_ignition_wall_self',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallSelfCompileIgnition.description='wall self time spent in compile ignition';for(var e of model.findTopmostSlicesNamed('V8.CompileIgnition')){cpuSelfCompileIgnition.addSample(e.cpuSelfTime);wallSelfCompileIgnition.addSample(e.selfTime);}values.addHistogram(cpuSelfCompileIgnition);values.addHistogram(wallSelfCompileIgnition);}function computeRecompileMetrics(values,model){var cpuTotalRecompileSynchronous=new tr.v.Histogram('v8_recompile_synchronous_cpu_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuTotalRecompileSynchronous.description='cpu total time spent in synchronous recompilation';var wallTotalRecompileSynchronous=new tr.v.Histogram('v8_recompile_synchronous_wall_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallTotalRecompileSynchronous.description='wall total time spent in synchronous recompilation';var cpuTotalRecompileConcurrent=new tr.v.Histogram('v8_recompile_concurrent_cpu_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuTotalRecompileConcurrent.description='cpu total time spent in concurrent recompilation';var wallTotalRecompileConcurrent=new tr.v.Histogram('v8_recompile_concurrent_wall_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallTotalRecompileConcurrent.description='wall total time spent in concurrent recompilation';var cpuTotalRecompileOverall=new tr.v.Histogram('v8_recompile_overall_cpu_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuTotalRecompileOverall.description='cpu total time spent in synchronous or concurrent recompilation';var wallTotalRecompileOverall=new tr.v.Histogram('v8_recompile_overall_wall_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallTotalRecompileOverall.description='wall total time spent in synchronous or concurrent recompilation';for(var e of model.findTopmostSlicesNamed('V8.RecompileSynchronous')){cpuTotalRecompileSynchronous.addSample(e.cpuDuration);wallTotalRecompileSynchronous.addSample(e.duration);cpuTotalRecompileOverall.addSample(e.cpuDuration);wallTotalRecompileOverall.addSample(e.duration);}values.addHistogram(cpuTotalRecompileSynchronous);values.addHistogram(wallTotalRecompileSynchronous);for(var e of model.findTopmostSlicesNamed('V8.RecompileConcurrent')){cpuTotalRecompileConcurrent.addSample(e.cpuDuration);wallTotalRecompileConcurrent.addSample(e.duration);cpuTotalRecompileOverall.addSample(e.cpuDuration);wallTotalRecompileOverall.addSample(e.duration);}values.addHistogram(cpuTotalRecompileConcurrent);values.addHistogram(wallTotalRecompileConcurrent);values.addHistogram(cpuTotalRecompileOverall);values.addHistogram(wallTotalRecompileOverall);}function computeOptimizeCodeMetrics(values,model){var cpuTotalOptimizeCode=new tr.v.Histogram('v8_optimize_code_cpu_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuTotalOptimizeCode.description='cpu total time spent in code optimization';var wallTotalOptimizeCode=new tr.v.Histogram('v8_optimize_code_wall_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallTotalOptimizeCode.description='wall total time spent in code optimization';for(var e of model.findTopmostSlicesNamed('V8.OptimizeCode')){cpuTotalOptimizeCode.addSample(e.cpuDuration);wallTotalOptimizeCode.addSample(e.duration);}values.addHistogram(cpuTotalOptimizeCode);values.addHistogram(wallTotalOptimizeCode);}function computeDeoptimizeCodeMetrics(values,model){var cpuTotalDeoptimizeCode=new tr.v.Histogram('v8_deoptimize_code_cpu_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);cpuTotalDeoptimizeCode.description='cpu total time spent in code deoptimization';var wallTotalDeoptimizeCode=new tr.v.Histogram('v8_deoptimize_code_wall_total',tr.b.Unit.byName.timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);wallTotalDeoptimizeCode.description='wall total time spent in code deoptimization';for(var e of model.findTopmostSlicesNamed('V8.DeoptimizeCode')){cpuTotalDeoptimizeCode.addSample(e.cpuDuration);wallTotalDeoptimizeCode.addSample(e.duration);}values.addHistogram(cpuTotalDeoptimizeCode);values.addHistogram(wallTotalDeoptimizeCode);}function executionMetric(values,model){computeExecuteMetrics(values,model);computeParseLazyMetrics(values,model);computeCompileIgnitionMetrics(values,model);computeCompileFullCodeMetrics(values,model);computeRecompileMetrics(values,model);computeOptimizeCodeMetrics(values,model);computeDeoptimizeCodeMetrics(values,model);}tr.metrics.MetricRegistry.register(executionMetric);return{executionMetric:executionMetric};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/range.js":53,"../../base/unit.js":63,"../../value/histogram.js":195,"../metric_registry.js":89}],104:[function(require,module,exports){(function(global){"use strict";require("../../base/range.js");require("../../base/unit.js");require("../metric_registry.js");require("./utils.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.v8',function(){var TARGET_FPS=60;var MS_PER_SECOND=1000;var WINDOW_SIZE_MS=MS_PER_SECOND/TARGET_FPS;function gcMetric(values,model){addDurationOfTopEvents(values,model);addTotalDurationOfTopEvents(values,model);addDurationOfSubEvents(values,model);addIdleTimesOfTopEvents(values,model);addTotalIdleTimesOfTopEvents(values,model);addPercentageInV8ExecuteOfTopEvents(values,model);addTotalPercentageInV8Execute(values,model);addV8ExecuteMutatorUtilization(values,model);}tr.metrics.MetricRegistry.register(gcMetric);var timeDurationInMs_smallerIsBetter=tr.b.Unit.byName.timeDurationInMs_smallerIsBetter;var percentage_biggerIsBetter=tr.b.Unit.byName.normalizedPercentage_biggerIsBetter;var percentage_smallerIsBetter=tr.b.Unit.byName.normalizedPercentage_smallerIsBetter;var CUSTOM_BOUNDARIES=tr.v.HistogramBinBoundaries.createLinear(0,20,200).addExponentialBins(200,100);function createNumericForTopEventTime(name){var n=new tr.v.Histogram(name,timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);n.customizeSummaryOptions({avg:true,count:true,max:true,min:false,std:true,sum:true,percentile:[0.90]});return n;}function createNumericForSubEventTime(name){var n=new tr.v.Histogram(name,timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);n.customizeSummaryOptions({avg:true,count:false,max:true,min:false,std:false,sum:false,percentile:[0.90]});return n;}function createNumericForIdleTime(name){var n=new tr.v.Histogram(name,timeDurationInMs_smallerIsBetter,CUSTOM_BOUNDARIES);n.customizeSummaryOptions({avg:true,count:false,max:true,min:false,std:false,sum:true,percentile:[]});return n;}function createPercentage(name,numerator,denominator,unit){var hist=new tr.v.Histogram(name,unit);if(denominator===0)hist.addSample(0);else hist.addSample(numerator/denominator);hist.customizeSummaryOptions({avg:true,count:false,max:false,min:false,std:false,sum:false,percentile:[]});return hist;}function isNotForcedTopGarbageCollectionEvent(event){return tr.metrics.v8.utils.isTopGarbageCollectionEvent(event)&&!tr.metrics.v8.utils.isForcedGarbageCollectionEvent(event);}function isNotForcedSubGarbageCollectionEvent(event){return tr.metrics.v8.utils.isSubGarbageCollectionEvent(event)&&!tr.metrics.v8.utils.isForcedGarbageCollectionEvent(event);}function addDurationOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedTopGarbageCollectionEvent,tr.metrics.v8.utils.topGarbageCollectionEventName,function(name,events){var cpuDuration=createNumericForTopEventTime(name);events.forEach(function(event){cpuDuration.addSample(event.cpuDuration);});values.addHistogram(cpuDuration);});}function addTotalDurationOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedTopGarbageCollectionEvent,event=>'v8-gc-total',function(name,events){var cpuDuration=createNumericForTopEventTime(name);events.forEach(function(event){cpuDuration.addSample(event.cpuDuration);});values.addHistogram(cpuDuration);});}function addDurationOfSubEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedSubGarbageCollectionEvent,tr.metrics.v8.utils.subGarbageCollectionEventName,function(name,events){var cpuDuration=createNumericForSubEventTime(name);events.forEach(function(event){cpuDuration.addSample(event.cpuDuration);});values.addHistogram(cpuDuration);});}function addIdleTimesOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedTopGarbageCollectionEvent,tr.metrics.v8.utils.topGarbageCollectionEventName,function(name,events){addIdleTimes(values,model,name,events);});}function addTotalIdleTimesOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedTopGarbageCollectionEvent,event=>'v8-gc-total',function(name,events){addIdleTimes(values,model,name,events);});}function addIdleTimes(values,model,name,events){var cpuDuration=createNumericForIdleTime();var insideIdle=createNumericForIdleTime();var outsideIdle=createNumericForIdleTime(name+'_outside_idle');var idleDeadlineOverrun=createNumericForIdleTime(name+'_idle_deadline_overrun');events.forEach(function(event){var idleTask=tr.metrics.v8.utils.findParent(event,tr.metrics.v8.utils.isIdleTask);var inside=0;var overrun=0;if(idleTask){var allottedTime=idleTask['args']['allotted_time_ms'];if(event.duration>allottedTime){overrun=event.duration-allottedTime;inside=event.cpuDuration*allottedTime/event.duration;}else{inside=event.cpuDuration;}}cpuDuration.addSample(event.cpuDuration);insideIdle.addSample(inside);outsideIdle.addSample(event.cpuDuration-inside);idleDeadlineOverrun.addSample(overrun);});values.addHistogram(idleDeadlineOverrun);values.addHistogram(outsideIdle);var percentage=createPercentage(name+'_percentage_idle',insideIdle.sum,cpuDuration.sum,percentage_biggerIsBetter);values.addHistogram(percentage);}function addPercentageInV8ExecuteOfTopEvents(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedTopGarbageCollectionEvent,tr.metrics.v8.utils.topGarbageCollectionEventName,function(name,events){addPercentageInV8Execute(values,model,name,events);});}function addTotalPercentageInV8Execute(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,isNotForcedTopGarbageCollectionEvent,event=>'v8-gc-total',function(name,events){addPercentageInV8Execute(values,model,name,events);});}function addPercentageInV8Execute(values,model,name,events){var cpuDurationInV8Execute=0;var cpuDurationTotal=0;events.forEach(function(event){var v8Execute=tr.metrics.v8.utils.findParent(event,tr.metrics.v8.utils.isV8ExecuteEvent);if(v8Execute){cpuDurationInV8Execute+=event.cpuDuration;}cpuDurationTotal+=event.cpuDuration;});var percentage=createPercentage(name+'_percentage_in_v8_execute',cpuDurationInV8Execute,cpuDurationTotal,percentage_smallerIsBetter);values.addHistogram(percentage);}function addV8ExecuteMutatorUtilization(values,model){tr.metrics.v8.utils.groupAndProcessEvents(model,tr.metrics.v8.utils.isTopV8ExecuteEvent,event=>'v8-execute',function(name,events){events.sort((a,b)=>a.start-b.start);var time=0;var pauses=[];for(var topEvent of events){for(var e of topEvent.enumerateAllDescendents()){if(isNotForcedTopGarbageCollectionEvent(e)){pauses.push({start:e.start-topEvent.start+time,end:e.end-topEvent.start+time});}}time+=topEvent.duration;}var mutatorUtilization=tr.metrics.v8.utils.mutatorUtilization(0,time,WINDOW_SIZE_MS,pauses);[0.90,0.95,0.99].forEach(function(percent){var hist=new tr.v.Histogram('v8-execute-mutator-utilization_pct_0'+percent*100,percentage_biggerIsBetter);hist.addSample(mutatorUtilization.percentile(1.0-percent));values.addHistogram(hist);});var hist=new tr.v.Histogram('v8-execute-mutator-utilization_min',percentage_biggerIsBetter);hist.addSample(mutatorUtilization.min);values.addHistogram(hist);});}return{gcMetric:gcMetric,WINDOW_SIZE_MS:WINDOW_SIZE_MS};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/range.js":53,"../../base/unit.js":63,"../../value/histogram.js":195,"../metric_registry.js":89,"./utils.js":105}],105:[function(require,module,exports){(function(global){"use strict";require("../../base/piecewise_linear_function.js");require("../../base/range.js");require("../../base/range_utils.js");require("../../base/unit.js");require("../metric_registry.js");require("../../value/histogram.js");'use strict';global.tr.exportTo('tr.metrics.v8.utils',function(){var IDLE_TASK_EVENT='SingleThreadIdleTaskRunner::RunTask';var V8_EXECUTE='V8.Execute';var GC_EVENT_PREFIX='V8.GC';var FULL_GC_EVENT='V8.GCCompactor';var LOW_MEMORY_EVENT='V8.GCLowMemoryNotification';var MAJOR_GC_EVENT='MajorGC';var MINOR_GC_EVENT='MinorGC';var TOP_GC_EVENTS={'V8.GCCompactor':'v8-gc-full-mark-compactor','V8.GCFinalizeMC':'v8-gc-latency-mark-compactor','V8.GCFinalizeMCReduceMemory':'v8-gc-memory-mark-compactor','V8.GCIncrementalMarking':'v8-gc-incremental-step','V8.GCIncrementalMarkingFinalize':'v8-gc-incremental-finalize','V8.GCIncrementalMarkingStart':'v8-gc-incremental-start','V8.GCPhantomHandleProcessingCallback':'v8-gc-phantom-handle-callback','V8.GCScavenger':'v8-gc-scavenger'};var LOW_MEMORY_MARK_COMPACTOR='v8-gc-low-memory-mark-compactor';function findParent(event,predicate){var parent=event.parentSlice;while(parent){if(predicate(parent)){return parent;}parent=parent.parentSlice;}return null;}function isIdleTask(event){return event.title===IDLE_TASK_EVENT;}function isLowMemoryEvent(event){return event.title===LOW_MEMORY_EVENT;}function isV8ExecuteEvent(event){return event.title===V8_EXECUTE;}function isTopV8ExecuteEvent(event){return isV8ExecuteEvent(event)&&findParent(isV8ExecuteEvent)===null;}function isGarbageCollectionEvent(event){return event.title&&event.title.startsWith(GC_EVENT_PREFIX)&&event.title!=LOW_MEMORY_EVENT;}function isTopGarbageCollectionEvent(event){return event.title in TOP_GC_EVENTS;}function isForcedGarbageCollectionEvent(event){return findParent(event,isLowMemoryEvent)!==null;}function isSubGarbageCollectionEvent(event){return isGarbageCollectionEvent(event)&&event.parentSlice&&(isTopGarbageCollectionEvent(event.parentSlice)||event.parentSlice.title===MAJOR_GC_EVENT||event.parentSlice.title===MINOR_GC_EVENT);}function topGarbageCollectionEventName(event){if(event.title===FULL_GC_EVENT){if(findParent(event,isLowMemoryEvent)){return LOW_MEMORY_MARK_COMPACTOR;}}return TOP_GC_EVENTS[event.title];}function subGarbageCollectionEventName(event){var topEvent=findParent(event,isTopGarbageCollectionEvent);var prefix=topEvent?topGarbageCollectionEventName(topEvent):'unknown';var name=event.title.replace('V8.GC_MC_','').replace('V8.GC_SCAVENGER_','').replace('V8.GC_','').replace(/_/g,'-').toLowerCase();return prefix+'-'+name;}function groupAndProcessEvents(model,filterCallback,nameCallback,processCallback){var nameToEvents={};for(var event of model.getDescendantEvents()){if(!filterCallback(event))continue;var name=nameCallback(event);nameToEvents[name]=nameToEvents[name]||[];nameToEvents[name].push(event);}tr.b.iterItems(nameToEvents,function(name,events){processCallback(name,events);});}function unionOfIntervals(intervals){if(intervals.length===0)return[];return tr.b.mergeRanges(intervals.map(x=>({min:x.start,max:x.end})),1e-6,function(ranges){return{start:ranges.reduce((acc,x)=>Math.min(acc,x.min),ranges[0].min),end:ranges.reduce((acc,x)=>Math.max(acc,x.max),ranges[0].max)};});}function WindowEndpoint(start,points){this.points=points;this.lastIndex=-1;this.position=start;this.distanceUntilNextPoint=points[0].position-start;this.cummulativePause=0;this.stackDepth=0;}WindowEndpoint.prototype={advance:function(delta){var points=this.points;if(delta<this.distanceUntilNextPoint){this.position+=delta;this.cummulativePause+=this.stackDepth>0?delta:0;this.distanceUntilNextPoint=points[this.lastIndex+1].position-this.position;}else{this.position+=this.distanceUntilNextPoint;this.cummulativePause+=this.stackDepth>0?this.distanceUntilNextPoint:0;this.distanceUntilNextPoint=0;this.lastIndex++;if(this.lastIndex<points.length){this.stackDepth+=points[this.lastIndex].delta;if(this.lastIndex+1<points.length)this.distanceUntilNextPoint=points[this.lastIndex+1].position-this.position;}}}};function mutatorUtilization(start,end,timeWindow,intervals){var mu=new tr.b.PiecewiseLinearFunction();if(end-start<=timeWindow)return mu;if(intervals.length===0){mu.push(start,1.0,end-timeWindow,1.0);return mu;}intervals=unionOfIntervals(intervals);var points=[];intervals.forEach(function(interval){points.push({position:interval.start,delta:1});points.push({position:interval.end,delta:-1});});points.sort((a,b)=>a.position-b.position);points.push({position:end,delta:0});var left=new WindowEndpoint(start,points);var right=new WindowEndpoint(start,points);while(right.position-left.position<timeWindow)right.advance(timeWindow-(right.position-left.position));while(right.lastIndex<points.length){var distanceUntilNextPoint=Math.min(left.distanceUntilNextPoint,right.distanceUntilNextPoint);var position1=left.position;var value1=right.cummulativePause-left.cummulativePause;left.advance(distanceUntilNextPoint);right.advance(distanceUntilNextPoint);if(distanceUntilNextPoint>0){var position2=left.position;var value2=right.cummulativePause-left.cummulativePause;mu.push(position1,1.0-value1/timeWindow,position2,1.0-value2/timeWindow);}}return mu;}function hasV8Stats(globalMemoryDump){var v8stats=undefined;globalMemoryDump.iterateContainerDumps(function(dump){v8stats=v8stats||dump.getMemoryAllocatorDumpByFullName('v8');});return!!v8stats;}function rangeForMemoryDumps(model){var startOfFirstDumpWithV8=model.globalMemoryDumps.filter(hasV8Stats).reduce((start,dump)=>Math.min(start,dump.start),Infinity);if(startOfFirstDumpWithV8===Infinity)return new tr.b.Range();return tr.b.Range.fromExplicitRange(startOfFirstDumpWithV8,Infinity);}return{findParent:findParent,groupAndProcessEvents:groupAndProcessEvents,isForcedGarbageCollectionEvent:isForcedGarbageCollectionEvent,isGarbageCollectionEvent:isGarbageCollectionEvent,isIdleTask:isIdleTask,isLowMemoryEvent:isLowMemoryEvent,isSubGarbageCollectionEvent:isSubGarbageCollectionEvent,isTopGarbageCollectionEvent:isTopGarbageCollectionEvent,isTopV8ExecuteEvent:isTopV8ExecuteEvent,isV8ExecuteEvent:isV8ExecuteEvent,mutatorUtilization:mutatorUtilization,subGarbageCollectionEventName:subGarbageCollectionEventName,topGarbageCollectionEventName:topGarbageCollectionEventName,rangeForMemoryDumps:rangeForMemoryDumps,unionOfIntervals:unionOfIntervals};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/piecewise_linear_function.js":50,"../../base/range.js":53,"../../base/range_utils.js":54,"../../base/unit.js":63,"../../value/histogram.js":195,"../metric_registry.js":89}],106:[function(require,module,exports){(function(global){"use strict";require("../metric_registry.js");require("../system_health/memory_metric.js");require("./execution_metric.js");require("./gc_metric.js");'use strict';global.tr.exportTo('tr.metrics.v8',function(){function v8AndMemoryMetrics(values,model){tr.metrics.v8.executionMetric(values,model);tr.metrics.v8.gcMetric(values,model);tr.metrics.sh.memoryMetric(values,model,{rangeOfInterest:tr.metrics.v8.utils.rangeForMemoryDumps(model)});}tr.metrics.MetricRegistry.register(v8AndMemoryMetrics);return{v8AndMemoryMetrics:v8AndMemoryMetrics};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../metric_registry.js":89,"../system_health/memory_metric.js":96,"./execution_metric.js":103,"./gc_metric.js":104}],107:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./event_info.js");require("./event_set.js");require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){function Alert(info,start,opt_associatedEvents,opt_args){tr.model.TimedEvent.call(this,start);this.info=info;this.args=opt_args||{};this.associatedEvents=new tr.model.EventSet(opt_associatedEvents);this.associatedEvents.forEach(function(event){event.addAssociatedAlert(this);},this);}Alert.prototype={__proto__:tr.model.TimedEvent.prototype,get title(){return this.info.title;},get colorId(){return this.info.colorId;},get userFriendlyName(){return'Alert '+this.title+' at '+tr.b.Unit.byName.timeStampInMs.format(this.start);}};tr.model.EventRegistry.register(Alert,{name:'alert',pluralName:'alerts'});return{Alert:Alert};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./event_info.js":124,"./event_set.js":126,"./timed_event.js":166}],108:[function(require,module,exports){(function(global){"use strict";require("../base/extension_registry.js");require("../base/guid.js");'use strict';global.tr.exportTo('tr.model',function(){function Annotation(){this.guid_=tr.b.GUID.allocateSimple();this.view_=undefined;};Annotation.fromDictIfPossible=function(args){if(args.typeName===undefined)throw new Error('Missing typeName argument');var typeInfo=Annotation.findTypeInfoMatching(function(typeInfo){return typeInfo.metadata.typeName===args.typeName;});if(typeInfo===undefined)return undefined;return typeInfo.constructor.fromDict(args);};Annotation.fromDict=function(){throw new Error('Not implemented');};Annotation.prototype={get guid(){return this.guid_;},onRemove:function(){},toDict:function(){throw new Error('Not implemented');},getOrCreateView:function(viewport){if(!this.view_)this.view_=this.createView_(viewport);return this.view_;},createView_:function(){throw new Error('Not implemented');}};var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);tr.b.decorateExtensionRegistry(Annotation,options);Annotation.addEventListener('will-register',function(e){if(!e.typeInfo.constructor.hasOwnProperty('fromDict'))throw new Error('Must have fromDict method');if(!e.typeInfo.metadata.typeName)throw new Error('Registered Annotations must provide typeName');});return{Annotation:Annotation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/extension_registry.js":41,"../base/guid.js":45}],109:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){function AsyncSlice(category,title,colorId,start,args,duration,opt_isTopLevel,opt_cpuStart,opt_cpuDuration,opt_argsStripped){tr.model.TimedEvent.call(this,start);this.category=category||'';this.originalTitle=title;this.title=title;this.colorId=colorId;this.args=args;this.startStackFrame=undefined;this.endStackFrame=undefined;this.didNotFinish=false;this.important=false;this.subSlices=[];this.parentContainer_=undefined;this.id=undefined;this.startThread=undefined;this.endThread=undefined;this.cpuStart=undefined;this.cpuDuration=undefined;this.argsStripped=false;this.startStackFrame=undefined;this.endStackFrame=undefined;this.duration=duration;this.isTopLevel=opt_isTopLevel===true;if(opt_cpuStart!==undefined)this.cpuStart=opt_cpuStart;if(opt_cpuDuration!==undefined)this.cpuDuration=opt_cpuDuration;if(opt_argsStripped!==undefined)this.argsStripped=opt_argsStripped;}AsyncSlice.prototype={__proto__:tr.model.TimedEvent.prototype,get analysisTypeName(){return this.title;},get parentContainer(){return this.parentContainer_;},set parentContainer(parentContainer){this.parentContainer_=parentContainer;for(var i=0;i<this.subSlices.length;i++){var subSlice=this.subSlices[i];if(subSlice.parentContainer===undefined)subSlice.parentContainer=parentContainer;}},get viewSubGroupTitle(){return this.title;},get userFriendlyName(){return'Async slice '+this.title+' at '+tr.b.Unit.byName.timeStampInMs.format(this.start);},get stableId(){var parentAsyncSliceGroup=this.parentContainer.asyncSliceGroup;return parentAsyncSliceGroup.stableId+'.'+parentAsyncSliceGroup.slices.indexOf(this);},findTopmostSlicesRelativeToThisSlice:function*(eventPredicate,opt_this){if(eventPredicate(this)){yield this;return;}for(var s of this.subSlices)yield*s.findTopmostSlicesRelativeToThisSlice(eventPredicate);},findDescendentSlice:function(targetTitle){if(!this.subSlices)return undefined;for(var i=0;i<this.subSlices.length;i++){if(this.subSlices[i].title==targetTitle)return this.subSlices[i];var slice=this.subSlices[i].findDescendentSlice(targetTitle);if(slice)return slice;}return undefined;},enumerateAllDescendents:function*(){for(var slice of this.subSlices)yield slice;for(var slice of this.subSlices)yield*slice.enumerateAllDescendents();},compareTo:function(that){return this.title.localeCompare(that.title);}};tr.model.EventRegistry.register(AsyncSlice,{name:'asyncSlice',pluralName:'asyncSlices'});return{AsyncSlice:AsyncSlice};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./timed_event.js":166}],110:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/range.js");require("./async_slice.js");require("./event_container.js");'use strict';global.tr.exportTo('tr.model',function(){function AsyncSliceGroup(parentContainer,opt_name){tr.model.EventContainer.call(this);this.parentContainer_=parentContainer;this.slices=[];this.name_=opt_name;this.viewSubGroups_=undefined;}AsyncSliceGroup.prototype={__proto__:tr.model.EventContainer.prototype,get parentContainer(){return this.parentContainer_;},get model(){return this.parentContainer_.parent.model;},get stableId(){return this.parentContainer_.stableId+'.AsyncSliceGroup';},getSettingsKey:function(){if(!this.name_)return undefined;var parentKey=this.parentContainer_.getSettingsKey();if(!parentKey)return undefined;return parentKey+'.'+this.name_;},push:function(slice){slice.parentContainer=this.parentContainer;this.slices.push(slice);return slice;},get length(){return this.slices.length;},shiftTimestampsForward:function(amount){for(var sI=0;sI<this.slices.length;sI++){var slice=this.slices[sI];slice.start=slice.start+amount;var shiftSubSlices=function(subSlices){if(subSlices===undefined||subSlices.length===0)return;for(var sJ=0;sJ<subSlices.length;sJ++){subSlices[sJ].start+=amount;shiftSubSlices(subSlices[sJ].subSlices);}};shiftSubSlices(slice.subSlices);}},updateBounds:function(){this.bounds.reset();for(var i=0;i<this.slices.length;i++){this.bounds.addValue(this.slices[i].start);this.bounds.addValue(this.slices[i].end);}},get viewSubGroups(){if(this.viewSubGroups_===undefined){var prefix='';if(this.name!==undefined)prefix=this.name+'.';else prefix='';var subGroupsByTitle={};for(var i=0;i<this.slices.length;++i){var slice=this.slices[i];var subGroupTitle=slice.viewSubGroupTitle;if(!subGroupsByTitle[subGroupTitle]){subGroupsByTitle[subGroupTitle]=new AsyncSliceGroup(this.parentContainer_,prefix+subGroupTitle);}subGroupsByTitle[subGroupTitle].push(slice);}this.viewSubGroups_=tr.b.dictionaryValues(subGroupsByTitle);this.viewSubGroups_.sort(function(a,b){return a.slices[0].compareTo(b.slices[0]);});}return this.viewSubGroups_;},findTopmostSlicesInThisContainer:function*(eventPredicate,opt_this){for(var slice of this.slices){if(slice.isTopLevel){yield*slice.findTopmostSlicesRelativeToThisSlice(eventPredicate,opt_this);}}},childEvents:function*(){for(var slice of this.slices){yield slice;if(slice.subSlices)yield*slice.subSlices;}},childEventContainers:function*(){}};return{AsyncSliceGroup:AsyncSliceGroup};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/range.js":53,"./async_slice.js":109,"./event_container.js":123}],111:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");'use strict';global.tr.exportTo('tr.model',function(){var ClockDomainId={BATTOR:'BATTOR',UNKNOWN_CHROME_LEGACY:'UNKNOWN_CHROME_LEGACY',LINUX_CLOCK_MONOTONIC:'LINUX_CLOCK_MONOTONIC',LINUX_FTRACE_GLOBAL:'LINUX_FTRACE_GLOBAL',MAC_MACH_ABSOLUTE_TIME:'MAC_MACH_ABSOLUTE_TIME',WIN_ROLLOVER_PROTECTED_TIME_GET_TIME:'WIN_ROLLOVER_PROTECTED_TIME_GET_TIME',WIN_QPC:'WIN_QPC',TELEMETRY:'TELEMETRY'};var POSSIBLE_CHROME_CLOCK_DOMAINS=new Set([ClockDomainId.UNKNOWN_CHROME_LEGACY,ClockDomainId.LINUX_CLOCK_MONOTONIC,ClockDomainId.MAC_MACH_ABSOLUTE_TIME,ClockDomainId.WIN_ROLLOVER_PROTECTED_TIME_GET_TIME,ClockDomainId.WIN_QPC]);var BATTOR_FAST_SYNC_THRESHOLD_MS=3;function ClockSyncManager(){this.domainsSeen_=new Set();this.markersBySyncId_=new Map();this.transformerMapByDomainId_={};}ClockSyncManager.prototype={addClockSyncMarker:function(domainId,syncId,startTs,opt_endTs){this.onDomainSeen_(domainId);if(tr.b.dictionaryValues(ClockDomainId).indexOf(domainId)<0){throw new Error('"'+domainId+'" is not in the list of known '+'clock domain IDs.');}if(this.modelDomainId_){throw new Error('Cannot add new clock sync markers after getting '+'a model time transformer.');}var marker=new ClockSyncMarker(domainId,startTs,opt_endTs);if(!this.markersBySyncId_.has(syncId)){this.markersBySyncId_.set(syncId,[marker]);return;}var markers=this.markersBySyncId_.get(syncId);if(markers.length===2){throw new Error('Clock sync with ID "'+syncId+'" is already '+'complete - cannot add a third clock sync marker to it.');}if(markers[0].domainId===domainId)throw new Error('A clock domain cannot sync with itself.');markers.push(marker);this.onSyncCompleted_(markers[0],marker);},get markersBySyncId(){return this.markersBySyncId_;},get domainsSeen(){return this.domainsSeen_;},getModelTimeTransformer:function(domainId){return this.getModelTimeTransformerRaw_(domainId).fn;},getModelTimeTransformerError:function(domainId){return this.getModelTimeTransformerRaw_(domainId).error;},getModelTimeTransformerRaw_:function(domainId){this.onDomainSeen_(domainId);if(!this.modelDomainId_)this.selectModelDomainId_();var transformer=this.getTransformerBetween_(domainId,this.modelDomainId_);if(!transformer){throw new Error('No clock sync markers exist pairing clock domain "'+domainId+'" '+'with model clock domain "'+this.modelDomainId_+'".');}return transformer;},getTransformerBetween_:function(fromDomainId,toDomainId){var visitedDomainIds=new Set();var queue=[{domainId:fromDomainId,transformer:Transformer.IDENTITY}];while(queue.length>0){queue.sort((domain1,domain2)=>domain1.transformer.error-domain2.transformer.error);var current=queue.shift();if(current.domainId===toDomainId)return current.transformer;if(visitedDomainIds.has(current.domainId))continue;visitedDomainIds.add(current.domainId);var outgoingTransformers=this.transformerMapByDomainId_[current.domainId];if(!outgoingTransformers)continue;for(var outgoingDomainId in outgoingTransformers){var toNextDomainTransformer=outgoingTransformers[outgoingDomainId];var toCurrentDomainTransformer=current.transformer;queue.push({domainId:outgoingDomainId,transformer:Transformer.compose(toNextDomainTransformer,toCurrentDomainTransformer)});}}return undefined;},selectModelDomainId_:function(){this.ensureAllDomainsAreConnected_();for(var chromeDomainId of POSSIBLE_CHROME_CLOCK_DOMAINS){if(this.domainsSeen_.has(chromeDomainId)){this.modelDomainId_=chromeDomainId;return;}}var domainsSeenArray=Array.from(this.domainsSeen_);domainsSeenArray.sort();this.modelDomainId_=domainsSeenArray[0];},ensureAllDomainsAreConnected_:function(){var firstDomainId=undefined;for(var domainId of this.domainsSeen_){if(!firstDomainId){firstDomainId=domainId;continue;}if(!this.getTransformerBetween_(firstDomainId,domainId)){throw new Error('Unable to select a master clock domain because no '+'path can be found from "'+firstDomainId+'" to "'+domainId+'".');}}return true;},onDomainSeen_:function(domainId){if(domainId===ClockDomainId.UNKNOWN_CHROME_LEGACY&&!this.domainsSeen_.has(ClockDomainId.UNKNOWN_CHROME_LEGACY)){for(var chromeDomainId of POSSIBLE_CHROME_CLOCK_DOMAINS){if(chromeDomainId===ClockDomainId.UNKNOWN_CHROME_LEGACY)continue;this.collapseDomains_(ClockDomainId.UNKNOWN_CHROME_LEGACY,chromeDomainId);}}this.domainsSeen_.add(domainId);},onSyncCompleted_:function(marker1,marker2){var forwardTransformer=Transformer.fromMarkers(marker1,marker2);var backwardTransformer=Transformer.fromMarkers(marker2,marker1);var existingTransformer=this.getOrCreateTransformerMap_(marker1.domainId)[marker2.domainId];if(!existingTransformer||forwardTransformer.error<existingTransformer.error){this.getOrCreateTransformerMap_(marker1.domainId)[marker2.domainId]=forwardTransformer;this.getOrCreateTransformerMap_(marker2.domainId)[marker1.domainId]=backwardTransformer;}},collapseDomains_:function(domain1Id,domain2Id){this.getOrCreateTransformerMap_(domain1Id)[domain2Id]=this.getOrCreateTransformerMap_(domain2Id)[domain1Id]=Transformer.IDENTITY;},getOrCreateTransformerMap_:function(domainId){if(!this.transformerMapByDomainId_[domainId])this.transformerMapByDomainId_[domainId]={};return this.transformerMapByDomainId_[domainId];}};function ClockSyncMarker(domainId,startTs,opt_endTs){this.domainId=domainId;this.startTs=startTs;this.endTs=opt_endTs===undefined?startTs:opt_endTs;}ClockSyncMarker.prototype={get duration(){return this.endTs-this.startTs;},get ts(){return this.startTs+this.duration/2;}};function Transformer(fn,error){this.fn=fn;this.error=error;}Transformer.IDENTITY=new Transformer(tr.b.identity,0);Transformer.compose=function(aToB,bToC){return new Transformer(ts=>bToC.fn(aToB.fn(ts)),aToB.error+bToC.error);};Transformer.fromMarkers=function(fromMarker,toMarker){var fromTs=fromMarker.ts,toTs=toMarker.ts;if(fromMarker.domainId===ClockDomainId.BATTOR&&toMarker.duration>BATTOR_FAST_SYNC_THRESHOLD_MS){toTs=toMarker.startTs;}else if(toMarker.domainId===ClockDomainId.BATTOR&&fromMarker.duration>BATTOR_FAST_SYNC_THRESHOLD_MS){fromTs=fromMarker.startTs;}var tsShift=toTs-fromTs;return new Transformer(ts=>ts+tsShift,fromMarker.duration+toMarker.duration);};return{ClockDomainId:ClockDomainId,ClockSyncManager:ClockSyncManager};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47}],112:[function(require,module,exports){(function(global){"use strict";require("./location.js");require("./annotation.js");require("./rect_annotation.js");require("../ui/annotations/comment_box_annotation_view.js");'use strict';global.tr.exportTo('tr.model',function(){function CommentBoxAnnotation(location,text){tr.model.Annotation.apply(this,arguments);this.location=location;this.text=text;}CommentBoxAnnotation.fromDict=function(dict){var args=dict.args;var location=new tr.model.Location(args.location.xWorld,args.location.yComponents);return new tr.model.CommentBoxAnnotation(location,args.text);};CommentBoxAnnotation.prototype={__proto__:tr.model.Annotation.prototype,onRemove:function(){this.view_.removeTextArea();},toDict:function(){return{typeName:'comment_box',args:{text:this.text,location:this.location.toDict()}};},createView_:function(viewport){return new tr.ui.annotations.CommentBoxAnnotationView(viewport,this);}};tr.model.Annotation.register(CommentBoxAnnotation,{typeName:'comment_box'});return{CommentBoxAnnotation:CommentBoxAnnotation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../ui/annotations/comment_box_annotation_view.js":177,"./annotation.js":108,"./location.js":139,"./rect_annotation.js":152}],113:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){var CompoundEventSelectionState={NOT_SELECTED:0,EVENT_SELECTED:0x1,SOME_ASSOCIATED_EVENTS_SELECTED:0x2,ALL_ASSOCIATED_EVENTS_SELECTED:0x4,EVENT_AND_SOME_ASSOCIATED_SELECTED:0x1|0x2,EVENT_AND_ALL_ASSOCIATED_SELECTED:0x1|0x4};return{CompoundEventSelectionState:CompoundEventSelectionState};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],114:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){return{BROWSER_PROCESS_PID_REF:-1,OBJECT_DEFAULT_SCOPE:'ptr'};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],115:[function(require,module,exports){(function(global){"use strict";require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){function ContainerMemoryDump(start){tr.model.TimedEvent.call(this,start);this.levelOfDetail=undefined;this.memoryAllocatorDumps_=undefined;this.memoryAllocatorDumpsByFullName_=undefined;};ContainerMemoryDump.LevelOfDetail={BACKGROUND:0,LIGHT:1,DETAILED:2};ContainerMemoryDump.prototype={__proto__:tr.model.TimedEvent.prototype,shiftTimestampsForward:function(amount){this.start+=amount;},get memoryAllocatorDumps(){return this.memoryAllocatorDumps_;},set memoryAllocatorDumps(memoryAllocatorDumps){this.memoryAllocatorDumps_=memoryAllocatorDumps;this.forceRebuildingMemoryAllocatorDumpByFullNameIndex();},getMemoryAllocatorDumpByFullName:function(fullName){if(this.memoryAllocatorDumps_===undefined)return undefined;if(this.memoryAllocatorDumpsByFullName_===undefined){var index={};function addDumpsToIndex(dumps){dumps.forEach(function(dump){index[dump.fullName]=dump;addDumpsToIndex(dump.children);});};addDumpsToIndex(this.memoryAllocatorDumps_);this.memoryAllocatorDumpsByFullName_=index;}return this.memoryAllocatorDumpsByFullName_[fullName];},forceRebuildingMemoryAllocatorDumpByFullNameIndex:function(){this.memoryAllocatorDumpsByFullName_=undefined;},iterateRootAllocatorDumps:function(fn,opt_this){if(this.memoryAllocatorDumps===undefined)return;this.memoryAllocatorDumps.forEach(fn,opt_this||this);}};return{ContainerMemoryDump:ContainerMemoryDump};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./timed_event.js":166}],116:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/range.js");require("./counter_series.js");require("./event_container.js");'use strict';global.tr.exportTo('tr.model',function(){function Counter(parent,id,category,name){tr.model.EventContainer.call(this);this.parent_=parent;this.id_=id;this.category_=category||'';this.name_=name;this.series_=[];this.totals=[];}Counter.prototype={__proto__:tr.model.EventContainer.prototype,get parent(){return this.parent_;},get id(){return this.id_;},get category(){return this.category_;},get name(){return this.name_;},childEvents:function*(){},childEventContainers:function*(){yield*this.series;},set timestamps(arg){throw new Error('Bad counter API. No cookie.');},set seriesNames(arg){throw new Error('Bad counter API. No cookie.');},set seriesColors(arg){throw new Error('Bad counter API. No cookie.');},set samples(arg){throw new Error('Bad counter API. No cookie.');},addSeries:function(series){series.counter=this;series.seriesIndex=this.series_.length;this.series_.push(series);return series;},getSeries:function(idx){return this.series_[idx];},get series(){return this.series_;},get numSeries(){return this.series_.length;},get numSamples(){if(this.series_.length===0)return 0;return this.series_[0].length;},get timestamps(){if(this.series_.length===0)return[];return this.series_[0].timestamps;},getSampleStatistics:function(sampleIndices){sampleIndices.sort();var ret=[];this.series_.forEach(function(series){ret.push(series.getStatistics(sampleIndices));});return ret;},shiftTimestampsForward:function(amount){for(var i=0;i<this.series_.length;++i)this.series_[i].shiftTimestampsForward(amount);},updateBounds:function(){this.totals=[];this.maxTotal=0;this.bounds.reset();if(this.series_.length===0)return;var firstSeries=this.series_[0];var lastSeries=this.series_[this.series_.length-1];this.bounds.addValue(firstSeries.getTimestamp(0));this.bounds.addValue(lastSeries.getTimestamp(lastSeries.length-1));var numSeries=this.numSeries;this.maxTotal=-Infinity;for(var i=0;i<firstSeries.length;++i){var total=0;this.series_.forEach(function(series){total+=series.getSample(i).value;this.totals.push(total);}.bind(this));this.maxTotal=Math.max(total,this.maxTotal);}}};Counter.compare=function(x,y){var tmp=x.parent.compareTo(y);if(tmp!=0)return tmp;var tmp=x.name.localeCompare(y.name);if(tmp==0)return x.tid-y.tid;return tmp;};return{Counter:Counter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/range.js":53,"./counter_series.js":118,"./event_container.js":123}],117:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");require("../base/sorted_array_utils.js");require("../base/unit.js");require("./event.js");require("./event_registry.js");'use strict';global.tr.exportTo('tr.model',function(){function CounterSample(series,timestamp,value){tr.model.Event.call(this);this.series_=series;this.timestamp_=timestamp;this.value_=value;}CounterSample.groupByTimestamp=function(samples){var samplesByTimestamp=tr.b.group(samples,function(sample){return sample.timestamp;});var timestamps=tr.b.dictionaryKeys(samplesByTimestamp);timestamps.sort();var groups=[];for(var i=0;i<timestamps.length;i++){var ts=timestamps[i];var group=samplesByTimestamp[ts];group.sort(function(x,y){return x.series.seriesIndex-y.series.seriesIndex;});groups.push(group);}return groups;};CounterSample.prototype={__proto__:tr.model.Event.prototype,get series(){return this.series_;},get timestamp(){return this.timestamp_;},get value(){return this.value_;},set timestamp(timestamp){this.timestamp_=timestamp;},addBoundsToRange:function(range){range.addValue(this.timestamp);},getSampleIndex:function(){return tr.b.findLowIndexInSortedArray(this.series.timestamps,function(x){return x;},this.timestamp_);},get userFriendlyName(){return'Counter sample from '+this.series_.title+' at '+tr.b.Unit.byName.timeStampInMs.format(this.timestamp);}};tr.model.EventRegistry.register(CounterSample,{name:'counterSample',pluralName:'counterSamples'});return{CounterSample:CounterSample};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47,"../base/sorted_array_utils.js":58,"../base/unit.js":63,"./event.js":122,"./event_registry.js":125}],118:[function(require,module,exports){(function(global){"use strict";require("./counter_sample.js");require("./event_container.js");'use strict';global.tr.exportTo('tr.model',function(){var CounterSample=tr.model.CounterSample;function CounterSeries(name,color){tr.model.EventContainer.call(this);this.name_=name;this.color_=color;this.timestamps_=[];this.samples_=[];this.counter=undefined;this.seriesIndex=undefined;}CounterSeries.prototype={__proto__:tr.model.EventContainer.prototype,get length(){return this.timestamps_.length;},get name(){return this.name_;},get color(){return this.color_;},get samples(){return this.samples_;},get timestamps(){return this.timestamps_;},getSample:function(idx){return this.samples_[idx];},getTimestamp:function(idx){return this.timestamps_[idx];},addCounterSample:function(ts,val){var sample=new CounterSample(this,ts,val);this.addSample(sample);return sample;},addSample:function(sample){this.timestamps_.push(sample.timestamp);this.samples_.push(sample);},getStatistics:function(sampleIndices){var sum=0;var min=Number.MAX_VALUE;var max=-Number.MAX_VALUE;for(var i=0;i<sampleIndices.length;++i){var sample=this.getSample(sampleIndices[i]).value;sum+=sample;min=Math.min(sample,min);max=Math.max(sample,max);}return{min:min,max:max,avg:sum/sampleIndices.length,start:this.getSample(sampleIndices[0]).value,end:this.getSample(sampleIndices.length-1).value};},shiftTimestampsForward:function(amount){for(var i=0;i<this.timestamps_.length;++i){this.timestamps_[i]+=amount;this.samples_[i].timestamp=this.timestamps_[i];}},childEvents:function*(){yield*this.samples_;},childEventContainers:function*(){}};return{CounterSeries:CounterSeries};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./counter_sample.js":117,"./event_container.js":123}],119:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("./counter.js");require("./cpu_slice.js");require("./process_base.js");require("./thread_time_slice.js");'use strict';global.tr.exportTo('tr.model',function(){var ColorScheme=tr.b.ColorScheme;var Counter=tr.model.Counter;var CpuSlice=tr.model.CpuSlice;function Cpu(kernel,number){if(kernel===undefined||number===undefined)throw new Error('Missing arguments');this.kernel=kernel;this.cpuNumber=number;this.slices=[];this.counters={};this.bounds_=new tr.b.Range();this.samples_=undefined;this.lastActiveTimestamp_=undefined;this.lastActiveThread_=undefined;this.lastActiveName_=undefined;this.lastActiveArgs_=undefined;}Cpu.prototype={__proto__:tr.model.EventContainer.prototype,get samples(){return this.samples_;},get userFriendlyName(){return'CPU '+this.cpuNumber;},findTopmostSlicesInThisContainer:function*(eventPredicate,opt_this){for(var s of this.slices){yield*s.findTopmostSlicesRelativeToThisSlice(eventPredicate,opt_this);}},childEvents:function*(){yield*this.slices;if(this.samples_)yield*this.samples_;},childEventContainers:function*(){yield*tr.b.dictionaryValues(this.counters);},getOrCreateCounter:function(cat,name){var id=cat+'.'+name;if(!this.counters[id])this.counters[id]=new Counter(this,id,cat,name);return this.counters[id];},getCounter:function(cat,name){var id=cat+'.'+name;if(!this.counters[id])return undefined;return this.counters[id];},shiftTimestampsForward:function(amount){for(var sI=0;sI<this.slices.length;sI++)this.slices[sI].start=this.slices[sI].start+amount;for(var id in this.counters)this.counters[id].shiftTimestampsForward(amount);},updateBounds:function(){this.bounds_.reset();if(this.slices.length){this.bounds_.addValue(this.slices[0].start);this.bounds_.addValue(this.slices[this.slices.length-1].end);}for(var id in this.counters){this.counters[id].updateBounds();this.bounds_.addRange(this.counters[id].bounds);}if(this.samples_&&this.samples_.length){this.bounds_.addValue(this.samples_[0].start);this.bounds_.addValue(this.samples_[this.samples_.length-1].end);}},createSubSlices:function(){this.samples_=this.kernel.model.samples.filter(function(sample){return sample.cpu==this;},this);},addCategoriesToDict:function(categoriesDict){for(var i=0;i<this.slices.length;i++)categoriesDict[this.slices[i].category]=true;for(var id in this.counters)categoriesDict[this.counters[id].category]=true;for(var i=0;i<this.samples_.length;i++)categoriesDict[this.samples_[i].category]=true;},indexOf:function(cpuSlice){var i=tr.b.findLowIndexInSortedArray(this.slices,function(slice){return slice.start;},cpuSlice.start);if(this.slices[i]!==cpuSlice)return undefined;return i;},closeActiveThread:function(endTimestamp,args){if(this.lastActiveThread_==undefined||this.lastActiveThread_==0)return;if(endTimestamp<this.lastActiveTimestamp_){throw new Error('The end timestamp of a thread running on CPU '+this.cpuNumber+' is before its start timestamp.');}for(var key in args){this.lastActiveArgs_[key]=args[key];}var duration=endTimestamp-this.lastActiveTimestamp_;var slice=new tr.model.CpuSlice('',this.lastActiveName_,ColorScheme.getColorIdForGeneralPurposeString(this.lastActiveName_),this.lastActiveTimestamp_,this.lastActiveArgs_,duration);slice.cpu=this;this.slices.push(slice);this.lastActiveTimestamp_=undefined;this.lastActiveThread_=undefined;this.lastActiveName_=undefined;this.lastActiveArgs_=undefined;},switchActiveThread:function(timestamp,oldThreadArgs,newThreadId,newThreadName,newThreadArgs){this.closeActiveThread(timestamp,oldThreadArgs);this.lastActiveTimestamp_=timestamp;this.lastActiveThread_=newThreadId;this.lastActiveName_=newThreadName;this.lastActiveArgs_=newThreadArgs;},getFreqStatsForRange:function(range){var stats={};function addStatsForFreq(freqSample,index){var freqEnd=index<freqSample.series_.length-1?freqSample.series_.samples_[index+1].timestamp:range.max;var freqRange=tr.b.Range.fromExplicitRange(freqSample.timestamp,freqEnd);var intersection=freqRange.findIntersection(range);if(!(freqSample.value in stats))stats[freqSample.value]=0;stats[freqSample.value]+=intersection.duration;}var freqCounter=this.getCounter('','Clock Frequency');if(freqCounter!==undefined){var freqSeries=freqCounter.getSeries(0);if(!freqSeries)return;tr.b.iterateOverIntersectingIntervals(freqSeries.samples_,function(x){return x.timestamp;},function(x,index){return index<freqSeries.length-1?freqSeries.samples_[index+1].timestamp:range.max;},range.min,range.max,addStatsForFreq);}return stats;}};Cpu.compare=function(x,y){return x.cpuNumber-y.cpuNumber;};return{Cpu:Cpu};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"./counter.js":116,"./cpu_slice.js":120,"./process_base.js":150,"./thread_time_slice.js":164}],120:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("./thread_time_slice.js");'use strict';global.tr.exportTo('tr.model',function(){var Slice=tr.model.Slice;function CpuSlice(cat,title,colorId,start,args,opt_duration){Slice.apply(this,arguments);this.threadThatWasRunning=undefined;this.cpu=undefined;}CpuSlice.prototype={__proto__:Slice.prototype,get analysisTypeName(){return'tr.ui.analysis.CpuSlice';},getAssociatedTimeslice:function(){if(!this.threadThatWasRunning)return undefined;var timeSlices=this.threadThatWasRunning.timeSlices;for(var i=0;i<timeSlices.length;i++){var timeSlice=timeSlices[i];if(timeSlice.start!==this.start)continue;if(timeSlice.duration!==this.duration)continue;return timeSlice;}return undefined;}};tr.model.EventRegistry.register(CpuSlice,{name:'cpuSlice',pluralName:'cpuSlices'});return{CpuSlice:CpuSlice};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"./thread_time_slice.js":164}],121:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/range.js");require("./event_container.js");require("./power_series.js");'use strict';global.tr.exportTo('tr.model',function(){function Device(model){if(!model)throw new Error('Must provide a model.');tr.model.EventContainer.call(this);this.powerSeries_=undefined;this.vSyncTimestamps_=[];};Device.compare=function(x,y){return x.guid-y.guid;};Device.prototype={__proto__:tr.model.EventContainer.prototype,compareTo:function(that){return Device.compare(this,that);},get userFriendlyName(){return'Device';},get userFriendlyDetails(){return'Device';},get stableId(){return'Device';},getSettingsKey:function(){return'device';},get powerSeries(){return this.powerSeries_;},set powerSeries(powerSeries){this.powerSeries_=powerSeries;},get vSyncTimestamps(){return this.vSyncTimestamps_;},set vSyncTimestamps(value){this.vSyncTimestamps_=value;},updateBounds:function(){this.bounds.reset();for(var child of this.childEventContainers()){child.updateBounds();this.bounds.addRange(child.bounds);}},shiftTimestampsForward:function(amount){for(var child of this.childEventContainers()){child.shiftTimestampsForward(amount);}for(var i=0;i<this.vSyncTimestamps_.length;i++)this.vSyncTimestamps_[i]+=amount;},addCategoriesToDict:function(categoriesDict){},childEventContainers:function*(){if(this.powerSeries_)yield this.powerSeries_;}};return{Device:Device};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/range.js":53,"./event_container.js":123,"./power_series.js":148}],122:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/range.js");require("./event_set.js");require("./selectable_item.js");require("./selection_state.js");'use strict';global.tr.exportTo('tr.model',function(){var SelectableItem=tr.model.SelectableItem;var SelectionState=tr.model.SelectionState;var IMMUTABLE_EMPTY_SET=tr.model.EventSet.IMMUTABLE_EMPTY_SET;function Event(){SelectableItem.call(this,this);this.guid_=tr.b.GUID.allocateSimple();this.selectionState=SelectionState.NONE;this.info=undefined;}Event.prototype={__proto__:SelectableItem.prototype,get guid(){return this.guid_;},get stableId(){return undefined;},get range(){var range=new tr.b.Range();this.addBoundsToRange(range);return range;},associatedAlerts:IMMUTABLE_EMPTY_SET,addAssociatedAlert:function(alert){if(this.associatedAlerts===IMMUTABLE_EMPTY_SET)this.associatedAlerts=new tr.model.EventSet();this.associatedAlerts.push(alert);},addBoundsToRange:function(range){}};return{Event:Event};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/range.js":53,"./event_set.js":126,"./selectable_item.js":155,"./selection_state.js":156}],123:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/guid.js");require("../base/range.js");'use strict';global.tr.exportTo('tr.model',function(){function EventContainer(){this.guid_=tr.b.GUID.allocateSimple();this.important=true;this.bounds_=new tr.b.Range();}EventContainer.prototype={get guid(){return this.guid_;},get stableId(){throw new Error('Not implemented');},get bounds(){return this.bounds_;},updateBounds:function(){throw new Error('Not implemented');},shiftTimestampsForward:function(amount){throw new Error('Not implemented');},childEvents:function*(){},getDescendantEvents:function*(){yield*this.childEvents();for(var container of this.childEventContainers())yield*container.getDescendantEvents();},childEventContainers:function*(){},getDescendantEventContainers:function*(){yield this;for(var container of this.childEventContainers())yield*container.getDescendantEventContainers();},findTopmostSlicesInThisContainer:function*(eventPredicate,opt_this){},findTopmostSlices:function*(eventPredicate){for(var ec of this.getDescendantEventContainers())yield*ec.findTopmostSlicesInThisContainer(eventPredicate);},findTopmostSlicesNamed:function*(name){yield*this.findTopmostSlices(e=>e.title===name);}};return{EventContainer:EventContainer};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/guid.js":45,"../base/range.js":53}],124:[function(require,module,exports){(function(global){"use strict";require("../base/color_scheme.js");'use strict';global.tr.exportTo('tr.model',function(){var ColorScheme=tr.b.ColorScheme;function EventInfo(title,description,docLinks){this.title=title;this.description=description;this.docLinks=docLinks;this.colorId=ColorScheme.getColorIdForGeneralPurposeString(title);}return{EventInfo:EventInfo};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/color_scheme.js":38}],125:[function(require,module,exports){(function(global){"use strict";require("../base/extension_registry.js");'use strict';global.tr.exportTo('tr.model',function(){function EventRegistry(){}var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);tr.b.decorateExtensionRegistry(EventRegistry,options);EventRegistry.addEventListener('will-register',function(e){var metadata=e.typeInfo.metadata;if(metadata.name===undefined)throw new Error('Registered events must provide name metadata');if(metadata.pluralName===undefined)throw new Error('Registered events must provide pluralName metadata');if(metadata.subTypes===undefined){metadata.subTypes={};var options=new tr.b.ExtensionRegistryOptions(tr.b.TYPE_BASED_REGISTRY_MODE);options.mandatoryBaseClass=e.typeInfo.constructor;options.defaultConstructor=e.typeInfo.constructor;tr.b.decorateExtensionRegistry(metadata.subTypes,options);}else{if(!metadata.subTypes.register)throw new Error('metadata.subTypes must be an extension registry.');}e.typeInfo.constructor.subTypes=metadata.subTypes;});var eventsByTypeName=undefined;EventRegistry.getEventTypeInfoByTypeName=function(typeName){if(eventsByTypeName===undefined){eventsByTypeName={};EventRegistry.getAllRegisteredTypeInfos().forEach(function(typeInfo){eventsByTypeName[typeInfo.metadata.name]=typeInfo;});}return eventsByTypeName[typeName];};EventRegistry.addEventListener('registry-changed',function(){eventsByTypeName=undefined;});function convertCamelCaseToTitleCase(name){var result=name.replace(/[A-Z]/g,' $&');result=result.charAt(0).toUpperCase()+result.slice(1);return result;}EventRegistry.getUserFriendlySingularName=function(typeName){var typeInfo=EventRegistry.getEventTypeInfoByTypeName(typeName);var str=typeInfo.metadata.name;return convertCamelCaseToTitleCase(str);};EventRegistry.getUserFriendlyPluralName=function(typeName){var typeInfo=EventRegistry.getEventTypeInfoByTypeName(typeName);var str=typeInfo.metadata.pluralName;return convertCamelCaseToTitleCase(str);};return{EventRegistry:EventRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/extension_registry.js":41}],126:[function(require,module,exports){(function(global){"use strict";require("../base/event.js");require("../base/guid.js");require("../base/iteration_helpers.js");require("../base/range.js");require("./event_registry.js");'use strict';global.tr.exportTo('tr.model',function(){var EventRegistry=tr.model.EventRegistry;var RequestSelectionChangeEvent=tr.b.Event.bind(undefined,'requestSelectionChange',true,false);function EventSet(opt_events){this.bounds_=new tr.b.Range();this.events_=new Set();if(opt_events){if(opt_events instanceof Array){for(var event of opt_events)this.push(event);}else if(opt_events instanceof EventSet){this.addEventSet(opt_events);}else{this.push(opt_events);}}}EventSet.prototype={__proto__:Object.prototype,get bounds(){return this.bounds_;},get duration(){if(this.bounds_.isEmpty)return 0;return this.bounds_.max-this.bounds_.min;},get length(){return this.events_.size;},get guid(){return this.guid_;},*[Symbol.iterator](){for(var event of this.events_)yield event;},clear:function(){this.bounds_=new tr.b.Range();this.events_.clear();},push:function(event){if(event.guid==undefined)throw new Error('Event must have a GUID');if(!this.events_.has(event)){this.events_.add(event);if(event.addBoundsToRange)if(this.bounds_!==undefined)event.addBoundsToRange(this.bounds_);}return event;},contains:function(event){if(this.events_.has(event))return event;else return undefined;},addEventSet:function(eventSet){for(var event of eventSet)this.push(event);},intersectionIsEmpty:function(otherEventSet){return!this.some(event=>otherEventSet.contains(event));},equals:function(that){if(this.length!==that.length)return false;return this.every(event=>that.contains(event));},sortEvents:function(compare){var ary=this.toArray();ary.sort(compare);this.clear();for(var event of ary)this.push(event);},getEventsOrganizedByBaseType:function(opt_pruneEmpty){var allTypeInfos=EventRegistry.getAllRegisteredTypeInfos();var events=this.getEventsOrganizedByCallback(function(event){var maxEventIndex=-1;var maxEventTypeInfo=undefined;allTypeInfos.forEach(function(eventTypeInfo,eventIndex){if(!(event instanceof eventTypeInfo.constructor))return;if(eventIndex>maxEventIndex){maxEventIndex=eventIndex;maxEventTypeInfo=eventTypeInfo;}});if(maxEventIndex==-1){console.log(event);throw new Error('Unrecognized event type');}return maxEventTypeInfo.metadata.name;});if(!opt_pruneEmpty){allTypeInfos.forEach(function(eventTypeInfo){if(events[eventTypeInfo.metadata.name]===undefined)events[eventTypeInfo.metadata.name]=new EventSet();});}return events;},getEventsOrganizedByTitle:function(){return this.getEventsOrganizedByCallback(function(event){if(event.title===undefined)throw new Error('An event didn\'t have a title!');return event.title;});},getEventsOrganizedByCallback:function(cb,opt_this){var groupedEvents=tr.b.group(this,cb,opt_this||this);return tr.b.mapItems(groupedEvents,(_,events)=>new EventSet(events));},enumEventsOfType:function(type,func){for(var event of this)if(event instanceof type)func(event);},get userFriendlyName(){if(this.length===0){throw new Error('Empty event set');}var eventsByBaseType=this.getEventsOrganizedByBaseType(true);var eventTypeName=tr.b.dictionaryKeys(eventsByBaseType)[0];if(this.length===1){var tmp=EventRegistry.getUserFriendlySingularName(eventTypeName);return tr.b.getOnlyElement(this.events_).userFriendlyName;}var numEventTypes=tr.b.dictionaryLength(eventsByBaseType);if(numEventTypes!==1){return this.length+' events of various types';}var tmp=EventRegistry.getUserFriendlyPluralName(eventTypeName);return this.length+' '+tmp;},filter:function(fn,opt_this){var res=new EventSet();for(var event of this)if(fn.call(opt_this,event))res.push(event);return res;},toArray:function(){var ary=[];for(var event of this)ary.push(event);return ary;},forEach:function(fn,opt_this){for(var event of this)fn.call(opt_this,event);},map:function(fn,opt_this){var res=[];for(var event of this)res.push(fn.call(opt_this,event));return res;},every:function(fn,opt_this){for(var event of this)if(!fn.call(opt_this,event))return false;return true;},some:function(fn,opt_this){for(var event of this)if(fn.call(opt_this,event))return true;return false;},asDict:function(){var stableIds=[];for(var event of this)stableIds.push(event.stableId);return{'events':stableIds};},asSet:function(){return this.events_;}};EventSet.IMMUTABLE_EMPTY_SET=function(){var s=new EventSet();s.push=function(){throw new Error('Cannot push to an immutable event set');};s.addEventSet=function(){throw new Error('Cannot add to an immutable event set');};Object.freeze(s);return s;}();return{EventSet:EventSet,RequestSelectionChangeEvent:RequestSelectionChangeEvent};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/event.js":39,"../base/guid.js":45,"../base/iteration_helpers.js":47,"../base/range.js":53,"./event_registry.js":125}],127:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){function FlowEvent(category,id,title,colorId,start,args,opt_duration){tr.model.TimedEvent.call(this,start);this.category=category||'';this.title=title;this.colorId=colorId;this.start=start;this.args=args;this.id=id;this.startSlice=undefined;this.endSlice=undefined;this.startStackFrame=undefined;this.endStackFrame=undefined;if(opt_duration!==undefined)this.duration=opt_duration;}FlowEvent.prototype={__proto__:tr.model.TimedEvent.prototype,get userFriendlyName(){return'Flow event named '+this.title+' at '+tr.b.Unit.byName.timeStampInMs.format(this.timestamp);}};tr.model.EventRegistry.register(FlowEvent,{name:'flowEvent',pluralName:'flowEvents'});return{FlowEvent:FlowEvent};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./timed_event.js":166}],128:[function(require,module,exports){(function(global){"use strict";require("../base/color_scheme.js");require("../base/statistics.js");require("./event.js");require("./event_set.js");'use strict';global.tr.exportTo('tr.model',function(){var ColorScheme=tr.b.ColorScheme;var Statistics=tr.b.Statistics;var FRAME_PERF_CLASS={GOOD:'good',BAD:'bad',TERRIBLE:'terrible',NEUTRAL:'generic_work'};function Frame(associatedEvents,threadTimeRanges,opt_args){tr.model.Event.call(this);this.threadTimeRanges=threadTimeRanges;this.associatedEvents=new tr.model.EventSet(associatedEvents);this.args=opt_args||{};this.title='Frame';this.start=Statistics.min(threadTimeRanges,function(x){return x.start;});this.end=Statistics.max(threadTimeRanges,function(x){return x.end;});this.totalDuration=Statistics.sum(threadTimeRanges,function(x){return x.end-x.start;});this.perfClass=FRAME_PERF_CLASS.NEUTRAL;};Frame.prototype={__proto__:tr.model.Event.prototype,set perfClass(perfClass){this.colorId=ColorScheme.getColorIdForReservedName(perfClass);this.perfClass_=perfClass;},get perfClass(){return this.perfClass_;},shiftTimestampsForward:function(amount){this.start+=amount;this.end+=amount;for(var i=0;i<this.threadTimeRanges.length;i++){this.threadTimeRanges[i].start+=amount;this.threadTimeRanges[i].end+=amount;}},addBoundsToRange:function(range){range.addValue(this.start);range.addValue(this.end);}};tr.model.EventRegistry.register(Frame,{name:'frame',pluralName:'frames'});return{Frame:Frame,FRAME_PERF_CLASS:FRAME_PERF_CLASS};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/color_scheme.js":38,"../base/statistics.js":59,"./event.js":122,"./event_set.js":126}],129:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");require("../base/unit.js");require("./container_memory_dump.js");require("./event_registry.js");require("./memory_allocator_dump.js");require("../value/numeric.js");'use strict';global.tr.exportTo('tr.model',function(){function GlobalMemoryDump(model,start){tr.model.ContainerMemoryDump.call(this,start);this.model=model;this.processMemoryDumps={};}var SIZE_NUMERIC_NAME=tr.model.MemoryAllocatorDump.SIZE_NUMERIC_NAME;var EFFECTIVE_SIZE_NUMERIC_NAME=tr.model.MemoryAllocatorDump.EFFECTIVE_SIZE_NUMERIC_NAME;var MemoryAllocatorDumpInfoType=tr.model.MemoryAllocatorDumpInfoType;var PROVIDED_SIZE_LESS_THAN_AGGREGATED_CHILDREN=MemoryAllocatorDumpInfoType.PROVIDED_SIZE_LESS_THAN_AGGREGATED_CHILDREN;var PROVIDED_SIZE_LESS_THAN_LARGEST_OWNER=MemoryAllocatorDumpInfoType.PROVIDED_SIZE_LESS_THAN_LARGEST_OWNER;function inPlaceFilter(array,predicate,opt_this){opt_this=opt_this||this;var nextPosition=0;for(var i=0;i<array.length;i++){if(!predicate.call(opt_this,array[i],i))continue;if(nextPosition<i)array[nextPosition]=array[i];nextPosition++;}if(nextPosition<array.length)array.length=nextPosition;}function getSize(dump){var numeric=dump.numerics[SIZE_NUMERIC_NAME];if(numeric===undefined)return 0;return numeric.value;}function hasSize(dump){return dump.numerics[SIZE_NUMERIC_NAME]!==undefined;}function optional(value,defaultValue){if(value===undefined)return defaultValue;return value;}GlobalMemoryDump.prototype={__proto__:tr.model.ContainerMemoryDump.prototype,get userFriendlyName(){return'Global memory dump at '+tr.b.Unit.byName.timeStampInMs.format(this.start);},get containerName(){return'global space';},finalizeGraph:function(){this.removeWeakDumps();this.setUpTracingOverheadOwnership();this.aggregateNumerics();this.calculateSizes();this.calculateEffectiveSizes();this.discountTracingOverheadFromVmRegions();this.forceRebuildingMemoryAllocatorDumpByFullNameIndices();},removeWeakDumps:function(){this.traverseAllocatorDumpsInDepthFirstPreOrder(function(dump){if(dump.weak)return;if(dump.owns!==undefined&&dump.owns.target.weak||dump.parent!==undefined&&dump.parent.weak){dump.weak=true;}});function removeWeakDumpsFromListRecursively(dumps){inPlaceFilter(dumps,function(dump){if(dump.weak){return false;}removeWeakDumpsFromListRecursively(dump.children);inPlaceFilter(dump.ownedBy,function(ownershipLink){return!ownershipLink.source.weak;});return true;});}this.iterateContainerDumps(function(containerDump){var memoryAllocatorDumps=containerDump.memoryAllocatorDumps;if(memoryAllocatorDumps!==undefined)removeWeakDumpsFromListRecursively(memoryAllocatorDumps);});},calculateSizes:function(){this.traverseAllocatorDumpsInDepthFirstPostOrder(this.calculateMemoryAllocatorDumpSize_.bind(this));},calculateMemoryAllocatorDumpSize_:function(dump){var shouldDefineSize=false;function getDependencySize(dependencyDump){var numeric=dependencyDump.numerics[SIZE_NUMERIC_NAME];if(numeric===undefined)return 0;shouldDefineSize=true;return numeric.value;}var sizeNumeric=dump.numerics[SIZE_NUMERIC_NAME];var size=0;var checkDependencySizeIsConsistent=function(){};if(sizeNumeric!==undefined){size=sizeNumeric.value;shouldDefineSize=true;if(sizeNumeric.unit!==tr.b.Unit.byName.sizeInBytes_smallerIsBetter){this.model.importWarning({type:'memory_dump_parse_error',message:'Invalid unit of \'size\' numeric of memory allocator '+'dump '+dump.quantifiedName+': '+sizeNumeric.unit.unitName+'.'});}checkDependencySizeIsConsistent=function(dependencySize,dependencyInfoType,dependencyName){if(size>=dependencySize)return;this.model.importWarning({type:'memory_dump_parse_error',message:'Size provided by memory allocator dump \''+dump.fullName+'\''+tr.b.Unit.byName.sizeInBytes.format(size)+') is less than '+dependencyName+' ('+tr.b.Unit.byName.sizeInBytes.format(dependencySize)+').'});dump.infos.push({type:dependencyInfoType,providedSize:size,dependencySize:dependencySize});}.bind(this);}var aggregatedChildrenSize=0;var allOverlaps={};dump.children.forEach(function(childDump){function aggregateDescendantDump(descendantDump){var ownedDumpLink=descendantDump.owns;if(ownedDumpLink!==undefined&&ownedDumpLink.target.isDescendantOf(dump)){var ownedChildDump=ownedDumpLink.target;while(ownedChildDump.parent!==dump)ownedChildDump=ownedChildDump.parent;if(childDump!==ownedChildDump){var ownedBySiblingSize=getDependencySize(descendantDump);if(ownedBySiblingSize>0){var previousTotalOwnedBySiblingSize=ownedChildDump.ownedBySiblingSizes.get(childDump)||0;var updatedTotalOwnedBySiblingSize=previousTotalOwnedBySiblingSize+ownedBySiblingSize;ownedChildDump.ownedBySiblingSizes.set(childDump,updatedTotalOwnedBySiblingSize);}}return;}if(descendantDump.children.length===0){aggregatedChildrenSize+=getDependencySize(descendantDump);return;}descendantDump.children.forEach(aggregateDescendantDump);}aggregateDescendantDump(childDump);});checkDependencySizeIsConsistent(aggregatedChildrenSize,PROVIDED_SIZE_LESS_THAN_AGGREGATED_CHILDREN,'the aggregated size of its children');var largestOwnerSize=0;dump.ownedBy.forEach(function(ownershipLink){var owner=ownershipLink.source;var ownerSize=getDependencySize(owner);largestOwnerSize=Math.max(largestOwnerSize,ownerSize);});checkDependencySizeIsConsistent(largestOwnerSize,PROVIDED_SIZE_LESS_THAN_LARGEST_OWNER,'the size of its largest owner');if(!shouldDefineSize){delete dump.numerics[SIZE_NUMERIC_NAME];return;}size=Math.max(size,aggregatedChildrenSize,largestOwnerSize);dump.numerics[SIZE_NUMERIC_NAME]=new tr.v.ScalarNumeric(tr.b.Unit.byName.sizeInBytes_smallerIsBetter,size);if(aggregatedChildrenSize<size&&dump.children!==undefined&&dump.children.length>0){var virtualChild=new tr.model.MemoryAllocatorDump(dump.containerMemoryDump,dump.fullName+'/<unspecified>');virtualChild.parent=dump;dump.children.unshift(virtualChild);virtualChild.numerics[SIZE_NUMERIC_NAME]=new tr.v.ScalarNumeric(tr.b.Unit.byName.sizeInBytes_smallerIsBetter,size-aggregatedChildrenSize);}},calculateEffectiveSizes:function(){this.traverseAllocatorDumpsInDepthFirstPostOrder(this.calculateDumpSubSizes_.bind(this));this.traverseAllocatorDumpsInDepthFirstPostOrder(this.calculateDumpOwnershipCoefficient_.bind(this));this.traverseAllocatorDumpsInDepthFirstPreOrder(this.calculateDumpCumulativeOwnershipCoefficient_.bind(this));this.traverseAllocatorDumpsInDepthFirstPostOrder(this.calculateDumpEffectiveSize_.bind(this));},calculateDumpSubSizes_:function(dump){if(!hasSize(dump))return;if(dump.children===undefined||dump.children.length===0){var size=getSize(dump);dump.notOwningSubSize_=size;dump.notOwnedSubSize_=size;return;}var notOwningSubSize=0;dump.children.forEach(function(childDump){if(childDump.owns!==undefined)return;notOwningSubSize+=optional(childDump.notOwningSubSize_,0);});dump.notOwningSubSize_=notOwningSubSize;var notOwnedSubSize=0;dump.children.forEach(function(childDump){if(childDump.ownedBy.length===0){notOwnedSubSize+=optional(childDump.notOwnedSubSize_,0);return;}var largestChildOwnerSize=0;childDump.ownedBy.forEach(function(ownershipLink){largestChildOwnerSize=Math.max(largestChildOwnerSize,getSize(ownershipLink.source));});notOwnedSubSize+=getSize(childDump)-largestChildOwnerSize;});dump.notOwnedSubSize_=notOwnedSubSize;},calculateDumpOwnershipCoefficient_:function(dump){if(!hasSize(dump))return;if(dump.ownedBy.length===0)return;var owners=dump.ownedBy.map(function(ownershipLink){return{dump:ownershipLink.source,importance:optional(ownershipLink.importance,0),notOwningSubSize:optional(ownershipLink.source.notOwningSubSize_,0)};});owners.sort(function(a,b){if(a.importance===b.importance)return a.notOwningSubSize-b.notOwningSubSize;return b.importance-a.importance;});var currentImportanceStartPos=0;var alreadyAttributedSubSize=0;while(currentImportanceStartPos<owners.length){var currentImportance=owners[currentImportanceStartPos].importance;var nextImportanceStartPos=currentImportanceStartPos+1;while(nextImportanceStartPos<owners.length&&owners[nextImportanceStartPos].importance===currentImportance){nextImportanceStartPos++;}var attributedNotOwningSubSize=0;for(var pos=currentImportanceStartPos;pos<nextImportanceStartPos;pos++){var owner=owners[pos];var notOwningSubSize=owner.notOwningSubSize;if(notOwningSubSize>alreadyAttributedSubSize){attributedNotOwningSubSize+=(notOwningSubSize-alreadyAttributedSubSize)/(nextImportanceStartPos-pos);alreadyAttributedSubSize=notOwningSubSize;}var owningCoefficient=0;if(notOwningSubSize!==0)owningCoefficient=attributedNotOwningSubSize/notOwningSubSize;owner.dump.owningCoefficient_=owningCoefficient;}currentImportanceStartPos=nextImportanceStartPos;}var notOwnedSubSize=optional(dump.notOwnedSubSize_,0);var remainderSubSize=notOwnedSubSize-alreadyAttributedSubSize;var ownedCoefficient=0;if(notOwnedSubSize!==0)ownedCoefficient=remainderSubSize/notOwnedSubSize;dump.ownedCoefficient_=ownedCoefficient;},calculateDumpCumulativeOwnershipCoefficient_:function(dump){if(!hasSize(dump))return;var cumulativeOwnedCoefficient=optional(dump.ownedCoefficient_,1);var parent=dump.parent;if(dump.parent!==undefined)cumulativeOwnedCoefficient*=dump.parent.cumulativeOwnedCoefficient_;dump.cumulativeOwnedCoefficient_=cumulativeOwnedCoefficient;var cumulativeOwningCoefficient;if(dump.owns!==undefined){cumulativeOwningCoefficient=dump.owningCoefficient_*dump.owns.target.cumulativeOwningCoefficient_;}else if(dump.parent!==undefined){cumulativeOwningCoefficient=dump.parent.cumulativeOwningCoefficient_;}else{cumulativeOwningCoefficient=1;}dump.cumulativeOwningCoefficient_=cumulativeOwningCoefficient;},calculateDumpEffectiveSize_:function(dump){if(!hasSize(dump)){delete dump.numerics[EFFECTIVE_SIZE_NUMERIC_NAME];return;}var effectiveSize;if(dump.children===undefined||dump.children.length===0){effectiveSize=getSize(dump)*dump.cumulativeOwningCoefficient_*dump.cumulativeOwnedCoefficient_;}else{effectiveSize=0;dump.children.forEach(function(childDump){if(!hasSize(childDump))return;effectiveSize+=childDump.numerics[EFFECTIVE_SIZE_NUMERIC_NAME].value;});}dump.numerics[EFFECTIVE_SIZE_NUMERIC_NAME]=new tr.v.ScalarNumeric(tr.b.Unit.byName.sizeInBytes_smallerIsBetter,effectiveSize);},aggregateNumerics:function(){this.iterateRootAllocatorDumps(function(dump){dump.aggregateNumericsRecursively(this.model);});this.iterateRootAllocatorDumps(this.propagateNumericsAndDiagnosticsRecursively);tr.b.iterItems(this.processMemoryDumps,function(pid,processMemoryDump){processMemoryDump.iterateRootAllocatorDumps(function(dump){dump.aggregateNumericsRecursively(this.model);},this);},this);},propagateNumericsAndDiagnosticsRecursively:function(globalAllocatorDump){['numerics','diagnostics'].forEach(function(field){tr.b.iterItems(globalAllocatorDump[field],function(name,value){globalAllocatorDump.ownedBy.forEach(function(ownershipLink){var processAllocatorDump=ownershipLink.source;if(processAllocatorDump[field][name]!==undefined){return;}processAllocatorDump[field][name]=value;});});});globalAllocatorDump.children.forEach(this.propagateNumericsAndDiagnosticsRecursively,this);},setUpTracingOverheadOwnership:function(){tr.b.iterItems(this.processMemoryDumps,function(pid,dump){dump.setUpTracingOverheadOwnership(this.model);},this);},discountTracingOverheadFromVmRegions:function(){tr.b.iterItems(this.processMemoryDumps,function(pid,dump){dump.discountTracingOverheadFromVmRegions(this.model);},this);},forceRebuildingMemoryAllocatorDumpByFullNameIndices:function(){this.iterateContainerDumps(function(containerDump){containerDump.forceRebuildingMemoryAllocatorDumpByFullNameIndex();});},iterateContainerDumps:function(fn){fn.call(this,this);tr.b.iterItems(this.processMemoryDumps,function(pid,processDump){fn.call(this,processDump);},this);},iterateAllRootAllocatorDumps:function(fn){this.iterateContainerDumps(function(containerDump){containerDump.iterateRootAllocatorDumps(fn,this);});},traverseAllocatorDumpsInDepthFirstPostOrder:function(fn){var visitedDumps=new WeakSet();var openDumps=new WeakSet();function visit(dump){if(visitedDumps.has(dump))return;if(openDumps.has(dump))throw new Error(dump.userFriendlyName+' contains a cycle');openDumps.add(dump);dump.ownedBy.forEach(function(ownershipLink){visit.call(this,ownershipLink.source);},this);dump.children.forEach(visit,this);fn.call(this,dump);visitedDumps.add(dump);openDumps.delete(dump);}this.iterateAllRootAllocatorDumps(visit);},traverseAllocatorDumpsInDepthFirstPreOrder:function(fn){var visitedDumps=new WeakSet();function visit(dump){if(visitedDumps.has(dump))return;if(dump.owns!==undefined&&!visitedDumps.has(dump.owns.target))return;if(dump.parent!==undefined&&!visitedDumps.has(dump.parent))return;fn.call(this,dump);visitedDumps.add(dump);dump.ownedBy.forEach(function(ownershipLink){visit.call(this,ownershipLink.source);},this);dump.children.forEach(visit,this);}this.iterateAllRootAllocatorDumps(visit);}};tr.model.EventRegistry.register(GlobalMemoryDump,{name:'globalMemoryDump',pluralName:'globalMemoryDumps'});return{GlobalMemoryDump:GlobalMemoryDump};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47,"../base/unit.js":63,"../value/numeric.js":196,"./container_memory_dump.js":115,"./event_registry.js":125,"./memory_allocator_dump.js":140}],130:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){function HeapEntry(heapDump,leafStackFrame,objectTypeName,size,count){this.heapDump=heapDump;this.leafStackFrame=leafStackFrame;this.objectTypeName=objectTypeName;this.size=size;this.count=count;}function HeapDump(processMemoryDump,allocatorName){this.processMemoryDump=processMemoryDump;this.allocatorName=allocatorName;this.entries=[];}HeapDump.prototype={addEntry:function(leafStackFrame,objectTypeName,size,count){var entry=new HeapEntry(this,leafStackFrame,objectTypeName,size,count);this.entries.push(entry);return entry;}};return{HeapEntry:HeapEntry,HeapDump:HeapDump};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],131:[function(require,module,exports){(function(global){"use strict";require("../../base/iteration_helpers.js");require("./chrome_process_helper.js");'use strict';global.tr.exportTo('tr.model.helpers',function(){function ChromeBrowserHelper(modelHelper,process){tr.model.helpers.ChromeProcessHelper.call(this,modelHelper,process);this.mainThread_=process.findAtMostOneThreadNamed('CrBrowserMain');if(!process.name)process.name=ChromeBrowserHelper.PROCESS_NAME;}ChromeBrowserHelper.PROCESS_NAME='Browser';ChromeBrowserHelper.isBrowserProcess=function(process){return!!process.findAtMostOneThreadNamed('CrBrowserMain');};ChromeBrowserHelper.prototype={__proto__:tr.model.helpers.ChromeProcessHelper.prototype,get browserName(){var hasInProcessRendererThread=this.process.findAllThreadsNamed('Chrome_InProcRendererThread').length>0;return hasInProcessRendererThread?'webview':'chrome';},get rendererHelpers(){return this.modelHelper.rendererHelpers;},getLoadingEventsInRange:function(rangeOfInterest){return this.getAllAsyncSlicesMatching(function(slice){return slice.title.indexOf('WebContentsImpl Loading')===0&&rangeOfInterest.intersectsExplicitRangeInclusive(slice.start,slice.end);});},getCommitProvisionalLoadEventsInRange:function(rangeOfInterest){return this.getAllAsyncSlicesMatching(function(slice){return slice.title==='RenderFrameImpl::didCommitProvisionalLoad'&&rangeOfInterest.intersectsExplicitRangeInclusive(slice.start,slice.end);});},get hasLatencyEvents(){var hasLatency=false;for(var thread of this.modelHelper.model.getAllThreads())for(var event of thread.getDescendantEvents()){if(!event.isTopLevel)continue;if(!(event instanceof tr.e.cc.InputLatencyAsyncSlice))continue;hasLatency=true;}return hasLatency;},getLatencyEventsInRange:function(rangeOfInterest){return this.getAllAsyncSlicesMatching(function(slice){return slice.title.indexOf('InputLatency')===0&&rangeOfInterest.intersectsExplicitRangeInclusive(slice.start,slice.end);});},getAllAsyncSlicesMatching:function(pred,opt_this){var events=[];this.iterAllThreads(function(thread){for(var slice of thread.getDescendantEvents())if(pred.call(opt_this,slice))events.push(slice);});return events;},getAllNetworkEventsInRange:function(rangeOfInterest){var networkEvents=[];this.modelHelper.model.getAllThreads().forEach(function(thread){thread.asyncSliceGroup.slices.forEach(function(slice){var match=false;if(slice.category=='net'||slice.category=='disabled-by-default-netlog'||slice.category=='netlog'){match=true;}if(!match)return;if(rangeOfInterest.intersectsExplicitRangeInclusive(slice.start,slice.end))networkEvents.push(slice);});});return networkEvents;},iterAllThreads:function(func,opt_this){tr.b.iterItems(this.process.threads,function(tid,thread){func.call(opt_this,thread);});tr.b.iterItems(this.rendererHelpers,function(pid,rendererHelper){var rendererProcess=rendererHelper.process;tr.b.iterItems(rendererProcess.threads,function(tid,thread){func.call(opt_this,thread);});},this);}};return{ChromeBrowserHelper:ChromeBrowserHelper};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/iteration_helpers.js":47,"./chrome_process_helper.js":134}],132:[function(require,module,exports){(function(global){"use strict";require("./chrome_process_helper.js");'use strict';global.tr.exportTo('tr.model.helpers',function(){function ChromeGpuHelper(modelHelper,process){tr.model.helpers.ChromeProcessHelper.call(this,modelHelper,process);this.mainThread_=process.findAtMostOneThreadNamed('CrGpuMain');if(!process.name)process.name=ChromeGpuHelper.PROCESS_NAME;};ChromeGpuHelper.PROCESS_NAME='GPU Process';ChromeGpuHelper.isGpuProcess=function(process){if(process.findAtMostOneThreadNamed('CrBrowserMain')||process.findAtMostOneThreadNamed('CrRendererMain'))return false;return process.findAtMostOneThreadNamed('CrGpuMain');};ChromeGpuHelper.prototype={__proto__:tr.model.helpers.ChromeProcessHelper.prototype,get mainThread(){return this.mainThread_;}};return{ChromeGpuHelper:ChromeGpuHelper};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./chrome_process_helper.js":134}],133:[function(require,module,exports){(function(global){"use strict";require("../../base/guid.js");require("../../base/iteration_helpers.js");require("./chrome_browser_helper.js");require("./chrome_gpu_helper.js");require("./chrome_renderer_helper.js");'use strict';global.tr.exportTo('tr.model.helpers',function(){function findChromeBrowserProcesses(model){return model.getAllProcesses(tr.model.helpers.ChromeBrowserHelper.isBrowserProcess);}function findChromeRenderProcesses(model){return model.getAllProcesses(tr.model.helpers.ChromeRendererHelper.isRenderProcess);}function findChromeGpuProcess(model){var gpuProcesses=model.getAllProcesses(tr.model.helpers.ChromeGpuHelper.isGpuProcess);if(gpuProcesses.length!==1)return undefined;return gpuProcesses[0];}function ChromeModelHelper(model){this.model_=model;var browserProcesses=findChromeBrowserProcesses(model);this.browserHelpers_=browserProcesses.map(p=>new tr.model.helpers.ChromeBrowserHelper(this,p));var gpuProcess=findChromeGpuProcess(model);if(gpuProcess){this.gpuHelper_=new tr.model.helpers.ChromeGpuHelper(this,gpuProcess);}else{this.gpuHelper_=undefined;}var rendererProcesses_=findChromeRenderProcesses(model);this.rendererHelpers_={};rendererProcesses_.forEach(function(renderProcess){var rendererHelper=new tr.model.helpers.ChromeRendererHelper(this,renderProcess);this.rendererHelpers_[rendererHelper.pid]=rendererHelper;},this);}ChromeModelHelper.guid=tr.b.GUID.allocateSimple();ChromeModelHelper.supportsModel=function(model){if(findChromeBrowserProcesses(model).length)return true;if(findChromeRenderProcesses(model).length)return true;return false;};ChromeModelHelper.prototype={get pid(){throw new Error('woah');},get process(){throw new Error('woah');},get model(){return this.model_;},get browserProcess(){if(this.browserHelper===undefined)return undefined;return this.browserHelper.process;},get browserHelper(){return this.browserHelpers_[0];},get browserHelpers(){return this.browserHelpers_;},get gpuHelper(){return this.gpuHelper_;},get rendererHelpers(){return this.rendererHelpers_;}};return{ChromeModelHelper:ChromeModelHelper};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/guid.js":45,"../../base/iteration_helpers.js":47,"./chrome_browser_helper.js":131,"./chrome_gpu_helper.js":132,"./chrome_renderer_helper.js":135}],134:[function(require,module,exports){(function(global){"use strict";require("../../base/base.js");'use strict';global.tr.exportTo('tr.model.helpers',function(){var MAIN_FRAMETIME_TYPE='main_frametime_type';var IMPL_FRAMETIME_TYPE='impl_frametime_type';var MAIN_RENDERING_STATS='BenchmarkInstrumentation::MainThreadRenderingStats';var IMPL_RENDERING_STATS='BenchmarkInstrumentation::ImplThreadRenderingStats';function getSlicesIntersectingRange(rangeOfInterest,slices){var slicesInFilterRange=[];for(var i=0;i<slices.length;i++){var slice=slices[i];if(rangeOfInterest.intersectsExplicitRangeInclusive(slice.start,slice.end))slicesInFilterRange.push(slice);}return slicesInFilterRange;}function ChromeProcessHelper(modelHelper,process){this.modelHelper=modelHelper;this.process=process;}ChromeProcessHelper.prototype={get pid(){return this.process.pid;},getFrameEventsInRange:function(frametimeType,range){var titleToGet=frametimeType===MAIN_FRAMETIME_TYPE?MAIN_RENDERING_STATS:IMPL_RENDERING_STATS;var frameEvents=[];for(var event of this.process.getDescendantEvents())if(event.title===titleToGet)if(range.intersectsExplicitRangeInclusive(event.start,event.end))frameEvents.push(event);frameEvents.sort(function(a,b){return a.start-b.start;});return frameEvents;}};function getFrametimeDataFromEvents(frameEvents){var frametimeData=[];for(var i=1;i<frameEvents.length;i++){var diff=frameEvents[i].start-frameEvents[i-1].start;frametimeData.push({'x':frameEvents[i].start,'frametime':diff});}return frametimeData;}return{ChromeProcessHelper:ChromeProcessHelper,MAIN_FRAMETIME_TYPE:MAIN_FRAMETIME_TYPE,IMPL_FRAMETIME_TYPE:IMPL_FRAMETIME_TYPE,MAIN_RENDERING_STATS:MAIN_RENDERING_STATS,IMPL_RENDERING_STATS:IMPL_RENDERING_STATS,getSlicesIntersectingRange:getSlicesIntersectingRange,getFrametimeDataFromEvents:getFrametimeDataFromEvents};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base.js":34}],135:[function(require,module,exports){(function(global){"use strict";require("../../base/range.js");require("../../extras/chrome/chrome_user_friendly_category_driver.js");require("./chrome_process_helper.js");'use strict';global.tr.exportTo('tr.model.helpers',function(){function ChromeRendererHelper(modelHelper,process){tr.model.helpers.ChromeProcessHelper.call(this,modelHelper,process);this.mainThread_=process.findAtMostOneThreadNamed('CrRendererMain');this.compositorThread_=process.findAtMostOneThreadNamed('Compositor');this.rasterWorkerThreads_=process.findAllThreadsMatching(function(t){if(t.name===undefined)return false;if(t.name.indexOf('CompositorTileWorker')===0)return true;if(t.name.indexOf('CompositorRasterWorker')===0)return true;return false;});this.isChromeTracingUI_=process.labels!==undefined&&process.labels.length===1&&process.labels[0]==='chrome://tracing';if(!process.name)process.name=ChromeRendererHelper.PROCESS_NAME;}ChromeRendererHelper.PROCESS_NAME='Renderer';ChromeRendererHelper.isRenderProcess=function(process){if(process.findAtMostOneThreadNamed('CrRendererMain'))return true;if(process.findAtMostOneThreadNamed('Compositor'))return true;return false;};ChromeRendererHelper.prototype={__proto__:tr.model.helpers.ChromeProcessHelper.prototype,get mainThread(){return this.mainThread_;},get compositorThread(){return this.compositorThread_;},get rasterWorkerThreads(){return this.rasterWorkerThreads_;},get isChromeTracingUI(){return this.isChromeTracingUI_;},generateTimeBreakdownTree:function(start,end){if(this.mainThread===null)return;var breakdownMap={};var range=tr.b.Range.fromExplicitRange(start,end);for(var title of tr.e.chrome.ChromeUserFriendlyCategoryDriver.ALL_TITLES){breakdownMap[title]={total:0,events:{}};}breakdownMap['idle']={total:0,events:{}};var totalIdleTime=end-start;for(var event of this.mainThread.getDescendantEvents()){if(!range.intersectsExplicitRangeExclusive(event.start,event.end))continue;if(event.selfTime===undefined)continue;var title=tr.e.chrome.ChromeUserFriendlyCategoryDriver.fromEvent(event);var wallTimeIntersectionRatio=0;if(event.duration>0){wallTimeIntersectionRatio=range.findExplicitIntersectionDuration(event.start,event.end)/event.duration;}var v8Runtime=event.args['runtime-call-stat'];if(v8Runtime!==undefined){try{var v8RuntimeObject=JSON.parse(v8Runtime);for(var runtimeCall in v8RuntimeObject){if(v8RuntimeObject[runtimeCall].length==2){if(breakdownMap['v8_runtime'].events[runtimeCall]===undefined){breakdownMap['v8_runtime'].events[runtimeCall]=0;}var runtimeTime=v8RuntimeObject[runtimeCall][1]*wallTimeIntersectionRatio/1000;breakdownMap['v8_runtime'].total+=runtimeTime;breakdownMap['v8_runtime'].events[runtimeCall]+=runtimeTime;}}}catch(e){console.warn(e);}}var approximatedSelfTimeContribution=event.selfTime*wallTimeIntersectionRatio;breakdownMap[title].total+=approximatedSelfTimeContribution;if(breakdownMap[title].events[event.title]===undefined)breakdownMap[title].events[event.title]=0;breakdownMap[title].events[event.title]+=approximatedSelfTimeContribution;totalIdleTime-=approximatedSelfTimeContribution;}breakdownMap['idle'].total=totalIdleTime;return breakdownMap;}};return{ChromeRendererHelper:ChromeRendererHelper};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/range.js":53,"../../extras/chrome/chrome_user_friendly_category_driver.js":69,"./chrome_process_helper.js":134}],136:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){var InstantEventType={GLOBAL:1,PROCESS:2};function InstantEvent(category,title,colorId,start,args){tr.model.TimedEvent.call(this,start);this.category=category||'';this.title=title;this.colorId=colorId;this.args=args;this.type=undefined;}InstantEvent.prototype={__proto__:tr.model.TimedEvent.prototype};function GlobalInstantEvent(category,title,colorId,start,args){InstantEvent.apply(this,arguments);this.type=InstantEventType.GLOBAL;}GlobalInstantEvent.prototype={__proto__:InstantEvent.prototype,get userFriendlyName(){return'Global instant event '+this.title+' @ '+tr.b.Unit.byName.timeStampInMs.format(start);}};function ProcessInstantEvent(category,title,colorId,start,args){InstantEvent.apply(this,arguments);this.type=InstantEventType.PROCESS;}ProcessInstantEvent.prototype={__proto__:InstantEvent.prototype,get userFriendlyName(){return'Process-level instant event '+this.title+' @ '+tr.b.Unit.byName.timeStampInMs.format(start);}};tr.model.EventRegistry.register(InstantEvent,{name:'instantEvent',pluralName:'instantEvents'});return{GlobalInstantEvent:GlobalInstantEvent,ProcessInstantEvent:ProcessInstantEvent,InstantEventType:InstantEventType,InstantEvent:InstantEvent};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./timed_event.js":166}],137:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");require("./event_set.js");'use strict';global.tr.exportTo('tr.model',function(){function getAssociatedEvents(irs){var allAssociatedEvents=new tr.model.EventSet();irs.forEach(function(ir){ir.associatedEvents.forEach(function(event){if(event instanceof tr.model.FlowEvent)return;allAssociatedEvents.push(event);});});return allAssociatedEvents;}function getUnassociatedEvents(model,associatedEvents){var unassociatedEvents=new tr.model.EventSet();for(var proc of model.getAllProcesses())for(var thread of tr.b.dictionaryValues(proc.threads))for(var event of thread.sliceGroup.getDescendantEvents())if(!associatedEvents.contains(event))unassociatedEvents.push(event);return unassociatedEvents;}function getTotalCpuDuration(events){var cpuMs=0;events.forEach(function(event){if(event.cpuSelfTime)cpuMs+=event.cpuSelfTime;});return cpuMs;}function getIRCoverageFromModel(model){var associatedEvents=getAssociatedEvents(model.userModel.expectations);if(!associatedEvents.length)return undefined;var unassociatedEvents=getUnassociatedEvents(model,associatedEvents);var associatedCpuMs=getTotalCpuDuration(associatedEvents);var unassociatedCpuMs=getTotalCpuDuration(unassociatedEvents);var totalEventCount=associatedEvents.length+unassociatedEvents.length;var totalCpuMs=associatedCpuMs+unassociatedCpuMs;var coveredEventsCpuTimeRatio=undefined;if(totalCpuMs!==0)coveredEventsCpuTimeRatio=associatedCpuMs/totalCpuMs;return{associatedEventsCount:associatedEvents.length,unassociatedEventsCount:unassociatedEvents.length,associatedEventsCpuTimeMs:associatedCpuMs,unassociatedEventsCpuTimeMs:unassociatedCpuMs,coveredEventsCountRatio:associatedEvents.length/totalEventCount,coveredEventsCpuTimeRatio:coveredEventsCpuTimeRatio};}return{getIRCoverageFromModel:getIRCoverageFromModel,getAssociatedEvents:getAssociatedEvents,getUnassociatedEvents:getUnassociatedEvents};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47,"./event_set.js":126}],138:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");require("./cpu.js");require("./process_base.js");'use strict';global.tr.exportTo('tr.model',function(){var Cpu=tr.model.Cpu;var ProcessBase=tr.model.ProcessBase;function Kernel(model){ProcessBase.call(this,model);this.cpus={};this.softwareMeasuredCpuCount_=undefined;};Kernel.compare=function(x,y){return 0;};Kernel.prototype={__proto__:ProcessBase.prototype,compareTo:function(that){return Kernel.compare(this,that);},get userFriendlyName(){return'Kernel';},get userFriendlyDetails(){return'Kernel';},get stableId(){return'Kernel';},getOrCreateCpu:function(cpuNumber){if(!this.cpus[cpuNumber])this.cpus[cpuNumber]=new Cpu(this,cpuNumber);return this.cpus[cpuNumber];},get softwareMeasuredCpuCount(){return this.softwareMeasuredCpuCount_;},set softwareMeasuredCpuCount(softwareMeasuredCpuCount){if(this.softwareMeasuredCpuCount_!==undefined&&this.softwareMeasuredCpuCount_!==softwareMeasuredCpuCount){throw new Error('Cannot change the softwareMeasuredCpuCount once it is set');}this.softwareMeasuredCpuCount_=softwareMeasuredCpuCount;},get bestGuessAtCpuCount(){var realCpuCount=tr.b.dictionaryLength(this.cpus);if(realCpuCount!==0)return realCpuCount;return this.softwareMeasuredCpuCount;},updateBounds:function(){ProcessBase.prototype.updateBounds.call(this);for(var cpuNumber in this.cpus){var cpu=this.cpus[cpuNumber];cpu.updateBounds();this.bounds.addRange(cpu.bounds);}},createSubSlices:function(){ProcessBase.prototype.createSubSlices.call(this);for(var cpuNumber in this.cpus){var cpu=this.cpus[cpuNumber];cpu.createSubSlices();}},addCategoriesToDict:function(categoriesDict){ProcessBase.prototype.addCategoriesToDict.call(this,categoriesDict);for(var cpuNumber in this.cpus)this.cpus[cpuNumber].addCategoriesToDict(categoriesDict);},getSettingsKey:function(){return'kernel';},childEventContainers:function*(){yield*ProcessBase.prototype.childEventContainers.call(this);yield*tr.b.dictionaryValues(this.cpus);}};return{Kernel:Kernel};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47,"./cpu.js":119,"./process_base.js":150}],139:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){function YComponent(stableId,yPercentOffset){this.stableId=stableId;this.yPercentOffset=yPercentOffset;}YComponent.prototype={toDict:function(){return{stableId:this.stableId,yPercentOffset:this.yPercentOffset};}};function Location(xWorld,yComponents){this.xWorld_=xWorld;this.yComponents_=yComponents;};Location.fromViewCoordinates=function(viewport,viewX,viewY){var dt=viewport.currentDisplayTransform;var xWorld=dt.xViewToWorld(viewX);var yComponents=[];var elem=document.elementFromPoint(viewX+viewport.modelTrackContainer.canvas.offsetLeft,viewY+viewport.modelTrackContainer.canvas.offsetTop);while(elem instanceof tr.ui.tracks.Track){if(elem.eventContainer){var boundRect=elem.getBoundingClientRect();var yPercentOffset=(viewY-boundRect.top)/boundRect.height;yComponents.push(new YComponent(elem.eventContainer.stableId,yPercentOffset));}elem=elem.parentElement;}if(yComponents.length==0)return;return new Location(xWorld,yComponents);};Location.fromStableIdAndTimestamp=function(viewport,stableId,ts){var xWorld=ts;var yComponents=[];var containerToTrack=viewport.containerToTrackMap;var elem=containerToTrack.getTrackByStableId(stableId);if(!elem)return;var firstY=elem.getBoundingClientRect().top;while(elem instanceof tr.ui.tracks.Track){if(elem.eventContainer){var boundRect=elem.getBoundingClientRect();var yPercentOffset=(firstY-boundRect.top)/boundRect.height;yComponents.push(new YComponent(elem.eventContainer.stableId,yPercentOffset));}elem=elem.parentElement;}if(yComponents.length==0)return;return new Location(xWorld,yComponents);};Location.prototype={get xWorld(){return this.xWorld_;},getContainingTrack:function(viewport){var containerToTrack=viewport.containerToTrackMap;for(var i in this.yComponents_){var yComponent=this.yComponents_[i];var track=containerToTrack.getTrackByStableId(yComponent.stableId);if(track!==undefined)return track;}},toViewCoordinates:function(viewport){var dt=viewport.currentDisplayTransform;var containerToTrack=viewport.containerToTrackMap;var viewX=dt.xWorldToView(this.xWorld_);var viewY=-1;for(var index in this.yComponents_){var yComponent=this.yComponents_[index];var track=containerToTrack.getTrackByStableId(yComponent.stableId);if(track!==undefined){var boundRect=track.getBoundingClientRect();viewY=yComponent.yPercentOffset*boundRect.height+boundRect.top;break;}}return{viewX:viewX,viewY:viewY};},toDict:function(){return{xWorld:this.xWorld_,yComponents:this.yComponents_};}};return{Location:Location};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],140:[function(require,module,exports){(function(global){"use strict";require("../base/iteration_helpers.js");require("../base/unit.js");require("../value/numeric.js");'use strict';global.tr.exportTo('tr.model',function(){function MemoryAllocatorDump(containerMemoryDump,fullName,opt_guid){this.fullName=fullName;this.parent=undefined;this.children=[];this.numerics={};this.diagnostics={};this.containerMemoryDump=containerMemoryDump;this.owns=undefined;this.ownedBy=[];this.ownedBySiblingSizes=new Map();this.retains=[];this.retainedBy=[];this.weak=false;this.infos=[];this.guid=opt_guid;}MemoryAllocatorDump.SIZE_NUMERIC_NAME='size';MemoryAllocatorDump.EFFECTIVE_SIZE_NUMERIC_NAME='effective_size';MemoryAllocatorDump.RESIDENT_SIZE_NUMERIC_NAME='resident_size';MemoryAllocatorDump.DISPLAYED_SIZE_NUMERIC_NAME=MemoryAllocatorDump.EFFECTIVE_SIZE_NUMERIC_NAME;MemoryAllocatorDump.prototype={get name(){return this.fullName.substring(this.fullName.lastIndexOf('/')+1);},get quantifiedName(){return'\''+this.fullName+'\' in '+this.containerMemoryDump.containerName;},getDescendantDumpByFullName:function(fullName){return this.containerMemoryDump.getMemoryAllocatorDumpByFullName(this.fullName+'/'+fullName);},isDescendantOf:function(otherDump){var dump=this;while(dump!==undefined){if(dump===otherDump)return true;dump=dump.parent;}return false;},addNumeric:function(name,numeric){if(!(numeric instanceof tr.v.ScalarNumeric))throw new Error('Numeric value must be an instance of ScalarNumeric.');if(name in this.numerics)throw new Error('Duplicate numeric name: '+name+'.');this.numerics[name]=numeric;},addDiagnostic:function(name,text){if(typeof text!=='string')throw new Error('Diagnostic text must be a string.');if(name in this.diagnostics)throw new Error('Duplicate diagnostic name: '+name+'.');this.diagnostics[name]=text;},aggregateNumericsRecursively:function(opt_model){var numericNames=new Set();this.children.forEach(function(child){child.aggregateNumericsRecursively(opt_model);tr.b.iterItems(child.numerics,numericNames.add,numericNames);},this);numericNames.forEach(function(numericName){if(numericName===MemoryAllocatorDump.SIZE_NUMERIC_NAME||numericName===MemoryAllocatorDump.EFFECTIVE_SIZE_NUMERIC_NAME||this.numerics[numericName]!==undefined){return;}this.numerics[numericName]=MemoryAllocatorDump.aggregateNumerics(this.children.map(function(child){return child.numerics[numericName];}),opt_model);},this);}};MemoryAllocatorDump.aggregateNumerics=function(numerics,opt_model){var shouldLogWarning=!!opt_model;var aggregatedUnit=undefined;var aggregatedValue=0;numerics.forEach(function(numeric){if(numeric===undefined)return;var unit=numeric.unit;if(aggregatedUnit===undefined){aggregatedUnit=unit;}else if(aggregatedUnit!==unit){if(shouldLogWarning){opt_model.importWarning({type:'numeric_parse_error',message:'Multiple units provided for numeric: \''+aggregatedUnit.unitName+'\' and \''+unit.unitName+'\'.'});shouldLogWarning=false;}aggregatedUnit=tr.b.Unit.byName.unitlessNumber_smallerIsBetter;}aggregatedValue+=numeric.value;},this);if(aggregatedUnit===undefined)return undefined;return new tr.v.ScalarNumeric(aggregatedUnit,aggregatedValue);};function MemoryAllocatorDumpLink(source,target,opt_importance){this.source=source;this.target=target;this.importance=opt_importance;this.size=undefined;}var MemoryAllocatorDumpInfoType={PROVIDED_SIZE_LESS_THAN_AGGREGATED_CHILDREN:0,PROVIDED_SIZE_LESS_THAN_LARGEST_OWNER:1};return{MemoryAllocatorDump:MemoryAllocatorDump,MemoryAllocatorDumpLink:MemoryAllocatorDumpLink,MemoryAllocatorDumpInfoType:MemoryAllocatorDumpInfoType};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/iteration_helpers.js":47,"../base/unit.js":63,"../value/numeric.js":196}],141:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/event.js");require("../base/interval_tree.js");require("../base/quad.js");require("../base/range.js");require("../base/task.js");require("../base/time_display_modes.js");require("../base/unit.js");require("../core/auditor.js");require("../core/filter.js");require("./alert.js");require("./clock_sync_manager.js");require("./constants.js");require("./device.js");require("./flow_event.js");require("./frame.js");require("./global_memory_dump.js");require("./instant_event.js");require("./kernel.js");require("./model_indices.js");require("./model_stats.js");require("./object_snapshot.js");require("./process.js");require("./process_memory_dump.js");require("./sample.js");require("./stack_frame.js");require("./user_model/user_expectation.js");require("./user_model/user_model.js");'use strict';global.tr.exportTo('tr',function(){var Process=tr.model.Process;var Device=tr.model.Device;var Kernel=tr.model.Kernel;var GlobalMemoryDump=tr.model.GlobalMemoryDump;var GlobalInstantEvent=tr.model.GlobalInstantEvent;var FlowEvent=tr.model.FlowEvent;var Alert=tr.model.Alert;var Sample=tr.model.Sample;function Model(){tr.model.EventContainer.call(this);tr.b.EventTarget.decorate(this);this.timestampShiftToZeroAmount_=0;this.faviconHue='blue';this.device=new Device(this);this.kernel=new Kernel(this);this.processes={};this.metadata=[];this.categories=[];this.instantEvents=[];this.flowEvents=[];this.clockSyncManager=new tr.model.ClockSyncManager();this.intrinsicTimeUnit_=undefined;this.stackFrames={};this.samples=[];this.alerts=[];this.userModel=new tr.model.um.UserModel(this);this.flowIntervalTree=new tr.b.IntervalTree(f=>f.start,f=>f.end);this.globalMemoryDumps=[];this.userFriendlyCategoryDrivers_=[];this.annotationsByGuid_={};this.modelIndices=undefined;this.stats=new tr.model.ModelStats();this.importWarnings_=[];this.reportedImportWarnings_={};this.isTimeHighResolution_=true;this.patchupsToApply_=[];this.doesHelperGUIDSupportThisModel_={};this.helpersByConstructorGUID_={};this.eventsByStableId_=undefined;}Model.prototype={__proto__:tr.model.EventContainer.prototype,getEventByStableId:function(stableId){if(this.eventsByStableId_===undefined){this.eventsByStableId_={};for(var event of this.getDescendantEvents()){this.eventsByStableId_[event.stableId]=event;}}return this.eventsByStableId_[stableId];},getOrCreateHelper:function(constructor){if(!constructor.guid)throw new Error('Helper constructors must have GUIDs');if(this.helpersByConstructorGUID_[constructor.guid]===undefined){if(this.doesHelperGUIDSupportThisModel_[constructor.guid]===undefined){this.doesHelperGUIDSupportThisModel_[constructor.guid]=constructor.supportsModel(this);}if(!this.doesHelperGUIDSupportThisModel_[constructor.guid])return undefined;this.helpersByConstructorGUID_[constructor.guid]=new constructor(this);}return this.helpersByConstructorGUID_[constructor.guid];},childEvents:function*(){yield*this.globalMemoryDumps;yield*this.instantEvents;yield*this.flowEvents;yield*this.alerts;yield*this.samples;},childEventContainers:function*(){yield this.userModel;yield this.device;yield this.kernel;yield*tr.b.dictionaryValues(this.processes);},iterateAllPersistableObjects:function(callback){this.kernel.iterateAllPersistableObjects(callback);for(var pid in this.processes)this.processes[pid].iterateAllPersistableObjects(callback);},updateBounds:function(){this.bounds.reset();var bounds=this.bounds;for(var ec of this.childEventContainers()){ec.updateBounds();bounds.addRange(ec.bounds);}for(var event of this.childEvents())event.addBoundsToRange(bounds);},shiftWorldToZero:function(){var shiftAmount=-this.bounds.min;this.timestampShiftToZeroAmount_=shiftAmount;for(var ec of this.childEventContainers())ec.shiftTimestampsForward(shiftAmount);for(var event of this.childEvents())event.start+=shiftAmount;this.updateBounds();},convertTimestampToModelTime:function(sourceClockDomainName,ts){if(sourceClockDomainName!=='traceEventClock')throw new Error('Only traceEventClock is supported.');return tr.b.Unit.timestampFromUs(ts)+this.timestampShiftToZeroAmount_;},get numProcesses(){var n=0;for(var p in this.processes)n++;return n;},getProcess:function(pid){return this.processes[pid];},getOrCreateProcess:function(pid){if(!this.processes[pid])this.processes[pid]=new Process(this,pid);return this.processes[pid];},addStackFrame:function(stackFrame){if(this.stackFrames[stackFrame.id])throw new Error('Stack frame already exists');this.stackFrames[stackFrame.id]=stackFrame;return stackFrame;},updateCategories_:function(){var categoriesDict={};this.userModel.addCategoriesToDict(categoriesDict);this.device.addCategoriesToDict(categoriesDict);this.kernel.addCategoriesToDict(categoriesDict);for(var pid in this.processes)this.processes[pid].addCategoriesToDict(categoriesDict);this.categories=[];for(var category in categoriesDict)if(category!='')this.categories.push(category);},getAllThreads:function(){var threads=[];for(var tid in this.kernel.threads){threads.push(process.threads[tid]);}for(var pid in this.processes){var process=this.processes[pid];for(var tid in process.threads){threads.push(process.threads[tid]);}}return threads;},getAllProcesses:function(opt_predicate){var processes=[];for(var pid in this.processes){var process=this.processes[pid];if(opt_predicate===undefined||opt_predicate(process))processes.push(process);}return processes;},getAllCounters:function(){var counters=[];counters.push.apply(counters,tr.b.dictionaryValues(this.device.counters));counters.push.apply(counters,tr.b.dictionaryValues(this.kernel.counters));for(var pid in this.processes){var process=this.processes[pid];for(var tid in process.counters){counters.push(process.counters[tid]);}}return counters;},getAnnotationByGUID:function(guid){return this.annotationsByGuid_[guid];},addAnnotation:function(annotation){if(!annotation.guid)throw new Error('Annotation with undefined guid given');this.annotationsByGuid_[annotation.guid]=annotation;tr.b.dispatchSimpleEvent(this,'annotationChange');},removeAnnotation:function(annotation){this.annotationsByGuid_[annotation.guid].onRemove();delete this.annotationsByGuid_[annotation.guid];tr.b.dispatchSimpleEvent(this,'annotationChange');},getAllAnnotations:function(){return tr.b.dictionaryValues(this.annotationsByGuid_);},addUserFriendlyCategoryDriver:function(ufcd){this.userFriendlyCategoryDrivers_.push(ufcd);},getUserFriendlyCategoryFromEvent:function(event){for(var i=0;i<this.userFriendlyCategoryDrivers_.length;i++){var ufc=this.userFriendlyCategoryDrivers_[i].fromEvent(event);if(ufc!==undefined)return ufc;}return undefined;},findAllThreadsNamed:function(name){var namedThreads=[];namedThreads.push.apply(namedThreads,this.kernel.findAllThreadsNamed(name));for(var pid in this.processes){namedThreads.push.apply(namedThreads,this.processes[pid].findAllThreadsNamed(name));}return namedThreads;},get importOptions(){return this.importOptions_;},set importOptions(options){this.importOptions_=options;},get intrinsicTimeUnit(){if(this.intrinsicTimeUnit_===undefined)return tr.b.TimeDisplayModes.ms;return this.intrinsicTimeUnit_;},set intrinsicTimeUnit(value){if(this.intrinsicTimeUnit_===value)return;if(this.intrinsicTimeUnit_!==undefined)throw new Error('Intrinsic time unit already set');this.intrinsicTimeUnit_=value;},get isTimeHighResolution(){return this.isTimeHighResolution_;},set isTimeHighResolution(value){this.isTimeHighResolution_=value;},get canonicalUrl(){return this.canonicalUrl_;},set canonicalUrl(value){if(this.canonicalUrl_===value)return;if(this.canonicalUrl_!==undefined)throw new Error('canonicalUrl already set');this.canonicalUrl_=value;},importWarning:function(data){data.showToUser=!!data.showToUser;this.importWarnings_.push(data);if(this.reportedImportWarnings_[data.type]===true)return;if(this.importOptions_.showImportWarnings)console.warn(data.message);this.reportedImportWarnings_[data.type]=true;},get hasImportWarnings(){return this.importWarnings_.length>0;},get importWarnings(){return this.importWarnings_;},get importWarningsThatShouldBeShownToUser(){return this.importWarnings_.filter(function(warning){return warning.showToUser;});},autoCloseOpenSlices:function(){this.samples.sort(function(x,y){return x.start-y.start;});this.updateBounds();this.kernel.autoCloseOpenSlices();for(var pid in this.processes)this.processes[pid].autoCloseOpenSlices();},createSubSlices:function(){this.kernel.createSubSlices();for(var pid in this.processes)this.processes[pid].createSubSlices();},preInitializeObjects:function(){for(var pid in this.processes)this.processes[pid].preInitializeObjects();},initializeObjects:function(){for(var pid in this.processes)this.processes[pid].initializeObjects();},pruneEmptyContainers:function(){this.kernel.pruneEmptyContainers();for(var pid in this.processes)this.processes[pid].pruneEmptyContainers();},mergeKernelWithUserland:function(){for(var pid in this.processes)this.processes[pid].mergeKernelWithUserland();},computeWorldBounds:function(shiftWorldToZero){this.updateBounds();this.updateCategories_();if(shiftWorldToZero)this.shiftWorldToZero();},buildFlowEventIntervalTree:function(){for(var i=0;i<this.flowEvents.length;++i){var flowEvent=this.flowEvents[i];this.flowIntervalTree.insert(flowEvent);}this.flowIntervalTree.updateHighValues();},cleanupUndeletedObjects:function(){for(var pid in this.processes)this.processes[pid].autoDeleteObjects(this.bounds.max);},sortMemoryDumps:function(){this.globalMemoryDumps.sort(function(x,y){return x.start-y.start;});for(var pid in this.processes)this.processes[pid].sortMemoryDumps();},finalizeMemoryGraphs:function(){this.globalMemoryDumps.forEach(function(dump){dump.finalizeGraph();});},buildEventIndices:function(){this.modelIndices=new tr.model.ModelIndices(this);},sortAlerts:function(){this.alerts.sort(function(x,y){return x.start-y.start;});},applyObjectRefPatchups:function(){var unresolved=[];this.patchupsToApply_.forEach(function(patchup){if(patchup.pidRef in this.processes){var snapshot=this.processes[patchup.pidRef].objects.getSnapshotAt(patchup.scopedId,patchup.ts);if(snapshot){patchup.object[patchup.field]=snapshot;snapshot.referencedAt(patchup.item,patchup.object,patchup.field);return;}}unresolved.push(patchup);},this);this.patchupsToApply_=unresolved;},replacePIDRefsInPatchups:function(oldPidRef,newPidRef){this.patchupsToApply_.forEach(function(patchup){if(patchup.pidRef===oldPidRef){patchup.pidRef=newPidRef;}});},joinRefs:function(){this.joinObjectRefs_();this.applyObjectRefPatchups();},joinObjectRefs_:function(){tr.b.iterItems(this.processes,function(pid,process){this.joinObjectRefsForProcess_(pid,process);},this);},joinObjectRefsForProcess_:function(pid,process){tr.b.iterItems(process.threads,function(tid,thread){thread.asyncSliceGroup.slices.forEach(function(item){this.searchItemForIDRefs_(pid,'start',item);},this);thread.sliceGroup.slices.forEach(function(item){this.searchItemForIDRefs_(pid,'start',item);},this);},this);process.objects.iterObjectInstances(function(instance){instance.snapshots.forEach(function(item){this.searchItemForIDRefs_(pid,'ts',item);},this);},this);},searchItemForIDRefs_:function(pid,itemTimestampField,item){if(!item.args&&!item.contexts)return;var patchupsToApply=this.patchupsToApply_;function handleField(object,fieldName,fieldValue){if(!fieldValue||!fieldValue.id_ref&&!fieldValue.idRef)return;var scope=fieldValue.scope||tr.model.OBJECT_DEFAULT_SCOPE;var idRef=fieldValue.id_ref||fieldValue.idRef;var scopedId=new tr.model.ScopedId(scope,idRef);var pidRef=fieldValue.pid_ref||fieldValue.pidRef||pid;var ts=item[itemTimestampField];patchupsToApply.push({item:item,object:object,field:fieldName,pidRef:pidRef,scopedId:scopedId,ts:ts});}function iterObjectFieldsRecursively(object){if(!(object instanceof Object))return;if(object instanceof tr.model.ObjectSnapshot||object instanceof Float32Array||object instanceof tr.b.Quad)return;if(object instanceof Array){for(var i=0;i<object.length;i++){handleField(object,i,object[i]);iterObjectFieldsRecursively(object[i]);}return;}for(var key in object){var value=object[key];handleField(object,key,value);iterObjectFieldsRecursively(value);}}iterObjectFieldsRecursively(item.args);iterObjectFieldsRecursively(item.contexts);}};return{Model:Model};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/event.js":39,"../base/interval_tree.js":46,"../base/quad.js":51,"../base/range.js":53,"../base/task.js":60,"../base/time_display_modes.js":61,"../base/unit.js":63,"../core/auditor.js":66,"../core/filter.js":67,"./alert.js":107,"./clock_sync_manager.js":111,"./constants.js":114,"./device.js":121,"./flow_event.js":127,"./frame.js":128,"./global_memory_dump.js":129,"./instant_event.js":136,"./kernel.js":138,"./model_indices.js":142,"./model_stats.js":143,"./object_snapshot.js":146,"./process.js":149,"./process_memory_dump.js":151,"./sample.js":153,"./stack_frame.js":161,"./user_model/user_expectation.js":172,"./user_model/user_model.js":173}],142:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){function ModelIndices(model){this.flowEventsById_={};model.flowEvents.forEach(function(fe){if(fe.id!==undefined){if(!this.flowEventsById_.hasOwnProperty(fe.id)){this.flowEventsById_[fe.id]=new Array();}this.flowEventsById_[fe.id].push(fe);}},this);}ModelIndices.prototype={addEventWithId:function(id,event){if(!this.flowEventsById_.hasOwnProperty(id)){this.flowEventsById_[id]=new Array();}this.flowEventsById_[id].push(event);},getFlowEventsWithId:function(id){if(!this.flowEventsById_.hasOwnProperty(id))return[];return this.flowEventsById_[id];}};return{ModelIndices:ModelIndices};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],143:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");'use strict';global.tr.exportTo('tr.model',function(){function ModelStats(){this.traceEventCountsByKey_=new Map();this.allTraceEventStats_=[];this.traceEventStatsInTimeIntervals_=new Map();this.allTraceEventStatsInTimeIntervals_=[];this.hasEventSizesinBytes_=false;}ModelStats.prototype={TIME_INTERVAL_SIZE_IN_MS:100,willProcessBasicTraceEvent:function(phase,category,title,ts,opt_eventSizeinBytes){var key=phase+'/'+category+'/'+title;var eventStats=this.traceEventCountsByKey_.get(key);if(eventStats===undefined){eventStats={phase:phase,category:category,title:title,numEvents:0,totalEventSizeinBytes:0};this.traceEventCountsByKey_.set(key,eventStats);this.allTraceEventStats_.push(eventStats);}eventStats.numEvents++;var timeIntervalKey=Math.floor(tr.b.Unit.timestampFromUs(ts)/this.TIME_INTERVAL_SIZE_IN_MS);var eventStatsByTimeInverval=this.traceEventStatsInTimeIntervals_.get(timeIntervalKey);if(eventStatsByTimeInverval===undefined){eventStatsByTimeInverval={timeInterval:timeIntervalKey,numEvents:0,totalEventSizeinBytes:0};this.traceEventStatsInTimeIntervals_.set(timeIntervalKey,eventStatsByTimeInverval);this.allTraceEventStatsInTimeIntervals_.push(eventStatsByTimeInverval);}eventStatsByTimeInverval.numEvents++;if(opt_eventSizeinBytes!==undefined){this.hasEventSizesinBytes_=true;eventStats.totalEventSizeinBytes+=opt_eventSizeinBytes;eventStatsByTimeInverval.totalEventSizeinBytes+=opt_eventSizeinBytes;}},get allTraceEventStats(){return this.allTraceEventStats_;},get allTraceEventStatsInTimeIntervals(){return this.allTraceEventStatsInTimeIntervals_;},get hasEventSizesinBytes(){return this.hasEventSizesinBytes_;}};return{ModelStats:ModelStats};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63}],144:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("../base/sorted_array_utils.js");require("../base/utils.js");require("./event_container.js");require("./object_instance.js");require("./time_to_object_instance_map.js");'use strict';global.tr.exportTo('tr.model',function(){var ObjectInstance=tr.model.ObjectInstance;var ObjectSnapshot=tr.model.ObjectSnapshot;function ObjectCollection(parent){tr.model.EventContainer.call(this);this.parent=parent;this.instanceMapsByScopedId_={};this.instancesByTypeName_={};this.createObjectInstance_=this.createObjectInstance_.bind(this);}ObjectCollection.prototype={__proto__:tr.model.EventContainer.prototype,childEvents:function*(){for(var instance of this.getAllObjectInstances()){yield instance;yield*instance.snapshots;}},createObjectInstance_:function(parent,scopedId,category,name,creationTs,opt_baseTypeName){var constructor=tr.model.ObjectInstance.subTypes.getConstructor(category,name);var instance=new constructor(parent,scopedId,category,name,creationTs,opt_baseTypeName);var typeName=instance.typeName;var instancesOfTypeName=this.instancesByTypeName_[typeName];if(!instancesOfTypeName){instancesOfTypeName=[];this.instancesByTypeName_[typeName]=instancesOfTypeName;}instancesOfTypeName.push(instance);return instance;},getOrCreateInstanceMap_:function(scopedId){var dict;if(scopedId.scope in this.instanceMapsByScopedId_){dict=this.instanceMapsByScopedId_[scopedId.scope];}else{dict={};this.instanceMapsByScopedId_[scopedId.scope]=dict;}var instanceMap=dict[scopedId.id];if(instanceMap)return instanceMap;instanceMap=new tr.model.TimeToObjectInstanceMap(this.createObjectInstance_,this.parent,scopedId);dict[scopedId.id]=instanceMap;return instanceMap;},idWasCreated:function(scopedId,category,name,ts){var instanceMap=this.getOrCreateInstanceMap_(scopedId);return instanceMap.idWasCreated(category,name,ts);},addSnapshot:function(scopedId,category,name,ts,args,opt_baseTypeName){var instanceMap=this.getOrCreateInstanceMap_(scopedId);var snapshot=instanceMap.addSnapshot(category,name,ts,args,opt_baseTypeName);if(snapshot.objectInstance.category!=category){var msg='Added snapshot name='+name+' with cat='+category+' impossible. It instance was created/snapshotted with cat='+snapshot.objectInstance.category+' name='+snapshot.objectInstance.name;throw new Error(msg);}if(opt_baseTypeName&&snapshot.objectInstance.baseTypeName!=opt_baseTypeName){throw new Error('Could not add snapshot with baseTypeName='+opt_baseTypeName+'. It '+'was previously created with name='+snapshot.objectInstance.baseTypeName);}if(snapshot.objectInstance.name!=name){throw new Error('Could not add snapshot with name='+name+'. It '+'was previously created with name='+snapshot.objectInstance.name);}return snapshot;},idWasDeleted:function(scopedId,category,name,ts){var instanceMap=this.getOrCreateInstanceMap_(scopedId);var deletedInstance=instanceMap.idWasDeleted(category,name,ts);if(!deletedInstance)return;if(deletedInstance.category!=category){var msg='Deleting object '+deletedInstance.name+' with a different category '+'than when it was created. It previous had cat='+deletedInstance.category+' but the delete command '+'had cat='+category;throw new Error(msg);}if(deletedInstance.baseTypeName!=name){throw new Error('Deletion requested for name='+name+' could not proceed: '+'An existing object with baseTypeName='+deletedInstance.baseTypeName+' existed.');}},autoDeleteObjects:function(maxTimestamp){tr.b.iterItems(this.instanceMapsByScopedId_,function(scope,imapById){tr.b.iterItems(imapById,function(id,i2imap){var lastInstance=i2imap.lastInstance;if(lastInstance.deletionTs!=Number.MAX_VALUE)return;i2imap.idWasDeleted(lastInstance.category,lastInstance.name,maxTimestamp);lastInstance.deletionTsWasExplicit=false;});});},getObjectInstanceAt:function(scopedId,ts){var instanceMap;if(scopedId.scope in this.instanceMapsByScopedId_)instanceMap=this.instanceMapsByScopedId_[scopedId.scope][scopedId.id];if(!instanceMap)return undefined;return instanceMap.getInstanceAt(ts);},getSnapshotAt:function(scopedId,ts){var instance=this.getObjectInstanceAt(scopedId,ts);if(!instance)return undefined;return instance.getSnapshotAt(ts);},iterObjectInstances:function(iter,opt_this){opt_this=opt_this||this;tr.b.iterItems(this.instanceMapsByScopedId_,function(scope,imapById){tr.b.iterItems(imapById,function(id,i2imap){i2imap.instances.forEach(iter,opt_this);});});},getAllObjectInstances:function(){var instances=[];this.iterObjectInstances(function(i){instances.push(i);});return instances;},getAllInstancesNamed:function(name){return this.instancesByTypeName_[name];},getAllInstancesByTypeName:function(){return this.instancesByTypeName_;},preInitializeAllObjects:function(){this.iterObjectInstances(function(instance){instance.preInitialize();});},initializeAllObjects:function(){this.iterObjectInstances(function(instance){instance.initialize();});},initializeInstances:function(){this.iterObjectInstances(function(instance){instance.initialize();});},updateBounds:function(){this.bounds.reset();this.iterObjectInstances(function(instance){instance.updateBounds();this.bounds.addRange(instance.bounds);},this);},shiftTimestampsForward:function(amount){this.iterObjectInstances(function(instance){instance.shiftTimestampsForward(amount);});},addCategoriesToDict:function(categoriesDict){this.iterObjectInstances(function(instance){categoriesDict[instance.category]=true;});}};return{ObjectCollection:ObjectCollection};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"../base/sorted_array_utils.js":58,"../base/utils.js":65,"./event_container.js":123,"./object_instance.js":145,"./time_to_object_instance_map.js":165}],145:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("../base/sorted_array_utils.js");require("./event.js");require("./object_snapshot.js");'use strict';global.tr.exportTo('tr.model',function(){var ObjectSnapshot=tr.model.ObjectSnapshot;function ObjectInstance(parent,scopedId,category,name,creationTs,opt_baseTypeName){tr.model.Event.call(this);this.parent=parent;this.scopedId=scopedId;this.category=category;this.baseTypeName=opt_baseTypeName?opt_baseTypeName:name;this.name=name;this.creationTs=creationTs;this.creationTsWasExplicit=false;this.deletionTs=Number.MAX_VALUE;this.deletionTsWasExplicit=false;this.colorId=0;this.bounds=new tr.b.Range();this.snapshots=[];this.hasImplicitSnapshots=false;}ObjectInstance.prototype={__proto__:tr.model.Event.prototype,get typeName(){return this.name;},addBoundsToRange:function(range){range.addRange(this.bounds);},addSnapshot:function(ts,args,opt_name,opt_baseTypeName){if(ts<this.creationTs)throw new Error('Snapshots must be >= instance.creationTs');if(ts>=this.deletionTs)throw new Error('Snapshots cannot be added after '+'an objects deletion timestamp.');var lastSnapshot;if(this.snapshots.length>0){lastSnapshot=this.snapshots[this.snapshots.length-1];if(lastSnapshot.ts==ts)throw new Error('Snapshots already exists at this time!');if(ts<lastSnapshot.ts){throw new Error('Snapshots must be added in increasing timestamp order');}}if(opt_name&&this.name!=opt_name){if(!opt_baseTypeName)throw new Error('Must provide base type name for name update');if(this.baseTypeName!=opt_baseTypeName)throw new Error('Cannot update type name: base types dont match');this.name=opt_name;}var snapshotConstructor=tr.model.ObjectSnapshot.subTypes.getConstructor(this.category,this.name);var snapshot=new snapshotConstructor(this,ts,args);this.snapshots.push(snapshot);return snapshot;},wasDeleted:function(ts){var lastSnapshot;if(this.snapshots.length>0){lastSnapshot=this.snapshots[this.snapshots.length-1];if(lastSnapshot.ts>ts)throw new Error('Instance cannot be deleted at ts='+ts+'. A snapshot exists that is older.');}this.deletionTs=ts;this.deletionTsWasExplicit=true;},preInitialize:function(){for(var i=0;i<this.snapshots.length;i++)this.snapshots[i].preInitialize();},initialize:function(){for(var i=0;i<this.snapshots.length;i++)this.snapshots[i].initialize();},isAliveAt:function(ts){if(ts<this.creationTs&&this.creationTsWasExplicit)return false;if(ts>this.deletionTs)return false;return true;},getSnapshotAt:function(ts){if(ts<this.creationTs){if(this.creationTsWasExplicit)throw new Error('ts must be within lifetime of this instance');return this.snapshots[0];}if(ts>this.deletionTs)throw new Error('ts must be within lifetime of this instance');var snapshots=this.snapshots;var i=tr.b.findIndexInSortedIntervals(snapshots,function(snapshot){return snapshot.ts;},function(snapshot,i){if(i==snapshots.length-1)return snapshots[i].objectInstance.deletionTs;return snapshots[i+1].ts-snapshots[i].ts;},ts);if(i<0){return this.snapshots[0];}if(i>=this.snapshots.length)return this.snapshots[this.snapshots.length-1];return this.snapshots[i];},updateBounds:function(){this.bounds.reset();this.bounds.addValue(this.creationTs);if(this.deletionTs!=Number.MAX_VALUE)this.bounds.addValue(this.deletionTs);else if(this.snapshots.length>0)this.bounds.addValue(this.snapshots[this.snapshots.length-1].ts);},shiftTimestampsForward:function(amount){this.creationTs+=amount;if(this.deletionTs!=Number.MAX_VALUE)this.deletionTs+=amount;this.snapshots.forEach(function(snapshot){snapshot.ts+=amount;});},get userFriendlyName(){return this.typeName+' object '+this.scopedId;}};tr.model.EventRegistry.register(ObjectInstance,{name:'objectInstance',pluralName:'objectInstances'});return{ObjectInstance:ObjectInstance};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"../base/sorted_array_utils.js":58,"./event.js":122,"./object_snapshot.js":146}],146:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./event.js");'use strict';global.tr.exportTo('tr.model',function(){function ObjectSnapshot(objectInstance,ts,args){tr.model.Event.call(this);this.objectInstance=objectInstance;this.ts=ts;this.args=args;}ObjectSnapshot.prototype={__proto__:tr.model.Event.prototype,preInitialize:function(){},initialize:function(){},referencedAt:function(item,object,field){},addBoundsToRange:function(range){range.addValue(this.ts);},get userFriendlyName(){return'Snapshot of '+this.objectInstance.typeName+' '+this.objectInstance.id+' @ '+tr.b.Unit.byName.timeStampInMs.format(this.ts);}};tr.model.EventRegistry.register(ObjectSnapshot,{name:'objectSnapshot',pluralName:'objectSnapshots'});return{ObjectSnapshot:ObjectSnapshot};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./event.js":122}],147:[function(require,module,exports){(function(global){"use strict";require("./event.js");require("./event_registry.js");'use strict';global.tr.exportTo('tr.model',function(){var Event=tr.model.Event;var EventRegistry=tr.model.EventRegistry;function PowerSample(series,start,powerInW){Event.call(this);this.series_=series;this.start_=start;this.powerInW_=powerInW;}PowerSample.prototype={__proto__:Event.prototype,get series(){return this.series_;},get start(){return this.start_;},set start(value){this.start_=value;},get powerInW(){return this.powerInW_;},set powerInW(value){this.powerInW_=value;},addBoundsToRange:function(range){range.addValue(this.start);}};EventRegistry.register(PowerSample,{name:'powerSample',pluralName:'powerSamples'});return{PowerSample:PowerSample};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./event.js":122,"./event_registry.js":125}],148:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("../base/sorted_array_utils.js");require("../base/unit_scale.js");require("./event_container.js");require("./power_sample.js");'use strict';global.tr.exportTo('tr.model',function(){var PowerSample=tr.model.PowerSample;function PowerSeries(device){tr.model.EventContainer.call(this);this.device_=device;this.samples_=[];}PowerSeries.prototype={__proto__:tr.model.EventContainer.prototype,get device(){return this.device_;},get samples(){return this.samples_;},get stableId(){return this.device_.stableId+'.PowerSeries';},addPowerSample:function(ts,val){var sample=new PowerSample(this,ts,val);this.samples_.push(sample);return sample;},getEnergyConsumedInJ:function(start,end){var measurementRange=tr.b.Range.fromExplicitRange(start,end);var energyConsumedInJ=0;var startIndex=tr.b.findLowIndexInSortedArray(this.samples,x=>x.start,start)-1;var endIndex=tr.b.findLowIndexInSortedArray(this.samples,x=>x.start,end);if(startIndex<0)startIndex=0;for(var i=startIndex;i<endIndex;i++){var sample=this.samples[i];var nextSample=this.samples[i+1];var sampleRange=new tr.b.Range();sampleRange.addValue(sample.start);sampleRange.addValue(nextSample?nextSample.start:sample.start);var intersectionRangeInMs=measurementRange.findIntersection(sampleRange);var durationInS=tr.b.convertUnit(intersectionRangeInMs.duration,tr.b.UnitScale.Metric.MILLI,tr.b.UnitScale.Metric.NONE);energyConsumedInJ+=durationInS*sample.powerInW;}return energyConsumedInJ;},getSamplesWithinRange:function(start,end){var startIndex=tr.b.findLowIndexInSortedArray(this.samples,x=>x.start,start);var endIndex=tr.b.findLowIndexInSortedArray(this.samples,x=>x.start,end);return this.samples.slice(startIndex,endIndex);},shiftTimestampsForward:function(amount){for(var i=0;i<this.samples_.length;++i)this.samples_[i].start+=amount;},updateBounds:function(){this.bounds.reset();if(this.samples_.length===0)return;this.bounds.addValue(this.samples_[0].start);this.bounds.addValue(this.samples_[this.samples_.length-1].start);},childEvents:function*(){yield*this.samples_;}};return{PowerSeries:PowerSeries};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"../base/sorted_array_utils.js":58,"../base/unit_scale.js":64,"./event_container.js":123,"./power_sample.js":147}],149:[function(require,module,exports){(function(global){"use strict";require("./process_base.js");require("./process_memory_dump.js");'use strict';global.tr.exportTo('tr.model',function(){var ProcessBase=tr.model.ProcessBase;var ProcessInstantEvent=tr.model.ProcessInstantEvent;var Frame=tr.model.Frame;var ProcessMemoryDump=tr.model.ProcessMemoryDump;function Process(model,pid){if(model===undefined)throw new Error('model must be provided');if(pid===undefined)throw new Error('pid must be provided');tr.model.ProcessBase.call(this,model);this.pid=pid;this.name=undefined;this.labels=[];this.instantEvents=[];this.memoryDumps=[];this.frames=[];this.activities=[];};Process.compare=function(x,y){var tmp=tr.model.ProcessBase.compare(x,y);if(tmp)return tmp;tmp=tr.b.comparePossiblyUndefinedValues(x.name,y.name,function(x,y){return x.localeCompare(y);});if(tmp)return tmp;tmp=tr.b.compareArrays(x.labels,y.labels,function(x,y){return x.localeCompare(y);});if(tmp)return tmp;return x.pid-y.pid;};Process.prototype={__proto__:tr.model.ProcessBase.prototype,get stableId(){return this.pid;},compareTo:function(that){return Process.compare(this,that);},childEvents:function*(){yield*ProcessBase.prototype.childEvents.call(this);yield*this.instantEvents;yield*this.frames;yield*this.memoryDumps;},addLabelIfNeeded:function(labelName){for(var i=0;i<this.labels.length;i++){if(this.labels[i]===labelName)return;}this.labels.push(labelName);},get userFriendlyName(){var res;if(this.name)res=this.name+' (pid '+this.pid+')';else res='Process '+this.pid;if(this.labels.length)res+=': '+this.labels.join(', ');return res;},get userFriendlyDetails(){if(this.name)return this.name+' (pid '+this.pid+')';return'pid: '+this.pid;},getSettingsKey:function(){if(!this.name)return undefined;if(!this.labels.length)return'processes.'+this.name;return'processes.'+this.name+'.'+this.labels.join('.');},shiftTimestampsForward:function(amount){for(var i=0;i<this.instantEvents.length;i++)this.instantEvents[i].start+=amount;for(var i=0;i<this.frames.length;i++)this.frames[i].shiftTimestampsForward(amount);for(var i=0;i<this.memoryDumps.length;i++)this.memoryDumps[i].shiftTimestampsForward(amount);for(var i=0;i<this.activities.length;i++)this.activities[i].shiftTimestampsForward(amount);tr.model.ProcessBase.prototype.shiftTimestampsForward.apply(this,arguments);},updateBounds:function(){tr.model.ProcessBase.prototype.updateBounds.apply(this);for(var i=0;i<this.frames.length;i++)this.frames[i].addBoundsToRange(this.bounds);for(var i=0;i<this.memoryDumps.length;i++)this.memoryDumps[i].addBoundsToRange(this.bounds);for(var i=0;i<this.activities.length;i++)this.activities[i].addBoundsToRange(this.bounds);},sortMemoryDumps:function(){this.memoryDumps.sort(function(x,y){return x.start-y.start;});tr.model.ProcessMemoryDump.hookUpMostRecentVmRegionsLinks(this.memoryDumps);}};return{Process:Process};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./process_base.js":150,"./process_memory_dump.js":151}],150:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/range.js");require("./counter.js");require("./event_container.js");require("./object_collection.js");require("./thread.js");'use strict';global.tr.exportTo('tr.model',function(){var Thread=tr.model.Thread;var Counter=tr.model.Counter;function ProcessBase(model){if(!model)throw new Error('Must provide a model');tr.model.EventContainer.call(this);this.model=model;this.threads={};this.counters={};this.objects=new tr.model.ObjectCollection(this);this.sortIndex=0;};ProcessBase.compare=function(x,y){return x.sortIndex-y.sortIndex;};ProcessBase.prototype={__proto__:tr.model.EventContainer.prototype,get stableId(){throw new Error('Not implemented');},childEventContainers:function*(){yield*tr.b.dictionaryValues(this.threads);yield*tr.b.dictionaryValues(this.counters);yield this.objects;},iterateAllPersistableObjects:function(cb){cb(this);for(var tid in this.threads)this.threads[tid].iterateAllPersistableObjects(cb);},get numThreads(){var n=0;for(var p in this.threads){n++;}return n;},shiftTimestampsForward:function(amount){for(var child of this.childEventContainers())child.shiftTimestampsForward(amount);},autoCloseOpenSlices:function(){for(var tid in this.threads){var thread=this.threads[tid];thread.autoCloseOpenSlices();}},autoDeleteObjects:function(maxTimestamp){this.objects.autoDeleteObjects(maxTimestamp);},preInitializeObjects:function(){this.objects.preInitializeAllObjects();},initializeObjects:function(){this.objects.initializeAllObjects();},mergeKernelWithUserland:function(){for(var tid in this.threads){var thread=this.threads[tid];thread.mergeKernelWithUserland();}},updateBounds:function(){this.bounds.reset();for(var tid in this.threads){this.threads[tid].updateBounds();this.bounds.addRange(this.threads[tid].bounds);}for(var id in this.counters){this.counters[id].updateBounds();this.bounds.addRange(this.counters[id].bounds);}this.objects.updateBounds();this.bounds.addRange(this.objects.bounds);},addCategoriesToDict:function(categoriesDict){for(var tid in this.threads)this.threads[tid].addCategoriesToDict(categoriesDict);for(var id in this.counters)categoriesDict[this.counters[id].category]=true;this.objects.addCategoriesToDict(categoriesDict);},findAllThreadsMatching:function(predicate,opt_this){var threads=[];for(var tid in this.threads){var thread=this.threads[tid];if(predicate.call(opt_this,thread))threads.push(thread);}return threads;},findAllThreadsNamed:function(name){var threads=this.findAllThreadsMatching(function(thread){if(!thread.name)return false;return thread.name===name;});return threads;},findAtMostOneThreadNamed:function(name){var threads=this.findAllThreadsNamed(name);if(threads.length===0)return undefined;if(threads.length>1)throw new Error('Expected no more than one '+name);return threads[0];},pruneEmptyContainers:function(){var threadsToKeep={};for(var tid in this.threads){var thread=this.threads[tid];if(!thread.isEmpty)threadsToKeep[tid]=thread;}this.threads=threadsToKeep;},getThread:function(tid){return this.threads[tid];},getOrCreateThread:function(tid){if(!this.threads[tid])this.threads[tid]=new Thread(this,tid);return this.threads[tid];},getOrCreateCounter:function(cat,name){var id=cat+'.'+name;if(!this.counters[id])this.counters[id]=new Counter(this,id,cat,name);return this.counters[id];},getSettingsKey:function(){throw new Error('Not implemented');},createSubSlices:function(){for(var tid in this.threads)this.threads[tid].createSubSlices();}};return{ProcessBase:ProcessBase};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/range.js":53,"./counter.js":116,"./event_container.js":123,"./object_collection.js":144,"./thread.js":162}],151:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./container_memory_dump.js");require("./memory_allocator_dump.js");require("./vm_region.js");'use strict';global.tr.exportTo('tr.model',function(){var DISCOUNTED_ALLOCATOR_NAMES=['winheap','malloc'];var TRACING_OVERHEAD_PATH=['allocated_objects','tracing_overhead'];var SIZE_NUMERIC_NAME=tr.model.MemoryAllocatorDump.SIZE_NUMERIC_NAME;var RESIDENT_SIZE_NUMERIC_NAME=tr.model.MemoryAllocatorDump.RESIDENT_SIZE_NUMERIC_NAME;function getSizeNumericValue(dump,sizeNumericName){var sizeNumeric=dump.numerics[sizeNumericName];if(sizeNumeric===undefined)return 0;return sizeNumeric.value;}function ProcessMemoryDump(globalMemoryDump,process,start){tr.model.ContainerMemoryDump.call(this,start);this.process=process;this.globalMemoryDump=globalMemoryDump;this.totals=undefined;this.vmRegions=undefined;this.heapDumps=undefined;this.tracingOverheadOwnershipSetUp_=false;this.tracingOverheadDiscountedFromVmRegions_=false;}ProcessMemoryDump.prototype={__proto__:tr.model.ContainerMemoryDump.prototype,get userFriendlyName(){return'Process memory dump at '+tr.b.Unit.byName.timeStampInMs.format(this.start);},get containerName(){return this.process.userFriendlyName;},get processMemoryDumps(){var dumps={};dumps[this.process.pid]=this;return dumps;},get hasOwnVmRegions(){return this.vmRegions!==undefined;},setUpTracingOverheadOwnership:function(opt_model){if(this.tracingOverheadOwnershipSetUp_)return;this.tracingOverheadOwnershipSetUp_=true;var tracingDump=this.getMemoryAllocatorDumpByFullName('tracing');if(tracingDump===undefined||tracingDump.owns!==undefined){return;}if(tracingDump.owns!==undefined)return;var hasDiscountedFromAllocatorDumps=DISCOUNTED_ALLOCATOR_NAMES.some(function(allocatorName){var allocatorDump=this.getMemoryAllocatorDumpByFullName(allocatorName);if(allocatorDump===undefined)return false;var nextPathIndex=0;var currentDump=allocatorDump;var currentFullName=allocatorName;for(;nextPathIndex<TRACING_OVERHEAD_PATH.length;nextPathIndex++){var childFullName=currentFullName+'/'+TRACING_OVERHEAD_PATH[nextPathIndex];var childDump=this.getMemoryAllocatorDumpByFullName(childFullName);if(childDump===undefined)break;currentDump=childDump;currentFullName=childFullName;}for(;nextPathIndex<TRACING_OVERHEAD_PATH.length;nextPathIndex++){var childFullName=currentFullName+'/'+TRACING_OVERHEAD_PATH[nextPathIndex];var childDump=new tr.model.MemoryAllocatorDump(currentDump.containerMemoryDump,childFullName);childDump.parent=currentDump;currentDump.children.push(childDump);currentFullName=childFullName;currentDump=childDump;}var ownershipLink=new tr.model.MemoryAllocatorDumpLink(tracingDump,currentDump);tracingDump.owns=ownershipLink;currentDump.ownedBy.push(ownershipLink);return true;},this);if(hasDiscountedFromAllocatorDumps)this.forceRebuildingMemoryAllocatorDumpByFullNameIndex();},discountTracingOverheadFromVmRegions:function(opt_model){if(this.tracingOverheadDiscountedFromVmRegions_)return;this.tracingOverheadDiscountedFromVmRegions_=true;var tracingDump=this.getMemoryAllocatorDumpByFullName('tracing');if(tracingDump===undefined)return;var discountedSize=getSizeNumericValue(tracingDump,SIZE_NUMERIC_NAME);var discountedResidentSize=getSizeNumericValue(tracingDump,RESIDENT_SIZE_NUMERIC_NAME);if(discountedSize<=0&&discountedResidentSize<=0)return;if(this.totals!==undefined){if(this.totals.residentBytes!==undefined)this.totals.residentBytes-=discountedResidentSize;if(this.totals.peakResidentBytes!==undefined)this.totals.peakResidentBytes-=discountedResidentSize;}if(this.vmRegions!==undefined){var hasSizeInBytes=this.vmRegions.sizeInBytes!==undefined;var hasPrivateDirtyResident=this.vmRegions.byteStats.privateDirtyResident!==undefined;var hasProportionalResident=this.vmRegions.byteStats.proportionalResident!==undefined;if(hasSizeInBytes&&discountedSize>0||(hasPrivateDirtyResident||hasProportionalResident)&&discountedResidentSize>0){var byteStats={};if(hasPrivateDirtyResident)byteStats.privateDirtyResident=-discountedResidentSize;if(hasProportionalResident)byteStats.proportionalResident=-discountedResidentSize;this.vmRegions.addRegion(tr.model.VMRegion.fromDict({mappedFile:'[discounted tracing overhead]',sizeInBytes:hasSizeInBytes?-discountedSize:undefined,byteStats:byteStats}));}}}};ProcessMemoryDump.hookUpMostRecentVmRegionsLinks=function(processDumps){var mostRecentVmRegions=undefined;processDumps.forEach(function(processDump){if(processDump.vmRegions!==undefined)mostRecentVmRegions=processDump.vmRegions;processDump.mostRecentVmRegions=mostRecentVmRegions;});};tr.model.EventRegistry.register(ProcessMemoryDump,{name:'processMemoryDump',pluralName:'processMemoryDumps'});return{ProcessMemoryDump:ProcessMemoryDump};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./container_memory_dump.js":115,"./memory_allocator_dump.js":140,"./vm_region.js":174}],152:[function(require,module,exports){(function(global){"use strict";require("./location.js");require("./annotation.js");require("../ui/annotations/rect_annotation_view.js");'use strict';global.tr.exportTo('tr.model',function(){function RectAnnotation(start,end){tr.model.Annotation.apply(this,arguments);this.startLocation_=start;this.endLocation_=end;this.fillStyle='rgba(255, 180, 0, 0.3)';}RectAnnotation.fromDict=function(dict){var args=dict.args;var startLoc=new tr.model.Location(args.start.xWorld,args.start.yComponents);var endLoc=new tr.model.Location(args.end.xWorld,args.end.yComponents);return new tr.model.RectAnnotation(startLoc,endLoc);};RectAnnotation.prototype={__proto__:tr.model.Annotation.prototype,get startLocation(){return this.startLocation_;},get endLocation(){return this.endLocation_;},toDict:function(){return{typeName:'rect',args:{start:this.startLocation.toDict(),end:this.endLocation.toDict()}};},createView_:function(viewport){return new tr.ui.annotations.RectAnnotationView(viewport,this);}};tr.model.Annotation.register(RectAnnotation,{typeName:'rect'});return{RectAnnotation:RectAnnotation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../ui/annotations/rect_annotation_view.js":178,"./annotation.js":108,"./location.js":139}],153:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){function Sample(cpu,thread,title,start,leafStackFrame,opt_weight,opt_args){tr.model.TimedEvent.call(this,start);this.title=title;this.cpu=cpu;this.thread=thread;this.leafStackFrame=leafStackFrame;this.weight=opt_weight;this.args=opt_args||{};}Sample.prototype={__proto__:tr.model.TimedEvent.prototype,get colorId(){return this.leafStackFrame.colorId;},get stackTrace(){return this.leafStackFrame.stackTrace;},getUserFriendlyStackTrace:function(){return this.leafStackFrame.getUserFriendlyStackTrace();},get userFriendlyName(){return'Sample at '+tr.b.Unit.byName.timeStampInMs.format(this.start);}};tr.model.EventRegistry.register(Sample,{name:'sample',pluralName:'samples'});return{Sample:Sample};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./timed_event.js":166}],154:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("./constants.js");'use strict';global.tr.exportTo('tr.model',function(){function ScopedId(scope,id){if(scope===undefined){throw new Error('Scope should be defined. Use \''+tr.model.OBJECT_DEFAULT_SCOPE+'\' as the default scope.');}this.scope=scope;this.id=id;}ScopedId.prototype={toString:function(){return'{scope: '+this.scope+', id: '+this.id+'}';}};return{ScopedId:ScopedId};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"./constants.js":114}],155:[function(require,module,exports){(function(global){"use strict";require("./selection_state.js");'use strict';global.tr.exportTo('tr.model',function(){var SelectionState=tr.model.SelectionState;function SelectableItem(modelItem){this.modelItem_=modelItem;}SelectableItem.prototype={get modelItem(){return this.modelItem_;},get selected(){return this.selectionState===SelectionState.SELECTED;},addToSelection:function(selection){var modelItem=this.modelItem_;if(!modelItem)return;selection.push(modelItem);},addToTrackMap:function(eventToTrackMap,track){var modelItem=this.modelItem_;if(!modelItem)return;eventToTrackMap.addEvent(modelItem,track);}};return{SelectableItem:SelectableItem};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./selection_state.js":156}],156:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/color_scheme.js");'use strict';global.tr.exportTo('tr.model',function(){var ColorScheme=tr.b.ColorScheme;var SelectionState={NONE:0,SELECTED:ColorScheme.properties.brightenedOffsets[0],HIGHLIGHTED:ColorScheme.properties.brightenedOffsets[1],DIMMED:ColorScheme.properties.dimmedOffsets[0],BRIGHTENED0:ColorScheme.properties.brightenedOffsets[0],BRIGHTENED1:ColorScheme.properties.brightenedOffsets[1],BRIGHTENED2:ColorScheme.properties.brightenedOffsets[2],DIMMED0:ColorScheme.properties.dimmedOffsets[0],DIMMED1:ColorScheme.properties.dimmedOffsets[1],DIMMED2:ColorScheme.properties.dimmedOffsets[2]};var brighteningLevels=[SelectionState.NONE,SelectionState.BRIGHTENED0,SelectionState.BRIGHTENED1,SelectionState.BRIGHTENED2];SelectionState.getFromBrighteningLevel=function(level){return brighteningLevels[level];};var dimmingLevels=[SelectionState.DIMMED0,SelectionState.DIMMED1,SelectionState.DIMMED2];SelectionState.getFromDimmingLevel=function(level){return dimmingLevels[level];};return{SelectionState:SelectionState};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34,"../base/color_scheme.js":38}],157:[function(require,module,exports){(function(global){"use strict";require("../base/unit.js");require("./timed_event.js");'use strict';global.tr.exportTo('tr.model',function(){function Slice(category,title,colorId,start,args,opt_duration,opt_cpuStart,opt_cpuDuration,opt_argsStripped,opt_bindId){if(!(this instanceof Slice)){throw new Error("Can't instantiate pure virtual class Slice");}tr.model.TimedEvent.call(this,start);this.category=category||'';this.title=title;this.colorId=colorId;this.args=args;this.startStackFrame=undefined;this.endStackFrame=undefined;this.didNotFinish=false;this.inFlowEvents=[];this.outFlowEvents=[];this.subSlices=[];this.selfTime=undefined;this.cpuSelfTime=undefined;this.important=false;this.parentContainer=undefined;this.argsStripped=false;this.bind_id_=opt_bindId;this.parentSlice=undefined;this.isTopLevel=false;if(opt_duration!==undefined)this.duration=opt_duration;if(opt_cpuStart!==undefined)this.cpuStart=opt_cpuStart;if(opt_cpuDuration!==undefined)this.cpuDuration=opt_cpuDuration;if(opt_argsStripped!==undefined)this.argsStripped=true;}Slice.prototype={__proto__:tr.model.TimedEvent.prototype,get analysisTypeName(){return this.title;},get userFriendlyName(){return'Slice '+this.title+' at '+tr.b.Unit.byName.timeStampInMs.format(this.start);},get stableId(){var parentSliceGroup=this.parentContainer.sliceGroup;return parentSliceGroup.stableId+'.'+parentSliceGroup.slices.indexOf(this);},findDescendentSlice:function(targetTitle){if(!this.subSlices)return undefined;for(var i=0;i<this.subSlices.length;i++){if(this.subSlices[i].title==targetTitle)return this.subSlices[i];var slice=this.subSlices[i].findDescendentSlice(targetTitle);if(slice)return slice;}return undefined;},get mostTopLevelSlice(){var curSlice=this;while(curSlice.parentSlice)curSlice=curSlice.parentSlice;return curSlice;},getProcess:function(){var thread=this.parentContainer;if(thread&&thread.getProcess)return thread.getProcess();return undefined;},get model(){var process=this.getProcess();if(process!==undefined)return this.getProcess().model;return undefined;},findTopmostSlicesRelativeToThisSlice:function*(eventPredicate){if(eventPredicate(this)){yield this;return;}for(var s of this.subSlices)yield*s.findTopmostSlicesRelativeToThisSlice(eventPredicate);},iterateAllSubsequentSlices:function(callback,opt_this){var parentStack=[];var started=false;var topmostSlice=this.mostTopLevelSlice;parentStack.push(topmostSlice);while(parentStack.length!==0){var curSlice=parentStack.pop();if(started)callback.call(opt_this,curSlice);else started=curSlice.guid===this.guid;for(var i=curSlice.subSlices.length-1;i>=0;i--){parentStack.push(curSlice.subSlices[i]);}}},get subsequentSlices(){var res=[];this.iterateAllSubsequentSlices(function(subseqSlice){res.push(subseqSlice);});return res;},enumerateAllAncestors:function*(){var curSlice=this;while(curSlice.parentSlice){curSlice=curSlice.parentSlice;yield curSlice;}},get ancestorSlices(){var res=[];for(var slice of this.enumerateAllAncestors())res.push(slice);return res;},iterateEntireHierarchy:function(callback,opt_this){var mostTopLevelSlice=this.mostTopLevelSlice;callback.call(opt_this,mostTopLevelSlice);mostTopLevelSlice.iterateAllSubsequentSlices(callback,opt_this);},get entireHierarchy(){var res=[];this.iterateEntireHierarchy(function(slice){res.push(slice);});return res;},get ancestorAndSubsequentSlices(){var res=[];res.push(this);for(var aSlice of this.enumerateAllAncestors())res.push(aSlice);this.iterateAllSubsequentSlices(function(sSlice){res.push(sSlice);});return res;},enumerateAllDescendents:function*(){for(var slice of this.subSlices)yield slice;for(var slice of this.subSlices)yield*slice.enumerateAllDescendents();},get descendentSlices(){var res=[];for(var slice of this.enumerateAllDescendents())res.push(slice);return res;}};return{Slice:Slice};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/unit.js":63,"./timed_event.js":166}],158:[function(require,module,exports){(function(global){"use strict";require("../base/color_scheme.js");require("../base/guid.js");require("../base/sorted_array_utils.js");require("../core/filter.js");require("./event_container.js");require("./thread_slice.js");'use strict';global.tr.exportTo('tr.model',function(){var ColorScheme=tr.b.ColorScheme;var ThreadSlice=tr.model.ThreadSlice;function getSliceLo(s){return s.start;}function getSliceHi(s){return s.end;}function SliceGroup(parentContainer,opt_sliceConstructor,opt_name){tr.model.EventContainer.call(this);this.parentContainer_=parentContainer;var sliceConstructor=opt_sliceConstructor||ThreadSlice;this.sliceConstructor=sliceConstructor;this.sliceConstructorSubTypes=this.sliceConstructor.subTypes;if(!this.sliceConstructorSubTypes)throw new Error('opt_sliceConstructor must have a subtype registry.');this.openPartialSlices_=[];this.slices=[];this.topLevelSlices=[];this.haveTopLevelSlicesBeenBuilt=false;this.name_=opt_name;if(this.model===undefined)throw new Error('SliceGroup must have model defined.');}SliceGroup.prototype={__proto__:tr.model.EventContainer.prototype,get parentContainer(){return this.parentContainer_;},get model(){return this.parentContainer_.model;},get stableId(){return this.parentContainer_.stableId+'.SliceGroup';},getSettingsKey:function(){if(!this.name_)return undefined;var parentKey=this.parentContainer_.getSettingsKey();if(!parentKey)return undefined;return parentKey+'.'+this.name;},get length(){return this.slices.length;},pushSlice:function(slice){this.haveTopLevelSlicesBeenBuilt=false;slice.parentContainer=this.parentContainer_;this.slices.push(slice);return slice;},pushSlices:function(slices){this.haveTopLevelSlicesBeenBuilt=false;slices.forEach(function(slice){slice.parentContainer=this.parentContainer_;this.slices.push(slice);},this);},beginSlice:function(category,title,ts,opt_args,opt_tts,opt_argsStripped,opt_colorId){if(this.openPartialSlices_.length){var prevSlice=this.openPartialSlices_[this.openPartialSlices_.length-1];if(ts<prevSlice.start)throw new Error('Slices must be added in increasing timestamp order');}var colorId=opt_colorId||ColorScheme.getColorIdForGeneralPurposeString(title);var sliceConstructorSubTypes=this.sliceConstructorSubTypes;var sliceType=sliceConstructorSubTypes.getConstructor(category,title);var slice=new sliceType(category,title,colorId,ts,opt_args?opt_args:{},null,opt_tts,undefined,opt_argsStripped);this.openPartialSlices_.push(slice);slice.didNotFinish=true;this.pushSlice(slice);return slice;},isTimestampValidForBeginOrEnd:function(ts){if(!this.openPartialSlices_.length)return true;var top=this.openPartialSlices_[this.openPartialSlices_.length-1];return ts>=top.start;},get openSliceCount(){return this.openPartialSlices_.length;},get mostRecentlyOpenedPartialSlice(){if(!this.openPartialSlices_.length)return undefined;return this.openPartialSlices_[this.openPartialSlices_.length-1];},endSlice:function(ts,opt_tts,opt_colorId){if(!this.openSliceCount)throw new Error('endSlice called without an open slice');var slice=this.openPartialSlices_[this.openSliceCount-1];this.openPartialSlices_.splice(this.openSliceCount-1,1);if(ts<slice.start)throw new Error('Slice '+slice.title+' end time is before its start.');slice.duration=ts-slice.start;slice.didNotFinish=false;slice.colorId=opt_colorId||slice.colorId;if(opt_tts&&slice.cpuStart!==undefined)slice.cpuDuration=opt_tts-slice.cpuStart;return slice;},pushCompleteSlice:function(category,title,ts,duration,tts,cpuDuration,opt_args,opt_argsStripped,opt_colorId,opt_bindId){var colorId=opt_colorId||ColorScheme.getColorIdForGeneralPurposeString(title);var sliceConstructorSubTypes=this.sliceConstructorSubTypes;var sliceType=sliceConstructorSubTypes.getConstructor(category,title);var slice=new sliceType(category,title,colorId,ts,opt_args?opt_args:{},duration,tts,cpuDuration,opt_argsStripped,opt_bindId);if(duration===undefined)slice.didNotFinish=true;this.pushSlice(slice);return slice;},autoCloseOpenSlices:function(){this.updateBounds();var maxTimestamp=this.bounds.max;for(var sI=0;sI<this.slices.length;sI++){var slice=this.slices[sI];if(slice.didNotFinish)slice.duration=maxTimestamp-slice.start;}this.openPartialSlices_=[];},shiftTimestampsForward:function(amount){for(var sI=0;sI<this.slices.length;sI++){var slice=this.slices[sI];slice.start=slice.start+amount;}},updateBounds:function(){this.bounds.reset();for(var i=0;i<this.slices.length;i++){this.bounds.addValue(this.slices[i].start);this.bounds.addValue(this.slices[i].end);}},copySlice:function(slice){var sliceConstructorSubTypes=this.sliceConstructorSubTypes;var sliceType=sliceConstructorSubTypes.getConstructor(slice.category,slice.title);var newSlice=new sliceType(slice.category,slice.title,slice.colorId,slice.start,slice.args,slice.duration,slice.cpuStart,slice.cpuDuration);newSlice.didNotFinish=slice.didNotFinish;return newSlice;},findTopmostSlicesInThisContainer:function*(eventPredicate,opt_this){if(!this.haveTopLevelSlicesBeenBuilt)throw new Error('Nope');for(var s of this.topLevelSlices)yield*s.findTopmostSlicesRelativeToThisSlice(eventPredicate);},childEvents:function*(){yield*this.slices;},childEventContainers:function*(){},getSlicesOfName:function(title){var slices=[];for(var i=0;i<this.slices.length;i++){if(this.slices[i].title==title){slices.push(this.slices[i]);}}return slices;},iterSlicesInTimeRange:function(callback,start,end){var ret=[];tr.b.iterateOverIntersectingIntervals(this.topLevelSlices,function(s){return s.start;},function(s){return s.duration;},start,end,function(topLevelSlice){callback(topLevelSlice);for(var slice of topLevelSlice.enumerateAllDescendents())callback(slice);});return ret;},findFirstSlice:function(){if(!this.haveTopLevelSlicesBeenBuilt)throw new Error('Nope');if(0===this.slices.length)return undefined;return this.slices[0];},findSliceAtTs:function(ts){if(!this.haveTopLevelSlicesBeenBuilt)throw new Error('Nope');var i=tr.b.findIndexInSortedClosedIntervals(this.topLevelSlices,getSliceLo,getSliceHi,ts);if(i==-1||i==this.topLevelSlices.length)return undefined;var curSlice=this.topLevelSlices[i];while(true){var i=tr.b.findIndexInSortedClosedIntervals(curSlice.subSlices,getSliceLo,getSliceHi,ts);if(i==-1||i==curSlice.subSlices.length)return curSlice;curSlice=curSlice.subSlices[i];}},findNextSliceAfter:function(ts,refGuid){var i=tr.b.findLowIndexInSortedArray(this.slices,getSliceLo,ts);if(i===this.slices.length)return undefined;for(;i<this.slices.length;i++){var slice=this.slices[i];if(slice.start>ts)return slice;if(slice.guid<=refGuid)continue;return slice;}return undefined;},createSubSlices:function(){this.haveTopLevelSlicesBeenBuilt=true;this.createSubSlicesImpl_();if(this.parentContainer.timeSlices)this.addCpuTimeToSubslices_(this.parentContainer.timeSlices);this.slices.forEach(function(slice){var selfTime=slice.duration;for(var i=0;i<slice.subSlices.length;i++)selfTime-=slice.subSlices[i].duration;slice.selfTime=selfTime;if(slice.cpuDuration===undefined)return;var cpuSelfTime=slice.cpuDuration;for(var i=0;i<slice.subSlices.length;i++){if(slice.subSlices[i].cpuDuration!==undefined)cpuSelfTime-=slice.subSlices[i].cpuDuration;}slice.cpuSelfTime=cpuSelfTime;});},createSubSlicesImpl_:function(){var precisionUnit=this.model.intrinsicTimeUnit;function addSliceIfBounds(parent,child){if(parent.bounds(child,precisionUnit)){child.parentSlice=parent;if(parent.subSlices===undefined)parent.subSlices=[];parent.subSlices.push(child);return true;}return false;}if(!this.slices.length)return;var ops=[];for(var i=0;i<this.slices.length;i++){if(this.slices[i].subSlices)this.slices[i].subSlices.splice(0,this.slices[i].subSlices.length);ops.push(i);}var originalSlices=this.slices;ops.sort(function(ix,iy){var x=originalSlices[ix];var y=originalSlices[iy];if(x.start!=y.start)return x.start-y.start;return ix-iy;});var slices=new Array(this.slices.length);for(var i=0;i<ops.length;i++){slices[i]=originalSlices[ops[i]];}var rootSlice=slices[0];this.topLevelSlices=[];this.topLevelSlices.push(rootSlice);rootSlice.isTopLevel=true;for(var i=1;i<slices.length;i++){var slice=slices[i];while(rootSlice!==undefined&&!addSliceIfBounds(rootSlice,slice)){rootSlice=rootSlice.parentSlice;}if(rootSlice===undefined){this.topLevelSlices.push(slice);slice.isTopLevel=true;}rootSlice=slice;}this.slices=slices;},addCpuTimeToSubslices_:function(timeSlices){var SCHEDULING_STATE=tr.model.SCHEDULING_STATE;var sliceIdx=0;timeSlices.forEach(function(timeSlice){if(timeSlice.schedulingState==SCHEDULING_STATE.RUNNING){while(sliceIdx<this.topLevelSlices.length){if(this.addCpuTimeToSubslice_(this.topLevelSlices[sliceIdx],timeSlice)){sliceIdx++;}else{break;}}}},this);},addCpuTimeToSubslice_:function(slice,timeSlice){if(slice.start>timeSlice.end||slice.end<timeSlice.start)return slice.end<=timeSlice.end;var duration=timeSlice.duration;if(slice.start>timeSlice.start)duration-=slice.start-timeSlice.start;if(timeSlice.end>slice.end)duration-=timeSlice.end-slice.end;if(slice.cpuDuration){slice.cpuDuration+=duration;}else{slice.cpuDuration=duration;}for(var i=0;i<slice.subSlices.length;i++){this.addCpuTimeToSubslice_(slice.subSlices[i],timeSlice);}return slice.end<=timeSlice.end;}};SliceGroup.merge=function(groupA,groupB){if(groupA.openPartialSlices_.length>0)throw new Error('groupA has open partial slices');if(groupB.openPartialSlices_.length>0)throw new Error('groupB has open partial slices');if(groupA.parentContainer!=groupB.parentContainer)throw new Error('Different parent threads. Cannot merge');if(groupA.sliceConstructor!=groupB.sliceConstructor)throw new Error('Different slice constructors. Cannot merge');var result=new SliceGroup(groupA.parentContainer,groupA.sliceConstructor,groupA.name_);var slicesA=groupA.slices;var slicesB=groupB.slices;var idxA=0;var idxB=0;var openA=[];var openB=[];var splitOpenSlices=function(when){for(var i=0;i<openB.length;i++){var oldSlice=openB[i];var oldEnd=oldSlice.end;if(when<oldSlice.start||oldEnd<when){throw new Error('slice should not be split');}var newSlice=result.copySlice(oldSlice);newSlice.start=when;newSlice.duration=oldEnd-when;if(newSlice.title.indexOf(' (cont.)')==-1)newSlice.title+=' (cont.)';oldSlice.duration=when-oldSlice.start;openB[i]=newSlice;result.pushSlice(newSlice);}};var closeOpenSlices=function(upTo){while(openA.length>0||openB.length>0){var nextA=openA[openA.length-1];var nextB=openB[openB.length-1];var endA=nextA&&nextA.end;var endB=nextB&&nextB.end;if((endA===undefined||endA>upTo)&&(endB===undefined||endB>upTo)){return;}if(endB===undefined||endA<endB){splitOpenSlices(endA);openA.pop();}else{openB.pop();}}};while(idxA<slicesA.length||idxB<slicesB.length){var sA=slicesA[idxA];var sB=slicesB[idxB];var nextSlice,isFromB;if(sA===undefined||sB!==undefined&&sA.start>sB.start){nextSlice=result.copySlice(sB);isFromB=true;idxB++;}else{nextSlice=result.copySlice(sA);isFromB=false;idxA++;}closeOpenSlices(nextSlice.start);result.pushSlice(nextSlice);if(isFromB){openB.push(nextSlice);}else{splitOpenSlices(nextSlice.start);openA.push(nextSlice);}}closeOpenSlices();return result;};return{SliceGroup:SliceGroup};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/color_scheme.js":38,"../base/guid.js":45,"../base/sorted_array_utils.js":58,"../core/filter.js":67,"./event_container.js":123,"./thread_slice.js":163}],159:[function(require,module,exports){(function(global){"use strict";require("./source_info.js");'use strict';global.tr.exportTo('tr.model.source_info',function(){function JSSourceInfo(file,line,column,isNative,scriptId,state){tr.model.source_info.SourceInfo.call(this,file,line,column);this.isNative_=isNative;this.scriptId_=scriptId;this.state_=state;}JSSourceInfo.prototype={__proto__:tr.model.source_info.SourceInfo.prototype,get state(){return this.state_;},get isNative(){return this.isNative_;},get scriptId(){return this.scriptId_;},toString:function(){var str=this.isNative_?'[native v8] ':'';return str+tr.model.source_info.SourceInfo.prototype.toString.call(this);}};return{JSSourceInfo:JSSourceInfo,JSSourceState:{COMPILED:'compiled',OPTIMIZABLE:'optimizable',OPTIMIZED:'optimized',UNKNOWN:'unknown'}};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./source_info.js":160}],160:[function(require,module,exports){(function(global){"use strict";require("../../base/base.js");'use strict';global.tr.exportTo('tr.model.source_info',function(){function SourceInfo(file,opt_line,opt_column){this.file_=file;this.line_=opt_line||-1;this.column_=opt_column||-1;}SourceInfo.prototype={get file(){return this.file_;},get line(){return this.line_;},get column(){return this.column_;},get domain(){if(!this.file_)return undefined;var domain=this.file_.match(/(.*:\/\/[^:\/]*)/i);return domain?domain[1]:undefined;},toString:function(){var str='';if(this.file_)str+=this.file_;if(this.line_>0)str+=':'+this.line_;if(this.column_>0)str+=':'+this.column_;return str;}};return{SourceInfo:SourceInfo};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base.js":34}],161:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){function StackFrame(parentFrame,id,title,colorId,opt_sourceInfo){if(id===undefined)throw new Error('id must be given');this.parentFrame_=parentFrame;this.id=id;this.title_=title;this.colorId=colorId;this.children=[];this.sourceInfo_=opt_sourceInfo;if(this.parentFrame_)this.parentFrame_.addChild(this);}StackFrame.prototype={get parentFrame(){return this.parentFrame_;},get title(){if(this.sourceInfo_){var src=this.sourceInfo_.toString();return this.title_+(src===''?'':' '+src);}return this.title_;},get domain(){var result='unknown';if(this.sourceInfo_&&this.sourceInfo_.domain)result=this.sourceInfo_.domain;if(result==='unknown'&&this.parentFrame)result=this.parentFrame.domain;return result;},get sourceInfo(){return this.sourceInfo_;},set parentFrame(parentFrame){if(this.parentFrame_)Polymer.dom(this.parentFrame_).removeChild(this);this.parentFrame_=parentFrame;if(this.parentFrame_)this.parentFrame_.addChild(this);},addChild:function(child){this.children.push(child);},removeChild:function(child){var i=this.children.indexOf(child.id);if(i==-1)throw new Error('omg');this.children.splice(i,1);},removeAllChildren:function(){for(var i=0;i<this.children.length;i++)this.children[i].parentFrame_=undefined;this.children.splice(0,this.children.length);},get stackTrace(){var stack=[];var cur=this;while(cur){stack.push(cur);cur=cur.parentFrame;}return stack;},getUserFriendlyStackTrace:function(){return this.stackTrace.map(function(x){return x.title;});}};return{StackFrame:StackFrame};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],162:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/range.js");require("./async_slice_group.js");require("./event_container.js");require("./slice_group.js");require("./thread_slice.js");'use strict';global.tr.exportTo('tr.model',function(){var AsyncSlice=tr.model.AsyncSlice;var AsyncSliceGroup=tr.model.AsyncSliceGroup;var SliceGroup=tr.model.SliceGroup;var ThreadSlice=tr.model.ThreadSlice;var ThreadTimeSlice=tr.model.ThreadTimeSlice;function Thread(parent,tid){if(!parent)throw new Error('Parent must be provided.');tr.model.EventContainer.call(this);this.parent=parent;this.sortIndex=0;this.tid=tid;this.name=undefined;this.samples_=undefined;var that=this;this.sliceGroup=new SliceGroup(this,ThreadSlice,'slices');this.timeSlices=undefined;this.kernelSliceGroup=new SliceGroup(this,ThreadSlice,'kernel-slices');this.asyncSliceGroup=new AsyncSliceGroup(this,'async-slices');}Thread.prototype={__proto__:tr.model.EventContainer.prototype,get model(){return this.parent.model;},get stableId(){return this.parent.stableId+'.'+this.tid;},compareTo:function(that){return Thread.compare(this,that);},childEventContainers:function*(){if(this.sliceGroup.length)yield this.sliceGroup;if(this.kernelSliceGroup.length)yield this.kernelSliceGroup;if(this.asyncSliceGroup.length)yield this.asyncSliceGroup;},childEvents:function*(){if(this.timeSlices)yield*this.timeSlices;},iterateAllPersistableObjects:function(cb){cb(this);if(this.sliceGroup.length)cb(this.sliceGroup);this.asyncSliceGroup.viewSubGroups.forEach(cb);},shiftTimestampsForward:function(amount){this.sliceGroup.shiftTimestampsForward(amount);if(this.timeSlices){for(var i=0;i<this.timeSlices.length;i++){var slice=this.timeSlices[i];slice.start+=amount;}}this.kernelSliceGroup.shiftTimestampsForward(amount);this.asyncSliceGroup.shiftTimestampsForward(amount);},get isEmpty(){if(this.sliceGroup.length)return false;if(this.sliceGroup.openSliceCount)return false;if(this.timeSlices&&this.timeSlices.length)return false;if(this.kernelSliceGroup.length)return false;if(this.asyncSliceGroup.length)return false;if(this.samples_.length)return false;return true;},updateBounds:function(){this.bounds.reset();this.sliceGroup.updateBounds();this.bounds.addRange(this.sliceGroup.bounds);this.kernelSliceGroup.updateBounds();this.bounds.addRange(this.kernelSliceGroup.bounds);this.asyncSliceGroup.updateBounds();this.bounds.addRange(this.asyncSliceGroup.bounds);if(this.timeSlices&&this.timeSlices.length){this.bounds.addValue(this.timeSlices[0].start);this.bounds.addValue(this.timeSlices[this.timeSlices.length-1].end);}if(this.samples_&&this.samples_.length){this.bounds.addValue(this.samples_[0].start);this.bounds.addValue(this.samples_[this.samples_.length-1].end);}},addCategoriesToDict:function(categoriesDict){for(var i=0;i<this.sliceGroup.length;i++)categoriesDict[this.sliceGroup.slices[i].category]=true;for(var i=0;i<this.kernelSliceGroup.length;i++)categoriesDict[this.kernelSliceGroup.slices[i].category]=true;for(var i=0;i<this.asyncSliceGroup.length;i++)categoriesDict[this.asyncSliceGroup.slices[i].category]=true;if(this.samples_){for(var i=0;i<this.samples_.length;i++)categoriesDict[this.samples_[i].category]=true;}},autoCloseOpenSlices:function(){this.sliceGroup.autoCloseOpenSlices();this.kernelSliceGroup.autoCloseOpenSlices();},mergeKernelWithUserland:function(){if(this.kernelSliceGroup.length>0){var newSlices=SliceGroup.merge(this.sliceGroup,this.kernelSliceGroup);this.sliceGroup.slices=newSlices.slices;this.kernelSliceGroup=new SliceGroup(this);this.updateBounds();}},createSubSlices:function(){this.sliceGroup.createSubSlices();this.samples_=this.parent.model.samples.filter(function(sample){return sample.thread==this;},this);},get userFriendlyName(){return this.name||this.tid;},get userFriendlyDetails(){return'tid: '+this.tid+(this.name?', name: '+this.name:'');},getSettingsKey:function(){if(!this.name)return undefined;var parentKey=this.parent.getSettingsKey();if(!parentKey)return undefined;return parentKey+'.'+this.name;},getProcess:function(){return this.parent;},indexOfTimeSlice:function(timeSlice){var i=tr.b.findLowIndexInSortedArray(this.timeSlices,function(slice){return slice.start;},timeSlice.start);if(this.timeSlices[i]!==timeSlice)return undefined;return i;},getCpuStatsForRange:function(range){var stats={};stats.total=0;if(!this.timeSlices)return stats;function addStatsForSlice(threadTimeSlice){var freqRange=tr.b.Range.fromExplicitRange(threadTimeSlice.start,threadTimeSlice.end);var intersection=freqRange.findIntersection(range);if(threadTimeSlice.schedulingState==tr.model.SCHEDULING_STATE.RUNNING){var cpu=threadTimeSlice.cpuOnWhichThreadWasRunning;if(!(cpu.cpuNumber in stats))stats[cpu.cpuNumber]=0;stats[cpu.cpuNumber]+=intersection.duration;stats.total+=intersection.duration;}}tr.b.iterateOverIntersectingIntervals(this.timeSlices,function(x){return x.start;},function(x){return x.end;},range.min,range.max,addStatsForSlice);return stats;},getSchedulingStatsForRange:function(start,end){var stats={};if(!this.timeSlices)return stats;function addStatsForSlice(threadTimeSlice){var overlapStart=Math.max(threadTimeSlice.start,start);var overlapEnd=Math.min(threadTimeSlice.end,end);var schedulingState=threadTimeSlice.schedulingState;if(!(schedulingState in stats))stats[schedulingState]=0;stats[schedulingState]+=overlapEnd-overlapStart;}tr.b.iterateOverIntersectingIntervals(this.timeSlices,function(x){return x.start;},function(x){return x.end;},start,end,addStatsForSlice);return stats;},get samples(){return this.samples_;}};Thread.compare=function(x,y){var tmp=x.parent.compareTo(y.parent);if(tmp)return tmp;tmp=x.sortIndex-y.sortIndex;if(tmp)return tmp;tmp=tr.b.comparePossiblyUndefinedValues(x.name,y.name,function(x,y){return x.localeCompare(y);});if(tmp)return tmp;return x.tid-y.tid;};return{Thread:Thread};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/range.js":53,"./async_slice_group.js":110,"./event_container.js":123,"./slice_group.js":158,"./thread_slice.js":163}],163:[function(require,module,exports){(function(global){"use strict";require("./slice.js");'use strict';global.tr.exportTo('tr.model',function(){var Slice=tr.model.Slice;function ThreadSlice(cat,title,colorId,start,args,opt_duration,opt_cpuStart,opt_cpuDuration,opt_argsStripped,opt_bindId){Slice.call(this,cat,title,colorId,start,args,opt_duration,opt_cpuStart,opt_cpuDuration,opt_argsStripped,opt_bindId);this.subSlices=[];}ThreadSlice.prototype={__proto__:Slice.prototype,get overlappingSamples(){var samples=new tr.model.EventSet();if(!this.parentContainer||!this.parentContainer.samples)return samples;this.parentContainer.samples.forEach(function(sample){if(this.start<=sample.start&&sample.start<=this.end)samples.push(sample);},this);return samples;}};tr.model.EventRegistry.register(ThreadSlice,{name:'slice',pluralName:'slices'});return{ThreadSlice:ThreadSlice};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./slice.js":157}],164:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("./slice.js");'use strict';global.tr.exportTo('tr.model',function(){var Slice=tr.model.Slice;var SCHEDULING_STATE={DEBUG:'Debug',EXIT_DEAD:'Exit Dead',RUNNABLE:'Runnable',RUNNING:'Running',SLEEPING:'Sleeping',STOPPED:'Stopped',TASK_DEAD:'Task Dead',UNINTR_SLEEP:'Uninterruptible Sleep',UNINTR_SLEEP_WAKE_KILL:'Uninterruptible Sleep | WakeKill',UNINTR_SLEEP_WAKING:'Uninterruptible Sleep | Waking',UNINTR_SLEEP_IO:'Uninterruptible Sleep - Block I/O',UNINTR_SLEEP_WAKE_KILL_IO:'Uninterruptible Sleep | WakeKill - Block I/O',UNINTR_SLEEP_WAKING_IO:'Uninterruptible Sleep | Waking - Block I/O',UNKNOWN:'UNKNOWN',WAKE_KILL:'Wakekill',WAKING:'Waking',ZOMBIE:'Zombie'};function ThreadTimeSlice(thread,schedulingState,cat,start,args,opt_duration){Slice.call(this,cat,schedulingState,this.getColorForState_(schedulingState),start,args,opt_duration);this.thread=thread;this.schedulingState=schedulingState;this.cpuOnWhichThreadWasRunning=undefined;}ThreadTimeSlice.prototype={__proto__:Slice.prototype,getColorForState_:function(state){var getColorIdForReservedName=tr.b.ColorScheme.getColorIdForReservedName;switch(state){case SCHEDULING_STATE.RUNNABLE:return getColorIdForReservedName('thread_state_runnable');case SCHEDULING_STATE.RUNNING:return getColorIdForReservedName('thread_state_running');case SCHEDULING_STATE.SLEEPING:return getColorIdForReservedName('thread_state_sleeping');case SCHEDULING_STATE.DEBUG:case SCHEDULING_STATE.EXIT_DEAD:case SCHEDULING_STATE.STOPPED:case SCHEDULING_STATE.TASK_DEAD:case SCHEDULING_STATE.UNINTR_SLEEP:case SCHEDULING_STATE.UNINTR_SLEEP_WAKE_KILL:case SCHEDULING_STATE.UNINTR_SLEEP_WAKING:case SCHEDULING_STATE.UNKNOWN:case SCHEDULING_STATE.WAKE_KILL:case SCHEDULING_STATE.WAKING:case SCHEDULING_STATE.ZOMBIE:return getColorIdForReservedName('thread_state_uninterruptible');case SCHEDULING_STATE.UNINTR_SLEEP_IO:case SCHEDULING_STATE.UNINTR_SLEEP_WAKE_KILL_IO:case SCHEDULING_STATE.UNINTR_SLEEP_WAKING_IO:return getColorIdForReservedName('thread_state_iowait');default:return getColorIdForReservedName('thread_state_unknown');}},get analysisTypeName(){return'tr.ui.analysis.ThreadTimeSlice';},getAssociatedCpuSlice:function(){if(!this.cpuOnWhichThreadWasRunning)return undefined;var cpuSlices=this.cpuOnWhichThreadWasRunning.slices;for(var i=0;i<cpuSlices.length;i++){var cpuSlice=cpuSlices[i];if(cpuSlice.start!==this.start)continue;if(cpuSlice.duration!==this.duration)continue;return cpuSlice;}return undefined;},getCpuSliceThatTookCpu:function(){if(this.cpuOnWhichThreadWasRunning)return undefined;var curIndex=this.thread.indexOfTimeSlice(this);var cpuSliceWhenLastRunning;while(curIndex>=0){var curSlice=this.thread.timeSlices[curIndex];if(!curSlice.cpuOnWhichThreadWasRunning){curIndex--;continue;}cpuSliceWhenLastRunning=curSlice.getAssociatedCpuSlice();break;}if(!cpuSliceWhenLastRunning)return undefined;var cpu=cpuSliceWhenLastRunning.cpu;var indexOfSliceOnCpuWhenLastRunning=cpu.indexOf(cpuSliceWhenLastRunning);var nextRunningSlice=cpu.slices[indexOfSliceOnCpuWhenLastRunning+1];if(!nextRunningSlice)return undefined;if(Math.abs(nextRunningSlice.start-cpuSliceWhenLastRunning.end)<0.00001)return nextRunningSlice;return undefined;}};tr.model.EventRegistry.register(ThreadTimeSlice,{name:'threadTimeSlice',pluralName:'threadTimeSlices'});return{ThreadTimeSlice:ThreadTimeSlice,SCHEDULING_STATE:SCHEDULING_STATE};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"./slice.js":157}],165:[function(require,module,exports){(function(global){"use strict";require("../base/range.js");require("../base/sorted_array_utils.js");'use strict';global.tr.exportTo('tr.model',function(){function TimeToObjectInstanceMap(createObjectInstanceFunction,parent,scopedId){this.createObjectInstanceFunction_=createObjectInstanceFunction;this.parent=parent;this.scopedId=scopedId;this.instances=[];}TimeToObjectInstanceMap.prototype={idWasCreated:function(category,name,ts){if(this.instances.length==0){this.instances.push(this.createObjectInstanceFunction_(this.parent,this.scopedId,category,name,ts));this.instances[0].creationTsWasExplicit=true;return this.instances[0];}var lastInstance=this.instances[this.instances.length-1];if(ts<lastInstance.deletionTs){throw new Error('Mutation of the TimeToObjectInstanceMap must be '+'done in ascending timestamp order.');}lastInstance=this.createObjectInstanceFunction_(this.parent,this.scopedId,category,name,ts);lastInstance.creationTsWasExplicit=true;this.instances.push(lastInstance);return lastInstance;},addSnapshot:function(category,name,ts,args,opt_baseTypeName){if(this.instances.length==0){this.instances.push(this.createObjectInstanceFunction_(this.parent,this.scopedId,category,name,ts,opt_baseTypeName));}var i=tr.b.findIndexInSortedIntervals(this.instances,function(inst){return inst.creationTs;},function(inst){return inst.deletionTs-inst.creationTs;},ts);var instance;if(i<0){instance=this.instances[0];if(ts>instance.deletionTs||instance.creationTsWasExplicit){throw new Error('At the provided timestamp, no instance was still alive');}if(instance.snapshots.length!=0){throw new Error('Cannot shift creationTs forward, '+'snapshots have been added. First snap was at ts='+instance.snapshots[0].ts+' and creationTs was '+instance.creationTs);}instance.creationTs=ts;}else if(i>=this.instances.length){instance=this.instances[this.instances.length-1];if(ts>=instance.deletionTs){instance=this.createObjectInstanceFunction_(this.parent,this.scopedId,category,name,ts,opt_baseTypeName);this.instances.push(instance);}else{var lastValidIndex;for(var i=this.instances.length-1;i>=0;i--){var tmp=this.instances[i];if(ts>=tmp.deletionTs)break;if(tmp.creationTsWasExplicit==false&&tmp.snapshots.length==0)lastValidIndex=i;}if(lastValidIndex===undefined){throw new Error('Cannot add snapshot. No instance was alive that was mutable.');}instance=this.instances[lastValidIndex];instance.creationTs=ts;}}else{instance=this.instances[i];}return instance.addSnapshot(ts,args,name,opt_baseTypeName);},get lastInstance(){if(this.instances.length==0)return undefined;return this.instances[this.instances.length-1];},idWasDeleted:function(category,name,ts){if(this.instances.length==0){this.instances.push(this.createObjectInstanceFunction_(this.parent,this.scopedId,category,name,ts));}var lastInstance=this.instances[this.instances.length-1];if(ts<lastInstance.creationTs)throw new Error('Cannot delete an id before it was created');if(lastInstance.deletionTs==Number.MAX_VALUE){lastInstance.wasDeleted(ts);return lastInstance;}if(ts<lastInstance.deletionTs)throw new Error('id was already deleted earlier.');lastInstance=this.createObjectInstanceFunction_(this.parent,this.scopedId,category,name,ts);this.instances.push(lastInstance);lastInstance.wasDeleted(ts);return lastInstance;},getInstanceAt:function(ts){var i=tr.b.findIndexInSortedIntervals(this.instances,function(inst){return inst.creationTs;},function(inst){return inst.deletionTs-inst.creationTs;},ts);if(i<0){if(this.instances[0].creationTsWasExplicit)return undefined;return this.instances[0];}else if(i>=this.instances.length){return undefined;}return this.instances[i];},logToConsole:function(){for(var i=0;i<this.instances.length;i++){var instance=this.instances[i];var cEF='';var dEF='';if(instance.creationTsWasExplicit)cEF='(explicitC)';if(instance.deletionTsWasExplicit)dEF='(explicit)';console.log(instance.creationTs,cEF,instance.deletionTs,dEF,instance.category,instance.name,instance.snapshots.length+' snapshots');}}};return{TimeToObjectInstanceMap:TimeToObjectInstanceMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/range.js":53,"../base/sorted_array_utils.js":58}],166:[function(require,module,exports){(function(global){"use strict";require("../base/guid.js");require("../base/time_display_modes.js");require("./event.js");'use strict';global.tr.exportTo('tr.model',function(){function TimedEvent(start){tr.model.Event.call(this);this.start=start;this.duration=0;this.cpuStart=undefined;this.cpuDuration=undefined;this.contexts=Object.freeze([]);}TimedEvent.prototype={__proto__:tr.model.Event.prototype,get end(){return this.start+this.duration;},addBoundsToRange:function(range){range.addValue(this.start);range.addValue(this.end);},bounds:function(that,opt_precisionUnit){if(opt_precisionUnit===undefined)opt_precisionUnit=tr.b.TimeDisplayModes.ms;var startsBefore=opt_precisionUnit.roundedLess(that.start,this.start);var endsAfter=opt_precisionUnit.roundedLess(this.end,that.end);return!startsBefore&&!endsAfter;}};return{TimedEvent:TimedEvent};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/guid.js":45,"../base/time_display_modes.js":61,"./event.js":122}],167:[function(require,module,exports){(function(global){"use strict";require("./user_expectation.js");'use strict';global.tr.exportTo('tr.model.um',function(){function AnimationExpectation(parentModel,initiatorTitle,start,duration){tr.model.um.UserExpectation.call(this,parentModel,initiatorTitle,start,duration);this.frameEvents_=undefined;}AnimationExpectation.prototype={__proto__:tr.model.um.UserExpectation.prototype,constructor:AnimationExpectation,get frameEvents(){if(this.frameEvents_)return this.frameEvents_;this.frameEvents_=new tr.model.EventSet();this.associatedEvents.forEach(function(event){if(event.title===tr.model.helpers.IMPL_RENDERING_STATS)this.frameEvents_.push(event);},this);return this.frameEvents_;}};tr.model.um.UserExpectation.subTypes.register(AnimationExpectation,{stageTitle:'Animation',colorId:tr.b.ColorScheme.getColorIdForReservedName('rail_animation')});return{AnimationExpectation:AnimationExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./user_expectation.js":172}],168:[function(require,module,exports){(function(global){"use strict";require("./user_expectation.js");'use strict';global.tr.exportTo('tr.model.um',function(){function IdleExpectation(parentModel,start,duration){var initiatorTitle='';tr.model.um.UserExpectation.call(this,parentModel,initiatorTitle,start,duration);}IdleExpectation.prototype={__proto__:tr.model.um.UserExpectation.prototype,constructor:IdleExpectation};tr.model.um.UserExpectation.subTypes.register(IdleExpectation,{stageTitle:'Idle',colorId:tr.b.ColorScheme.getColorIdForReservedName('rail_idle')});return{IdleExpectation:IdleExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./user_expectation.js":172}],169:[function(require,module,exports){(function(global){"use strict";require("./user_expectation.js");'use strict';global.tr.exportTo('tr.model.um',function(){var LOAD_SUBTYPE_NAMES={SUCCESSFUL:'Successful',FAILED:'Failed'};var DOES_LOAD_SUBTYPE_NAME_EXIST={};for(var key in LOAD_SUBTYPE_NAMES){DOES_LOAD_SUBTYPE_NAME_EXIST[LOAD_SUBTYPE_NAMES[key]]=true;;}function LoadExpectation(parentModel,initiatorTitle,start,duration){if(!DOES_LOAD_SUBTYPE_NAME_EXIST[initiatorTitle])throw new Error(initiatorTitle+' is not in LOAD_SUBTYPE_NAMES');tr.model.um.UserExpectation.call(this,parentModel,initiatorTitle,start,duration);this.renderProcess=undefined;this.renderMainThread=undefined;this.routingId=undefined;this.parentRoutingId=undefined;this.loadFinishedEvent=undefined;}LoadExpectation.prototype={__proto__:tr.model.um.UserExpectation.prototype,constructor:LoadExpectation};tr.model.um.UserExpectation.subTypes.register(LoadExpectation,{stageTitle:'Load',colorId:tr.b.ColorScheme.getColorIdForReservedName('rail_load')});return{LOAD_SUBTYPE_NAMES:LOAD_SUBTYPE_NAMES,LoadExpectation:LoadExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./user_expectation.js":172}],170:[function(require,module,exports){(function(global){"use strict";require("./user_expectation.js");'use strict';global.tr.exportTo('tr.model.um',function(){function ResponseExpectation(parentModel,initiatorTitle,start,duration,opt_isAnimationBegin){tr.model.um.UserExpectation.call(this,parentModel,initiatorTitle,start,duration);this.isAnimationBegin=opt_isAnimationBegin||false;}ResponseExpectation.prototype={__proto__:tr.model.um.UserExpectation.prototype,constructor:ResponseExpectation};tr.model.um.UserExpectation.subTypes.register(ResponseExpectation,{stageTitle:'Response',colorId:tr.b.ColorScheme.getColorIdForReservedName('rail_response')});return{ResponseExpectation:ResponseExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./user_expectation.js":172}],171:[function(require,module,exports){(function(global){"use strict";require("./user_expectation.js");'use strict';global.tr.exportTo('tr.model.um',function(){function StartupExpectation(parentModel,start,duration){tr.model.um.UserExpectation.call(this,parentModel,'',start,duration);}StartupExpectation.prototype={__proto__:tr.model.um.UserExpectation.prototype,constructor:StartupExpectation};tr.model.um.UserExpectation.subTypes.register(StartupExpectation,{stageTitle:'Startup',colorId:tr.b.ColorScheme.getColorIdForReservedName('startup')});return{StartupExpectation:StartupExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./user_expectation.js":172}],172:[function(require,module,exports){(function(global){"use strict";require("../../base/range_utils.js");require("../../base/statistics.js");require("../../base/unit.js");require("../compound_event_selection_state.js");require("../event_set.js");require("../timed_event.js");'use strict';global.tr.exportTo('tr.model.um',function(){var CompoundEventSelectionState=tr.model.CompoundEventSelectionState;function UserExpectation(parentModel,initiatorTitle,start,duration){tr.model.TimedEvent.call(this,start);this.associatedEvents=new tr.model.EventSet();this.duration=duration;this.initiatorTitle_=initiatorTitle;this.parentModel=parentModel;this.typeInfo_=undefined;this.sourceEvents=new tr.model.EventSet();}UserExpectation.prototype={__proto__:tr.model.TimedEvent.prototype,computeCompoundEvenSelectionState:function(selection){var cess=CompoundEventSelectionState.NOT_SELECTED;if(selection.contains(this))cess|=CompoundEventSelectionState.EVENT_SELECTED;if(this.associatedEvents.intersectionIsEmpty(selection))return cess;var allContained=this.associatedEvents.every(function(event){return selection.contains(event);});if(allContained)cess|=CompoundEventSelectionState.ALL_ASSOCIATED_EVENTS_SELECTED;else cess|=CompoundEventSelectionState.SOME_ASSOCIATED_EVENTS_SELECTED;return cess;},get associatedSamples(){var samples=new tr.model.EventSet();this.associatedEvents.forEach(function(event){if(event instanceof tr.model.ThreadSlice)samples.addEventSet(event.overlappingSamples);});return samples;},get userFriendlyName(){return this.title+' User Expectation at '+tr.b.Unit.byName.timeStampInMs.format(this.start);},get stableId(){return'UserExpectation.'+this.guid;},get typeInfo(){if(!this.typeInfo_){this.typeInfo_=UserExpectation.subTypes.findTypeInfo(this.constructor);}if(!this.typeInfo_)throw new Error('Unregistered UserExpectation');return this.typeInfo_;},get colorId(){return this.typeInfo.metadata.colorId;},get stageTitle(){return this.typeInfo.metadata.stageTitle;},get initiatorTitle(){return this.initiatorTitle_;},get title(){if(!this.initiatorTitle)return this.stageTitle;return this.initiatorTitle+' '+this.stageTitle;},get totalCpuMs(){var cpuMs=0;this.associatedEvents.forEach(function(event){if(event.cpuSelfTime)cpuMs+=event.cpuSelfTime;});return cpuMs;}};var subTypes={};var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);tr.b.decorateExtensionRegistry(subTypes,options);subTypes.addEventListener('will-register',function(e){var metadata=e.typeInfo.metadata;if(metadata.stageTitle===undefined){throw new Error('Registered UserExpectations must provide '+'stageTitle');}if(metadata.colorId===undefined){throw new Error('Registered UserExpectations must provide '+'colorId');}});tr.model.EventRegistry.register(UserExpectation,{name:'userExpectation',pluralName:'userExpectations',subTypes:subTypes});return{UserExpectation:UserExpectation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/range_utils.js":54,"../../base/statistics.js":59,"../../base/unit.js":63,"../compound_event_selection_state.js":113,"../event_set.js":126,"../timed_event.js":166}],173:[function(require,module,exports){(function(global){"use strict";require("../event_container.js");'use strict';global.tr.exportTo('tr.model.um',function(){function UserModel(parentModel){tr.model.EventContainer.call(this);this.parentModel_=parentModel;this.expectations_=new tr.model.EventSet();}UserModel.prototype={__proto__:tr.model.EventContainer.prototype,get stableId(){return'UserModel';},get parentModel(){return this.parentModel_;},sortExpectations:function(){this.expectations_.sortEvents((x,y)=>x.start-y.start);},get expectations(){return this.expectations_;},shiftTimestampsForward:function(amount){},addCategoriesToDict:function(categoriesDict){},childEvents:function*(){yield*this.expectations;},childEventContainers:function*(){},updateBounds:function(){this.bounds.reset();this.expectations.forEach(function(expectation){expectation.addBoundsToRange(this.bounds);},this);}};return{UserModel:UserModel};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../event_container.js":123}],174:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.model',function(){function VMRegion(startAddress,sizeInBytes,protectionFlags,mappedFile,byteStats){this.startAddress=startAddress;this.sizeInBytes=sizeInBytes;this.protectionFlags=protectionFlags;this.mappedFile=mappedFile||'';this.byteStats=byteStats||{};};VMRegion.PROTECTION_FLAG_READ=4;VMRegion.PROTECTION_FLAG_WRITE=2;VMRegion.PROTECTION_FLAG_EXECUTE=1;VMRegion.PROTECTION_FLAG_MAYSHARE=128;VMRegion.prototype={get uniqueIdWithinProcess(){return this.mappedFile+'#'+this.startAddress;},get protectionFlagsToString(){if(this.protectionFlags===undefined)return undefined;return(this.protectionFlags&VMRegion.PROTECTION_FLAG_READ?'r':'-')+(this.protectionFlags&VMRegion.PROTECTION_FLAG_WRITE?'w':'-')+(this.protectionFlags&VMRegion.PROTECTION_FLAG_EXECUTE?'x':'-')+(this.protectionFlags&VMRegion.PROTECTION_FLAG_MAYSHARE?'s':'p');}};VMRegion.fromDict=function(dict){return new VMRegion(dict.startAddress,dict.sizeInBytes,dict.protectionFlags,dict.mappedFile,dict.byteStats);};function VMRegionClassificationNode(opt_rule){this.rule_=opt_rule||VMRegionClassificationNode.CLASSIFICATION_RULES;this.hasRegions=false;this.sizeInBytes=undefined;this.byteStats={};this.children_=undefined;this.regions_=[];}VMRegionClassificationNode.CLASSIFICATION_RULES={name:'Total',children:[{name:'Android',file:/^\/dev\/ashmem(?!\/libc malloc)/,children:[{name:'Java runtime',file:/^\/dev\/ashmem\/dalvik-/,children:[{name:'Spaces',file:/\/dalvik-(alloc|main|large object|non moving|zygote) space/,children:[{name:'Normal',file:/\/dalvik-(alloc|main)/},{name:'Large',file:/\/dalvik-large object/},{name:'Zygote',file:/\/dalvik-zygote/},{name:'Non-moving',file:/\/dalvik-non moving/}]},{name:'Linear Alloc',file:/\/dalvik-LinearAlloc/},{name:'Indirect Reference Table',file:/\/dalvik-indirect.ref/},{name:'Cache',file:/\/dalvik-jit-code-cache/},{name:'Accounting'}]},{name:'Cursor',file:/\/CursorWindow/},{name:'Ashmem'}]},{name:'Native heap',file:/^((\[heap\])|(\[anon:)|(\/dev\/ashmem\/libc malloc)|(\[discounted tracing overhead\])|$)/},{name:'Stack',file:/^\[stack/},{name:'Files',file:/\.((((jar)|(apk)|(ttf)|(odex)|(oat)|(art))$)|(dex)|(so))/,children:[{name:'so',file:/\.so/},{name:'jar',file:/\.jar$/},{name:'apk',file:/\.apk$/},{name:'ttf',file:/\.ttf$/},{name:'dex',file:/\.((dex)|(odex$))/},{name:'oat',file:/\.oat$/},{name:'art',file:/\.art$/}]},{name:'Devices',file:/(^\/dev\/)|(anon_inode:dmabuf)/,children:[{name:'GPU',file:/\/((nv)|(mali)|(kgsl))/},{name:'DMA',file:/anon_inode:dmabuf/}]}]};VMRegionClassificationNode.OTHER_RULE={name:'Other'};VMRegionClassificationNode.fromRegions=function(regions,opt_rules){var tree=new VMRegionClassificationNode(opt_rules);tree.regions_=regions;for(var i=0;i<regions.length;i++)tree.addStatsFromRegion_(regions[i]);return tree;};VMRegionClassificationNode.prototype={get title(){return this.rule_.name;},get children(){if(this.isLeafNode)return undefined;if(this.children_===undefined)this.buildTree_();return this.children_;},get regions(){if(!this.isLeafNode){return undefined;}return this.regions_;},get allRegionsForTesting(){if(this.regions_!==undefined){if(this.children_!==undefined){throw new Error('Internal error: a VM region classification node '+'cannot have both regions and children');}return this.regions_;}var regions=[];this.children_.forEach(function(childNode){regions=regions.concat(childNode.allRegionsForTesting);});return regions;},get isLeafNode(){var children=this.rule_.children;return children===undefined||children.length===0;},addRegion:function(region){this.addRegionRecursively_(region,true);},someRegion:function(fn,opt_this){if(this.regions_!==undefined){return this.regions_.some(fn,opt_this);}return this.children_.some(function(childNode){return childNode.someRegion(fn,opt_this);});},addRegionRecursively_:function(region,addStatsToThisNode){if(addStatsToThisNode)this.addStatsFromRegion_(region);if(this.regions_!==undefined){if(this.children_!==undefined){throw new Error('Internal error: a VM region classification node '+'cannot have both regions and children');}this.regions_.push(region);return;}function regionRowMatchesChildNide(child){var fileRegExp=child.rule_.file;if(fileRegExp===undefined)return true;return fileRegExp.test(region.mappedFile);}var matchedChild=tr.b.findFirstInArray(this.children_,regionRowMatchesChildNide);if(matchedChild===undefined){if(this.children_.length!==this.rule_.children.length)throw new Error('Internal error');matchedChild=new VMRegionClassificationNode(VMRegionClassificationNode.OTHER_RULE);this.children_.push(matchedChild);}matchedChild.addRegionRecursively_(region,true);},buildTree_:function(){var cachedRegions=this.regions_;this.regions_=undefined;this.buildChildNodesRecursively_();for(var i=0;i<cachedRegions.length;i++){this.addRegionRecursively_(cachedRegions[i],false);}},buildChildNodesRecursively_:function(){if(this.children_!==undefined){throw new Error('Internal error: Classification node already has children');}if(this.regions_!==undefined&&this.regions_.length!==0){throw new Error('Internal error: Classification node should have no regions');}if(this.isLeafNode)return;this.regions_=undefined;this.children_=this.rule_.children.map(function(childRule){var child=new VMRegionClassificationNode(childRule);child.buildChildNodesRecursively_();return child;});},addStatsFromRegion_:function(region){this.hasRegions=true;var regionSizeInBytes=region.sizeInBytes;if(regionSizeInBytes!==undefined)this.sizeInBytes=(this.sizeInBytes||0)+regionSizeInBytes;var thisByteStats=this.byteStats;var regionByteStats=region.byteStats;for(var byteStatName in regionByteStats){var regionByteStatValue=regionByteStats[byteStatName];if(regionByteStatValue===undefined)continue;thisByteStats[byteStatName]=(thisByteStats[byteStatName]||0)+regionByteStatValue;}}};return{VMRegion:VMRegion,VMRegionClassificationNode:VMRegionClassificationNode};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../base/base.js":34}],175:[function(require,module,exports){(function(global){"use strict";require("./annotation.js");require("../ui/annotations/x_marker_annotation_view.js");'use strict';global.tr.exportTo('tr.model',function(){function XMarkerAnnotation(timestamp){tr.model.Annotation.apply(this,arguments);this.timestamp=timestamp;this.strokeStyle='rgba(0, 0, 255, 0.5)';}XMarkerAnnotation.fromDict=function(dict){return new XMarkerAnnotation(dict.args.timestamp);};XMarkerAnnotation.prototype={__proto__:tr.model.Annotation.prototype,toDict:function(){return{typeName:'xmarker',args:{timestamp:this.timestamp}};},createView_:function(viewport){return new tr.ui.annotations.XMarkerAnnotationView(viewport,this);}};tr.model.Annotation.register(XMarkerAnnotation,{typeName:'xmarker'});return{XMarkerAnnotation:XMarkerAnnotation};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../ui/annotations/x_marker_annotation_view.js":179,"./annotation.js":108}],176:[function(require,module,exports){(function(global){"use strict";require("../../base/base.js");'use strict';global.tr.exportTo('tr.ui.annotations',function(){function AnnotationView(viewport,annotation){}AnnotationView.prototype={draw:function(ctx){throw new Error('Not implemented');}};return{AnnotationView:AnnotationView};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base.js":34}],177:[function(require,module,exports){(function(global){"use strict";require("./annotation_view.js");'use strict';global.tr.exportTo('tr.ui.annotations',function(){function CommentBoxAnnotationView(viewport,annotation){this.viewport_=viewport;this.annotation_=annotation;this.textArea_=undefined;this.styleWidth=250;this.styleHeight=50;this.fontSize=10;this.rightOffset=50;this.topOffset=25;}CommentBoxAnnotationView.prototype={__proto__:tr.ui.annotations.AnnotationView.prototype,removeTextArea:function(){Polymer.dom(Polymer.dom(this.textArea_).parentNode).removeChild(this.textArea_);},draw:function(ctx){var coords=this.annotation_.location.toViewCoordinates(this.viewport_);if(coords.viewX<0){if(this.textArea_)this.textArea_.style.visibility='hidden';return;}if(!this.textArea_){this.textArea_=document.createElement('textarea');this.textArea_.style.position='absolute';this.textArea_.readOnly=true;this.textArea_.value=this.annotation_.text;this.textArea_.style.zIndex=1;Polymer.dom(Polymer.dom(ctx.canvas).parentNode).appendChild(this.textArea_);}this.textArea_.style.width=this.styleWidth+'px';this.textArea_.style.height=this.styleHeight+'px';this.textArea_.style.fontSize=this.fontSize+'px';this.textArea_.style.visibility='visible';this.textArea_.style.left=coords.viewX+ctx.canvas.getBoundingClientRect().left+this.rightOffset+'px';this.textArea_.style.top=coords.viewY-ctx.canvas.getBoundingClientRect().top-this.topOffset+'px';ctx.strokeStyle='rgb(0, 0, 0)';ctx.lineWidth=2;ctx.beginPath();tr.ui.b.drawLine(ctx,coords.viewX,coords.viewY-ctx.canvas.getBoundingClientRect().top,coords.viewX+this.rightOffset,coords.viewY-this.topOffset-ctx.canvas.getBoundingClientRect().top);ctx.stroke();}};return{CommentBoxAnnotationView:CommentBoxAnnotationView};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./annotation_view.js":176}],178:[function(require,module,exports){(function(global){"use strict";require("./annotation_view.js");'use strict';global.tr.exportTo('tr.ui.annotations',function(){function RectAnnotationView(viewport,annotation){this.viewport_=viewport;this.annotation_=annotation;}RectAnnotationView.prototype={__proto__:tr.ui.annotations.AnnotationView.prototype,draw:function(ctx){var dt=this.viewport_.currentDisplayTransform;var startCoords=this.annotation_.startLocation.toViewCoordinates(this.viewport_);var endCoords=this.annotation_.endLocation.toViewCoordinates(this.viewport_);var startY=startCoords.viewY-ctx.canvas.getBoundingClientRect().top;var sizeY=endCoords.viewY-startCoords.viewY;if(startY+sizeY<0){startY=sizeY;}else if(startY<0){startY=0;}ctx.fillStyle=this.annotation_.fillStyle;ctx.fillRect(startCoords.viewX,startY,endCoords.viewX-startCoords.viewX,sizeY);}};return{RectAnnotationView:RectAnnotationView};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./annotation_view.js":176}],179:[function(require,module,exports){(function(global){"use strict";require("./annotation_view.js");'use strict';global.tr.exportTo('tr.ui.annotations',function(){function XMarkerAnnotationView(viewport,annotation){this.viewport_=viewport;this.annotation_=annotation;}XMarkerAnnotationView.prototype={__proto__:tr.ui.annotations.AnnotationView.prototype,draw:function(ctx){var dt=this.viewport_.currentDisplayTransform;var viewX=dt.xWorldToView(this.annotation_.timestamp);ctx.beginPath();tr.ui.b.drawLine(ctx,viewX,0,viewX,ctx.canvas.height);ctx.strokeStyle=this.annotation_.strokeStyle;ctx.stroke();}};return{XMarkerAnnotationView:XMarkerAnnotationView};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./annotation_view.js":176}],180:[function(require,module,exports){(function(global){"use strict";require("../../base/event.js");require("../../base/utils.js");require("./ui.js");require("./utils.js");'use strict';global.tr.exportTo('tr.ui.b',function(){if(tr.isHeadless)return{};return;var Overlay=tr.ui.b.define('overlay');Overlay.prototype={__proto__:HTMLDivElement.prototype,decorate:function(){Polymer.dom(this).classList.add('overlay');this.parentEl_=this.ownerDocument.body;this.visible_=false;this.userCanClose_=true;this.onKeyDown_=this.onKeyDown_.bind(this);this.onClick_=this.onClick_.bind(this);this.onFocusIn_=this.onFocusIn_.bind(this);this.onDocumentClick_=this.onDocumentClick_.bind(this);this.onClose_=this.onClose_.bind(this);this.addEventListener('visible-change',tr.ui.b.Overlay.prototype.onVisibleChange_.bind(this),true);var createShadowRoot=this.createShadowRoot||this.webkitCreateShadowRoot;this.shadow_=createShadowRoot.call(this);Polymer.dom(this.shadow_).appendChild(tr.ui.b.instantiateTemplate('#overlay-template',THIS_DOC));this.closeBtn_=Polymer.dom(this.shadow_).querySelector('close-button');this.closeBtn_.addEventListener('click',this.onClose_);Polymer.dom(this.shadow_).querySelector('overlay-frame').addEventListener('click',this.onClick_);this.observer_=new WebKitMutationObserver(this.didButtonBarMutate_.bind(this));this.observer_.observe(Polymer.dom(this.shadow_).querySelector('button-bar'),{childList:true});Object.defineProperty(this,'title',{get:function(){return Polymer.dom(Polymer.dom(this.shadow_).querySelector('title')).textContent;},set:function(title){Polymer.dom(Polymer.dom(this.shadow_).querySelector('title')).textContent=title;}});},set userCanClose(userCanClose){this.userCanClose_=userCanClose;this.closeBtn_.style.display=userCanClose?'block':'none';},get buttons(){return Polymer.dom(this.shadow_).querySelector('button-bar');},get visible(){return this.visible_;},set visible(newValue){if(this.visible_===newValue)return;this.visible_=newValue;var e=new tr.b.Event('visible-change');this.dispatchEvent(e);},onVisibleChange_:function(){this.visible_?this.show_():this.hide_();},show_:function(){Polymer.dom(this.parentEl_).appendChild(this);if(this.userCanClose_){this.addEventListener('keydown',this.onKeyDown_.bind(this));this.addEventListener('click',this.onDocumentClick_.bind(this));this.closeBtn_.addEventListener('click',this.onClose_);}this.parentEl_.addEventListener('focusin',this.onFocusIn_);this.tabIndex=0;var focusEl=undefined;var elList=Polymer.dom(this).querySelectorAll('button, input, list, select, a');if(elList.length>0){if(elList[0]===this.closeBtn_){if(elList.length>1)focusEl=elList[1];}else{focusEl=elList[0];}}if(focusEl===undefined)focusEl=this;focusEl.focus();},hide_:function(){Polymer.dom(this.parentEl_).removeChild(this);this.parentEl_.removeEventListener('focusin',this.onFocusIn_);if(this.closeBtn_)this.closeBtn_.removeEventListener('click',this.onClose_);document.removeEventListener('keydown',this.onKeyDown_);document.removeEventListener('click',this.onDocumentClick_);},onClose_:function(e){this.visible=false;if(e.type!='keydown'||e.type==='keydown'&&e.keyCode===27)e.stopPropagation();e.preventDefault();tr.b.dispatchSimpleEvent(this,'closeclick');},onFocusIn_:function(e){if(e.target===this)return;window.setTimeout(function(){this.focus();},0);e.preventDefault();e.stopPropagation();},didButtonBarMutate_:function(e){var hasButtons=this.buttons.children.length>0;if(hasButtons){Polymer.dom(this.shadow_).querySelector('button-bar').style.display=undefined;}else{Polymer.dom(this.shadow_).querySelector('button-bar').style.display='none';}},onKeyDown_:function(e){if(e.keyCode===9&&e.shiftKey&&e.target===this){e.preventDefault();return;}if(e.keyCode!==27)return;this.onClose_(e);},onClick_:function(e){e.stopPropagation();},onDocumentClick_:function(e){if(!this.userCanClose_)return;this.onClose_(e);}};Overlay.showError=function(msg,opt_err){var o=new Overlay();o.title='Error';Polymer.dom(o).textContent=msg;if(opt_err){var e=tr.b.normalizeException(opt_err);var stackDiv=document.createElement('pre');Polymer.dom(stackDiv).textContent=e.stack;stackDiv.style.paddingLeft='8px';stackDiv.style.margin=0;Polymer.dom(o).appendChild(stackDiv);}var b=document.createElement('button');Polymer.dom(b).textContent='OK';b.addEventListener('click',function(){o.visible=false;});Polymer.dom(o.buttons).appendChild(b);o.visible=true;return o;};return{Overlay:Overlay};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/event.js":39,"../../base/utils.js":65,"./ui.js":181,"./utils.js":182}],181:[function(require,module,exports){(function(global){"use strict";require("../../base/base.js");'use strict';global.tr.exportTo('tr.ui.b',function(){function decorate(source,constr){var elements;if(typeof source=='string')elements=Polymer.dom(tr.doc).querySelectorAll(source);else elements=[source];for(var i=0,el;el=elements[i];i++){if(!(el instanceof constr))constr.decorate(el);}}function define(className,opt_parentConstructor,opt_tagNS){if(typeof className=='function'){throw new Error('Passing functions as className is deprecated. Please '+'use (className, opt_parentConstructor) to subclass');}var className=className.toLowerCase();if(opt_parentConstructor&&!opt_parentConstructor.tagName)throw new Error('opt_parentConstructor was not '+'created by tr.ui.b.define');var tagName=className;var tagNS=undefined;if(opt_parentConstructor){if(opt_tagNS)throw new Error('Must not specify tagNS if parentConstructor is given');var parent=opt_parentConstructor;while(parent&&parent.tagName){tagName=parent.tagName;tagNS=parent.tagNS;parent=parent.parentConstructor;}}else{tagNS=opt_tagNS;}function f(){if(opt_parentConstructor&&f.prototype.__proto__!=opt_parentConstructor.prototype){throw new Error(className+' prototye\'s __proto__ field is messed up. '+'It MUST be the prototype of '+opt_parentConstructor.tagName);}var el;if(tagNS===undefined)el=tr.doc.createElement(tagName);else el=tr.doc.createElementNS(tagNS,tagName);f.decorate.call(this,el,arguments);return el;}f.decorate=function(el){el.__proto__=f.prototype;el.decorate.apply(el,arguments[1]);el.constructor=f;};f.className=className;f.tagName=tagName;f.tagNS=tagNS;f.parentConstructor=opt_parentConstructor?opt_parentConstructor:undefined;f.toString=function(){if(!f.parentConstructor)return f.tagName;return f.parentConstructor.toString()+'::'+f.className;};return f;}function elementIsChildOf(el,potentialParent){if(el==potentialParent)return false;var cur=el;while(Polymer.dom(cur).parentNode){if(cur==potentialParent)return true;cur=Polymer.dom(cur).parentNode;}return false;};return{decorate:decorate,define:define,elementIsChildOf:elementIsChildOf};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base.js":34}],182:[function(require,module,exports){(function(global){"use strict";require("../../base/base.js");require("../../base/rect.js");'use strict';global.tr.exportTo('tr.ui.b',function(){function instantiateTemplate(selector,doc){doc=doc||document;var el=Polymer.dom(doc).querySelector(selector);if(!el)throw new Error('Element not found');return doc.importNode(el.content,true);}function windowRectForElement(element){var position=[element.offsetLeft,element.offsetTop];var size=[element.offsetWidth,element.offsetHeight];var node=element.offsetParent;while(node){position[0]+=node.offsetLeft;position[1]+=node.offsetTop;node=node.offsetParent;}return tr.b.Rect.fromXYWH(position[0],position[1],size[0],size[1]);}function scrollIntoViewIfNeeded(el){var pr=el.parentElement.getBoundingClientRect();var cr=el.getBoundingClientRect();if(cr.top<pr.top){el.scrollIntoView(true);}else if(cr.bottom>pr.bottom){el.scrollIntoView(false);}}function extractUrlString(url){var extracted=url.replace(/url\((.*)\)/,'$1');extracted=extracted.replace(/\"(.*)\"/,'$1');return extracted;}function toThreeDigitLocaleString(value){return value.toLocaleString(undefined,{minimumFractionDigits:3,maximumFractionDigits:3});}function isUnknownElementName(name){return document.createElement(name)instanceof HTMLUnknownElement;}return{isUnknownElementName:isUnknownElementName,toThreeDigitLocaleString:toThreeDigitLocaleString,instantiateTemplate:instantiateTemplate,windowRectForElement:windowRectForElement,scrollIntoViewIfNeeded:scrollIntoViewIfNeeded,extractUrlString:extractUrlString};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base.js":34,"../../base/rect.js":55}],183:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("./related_value_map.js");'use strict';global.tr.exportTo('tr.v.d',function(){class Breakdown extends tr.v.d.Diagnostic{constructor(){super();this.values_=new Map();this.colorScheme=undefined;}set(name,value){if(typeof name!=='string'||typeof value!=='number'){throw new Error('Breakdown maps from strings to numbers');}this.values_.set(name,value);}get(name){return this.values_.get(name)||0;}*[Symbol.iterator](){for(var pair of this.values_)yield pair;}asDictInto_(d){d.values={};for(var _ref of this){var _ref2=_slicedToArray(_ref,2);var name=_ref2[0];var value=_ref2[1];d.values[name]=value;}if(this.colorScheme)d.colorScheme=this.colorScheme;}static fromDict(d){var breakdown=new Breakdown();tr.b.iterItems(d.values,(name,value)=>breakdown.set(name,value));if(d.colorScheme)breakdown.colorScheme=d.colorScheme;return breakdown;}}tr.v.d.Diagnostic.register(Breakdown,{elementName:'tr-v-ui-breakdown-span'});return{Breakdown:Breakdown};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./related_value_map.js":191}],184:[function(require,module,exports){(function(global){"use strict";require("../../base/extension_registry.js");'use strict';global.tr.exportTo('tr.v.d',function(){class Diagnostic{asDict(){var result={type:this.constructor.name};this.asDictInto_(result);return result;}asDictInto_(d){throw new Error('Abstract virtual method');}static fromDict(d){var typeInfo=Diagnostic.findTypeInfoWithName(d.type);if(!typeInfo)throw new Error('Unrecognized diagnostic type: '+d.type);return typeInfo.constructor.fromDict(d);}}var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);options.defaultMetadata={};options.mandatoryBaseClass=Diagnostic;tr.b.decorateExtensionRegistry(Diagnostic,options);Diagnostic.addEventListener('will-register',function(e){var constructor=e.typeInfo.constructor;if(!(constructor.fromDict instanceof Function)||constructor.fromDict===Diagnostic.fromDict||constructor.fromDict.length!==1){throw new Error('Diagnostics must define fromDict(d)');}});return{Diagnostic:Diagnostic};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/extension_registry.js":41}],185:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("./breakdown.js");require("./generic.js");require("./iteration_info.js");require("./related_event_set.js");require("./related_histogram_breakdown.js");require("./related_value_map.js");require("./related_value_set.js");require("./scalar.js");'use strict';global.tr.exportTo('tr.v.d',function(){class DiagnosticMap extends Map{set(name,diagnostic){if(typeof name!=='string')throw new Error('name must be string, not '+name);if(!(diagnostic instanceof tr.v.d.Diagnostic))throw new Error('Must be instanceof Diagnostic: '+diagnostic);Map.prototype.set.call(this,name,diagnostic);}addDicts(dict){tr.b.iterItems(dict,function(name,diagnosticDict){this.set(name,tr.v.d.Diagnostic.fromDict(diagnosticDict));},this);}asDict(){var dict={};for(var _ref of this){var _ref2=_slicedToArray(_ref,2);var name=_ref2[0];var diagnostic=_ref2[1];dict[name]=diagnostic.asDict();}return dict;}static fromDict(d){var diagnostics=new DiagnosticMap();diagnostics.addDicts(d);return diagnostics;}static fromObject(obj){var diagnostics=new DiagnosticMap();tr.b.iterItems(obj,function(name,diagnostic){diagnostics.set(name,diagnostic);});return diagnostics;}}return{DiagnosticMap:DiagnosticMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./breakdown.js":183,"./generic.js":187,"./iteration_info.js":188,"./related_event_set.js":189,"./related_histogram_breakdown.js":190,"./related_value_map.js":191,"./related_value_set.js":192,"./scalar.js":193}],186:[function(require,module,exports){(function(global){"use strict";require("../../base/guid.js");'use strict';global.tr.exportTo('tr.v.d',function(){class EventRef{constructor(event){this.stableId=event.stableId;this.title=event.title;this.start=event.start;this.duration=event.duration;this.end=this.start+this.duration;this.guid=tr.b.GUID.allocateSimple();}}return{EventRef:EventRef};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/guid.js":45}],187:[function(require,module,exports){(function(global){"use strict";require("./diagnostic.js");'use strict';global.tr.exportTo('tr.v.d',function(){class Generic extends tr.v.d.Diagnostic{constructor(value){super();this.value=value;}asDictInto_(d){d.value=this.value;}static fromDict(d){return new Generic(d.value);}}tr.v.d.Diagnostic.register(Generic,{elementName:'tr-v-ui-generic-diagnostic-span'});return{Generic:Generic};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./diagnostic.js":184}],188:[function(require,module,exports){(function(global){"use strict";require("../../base/utils.js");require("./diagnostic.js");'use strict';global.tr.exportTo('tr.v.d',function(){class IterationInfo extends tr.v.d.Diagnostic{constructor(opt_info){super();this.benchmarkName_='';this.benchmarkStart_=undefined;this.label_='';this.osVersion_='';this.productVersion_='';this.storyDisplayName_='';this.storyGroupingKeys_={};this.storyRepeatCounter_=undefined;this.storyUrl_='';this.storysetRepeatCounter_=undefined;if(opt_info)this.addInfo(opt_info);}addInfo(info){if(info.benchmarkName)this.benchmarkName_=info.benchmarkName;if(info.benchmarkStartMs)this.benchmarkStart_=new Date(info.benchmarkStartMs);if(info.label)this.label_=info.label;if(info.storyDisplayName)this.storyDisplayName_=info.storyDisplayName;if(info.storyGroupingKeys)this.storyGroupingKeys_=info.storyGroupingKeys;if(info.storyRepeatCounter!==undefined)this.storyRepeatCounter_=info.storyRepeatCounter;if(info.storyUrl)this.storyUrl_=info.storyUrl;if(info.storysetRepeatCounter!==undefined)this.storysetRepeatCounter_=info.storysetRepeatCounter;if(info['os-version'])this.osVersion_=info['os-version'];if(info['product-version'])this.productVersion_=info['product-version'];}addToValue(value){value.diagnostics.set(IterationInfo.NAME,this);}static getFromValue(value){return value.diagnostics.get(IterationInfo.NAME);}asDictInto_(d){d.benchmarkName=this.benchmarkName;if(this.benchmarkStart)d.benchmarkStartMs=this.benchmarkStart.getTime();d.label=this.label;d.storyDisplayName=this.storyDisplayName;d.storyGroupingKeys=this.storyGroupingKeys;d.storyRepeatCounter=this.storyRepeatCounter;d.storyUrl=this.storyUrl;d.storysetRepeatCounter=this.storysetRepeatCounter;d['os-version']=this.osVersion;d['product-version']=this.productVersion;}static fromDict(d){var info=new IterationInfo();info.addInfo(d);return info;}get displayLabel(){if(this.label)return this.label;return this.benchmarkName+' '+this.benchmarkStartString;}get osVersion(){return this.osVersion_;}get productVersion(){return this.productVersion_;}get benchmarkName(){return this.benchmarkName_;}get label(){return this.label_;}get storyGroupingKeys(){return this.storyGroupingKeys_;}get storyDisplayName(){return this.storyDisplayName_;}get storyUrl(){return this.storyUrl_;}get storyRepeatCounter(){return this.storyRepeatCounter_;}get storyRepeatCounterLabel(){return'story repeat '+this.storyRepeatCounter;}get storysetRepeatCounter(){return this.storysetRepeatCounter_;}get storysetRepeatCounterLabel(){return'storyset repeat '+this.storysetRepeatCounter;}get benchmarkStart(){return this.benchmarkStart_;}get benchmarkStartString(){if(this.benchmarkStart_===undefined)return'';return tr.b.formatDate(this.benchmarkStart);}static getField(value,fieldName,defaultValue){var iteration=tr.v.d.IterationInfo.getFromValue(value);if(!(iteration instanceof tr.v.d.IterationInfo)||!iteration[fieldName]){return defaultValue;}return iteration[fieldName];}static getStoryGroupingKeyLabel(value,storyGroupingKey){var iteration=tr.v.d.IterationInfo.getFromValue(value);if(!(iteration instanceof tr.v.d.IterationInfo))return storyGroupingKey+': undefined';return storyGroupingKey+': '+iteration.storyGroupingKeys[storyGroupingKey];}}IterationInfo.NAME='iteration';tr.v.d.Diagnostic.register(IterationInfo,{elementName:'tr-v-ui-iteration-info-span'});return{IterationInfo:IterationInfo};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/utils.js":65,"./diagnostic.js":184}],189:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("../../model/event_set.js");require("./diagnostic.js");require("./event_ref.js");'use strict';global.tr.exportTo('tr.v.d',function(){class RelatedEventSet extends tr.v.d.Diagnostic{constructor(opt_events){super();this.eventsByStableId_=new Map();if(opt_events){if(opt_events instanceof tr.model.EventSet||opt_events instanceof Array){for(var event of opt_events)this.add(event);}else{this.add(opt_events);}}}add(event){this.eventsByStableId_.set(event.stableId,event);}has(event){return this.eventsByStableId_.has(event.stableId);}get length(){return this.eventsByStableId_.size;}*[Symbol.iterator](){for(var _ref of this.eventsByStableId_){var _ref2=_slicedToArray(_ref,2);var stableId=_ref2[0];var event=_ref2[1];yield event;}}resolve(model,opt_required){for(var _ref3 of this.eventsByStableId_){var _ref4=_slicedToArray(_ref3,2);var stableId=_ref4[0];var event=_ref4[1];if(!(event instanceof tr.v.d.EventRef))continue;event=model.getEventByStableId(stableId);if(event instanceof tr.model.Event)this.eventsByStableId_.set(stableId,event);else if(opt_required)throw new Error('Unable to find Event '+stableId);}}asDictInto_(d){d.events=[];for(var event of this){d.events.push({stableId:event.stableId,title:event.title,start:event.start,duration:event.duration});}}static fromDict(d){return new RelatedEventSet(d.events.map(event=>new tr.v.d.EventRef(event)));}}tr.v.d.Diagnostic.register(RelatedEventSet,{elementName:'tr-v-ui-related-event-set-span'});return{RelatedEventSet:RelatedEventSet};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../model/event_set.js":126,"./diagnostic.js":184,"./event_ref.js":186}],190:[function(require,module,exports){(function(global){"use strict";require("./related_value_map.js");'use strict';global.tr.exportTo('tr.v.d',function(){var COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER='ChromeUserFriendlyCategory';class RelatedHistogramBreakdown extends tr.v.d.RelatedValueMap{constructor(){super();this.colorScheme=undefined;}set(name,value){if(!(value instanceof tr.v.d.ValueRef)){if(!(value instanceof tr.v.Histogram)){throw new Error('RelatedHistogramBreakdown can only contain Histograms');}if(value.name.indexOf(name)!==value.name.length-name.length){throw new Error('RelatedHistogramBreakdown name must be a suffix of value.name');}if(this.length>0&&value.unit!==tr.b.getFirstElement(this)[1].unit){throw new Error('Units mismatch',tr.b.getFirstElement(this)[1].unit,value.unit);}}tr.v.d.RelatedValueMap.prototype.set.call(this,name,value);}asDictInto_(d){tr.v.d.RelatedValueMap.prototype.asDictInto_.call(this,d);if(this.colorScheme)d.colorScheme=this.colorScheme;}static fromDict(d){var diagnostic=new RelatedHistogramBreakdown();tr.b.iterItems(d.values,function(name,guid){diagnostic.set(name,new tr.v.d.ValueRef(guid));});if(d.colorScheme)diagnostic.colorScheme=d.colorScheme;return diagnostic;}static buildFromEvents(values,namePrefix,events,categoryForEvent,unit,opt_sampleForEvent,opt_binBoundaries,opt_this){var sampleForEvent=opt_sampleForEvent||(event=>event.cpuSelfTime);var diagnostic=new RelatedHistogramBreakdown();for(var event of events){var sample=sampleForEvent.call(opt_this,event);if(sample===undefined)continue;var eventCategory=categoryForEvent.call(opt_this,event);var value=diagnostic.get(eventCategory);if(value===undefined){value=new tr.v.Histogram(namePrefix+eventCategory,unit,opt_binBoundaries);values.addHistogram(value);diagnostic.set(eventCategory,value);}value.addSample(sample,{relatedEvents:new tr.v.d.RelatedEventSet([event])});}return diagnostic;}}tr.v.d.Diagnostic.register(RelatedHistogramBreakdown,{elementName:'tr-v-ui-breakdown-span'});return{COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER:COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER,RelatedHistogramBreakdown:RelatedHistogramBreakdown};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./related_value_map.js":191}],191:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("../../base/iteration_helpers.js");require("./diagnostic.js");require("./value_ref.js");'use strict';global.tr.exportTo('tr.v.d',function(){class RelatedValueMap extends tr.v.d.Diagnostic{constructor(){super();this.valuesByName_=new Map();}get(name){return this.valuesByName_.get(name);}set(name,value){if(!(value instanceof tr.v.Histogram)&&!(value instanceof tr.v.d.ValueRef))throw new Error('Must be instanceof Histogram or ValueRef: '+value);this.valuesByName_.set(name,value);}add(value){this.set(value.name,value);}get length(){return this.valuesByName_.size;}*[Symbol.iterator](){for(var pair of this.valuesByName_)yield pair;}resolve(valueSet,opt_required){for(var _ref of this){var _ref2=_slicedToArray(_ref,2);var name=_ref2[0];var value=_ref2[1];if(!(value instanceof tr.v.d.ValueRef))continue;var guid=value.guid;value=valueSet.lookup(guid);if(value instanceof tr.v.Histogram)this.valuesByName_.set(name,value);else if(opt_required)throw new Error('Unable to find Histogram '+guid);}}asDictInto_(d){d.values={};for(var _ref3 of this){var _ref4=_slicedToArray(_ref3,2);var name=_ref4[0];var value=_ref4[1];d.values[name]=value.guid;}}static fromDict(d){var map=new RelatedValueMap();tr.b.iterItems(d.values,function(name,guid){map.set(name,new tr.v.d.ValueRef(guid));});return map;}}tr.v.d.Diagnostic.register(RelatedValueMap,{elementName:'tr-v-ui-related-value-map-span'});return{RelatedValueMap:RelatedValueMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/iteration_helpers.js":47,"./diagnostic.js":184,"./value_ref.js":194}],192:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("../../base/iteration_helpers.js");require("./diagnostic.js");require("./value_ref.js");'use strict';global.tr.exportTo('tr.v.d',function(){class RelatedValueSet extends tr.v.d.Diagnostic{constructor(opt_values){super();this.valuesByGuid_=new Map();if(opt_values)for(var value of opt_values)this.add(value);}add(value){if(!(value instanceof tr.v.Histogram)&&!(value instanceof tr.v.d.ValueRef))throw new Error('Must be instanceof Histogram or ValueRef: '+value);if(this.valuesByGuid_.get(value.guid))throw new Error('Tried to add same value twice');this.valuesByGuid_.set(value.guid,value);}has(value){return this.valuesByGuid_.has(value.guid);}get length(){return this.valuesByGuid_.size;}*[Symbol.iterator](){for(var _ref of this.valuesByGuid_){var _ref2=_slicedToArray(_ref,2);var guid=_ref2[0];var value=_ref2[1];yield value;}}resolve(valueSet,opt_required){for(var _ref3 of this.valuesByGuid_){var _ref4=_slicedToArray(_ref3,2);var guid=_ref4[0];var value=_ref4[1];if(!(value instanceof tr.v.d.ValueRef))continue;value=valueSet.lookup(guid);if(value instanceof tr.v.Histogram)this.valuesByGuid_.set(guid,value);else if(opt_required)throw new Error('Unable to find Histogram '+guid);}}asDictInto_(d){d.guids=[];for(var value of this)d.guids.push(value.guid);}static fromDict(d){return new RelatedValueSet(d.guids.map(guid=>new tr.v.d.ValueRef(guid)));}}tr.v.d.Diagnostic.register(RelatedValueSet,{elementName:'tr-v-ui-related-value-set-span'});return{RelatedValueSet:RelatedValueSet};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/iteration_helpers.js":47,"./diagnostic.js":184,"./value_ref.js":194}],193:[function(require,module,exports){(function(global){"use strict";require("./diagnostic.js");require("../numeric.js");'use strict';global.tr.exportTo('tr.v.d',function(){class Scalar extends tr.v.d.Diagnostic{constructor(value){super();if(!(value instanceof tr.v.ScalarNumeric))throw new Error("expected ScalarNumeric");this.value=value;}asDictInto_(d){d.value=this.value.asDict();}static fromDict(d){return new Scalar(tr.v.ScalarNumeric.fromDict(d.value));}}tr.v.d.Diagnostic.register(Scalar,{elementName:'tr-v-ui-scalar-diagnostic-span'});return{Scalar:Scalar};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../numeric.js":196,"./diagnostic.js":184}],194:[function(require,module,exports){(function(global){"use strict";require("../../base/base.js");'use strict';global.tr.exportTo('tr.v.d',function(){function ValueRef(guid){this.guid=guid;}return{ValueRef:ValueRef};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"../../base/base.js":34}],195:[function(require,module,exports){(function(global){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break;}}catch(err){_d=true;_e=err;}finally{try{if(!_n&&_i["return"])_i["return"]();}finally{if(_d)throw _e;}}return _arr;}return function(arr,i){if(Array.isArray(arr)){return arr;}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i);}else{throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();require("../base/iteration_helpers.js");require("../base/range.js");require("../base/running_statistics.js");require("../base/sorted_array_utils.js");require("../base/statistics.js");require("../base/unit.js");require("./diagnostics/diagnostic_map.js");require("./numeric.js");'use strict';global.tr.exportTo('tr.v',function(){var MAX_DIAGNOSTIC_MAPS=16;var DEFAULT_BOUNDARIES_FOR_UNIT=new Map();class HistogramBin{constructor(range){this.range=range;this.count=0;this.diagnosticMaps=[];}addSample(value){this.count+=1;}addDiagnosticMap(diagnostics){tr.b.Statistics.uniformlySampleStream(this.diagnosticMaps,this.count,diagnostics,MAX_DIAGNOSTIC_MAPS);}addBin(other){if(!this.range.equals(other.range))throw new Error('Merging incompatible Histogram bins.');tr.b.Statistics.mergeSampledStreams(this.diagnosticMaps,this.count,other.diagnosticMaps,other.count,MAX_DIAGNOSTIC_MAPS);this.count+=other.count;}fromDict(dict){this.count=dict[0];if(dict.length>1){for(var map of dict[1]){this.diagnosticMaps.push(tr.v.d.DiagnosticMap.fromDict(map));}}}asDict(){if(!this.diagnosticMaps.length){return[this.count];}return[this.count,this.diagnosticMaps.map(d=>d.asDict())];}}var DEFAULT_SUMMARY_OPTIONS=new Map([['avg',true],['geometricMean',false],['std',true],['count',true],['sum',true],['min',true],['max',true],['nans',false]]);class Histogram{constructor(name,unit,opt_binBoundaries){var binBoundaries=opt_binBoundaries;if(!binBoundaries){var baseUnit=unit.baseUnit?unit.baseUnit:unit;binBoundaries=DEFAULT_BOUNDARIES_FOR_UNIT.get(baseUnit.unitName);}this.guid_=undefined;this.binBoundariesDict_=binBoundaries.asDict();this.centralBins=[];this.description='';this.diagnostics=new tr.v.d.DiagnosticMap();this.maxCount_=0;this.name_=name;this.nanDiagnosticMaps=[];this.numNans=0;this.running=new tr.b.RunningStatistics();this.sampleValues_=[];this.shortName=undefined;this.summaryOptions=new Map(DEFAULT_SUMMARY_OPTIONS);this.summaryOptions.set('percentile',[]);this.unit=unit;this.underflowBin=new HistogramBin(tr.b.Range.fromExplicitRange(-Number.MAX_VALUE,binBoundaries.range.min));this.overflowBin=new HistogramBin(tr.b.Range.fromExplicitRange(binBoundaries.range.max,Number.MAX_VALUE));for(var range of binBoundaries.binRanges()){this.centralBins.push(new HistogramBin(range));}this.allBins=[this.underflowBin];for(var bin of this.centralBins)this.allBins.push(bin);this.allBins.push(this.overflowBin);this.maxNumSampleValues_=this.defaultMaxNumSampleValues_;}get maxNumSampleValues(){return this.maxNumSampleValues_;}set maxNumSampleValues(n){this.maxNumSampleValues_=n;tr.b.Statistics.uniformlySampleArray(this.sampleValues_,this.maxNumSampleValues_);}get name(){return this.name_;}get guid(){if(this.guid_===undefined)this.guid_=tr.b.GUID.allocateUUID4();return this.guid_;}set guid(guid){if(this.guid_!==undefined)throw new Error('Cannot reset guid');this.guid_=guid;}static fromDict(dict){var hist=new Histogram(dict.name,tr.b.Unit.fromJSON(dict.unit),HistogramBinBoundaries.fromDict(dict.binBoundaries));hist.guid=dict.guid;if(dict.shortName){hist.shortName=dict.shortName;}if(dict.description){hist.description=dict.description;}if(dict.diagnostics){hist.diagnostics.addDicts(dict.diagnostics);}if(dict.underflowBin){hist.underflowBin.fromDict(dict.underflowBin);}if(dict.overflowBin){hist.overflowBin.fromDict(dict.overflowBin);}if(dict.centralBins){if(dict.centralBins.length!==undefined){for(var i=0;i<dict.centralBins.length;++i){hist.centralBins[i].fromDict(dict.centralBins[i]);}}else{tr.b.iterItems(dict.centralBins,(i,binDict)=>{hist.centralBins[i].fromDict(binDict);});}}for(var bin of hist.allBins){hist.maxCount_=Math.max(hist.maxCount_,bin.count);}if(dict.running){hist.running=tr.b.RunningStatistics.fromDict(dict.running);}if(dict.summaryOptions){hist.customizeSummaryOptions(dict.summaryOptions);}if(dict.maxNumSampleValues!==undefined){hist.maxNumSampleValues=dict.maxNumSampleValues;}if(dict.sampleValues){hist.sampleValues_=dict.sampleValues;}if(dict.numNans){hist.numNans=dict.numNans;}if(dict.nanDiagnostics){for(var map of dict.nanDiagnostics){hist.nanDiagnosticMaps.push(tr.v.d.DiagnosticMap.fromDict(map));}}return hist;}static buildFromSamples(unit,samples){var boundaries=HistogramBinBoundaries.createFromSamples(samples);var result=new Histogram(unit,boundaries);result.maxNumSampleValues=1000;for(var sample of samples)result.addSample(sample);return result;}get numValues(){return tr.b.Statistics.sum(this.allBins,function(e){return e.count;});}get average(){return this.running.mean;}get standardDeviation(){return this.running.stddev;}get geometricMean(){return this.running.geometricMean;}get sum(){return this.running.sum;}get maxCount(){return this.maxCount_;}getDifferenceSignificance(other,opt_alpha){if(this.unit!==other.unit)throw new Error('Cannot compare Numerics with different units');if(this.unit.improvementDirection===tr.b.ImprovementDirection.DONT_CARE){return tr.b.Statistics.Significance.DONT_CARE;}if(!(other instanceof Histogram))throw new Error('Unable to compute a p-value');var testResult=tr.b.Statistics.mwu(this.sampleValues,other.sampleValues,opt_alpha);return testResult.significance;}getApproximatePercentile(percent){if(!(percent>=0&&percent<=1))throw new Error('percent must be [0,1]');if(this.numValues==0)return 0;var valuesToSkip=Math.floor((this.numValues-1)*percent);for(var i=0;i<this.allBins.length;i++){var bin=this.allBins[i];valuesToSkip-=bin.count;if(valuesToSkip<0){if(bin===this.underflowBin)return bin.range.max;else if(bin===this.overflowBin)return bin.range.min;else return bin.range.center;}}throw new Error('Unreachable');}getBinForValue(value){var binIndex=tr.b.findHighIndexInSortedArray(this.allBins,b=>value<b.range.max?-1:1);return this.allBins[binIndex]||this.overflowBin;}addSample(value,opt_diagnostics){if(opt_diagnostics&&!(opt_diagnostics instanceof tr.v.d.DiagnosticMap))opt_diagnostics=tr.v.d.DiagnosticMap.fromObject(opt_diagnostics);if(typeof value!=='number'||isNaN(value)){this.numNans++;if(opt_diagnostics){tr.b.Statistics.uniformlySampleStream(this.nanDiagnosticMaps,this.numNans,opt_diagnostics,MAX_DIAGNOSTIC_MAPS);}}else{this.running.add(value);var bin=this.getBinForValue(value);bin.addSample(value);if(opt_diagnostics)bin.addDiagnosticMap(opt_diagnostics);if(bin.count>this.maxCount_)this.maxCount_=bin.count;}tr.b.Statistics.uniformlySampleStream(this.sampleValues_,this.numValues+this.numNans,value,this.maxNumSampleValues);}sampleValuesInto(samples){for(var sampleValue of this.sampleValues)samples.push(sampleValue);}canAddHistogram(other){if(this.unit!==other.unit)return false;if(this.allBins.length!==other.allBins.length)return false;for(var i=0;i<this.allBins.length;++i)if(!this.allBins[i].range.equals(other.allBins[i].range))return false;return true;}addHistogram(other){if(!this.canAddHistogram(other)){throw new Error('Merging incompatible Histograms');}tr.b.Statistics.mergeSampledStreams(this.nanDiagnosticMaps,this.numNans,other.nanDiagnosticMaps,other.numNans,MAX_DIAGNOSTIC_MAPS);tr.b.Statistics.mergeSampledStreams(this.sampleValues,this.numValues,other.sampleValues,other.numValues,tr.b.Statistics.mean([this.maxNumSampleValues,other.maxNumSampleValues]));this.numNans+=other.numNans;this.running=this.ru