var CLOSURE_NO_DEPS=true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split('.');
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript('var ' + parts[0]);
  }
  for (var part; parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else if (cur[part]) {
      cur = cur[part];
    } else {
      cur = cur[part] = {};
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES &&
        Object.prototype.hasOwnProperty.call(
            goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else if (goog.global.CLOSURE_DEFINES &&
        Object.prototype.hasOwnProperty.call(
            goog.global.CLOSURE_DEFINES, name)) {
      value = goog.global.CLOSURE_DEFINES[name];
    }
  }
  goog.exportPath_(name, value);
};
goog.DEBUG = true;
goog.define('goog.LOCALE', 'en');  // default to en
goog.define('goog.TRUSTED_SITE', true);
goog.define('goog.STRICT_MODE_COMPATIBLE', false);
goog.provide = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while ((namespace = namespace.substring(0, namespace.lastIndexOf('.')))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name);
};
goog.setTestOnly = function(opt_message) {
  if (COMPILED && !goog.DEBUG) {
    opt_message = opt_message || '';
    throw Error('Importing test-only code into non-debug environment' +
                (opt_message ? ': ' + opt_message : '.'));
  }
};
goog.forwardDeclare = function(name) {};
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return !goog.implicitNamespaces_[name] &&
        goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split('.');
  var cur = opt_obj || goog.global;
  for (var part; part = parts.shift(); ) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, '/');
    var deps = goog.dependencies_;
    for (var i = 0; provide = provides[i]; i++) {
      deps.nameToPath[provide] = path;
      if (!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {};
      }
      deps.pathToNames[path][provide] = true;
    }
    for (var j = 0; require = requires[j]; j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define('goog.ENABLE_DEBUG_LOADER', true);
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return;
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return;
      }
    }
    var errorMessage = 'goog.require could not find: ' + name;
    if (goog.global.console) {
      goog.global.console['error'](errorMessage);
    }
      throw Error(errorMessage);
  }
};
goog.basePath = '';
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {};
goog.identityFunction = function(opt_returnValue, var_args) {
  return opt_returnValue;
};
goog.abstractMethod = function() {
  throw Error('unimplemented abstract method');
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
if (goog.DEPENDENCIES_ENABLED) {
  goog.included_ = {};
  goog.dependencies_ = {
    pathToNames: {}, // 1 to many
    nameToPath: {}, // 1 to 1
    requires: {}, // 1 to many
    visited: {},
    written: {} // Used to keep track of script files we have written.
  };
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != 'undefined' &&
           'write' in doc;  // XULDocument misses write.
  };
  goog.findBasePath_ = function() {
    if (goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else if (!goog.inHtmlDocument_()) {
      return;
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName('script');
    for (var i = scripts.length - 1; i >= 0; --i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf('?');
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == 'base.js') {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT ||
        goog.writeScriptTag_;
    if (!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.writeScriptTag_ = function(src) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (doc.readyState == 'complete') {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      doc.write(
          '<script type="text/javascript" src="' + src + '"></' + 'script>');
      return true;
    } else {
      return false;
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        if (!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path);
        }
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error('Undefined nameToPath for ' + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    for (var path in goog.included_) {
      if (!deps.written[path]) {
        visitNode(path);
      }
    }
    for (var i = 0; i < scripts.length; i++) {
      if (scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i]);
      } else {
        throw Error('Undefined script input');
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + 'deps.js');
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == 'object') {
    if (value) {
      if (value instanceof Array) {
        return 'array';
      } else if (value instanceof Object) {
        return s;
      }
      var className = Object.prototype.toString.call(
           (value));
      if (className == '[object Window]') {
        return 'object';
      }
      if ((className == '[object Array]' ||
           typeof value.length == 'number' &&
           typeof value.splice != 'undefined' &&
           typeof value.propertyIsEnumerable != 'undefined' &&
           !value.propertyIsEnumerable('splice')
          )) {
        return 'array';
      }
      if ((className == '[object Function]' ||
          typeof value.call != 'undefined' &&
          typeof value.propertyIsEnumerable != 'undefined' &&
          !value.propertyIsEnumerable('call'))) {
        return 'function';
      }
    } else {
      return 'null';
    }
  } else if (s == 'function' && typeof value.call == 'undefined') {
    return 'object';
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == 'array';
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == 'array' || type == 'object' && typeof val.length == 'number';
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == 'function';
};
goog.isString = function(val) {
  return typeof val == 'string';
};
goog.isBoolean = function(val) {
  return typeof val == 'boolean';
};
goog.isNumber = function(val) {
  return typeof val == 'number';
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == 'function';
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == 'object' && val != null || type == 'function';
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] ||
      (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if ('removeAttribute' in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = 'closure_uid_' + ((Math.random() * 1e9) >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == 'object' || type == 'array') {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == 'array' ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return  (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error();
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind &&
      Function.prototype.bind.toString().indexOf('native code') != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = (goog.TRUSTED_SITE && Date.now) || (function() {
  return +new Date();
});
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, 'JavaScript');
  } else if (goog.global.eval) {
    if (goog.evalWorksForGlobals_ == null) {
      goog.global.eval('var _et_ = 1;');
      if (typeof goog.global['_et_'] != 'undefined') {
        delete goog.global['_et_'];
        goog.evalWorksForGlobals_ = true;
      } else {
        goog.evalWorksForGlobals_ = false;
      }
    }
    if (goog.evalWorksForGlobals_) {
      goog.global.eval(script);
    } else {
      var doc = goog.global.document;
      var scriptElt = doc.createElement('script');
      scriptElt.type = 'text/javascript';
      scriptElt.defer = false;
      scriptElt.appendChild(doc.createTextNode(script));
      doc.body.appendChild(scriptElt);
      doc.body.removeChild(scriptElt);
    }
  } else {
    throw Error('goog.globalEval not available');
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split('-');
    var mapped = [];
    for (var i = 0; i < parts.length; i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join('-');
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == 'BY_WHOLE' ?
        getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + '-' + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {};
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor();
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = Array.prototype.slice.call(arguments, 2);
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || (goog.DEBUG && !caller)) {
    throw Error('arguments.caller not defined.  goog.base() cannot be used ' +
                'with strict mode code. See ' +
                'http://www.ecma-international.org/ecma-262/5.1/#sec-C');
  }
  if (caller.superClass_) {
    return caller.superClass_.constructor.apply(
        me, Array.prototype.slice.call(arguments, 1));
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for (var ctor = me.constructor;
       ctor; ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else if (foundCaller) {
      return ctor.prototype[opt_methodName].apply(me, args);
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error(
        'goog.base called from a method of one name ' +
        'to a method of a different name');
  }
};
goog.scope = function(fn) {
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global['COMPILED'] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error('cannot instantiate an interface (no constructor defined).');
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define('goog.defineClass.SEAL_CLASS_INSTANCES', goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (goog.defineClass.SEAL_CLASS_INSTANCES &&
      Object.seal instanceof Function) {
    if (superClass && superClass.prototype &&
        superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {
      return ctr;
    }
    var wrappedCtr = function() {
      var instance = ctr.apply(this, arguments) || this;
      if (this.constructor === wrappedCtr) {
        Object.seal(instance);
      }
      return instance;
    };
    return wrappedCtr;
  }
  return ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0; i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = 'goog_defineClass_legacy_unsealable';

// i18n.input.chrome.MessageKey
// i18n.input.chrome.TriggerType
goog.provide('i18n.input.chrome.MessageKey');
goog.provide('i18n.input.chrome.TriggerType');
i18n.input.chrome.MessageKey = {
  APPEND: 'append',
  APPEND_TOKENS: 'append_tokens',
  CLEAR: 'clear',
  COMMIT: 'commit',
  COMMIT_MARK: '@',
  COMMIT_POS: 'commit_pos',
  COMMIT_WORD: 'commit_word',
  CONTEXT: 'context',
  CORRECTION: 'correction',
  DECODE_GESTURE: 'decode_gesture',
  DELETE: 'delete',
  ENABLE_USER_DICT: 'enable_user_dict',
  ENTRIES: 'entries',
  FREQUENCY: 'frequency',
  FUZZY_PAIRS: 'fuzzy_pairs',
  KEYBOARD_LAYOUT: 'keyboard_layout',
  HIGHLIGHT: 'highlight',
  HIGHLIGHT_INDEX: 'highlight_index',
  IME: 'itc',
  MIN_SCORE: 'min_score',
  MULTI: 'multi',
  MULTI_APPEND: 'multi_append',
  PRECEDING_TEXT: 'preceding_text',
  PREDICT: 'predict',
  REVERT: 'revert',
  SELECT: 'select',
  SELECT_HIGHLIGHT: 'select_highlight',
  SOURCE: 'source',
  TARGET: 'target',
  UPDATE_ALL: 'update_all',
  USER_DICT: 'user_dict'
};
i18n.input.chrome.TriggerType = {
  SPACE: 0,
  RESET: 1,
  CANDIDATE: 2,
  SYMBOL_OR_NUMBER: 3,
  DOUBLE_SPACE_TO_PERIOD: 4,
  REVERT: 5,
  VOICE: 6,
  COMPOSITION_DISABLED: 7,
  GESTURE: 8,
  UNKNOWN: -1
};

// i18n.input.chrome.Constant
goog.provide('i18n.input.chrome.Constant');
i18n.input.chrome.Constant.LATIN_VALID_CHAR =
    "[a-z\\-\\\'\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u017F]";
i18n.input.chrome.Constant.NACL_LANGUAGES = [
  'da',
  'de',
  'en',
  'es',
  'fi',
  'fr',
  'it',
  'nl',
  'no',
  'pl',
  'pt',
  'pt-BR',
  'pt-PT',
  'sv',
  'tr'
];

// goog.debug.Error
goog.provide('goog.debug.Error');
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = new Error().stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = 'CustomError';

// goog.dom.NodeType
goog.provide('goog.dom.NodeType');
goog.dom.NodeType = {
  ELEMENT: 1,
  ATTRIBUTE: 2,
  TEXT: 3,
  CDATA_SECTION: 4,
  ENTITY_REFERENCE: 5,
  ENTITY: 6,
  PROCESSING_INSTRUCTION: 7,
  COMMENT: 8,
  DOCUMENT: 9,
  DOCUMENT_TYPE: 10,
  DOCUMENT_FRAGMENT: 11,
  NOTATION: 12
};

// goog.string
// goog.string.Unicode
goog.provide('goog.string');
goog.provide('goog.string.Unicode');
goog.define('goog.string.DETECT_DOUBLE_ESCAPING', false);
goog.define('goog.string.FORCE_NON_DOM_HTML_UNESCAPING', false);
goog.string.Unicode = {
  NBSP: '\xa0'
};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(
      prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(
      suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split('%s');
  var returnString = '';
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length &&
         splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join('%s'); // Join unused '%s'
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, ' ').replace(/^\s+|\s+$/g, '');
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == ' ';
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= ' ' && ch <= '~' ||
         ch >= '\u0080' && ch <= '\uFFFD';
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, ' ');
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, '\n');
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, ' ');
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, ' ');
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, ' ').replace(
      /^[\t\r\n ]+|[\t\r\n ]+$/g, '');
};
goog.string.trim = (goog.TRUSTED_SITE && String.prototype.trim) ?
    function(str) {
      return str.trim();
    } :
    function(str) {
      return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, '');
    };
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, '');
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, '');
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else if (test1 == test2) {
    return 0;
  } else {
    return 1;
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0; i < count; i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, ' '));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? '<br />' : '<br>');
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, '&amp;')
          .replace(goog.string.LT_RE_, '&lt;')
          .replace(goog.string.GT_RE_, '&gt;')
          .replace(goog.string.QUOT_RE_, '&quot;')
          .replace(goog.string.SINGLE_QUOTE_RE_, '&#39;')
          .replace(goog.string.NULL_RE_, '&#0;');
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, '&#101;');
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) return str;
    if (str.indexOf('&') != -1) {
      str = str.replace(goog.string.AMP_RE_, '&amp;');
    }
    if (str.indexOf('<') != -1) {
      str = str.replace(goog.string.LT_RE_, '&lt;');
    }
    if (str.indexOf('>') != -1) {
      str = str.replace(goog.string.GT_RE_, '&gt;');
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, '&quot;');
    }
    if (str.indexOf('\'') != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, '&#39;');
    }
    if (str.indexOf('\x00') != -1) {
      str = str.replace(goog.string.NULL_RE_, '&#0;');
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf('e') != -1) {
      str = str.replace(goog.string.E_RE_, '&#101;');
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = (goog.string.DETECT_DOUBLE_ESCAPING ?
    /[\x00&<>"'e]/ :
    /[\x00&<>"']/);
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, '&')) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING &&
        'document' in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, '&')) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {'&amp;': '&', '&lt;': '<', '&gt;': '>', '&quot;': '"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement('div');
  } else {
    div = goog.global.document.createElement('div');
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == '#') {
      var n = Number('0' + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + ' ';
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch (entity) {
      case 'amp':
        return '&';
      case 'lt':
        return '<';
      case 'gt':
        return '>';
      case 'quot':
        return '"';
      default:
        if (entity.charAt(0) == '#') {
          var n = Number('0' + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, ' &#160;'), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, '$1' + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0; i < length; i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + '...';
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars,
    opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + '...' + str.substring(endPoint);
  } else if (str.length > chars) {
    var half = Math.floor(chars / 2);
    var endPos = str.length - half;
    half += chars % 2;
    str = str.substring(0, half) + '...' + str.substring(endPos);
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {
  '\0': '\\0',
  '\b': '\\b',
  '\f': '\\f',
  '\n': '\\n',
  '\r': '\\r',
  '\t': '\\t',
  '\x0B': '\\x0B', // '\v' is not supported in JScript
  '"': '\\"',
  '\\': '\\\\'
};
goog.string.jsEscapeCache_ = {
  '\'': '\\\''
};
goog.string.quote = function(s) {
  s = String(s);
  if (s.quote) {
    return s.quote();
  } else {
    var sb = ['"'];
    for (var i = 0; i < s.length; i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] ||
          ((cc > 31 && cc < 127) ? ch : goog.string.escapeChar(ch));
    }
    sb.push('"');
    return sb.join('');
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0; i < str.length; i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join('');
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = '\\x';
      if (cc < 16 || cc > 256) {
        rv += '0';
      }
    } else {
      rv = '\\u';
      if (cc < 4096) { // \u1000
        rv += '0';
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) +
        s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), '');
  return s.replace(re, '');
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), 'g');
  return s.replace(re, '');
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, '\\$1').
      replace(/\x08/g, '\\x08');
};
goog.string.repeat = function(string, length) {
  return new Array(length + 1).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf('.');
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat('0', Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? '' : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, '');
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) +
         Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split('.');
  var v2Subs = goog.string.trim(String(version2)).split('.');
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0; order == 0 && subIdx < subCount; subIdx++) {
    var v1Sub = v1Subs[subIdx] || '';
    var v2Sub = v2Subs[subIdx] || '';
    var v1CompParser = new RegExp('(\\d*)(\\D*)', 'g');
    var v2CompParser = new RegExp('(\\d*)(\\D*)', 'g');
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ['', '', ''];
      var v2Comp = v2CompParser.exec(v2Sub) || ['', '', ''];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) ||
          goog.string.compareElements_(v1Comp[2].length == 0,
              v2Comp[2].length == 0) ||
          goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else if (left > right) {
    return 1;
  }
  return 0;
};
goog.string.HASHCODE_MAX_ = 0x100000000;
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0; i < str.length; ++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 0x80000000 | 0;
goog.string.createUniqueString = function() {
  return 'goog_' + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, '-$1').toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ?
      goog.string.regExpEscape(opt_delimiters) : '\\s';
  delimiters = delimiters ? '|[' + delimiters + ']+' : '';
  var regexp = new RegExp('(^' + delimiters + ')([a-z])', 'g');
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() +
      String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ?
        parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0; i < b.length + 1; i++) {
    v0[i] = i;
  }
  for (var i = 0; i < a.length; i++) {
    v1[0] = i + 1;
    for (var j = 0; j < b.length; j++) {
      var cost = a[i] != b[j];
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0; j < v0.length; j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};

// goog.asserts
// goog.asserts.AssertionError
goog.provide('goog.asserts');
goog.provide('goog.asserts.AssertionError');
goog.define('goog.asserts.ENABLE_ASSERTS', goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = 'AssertionError';
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) { throw e; };
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ =
    function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = 'Assertion failed';
  if (givenMessage) {
    message += ': ' + givenMessage;
    var args = givenArgs;
  } else if (defaultMessage) {
    message += ': ' + defaultMessage;
    args = defaultArgs;
  }
  var e = new goog.asserts.AssertionError('' + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_('', null, opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError(
        'Failure' + (opt_message ? ': ' + opt_message : ''),
        Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_('Expected number but got %s: %s.',
        [goog.typeOf(value), value], opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_('Expected string but got %s: %s.',
        [goog.typeOf(value), value], opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_('Expected function but got %s: %s.',
        [goog.typeOf(value), value], opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_('Expected object but got %s: %s.',
        [goog.typeOf(value), value],
        opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_('Expected array but got %s: %s.',
        [goog.typeOf(value), value], opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_('Expected boolean but got %s: %s.',
        [goog.typeOf(value), value], opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) ||
      value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_('Expected Element but got %s: %s.',
        [goog.typeOf(value), value], opt_message,
        Array.prototype.slice.call(arguments, 2));
  }
  return  (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_('Expected instanceof %s but got %s.',
        [goog.asserts.getType_(type), goog.asserts.getType_(value)],
        opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + ' should not be enumerable in Object.prototype.');
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || 'unknown type name';
  } else if (value instanceof Object) {
    return value.constructor.displayName || value.constructor.name ||
        Object.prototype.toString.call(value);
  } else {
    return value === null ? 'null' : typeof value;
  }
};

// goog.debug.EntryPointMonitor
// goog.debug.entryPointRegistry
goog.provide('goog.debug.EntryPointMonitor');
goog.provide('goog.debug.entryPointRegistry');
goog.debug.EntryPointMonitor = function() {};
goog.debug.EntryPointMonitor.prototype.wrap;
goog.debug.EntryPointMonitor.prototype.unwrap;
goog.debug.entryPointRegistry.refList_ = [];
goog.debug.entryPointRegistry.monitors_ = [];
goog.debug.entryPointRegistry.monitorsMayExist_ = false;
goog.debug.entryPointRegistry.register = function(callback) {
  goog.debug.entryPointRegistry.refList_[
      goog.debug.entryPointRegistry.refList_.length] = callback;
  if (goog.debug.entryPointRegistry.monitorsMayExist_) {
    var monitors = goog.debug.entryPointRegistry.monitors_;
    for (var i = 0; i < monitors.length; i++) {
      callback(goog.bind(monitors[i].wrap, monitors[i]));
    }
  }
};
goog.debug.entryPointRegistry.monitorAll = function(monitor) {
  goog.debug.entryPointRegistry.monitorsMayExist_ = true;
  var transformer = goog.bind(monitor.wrap, monitor);
  for (var i = 0; i < goog.debug.entryPointRegistry.refList_.length; i++) {
    goog.debug.entryPointRegistry.refList_[i](transformer);
  }
  goog.debug.entryPointRegistry.monitors_.push(monitor);
};
goog.debug.entryPointRegistry.unmonitorAllIfPossible = function(monitor) {
  var monitors = goog.debug.entryPointRegistry.monitors_;
  goog.asserts.assert(monitor == monitors[monitors.length - 1],
      'Only the most recent monitor can be unwrapped.');
  var transformer = goog.bind(monitor.unwrap, monitor);
  for (var i = 0; i < goog.debug.entryPointRegistry.refList_.length; i++) {
    goog.debug.entryPointRegistry.refList_[i](transformer);
  }
  monitors.length--;
};

// goog.array
// goog.array.ArrayLike
goog.provide('goog.array');
goog.provide('goog.array.ArrayLike');
goog.define('goog.NATIVE_ARRAY_PROTOTYPES', goog.TRUSTED_SITE);
goog.define('goog.array.ASSUME_NATIVE_FUNCTIONS', false);
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES &&
                     (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                      goog.array.ARRAY_PROTOTYPE_.indexOf) ?
    function(arr, obj, opt_fromIndex) {
      goog.asserts.assert(arr.length != null);
      return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);
    } :
    function(arr, obj, opt_fromIndex) {
      var fromIndex = opt_fromIndex == null ?
          0 : (opt_fromIndex < 0 ?
               Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex);
      if (goog.isString(arr)) {
        if (!goog.isString(obj) || obj.length != 1) {
          return -1;
        }
        return arr.indexOf(obj, fromIndex);
      }
      for (var i = fromIndex; i < arr.length; i++) {
        if (i in arr && arr[i] === obj)
          return i;
      }
      return -1;
    };
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES &&
                         (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                          goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ?
    function(arr, obj, opt_fromIndex) {
      goog.asserts.assert(arr.length != null);
      var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
      return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);
    } :
    function(arr, obj, opt_fromIndex) {
      var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
      if (fromIndex < 0) {
        fromIndex = Math.max(0, arr.length + fromIndex);
      }
      if (goog.isString(arr)) {
        if (!goog.isString(obj) || obj.length != 1) {
          return -1;
        }
        return arr.lastIndexOf(obj, fromIndex);
      }
      for (var i = fromIndex; i >= 0; i--) {
        if (i in arr && arr[i] === obj)
          return i;
      }
      return -1;
    };
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES &&
                     (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                      goog.array.ARRAY_PROTOTYPE_.forEach) ?
    function(arr, f, opt_obj) {
      goog.asserts.assert(arr.length != null);
      goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);
    } :
    function(arr, f, opt_obj) {
      var l = arr.length;  // must be fixed during loop... see docs
      var arr2 = goog.isString(arr) ? arr.split('') : arr;
      for (var i = 0; i < l; i++) {
        if (i in arr2) {
          f.call(opt_obj, arr2[i], i, arr);
        }
      }
    };
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;  // must be fixed during loop... see docs
  var arr2 = goog.isString(arr) ? arr.split('') : arr;
  for (var i = l - 1; i >= 0; --i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES &&
                    (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                     goog.array.ARRAY_PROTOTYPE_.filter) ?
    function(arr, f, opt_obj) {
      goog.asserts.assert(arr.length != null);
      return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);
    } :
    function(arr, f, opt_obj) {
      var l = arr.length;  // must be fixed during loop... see docs
      var res = [];
      var resLength = 0;
      var arr2 = goog.isString(arr) ? arr.split('') : arr;
      for (var i = 0; i < l; i++) {
        if (i in arr2) {
          var val = arr2[i];  // in case f mutates arr2
          if (f.call(opt_obj, val, i, arr)) {
            res[resLength++] = val;
          }
        }
      }
      return res;
    };
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES &&
                 (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                  goog.array.ARRAY_PROTOTYPE_.map) ?
    function(arr, f, opt_obj) {
      goog.asserts.assert(arr.length != null);
      return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);
    } :
    function(arr, f, opt_obj) {
      var l = arr.length;  // must be fixed during loop... see docs
      var res = new Array(l);
      var arr2 = goog.isString(arr) ? arr.split('') : arr;
      for (var i = 0; i < l; i++) {
        if (i in arr2) {
          res[i] = f.call(opt_obj, arr2[i], i, arr);
        }
      }
      return res;
    };
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES &&
                    (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                     goog.array.ARRAY_PROTOTYPE_.reduce) ?
    function(arr, f, val, opt_obj) {
      goog.asserts.assert(arr.length != null);
      if (opt_obj) {
        f = goog.bind(f, opt_obj);
      }
      return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);
    } :
    function(arr, f, val, opt_obj) {
      var rval = val;
      goog.array.forEach(arr, function(val, index) {
        rval = f.call(opt_obj, rval, val, index, arr);
      });
      return rval;
    };
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES &&
                         (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                          goog.array.ARRAY_PROTOTYPE_.reduceRight) ?
    function(arr, f, val, opt_obj) {
      goog.asserts.assert(arr.length != null);
      if (opt_obj) {
        f = goog.bind(f, opt_obj);
      }
      return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);
    } :
    function(arr, f, val, opt_obj) {
      var rval = val;
      goog.array.forEachRight(arr, function(val, index) {
        rval = f.call(opt_obj, rval, val, index, arr);
      });
      return rval;
    };
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES &&
                  (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                   goog.array.ARRAY_PROTOTYPE_.some) ?
    function(arr, f, opt_obj) {
      goog.asserts.assert(arr.length != null);
      return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);
    } :
    function(arr, f, opt_obj) {
      var l = arr.length;  // must be fixed during loop... see docs
      var arr2 = goog.isString(arr) ? arr.split('') : arr;
      for (var i = 0; i < l; i++) {
        if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
          return true;
        }
      }
      return false;
    };
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES &&
                   (goog.array.ASSUME_NATIVE_FUNCTIONS ||
                    goog.array.ARRAY_PROTOTYPE_.every) ?
    function(arr, f, opt_obj) {
      goog.asserts.assert(arr.length != null);
      return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);
    } :
    function(arr, f, opt_obj) {
      var l = arr.length;  // must be fixed during loop... see docs
      var arr2 = goog.isString(arr) ? arr.split('') : arr;
      for (var i = 0; i < l; i++) {
        if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
          return false;
        }
      }
      return true;
    };
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;  // must be fixed during loop... see docs
  var arr2 = goog.isString(arr) ? arr.split('') : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;  // must be fixed during loop... see docs
  var arr2 = goog.isString(arr) ? arr.split('') : arr;
  for (var i = l - 1; i >= 0; i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1; i >= 0; i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if ((rv = i >= 0)) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call(opt_obj, val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(
      goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.join = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(
      goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0; i < length; i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1; i < arguments.length; i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0; j < len2; j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(
      arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);
  } else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(item) ? 'o' + goog.getUid(item) :
        (typeof item).charAt(0) + item;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr,
      opt_compareFn || goog.array.defaultCompare, false ,
      target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true ,
      undefined , opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target,
    opt_selfObj) {
  var left = 0;  // inclusive
  var right = arr.length;  // exclusive
  var found;
  while (left < right) {
    var middle = (left + right) >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var i = 0; i < arr.length; i++) {
    arr[i] = {index: i, value: arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  };
  goog.array.sort(arr, stableCompareFn);
  for (var i = 0; i < arr.length; i++) {
    arr[i] = arr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr,
      function(obj) { return obj[key]; },
      opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1; i < arr.length; i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) ||
      arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0; i < l; i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0; i < l; i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return (index >= 0) ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0; i < array.length; i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start; i < end; i += step) {
      array.push(i);
    }
  } else {
    for (var i = start; i > end; i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0; i < n; i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0; c < element.length; c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0; r < recurseResult.length; r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));
    } else if (n < 0) {
      goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);
  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  for (var i = 0; true; i++) {
    var value = [];
    for (var j = 0; j < arguments.length; j++) {
      var arr = arguments[j];
      if (i >= arr.length) {
        return result;
      }
      value.push(arr[i]);
    }
    result.push(value);
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1; i > 0; i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};

// goog.labs.userAgent.util
goog.provide('goog.labs.userAgent.util');
goog.labs.userAgent.util.getNativeUserAgentString_ = function() {
  var navigator = goog.labs.userAgent.util.getNavigator_();
  if (navigator) {
    var userAgent = navigator.userAgent;
    if (userAgent) {
      return userAgent;
    }
  }
  return '';
};
goog.labs.userAgent.util.getNavigator_ = function() {
  return goog.global.navigator;
};
goog.labs.userAgent.util.userAgent_ =
    goog.labs.userAgent.util.getNativeUserAgentString_();
goog.labs.userAgent.util.setUserAgent = function(opt_userAgent) {
  goog.labs.userAgent.util.userAgent_ = opt_userAgent ||
      goog.labs.userAgent.util.getNativeUserAgentString_();
};
goog.labs.userAgent.util.getUserAgent = function() {
  return goog.labs.userAgent.util.userAgent_;
};
goog.labs.userAgent.util.matchUserAgent = function(str) {
  var userAgent = goog.labs.userAgent.util.getUserAgent();
  return goog.string.contains(userAgent, str);
};
goog.labs.userAgent.util.matchUserAgentIgnoreCase = function(str) {
  var userAgent = goog.labs.userAgent.util.getUserAgent();
  return goog.string.caseInsensitiveContains(userAgent, str);
};
goog.labs.userAgent.util.extractVersionTuples = function(userAgent) {
  var versionRegExp = new RegExp(
      '(\\w[\\w ]+)' +
      '/' +                // slash
      '([^\\s]+)' +        // version (i.e. '5.0b')
      '\\s*' +             // whitespace
      '(?:\\((.*?)\\))?',  // parenthetical info. parentheses not matched.
      'g');
  var data = [];
  var match;
  while (match = versionRegExp.exec(userAgent)) {
    data.push([
      match[1],  // key
      match[2],  // value
      match[3] || undefined  // info
    ]);
  }
  return data;
};

// goog.object
goog.provide('goog.object');
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1; i < keys.length; i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if ((rv = key in obj)) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : (obj[key] = value);
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == 'object' || type == 'array') {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == 'array' ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1; i < arguments.length; i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0; j < goog.object.PROTOTYPE_FIELDS_.length; j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error('Uneven number of arguments');
  }
  var rv = {};
  for (var i = 0; i < argLength; i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0; i < argLength; i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};

// goog.labs.userAgent.browser
goog.provide('goog.labs.userAgent.browser');
goog.labs.userAgent.browser.matchOpera_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Opera') ||
      goog.labs.userAgent.util.matchUserAgent('OPR');
};
goog.labs.userAgent.browser.matchIE_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Trident') ||
      goog.labs.userAgent.util.matchUserAgent('MSIE');
};
goog.labs.userAgent.browser.matchEdge_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Edge');
};
goog.labs.userAgent.browser.matchFirefox_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Firefox');
};
goog.labs.userAgent.browser.matchSafari_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Safari') &&
      !(goog.labs.userAgent.browser.matchChrome_() ||
        goog.labs.userAgent.browser.matchCoast_() ||
        goog.labs.userAgent.browser.matchOpera_() ||
        goog.labs.userAgent.browser.matchEdge_() ||
        goog.labs.userAgent.browser.isSilk() ||
        goog.labs.userAgent.util.matchUserAgent('Android'));
};
goog.labs.userAgent.browser.matchCoast_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Coast');
};
goog.labs.userAgent.browser.matchIosWebview_ = function() {
  return (goog.labs.userAgent.util.matchUserAgent('iPad') ||
          goog.labs.userAgent.util.matchUserAgent('iPhone')) &&
      !goog.labs.userAgent.browser.matchSafari_() &&
      !goog.labs.userAgent.browser.matchChrome_() &&
      !goog.labs.userAgent.browser.matchCoast_() &&
      goog.labs.userAgent.util.matchUserAgent('AppleWebKit');
};
goog.labs.userAgent.browser.matchChrome_ = function() {
  return (goog.labs.userAgent.util.matchUserAgent('Chrome') ||
      goog.labs.userAgent.util.matchUserAgent('CriOS')) &&
      !goog.labs.userAgent.browser.matchOpera_() &&
      !goog.labs.userAgent.browser.matchEdge_();
};
goog.labs.userAgent.browser.matchAndroidBrowser_ = function() {
  return goog.labs.userAgent.util.matchUserAgent('Android') &&
      !(goog.labs.userAgent.browser.isChrome() ||
        goog.labs.userAgent.browser.isFirefox() ||
        goog.labs.userAgent.browser.isOpera() ||
        goog.labs.userAgent.browser.isSilk());
};
goog.labs.userAgent.browser.isOpera = goog.labs.userAgent.browser.matchOpera_;
goog.labs.userAgent.browser.isIE = goog.labs.userAgent.browser.matchIE_;
goog.labs.userAgent.browser.isEdge = goog.labs.userAgent.browser.matchEdge_;
goog.labs.userAgent.browser.isFirefox =
    goog.labs.userAgent.browser.matchFirefox_;
goog.labs.userAgent.browser.isSafari =
    goog.labs.userAgent.browser.matchSafari_;
goog.labs.userAgent.browser.isCoast =
    goog.labs.userAgent.browser.matchCoast_;
goog.labs.userAgent.browser.isIosWebview =
    goog.labs.userAgent.browser.matchIosWebview_;
goog.labs.userAgent.browser.isChrome =
    goog.labs.userAgent.browser.matchChrome_;
goog.labs.userAgent.browser.isAndroidBrowser =
    goog.labs.userAgent.browser.matchAndroidBrowser_;
goog.labs.userAgent.browser.isSilk = function() {
  return goog.labs.userAgent.util.matchUserAgent('Silk');
};
goog.labs.userAgent.browser.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  if (goog.labs.userAgent.browser.isIE()) {
    return goog.labs.userAgent.browser.getIEVersion_(userAgentString);
  }
  var versionTuples = goog.labs.userAgent.util.extractVersionTuples(
      userAgentString);
  var versionMap = {};
  goog.array.forEach(versionTuples, function(tuple) {
    var key = tuple[0];
    var value = tuple[1];
    versionMap[key] = value;
  });
  var versionMapHasKey = goog.partial(goog.object.containsKey, versionMap);
  function lookUpValueWithKeys(keys) {
    var key = goog.array.find(keys, versionMapHasKey);
    return versionMap[key] || '';
  }
  if (goog.labs.userAgent.browser.isOpera()) {
    return lookUpValueWithKeys(['Version', 'Opera', 'OPR']);
  }
  if (goog.labs.userAgent.browser.isEdge()) {
    return lookUpValueWithKeys(['Edge']);
  }
  if (goog.labs.userAgent.browser.isChrome()) {
    return lookUpValueWithKeys(['Chrome', 'CriOS']);
  }
  var tuple = versionTuples[2];
  return tuple && tuple[1] || '';
};
goog.labs.userAgent.browser.isVersionOrHigher = function(version) {
  return goog.string.compareVersions(goog.labs.userAgent.browser.getVersion(),
                                     version) >= 0;
};
goog.labs.userAgent.browser.getIEVersion_ = function(userAgent) {
  var rv = /rv: *([\d\.]*)/.exec(userAgent);
  if (rv && rv[1]) {
    return rv[1];
  }
  var version = '';
  var msie = /MSIE +([\d\.]+)/.exec(userAgent);
  if (msie && msie[1]) {
    var tridentVersion = /Trident\/(\d.\d)/.exec(userAgent);
    if (msie[1] == '7.0') {
      if (tridentVersion && tridentVersion[1]) {
        switch (tridentVersion[1]) {
          case '4.0':
            version = '8.0';
            break;
          case '5.0':
            version = '9.0';
            break;
          case '6.0':
            version = '10.0';
            break;
          case '7.0':
            version = '11.0';
            break;
        }
      } else {
        version = '7.0';
      }
    } else {
      version = msie[1];
    }
  }
  return version;
};

// goog.labs.userAgent.engine
goog.provide('goog.labs.userAgent.engine');
goog.labs.userAgent.engine.isPresto = function() {
  return goog.labs.userAgent.util.matchUserAgent('Presto');
};
goog.labs.userAgent.engine.isTrident = function() {
  return goog.labs.userAgent.util.matchUserAgent('Trident') ||
      goog.labs.userAgent.util.matchUserAgent('MSIE');
};
goog.labs.userAgent.engine.isEdge = function() {
  return goog.labs.userAgent.util.matchUserAgent('Edge');
};
goog.labs.userAgent.engine.isWebKit = function() {
  return goog.labs.userAgent.util.matchUserAgentIgnoreCase('WebKit') &&
      !goog.labs.userAgent.engine.isEdge();
};
goog.labs.userAgent.engine.isGecko = function() {
  return goog.labs.userAgent.util.matchUserAgent('Gecko') &&
      !goog.labs.userAgent.engine.isWebKit() &&
      !goog.labs.userAgent.engine.isTrident() &&
      !goog.labs.userAgent.engine.isEdge();
};
goog.labs.userAgent.engine.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  if (userAgentString) {
    var tuples = goog.labs.userAgent.util.extractVersionTuples(
        userAgentString);
    var engineTuple = goog.labs.userAgent.engine.getEngineTuple_(tuples);
    if (engineTuple) {
      if (engineTuple[0] == 'Gecko') {
        return goog.labs.userAgent.engine.getVersionForKey_(
            tuples, 'Firefox');
      }
      return engineTuple[1];
    }
    var browserTuple = tuples[0];
    var info;
    if (browserTuple && (info = browserTuple[2])) {
      var match = /Trident\/([^\s;]+)/.exec(info);
      if (match) {
        return match[1];
      }
    }
  }
  return '';
};
goog.labs.userAgent.engine.getEngineTuple_ = function(tuples) {
  if (!goog.labs.userAgent.engine.isEdge()) {
    return tuples[1];
  }
  for (var i = 0; i < tuples.length; i++) {
    var tuple = tuples[i];
    if (tuple[0] == 'Edge') {
      return tuple;
    }
  }
};
goog.labs.userAgent.engine.isVersionOrHigher = function(version) {
  return goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(),
                                     version) >= 0;
};
goog.labs.userAgent.engine.getVersionForKey_ = function(tuples, key) {
  var pair = goog.array.find(tuples, function(pair) {
    return key == pair[0];
  });
  return pair && pair[1] || '';
};

// goog.labs.userAgent.platform
goog.provide('goog.labs.userAgent.platform');
goog.labs.userAgent.platform.isAndroid = function() {
  return goog.labs.userAgent.util.matchUserAgent('Android');
};
goog.labs.userAgent.platform.isIpod = function() {
  return goog.labs.userAgent.util.matchUserAgent('iPod');
};
goog.labs.userAgent.platform.isIphone = function() {
  return goog.labs.userAgent.util.matchUserAgent('iPhone') &&
      !goog.labs.userAgent.util.matchUserAgent('iPod') &&
      !goog.labs.userAgent.util.matchUserAgent('iPad');
};
goog.labs.userAgent.platform.isIpad = function() {
  return goog.labs.userAgent.util.matchUserAgent('iPad');
};
goog.labs.userAgent.platform.isIos = function() {
  return goog.labs.userAgent.platform.isIphone() ||
      goog.labs.userAgent.platform.isIpad() ||
      goog.labs.userAgent.platform.isIpod();
};
goog.labs.userAgent.platform.isMacintosh = function() {
  return goog.labs.userAgent.util.matchUserAgent('Macintosh');
};
goog.labs.userAgent.platform.isLinux = function() {
  return goog.labs.userAgent.util.matchUserAgent('Linux');
};
goog.labs.userAgent.platform.isWindows = function() {
  return goog.labs.userAgent.util.matchUserAgent('Windows');
};
goog.labs.userAgent.platform.isChromeOS = function() {
  return goog.labs.userAgent.util.matchUserAgent('CrOS');
};
goog.labs.userAgent.platform.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  var version = '', re;
  if (goog.labs.userAgent.platform.isWindows()) {
    re = /Windows (?:NT|Phone) ([0-9.]+)/;
    var match = re.exec(userAgentString);
    if (match) {
      version = match[1];
    } else {
      version = '0.0';
    }
  } else if (goog.labs.userAgent.platform.isIos()) {
    re = /(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/;
    var match = re.exec(userAgentString);
    version = match && match[1].replace(/_/g, '.');
  } else if (goog.labs.userAgent.platform.isMacintosh()) {
    re = /Mac OS X ([0-9_.]+)/;
    var match = re.exec(userAgentString);
    version = match ? match[1].replace(/_/g, '.') : '10';
  } else if (goog.labs.userAgent.platform.isAndroid()) {
    re = /Android\s+([^\);]+)(\)|;)/;
    var match = re.exec(userAgentString);
    version = match && match[1];
  } else if (goog.labs.userAgent.platform.isChromeOS()) {
    re = /(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/;
    var match = re.exec(userAgentString);
    version = match && match[1];
  }
  return version || '';
};
goog.labs.userAgent.platform.isVersionOrHigher = function(version) {
  return goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(),
                                     version) >= 0;
};

// goog.userAgent
goog.provide('goog.userAgent');
goog.define('goog.userAgent.ASSUME_IE', false);
goog.define('goog.userAgent.ASSUME_EDGE', false);
goog.define('goog.userAgent.ASSUME_GECKO', false);
goog.define('goog.userAgent.ASSUME_WEBKIT', false);
goog.define('goog.userAgent.ASSUME_MOBILE_WEBKIT', false);
goog.define('goog.userAgent.ASSUME_OPERA', false);
goog.define('goog.userAgent.ASSUME_ANY_VERSION', false);
goog.userAgent.BROWSER_KNOWN_ =
    goog.userAgent.ASSUME_IE ||
    goog.userAgent.ASSUME_EDGE ||
    goog.userAgent.ASSUME_GECKO ||
    goog.userAgent.ASSUME_MOBILE_WEBKIT ||
    goog.userAgent.ASSUME_WEBKIT ||
    goog.userAgent.ASSUME_OPERA;
goog.userAgent.getUserAgentString = function() {
  return goog.labs.userAgent.util.getUserAgent();
};
goog.userAgent.getNavigator = function() {
  return goog.global['navigator'] || null;
};
goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ?
    goog.userAgent.ASSUME_OPERA :
    goog.labs.userAgent.browser.isOpera();
goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ?
    goog.userAgent.ASSUME_IE :
    goog.labs.userAgent.browser.isIE();
goog.userAgent.EDGE = goog.userAgent.BROWSER_KNOWN_ ?
    goog.userAgent.ASSUME_EDGE :
    goog.labs.userAgent.engine.isEdge();
goog.userAgent.EDGE_OR_IE = goog.userAgent.EDGE || goog.userAgent.IE;
goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ?
    goog.userAgent.ASSUME_GECKO :
    goog.labs.userAgent.engine.isGecko();
goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ?
    goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT :
    goog.labs.userAgent.engine.isWebKit();
goog.userAgent.isMobile_ = function() {
  return goog.userAgent.WEBKIT &&
         goog.labs.userAgent.util.matchUserAgent('Mobile');
};
goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT ||
                        goog.userAgent.isMobile_();
goog.userAgent.SAFARI = goog.userAgent.WEBKIT;
goog.userAgent.determinePlatform_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return navigator && navigator.platform || '';
};
goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_();
goog.define('goog.userAgent.ASSUME_MAC', false);
goog.define('goog.userAgent.ASSUME_WINDOWS', false);
goog.define('goog.userAgent.ASSUME_LINUX', false);
goog.define('goog.userAgent.ASSUME_X11', false);
goog.define('goog.userAgent.ASSUME_ANDROID', false);
goog.define('goog.userAgent.ASSUME_IPHONE', false);
goog.define('goog.userAgent.ASSUME_IPAD', false);
goog.userAgent.PLATFORM_KNOWN_ =
    goog.userAgent.ASSUME_MAC ||
    goog.userAgent.ASSUME_WINDOWS ||
    goog.userAgent.ASSUME_LINUX ||
    goog.userAgent.ASSUME_X11 ||
    goog.userAgent.ASSUME_ANDROID ||
    goog.userAgent.ASSUME_IPHONE ||
    goog.userAgent.ASSUME_IPAD;
goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_MAC : goog.labs.userAgent.platform.isMacintosh();
goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_WINDOWS :
    goog.labs.userAgent.platform.isWindows();
goog.userAgent.isLegacyLinux_ = function() {
  return goog.labs.userAgent.platform.isLinux() ||
      goog.labs.userAgent.platform.isChromeOS();
};
goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_LINUX :
    goog.userAgent.isLegacyLinux_();
goog.userAgent.isX11_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return !!navigator &&
      goog.string.contains(navigator['appVersion'] || '', 'X11');
};
goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_X11 :
    goog.userAgent.isX11_();
goog.userAgent.ANDROID = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_ANDROID :
    goog.labs.userAgent.platform.isAndroid();
goog.userAgent.IPHONE = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_IPHONE :
    goog.labs.userAgent.platform.isIphone();
goog.userAgent.IPAD = goog.userAgent.PLATFORM_KNOWN_ ?
    goog.userAgent.ASSUME_IPAD :
    goog.labs.userAgent.platform.isIpad();
goog.userAgent.determineVersion_ = function() {
  if (goog.userAgent.OPERA && goog.global['opera']) {
    var operaVersion = goog.global['opera'].version;
    return goog.isFunction(operaVersion) ? operaVersion() : operaVersion;
  }
  var version = '';
  var arr = goog.userAgent.getVersionRegexResult_();
  if (arr) {
    version = arr ? arr[1] : '';
  }
  if (goog.userAgent.IE) {
    var docMode = goog.userAgent.getDocumentMode_();
    if (docMode > parseFloat(version)) {
      return String(docMode);
    }
  }
  return version;
};
goog.userAgent.getVersionRegexResult_ = function() {
  var userAgent = goog.userAgent.getUserAgentString();
  if (goog.userAgent.GECKO) {
    return /rv\:([^\);]+)(\)|;)/.exec(userAgent);
  }
  if (goog.userAgent.EDGE) {
    return /Edge\/([\d\.]+)/.exec(userAgent);
  }
  if (goog.userAgent.IE) {
    return /\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(userAgent);
  }
  if (goog.userAgent.WEBKIT) {
    return /WebKit\/(\S+)/.exec(userAgent);
  }
};
goog.userAgent.getDocumentMode_ = function() {
  var doc = goog.global['document'];
  return doc ? doc['documentMode'] : undefined;
};
goog.userAgent.VERSION = goog.userAgent.determineVersion_();
goog.userAgent.compare = function(v1, v2) {
  return goog.string.compareVersions(v1, v2);
};
goog.userAgent.isVersionOrHigherCache_ = {};
goog.userAgent.isVersionOrHigher = function(version) {
  return goog.userAgent.ASSUME_ANY_VERSION ||
      goog.userAgent.isVersionOrHigherCache_[version] ||
      (goog.userAgent.isVersionOrHigherCache_[version] =
          goog.string.compareVersions(goog.userAgent.VERSION, version) >= 0);
};
goog.userAgent.isVersion = goog.userAgent.isVersionOrHigher;
goog.userAgent.isDocumentModeOrHigher = function(documentMode) {
  return goog.userAgent.DOCUMENT_MODE >= documentMode;
};
goog.userAgent.isDocumentMode = goog.userAgent.isDocumentModeOrHigher;
goog.userAgent.DOCUMENT_MODE = (function() {
  var doc = goog.global['document'];
  var mode = goog.userAgent.getDocumentMode_();
  if (!doc || !goog.userAgent.IE) {
    return undefined;
  }
  return mode || (doc['compatMode'] == 'CSS1Compat' ?
      parseInt(goog.userAgent.VERSION, 10) : 5);
})();

// goog.events.BrowserFeature
goog.provide('goog.events.BrowserFeature');
goog.events.BrowserFeature = {
  HAS_W3C_BUTTON: !goog.userAgent.IE ||
      goog.userAgent.isDocumentModeOrHigher(9),
  HAS_W3C_EVENT_SUPPORT: !goog.userAgent.IE ||
      goog.userAgent.isDocumentModeOrHigher(9),
  SET_KEY_CODE_TO_PREVENT_DEFAULT: goog.userAgent.IE &&
      !goog.userAgent.isVersionOrHigher('9'),
  HAS_NAVIGATOR_ONLINE_PROPERTY: !goog.userAgent.WEBKIT ||
      goog.userAgent.isVersionOrHigher('528'),
  HAS_HTML5_NETWORK_EVENT_SUPPORT:
      goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher('1.9b') ||
      goog.userAgent.IE && goog.userAgent.isVersionOrHigher('8') ||
      goog.userAgent.OPERA && goog.userAgent.isVersionOrHigher('9.5') ||
      goog.userAgent.WEBKIT && goog.userAgent.isVersionOrHigher('528'),
  HTML5_NETWORK_EVENTS_FIRE_ON_BODY:
      goog.userAgent.GECKO && !goog.userAgent.isVersionOrHigher('8') ||
      goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('9'),
  TOUCH_ENABLED:
      ('ontouchstart' in goog.global ||
          !!(goog.global['document'] &&
             document.documentElement &&
             'ontouchstart' in document.documentElement) ||
          !!(goog.global['navigator'] &&
              goog.global['navigator']['msMaxTouchPoints']))
};

// goog.disposable.IDisposable
goog.provide('goog.disposable.IDisposable');
goog.disposable.IDisposable = function() {};
goog.disposable.IDisposable.prototype.dispose = goog.abstractMethod;
goog.disposable.IDisposable.prototype.isDisposed = goog.abstractMethod;

// goog.Disposable
// goog.dispose
// goog.disposeAll
goog.provide('goog.Disposable');
goog.provide('goog.dispose');
goog.provide('goog.disposeAll');
goog.Disposable = function() {
  if (goog.Disposable.MONITORING_MODE != goog.Disposable.MonitoringMode.OFF) {
    if (goog.Disposable.INCLUDE_STACK_ON_CREATION) {
      this.creationStack = new Error().stack;
    }
    goog.Disposable.instances_[goog.getUid(this)] = this;
  }
  this.disposed_ = this.disposed_;
  this.onDisposeCallbacks_ = this.onDisposeCallbacks_;
};
goog.Disposable.MonitoringMode = {
  OFF: 0,
  PERMANENT: 1,
  INTERACTIVE: 2
};
goog.define('goog.Disposable.MONITORING_MODE', 0);
goog.define('goog.Disposable.INCLUDE_STACK_ON_CREATION', true);
goog.Disposable.instances_ = {};
goog.Disposable.getUndisposedObjects = function() {
  var ret = [];
  for (var id in goog.Disposable.instances_) {
    if (goog.Disposable.instances_.hasOwnProperty(id)) {
      ret.push(goog.Disposable.instances_[Number(id)]);
    }
  }
  return ret;
};
goog.Disposable.clearUndisposedObjects = function() {
  goog.Disposable.instances_ = {};
};
goog.Disposable.prototype.disposed_ = false;
goog.Disposable.prototype.onDisposeCallbacks_;
goog.Disposable.prototype.creationStack;
goog.Disposable.prototype.isDisposed = function() {
  return this.disposed_;
};
goog.Disposable.prototype.getDisposed = goog.Disposable.prototype.isDisposed;
goog.Disposable.prototype.dispose = function() {
  if (!this.disposed_) {
    this.disposed_ = true;
    this.disposeInternal();
    if (goog.Disposable.MONITORING_MODE != goog.Disposable.MonitoringMode.OFF) {
      var uid = goog.getUid(this);
      if (goog.Disposable.MONITORING_MODE ==
          goog.Disposable.MonitoringMode.PERMANENT &&
          !goog.Disposable.instances_.hasOwnProperty(uid)) {
        throw Error(this + ' did not call the goog.Disposable base ' +
            'constructor or was disposed of after a clearUndisposedObjects ' +
            'call');
      }
      delete goog.Disposable.instances_[uid];
    }
  }
};
goog.Disposable.prototype.registerDisposable = function(disposable) {
  this.addOnDisposeCallback(goog.partial(goog.dispose, disposable));
};
goog.Disposable.prototype.addOnDisposeCallback = function(callback, opt_scope) {
  if (this.disposed_) {
    callback.call(opt_scope);
    return;
  }
  if (!this.onDisposeCallbacks_) {
    this.onDisposeCallbacks_ = [];
  }
  this.onDisposeCallbacks_.push(
      goog.isDef(opt_scope) ? goog.bind(callback, opt_scope) : callback);
};
goog.Disposable.prototype.disposeInternal = function() {
  if (this.onDisposeCallbacks_) {
    while (this.onDisposeCallbacks_.length) {
      this.onDisposeCallbacks_.shift()();
    }
  }
};
goog.Disposable.isDisposed = function(obj) {
  if (obj && typeof obj.isDisposed == 'function') {
    return obj.isDisposed();
  }
  return false;
};
goog.dispose = function(obj) {
  if (obj && typeof obj.dispose == 'function') {
    obj.dispose();
  }
};
goog.disposeAll = function(var_args) {
  for (var i = 0, len = arguments.length; i < len; ++i) {
    var disposable = arguments[i];
    if (goog.isArrayLike(disposable)) {
      goog.disposeAll.apply(null, disposable);
    } else {
      goog.dispose(disposable);
    }
  }
};

// goog.events.EventId
goog.provide('goog.events.EventId');
goog.events.EventId = function(eventId) {
   this.id = eventId;
};
goog.events.EventId.prototype.toString = function() {
  return this.id;
};

// goog.events.Event
// goog.events.EventLike
goog.provide('goog.events.Event');
goog.provide('goog.events.EventLike');
goog.events.EventLike;
goog.events.Event = function(type, opt_target) {
  this.type = type instanceof goog.events.EventId ? String(type) : type;
  this.target = opt_target;
  this.currentTarget = this.target;
  this.propagationStopped_ = false;
  this.defaultPrevented = false;
  this.returnValue_ = true;
};
goog.events.Event.prototype.stopPropagation = function() {
  this.propagationStopped_ = true;
};
goog.events.Event.prototype.preventDefault = function() {
  this.defaultPrevented = true;
  this.returnValue_ = false;
};
goog.events.Event.stopPropagation = function(e) {
  e.stopPropagation();
};
goog.events.Event.preventDefault = function(e) {
  e.preventDefault();
};

// goog.events.EventType
goog.provide('goog.events.EventType');
goog.events.getVendorPrefixedName_ = function(eventName) {
  return goog.userAgent.WEBKIT ? 'webkit' + eventName :
      (goog.userAgent.OPERA ? 'o' + eventName.toLowerCase() :
          eventName.toLowerCase());
};
goog.events.EventType = {
  CLICK: 'click',
  RIGHTCLICK: 'rightclick',
  DBLCLICK: 'dblclick',
  MOUSEDOWN: 'mousedown',
  MOUSEUP: 'mouseup',
  MOUSEOVER: 'mouseover',
  MOUSEOUT: 'mouseout',
  MOUSEMOVE: 'mousemove',
  MOUSEENTER: 'mouseenter',
  MOUSELEAVE: 'mouseleave',
  SELECTSTART: 'selectstart', // IE, Safari, Chrome
  WHEEL: 'wheel',
  KEYPRESS: 'keypress',
  KEYDOWN: 'keydown',
  KEYUP: 'keyup',
  BLUR: 'blur',
  FOCUS: 'focus',
  DEACTIVATE: 'deactivate', // IE only
  FOCUSIN: goog.userAgent.IE ? 'focusin' : 'DOMFocusIn',
  FOCUSOUT: goog.userAgent.IE ? 'focusout' : 'DOMFocusOut',
  CHANGE: 'change',
  RESET: 'reset',
  SELECT: 'select',
  SUBMIT: 'submit',
  INPUT: 'input',
  PROPERTYCHANGE: 'propertychange', // IE only
  DRAGSTART: 'dragstart',
  DRAG: 'drag',
  DRAGENTER: 'dragenter',
  DRAGOVER: 'dragover',
  DRAGLEAVE: 'dragleave',
  DROP: 'drop',
  DRAGEND: 'dragend',
  TOUCHSTART: 'touchstart',
  TOUCHMOVE: 'touchmove',
  TOUCHEND: 'touchend',
  TOUCHCANCEL: 'touchcancel',
  BEFOREUNLOAD: 'beforeunload',
  CONSOLEMESSAGE: 'consolemessage',
  CONTEXTMENU: 'contextmenu',
  DOMCONTENTLOADED: 'DOMContentLoaded',
  ERROR: 'error',
  HELP: 'help',
  LOAD: 'load',
  LOSECAPTURE: 'losecapture',
  ORIENTATIONCHANGE: 'orientationchange',
  READYSTATECHANGE: 'readystatechange',
  RESIZE: 'resize',
  SCROLL: 'scroll',
  UNLOAD: 'unload',
  HASHCHANGE: 'hashchange',
  PAGEHIDE: 'pagehide',
  PAGESHOW: 'pageshow',
  POPSTATE: 'popstate',
  COPY: 'copy',
  PASTE: 'paste',
  CUT: 'cut',
  BEFORECOPY: 'beforecopy',
  BEFORECUT: 'beforecut',
  BEFOREPASTE: 'beforepaste',
  ONLINE: 'online',
  OFFLINE: 'offline',
  MESSAGE: 'message',
  CONNECT: 'connect',
  ANIMATIONSTART: goog.events.getVendorPrefixedName_('AnimationStart'),
  ANIMATIONEND: goog.events.getVendorPrefixedName_('AnimationEnd'),
  ANIMATIONITERATION: goog.events.getVendorPrefixedName_('AnimationIteration'),
  TRANSITIONEND: goog.events.getVendorPrefixedName_('TransitionEnd'),
  POINTERDOWN: 'pointerdown',
  POINTERUP: 'pointerup',
  POINTERCANCEL: 'pointercancel',
  POINTERMOVE: 'pointermove',
  POINTEROVER: 'pointerover',
  POINTEROUT: 'pointerout',
  POINTERENTER: 'pointerenter',
  POINTERLEAVE: 'pointerleave',
  GOTPOINTERCAPTURE: 'gotpointercapture',
  LOSTPOINTERCAPTURE: 'lostpointercapture',
  MSGESTURECHANGE: 'MSGestureChange',
  MSGESTUREEND: 'MSGestureEnd',
  MSGESTUREHOLD: 'MSGestureHold',
  MSGESTURESTART: 'MSGestureStart',
  MSGESTURETAP: 'MSGestureTap',
  MSGOTPOINTERCAPTURE: 'MSGotPointerCapture',
  MSINERTIASTART: 'MSInertiaStart',
  MSLOSTPOINTERCAPTURE: 'MSLostPointerCapture',
  MSPOINTERCANCEL: 'MSPointerCancel',
  MSPOINTERDOWN: 'MSPointerDown',
  MSPOINTERENTER: 'MSPointerEnter',
  MSPOINTERHOVER: 'MSPointerHover',
  MSPOINTERLEAVE: 'MSPointerLeave',
  MSPOINTERMOVE: 'MSPointerMove',
  MSPOINTEROUT: 'MSPointerOut',
  MSPOINTEROVER: 'MSPointerOver',
  MSPOINTERUP: 'MSPointerUp',
  TEXT: 'text',
  TEXTINPUT: 'textInput',
  COMPOSITIONSTART: 'compositionstart',
  COMPOSITIONUPDATE: 'compositionupdate',
  COMPOSITIONEND: 'compositionend',
  EXIT: 'exit',
  LOADABORT: 'loadabort',
  LOADCOMMIT: 'loadcommit',
  LOADREDIRECT: 'loadredirect',
  LOADSTART: 'loadstart',
  LOADSTOP: 'loadstop',
  RESPONSIVE: 'responsive',
  SIZECHANGED: 'sizechanged',
  UNRESPONSIVE: 'unresponsive',
  VISIBILITYCHANGE: 'visibilitychange',
  STORAGE: 'storage',
  DOMSUBTREEMODIFIED: 'DOMSubtreeModified',
  DOMNODEINSERTED: 'DOMNodeInserted',
  DOMNODEREMOVED: 'DOMNodeRemoved',
  DOMNODEREMOVEDFROMDOCUMENT: 'DOMNodeRemovedFromDocument',
  DOMNODEINSERTEDINTODOCUMENT: 'DOMNodeInsertedIntoDocument',
  DOMATTRMODIFIED: 'DOMAttrModified',
  DOMCHARACTERDATAMODIFIED: 'DOMCharacterDataModified',
  BEFOREPRINT: 'beforeprint',
  AFTERPRINT: 'afterprint'
};

// goog.reflect
goog.provide('goog.reflect');
goog.reflect.object = function(type, object) {
  return object;
};
goog.reflect.sinkValue = function(x) {
  goog.reflect.sinkValue[' '](x);
  return x;
};
goog.reflect.sinkValue[' '] = goog.nullFunction;
goog.reflect.canAccessProperty = function(obj, prop) {
  try {
    goog.reflect.sinkValue(obj[prop]);
    return true;
  } catch (e) {}
  return false;
};

// goog.events.BrowserEvent
// goog.events.BrowserEvent.MouseButton
goog.provide('goog.events.BrowserEvent');
goog.provide('goog.events.BrowserEvent.MouseButton');
goog.events.BrowserEvent = function(opt_e, opt_currentTarget) {
  goog.events.BrowserEvent.base(this, 'constructor', opt_e ? opt_e.type : '');
  this.target = null;
  this.currentTarget = null;
  this.relatedTarget = null;
  this.offsetX = 0;
  this.offsetY = 0;
  this.clientX = 0;
  this.clientY = 0;
  this.screenX = 0;
  this.screenY = 0;
  this.button = 0;
  this.keyCode = 0;
  this.charCode = 0;
  this.ctrlKey = false;
  this.altKey = false;
  this.shiftKey = false;
  this.metaKey = false;
  this.state = null;
  this.platformModifierKey = false;
  this.event_ = null;
  if (opt_e) {
    this.init(opt_e, opt_currentTarget);
  }
};
goog.inherits(goog.events.BrowserEvent, goog.events.Event);
goog.events.BrowserEvent.MouseButton = {
  LEFT: 0,
  MIDDLE: 1,
  RIGHT: 2
};
goog.events.BrowserEvent.IEButtonMap = [
  1, // LEFT
  4, // MIDDLE
  2  // RIGHT
];
goog.events.BrowserEvent.prototype.init = function(e, opt_currentTarget) {
  var type = this.type = e.type;
  this.target =  (e.target) || e.srcElement;
  this.currentTarget =  (opt_currentTarget);
  var relatedTarget =  (e.relatedTarget);
  if (relatedTarget) {
    if (goog.userAgent.GECKO) {
      if (!goog.reflect.canAccessProperty(relatedTarget, 'nodeName')) {
        relatedTarget = null;
      }
    }
  } else if (type == goog.events.EventType.MOUSEOVER) {
    relatedTarget = e.fromElement;
  } else if (type == goog.events.EventType.MOUSEOUT) {
    relatedTarget = e.toElement;
  }
  this.relatedTarget = relatedTarget;
  this.offsetX = (goog.userAgent.WEBKIT || e.offsetX !== undefined) ?
      e.offsetX : e.layerX;
  this.offsetY = (goog.userAgent.WEBKIT || e.offsetY !== undefined) ?
      e.offsetY : e.layerY;
  this.clientX = e.clientX !== undefined ? e.clientX : e.pageX;
  this.clientY = e.clientY !== undefined ? e.clientY : e.pageY;
  this.screenX = e.screenX || 0;
  this.screenY = e.screenY || 0;
  this.button = e.button;
  this.keyCode = e.keyCode || 0;
  this.charCode = e.charCode || (type == 'keypress' ? e.keyCode : 0);
  this.ctrlKey = e.ctrlKey;
  this.altKey = e.altKey;
  this.shiftKey = e.shiftKey;
  this.metaKey = e.metaKey;
  this.platformModifierKey = goog.userAgent.MAC ? e.metaKey : e.ctrlKey;
  this.state = e.state;
  this.event_ = e;
  if (e.defaultPrevented) {
    this.preventDefault();
  }
};
goog.events.BrowserEvent.prototype.isButton = function(button) {
  if (!goog.events.BrowserFeature.HAS_W3C_BUTTON) {
    if (this.type == 'click') {
      return button == goog.events.BrowserEvent.MouseButton.LEFT;
    } else {
      return !!(this.event_.button &
          goog.events.BrowserEvent.IEButtonMap[button]);
    }
  } else {
    return this.event_.button == button;
  }
};
goog.events.BrowserEvent.prototype.isMouseActionButton = function() {
  return this.isButton(goog.events.BrowserEvent.MouseButton.LEFT) &&
      !(goog.userAgent.WEBKIT && goog.userAgent.MAC && this.ctrlKey);
};
goog.events.BrowserEvent.prototype.stopPropagation = function() {
  goog.events.BrowserEvent.superClass_.stopPropagation.call(this);
  if (this.event_.stopPropagation) {
    this.event_.stopPropagation();
  } else {
    this.event_.cancelBubble = true;
  }
};
goog.events.BrowserEvent.prototype.preventDefault = function() {
  goog.events.BrowserEvent.superClass_.preventDefault.call(this);
  var be = this.event_;
  if (!be.preventDefault) {
    be.returnValue = false;
    if (goog.events.BrowserFeature.SET_KEY_CODE_TO_PREVENT_DEFAULT) {
      try {
        var VK_F1 = 112;
        var VK_F12 = 123;
        if (be.ctrlKey || be.keyCode >= VK_F1 && be.keyCode <= VK_F12) {
          be.keyCode = -1;
        }
      } catch (ex) {
      }
    }
  } else {
    be.preventDefault();
  }
};
goog.events.BrowserEvent.prototype.getBrowserEvent = function() {
  return this.event_;
};

// goog.events.Listenable
// goog.events.ListenableKey
goog.provide('goog.events.Listenable');
goog.provide('goog.events.ListenableKey');
goog.events.Listenable = function() {};
goog.events.Listenable.IMPLEMENTED_BY_PROP =
    'closure_listenable_' + ((Math.random() * 1e6) | 0);
goog.events.Listenable.addImplementation = function(cls) {
  cls.prototype[goog.events.Listenable.IMPLEMENTED_BY_PROP] = true;
};
goog.events.Listenable.isImplementedBy = function(obj) {
  return !!(obj && obj[goog.events.Listenable.IMPLEMENTED_BY_PROP]);
};
goog.events.Listenable.prototype.listen;
goog.events.Listenable.prototype.listenOnce;
goog.events.Listenable.prototype.unlisten;
goog.events.Listenable.prototype.unlistenByKey;
goog.events.Listenable.prototype.dispatchEvent;
goog.events.Listenable.prototype.removeAllListeners;
goog.events.Listenable.prototype.getParentEventTarget;
goog.events.Listenable.prototype.fireListeners;
goog.events.Listenable.prototype.getListeners;
goog.events.Listenable.prototype.getListener;
goog.events.Listenable.prototype.hasListener;
goog.events.ListenableKey = function() {};
goog.events.ListenableKey.counter_ = 0;
goog.events.ListenableKey.reserveKey = function() {
  return ++goog.events.ListenableKey.counter_;
};
goog.events.ListenableKey.prototype.src;
goog.events.ListenableKey.prototype.type;
goog.events.ListenableKey.prototype.listener;
goog.events.ListenableKey.prototype.capture;
goog.events.ListenableKey.prototype.handler;
goog.events.ListenableKey.prototype.key;

// goog.events.Listener
goog.provide('goog.events.Listener');
goog.events.Listener = function(
    listener, proxy, src, type, capture, opt_handler) {
  if (goog.events.Listener.ENABLE_MONITORING) {
    this.creationStack = new Error().stack;
  }
  this.listener = listener;
  this.proxy = proxy;
  this.src = src;
  this.type = type;
  this.capture = !!capture;
  this.handler = opt_handler;
  this.key = goog.events.ListenableKey.reserveKey();
  this.callOnce = false;
  this.removed = false;
};
goog.define('goog.events.Listener.ENABLE_MONITORING', false);
goog.events.Listener.prototype.creationStack;
goog.events.Listener.prototype.markAsRemoved = function() {
  this.removed = true;
  this.listener = null;
  this.proxy = null;
  this.src = null;
  this.handler = null;
};

// goog.events.ListenerMap
goog.provide('goog.events.ListenerMap');
goog.events.ListenerMap = function(src) {
  this.src = src;
  this.listeners = {};
  this.typeCount_ = 0;
};
goog.events.ListenerMap.prototype.getTypeCount = function() {
  return this.typeCount_;
};
goog.events.ListenerMap.prototype.getListenerCount = function() {
  var count = 0;
  for (var type in this.listeners) {
    count += this.listeners[type].length;
  }
  return count;
};
goog.events.ListenerMap.prototype.add = function(
    type, listener, callOnce, opt_useCapture, opt_listenerScope) {
  var typeStr = type.toString();
  var listenerArray = this.listeners[typeStr];
  if (!listenerArray) {
    listenerArray = this.listeners[typeStr] = [];
    this.typeCount_++;
  }
  var listenerObj;
  var index = goog.events.ListenerMap.findListenerIndex_(
      listenerArray, listener, opt_useCapture, opt_listenerScope);
  if (index > -1) {
    listenerObj = listenerArray[index];
    if (!callOnce) {
      listenerObj.callOnce = false;
    }
  } else {
    listenerObj = new goog.events.Listener(
        listener, null, this.src, typeStr, !!opt_useCapture, opt_listenerScope);
    listenerObj.callOnce = callOnce;
    listenerArray.push(listenerObj);
  }
  return listenerObj;
};
goog.events.ListenerMap.prototype.remove = function(
    type, listener, opt_useCapture, opt_listenerScope) {
  var typeStr = type.toString();
  if (!(typeStr in this.listeners)) {
    return false;
  }
  var listenerArray = this.listeners[typeStr];
  var index = goog.events.ListenerMap.findListenerIndex_(
      listenerArray, listener, opt_useCapture, opt_listenerScope);
  if (index > -1) {
    var listenerObj = listenerArray[index];
    listenerObj.markAsRemoved();
    goog.array.removeAt(listenerArray, index);
    if (listenerArray.length == 0) {
      delete this.listeners[typeStr];
      this.typeCount_--;
    }
    return true;
  }
  return false;
};
goog.events.ListenerMap.prototype.removeByKey = function(listener) {
  var type = listener.type;
  if (!(type in this.listeners)) {
    return false;
  }
  var removed = goog.array.remove(this.listeners[type], listener);
  if (removed) {
    listener.markAsRemoved();
    if (this.listeners[type].length == 0) {
      delete this.listeners[type];
      this.typeCount_--;
    }
  }
  return removed;
};
goog.events.ListenerMap.prototype.removeAll = function(opt_type) {
  var typeStr = opt_type && opt_type.toString();
  var count = 0;
  for (var type in this.listeners) {
    if (!typeStr || type == typeStr) {
      var listenerArray = this.listeners[type];
      for (var i = 0; i < listenerArray.length; i++) {
        ++count;
        listenerArray[i].markAsRemoved();
      }
      delete this.listeners[type];
      this.typeCount_--;
    }
  }
  return count;
};
goog.events.ListenerMap.prototype.getListeners = function(type, capture) {
  var listenerArray = this.listeners[type.toString()];
  var rv = [];
  if (listenerArray) {
    for (var i = 0; i < listenerArray.length; ++i) {
      var listenerObj = listenerArray[i];
      if (listenerObj.capture == capture) {
        rv.push(listenerObj);
      }
    }
  }
  return rv;
};
goog.events.ListenerMap.prototype.getListener = function(
    type, listener, capture, opt_listenerScope) {
  var listenerArray = this.listeners[type.toString()];
  var i = -1;
  if (listenerArray) {
    i = goog.events.ListenerMap.findListenerIndex_(
        listenerArray, listener, capture, opt_listenerScope);
  }
  return i > -1 ? listenerArray[i] : null;
};
goog.events.ListenerMap.prototype.hasListener = function(
    opt_type, opt_capture) {
  var hasType = goog.isDef(opt_type);
  var typeStr = hasType ? opt_type.toString() : '';
  var hasCapture = goog.isDef(opt_capture);
  return goog.object.some(
      this.listeners, function(listenerArray, type) {
        for (var i = 0; i < listenerArray.length; ++i) {
          if ((!hasType || listenerArray[i].type == typeStr) &&
              (!hasCapture || listenerArray[i].capture == opt_capture)) {
            return true;
          }
        }
        return false;
      });
};
goog.events.ListenerMap.findListenerIndex_ = function(
    listenerArray, listener, opt_useCapture, opt_listenerScope) {
  for (var i = 0; i < listenerArray.length; ++i) {
    var listenerObj = listenerArray[i];
    if (!listenerObj.removed &&
        listenerObj.listener == listener &&
        listenerObj.capture == !!opt_useCapture &&
        listenerObj.handler == opt_listenerScope) {
      return i;
    }
  }
  return -1;
};

// goog.events
// goog.events.CaptureSimulationMode
// goog.events.Key
// goog.events.ListenableType
goog.provide('goog.events');
goog.provide('goog.events.CaptureSimulationMode');
goog.provide('goog.events.Key');
goog.provide('goog.events.ListenableType');
goog.forwardDeclare('goog.debug.ErrorHandler');
goog.forwardDeclare('goog.events.EventWrapper');
goog.events.Key;
goog.events.ListenableType;
goog.events.LISTENER_MAP_PROP_ = 'closure_lm_' + ((Math.random() * 1e6) | 0);
goog.events.onString_ = 'on';
goog.events.onStringMap_ = {};
goog.events.CaptureSimulationMode = {
  OFF_AND_FAIL: 0,
  OFF_AND_SILENT: 1,
  ON: 2
};
goog.define('goog.events.CAPTURE_SIMULATION_MODE', 2);
goog.events.listenerCountEstimate_ = 0;
goog.events.listen = function(src, type, listener, opt_capt, opt_handler) {
  if (goog.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      goog.events.listen(src, type[i], listener, opt_capt, opt_handler);
    }
    return null;
  }
  listener = goog.events.wrapListener(listener);
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.listen(
         (type),
        listener, opt_capt, opt_handler);
  } else {
    return goog.events.listen_(
         (src),
         (type),
        listener,  false, opt_capt, opt_handler);
  }
};
goog.events.listen_ = function(
    src, type, listener, callOnce, opt_capt, opt_handler) {
  if (!type) {
    throw Error('Invalid event type');
  }
  var capture = !!opt_capt;
  if (capture && !goog.events.BrowserFeature.HAS_W3C_EVENT_SUPPORT) {
    if (goog.events.CAPTURE_SIMULATION_MODE ==
        goog.events.CaptureSimulationMode.OFF_AND_FAIL) {
      goog.asserts.fail('Can not register capture listener in IE8-.');
      return null;
    } else if (goog.events.CAPTURE_SIMULATION_MODE ==
        goog.events.CaptureSimulationMode.OFF_AND_SILENT) {
      return null;
    }
  }
  var listenerMap = goog.events.getListenerMap_(src);
  if (!listenerMap) {
    src[goog.events.LISTENER_MAP_PROP_] = listenerMap =
        new goog.events.ListenerMap(src);
  }
  var listenerObj = listenerMap.add(
      type, listener, callOnce, opt_capt, opt_handler);
  if (listenerObj.proxy) {
    return listenerObj;
  }
  var proxy = goog.events.getProxy();
  listenerObj.proxy = proxy;
  proxy.src = src;
  proxy.listener = listenerObj;
  if (src.addEventListener) {
    src.addEventListener(type.toString(), proxy, capture);
  } else if (src.attachEvent) {
    src.attachEvent(goog.events.getOnString_(type.toString()), proxy);
  } else {
    throw Error('addEventListener and attachEvent are unavailable.');
  }
  goog.events.listenerCountEstimate_++;
  return listenerObj;
};
goog.events.getProxy = function() {
  var proxyCallbackFunction = goog.events.handleBrowserEvent_;
  var f = goog.events.BrowserFeature.HAS_W3C_EVENT_SUPPORT ?
      function(eventObject) {
        return proxyCallbackFunction.call(f.src, f.listener, eventObject);
      } :
      function(eventObject) {
        var v = proxyCallbackFunction.call(f.src, f.listener, eventObject);
        if (!v) return v;
      };
  return f;
};
goog.events.listenOnce = function(src, type, listener, opt_capt, opt_handler) {
  if (goog.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      goog.events.listenOnce(src, type[i], listener, opt_capt, opt_handler);
    }
    return null;
  }
  listener = goog.events.wrapListener(listener);
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.listenOnce(
         (type),
        listener, opt_capt, opt_handler);
  } else {
    return goog.events.listen_(
         (src),
         (type),
        listener,  true, opt_capt, opt_handler);
  }
};
goog.events.listenWithWrapper = function(src, wrapper, listener, opt_capt,
    opt_handler) {
  wrapper.listen(src, listener, opt_capt, opt_handler);
};
goog.events.unlisten = function(src, type, listener, opt_capt, opt_handler) {
  if (goog.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      goog.events.unlisten(src, type[i], listener, opt_capt, opt_handler);
    }
    return null;
  }
  listener = goog.events.wrapListener(listener);
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.unlisten(
         (type),
        listener, opt_capt, opt_handler);
  }
  if (!src) {
    return false;
  }
  var capture = !!opt_capt;
  var listenerMap = goog.events.getListenerMap_(
       (src));
  if (listenerMap) {
    var listenerObj = listenerMap.getListener(
         (type),
        listener, capture, opt_handler);
    if (listenerObj) {
      return goog.events.unlistenByKey(listenerObj);
    }
  }
  return false;
};
goog.events.unlistenByKey = function(key) {
  if (goog.isNumber(key)) {
    return false;
  }
  var listener = key;
  if (!listener || listener.removed) {
    return false;
  }
  var src = listener.src;
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.unlistenByKey(listener);
  }
  var type = listener.type;
  var proxy = listener.proxy;
  if (src.removeEventListener) {
    src.removeEventListener(type, proxy, listener.capture);
  } else if (src.detachEvent) {
    src.detachEvent(goog.events.getOnString_(type), proxy);
  }
  goog.events.listenerCountEstimate_--;
  var listenerMap = goog.events.getListenerMap_(
       (src));
  if (listenerMap) {
    listenerMap.removeByKey(listener);
    if (listenerMap.getTypeCount() == 0) {
      listenerMap.src = null;
      src[goog.events.LISTENER_MAP_PROP_] = null;
    }
  } else {
    listener.markAsRemoved();
  }
  return true;
};
goog.events.unlistenWithWrapper = function(src, wrapper, listener, opt_capt,
    opt_handler) {
  wrapper.unlisten(src, listener, opt_capt, opt_handler);
};
goog.events.removeAll = function(obj, opt_type) {
  if (!obj) {
    return 0;
  }
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.removeAllListeners(opt_type);
  }
  var listenerMap = goog.events.getListenerMap_(
       (obj));
  if (!listenerMap) {
    return 0;
  }
  var count = 0;
  var typeStr = opt_type && opt_type.toString();
  for (var type in listenerMap.listeners) {
    if (!typeStr || type == typeStr) {
      var listeners = listenerMap.listeners[type].concat();
      for (var i = 0; i < listeners.length; ++i) {
        if (goog.events.unlistenByKey(listeners[i])) {
          ++count;
        }
      }
    }
  }
  return count;
};
goog.events.getListeners = function(obj, type, capture) {
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.getListeners(type, capture);
  } else {
    if (!obj) {
      return [];
    }
    var listenerMap = goog.events.getListenerMap_(
         (obj));
    return listenerMap ? listenerMap.getListeners(type, capture) : [];
  }
};
goog.events.getListener = function(src, type, listener, opt_capt, opt_handler) {
  type =  (type);
  listener = goog.events.wrapListener(listener);
  var capture = !!opt_capt;
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.getListener(type, listener, capture, opt_handler);
  }
  if (!src) {
    return null;
  }
  var listenerMap = goog.events.getListenerMap_(
       (src));
  if (listenerMap) {
    return listenerMap.getListener(type, listener, capture, opt_handler);
  }
  return null;
};
goog.events.hasListener = function(obj, opt_type, opt_capture) {
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.hasListener(opt_type, opt_capture);
  }
  var listenerMap = goog.events.getListenerMap_(
       (obj));
  return !!listenerMap && listenerMap.hasListener(opt_type, opt_capture);
};
goog.events.expose = function(e) {
  var str = [];
  for (var key in e) {
    if (e[key] && e[key].id) {
      str.push(key + ' = ' + e[key] + ' (' + e[key].id + ')');
    } else {
      str.push(key + ' = ' + e[key]);
    }
  }
  return str.join('\n');
};
goog.events.getOnString_ = function(type) {
  if (type in goog.events.onStringMap_) {
    return goog.events.onStringMap_[type];
  }
  return goog.events.onStringMap_[type] = goog.events.onString_ + type;
};
goog.events.fireListeners = function(obj, type, capture, eventObject) {
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.fireListeners(type, capture, eventObject);
  }
  return goog.events.fireListeners_(obj, type, capture, eventObject);
};
goog.events.fireListeners_ = function(obj, type, capture, eventObject) {
  var retval = true;
  var listenerMap = goog.events.getListenerMap_(
       (obj));
  if (listenerMap) {
    var listenerArray = listenerMap.listeners[type.toString()];
    if (listenerArray) {
      listenerArray = listenerArray.concat();
      for (var i = 0; i < listenerArray.length; i++) {
        var listener = listenerArray[i];
        if (listener && listener.capture == capture && !listener.removed) {
          var result = goog.events.fireListener(listener, eventObject);
          retval = retval && (result !== false);
        }
      }
    }
  }
  return retval;
};
goog.events.fireListener = function(listener, eventObject) {
  var listenerFn = listener.listener;
  var listenerHandler = listener.handler || listener.src;
  if (listener.callOnce) {
    goog.events.unlistenByKey(listener);
  }
  return listenerFn.call(listenerHandler, eventObject);
};
goog.events.getTotalListenerCount = function() {
  return goog.events.listenerCountEstimate_;
};
goog.events.dispatchEvent = function(src, e) {
  goog.asserts.assert(
      goog.events.Listenable.isImplementedBy(src),
      'Can not use goog.events.dispatchEvent with ' +
      'non-goog.events.Listenable instance.');
  return src.dispatchEvent(e);
};
goog.events.protectBrowserEventEntryPoint = function(errorHandler) {
  goog.events.handleBrowserEvent_ = errorHandler.protectEntryPoint(
      goog.events.handleBrowserEvent_);
};
goog.events.handleBrowserEvent_ = function(listener, opt_evt) {
  if (listener.removed) {
    return true;
  }
  if (!goog.events.BrowserFeature.HAS_W3C_EVENT_SUPPORT) {
    var ieEvent = opt_evt ||
         (goog.getObjectByName('window.event'));
    var evt = new goog.events.BrowserEvent(ieEvent, this);
    var retval = true;
    if (goog.events.CAPTURE_SIMULATION_MODE ==
            goog.events.CaptureSimulationMode.ON) {
      if (!goog.events.isMarkedIeEvent_(ieEvent)) {
        goog.events.markIeEvent_(ieEvent);
        var ancestors = [];
        for (var parent = evt.currentTarget; parent;
             parent = parent.parentNode) {
          ancestors.push(parent);
        }
        var type = listener.type;
        for (var i = ancestors.length - 1; !evt.propagationStopped_ && i >= 0;
             i--) {
          evt.currentTarget = ancestors[i];
          var result = goog.events.fireListeners_(ancestors[i], type, true, evt);
          retval = retval && result;
        }
        for (var i = 0; !evt.propagationStopped_ && i < ancestors.length; i++) {
          evt.currentTarget = ancestors[i];
          var result = goog.events.fireListeners_(ancestors[i], type, false, evt);
          retval = retval && result;
        }
      }
    } else {
      retval = goog.events.fireListener(listener, evt);
    }
    return retval;
  }
  return goog.events.fireListener(
      listener, new goog.events.BrowserEvent(opt_evt, this));
};
goog.events.markIeEvent_ = function(e) {
  var useReturnValue = false;
  if (e.keyCode == 0) {
    try {
      e.keyCode = -1;
      return;
    } catch (ex) {
      useReturnValue = true;
    }
  }
  if (useReturnValue ||
       (e.returnValue) == undefined) {
    e.returnValue = true;
  }
};
goog.events.isMarkedIeEvent_ = function(e) {
  return e.keyCode < 0 || e.returnValue != undefined;
};
goog.events.uniqueIdCounter_ = 0;
goog.events.getUniqueId = function(identifier) {
  return identifier + '_' + goog.events.uniqueIdCounter_++;
};
goog.events.getListenerMap_ = function(src) {
  var listenerMap = src[goog.events.LISTENER_MAP_PROP_];
  return listenerMap instanceof goog.events.ListenerMap ? listenerMap : null;
};
goog.events.LISTENER_WRAPPER_PROP_ = '__closure_events_fn_' +
    ((Math.random() * 1e9) >>> 0);
goog.events.wrapListener = function(listener) {
  goog.asserts.assert(listener, 'Listener can not be null.');
  if (goog.isFunction(listener)) {
    return listener;
  }
  goog.asserts.assert(
      listener.handleEvent, 'An object listener must have handleEvent method.');
  if (!listener[goog.events.LISTENER_WRAPPER_PROP_]) {
    listener[goog.events.LISTENER_WRAPPER_PROP_] =
        function(e) { return listener.handleEvent(e); };
  }
  return listener[goog.events.LISTENER_WRAPPER_PROP_];
};
goog.debug.entryPointRegistry.register(
    function(transformer) {
      goog.events.handleBrowserEvent_ = transformer(
          goog.events.handleBrowserEvent_);
    });

// goog.events.EventTarget
goog.provide('goog.events.EventTarget');
goog.events.EventTarget = function() {
  goog.Disposable.call(this);
  this.eventTargetListeners_ = new goog.events.ListenerMap(this);
  this.actualEventTarget_ = this;
  this.parentEventTarget_ = null;
};
goog.inherits(goog.events.EventTarget, goog.Disposable);
goog.events.Listenable.addImplementation(goog.events.EventTarget);
goog.events.EventTarget.MAX_ANCESTORS_ = 1000;
goog.events.EventTarget.prototype.getParentEventTarget = function() {
  return this.parentEventTarget_;
};
goog.events.EventTarget.prototype.setParentEventTarget = function(parent) {
  this.parentEventTarget_ = parent;
};
goog.events.EventTarget.prototype.addEventListener = function(
    type, handler, opt_capture, opt_handlerScope) {
  goog.events.listen(this, type, handler, opt_capture, opt_handlerScope);
};
goog.events.EventTarget.prototype.removeEventListener = function(
    type, handler, opt_capture, opt_handlerScope) {
  goog.events.unlisten(this, type, handler, opt_capture, opt_handlerScope);
};
goog.events.EventTarget.prototype.dispatchEvent = function(e) {
  this.assertInitialized_();
  var ancestorsTree, ancestor = this.getParentEventTarget();
  if (ancestor) {
    ancestorsTree = [];
    var ancestorCount = 1;
    for (; ancestor; ancestor = ancestor.getParentEventTarget()) {
      ancestorsTree.push(ancestor);
      goog.asserts.assert(
          (++ancestorCount < goog.events.EventTarget.MAX_ANCESTORS_),
          'infinite loop');
    }
  }
  return goog.events.EventTarget.dispatchEventInternal_(
      this.actualEventTarget_, e, ancestorsTree);
};
goog.events.EventTarget.prototype.disposeInternal = function() {
  goog.events.EventTarget.superClass_.disposeInternal.call(this);
  this.removeAllListeners();
  this.parentEventTarget_ = null;
};
goog.events.EventTarget.prototype.listen = function(
    type, listener, opt_useCapture, opt_listenerScope) {
  this.assertInitialized_();
  return this.eventTargetListeners_.add(
      String(type), listener, false , opt_useCapture,
      opt_listenerScope);
};
goog.events.EventTarget.prototype.listenOnce = function(
    type, listener, opt_useCapture, opt_listenerScope) {
  return this.eventTargetListeners_.add(
      String(type), listener, true , opt_useCapture,
      opt_listenerScope);
};
goog.events.EventTarget.prototype.unlisten = function(
    type, listener, opt_useCapture, opt_listenerScope) {
  return this.eventTargetListeners_.remove(
      String(type), listener, opt_useCapture, opt_listenerScope);
};
goog.events.EventTarget.prototype.unlistenByKey = function(key) {
  return this.eventTargetListeners_.removeByKey(key);
};
goog.events.EventTarget.prototype.removeAllListeners = function(opt_type) {
  if (!this.eventTargetListeners_) {
    return 0;
  }
  return this.eventTargetListeners_.removeAll(opt_type);
};
goog.events.EventTarget.prototype.fireListeners = function(
    type, capture, eventObject) {
  var listenerArray = this.eventTargetListeners_.listeners[String(type)];
  if (!listenerArray) {
    return true;
  }
  listenerArray = listenerArray.concat();
  var rv = true;
  for (var i = 0; i < listenerArray.length; ++i) {
    var listener = listenerArray[i];
    if (listener && !listener.removed && listener.capture == capture) {
      var listenerFn = listener.listener;
      var listenerHandler = listener.handler || listener.src;
      if (listener.callOnce) {
        this.unlistenByKey(listener);
      }
      rv = listenerFn.call(listenerHandler, eventObject) !== false && rv;
    }
  }
  return rv && eventObject.returnValue_ != false;
};
goog.events.EventTarget.prototype.getListeners = function(type, capture) {
  return this.eventTargetListeners_.getListeners(String(type), capture);
};
goog.events.EventTarget.prototype.getListener = function(
    type, listener, capture, opt_listenerScope) {
  return this.eventTargetListeners_.getListener(
      String(type), listener, capture, opt_listenerScope);
};
goog.events.EventTarget.prototype.hasListener = function(
    opt_type, opt_capture) {
  var id = goog.isDef(opt_type) ? String(opt_type) : undefined;
  return this.eventTargetListeners_.hasListener(id, opt_capture);
};
goog.events.EventTarget.prototype.setTargetForTesting = function(target) {
  this.actualEventTarget_ = target;
};
goog.events.EventTarget.prototype.assertInitialized_ = function() {
  goog.asserts.assert(
      this.eventTargetListeners_,
      'Event target is not initialized. Did you call the superclass ' +
      '(goog.events.EventTarget) constructor?');
};
goog.events.EventTarget.dispatchEventInternal_ = function(
    target, e, opt_ancestorsTree) {
  var type = e.type ||  (e);
  if (goog.isString(e)) {
    e = new goog.events.Event(e, target);
  } else if (!(e instanceof goog.events.Event)) {
    var oldEvent = e;
    e = new goog.events.Event(type, target);
    goog.object.extend(e, oldEvent);
  } else {
    e.target = e.target || target;
  }
  var rv = true, currentTarget;
  if (opt_ancestorsTree) {
    for (var i = opt_ancestorsTree.length - 1; !e.propagationStopped_ && i >= 0;
         i--) {
      currentTarget = e.currentTarget = opt_ancestorsTree[i];
      rv = currentTarget.fireListeners(type, true, e) && rv;
    }
  }
  if (!e.propagationStopped_) {
    currentTarget = e.currentTarget = target;
    rv = currentTarget.fireListeners(type, true, e) && rv;
    if (!e.propagationStopped_) {
      rv = currentTarget.fireListeners(type, false, e) && rv;
    }
  }
  if (opt_ancestorsTree) {
    for (i = 0; !e.propagationStopped_ && i < opt_ancestorsTree.length; i++) {
      currentTarget = e.currentTarget = opt_ancestorsTree[i];
      rv = currentTarget.fireListeners(type, false, e) && rv;
    }
  }
  return rv;
};

// goog.functions
goog.provide('goog.functions');
goog.functions.constant = function(retValue) {
  return function() {
    return retValue;
  };
};
goog.functions.FALSE = goog.functions.constant(false);
goog.functions.TRUE = goog.functions.constant(true);
goog.functions.NULL = goog.functions.constant(null);
goog.functions.identity = function(opt_returnValue, var_args) {
  return opt_returnValue;
};
goog.functions.error = function(message) {
  return function() {
    throw Error(message);
  };
};
goog.functions.fail = function(err) {
  return function() {
    throw err;
  }
};
goog.functions.lock = function(f, opt_numArgs) {
  opt_numArgs = opt_numArgs || 0;
  return function() {
    return f.apply(this, Array.prototype.slice.call(arguments, 0, opt_numArgs));
  };
};
goog.functions.nth = function(n) {
  return function() {
    return arguments[n];
  };
};
goog.functions.withReturnValue = function(f, retValue) {
  return goog.functions.sequence(f, goog.functions.constant(retValue));
};
goog.functions.equalTo = function(value, opt_useLooseComparison) {
  return function(other) {
    return opt_useLooseComparison ? (value == other) : (value === other);
  };
};
goog.functions.compose = function(fn, var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    var result;
    if (length) {
      result = functions[length - 1].apply(this, arguments);
    }
    for (var i = length - 2; i >= 0; i--) {
      result = functions[i].call(this, result);
    }
    return result;
  };
};
goog.functions.sequence = function(var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    var result;
    for (var i = 0; i < length; i++) {
      result = functions[i].apply(this, arguments);
    }
    return result;
  };
};
goog.functions.and = function(var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    for (var i = 0; i < length; i++) {
      if (!functions[i].apply(this, arguments)) {
        return false;
      }
    }
    return true;
  };
};
goog.functions.or = function(var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    for (var i = 0; i < length; i++) {
      if (functions[i].apply(this, arguments)) {
        return true;
      }
    }
    return false;
  };
};
goog.functions.not = function(f) {
  return function() {
    return !f.apply(this, arguments);
  };
};
goog.functions.create = function(constructor, var_args) {
  var temp = function() {};
  temp.prototype = constructor.prototype;
  var obj = new temp();
  constructor.apply(obj, Array.prototype.slice.call(arguments, 1));
  return obj;
};
goog.define('goog.functions.CACHE_RETURN_VALUE', true);
goog.functions.cacheReturnValue = function(fn) {
  var called = false;
  var value;
  return function() {
    if (!goog.functions.CACHE_RETURN_VALUE) {
      return fn();
    }
    if (!called) {
      value = fn();
      called = true;
    }
    return value;
  }
};
goog.functions.once = function(f) {
  var inner = f;
  return function() {
    if (inner) {
      var tmp = inner;
      inner = null;
      tmp();
    }
  };
};

// i18n.input.chrome.DataSource
goog.provide('i18n.input.chrome.DataSource');
goog.scope(function() {
var Event = goog.events.Event;
var EventTarget = goog.events.EventTarget;
i18n.input.chrome.DataSource = function(numOfCanddiate, candidatesCallback,
    gestureCallback) {
  goog.base(this);
  this.numOfCandidate = numOfCanddiate;
  this.candidatesCallback = candidatesCallback;
  this.gestureCallback = gestureCallback;
};
var DataSource = i18n.input.chrome.DataSource;
goog.inherits(DataSource, EventTarget);
DataSource.EventType = {
  CANDIDATES_BACK: goog.events.getUniqueId('cb'),
  GESTURES_BACK: goog.events.getUniqueId('gb'),
  READY: goog.events.getUniqueId('r')
};
DataSource.prototype.ready = false;
DataSource.prototype.correctionLevel = 0;
DataSource.prototype.enableUserDict = false;
DataSource.prototype.language;
DataSource.prototype.setLanguage = function(language) {
  this.language = language;
};
DataSource.prototype.isReady = function() {
  return this.ready;
};
DataSource.prototype.createCommonPayload = function() {
  return {
    'itc': this.getInputToolCode(),
    'num': this.numOfCandidate
  };
};
DataSource.prototype.getInputToolCode = function() {
  return this.language + '-t-i0-und';
};
DataSource.prototype.sendCompletionRequestForWord = goog.functions.NULL;
DataSource.prototype.sendCompletionRequest = goog.functions.NULL;
DataSource.prototype.setEnableUserDict = function(enabled) {
  this.enableUserDict = enabled;
};
DataSource.prototype.sendPredictionRequest = goog.functions.NULL;
DataSource.prototype.setCorrectionLevel = function(level) {
  this.correctionLevel = level;
};
DataSource.prototype.changeWordFrequency = goog.functions.NULL;
DataSource.prototype.clear = goog.functions.NULL;
DataSource.CandidatesBackEvent = function(source, candidates) {
  DataSource.CandidatesBackEvent.base(
      this, 'constructor', DataSource.EventType.CANDIDATES_BACK);
  this.source = source;
  this.candidates = candidates;
};
goog.inherits(DataSource.CandidatesBackEvent, Event);
DataSource.GesturesBackEvent = function(response) {
  DataSource.GesturesBackEvent.base(
      this, 'constructor', DataSource.EventType.GESTURES_BACK);
  this.response = response;
};
goog.inherits(DataSource.GesturesBackEvent, Event);
});  // goog.scope

// i18n.input.chrome.ElementType
goog.provide('i18n.input.chrome.ElementType');
i18n.input.chrome.ElementType = {
  CHARACTER: 0,
  FUNCTIONAL_KEY: 1,
  KEYBOARD: 2,
  LAYOUT_VIEW: 3,
  LINEAR_LAYOUT: 4,
  MODIFIER_KEY: 5,
  CHARACTER_KEY: 6,
  SOFT_KEY: 7,
  SOFT_KEY_VIEW: 8,
  VERTICAL_LAYOUT: 9,
  CANDIDATE_VIEW: 10,
  SPACE_KEY: 11,
  ENTER_KEY: 12,
  BACKSPACE_KEY: 13,
  TAB_KEY: 14,
  ARROW_UP: 15,
  ARROW_DOWN: 16,
  ARROW_LEFT: 17,
  ARROW_RIGHT: 18,
  HIDE_KEYBOARD_KEY: 19,
  ALTDATA_VIEW: 20,
  SWITCHER_KEY: 21,
  COMPACT_KEY: 22,
  CANVAS_VIEW: 23,
  HANDWRITING_LAYOUT: 24,
  MENU_VIEW: 25,
  MENU_KEY: 26,
  GLOBE_KEY: 27,
  BACK_BUTTON: 28,
  SHRINK_CANDIDATES: 29,
  EXPAND_CANDIDATES: 30,
  CANDIDATES_PAGE_UP: 31,
  CANDIDATES_PAGE_DOWN: 32,
  CANDIDATE: 33,
  EXPANDED_CANDIDATE_VIEW: 34,
  IME_SWITCH: 35,
  HWT_PRIVACY_GOT_IT: 36,
  MENU_ITEM: 37,
  EMOJI_KEY: 38,
  TAB_BAR_KEY: 39,
  EXTENDED_LAYOUT: 40,
  PAGE_INDICATOR: 41,
  EN_SWITCHER: 42,
  VOICE_BTN: 43,
  VOICE_VIEW: 44,
  VOICE_PRIVACY_GOT_IT: 45,
  BACK_TO_KEYBOARD: 46,
  BOLD: 47,
  ITALICS: 48,
  UNDERLINE: 49,
  COPY: 50,
  PASTE: 51,
  CUT: 52,
  SELECT_ALL: 53,
  REDO: 54,
  UNDO: 55,
  SWIPE_VIEW: 56,
  SELECT_VIEW: 57,
  GESTURE_CANVAS_VIEW: 58,
  KEYBOARD_CONTAINER_VIEW: 59,
  DRAG: 60,
  FLOATING_VIEW: 61,
  RESIZE: 62,
  GESTURE_PREVIEW_VIEW: 63,
  KEYSET_VIEW: 64,
  HOTROD_SWITCHER_KEY: 65
};

// i18n.input.chrome.FeatureName
goog.provide('i18n.input.chrome.FeatureName');
i18n.input.chrome.FeatureName = {
  EXPERIMENTAL: 'experimental',
  FLOATING_VIRTUAL_KEYBOARD: 'floatingvirtualkeyboard',
  GESTURE_EDITING_OPTION: 'gestureediting',
  GESTURE_TYPING_OPTION: 'gesturetyping',
  OPTIMIZED_LAYOUTS: 'optimized-layouts',
  PHYSICAL_AUTOCORRECT: 'physicalautocorrect',
  VOICE_INPUT: 'voiceinput'
};

// i18n.input.chrome.FeatureTracker
goog.provide('i18n.input.chrome.FeatureTracker');
goog.scope(function() {
var FeatureName = i18n.input.chrome.FeatureName;
i18n.input.chrome.FeatureTracker = function() {
  this.features_ = {};
  this.ENABLED_BY_DEFAULT_ = [];
  this.ready_ = false;
};
var FeatureTracker = i18n.input.chrome.FeatureTracker;
FeatureTracker.prototype.isEnabled = function(feature) {
  if (!this.ready_) {
    console.error('Features not present in config or not ready yet.');
  }
  if (feature in this.features_) {
    return this.features_[feature];
  }
  return (this.ENABLED_BY_DEFAULT_.indexOf(feature) >= 0) ||
      !!this.features_[FeatureName.EXPERIMENTAL];
};
FeatureTracker.prototype.initialize = function(config) {
  if (config.features) {
    var features = config.features;
    for (var i = 0; i < features.length; i++) {
      var pieces = features[i].split('-');
      var state = pieces.pop();
      if (state == 'enabled') {
        this.features_[pieces.join('-')] = true;
      } else if (state == 'disabled') {
        this.features_[pieces.join('-')] = false;
      } else {
        console.error('Unrecognized flag: ' + features[i]);
      }
    }
    this.ready_ = true;
  } else {
    console.error('API Error. Features not present in config.');
    return;
  }
};
});  // goog.scope

// goog.dom.BrowserFeature
goog.provide('goog.dom.BrowserFeature');
goog.dom.BrowserFeature = {
  CAN_ADD_NAME_OR_TYPE_ATTRIBUTES: !goog.userAgent.IE ||
      goog.userAgent.isDocumentModeOrHigher(9),
  CAN_USE_CHILDREN_ATTRIBUTE: !goog.userAgent.GECKO && !goog.userAgent.IE ||
      goog.userAgent.IE && goog.userAgent.isDocumentModeOrHigher(9) ||
      goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher('1.9.1'),
  CAN_USE_INNER_TEXT: (
      goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('9')),
  CAN_USE_PARENT_ELEMENT_PROPERTY: goog.userAgent.IE || goog.userAgent.OPERA ||
      goog.userAgent.WEBKIT,
  INNER_HTML_NEEDS_SCOPED_ELEMENT: goog.userAgent.IE,
  LEGACY_IE_RANGES: goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9)
};

// goog.dom.TagName
goog.provide('goog.dom.TagName');
goog.dom.TagName = {
  A: 'A',
  ABBR: 'ABBR',
  ACRONYM: 'ACRONYM',
  ADDRESS: 'ADDRESS',
  APPLET: 'APPLET',
  AREA: 'AREA',
  ARTICLE: 'ARTICLE',
  ASIDE: 'ASIDE',
  AUDIO: 'AUDIO',
  B: 'B',
  BASE: 'BASE',
  BASEFONT: 'BASEFONT',
  BDI: 'BDI',
  BDO: 'BDO',
  BIG: 'BIG',
  BLOCKQUOTE: 'BLOCKQUOTE',
  BODY: 'BODY',
  BR: 'BR',
  BUTTON: 'BUTTON',
  CANVAS: 'CANVAS',
  CAPTION: 'CAPTION',
  CENTER: 'CENTER',
  CITE: 'CITE',
  CODE: 'CODE',
  COL: 'COL',
  COLGROUP: 'COLGROUP',
  COMMAND: 'COMMAND',
  DATA: 'DATA',
  DATALIST: 'DATALIST',
  DD: 'DD',
  DEL: 'DEL',
  DETAILS: 'DETAILS',
  DFN: 'DFN',
  DIALOG: 'DIALOG',
  DIR: 'DIR',
  DIV: 'DIV',
  DL: 'DL',
  DT: 'DT',
  EM: 'EM',
  EMBED: 'EMBED',
  FIELDSET: 'FIELDSET',
  FIGCAPTION: 'FIGCAPTION',
  FIGURE: 'FIGURE',
  FONT: 'FONT',
  FOOTER: 'FOOTER',
  FORM: 'FORM',
  FRAME: 'FRAME',
  FRAMESET: 'FRAMESET',
  H1: 'H1',
  H2: 'H2',
  H3: 'H3',
  H4: 'H4',
  H5: 'H5',
  H6: 'H6',
  HEAD: 'HEAD',
  HEADER: 'HEADER',
  HGROUP: 'HGROUP',
  HR: 'HR',
  HTML: 'HTML',
  I: 'I',
  IFRAME: 'IFRAME',
  IMG: 'IMG',
  INPUT: 'INPUT',
  INS: 'INS',
  ISINDEX: 'ISINDEX',
  KBD: 'KBD',
  KEYGEN: 'KEYGEN',
  LABEL: 'LABEL',
  LEGEND: 'LEGEND',
  LI: 'LI',
  LINK: 'LINK',
  MAP: 'MAP',
  MARK: 'MARK',
  MATH: 'MATH',
  MENU: 'MENU',
  META: 'META',
  METER: 'METER',
  NAV: 'NAV',
  NOFRAMES: 'NOFRAMES',
  NOSCRIPT: 'NOSCRIPT',
  OBJECT: 'OBJECT',
  OL: 'OL',
  OPTGROUP: 'OPTGROUP',
  OPTION: 'OPTION',
  OUTPUT: 'OUTPUT',
  P: 'P',
  PARAM: 'PARAM',
  PRE: 'PRE',
  PROGRESS: 'PROGRESS',
  Q: 'Q',
  RP: 'RP',
  RT: 'RT',
  RUBY: 'RUBY',
  S: 'S',
  SAMP: 'SAMP',
  SCRIPT: 'SCRIPT',
  SECTION: 'SECTION',
  SELECT: 'SELECT',
  SMALL: 'SMALL',
  SOURCE: 'SOURCE',
  SPAN: 'SPAN',
  STRIKE: 'STRIKE',
  STRONG: 'STRONG',
  STYLE: 'STYLE',
  SUB: 'SUB',
  SUMMARY: 'SUMMARY',
  SUP: 'SUP',
  SVG: 'SVG',
  TABLE: 'TABLE',
  TBODY: 'TBODY',
  TD: 'TD',
  TEMPLATE: 'TEMPLATE',
  TEXTAREA: 'TEXTAREA',
  TFOOT: 'TFOOT',
  TH: 'TH',
  THEAD: 'THEAD',
  TIME: 'TIME',
  TITLE: 'TITLE',
  TR: 'TR',
  TRACK: 'TRACK',
  TT: 'TT',
  U: 'U',
  UL: 'UL',
  VAR: 'VAR',
  VIDEO: 'VIDEO',
  WBR: 'WBR'
};

// goog.dom.tags
goog.provide('goog.dom.tags');
goog.dom.tags.VOID_TAGS_ = goog.object.createSet(('area,base,br,col,command,' +
    'embed,hr,img,input,keygen,link,meta,param,source,track,wbr').split(','));
goog.dom.tags.isVoidTag = function(tagName) {
  return goog.dom.tags.VOID_TAGS_[tagName] === true;
};

// goog.string.TypedString
goog.provide('goog.string.TypedString');
goog.string.TypedString = function() {};
goog.string.TypedString.prototype.implementsGoogStringTypedString;
goog.string.TypedString.prototype.getTypedStringValue;

// goog.string.Const
goog.provide('goog.string.Const');
goog.string.Const = function() {
  this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ = '';
  this.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ =
      goog.string.Const.TYPE_MARKER_;
};
goog.string.Const.prototype.implementsGoogStringTypedString = true;
goog.string.Const.prototype.getTypedStringValue = function() {
  return this.stringConstValueWithSecurityContract__googStringSecurityPrivate_;
};
goog.string.Const.prototype.toString = function() {
  return 'Const{' +
         this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ +
         '}';
};
goog.string.Const.unwrap = function(stringConst) {
  if (stringConst instanceof goog.string.Const &&
      stringConst.constructor === goog.string.Const &&
      stringConst.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ ===
          goog.string.Const.TYPE_MARKER_) {
    return stringConst.
        stringConstValueWithSecurityContract__googStringSecurityPrivate_;
  } else {
    goog.asserts.fail('expected object of type Const, got \'' +
                      stringConst + '\'');
    return 'type_error:Const';
  }
};
goog.string.Const.from = function(s) {
  return goog.string.Const.create__googStringSecurityPrivate_(s);
};
goog.string.Const.TYPE_MARKER_ = {};
goog.string.Const.create__googStringSecurityPrivate_ = function(s) {
  var stringConst = new goog.string.Const();
  stringConst.stringConstValueWithSecurityContract__googStringSecurityPrivate_ =
      s;
  return stringConst;
};

// goog.html.SafeStyle
goog.provide('goog.html.SafeStyle');
goog.html.SafeStyle = function() {
  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = '';
  this.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ =
      goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeStyle.prototype.implementsGoogStringTypedString = true;
goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeStyle.fromConstant = function(style) {
  var styleString = goog.string.Const.unwrap(style);
  if (styleString.length === 0) {
    return goog.html.SafeStyle.EMPTY;
  }
  goog.html.SafeStyle.checkStyle_(styleString);
  goog.asserts.assert(goog.string.endsWith(styleString, ';'),
      'Last character of style string is not \';\': ' + styleString);
  goog.asserts.assert(goog.string.contains(styleString, ':'),
      'Style string must contain at least one \':\', to ' +
      'specify a "name: value" pair: ' + styleString);
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(
      styleString);
};
goog.html.SafeStyle.checkStyle_ = function(style) {
  goog.asserts.assert(!/[<>]/.test(style),
      'Forbidden characters in style string: ' + style);
};
goog.html.SafeStyle.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeStyleWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeStyle.prototype.toString = function() {
    return 'SafeStyle{' +
        this.privateDoNotAccessOrElseSafeStyleWrappedValue_ + '}';
  };
}
goog.html.SafeStyle.unwrap = function(safeStyle) {
  if (safeStyle instanceof goog.html.SafeStyle &&
      safeStyle.constructor === goog.html.SafeStyle &&
      safeStyle.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ===
          goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeStyle.privateDoNotAccessOrElseSafeStyleWrappedValue_;
  } else {
    goog.asserts.fail(
        'expected object of type SafeStyle, got \'' + safeStyle + '\'');
    return 'type_error:SafeStyle';
  }
};
goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse =
    function(style) {
  return new goog.html.SafeStyle().initSecurityPrivateDoNotAccessOrElse_(style);
};
goog.html.SafeStyle.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(
    style) {
  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = style;
  return this;
};
goog.html.SafeStyle.EMPTY =
    goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse('');
goog.html.SafeStyle.INNOCUOUS_STRING = 'zClosurez';
goog.html.SafeStyle.PropertyMap;
goog.html.SafeStyle.create = function(map) {
  var style = '';
  for (var name in map) {
    if (!/^[-_a-zA-Z0-9]+$/.test(name)) {
      throw Error('Name allows only [-_a-zA-Z0-9], got: ' + name);
    }
    var value = map[name];
    if (value == null) {
      continue;
    }
    if (value instanceof goog.string.Const) {
      value = goog.string.Const.unwrap(value);
      goog.asserts.assert(!/[{;}]/.test(value), 'Value does not allow [{;}].');
    } else if (!goog.html.SafeStyle.VALUE_RE_.test(value)) {
      goog.asserts.fail(
          'String value allows only [-,."\'%_!# a-zA-Z0-9], got: ' + value);
      value = goog.html.SafeStyle.INNOCUOUS_STRING;
    } else if (!goog.html.SafeStyle.hasBalancedQuotes_(value)) {
      goog.asserts.fail('String value requires balanced quotes, got: ' + value);
      value = goog.html.SafeStyle.INNOCUOUS_STRING;
    }
    style += name + ':' + value + ';';
  }
  if (!style) {
    return goog.html.SafeStyle.EMPTY;
  }
  goog.html.SafeStyle.checkStyle_(style);
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(
      style);
};
goog.html.SafeStyle.hasBalancedQuotes_ = function(value) {
  var outsideSingle = true;
  var outsideDouble = true;
  for (var i = 0; i < value.length; i++) {
    var c = value.charAt(i);
    if (c == "'" && outsideDouble) {
      outsideSingle = !outsideSingle;
    } else if (c == '"' && outsideSingle) {
      outsideDouble = !outsideDouble;
    }
  }
  return outsideSingle && outsideDouble;
};
goog.html.SafeStyle.VALUE_RE_ = /^[-,."'%_!# a-zA-Z0-9]+$/;
goog.html.SafeStyle.concat = function(var_args) {
  var style = '';
  var addArgument = function(argument) {
    if (goog.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      style += goog.html.SafeStyle.unwrap(argument);
    }
  };
  goog.array.forEach(arguments, addArgument);
  if (!style) {
    return goog.html.SafeStyle.EMPTY;
  }
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(
      style);
};

// goog.html.SafeStyleSheet
goog.provide('goog.html.SafeStyleSheet');
goog.html.SafeStyleSheet = function() {
  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = '';
  this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ =
      goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeStyleSheet.prototype.implementsGoogStringTypedString = true;
goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeStyleSheet.concat = function(var_args) {
  var result = '';
  var addArgument = function(argument) {
    if (goog.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      result += goog.html.SafeStyleSheet.unwrap(argument);
    }
  };
  goog.array.forEach(arguments, addArgument);
  return goog.html.SafeStyleSheet
      .createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(result);
};
goog.html.SafeStyleSheet.fromConstant = function(styleSheet) {
  var styleSheetString = goog.string.Const.unwrap(styleSheet);
  if (styleSheetString.length === 0) {
    return goog.html.SafeStyleSheet.EMPTY;
  }
  goog.asserts.assert(!goog.string.contains(styleSheetString, '<'),
      "Forbidden '<' character in style sheet string: " + styleSheetString);
  return goog.html.SafeStyleSheet.
      createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheetString);
};
goog.html.SafeStyleSheet.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeStyleSheet.prototype.toString = function() {
    return 'SafeStyleSheet{' +
        this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ + '}';
  };
}
goog.html.SafeStyleSheet.unwrap = function(safeStyleSheet) {
  if (safeStyleSheet instanceof goog.html.SafeStyleSheet &&
      safeStyleSheet.constructor === goog.html.SafeStyleSheet &&
      safeStyleSheet.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ===
          goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeStyleSheet.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
  } else {
    goog.asserts.fail(
        "expected object of type SafeStyleSheet, got '" + safeStyleSheet +
        "'");
    return 'type_error:SafeStyleSheet';
  }
};
goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse =
    function(styleSheet) {
  return new goog.html.SafeStyleSheet().initSecurityPrivateDoNotAccessOrElse_(
      styleSheet);
};
goog.html.SafeStyleSheet.prototype.initSecurityPrivateDoNotAccessOrElse_ =
    function(styleSheet) {
  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = styleSheet;
  return this;
};
goog.html.SafeStyleSheet.EMPTY =
    goog.html.SafeStyleSheet.
        createSafeStyleSheetSecurityPrivateDoNotAccessOrElse('');

// goog.fs.url
goog.provide('goog.fs.url');
goog.fs.url.createObjectUrl = function(blob) {
  return goog.fs.url.getUrlObject_().createObjectURL(blob);
};
goog.fs.url.revokeObjectUrl = function(url) {
  goog.fs.url.getUrlObject_().revokeObjectURL(url);
};
goog.fs.url.UrlObject_;
goog.fs.url.getUrlObject_ = function() {
  var urlObject = goog.fs.url.findUrlObject_();
  if (urlObject != null) {
    return urlObject;
  } else {
    throw Error('This browser doesn\'t seem to support blob URLs');
  }
};
goog.fs.url.findUrlObject_ = function() {
  if (goog.isDef(goog.global.URL) &&
      goog.isDef(goog.global.URL.createObjectURL)) {
    return  (goog.global.URL);
  } else if (goog.isDef(goog.global.webkitURL) &&
             goog.isDef(goog.global.webkitURL.createObjectURL)) {
    return  (goog.global.webkitURL);
  } else if (goog.isDef(goog.global.createObjectURL)) {
    return  (goog.global);
  } else {
    return null;
  }
};
goog.fs.url.browserSupportsObjectUrls = function() {
  return goog.fs.url.findUrlObject_() != null;
};

// goog.i18n.bidi
// goog.i18n.bidi.Dir
// goog.i18n.bidi.DirectionalString
// goog.i18n.bidi.Format
goog.provide('goog.i18n.bidi');
goog.provide('goog.i18n.bidi.Dir');
goog.provide('goog.i18n.bidi.DirectionalString');
goog.provide('goog.i18n.bidi.Format');
goog.define('goog.i18n.bidi.FORCE_RTL', false);
goog.i18n.bidi.IS_RTL = goog.i18n.bidi.FORCE_RTL ||
    (
        (goog.LOCALE.substring(0, 2).toLowerCase() == 'ar' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'fa' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'he' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'iw' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'ps' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'sd' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'ug' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'ur' ||
         goog.LOCALE.substring(0, 2).toLowerCase() == 'yi') &&
        (goog.LOCALE.length == 2 ||
         goog.LOCALE.substring(2, 3) == '-' ||
         goog.LOCALE.substring(2, 3) == '_')
    ) || (
        goog.LOCALE.length >= 3 &&
        goog.LOCALE.substring(0, 3).toLowerCase() == 'ckb' &&
        (goog.LOCALE.length == 3 ||
         goog.LOCALE.substring(3, 4) == '-' ||
         goog.LOCALE.substring(3, 4) == '_')
    );
goog.i18n.bidi.Format = {
  LRE: '\u202A',
  RLE: '\u202B',
  PDF: '\u202C',
  LRM: '\u200E',
  RLM: '\u200F'
};
goog.i18n.bidi.Dir = {
  LTR: 1,
  RTL: -1,
  NEUTRAL: 0
};
goog.i18n.bidi.RIGHT = 'right';
goog.i18n.bidi.LEFT = 'left';
goog.i18n.bidi.I18N_RIGHT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.LEFT :
    goog.i18n.bidi.RIGHT;
goog.i18n.bidi.I18N_LEFT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.RIGHT :
    goog.i18n.bidi.LEFT;
goog.i18n.bidi.toDir = function(givenDir, opt_noNeutral) {
  if (typeof givenDir == 'number') {
    return givenDir > 0 ? goog.i18n.bidi.Dir.LTR :
        givenDir < 0 ? goog.i18n.bidi.Dir.RTL :
        opt_noNeutral ? null : goog.i18n.bidi.Dir.NEUTRAL;
  } else if (givenDir == null) {
    return null;
  } else {
    return givenDir ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
  }
};
goog.i18n.bidi.ltrChars_ =
    'A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF' +
    '\u200E\u2C00-\uFB1C\uFE00-\uFE6F\uFEFD-\uFFFF';
goog.i18n.bidi.rtlChars_ =
    '\u0591-\u06EF\u06FA-\u07FF\u200F\uFB1D-\uFDFF\uFE70-\uFEFC';
goog.i18n.bidi.htmlSkipReg_ = /<[^>]*>|&[^;]+;/g;
goog.i18n.bidi.stripHtmlIfNeeded_ = function(str, opt_isStripNeeded) {
  return opt_isStripNeeded ? str.replace(goog.i18n.bidi.htmlSkipReg_, '') :
      str;
};
goog.i18n.bidi.rtlCharReg_ = new RegExp('[' + goog.i18n.bidi.rtlChars_ + ']');
goog.i18n.bidi.ltrCharReg_ = new RegExp('[' + goog.i18n.bidi.ltrChars_ + ']');
goog.i18n.bidi.hasAnyRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(
      str, opt_isHtml));
};
goog.i18n.bidi.hasRtlChar = goog.i18n.bidi.hasAnyRtl;
goog.i18n.bidi.hasAnyLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(
      str, opt_isHtml));
};
goog.i18n.bidi.ltrRe_ = new RegExp('^[' + goog.i18n.bidi.ltrChars_ + ']');
goog.i18n.bidi.rtlRe_ = new RegExp('^[' + goog.i18n.bidi.rtlChars_ + ']');
goog.i18n.bidi.isRtlChar = function(str) {
  return goog.i18n.bidi.rtlRe_.test(str);
};
goog.i18n.bidi.isLtrChar = function(str) {
  return goog.i18n.bidi.ltrRe_.test(str);
};
goog.i18n.bidi.isNeutralChar = function(str) {
  return !goog.i18n.bidi.isLtrChar(str) && !goog.i18n.bidi.isRtlChar(str);
};
goog.i18n.bidi.ltrDirCheckRe_ = new RegExp(
    '^[^' + goog.i18n.bidi.rtlChars_ + ']*[' + goog.i18n.bidi.ltrChars_ + ']');
goog.i18n.bidi.rtlDirCheckRe_ = new RegExp(
    '^[^' + goog.i18n.bidi.ltrChars_ + ']*[' + goog.i18n.bidi.rtlChars_ + ']');
goog.i18n.bidi.startsWithRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(
      str, opt_isHtml));
};
goog.i18n.bidi.isRtlText = goog.i18n.bidi.startsWithRtl;
goog.i18n.bidi.startsWithLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(
      str, opt_isHtml));
};
goog.i18n.bidi.isLtrText = goog.i18n.bidi.startsWithLtr;
goog.i18n.bidi.isRequiredLtrRe_ = /^http:\/\/.*/;
goog.i18n.bidi.isNeutralText = function(str, opt_isHtml) {
  str = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml);
  return goog.i18n.bidi.isRequiredLtrRe_.test(str) ||
      !goog.i18n.bidi.hasAnyLtr(str) && !goog.i18n.bidi.hasAnyRtl(str);
};
goog.i18n.bidi.ltrExitDirCheckRe_ = new RegExp(
    '[' + goog.i18n.bidi.ltrChars_ + '][^' + goog.i18n.bidi.rtlChars_ + ']*$');
goog.i18n.bidi.rtlExitDirCheckRe_ = new RegExp(
    '[' + goog.i18n.bidi.rtlChars_ + '][^' + goog.i18n.bidi.ltrChars_ + ']*$');
goog.i18n.bidi.endsWithLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrExitDirCheckRe_.test(
      goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isLtrExitText = goog.i18n.bidi.endsWithLtr;
goog.i18n.bidi.endsWithRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlExitDirCheckRe_.test(
      goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isRtlExitText = goog.i18n.bidi.endsWithRtl;
goog.i18n.bidi.rtlLocalesRe_ = new RegExp(
    '^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|' +
    '.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))' +
    '(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)',
    'i');
goog.i18n.bidi.isRtlLanguage = function(lang) {
  return goog.i18n.bidi.rtlLocalesRe_.test(lang);
};
goog.i18n.bidi.bracketGuardHtmlRe_ =
    /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(&lt;.*?(&gt;)+)/g;
goog.i18n.bidi.bracketGuardTextRe_ =
    /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(<.*?>+)/g;
goog.i18n.bidi.guardBracketInHtml = function(s, opt_isRtlContext) {
  var useRtl = opt_isRtlContext === undefined ?
      goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext;
  if (useRtl) {
    return s.replace(goog.i18n.bidi.bracketGuardHtmlRe_,
        '<span dir=rtl>$&</span>');
  }
  return s.replace(goog.i18n.bidi.bracketGuardHtmlRe_,
      '<span dir=ltr>$&</span>');
};
goog.i18n.bidi.guardBracketInText = function(s, opt_isRtlContext) {
  var useRtl = opt_isRtlContext === undefined ?
      goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext;
  var mark = useRtl ? goog.i18n.bidi.Format.RLM : goog.i18n.bidi.Format.LRM;
  return s.replace(goog.i18n.bidi.bracketGuardTextRe_, mark + '$&' + mark);
};
goog.i18n.bidi.enforceRtlInHtml = function(html) {
  if (html.charAt(0) == '<') {
    return html.replace(/<\w+/, '$& dir=rtl');
  }
  return '\n<span dir=rtl>' + html + '</span>';
};
goog.i18n.bidi.enforceRtlInText = function(text) {
  return goog.i18n.bidi.Format.RLE + text + goog.i18n.bidi.Format.PDF;
};
goog.i18n.bidi.enforceLtrInHtml = function(html) {
  if (html.charAt(0) == '<') {
    return html.replace(/<\w+/, '$& dir=ltr');
  }
  return '\n<span dir=ltr>' + html + '</span>';
};
goog.i18n.bidi.enforceLtrInText = function(text) {
  return goog.i18n.bidi.Format.LRE + text + goog.i18n.bidi.Format.PDF;
};
goog.i18n.bidi.dimensionsRe_ =
    /:\s*([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)/g;
goog.i18n.bidi.leftRe_ = /left/gi;
goog.i18n.bidi.rightRe_ = /right/gi;
goog.i18n.bidi.tempRe_ = /%%%%/g;
goog.i18n.bidi.mirrorCSS = function(cssStr) {
  return cssStr.
      replace(goog.i18n.bidi.dimensionsRe_, ':$1 $4 $3 $2').
      replace(goog.i18n.bidi.leftRe_, '%%%%').          // swap left and right
      replace(goog.i18n.bidi.rightRe_, goog.i18n.bidi.LEFT).
      replace(goog.i18n.bidi.tempRe_, goog.i18n.bidi.RIGHT);
};
goog.i18n.bidi.doubleQuoteSubstituteRe_ = /([\u0591-\u05f2])"/g;
goog.i18n.bidi.singleQuoteSubstituteRe_ = /([\u0591-\u05f2])'/g;
goog.i18n.bidi.normalizeHebrewQuote = function(str) {
  return str.
      replace(goog.i18n.bidi.doubleQuoteSubstituteRe_, '$1\u05f4').
      replace(goog.i18n.bidi.singleQuoteSubstituteRe_, '$1\u05f3');
};
goog.i18n.bidi.wordSeparatorRe_ = /\s+/;
goog.i18n.bidi.hasNumeralsRe_ = /[\d\u06f0-\u06f9]/;
goog.i18n.bidi.rtlDetectionThreshold_ = 0.40;
goog.i18n.bidi.estimateDirection = function(str, opt_isHtml) {
  var rtlCount = 0;
  var totalCount = 0;
  var hasWeaklyLtr = false;
  var tokens = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml).
      split(goog.i18n.bidi.wordSeparatorRe_);
  for (var i = 0; i < tokens.length; i++) {
    var token = tokens[i];
    if (goog.i18n.bidi.startsWithRtl(token)) {
      rtlCount++;
      totalCount++;
    } else if (goog.i18n.bidi.isRequiredLtrRe_.test(token)) {
      hasWeaklyLtr = true;
    } else if (goog.i18n.bidi.hasAnyLtr(token)) {
      totalCount++;
    } else if (goog.i18n.bidi.hasNumeralsRe_.test(token)) {
      hasWeaklyLtr = true;
    }
  }
  return totalCount == 0 ?
      (hasWeaklyLtr ? goog.i18n.bidi.Dir.LTR : goog.i18n.bidi.Dir.NEUTRAL) :
      (rtlCount / totalCount > goog.i18n.bidi.rtlDetectionThreshold_ ?
          goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR);
};
goog.i18n.bidi.detectRtlDirectionality = function(str, opt_isHtml) {
  return goog.i18n.bidi.estimateDirection(str, opt_isHtml) ==
      goog.i18n.bidi.Dir.RTL;
};
goog.i18n.bidi.setElementDirAndAlign = function(element, dir) {
  if (element) {
    dir = goog.i18n.bidi.toDir(dir);
    if (dir) {
      element.style.textAlign =
          dir == goog.i18n.bidi.Dir.RTL ?
          goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;
      element.dir = dir == goog.i18n.bidi.Dir.RTL ? 'rtl' : 'ltr';
    }
  }
};
goog.i18n.bidi.setElementDirByTextDirectionality = function(element, text) {
  switch (goog.i18n.bidi.estimateDirection(text)) {
    case (goog.i18n.bidi.Dir.LTR):
      element.dir = 'ltr';
      break;
    case (goog.i18n.bidi.Dir.RTL):
      element.dir = 'rtl';
      break;
    default:
      element.removeAttribute('dir');
  }
};
goog.i18n.bidi.DirectionalString = function() {};
goog.i18n.bidi.DirectionalString.prototype.
    implementsGoogI18nBidiDirectionalString;
goog.i18n.bidi.DirectionalString.prototype.getDirection;

// goog.html.SafeUrl
goog.provide('goog.html.SafeUrl');
goog.html.SafeUrl = function() {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = '';
  this.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ =
      goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeUrl.INNOCUOUS_STRING = 'about:invalid#zClosurez';
goog.html.SafeUrl.prototype.implementsGoogStringTypedString = true;
goog.html.SafeUrl.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
};
goog.html.SafeUrl.prototype.implementsGoogI18nBidiDirectionalString = true;
goog.html.SafeUrl.prototype.getDirection = function() {
  return goog.i18n.bidi.Dir.LTR;
};
if (goog.DEBUG) {
  goog.html.SafeUrl.prototype.toString = function() {
    return 'SafeUrl{' + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ +
        '}';
  };
}
goog.html.SafeUrl.unwrap = function(safeUrl) {
  if (safeUrl instanceof goog.html.SafeUrl &&
      safeUrl.constructor === goog.html.SafeUrl &&
      safeUrl.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ===
          goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeUrl.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
  } else {
    goog.asserts.fail('expected object of type SafeUrl, got \'' +
                      safeUrl + '\'');
    return 'type_error:SafeUrl';
  }
};
goog.html.SafeUrl.fromConstant = function(url) {
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(
      goog.string.Const.unwrap(url));
};
goog.html.SAFE_MIME_TYPE_PATTERN_ =
    /^(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm))$/i;
goog.html.SafeUrl.fromBlob = function(blob) {
  var url = goog.html.SAFE_MIME_TYPE_PATTERN_.test(blob.type) ?
      goog.fs.url.createObjectUrl(blob) : goog.html.SafeUrl.INNOCUOUS_STRING;
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.DATA_URL_PATTERN_ = /^data:([^;,]*);base64,[a-z0-9+\/]+=*$/i;
goog.html.SafeUrl.fromDataUrl = function(dataUrl) {
  var match = dataUrl.match(goog.html.DATA_URL_PATTERN_);
  var valid = match && goog.html.SAFE_MIME_TYPE_PATTERN_.test(match[1]);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(
      valid ? dataUrl : goog.html.SafeUrl.INNOCUOUS_STRING);
};
goog.html.SAFE_URL_PATTERN_ =
    /^(?:(?:https?|mailto|ftp):|[^&:/?#]*(?:[/?#]|$))/i;
goog.html.SafeUrl.sanitize = function(url) {
  if (url instanceof goog.html.SafeUrl) {
    return url;
  }
  else if (url.implementsGoogStringTypedString) {
    url = url.getTypedStringValue();
  } else {
    url = String(url);
  }
  if (!goog.html.SAFE_URL_PATTERN_.test(url)) {
    url = goog.html.SafeUrl.INNOCUOUS_STRING;
  }
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse = function(
    url) {
  var safeUrl = new goog.html.SafeUrl();
  safeUrl.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = url;
  return safeUrl;
};

// goog.html.TrustedResourceUrl
goog.provide('goog.html.TrustedResourceUrl');
goog.html.TrustedResourceUrl = function() {
  this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ = '';
  this.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ =
      goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.TrustedResourceUrl.prototype.implementsGoogStringTypedString = true;
goog.html.TrustedResourceUrl.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_;
};
goog.html.TrustedResourceUrl.prototype.implementsGoogI18nBidiDirectionalString =
    true;
goog.html.TrustedResourceUrl.prototype.getDirection = function() {
  return goog.i18n.bidi.Dir.LTR;
};
if (goog.DEBUG) {
  goog.html.TrustedResourceUrl.prototype.toString = function() {
    return 'TrustedResourceUrl{' +
        this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ + '}';
  };
}
goog.html.TrustedResourceUrl.unwrap = function(trustedResourceUrl) {
  if (trustedResourceUrl instanceof goog.html.TrustedResourceUrl &&
      trustedResourceUrl.constructor === goog.html.TrustedResourceUrl &&
      trustedResourceUrl
          .TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ===
              goog.html.TrustedResourceUrl
                  .TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return trustedResourceUrl
        .privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_;
  } else {
    goog.asserts.fail('expected object of type TrustedResourceUrl, got \'' +
                      trustedResourceUrl + '\'');
    return 'type_error:TrustedResourceUrl';
  }
};
goog.html.TrustedResourceUrl.fromConstant = function(url) {
  return goog.html.TrustedResourceUrl
      .createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(
          goog.string.Const.unwrap(url));
};
goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.TrustedResourceUrl.
    createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse = function(url) {
  var trustedResourceUrl = new goog.html.TrustedResourceUrl();
  trustedResourceUrl.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ =
      url;
  return trustedResourceUrl;
};

// goog.html.SafeHtml
goog.provide('goog.html.SafeHtml');
goog.html.SafeHtml = function() {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = '';
  this.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ =
      goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  this.dir_ = null;
};
goog.html.SafeHtml.prototype.implementsGoogI18nBidiDirectionalString = true;
goog.html.SafeHtml.prototype.getDirection = function() {
  return this.dir_;
};
goog.html.SafeHtml.prototype.implementsGoogStringTypedString = true;
goog.html.SafeHtml.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeHtml.prototype.toString = function() {
    return 'SafeHtml{' + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ +
        '}';
  };
}
goog.html.SafeHtml.unwrap = function(safeHtml) {
  if (safeHtml instanceof goog.html.SafeHtml &&
      safeHtml.constructor === goog.html.SafeHtml &&
      safeHtml.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ===
          goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeHtml.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
  } else {
    goog.asserts.fail('expected object of type SafeHtml, got \'' +
                      safeHtml + '\'');
    return 'type_error:SafeHtml';
  }
};
goog.html.SafeHtml.TextOrHtml_;
goog.html.SafeHtml.htmlEscape = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var dir = null;
  if (textOrHtml.implementsGoogI18nBidiDirectionalString) {
    dir = textOrHtml.getDirection();
  }
  var textAsString;
  if (textOrHtml.implementsGoogStringTypedString) {
    textAsString = textOrHtml.getTypedStringValue();
  } else {
    textAsString = String(textOrHtml);
  }
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
      goog.string.htmlEscape(textAsString), dir);
};
goog.html.SafeHtml.htmlEscapePreservingNewlines = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var html = goog.html.SafeHtml.htmlEscape(textOrHtml);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
      goog.string.newLineToBr(goog.html.SafeHtml.unwrap(html)),
      html.getDirection());
};
goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces = function(
    textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var html = goog.html.SafeHtml.htmlEscape(textOrHtml);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
      goog.string.whitespaceEscape(goog.html.SafeHtml.unwrap(html)),
      html.getDirection());
};
goog.html.SafeHtml.from = goog.html.SafeHtml.htmlEscape;
goog.html.SafeHtml.VALID_NAMES_IN_TAG_ = /^[a-zA-Z0-9-]+$/;
goog.html.SafeHtml.URL_ATTRIBUTES_ = goog.object.createSet('action', 'cite',
    'data', 'formaction', 'href', 'manifest', 'poster', 'src');
goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_ = goog.object.createSet(
    goog.dom.TagName.EMBED, goog.dom.TagName.IFRAME, goog.dom.TagName.LINK,
    goog.dom.TagName.OBJECT, goog.dom.TagName.SCRIPT, goog.dom.TagName.STYLE,
    goog.dom.TagName.TEMPLATE);
goog.html.SafeHtml.AttributeValue_;
goog.html.SafeHtml.create = function(tagName, opt_attributes, opt_content) {
  if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(tagName)) {
    throw Error('Invalid tag name <' + tagName + '>.');
  }
  if (tagName.toUpperCase() in goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_) {
    throw Error('Tag name <' + tagName + '> is not allowed for SafeHtml.');
  }
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(
      tagName, opt_attributes, opt_content);
};
goog.html.SafeHtml.createIframe = function(
    opt_src, opt_srcdoc, opt_attributes, opt_content) {
  var fixedAttributes = {};
  fixedAttributes['src'] = opt_src || null;
  fixedAttributes['srcdoc'] = opt_srcdoc || null;
  var defaultAttributes = {'sandbox': ''};
  var attributes = goog.html.SafeHtml.combineAttributes(
      fixedAttributes, defaultAttributes, opt_attributes);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(
      'iframe', attributes, opt_content);
};
goog.html.SafeHtml.createStyle = function(styleSheet, opt_attributes) {
  var fixedAttributes = {'type': 'text/css'};
  var defaultAttributes = {};
  var attributes = goog.html.SafeHtml.combineAttributes(
      fixedAttributes, defaultAttributes, opt_attributes);
  var content = '';
  styleSheet = goog.array.concat(styleSheet);
  for (var i = 0; i < styleSheet.length; i++) {
    content += goog.html.SafeStyleSheet.unwrap(styleSheet[i]);
  }
  var htmlContent = goog.html.SafeHtml
      .createSafeHtmlSecurityPrivateDoNotAccessOrElse(
          content, goog.i18n.bidi.Dir.NEUTRAL);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(
      'style', attributes, htmlContent);
};
goog.html.SafeHtml.getAttrNameAndValue_ = function(tagName, name, value) {
  if (value instanceof goog.string.Const) {
    value = goog.string.Const.unwrap(value);
  } else if (name.toLowerCase() == 'style') {
    value = goog.html.SafeHtml.getStyleValue_(value);
  } else if (/^on/i.test(name)) {
    throw Error('Attribute "' + name +
        '" requires goog.string.Const value, "' + value + '" given.');
  } else if (name.toLowerCase() in goog.html.SafeHtml.URL_ATTRIBUTES_) {
    if (value instanceof goog.html.TrustedResourceUrl) {
      value = goog.html.TrustedResourceUrl.unwrap(value);
    } else if (value instanceof goog.html.SafeUrl) {
      value = goog.html.SafeUrl.unwrap(value);
    } else if (goog.isString(value)) {
      value = goog.html.SafeUrl.sanitize(value).getTypedStringValue();
    } else {
      throw Error('Attribute "' + name + '" on tag "' + tagName +
          '" requires goog.html.SafeUrl, goog.string.Const, or string,' +
          ' value "' + value + '" given.');
    }
  }
  if (value.implementsGoogStringTypedString) {
    value = value.getTypedStringValue();
  }
  goog.asserts.assert(goog.isString(value) || goog.isNumber(value),
      'String or number value expected, got ' +
      (typeof value) + ' with value: ' + value);
  return name + '="' + goog.string.htmlEscape(String(value)) + '"';
};
goog.html.SafeHtml.getStyleValue_ = function(value) {
  if (!goog.isObject(value)) {
    throw Error('The "style" attribute requires goog.html.SafeStyle or map ' +
        'of style properties, ' + (typeof value) + ' given: ' + value);
  }
  if (!(value instanceof goog.html.SafeStyle)) {
    value = goog.html.SafeStyle.create(value);
  }
  return goog.html.SafeStyle.unwrap(value);
};
goog.html.SafeHtml.createWithDir = function(dir, tagName, opt_attributes,
    opt_content) {
  var html = goog.html.SafeHtml.create(tagName, opt_attributes, opt_content);
  html.dir_ = dir;
  return html;
};
goog.html.SafeHtml.concat = function(var_args) {
  var dir = goog.i18n.bidi.Dir.NEUTRAL;
  var content = '';
  var addArgument = function(argument) {
    if (goog.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      var html = goog.html.SafeHtml.htmlEscape(argument);
      content += goog.html.SafeHtml.unwrap(html);
      var htmlDir = html.getDirection();
      if (dir == goog.i18n.bidi.Dir.NEUTRAL) {
        dir = htmlDir;
      } else if (htmlDir != goog.i18n.bidi.Dir.NEUTRAL && dir != htmlDir) {
        dir = null;
      }
    }
  };
  goog.array.forEach(arguments, addArgument);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
      content, dir);
};
goog.html.SafeHtml.concatWithDir = function(dir, var_args) {
  var html = goog.html.SafeHtml.concat(goog.array.slice(arguments, 1));
  html.dir_ = dir;
  return html;
};
goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse = function(
    html, dir) {
  return new goog.html.SafeHtml().initSecurityPrivateDoNotAccessOrElse_(
      html, dir);
};
goog.html.SafeHtml.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(
    html, dir) {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = html;
  this.dir_ = dir;
  return this;
};
goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse =
    function(tagName, opt_attributes, opt_content) {
  var dir = null;
  var result = '<' + tagName;
  if (opt_attributes) {
    for (var name in opt_attributes) {
      if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(name)) {
        throw Error('Invalid attribute name "' + name + '".');
      }
      var value = opt_attributes[name];
      if (!goog.isDefAndNotNull(value)) {
        continue;
      }
      result += ' ' +
          goog.html.SafeHtml.getAttrNameAndValue_(tagName, name, value);
    }
  }
  var content = opt_content;
  if (!goog.isDefAndNotNull(content)) {
    content = [];
  } else if (!goog.isArray(content)) {
    content = [content];
  }
  if (goog.dom.tags.isVoidTag(tagName.toLowerCase())) {
    goog.asserts.assert(!content.length,
        'Void tag <' + tagName + '> does not allow content.');
    result += '>';
  } else {
    var html = goog.html.SafeHtml.concat(content);
    result += '>' + goog.html.SafeHtml.unwrap(html) + '</' + tagName + '>';
    dir = html.getDirection();
  }
  var dirAttribute = opt_attributes && opt_attributes['dir'];
  if (dirAttribute) {
    if (/^(ltr|rtl|auto)$/i.test(dirAttribute)) {
      dir = goog.i18n.bidi.Dir.NEUTRAL;
    } else {
      dir = null;
    }
  }
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
      result, dir);
};
goog.html.SafeHtml.combineAttributes = function(
    fixedAttributes, defaultAttributes, opt_attributes) {
  var combinedAttributes = {};
  var name;
  for (name in fixedAttributes) {
    goog.asserts.assert(name.toLowerCase() == name, 'Must be lower case');
    combinedAttributes[name] = fixedAttributes[name];
  }
  for (name in defaultAttributes) {
    goog.asserts.assert(name.toLowerCase() == name, 'Must be lower case');
    combinedAttributes[name] = defaultAttributes[name];
  }
  for (name in opt_attributes) {
    var nameLower = name.toLowerCase();
    if (nameLower in fixedAttributes) {
      throw Error('Cannot override "' + nameLower + '" attribute, got "' +
          name + '" with value "' + opt_attributes[name] + '"');
    }
    if (nameLower in defaultAttributes) {
      delete combinedAttributes[nameLower];
    }
    combinedAttributes[name] = opt_attributes[name];
  }
  return combinedAttributes;
};
goog.html.SafeHtml.DOCTYPE_HTML =
    goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
        '<!DOCTYPE html>', goog.i18n.bidi.Dir.NEUTRAL);
goog.html.SafeHtml.EMPTY =
    goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
        '', goog.i18n.bidi.Dir.NEUTRAL);

// goog.dom.safe
// goog.dom.safe.InsertAdjacentHtmlPosition
goog.provide('goog.dom.safe');
goog.provide('goog.dom.safe.InsertAdjacentHtmlPosition');
goog.dom.safe.InsertAdjacentHtmlPosition = {
  AFTERBEGIN: 'afterbegin',
  AFTEREND: 'afterend',
  BEFOREBEGIN: 'beforebegin',
  BEFOREEND: 'beforeend'
};
goog.dom.safe.insertAdjacentHtml = function(node, position, html) {
  node.insertAdjacentHTML(position, goog.html.SafeHtml.unwrap(html));
};
goog.dom.safe.setInnerHtml = function(elem, html) {
  elem.innerHTML = goog.html.SafeHtml.unwrap(html);
};
goog.dom.safe.setOuterHtml = function(elem, html) {
  elem.outerHTML = goog.html.SafeHtml.unwrap(html);
};
goog.dom.safe.documentWrite = function(doc, html) {
  doc.write(goog.html.SafeHtml.unwrap(html));
};
goog.dom.safe.setAnchorHref = function(anchor, url) {
  var safeUrl;
  if (url instanceof goog.html.SafeUrl) {
    safeUrl = url;
  } else {
    safeUrl = goog.html.SafeUrl.sanitize(url);
  }
  anchor.href = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setEmbedSrc = function(embed, url) {
  embed.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setFrameSrc = function(frame, url) {
  frame.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setIframeSrc = function(iframe, url) {
  iframe.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setLinkHrefAndRel = function(link, url, rel) {
  link.rel = rel;
  if (goog.string.caseInsensitiveContains(rel, 'stylesheet')) {
    goog.asserts.assert(
        url instanceof goog.html.TrustedResourceUrl,
        'URL must be TrustedResourceUrl because "rel" contains "stylesheet"');
    link.href = goog.html.TrustedResourceUrl.unwrap(url);
  } else if (url instanceof goog.html.TrustedResourceUrl) {
    link.href = goog.html.TrustedResourceUrl.unwrap(url);
  } else if (url instanceof goog.html.SafeUrl) {
    link.href = goog.html.SafeUrl.unwrap(url);
  } else {  // string
    link.href = goog.html.SafeUrl.sanitize(url).getTypedStringValue();
  }
};
goog.dom.safe.setObjectData = function(object, url) {
  object.data = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setScriptSrc = function(script, url) {
  script.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setLocationHref = function(loc, url) {
  var safeUrl;
  if (url instanceof goog.html.SafeUrl) {
    safeUrl = url;
  } else {
    safeUrl = goog.html.SafeUrl.sanitize(url);
  }
  loc.href = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.openInWindow = function(
    url, opt_openerWin, opt_name, opt_specs, opt_replace) {
  var safeUrl;
  if (url instanceof goog.html.SafeUrl) {
    safeUrl = url;
  } else {
    safeUrl = goog.html.SafeUrl.sanitize(url);
  }
  var win = opt_openerWin || window;
  return win.open(goog.html.SafeUrl.unwrap(safeUrl),
      opt_name ? goog.string.Const.unwrap(opt_name) : '',
      opt_specs, opt_replace);
};

// goog.math
goog.provide('goog.math');
goog.math.randomInt = function(a) {
  return Math.floor(Math.random() * a);
};
goog.math.uniformRandom = function(a, b) {
  return a + Math.random() * (b - a);
};
goog.math.clamp = function(value, min, max) {
  return Math.min(Math.max(value, min), max);
};
goog.math.modulo = function(a, b) {
  var r = a % b;
  return (r * b < 0) ? r + b : r;
};
goog.math.lerp = function(a, b, x) {
  return a + x * (b - a);
};
goog.math.nearlyEquals = function(a, b, opt_tolerance) {
  return Math.abs(a - b) <= (opt_tolerance || 0.000001);
};
goog.math.standardAngle = function(angle) {
  return goog.math.modulo(angle, 360);
};
goog.math.standardAngleInRadians = function(angle) {
  return goog.math.modulo(angle, 2 * Math.PI);
};
goog.math.toRadians = function(angleDegrees) {
  return angleDegrees * Math.PI / 180;
};
goog.math.toDegrees = function(angleRadians) {
  return angleRadians * 180 / Math.PI;
};
goog.math.angleDx = function(degrees, radius) {
  return radius * Math.cos(goog.math.toRadians(degrees));
};
goog.math.angleDy = function(degrees, radius) {
  return radius * Math.sin(goog.math.toRadians(degrees));
};
goog.math.angle = function(x1, y1, x2, y2) {
  return goog.math.standardAngle(goog.math.toDegrees(Math.atan2(y2 - y1,
                                                                x2 - x1)));
};
goog.math.angleDifference = function(startAngle, endAngle) {
  var d = goog.math.standardAngle(endAngle) -
          goog.math.standardAngle(startAngle);
  if (d > 180) {
    d = d - 360;
  } else if (d <= -180) {
    d = 360 + d;
  }
  return d;
};
goog.math.sign = Math.sign || function(x) {
  if (x > 0) {
    return 1;
  }
  if (x < 0) {
    return -1;
  }
  return x;  // Preserves signed zeros and NaN.
};
goog.math.longestCommonSubsequence = function(
    array1, array2, opt_compareFn, opt_collectorFn) {
  var compare = opt_compareFn || function(a, b) {
    return a == b;
  };
  var collect = opt_collectorFn || function(i1, i2) {
    return array1[i1];
  };
  var length1 = array1.length;
  var length2 = array2.length;
  var arr = [];
  for (var i = 0; i < length1 + 1; i++) {
    arr[i] = [];
    arr[i][0] = 0;
  }
  for (var j = 0; j < length2 + 1; j++) {
    arr[0][j] = 0;
  }
  for (i = 1; i <= length1; i++) {
    for (j = 1; j <= length2; j++) {
      if (compare(array1[i - 1], array2[j - 1])) {
        arr[i][j] = arr[i - 1][j - 1] + 1;
      } else {
        arr[i][j] = Math.max(arr[i - 1][j], arr[i][j - 1]);
      }
    }
  }
  var result = [];
  var i = length1, j = length2;
  while (i > 0 && j > 0) {
    if (compare(array1[i - 1], array2[j - 1])) {
      result.unshift(collect(i - 1, j - 1));
      i--;
      j--;
    } else {
      if (arr[i - 1][j] > arr[i][j - 1]) {
        i--;
      } else {
        j--;
      }
    }
  }
  return result;
};
goog.math.sum = function(var_args) {
  return  (goog.array.reduce(arguments,
      function(sum, value) {
        return sum + value;
      }, 0));
};
goog.math.average = function(var_args) {
  return goog.math.sum.apply(null, arguments) / arguments.length;
};
goog.math.sampleVariance = function(var_args) {
  var sampleSize = arguments.length;
  if (sampleSize < 2) {
    return 0;
  }
  var mean = goog.math.average.apply(null, arguments);
  var variance = goog.math.sum.apply(null, goog.array.map(arguments,
      function(val) {
        return Math.pow(val - mean, 2);
      })) / (sampleSize - 1);
  return variance;
};
goog.math.standardDeviation = function(var_args) {
  return Math.sqrt(goog.math.sampleVariance.apply(null, arguments));
};
goog.math.isInt = function(num) {
  return isFinite(num) && num % 1 == 0;
};
goog.math.isFiniteNumber = function(num) {
  return isFinite(num) && !isNaN(num);
};
goog.math.isNegativeZero = function(num) {
  return num == 0 && 1 / num < 0;
};
goog.math.log10Floor = function(num) {
  if (num > 0) {
    var x = Math.round(Math.log(num) * Math.LOG10E);
    return x - (parseFloat('1e' + x) > num);
  }
  return num == 0 ? -Infinity : NaN;
};
goog.math.safeFloor = function(num, opt_epsilon) {
  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon > 0);
  return Math.floor(num + (opt_epsilon || 2e-15));
};
goog.math.safeCeil = function(num, opt_epsilon) {
  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon > 0);
  return Math.ceil(num - (opt_epsilon || 2e-15));
};

// goog.math.Coordinate
goog.provide('goog.math.Coordinate');
goog.math.Coordinate = function(opt_x, opt_y) {
  this.x = goog.isDef(opt_x) ? opt_x : 0;
  this.y = goog.isDef(opt_y) ? opt_y : 0;
};
goog.math.Coordinate.prototype.clone = function() {
  return new goog.math.Coordinate(this.x, this.y);
};
if (goog.DEBUG) {
  goog.math.Coordinate.prototype.toString = function() {
    return '(' + this.x + ', ' + this.y + ')';
  };
}
goog.math.Coordinate.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.x == b.x && a.y == b.y;
};
goog.math.Coordinate.distance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return Math.sqrt(dx * dx + dy * dy);
};
goog.math.Coordinate.magnitude = function(a) {
  return Math.sqrt(a.x * a.x + a.y * a.y);
};
goog.math.Coordinate.azimuth = function(a) {
  return goog.math.angle(0, 0, a.x, a.y);
};
goog.math.Coordinate.squaredDistance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return dx * dx + dy * dy;
};
goog.math.Coordinate.difference = function(a, b) {
  return new goog.math.Coordinate(a.x - b.x, a.y - b.y);
};
goog.math.Coordinate.sum = function(a, b) {
  return new goog.math.Coordinate(a.x + b.x, a.y + b.y);
};
goog.math.Coordinate.prototype.ceil = function() {
  this.x = Math.ceil(this.x);
  this.y = Math.ceil(this.y);
  return this;
};
goog.math.Coordinate.prototype.floor = function() {
  this.x = Math.floor(this.x);
  this.y = Math.floor(this.y);
  return this;
};
goog.math.Coordinate.prototype.round = function() {
  this.x = Math.round(this.x);
  this.y = Math.round(this.y);
  return this;
};
goog.math.Coordinate.prototype.translate = function(tx, opt_ty) {
  if (tx instanceof goog.math.Coordinate) {
    this.x += tx.x;
    this.y += tx.y;
  } else {
    this.x += tx;
    if (goog.isNumber(opt_ty)) {
      this.y += opt_ty;
    }
  }
  return this;
};
goog.math.Coordinate.prototype.scale = function(sx, opt_sy) {
  var sy = goog.isNumber(opt_sy) ? opt_sy : sx;
  this.x *= sx;
  this.y *= sy;
  return this;
};
goog.math.Coordinate.prototype.rotateRadians = function(radians, opt_center) {
  var center = opt_center || new goog.math.Coordinate(0, 0);
  var x = this.x;
  var y = this.y;
  var cos = Math.cos(radians);
  var sin = Math.sin(radians);
  this.x = (x - center.x) * cos - (y - center.y) * sin + center.x;
  this.y = (x - center.x) * sin + (y - center.y) * cos + center.y;
};
goog.math.Coordinate.prototype.rotateDegrees = function(degrees, opt_center) {
  this.rotateRadians(goog.math.toRadians(degrees), opt_center);
};

// goog.math.Size
goog.provide('goog.math.Size');
goog.math.Size = function(width, height) {
  this.width = width;
  this.height = height;
};
goog.math.Size.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.width == b.width && a.height == b.height;
};
goog.math.Size.prototype.clone = function() {
  return new goog.math.Size(this.width, this.height);
};
if (goog.DEBUG) {
  goog.math.Size.prototype.toString = function() {
    return '(' + this.width + ' x ' + this.height + ')';
  };
}
goog.math.Size.prototype.getLongest = function() {
  return Math.max(this.width, this.height);
};
goog.math.Size.prototype.getShortest = function() {
  return Math.min(this.width, this.height);
};
goog.math.Size.prototype.area = function() {
  return this.width * this.height;
};
goog.math.Size.prototype.perimeter = function() {
  return (this.width + this.height) * 2;
};
goog.math.Size.prototype.aspectRatio = function() {
  return this.width / this.height;
};
goog.math.Size.prototype.isEmpty = function() {
  return !this.area();
};
goog.math.Size.prototype.ceil = function() {
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this;
};
goog.math.Size.prototype.fitsInside = function(target) {
  return this.width <= target.width && this.height <= target.height;
};
goog.math.Size.prototype.floor = function() {
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this;
};
goog.math.Size.prototype.round = function() {
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this;
};
goog.math.Size.prototype.scale = function(sx, opt_sy) {
  var sy = goog.isNumber(opt_sy) ? opt_sy : sx;
  this.width *= sx;
  this.height *= sy;
  return this;
};
goog.math.Size.prototype.scaleToCover = function(target) {
  var s = this.aspectRatio() <= target.aspectRatio() ?
      target.width / this.width :
      target.height / this.height;
  return this.scale(s);
};
goog.math.Size.prototype.scaleToFit = function(target) {
  var s = this.aspectRatio() > target.aspectRatio() ?
      target.width / this.width :
      target.height / this.height;
  return this.scale(s);
};

// goog.dom
// goog.dom.Appendable
// goog.dom.DomHelper
goog.provide('goog.dom');
goog.provide('goog.dom.Appendable');
goog.provide('goog.dom.DomHelper');
goog.define('goog.dom.ASSUME_QUIRKS_MODE', false);
goog.define('goog.dom.ASSUME_STANDARDS_MODE', false);
goog.dom.COMPAT_MODE_KNOWN_ =
    goog.dom.ASSUME_QUIRKS_MODE || goog.dom.ASSUME_STANDARDS_MODE;
goog.dom.getDomHelper = function(opt_element) {
  return opt_element ?
      new goog.dom.DomHelper(goog.dom.getOwnerDocument(opt_element)) :
      (goog.dom.defaultDomHelper_ ||
          (goog.dom.defaultDomHelper_ = new goog.dom.DomHelper()));
};
goog.dom.defaultDomHelper_;
goog.dom.getDocument = function() {
  return document;
};
goog.dom.getElement = function(element) {
  return goog.dom.getElementHelper_(document, element);
};
goog.dom.getElementHelper_ = function(doc, element) {
  return goog.isString(element) ?
      doc.getElementById(element) :
      element;
};
goog.dom.getRequiredElement = function(id) {
  return goog.dom.getRequiredElementHelper_(document, id);
};
goog.dom.getRequiredElementHelper_ = function(doc, id) {
  goog.asserts.assertString(id);
  var element = goog.dom.getElementHelper_(doc, id);
  element = goog.asserts.assertElement(element,
      'No element found with id: ' + id);
  return element;
};
goog.dom.$ = goog.dom.getElement;
goog.dom.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(document, opt_tag, opt_class,
                                                opt_el);
};
goog.dom.getElementsByClass = function(className, opt_el) {
  var parent = opt_el || document;
  if (goog.dom.canUseQuerySelector_(parent)) {
    return parent.querySelectorAll('.' + className);
  }
  return goog.dom.getElementsByTagNameAndClass_(
      document, '*', className, opt_el);
};
goog.dom.getElementByClass = function(className, opt_el) {
  var parent = opt_el || document;
  var retVal = null;
  if (parent.getElementsByClassName) {
    retVal = parent.getElementsByClassName(className)[0];
  } else if (goog.dom.canUseQuerySelector_(parent)) {
    retVal = parent.querySelector('.' + className);
  } else {
    retVal = goog.dom.getElementsByTagNameAndClass_(
        document, '*', className, opt_el)[0];
  }
  return retVal || null;
};
goog.dom.getRequiredElementByClass = function(className, opt_root) {
  var retValue = goog.dom.getElementByClass(className, opt_root);
  return goog.asserts.assert(retValue,
      'No element found with className: ' + className);
};
goog.dom.canUseQuerySelector_ = function(parent) {
  return !!(parent.querySelectorAll && parent.querySelector);
};
goog.dom.getElementsByTagNameAndClass_ = function(doc, opt_tag, opt_class,
                                                  opt_el) {
  var parent = opt_el || doc;
  var tagName = (opt_tag && opt_tag != '*') ? opt_tag.toUpperCase() : '';
  if (goog.dom.canUseQuerySelector_(parent) &&
      (tagName || opt_class)) {
    var query = tagName + (opt_class ? '.' + opt_class : '');
    return parent.querySelectorAll(query);
  }
  if (opt_class && parent.getElementsByClassName) {
    var els = parent.getElementsByClassName(opt_class);
    if (tagName) {
      var arrayLike = {};
      var len = 0;
      for (var i = 0, el; el = els[i]; i++) {
        if (tagName == el.nodeName) {
          arrayLike[len++] = el;
        }
      }
      arrayLike.length = len;
      return arrayLike;
    } else {
      return els;
    }
  }
  var els = parent.getElementsByTagName(tagName || '*');
  if (opt_class) {
    var arrayLike = {};
    var len = 0;
    for (var i = 0, el; el = els[i]; i++) {
      var className = el.className;
      if (typeof className.split == 'function' &&
          goog.array.contains(className.split(/\s+/), opt_class)) {
        arrayLike[len++] = el;
      }
    }
    arrayLike.length = len;
    return arrayLike;
  } else {
    return els;
  }
};
goog.dom.$$ = goog.dom.getElementsByTagNameAndClass;
goog.dom.setProperties = function(element, properties) {
  goog.object.forEach(properties, function(val, key) {
    if (key == 'style') {
      element.style.cssText = val;
    } else if (key == 'class') {
      element.className = val;
    } else if (key == 'for') {
      element.htmlFor = val;
    } else if (goog.dom.DIRECT_ATTRIBUTE_MAP_.hasOwnProperty(key)) {
      element.setAttribute(goog.dom.DIRECT_ATTRIBUTE_MAP_[key], val);
    } else if (goog.string.startsWith(key, 'aria-') ||
        goog.string.startsWith(key, 'data-')) {
      element.setAttribute(key, val);
    } else {
      element[key] = val;
    }
  });
};
goog.dom.DIRECT_ATTRIBUTE_MAP_ = {
  'cellpadding': 'cellPadding',
  'cellspacing': 'cellSpacing',
  'colspan': 'colSpan',
  'frameborder': 'frameBorder',
  'height': 'height',
  'maxlength': 'maxLength',
  'role': 'role',
  'rowspan': 'rowSpan',
  'type': 'type',
  'usemap': 'useMap',
  'valign': 'vAlign',
  'width': 'width'
};
goog.dom.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize_(opt_window || window);
};
goog.dom.getViewportSize_ = function(win) {
  var doc = win.document;
  var el = goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body;
  return new goog.math.Size(el.clientWidth, el.clientHeight);
};
goog.dom.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(window);
};
goog.dom.getDocumentHeight_ = function(win) {
  var doc = win.document;
  var height = 0;
  if (doc) {
    var body = doc.body;
    var docEl =  (doc.documentElement);
    if (!(docEl && body)) {
      return 0;
    }
    var vh = goog.dom.getViewportSize_(win).height;
    if (goog.dom.isCss1CompatMode_(doc) && docEl.scrollHeight) {
      height = docEl.scrollHeight != vh ?
          docEl.scrollHeight : docEl.offsetHeight;
    } else {
      var sh = docEl.scrollHeight;
      var oh = docEl.offsetHeight;
      if (docEl.clientHeight != oh) {
        sh = body.scrollHeight;
        oh = body.offsetHeight;
      }
      if (sh > vh) {
        height = sh > oh ? sh : oh;
      } else {
        height = sh < oh ? sh : oh;
      }
    }
  }
  return height;
};
goog.dom.getPageScroll = function(opt_window) {
  var win = opt_window || goog.global || window;
  return goog.dom.getDomHelper(win.document).getDocumentScroll();
};
goog.dom.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(document);
};
goog.dom.getDocumentScroll_ = function(doc) {
  var el = goog.dom.getDocumentScrollElement_(doc);
  var win = goog.dom.getWindow_(doc);
  if (goog.userAgent.IE && goog.userAgent.isVersionOrHigher('10') &&
      win.pageYOffset != el.scrollTop) {
    return new goog.math.Coordinate(el.scrollLeft, el.scrollTop);
  }
  return new goog.math.Coordinate(win.pageXOffset || el.scrollLeft,
      win.pageYOffset || el.scrollTop);
};
goog.dom.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(document);
};
goog.dom.getDocumentScrollElement_ = function(doc) {
  if (doc.scrollingElement) {
    return doc.scrollingElement;
  }
  if (!goog.userAgent.WEBKIT && goog.dom.isCss1CompatMode_(doc)) {
    return doc.documentElement;
  }
  return doc.body || doc.documentElement;
};
goog.dom.getWindow = function(opt_doc) {
  return opt_doc ? goog.dom.getWindow_(opt_doc) : window;
};
goog.dom.getWindow_ = function(doc) {
  return doc.parentWindow || doc.defaultView;
};
goog.dom.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(document, arguments);
};
goog.dom.createDom_ = function(doc, args) {
  var tagName = args[0];
  var attributes = args[1];
  if (!goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES && attributes &&
      (attributes.name || attributes.type)) {
    var tagNameArr = ['<', tagName];
    if (attributes.name) {
      tagNameArr.push(' name="', goog.string.htmlEscape(attributes.name),
                      '"');
    }
    if (attributes.type) {
      tagNameArr.push(' type="', goog.string.htmlEscape(attributes.type),
                      '"');
      var clone = {};
      goog.object.extend(clone, attributes);
      delete clone['type'];
      attributes = clone;
    }
    tagNameArr.push('>');
    tagName = tagNameArr.join('');
  }
  var element = doc.createElement(tagName);
  if (attributes) {
    if (goog.isString(attributes)) {
      element.className = attributes;
    } else if (goog.isArray(attributes)) {
      element.className = attributes.join(' ');
    } else {
      goog.dom.setProperties(element, attributes);
    }
  }
  if (args.length > 2) {
    goog.dom.append_(doc, element, args, 2);
  }
  return element;
};
goog.dom.append_ = function(doc, parent, args, startIndex) {
  function childHandler(child) {
    if (child) {
      parent.appendChild(goog.isString(child) ?
          doc.createTextNode(child) : child);
    }
  }
  for (var i = startIndex; i < args.length; i++) {
    var arg = args[i];
    if (goog.isArrayLike(arg) && !goog.dom.isNodeLike(arg)) {
      goog.array.forEach(goog.dom.isNodeList(arg) ?
          goog.array.toArray(arg) : arg,
          childHandler);
    } else {
      childHandler(arg);
    }
  }
};
goog.dom.$dom = goog.dom.createDom;
goog.dom.createElement = function(name) {
  return document.createElement(name);
};
goog.dom.createTextNode = function(content) {
  return document.createTextNode(String(content));
};
goog.dom.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(document, rows, columns, !!opt_fillWithNbsp);
};
goog.dom.createTable_ = function(doc, rows, columns, fillWithNbsp) {
  var table = 
      (doc.createElement(goog.dom.TagName.TABLE));
  var tbody = table.appendChild(doc.createElement(goog.dom.TagName.TBODY));
  for (var i = 0; i < rows; i++) {
    var tr = doc.createElement(goog.dom.TagName.TR);
    for (var j = 0; j < columns; j++) {
      var td = doc.createElement(goog.dom.TagName.TD);
      if (fillWithNbsp) {
        goog.dom.setTextContent(td, goog.string.Unicode.NBSP);
      }
      tr.appendChild(td);
    }
    tbody.appendChild(tr);
  }
  return table;
};
goog.dom.safeHtmlToNode = function(html) {
  return goog.dom.safeHtmlToNode_(document, html);
};
goog.dom.safeHtmlToNode_ = function(doc, html) {
  var tempDiv = doc.createElement(goog.dom.TagName.DIV);
  if (goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    goog.dom.safe.setInnerHtml(tempDiv,
        goog.html.SafeHtml.concat(goog.html.SafeHtml.create('br'), html));
    tempDiv.removeChild(tempDiv.firstChild);
  } else {
    goog.dom.safe.setInnerHtml(tempDiv, html);
  }
  return goog.dom.childrenToNode_(doc, tempDiv);
};
goog.dom.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(document, htmlString);
};
goog.dom.htmlToDocumentFragment_ = function(doc, htmlString) {
  var tempDiv = doc.createElement(goog.dom.TagName.DIV);
  if (goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    tempDiv.innerHTML = '<br>' + htmlString;
    tempDiv.removeChild(tempDiv.firstChild);
  } else {
    tempDiv.innerHTML = htmlString;
  }
  return goog.dom.childrenToNode_(doc, tempDiv);
};
goog.dom.childrenToNode_ = function(doc, tempDiv) {
  if (tempDiv.childNodes.length == 1) {
    return tempDiv.removeChild(tempDiv.firstChild);
  } else {
    var fragment = doc.createDocumentFragment();
    while (tempDiv.firstChild) {
      fragment.appendChild(tempDiv.firstChild);
    }
    return fragment;
  }
};
goog.dom.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(document);
};
goog.dom.isCss1CompatMode_ = function(doc) {
  if (goog.dom.COMPAT_MODE_KNOWN_) {
    return goog.dom.ASSUME_STANDARDS_MODE;
  }
  return doc.compatMode == 'CSS1Compat';
};
goog.dom.canHaveChildren = function(node) {
  if (node.nodeType != goog.dom.NodeType.ELEMENT) {
    return false;
  }
  switch ( (node).tagName) {
    case goog.dom.TagName.APPLET:
    case goog.dom.TagName.AREA:
    case goog.dom.TagName.BASE:
    case goog.dom.TagName.BR:
    case goog.dom.TagName.COL:
    case goog.dom.TagName.COMMAND:
    case goog.dom.TagName.EMBED:
    case goog.dom.TagName.FRAME:
    case goog.dom.TagName.HR:
    case goog.dom.TagName.IMG:
    case goog.dom.TagName.INPUT:
    case goog.dom.TagName.IFRAME:
    case goog.dom.TagName.ISINDEX:
    case goog.dom.TagName.KEYGEN:
    case goog.dom.TagName.LINK:
    case goog.dom.TagName.NOFRAMES:
    case goog.dom.TagName.NOSCRIPT:
    case goog.dom.TagName.META:
    case goog.dom.TagName.OBJECT:
    case goog.dom.TagName.PARAM:
    case goog.dom.TagName.SCRIPT:
    case goog.dom.TagName.SOURCE:
    case goog.dom.TagName.STYLE:
    case goog.dom.TagName.TRACK:
    case goog.dom.TagName.WBR:
      return false;
  }
  return true;
};
goog.dom.appendChild = function(parent, child) {
  parent.appendChild(child);
};
goog.dom.append = function(parent, var_args) {
  goog.dom.append_(goog.dom.getOwnerDocument(parent), parent, arguments, 1);
};
goog.dom.removeChildren = function(node) {
  var child;
  while ((child = node.firstChild)) {
    node.removeChild(child);
  }
};
goog.dom.insertSiblingBefore = function(newNode, refNode) {
  if (refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode);
  }
};
goog.dom.insertSiblingAfter = function(newNode, refNode) {
  if (refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode.nextSibling);
  }
};
goog.dom.insertChildAt = function(parent, child, index) {
  parent.insertBefore(child, parent.childNodes[index] || null);
};
goog.dom.removeNode = function(node) {
  return node && node.parentNode ? node.parentNode.removeChild(node) : null;
};
goog.dom.replaceNode = function(newNode, oldNode) {
  var parent = oldNode.parentNode;
  if (parent) {
    parent.replaceChild(newNode, oldNode);
  }
};
goog.dom.flattenElement = function(element) {
  var child, parent = element.parentNode;
  if (parent && parent.nodeType != goog.dom.NodeType.DOCUMENT_FRAGMENT) {
    if (element.removeNode) {
      return  (element.removeNode(false));
    } else {
      while ((child = element.firstChild)) {
        parent.insertBefore(child, element);
      }
      return  (goog.dom.removeNode(element));
    }
  }
};
goog.dom.getChildren = function(element) {
  if (goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE &&
      element.children != undefined) {
    return element.children;
  }
  return goog.array.filter(element.childNodes, function(node) {
    return node.nodeType == goog.dom.NodeType.ELEMENT;
  });
};
goog.dom.getFirstElementChild = function(node) {
  if (goog.isDef(node.firstElementChild)) {
    return (node).firstElementChild;
  }
  return goog.dom.getNextElementNode_(node.firstChild, true);
};
goog.dom.getLastElementChild = function(node) {
  if (goog.isDef(node.lastElementChild)) {
    return (node).lastElementChild;
  }
  return goog.dom.getNextElementNode_(node.lastChild, false);
};
goog.dom.getNextElementSibling = function(node) {
  if (goog.isDef(node.nextElementSibling)) {
    return (node).nextElementSibling;
  }
  return goog.dom.getNextElementNode_(node.nextSibling, true);
};
goog.dom.getPreviousElementSibling = function(node) {
  if (goog.isDef(node.previousElementSibling)) {
    return (node).previousElementSibling;
  }
  return goog.dom.getNextElementNode_(node.previousSibling, false);
};
goog.dom.getNextElementNode_ = function(node, forward) {
  while (node && node.nodeType != goog.dom.NodeType.ELEMENT) {
    node = forward ? node.nextSibling : node.previousSibling;
  }
  return  (node);
};
goog.dom.getNextNode = function(node) {
  if (!node) {
    return null;
  }
  if (node.firstChild) {
    return node.firstChild;
  }
  while (node && !node.nextSibling) {
    node = node.parentNode;
  }
  return node ? node.nextSibling : null;
};
goog.dom.getPreviousNode = function(node) {
  if (!node) {
    return null;
  }
  if (!node.previousSibling) {
    return node.parentNode;
  }
  node = node.previousSibling;
  while (node && node.lastChild) {
    node = node.lastChild;
  }
  return node;
};
goog.dom.isNodeLike = function(obj) {
  return goog.isObject(obj) && obj.nodeType > 0;
};
goog.dom.isElement = function(obj) {
  return goog.isObject(obj) && obj.nodeType == goog.dom.NodeType.ELEMENT;
};
goog.dom.isWindow = function(obj) {
  return goog.isObject(obj) && obj['window'] == obj;
};
goog.dom.getParentElement = function(element) {
  var parent;
  if (goog.dom.BrowserFeature.CAN_USE_PARENT_ELEMENT_PROPERTY) {
    var isIe9 = goog.userAgent.IE &&
        goog.userAgent.isVersionOrHigher('9') &&
        !goog.userAgent.isVersionOrHigher('10');
    if (!(isIe9 && goog.global['SVGElement'] &&
        element instanceof goog.global['SVGElement'])) {
      parent = element.parentElement;
      if (parent) {
        return parent;
      }
    }
  }
  parent = element.parentNode;
  return goog.dom.isElement(parent) ?  (parent) : null;
};
goog.dom.contains = function(parent, descendant) {
  if (parent.contains && descendant.nodeType == goog.dom.NodeType.ELEMENT) {
    return parent == descendant || parent.contains(descendant);
  }
  if (typeof parent.compareDocumentPosition != 'undefined') {
    return parent == descendant ||
        Boolean(parent.compareDocumentPosition(descendant) & 16);
  }
  while (descendant && parent != descendant) {
    descendant = descendant.parentNode;
  }
  return descendant == parent;
};
goog.dom.compareNodeOrder = function(node1, node2) {
  if (node1 == node2) {
    return 0;
  }
  if (node1.compareDocumentPosition) {
    return node1.compareDocumentPosition(node2) & 2 ? 1 : -1;
  }
  if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9)) {
    if (node1.nodeType == goog.dom.NodeType.DOCUMENT) {
      return -1;
    }
    if (node2.nodeType == goog.dom.NodeType.DOCUMENT) {
      return 1;
    }
  }
  if ('sourceIndex' in node1 ||
      (node1.parentNode && 'sourceIndex' in node1.parentNode)) {
    var isElement1 = node1.nodeType == goog.dom.NodeType.ELEMENT;
    var isElement2 = node2.nodeType == goog.dom.NodeType.ELEMENT;
    if (isElement1 && isElement2) {
      return node1.sourceIndex - node2.sourceIndex;
    } else {
      var parent1 = node1.parentNode;
      var parent2 = node2.parentNode;
      if (parent1 == parent2) {
        return goog.dom.compareSiblingOrder_(node1, node2);
      }
      if (!isElement1 && goog.dom.contains(parent1, node2)) {
        return -1 * goog.dom.compareParentsDescendantNodeIe_(node1, node2);
      }
      if (!isElement2 && goog.dom.contains(parent2, node1)) {
        return goog.dom.compareParentsDescendantNodeIe_(node2, node1);
      }
      return (isElement1 ? node1.sourceIndex : parent1.sourceIndex) -
             (isElement2 ? node2.sourceIndex : parent2.sourceIndex);
    }
  }
  var doc = goog.dom.getOwnerDocument(node1);
  var range1, range2;
  range1 = doc.createRange();
  range1.selectNode(node1);
  range1.collapse(true);
  range2 = doc.createRange();
  range2.selectNode(node2);
  range2.collapse(true);
  return range1.compareBoundaryPoints(goog.global['Range'].START_TO_END,
      range2);
};
goog.dom.compareParentsDescendantNodeIe_ = function(textNode, node) {
  var parent = textNode.parentNode;
  if (parent == node) {
    return -1;
  }
  var sibling = node;
  while (sibling.parentNode != parent) {
    sibling = sibling.parentNode;
  }
  return goog.dom.compareSiblingOrder_(sibling, textNode);
};
goog.dom.compareSiblingOrder_ = function(node1, node2) {
  var s = node2;
  while ((s = s.previousSibling)) {
    if (s == node1) {
      return -1;
    }
  }
  return 1;
};
goog.dom.findCommonAncestor = function(var_args) {
  var i, count = arguments.length;
  if (!count) {
    return null;
  } else if (count == 1) {
    return arguments[0];
  }
  var paths = [];
  var minLength = Infinity;
  for (i = 0; i < count; i++) {
    var ancestors = [];
    var node = arguments[i];
    while (node) {
      ancestors.unshift(node);
      node = node.parentNode;
    }
    paths.push(ancestors);
    minLength = Math.min(minLength, ancestors.length);
  }
  var output = null;
  for (i = 0; i < minLength; i++) {
    var first = paths[0][i];
    for (var j = 1; j < count; j++) {
      if (first != paths[j][i]) {
        return output;
      }
    }
    output = first;
  }
  return output;
};
goog.dom.getOwnerDocument = function(node) {
  goog.asserts.assert(node, 'Node cannot be null or undefined.');
  return  (
      node.nodeType == goog.dom.NodeType.DOCUMENT ? node :
      node.ownerDocument || node.document);
};
goog.dom.getFrameContentDocument = function(frame) {
  var doc = frame.contentDocument || frame.contentWindow.document;
  return doc;
};
goog.dom.getFrameContentWindow = function(frame) {
  return frame.contentWindow ||
      goog.dom.getWindow(goog.dom.getFrameContentDocument(frame));
};
goog.dom.setTextContent = function(node, text) {
  goog.asserts.assert(node != null,
      'goog.dom.setTextContent expects a non-null value for node');
  if ('textContent' in node) {
    node.textContent = text;
  } else if (node.nodeType == goog.dom.NodeType.TEXT) {
    node.data = text;
  } else if (node.firstChild &&
             node.firstChild.nodeType == goog.dom.NodeType.TEXT) {
    while (node.lastChild != node.firstChild) {
      node.removeChild(node.lastChild);
    }
    node.firstChild.data = text;
  } else {
    goog.dom.removeChildren(node);
    var doc = goog.dom.getOwnerDocument(node);
    node.appendChild(doc.createTextNode(String(text)));
  }
};
goog.dom.getOuterHtml = function(element) {
  if ('outerHTML' in element) {
    return element.outerHTML;
  } else {
    var doc = goog.dom.getOwnerDocument(element);
    var div = doc.createElement(goog.dom.TagName.DIV);
    div.appendChild(element.cloneNode(true));
    return div.innerHTML;
  }
};
goog.dom.findNode = function(root, p) {
  var rv = [];
  var found = goog.dom.findNodes_(root, p, rv, true);
  return found ? rv[0] : undefined;
};
goog.dom.findNodes = function(root, p) {
  var rv = [];
  goog.dom.findNodes_(root, p, rv, false);
  return rv;
};
goog.dom.findNodes_ = function(root, p, rv, findOne) {
  if (root != null) {
    var child = root.firstChild;
    while (child) {
      if (p(child)) {
        rv.push(child);
        if (findOne) {
          return true;
        }
      }
      if (goog.dom.findNodes_(child, p, rv, findOne)) {
        return true;
      }
      child = child.nextSibling;
    }
  }
  return false;
};
goog.dom.TAGS_TO_IGNORE_ = {
  'SCRIPT': 1,
  'STYLE': 1,
  'HEAD': 1,
  'IFRAME': 1,
  'OBJECT': 1
};
goog.dom.PREDEFINED_TAG_VALUES_ = {'IMG': ' ', 'BR': '\n'};
goog.dom.isFocusableTabIndex = function(element) {
  return goog.dom.hasSpecifiedTabIndex_(element) &&
         goog.dom.isTabIndexFocusable_(element);
};
goog.dom.setFocusableTabIndex = function(element, enable) {
  if (enable) {
    element.tabIndex = 0;
  } else {
    element.tabIndex = -1;
    element.removeAttribute('tabIndex'); // Must be camelCase!
  }
};
goog.dom.isFocusable = function(element) {
  var focusable;
  if (goog.dom.nativelySupportsFocus_(element)) {
    focusable = !element.disabled &&
        (!goog.dom.hasSpecifiedTabIndex_(element) ||
         goog.dom.isTabIndexFocusable_(element));
  } else {
    focusable = goog.dom.isFocusableTabIndex(element);
  }
  return focusable && goog.userAgent.IE ?
             goog.dom.hasNonZeroBoundingRect_(element) : focusable;
};
goog.dom.hasSpecifiedTabIndex_ = function(element) {
  var attrNode = element.getAttributeNode('tabindex'); // Must be lowercase!
  return goog.isDefAndNotNull(attrNode) && attrNode.specified;
};
goog.dom.isTabIndexFocusable_ = function(element) {
  var index = element.tabIndex;
  return goog.isNumber(index) && index >= 0 && index < 32768;
};
goog.dom.nativelySupportsFocus_ = function(element) {
  return element.tagName == goog.dom.TagName.A ||
         element.tagName == goog.dom.TagName.INPUT ||
         element.tagName == goog.dom.TagName.TEXTAREA ||
         element.tagName == goog.dom.TagName.SELECT ||
         element.tagName == goog.dom.TagName.BUTTON;
};
goog.dom.hasNonZeroBoundingRect_ = function(element) {
  var rect = goog.isFunction(element['getBoundingClientRect']) ?
      element.getBoundingClientRect() :
      {'height': element.offsetHeight, 'width': element.offsetWidth};
  return goog.isDefAndNotNull(rect) && rect.height > 0 && rect.width > 0;
};
goog.dom.getTextContent = function(node) {
  var textContent;
  if (goog.dom.BrowserFeature.CAN_USE_INNER_TEXT && ('innerText' in node)) {
    textContent = goog.string.canonicalizeNewlines(node.innerText);
  } else {
    var buf = [];
    goog.dom.getTextContent_(node, buf, true);
    textContent = buf.join('');
  }
  textContent = textContent.replace(/ \xAD /g, ' ').replace(/\xAD/g, '');
  textContent = textContent.replace(/\u200B/g, '');
  if (!goog.dom.BrowserFeature.CAN_USE_INNER_TEXT) {
    textContent = textContent.replace(/ +/g, ' ');
  }
  if (textContent != ' ') {
    textContent = textContent.replace(/^\s*/, '');
  }
  return textContent;
};
goog.dom.getRawTextContent = function(node) {
  var buf = [];
  goog.dom.getTextContent_(node, buf, false);
  return buf.join('');
};
goog.dom.getTextContent_ = function(node, buf, normalizeWhitespace) {
  if (node.nodeName in goog.dom.TAGS_TO_IGNORE_) {
  } else if (node.nodeType == goog.dom.NodeType.TEXT) {
    if (normalizeWhitespace) {
      buf.push(String(node.nodeValue).replace(/(\r\n|\r|\n)/g, ''));
    } else {
      buf.push(node.nodeValue);
    }
  } else if (node.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
    buf.push(goog.dom.PREDEFINED_TAG_VALUES_[node.nodeName]);
  } else {
    var child = node.firstChild;
    while (child) {
      goog.dom.getTextContent_(child, buf, normalizeWhitespace);
      child = child.nextSibling;
    }
  }
};
goog.dom.getNodeTextLength = function(node) {
  return goog.dom.getTextContent(node).length;
};
goog.dom.getNodeTextOffset = function(node, opt_offsetParent) {
  var root = opt_offsetParent || goog.dom.getOwnerDocument(node).body;
  var buf = [];
  while (node && node != root) {
    var cur = node;
    while ((cur = cur.previousSibling)) {
      buf.unshift(goog.dom.getTextContent(cur));
    }
    node = node.parentNode;
  }
  return goog.string.trimLeft(buf.join('')).replace(/ +/g, ' ').length;
};
goog.dom.getNodeAtOffset = function(parent, offset, opt_result) {
  var stack = [parent], pos = 0, cur = null;
  while (stack.length > 0 && pos < offset) {
    cur = stack.pop();
    if (cur.nodeName in goog.dom.TAGS_TO_IGNORE_) {
    } else if (cur.nodeType == goog.dom.NodeType.TEXT) {
      var text = cur.nodeValue.replace(/(\r\n|\r|\n)/g, '').replace(/ +/g, ' ');
      pos += text.length;
    } else if (cur.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
      pos += goog.dom.PREDEFINED_TAG_VALUES_[cur.nodeName].length;
    } else {
      for (var i = cur.childNodes.length - 1; i >= 0; i--) {
        stack.push(cur.childNodes[i]);
      }
    }
  }
  if (goog.isObject(opt_result)) {
    opt_result.remainder = cur ? cur.nodeValue.length + offset - pos - 1 : 0;
    opt_result.node = cur;
  }
  return cur;
};
goog.dom.isNodeList = function(val) {
  if (val && typeof val.length == 'number') {
    if (goog.isObject(val)) {
      return typeof val.item == 'function' || typeof val.item == 'string';
    } else if (goog.isFunction(val)) {
      return typeof val.item == 'function';
    }
  }
  return false;
};
goog.dom.getAncestorByTagNameAndClass = function(element, opt_tag, opt_class,
    opt_maxSearchSteps) {
  if (!opt_tag && !opt_class) {
    return null;
  }
  var tagName = opt_tag ? opt_tag.toUpperCase() : null;
  return  (goog.dom.getAncestor(element,
      function(node) {
        return (!tagName || node.nodeName == tagName) &&
               (!opt_class || goog.isString(node.className) &&
                   goog.array.contains(node.className.split(/\s+/), opt_class));
      }, true, opt_maxSearchSteps));
};
goog.dom.getAncestorByClass = function(element, className, opt_maxSearchSteps) {
  return goog.dom.getAncestorByTagNameAndClass(element, null, className,
      opt_maxSearchSteps);
};
goog.dom.getAncestor = function(
    element, matcher, opt_includeNode, opt_maxSearchSteps) {
  if (!opt_includeNode) {
    element = element.parentNode;
  }
  var ignoreSearchSteps = opt_maxSearchSteps == null;
  var steps = 0;
  while (element && (ignoreSearchSteps || steps <= opt_maxSearchSteps)) {
    goog.asserts.assert(element.name != 'parentNode');
    if (matcher(element)) {
      return element;
    }
    element = element.parentNode;
    steps++;
  }
  return null;
};
goog.dom.getActiveElement = function(doc) {
  try {
    return doc && doc.activeElement;
  } catch (e) {
  }
  return null;
};
goog.dom.getPixelRatio = function() {
  var win = goog.dom.getWindow();
  var isFirefoxMobile = goog.userAgent.GECKO && goog.userAgent.MOBILE;
  if (goog.isDef(win.devicePixelRatio) && !isFirefoxMobile) {
    return win.devicePixelRatio;
  } else if (win.matchMedia) {
    return goog.dom.matchesPixelRatio_(.75) ||
           goog.dom.matchesPixelRatio_(1.5) ||
           goog.dom.matchesPixelRatio_(2) ||
           goog.dom.matchesPixelRatio_(3) || 1;
  }
  return 1;
};
goog.dom.matchesPixelRatio_ = function(pixelRatio) {
  var win = goog.dom.getWindow();
  var query = ('(-webkit-min-device-pixel-ratio: ' + pixelRatio + '),' +
               '(min--moz-device-pixel-ratio: ' + pixelRatio + '),' +
               '(min-resolution: ' + pixelRatio + 'dppx)');
  return win.matchMedia(query).matches ? pixelRatio : 0;
};
goog.dom.DomHelper = function(opt_document) {
  this.document_ = opt_document || goog.global.document || document;
};
goog.dom.DomHelper.prototype.getDomHelper = goog.dom.getDomHelper;
goog.dom.DomHelper.prototype.setDocument = function(document) {
  this.document_ = document;
};
goog.dom.DomHelper.prototype.getDocument = function() {
  return this.document_;
};
goog.dom.DomHelper.prototype.getElement = function(element) {
  return goog.dom.getElementHelper_(this.document_, element);
};
goog.dom.DomHelper.prototype.getRequiredElement = function(id) {
  return goog.dom.getRequiredElementHelper_(this.document_, id);
};
goog.dom.DomHelper.prototype.$ = goog.dom.DomHelper.prototype.getElement;
goog.dom.DomHelper.prototype.getElementsByTagNameAndClass = function(opt_tag,
                                                                     opt_class,
                                                                     opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(this.document_, opt_tag,
                                                opt_class, opt_el);
};
goog.dom.DomHelper.prototype.getElementsByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementsByClass(className, doc);
};
goog.dom.DomHelper.prototype.getElementByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementByClass(className, doc);
};
goog.dom.DomHelper.prototype.getRequiredElementByClass = function(className,
                                                                  opt_root) {
  var root = opt_root || this.document_;
  return goog.dom.getRequiredElementByClass(className, root);
};
goog.dom.DomHelper.prototype.$$ =
    goog.dom.DomHelper.prototype.getElementsByTagNameAndClass;
goog.dom.DomHelper.prototype.setProperties = goog.dom.setProperties;
goog.dom.DomHelper.prototype.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize(opt_window || this.getWindow());
};
goog.dom.DomHelper.prototype.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(this.getWindow());
};
goog.dom.Appendable;
goog.dom.DomHelper.prototype.createDom = function(tagName,
                                                  opt_attributes,
                                                  var_args) {
  return goog.dom.createDom_(this.document_, arguments);
};
goog.dom.DomHelper.prototype.$dom = goog.dom.DomHelper.prototype.createDom;
goog.dom.DomHelper.prototype.createElement = function(name) {
  return this.document_.createElement(name);
};
goog.dom.DomHelper.prototype.createTextNode = function(content) {
  return this.document_.createTextNode(String(content));
};
goog.dom.DomHelper.prototype.createTable = function(rows, columns,
    opt_fillWithNbsp) {
  return goog.dom.createTable_(this.document_, rows, columns,
      !!opt_fillWithNbsp);
};
goog.dom.DomHelper.prototype.safeHtmlToNode = function(html) {
  return goog.dom.safeHtmlToNode_(this.document_, html);
};
goog.dom.DomHelper.prototype.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(this.document_, htmlString);
};
goog.dom.DomHelper.prototype.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(this.document_);
};
goog.dom.DomHelper.prototype.getWindow = function() {
  return goog.dom.getWindow_(this.document_);
};
goog.dom.DomHelper.prototype.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(this.document_);
};
goog.dom.DomHelper.prototype.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(this.document_);
};
goog.dom.DomHelper.prototype.getActiveElement = function(opt_doc) {
  return goog.dom.getActiveElement(opt_doc || this.document_);
};
goog.dom.DomHelper.prototype.appendChild = goog.dom.appendChild;
goog.dom.DomHelper.prototype.append = goog.dom.append;
goog.dom.DomHelper.prototype.canHaveChildren = goog.dom.canHaveChildren;
goog.dom.DomHelper.prototype.removeChildren = goog.dom.removeChildren;
goog.dom.DomHelper.prototype.insertSiblingBefore = goog.dom.insertSiblingBefore;
goog.dom.DomHelper.prototype.insertSiblingAfter = goog.dom.insertSiblingAfter;
goog.dom.DomHelper.prototype.insertChildAt = goog.dom.insertChildAt;
goog.dom.DomHelper.prototype.removeNode = goog.dom.removeNode;
goog.dom.DomHelper.prototype.replaceNode = goog.dom.replaceNode;
goog.dom.DomHelper.prototype.flattenElement = goog.dom.flattenElement;
goog.dom.DomHelper.prototype.getChildren = goog.dom.getChildren;
goog.dom.DomHelper.prototype.getFirstElementChild =
    goog.dom.getFirstElementChild;
goog.dom.DomHelper.prototype.getLastElementChild = goog.dom.getLastElementChild;
goog.dom.DomHelper.prototype.getNextElementSibling =
    goog.dom.getNextElementSibling;
goog.dom.DomHelper.prototype.getPreviousElementSibling =
    goog.dom.getPreviousElementSibling;
goog.dom.DomHelper.prototype.getNextNode = goog.dom.getNextNode;
goog.dom.DomHelper.prototype.getPreviousNode = goog.dom.getPreviousNode;
goog.dom.DomHelper.prototype.isNodeLike = goog.dom.isNodeLike;
goog.dom.DomHelper.prototype.isElement = goog.dom.isElement;
goog.dom.DomHelper.prototype.isWindow = goog.dom.isWindow;
goog.dom.DomHelper.prototype.getParentElement = goog.dom.getParentElement;
goog.dom.DomHelper.prototype.contains = goog.dom.contains;
goog.dom.DomHelper.prototype.compareNodeOrder = goog.dom.compareNodeOrder;
goog.dom.DomHelper.prototype.findCommonAncestor = goog.dom.findCommonAncestor;
goog.dom.DomHelper.prototype.getOwnerDocument = goog.dom.getOwnerDocument;
goog.dom.DomHelper.prototype.getFrameContentDocument =
    goog.dom.getFrameContentDocument;
goog.dom.DomHelper.prototype.getFrameContentWindow =
    goog.dom.getFrameContentWindow;
goog.dom.DomHelper.prototype.setTextContent = goog.dom.setTextContent;
goog.dom.DomHelper.prototype.getOuterHtml = goog.dom.getOuterHtml;
goog.dom.DomHelper.prototype.findNode = goog.dom.findNode;
goog.dom.DomHelper.prototype.findNodes = goog.dom.findNodes;
goog.dom.DomHelper.prototype.isFocusableTabIndex = goog.dom.isFocusableTabIndex;
goog.dom.DomHelper.prototype.setFocusableTabIndex =
    goog.dom.setFocusableTabIndex;
goog.dom.DomHelper.prototype.isFocusable = goog.dom.isFocusable;
goog.dom.DomHelper.prototype.getTextContent = goog.dom.getTextContent;
goog.dom.DomHelper.prototype.getNodeTextLength = goog.dom.getNodeTextLength;
goog.dom.DomHelper.prototype.getNodeTextOffset = goog.dom.getNodeTextOffset;
goog.dom.DomHelper.prototype.getNodeAtOffset = goog.dom.getNodeAtOffset;
goog.dom.DomHelper.prototype.isNodeList = goog.dom.isNodeList;
goog.dom.DomHelper.prototype.getAncestorByTagNameAndClass =
    goog.dom.getAncestorByTagNameAndClass;
goog.dom.DomHelper.prototype.getAncestorByClass =
    goog.dom.getAncestorByClass;
goog.dom.DomHelper.prototype.getAncestor = goog.dom.getAncestor;

// goog.math.Box
goog.provide('goog.math.Box');
goog.math.Box = function(top, right, bottom, left) {
  this.top = top;
  this.right = right;
  this.bottom = bottom;
  this.left = left;
};
goog.math.Box.boundingBox = function(var_args) {
  var box = new goog.math.Box(arguments[0].y, arguments[0].x,
                              arguments[0].y, arguments[0].x);
  for (var i = 1; i < arguments.length; i++) {
    var coord = arguments[i];
    box.top = Math.min(box.top, coord.y);
    box.right = Math.max(box.right, coord.x);
    box.bottom = Math.max(box.bottom, coord.y);
    box.left = Math.min(box.left, coord.x);
  }
  return box;
};
goog.math.Box.prototype.getWidth = function() {
  return this.right - this.left;
};
goog.math.Box.prototype.getHeight = function() {
  return this.bottom - this.top;
};
goog.math.Box.prototype.clone = function() {
  return new goog.math.Box(this.top, this.right, this.bottom, this.left);
};
if (goog.DEBUG) {
  goog.math.Box.prototype.toString = function() {
    return '(' + this.top + 't, ' + this.right + 'r, ' + this.bottom + 'b, ' +
           this.left + 'l)';
  };
}
goog.math.Box.prototype.contains = function(other) {
  return goog.math.Box.contains(this, other);
};
goog.math.Box.prototype.expand = function(top, opt_right, opt_bottom,
    opt_left) {
  if (goog.isObject(top)) {
    this.top -= top.top;
    this.right += top.right;
    this.bottom += top.bottom;
    this.left -= top.left;
  } else {
    this.top -= top;
    this.right += opt_right;
    this.bottom += opt_bottom;
    this.left -= opt_left;
  }
  return this;
};
goog.math.Box.prototype.expandToInclude = function(box) {
  this.left = Math.min(this.left, box.left);
  this.top = Math.min(this.top, box.top);
  this.right = Math.max(this.right, box.right);
  this.bottom = Math.max(this.bottom, box.bottom);
};
goog.math.Box.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.top == b.top && a.right == b.right &&
         a.bottom == b.bottom && a.left == b.left;
};
goog.math.Box.contains = function(box, other) {
  if (!box || !other) {
    return false;
  }
  if (other instanceof goog.math.Box) {
    return other.left >= box.left && other.right <= box.right &&
        other.top >= box.top && other.bottom <= box.bottom;
  }
  return other.x >= box.left && other.x <= box.right &&
         other.y >= box.top && other.y <= box.bottom;
};
goog.math.Box.relativePositionX = function(box, coord) {
  if (coord.x < box.left) {
    return coord.x - box.left;
  } else if (coord.x > box.right) {
    return coord.x - box.right;
  }
  return 0;
};
goog.math.Box.relativePositionY = function(box, coord) {
  if (coord.y < box.top) {
    return coord.y - box.top;
  } else if (coord.y > box.bottom) {
    return coord.y - box.bottom;
  }
  return 0;
};
goog.math.Box.distance = function(box, coord) {
  var x = goog.math.Box.relativePositionX(box, coord);
  var y = goog.math.Box.relativePositionY(box, coord);
  return Math.sqrt(x * x + y * y);
};
goog.math.Box.intersects = function(a, b) {
  return (a.left <= b.right && b.left <= a.right &&
          a.top <= b.bottom && b.top <= a.bottom);
};
goog.math.Box.intersectsWithPadding = function(a, b, padding) {
  return (a.left <= b.right + padding && b.left <= a.right + padding &&
          a.top <= b.bottom + padding && b.top <= a.bottom + padding);
};
goog.math.Box.prototype.ceil = function() {
  this.top = Math.ceil(this.top);
  this.right = Math.ceil(this.right);
  this.bottom = Math.ceil(this.bottom);
  this.left = Math.ceil(this.left);
  return this;
};
goog.math.Box.prototype.floor = function() {
  this.top = Math.floor(this.top);
  this.right = Math.floor(this.right);
  this.bottom = Math.floor(this.bottom);
  this.left = Math.floor(this.left);
  return this;
};
goog.math.Box.prototype.round = function() {
  this.top = Math.round(this.top);
  this.right = Math.round(this.right);
  this.bottom = Math.round(this.bottom);
  this.left = Math.round(this.left);
  return this;
};
goog.math.Box.prototype.translate = function(tx, opt_ty) {
  if (tx instanceof goog.math.Coordinate) {
    this.left += tx.x;
    this.right += tx.x;
    this.top += tx.y;
    this.bottom += tx.y;
  } else {
    this.left += tx;
    this.right += tx;
    if (goog.isNumber(opt_ty)) {
      this.top += opt_ty;
      this.bottom += opt_ty;
    }
  }
  return this;
};
goog.math.Box.prototype.scale = function(sx, opt_sy) {
  var sy = goog.isNumber(opt_sy) ? opt_sy : sx;
  this.left *= sx;
  this.right *= sx;
  this.top *= sy;
  this.bottom *= sy;
  return this;
};

// goog.math.Rect
goog.provide('goog.math.Rect');
goog.math.Rect = function(x, y, w, h) {
  this.left = x;
  this.top = y;
  this.width = w;
  this.height = h;
};
goog.math.Rect.prototype.clone = function() {
  return new goog.math.Rect(this.left, this.top, this.width, this.height);
};
goog.math.Rect.prototype.toBox = function() {
  var right = this.left + this.width;
  var bottom = this.top + this.height;
  return new goog.math.Box(this.top,
                           right,
                           bottom,
                           this.left);
};
goog.math.Rect.createFromPositionAndSize = function(position, size) {
  return new goog.math.Rect(position.x, position.y, size.width, size.height);
};
goog.math.Rect.createFromBox = function(box) {
  return new goog.math.Rect(box.left, box.top,
      box.right - box.left, box.bottom - box.top);
};
if (goog.DEBUG) {
  goog.math.Rect.prototype.toString = function() {
    return '(' + this.left + ', ' + this.top + ' - ' + this.width + 'w x ' +
           this.height + 'h)';
  };
}
goog.math.Rect.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.left == b.left && a.width == b.width &&
         a.top == b.top && a.height == b.height;
};
goog.math.Rect.prototype.intersection = function(rect) {
  var x0 = Math.max(this.left, rect.left);
  var x1 = Math.min(this.left + this.width, rect.left + rect.width);
  if (x0 <= x1) {
    var y0 = Math.max(this.top, rect.top);
    var y1 = Math.min(this.top + this.height, rect.top + rect.height);
    if (y0 <= y1) {
      this.left = x0;
      this.top = y0;
      this.width = x1 - x0;
      this.height = y1 - y0;
      return true;
    }
  }
  return false;
};
goog.math.Rect.intersection = function(a, b) {
  var x0 = Math.max(a.left, b.left);
  var x1 = Math.min(a.left + a.width, b.left + b.width);
  if (x0 <= x1) {
    var y0 = Math.max(a.top, b.top);
    var y1 = Math.min(a.top + a.height, b.top + b.height);
    if (y0 <= y1) {
      return new goog.math.Rect(x0, y0, x1 - x0, y1 - y0);
    }
  }
  return null;
};
goog.math.Rect.intersects = function(a, b) {
  return (a.left <= b.left + b.width && b.left <= a.left + a.width &&
      a.top <= b.top + b.height && b.top <= a.top + a.height);
};
goog.math.Rect.prototype.intersects = function(rect) {
  return goog.math.Rect.intersects(this, rect);
};
goog.math.Rect.difference = function(a, b) {
  var intersection = goog.math.Rect.intersection(a, b);
  if (!intersection || !intersection.height || !intersection.width) {
    return [a.clone()];
  }
  var result = [];
  var top = a.top;
  var height = a.height;
  var ar = a.left + a.width;
  var ab = a.top + a.height;
  var br = b.left + b.width;
  var bb = b.top + b.height;
  if (b.top > a.top) {
    result.push(new goog.math.Rect(a.left, a.top, a.width, b.top - a.top));
    top = b.top;
    height -= b.top - a.top;
  }
  if (bb < ab) {
    result.push(new goog.math.Rect(a.left, bb, a.width, ab - bb));
    height = bb - top;
  }
  if (b.left > a.left) {
    result.push(new goog.math.Rect(a.left, top, b.left - a.left, height));
  }
  if (br < ar) {
    result.push(new goog.math.Rect(br, top, ar - br, height));
  }
  return result;
};
goog.math.Rect.prototype.difference = function(rect) {
  return goog.math.Rect.difference(this, rect);
};
goog.math.Rect.prototype.boundingRect = function(rect) {
  var right = Math.max(this.left + this.width, rect.left + rect.width);
  var bottom = Math.max(this.top + this.height, rect.top + rect.height);
  this.left = Math.min(this.left, rect.left);
  this.top = Math.min(this.top, rect.top);
  this.width = right - this.left;
  this.height = bottom - this.top;
};
goog.math.Rect.boundingRect = function(a, b) {
  if (!a || !b) {
    return null;
  }
  var clone = a.clone();
  clone.boundingRect(b);
  return clone;
};
goog.math.Rect.prototype.contains = function(another) {
  if (another instanceof goog.math.Rect) {
    return this.left <= another.left &&
           this.left + this.width >= another.left + another.width &&
           this.top <= another.top &&
           this.top + this.height >= another.top + another.height;
  } else { // (another instanceof goog.math.Coordinate)
    return another.x >= this.left &&
           another.x <= this.left + this.width &&
           another.y >= this.top &&
           another.y <= this.top + this.height;
  }
};
goog.math.Rect.prototype.squaredDistance = function(point) {
  var dx = point.x < this.left ?
      this.left - point.x : Math.max(point.x - (this.left + this.width), 0);
  var dy = point.y < this.top ?
      this.top - point.y : Math.max(point.y - (this.top + this.height), 0);
  return dx * dx + dy * dy;
};
goog.math.Rect.prototype.distance = function(point) {
  return Math.sqrt(this.squaredDistance(point));
};
goog.math.Rect.prototype.getSize = function() {
  return new goog.math.Size(this.width, this.height);
};
goog.math.Rect.prototype.getTopLeft = function() {
  return new goog.math.Coordinate(this.left, this.top);
};
goog.math.Rect.prototype.getCenter = function() {
  return new goog.math.Coordinate(
      this.left + this.width / 2, this.top + this.height / 2);
};
goog.math.Rect.prototype.getBottomRight = function() {
  return new goog.math.Coordinate(
      this.left + this.width, this.top + this.height);
};
goog.math.Rect.prototype.ceil = function() {
  this.left = Math.ceil(this.left);
  this.top = Math.ceil(this.top);
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this;
};
goog.math.Rect.prototype.floor = function() {
  this.left = Math.floor(this.left);
  this.top = Math.floor(this.top);
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this;
};
goog.math.Rect.prototype.round = function() {
  this.left = Math.round(this.left);
  this.top = Math.round(this.top);
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this;
};
goog.math.Rect.prototype.translate = function(tx, opt_ty) {
  if (tx instanceof goog.math.Coordinate) {
    this.left += tx.x;
    this.top += tx.y;
  } else {
    this.left += tx;
    if (goog.isNumber(opt_ty)) {
      this.top += opt_ty;
    }
  }
  return this;
};
goog.math.Rect.prototype.scale = function(sx, opt_sy) {
  var sy = goog.isNumber(opt_sy) ? opt_sy : sx;
  this.left *= sx;
  this.width *= sx;
  this.top *= sy;
  this.height *= sy;
  return this;
};

// goog.dom.vendor
goog.provide('goog.dom.vendor');
goog.dom.vendor.getVendorJsPrefix = function() {
  if (goog.userAgent.WEBKIT) {
    return 'Webkit';
  } else if (goog.userAgent.GECKO) {
    return 'Moz';
  } else if (goog.userAgent.IE) {
    return 'ms';
  } else if (goog.userAgent.OPERA) {
    return 'O';
  }
  return null;
};
goog.dom.vendor.getVendorPrefix = function() {
  if (goog.userAgent.WEBKIT) {
    return '-webkit';
  } else if (goog.userAgent.GECKO) {
    return '-moz';
  } else if (goog.userAgent.IE) {
    return '-ms';
  } else if (goog.userAgent.OPERA) {
    return '-o';
  }
  return null;
};
goog.dom.vendor.getPrefixedPropertyName = function(propertyName, opt_object) {
  if (opt_object && propertyName in opt_object) {
    return propertyName;
  }
  var prefix = goog.dom.vendor.getVendorJsPrefix();
  if (prefix) {
    prefix = prefix.toLowerCase();
    var prefixedPropertyName = prefix + goog.string.toTitleCase(propertyName);
    return (!goog.isDef(opt_object) || prefixedPropertyName in opt_object) ?
        prefixedPropertyName : null;
  }
  return null;
};
goog.dom.vendor.getPrefixedEventType = function(eventType) {
  var prefix = goog.dom.vendor.getVendorJsPrefix() || '';
  return (prefix + eventType).toLowerCase();
};

// goog.style
goog.provide('goog.style');
goog.forwardDeclare('goog.events.BrowserEvent');
goog.forwardDeclare('goog.events.Event');
goog.style.setStyle = function(element, style, opt_value) {
  if (goog.isString(style)) {
    goog.style.setStyle_(element, opt_value, style);
  } else {
    for (var key in style) {
      goog.style.setStyle_(element, style[key], key);
    }
  }
};
goog.style.setStyle_ = function(element, value, style) {
  var propertyName = goog.style.getVendorJsStyleName_(element, style);
  if (propertyName) {
    element.style[propertyName] = value;
  }
};
goog.style.styleNameCache_ = {};
goog.style.getVendorJsStyleName_ = function(element, style) {
  var propertyName = goog.style.styleNameCache_[style];
  if (!propertyName) {
    var camelStyle = goog.string.toCamelCase(style);
    propertyName = camelStyle;
    if (element.style[camelStyle] === undefined) {
      var prefixedStyle = goog.dom.vendor.getVendorJsPrefix() +
          goog.string.toTitleCase(camelStyle);
      if (element.style[prefixedStyle] !== undefined) {
        propertyName = prefixedStyle;
      }
    }
    goog.style.styleNameCache_[style] = propertyName;
  }
  return propertyName;
};
goog.style.getVendorStyleName_ = function(element, style) {
  var camelStyle = goog.string.toCamelCase(style);
  if (element.style[camelStyle] === undefined) {
    var prefixedStyle = goog.dom.vendor.getVendorJsPrefix() +
        goog.string.toTitleCase(camelStyle);
    if (element.style[prefixedStyle] !== undefined) {
      return goog.dom.vendor.getVendorPrefix() + '-' + style;
    }
  }
  return style;
};
goog.style.getStyle = function(element, property) {
  var styleValue = element.style[goog.string.toCamelCase(property)];
  if (typeof(styleValue) !== 'undefined') {
    return styleValue;
  }
  return element.style[goog.style.getVendorJsStyleName_(element, property)] ||
      '';
};
goog.style.getComputedStyle = function(element, property) {
  var doc = goog.dom.getOwnerDocument(element);
  if (doc.defaultView && doc.defaultView.getComputedStyle) {
    var styles = doc.defaultView.getComputedStyle(element, null);
    if (styles) {
      return styles[property] || styles.getPropertyValue(property) || '';
    }
  }
  return '';
};
goog.style.getCascadedStyle = function(element, style) {
  return element.currentStyle ? element.currentStyle[style] : null;
};
goog.style.getStyle_ = function(element, style) {
  return goog.style.getComputedStyle(element, style) ||
         goog.style.getCascadedStyle(element, style) ||
         (element.style && element.style[style]);
};
goog.style.getComputedBoxSizing = function(element) {
  return goog.style.getStyle_(element, 'boxSizing') ||
      goog.style.getStyle_(element, 'MozBoxSizing') ||
      goog.style.getStyle_(element, 'WebkitBoxSizing') || null;
};
goog.style.getComputedPosition = function(element) {
  return goog.style.getStyle_(element, 'position');
};
goog.style.getBackgroundColor = function(element) {
  return goog.style.getStyle_(element, 'backgroundColor');
};
goog.style.getComputedOverflowX = function(element) {
  return goog.style.getStyle_(element, 'overflowX');
};
goog.style.getComputedOverflowY = function(element) {
  return goog.style.getStyle_(element, 'overflowY');
};
goog.style.getComputedZIndex = function(element) {
  return goog.style.getStyle_(element, 'zIndex');
};
goog.style.getComputedTextAlign = function(element) {
  return goog.style.getStyle_(element, 'textAlign');
};
goog.style.getComputedCursor = function(element) {
  return goog.style.getStyle_(element, 'cursor');
};
goog.style.getComputedTransform = function(element) {
  var property = goog.style.getVendorStyleName_(element, 'transform');
  return goog.style.getStyle_(element, property) ||
      goog.style.getStyle_(element, 'transform');
};
goog.style.setPosition = function(el, arg1, opt_arg2) {
  var x, y;
  if (arg1 instanceof goog.math.Coordinate) {
    x = arg1.x;
    y = arg1.y;
  } else {
    x = arg1;
    y = opt_arg2;
  }
  el.style.left = goog.style.getPixelStyleValue_(
       (x), false);
  el.style.top = goog.style.getPixelStyleValue_(
       (y), false);
};
goog.style.getPosition = function(element) {
  return new goog.math.Coordinate(
       (element).offsetLeft,
       (element).offsetTop);
};
goog.style.getClientViewportElement = function(opt_node) {
  var doc;
  if (opt_node) {
    doc = goog.dom.getOwnerDocument(opt_node);
  } else {
    doc = goog.dom.getDocument();
  }
  if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9) &&
      !goog.dom.getDomHelper(doc).isCss1CompatMode()) {
    return doc.body;
  }
  return doc.documentElement;
};
goog.style.getViewportPageOffset = function(doc) {
  var body = doc.body;
  var documentElement = doc.documentElement;
  var scrollLeft = body.scrollLeft || documentElement.scrollLeft;
  var scrollTop = body.scrollTop || documentElement.scrollTop;
  return new goog.math.Coordinate(scrollLeft, scrollTop);
};
goog.style.getBoundingClientRect_ = function(el) {
  var rect;
  try {
    rect = el.getBoundingClientRect();
  } catch (e) {
    return {'left': 0, 'top': 0, 'right': 0, 'bottom': 0};
  }
  if (goog.userAgent.IE && el.ownerDocument.body) {
    var doc = el.ownerDocument;
    rect.left -= doc.documentElement.clientLeft + doc.body.clientLeft;
    rect.top -= doc.documentElement.clientTop + doc.body.clientTop;
  }
  return rect;
};
goog.style.getOffsetParent = function(element) {
  if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(8)) {
    return element.offsetParent;
  }
  var doc = goog.dom.getOwnerDocument(element);
  var positionStyle = goog.style.getStyle_(element, 'position');
  var skipStatic = positionStyle == 'fixed' || positionStyle == 'absolute';
  for (var parent = element.parentNode; parent && parent != doc;
       parent = parent.parentNode) {
    if (parent.nodeType == goog.dom.NodeType.DOCUMENT_FRAGMENT &&
        parent.host) {
      parent = parent.host;
    }
    positionStyle =
        goog.style.getStyle_( (parent), 'position');
    skipStatic = skipStatic && positionStyle == 'static' &&
                 parent != doc.documentElement && parent != doc.body;
    if (!skipStatic && (parent.scrollWidth > parent.clientWidth ||
                        parent.scrollHeight > parent.clientHeight ||
                        positionStyle == 'fixed' ||
                        positionStyle == 'absolute' ||
                        positionStyle == 'relative')) {
      return  (parent);
    }
  }
  return null;
};
goog.style.getVisibleRectForElement = function(element) {
  var visibleRect = new goog.math.Box(0, Infinity, Infinity, 0);
  var dom = goog.dom.getDomHelper(element);
  var body = dom.getDocument().body;
  var documentElement = dom.getDocument().documentElement;
  var scrollEl = dom.getDocumentScrollElement();
  for (var el = element; el = goog.style.getOffsetParent(el); ) {
    if ((!goog.userAgent.IE || el.clientWidth != 0) &&
        (!goog.userAgent.WEBKIT || el.clientHeight != 0 || el != body) &&
        (el != body && el != documentElement &&
            goog.style.getStyle_(el, 'overflow') != 'visible')) {
      var pos = goog.style.getPageOffset(el);
      var client = goog.style.getClientLeftTop(el);
      pos.x += client.x;
      pos.y += client.y;
      visibleRect.top = Math.max(visibleRect.top, pos.y);
      visibleRect.right = Math.min(visibleRect.right,
                                   pos.x + el.clientWidth);
      visibleRect.bottom = Math.min(visibleRect.bottom,
                                    pos.y + el.clientHeight);
      visibleRect.left = Math.max(visibleRect.left, pos.x);
    }
  }
  var scrollX = scrollEl.scrollLeft, scrollY = scrollEl.scrollTop;
  visibleRect.left = Math.max(visibleRect.left, scrollX);
  visibleRect.top = Math.max(visibleRect.top, scrollY);
  var winSize = dom.getViewportSize();
  visibleRect.right = Math.min(visibleRect.right, scrollX + winSize.width);
  visibleRect.bottom = Math.min(visibleRect.bottom, scrollY + winSize.height);
  return visibleRect.top >= 0 && visibleRect.left >= 0 &&
         visibleRect.bottom > visibleRect.top &&
         visibleRect.right > visibleRect.left ?
         visibleRect : null;
};
goog.style.getContainerOffsetToScrollInto =
    function(element, container, opt_center) {
  var elementPos = goog.style.getPageOffset(element);
  var containerPos = goog.style.getPageOffset(container);
  var containerBorder = goog.style.getBorderBox(container);
  var relX = elementPos.x - containerPos.x - containerBorder.left;
  var relY = elementPos.y - containerPos.y - containerBorder.top;
  var spaceX = container.clientWidth -
       (element).offsetWidth;
  var spaceY = container.clientHeight -
       (element).offsetHeight;
  var scrollLeft = container.scrollLeft;
  var scrollTop = container.scrollTop;
  if (container == goog.dom.getDocument().body ||
      container == goog.dom.getDocument().documentElement) {
    scrollLeft = containerPos.x + containerBorder.left;
    scrollTop = containerPos.y + containerBorder.top;
    if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(10)) {
      scrollLeft += containerBorder.left;
      scrollTop += containerBorder.top;
    }
  }
  if (opt_center) {
    scrollLeft += relX - spaceX / 2;
    scrollTop += relY - spaceY / 2;
  } else {
    scrollLeft += Math.min(relX, Math.max(relX - spaceX, 0));
    scrollTop += Math.min(relY, Math.max(relY - spaceY, 0));
  }
  return new goog.math.Coordinate(scrollLeft, scrollTop);
};
goog.style.scrollIntoContainerView = function(element, container, opt_center) {
  var offset =
      goog.style.getContainerOffsetToScrollInto(element, container, opt_center);
  container.scrollLeft = offset.x;
  container.scrollTop = offset.y;
};
goog.style.getClientLeftTop = function(el) {
  return new goog.math.Coordinate(el.clientLeft, el.clientTop);
};
goog.style.getPageOffset = function(el) {
  var doc = goog.dom.getOwnerDocument(el);
  goog.asserts.assertObject(el, 'Parameter is required');
  var pos = new goog.math.Coordinate(0, 0);
  var viewportElement = goog.style.getClientViewportElement(doc);
  if (el == viewportElement) {
    return pos;
  }
  var box = goog.style.getBoundingClientRect_(el);
  var scrollCoord = goog.dom.getDomHelper(doc).getDocumentScroll();
  pos.x = box.left + scrollCoord.x;
  pos.y = box.top + scrollCoord.y;
  return pos;
};
goog.style.getPageOffsetLeft = function(el) {
  return goog.style.getPageOffset(el).x;
};
goog.style.getPageOffsetTop = function(el) {
  return goog.style.getPageOffset(el).y;
};
goog.style.getFramedPageOffset = function(el, relativeWin) {
  var position = new goog.math.Coordinate(0, 0);
  var currentWin = goog.dom.getWindow(goog.dom.getOwnerDocument(el));
  var currentEl = el;
  do {
    var offset = currentWin == relativeWin ?
        goog.style.getPageOffset(currentEl) :
        goog.style.getClientPositionForElement_(
            goog.asserts.assert(currentEl));
    position.x += offset.x;
    position.y += offset.y;
  } while (currentWin && currentWin != relativeWin &&
      currentWin != currentWin.parent &&
      (currentEl = currentWin.frameElement) &&
      (currentWin = currentWin.parent));
  return position;
};
goog.style.translateRectForAnotherFrame = function(rect, origBase, newBase) {
  if (origBase.getDocument() != newBase.getDocument()) {
    var body = origBase.getDocument().body;
    var pos = goog.style.getFramedPageOffset(body, newBase.getWindow());
    pos = goog.math.Coordinate.difference(pos, goog.style.getPageOffset(body));
    if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9) &&
        !origBase.isCss1CompatMode()) {
      pos = goog.math.Coordinate.difference(pos, origBase.getDocumentScroll());
    }
    rect.left += pos.x;
    rect.top += pos.y;
  }
};
goog.style.getRelativePosition = function(a, b) {
  var ap = goog.style.getClientPosition(a);
  var bp = goog.style.getClientPosition(b);
  return new goog.math.Coordinate(ap.x - bp.x, ap.y - bp.y);
};
goog.style.getClientPositionForElement_ = function(el) {
  var box = goog.style.getBoundingClientRect_(el);
  return new goog.math.Coordinate(box.left, box.top);
};
goog.style.getClientPosition = function(el) {
  goog.asserts.assert(el);
  if (el.nodeType == goog.dom.NodeType.ELEMENT) {
    return goog.style.getClientPositionForElement_(
         (el));
  } else {
    var isAbstractedEvent = goog.isFunction(el.getBrowserEvent);
    var be =  (el);
    var targetEvent = el;
    if (el.targetTouches && el.targetTouches.length) {
      targetEvent = el.targetTouches[0];
    } else if (isAbstractedEvent && be.getBrowserEvent().targetTouches &&
        be.getBrowserEvent().targetTouches.length) {
      targetEvent = be.getBrowserEvent().targetTouches[0];
    }
    return new goog.math.Coordinate(
        targetEvent.clientX,
        targetEvent.clientY);
  }
};
goog.style.setPageOffset = function(el, x, opt_y) {
  var cur = goog.style.getPageOffset(el);
  if (x instanceof goog.math.Coordinate) {
    opt_y = x.y;
    x = x.x;
  }
  var dx = x - cur.x;
  var dy = opt_y - cur.y;
  goog.style.setPosition(el,  (el).offsetLeft + dx,
                          (el).offsetTop + dy);
};
goog.style.setSize = function(element, w, opt_h) {
  var h;
  if (w instanceof goog.math.Size) {
    h = w.height;
    w = w.width;
  } else {
    if (opt_h == undefined) {
      throw Error('missing height argument');
    }
    h = opt_h;
  }
  goog.style.setWidth(element,  (w));
  goog.style.setHeight(element, h);
};
goog.style.getPixelStyleValue_ = function(value, round) {
  if (typeof value == 'number') {
    value = (round ? Math.round(value) : value) + 'px';
  }
  return value;
};
goog.style.setHeight = function(element, height) {
  element.style.height = goog.style.getPixelStyleValue_(height, true);
};
goog.style.setWidth = function(element, width) {
  element.style.width = goog.style.getPixelStyleValue_(width, true);
};
goog.style.getSize = function(element) {
  return goog.style.evaluateWithTemporaryDisplay_(
      goog.style.getSizeWithDisplay_,  (element));
};
goog.style.evaluateWithTemporaryDisplay_ = function(fn, element) {
  if (goog.style.getStyle_(element, 'display') != 'none') {
    return fn(element);
  }
  var style = element.style;
  var originalDisplay = style.display;
  var originalVisibility = style.visibility;
  var originalPosition = style.position;
  style.visibility = 'hidden';
  style.position = 'absolute';
  style.display = 'inline';
  var retVal = fn(element);
  style.display = originalDisplay;
  style.position = originalPosition;
  style.visibility = originalVisibility;
  return retVal;
};
goog.style.getSizeWithDisplay_ = function(element) {
  var offsetWidth =  (element).offsetWidth;
  var offsetHeight =  (element).offsetHeight;
  var webkitOffsetsZero =
      goog.userAgent.WEBKIT && !offsetWidth && !offsetHeight;
  if ((!goog.isDef(offsetWidth) || webkitOffsetsZero) &&
      element.getBoundingClientRect) {
    var clientRect = goog.style.getBoundingClientRect_(element);
    return new goog.math.Size(clientRect.right - clientRect.left,
        clientRect.bottom - clientRect.top);
  }
  return new goog.math.Size(offsetWidth, offsetHeight);
};
goog.style.getTransformedSize = function(element) {
  if (!element.getBoundingClientRect) {
    return null;
  }
  var clientRect = goog.style.evaluateWithTemporaryDisplay_(
      goog.style.getBoundingClientRect_, element);
  return new goog.math.Size(clientRect.right - clientRect.left,
      clientRect.bottom - clientRect.top);
};
goog.style.getBounds = function(element) {
  var o = goog.style.getPageOffset(element);
  var s = goog.style.getSize(element);
  return new goog.math.Rect(o.x, o.y, s.width, s.height);
};
goog.style.toCamelCase = function(selector) {
  return goog.string.toCamelCase(String(selector));
};
goog.style.toSelectorCase = function(selector) {
  return goog.string.toSelectorCase(selector);
};
goog.style.getOpacity = function(el) {
  var style = el.style;
  var result = '';
  if ('opacity' in style) {
    result = style.opacity;
  } else if ('MozOpacity' in style) {
    result = style.MozOpacity;
  } else if ('filter' in style) {
    var match = style.filter.match(/alpha\(opacity=([\d.]+)\)/);
    if (match) {
      result = String(match[1] / 100);
    }
  }
  return result == '' ? result : Number(result);
};
goog.style.setOpacity = function(el, alpha) {
  var style = el.style;
  if ('opacity' in style) {
    style.opacity = alpha;
  } else if ('MozOpacity' in style) {
    style.MozOpacity = alpha;
  } else if ('filter' in style) {
    if (alpha === '') {
      style.filter = '';
    } else {
      style.filter = 'alpha(opacity=' + alpha * 100 + ')';
    }
  }
};
goog.style.setTransparentBackgroundImage = function(el, src) {
  var style = el.style;
  if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('8')) {
    style.filter = 'progid:DXImageTransform.Microsoft.AlphaImageLoader(' +
        'src="' + src + '", sizingMethod="crop")';
  } else {
    style.backgroundImage = 'url(' + src + ')';
    style.backgroundPosition = 'top left';
    style.backgroundRepeat = 'no-repeat';
  }
};
goog.style.clearTransparentBackgroundImage = function(el) {
  var style = el.style;
  if ('filter' in style) {
    style.filter = '';
  } else {
    style.backgroundImage = 'none';
  }
};
goog.style.showElement = function(el, display) {
  goog.style.setElementShown(el, display);
};
goog.style.setElementShown = function(el, isShown) {
  el.style.display = isShown ? '' : 'none';
};
goog.style.isElementShown = function(el) {
  return el.style.display != 'none';
};
goog.style.installStyles = function(stylesString, opt_node) {
  var dh = goog.dom.getDomHelper(opt_node);
  var styleSheet = null;
  var doc = dh.getDocument();
  if (goog.userAgent.IE && doc.createStyleSheet) {
    styleSheet = doc.createStyleSheet();
    goog.style.setStyles(styleSheet, stylesString);
  } else {
    var head = dh.getElementsByTagNameAndClass(goog.dom.TagName.HEAD)[0];
    if (!head) {
      var body = dh.getElementsByTagNameAndClass(goog.dom.TagName.BODY)[0];
      head = dh.createDom(goog.dom.TagName.HEAD);
      body.parentNode.insertBefore(head, body);
    }
    styleSheet = dh.createDom(goog.dom.TagName.STYLE);
    goog.style.setStyles(styleSheet, stylesString);
    dh.appendChild(head, styleSheet);
  }
  return styleSheet;
};
goog.style.uninstallStyles = function(styleSheet) {
  var node = styleSheet.ownerNode || styleSheet.owningElement ||
       (styleSheet);
  goog.dom.removeNode(node);
};
goog.style.setStyles = function(element, stylesString) {
  if (goog.userAgent.IE && goog.isDef(element.cssText)) {
    element.cssText = stylesString;
  } else {
    element.innerHTML = stylesString;
  }
};
goog.style.setPreWrap = function(el) {
  var style = el.style;
  if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('8')) {
    style.whiteSpace = 'pre';
    style.wordWrap = 'break-word';
  } else if (goog.userAgent.GECKO) {
    style.whiteSpace = '-moz-pre-wrap';
  } else {
    style.whiteSpace = 'pre-wrap';
  }
};
goog.style.setInlineBlock = function(el) {
  var style = el.style;
  style.position = 'relative';
  if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('8')) {
    style.zoom = '1';
    style.display = 'inline';
  } else {
    style.display = 'inline-block';
  }
};
goog.style.isRightToLeft = function(el) {
  return 'rtl' == goog.style.getStyle_(el, 'direction');
};
goog.style.unselectableStyle_ =
    goog.userAgent.GECKO ? 'MozUserSelect' :
    goog.userAgent.WEBKIT ? 'WebkitUserSelect' :
    null;
goog.style.isUnselectable = function(el) {
  if (goog.style.unselectableStyle_) {
    return el.style[goog.style.unselectableStyle_].toLowerCase() == 'none';
  } else if (goog.userAgent.IE || goog.userAgent.OPERA) {
    return el.getAttribute('unselectable') == 'on';
  }
  return false;
};
goog.style.setUnselectable = function(el, unselectable, opt_noRecurse) {
  var descendants = !opt_noRecurse ? el.getElementsByTagName('*') : null;
  var name = goog.style.unselectableStyle_;
  if (name) {
    var value = unselectable ? 'none' : '';
    if (el.style) {
      el.style[name] = value;
    }
    if (descendants) {
      for (var i = 0, descendant; descendant = descendants[i]; i++) {
        if (descendant.style) {
          descendant.style[name] = value;
        }
      }
    }
  } else if (goog.userAgent.IE || goog.userAgent.OPERA) {
    var value = unselectable ? 'on' : '';
    el.setAttribute('unselectable', value);
    if (descendants) {
      for (var i = 0, descendant; descendant = descendants[i]; i++) {
        descendant.setAttribute('unselectable', value);
      }
    }
  }
};
goog.style.getBorderBoxSize = function(element) {
  return new goog.math.Size(
       (element).offsetWidth,
       (element).offsetHeight);
};
goog.style.setBorderBoxSize = function(element, size) {
  var doc = goog.dom.getOwnerDocument(element);
  var isCss1CompatMode = goog.dom.getDomHelper(doc).isCss1CompatMode();
  if (goog.userAgent.IE &&
      !goog.userAgent.isVersionOrHigher('10') &&
      (!isCss1CompatMode || !goog.userAgent.isVersionOrHigher('8'))) {
    var style = element.style;
    if (isCss1CompatMode) {
      var paddingBox = goog.style.getPaddingBox(element);
      var borderBox = goog.style.getBorderBox(element);
      style.pixelWidth = size.width - borderBox.left - paddingBox.left -
                         paddingBox.right - borderBox.right;
      style.pixelHeight = size.height - borderBox.top - paddingBox.top -
                          paddingBox.bottom - borderBox.bottom;
    } else {
      style.pixelWidth = size.width;
      style.pixelHeight = size.height;
    }
  } else {
    goog.style.setBoxSizingSize_(element, size, 'border-box');
  }
};
goog.style.getContentBoxSize = function(element) {
  var doc = goog.dom.getOwnerDocument(element);
  var ieCurrentStyle = goog.userAgent.IE && element.currentStyle;
  if (ieCurrentStyle &&
      goog.dom.getDomHelper(doc).isCss1CompatMode() &&
      ieCurrentStyle.width != 'auto' && ieCurrentStyle.height != 'auto' &&
      !ieCurrentStyle.boxSizing) {
    var width = goog.style.getIePixelValue_(element, ieCurrentStyle.width,
                                            'width', 'pixelWidth');
    var height = goog.style.getIePixelValue_(element, ieCurrentStyle.height,
                                             'height', 'pixelHeight');
    return new goog.math.Size(width, height);
  } else {
    var borderBoxSize = goog.style.getBorderBoxSize(element);
    var paddingBox = goog.style.getPaddingBox(element);
    var borderBox = goog.style.getBorderBox(element);
    return new goog.math.Size(borderBoxSize.width -
                              borderBox.left - paddingBox.left -
                              paddingBox.right - borderBox.right,
                              borderBoxSize.height -
                              borderBox.top - paddingBox.top -
                              paddingBox.bottom - borderBox.bottom);
  }
};
goog.style.setContentBoxSize = function(element, size) {
  var doc = goog.dom.getOwnerDocument(element);
  var isCss1CompatMode = goog.dom.getDomHelper(doc).isCss1CompatMode();
  if (goog.userAgent.IE &&
      !goog.userAgent.isVersionOrHigher('10') &&
      (!isCss1CompatMode || !goog.userAgent.isVersionOrHigher('8'))) {
    var style = element.style;
    if (isCss1CompatMode) {
      style.pixelWidth = size.width;
      style.pixelHeight = size.height;
    } else {
      var paddingBox = goog.style.getPaddingBox(element);
      var borderBox = goog.style.getBorderBox(element);
      style.pixelWidth = size.width + borderBox.left + paddingBox.left +
                         paddingBox.right + borderBox.right;
      style.pixelHeight = size.height + borderBox.top + paddingBox.top +
                          paddingBox.bottom + borderBox.bottom;
    }
  } else {
    goog.style.setBoxSizingSize_(element, size, 'content-box');
  }
};
goog.style.setBoxSizingSize_ = function(element, size, boxSizing) {
  var style = element.style;
  if (goog.userAgent.GECKO) {
    style.MozBoxSizing = boxSizing;
  } else if (goog.userAgent.WEBKIT) {
    style.WebkitBoxSizing = boxSizing;
  } else {
    style.boxSizing = boxSizing;
  }
  style.width = Math.max(size.width, 0) + 'px';
  style.height = Math.max(size.height, 0) + 'px';
};
goog.style.getIePixelValue_ = function(element, value, name, pixelName) {
  if (/^\d+px?$/.test(value)) {
    return parseInt(value, 10);
  } else {
    var oldStyleValue = element.style[name];
    var oldRuntimeValue = element.runtimeStyle[name];
    element.runtimeStyle[name] = element.currentStyle[name];
    element.style[name] = value;
    var pixelValue = element.style[pixelName];
    element.style[name] = oldStyleValue;
    element.runtimeStyle[name] = oldRuntimeValue;
    return pixelValue;
  }
};
goog.style.getIePixelDistance_ = function(element, propName) {
  var value = goog.style.getCascadedStyle(element, propName);
  return value ?
      goog.style.getIePixelValue_(element, value, 'left', 'pixelLeft') : 0;
};
goog.style.getBox_ = function(element, stylePrefix) {
  if (goog.userAgent.IE) {
    var left = goog.style.getIePixelDistance_(element, stylePrefix + 'Left');
    var right = goog.style.getIePixelDistance_(element, stylePrefix + 'Right');
    var top = goog.style.getIePixelDistance_(element, stylePrefix + 'Top');
    var bottom = goog.style.getIePixelDistance_(
        element, stylePrefix + 'Bottom');
    return new goog.math.Box(top, right, bottom, left);
  } else {
    var left = goog.style.getComputedStyle(element, stylePrefix + 'Left');
    var right = goog.style.getComputedStyle(element, stylePrefix + 'Right');
    var top = goog.style.getComputedStyle(element, stylePrefix + 'Top');
    var bottom = goog.style.getComputedStyle(element, stylePrefix + 'Bottom');
    return new goog.math.Box(parseFloat(top),
                             parseFloat(right),
                             parseFloat(bottom),
                             parseFloat(left));
  }
};
goog.style.getPaddingBox = function(element) {
  return goog.style.getBox_(element, 'padding');
};
goog.style.getMarginBox = function(element) {
  return goog.style.getBox_(element, 'margin');
};
goog.style.ieBorderWidthKeywords_ = {
  'thin': 2,
  'medium': 4,
  'thick': 6
};
goog.style.getIePixelBorder_ = function(element, prop) {
  if (goog.style.getCascadedStyle(element, prop + 'Style') == 'none') {
    return 0;
  }
  var width = goog.style.getCascadedStyle(element, prop + 'Width');
  if (width in goog.style.ieBorderWidthKeywords_) {
    return goog.style.ieBorderWidthKeywords_[width];
  }
  return goog.style.getIePixelValue_(element, width, 'left', 'pixelLeft');
};
goog.style.getBorderBox = function(element) {
  if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9)) {
    var left = goog.style.getIePixelBorder_(element, 'borderLeft');
    var right = goog.style.getIePixelBorder_(element, 'borderRight');
    var top = goog.style.getIePixelBorder_(element, 'borderTop');
    var bottom = goog.style.getIePixelBorder_(element, 'borderBottom');
    return new goog.math.Box(top, right, bottom, left);
  } else {
    var left = goog.style.getComputedStyle(element, 'borderLeftWidth');
    var right = goog.style.getComputedStyle(element, 'borderRightWidth');
    var top = goog.style.getComputedStyle(element, 'borderTopWidth');
    var bottom = goog.style.getComputedStyle(element, 'borderBottomWidth');
    return new goog.math.Box(parseFloat(top),
                             parseFloat(right),
                             parseFloat(bottom),
                             parseFloat(left));
  }
};
goog.style.getFontFamily = function(el) {
  var doc = goog.dom.getOwnerDocument(el);
  var font = '';
  if (doc.body.createTextRange && goog.dom.contains(doc, el)) {
    var range = doc.body.createTextRange();
    range.moveToElementText(el);
    try {
      font = range.queryCommandValue('FontName');
    } catch (e) {
      font = '';
    }
  }
  if (!font) {
    font = goog.style.getStyle_(el, 'fontFamily');
  }
  var fontsArray = font.split(',');
  if (fontsArray.length > 1) font = fontsArray[0];
  return goog.string.stripQuotes(font, '"\'');
};
goog.style.lengthUnitRegex_ = /[^\d]+$/;
goog.style.getLengthUnits = function(value) {
  var units = value.match(goog.style.lengthUnitRegex_);
  return units && units[0] || null;
};
goog.style.ABSOLUTE_CSS_LENGTH_UNITS_ = {
  'cm' : 1,
  'in' : 1,
  'mm' : 1,
  'pc' : 1,
  'pt' : 1
};
goog.style.CONVERTIBLE_RELATIVE_CSS_UNITS_ = {
  'em' : 1,
  'ex' : 1
};
goog.style.getFontSize = function(el) {
  var fontSize = goog.style.getStyle_(el, 'fontSize');
  var sizeUnits = goog.style.getLengthUnits(fontSize);
  if (fontSize && 'px' == sizeUnits) {
    return parseInt(fontSize, 10);
  }
  if (goog.userAgent.IE) {
    if (sizeUnits in goog.style.ABSOLUTE_CSS_LENGTH_UNITS_) {
      return goog.style.getIePixelValue_(el,
                                         fontSize,
                                         'left',
                                         'pixelLeft');
    } else if (el.parentNode &&
               el.parentNode.nodeType == goog.dom.NodeType.ELEMENT &&
               sizeUnits in goog.style.CONVERTIBLE_RELATIVE_CSS_UNITS_) {
      var parentElement =  (el.parentNode);
      var parentSize = goog.style.getStyle_(parentElement, 'fontSize');
      return goog.style.getIePixelValue_(parentElement,
                                         fontSize == parentSize ?
                                             '1em' : fontSize,
                                         'left',
                                         'pixelLeft');
    }
  }
  var sizeElement = goog.dom.createDom(
      goog.dom.TagName.SPAN,
      {'style': 'visibility:hidden;position:absolute;' +
            'line-height:0;padding:0;margin:0;border:0;height:1em;'});
  goog.dom.appendChild(el, sizeElement);
  fontSize = sizeElement.offsetHeight;
  goog.dom.removeNode(sizeElement);
  return fontSize;
};
goog.style.parseStyleAttribute = function(value) {
  var result = {};
  goog.array.forEach(value.split(/\s*;\s*/), function(pair) {
    var keyValue = pair.split(/\s*:\s*/);
    if (keyValue.length == 2) {
      result[goog.string.toCamelCase(keyValue[0].toLowerCase())] = keyValue[1];
    }
  });
  return result;
};
goog.style.toStyleAttribute = function(obj) {
  var buffer = [];
  goog.object.forEach(obj, function(value, key) {
    buffer.push(goog.string.toSelectorCase(key), ':', value, ';');
  });
  return buffer.join('');
};
goog.style.setFloat = function(el, value) {
  el.style[goog.userAgent.IE ? 'styleFloat' : 'cssFloat'] = value;
};
goog.style.getFloat = function(el) {
  return el.style[goog.userAgent.IE ? 'styleFloat' : 'cssFloat'] || '';
};
goog.style.getScrollbarWidth = function(opt_className) {
  var outerDiv = goog.dom.createElement(goog.dom.TagName.DIV);
  if (opt_className) {
    outerDiv.className = opt_className;
  }
  outerDiv.style.cssText = 'overflow:auto;' +
      'position:absolute;top:0;width:100px;height:100px';
  var innerDiv = goog.dom.createElement(goog.dom.TagName.DIV);
  goog.style.setSize(innerDiv, '200px', '200px');
  outerDiv.appendChild(innerDiv);
  goog.dom.appendChild(goog.dom.getDocument().body, outerDiv);
  var width = outerDiv.offsetWidth - outerDiv.clientWidth;
  goog.dom.removeNode(outerDiv);
  return width;
};
goog.style.MATRIX_TRANSLATION_REGEX_ =
    new RegExp('matrix\\([0-9\\.\\-]+, [0-9\\.\\-]+, ' +
               '[0-9\\.\\-]+, [0-9\\.\\-]+, ' +
               '([0-9\\.\\-]+)p?x?, ([0-9\\.\\-]+)p?x?\\)');
goog.style.getCssTranslation = function(element) {
  var transform = goog.style.getComputedTransform(element);
  if (!transform) {
    return new goog.math.Coordinate(0, 0);
  }
  var matches = transform.match(goog.style.MATRIX_TRANSLATION_REGEX_);
  if (!matches) {
    return new goog.math.Coordinate(0, 0);
  }
  return new goog.math.Coordinate(parseFloat(matches[1]),
                                  parseFloat(matches[2]));
};

// goog.style.bidi
goog.provide('goog.style.bidi');
goog.style.bidi.getScrollLeft = function(element) {
  var isRtl = goog.style.isRightToLeft(element);
  if (isRtl && goog.userAgent.GECKO) {
    return -element.scrollLeft;
  } else if (isRtl &&
             !(goog.userAgent.IE && goog.userAgent.isVersionOrHigher('8'))) {
    var overflowX = goog.style.getComputedOverflowX(element);
    if (overflowX == 'visible') {
      return element.scrollLeft;
    } else {
      return element.scrollWidth - element.clientWidth - element.scrollLeft;
    }
  }
  return element.scrollLeft;
};
goog.style.bidi.getOffsetStart = function(element) {
  element =  (element);
  var offsetLeftForReal = element.offsetLeft;
  var bestParent = element.offsetParent;
  if (!bestParent && goog.style.getComputedPosition(element) == 'fixed') {
    bestParent = goog.dom.getOwnerDocument(element).documentElement;
  }
  if (!bestParent) {
    return offsetLeftForReal;
  }
  if (goog.userAgent.GECKO) {
    var borderWidths = goog.style.getBorderBox(bestParent);
    offsetLeftForReal += borderWidths.left;
  } else if (goog.userAgent.isDocumentModeOrHigher(8) &&
             !goog.userAgent.isDocumentModeOrHigher(9)) {
    var borderWidths = goog.style.getBorderBox(bestParent);
    offsetLeftForReal -= borderWidths.left;
  }
  if (goog.style.isRightToLeft(bestParent)) {
    var elementRightOffset = offsetLeftForReal + element.offsetWidth;
    return bestParent.clientWidth - elementRightOffset;
  }
  return offsetLeftForReal;
};
goog.style.bidi.setScrollOffset = function(element, offsetStart) {
  offsetStart = Math.max(offsetStart, 0);
  if (!goog.style.isRightToLeft(element)) {
    element.scrollLeft = offsetStart;
  } else if (goog.userAgent.GECKO) {
    element.scrollLeft = -offsetStart;
  } else if (!(goog.userAgent.IE && goog.userAgent.isVersionOrHigher('8'))) {
    element.scrollLeft =
        element.scrollWidth - offsetStart - element.clientWidth;
  } else {
    element.scrollLeft = offsetStart;
  }
};
goog.style.bidi.setPosition = function(elem, left, top, isRtl) {
  if (!goog.isNull(top)) {
    elem.style.top = top + 'px';
  }
  if (isRtl) {
    elem.style.right = left + 'px';
    elem.style.left = '';
  } else {
    elem.style.left = left + 'px';
    elem.style.right = '';
  }
};

// goog.positioning
// goog.positioning.Corner
// goog.positioning.CornerBit
// goog.positioning.Overflow
// goog.positioning.OverflowStatus
goog.provide('goog.positioning');
goog.provide('goog.positioning.Corner');
goog.provide('goog.positioning.CornerBit');
goog.provide('goog.positioning.Overflow');
goog.provide('goog.positioning.OverflowStatus');
goog.positioning.Corner = {
  TOP_LEFT: 0,
  TOP_RIGHT: 2,
  BOTTOM_LEFT: 1,
  BOTTOM_RIGHT: 3,
  TOP_START: 4,
  TOP_END: 6,
  BOTTOM_START: 5,
  BOTTOM_END: 7
};
goog.positioning.CornerBit = {
  BOTTOM: 1,
  RIGHT: 2,
  FLIP_RTL: 4
};
goog.positioning.Overflow = {
  IGNORE: 0,
  ADJUST_X: 1,
  FAIL_X: 2,
  ADJUST_Y: 4,
  FAIL_Y: 8,
  RESIZE_WIDTH: 16,
  RESIZE_HEIGHT: 32,
  ADJUST_X_EXCEPT_OFFSCREEN: 64 | 1,
  ADJUST_Y_EXCEPT_OFFSCREEN: 128 | 4
};
goog.positioning.OverflowStatus = {
  NONE: 0,
  ADJUSTED_X: 1,
  ADJUSTED_Y: 2,
  WIDTH_ADJUSTED: 4,
  HEIGHT_ADJUSTED: 8,
  FAILED_LEFT: 16,
  FAILED_RIGHT: 32,
  FAILED_TOP: 64,
  FAILED_BOTTOM: 128,
  FAILED_OUTSIDE_VIEWPORT: 256
};
goog.positioning.OverflowStatus.FAILED =
    goog.positioning.OverflowStatus.FAILED_LEFT |
    goog.positioning.OverflowStatus.FAILED_RIGHT |
    goog.positioning.OverflowStatus.FAILED_TOP |
    goog.positioning.OverflowStatus.FAILED_BOTTOM |
    goog.positioning.OverflowStatus.FAILED_OUTSIDE_VIEWPORT;
goog.positioning.OverflowStatus.FAILED_HORIZONTAL =
    goog.positioning.OverflowStatus.FAILED_LEFT |
    goog.positioning.OverflowStatus.FAILED_RIGHT;
goog.positioning.OverflowStatus.FAILED_VERTICAL =
    goog.positioning.OverflowStatus.FAILED_TOP |
    goog.positioning.OverflowStatus.FAILED_BOTTOM;
goog.positioning.positionAtAnchor = function(anchorElement,
                                             anchorElementCorner,
                                             movableElement,
                                             movableElementCorner,
                                             opt_offset,
                                             opt_margin,
                                             opt_overflow,
                                             opt_preferredSize,
                                             opt_viewport) {
  goog.asserts.assert(movableElement);
  var movableParentTopLeft =
      goog.positioning.getOffsetParentPageOffset(movableElement);
  var anchorRect = goog.positioning.getVisiblePart_(anchorElement);
  goog.style.translateRectForAnotherFrame(
      anchorRect,
      goog.dom.getDomHelper(anchorElement),
      goog.dom.getDomHelper(movableElement));
  var corner = goog.positioning.getEffectiveCorner(anchorElement,
                                                   anchorElementCorner);
  var absolutePos = new goog.math.Coordinate(
      corner & goog.positioning.CornerBit.RIGHT ?
          anchorRect.left + anchorRect.width : anchorRect.left,
      corner & goog.positioning.CornerBit.BOTTOM ?
          anchorRect.top + anchorRect.height : anchorRect.top);
  absolutePos =
      goog.math.Coordinate.difference(absolutePos, movableParentTopLeft);
  if (opt_offset) {
    absolutePos.x += (corner & goog.positioning.CornerBit.RIGHT ? -1 : 1) *
        opt_offset.x;
    absolutePos.y += (corner & goog.positioning.CornerBit.BOTTOM ? -1 : 1) *
        opt_offset.y;
  }
  var viewport;
  if (opt_overflow) {
    if (opt_viewport) {
      viewport = opt_viewport;
    } else {
      viewport = goog.style.getVisibleRectForElement(movableElement);
      if (viewport) {
        viewport.top -= movableParentTopLeft.y;
        viewport.right -= movableParentTopLeft.x;
        viewport.bottom -= movableParentTopLeft.y;
        viewport.left -= movableParentTopLeft.x;
      }
    }
  }
  return goog.positioning.positionAtCoordinate(absolutePos,
                                               movableElement,
                                               movableElementCorner,
                                               opt_margin,
                                               viewport,
                                               opt_overflow,
                                               opt_preferredSize);
};
goog.positioning.getOffsetParentPageOffset = function(movableElement) {
  var movableParentTopLeft;
  var parent = movableElement.offsetParent;
  if (parent) {
    var isBody = parent.tagName == goog.dom.TagName.HTML ||
        parent.tagName == goog.dom.TagName.BODY;
    if (!isBody ||
        goog.style.getComputedPosition(parent) != 'static') {
      movableParentTopLeft = goog.style.getPageOffset(parent);
      if (!isBody) {
        movableParentTopLeft = goog.math.Coordinate.difference(
            movableParentTopLeft,
            new goog.math.Coordinate(goog.style.bidi.getScrollLeft(parent),
                parent.scrollTop));
      }
    }
  }
  return movableParentTopLeft || new goog.math.Coordinate();
};
goog.positioning.getVisiblePart_ = function(el) {
  var rect = goog.style.getBounds(el);
  var visibleBox = goog.style.getVisibleRectForElement(el);
  if (visibleBox) {
    rect.intersection(goog.math.Rect.createFromBox(visibleBox));
  }
  return rect;
};
goog.positioning.positionAtCoordinate = function(absolutePos,
                                                 movableElement,
                                                 movableElementCorner,
                                                 opt_margin,
                                                 opt_viewport,
                                                 opt_overflow,
                                                 opt_preferredSize) {
  absolutePos = absolutePos.clone();
  var corner = goog.positioning.getEffectiveCorner(movableElement,
                                                   movableElementCorner);
  var elementSize = goog.style.getSize(movableElement);
  var size = opt_preferredSize ? opt_preferredSize.clone() :
      elementSize.clone();
  var positionResult = goog.positioning.getPositionAtCoordinate(absolutePos,
      size, corner, opt_margin, opt_viewport, opt_overflow);
  if (positionResult.status & goog.positioning.OverflowStatus.FAILED) {
    return positionResult.status;
  }
  goog.style.setPosition(movableElement, positionResult.rect.getTopLeft());
  size = positionResult.rect.getSize();
  if (!goog.math.Size.equals(elementSize, size)) {
    goog.style.setBorderBoxSize(movableElement, size);
  }
  return positionResult.status;
};
goog.positioning.getPositionAtCoordinate = function(
    absolutePos,
    elementSize,
    elementCorner,
    opt_margin,
    opt_viewport,
    opt_overflow) {
  absolutePos = absolutePos.clone();
  elementSize = elementSize.clone();
  var status = goog.positioning.OverflowStatus.NONE;
  if (opt_margin || elementCorner != goog.positioning.Corner.TOP_LEFT) {
    if (elementCorner & goog.positioning.CornerBit.RIGHT) {
      absolutePos.x -= elementSize.width + (opt_margin ? opt_margin.right : 0);
    } else if (opt_margin) {
      absolutePos.x += opt_margin.left;
    }
    if (elementCorner & goog.positioning.CornerBit.BOTTOM) {
      absolutePos.y -= elementSize.height +
          (opt_margin ? opt_margin.bottom : 0);
    } else if (opt_margin) {
      absolutePos.y += opt_margin.top;
    }
  }
  if (opt_overflow) {
    status = opt_viewport ?
        goog.positioning.adjustForViewport_(
            absolutePos, elementSize, opt_viewport, opt_overflow) :
        goog.positioning.OverflowStatus.FAILED_OUTSIDE_VIEWPORT;
  }
  var rect = new goog.math.Rect(0, 0, 0, 0);
  rect.left = absolutePos.x;
  rect.top = absolutePos.y;
  rect.width = elementSize.width;
  rect.height = elementSize.height;
  return {rect: rect, status: status};
};
goog.positioning.adjustForViewport_ = function(pos, size, viewport, overflow) {
  var status = goog.positioning.OverflowStatus.NONE;
  var ADJUST_X_EXCEPT_OFFSCREEN =
      goog.positioning.Overflow.ADJUST_X_EXCEPT_OFFSCREEN;
  var ADJUST_Y_EXCEPT_OFFSCREEN =
      goog.positioning.Overflow.ADJUST_Y_EXCEPT_OFFSCREEN;
  if ((overflow & ADJUST_X_EXCEPT_OFFSCREEN) == ADJUST_X_EXCEPT_OFFSCREEN &&
      (pos.x < viewport.left || pos.x >= viewport.right)) {
    overflow &= ~goog.positioning.Overflow.ADJUST_X;
  }
  if ((overflow & ADJUST_Y_EXCEPT_OFFSCREEN) == ADJUST_Y_EXCEPT_OFFSCREEN &&
      (pos.y < viewport.top || pos.y >= viewport.bottom)) {
    overflow &= ~goog.positioning.Overflow.ADJUST_Y;
  }
  if (pos.x < viewport.left && overflow & goog.positioning.Overflow.ADJUST_X) {
    pos.x = viewport.left;
    status |= goog.positioning.OverflowStatus.ADJUSTED_X;
  }
  if (overflow & goog.positioning.Overflow.RESIZE_WIDTH) {
    var originalX = pos.x;
    if (pos.x < viewport.left) {
      pos.x = viewport.left;
      status |= goog.positioning.OverflowStatus.WIDTH_ADJUSTED;
    }
    if (pos.x + size.width > viewport.right) {
      size.width = Math.min(
          viewport.right - pos.x, originalX + size.width - viewport.left);
      size.width = Math.max(size.width, 0);
      status |= goog.positioning.OverflowStatus.WIDTH_ADJUSTED;
    }
  }
  if (pos.x + size.width > viewport.right &&
      overflow & goog.positioning.Overflow.ADJUST_X) {
    pos.x = Math.max(viewport.right - size.width, viewport.left);
    status |= goog.positioning.OverflowStatus.ADJUSTED_X;
  }
  if (overflow & goog.positioning.Overflow.FAIL_X) {
    status |= (pos.x < viewport.left ?
                   goog.positioning.OverflowStatus.FAILED_LEFT : 0) |
              (pos.x + size.width > viewport.right ?
                   goog.positioning.OverflowStatus.FAILED_RIGHT : 0);
  }
  if (pos.y < viewport.top && overflow & goog.positioning.Overflow.ADJUST_Y) {
    pos.y = viewport.top;
    status |= goog.positioning.OverflowStatus.ADJUSTED_Y;
  }
  if (overflow & goog.positioning.Overflow.RESIZE_HEIGHT) {
    var originalY = pos.y;
    if (pos.y < viewport.top) {
      pos.y = viewport.top;
      status |= goog.positioning.OverflowStatus.HEIGHT_ADJUSTED;
    }
    if (pos.y + size.height > viewport.bottom) {
      size.height = Math.min(
          viewport.bottom - pos.y, originalY + size.height - viewport.top);
      size.height = Math.max(size.height, 0);
      status |= goog.positioning.OverflowStatus.HEIGHT_ADJUSTED;
    }
  }
  if (pos.y + size.height > viewport.bottom &&
      overflow & goog.positioning.Overflow.ADJUST_Y) {
    pos.y = Math.max(viewport.bottom - size.height, viewport.top);
    status |= goog.positioning.OverflowStatus.ADJUSTED_Y;
  }
  if (overflow & goog.positioning.Overflow.FAIL_Y) {
    status |= (pos.y < viewport.top ?
                   goog.positioning.OverflowStatus.FAILED_TOP : 0) |
              (pos.y + size.height > viewport.bottom ?
                   goog.positioning.OverflowStatus.FAILED_BOTTOM : 0);
  }
  return status;
};
goog.positioning.getEffectiveCorner = function(element, corner) {
  return  (
      (corner & goog.positioning.CornerBit.FLIP_RTL &&
          goog.style.isRightToLeft(element) ?
          corner ^ goog.positioning.CornerBit.RIGHT :
          corner
      ) & ~goog.positioning.CornerBit.FLIP_RTL);
};
goog.positioning.flipCornerHorizontal = function(corner) {
  return  (corner ^
      goog.positioning.CornerBit.RIGHT);
};
goog.positioning.flipCornerVertical = function(corner) {
  return  (corner ^
      goog.positioning.CornerBit.BOTTOM);
};
goog.positioning.flipCorner = function(corner) {
  return  (corner ^
      goog.positioning.CornerBit.BOTTOM ^
      goog.positioning.CornerBit.RIGHT);
};

// i18n.input.common.GlobalSettings
goog.provide('i18n.input.common.GlobalSettings');
i18n.input.common.GlobalSettings.ApplicationName = 'jsapi';
i18n.input.common.GlobalSettings.KeyboardHelpUrl = '';
i18n.input.common.GlobalSettings.KeyboardShowMinMax = false;
i18n.input.common.GlobalSettings.ShowStatusBar = true;
i18n.input.common.GlobalSettings.showGoogleLogo = false;
i18n.input.common.GlobalSettings.StatusBarToggleLanguageShortcut = 'shift';
i18n.input.common.GlobalSettings.StatusBarToggleSbcShortcut = 'shift+space';
i18n.input.common.GlobalSettings.StatusBarPunctuationShortcut = 'ctrl+.';
i18n.input.common.GlobalSettings.KeyboardDefaultLocation =
    goog.positioning.Corner.BOTTOM_END;
i18n.input.common.GlobalSettings.HandwritingDefaultLocation =
    goog.positioning.Corner.BOTTOM_END;
i18n.input.common.GlobalSettings.isOfflineMode = false;
i18n.input.common.GlobalSettings.canSendFakeEvents = true;
i18n.input.common.GlobalSettings.canListenInCaptureForIE8 =
    !goog.userAgent.IE || goog.userAgent.isVersionOrHigher(9);
i18n.input.common.GlobalSettings.chromeExtension = {
  ACT_FLAG: 'IS_INPUT_ACTIVE',
  ACTIVE_UI_IFRAME_ID: 'GOOGLE_INPUT_ACTIVE_UI',
  APP_FLAG: 'GOOGLE_INPUT_NON_CHEXT_FLAG',
  CHEXT_FLAG: 'GOOGLE_INPUT_CHEXT_FLAG',
  INPUTTOOL: 'input',
  INPUTTOOL_STAT: 'input_stat',
  STATUS_BAR_IFRAME_ID: 'GOOGLE_INPUT_STATUS_BAR'
};
i18n.input.common.GlobalSettings.BUILD_SOURCE = 'jsapi';
i18n.input.common.GlobalSettings.ENABLE_XHR = false;
i18n.input.common.GlobalSettings.enableStatusBarMetrics = false;
i18n.input.common.GlobalSettings.onScreenKeyboard = true;
i18n.input.common.GlobalSettings.enableUserDict = false;
i18n.input.common.GlobalSettings.MAX_INT = 2147483647;
i18n.input.common.GlobalSettings.enableUserPrefs = true;
i18n.input.common.GlobalSettings.IFRAME_WRAPPER = false;
i18n.input.common.GlobalSettings.css = '';
i18n.input.common.GlobalSettings.alternativeImageUrl = '';
i18n.input.common.GlobalSettings.enableVoice = false;
i18n.input.common.GlobalSettings.enableGlobalEventDelegate = true;
i18n.input.common.GlobalSettings.mobile = goog.userAgent.MOBILE;
i18n.input.common.GlobalSettings.simpleEasyAccents = false;

// i18n.input.lang.InputToolCode
goog.provide('i18n.input.lang.InputToolCode');
i18n.input.lang.InputToolCode = {
  INPUTMETHOD_ARRAY92_CHINESE_TRADITIONAL: 'zh-hant-t-i0-array-1992',
  INPUTMETHOD_CANGJIE82_CHINESE_SIMPLIFIED: 'zh-hans-t-i0-cangjie-1982',
  INPUTMETHOD_CANGJIE82_CHINESE_TRADITIONAL: 'zh-hant-t-i0-cangjie-1982',
  INPUTMETHOD_CANGJIE87_CHINESE_SIMPLIFIED: 'zh-hans-t-i0-cangjie-1987',
  INPUTMETHOD_CANGJIE87_CHINESE_TRADITIONAL: 'zh-hant-t-i0-cangjie-1987',
  INPUTMETHOD_CANGJIE87_QUICK_CHINESE_TRADITIONAL:
      'zh-hant-t-i0-cangjie-1987-x-m0-simplified',
  INPUTMETHOD_CANTONESE_TRADITIONAL: 'yue-hant-t-i0-und',
  INPUTMETHOD_DAYI88_CHINESE_TRADITIONAL: 'zh-hant-t-i0-dayi-1988',
  INPUTMETHOD_PINYIN_CHINESE_SIMPLIFIED: 'zh-t-i0-pinyin',
  INPUTMETHOD_PINYIN_CHINESE_TRADITIONAL: 'zh-hant-t-i0-pinyin',
  INPUTMETHOD_HANGUL_KOREAN: 'ko-t-i0-und',
  INPUTMETHOD_SHUANGPING_ABC: 'zh-t-i0-pinyin-x0-shuangpin-abc',
  INPUTMETHOD_SHUANGPING_FLYPY: 'zh-t-i0-pinyin-x0-shuangpin-flypy',
  INPUTMETHOD_SHUANGPING_JIAJIA: 'zh-t-i0-pinyin-x0-shuangpin-jiajia',
  INPUTMETHOD_SHUANGPING_MS: 'zh-t-i0-pinyin-x0-shuangpin-ms',
  INPUTMETHOD_SHUANGPING_ZIGUANG: 'zh-t-i0-pinyin-x0-shuangpin-ziguang',
  INPUTMETHOD_SHUANGPING_ZIRANMA: 'zh-t-i0-pinyin-x0-shuangpin-ziranma',
  INPUTMETHOD_TRANSLITERATION_AMHARIC: 'am-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_ARABIC: 'ar-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_BELARUSIAN: 'be-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_BENGALI: 'bn-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_BULGARIAN: 'bg-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_DUTCH: 'nl-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_ENGLISH: 'en-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_FRENCH: 'fr-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_GERMAN: 'de-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_GREEK: 'el-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_GUJARATI: 'gu-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_HEBREW: 'he-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_HINDI: 'hi-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_HIRAGANA: 'ja-hira-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_ITALIAN: 'it-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_JAPANESE: 'ja-t-ja-hira-i0-und',
  INPUTMETHOD_TRANSLITERATION_KANNADA: 'kn-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_MALAYALAM: 'ml-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_MARATHI: 'mr-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_NEPALI: 'ne-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_ORIYA: 'or-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_PERSIAN: 'fa-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_POLISH: 'pl-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_PORTUGUESE: 'pt-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_PORTUGUESE_BRRAZIL: 'pt-br-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_PORTUGUESE_PORTUGAL: 'pt-pt-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_PUNJABI: 'pa-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_RUSSIAN: 'ru-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_SANSKRIT: 'sa-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_SERBIAN: 'sr-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_SINHALESE: 'si-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_SPANISH: 'es-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_TAMIL: 'ta-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_TELUGU: 'te-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_TIGRINYA: 'ti-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_TURKISH: 'tr' + '-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_UKRAINE: 'uk-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_URDU: 'ur-t-i0-und',
  INPUTMETHOD_TRANSLITERATION_VIETNAMESE: 'vi-t-i0-und',
  INPUTMETHOD_WUBI_CHINESE_SIMPLIFIED: 'zh-t-i0-wubi-1986',
  INPUTMETHOD_ZHUYIN_CHINESE_TRADITIONAL: 'zh-hant-t-i0-und',
  INPUTMETHOD_ZHUYIN_CHINESE_TRADITIONAL_BOPOMOFO: 'zh-hant-t-i0-bopomofo',
  KEYBOARD_ALBANIAN: 'sq-t-k0-und',
  KEYBOARD_ARABIC: 'ar-t-k0-und',
  KEYBOARD_ARMENIAN_EASTERN: 'hy-hyr-t-k0-und',
  KEYBOARD_ARMENIAN_WESTERN: 'hy-hyt-t-k0-und',
  KEYBOARD_BASQUE: 'eu-t-k0-und',
  KEYBOARD_BELARUSIAN: 'be-t-k0-und',
  KEYBOARD_BENGALI_INSCRIPT: 'bn-t-k0-und',
  KEYBOARD_BENGALI_PHONETIC: 'bn-t-und-latn-k0-und',
  KEYBOARD_BOSNIAN: 'bs-t-k0-und',
  KEYBOARD_BRAZILIAN_PORTUGUESE: 'pt-br-t-k0-und',
  KEYBOARD_BULGARIAN: 'bg-t-k0-und',
  KEYBOARD_BULGARIAN_PHONETIC: 'bg-t-k0-qwerty',
  KEYBOARD_CATALAN: 'ca-t-k0-und',
  KEYBOARD_CHEROKEE: 'chr-t-k0-und',
  KEYBOARD_CHEROKEE_PHONETIC: 'chr-t-und-latn-k0-und',
  KEYBOARD_CROATIAN: 'hr-t-k0-und',
  KEYBOARD_CZECH: 'cs-t-k0-und',
  KEYBOARD_CZECH_QWERTZ: 'cs-t-k0-qwertz',
  KEYBOARD_DANISH: 'da-t-k0-und',
  KEYBOARD_DARI: 'prs-t-k0-und',
  KEYBOARD_DEVANAGARI_PHONETIC: 'hi-t-k0-qwerty',
  KEYBOARD_DUTCH: 'nl-t-k0-und',
  KEYBOARD_DUTCH_INTL: 'nl-t-k0-intl',
  KEYBOARD_DZONGKHA: 'dz-t-k0-und',
  KEYBOARD_ENGLISH: 'en-t-k0-und',
  KEYBOARD_ENGLISH_DVORAK: 'en-t-k0-dvorak',
  KEYBOARD_ESTONIAN: 'et-t-k0-und',
  KEYBOARD_ETHIOPIC: 'und-ethi-t-k0-und',
  KEYBOARD_TIGRINYA_ETHIOPIC: 'ti-ethi-t-k0-und',
  KEYBOARD_FINNISH: 'fi-t-k0-und',
  KEYBOARD_FRENCH: 'fr-t-k0-und',
  KEYBOARD_FRENCH_INTL: 'fr-t-k0-intl',
  KEYBOARD_GALICIAN: 'gl-t-k0-und',
  KEYBOARD_GEORGIAN_QWERTY: 'ka-t-k0-und',
  KEYBOARD_GEORGIAN_TYPEWRITER: 'ka-t-k0-legacy',
  KEYBOARD_GERMAN: 'de-t-k0-und',
  KEYBOARD_GERMAN_INTL: 'de-t-k0-intl',
  KEYBOARD_GREEK: 'el-t-k0-und',
  KEYBOARD_GUJARATI_INSCRIPT: 'gu-t-k0-und',
  KEYBOARD_GUJARATI_PHONETIC: 'gu-t-und-latn-k0-qwerty',
  KEYBOARD_GURMUKHI_INSCRIPT: 'pa-guru-t-k0-und',
  KEYBOARD_GURMUKHI_PHONETIC: 'pa-guru-t-und-latn-k0-und',
  KEYBOARD_HAITIAN: 'ht-t-k0-und',
  KEYBOARD_HEBREW: 'he-t-k0-und',
  KEYBOARD_HINDI: 'hi-t-k0-und',
  KEYBOARD_HUNGARIAN_101: 'hu-t-k0-101key',
  KEYBOARD_ICELANDIC: 'is-t-k0-und',
  KEYBOARD_INDONESIAN: 'id-t-k0-und',
  KEYBOARD_INUKTITUT_NUNAVIK: 'iu-t-k0-nunavik',
  KEYBOARD_INUKTITUT_NUNAVUT: 'iu-t-k0-nunavut',
  KEYBOARD_IRISH: 'ga-t-k0-und',
  KEYBOARD_ITALIAN: 'it-t-k0-und',
  KEYBOARD_ITALIAN_INTL: 'it-t-k0-intl',
  KEYBOARD_JAVANESE: 'jw-t-k0-und',
  KEYBOARD_KANNADA_INSCRIPT: 'kn-t-k0-und',
  KEYBOARD_KANNADA_PHONETIC: 'kn-t-und-latn-k0-und',
  KEYBOARD_KAZAKH: 'kk-t-k0-und',
  KEYBOARD_KHMER: 'km-t-k0-und',
  KEYBOARD_KOREAN: 'ko-t-k0-und',
  KEYBOARD_KYRGYZ: 'ky-cyrl-t-k0-und',
  KEYBOARD_LAO: 'lo-t-k0-und',
  KEYBOARD_LATVIAN: 'lv-t-k0-und',
  KEYBOARD_LISU: 'lis-t-k0-und',
  KEYBOARD_LITHUANIAN: 'lt-t-k0-und',
  KEYBOARD_MACEDONIAN: 'mk-t-k0-und',
  KEYBOARD_MALAY: 'ms-t-k0-und',
  KEYBOARD_MALAYALAM_INSCRIPT: 'ml-t-k0-und',
  KEYBOARD_MALAYALAM_PHONETIC: 'ml-t-und-latn-k0-und',
  KEYBOARD_MALTESE: 'mt-t-k0-und',
  KEYBOARD_MAORI: 'mi-t-k0-und',
  KEYBOARD_MARATHI: 'mr-t-k0-und',
  KEYBOARD_MARATHI_INSCRIPT: 'mr-t-k0-devanaga',
  KEYBOARD_MONGOLIAN_CYRILLIC: 'mn-cyrl-t-k0-und',
  KEYBOARD_MONTENEGRIN: 'srp-t-k0-und',
  KEYBOARD_MYANMAR: 'my-t-k0-und',
  KEYBOARD_MYANMAR_MYANSAN: 'my-t-k0-myansan',
  KEYBOARD_NAVAJO: 'nv-t-k0-und',
  KEYBOARD_NAVAJO_STANDARD: 'nv-t-k0-std',
  KEYBOARD_NEPALI_INSCRIPT: 'ne-t-k0-und',
  KEYBOARD_NEPALI_PHONETIC: 'ne-t-und-latn-k0-und',
  KEYBOARD_NORWEGIAN: 'no-t-k0-und',
  KEYBOARD_ORIYA_INSCRIPT: 'or-t-k0-und',
  KEYBOARD_ORIYA_PHONETIC: 'or-t-und-latn-k0-und',
  KEYBOARD_PAN_AFRICA_LATIN: 'latn-002-t-k0-und',
  KEYBOARD_PASHTO: 'ps-t-k0-und',
  KEYBOARD_PERSIAN: 'fa-t-k0-und',
  KEYBOARD_POLISH: 'pl-t-k0-und',
  KEYBOARD_PORTUGUESE: 'pt-pt-t-k0-und',
  KEYBOARD_PORTUGUESE_BRAZIL_INTL: 'pt-br-t-k0-intl',
  KEYBOARD_PORTUGUESE_PORTUGAL_INTL: 'pt-pt-t-k0-intl',
  KEYBOARD_ROMANI: 'rom-t-k0-und',
  KEYBOARD_ROMANIAN: 'ro-t-k0-und',
  KEYBOARD_ROMANIAN_SR13392_PRIMARY: 'ro-t-k0-legacy',
  KEYBOARD_ROMANIAN_SR13392_SECONDARY: 'ro-t-k0-extended',
  KEYBOARD_RUSSIAN: 'ru-t-k0-und',
  KEYBOARD_RUSSIAN_PHONETIC: 'ru-t-k0-qwerty',
  KEYBOARD_RUSSIAN_PHONETIC_AATSEEL: 'ru-t-k0-aatseel',
  KEYBOARD_RUSSIAN_PHONETIC_YAZHERT: 'ru-t-k0-yazhert',
  KEYBOARD_SANSKRIT_PHONETIC: 'sa-t-und-latn-k0-und',
  KEYBOARD_SANSKRIT_INSCRIPT: 'sa-t-k0-devanaga',
  KEYBOARD_SENECA: 'see-t-k0-und',
  KEYBOARD_SERBIAN_CYRILLIC: 'sr-cyrl-t-k0-und',
  KEYBOARD_SERBIAN_LATIN: 'sr-latn-t-k0-und',
  KEYBOARD_SINDHI: 'sd-t-k0-und',
  KEYBOARD_SINHALA: 'si-t-k0-und',
  KEYBOARD_SLOVAK: 'sk-t-k0-und',
  KEYBOARD_SLOVAK_QWERTY: 'sk-t-k0-qwerty',
  KEYBOARD_SLOVENIAN: 'sl-t-k0-und',
  KEYBOARD_SORANI_KURDISH_AR: 'ckb-t-k0-ar',  // Arabic-based
  KEYBOARD_SORANI_KURDISH_EN: 'ckb-t-k0-en',  // English-based
  KEYBOARD_SOUTHERN_UZBEK: 'uzs-t-k0-und',
  KEYBOARD_SPANISH: 'es-t-k0-und',
  KEYBOARD_SPANISH_INTL: 'es-t-k0-intl',
  KEYBOARD_SWAHILI: 'sw-t-k0-und',
  KEYBOARD_SWEDISH: 'sv-t-k0-und',
  KEYBOARD_SWISS_GERMAN: 'de-ch-t-k0-und',
  KEYBOARD_TAGALOG: 'tl-t-k0-und',
  KEYBOARD_TAJIK: 'tg-t-k0-und',
  KEYBOARD_TAMIL_99: 'ta-t-k0-ta99',
  KEYBOARD_TAMIL_INSCRIPT: 'ta-t-k0-und',
  KEYBOARD_TAMIL_ITRANS: 'ta-t-k0-itrans',
  KEYBOARD_TAMIL_PHONETIC: 'ta-t-und-latn-k0-und',
  KEYBOARD_TAMIL_TYPEWRITER: 'ta-t-k0-typewriter',
  KEYBOARD_TATAR: 'tt-t-k0-und',
  KEYBOARD_TELUGU_INSCRIPT: 'te-t-k0-und',
  KEYBOARD_TELUGU_PHONETIC: 'te-t-und-latn-k0-und',
  KEYBOARD_THAI: 'th-t-k0-und',
  KEYBOARD_THAI_PATTAJOTI: 'th-t-k0-pattajoti',
  KEYBOARD_THAI_TIS: 'th-t-k0-tis',
  KEYBOARD_TIGRINYA: 'ti-t-k0-und',
  KEYBOARD_TURKISH_F: 'tr' + '-t-k0-legacy',
  KEYBOARD_TURKISH_Q: 'tr' + '-t-k0-und',
  KEYBOARD_UIGHUR: 'ug-t-k0-und',
  KEYBOARD_UKRAINIAN_101: 'uk-t-k0-101key',
  KEYBOARD_URDU: 'ur-t-k0-und',
  KEYBOARD_US_INTERNATIONAL: 'en-us-t-k0-intl',
  KEYBOARD_UZBEK_CYRILLIC_PHONETIC: 'uz-cyrl-t-k0-und',
  KEYBOARD_UZBEK_CYRILLIC_TYPEWRITTER: 'uz-cyrl-t-k0-legacy',
  KEYBOARD_UZBEK_LATIN: 'uz-latn-t-k0-und',
  KEYBOARD_VIETNAMESE_TCVN: 'vi-t-k0-und',
  KEYBOARD_VIETNAMESE_TELEX: 'vi-t-k0-legacy',
  KEYBOARD_VIETNAMESE_VIQR: 'vi-t-k0-viqr',
  KEYBOARD_VIETNAMESE_VNI: 'vi-t-k0-vni',
  KEYBOARD_WELSH: 'cy-t-k0-und',
  KEYBOARD_YIDDISH: 'yi-t-k0-und',
  KEYBOARD_GENMAN_ACCENTS: 'de-t-k0-accents',
  KEYBOARD_SPANISH_ACCENTS: 'es-t-k0-accents',
  KEYBOARD_FRENCH_ACCENTS: 'fr-t-k0-accents',
  KEYBOARD_ITALIAN_ACCENTS: 'it-t-k0-accents',
  EYBOARD_DUTCH_ACCENTS: 'nl-t-k0-accents',
  KEYBOARD_POLISH_ACCENTS: 'pl-t-k0-accents',
  KEYBOARD_PORTUGUESE_BRAZIL_ACCENTS: 'pt-br-t-k0-accents',
  KEYBOARD_PORTUGUESE_PORTUGAL_ACCENTS: 'pt-pt-t-k0-accents',
  KEYBOARD_TURKISH_F_ACCENTS: 'tr' + '-t-k0-f-accents',
  KEYBOARD_TURKISH_Q_ACCENTS: 'tr' + '-t-k0-q-accents',
  KEYBOARD_CORSICAN_ACCENTS: 'co-t-k0-accents',
  KEYBOARD_HAWAIIAN_ACCENTS: 'haw-t-k0-accents',
  KEYBOARD_SAMOAN_ACCENTS: 'sm-t-k0-accents',
  KEYBOARD_SCOTS_GAELIC_ACCENTS: 'gd-t-k0-accents',
  KEYBOARD_WEST_FRISIAN_ACCENTS: 'fy-t-k0-accents',
  KEYBORAD_LUXEMBOURGISH_ACCENTS: 'lb-t-k0-accents',
  HANDWRIT_AFRIKAANS: 'af-t-i0-handwrit',
  HANDWRIT_ALBANIAN: 'sq-t-i0-handwrit',
  HANDWRIT_ARABIC: 'ar-t-i0-handwrit',
  HANDWRIT_AZERBAIJANI: 'az-t-i0-handwrit',
  HANDWRIT_BASQUE: 'eu-t-i0-handwrit',
  HANDWRIT_BELARUSIAN: 'be-t-i0-handwrit',
  HANDWRIT_BENGALI: 'bn-t-i0-handwrit',
  HANDWRIT_BOSNIAN: 'bs-t-i0-handwrit',
  HANDWRIT_BULGARIAN: 'bg-t-i0-handwrit',
  HANDWRIT_BURMESE: 'my-t-i0-handwrit',
  HANDWRIT_CANTONESE: 'zh-yue-t-i0-handwrit',
  HANDWRIT_CATALAN: 'ca-t-i0-handwrit',
  HANDWRIT_CEBUANO: 'ceb-t-i0-handwrit',
  HANDWRIT_CHINESE: 'zh-t-i0-handwrit',
  HANDWRIT_CHINESE_SIMPLIFIED: 'zh-hans-t-i0-handwrit',
  HANDWRIT_CHINESE_TRADITIONAL: 'zh-hant-t-i0-handwrit',
  HANDWRIT_CORSICAN: 'co-t-i0-handwrit',
  HANDWRIT_CROATIAN: 'hr-t-i0-handwrit',
  HANDWRIT_CZECH: 'cs-t-i0-handwrit',
  HANDWRIT_DANISH: 'da-t-i0-handwrit',
  HANDWRIT_DUTCH: 'nl-t-i0-handwrit',
  HANDWRIT_ENGLISH: 'en-t-i0-handwrit',
  HANDWRIT_ESPERANTO: 'eo-t-i0-handwrit',
  HANDWRIT_ESTONIAN: 'et-t-i0-handwrit',
  HANDWRIT_FILIPINO: 'fil-t-i0-handwrit',
  HANDWRIT_FINNISH: 'fi-t-i0-handwrit',
  HANDWRIT_FRENCH: 'fr-t-i0-handwrit',
  HANDWRIT_GALICIAN: 'gl-t-i0-handwrit',
  HANDWRIT_GERMAN: 'de-t-i0-handwrit',
  HANDWRIT_GREEK: 'el-t-i0-handwrit',
  HANDWRIT_GUJARATI: 'gu-t-i0-handwrit',
  HANDWRIT_HAITIAN: 'ht-t-i0-handwrit',
  HANDWRIT_HAWAIIAN: 'haw-t-i0-handwrit',
  HANDWRIT_HEBREW: 'he-t-i0-handwrit',
  HANDWRIT_HINDI: 'hi-t-i0-handwrit',
  HANDWRIT_HMONG: 'hmn-t-i0-handwrit',
  HANDWRIT_HUNGARIAN: 'hu-t-i0-handwrit',
  HANDWRIT_ICELANDIC: 'is-t-i0-handwrit',
  HANDWRIT_INDONESIAN: 'id-t-i0-handwrit',
  HANDWRIT_IRISH: 'ga-t-i0-handwrit',
  HANDWRIT_ITALIAN: 'it-t-i0-handwrit',
  HANDWRIT_JAPANESE: 'ja-t-i0-handwrit',
  HANDWRIT_JAVANESE: 'jv-t-i0-handwrit',
  HANDWRIT_KANNADA: 'kn-t-i0-handwrit',
  HANDWRIT_KHMER: 'km-t-i0-handwrit',
  HANDWRIT_KOREAN: 'ko-t-i0-handwrit',
  HANDWRIT_KURDISH: 'ku-t-i0-handwrit',
  HANDWRIT_KYRGYZ: 'ky-t-i0-handwrit',
  HANDWRIT_LAO: 'lo-t-i0-handwrit',
  HANDWRIT_LATIN: 'la-t-i0-handwrit',
  HANDWRIT_LATVIAN: 'lv-t-i0-handwrit',
  HANDWRIT_LITHUANIAN: 'lt-t-i0-handwrit',
  HANDWRIT_LUXEMBOURGISH: 'lb-t-i0-handwrit',
  HANDWRIT_MACEDONIAN: 'mk-t-i0-handwrit',
  HANDWRIT_MALAGASY: 'mg-t-i0-handwrit',
  HANDWRIT_MALAY: 'ms-t-i0-handwrit',
  HANDWRIT_MALAYALAM: 'ml-t-i0-handwrit',
  HANDWRIT_MALTESE: 'mt-t-i0-handwrit',
  HANDWRIT_MAORI: 'mi-t-i0-handwrit',
  HANDWRIT_MARATHI: 'mr-t-i0-handwrit',
  HANDWRIT_MONGOLIAN: 'mn-t-i0-handwrit',
  HANDWRIT_MULTIPLE_LANGUAGES: 'mul-t-i0-handwrit',
  HANDWRIT_NEPALI: 'ne-t-i0-handwrit',
  HANDWRIT_NORWEGIAN: 'no-t-i0-handwrit',
  HANDWRIT_NORWEGIAN_BOKMAL: 'nb-t-i0-handwrit',
  HANDWRIT_NORWEGIAN_NYNORSK: 'nn-t-i0-handwrit',
  HANDWRIT_NYANJA: 'ny-t-i0-handwrit',
  HANDWRIT_ORIYA: 'or-t-i0-handwrit',
  HANDWRIT_PERSIAN: 'fa-t-i0-handwrit',
  HANDWRIT_POLISH: 'pl-t-i0-handwrit',
  HANDWRIT_PORTUGUESE: 'pt-t-i0-handwrit',
  HANDWRIT_PORTUGUESE_BRAZIL: 'pt-br-t-i0-handwrit',
  HANDWRIT_PORTUGUESE_PORTUGAL: 'pt-pt-t-i0-handwrit',
  HANDWRIT_PUNJABI: 'pa-t-i0-handwrit',
  HANDWRIT_ROMANIAN: 'ro-t-i0-handwrit',
  HANDWRIT_RUSSIAN: 'ru-t-i0-handwrit',
  HANDWRIT_SAMOAN: 'sm-t-i0-handwrit',
  HANDWRIT_SCOTTISH_GAELIC: 'gd-t-i0-handwrit',
  HANDWRIT_SERBIAN: 'sr-t-i0-handwrit',
  HANDWRIT_SHONA: 'sn-t-i0-handwrit',
  HANDWRIT_SINHALA: 'si-t-i0-handwrit',
  HANDWRIT_SLOVAK: 'sk-t-i0-handwrit',
  HANDWRIT_SLOVENIAN: 'sl-t-i0-handwrit',
  HANDWRIT_SOMALI: 'so-t-i0-handwrit',
  HANDWRIT_SPANISH: 'es-t-i0-handwrit',
  HANDWRIT_SUNDANESE: 'su-t-i0-handwrit',
  HANDWRIT_SWAHILI: 'sw-t-i0-handwrit',
  HANDWRIT_SWEDISH: 'sv-t-i0-handwrit',
  HANDWRIT_TAMIL: 'ta-t-i0-handwrit',
  HANDWRIT_TELUGU: 'te-t-i0-handwrit',
  HANDWRIT_THAI: 'th-t-i0-handwrit',
  HANDWRIT_TURKISH: 'tr' + '-t-i0-handwrit',
  HANDWRIT_UKRAINIAN: 'uk-t-i0-handwrit',
  HANDWRIT_URDU: 'ur-t-i0-handwrit',
  HANDWRIT_VIETNAMESE: 'vi-t-i0-handwrit',
  HANDWRIT_WELSH: 'cy-t-i0-handwrit',
  HANDWRIT_WESTERN_FRISIAN: 'fy-t-i0-handwrit',
  HANDWRIT_XHOSA: 'xh-t-i0-handwrit',
  HANDWRIT_ZULU: 'zu-t-i0-handwrit',
  HANDWRIT_UNIVERSAL: 'und-t-i0-handwrit',
  VOICE_ENGLISH: 'en-t-i0-voice',
  VOICE_CHINESE_SIMPLIFIED: 'zh-hans-t-i0-voice',
  VOICE_CHINESE_TRADITIONAL: 'zh-hant-t-i0-voice',
  XKB_AM_PHONETIC_ARM: 'xkb:am:phonetic:arm',
  XKB_BE_FRA: 'xkb:be::fra',
  XKB_BE_GER: 'xkb:be::ger',
  XKB_BE_NLD: 'xkb:be::nld',
  XKB_BG_BUL: 'xkb:bg::bul',
  XKB_BG_PHONETIC_BUL: 'xkb:bg:phonetic:bul',
  XKB_BR_POR: 'xkb:br::por',
  XKB_BY_BEL: 'xkb:by::bel',
  XKB_CA_FRA: 'xkb:ca::fra',
  XKB_CA_ENG_ENG: 'xkb:ca:eng:eng',
  XKB_CA_MULTIX_FRA: 'xkb:ca:multix:fra',
  XKB_CH_GER: 'xkb:ch::ger',
  XKB_CH_FR_FRA: 'xkb:ch:fr:fra',
  XKB_CZ_CZE: 'xkb:cz::cze',
  XKB_CZ_QWERTY_CZE: 'xkb:cz:qwerty:cze',
  XKB_DE_GER: 'xkb:de::ger',
  XKB_DE_NEO_GER: 'xkb:de:neo:ger',
  XKB_DK_DAN: 'xkb:dk::dan',
  XKB_EE_EST: 'xkb:ee::est',
  XKB_ES_SPA: 'xkb:es::spa',
  XKB_ES_CAT_CAT: 'xkb:es:cat:cat',
  XKB_FO_FAO: 'xkb:fo::fao',
  XKB_FI_FIN: 'xkb:fi::fin',
  XKB_FR_BEPO_FRA: 'xkb:fr:bepo:fra',
  XKB_FR_FRA: 'xkb:fr::fra',
  XKB_GB_DVORAK_ENG: 'xkb:gb:dvorak:eng',
  XKB_GB_EXTD_ENG: 'xkb:gb:extd:eng',
  XKB_GE_GEO: 'xkb:ge::geo',
  XKB_GR_GRE: 'xkb:gr::gre',
  XKB_HR_SCR: 'xkb:hr::scr',
  XKB_HU_HUN: 'xkb:hu::hun',
  XKB_HU_QWERTY_HUN: 'xkb:hu:qwerty:hun',
  XKB_IE_GA: 'xkb:ie::ga',
  XKB_IL_HEB: 'xkb:il::heb',
  XKB_IS_ICE: 'xkb:is::ice',
  XKB_IT_ITA: 'xkb:it::ita',
  XKB_JP_JPN: 'xkb:jp::jpn',
  XKB_KZ_KAZ: 'xkb:kz::kaz',
  XKB_LATAM_SPA: 'xkb:latam::spa',
  XKB_LT_LIT: 'xkb:lt::lit',
  XKB_LV_APOSTROPHE_LAV: 'xkb:lv:apostrophe:lav',
  XKB_MN_MON: 'xkb:mn::mon',
  XKB_MK_MKD: 'xkb:mk::mkd',
  XKB_MT_MLT: 'xkb:mt::mlt',
  XKB_NO_NOB: 'xkb:no::nob',
  XKB_PL_POL: 'xkb:pl::pol',
  XKB_PT_POR: 'xkb:pt::por',
  XKB_RO_RUM: 'xkb:ro::rum',
  XKB_RO_STD_RUM: 'xkb:ro:std:rum',
  XKB_RS_SRP: 'xkb:rs::srp',
  XKB_RU_RUS: 'xkb:ru::rus',
  XKB_RU_PHONETIC_RUS: 'xkb:ru:phonetic:rus',
  XKB_SE_SWE: 'xkb:se::swe',
  XKB_SI_SLV: 'xkb:si::slv',
  XKB_SK_SLO: 'xkb:sk::slo',
  XKB_TR_TUR: 'xkb:tr::tur',
  XKB_TR_F_TUR: 'xkb:tr:f:tur',
  XKB_UA_UKR: 'xkb:ua::ukr',
  XKB_US_ENG: 'xkb:us::eng',
  XKB_US_FIL: 'xkb:us::fil',
  XKB_US_IND: 'xkb:us::ind',
  XKB_US_MSA: 'xkb:us::msa',
  XKB_US_ALTGR_INTL_ENG: 'xkb:us:altgr-intl:eng',
  XKB_US_COLEMAK_ENG: 'xkb:us:colemak:eng',
  XKB_US_DVORAK_ENG: 'xkb:us:dvorak:eng',
  XKB_US_DVP_ENG: 'xkb:us:dvp:eng',
  XKB_US_INTL_ENG: 'xkb:us:intl:eng',
  XKB_US_INTL_NLD: 'xkb:us:intl:nld',
  XKB_US_INTL_POR: 'xkb:us:intl:por'
};

// i18n.input.lang.InputToolType
goog.provide('i18n.input.lang.InputToolType');
i18n.input.lang.InputToolType = {
  IME: 'im',
  KBD: 'vkd',
  HWT: 'hw',
  VOICE: 'vo',
  XKB: 'xkb'
};

// i18n.input.lang.InputTool
goog.provide('i18n.input.lang.InputTool');
goog.scope(function() {
var GlobalSettings = i18n.input.common.GlobalSettings;
var InputToolCode = i18n.input.lang.InputToolCode;
var InputToolType = i18n.input.lang.InputToolType;
i18n.input.lang.InputTool = function(inputToolCode) {
  this.code = inputToolCode;
  this.type = null;
  this.languageCode = 'en';
  this.sourceLanguageCode = 'en';
  this.layoutCode;
  this.parseInputToolCode_();
};
var InputTool = i18n.input.lang.InputTool;
InputTool.RtlKeyboards = [
  InputToolCode.KEYBOARD_ARABIC,
  InputToolCode.KEYBOARD_DARI,
  InputToolCode.KEYBOARD_HEBREW,
  InputToolCode.KEYBOARD_PASHTO,
  InputToolCode.KEYBOARD_PERSIAN,
  InputToolCode.KEYBOARD_SOUTHERN_UZBEK,
  InputToolCode.KEYBOARD_UIGHUR,
  InputToolCode.KEYBOARD_URDU,
  InputToolCode.KEYBOARD_YIDDISH];
InputTool.RtlIMEs = [
  InputToolCode.INPUTMETHOD_TRANSLITERATION_ARABIC,
  InputToolCode.INPUTMETHOD_TRANSLITERATION_HEBREW,
  InputToolCode.INPUTMETHOD_TRANSLITERATION_PERSIAN,
  InputToolCode.INPUTMETHOD_TRANSLITERATION_URDU];
InputTool.LanguageCodeThreeTwoMap = goog.object.create(
    'arm', 'hy',
    'bel', 'be',
    'bul', 'bg',
    'cat', 'ca',
    'cze', 'cs',
    'dan', 'da',
    'eng', 'en',
    'est', 'et',
    'fao', 'fo',
    'fin', 'fi',
    'fra', 'fr',
    'geo', 'ka',
    'ger', 'de',
    'gre', 'el',
    'heb', 'he',
    'hun', 'hu',
    'ice', 'is',
    'ind', 'id',
    'ita', 'it',
    'jpn', 'ja',
    'kaz', 'kk',
    'lav', 'lv',
    'lit', 'lt',
    'mlt', 'mt',
    'mon', 'mn',
    'msa', 'ms',
    'nld', 'nl',
    'nob', 'no',
    'pol', 'pl',
    'por', 'pt',
    'rum', 'ro',
    'rus', 'ru',
    'scr', 'hr',
    'slo', 'sk',
    'slv', 'sl',
    'spa', 'es',
    'srp', 'sr',
    'swe', 'sv',
    'tur', 'tr',
    'ukr', 'uk');
InputTool.XkbId2Language_ = {
  'xkb:us:intl:por': 'pt',
  'xkb:br::por': 'pt',
  'xkb:pt::por': 'pt'
};
InputTool.instances_ = {};
InputTool.get = function(inputToolCode) {
  if (!inputToolCode) {
    return null;
  }
  if (!goog.object.contains(InputToolCode, inputToolCode)) {
    inputToolCode = InputTool.parseToBCP47_(inputToolCode);
  }
  inputToolCode = inputToolCode.replace(/_/g, '-');
  if (!goog.object.contains(InputToolCode, inputToolCode)) {
    inputToolCode = InputTool.parseToBCP47_(
        inputToolCode + '-und');
  }
  if (InputTool.instances_[inputToolCode]) {
    return InputTool.instances_[inputToolCode];
  }
  if (goog.object.contains(InputToolCode, inputToolCode)) {
    InputTool.instances_[inputToolCode] =
        new InputTool(
         (inputToolCode));
    return InputTool.instances_[inputToolCode];
  }
  return null;
};
InputTool.PHONETIC_INSCRIPT_LANGS_ = [
  'bn', 'gu', 'pa', 'kn', 'ml', 'or', 'sa', 'ta', 'te', 'ne'
];
InputTool.BCP47_SPECIAL_ = {
  'im_pinyin_zh_hans': InputToolCode.INPUTMETHOD_PINYIN_CHINESE_SIMPLIFIED,
  'im_pinyin_zh_hant': InputToolCode.INPUTMETHOD_PINYIN_CHINESE_TRADITIONAL,
  'im_t13n_ja': InputToolCode.INPUTMETHOD_TRANSLITERATION_JAPANESE,
  'im_t13n_ja-Hira': InputToolCode.INPUTMETHOD_TRANSLITERATION_HIRAGANA,
  'im_wubi_zh_hans': InputToolCode.INPUTMETHOD_WUBI_CHINESE_SIMPLIFIED,
  'im_zhuyin_zh_hant': InputToolCode.INPUTMETHOD_ZHUYIN_CHINESE_TRADITIONAL,
  'vkd_bg_phone': InputToolCode.KEYBOARD_BULGARIAN_PHONETIC,
  'vkd_chr_phone': InputToolCode.KEYBOARD_CHEROKEE_PHONETIC,
  'vkd_cs_qwertz': InputToolCode.KEYBOARD_CZECH_QWERTZ,
  'vkd_deva_phone': InputToolCode.KEYBOARD_DEVANAGARI_PHONETIC,
  'vkd_en_dvorak': InputToolCode.KEYBOARD_ENGLISH_DVORAK,
  'vkd_es_es': InputToolCode.KEYBOARD_SPANISH,
  'vkd_ethi': InputToolCode.KEYBOARD_ETHIOPIC,
  'vkd_gu_phone': InputToolCode.KEYBOARD_GUJARATI_PHONETIC,
  'vkd_guru_inscript': InputToolCode.KEYBOARD_GURMUKHI_INSCRIPT,
  'vkd_guru_phone': InputToolCode.KEYBOARD_GURMUKHI_PHONETIC,
  'vkd_hu_101': InputToolCode.KEYBOARD_HUNGARIAN_101,
  'vkd_hy_east': InputToolCode.KEYBOARD_ARMENIAN_EASTERN,
  'vkd_hy_west': InputToolCode.KEYBOARD_ARMENIAN_WESTERN,
  'vkd_ka_qwerty': InputToolCode.KEYBOARD_GEORGIAN_QWERTY,
  'vkd_ka_typewriter': InputToolCode.KEYBOARD_GEORGIAN_TYPEWRITER,
  'vkd_ro_sr13392_primary': InputToolCode.KEYBOARD_ROMANIAN_SR13392_PRIMARY,
  'vkd_ro_sr13392_secondary': InputToolCode.KEYBOARD_ROMANIAN_SR13392_SECONDARY,
  'vkd_ru_phone': InputToolCode.KEYBOARD_RUSSIAN_PHONETIC,
  'vkd_ru_phone_aatseel': InputToolCode.KEYBOARD_RUSSIAN_PHONETIC_AATSEEL,
  'vkd_ru_phone_yazhert': InputToolCode.KEYBOARD_RUSSIAN_PHONETIC_YAZHERT,
  'vkd_sk_qwerty': InputToolCode.KEYBOARD_SLOVAK_QWERTY,
  'vkd_ta_itrans': InputToolCode.KEYBOARD_TAMIL_ITRANS,
  'vkd_ta_tamil99': InputToolCode.KEYBOARD_TAMIL_99,
  'vkd_ta_typewriter': InputToolCode.KEYBOARD_TAMIL_TYPEWRITER,
  'vkd_th_pattajoti': InputToolCode.KEYBOARD_THAI_PATTAJOTI,
  'vkd_th_tis': InputToolCode.KEYBOARD_THAI_TIS,
  'vkd_tr_f': InputToolCode.KEYBOARD_TURKISH_F,
  'vkd_tr_q': InputToolCode.KEYBOARD_TURKISH_Q,
  'vkd_uk_101': InputToolCode.KEYBOARD_UKRAINIAN_101,
  'vkd_us_intl': InputToolCode.KEYBOARD_FRENCH_INTL,
  'vkd_uz_cyrl_phone': InputToolCode.KEYBOARD_UZBEK_CYRILLIC_PHONETIC,
  'vkd_uz_cyrl_type': InputToolCode.KEYBOARD_UZBEK_CYRILLIC_TYPEWRITTER,
  'vkd_vi_tcvn': InputToolCode.KEYBOARD_VIETNAMESE_TCVN,
  'vkd_vi_telex': InputToolCode.KEYBOARD_VIETNAMESE_TELEX
};
InputTool.BCP47_SPECIAL_REVERSE_ = goog.object.transpose(
    InputTool.BCP47_SPECIAL_);
InputTool.SpecialLayoutCodes_ = goog.object.create(
    InputToolCode.KEYBOARD_DUTCH_INTL, 'us_intl',
    InputToolCode.KEYBOARD_FRENCH_INTL, 'us_intl',
    InputToolCode.KEYBOARD_GERMAN_INTL, 'us_intl',
    InputToolCode.KEYBOARD_HAITIAN, 'fr',
    InputToolCode.KEYBOARD_INDONESIAN, 'latn_002',
    InputToolCode.KEYBOARD_IRISH, 'latn_002',
    InputToolCode.KEYBOARD_ITALIAN_INTL, 'us_intl',
    InputToolCode.KEYBOARD_JAVANESE, 'latn_002',
    InputToolCode.KEYBOARD_MARATHI, 'deva_phone',
    InputToolCode.KEYBOARD_MARATHI_INSCRIPT, 'hi',
    InputToolCode.KEYBOARD_MALAY, 'latn_002',
    InputToolCode.KEYBOARD_PORTUGUESE_BRAZIL_INTL, 'us_intl',
    InputToolCode.KEYBOARD_PORTUGUESE_PORTUGAL_INTL, 'us_intl',
    InputToolCode.KEYBOARD_SANSKRIT_INSCRIPT, 'hi',
    InputToolCode.KEYBOARD_SPANISH_INTL, 'us_intl',
    InputToolCode.KEYBOARD_SWAHILI, 'latn_002',
    InputToolCode.KEYBOARD_TAGALOG, 'latn_002',
    InputToolCode.KEYBOARD_TIGRINYA, 'ethi',
    InputToolCode.KEYBOARD_WELSH, 'latn_002');
InputTool.parseToBCP47_ = function(itCode) {
  if (InputTool.BCP47_SPECIAL_[itCode]) {
    return InputTool.BCP47_SPECIAL_[itCode];
  }
  if (itCode == 'vkd_iw') {
    return InputToolCode.KEYBOARD_HEBREW;
  }
  if (itCode == 'im_t13n_iw') {
    return InputToolCode.INPUTMETHOD_TRANSLITERATION_HEBREW;
  }
  if (itCode == 'tr' + '-t-k0-lagacy') {
    return InputToolCode.KEYBOARD_TURKISH_F;
  }
  var parts = itCode.split('_');
  var code = '';
  if (goog.string.startsWith(itCode, 'im_t13n')) {
    code = parts[2] + '-t-i0-und';
  } else if (goog.string.startsWith(itCode, 'vkd_')) {
    if (parts.length == 2) {
      code = parts[1] + '-t-k0-und';
    } else {
      if (goog.array.contains(
          InputTool.PHONETIC_INSCRIPT_LANGS_, parts[1])) {
        if (parts[2] == 'inscript') {
          code = parts[1] + '-t-k0-und';
        } else {
          code = parts[1] + '-t-und-latn-k0-und';
        }
      } else {
        code = parts[1] + '-t-k0-' + parts[2];
        if (!goog.object.contains(InputToolCode, code)) {
          code = parts[1] + '-' + parts[2] + '-t-k0-und';
        }
      }
    }
  }
  return goog.object.contains(InputToolCode, code) ? code : itCode;
};
InputTool.getInputTool = function(type, code) {
  if (type == InputToolType.IME) {
    if (code == 'zh' || code == 'zh-Hans') {
      return InputTool.get(
          InputToolCode.INPUTMETHOD_PINYIN_CHINESE_SIMPLIFIED);
    } else if (code == 'zh-Hant') {
      return InputTool.get(
          InputToolCode.INPUTMETHOD_ZHUYIN_CHINESE_TRADITIONAL);
    } else if (code == 'ja') {
      return InputTool.get(
          InputToolCode.INPUTMETHOD_TRANSLITERATION_JAPANESE);
    } else {
      return InputTool.get(code + '-t-i0-und');
    }
  } else if (type == InputToolType.KBD) {
    return InputTool.get('vkd_' + code);
  }
  return null;
};
InputTool.prototype.parseLayoutCode_ = function() {
  if (InputTool.SpecialLayoutCodes_[this.code]) {
    this.layoutCode = InputTool.SpecialLayoutCodes_[this.code];
  } else if (InputTool.BCP47_SPECIAL_REVERSE_[this.code]) {
    this.layoutCode = InputTool.
        BCP47_SPECIAL_REVERSE_[this.code].slice(4);
  } else {
    var parts = this.code.split('-t-');
    var countryCode = parts[0];
    var inputToolType = parts[1];
    countryCode = countryCode.replace(/-/g, '_');
    if (countryCode == 'en_us') {
      countryCode = 'us';
    }
    if (goog.array.contains(
        InputTool.PHONETIC_INSCRIPT_LANGS_, countryCode) &&
        (inputToolType == 'und-latn-k0-und' || inputToolType == 'k0-und')) {
      this.layoutCode = countryCode +
          (inputToolType == 'k0-und' ? '_inscript' : '_phone');
    } else if (inputToolType == 'k0-und') {
      this.layoutCode = countryCode;
    } else {
      var matches = inputToolType.match(/k0-(.*)/);
      if (matches[1]) {
        this.layoutCode = countryCode + '_' + matches[1].replace(
            'qwerty', 'phone').replace('-', '_');
      }
    }
  }
};
InputTool.prototype.parseInputToolCode_ = function() {
  if (this.code.indexOf('-i0') >= 0) {
    this.type = InputToolType.IME;
    if (goog.string.endsWith(this.code, '-handwrit')) {
      this.type = InputToolType.HWT;
    } else if (goog.string.endsWith(this.code, '-voice')) {
      this.type = InputToolType.VOICE;
    }
  } else if (this.code.indexOf('-k0') >= 0) {
    this.type = InputToolType.KBD;
  } else if (goog.string.startsWith(this.code, 'xkb')) {
    this.type = InputToolType.XKB;
  }
  var codes = this.code.split(/-t|-i0|-k0|:/);
  if (codes[0] == 'yue-hant') {
    codes[0] = 'zh-Hant';
  }
  switch (this.code) {
    case InputToolCode.INPUTMETHOD_CANTONESE_TRADITIONAL:
      codes[0] = 'zh-Hant';
      break;
    case InputToolCode.INPUTMETHOD_PINYIN_CHINESE_SIMPLIFIED:
    case InputToolCode.INPUTMETHOD_WUBI_CHINESE_SIMPLIFIED:
      codes[0] = 'zh-Hans';
      break;
  }
  if (this.type == InputToolType.XKB) {
    if (InputTool.XkbId2Language_[this.code]) {
      this.languageCode = InputTool.XkbId2Language_[this.code];
    } else {
      this.languageCode = this.formatLanguageCode_(codes[codes.length - 1]);
    }
  } else {
    this.languageCode = this.formatLanguageCode_(codes[0]);
    if (codes[1]) {
      this.sourceLanguageCode = this.formatLanguageCode_(codes[1]);
    }
  }
  if (this.type == InputToolType.KBD) {
    this.parseLayoutCode_();
  }
};
InputTool.prototype.toString = function() {
  return this.code;
};
InputTool.prototype.getDirection = function() {
  return this.isRightToLeft() ? 'rtl' : 'ltr';
};
InputTool.prototype.isRightToLeft = function() {
  return goog.array.contains(InputTool.RtlIMEs, this.code) ||
      goog.array.contains(InputTool.RtlKeyboards, this.code);
};
InputTool.prototype.hasStatusBar = function() {
  if (!GlobalSettings.mobile && this.type == InputToolType.IME) {
    return /^(zh|yue)/.test(this.code);
  }
  return false;
};
InputTool.prototype.formatLanguageCode_ = function(code) {
  if (code == 'und-ethi') {
    return 'et';
  }
  var parts = code.split('-');
  var retCode;
  if (parts.length == 2) {
    if (parts[1].length == 2) {
      retCode = parts[0] + '-' + parts[1].toUpperCase();
    } else {
      retCode = parts[0] + '-' + parts[1].charAt(0).toUpperCase() +
          parts[1].slice(1);
    }
  } else {
    if (goog.object.containsKey(InputTool.LanguageCodeThreeTwoMap, parts[0])) {
      retCode = InputTool.LanguageCodeThreeTwoMap[parts[0]];
    } else {
      retCode = parts[0];
    }
  }
  return retCode;
};
InputTool.prototype.isTransliteration = function() {
  var reg = new RegExp('^(am|ar|bn|el|gu|he|hi|kn|ml|mr|ne|or|fa|pa|ru|sa|' +
      'sr|si|ta|te|ti|ur|uk|be|bg)');
  return this.type == InputToolType.IME && reg.test(this.code);
};
InputTool.prototype.isLatin = function() {
  return this.type == InputToolType.IME &&
      /^(en|fr|de|it|es|nl|pt|tr|sv|da|fi|no)/.test(this.code);
};
});  // goog.scope

// i18n.input.chrome.Env
goog.provide('i18n.input.chrome.Env');
goog.scope(function() {
var Constant = i18n.input.chrome.Constant;
var FeatureTracker = i18n.input.chrome.FeatureTracker;
var InputTool = i18n.input.lang.InputTool;
var InputToolType = i18n.input.lang.InputToolType;
i18n.input.chrome.Env = function() {
  this.featureTracker = new FeatureTracker();
  this.compositionBoundsChangedHandler_ =
      this.onBoundsChanged_.bind(this);
  this.currentBounds =  ({x: 0, y: 0, w: 0, h: 0});
  this.currentBoundsList = [
     ({x: 0, y: 0, w: 0, h: 0})];
  if (chrome.accessibilityFeatures &&
      chrome.accessibilityFeatures.spokenFeedback) {
    chrome.accessibilityFeatures.spokenFeedback.get({}, (function(details) {
      this.isChromeVoxOn = details['value'];
    }).bind(this));
    chrome.accessibilityFeatures.spokenFeedback.onChange.addListener(
        function(details) {
          this.isChromeVoxOn = details['value'];
        }.bind(this));
  }
  if (window.inputview && window.inputview.getKeyboardConfig) {
    window.inputview.getKeyboardConfig((function(config) {
      this.featureTracker.initialize(config);
    }).bind(this));
  }
};
var Env = i18n.input.chrome.Env;
goog.addSingletonGetter(Env);
Env.prototype.engineId = '';
Env.prototype.context = null;
Env.prototype.screenType = 'normal';
Env.prototype.isPhysicalKeyboardAutocorrectEnabled = false;
Env.prototype.textBeforeCursor = '';
Env.prototype.surroundingInfo = null;
Env.prototype.isChromeVoxOn = false;
Env.prototype.isOnScreenKeyboardShown = false;
Env.prototype.onBoundsChanged_ = function(bounds, boundsList) {
  this.currentBounds = bounds;
  this.currentBoundsList = boundsList;
};
Env.prototype.listenCompositionBoundsChanged = function() {
  if (chrome.inputMethodPrivate &&
      chrome.inputMethodPrivate.onCompositionBoundsChanged) {
    chrome.inputMethodPrivate.onCompositionBoundsChanged.addListener(
        this.compositionBoundsChangedHandler_);
  }
};
Env.prototype.unlistenCompositionBoundsChanged = function() {
  if (chrome.inputMethodPrivate &&
      chrome.inputMethodPrivate.onCompositionBoundsChanged) {
    chrome.inputMethodPrivate.onCompositionBoundsChanged.removeListener(
        this.compositionBoundsChangedHandler_);
  }
};
Env.isXkbAndNaclEnabled = function(xkbEngineId) {
  var inputTool = InputTool.get(xkbEngineId);
  return !!inputTool && inputTool.type == InputToolType.XKB &&
      goog.array.contains(Constant.NACL_LANGUAGES, inputTool.languageCode);
};
});  // goog.scope

// i18n.input.chrome.events.KeyCodes
goog.provide('i18n.input.chrome.events.KeyCodes');
i18n.input.chrome.events.KeyCodes = {
  UNIDENTIFIED: 'Unidentified',
  BACK_QUOTE: 'Backquote',
  KEY_A: 'KeyA',
  KEY_B: 'KeyB',
  KEY_C: 'KeyC',
  KEY_D: 'KeyD',
  KEY_E: 'KeyE',
  KEY_F: 'KeyF',
  KEY_G: 'KeyG',
  KEY_H: 'KeyH',
  KEY_I: 'KeyI',
  KEY_J: 'KeyJ',
  KEY_K: 'KeyK',
  KEY_L: 'KeyL',
  KEY_M: 'KeyM',
  KEY_N: 'KeyN',
  KEY_O: 'KeyO',
  KEY_P: 'KeyP',
  KEY_Q: 'KeyQ',
  KEY_R: 'KeyR',
  KEY_S: 'KeyS',
  KEY_T: 'KeyT',
  KEY_U: 'KeyU',
  KEY_V: 'KeyV',
  KEY_W: 'KeyW',
  KEY_X: 'KeyX',
  KEY_Y: 'KeyY',
  KEY_Z: 'KeyZ',
  DIGIT_0: 'Digit0',
  DIGIT_1: 'Digit1',
  DIGIT_2: 'Digit2',
  DIGIT_3: 'Digit3',
  DIGIT_4: 'Digit4',
  DIGIT_5: 'Digit5',
  DIGIT_6: 'Digit6',
  DIGIT_7: 'Digit7',
  DIGIT_8: 'Digit8',
  DIGIT_9: 'Digit9',
  ALT: 'Alt',
  ALT_GRAPH: 'AltGraph',
  ALT_LEFT: 'AltLeft',
  ALT_RIGHT: 'AltRight',
  CAPS_LOCK: 'CapsLock',
  CONTROL: 'Control',
  FN: 'Fn',
  FN_LOCK: 'FnLock',
  HYPER: 'Hyper',
  META: 'Meta',
  NUM_LOCK: 'NumLock',
  O_S: 'OS',
  SHIFT: 'Shift',
  SHIFT_LEFT: 'ShiftLeft',
  SHIFT_RIGHT: 'ShiftRight',
  SUPER: 'Super',
  SYMBOL: 'Symbol',
  SYMBOL_LOCK: 'SymbolLock',
  ENTER: 'Enter',
  SEPARATOR: 'Separator',
  TAB: 'Tab',
  SPACE: 'Space',
  ARROW_DOWN: 'ArrowDown',
  ARROW_LEFT: 'ArrowLeft',
  ARROW_RIGHT: 'ArrowRight',
  ARROW_UP: 'ArrowUp',
  END: 'End',
  HOME: 'Home',
  PAGE_DOWN: 'PageDown',
  PAGE_UP: 'PageUp',
  BACKSPACE: 'Backspace',
  CLEAR: 'Clear',
  COPY: 'Copy',
  CR_SEL: 'CrSel',
  CUT: 'Cut',
  DELETE: 'Delete',
  ERASE_EOF: 'EraseEof',
  EX_SEL: 'ExSel',
  INSERT: 'Insert',
  PASTE: 'Paste',
  REDO: 'Redo',
  UNDO: 'Undo',
  ACCEPT: 'Accept',
  AGAIN: 'Again',
  ATTN: 'Attn',
  CANCEL: 'Cancel',
  CONTEXT_MENU: 'ContextMenu',
  ESCAPE: 'Escape',
  EXECUTE: 'Execute',
  FIND: 'Find',
  HELP: 'Help',
  PAUSE: 'Pause',
  PLAY: 'Play',
  PROPS: 'Props',
  SCROLL_LOCK: 'ScrollLock',
  ZOOM_IN: 'ZoomIn',
  ZOOM_OUT: 'ZoomOut',
  BRIGHTNESS_DOWN: 'BrightnessDown',
  BRIGHTNESS_UP: 'BrightnessUp',
  CAMERA: 'Camera',
  EJECT: 'Eject',
  LOG_OFF: 'LogOff',
  POWER: 'Power',
  POWER_OFF: 'PowerOff',
  PRINT_SCREEN: 'PrintScreen',
  HIBERNATE: 'Hibernate',
  STANDBY: 'Standby',
  WAKE_UP: 'WakeUp',
  ALL_CANDIDATES: 'AllCandidates',
  ALPHANUMERIC: 'Alphanumeric',
  CODE_INPUT: 'CodeInput',
  COMPOSE: 'Compose',
  CONVERT: 'Convert',
  FINAL_MODE: 'FinalMode',
  GROUP_FIRST: 'GroupFirst',
  GROUP_LAST: 'GroupLast',
  GROUP_NEXT: 'GroupNext',
  GROUP_PREVIOUS: 'GroupPrevious',
  MODE_CHANGE: 'ModeChange',
  NEXT_CANDIDATE: 'NextCandidate',
  NON_CONVERT: 'NonConvert',
  PREVIOUS_CANDIDATE: 'PreviousCandidate',
  PROCESS: 'Process',
  SINGLE_CANDIDATE: 'SingleCandidate',
  ROMAN_CHARACTERS: 'RomanCharacters',
  HANGUL_MODE: 'HangulMode',
  HANJA_MODE: 'Hanja',
  JUNJA_MODE: 'JunjaMode',
  ZENKAKU: 'Zenkaku',
  HANKAKU: 'Hankaku',
  ZENKAKU_HANKAKU: 'ZenkakuHankaku',
  KANA_MODE: 'KanaMode',
  KANJI_MODE: 'KanjiMode',
  HIRAGANA: 'Hiragana',
  KATAKANA: 'Katakana',
  HIRAGANA_KATAKANA: 'HiraganaKatakana',
  EISU: 'Eisu',
  F1: 'F1',
  F2: 'F2',
  F3: 'F3',
  F4: 'F4',
  F5: 'F5',
  F6: 'F6',
  F7: 'F7',
  F8: 'F8',
  F9: 'F9',
  F10: 'F10',
  F11: 'F11',
  F12: 'F12',
  SOFT1: 'Soft1',
  SOFT2: 'Soft2',
  SOFT3: 'Soft3',
  SOFT4: 'Soft4',
  CLOSE: 'Close',
  MAIL_FORWARD: 'MailForward',
  MAIL_REPLY: 'MailReply',
  MAIL_SEND: 'MailSend',
  MEDIA_PLAY_PAUSE: 'MediaPlayPause',
  MEDIA_SELECT: 'MediaSelect',
  MEDIA_STOP: 'MediaStop',
  MEDIA_TRACK_NEXT: 'MediaTrackNext',
  MEDIA_TRACK_PREVIOUS: 'MediaTrackPrevious',
  NEW: 'New',
  OPEN: 'Open',
  PRINT: 'Print',
  SAVE: 'Save',
  SPELL_CHECK: 'SpellCheck',
  VOLUME_DOWN: 'VolumeDown',
  VOLUME_UP: 'VolumeUp',
  VOLUME_MUTE: 'VolumeMute',
  LAUNCH_CALCULATOR: 'LaunchCalculator',
  LAUNCH_CALENDAR: 'LaunchCalendar',
  LAUNCH_MAIL: 'LaunchMail',
  LAUNCH_MEDIA_PLAYER: 'LaunchMediaPlayer',
  LAUNCH_MUSIC_PLAYER: 'LaunchMusicPlayer',
  LAUNCH_MY_COMPUTER: 'LaunchMyComputer',
  LAUNCH_SCREEN_SAVER: 'LaunchScreenSaver',
  LAUNCH_SPREADSHEET: 'LaunchSpreadsheet',
  LAUNCH_WEB_BROWSER: 'LaunchWebBrowser',
  LAUNCH_WEB_CAM: 'LaunchWebCam',
  LAUNCH_WORD_PROCESSOR: 'LaunchWordProcessor',
  BROWSER_BACK: 'BrowserBack',
  BROWSER_FAVORITES: 'BrowserFavorites',
  BROWSER_FORWARD: 'BrowserForward',
  BROWSER_HOME: 'BrowserHome',
  BROWSER_REFRESH: 'BrowserRefresh',
  BROWSER_SEARCH: 'BrowserSearch',
  BROWSER_STOP: 'BrowserStop',
  AUDIO_BALANCE_LEFT: 'AudioBalanceLeft',
  AUDIO_BALANCE_RIGHT: 'AudioBalanceRight',
  AUDIO_BASS_BOOST_DOWN: 'AudioBassBoostDown',
  AUDIO_BASS_BOOST_UP: 'AudioBassBoostUp',
  AUDIO_FADER_FRONT: 'AudioFaderFront',
  AUDIO_FADER_REAR: 'AudioFaderRear',
  AUDIO_SURROUND_MODE_NEXT: 'AudioSurroundModeNext',
  CHANNEL_DOWN: 'ChannelDown',
  CHANNEL_UP: 'ChannelUp',
  COLORF0_RED: 'ColorF0Red',
  COLORF1_GREEN: 'ColorF1Green',
  COLORF2_YELLOW: 'ColorF2Yellow',
  COLORF3_BLUE: 'ColorF3Blue',
  COLORF4_GREY: 'ColorF4Grey',
  COLORF5_BROWN: 'ColorF5Brown',
  CLOSED_CAPTION_TOGGLE: 'ClosedCaptionToggle',
  DIMMER: 'Dimmer',
  DISPLAY_SWAP: 'DisplaySwap',
  EXIT: 'Exit',
  FAVORITE_CLEAR0: 'FavoriteClear0',
  FAVORITE_CLEAR1: 'FavoriteClear1',
  FAVORITE_CLEAR2: 'FavoriteClear2',
  FAVORITE_CLEAR3: 'FavoriteClear3',
  FAVORITE_RECALL0: 'FavoriteRecall0',
  FAVORITE_RECALL1: 'FavoriteRecall1',
  FAVORITE_RECALL2: 'FavoriteRecall2',
  FAVORITE_RECALL3: 'FavoriteRecall3',
  FAVORITE_STORE0: 'FavoriteStore0',
  FAVORITE_STORE1: 'FavoriteStore1',
  FAVORITE_STORE2: 'FavoriteStore2',
  FAVORITE_STORE3: 'FavoriteStore3',
  GUIDE: 'Guide',
  GUIDE_NEXT_DAY: 'GuideNextDay',
  GUIDE_PREVIOUS_DAY: 'GuidePreviousDay',
  INFO: 'Info',
  INSTANT_REPLAY: 'InstantReplay',
  LINK: 'Link',
  LIST_PROGRAM: 'ListProgram',
  LIVE_CONTENT: 'LiveContent',
  LOCK: 'Lock',
  MEDIA_APPS: 'MediaApps',
  MEDIA_FAST_FORWARD: 'MediaFastForward',
  MEDIA_LAST: 'MediaLast',
  MEDIA_PAUSE: 'MediaPause',
  MEDIA_PLAY: 'MediaPlay',
  MEDIA_RECORD: 'MediaRecord',
  MEDIA_REWIND: 'MediaRewind',
  MEDIA_SKIP: 'MediaSkip',
  NEXT_FAVORITE_CHANNEL: 'NextFavoriteChannel',
  NEXT_USER_PROFILE: 'NextUserProfile',
  ON_DEMAND: 'OnDemand',
  PIN_P_DOWN: 'PinPDown',
  PIN_P_MOVE: 'PinPMove',
  PIN_P_TOGGLE: 'PinPToggle',
  PIN_P_UP: 'PinPUp',
  PLAY_SPEED_DOWN: 'PlaySpeedDown',
  PLAY_SPEED_RESET: 'PlaySpeedReset',
  PLAY_SPEED_UP: 'PlaySpeedUp',
  RANDOM_TOGGLE: 'RandomToggle',
  RC_LOW_BATTERY: 'RcLowBattery',
  RECORD_SPEED_NEXT: 'RecordSpeedNext',
  RF_BYPASS: 'RfBypass',
  SCAN_CHANNELS_TOGGLE: 'ScanChannelsToggle ',
  SCREEN_MODE_NEXT: 'ScreenModeNext',
  SETTINGS: 'Settings',
  SPLIT_SCREEN_TOGGLE: 'SplitScreenToggle',
  SUBTITLE: 'Subtitle',
  TELETEXT: 'Teletext',
  VIDEO_MODE_NEXT: 'VideoModeNext',
  WINK: 'Wink',
  ZOOM_TOGGLE: 'ZoomToggle'
};

// goog.a11y.aria.Role
goog.provide('goog.a11y.aria.Role');
goog.a11y.aria.Role = {
  ALERT: 'alert',
  ALERTDIALOG: 'alertdialog',
  APPLICATION: 'application',
  ARTICLE: 'article',
  BANNER: 'banner',
  BUTTON: 'button',
  CHECKBOX: 'checkbox',
  COLUMNHEADER: 'columnheader',
  COMBOBOX: 'combobox',
  COMPLEMENTARY: 'complementary',
  CONTENTINFO: 'contentinfo',
  DEFINITION: 'definition',
  DIALOG: 'dialog',
  DIRECTORY: 'directory',
  DOCUMENT: 'document',
  FORM: 'form',
  GRID: 'grid',
  GRIDCELL: 'gridcell',
  GROUP: 'group',
  HEADING: 'heading',
  IMG: 'img',
  LINK: 'link',
  LIST: 'list',
  LISTBOX: 'listbox',
  LISTITEM: 'listitem',
  LOG: 'log',
  MAIN: 'main',
  MARQUEE: 'marquee',
  MATH: 'math',
  MENU: 'menu',
  MENUBAR: 'menubar',
  MENU_ITEM: 'menuitem',
  MENU_ITEM_CHECKBOX: 'menuitemcheckbox',
  MENU_ITEM_RADIO: 'menuitemradio',
  NAVIGATION: 'navigation',
  NOTE: 'note',
  OPTION: 'option',
  PRESENTATION: 'presentation',
  PROGRESSBAR: 'progressbar',
  RADIO: 'radio',
  RADIOGROUP: 'radiogroup',
  REGION: 'region',
  ROW: 'row',
  ROWGROUP: 'rowgroup',
  ROWHEADER: 'rowheader',
  SCROLLBAR: 'scrollbar',
  SEARCH: 'search',
  SEPARATOR: 'separator',
  SLIDER: 'slider',
  SPINBUTTON: 'spinbutton',
  STATUS: 'status',
  TAB: 'tab',
  TAB_LIST: 'tablist',
  TAB_PANEL: 'tabpanel',
  TEXTBOX: 'textbox',
  TEXTINFO: 'textinfo',
  TIMER: 'timer',
  TOOLBAR: 'toolbar',
  TOOLTIP: 'tooltip',
  TREE: 'tree',
  TREEGRID: 'treegrid',
  TREEITEM: 'treeitem'
};

// goog.a11y.aria.AutoCompleteValues
// goog.a11y.aria.CheckedValues
// goog.a11y.aria.DropEffectValues
// goog.a11y.aria.ExpandedValues
// goog.a11y.aria.GrabbedValues
// goog.a11y.aria.InvalidValues
// goog.a11y.aria.LivePriority
// goog.a11y.aria.OrientationValues
// goog.a11y.aria.PressedValues
// goog.a11y.aria.RelevantValues
// goog.a11y.aria.SelectedValues
// goog.a11y.aria.SortValues
// goog.a11y.aria.State
goog.provide('goog.a11y.aria.AutoCompleteValues');
goog.provide('goog.a11y.aria.CheckedValues');
goog.provide('goog.a11y.aria.DropEffectValues');
goog.provide('goog.a11y.aria.ExpandedValues');
goog.provide('goog.a11y.aria.GrabbedValues');
goog.provide('goog.a11y.aria.InvalidValues');
goog.provide('goog.a11y.aria.LivePriority');
goog.provide('goog.a11y.aria.OrientationValues');
goog.provide('goog.a11y.aria.PressedValues');
goog.provide('goog.a11y.aria.RelevantValues');
goog.provide('goog.a11y.aria.SelectedValues');
goog.provide('goog.a11y.aria.SortValues');
goog.provide('goog.a11y.aria.State');
goog.a11y.aria.State = {
  ACTIVEDESCENDANT: 'activedescendant',
  ATOMIC: 'atomic',
  AUTOCOMPLETE: 'autocomplete',
  BUSY: 'busy',
  CHECKED: 'checked',
  CONTROLS: 'controls',
  DESCRIBEDBY: 'describedby',
  DISABLED: 'disabled',
  DROPEFFECT: 'dropeffect',
  EXPANDED: 'expanded',
  FLOWTO: 'flowto',
  GRABBED: 'grabbed',
  HASPOPUP: 'haspopup',
  HIDDEN: 'hidden',
  INVALID: 'invalid',
  LABEL: 'label',
  LABELLEDBY: 'labelledby',
  LEVEL: 'level',
  LIVE: 'live',
  MULTILINE: 'multiline',
  MULTISELECTABLE: 'multiselectable',
  ORIENTATION: 'orientation',
  OWNS: 'owns',
  POSINSET: 'posinset',
  PRESSED: 'pressed',
  READONLY: 'readonly',
  RELEVANT: 'relevant',
  REQUIRED: 'required',
  SELECTED: 'selected',
  SETSIZE: 'setsize',
  SORT: 'sort',
  VALUEMAX: 'valuemax',
  VALUEMIN: 'valuemin',
  VALUENOW: 'valuenow',
  VALUETEXT: 'valuetext'
};
goog.a11y.aria.AutoCompleteValues = {
  INLINE: 'inline',
  LIST: 'list',
  BOTH: 'both',
  NONE: 'none'
};
goog.a11y.aria.DropEffectValues = {
  COPY: 'copy',
  MOVE: 'move',
  LINK: 'link',
  EXECUTE: 'execute',
  POPUP: 'popup',
  NONE: 'none'
};
goog.a11y.aria.LivePriority = {
  OFF: 'off',
  POLITE: 'polite',
  ASSERTIVE: 'assertive'
};
goog.a11y.aria.OrientationValues = {
  VERTICAL: 'vertical',
  HORIZONTAL: 'horizontal'
};
goog.a11y.aria.RelevantValues = {
  ADDITIONS: 'additions',
  REMOVALS: 'removals',
  TEXT: 'text',
  ALL: 'all'
};
goog.a11y.aria.SortValues = {
  ASCENDING: 'ascending',
  DESCENDING: 'descending',
  NONE: 'none',
  OTHER: 'other'
};
goog.a11y.aria.CheckedValues = {
  TRUE: 'true',
  FALSE: 'false',
  MIXED: 'mixed',
  UNDEFINED: 'undefined'
};
goog.a11y.aria.ExpandedValues = {
  TRUE: 'true',
  FALSE: 'false',
  UNDEFINED: 'undefined'
};
goog.a11y.aria.GrabbedValues = {
  TRUE: 'true',
  FALSE: 'false',
  UNDEFINED: 'undefined'
};
goog.a11y.aria.InvalidValues = {
  FALSE: 'false',
  TRUE: 'true',
  GRAMMAR: 'grammar',
  SPELLING: 'spelling'
};
goog.a11y.aria.PressedValues = {
  TRUE: 'true',
  FALSE: 'false',
  MIXED: 'mixed',
  UNDEFINED: 'undefined'
};
goog.a11y.aria.SelectedValues = {
  TRUE: 'true',
  FALSE: 'false',
  UNDEFINED: 'undefined'
};

// goog.a11y.aria.datatables
goog.provide('goog.a11y.aria.datatables');
goog.a11y.aria.DefaultStateValueMap_;
goog.a11y.aria.datatables.getDefaultValuesMap = function() {
  if (!goog.a11y.aria.DefaultStateValueMap_) {
    goog.a11y.aria.DefaultStateValueMap_ = goog.object.create(
        goog.a11y.aria.State.ATOMIC, false,
        goog.a11y.aria.State.AUTOCOMPLETE, 'none',
        goog.a11y.aria.State.DROPEFFECT, 'none',
        goog.a11y.aria.State.HASPOPUP, false,
        goog.a11y.aria.State.LIVE, 'off',
        goog.a11y.aria.State.MULTILINE, false,
        goog.a11y.aria.State.MULTISELECTABLE, false,
        goog.a11y.aria.State.ORIENTATION, 'vertical',
        goog.a11y.aria.State.READONLY, false,
        goog.a11y.aria.State.RELEVANT, 'additions text',
        goog.a11y.aria.State.REQUIRED, false,
        goog.a11y.aria.State.SORT, 'none',
        goog.a11y.aria.State.BUSY, false,
        goog.a11y.aria.State.DISABLED, false,
        goog.a11y.aria.State.HIDDEN, false,
        goog.a11y.aria.State.INVALID, 'false');
  }
  return goog.a11y.aria.DefaultStateValueMap_;
};

// goog.a11y.aria
goog.provide('goog.a11y.aria');
goog.a11y.aria.ARIA_PREFIX_ = 'aria-';
goog.a11y.aria.ROLE_ATTRIBUTE_ = 'role';
goog.a11y.aria.TAGS_WITH_ASSUMED_ROLES_ = [
  goog.dom.TagName.A,
  goog.dom.TagName.AREA,
  goog.dom.TagName.BUTTON,
  goog.dom.TagName.HEAD,
  goog.dom.TagName.INPUT,
  goog.dom.TagName.LINK,
  goog.dom.TagName.MENU,
  goog.dom.TagName.META,
  goog.dom.TagName.OPTGROUP,
  goog.dom.TagName.OPTION,
  goog.dom.TagName.PROGRESS,
  goog.dom.TagName.STYLE,
  goog.dom.TagName.SELECT,
  goog.dom.TagName.SOURCE,
  goog.dom.TagName.TEXTAREA,
  goog.dom.TagName.TITLE,
  goog.dom.TagName.TRACK
];
goog.a11y.aria.CONTAINER_ROLES_ = [
  goog.a11y.aria.Role.COMBOBOX,
  goog.a11y.aria.Role.GRID,
  goog.a11y.aria.Role.GROUP,
  goog.a11y.aria.Role.LISTBOX,
  goog.a11y.aria.Role.MENU,
  goog.a11y.aria.Role.MENUBAR,
  goog.a11y.aria.Role.RADIOGROUP,
  goog.a11y.aria.Role.ROW,
  goog.a11y.aria.Role.ROWGROUP,
  goog.a11y.aria.Role.TAB_LIST,
  goog.a11y.aria.Role.TEXTBOX,
  goog.a11y.aria.Role.TOOLBAR,
  goog.a11y.aria.Role.TREE,
  goog.a11y.aria.Role.TREEGRID
];
goog.a11y.aria.setRole = function(element, roleName) {
  if (!roleName) {
    goog.a11y.aria.removeRole(element);
  } else {
    if (goog.asserts.ENABLE_ASSERTS) {
      goog.asserts.assert(goog.object.containsValue(
          goog.a11y.aria.Role, roleName), 'No such ARIA role ' + roleName);
    }
    element.setAttribute(goog.a11y.aria.ROLE_ATTRIBUTE_, roleName);
  }
};
goog.a11y.aria.getRole = function(element) {
  var role = element.getAttribute(goog.a11y.aria.ROLE_ATTRIBUTE_);
  return  (role) || null;
};
goog.a11y.aria.removeRole = function(element) {
  element.removeAttribute(goog.a11y.aria.ROLE_ATTRIBUTE_);
};
goog.a11y.aria.setState = function(element, stateName, value) {
  if (goog.isArray(value)) {
    value = value.join(' ');
  }
  var attrStateName = goog.a11y.aria.getAriaAttributeName_(stateName);
  if (value === '' || value == undefined) {
    var defaultValueMap = goog.a11y.aria.datatables.getDefaultValuesMap();
    if (stateName in defaultValueMap) {
      element.setAttribute(attrStateName, defaultValueMap[stateName]);
    } else {
      element.removeAttribute(attrStateName);
    }
  } else {
    element.setAttribute(attrStateName, value);
  }
};
goog.a11y.aria.toggleState = function(el, attr) {
  var val = goog.a11y.aria.getState(el, attr);
  if (!goog.string.isEmptyOrWhitespace(goog.string.makeSafe(val)) &&
      !(val == 'true' || val == 'false')) {
    goog.a11y.aria.removeState(el,  (attr));
    return;
  }
  goog.a11y.aria.setState(el, attr, val == 'true' ? 'false' : 'true');
};
goog.a11y.aria.removeState = function(element, stateName) {
  element.removeAttribute(goog.a11y.aria.getAriaAttributeName_(stateName));
};
goog.a11y.aria.getState = function(element, stateName) {
  var attr =
       (element.getAttribute(
      goog.a11y.aria.getAriaAttributeName_(stateName)));
  var isNullOrUndefined = attr == null || attr == undefined;
  return isNullOrUndefined ? '' : String(attr);
};
goog.a11y.aria.getActiveDescendant = function(element) {
  var id = goog.a11y.aria.getState(
      element, goog.a11y.aria.State.ACTIVEDESCENDANT);
  return goog.dom.getOwnerDocument(element).getElementById(id);
};
goog.a11y.aria.setActiveDescendant = function(element, activeElement) {
  var id = '';
  if (activeElement) {
    id = activeElement.id;
    goog.asserts.assert(id, 'The active element should have an id.');
  }
  goog.a11y.aria.setState(element, goog.a11y.aria.State.ACTIVEDESCENDANT, id);
};
goog.a11y.aria.getLabel = function(element) {
  return goog.a11y.aria.getState(element, goog.a11y.aria.State.LABEL);
};
goog.a11y.aria.setLabel = function(element, label) {
  goog.a11y.aria.setState(element, goog.a11y.aria.State.LABEL, label);
};
goog.a11y.aria.assertRoleIsSetInternalUtil = function(element, allowedRoles) {
  if (goog.array.contains(goog.a11y.aria.TAGS_WITH_ASSUMED_ROLES_,
      element.tagName)) {
    return;
  }
  var elementRole =  (goog.a11y.aria.getRole(element));
  goog.asserts.assert(elementRole != null,
      'The element ARIA role cannot be null.');
  goog.asserts.assert(goog.array.contains(allowedRoles, elementRole),
      'Non existing or incorrect role set for element.' +
      'The role set is "' + elementRole +
      '". The role should be any of "' + allowedRoles +
      '". Check the ARIA specification for more details ' +
      'http://www.w3.org/TR/wai-aria/roles.');
};
goog.a11y.aria.getStateBoolean = function(element, stateName) {
  var attr =
       (element.getAttribute(
          goog.a11y.aria.getAriaAttributeName_(stateName)));
  goog.asserts.assert(
      goog.isBoolean(attr) || attr == null || attr == 'true' ||
          attr == 'false');
  if (attr == null) {
    return attr;
  }
  return goog.isBoolean(attr) ? attr : attr == 'true';
};
goog.a11y.aria.getStateNumber = function(element, stateName) {
  var attr =
       (element.getAttribute(
          goog.a11y.aria.getAriaAttributeName_(stateName)));
  goog.asserts.assert((attr == null || !isNaN(Number(attr))) &&
      !goog.isBoolean(attr));
  return attr == null ? null : Number(attr);
};
goog.a11y.aria.getStateString = function(element, stateName) {
  var attr = element.getAttribute(
      goog.a11y.aria.getAriaAttributeName_(stateName));
  goog.asserts.assert((attr == null || goog.isString(attr)) &&
      isNaN(Number(attr)) && attr != 'true' && attr != 'false');
  return attr == null ? null : attr;
};
goog.a11y.aria.getStringArrayStateInternalUtil = function(element, stateName) {
  var attrValue = element.getAttribute(
      goog.a11y.aria.getAriaAttributeName_(stateName));
  return goog.a11y.aria.splitStringOnWhitespace_(attrValue);
};
goog.a11y.aria.isContainerRole = function(element) {
  var role = goog.a11y.aria.getRole(element);
  return goog.array.contains(goog.a11y.aria.CONTAINER_ROLES_, role);
};
goog.a11y.aria.splitStringOnWhitespace_ = function(stringValue) {
  return stringValue ? stringValue.split(/\s+/) : [];
};
goog.a11y.aria.getAriaAttributeName_ = function(ariaName) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.assert(ariaName, 'ARIA attribute cannot be empty.');
    goog.asserts.assert(goog.object.containsValue(
        goog.a11y.aria.State, ariaName),
        'No such ARIA attribute ' + ariaName);
  }
  return goog.a11y.aria.ARIA_PREFIX_ + ariaName;
};

// goog.events.KeyCodes
goog.provide('goog.events.KeyCodes');
goog.forwardDeclare('goog.events.BrowserEvent');
goog.events.KeyCodes = {
  WIN_KEY_FF_LINUX: 0,
  MAC_ENTER: 3,
  BACKSPACE: 8,
  TAB: 9,
  NUM_CENTER: 12,  // NUMLOCK on FF/Safari Mac
  ENTER: 13,
  SHIFT: 16,
  CTRL: 17,
  ALT: 18,
  PAUSE: 19,
  CAPS_LOCK: 20,
  ESC: 27,
  SPACE: 32,
  PAGE_UP: 33,     // also NUM_NORTH_EAST
  PAGE_DOWN: 34,   // also NUM_SOUTH_EAST
  END: 35,         // also NUM_SOUTH_WEST
  HOME: 36,        // also NUM_NORTH_WEST
  LEFT: 37,        // also NUM_WEST
  UP: 38,          // also NUM_NORTH
  RIGHT: 39,       // also NUM_EAST
  DOWN: 40,        // also NUM_SOUTH
  PRINT_SCREEN: 44,
  INSERT: 45,      // also NUM_INSERT
  DELETE: 46,      // also NUM_DELETE
  ZERO: 48,
  ONE: 49,
  TWO: 50,
  THREE: 51,
  FOUR: 52,
  FIVE: 53,
  SIX: 54,
  SEVEN: 55,
  EIGHT: 56,
  NINE: 57,
  FF_SEMICOLON: 59, // Firefox (Gecko) fires this for semicolon instead of 186
  FF_EQUALS: 61, // Firefox (Gecko) fires this for equals instead of 187
  FF_DASH: 173, // Firefox (Gecko) fires this for dash instead of 189
  QUESTION_MARK: 63, // needs localization
  A: 65,
  B: 66,
  C: 67,
  D: 68,
  E: 69,
  F: 70,
  G: 71,
  H: 72,
  I: 73,
  J: 74,
  K: 75,
  L: 76,
  M: 77,
  N: 78,
  O: 79,
  P: 80,
  Q: 81,
  R: 82,
  S: 83,
  T: 84,
  U: 85,
  V: 86,
  W: 87,
  X: 88,
  Y: 89,
  Z: 90,
  META: 91, // WIN_KEY_LEFT
  WIN_KEY_RIGHT: 92,
  CONTEXT_MENU: 93,
  NUM_ZERO: 96,
  NUM_ONE: 97,
  NUM_TWO: 98,
  NUM_THREE: 99,
  NUM_FOUR: 100,
  NUM_FIVE: 101,
  NUM_SIX: 102,
  NUM_SEVEN: 103,
  NUM_EIGHT: 104,
  NUM_NINE: 105,
  NUM_MULTIPLY: 106,
  NUM_PLUS: 107,
  NUM_MINUS: 109,
  NUM_PERIOD: 110,
  NUM_DIVISION: 111,
  F1: 112,
  F2: 113,
  F3: 114,
  F4: 115,
  F5: 116,
  F6: 117,
  F7: 118,
  F8: 119,
  F9: 120,
  F10: 121,
  F11: 122,
  F12: 123,
  NUMLOCK: 144,
  SCROLL_LOCK: 145,
  FIRST_MEDIA_KEY: 166,
  LAST_MEDIA_KEY: 183,
  SEMICOLON: 186,            // needs localization
  DASH: 189,                 // needs localization
  EQUALS: 187,               // needs localization
  COMMA: 188,                // needs localization
  PERIOD: 190,               // needs localization
  SLASH: 191,                // needs localization
  APOSTROPHE: 192,           // needs localization
  TILDE: 192,                // needs localization
  SINGLE_QUOTE: 222,         // needs localization
  OPEN_SQUARE_BRACKET: 219,  // needs localization
  BACKSLASH: 220,            // needs localization
  CLOSE_SQUARE_BRACKET: 221, // needs localization
  WIN_KEY: 224,
  MAC_FF_META: 224, // Firefox (Gecko) fires this for the meta key instead of 91
  MAC_WK_CMD_LEFT: 91,  // WebKit Left Command key fired, same as META
  MAC_WK_CMD_RIGHT: 93, // WebKit Right Command key fired, different from META
  WIN_IME: 229,
  VK_NONAME: 252,
  PHANTOM: 255
};
goog.events.KeyCodes.isTextModifyingKeyEvent = function(e) {
  if (e.altKey && !e.ctrlKey ||
      e.metaKey ||
      e.keyCode >= goog.events.KeyCodes.F1 &&
      e.keyCode <= goog.events.KeyCodes.F12) {
    return false;
  }
  switch (e.keyCode) {
    case goog.events.KeyCodes.ALT:
    case goog.events.KeyCodes.CAPS_LOCK:
    case goog.events.KeyCodes.CONTEXT_MENU:
    case goog.events.KeyCodes.CTRL:
    case goog.events.KeyCodes.DOWN:
    case goog.events.KeyCodes.END:
    case goog.events.KeyCodes.ESC:
    case goog.events.KeyCodes.HOME:
    case goog.events.KeyCodes.INSERT:
    case goog.events.KeyCodes.LEFT:
    case goog.events.KeyCodes.MAC_FF_META:
    case goog.events.KeyCodes.META:
    case goog.events.KeyCodes.NUMLOCK:
    case goog.events.KeyCodes.NUM_CENTER:
    case goog.events.KeyCodes.PAGE_DOWN:
    case goog.events.KeyCodes.PAGE_UP:
    case goog.events.KeyCodes.PAUSE:
    case goog.events.KeyCodes.PHANTOM:
    case goog.events.KeyCodes.PRINT_SCREEN:
    case goog.events.KeyCodes.RIGHT:
    case goog.events.KeyCodes.SCROLL_LOCK:
    case goog.events.KeyCodes.SHIFT:
    case goog.events.KeyCodes.UP:
    case goog.events.KeyCodes.VK_NONAME:
    case goog.events.KeyCodes.WIN_KEY:
    case goog.events.KeyCodes.WIN_KEY_RIGHT:
      return false;
    case goog.events.KeyCodes.WIN_KEY_FF_LINUX:
      return !goog.userAgent.GECKO;
    default:
      return e.keyCode < goog.events.KeyCodes.FIRST_MEDIA_KEY ||
          e.keyCode > goog.events.KeyCodes.LAST_MEDIA_KEY;
  }
};
goog.events.KeyCodes.firesKeyPressEvent = function(keyCode, opt_heldKeyCode,
    opt_shiftKey, opt_ctrlKey, opt_altKey) {
  if (!goog.userAgent.IE && !goog.userAgent.EDGE &&
      !(goog.userAgent.WEBKIT && goog.userAgent.isVersionOrHigher('525'))) {
    return true;
  }
  if (goog.userAgent.MAC && opt_altKey) {
    return goog.events.KeyCodes.isCharacterKey(keyCode);
  }
  if (opt_altKey && !opt_ctrlKey) {
    return false;
  }
  if (goog.isNumber(opt_heldKeyCode)) {
    opt_heldKeyCode = goog.events.KeyCodes.normalizeKeyCode(opt_heldKeyCode);
  }
  if (!opt_shiftKey &&
      (opt_heldKeyCode == goog.events.KeyCodes.CTRL ||
       opt_heldKeyCode == goog.events.KeyCodes.ALT ||
       goog.userAgent.MAC &&
       opt_heldKeyCode == goog.events.KeyCodes.META)) {
    return false;
  }
  if ((goog.userAgent.WEBKIT || goog.userAgent.EDGE) &&
      opt_ctrlKey && opt_shiftKey) {
    switch (keyCode) {
      case goog.events.KeyCodes.BACKSLASH:
      case goog.events.KeyCodes.OPEN_SQUARE_BRACKET:
      case goog.events.KeyCodes.CLOSE_SQUARE_BRACKET:
      case goog.events.KeyCodes.TILDE:
      case goog.events.KeyCodes.SEMICOLON:
      case goog.events.KeyCodes.DASH:
      case goog.events.KeyCodes.EQUALS:
      case goog.events.KeyCodes.COMMA:
      case goog.events.KeyCodes.PERIOD:
      case goog.events.KeyCodes.SLASH:
      case goog.events.KeyCodes.APOSTROPHE:
      case goog.events.KeyCodes.SINGLE_QUOTE:
        return false;
    }
  }
  if (goog.userAgent.IE && opt_ctrlKey && opt_heldKeyCode == keyCode) {
    return false;
  }
  switch (keyCode) {
    case goog.events.KeyCodes.ENTER:
      return true;
    case goog.events.KeyCodes.ESC:
      return !(goog.userAgent.WEBKIT || goog.userAgent.EDGE);
  }
  return goog.events.KeyCodes.isCharacterKey(keyCode);
};
goog.events.KeyCodes.isCharacterKey = function(keyCode) {
  if (keyCode >= goog.events.KeyCodes.ZERO &&
      keyCode <= goog.events.KeyCodes.NINE) {
    return true;
  }
  if (keyCode >= goog.events.KeyCodes.NUM_ZERO &&
      keyCode <= goog.events.KeyCodes.NUM_MULTIPLY) {
    return true;
  }
  if (keyCode >= goog.events.KeyCodes.A &&
      keyCode <= goog.events.KeyCodes.Z) {
    return true;
  }
  if ((goog.userAgent.WEBKIT || goog.userAgent.EDGE) && keyCode == 0) {
    return true;
  }
  switch (keyCode) {
    case goog.events.KeyCodes.SPACE:
    case goog.events.KeyCodes.QUESTION_MARK:
    case goog.events.KeyCodes.NUM_PLUS:
    case goog.events.KeyCodes.NUM_MINUS:
    case goog.events.KeyCodes.NUM_PERIOD:
    case goog.events.KeyCodes.NUM_DIVISION:
    case goog.events.KeyCodes.SEMICOLON:
    case goog.events.KeyCodes.FF_SEMICOLON:
    case goog.events.KeyCodes.DASH:
    case goog.events.KeyCodes.EQUALS:
    case goog.events.KeyCodes.FF_EQUALS:
    case goog.events.KeyCodes.COMMA:
    case goog.events.KeyCodes.PERIOD:
    case goog.events.KeyCodes.SLASH:
    case goog.events.KeyCodes.APOSTROPHE:
    case goog.events.KeyCodes.SINGLE_QUOTE:
    case goog.events.KeyCodes.OPEN_SQUARE_BRACKET:
    case goog.events.KeyCodes.BACKSLASH:
    case goog.events.KeyCodes.CLOSE_SQUARE_BRACKET:
      return true;
    default:
      return false;
  }
};
goog.events.KeyCodes.normalizeKeyCode = function(keyCode) {
  if (goog.userAgent.GECKO) {
    return goog.events.KeyCodes.normalizeGeckoKeyCode(keyCode);
  } else if (goog.userAgent.MAC && goog.userAgent.WEBKIT) {
    return goog.events.KeyCodes.normalizeMacWebKitKeyCode(keyCode);
  } else {
    return keyCode;
  }
};
goog.events.KeyCodes.normalizeGeckoKeyCode = function(keyCode) {
  switch (keyCode) {
    case goog.events.KeyCodes.FF_EQUALS:
      return goog.events.KeyCodes.EQUALS;
    case goog.events.KeyCodes.FF_SEMICOLON:
      return goog.events.KeyCodes.SEMICOLON;
    case goog.events.KeyCodes.FF_DASH:
      return goog.events.KeyCodes.DASH;
    case goog.events.KeyCodes.MAC_FF_META:
      return goog.events.KeyCodes.META;
    case goog.events.KeyCodes.WIN_KEY_FF_LINUX:
      return goog.events.KeyCodes.WIN_KEY;
    default:
      return keyCode;
  }
};
goog.events.KeyCodes.normalizeMacWebKitKeyCode = function(keyCode) {
  switch (keyCode) {
    case goog.events.KeyCodes.MAC_WK_CMD_RIGHT:  // 93
      return goog.events.KeyCodes.META;          // 91
    default:
      return keyCode;
  }
};

// goog.events.KeyEvent
// goog.events.KeyHandler
// goog.events.KeyHandler.EventType
goog.provide('goog.events.KeyEvent');
goog.provide('goog.events.KeyHandler');
goog.provide('goog.events.KeyHandler.EventType');
goog.events.KeyHandler = function(opt_element, opt_capture) {
  goog.events.EventTarget.call(this);
  if (opt_element) {
    this.attach(opt_element, opt_capture);
  }
};
goog.inherits(goog.events.KeyHandler, goog.events.EventTarget);
goog.events.KeyHandler.prototype.element_ = null;
goog.events.KeyHandler.prototype.keyPressKey_ = null;
goog.events.KeyHandler.prototype.keyDownKey_ = null;
goog.events.KeyHandler.prototype.keyUpKey_ = null;
goog.events.KeyHandler.prototype.lastKey_ = -1;
goog.events.KeyHandler.prototype.keyCode_ = -1;
goog.events.KeyHandler.prototype.altKey_ = false;
goog.events.KeyHandler.EventType = {
  KEY: 'key'
};
goog.events.KeyHandler.safariKey_ = {
  '3': goog.events.KeyCodes.ENTER, // 13
  '12': goog.events.KeyCodes.NUMLOCK, // 144
  '63232': goog.events.KeyCodes.UP, // 38
  '63233': goog.events.KeyCodes.DOWN, // 40
  '63234': goog.events.KeyCodes.LEFT, // 37
  '63235': goog.events.KeyCodes.RIGHT, // 39
  '63236': goog.events.KeyCodes.F1, // 112
  '63237': goog.events.KeyCodes.F2, // 113
  '63238': goog.events.KeyCodes.F3, // 114
  '63239': goog.events.KeyCodes.F4, // 115
  '63240': goog.events.KeyCodes.F5, // 116
  '63241': goog.events.KeyCodes.F6, // 117
  '63242': goog.events.KeyCodes.F7, // 118
  '63243': goog.events.KeyCodes.F8, // 119
  '63244': goog.events.KeyCodes.F9, // 120
  '63245': goog.events.KeyCodes.F10, // 121
  '63246': goog.events.KeyCodes.F11, // 122
  '63247': goog.events.KeyCodes.F12, // 123
  '63248': goog.events.KeyCodes.PRINT_SCREEN, // 44
  '63272': goog.events.KeyCodes.DELETE, // 46
  '63273': goog.events.KeyCodes.HOME, // 36
  '63275': goog.events.KeyCodes.END, // 35
  '63276': goog.events.KeyCodes.PAGE_UP, // 33
  '63277': goog.events.KeyCodes.PAGE_DOWN, // 34
  '63289': goog.events.KeyCodes.NUMLOCK, // 144
  '63302': goog.events.KeyCodes.INSERT // 45
};
goog.events.KeyHandler.keyIdentifier_ = {
  'Up': goog.events.KeyCodes.UP, // 38
  'Down': goog.events.KeyCodes.DOWN, // 40
  'Left': goog.events.KeyCodes.LEFT, // 37
  'Right': goog.events.KeyCodes.RIGHT, // 39
  'Enter': goog.events.KeyCodes.ENTER, // 13
  'F1': goog.events.KeyCodes.F1, // 112
  'F2': goog.events.KeyCodes.F2, // 113
  'F3': goog.events.KeyCodes.F3, // 114
  'F4': goog.events.KeyCodes.F4, // 115
  'F5': goog.events.KeyCodes.F5, // 116
  'F6': goog.events.KeyCodes.F6, // 117
  'F7': goog.events.KeyCodes.F7, // 118
  'F8': goog.events.KeyCodes.F8, // 119
  'F9': goog.events.KeyCodes.F9, // 120
  'F10': goog.events.KeyCodes.F10, // 121
  'F11': goog.events.KeyCodes.F11, // 122
  'F12': goog.events.KeyCodes.F12, // 123
  'U+007F': goog.events.KeyCodes.DELETE, // 46
  'Home': goog.events.KeyCodes.HOME, // 36
  'End': goog.events.KeyCodes.END, // 35
  'PageUp': goog.events.KeyCodes.PAGE_UP, // 33
  'PageDown': goog.events.KeyCodes.PAGE_DOWN, // 34
  'Insert': goog.events.KeyCodes.INSERT // 45
};
goog.events.KeyHandler.USES_KEYDOWN_ = goog.userAgent.IE ||
    goog.userAgent.EDGE ||
    goog.userAgent.WEBKIT && goog.userAgent.isVersionOrHigher('525');
goog.events.KeyHandler.SAVE_ALT_FOR_KEYPRESS_ = goog.userAgent.MAC &&
    goog.userAgent.GECKO;
goog.events.KeyHandler.prototype.handleKeyDown_ = function(e) {
  if (goog.userAgent.WEBKIT || goog.userAgent.EDGE) {
    if (this.lastKey_ == goog.events.KeyCodes.CTRL && !e.ctrlKey ||
        this.lastKey_ == goog.events.KeyCodes.ALT && !e.altKey ||
        goog.userAgent.MAC &&
        this.lastKey_ == goog.events.KeyCodes.META && !e.metaKey) {
      this.resetState();
    }
  }
  if (this.lastKey_ == -1) {
    if (e.ctrlKey && e.keyCode != goog.events.KeyCodes.CTRL) {
      this.lastKey_ = goog.events.KeyCodes.CTRL;
    } else if (e.altKey && e.keyCode != goog.events.KeyCodes.ALT) {
      this.lastKey_ = goog.events.KeyCodes.ALT;
    } else if (e.metaKey && e.keyCode != goog.events.KeyCodes.META) {
      this.lastKey_ = goog.events.KeyCodes.META;
    }
  }
  if (goog.events.KeyHandler.USES_KEYDOWN_ &&
      !goog.events.KeyCodes.firesKeyPressEvent(e.keyCode,
          this.lastKey_, e.shiftKey, e.ctrlKey, e.altKey)) {
    this.handleEvent(e);
  } else {
    this.keyCode_ = goog.events.KeyCodes.normalizeKeyCode(e.keyCode);
    if (goog.events.KeyHandler.SAVE_ALT_FOR_KEYPRESS_) {
      this.altKey_ = e.altKey;
    }
  }
};
goog.events.KeyHandler.prototype.resetState = function() {
  this.lastKey_ = -1;
  this.keyCode_ = -1;
};
goog.events.KeyHandler.prototype.handleKeyup_ = function(e) {
  this.resetState();
  this.altKey_ = e.altKey;
};
goog.events.KeyHandler.prototype.handleEvent = function(e) {
  var be = e.getBrowserEvent();
  var keyCode, charCode;
  var altKey = be.altKey;
  if (goog.userAgent.IE && e.type == goog.events.EventType.KEYPRESS) {
    keyCode = this.keyCode_;
    charCode = keyCode != goog.events.KeyCodes.ENTER &&
        keyCode != goog.events.KeyCodes.ESC ?
            be.keyCode : 0;
  } else if ((goog.userAgent.WEBKIT || goog.userAgent.EDGE) &&
      e.type == goog.events.EventType.KEYPRESS) {
    keyCode = this.keyCode_;
    charCode = be.charCode >= 0 && be.charCode < 63232 &&
        goog.events.KeyCodes.isCharacterKey(keyCode) ?
            be.charCode : 0;
  } else if (goog.userAgent.OPERA && !goog.userAgent.WEBKIT) {
    keyCode = this.keyCode_;
    charCode = goog.events.KeyCodes.isCharacterKey(keyCode) ?
        be.keyCode : 0;
  } else {
    keyCode = be.keyCode || this.keyCode_;
    charCode = be.charCode || 0;
    if (goog.events.KeyHandler.SAVE_ALT_FOR_KEYPRESS_) {
      altKey = this.altKey_;
    }
    if (goog.userAgent.MAC &&
        charCode == goog.events.KeyCodes.QUESTION_MARK &&
        keyCode == goog.events.KeyCodes.WIN_KEY) {
      keyCode = goog.events.KeyCodes.SLASH;
    }
  }
  keyCode = goog.events.KeyCodes.normalizeKeyCode(keyCode);
  var key = keyCode;
  var keyIdentifier = be.keyIdentifier;
  if (keyCode) {
    if (keyCode >= 63232 && keyCode in goog.events.KeyHandler.safariKey_) {
      key = goog.events.KeyHandler.safariKey_[keyCode];
    } else {
      if (keyCode == 25 && e.shiftKey) {
        key = 9;
      }
    }
  } else if (keyIdentifier &&
             keyIdentifier in goog.events.KeyHandler.keyIdentifier_) {
    key = goog.events.KeyHandler.keyIdentifier_[keyIdentifier];
  }
  var repeat = key == this.lastKey_;
  this.lastKey_ = key;
  var event = new goog.events.KeyEvent(key, charCode, repeat, be);
  event.altKey = altKey;
  this.dispatchEvent(event);
};
goog.events.KeyHandler.prototype.getElement = function() {
  return this.element_;
};
goog.events.KeyHandler.prototype.attach = function(element, opt_capture) {
  if (this.keyUpKey_) {
    this.detach();
  }
  this.element_ = element;
  this.keyPressKey_ = goog.events.listen(this.element_,
                                         goog.events.EventType.KEYPRESS,
                                         this,
                                         opt_capture);
  this.keyDownKey_ = goog.events.listen(this.element_,
                                        goog.events.EventType.KEYDOWN,
                                        this.handleKeyDown_,
                                        opt_capture,
                                        this);
  this.keyUpKey_ = goog.events.listen(this.element_,
                                      goog.events.EventType.KEYUP,
                                      this.handleKeyup_,
                                      opt_capture,
                                      this);
};
goog.events.KeyHandler.prototype.detach = function() {
  if (this.keyPressKey_) {
    goog.events.unlistenByKey(this.keyPressKey_);
    goog.events.unlistenByKey(this.keyDownKey_);
    goog.events.unlistenByKey(this.keyUpKey_);
    this.keyPressKey_ = null;
    this.keyDownKey_ = null;
    this.keyUpKey_ = null;
  }
  this.element_ = null;
  this.lastKey_ = -1;
  this.keyCode_ = -1;
};
goog.events.KeyHandler.prototype.disposeInternal = function() {
  goog.events.KeyHandler.superClass_.disposeInternal.call(this);
  this.detach();
};
goog.events.KeyEvent = function(keyCode, charCode, repeat, browserEvent) {
  goog.events.BrowserEvent.call(this, browserEvent);
  this.type = goog.events.KeyHandler.EventType.KEY;
  this.keyCode = keyCode;
  this.charCode = charCode;
  this.repeat = repeat;
};
goog.inherits(goog.events.KeyEvent, goog.events.BrowserEvent);

// goog.events.EventHandler
goog.provide('goog.events.EventHandler');
goog.forwardDeclare('goog.events.EventWrapper');
goog.events.EventHandler = function(opt_scope) {
  goog.Disposable.call(this);
  this.handler_ = opt_scope;
  this.keys_ = {};
};
goog.inherits(goog.events.EventHandler, goog.Disposable);
goog.events.EventHandler.typeArray_ = [];
goog.events.EventHandler.prototype.listen = function(
    src, type, opt_fn, opt_capture) {
  return this.listen_(src, type, opt_fn, opt_capture);
};
goog.events.EventHandler.prototype.listenWithScope = function(
    src, type, fn, capture, scope) {
  return this.listen_(src, type, fn, capture, scope);
};
goog.events.EventHandler.prototype.listen_ = function(src, type, opt_fn,
                                                      opt_capture,
                                                      opt_scope) {
  if (!goog.isArray(type)) {
    if (type) {
      goog.events.EventHandler.typeArray_[0] = type.toString();
    }
    type = goog.events.EventHandler.typeArray_;
  }
  for (var i = 0; i < type.length; i++) {
    var listenerObj = goog.events.listen(
        src, type[i], opt_fn || this.handleEvent,
        opt_capture || false,
        opt_scope || this.handler_ || this);
    if (!listenerObj) {
      return this;
    }
    var key = listenerObj.key;
    this.keys_[key] = listenerObj;
  }
  return this;
};
goog.events.EventHandler.prototype.listenOnce = function(
    src, type, opt_fn, opt_capture) {
  return this.listenOnce_(src, type, opt_fn, opt_capture);
};
goog.events.EventHandler.prototype.listenOnceWithScope = function(
    src, type, fn, capture, scope) {
  return this.listenOnce_(src, type, fn, capture, scope);
};
goog.events.EventHandler.prototype.listenOnce_ = function(
    src, type, opt_fn, opt_capture, opt_scope) {
  if (goog.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      this.listenOnce_(src, type[i], opt_fn, opt_capture, opt_scope);
    }
  } else {
    var listenerObj = goog.events.listenOnce(
        src, type, opt_fn || this.handleEvent, opt_capture,
        opt_scope || this.handler_ || this);
    if (!listenerObj) {
      return this;
    }
    var key = listenerObj.key;
    this.keys_[key] = listenerObj;
  }
  return this;
};
goog.events.EventHandler.prototype.listenWithWrapper = function(
    src, wrapper, listener, opt_capt) {
  return this.listenWithWrapper_(src, wrapper, listener, opt_capt);
};
goog.events.EventHandler.prototype.listenWithWrapperAndScope = function(
    src, wrapper, listener, capture, scope) {
  return this.listenWithWrapper_(src, wrapper, listener, capture, scope);
};
goog.events.EventHandler.prototype.listenWithWrapper_ = function(
    src, wrapper, listener, opt_capt, opt_scope) {
  wrapper.listen(src, listener, opt_capt, opt_scope || this.handler_ || this,
                 this);
  return this;
};
goog.events.EventHandler.prototype.getListenerCount = function() {
  var count = 0;
  for (var key in this.keys_) {
    if (Object.prototype.hasOwnProperty.call(this.keys_, key)) {
      count++;
    }
  }
  return count;
};
goog.events.EventHandler.prototype.unlisten = function(src, type, opt_fn,
                                                       opt_capture,
                                                       opt_scope) {
  if (goog.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      this.unlisten(src, type[i], opt_fn, opt_capture, opt_scope);
    }
  } else {
    var listener = goog.events.getListener(src, type,
        opt_fn || this.handleEvent,
        opt_capture, opt_scope || this.handler_ || this);
    if (listener) {
      goog.events.unlistenByKey(listener);
      delete this.keys_[listener.key];
    }
  }
  return this;
};
goog.events.EventHandler.prototype.unlistenWithWrapper = function(src, wrapper,
    listener, opt_capt, opt_scope) {
  wrapper.unlisten(src, listener, opt_capt,
                   opt_scope || this.handler_ || this, this);
  return this;
};
goog.events.EventHandler.prototype.removeAll = function() {
  goog.object.forEach(this.keys_, function(listenerObj, key) {
    if (this.keys_.hasOwnProperty(key)) {
      goog.events.unlistenByKey(listenerObj);
    }
  }, this);
  this.keys_ = {};
};
goog.events.EventHandler.prototype.disposeInternal = function() {
  goog.events.EventHandler.superClass_.disposeInternal.call(this);
  this.removeAll();
};
goog.events.EventHandler.prototype.handleEvent = function(e) {
  throw Error('EventHandler.handleEvent not implemented');
};

// goog.ui.IdGenerator
goog.provide('goog.ui.IdGenerator');
goog.ui.IdGenerator = function() {
};
goog.addSingletonGetter(goog.ui.IdGenerator);
goog.ui.IdGenerator.prototype.nextId_ = 0;
goog.ui.IdGenerator.prototype.getNextUniqueId = function() {
  return ':' + (this.nextId_++).toString(36);
};

// goog.ui.Component
// goog.ui.Component.Error
// goog.ui.Component.EventType
// goog.ui.Component.State
goog.provide('goog.ui.Component');
goog.provide('goog.ui.Component.Error');
goog.provide('goog.ui.Component.EventType');
goog.provide('goog.ui.Component.State');
goog.ui.Component = function(opt_domHelper) {
  goog.events.EventTarget.call(this);
  this.dom_ = opt_domHelper || goog.dom.getDomHelper();
  this.rightToLeft_ = goog.ui.Component.defaultRightToLeft_;
  this.id_ = null;
  this.inDocument_ = false;
  this.element_ = null;
  this.googUiComponentHandler_ = void 0;
  this.model_ = null;
  this.parent_ = null;
  this.children_ = null;
  this.childIndex_ = null;
  this.wasDecorated_ = false;
};
goog.inherits(goog.ui.Component, goog.events.EventTarget);
goog.define('goog.ui.Component.ALLOW_DETACHED_DECORATION', false);
goog.ui.Component.prototype.idGenerator_ = goog.ui.IdGenerator.getInstance();
goog.define('goog.ui.Component.DEFAULT_BIDI_DIR', 0);
goog.ui.Component.defaultRightToLeft_ =
    (goog.ui.Component.DEFAULT_BIDI_DIR == 1) ? false :
    (goog.ui.Component.DEFAULT_BIDI_DIR == -1) ? true : null;
goog.ui.Component.EventType = {
  BEFORE_SHOW: 'beforeshow',
  SHOW: 'show',
  HIDE: 'hide',
  DISABLE: 'disable',
  ENABLE: 'enable',
  HIGHLIGHT: 'highlight',
  UNHIGHLIGHT: 'unhighlight',
  ACTIVATE: 'activate',
  DEACTIVATE: 'deactivate',
  SELECT: 'select',
  UNSELECT: 'unselect',
  CHECK: 'check',
  UNCHECK: 'uncheck',
  FOCUS: 'focus',
  BLUR: 'blur',
  OPEN: 'open',
  CLOSE: 'close',
  ENTER: 'enter',
  LEAVE: 'leave',
  ACTION: 'action',
  CHANGE: 'change'
};
goog.ui.Component.Error = {
  NOT_SUPPORTED: 'Method not supported',
  DECORATE_INVALID: 'Invalid element to decorate',
  ALREADY_RENDERED: 'Component already rendered',
  PARENT_UNABLE_TO_BE_SET: 'Unable to set parent component',
  CHILD_INDEX_OUT_OF_BOUNDS: 'Child component index out of bounds',
  NOT_OUR_CHILD: 'Child is not in parent component',
  NOT_IN_DOCUMENT: 'Operation not supported while component is not in document',
  STATE_INVALID: 'Invalid component state'
};
goog.ui.Component.State = {
  ALL: 0xFF,
  DISABLED: 0x01,
  HOVER: 0x02,
  ACTIVE: 0x04,
  SELECTED: 0x08,
  CHECKED: 0x10,
  FOCUSED: 0x20,
  OPENED: 0x40
};
goog.ui.Component.getStateTransitionEvent = function(state, isEntering) {
  switch (state) {
    case goog.ui.Component.State.DISABLED:
      return isEntering ? goog.ui.Component.EventType.DISABLE :
          goog.ui.Component.EventType.ENABLE;
    case goog.ui.Component.State.HOVER:
      return isEntering ? goog.ui.Component.EventType.HIGHLIGHT :
          goog.ui.Component.EventType.UNHIGHLIGHT;
    case goog.ui.Component.State.ACTIVE:
      return isEntering ? goog.ui.Component.EventType.ACTIVATE :
          goog.ui.Component.EventType.DEACTIVATE;
    case goog.ui.Component.State.SELECTED:
      return isEntering ? goog.ui.Component.EventType.SELECT :
          goog.ui.Component.EventType.UNSELECT;
    case goog.ui.Component.State.CHECKED:
      return isEntering ? goog.ui.Component.EventType.CHECK :
          goog.ui.Component.EventType.UNCHECK;
    case goog.ui.Component.State.FOCUSED:
      return isEntering ? goog.ui.Component.EventType.FOCUS :
          goog.ui.Component.EventType.BLUR;
    case goog.ui.Component.State.OPENED:
      return isEntering ? goog.ui.Component.EventType.OPEN :
          goog.ui.Component.EventType.CLOSE;
    default:
  }
  throw Error(goog.ui.Component.Error.STATE_INVALID);
};
goog.ui.Component.setDefaultRightToLeft = function(rightToLeft) {
  goog.ui.Component.defaultRightToLeft_ = rightToLeft;
};
goog.ui.Component.prototype.getId = function() {
  return this.id_ || (this.id_ = this.idGenerator_.getNextUniqueId());
};
goog.ui.Component.prototype.setId = function(id) {
  if (this.parent_ && this.parent_.childIndex_) {
    goog.object.remove(this.parent_.childIndex_, this.id_);
    goog.object.add(this.parent_.childIndex_, id, this);
  }
  this.id_ = id;
};
goog.ui.Component.prototype.getElement = function() {
  return this.element_;
};
goog.ui.Component.prototype.getElementStrict = function() {
  var el = this.element_;
  goog.asserts.assert(
      el, 'Can not call getElementStrict before rendering/decorating.');
  return el;
};
goog.ui.Component.prototype.setElementInternal = function(element) {
  this.element_ = element;
};
goog.ui.Component.prototype.getElementsByClass = function(className) {
  return this.element_ ?
      this.dom_.getElementsByClass(className, this.element_) : [];
};
goog.ui.Component.prototype.getElementByClass = function(className) {
  return this.element_ ?
      this.dom_.getElementByClass(className, this.element_) : null;
};
goog.ui.Component.prototype.getRequiredElementByClass = function(className) {
  var el = this.getElementByClass(className);
  goog.asserts.assert(el, 'Expected element in component with class: %s',
      className);
  return el;
};
goog.ui.Component.prototype.getHandler = function() {
  var self =  (this);
  if (!self.googUiComponentHandler_) {
    self.googUiComponentHandler_ = new goog.events.EventHandler(self);
  }
  return self.googUiComponentHandler_;
};
goog.ui.Component.prototype.setParent = function(parent) {
  if (this == parent) {
    throw Error(goog.ui.Component.Error.PARENT_UNABLE_TO_BE_SET);
  }
  if (parent && this.parent_ && this.id_ && this.parent_.getChild(this.id_) &&
      this.parent_ != parent) {
    throw Error(goog.ui.Component.Error.PARENT_UNABLE_TO_BE_SET);
  }
  this.parent_ = parent;
  goog.ui.Component.superClass_.setParentEventTarget.call(this, parent);
};
goog.ui.Component.prototype.getParent = function() {
  return this.parent_;
};
goog.ui.Component.prototype.setParentEventTarget = function(parent) {
  if (this.parent_ && this.parent_ != parent) {
    throw Error(goog.ui.Component.Error.NOT_SUPPORTED);
  }
  goog.ui.Component.superClass_.setParentEventTarget.call(this, parent);
};
goog.ui.Component.prototype.getDomHelper = function() {
  return this.dom_;
};
goog.ui.Component.prototype.isInDocument = function() {
  return this.inDocument_;
};
goog.ui.Component.prototype.createDom = function() {
  this.element_ = this.dom_.createElement(goog.dom.TagName.DIV);
};
goog.ui.Component.prototype.render = function(opt_parentElement) {
  this.render_(opt_parentElement);
};
goog.ui.Component.prototype.renderBefore = function(sibling) {
  this.render_( (sibling.parentNode),
               sibling);
};
goog.ui.Component.prototype.render_ = function(opt_parentElement,
                                               opt_beforeNode) {
  if (this.inDocument_) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  if (!this.element_) {
    this.createDom();
  }
  if (opt_parentElement) {
    opt_parentElement.insertBefore(this.element_, opt_beforeNode || null);
  } else {
    this.dom_.getDocument().body.appendChild(this.element_);
  }
  if (!this.parent_ || this.parent_.isInDocument()) {
    this.enterDocument();
  }
};
goog.ui.Component.prototype.decorate = function(element) {
  if (this.inDocument_) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  } else if (element && this.canDecorate(element)) {
    this.wasDecorated_ = true;
    var doc = goog.dom.getOwnerDocument(element);
    if (!this.dom_ || this.dom_.getDocument() != doc) {
      this.dom_ = goog.dom.getDomHelper(element);
    }
    this.decorateInternal(element);
    if (!goog.ui.Component.ALLOW_DETACHED_DECORATION ||
        goog.dom.contains(doc, element)) {
      this.enterDocument();
    }
  } else {
    throw Error(goog.ui.Component.Error.DECORATE_INVALID);
  }
};
goog.ui.Component.prototype.canDecorate = function(element) {
  return true;
};
goog.ui.Component.prototype.wasDecorated = function() {
  return this.wasDecorated_;
};
goog.ui.Component.prototype.decorateInternal = function(element) {
  this.element_ = element;
};
goog.ui.Component.prototype.enterDocument = function() {
  this.inDocument_ = true;
  this.forEachChild(function(child) {
    if (!child.isInDocument() && child.getElement()) {
      child.enterDocument();
    }
  });
};
goog.ui.Component.prototype.exitDocument = function() {
  this.forEachChild(function(child) {
    if (child.isInDocument()) {
      child.exitDocument();
    }
  });
  if (this.googUiComponentHandler_) {
    this.googUiComponentHandler_.removeAll();
  }
  this.inDocument_ = false;
};
goog.ui.Component.prototype.disposeInternal = function() {
  if (this.inDocument_) {
    this.exitDocument();
  }
  if (this.googUiComponentHandler_) {
    this.googUiComponentHandler_.dispose();
    delete this.googUiComponentHandler_;
  }
  this.forEachChild(function(child) {
    child.dispose();
  });
  if (!this.wasDecorated_ && this.element_) {
    goog.dom.removeNode(this.element_);
  }
  this.children_ = null;
  this.childIndex_ = null;
  this.element_ = null;
  this.model_ = null;
  this.parent_ = null;
  goog.ui.Component.superClass_.disposeInternal.call(this);
};
goog.ui.Component.prototype.makeId = function(idFragment) {
  return this.getId() + '.' + idFragment;
};
goog.ui.Component.prototype.makeIds = function(object) {
  var ids = {};
  for (var key in object) {
    ids[key] = this.makeId(object[key]);
  }
  return ids;
};
goog.ui.Component.prototype.getModel = function() {
  return this.model_;
};
goog.ui.Component.prototype.setModel = function(obj) {
  this.model_ = obj;
};
goog.ui.Component.prototype.getFragmentFromId = function(id) {
  return id.substring(this.getId().length + 1);
};
goog.ui.Component.prototype.getElementByFragment = function(idFragment) {
  if (!this.inDocument_) {
    throw Error(goog.ui.Component.Error.NOT_IN_DOCUMENT);
  }
  return this.dom_.getElement(this.makeId(idFragment));
};
goog.ui.Component.prototype.addChild = function(child, opt_render) {
  this.addChildAt(child, this.getChildCount(), opt_render);
};
goog.ui.Component.prototype.addChildAt = function(child, index, opt_render) {
  goog.asserts.assert(!!child, 'Provided element must not be null.');
  if (child.inDocument_ && (opt_render || !this.inDocument_)) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  if (index < 0 || index > this.getChildCount()) {
    throw Error(goog.ui.Component.Error.CHILD_INDEX_OUT_OF_BOUNDS);
  }
  if (!this.childIndex_ || !this.children_) {
    this.childIndex_ = {};
    this.children_ = [];
  }
  if (child.getParent() == this) {
    goog.object.set(this.childIndex_, child.getId(), child);
    goog.array.remove(this.children_, child);
  } else {
    goog.object.add(this.childIndex_, child.getId(), child);
  }
  child.setParent(this);
  goog.array.insertAt(this.children_, child, index);
  if (child.inDocument_ && this.inDocument_ && child.getParent() == this) {
    var contentElement = this.getContentElement();
    var insertBeforeElement = contentElement.childNodes[index] || null;
    if (insertBeforeElement != child.getElement()) {
      contentElement.insertBefore(child.getElement(), insertBeforeElement);
    }
  } else if (opt_render) {
    if (!this.element_) {
      this.createDom();
    }
    var sibling = this.getChildAt(index + 1);
    child.render_(this.getContentElement(), sibling ? sibling.element_ : null);
  } else if (this.inDocument_ && !child.inDocument_ && child.element_ &&
      child.element_.parentNode &&
      child.element_.parentNode.nodeType == goog.dom.NodeType.ELEMENT) {
    child.enterDocument();
  }
};
goog.ui.Component.prototype.getContentElement = function() {
  return this.element_;
};
goog.ui.Component.prototype.isRightToLeft = function() {
  if (this.rightToLeft_ == null) {
    this.rightToLeft_ = goog.style.isRightToLeft(this.inDocument_ ?
        this.element_ : this.dom_.getDocument().body);
  }
  return this.rightToLeft_;
};
goog.ui.Component.prototype.setRightToLeft = function(rightToLeft) {
  if (this.inDocument_) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  this.rightToLeft_ = rightToLeft;
};
goog.ui.Component.prototype.hasChildren = function() {
  return !!this.children_ && this.children_.length != 0;
};
goog.ui.Component.prototype.getChildCount = function() {
  return this.children_ ? this.children_.length : 0;
};
goog.ui.Component.prototype.getChildIds = function() {
  var ids = [];
  this.forEachChild(function(child) {
    ids.push(child.getId());
  });
  return ids;
};
goog.ui.Component.prototype.getChild = function(id) {
  return (this.childIndex_ && id) ?  (
      goog.object.get(this.childIndex_, id)) || null : null;
};
goog.ui.Component.prototype.getChildAt = function(index) {
  return this.children_ ? this.children_[index] || null : null;
};
goog.ui.Component.prototype.forEachChild = function(f, opt_obj) {
  if (this.children_) {
    goog.array.forEach(this.children_, f, opt_obj);
  }
};
goog.ui.Component.prototype.indexOfChild = function(child) {
  return (this.children_ && child) ? goog.array.indexOf(this.children_, child) :
      -1;
};
goog.ui.Component.prototype.removeChild = function(child, opt_unrender) {
  if (child) {
    var id = goog.isString(child) ? child : child.getId();
    child = this.getChild(id);
    if (id && child) {
      goog.object.remove(this.childIndex_, id);
      goog.array.remove(this.children_, child);
      if (opt_unrender) {
        child.exitDocument();
        if (child.element_) {
          goog.dom.removeNode(child.element_);
        }
      }
      child.setParent(null);
    }
  }
  if (!child) {
    throw Error(goog.ui.Component.Error.NOT_OUR_CHILD);
  }
  return (child);
};
goog.ui.Component.prototype.removeChildAt = function(index, opt_unrender) {
  return this.removeChild(this.getChildAt(index), opt_unrender);
};
goog.ui.Component.prototype.removeChildren = function(opt_unrender) {
  var removedChildren = [];
  while (this.hasChildren()) {
    removedChildren.push(this.removeChildAt(0, opt_unrender));
  }
  return removedChildren;
};

// goog.dom.classlist
goog.provide('goog.dom.classlist');
goog.define('goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST', false);
goog.dom.classlist.get = function(element) {
  if (goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST || element.classList) {
    return element.classList;
  }
  var className = element.className;
  return goog.isString(className) && className.match(/\S+/g) || [];
};
goog.dom.classlist.set = function(element, className) {
  element.className = className;
};
goog.dom.classlist.contains = function(element, className) {
  if (goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST || element.classList) {
    return element.classList.contains(className);
  }
  return goog.array.contains(goog.dom.classlist.get(element), className);
};
goog.dom.classlist.add = function(element, className) {
  if (goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST || element.classList) {
    element.classList.add(className);
    return;
  }
  if (!goog.dom.classlist.contains(element, className)) {
    element.className += element.className.length > 0 ?
        (' ' + className) : className;
  }
};
goog.dom.classlist.addAll = function(element, classesToAdd) {
  if (goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST || element.classList) {
    goog.array.forEach(classesToAdd, function(className) {
      goog.dom.classlist.add(element, className);
    });
    return;
  }
  var classMap = {};
  goog.array.forEach(goog.dom.classlist.get(element),
      function(className) {
        classMap[className] = true;
      });
  goog.array.forEach(classesToAdd,
      function(className) {
        classMap[className] = true;
      });
  element.className = '';
  for (var className in classMap) {
    element.className += element.className.length > 0 ?
        (' ' + className) : className;
  }
};
goog.dom.classlist.remove = function(element, className) {
  if (goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST || element.classList) {
    element.classList.remove(className);
    return;
  }
  if (goog.dom.classlist.contains(element, className)) {
    element.className = goog.array.filter(
        goog.dom.classlist.get(element),
        function(c) {
          return c != className;
        }).join(' ');
  }
};
goog.dom.classlist.removeAll = function(element, classesToRemove) {
  if (goog.dom.classlist.ALWAYS_USE_DOM_TOKEN_LIST || element.classList) {
    goog.array.forEach(classesToRemove, function(className) {
      goog.dom.classlist.remove(element, className);
    });
    return;
  }
  element.className = goog.array.filter(
      goog.dom.classlist.get(element),
      function(className) {
        return !goog.array.contains(classesToRemove, className);
      }).join(' ');
};
goog.dom.classlist.enable = function(element, className, enabled) {
  if (enabled) {
    goog.dom.classlist.add(element, className);
  } else {
    goog.dom.classlist.remove(element, className);
  }
};
goog.dom.classlist.enableAll = function(element, classesToEnable, enabled) {
  var f = enabled ? goog.dom.classlist.addAll :
      goog.dom.classlist.removeAll;
  f(element, classesToEnable);
};
goog.dom.classlist.swap = function(element, fromClass, toClass) {
  if (goog.dom.classlist.contains(element, fromClass)) {
    goog.dom.classlist.remove(element, fromClass);
    goog.dom.classlist.add(element, toClass);
    return true;
  }
  return false;
};
goog.dom.classlist.toggle = function(element, className) {
  var add = !goog.dom.classlist.contains(element, className);
  goog.dom.classlist.enable(element, className, add);
  return add;
};
goog.dom.classlist.addRemove = function(element, classToRemove, classToAdd) {
  goog.dom.classlist.remove(element, classToRemove);
  goog.dom.classlist.add(element, classToAdd);
};

// goog.ui.registry
goog.provide('goog.ui.registry');
goog.ui.registry.getDefaultRenderer = function(componentCtor) {
  var key;
   var rendererCtor;
  while (componentCtor) {
    key = goog.getUid(componentCtor);
    if ((rendererCtor = goog.ui.registry.defaultRenderers_[key])) {
      break;
    }
    componentCtor = componentCtor.superClass_ ?
        componentCtor.superClass_.constructor : null;
  }
  if (rendererCtor) {
    return goog.isFunction(rendererCtor.getInstance) ?
        rendererCtor.getInstance() : new rendererCtor();
  }
  return null;
};
goog.ui.registry.setDefaultRenderer = function(componentCtor, rendererCtor) {
  if (!goog.isFunction(componentCtor)) {
    throw Error('Invalid component class ' + componentCtor);
  }
  if (!goog.isFunction(rendererCtor)) {
    throw Error('Invalid renderer class ' + rendererCtor);
  }
  var key = goog.getUid(componentCtor);
  goog.ui.registry.defaultRenderers_[key] = rendererCtor;
};
goog.ui.registry.getDecoratorByClassName = function(className) {
  return className in goog.ui.registry.decoratorFunctions_ ?
      goog.ui.registry.decoratorFunctions_[className]() : null;
};
goog.ui.registry.setDecoratorByClassName = function(className, decoratorFn) {
  if (!className) {
    throw Error('Invalid class name ' + className);
  }
  if (!goog.isFunction(decoratorFn)) {
    throw Error('Invalid decorator function ' + decoratorFn);
  }
  goog.ui.registry.decoratorFunctions_[className] = decoratorFn;
};
goog.ui.registry.getDecorator = function(element) {
  var decorator;
  goog.asserts.assert(element);
  var classNames = goog.dom.classlist.get(element);
  for (var i = 0, len = classNames.length; i < len; i++) {
    if ((decorator = goog.ui.registry.getDecoratorByClassName(classNames[i]))) {
      return decorator;
    }
  }
  return null;
};
goog.ui.registry.reset = function() {
  goog.ui.registry.defaultRenderers_ = {};
  goog.ui.registry.decoratorFunctions_ = {};
};
goog.ui.registry.defaultRenderers_ = {};
goog.ui.registry.decoratorFunctions_ = {};

// goog.ui.ContainerRenderer
goog.provide('goog.ui.ContainerRenderer');
goog.ui.ContainerRenderer = function(opt_ariaRole) {
  this.ariaRole_ = opt_ariaRole;
};
goog.addSingletonGetter(goog.ui.ContainerRenderer);
goog.ui.ContainerRenderer.getCustomRenderer = function(ctor, cssClassName) {
  var renderer = new ctor();
  renderer.getCssClass = function() {
    return cssClassName;
  };
  return renderer;
};
goog.ui.ContainerRenderer.CSS_CLASS = goog.getCssName('goog-container');
goog.ui.ContainerRenderer.prototype.getAriaRole = function() {
  return this.ariaRole_;
};
goog.ui.ContainerRenderer.prototype.enableTabIndex = function(element, enable) {
  if (element) {
    element.tabIndex = enable ? 0 : -1;
  }
};
goog.ui.ContainerRenderer.prototype.createDom = function(container) {
  return container.getDomHelper().createDom(goog.dom.TagName.DIV,
      this.getClassNames(container).join(' '));
};
goog.ui.ContainerRenderer.prototype.getContentElement = function(element) {
  return element;
};
goog.ui.ContainerRenderer.prototype.canDecorate = function(element) {
  return element.tagName == 'DIV';
};
goog.ui.ContainerRenderer.prototype.decorate = function(container, element) {
  if (element.id) {
    container.setId(element.id);
  }
  var baseClass = this.getCssClass();
  var hasBaseClass = false;
  var classNames = goog.dom.classlist.get(element);
  if (classNames) {
    goog.array.forEach(classNames, function(className) {
      if (className == baseClass) {
        hasBaseClass = true;
      } else if (className) {
        this.setStateFromClassName(container, className, baseClass);
      }
    }, this);
  }
  if (!hasBaseClass) {
    goog.dom.classlist.add(element, baseClass);
  }
  this.decorateChildren(container, this.getContentElement(element));
  return element;
};
goog.ui.ContainerRenderer.prototype.setStateFromClassName = function(container,
    className, baseClass) {
  if (className == goog.getCssName(baseClass, 'disabled')) {
    container.setEnabled(false);
  } else if (className == goog.getCssName(baseClass, 'horizontal')) {
    container.setOrientation(goog.ui.Container.Orientation.HORIZONTAL);
  } else if (className == goog.getCssName(baseClass, 'vertical')) {
    container.setOrientation(goog.ui.Container.Orientation.VERTICAL);
  }
};
goog.ui.ContainerRenderer.prototype.decorateChildren = function(container,
    element, opt_firstChild) {
  if (element) {
    var node = opt_firstChild || element.firstChild, next;
    while (node && node.parentNode == element) {
      next = node.nextSibling;
      if (node.nodeType == goog.dom.NodeType.ELEMENT) {
        var child = this.getDecoratorForChild((node));
        if (child) {
          child.setElementInternal((node));
          if (!container.isEnabled()) {
            child.setEnabled(false);
          }
          container.addChild(child);
          child.decorate((node));
        }
      } else if (!node.nodeValue || goog.string.trim(node.nodeValue) == '') {
        element.removeChild(node);
      }
      node = next;
    }
  }
};
goog.ui.ContainerRenderer.prototype.getDecoratorForChild = function(element) {
  return  (
      goog.ui.registry.getDecorator(element));
};
goog.ui.ContainerRenderer.prototype.initializeDom = function(container) {
  var elem = container.getElement();
  goog.asserts.assert(elem, 'The container DOM element cannot be null.');
  goog.style.setUnselectable(elem, true, goog.userAgent.GECKO);
  if (goog.userAgent.IE) {
    elem.hideFocus = true;
  }
  var ariaRole = this.getAriaRole();
  if (ariaRole) {
    goog.a11y.aria.setRole(elem, ariaRole);
  }
};
goog.ui.ContainerRenderer.prototype.getKeyEventTarget = function(container) {
  return container.getElement();
};
goog.ui.ContainerRenderer.prototype.getCssClass = function() {
  return goog.ui.ContainerRenderer.CSS_CLASS;
};
goog.ui.ContainerRenderer.prototype.getClassNames = function(container) {
  var baseClass = this.getCssClass();
  var isHorizontal =
      container.getOrientation() == goog.ui.Container.Orientation.HORIZONTAL;
  var classNames = [
    baseClass,
    (isHorizontal ?
        goog.getCssName(baseClass, 'horizontal') :
        goog.getCssName(baseClass, 'vertical'))
  ];
  if (!container.isEnabled()) {
    classNames.push(goog.getCssName(baseClass, 'disabled'));
  }
  return classNames;
};
goog.ui.ContainerRenderer.prototype.getDefaultOrientation = function() {
  return goog.ui.Container.Orientation.VERTICAL;
};

// goog.ui.ControlContent
goog.provide('goog.ui.ControlContent');
goog.ui.ControlContent;

// goog.ui.ControlRenderer
goog.provide('goog.ui.ControlRenderer');
goog.ui.ControlRenderer = function() {
};
goog.addSingletonGetter(goog.ui.ControlRenderer);
goog.tagUnsealableClass(goog.ui.ControlRenderer);
goog.ui.ControlRenderer.getCustomRenderer = function(ctor, cssClassName) {
  var renderer = new ctor();
  renderer.getCssClass = function() {
    return cssClassName;
  };
  return renderer;
};
goog.ui.ControlRenderer.CSS_CLASS = goog.getCssName('goog-control');
goog.ui.ControlRenderer.IE6_CLASS_COMBINATIONS = [];
goog.ui.ControlRenderer.ariaAttributeMap_;
goog.ui.ControlRenderer.TOGGLE_ARIA_STATE_MAP_ = goog.object.create(
    goog.a11y.aria.Role.BUTTON, goog.a11y.aria.State.PRESSED,
    goog.a11y.aria.Role.CHECKBOX, goog.a11y.aria.State.CHECKED,
    goog.a11y.aria.Role.MENU_ITEM, goog.a11y.aria.State.SELECTED,
    goog.a11y.aria.Role.MENU_ITEM_CHECKBOX, goog.a11y.aria.State.CHECKED,
    goog.a11y.aria.Role.MENU_ITEM_RADIO, goog.a11y.aria.State.CHECKED,
    goog.a11y.aria.Role.RADIO, goog.a11y.aria.State.CHECKED,
    goog.a11y.aria.Role.TAB, goog.a11y.aria.State.SELECTED,
    goog.a11y.aria.Role.TREEITEM, goog.a11y.aria.State.SELECTED);
goog.ui.ControlRenderer.prototype.getAriaRole = function() {
  return undefined;
};
goog.ui.ControlRenderer.prototype.createDom = function(control) {
  var element = control.getDomHelper().createDom(
      goog.dom.TagName.DIV, this.getClassNames(control).join(' '),
      control.getContent());
  return element;
};
goog.ui.ControlRenderer.prototype.getContentElement = function(element) {
  return element;
};
goog.ui.ControlRenderer.prototype.enableClassName = function(control,
    className, enable) {
  var element =  (
      control.getElement ? control.getElement() : control);
  if (element) {
    var classNames = [className];
    if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('7')) {
      classNames = this.getAppliedCombinedClassNames_(
          goog.dom.classlist.get(element), className);
      classNames.push(className);
    }
    goog.dom.classlist.enableAll(element, classNames, enable);
  }
};
goog.ui.ControlRenderer.prototype.enableExtraClassName = function(control,
    className, enable) {
  this.enableClassName(control, className, enable);
};
goog.ui.ControlRenderer.prototype.canDecorate = function(element) {
  return true;
};
goog.ui.ControlRenderer.prototype.decorate = function(control, element) {
  if (element.id) {
    control.setId(element.id);
  }
  var contentElem = this.getContentElement(element);
  if (contentElem && contentElem.firstChild) {
    control.setContentInternal(contentElem.firstChild.nextSibling ?
        goog.array.clone(contentElem.childNodes) : contentElem.firstChild);
  } else {
    control.setContentInternal(null);
  }
  var state = 0x00;
  var rendererClassName = this.getCssClass();
  var structuralClassName = this.getStructuralCssClass();
  var hasRendererClassName = false;
  var hasStructuralClassName = false;
  var hasCombinedClassName = false;
  var classNames = goog.array.toArray(goog.dom.classlist.get(element));
  goog.array.forEach(classNames, function(className) {
    if (!hasRendererClassName && className == rendererClassName) {
      hasRendererClassName = true;
      if (structuralClassName == rendererClassName) {
        hasStructuralClassName = true;
      }
    } else if (!hasStructuralClassName && className == structuralClassName) {
      hasStructuralClassName = true;
    } else {
      state |= this.getStateFromClass(className);
    }
    if (this.getStateFromClass(className) == goog.ui.Component.State.DISABLED) {
      goog.asserts.assertElement(contentElem);
      if (goog.dom.isFocusableTabIndex(contentElem)) {
        goog.dom.setFocusableTabIndex(contentElem, false);
      }
    }
  }, this);
  control.setStateInternal(state);
  if (!hasRendererClassName) {
    classNames.push(rendererClassName);
    if (structuralClassName == rendererClassName) {
      hasStructuralClassName = true;
    }
  }
  if (!hasStructuralClassName) {
    classNames.push(structuralClassName);
  }
  var extraClassNames = control.getExtraClassNames();
  if (extraClassNames) {
    classNames.push.apply(classNames, extraClassNames);
  }
  if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('7')) {
    var combinedClasses = this.getAppliedCombinedClassNames_(
        classNames);
    if (combinedClasses.length > 0) {
      classNames.push.apply(classNames, combinedClasses);
      hasCombinedClassName = true;
    }
  }
  if (!hasRendererClassName || !hasStructuralClassName ||
      extraClassNames || hasCombinedClassName) {
    goog.dom.classlist.set(element, classNames.join(' '));
  }
  return element;
};
goog.ui.ControlRenderer.prototype.initializeDom = function(control) {
  if (control.isRightToLeft()) {
    this.setRightToLeft(control.getElement(), true);
  }
  if (control.isEnabled()) {
    this.setFocusable(control, control.isVisible());
  }
};
goog.ui.ControlRenderer.prototype.setAriaRole = function(element,
    opt_preferredRole) {
  var ariaRole = opt_preferredRole || this.getAriaRole();
  if (ariaRole) {
    goog.asserts.assert(element,
        'The element passed as a first parameter cannot be null.');
    var currentRole = goog.a11y.aria.getRole(element);
    if (ariaRole == currentRole) {
      return;
    }
    goog.a11y.aria.setRole(element, ariaRole);
  }
};
goog.ui.ControlRenderer.prototype.setAriaStates = function(control, element) {
  goog.asserts.assert(control);
  goog.asserts.assert(element);
  var ariaLabel = control.getAriaLabel();
  if (goog.isDefAndNotNull(ariaLabel)) {
    this.setAriaLabel(element, ariaLabel);
  }
  if (!control.isVisible()) {
    goog.a11y.aria.setState(
        element, goog.a11y.aria.State.HIDDEN, !control.isVisible());
  }
  if (!control.isEnabled()) {
    this.updateAriaState(
        element, goog.ui.Component.State.DISABLED, !control.isEnabled());
  }
  if (control.isSupportedState(goog.ui.Component.State.SELECTED)) {
    this.updateAriaState(
        element, goog.ui.Component.State.SELECTED, control.isSelected());
  }
  if (control.isSupportedState(goog.ui.Component.State.CHECKED)) {
    this.updateAriaState(
        element, goog.ui.Component.State.CHECKED, control.isChecked());
  }
  if (control.isSupportedState(goog.ui.Component.State.OPENED)) {
    this.updateAriaState(
        element, goog.ui.Component.State.OPENED, control.isOpen());
  }
};
goog.ui.ControlRenderer.prototype.setAriaLabel = function(element, ariaLabel) {
  goog.a11y.aria.setLabel(element, ariaLabel);
};
goog.ui.ControlRenderer.prototype.setAllowTextSelection = function(element,
    allow) {
  goog.style.setUnselectable(element, !allow,
      !goog.userAgent.IE && !goog.userAgent.OPERA);
};
goog.ui.ControlRenderer.prototype.setRightToLeft = function(element,
    rightToLeft) {
  this.enableClassName(element,
      goog.getCssName(this.getStructuralCssClass(), 'rtl'), rightToLeft);
};
goog.ui.ControlRenderer.prototype.isFocusable = function(control) {
  var keyTarget;
  if (control.isSupportedState(goog.ui.Component.State.FOCUSED) &&
      (keyTarget = control.getKeyEventTarget())) {
    return goog.dom.isFocusableTabIndex(keyTarget);
  }
  return false;
};
goog.ui.ControlRenderer.prototype.setFocusable = function(control, focusable) {
  var keyTarget;
  if (control.isSupportedState(goog.ui.Component.State.FOCUSED) &&
      (keyTarget = control.getKeyEventTarget())) {
    if (!focusable && control.isFocused()) {
      try {
        keyTarget.blur();
      } catch (e) {
      }
      if (control.isFocused()) {
        control.handleBlur(null);
      }
    }
    if (goog.dom.isFocusableTabIndex(keyTarget) != focusable) {
      goog.dom.setFocusableTabIndex(keyTarget, focusable);
    }
  }
};
goog.ui.ControlRenderer.prototype.setVisible = function(element, visible) {
  goog.style.setElementShown(element, visible);
  if (element) {
    goog.a11y.aria.setState(element, goog.a11y.aria.State.HIDDEN, !visible);
  }
};
goog.ui.ControlRenderer.prototype.setState = function(control, state, enable) {
  var element = control.getElement();
  if (element) {
    var className = this.getClassForState(state);
    if (className) {
      this.enableClassName(control, className, enable);
    }
    this.updateAriaState(element, state, enable);
  }
};
goog.ui.ControlRenderer.prototype.updateAriaState = function(element, state,
    enable) {
  if (!goog.ui.ControlRenderer.ariaAttributeMap_) {
    goog.ui.ControlRenderer.ariaAttributeMap_ = goog.object.create(
        goog.ui.Component.State.DISABLED, goog.a11y.aria.State.DISABLED,
        goog.ui.Component.State.SELECTED, goog.a11y.aria.State.SELECTED,
        goog.ui.Component.State.CHECKED, goog.a11y.aria.State.CHECKED,
        goog.ui.Component.State.OPENED, goog.a11y.aria.State.EXPANDED);
  }
  goog.asserts.assert(element,
      'The element passed as a first parameter cannot be null.');
  var ariaAttr = goog.ui.ControlRenderer.getAriaStateForAriaRole_(
      element, goog.ui.ControlRenderer.ariaAttributeMap_[state]);
  if (ariaAttr) {
    goog.a11y.aria.setState(element, ariaAttr, enable);
  }
};
goog.ui.ControlRenderer.getAriaStateForAriaRole_ = function(element, attr) {
  var role = goog.a11y.aria.getRole(element);
  if (!role) {
    return attr;
  }
  role =  (role);
  var matchAttr = goog.ui.ControlRenderer.TOGGLE_ARIA_STATE_MAP_[role] || attr;
  return goog.ui.ControlRenderer.isAriaState_(attr) ? matchAttr : attr;
};
goog.ui.ControlRenderer.isAriaState_ = function(attr) {
  return attr == goog.a11y.aria.State.CHECKED ||
      attr == goog.a11y.aria.State.SELECTED;
};
goog.ui.ControlRenderer.prototype.setContent = function(element, content) {
  var contentElem = this.getContentElement(element);
  if (contentElem) {
    goog.dom.removeChildren(contentElem);
    if (content) {
      if (goog.isString(content)) {
        goog.dom.setTextContent(contentElem, content);
      } else {
        var childHandler = function(child) {
          if (child) {
            var doc = goog.dom.getOwnerDocument(contentElem);
            contentElem.appendChild(goog.isString(child) ?
                doc.createTextNode(child) : child);
          }
        };
        if (goog.isArray(content)) {
          goog.array.forEach(content, childHandler);
        } else if (goog.isArrayLike(content) && !('nodeType' in content)) {
          goog.array.forEach(
              goog.array.clone((content)),
              childHandler);
        } else {
          childHandler(content);
        }
      }
    }
  }
};
goog.ui.ControlRenderer.prototype.getKeyEventTarget = function(control) {
  return control.getElement();
};
goog.ui.ControlRenderer.prototype.getCssClass = function() {
  return goog.ui.ControlRenderer.CSS_CLASS;
};
goog.ui.ControlRenderer.prototype.getIe6ClassCombinations = function() {
  return [];
};
goog.ui.ControlRenderer.prototype.getStructuralCssClass = function() {
  return this.getCssClass();
};
goog.ui.ControlRenderer.prototype.getClassNames = function(control) {
  var cssClass = this.getCssClass();
  var classNames = [cssClass];
  var structuralCssClass = this.getStructuralCssClass();
  if (structuralCssClass != cssClass) {
    classNames.push(structuralCssClass);
  }
  var classNamesForState = this.getClassNamesForState(control.getState());
  classNames.push.apply(classNames, classNamesForState);
  var extraClassNames = control.getExtraClassNames();
  if (extraClassNames) {
    classNames.push.apply(classNames, extraClassNames);
  }
  if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher('7')) {
    classNames.push.apply(classNames,
        this.getAppliedCombinedClassNames_(classNames));
  }
  return classNames;
};
goog.ui.ControlRenderer.prototype.getAppliedCombinedClassNames_ = function(
    classes, opt_includedClass) {
  var toAdd = [];
  if (opt_includedClass) {
    classes = classes.concat([opt_includedClass]);
  }
  goog.array.forEach(this.getIe6ClassCombinations(), function(combo) {
    if (goog.array.every(combo, goog.partial(goog.array.contains, classes)) &&
        (!opt_includedClass || goog.array.contains(combo, opt_includedClass))) {
      toAdd.push(combo.join('_'));
    }
  });
  return toAdd;
};
goog.ui.ControlRenderer.prototype.getClassNamesForState = function(state) {
  var classNames = [];
  while (state) {
    var mask = state & -state;  // Least significant bit
    classNames.push(this.getClassForState(
         (mask)));
    state &= ~mask;
  }
  return classNames;
};
goog.ui.ControlRenderer.prototype.getClassForState = function(state) {
  if (!this.classByState_) {
    this.createClassByStateMap_();
  }
  return this.classByState_[state];
};
goog.ui.ControlRenderer.prototype.getStateFromClass = function(className) {
  if (!this.stateByClass_) {
    this.createStateByClassMap_();
  }
  var state = parseInt(this.stateByClass_[className], 10);
  return  (isNaN(state) ? 0x00 : state);
};
goog.ui.ControlRenderer.prototype.createClassByStateMap_ = function() {
  var baseClass = this.getStructuralCssClass();
  var isValidClassName = !goog.string.contains(
      goog.string.normalizeWhitespace(baseClass), ' ');
  goog.asserts.assert(isValidClassName,
      'ControlRenderer has an invalid css class: \'' + baseClass + '\'');
  this.classByState_ = goog.object.create(
      goog.ui.Component.State.DISABLED, goog.getCssName(baseClass, 'disabled'),
      goog.ui.Component.State.HOVER, goog.getCssName(baseClass, 'hover'),
      goog.ui.Component.State.ACTIVE, goog.getCssName(baseClass, 'active'),
      goog.ui.Component.State.SELECTED, goog.getCssName(baseClass, 'selected'),
      goog.ui.Component.State.CHECKED, goog.getCssName(baseClass, 'checked'),
      goog.ui.Component.State.FOCUSED, goog.getCssName(baseClass, 'focused'),
      goog.ui.Component.State.OPENED, goog.getCssName(baseClass, 'open'));
};
goog.ui.ControlRenderer.prototype.createStateByClassMap_ = function() {
  if (!this.classByState_) {
    this.createClassByStateMap_();
  }
  this.stateByClass_ = goog.object.transpose(this.classByState_);
};

// goog.ui.decorate
goog.provide('goog.ui.decorate');
goog.ui.decorate = function(element) {
  var decorator = goog.ui.registry.getDecorator(element);
  if (decorator) {
    decorator.decorate(element);
  }
  return decorator;
};

// goog.ui.Control
goog.provide('goog.ui.Control');
goog.ui.Control = function(opt_content, opt_renderer, opt_domHelper) {
  goog.ui.Component.call(this, opt_domHelper);
  this.renderer_ = opt_renderer ||
      goog.ui.registry.getDefaultRenderer(this.constructor);
  this.setContentInternal(goog.isDef(opt_content) ? opt_content : null);
  this.ariaLabel_ = null;
  this.ieMouseEventSequenceSimulator_;
};
goog.inherits(goog.ui.Control, goog.ui.Component);
goog.tagUnsealableClass(goog.ui.Control);
goog.ui.Control.registerDecorator = goog.ui.registry.setDecoratorByClassName;
goog.ui.Control.getDecorator =
     (
        goog.ui.registry.getDecorator);
goog.ui.Control.decorate =  (
    goog.ui.decorate);
goog.ui.Control.prototype.renderer_;
goog.ui.Control.prototype.content_ = null;
goog.ui.Control.prototype.state_ = 0x00;
goog.ui.Control.prototype.supportedStates_ =
    goog.ui.Component.State.DISABLED |
    goog.ui.Component.State.HOVER |
    goog.ui.Component.State.ACTIVE |
    goog.ui.Component.State.FOCUSED;
goog.ui.Control.prototype.autoStates_ = goog.ui.Component.State.ALL;
goog.ui.Control.prototype.statesWithTransitionEvents_ = 0x00;
goog.ui.Control.prototype.visible_ = true;
goog.ui.Control.prototype.keyHandler_;
goog.ui.Control.prototype.extraClassNames_ = null;
goog.ui.Control.prototype.handleMouseEvents_ = true;
goog.ui.Control.prototype.allowTextSelection_ = false;
goog.ui.Control.prototype.preferredAriaRole_ = null;
goog.ui.Control.prototype.isHandleMouseEvents = function() {
  return this.handleMouseEvents_;
};
goog.ui.Control.prototype.setHandleMouseEvents = function(enable) {
  if (this.isInDocument() && enable != this.handleMouseEvents_) {
    this.enableMouseEventHandling_(enable);
  }
  this.handleMouseEvents_ = enable;
};
goog.ui.Control.prototype.getKeyEventTarget = function() {
  return this.renderer_.getKeyEventTarget(this);
};
goog.ui.Control.prototype.getKeyHandler = function() {
  return this.keyHandler_ || (this.keyHandler_ = new goog.events.KeyHandler());
};
goog.ui.Control.prototype.getRenderer = function() {
  return this.renderer_;
};
goog.ui.Control.prototype.setRenderer = function(renderer) {
  if (this.isInDocument()) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  if (this.getElement()) {
    this.setElementInternal(null);
  }
  this.renderer_ = renderer;
};
goog.ui.Control.prototype.getExtraClassNames = function() {
  return this.extraClassNames_;
};
goog.ui.Control.prototype.addClassName = function(className) {
  if (className) {
    if (this.extraClassNames_) {
      if (!goog.array.contains(this.extraClassNames_, className)) {
        this.extraClassNames_.push(className);
      }
    } else {
      this.extraClassNames_ = [className];
    }
    this.renderer_.enableExtraClassName(this, className, true);
  }
};
goog.ui.Control.prototype.removeClassName = function(className) {
  if (className && this.extraClassNames_ &&
      goog.array.remove(this.extraClassNames_, className)) {
    if (this.extraClassNames_.length == 0) {
      this.extraClassNames_ = null;
    }
    this.renderer_.enableExtraClassName(this, className, false);
  }
};
goog.ui.Control.prototype.enableClassName = function(className, enable) {
  if (enable) {
    this.addClassName(className);
  } else {
    this.removeClassName(className);
  }
};
goog.ui.Control.prototype.createDom = function() {
  var element = this.renderer_.createDom(this);
  this.setElementInternal(element);
  this.renderer_.setAriaRole(element, this.getPreferredAriaRole());
  if (!this.isAllowTextSelection()) {
    this.renderer_.setAllowTextSelection(element, false);
  }
  if (!this.isVisible()) {
    this.renderer_.setVisible(element, false);
  }
};
goog.ui.Control.prototype.getPreferredAriaRole = function() {
  return this.preferredAriaRole_;
};
goog.ui.Control.prototype.setPreferredAriaRole = function(role) {
  this.preferredAriaRole_ = role;
};
goog.ui.Control.prototype.getAriaLabel = function() {
  return this.ariaLabel_;
};
goog.ui.Control.prototype.setAriaLabel = function(label) {
  this.ariaLabel_ = label;
  var element = this.getElement();
  if (element) {
    this.renderer_.setAriaLabel(element, label);
  }
};
goog.ui.Control.prototype.getContentElement = function() {
  return this.renderer_.getContentElement(this.getElement());
};
goog.ui.Control.prototype.canDecorate = function(element) {
  return this.renderer_.canDecorate(element);
};
goog.ui.Control.prototype.decorateInternal = function(element) {
  element = this.renderer_.decorate(this, element);
  this.setElementInternal(element);
  this.renderer_.setAriaRole(element, this.getPreferredAriaRole());
  if (!this.isAllowTextSelection()) {
    this.renderer_.setAllowTextSelection(element, false);
  }
  this.visible_ = element.style.display != 'none';
};
goog.ui.Control.prototype.enterDocument = function() {
  goog.ui.Control.superClass_.enterDocument.call(this);
  this.renderer_.setAriaStates(this, this.getElementStrict());
  this.renderer_.initializeDom(this);
  if (this.supportedStates_ & ~goog.ui.Component.State.DISABLED) {
    if (this.isHandleMouseEvents()) {
      this.enableMouseEventHandling_(true);
    }
    if (this.isSupportedState(goog.ui.Component.State.FOCUSED)) {
      var keyTarget = this.getKeyEventTarget();
      if (keyTarget) {
        var keyHandler = this.getKeyHandler();
        keyHandler.attach(keyTarget);
        this.getHandler().
            listen(keyHandler, goog.events.KeyHandler.EventType.KEY,
                this.handleKeyEvent).
            listen(keyTarget, goog.events.EventType.FOCUS,
                this.handleFocus).
            listen(keyTarget, goog.events.EventType.BLUR,
                this.handleBlur);
      }
    }
  }
};
goog.ui.Control.prototype.enableMouseEventHandling_ = function(enable) {
  var handler = this.getHandler();
  var element = this.getElement();
  if (enable) {
    handler.
        listen(element, goog.events.EventType.MOUSEOVER, this.handleMouseOver).
        listen(element, goog.events.EventType.MOUSEDOWN, this.handleMouseDown).
        listen(element, goog.events.EventType.MOUSEUP, this.handleMouseUp).
        listen(element, goog.events.EventType.MOUSEOUT, this.handleMouseOut);
    if (this.handleContextMenu != goog.nullFunction) {
      handler.listen(element, goog.events.EventType.CONTEXTMENU,
          this.handleContextMenu);
    }
    if (goog.userAgent.IE) {
      handler.listen(element, goog.events.EventType.DBLCLICK,
          this.handleDblClick);
      if (!this.ieMouseEventSequenceSimulator_) {
        this.ieMouseEventSequenceSimulator_ =
            new goog.ui.Control.IeMouseEventSequenceSimulator_(this);
        this.registerDisposable(this.ieMouseEventSequenceSimulator_);
      }
    }
  } else {
    handler.
        unlisten(element, goog.events.EventType.MOUSEOVER,
            this.handleMouseOver).
        unlisten(element, goog.events.EventType.MOUSEDOWN,
            this.handleMouseDown).
        unlisten(element, goog.events.EventType.MOUSEUP, this.handleMouseUp).
        unlisten(element, goog.events.EventType.MOUSEOUT, this.handleMouseOut);
    if (this.handleContextMenu != goog.nullFunction) {
      handler.unlisten(element, goog.events.EventType.CONTEXTMENU,
          this.handleContextMenu);
    }
    if (goog.userAgent.IE) {
      handler.unlisten(element, goog.events.EventType.DBLCLICK,
          this.handleDblClick);
      goog.dispose(this.ieMouseEventSequenceSimulator_);
      this.ieMouseEventSequenceSimulator_ = null;
    }
  }
};
goog.ui.Control.prototype.exitDocument = function() {
  goog.ui.Control.superClass_.exitDocument.call(this);
  if (this.keyHandler_) {
    this.keyHandler_.detach();
  }
  if (this.isVisible() && this.isEnabled()) {
    this.renderer_.setFocusable(this, false);
  }
};
goog.ui.Control.prototype.disposeInternal = function() {
  goog.ui.Control.superClass_.disposeInternal.call(this);
  if (this.keyHandler_) {
    this.keyHandler_.dispose();
    delete this.keyHandler_;
  }
  delete this.renderer_;
  this.content_ = null;
  this.extraClassNames_ = null;
  this.ieMouseEventSequenceSimulator_ = null;
};
goog.ui.Control.prototype.getContent = function() {
  return this.content_;
};
goog.ui.Control.prototype.setContent = function(content) {
  this.renderer_.setContent(this.getElement(), content);
  this.setContentInternal(content);
};
goog.ui.Control.prototype.setContentInternal = function(content) {
  this.content_ = content;
};
goog.ui.Control.prototype.getCaption = function() {
  var content = this.getContent();
  if (!content) {
    return '';
  }
  var caption =
      goog.isString(content) ? content :
      goog.isArray(content) ? goog.array.map(content,
          goog.dom.getRawTextContent).join('') :
      goog.dom.getTextContent( (content));
  return goog.string.collapseBreakingSpaces(caption);
};
goog.ui.Control.prototype.setCaption = function(caption) {
  this.setContent(caption);
};
goog.ui.Control.prototype.setRightToLeft = function(rightToLeft) {
  goog.ui.Control.superClass_.setRightToLeft.call(this, rightToLeft);
  var element = this.getElement();
  if (element) {
    this.renderer_.setRightToLeft(element, rightToLeft);
  }
};
goog.ui.Control.prototype.isAllowTextSelection = function() {
  return this.allowTextSelection_;
};
goog.ui.Control.prototype.setAllowTextSelection = function(allow) {
  this.allowTextSelection_ = allow;
  var element = this.getElement();
  if (element) {
    this.renderer_.setAllowTextSelection(element, allow);
  }
};
goog.ui.Control.prototype.isVisible = function() {
  return this.visible_;
};
goog.ui.Control.prototype.setVisible = function(visible, opt_force) {
  if (opt_force || (this.visible_ != visible && this.dispatchEvent(visible ?
      goog.ui.Component.EventType.SHOW : goog.ui.Component.EventType.HIDE))) {
    var element = this.getElement();
    if (element) {
      this.renderer_.setVisible(element, visible);
    }
    if (this.isEnabled()) {
      this.renderer_.setFocusable(this, visible);
    }
    this.visible_ = visible;
    return true;
  }
  return false;
};
goog.ui.Control.prototype.isEnabled = function() {
  return !this.hasState(goog.ui.Component.State.DISABLED);
};
goog.ui.Control.prototype.isParentDisabled_ = function() {
  var parent = this.getParent();
  return !!parent && typeof parent.isEnabled == 'function' &&
      !parent.isEnabled();
};
goog.ui.Control.prototype.setEnabled = function(enable) {
  if (!this.isParentDisabled_() &&
      this.isTransitionAllowed(goog.ui.Component.State.DISABLED, !enable)) {
    if (!enable) {
      this.setActive(false);
      this.setHighlighted(false);
    }
    if (this.isVisible()) {
      this.renderer_.setFocusable(this, enable);
    }
    this.setState(goog.ui.Component.State.DISABLED, !enable, true);
  }
};
goog.ui.Control.prototype.isHighlighted = function() {
  return this.hasState(goog.ui.Component.State.HOVER);
};
goog.ui.Control.prototype.setHighlighted = function(highlight) {
  if (this.isTransitionAllowed(goog.ui.Component.State.HOVER, highlight)) {
    this.setState(goog.ui.Component.State.HOVER, highlight);
  }
};
goog.ui.Control.prototype.isActive = function() {
  return this.hasState(goog.ui.Component.State.ACTIVE);
};
goog.ui.Control.prototype.setActive = function(active) {
  if (this.isTransitionAllowed(goog.ui.Component.State.ACTIVE, active)) {
    this.setState(goog.ui.Component.State.ACTIVE, active);
  }
};
goog.ui.Control.prototype.isSelected = function() {
  return this.hasState(goog.ui.Component.State.SELECTED);
};
goog.ui.Control.prototype.setSelected = function(select) {
  if (this.isTransitionAllowed(goog.ui.Component.State.SELECTED, select)) {
    this.setState(goog.ui.Component.State.SELECTED, select);
  }
};
goog.ui.Control.prototype.isChecked = function() {
  return this.hasState(goog.ui.Component.State.CHECKED);
};
goog.ui.Control.prototype.setChecked = function(check) {
  if (this.isTransitionAllowed(goog.ui.Component.State.CHECKED, check)) {
    this.setState(goog.ui.Component.State.CHECKED, check);
  }
};
goog.ui.Control.prototype.isFocused = function() {
  return this.hasState(goog.ui.Component.State.FOCUSED);
};
goog.ui.Control.prototype.setFocused = function(focused) {
  if (this.isTransitionAllowed(goog.ui.Component.State.FOCUSED, focused)) {
    this.setState(goog.ui.Component.State.FOCUSED, focused);
  }
};
goog.ui.Control.prototype.isOpen = function() {
  return this.hasState(goog.ui.Component.State.OPENED);
};
goog.ui.Control.prototype.setOpen = function(open) {
  if (this.isTransitionAllowed(goog.ui.Component.State.OPENED, open)) {
    this.setState(goog.ui.Component.State.OPENED, open);
  }
};
goog.ui.Control.prototype.getState = function() {
  return this.state_;
};
goog.ui.Control.prototype.hasState = function(state) {
  return !!(this.state_ & state);
};
goog.ui.Control.prototype.setState = function(state, enable, opt_calledFrom) {
  if (!opt_calledFrom && state == goog.ui.Component.State.DISABLED) {
    this.setEnabled(!enable);
    return;
  }
  if (this.isSupportedState(state) && enable != this.hasState(state)) {
    this.renderer_.setState(this, state, enable);
    this.state_ = enable ? this.state_ | state : this.state_ & ~state;
  }
};
goog.ui.Control.prototype.setStateInternal = function(state) {
  this.state_ = state;
};
goog.ui.Control.prototype.isSupportedState = function(state) {
  return !!(this.supportedStates_ & state);
};
goog.ui.Control.prototype.setSupportedState = function(state, support) {
  if (this.isInDocument() && this.hasState(state) && !support) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  if (!support && this.hasState(state)) {
    this.setState(state, false);
  }
  this.supportedStates_ = support ?
      this.supportedStates_ | state : this.supportedStates_ & ~state;
};
goog.ui.Control.prototype.isAutoState = function(state) {
  return !!(this.autoStates_ & state) && this.isSupportedState(state);
};
goog.ui.Control.prototype.setAutoStates = function(states, enable) {
  this.autoStates_ = enable ?
      this.autoStates_ | states : this.autoStates_ & ~states;
};
goog.ui.Control.prototype.isDispatchTransitionEvents = function(state) {
  return !!(this.statesWithTransitionEvents_ & state) &&
      this.isSupportedState(state);
};
goog.ui.Control.prototype.setDispatchTransitionEvents = function(states,
    enable) {
  this.statesWithTransitionEvents_ = enable ?
      this.statesWithTransitionEvents_ | states :
      this.statesWithTransitionEvents_ & ~states;
};
goog.ui.Control.prototype.isTransitionAllowed = function(state, enable) {
  return this.isSupportedState(state) &&
      this.hasState(state) != enable &&
      (!(this.statesWithTransitionEvents_ & state) || this.dispatchEvent(
          goog.ui.Component.getStateTransitionEvent(state, enable))) &&
      !this.isDisposed();
};
goog.ui.Control.prototype.handleMouseOver = function(e) {
  if (!goog.ui.Control.isMouseEventWithinElement_(e, this.getElement()) &&
      this.dispatchEvent(goog.ui.Component.EventType.ENTER) &&
      this.isEnabled() &&
      this.isAutoState(goog.ui.Component.State.HOVER)) {
    this.setHighlighted(true);
  }
};
goog.ui.Control.prototype.handleMouseOut = function(e) {
  if (!goog.ui.Control.isMouseEventWithinElement_(e, this.getElement()) &&
      this.dispatchEvent(goog.ui.Component.EventType.LEAVE)) {
    if (this.isAutoState(goog.ui.Component.State.ACTIVE)) {
      this.setActive(false);
    }
    if (this.isAutoState(goog.ui.Component.State.HOVER)) {
      this.setHighlighted(false);
    }
  }
};
goog.ui.Control.prototype.handleContextMenu = goog.nullFunction;
goog.ui.Control.isMouseEventWithinElement_ = function(e, elem) {
  return !!e.relatedTarget && goog.dom.contains(elem, e.relatedTarget);
};
goog.ui.Control.prototype.handleMouseDown = function(e) {
  if (this.isEnabled()) {
    if (this.isAutoState(goog.ui.Component.State.HOVER)) {
      this.setHighlighted(true);
    }
    if (e.isMouseActionButton()) {
      if (this.isAutoState(goog.ui.Component.State.ACTIVE)) {
        this.setActive(true);
      }
      if (this.renderer_ && this.renderer_.isFocusable(this)) {
        this.getKeyEventTarget().focus();
      }
    }
  }
  if (!this.isAllowTextSelection() && e.isMouseActionButton()) {
    e.preventDefault();
  }
};
goog.ui.Control.prototype.handleMouseUp = function(e) {
  if (this.isEnabled()) {
    if (this.isAutoState(goog.ui.Component.State.HOVER)) {
      this.setHighlighted(true);
    }
    if (this.isActive() &&
        this.performActionInternal(e) &&
        this.isAutoState(goog.ui.Component.State.ACTIVE)) {
      this.setActive(false);
    }
  }
};
goog.ui.Control.prototype.handleDblClick = function(e) {
  if (this.isEnabled()) {
    this.performActionInternal(e);
  }
};
goog.ui.Control.prototype.performActionInternal = function(e) {
  if (this.isAutoState(goog.ui.Component.State.CHECKED)) {
    this.setChecked(!this.isChecked());
  }
  if (this.isAutoState(goog.ui.Component.State.SELECTED)) {
    this.setSelected(true);
  }
  if (this.isAutoState(goog.ui.Component.State.OPENED)) {
    this.setOpen(!this.isOpen());
  }
  var actionEvent = new goog.events.Event(goog.ui.Component.EventType.ACTION,
      this);
  if (e) {
    actionEvent.altKey = e.altKey;
    actionEvent.ctrlKey = e.ctrlKey;
    actionEvent.metaKey = e.metaKey;
    actionEvent.shiftKey = e.shiftKey;
    actionEvent.platformModifierKey = e.platformModifierKey;
  }
  return this.dispatchEvent(actionEvent);
};
goog.ui.Control.prototype.handleFocus = function(e) {
  if (this.isAutoState(goog.ui.Component.State.FOCUSED)) {
    this.setFocused(true);
  }
};
goog.ui.Control.prototype.handleBlur = function(e) {
  if (this.isAutoState(goog.ui.Component.State.ACTIVE)) {
    this.setActive(false);
  }
  if (this.isAutoState(goog.ui.Component.State.FOCUSED)) {
    this.setFocused(false);
  }
};
goog.ui.Control.prototype.handleKeyEvent = function(e) {
  if (this.isVisible() && this.isEnabled() &&
      this.handleKeyEventInternal(e)) {
    e.preventDefault();
    e.stopPropagation();
    return true;
  }
  return false;
};
goog.ui.Control.prototype.handleKeyEventInternal = function(e) {
  return e.keyCode == goog.events.KeyCodes.ENTER &&
      this.performActionInternal(e);
};
goog.ui.registry.setDefaultRenderer(goog.ui.Control, goog.ui.ControlRenderer);
goog.ui.registry.setDecoratorByClassName(goog.ui.ControlRenderer.CSS_CLASS,
    function() {
      return new goog.ui.Control(null);
    });
goog.ui.Control.IeMouseEventSequenceSimulator_ = function(control) {
  goog.ui.Control.IeMouseEventSequenceSimulator_.base(this, 'constructor');
  this.control_ = control;
  this.clickExpected_ = false;
  this.handler_ = new goog.events.EventHandler(this);
  this.registerDisposable(this.handler_);
  var element = this.control_.getElementStrict();
  this.handler_.
      listen(element, goog.events.EventType.MOUSEDOWN, this.handleMouseDown_).
      listen(element, goog.events.EventType.MOUSEUP, this.handleMouseUp_).
      listen(element, goog.events.EventType.CLICK, this.handleClick_);
};
goog.inherits(goog.ui.Control.IeMouseEventSequenceSimulator_, goog.Disposable);
goog.ui.Control.IeMouseEventSequenceSimulator_.prototype.handleMouseDown_ =
    function() {
  this.clickExpected_ = false;
};
goog.ui.Control.IeMouseEventSequenceSimulator_.prototype.handleMouseUp_ =
    function() {
  this.clickExpected_ = true;
};
goog.ui.Control.IeMouseEventSequenceSimulator_.prototype.handleClick_ =
    function(e) {
  if (this.clickExpected_) {
    this.clickExpected_ = false;
    return;
  }
  var browserEvent =  (e);
  var event = browserEvent.getBrowserEvent();
  var origEventButton = event.button;
  var origEventType = event.type;
  event.button = goog.events.BrowserEvent.MouseButton.LEFT;
  event.type = goog.events.EventType.MOUSEDOWN;
  this.control_.handleMouseDown(
      new goog.events.BrowserEvent(event, browserEvent.currentTarget));
  event.type = goog.events.EventType.MOUSEUP;
  this.control_.handleMouseUp(
      new goog.events.BrowserEvent(event, browserEvent.currentTarget));
  event.button = origEventButton;
  event.type = origEventType;
};
goog.ui.Control.IeMouseEventSequenceSimulator_.prototype.disposeInternal =
    function() {
  this.control_ = null;
  goog.ui.Control.IeMouseEventSequenceSimulator_.base(this, 'disposeInternal');
};

// goog.ui.Container
// goog.ui.Container.EventType
// goog.ui.Container.Orientation
goog.provide('goog.ui.Container');
goog.provide('goog.ui.Container.EventType');
goog.provide('goog.ui.Container.Orientation');
goog.ui.Container = function(opt_orientation, opt_renderer, opt_domHelper) {
  goog.ui.Component.call(this, opt_domHelper);
  this.renderer_ = opt_renderer || goog.ui.ContainerRenderer.getInstance();
  this.orientation_ = opt_orientation || this.renderer_.getDefaultOrientation();
};
goog.inherits(goog.ui.Container, goog.ui.Component);
goog.tagUnsealableClass(goog.ui.Container);
goog.ui.Container.EventType = {
  AFTER_SHOW: 'aftershow',
  AFTER_HIDE: 'afterhide'
};
goog.ui.Container.Orientation = {
  HORIZONTAL: 'horizontal',
  VERTICAL: 'vertical'
};
goog.ui.Container.prototype.keyEventTarget_ = null;
goog.ui.Container.prototype.keyHandler_ = null;
goog.ui.Container.prototype.renderer_ = null;
goog.ui.Container.prototype.orientation_ = null;
goog.ui.Container.prototype.visible_ = true;
goog.ui.Container.prototype.enabled_ = true;
goog.ui.Container.prototype.focusable_ = true;
goog.ui.Container.prototype.highlightedIndex_ = -1;
goog.ui.Container.prototype.openItem_ = null;
goog.ui.Container.prototype.mouseButtonPressed_ = false;
goog.ui.Container.prototype.allowFocusableChildren_ = false;
goog.ui.Container.prototype.openFollowsHighlight_ = true;
goog.ui.Container.prototype.childElementIdMap_ = null;
goog.ui.Container.prototype.getKeyEventTarget = function() {
  return this.keyEventTarget_ || this.renderer_.getKeyEventTarget(this);
};
goog.ui.Container.prototype.setKeyEventTarget = function(element) {
  if (this.focusable_) {
    var oldTarget = this.getKeyEventTarget();
    var inDocument = this.isInDocument();
    this.keyEventTarget_ = element;
    var newTarget = this.getKeyEventTarget();
    if (inDocument) {
      this.keyEventTarget_ = oldTarget;
      this.enableFocusHandling_(false);
      this.keyEventTarget_ = element;
      this.getKeyHandler().attach(newTarget);
      this.enableFocusHandling_(true);
    }
  } else {
    throw Error('Can\'t set key event target for container ' +
        'that doesn\'t support keyboard focus!');
  }
};
goog.ui.Container.prototype.getKeyHandler = function() {
  return this.keyHandler_ ||
      (this.keyHandler_ = new goog.events.KeyHandler(this.getKeyEventTarget()));
};
goog.ui.Container.prototype.getRenderer = function() {
  return this.renderer_;
};
goog.ui.Container.prototype.setRenderer = function(renderer) {
  if (this.getElement()) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  this.renderer_ = renderer;
};
goog.ui.Container.prototype.createDom = function() {
  this.setElementInternal(this.renderer_.createDom(this));
};
goog.ui.Container.prototype.getContentElement = function() {
  return this.renderer_.getContentElement(this.getElement());
};
goog.ui.Container.prototype.canDecorate = function(element) {
  return this.renderer_.canDecorate(element);
};
goog.ui.Container.prototype.decorateInternal = function(element) {
  this.setElementInternal(this.renderer_.decorate(this, element));
  if (element.style.display == 'none') {
    this.visible_ = false;
  }
};
goog.ui.Container.prototype.enterDocument = function() {
  goog.ui.Container.superClass_.enterDocument.call(this);
  this.forEachChild(function(child) {
    if (child.isInDocument()) {
      this.registerChildId_(child);
    }
  }, this);
  var elem = this.getElement();
  this.renderer_.initializeDom(this);
  this.setVisible(this.visible_, true);
  this.getHandler().
      listen(this, goog.ui.Component.EventType.ENTER,
          this.handleEnterItem).
      listen(this, goog.ui.Component.EventType.HIGHLIGHT,
          this.handleHighlightItem).
      listen(this, goog.ui.Component.EventType.UNHIGHLIGHT,
          this.handleUnHighlightItem).
      listen(this, goog.ui.Component.EventType.OPEN, this.handleOpenItem).
      listen(this, goog.ui.Component.EventType.CLOSE, this.handleCloseItem).
      listen(elem, goog.events.EventType.MOUSEDOWN, this.handleMouseDown).
      listen(goog.dom.getOwnerDocument(elem), goog.events.EventType.MOUSEUP,
          this.handleDocumentMouseUp).
      listen(elem, [
        goog.events.EventType.MOUSEDOWN,
        goog.events.EventType.MOUSEUP,
        goog.events.EventType.MOUSEOVER,
        goog.events.EventType.MOUSEOUT,
        goog.events.EventType.CONTEXTMENU
      ], this.handleChildMouseEvents);
  if (this.isFocusable()) {
    this.enableFocusHandling_(true);
  }
};
goog.ui.Container.prototype.enableFocusHandling_ = function(enable) {
  var handler = this.getHandler();
  var keyTarget = this.getKeyEventTarget();
  if (enable) {
    handler.
        listen(keyTarget, goog.events.EventType.FOCUS, this.handleFocus).
        listen(keyTarget, goog.events.EventType.BLUR, this.handleBlur).
        listen(this.getKeyHandler(), goog.events.KeyHandler.EventType.KEY,
            this.handleKeyEvent);
  } else {
    handler.
        unlisten(keyTarget, goog.events.EventType.FOCUS, this.handleFocus).
        unlisten(keyTarget, goog.events.EventType.BLUR, this.handleBlur).
        unlisten(this.getKeyHandler(), goog.events.KeyHandler.EventType.KEY,
            this.handleKeyEvent);
  }
};
goog.ui.Container.prototype.exitDocument = function() {
  this.setHighlightedIndex(-1);
  if (this.openItem_) {
    this.openItem_.setOpen(false);
  }
  this.mouseButtonPressed_ = false;
  goog.ui.Container.superClass_.exitDocument.call(this);
};
goog.ui.Container.prototype.disposeInternal = function() {
  goog.ui.Container.superClass_.disposeInternal.call(this);
  if (this.keyHandler_) {
    this.keyHandler_.dispose();
    this.keyHandler_ = null;
  }
  this.keyEventTarget_ = null;
  this.childElementIdMap_ = null;
  this.openItem_ = null;
  this.renderer_ = null;
};
goog.ui.Container.prototype.handleEnterItem = function(e) {
  return true;
};
goog.ui.Container.prototype.handleHighlightItem = function(e) {
  var index = this.indexOfChild( (e.target));
  if (index > -1 && index != this.highlightedIndex_) {
    var item = this.getHighlighted();
    if (item) {
      item.setHighlighted(false);
    }
    this.highlightedIndex_ = index;
    item = this.getHighlighted();
    if (this.isMouseButtonPressed()) {
      item.setActive(true);
    }
    if (this.openFollowsHighlight_ &&
        this.openItem_ && item != this.openItem_) {
      if (item.isSupportedState(goog.ui.Component.State.OPENED)) {
        item.setOpen(true);
      } else {
        this.openItem_.setOpen(false);
      }
    }
  }
  var element = this.getElement();
  goog.asserts.assert(element,
      'The DOM element for the container cannot be null.');
  if (e.target.getElement() != null) {
    goog.a11y.aria.setState(element,
        goog.a11y.aria.State.ACTIVEDESCENDANT,
        e.target.getElement().id);
  }
};
goog.ui.Container.prototype.handleUnHighlightItem = function(e) {
  if (e.target == this.getHighlighted()) {
    this.highlightedIndex_ = -1;
  }
  var element = this.getElement();
  goog.asserts.assert(element,
      'The DOM element for the container cannot be null.');
  goog.a11y.aria.removeState(element, goog.a11y.aria.State.ACTIVEDESCENDANT);
};
goog.ui.Container.prototype.handleOpenItem = function(e) {
  var item =  (e.target);
  if (item && item != this.openItem_ && item.getParent() == this) {
    if (this.openItem_) {
      this.openItem_.setOpen(false);
    }
    this.openItem_ = item;
  }
};
goog.ui.Container.prototype.handleCloseItem = function(e) {
  if (e.target == this.openItem_) {
    this.openItem_ = null;
  }
  var element = this.getElement();
  var targetEl = e.target.getElement();
  if (element && e.target.isHighlighted() && targetEl) {
    goog.a11y.aria.setActiveDescendant(element, targetEl);
  }
};
goog.ui.Container.prototype.handleMouseDown = function(e) {
  if (this.enabled_) {
    this.setMouseButtonPressed(true);
  }
  var keyTarget = this.getKeyEventTarget();
  if (keyTarget && goog.dom.isFocusableTabIndex(keyTarget)) {
    keyTarget.focus();
  } else {
    e.preventDefault();
  }
};
goog.ui.Container.prototype.handleDocumentMouseUp = function(e) {
  this.setMouseButtonPressed(false);
};
goog.ui.Container.prototype.handleChildMouseEvents = function(e) {
  var control = this.getOwnerControl( (e.target));
  if (control) {
    switch (e.type) {
      case goog.events.EventType.MOUSEDOWN:
        control.handleMouseDown(e);
        break;
      case goog.events.EventType.MOUSEUP:
        control.handleMouseUp(e);
        break;
      case goog.events.EventType.MOUSEOVER:
        control.handleMouseOver(e);
        break;
      case goog.events.EventType.MOUSEOUT:
        control.handleMouseOut(e);
        break;
      case goog.events.EventType.CONTEXTMENU:
        control.handleContextMenu(e);
        break;
    }
  }
};
goog.ui.Container.prototype.getOwnerControl = function(node) {
  if (this.childElementIdMap_) {
    var elem = this.getElement();
    while (node && node !== elem) {
      var id = node.id;
      if (id in this.childElementIdMap_) {
        return this.childElementIdMap_[id];
      }
      node = node.parentNode;
    }
  }
  return null;
};
goog.ui.Container.prototype.handleFocus = function(e) {
};
goog.ui.Container.prototype.handleBlur = function(e) {
  this.setHighlightedIndex(-1);
  this.setMouseButtonPressed(false);
  if (this.openItem_) {
    this.openItem_.setOpen(false);
  }
};
goog.ui.Container.prototype.handleKeyEvent = function(e) {
  if (this.isEnabled() && this.isVisible() &&
      (this.getChildCount() != 0 || this.keyEventTarget_) &&
      this.handleKeyEventInternal(e)) {
    e.preventDefault();
    e.stopPropagation();
    return true;
  }
  return false;
};
goog.ui.Container.prototype.handleKeyEventInternal = function(e) {
  var highlighted = this.getHighlighted();
  if (highlighted && typeof highlighted.handleKeyEvent == 'function' &&
      highlighted.handleKeyEvent(e)) {
    return true;
  }
  if (this.openItem_ && this.openItem_ != highlighted &&
      typeof this.openItem_.handleKeyEvent == 'function' &&
      this.openItem_.handleKeyEvent(e)) {
    return true;
  }
  if (e.shiftKey || e.ctrlKey || e.metaKey || e.altKey) {
    return false;
  }
  switch (e.keyCode) {
    case goog.events.KeyCodes.ESC:
      if (this.isFocusable()) {
        this.getKeyEventTarget().blur();
      } else {
        return false;
      }
      break;
    case goog.events.KeyCodes.HOME:
      this.highlightFirst();
      break;
    case goog.events.KeyCodes.END:
      this.highlightLast();
      break;
    case goog.events.KeyCodes.UP:
      if (this.orientation_ == goog.ui.Container.Orientation.VERTICAL) {
        this.highlightPrevious();
      } else {
        return false;
      }
      break;
    case goog.events.KeyCodes.LEFT:
      if (this.orientation_ == goog.ui.Container.Orientation.HORIZONTAL) {
        if (this.isRightToLeft()) {
          this.highlightNext();
        } else {
          this.highlightPrevious();
        }
      } else {
        return false;
      }
      break;
    case goog.events.KeyCodes.DOWN:
      if (this.orientation_ == goog.ui.Container.Orientation.VERTICAL) {
        this.highlightNext();
      } else {
        return false;
      }
      break;
    case goog.events.KeyCodes.RIGHT:
      if (this.orientation_ == goog.ui.Container.Orientation.HORIZONTAL) {
        if (this.isRightToLeft()) {
          this.highlightPrevious();
        } else {
          this.highlightNext();
        }
      } else {
        return false;
      }
      break;
    default:
      return false;
  }
  return true;
};
goog.ui.Container.prototype.registerChildId_ = function(child) {
  var childElem = child.getElement();
  var id = childElem.id || (childElem.id = child.getId());
  if (!this.childElementIdMap_) {
    this.childElementIdMap_ = {};
  }
  this.childElementIdMap_[id] = child;
};
goog.ui.Container.prototype.addChild = function(child, opt_render) {
  goog.asserts.assertInstanceof(child, goog.ui.Control,
      'The child of a container must be a control');
  goog.ui.Container.superClass_.addChild.call(this, child, opt_render);
};
goog.ui.Container.prototype.getChild;
goog.ui.Container.prototype.getChildAt;
goog.ui.Container.prototype.addChildAt = function(control, index, opt_render) {
  goog.asserts.assertInstanceof(control, goog.ui.Control);
  control.setDispatchTransitionEvents(goog.ui.Component.State.HOVER, true);
  control.setDispatchTransitionEvents(goog.ui.Component.State.OPENED, true);
  if (this.isFocusable() || !this.isFocusableChildrenAllowed()) {
    control.setSupportedState(goog.ui.Component.State.FOCUSED, false);
  }
  control.setHandleMouseEvents(false);
  var srcIndex = (control.getParent() == this) ?
      this.indexOfChild(control) : -1;
  goog.ui.Container.superClass_.addChildAt.call(this, control, index,
      opt_render);
  if (control.isInDocument() && this.isInDocument()) {
    this.registerChildId_(control);
  }
  this.updateHighlightedIndex_(srcIndex, index);
};
goog.ui.Container.prototype.updateHighlightedIndex_ = function(
    fromIndex, toIndex) {
  if (fromIndex == -1) {
    fromIndex = this.getChildCount();
  }
  if (fromIndex == this.highlightedIndex_) {
    this.highlightedIndex_ = Math.min(this.getChildCount() - 1, toIndex);
  } else if (fromIndex > this.highlightedIndex_ &&
      toIndex <= this.highlightedIndex_) {
    this.highlightedIndex_++;
  } else if (fromIndex < this.highlightedIndex_ &&
      toIndex > this.highlightedIndex_) {
    this.highlightedIndex_--;
  }
};
goog.ui.Container.prototype.removeChild = function(control, opt_unrender) {
  control = goog.isString(control) ? this.getChild(control) : control;
  goog.asserts.assertInstanceof(control, goog.ui.Control);
  if (control) {
    var index = this.indexOfChild(control);
    if (index != -1) {
      if (index == this.highlightedIndex_) {
        control.setHighlighted(false);
        this.highlightedIndex_ = -1;
      } else if (index < this.highlightedIndex_) {
        this.highlightedIndex_--;
      }
    }
    var childElem = control.getElement();
    if (childElem && childElem.id && this.childElementIdMap_) {
      goog.object.remove(this.childElementIdMap_, childElem.id);
    }
  }
  control =  (
      goog.ui.Container.superClass_.removeChild.call(this, control,
          opt_unrender));
  control.setHandleMouseEvents(true);
  return control;
};
goog.ui.Container.prototype.getOrientation = function() {
  return this.orientation_;
};
goog.ui.Container.prototype.setOrientation = function(orientation) {
  if (this.getElement()) {
    throw Error(goog.ui.Component.Error.ALREADY_RENDERED);
  }
  this.orientation_ = orientation;
};
goog.ui.Container.prototype.isVisible = function() {
  return this.visible_;
};
goog.ui.Container.prototype.setVisible = function(visible, opt_force) {
  if (opt_force || (this.visible_ != visible && this.dispatchEvent(visible ?
      goog.ui.Component.EventType.SHOW : goog.ui.Component.EventType.HIDE))) {
    this.visible_ = visible;
    var elem = this.getElement();
    if (elem) {
      goog.style.setElementShown(elem, visible);
      if (this.isFocusable()) {
        this.renderer_.enableTabIndex(this.getKeyEventTarget(),
            this.enabled_ && this.visible_);
      }
      if (!opt_force) {
        this.dispatchEvent(this.visible_ ?
            goog.ui.Container.EventType.AFTER_SHOW :
            goog.ui.Container.EventType.AFTER_HIDE);
      }
    }
    return true;
  }
  return false;
};
goog.ui.Container.prototype.isEnabled = function() {
  return this.enabled_;
};
goog.ui.Container.prototype.setEnabled = function(enable) {
  if (this.enabled_ != enable && this.dispatchEvent(enable ?
      goog.ui.Component.EventType.ENABLE :
      goog.ui.Component.EventType.DISABLE)) {
    if (enable) {
      this.enabled_ = true;
      this.forEachChild(function(child) {
        if (child.wasDisabled) {
          delete child.wasDisabled;
        } else {
          child.setEnabled(true);
        }
      });
    } else {
      this.forEachChild(function(child) {
        if (child.isEnabled()) {
          child.setEnabled(false);
        } else {
          child.wasDisabled = true;
        }
      });
      this.enabled_ = false;
      this.setMouseButtonPressed(false);
    }
    if (this.isFocusable()) {
      this.renderer_.enableTabIndex(this.getKeyEventTarget(),
          enable && this.visible_);
    }
  }
};
goog.ui.Container.prototype.isFocusable = function() {
  return this.focusable_;
};
goog.ui.Container.prototype.setFocusable = function(focusable) {
  if (focusable != this.focusable_ && this.isInDocument()) {
    this.enableFocusHandling_(focusable);
  }
  this.focusable_ = focusable;
  if (this.enabled_ && this.visible_) {
    this.renderer_.enableTabIndex(this.getKeyEventTarget(), focusable);
  }
};
goog.ui.Container.prototype.isFocusableChildrenAllowed = function() {
  return this.allowFocusableChildren_;
};
goog.ui.Container.prototype.setFocusableChildrenAllowed = function(focusable) {
  this.allowFocusableChildren_ = focusable;
};
goog.ui.Container.prototype.isOpenFollowsHighlight = function() {
  return this.openFollowsHighlight_;
};
goog.ui.Container.prototype.setOpenFollowsHighlight = function(follow) {
  this.openFollowsHighlight_ = follow;
};
goog.ui.Container.prototype.getHighlightedIndex = function() {
  return this.highlightedIndex_;
};
goog.ui.Container.prototype.setHighlightedIndex = function(index) {
  var child = this.getChildAt(index);
  if (child) {
    child.setHighlighted(true);
  } else if (this.highlightedIndex_ > -1) {
    this.getHighlighted().setHighlighted(false);
  }
};
goog.ui.Container.prototype.setHighlighted = function(item) {
  this.setHighlightedIndex(this.indexOfChild(item));
};
goog.ui.Container.prototype.getHighlighted = function() {
  return this.getChildAt(this.highlightedIndex_);
};
goog.ui.Container.prototype.highlightFirst = function() {
  this.highlightHelper(function(index, max) {
    return (index + 1) % max;
  }, this.getChildCount() - 1);
};
goog.ui.Container.prototype.highlightLast = function() {
  this.highlightHelper(function(index, max) {
    index--;
    return index < 0 ? max - 1 : index;
  }, 0);
};
goog.ui.Container.prototype.highlightNext = function() {
  this.highlightHelper(function(index, max) {
    return (index + 1) % max;
  }, this.highlightedIndex_);
};
goog.ui.Container.prototype.highlightPrevious = function() {
  this.highlightHelper(function(index, max) {
    index--;
    return index < 0 ? max - 1 : index;
  }, this.highlightedIndex_);
};
goog.ui.Container.prototype.highlightHelper = function(fn, startIndex) {
  var curIndex = startIndex < 0 ?
      this.indexOfChild(this.openItem_) : startIndex;
  var numItems = this.getChildCount();
  curIndex = fn.call(this, curIndex, numItems);
  var visited = 0;
  while (visited <= numItems) {
    var control = this.getChildAt(curIndex);
    if (control && this.canHighlightItem(control)) {
      this.setHighlightedIndexFromKeyEvent(curIndex);
      return true;
    }
    visited++;
    curIndex = fn.call(this, curIndex, numItems);
  }
  return false;
};
goog.ui.Container.prototype.canHighlightItem = function(item) {
  return item.isVisible() && item.isEnabled() &&
      item.isSupportedState(goog.ui.Component.State.HOVER);
};
goog.ui.Container.prototype.setHighlightedIndexFromKeyEvent = function(index) {
  this.setHighlightedIndex(index);
};
goog.ui.Container.prototype.getOpenItem = function() {
  return this.openItem_;
};
goog.ui.Container.prototype.isMouseButtonPressed = function() {
  return this.mouseButtonPressed_;
};
goog.ui.Container.prototype.setMouseButtonPressed = function(pressed) {
  this.mouseButtonPressed_ = pressed;
};

// goog.fx.DragEvent
// goog.fx.Dragger
// goog.fx.Dragger.EventType
goog.provide('goog.fx.DragEvent');
goog.provide('goog.fx.Dragger');
goog.provide('goog.fx.Dragger.EventType');
goog.fx.Dragger = function(target, opt_handle, opt_limits) {
  goog.fx.Dragger.base(this, 'constructor');
  this.target = target;
  this.handle = opt_handle || target;
  this.limits = opt_limits || new goog.math.Rect(NaN, NaN, NaN, NaN);
  this.document_ = goog.dom.getOwnerDocument(target);
  this.eventHandler_ = new goog.events.EventHandler(this);
  this.registerDisposable(this.eventHandler_);
  this.rightToLeft_;
  this.clientX = 0;
  this.clientY = 0;
  this.screenX = 0;
  this.screenY = 0;
  this.startX = 0;
  this.startY = 0;
  this.deltaX = 0;
  this.deltaY = 0;
  this.pageScroll;
  this.enabled_ = true;
  this.dragging_ = false;
  this.preventMouseDown_ = true;
  this.hysteresisDistanceSquared_ = 0;
  this.mouseDownTime_ = 0;
  this.scrollTarget_;
  this.ieDragStartCancellingOn_ = false;
  this.useRightPositioningForRtl_ = false;
  goog.events.listen(this.handle,
      [goog.events.EventType.TOUCHSTART, goog.events.EventType.MOUSEDOWN],
      this.startDrag, false, this);
};
goog.inherits(goog.fx.Dragger, goog.events.EventTarget);
goog.tagUnsealableClass(goog.fx.Dragger);
goog.fx.Dragger.HAS_SET_CAPTURE_ =
    goog.userAgent.IE ||
    goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher('1.9.3');
goog.fx.Dragger.cloneNode = function(sourceEl) {
  var clonedEl =  (sourceEl.cloneNode(true)),
      origTexts = sourceEl.getElementsByTagName(goog.dom.TagName.TEXTAREA),
      dragTexts = clonedEl.getElementsByTagName(goog.dom.TagName.TEXTAREA);
  for (var i = 0; i < origTexts.length; i++) {
    dragTexts[i].value = origTexts[i].value;
  }
  switch (sourceEl.tagName) {
    case goog.dom.TagName.TR:
      return goog.dom.createDom(goog.dom.TagName.TABLE, null,
                                goog.dom.createDom(goog.dom.TagName.TBODY,
                                                   null, clonedEl));
    case goog.dom.TagName.TD:
    case goog.dom.TagName.TH:
      return goog.dom.createDom(
          goog.dom.TagName.TABLE, null, goog.dom.createDom(
              goog.dom.TagName.TBODY, null, goog.dom.createDom(
                  goog.dom.TagName.TR, null, clonedEl)));
    case goog.dom.TagName.TEXTAREA:
      clonedEl.value = sourceEl.value;
    default:
      return clonedEl;
  }
};
goog.fx.Dragger.EventType = {
  EARLY_CANCEL: 'earlycancel',
  START: 'start',
  BEFOREDRAG: 'beforedrag',
  DRAG: 'drag',
  END: 'end'
};
goog.fx.Dragger.prototype.enableRightPositioningForRtl =
    function(useRightPositioningForRtl) {
  this.useRightPositioningForRtl_ = useRightPositioningForRtl;
};
goog.fx.Dragger.prototype.getHandler = function() {
  var self =  (this);
  return self.eventHandler_;
};
goog.fx.Dragger.prototype.setLimits = function(limits) {
  this.limits = limits || new goog.math.Rect(NaN, NaN, NaN, NaN);
};
goog.fx.Dragger.prototype.setHysteresis = function(distance) {
  this.hysteresisDistanceSquared_ = Math.pow(distance, 2);
};
goog.fx.Dragger.prototype.getHysteresis = function() {
  return Math.sqrt(this.hysteresisDistanceSquared_);
};
goog.fx.Dragger.prototype.setScrollTarget = function(scrollTarget) {
  this.scrollTarget_ = scrollTarget;
};
goog.fx.Dragger.prototype.setCancelIeDragStart = function(cancelIeDragStart) {
  this.ieDragStartCancellingOn_ = cancelIeDragStart;
};
goog.fx.Dragger.prototype.getEnabled = function() {
  return this.enabled_;
};
goog.fx.Dragger.prototype.setEnabled = function(enabled) {
  this.enabled_ = enabled;
};
goog.fx.Dragger.prototype.setPreventMouseDown = function(preventMouseDown) {
  this.preventMouseDown_ = preventMouseDown;
};
goog.fx.Dragger.prototype.disposeInternal = function() {
  goog.fx.Dragger.superClass_.disposeInternal.call(this);
  goog.events.unlisten(this.handle,
      [goog.events.EventType.TOUCHSTART, goog.events.EventType.MOUSEDOWN],
      this.startDrag, false, this);
  this.cleanUpAfterDragging_();
  this.target = null;
  this.handle = null;
};
goog.fx.Dragger.prototype.isRightToLeft_ = function() {
  if (!goog.isDef(this.rightToLeft_)) {
    this.rightToLeft_ = goog.style.isRightToLeft(this.target);
  }
  return this.rightToLeft_;
};
goog.fx.Dragger.prototype.startDrag = function(e) {
  var isMouseDown = e.type == goog.events.EventType.MOUSEDOWN;
  if (this.enabled_ && !this.dragging_ &&
      (!isMouseDown || e.isMouseActionButton())) {
    this.maybeReinitTouchEvent_(e);
    if (this.hysteresisDistanceSquared_ == 0) {
      if (this.fireDragStart_(e)) {
        this.dragging_ = true;
        if (this.preventMouseDown_) {
          e.preventDefault();
        }
      } else {
        return;
      }
    } else if (this.preventMouseDown_) {
      e.preventDefault();
    }
    this.setupDragHandlers();
    this.clientX = this.startX = e.clientX;
    this.clientY = this.startY = e.clientY;
    this.screenX = e.screenX;
    this.screenY = e.screenY;
    this.computeInitialPosition();
    this.pageScroll = goog.dom.getDomHelper(this.document_).getDocumentScroll();
    this.mouseDownTime_ = goog.now();
  } else {
    this.dispatchEvent(goog.fx.Dragger.EventType.EARLY_CANCEL);
  }
};
goog.fx.Dragger.prototype.setupDragHandlers = function() {
  var doc = this.document_;
  var docEl = doc.documentElement;
  var useCapture = !goog.fx.Dragger.HAS_SET_CAPTURE_;
  this.eventHandler_.listen(doc,
      [goog.events.EventType.TOUCHMOVE, goog.events.EventType.MOUSEMOVE],
      this.handleMove_, useCapture);
  this.eventHandler_.listen(doc,
      [goog.events.EventType.TOUCHEND, goog.events.EventType.MOUSEUP],
      this.endDrag, useCapture);
  if (goog.fx.Dragger.HAS_SET_CAPTURE_) {
    docEl.setCapture(false);
    this.eventHandler_.listen(docEl,
                              goog.events.EventType.LOSECAPTURE,
                              this.endDrag);
  } else {
    this.eventHandler_.listen(goog.dom.getWindow(doc),
                              goog.events.EventType.BLUR,
                              this.endDrag);
  }
  if (goog.userAgent.IE && this.ieDragStartCancellingOn_) {
    this.eventHandler_.listen(doc, goog.events.EventType.DRAGSTART,
                              goog.events.Event.preventDefault);
  }
  if (this.scrollTarget_) {
    this.eventHandler_.listen(this.scrollTarget_, goog.events.EventType.SCROLL,
                              this.onScroll_, useCapture);
  }
};
goog.fx.Dragger.prototype.fireDragStart_ = function(e) {
  return this.dispatchEvent(new goog.fx.DragEvent(
      goog.fx.Dragger.EventType.START, this, e.clientX, e.clientY, e));
};
goog.fx.Dragger.prototype.cleanUpAfterDragging_ = function() {
  this.eventHandler_.removeAll();
  if (goog.fx.Dragger.HAS_SET_CAPTURE_) {
    this.document_.releaseCapture();
  }
};
goog.fx.Dragger.prototype.endDrag = function(e, opt_dragCanceled) {
  this.cleanUpAfterDragging_();
  if (this.dragging_) {
    this.maybeReinitTouchEvent_(e);
    this.dragging_ = false;
    var x = this.limitX(this.deltaX);
    var y = this.limitY(this.deltaY);
    var dragCanceled = opt_dragCanceled ||
        e.type == goog.events.EventType.TOUCHCANCEL;
    this.dispatchEvent(new goog.fx.DragEvent(
        goog.fx.Dragger.EventType.END, this, e.clientX, e.clientY, e, x, y,
        dragCanceled));
  } else {
    this.dispatchEvent(goog.fx.Dragger.EventType.EARLY_CANCEL);
  }
};
goog.fx.Dragger.prototype.endDragCancel = function(e) {
  this.endDrag(e, true);
};
goog.fx.Dragger.prototype.maybeReinitTouchEvent_ = function(e) {
  var type = e.type;
  if (type == goog.events.EventType.TOUCHSTART ||
      type == goog.events.EventType.TOUCHMOVE) {
    e.init(e.getBrowserEvent().targetTouches[0], e.currentTarget);
  } else if (type == goog.events.EventType.TOUCHEND ||
             type == goog.events.EventType.TOUCHCANCEL) {
    e.init(e.getBrowserEvent().changedTouches[0], e.currentTarget);
  }
};
goog.fx.Dragger.prototype.handleMove_ = function(e) {
  if (this.enabled_) {
    this.maybeReinitTouchEvent_(e);
    var sign = this.useRightPositioningForRtl_ &&
        this.isRightToLeft_() ? -1 : 1;
    var dx = sign * (e.clientX - this.clientX);
    var dy = e.clientY - this.clientY;
    this.clientX = e.clientX;
    this.clientY = e.clientY;
    this.screenX = e.screenX;
    this.screenY = e.screenY;
    if (!this.dragging_) {
      var diffX = this.startX - this.clientX;
      var diffY = this.startY - this.clientY;
      var distance = diffX * diffX + diffY * diffY;
      if (distance > this.hysteresisDistanceSquared_) {
        if (this.fireDragStart_(e)) {
          this.dragging_ = true;
        } else {
          if (!this.isDisposed()) {
            this.endDrag(e);
          }
          return;
        }
      }
    }
    var pos = this.calculatePosition_(dx, dy);
    var x = pos.x;
    var y = pos.y;
    if (this.dragging_) {
      var rv = this.dispatchEvent(new goog.fx.DragEvent(
          goog.fx.Dragger.EventType.BEFOREDRAG, this, e.clientX, e.clientY,
          e, x, y));
      if (rv) {
        this.doDrag(e, x, y, false);
        e.preventDefault();
      }
    }
  }
};
goog.fx.Dragger.prototype.calculatePosition_ = function(dx, dy) {
  var pageScroll = goog.dom.getDomHelper(this.document_).getDocumentScroll();
  dx += pageScroll.x - this.pageScroll.x;
  dy += pageScroll.y - this.pageScroll.y;
  this.pageScroll = pageScroll;
  this.deltaX += dx;
  this.deltaY += dy;
  var x = this.limitX(this.deltaX);
  var y = this.limitY(this.deltaY);
  return new goog.math.Coordinate(x, y);
};
goog.fx.Dragger.prototype.onScroll_ = function(e) {
  var pos = this.calculatePosition_(0, 0);
  e.clientX = this.clientX;
  e.clientY = this.clientY;
  this.doDrag(e, pos.x, pos.y, true);
};
goog.fx.Dragger.prototype.doDrag = function(e, x, y, dragFromScroll) {
  this.defaultAction(x, y);
  this.dispatchEvent(new goog.fx.DragEvent(
      goog.fx.Dragger.EventType.DRAG, this, e.clientX, e.clientY, e, x, y));
};
goog.fx.Dragger.prototype.limitX = function(x) {
  var rect = this.limits;
  var left = !isNaN(rect.left) ? rect.left : null;
  var width = !isNaN(rect.width) ? rect.width : 0;
  var maxX = left != null ? left + width : Infinity;
  var minX = left != null ? left : -Infinity;
  return Math.min(maxX, Math.max(minX, x));
};
goog.fx.Dragger.prototype.limitY = function(y) {
  var rect = this.limits;
  var top = !isNaN(rect.top) ? rect.top : null;
  var height = !isNaN(rect.height) ? rect.height : 0;
  var maxY = top != null ? top + height : Infinity;
  var minY = top != null ? top : -Infinity;
  return Math.min(maxY, Math.max(minY, y));
};
goog.fx.Dragger.prototype.computeInitialPosition = function() {
  this.deltaX = this.useRightPositioningForRtl_ ?
      goog.style.bidi.getOffsetStart(this.target) :
       (this.target).offsetLeft;
  this.deltaY =  (this.target).offsetTop;
};
goog.fx.Dragger.prototype.defaultAction = function(x, y) {
  if (this.useRightPositioningForRtl_ && this.isRightToLeft_()) {
    this.target.style.right = x + 'px';
  } else {
    this.target.style.left = x + 'px';
  }
  this.target.style.top = y + 'px';
};
goog.fx.Dragger.prototype.isDragging = function() {
  return this.dragging_;
};
goog.fx.DragEvent = function(type, dragobj, clientX, clientY, browserEvent,
                             opt_actX, opt_actY, opt_dragCanceled) {
  goog.events.Event.call(this, type);
  this.clientX = clientX;
  this.clientY = clientY;
  this.browserEvent = browserEvent;
  this.left = goog.isDef(opt_actX) ? opt_actX : dragobj.deltaX;
  this.top = goog.isDef(opt_actY) ? opt_actY : dragobj.deltaY;
  this.dragger = dragobj;
  this.dragCanceled = !!opt_dragCanceled;
};
goog.inherits(goog.fx.DragEvent, goog.events.Event);

// i18n.input.chrome.FloatingWindowDragger
goog.provide('i18n.input.chrome.FloatingWindowDragger');
goog.scope(function() {
i18n.input.chrome.FloatingWindowDragger = function(win, handle) {
  goog.base(this, handle);
  this.floatingWindow_ = win;
};
var FloatingWindowDragger = i18n.input.chrome.FloatingWindowDragger;
goog.inherits(FloatingWindowDragger, goog.fx.Dragger);
FloatingWindowDragger.prototype.defaultAction = function(x, y) {
  var outerBounds = this.floatingWindow_.outerBounds;
  if (outerBounds) {
    outerBounds.setPosition(outerBounds.left + x, outerBounds.top + y);
  } else {
    this.floatingWindow_.moveTo(this.floatingWindow_.screenX + x,
                                this.floatingWindow_.screenY + y);
  }
};
});  // goog.scope

// i18n.input.chrome.FloatingWindow
goog.provide('i18n.input.chrome.FloatingWindow');
goog.scope(function() {
var Env = i18n.input.chrome.Env;
var FloatingWindowDragger = i18n.input.chrome.FloatingWindowDragger;
i18n.input.chrome.FloatingWindow = function(parentWindow, opt_enableDragger,
    opt_cssFile) {
  goog.base(this, undefined, undefined,
      new goog.dom.DomHelper(parentWindow.contentWindow.document));
  this.parentWindow = parentWindow;
  this.env = Env.getInstance();
  this.enableDragger = goog.isDef(opt_enableDragger) ? opt_enableDragger : true;
  if (opt_cssFile) {
    this.installCss(opt_cssFile);
  }
};
var FloatingWindow = i18n.input.chrome.FloatingWindow;
goog.inherits(FloatingWindow, goog.ui.Container);
FloatingWindow.prototype.dragger_;
FloatingWindow.prototype.installCss = function(file) {
  var dh = this.getDomHelper();
  var doc = dh.getDocument();
  var head = dh.getElementsByTagNameAndClass('head')[0];
  var styleSheet = dh.createDom(goog.dom.TagName.LINK, {
    'rel': 'stylesheet',
    'href': file
  });
  dh.appendChild(head, styleSheet);
};
FloatingWindow.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.setFocusable(false);
  this.setFocusableChildrenAllowed(false);
  if (this.enableDragger) {
    this.dragger_ = new FloatingWindowDragger(
        this.parentWindow, this.getElement());
  }
};
FloatingWindow.prototype.setVisible = function(isVisible) {
  if (isVisible) {
    this.parentWindow.show();
  } else {
    this.parentWindow.hide();
  }
  return goog.base(this, 'setVisible', isVisible);
};
FloatingWindow.prototype.reposition = function(position) {
  var outerBounds = this.parentWindow.outerBounds;
  if (outerBounds.left != position.x || outerBounds.top != position.y) {
    outerBounds.setPosition(position.x, position.y);
  }
};
FloatingWindow.prototype.getPosition = function() {
  var outerBounds = this.parentWindow.outerBounds;
  return new goog.math.Coordinate(outerBounds.left, outerBounds.top);
};
FloatingWindow.prototype.resize = function(width, height) {
  this.parentWindow.outerBounds.setSize(width, height);
};
FloatingWindow.prototype.size = function() {
  return goog.style.getSize(this.getElement());
};
FloatingWindow.prototype.disposeInternal = function() {
  this.parentWindow.close();
  goog.dispose(this.dragger_);
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.WindowUtil
goog.provide('i18n.input.chrome.WindowUtil');
goog.scope(function() {
var WindowUtil = i18n.input.chrome.WindowUtil;
WindowUtil.EMPTY_WINDOW_URL_ = 'imewindows/window.html';
WindowUtil.createWindow = function(callback, opt_overridedOption,
    opt_urlParameter) {
  var options = goog.object.create(
      'ime', true,
      'focused', false,
      'frame', 'none',
      'alphaEnabled', true,
      'hidden', true);
  if (opt_overridedOption) {
    goog.object.forEach(opt_overridedOption, function(value, key) {
      options[key] = value;
    });
  }
  var url = opt_urlParameter ? WindowUtil.EMPTY_WINDOW_URL_ + opt_urlParameter :
      WindowUtil.EMPTY_WINDOW_URL_;
  if (chrome.app.window && chrome.app.window.create) {
    inputview.createWindow(url, options,
        WindowUtil.createWindowCb_.bind(WindowUtil, callback));
  }
};
WindowUtil.createWindowCb_ = function(callback, newWindow) {
  if (newWindow) {
    var contentWindow = newWindow.contentWindow;
    goog.events.listen(contentWindow, 'load', function() {
      callback(newWindow);
    });
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.ReadyState
goog.provide('i18n.input.chrome.inputview.ReadyState');
goog.scope(function() {
i18n.input.chrome.inputview.ReadyState = function() {
};
var ReadyState = i18n.input.chrome.inputview.ReadyState;
ReadyState.State = {
  IME_LIST_READY: 0x1,
  KEYBOARD_CONFIG_READY: 0x10,
  LAYOUT_READY: 0x100,
  LAYOUT_CONFIG_READY: 0x1000,
  M17N_LAYOUT_READY: 0x10000,
  DISPLAY_SIZE_READY: 0x100000
};
ReadyState.prototype.state_ = 0;
ReadyState.prototype.isReady = function(state) {
  return !!(this.state_ & state);
};
ReadyState.prototype.markStateReady = function(state) {
  this.state_ |= state;
};
});  // goog.scope

// i18n.input.chrome.inputview.StateType
goog.provide('i18n.input.chrome.inputview.StateType');
i18n.input.chrome.inputview.StateType = {
  DEFAULT: 0,
  SHIFT: 1,
  ALTGR: 2,
  CAPSLOCK: 4,
  CTRL: 8,
  ALT: 16
};

// i18n.input.chrome.inputview.events.ConfigLoadedEvent
// i18n.input.chrome.inputview.events.ContextUpdateEvent
// i18n.input.chrome.inputview.events.DragEvent
// i18n.input.chrome.inputview.events.EventType
// i18n.input.chrome.inputview.events.LayoutLoadedEvent
// i18n.input.chrome.inputview.events.MessageEvent
// i18n.input.chrome.inputview.events.PointerEvent
// i18n.input.chrome.inputview.events.SurroundingTextChangedEvent
// i18n.input.chrome.inputview.events.SwipeEvent
goog.provide('i18n.input.chrome.inputview.events.ConfigLoadedEvent');
goog.provide('i18n.input.chrome.inputview.events.ContextUpdateEvent');
goog.provide('i18n.input.chrome.inputview.events.DragEvent');
goog.provide('i18n.input.chrome.inputview.events.EventType');
goog.provide('i18n.input.chrome.inputview.events.LayoutLoadedEvent');
goog.provide('i18n.input.chrome.inputview.events.MessageEvent');
goog.provide('i18n.input.chrome.inputview.events.PointerEvent');
goog.provide('i18n.input.chrome.inputview.events.SurroundingTextChangedEvent');
goog.provide('i18n.input.chrome.inputview.events.SwipeEvent');
goog.scope(function() {
var events = i18n.input.chrome.inputview.events;
events.EventType = {
  CLICK: goog.events.getUniqueId('c'),
  CONFIG_LOADED: goog.events.getUniqueId('cl'),
  DOUBLE_CLICK: goog.events.getUniqueId('dc'),
  DOUBLE_CLICK_END: goog.events.getUniqueId('dce'),
  DRAG: goog.events.getUniqueId('dg'),
  LAYOUT_LOADED: goog.events.getUniqueId('ll'),
  LONG_PRESS: goog.events.getUniqueId('lp'),
  LONG_PRESS_END: goog.events.getUniqueId('lpe'),
  POINTER_DOWN: goog.events.getUniqueId('pd'),
  POINTER_UP: goog.events.getUniqueId('pu'),
  POINTER_OVER: goog.events.getUniqueId('pv'),
  POINTER_OUT: goog.events.getUniqueId('po'),
  REFRESH: goog.events.getUniqueId('rf'),
  SETTINGS_READY: goog.events.getUniqueId('sr'),
  SURROUNDING_TEXT_CHANGED: goog.events.getUniqueId('stc'),
  SWIPE: goog.events.getUniqueId('s'),
  CONTEXT_UPDATE: goog.events.getUniqueId('cu'),
  CONTEXT_FOCUS: goog.events.getUniqueId('cf'),
  CONTEXT_BLUR: goog.events.getUniqueId('cb'),
  VISIBILITY_CHANGE: goog.events.getUniqueId('vc'),
  MODEL_UPDATE: goog.events.getUniqueId('mu'),
  URL_CHANGED: goog.events.getUniqueId('uc'),
  UPDATE_SETTINGS: goog.events.getUniqueId('us'),
  VOICE_STATE_CHANGE: goog.events.getUniqueId('vsc'),
  HWT_NETWORK_ERROR: goog.events.getUniqueId('hne'),
  FRONT_TOGGLE_LANGUAGE_STATE: goog.events.getUniqueId('ftls')
};
events.LayoutLoadedEvent = function(data) {
  goog.base(this, events.EventType.LAYOUT_LOADED);
  this.data = data;
};
goog.inherits(events.LayoutLoadedEvent, goog.events.Event);
events.ConfigLoadedEvent = function(data) {
  goog.base(this, events.EventType.CONFIG_LOADED);
  this.data = data;
};
goog.inherits(events.ConfigLoadedEvent, goog.events.Event);
events.MessageEvent = function(type, msg) {
  goog.base(this, type);
  this.msg = msg;
};
goog.inherits(events.MessageEvent, goog.events.Event);
events.PointerEvent = function(view, type, target, x, y, identifier,
    opt_timestamp) {
  goog.base(this, type, target);
  this.view = view;
  this.x = x;
  this.y = y;
  this.identifier = identifier;
  this.timestamp = opt_timestamp || 0;
};
goog.inherits(events.PointerEvent, goog.events.Event);
events.SwipeEvent = function(view, direction, target, x, y, identifier) {
  goog.base(this, view, events.EventType.SWIPE,
      target, x, y, identifier);
  this.direction = direction;
};
goog.inherits(events.SwipeEvent, events.PointerEvent);
events.DragEvent = function(view, direction, target, x, y, deltaX, deltaY,
    identifier) {
  goog.base(this, view, events.EventType.DRAG,
      target, x, y, identifier);
  this.direction = direction;
  this.deltaX = deltaX;
  this.deltaY = deltaY;
};
goog.inherits(events.DragEvent, events.PointerEvent);
events.SurroundingTextChangedEvent = function(textBeforeCursor,
    anchor, focus, offset) {
  goog.base(this, events.EventType.SURROUNDING_TEXT_CHANGED);
  this.textBeforeCursor = textBeforeCursor;
  this.anchor = anchor;
  this.focus = focus;
  this.offset = offset;
};
goog.inherits(events.SurroundingTextChangedEvent, goog.events.Event);
events.ContextUpdateEvent = function(compositionText, committedText) {
  goog.base(this, events.EventType.CONTEXT_UPDATE);
  this.compositionText = compositionText;
  this.committedText = committedText;
};
goog.inherits(events.ContextUpdateEvent, goog.events.Event);
});  // goog.scope

// i18n.input.chrome.message.Source
goog.provide('i18n.input.chrome.message.Source');
i18n.input.chrome.message.Source = {
  BG_BG: 'bg->bg',
  BG_VK: 'bg->vk',
  BG_OP: 'bg->op',
  VK_BG: 'vk->bg',
  VK_OP: 'vk->op',
  VK_VK: 'vk->vk',
  OP_BG: 'op->bg',
  OP_VK: 'op->vk',
  OP_OP: 'op->op',
  UNKNOWN: 'unknown'
};

// i18n.input.chrome.message
// i18n.input.chrome.message.Type
goog.provide('i18n.input.chrome.message');
goog.provide('i18n.input.chrome.message.Type');
goog.scope(function() {
var Source = i18n.input.chrome.message.Source;
i18n.input.chrome.message.Type = {
  CANDIDATES_BACK: 'candidates_back',
  CONTEXT_BLUR: 'context_blur',
  CONTEXT_FOCUS: 'context_focus',
  FRONT_TOGGLE_LANGUAGE_STATE: 'front_toggle_language_state',
  GESTURES_BACK: 'gestures_back',
  HWT_NETWORK_ERROR: 'hwt_network_error',
  SURROUNDING_TEXT_CHANGED: 'surrounding_text_changed',
  UPDATE_SETTINGS: 'update_settings',
  VOICE_STATE_CHANGE: 'voice_state_change',
  COMMIT_TEXT: 'commit_text',
  COMPLETION: 'completion',
  CONFIRM_GESTURE_RESULT: 'confirm_gesture_result',
  CONNECT: 'connect',
  DATASOURCE_READY: 'datasource_ready',
  DISCONNECT: 'disconnect',
  DOUBLE_CLICK_ON_SPACE_KEY: 'double_click_on_space_key',
  EXEC_ALL: 'exec_all',
  HWT_REQUEST: 'hwt_request',
  KEY_CLICK: 'key_click',
  KEY_EVENT: 'key_event',
  OPTION_CHANGE: 'option_change',
  PREDICTION: 'prediction',
  SELECT_CANDIDATE: 'select_candidate',
  SEND_GESTURE_EVENT: 'send_gesture_event',
  SEND_KEY_EVENT: 'send_key_event',
  SEND_KEYBOARD_LAYOUT: 'send_keyboard_layout',
  SET_COMPOSITION: 'set_composition',
  SET_GESTURE_EDITING: 'set_gesture_editing',
  SET_LANGUAGE: 'set_language',
  SWITCH_KEYSET: 'switch_keyset',
  TOGGLE_LANGUAGE_STATE: 'toggle_language_state',
  VISIBILITY_CHANGE: 'visibility_change',
  SET_CONTROLLER: 'set_controller',
  UNSET_CONTROLLER: 'unset_controller',
  VOICE_VIEW_STATE_CHANGE: 'voice_view_state_change',
  HWT_PRIVACY_GOT_IT: 'hwt_privacy_got_it',
  VOICE_PRIVACY_GOT_IT: 'voice_privacy_got_it',
  USER_DICT_ADD_ENTRY: 'user_dict_add_entry',
  USER_DICT_CLEAR: 'user_dict_clear',
  USER_DICT_LIST: 'user_dict_list',
  USER_DICT_SET_THRESHOLD: 'user_dict_set_threshold',
  USER_DICT_START: 'user_dict_start',
  USER_DICT_STOP: 'user_dict_stop',
  USER_DICT_REMOVE_ENTRY: 'user_dict_remove_entry',
  USER_DICT_ENTRIES: 'user_dict_entries',
  HEARTBEAT: 'heart_beat'
};
var Type = i18n.input.chrome.message.Type;
i18n.input.chrome.message.isFromBackground = function(type) {
  var source = i18n.input.chrome.message.getMessageSource(type);
  return source == Source.BG_BG || source == Source.BG_OP ||
      source == Source.BG_VK;
};
i18n.input.chrome.message.getMessageSource = function(type) {
  switch (type) {
    case Type.CANDIDATES_BACK:
    case Type.CONTEXT_BLUR:
    case Type.CONTEXT_FOCUS:
    case Type.FRONT_TOGGLE_LANGUAGE_STATE:
    case Type.GESTURES_BACK:
    case Type.HWT_NETWORK_ERROR:
    case Type.SURROUNDING_TEXT_CHANGED:
    case Type.UPDATE_SETTINGS:
    case Type.VOICE_STATE_CHANGE:
      return Source.BG_VK;
    case Type.COMMIT_TEXT:
    case Type.COMPLETION:
    case Type.CONFIRM_GESTURE_RESULT:
    case Type.CONNECT:
    case Type.DATASOURCE_READY:
    case Type.DISCONNECT:
    case Type.DOUBLE_CLICK_ON_SPACE_KEY:
    case Type.EXEC_ALL:
    case Type.HWT_REQUEST:
    case Type.KEY_CLICK:
    case Type.KEY_EVENT:
    case Type.OPTION_CHANGE:
    case Type.PREDICTION:
    case Type.SELECT_CANDIDATE:
    case Type.SEND_GESTURE_EVENT:
    case Type.SEND_KEY_EVENT:
    case Type.SEND_KEYBOARD_LAYOUT:
    case Type.SET_COMPOSITION:
    case Type.SET_GESTURE_EDITING:
    case Type.SET_LANGUAGE:
    case Type.SWITCH_KEYSET:
    case Type.TOGGLE_LANGUAGE_STATE:
    case Type.VISIBILITY_CHANGE:
    case Type.SET_CONTROLLER:
    case Type.UNSET_CONTROLLER:
    case Type.VOICE_VIEW_STATE_CHANGE:
      return Source.VK_BG;
    case Type.HWT_PRIVACY_GOT_IT:
    case Type.VOICE_PRIVACY_GOT_IT:
      return Source.VK_VK;
    case Type.USER_DICT_ADD_ENTRY:
    case Type.USER_DICT_CLEAR:
    case Type.USER_DICT_LIST:
    case Type.USER_DICT_SET_THRESHOLD:
    case Type.USER_DICT_START:
    case Type.USER_DICT_STOP:
    case Type.USER_DICT_REMOVE_ENTRY:
      return Source.OP_BG;
    case Type.USER_DICT_ENTRIES:
      return Source.BG_OP;
    case Type.HEARTBEAT:
      return Source.BG_BG;
    default:
      return Source.UNKNOWN;
  }
};
});  // goog.scope

// i18n.input.chrome.message.ContextType
goog.provide('i18n.input.chrome.message.ContextType');
i18n.input.chrome.message.ContextType = {
  NONE: '',
  DEFAULT: 'text',
  EMAIL: 'email',
  PASSWORD: 'password',
  URL: 'url',
  NUMBER: 'number',
  PHONE: 'tel'
};

// i18n.input.chrome.message.Name
goog.provide('i18n.input.chrome.message.Name');
i18n.input.chrome.message.Name = {
  ALT_KEY: 'altKey',
  ANCHOR: 'anchor',
  AUXILIARY_TEXT: 'auxiliaryText',
  AUXILIARY_TEXT_VISIBLE: 'auxiliaryTextVisible',
  CANDIDATE: 'candidate',
  CANDIDATES: 'candidates',
  CANDIDATE_ID: 'candidateID',
  CODE: 'code',
  CONTEXT_ID: 'contextID',
  CONTEXT_TYPE: 'contextType',
  CURSOR_VISIBLE: 'cursorVisible',
  CTRL_KEY: 'ctrlKey',
  CURSOR: 'cursor',
  ENGINE_ID: 'engineID',
  FOCUS: 'focus',
  FORCE_AUTO_SPACE: 'force_auto_space',
  GESTURE_DATA: 'gestureData',
  GESTURE_RESULTS: 'gestureResults',
  HEIGHT: 'height',
  ID: 'id',
  IN_PROGRESS: 'inProgress',
  IS_AUTOCORRECT: 'isAutoCorrect',
  IS_EMOJI: 'isEmoji',
  IS_SWIPE: 'isSwipe',
  KEY: 'key',
  KEYBOARD_LAYOUT: 'keyboardLayout',
  KEYCODE: 'keyCode',
  KEYSET: 'keyset',
  KEY_DATA: 'keyData',
  LANGUAGE: 'language',
  LENGTH: 'length',
  MATCHED_LENGTHS: 'matchedLengths',
  MSG: 'msg',
  THRESHOLD: 'threshold',
  TYPE: 'type',
  OFFSET: 'offset',
  OPTION_PREFIX: 'optionPrefix',
  OPTION_TYPE: 'optionType',
  PAGE_SIZE: 'pageSize',
  POSSIBILITIES: 'possibilities',
  PROPERTIES: 'properties',
  REQUEST_ID: 'requestId',
  SCREEN: 'screen',
  SHIFT_KEY: 'shiftKey',
  SOURCE: 'source',
  SOURCES: 'sources',
  SPATIAL_DATA: 'spatialData',
  STROKES: 'strokes',
  TEXT: 'text',
  TEXT_BEFORE_CURSOR: 'text_before_cursor',
  VERTICAL: 'vertical',
  VISIBLE: 'visible',
  VISIBILITY: 'visibility',
  VOICE_STATE: 'voice_state',
  WIDTH: 'width',
  WORKSPACE_HEIGHT: 'workspace_height',
  SWITCHING: 'switching',
  VOICE_PRIVACY_INFO: 'voice_privacy_info',
  HWT_PRIVACY_INFO: 'hwt_privacy_info'
};

// i18n.input.chrome.inputview.Adapter
goog.provide('i18n.input.chrome.inputview.Adapter');
goog.scope(function() {
var CandidatesBackEvent = i18n.input.chrome.DataSource.CandidatesBackEvent;
var ContextType = i18n.input.chrome.message.ContextType;
var FeatureTracker = i18n.input.chrome.FeatureTracker;
var FeatureName = i18n.input.chrome.FeatureName;
var GesturesBackEvent = i18n.input.chrome.DataSource.GesturesBackEvent;
var Name = i18n.input.chrome.message.Name;
var State = i18n.input.chrome.inputview.ReadyState.State;
var Type = i18n.input.chrome.message.Type;
var events = i18n.input.chrome.inputview.events;
i18n.input.chrome.inputview.Adapter = function(readyState) {
  goog.base(this);
  this.isVisible = !document.webkitHidden;
  this.modifierState_ = {};
  this.features = new FeatureTracker();
  this.readyState_ = readyState;
  chrome.runtime.onMessage.addListener(this.onMessage_.bind(this));
  this.handler_ = new goog.events.EventHandler(this);
  this.handler_.
      listen(document, 'webkitvisibilitychange', this.onVisibilityChange_).
      listen(window, goog.events.EventType.RESIZE, this.onVisibilityChange_);
  this.onVisibilityChange_();
};
goog.inherits(i18n.input.chrome.inputview.Adapter,
    goog.events.EventTarget);
var Adapter = i18n.input.chrome.inputview.Adapter;
Adapter.GoogleSites = {
  DOCS: 'https://docs.google.com/document/d',
  MAIL: 'https://mail.google.com'
};
Adapter.ENABLE_FLOATING_THRESHOLD_INCHES_ = 15;
Adapter.prototype.isA11yMode = false;
Adapter.prototype.isHotrod = false;
Adapter.prototype.isVoiceInputEnabled = true;
Adapter.prototype.showGlobeKey = false;
Adapter.prototype.displayInInches = 0;
Adapter.prototype.contextType = ContextType.DEFAULT;
Adapter.prototype.screen = '';
Adapter.prototype.isChromeVoxOn = false;
Adapter.prototype.textBeforeCursor = '';
Adapter.prototype.isBgControllerSwitching_ = false;
Adapter.prototype.onUpdateSettings_ = function(message) {
  this.screen = message[Name.SCREEN];
  this.queryCurrentSite();
  this.contextType =  (message[Name.CONTEXT_TYPE]);
  this.isBgControllerSwitching_ = false;
  this.dispatchEvent(
      new events.MessageEvent(events.EventType.UPDATE_SETTINGS, message));
};
Adapter.prototype.setModifierState = function(stateType, enable) {
  this.modifierState_[stateType] = enable;
};
Adapter.prototype.clearModifierStates = function() {
  this.modifierState_ = {};
};
Adapter.prototype.sendKeyDownAndUpEvent = function(key, code, opt_keyCode,
    opt_spatialData, opt_modifiers) {
  this.sendKeyEvent_([
    this.generateKeyboardEvent_(
        goog.events.EventType.KEYDOWN,
        key,
        code,
        opt_keyCode,
        opt_spatialData,
        opt_modifiers),
    this.generateKeyboardEvent_(
        goog.events.EventType.KEYUP,
        key,
        code,
        opt_keyCode,
        opt_spatialData,
        opt_modifiers)
  ]);
};
Adapter.prototype.sendKeyDownEvent = function(key, code, opt_keyCode,
    opt_spatialData) {
  this.sendKeyEvent_([this.generateKeyboardEvent_(
      goog.events.EventType.KEYDOWN, key, code, opt_keyCode,
      opt_spatialData)]);
};
Adapter.prototype.setGestureEditingInProgress = function(inProgress,
    opt_isSwipe) {
  chrome.runtime.sendMessage(
      goog.object.create(
          Name.TYPE, Type.SET_GESTURE_EDITING,
          Name.IN_PROGRESS, inProgress,
          Name.IS_SWIPE, opt_isSwipe));
};
Adapter.prototype.sendGestureEvent = function(gestureData) {
  chrome.runtime.sendMessage(
      goog.object.create(Name.TYPE, Type.SEND_GESTURE_EVENT, Name.GESTURE_DATA,
          gestureData));
};
Adapter.prototype.sendKeyUpEvent = function(key, code, opt_keyCode,
    opt_spatialData) {
  this.sendKeyEvent_([this.generateKeyboardEvent_(
      goog.events.EventType.KEYUP, key, code, opt_keyCode, opt_spatialData)]);
};
Adapter.prototype.sendKeyEvent_ = function(keyData) {
  chrome.runtime.sendMessage(
      goog.object.create(Name.TYPE, Type.SEND_KEY_EVENT, Name.KEY_DATA,
          keyData));
};
Adapter.prototype.sendKeyboardLayout = function(keyboardLayout) {
  chrome.runtime.sendMessage(
      goog.object.create(Name.TYPE, Type.SEND_KEYBOARD_LAYOUT,
          Name.KEYBOARD_LAYOUT, keyboardLayout));
};
Adapter.prototype.generateKeyboardEvent_ = function(
    type, key, code, opt_keyCode, opt_spatialData, opt_modifiers) {
  var StateType = i18n.input.chrome.inputview.StateType;
  var ctrl = !!this.modifierState_[StateType.CTRL];
  var alt = !!this.modifierState_[StateType.ALT];
  var shift = !!this.modifierState_[StateType.SHIFT];
  if (opt_modifiers) {
    if (opt_modifiers.ctrl != undefined)
      ctrl = opt_modifiers.ctrl;
    if (opt_modifiers.shift != undefined)
      shift = opt_modifiers.shift;
  }
  if (ctrl || alt) {
    key = '';
  }
  var result = {
    'type': type,
    'key': key,
    'code': code,
    'keyCode': opt_keyCode || 0,
    'spatialData': opt_spatialData
  };
  result['altKey'] = alt;
  result['ctrlKey'] = ctrl;
  result['shiftKey'] = shift;
  result['capsLock'] = !!this.modifierState_[StateType.CAPSLOCK];
  return result;
};
Adapter.prototype.onSurroundingTextChanged_ = function(textBeforeCursor,
    anchor, focus, offset) {
  this.textBeforeCursor = textBeforeCursor;
  this.dispatchEvent(new i18n.input.chrome.inputview.events.
      SurroundingTextChangedEvent(textBeforeCursor, anchor, focus,
          offset));
};
Adapter.prototype.getContext = function() {
  var matches = this.textBeforeCursor.match(/([a-zA-Z'-Ḁ-ỹÀ-ȳ]+)\s+$/);
  var text = matches ? matches[1] : '';
  return text;
};
Adapter.prototype.sendHwtRequest = function(payload) {
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.HWT_REQUEST, Name.MSG, payload
      ));
};
Adapter.prototype.isPasswordBox = function() {
  return this.contextType == 'password';
};
Adapter.prototype.isFloatingVirtualKeyboardEnabled = function() {
  if (!inputview || !inputview.setMode) {
    return false;
  }
  if (!this.readyState_.isReady(State.DISPLAY_SIZE_READY))
    console.error('Display size is not ready yet.');
  if (this.displayInInches < Adapter.ENABLE_FLOATING_THRESHOLD_INCHES_) {
    return false;
  }
  return this.features.isEnabled(FeatureName.FLOATING_VIRTUAL_KEYBOARD);
};
Adapter.prototype.onContextBlur_ = function() {
  this.contextType = '';
  this.dispatchEvent(new goog.events.Event(i18n.input.chrome.inputview.events.
      EventType.CONTEXT_BLUR));
};
Adapter.prototype.queryCurrentSite = function() {
  var adapter = this;
  var criteria = {'active': true, 'lastFocusedWindow': true};
  if (chrome && chrome.tabs) {
    chrome.tabs.query(criteria, function(tabs) {
      tabs[0] && adapter.setCurrentSite_(tabs[0].url);
    });
  }
};
Adapter.prototype.setCurrentSite_ = function(url) {
  if (url != this.currentSite_) {
    this.currentSite_ = url;
    this.dispatchEvent(new goog.events.Event(
        i18n.input.chrome.inputview.events.EventType.URL_CHANGED));
  }
};
Adapter.prototype.isGoogleDocument = function() {
  return this.currentSite_ &&
      this.currentSite_.lastIndexOf(Adapter.GoogleSites.DOCS) === 0;
};
Adapter.prototype.isGoogleMail = function() {
  return this.currentSite_ &&
      this.currentSite_.lastIndexOf(Adapter.GoogleSites.MAIL) === 0;
};
Adapter.prototype.onContextFocus_ = function(message) {
  this.queryCurrentSite();
  this.contextType =  (message[Name.CONTEXT_TYPE]);
  this.dispatchEvent(new goog.events.Event(
      i18n.input.chrome.inputview.events.EventType.CONTEXT_FOCUS));
};
Adapter.prototype.initBackground_ = function() {
  chrome.runtime.getBackgroundPage((function() {
    this.isBgControllerSwitching_ = true;
    chrome.runtime.sendMessage(goog.object.create(
        Name.TYPE, Type.CONNECT,
        Name.VISIBILITY, this.isVisible));
  }).bind(this));
};
Adapter.prototype.initialize = function() {
  if (chrome.accessibilityFeatures &&
      chrome.accessibilityFeatures.spokenFeedback) {
    chrome.accessibilityFeatures.spokenFeedback.get({}, (function(details) {
      this.isChromeVoxOn = details['value'];
    }).bind(this));
    chrome.accessibilityFeatures.spokenFeedback.onChange.addListener((function(
        details) {
          if (!this.isChromeVoxOn && details['value']) {
            this.dispatchEvent(new goog.events.Event(
                i18n.input.chrome.inputview.events.EventType.REFRESH));
          }
          this.isChromeVoxOn = details['value'];
        }).bind(this));
  }
  this.initBackground_();
  if (window.inputview) {
    inputview.getKeyboardConfig((function(config) {
      this.isA11yMode = !!config['a11ymode'];
      this.isHotrod = !!config['hotrodmode'];
      this.features.initialize(config);
      this.isVoiceInputEnabled =
          this.features.isEnabled(FeatureName.VOICE_INPUT);
      this.readyState_.markStateReady(State.KEYBOARD_CONFIG_READY);
      this.maybeDispatchSettingsReadyEvent_();
    }).bind(this));
    inputview.getInputMethods((function(inputMethods) {
      this.showGlobeKey = inputMethods.length > 1 && !this.isHotrod;
      this.readyState_.markStateReady(State.IME_LIST_READY);
      this.maybeDispatchSettingsReadyEvent_();
    }).bind(this));
    inputview.getDisplayInInches((function(inches) {
      this.displayInInches = inches;
      this.readyState_.markStateReady(State.DISPLAY_SIZE_READY);
      this.maybeDispatchSettingsReadyEvent_();
    }).bind(this));
  } else {
    this.readyState_.markStateReady(State.IME_LIST_READY);
    this.readyState_.markStateReady(State.KEYBOARD_CONFIG_READY);
    this.readyState_.markStateReady(State.DISPLAY_SIZE_READY);
  }
  this.maybeDispatchSettingsReadyEvent_();
};
Adapter.prototype.maybeDispatchSettingsReadyEvent_ = function() {
  var states = [
    State.KEYBOARD_CONFIG_READY,
    State.IME_LIST_READY,
    State.DISPLAY_SIZE_READY];
  var ready = true;
  for (var i = 0; i < states.length; i++) {
    ready = ready && this.readyState_.isReady(states[i]);
  }
  if (ready) {
    window.setTimeout((function() {
      this.dispatchEvent(new goog.events.Event(
          i18n.input.chrome.inputview.events.EventType.SETTINGS_READY));
    }).bind(this), 0);
  }
};
Adapter.prototype.getCurrentInputMethod = function(callback) {
  if (window.inputview && inputview.getCurrentInputMethod) {
    inputview.getCurrentInputMethod(callback);
  } else {
    callback('DU');
  }
};
Adapter.prototype.getInputMethods = function(callback) {
  if (window.inputview && inputview.getInputMethods) {
    inputview.getInputMethods(callback);
  } else {
    callback([
      {'indicator': 'DU', 'id': 'DU', 'name': 'Dummy IME', 'command': 1}]);
  }
};
Adapter.prototype.switchToInputMethod = function(inputMethodId) {
  if (window.inputview && inputview.switchToInputMethod) {
    inputview.switchToInputMethod(inputMethodId);
  }
};
Adapter.prototype.onVisibilityChange_ = function() {
  this.isVisible = !document.webkitHidden;
  this.dispatchEvent(new goog.events.Event(i18n.input.chrome.inputview.
      events.EventType.VISIBILITY_CHANGE));
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.VISIBILITY_CHANGE,
      Name.VISIBILITY, !document.webkitHidden));
};
Adapter.prototype.sendCompletionRequest = function(query, opt_spatialData) {
  var spatialData = {};
  if (opt_spatialData) {
    spatialData[Name.SOURCES] = opt_spatialData.sources;
    spatialData[Name.POSSIBILITIES] = opt_spatialData.possibilities;
  }
  chrome.runtime.sendMessage(goog.object.create(Name.TYPE,
      Type.COMPLETION, Name.TEXT, query, Name.SPATIAL_DATA, spatialData));
};
Adapter.prototype.selectCandidate = function(candidate) {
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.SELECT_CANDIDATE, Name.CANDIDATE, candidate));
};
Adapter.prototype.commitText = function(text) {
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.COMMIT_TEXT, Name.TEXT, text));
};
Adapter.prototype.commitGestureResult = function(text, forceAutoSpace) {
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.CONFIRM_GESTURE_RESULT, Name.TEXT, text,
      Name.FORCE_AUTO_SPACE, forceAutoSpace));
};
Adapter.prototype.setLanguage = function(language) {
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.SET_LANGUAGE, Name.LANGUAGE, language));
};
Adapter.prototype.onCandidatesBack_ = function(message) {
  var source = message['source'] || '';
  var candidates = message['candidates'] || [];
  this.dispatchEvent(new CandidatesBackEvent(source, candidates));
};
Adapter.prototype.onGesturesBack_ = function(message) {
  var results = message[Name.GESTURE_RESULTS];
  this.dispatchEvent(new GesturesBackEvent(results));
};
Adapter.prototype.hideKeyboard = function() {
  chrome.input.ime.hideInputView();
};
Adapter.prototype.doubleClickOnSpaceKey = function() {
  chrome.runtime.sendMessage(
      goog.object.create(
          Name.TYPE,
          Type.DOUBLE_CLICK_ON_SPACE_KEY));
};
Adapter.prototype.toggleLanguageState = function(inputToolValue) {
  chrome.runtime.sendMessage(
      goog.object.create(
          Name.TYPE,
          Type.TOGGLE_LANGUAGE_STATE,
          Name.MSG,
          inputToolValue));
};
Adapter.prototype.onMessage_ = function(request, sender, sendResponse) {
  var type = request[Name.TYPE];
  var msg = request[Name.MSG];
  if (!i18n.input.chrome.message.isFromBackground(type)) {
    return;
  }
  switch (type) {
    case Type.CANDIDATES_BACK:
      this.onCandidatesBack_(msg);
      break;
    case Type.CONTEXT_FOCUS:
      this.onContextFocus_(msg);
      break;
    case Type.CONTEXT_BLUR:
      this.onContextBlur_();
      break;
    case Type.GESTURES_BACK:
      this.onGesturesBack_(msg);
      break;
    case Type.SURROUNDING_TEXT_CHANGED:
      this.onSurroundingTextChanged_(request[Name.TEXT_BEFORE_CURSOR],
          request[Name.ANCHOR],
          request[Name.FOCUS],
          request[Name.OFFSET]);
      break;
    case Type.UPDATE_SETTINGS:
      this.onUpdateSettings_(msg);
      break;
    case Type.VOICE_STATE_CHANGE:
      this.dispatchEvent(
          new events.MessageEvent(events.EventType.VOICE_STATE_CHANGE,
              msg));
      break;
    case Type.HWT_NETWORK_ERROR:
      this.dispatchEvent(
          new events.MessageEvent(events.EventType.HWT_NETWORK_ERROR,
              msg));
      break;
    case Type.FRONT_TOGGLE_LANGUAGE_STATE:
      this.dispatchEvent(
          new events.MessageEvent(events.EventType.FRONT_TOGGLE_LANGUAGE_STATE,
              msg));
      break;
  }
};
Adapter.prototype.sendVoiceViewStateChange = function(state) {
  chrome.runtime.sendMessage(goog.object.create(
      Name.TYPE, Type.VOICE_VIEW_STATE_CHANGE, Name.MSG, state));
};
Adapter.prototype.disposeInternal = function() {
  goog.dispose(this.handler_);
  goog.base(this, 'disposeInternal');
};
Adapter.prototype.isSwitching = function() {
  return this.isBgControllerSwitching_;
};
Adapter.prototype.setController = function(keyset, languageCode) {
  chrome.runtime.sendMessage(
      goog.object.create(
          Name.TYPE,
          Type.SET_CONTROLLER,
          Name.MSG,
          {'rawkeyset': keyset, 'languageCode': languageCode}));
};
Adapter.prototype.unsetController = function() {
  chrome.runtime.sendMessage(
      goog.object.create(
          Name.TYPE,
          Type.UNSET_CONTROLLER));
};
});  // goog.scope

// i18n.input.chrome.inputview.CandidatesInfo
goog.provide('i18n.input.chrome.inputview.CandidatesInfo');
i18n.input.chrome.inputview.CandidatesInfo = function(source, candidates) {
  this.source = source;
  this.candidates = candidates;
};
i18n.input.chrome.inputview.CandidatesInfo.getEmpty = function() {
  return new i18n.input.chrome.inputview.CandidatesInfo('', []);
};

// goog.Thenable
goog.provide('goog.Thenable');
goog.Thenable = function() {};
goog.Thenable.prototype.then = function(opt_onFulfilled, opt_onRejected,
    opt_context) {};
goog.Thenable.IMPLEMENTED_BY_PROP = '$goog_Thenable';
goog.Thenable.addImplementation = function(ctor) {
  goog.exportProperty(ctor.prototype, 'then', ctor.prototype.then);
  if (COMPILED) {
    ctor.prototype[goog.Thenable.IMPLEMENTED_BY_PROP] = true;
  } else {
    ctor.prototype.$goog_Thenable = true;
  }
};
goog.Thenable.isImplementedBy = function(object) {
  if (!object) {
    return false;
  }
  try {
    if (COMPILED) {
      return !!object[goog.Thenable.IMPLEMENTED_BY_PROP];
    }
    return !!object.$goog_Thenable;
  } catch (e) {
    return false;
  }
};

// goog.async.FreeList
goog.provide('goog.async.FreeList');
goog.async.FreeList = goog.defineClass(null, {
  constructor: function(create, reset, limit) {
    this.limit_ = limit;
    this.create_ = create;
    this.reset_ = reset;
    this.occupants_ = 0;
    this.head_ = null;
  },
  get: function() {
    var item;
    if (this.occupants_ > 0) {
      this.occupants_--;
      item = this.head_;
      this.head_ = item.next;
      item.next = null;
    } else {
      item = this.create_();
    }
    return item;
  },
  put: function(item) {
    this.reset_(item);
    if (this.occupants_ < this.limit_) {
      this.occupants_++;
      item.next = this.head_;
      this.head_ = item;
    }
  },
  occupants: function() {
    return this.occupants_;
  }
});

// goog.async.WorkItem
// goog.async.WorkQueue
goog.provide('goog.async.WorkItem');
goog.provide('goog.async.WorkQueue');
goog.async.WorkQueue = function() {
  this.workHead_ = null;
  this.workTail_ = null;
};
goog.define('goog.async.WorkQueue.DEFAULT_MAX_UNUSED', 100);
goog.async.WorkQueue.freelist_ = new goog.async.FreeList(
    function() {return new goog.async.WorkItem(); },
    function(item) {item.reset()},
    goog.async.WorkQueue.DEFAULT_MAX_UNUSED);
goog.async.WorkQueue.prototype.add = function(fn, scope) {
  var item = this.getUnusedItem_();
  item.set(fn, scope);
  if (this.workTail_) {
    this.workTail_.next = item;
    this.workTail_ = item;
  } else {
    goog.asserts.assert(!this.workHead_);
    this.workHead_ = item;
    this.workTail_ = item;
  }
};
goog.async.WorkQueue.prototype.remove = function() {
  var item = null;
  if (this.workHead_) {
    item = this.workHead_;
    this.workHead_ = this.workHead_.next;
    if (!this.workHead_) {
      this.workTail_ = null;
    }
    item.next = null;
  }
  return item;
};
goog.async.WorkQueue.prototype.returnUnused = function(item) {
  goog.async.WorkQueue.freelist_.put(item);
};
goog.async.WorkQueue.prototype.getUnusedItem_ = function() {
  return goog.async.WorkQueue.freelist_.get();
};
goog.async.WorkItem = function() {
  this.fn = null;
  this.scope = null;
  this.next = null;
};
goog.async.WorkItem.prototype.set = function(fn, scope) {
  this.fn = fn;
  this.scope = scope;
  this.next = null;
};
goog.async.WorkItem.prototype.reset = function() {
  this.fn = null;
  this.scope = null;
  this.next = null;
};

// goog.async.nextTick
// goog.async.throwException
goog.provide('goog.async.nextTick');
goog.provide('goog.async.throwException');
goog.async.throwException = function(exception) {
  goog.global.setTimeout(function() { throw exception; }, 0);
};
goog.async.nextTick = function(callback, opt_context, opt_useSetImmediate) {
  var cb = callback;
  if (opt_context) {
    cb = goog.bind(callback, opt_context);
  }
  cb = goog.async.nextTick.wrapCallback_(cb);
  if (goog.isFunction(goog.global.setImmediate) &&
      (opt_useSetImmediate ||
      !goog.global.Window || !goog.global.Window.prototype ||
      goog.global.Window.prototype.setImmediate != goog.global.setImmediate)) {
    goog.global.setImmediate(cb);
    return;
  }
  if (!goog.async.nextTick.setImmediate_) {
    goog.async.nextTick.setImmediate_ =
        goog.async.nextTick.getSetImmediateEmulator_();
  }
  goog.async.nextTick.setImmediate_(cb);
};
goog.async.nextTick.setImmediate_;
goog.async.nextTick.getSetImmediateEmulator_ = function() {
  var Channel = goog.global['MessageChannel'];
  if (typeof Channel === 'undefined' && typeof window !== 'undefined' &&
      window.postMessage && window.addEventListener &&
      !goog.labs.userAgent.engine.isPresto()) {
    Channel = function() {
      var iframe = document.createElement(goog.dom.TagName.IFRAME);
      iframe.style.display = 'none';
      iframe.src = '';
      document.documentElement.appendChild(iframe);
      var win = iframe.contentWindow;
      var doc = win.document;
      doc.open();
      doc.write('');
      doc.close();
      var message = 'callImmediate' + Math.random();
      var origin = win.location.protocol == 'file:' ?
          '*' : win.location.protocol + '//' + win.location.host;
      var onmessage = goog.bind(function(e) {
        if ((origin != '*' && e.origin != origin) || e.data != message) {
          return;
        }
        this['port1'].onmessage();
      }, this);
      win.addEventListener('message', onmessage, false);
      this['port1'] = {};
      this['port2'] = {
        postMessage: function() {
          win.postMessage(message, origin);
        }
      };
    };
  }
  if (typeof Channel !== 'undefined' &&
      (!goog.labs.userAgent.browser.isIE())) {
    var channel = new Channel();
    var head = {};
    var tail = head;
    channel['port1'].onmessage = function() {
      if (goog.isDef(head.next)) {
        head = head.next;
        var cb = head.cb;
        head.cb = null;
        cb();
      }
    };
    return function(cb) {
      tail.next = {
        cb: cb
      };
      tail = tail.next;
      channel['port2'].postMessage(0);
    };
  }
  if (typeof document !== 'undefined' && 'onreadystatechange' in
      document.createElement(goog.dom.TagName.SCRIPT)) {
    return function(cb) {
      var script = document.createElement(goog.dom.TagName.SCRIPT);
      script.onreadystatechange = function() {
        script.onreadystatechange = null;
        script.parentNode.removeChild(script);
        script = null;
        cb();
        cb = null;
      };
      document.documentElement.appendChild(script);
    };
  }
  return function(cb) {
    goog.global.setTimeout(cb, 0);
  };
};
goog.async.nextTick.wrapCallback_ = goog.functions.identity;
goog.debug.entryPointRegistry.register(
    function(transformer) {
      goog.async.nextTick.wrapCallback_ = transformer;
    });

// goog.testing.watchers
goog.provide('goog.testing.watchers');
goog.testing.watchers.resetWatchers_ = [];
goog.testing.watchers.signalClockReset = function() {
  var watchers = goog.testing.watchers.resetWatchers_;
  for (var i = 0; i < watchers.length; i++) {
    goog.testing.watchers.resetWatchers_[i]();
  }
};
goog.testing.watchers.watchClockReset = function(fn) {
  goog.testing.watchers.resetWatchers_.push(fn);
};

// goog.async.run
goog.provide('goog.async.run');
goog.async.run = function(callback, opt_context) {
  if (!goog.async.run.schedule_) {
    goog.async.run.initializeRunner_();
  }
  if (!goog.async.run.workQueueScheduled_) {
    goog.async.run.schedule_();
    goog.async.run.workQueueScheduled_ = true;
  }
  goog.async.run.workQueue_.add(callback, opt_context);
};
goog.async.run.initializeRunner_ = function() {
  if (goog.global.Promise && goog.global.Promise.resolve) {
    var promise = goog.global.Promise.resolve(undefined);
    goog.async.run.schedule_ = function() {
      promise.then(goog.async.run.processWorkQueue);
    };
  } else {
    goog.async.run.schedule_ = function() {
      goog.async.nextTick(goog.async.run.processWorkQueue);
    };
  }
};
goog.async.run.forceNextTick = function(opt_realSetTimeout) {
  goog.async.run.schedule_ = function() {
    goog.async.nextTick(goog.async.run.processWorkQueue);
    if (opt_realSetTimeout) {
      opt_realSetTimeout(goog.async.run.processWorkQueue);
    }
  };
};
goog.async.run.schedule_;
goog.async.run.workQueueScheduled_ = false;
goog.async.run.workQueue_ = new goog.async.WorkQueue();
if (goog.DEBUG) {
  goog.async.run.resetQueue_ = function() {
    goog.async.run.workQueueScheduled_ = false;
    goog.async.run.workQueue_ = new goog.async.WorkQueue();
  };
  goog.testing.watchers.watchClockReset(goog.async.run.resetQueue_);
}
goog.async.run.processWorkQueue = function() {
  var item = null;
  while (item = goog.async.run.workQueue_.remove()) {
    try {
      item.fn.call(item.scope);
    } catch (e) {
      goog.async.throwException(e);
    }
    goog.async.run.workQueue_.returnUnused(item);
  }
  goog.async.run.workQueueScheduled_ = false;
};

// goog.promise.Resolver
goog.provide('goog.promise.Resolver');
goog.promise.Resolver = function() {};
goog.promise.Resolver.prototype.promise;
goog.promise.Resolver.prototype.resolve;
goog.promise.Resolver.prototype.reject;

// goog.Promise
goog.provide('goog.Promise');
goog.Promise = function(resolver, opt_context) {
  this.state_ = goog.Promise.State_.PENDING;
  this.result_ = undefined;
  this.parent_ = null;
  this.callbackEntries_ = null;
  this.callbackEntriesTail_ = null;
  this.executing_ = false;
  if (goog.Promise.UNHANDLED_REJECTION_DELAY > 0) {
    this.unhandledRejectionId_ = 0;
  } else if (goog.Promise.UNHANDLED_REJECTION_DELAY == 0) {
    this.hadUnhandledRejection_ = false;
  }
  if (goog.Promise.LONG_STACK_TRACES) {
    this.stack_ = [];
    this.addStackTrace_(new Error('created'));
    this.currentStep_ = 0;
  }
  if (resolver != goog.nullFunction) {
    try {
      var self = this;
      resolver.call(
          opt_context,
          function(value) {
            self.resolve_(goog.Promise.State_.FULFILLED, value);
          },
          function(reason) {
            if (goog.DEBUG &&
                !(reason instanceof goog.Promise.CancellationError)) {
              try {
                if (reason instanceof Error) {
                  throw reason;
                } else {
                  throw new Error('Promise rejected.');
                }
              } catch (e) {
              }
            }
            self.resolve_(goog.Promise.State_.REJECTED, reason);
          });
    } catch (e) {
      this.resolve_(goog.Promise.State_.REJECTED, e);
    }
  }
};
goog.define('goog.Promise.LONG_STACK_TRACES', false);
goog.define('goog.Promise.UNHANDLED_REJECTION_DELAY', 0);
goog.Promise.State_ = {
  PENDING: 0,
  BLOCKED: 1,
  FULFILLED: 2,
  REJECTED: 3
};
goog.Promise.CallbackEntry_ = function() {
  this.child = null;
  this.onFulfilled = null;
  this.onRejected = null;
  this.context = null;
  this.next = null;
  this.always = false;
};
goog.Promise.CallbackEntry_.prototype.reset = function() {
  this.child = null;
  this.onFulfilled = null;
  this.onRejected = null;
  this.context = null;
  this.always = false;
};
goog.define('goog.Promise.DEFAULT_MAX_UNUSED', 100);
goog.Promise.freelist_ = new goog.async.FreeList(
    function() {
      return new goog.Promise.CallbackEntry_();
    },
    function(item) {
      item.reset();
    },
    goog.Promise.DEFAULT_MAX_UNUSED);
goog.Promise.getCallbackEntry_ = function(onFulfilled, onRejected, context) {
  var entry = goog.Promise.freelist_.get();
  entry.onFulfilled = onFulfilled;
  entry.onRejected = onRejected;
  entry.context = context;
  return entry;
};
goog.Promise.returnEntry_ = function(entry) {
  goog.Promise.freelist_.put(entry);
};
goog.Promise.resolve = function(opt_value) {
  if (opt_value instanceof goog.Promise) {
    return opt_value;
  }
  var promise = new goog.Promise(goog.nullFunction);
  promise.resolve_(goog.Promise.State_.FULFILLED, opt_value);
  return promise;
};
goog.Promise.reject = function(opt_reason) {
  return new goog.Promise(function(resolve, reject) {
    reject(opt_reason);
  });
};
goog.Promise.resolveThen_ = function(value, onFulfilled, onRejected) {
  var isThenable = goog.Promise.maybeThen_(
      value, onFulfilled, onRejected, null);
  if (!isThenable) {
    goog.async.run(goog.partial(onFulfilled, value));
  }
};
goog.Promise.race = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    if (!promises.length) {
      resolve(undefined);
    }
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];
      goog.Promise.resolveThen_(promise, resolve, reject);
    }
  });
};
goog.Promise.all = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    var toFulfill = promises.length;
    var values = [];
    if (!toFulfill) {
      resolve(values);
      return;
    }
    var onFulfill = function(index, value) {
      toFulfill--;
      values[index] = value;
      if (toFulfill == 0) {
        resolve(values);
      }
    };
    var onReject = function(reason) {
      reject(reason);
    };
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];
      goog.Promise.resolveThen_(
          promise, goog.partial(onFulfill, i), onReject);
    }
  });
};
goog.Promise.allSettled = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    var toSettle = promises.length;
    var results = [];
    if (!toSettle) {
      resolve(results);
      return;
    }
    var onSettled = function(index, fulfilled, result) {
      toSettle--;
      results[index] = fulfilled ?
          {fulfilled: true, value: result} :
          {fulfilled: false, reason: result};
      if (toSettle == 0) {
        resolve(results);
      }
    };
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];
      goog.Promise.resolveThen_(promise,
          goog.partial(onSettled, i, true ),
          goog.partial(onSettled, i, false ));
    }
  });
};
goog.Promise.firstFulfilled = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    var toReject = promises.length;
    var reasons = [];
    if (!toReject) {
      resolve(undefined);
      return;
    }
    var onFulfill = function(value) {
      resolve(value);
    };
    var onReject = function(index, reason) {
      toReject--;
      reasons[index] = reason;
      if (toReject == 0) {
        reject(reasons);
      }
    };
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];
      goog.Promise.resolveThen_(
          promise, onFulfill, goog.partial(onReject, i));
    }
  });
};
goog.Promise.withResolver = function() {
  var resolve, reject;
  var promise = new goog.Promise(function(rs, rj) {
    resolve = rs;
    reject = rj;
  });
  return new goog.Promise.Resolver_(promise, resolve, reject);
};
goog.Promise.prototype.then = function(
    opt_onFulfilled, opt_onRejected, opt_context) {
  if (opt_onFulfilled != null) {
    goog.asserts.assertFunction(opt_onFulfilled,
        'opt_onFulfilled should be a function.');
  }
  if (opt_onRejected != null) {
    goog.asserts.assertFunction(opt_onRejected,
        'opt_onRejected should be a function. Did you pass opt_context ' +
        'as the second argument instead of the third?');
  }
  if (goog.Promise.LONG_STACK_TRACES) {
    this.addStackTrace_(new Error('then'));
  }
  return this.addChildPromise_(
      goog.isFunction(opt_onFulfilled) ? opt_onFulfilled : null,
      goog.isFunction(opt_onRejected) ? opt_onRejected : null,
      opt_context);
};
goog.Thenable.addImplementation(goog.Promise);
goog.Promise.prototype.thenVoid = function(
    opt_onFulfilled, opt_onRejected, opt_context) {
  if (opt_onFulfilled != null) {
    goog.asserts.assertFunction(opt_onFulfilled,
        'opt_onFulfilled should be a function.');
  }
  if (opt_onRejected != null) {
    goog.asserts.assertFunction(opt_onRejected,
        'opt_onRejected should be a function. Did you pass opt_context ' +
        'as the second argument instead of the third?');
  }
  if (goog.Promise.LONG_STACK_TRACES) {
    this.addStackTrace_(new Error('then'));
  }
  this.addCallbackEntry_(goog.Promise.getCallbackEntry_(
      opt_onFulfilled || goog.nullFunction,
      opt_onRejected || null,
      opt_context));
};
goog.Promise.prototype.thenAlways = function(onSettled, opt_context) {
  if (goog.Promise.LONG_STACK_TRACES) {
    this.addStackTrace_(new Error('thenAlways'));
  }
  var entry = goog.Promise.getCallbackEntry_(onSettled, onSettled, opt_context);
  entry.always = true;
  this.addCallbackEntry_(entry);
  return this;
};
goog.Promise.prototype.thenCatch = function(onRejected, opt_context) {
  if (goog.Promise.LONG_STACK_TRACES) {
    this.addStackTrace_(new Error('thenCatch'));
  }
  return this.addChildPromise_(null, onRejected, opt_context);
};
goog.Promise.prototype.cancel = function(opt_message) {
  if (this.state_ == goog.Promise.State_.PENDING) {
    goog.async.run(function() {
      var err = new goog.Promise.CancellationError(opt_message);
      this.cancelInternal_(err);
    }, this);
  }
};
goog.Promise.prototype.cancelInternal_ = function(err) {
  if (this.state_ == goog.Promise.State_.PENDING) {
    if (this.parent_) {
      this.parent_.cancelChild_(this, err);
      this.parent_ = null;
    } else {
      this.resolve_(goog.Promise.State_.REJECTED, err);
    }
  }
};
goog.Promise.prototype.cancelChild_ = function(childPromise, err) {
  if (!this.callbackEntries_) {
    return;
  }
  var childCount = 0;
  var childEntry = null;
  var beforeChildEntry = null;
  for (var entry = this.callbackEntries_; entry; entry = entry.next) {
    if (!entry.always) {
      childCount++;
      if (entry.child == childPromise) {
        childEntry = entry;
      }
      if (childEntry && childCount > 1) {
        break;
      }
    }
    if (!childEntry) {
      beforeChildEntry = entry;
    }
  }
  if (childEntry) {
    if (this.state_ == goog.Promise.State_.PENDING && childCount == 1) {
      this.cancelInternal_(err);
    } else {
      if (beforeChildEntry) {
        this.removeEntryAfter_(beforeChildEntry);
      } else {
        this.popEntry_();
      }
      this.executeCallback_(
          childEntry, goog.Promise.State_.REJECTED, err);
    }
  }
};
goog.Promise.prototype.addCallbackEntry_ = function(callbackEntry) {
  if (!this.hasEntry_() &&
      (this.state_ == goog.Promise.State_.FULFILLED ||
       this.state_ == goog.Promise.State_.REJECTED)) {
    this.scheduleCallbacks_();
  }
  this.queueEntry_(callbackEntry);
};
goog.Promise.prototype.addChildPromise_ = function(
    onFulfilled, onRejected, opt_context) {
  var callbackEntry = goog.Promise.getCallbackEntry_(null, null, null);
  callbackEntry.child = new goog.Promise(function(resolve, reject) {
    callbackEntry.onFulfilled = onFulfilled ? function(value) {
      try {
        var result = onFulfilled.call(opt_context, value);
        resolve(result);
      } catch (err) {
        reject(err);
      }
    } : resolve;
    callbackEntry.onRejected = onRejected ? function(reason) {
      try {
        var result = onRejected.call(opt_context, reason);
        if (!goog.isDef(result) &&
            reason instanceof goog.Promise.CancellationError) {
          reject(reason);
        } else {
          resolve(result);
        }
      } catch (err) {
        reject(err);
      }
    } : reject;
  });
  callbackEntry.child.parent_ = this;
  this.addCallbackEntry_(callbackEntry);
  return callbackEntry.child;
};
goog.Promise.prototype.unblockAndFulfill_ = function(value) {
  goog.asserts.assert(this.state_ == goog.Promise.State_.BLOCKED);
  this.state_ = goog.Promise.State_.PENDING;
  this.resolve_(goog.Promise.State_.FULFILLED, value);
};
goog.Promise.prototype.unblockAndReject_ = function(reason) {
  goog.asserts.assert(this.state_ == goog.Promise.State_.BLOCKED);
  this.state_ = goog.Promise.State_.PENDING;
  this.resolve_(goog.Promise.State_.REJECTED, reason);
};
goog.Promise.prototype.resolve_ = function(state, x) {
  if (this.state_ != goog.Promise.State_.PENDING) {
    return;
  }
  if (this == x) {
    state = goog.Promise.State_.REJECTED;
    x = new TypeError('Promise cannot resolve to itself');
  }
  this.state_ = goog.Promise.State_.BLOCKED;
  var isThenable = goog.Promise.maybeThen_(
      x, this.unblockAndFulfill_, this.unblockAndReject_, this);
  if (isThenable) {
    return;
  }
  this.result_ = x;
  this.state_ = state;
  this.parent_ = null;
  this.scheduleCallbacks_();
  if (state == goog.Promise.State_.REJECTED &&
      !(x instanceof goog.Promise.CancellationError)) {
    goog.Promise.addUnhandledRejection_(this, x);
  }
};
goog.Promise.maybeThen_ = function(value, onFulfilled, onRejected, context) {
  if (value instanceof goog.Promise) {
    value.thenVoid(onFulfilled, onRejected, context);
    return true;
  } else if (goog.Thenable.isImplementedBy(value)) {
    value =  (value);
    value.then(onFulfilled, onRejected, context);
    return true;
  } else if (goog.isObject(value)) {
    try {
      var then = value['then'];
      if (goog.isFunction(then)) {
        goog.Promise.tryThen_(
            value, then, onFulfilled, onRejected, context);
        return true;
      }
    } catch (e) {
      onRejected.call(context, e);
      return true;
    }
  }
  return false;
};
goog.Promise.tryThen_ = function(
    thenable, then, onFulfilled, onRejected, context) {
  var called = false;
  var resolve = function(value) {
    if (!called) {
      called = true;
      onFulfilled.call(context, value);
    }
  };
  var reject = function(reason) {
    if (!called) {
      called = true;
      onRejected.call(context, reason);
    }
  };
  try {
    then.call(thenable, resolve, reject);
  } catch (e) {
    reject(e);
  }
};
goog.Promise.prototype.scheduleCallbacks_ = function() {
  if (!this.executing_) {
    this.executing_ = true;
    goog.async.run(this.executeCallbacks_, this);
  }
};
goog.Promise.prototype.hasEntry_ = function() {
  return !!this.callbackEntries_;
};
goog.Promise.prototype.queueEntry_ = function(entry) {
  goog.asserts.assert(entry.onFulfilled != null);
  if (this.callbackEntriesTail_) {
    this.callbackEntriesTail_.next = entry;
    this.callbackEntriesTail_ = entry;
  } else {
    this.callbackEntries_ = entry;
    this.callbackEntriesTail_ = entry;
  }
};
goog.Promise.prototype.popEntry_ = function() {
  var entry = null;
  if (this.callbackEntries_) {
    entry = this.callbackEntries_;
    this.callbackEntries_ = entry.next;
    entry.next = null;
  }
  if (!this.callbackEntries_) {
    this.callbackEntriesTail_ = null;
  }
  if (entry != null) {
    goog.asserts.assert(entry.onFulfilled != null);
  }
  return entry;
};
goog.Promise.prototype.removeEntryAfter_ = function(previous) {
  goog.asserts.assert(this.callbackEntries_);
  goog.asserts.assert(previous != null);
  if (previous.next == this.callbackEntriesTail_) {
    this.callbackEntriesTail_ = previous;
  }
  previous.next = previous.next.next;
};
goog.Promise.prototype.executeCallbacks_ = function() {
  var entry = null;
  while (entry = this.popEntry_()) {
    if (goog.Promise.LONG_STACK_TRACES) {
      this.currentStep_++;
    }
    this.executeCallback_(entry, this.state_, this.result_);
  }
  this.executing_ = false;
};
goog.Promise.prototype.executeCallback_ = function(
    callbackEntry, state, result) {
  if (state == goog.Promise.State_.REJECTED &&
      callbackEntry.onRejected && !callbackEntry.always) {
    this.removeUnhandledRejection_();
  }
  if (callbackEntry.child) {
    callbackEntry.child.parent_ = null;
    goog.Promise.invokeCallback_(callbackEntry, state, result);
  } else {
    try {
      callbackEntry.always ?
          callbackEntry.onFulfilled.call(callbackEntry.context) :
          goog.Promise.invokeCallback_(callbackEntry, state, result);
    } catch (err) {
      goog.Promise.handleRejection_.call(null, err);
    }
  }
  goog.Promise.returnEntry_(callbackEntry);
};
goog.Promise.invokeCallback_ = function(callbackEntry, state, result) {
  if (state == goog.Promise.State_.FULFILLED) {
    callbackEntry.onFulfilled.call(callbackEntry.context, result);
  } else if (callbackEntry.onRejected) {
    callbackEntry.onRejected.call(callbackEntry.context, result);
  }
};
goog.Promise.prototype.addStackTrace_ = function(err) {
  if (goog.Promise.LONG_STACK_TRACES && goog.isString(err.stack)) {
    var trace = err.stack.split('\n', 4)[3];
    var message = err.message;
    message += Array(11 - message.length).join(' ');
    this.stack_.push(message + trace);
  }
};
goog.Promise.prototype.appendLongStack_ = function(err) {
  if (goog.Promise.LONG_STACK_TRACES &&
      err && goog.isString(err.stack) && this.stack_.length) {
    var longTrace = ['Promise trace:'];
    for (var promise = this; promise; promise = promise.parent_) {
      for (var i = this.currentStep_; i >= 0; i--) {
        longTrace.push(promise.stack_[i]);
      }
      longTrace.push('Value: ' +
          '[' + (promise.state_ == goog.Promise.State_.REJECTED ?
              'REJECTED' : 'FULFILLED') + '] ' +
          '<' + String(promise.result_) + '>');
    }
    err.stack += '\n\n' + longTrace.join('\n');
  }
};
goog.Promise.prototype.removeUnhandledRejection_ = function() {
  if (goog.Promise.UNHANDLED_REJECTION_DELAY > 0) {
    for (var p = this; p && p.unhandledRejectionId_; p = p.parent_) {
      goog.global.clearTimeout(p.unhandledRejectionId_);
      p.unhandledRejectionId_ = 0;
    }
  } else if (goog.Promise.UNHANDLED_REJECTION_DELAY == 0) {
    for (var p = this; p && p.hadUnhandledRejection_; p = p.parent_) {
      p.hadUnhandledRejection_ = false;
    }
  }
};
goog.Promise.addUnhandledRejection_ = function(promise, reason) {
  if (goog.Promise.UNHANDLED_REJECTION_DELAY > 0) {
    promise.unhandledRejectionId_ = goog.global.setTimeout(function() {
      promise.appendLongStack_(reason);
      goog.Promise.handleRejection_.call(null, reason);
    }, goog.Promise.UNHANDLED_REJECTION_DELAY);
  } else if (goog.Promise.UNHANDLED_REJECTION_DELAY == 0) {
    promise.hadUnhandledRejection_ = true;
    goog.async.run(function() {
      if (promise.hadUnhandledRejection_) {
        promise.appendLongStack_(reason);
        goog.Promise.handleRejection_.call(null, reason);
      }
    });
  }
};
goog.Promise.handleRejection_ = goog.async.throwException;
goog.Promise.setUnhandledRejectionHandler = function(handler) {
  goog.Promise.handleRejection_ = handler;
};
goog.Promise.CancellationError = function(opt_message) {
  goog.Promise.CancellationError.base(this, 'constructor', opt_message);
};
goog.inherits(goog.Promise.CancellationError, goog.debug.Error);
goog.Promise.CancellationError.prototype.name = 'cancel';
goog.Promise.Resolver_ = function(promise, resolve, reject) {
  this.promise = promise;
  this.resolve = resolve;
  this.reject = reject;
};

// goog.Timer
goog.provide('goog.Timer');
goog.Timer = function(opt_interval, opt_timerObject) {
  goog.events.EventTarget.call(this);
  this.interval_ = opt_interval || 1;
  this.timerObject_ = opt_timerObject || goog.Timer.defaultTimerObject;
  this.boundTick_ = goog.bind(this.tick_, this);
  this.last_ = goog.now();
};
goog.inherits(goog.Timer, goog.events.EventTarget);
goog.Timer.MAX_TIMEOUT_ = 2147483647;
goog.Timer.INVALID_TIMEOUT_ID_ = -1;
goog.Timer.prototype.enabled = false;
goog.Timer.defaultTimerObject = goog.global;
goog.Timer.intervalScale = 0.8;
goog.Timer.prototype.timer_ = null;
goog.Timer.prototype.getInterval = function() {
  return this.interval_;
};
goog.Timer.prototype.setInterval = function(interval) {
  this.interval_ = interval;
  if (this.timer_ && this.enabled) {
    this.stop();
    this.start();
  } else if (this.timer_) {
    this.stop();
  }
};
goog.Timer.prototype.tick_ = function() {
  if (this.enabled) {
    var elapsed = goog.now() - this.last_;
    if (elapsed > 0 &&
        elapsed < this.interval_ * goog.Timer.intervalScale) {
      this.timer_ = this.timerObject_.setTimeout(this.boundTick_,
          this.interval_ - elapsed);
      return;
    }
    if (this.timer_) {
      this.timerObject_.clearTimeout(this.timer_);
      this.timer_ = null;
    }
    this.dispatchTick();
    if (this.enabled) {
      this.timer_ = this.timerObject_.setTimeout(this.boundTick_,
          this.interval_);
      this.last_ = goog.now();
    }
  }
};
goog.Timer.prototype.dispatchTick = function() {
  this.dispatchEvent(goog.Timer.TICK);
};
goog.Timer.prototype.start = function() {
  this.enabled = true;
  if (!this.timer_) {
    this.timer_ = this.timerObject_.setTimeout(this.boundTick_,
        this.interval_);
    this.last_ = goog.now();
  }
};
goog.Timer.prototype.stop = function() {
  this.enabled = false;
  if (this.timer_) {
    this.timerObject_.clearTimeout(this.timer_);
    this.timer_ = null;
  }
};
goog.Timer.prototype.disposeInternal = function() {
  goog.Timer.superClass_.disposeInternal.call(this);
  this.stop();
  delete this.timerObject_;
};
goog.Timer.TICK = 'tick';
goog.Timer.callOnce = function(listener, opt_delay, opt_handler) {
  if (goog.isFunction(listener)) {
    if (opt_handler) {
      listener = goog.bind(listener, opt_handler);
    }
  } else if (listener && typeof listener.handleEvent == 'function') {
    listener = goog.bind(listener.handleEvent, listener);
  } else {
    throw Error('Invalid listener argument');
  }
  if (opt_delay > goog.Timer.MAX_TIMEOUT_) {
    return goog.Timer.INVALID_TIMEOUT_ID_;
  } else {
    return goog.Timer.defaultTimerObject.setTimeout(
        listener, opt_delay || 0);
  }
};
goog.Timer.clear = function(timerId) {
  goog.Timer.defaultTimerObject.clearTimeout(timerId);
};
goog.Timer.promise = function(delay, opt_result) {
  var timerKey = null;
  return new goog.Promise(function(resolve, reject) {
    timerKey = goog.Timer.callOnce(function() {
      resolve(opt_result);
    }, delay);
    if (timerKey == goog.Timer.INVALID_TIMEOUT_ID_) {
      reject(new Error('Failed to schedule timer.'));
    }
  }).thenCatch(function(error) {
    goog.Timer.clear(timerKey);
    throw error;
  });
};

// goog.a11y.aria.Announcer
goog.provide('goog.a11y.aria.Announcer');
goog.a11y.aria.Announcer = function(opt_domHelper) {
  goog.a11y.aria.Announcer.base(this, 'constructor');
  this.domHelper_ = opt_domHelper || goog.dom.getDomHelper();
  this.liveRegions_ = {};
};
goog.inherits(goog.a11y.aria.Announcer, goog.Disposable);
goog.a11y.aria.Announcer.prototype.disposeInternal = function() {
  goog.object.forEach(
      this.liveRegions_, this.domHelper_.removeNode, this.domHelper_);
  this.liveRegions_ = null;
  this.domHelper_ = null;
  goog.a11y.aria.Announcer.base(this, 'disposeInternal');
};
goog.a11y.aria.Announcer.prototype.say = function(message, opt_priority) {
  var priority = opt_priority || goog.a11y.aria.LivePriority.POLITE;
  var liveRegion = this.getLiveRegion_(priority);
  goog.dom.setTextContent(liveRegion, '');
  goog.Timer.callOnce(function() {
    goog.dom.setTextContent(liveRegion, message);
  }, 1);
};
goog.a11y.aria.Announcer.prototype.getLiveRegion_ = function(priority) {
  var liveRegion = this.liveRegions_[priority];
  if (liveRegion) {
    goog.a11y.aria.removeState(liveRegion, goog.a11y.aria.State.HIDDEN);
    return liveRegion;
  }
  liveRegion = this.domHelper_.createElement(goog.dom.TagName.DIV);
  liveRegion.style.position = 'absolute';
  liveRegion.style.top = '-1000px';
  liveRegion.style.height = '1px';
  liveRegion.style.overflow = 'hidden';
  goog.a11y.aria.setState(liveRegion, goog.a11y.aria.State.LIVE,
      priority);
  goog.a11y.aria.setState(liveRegion, goog.a11y.aria.State.ATOMIC,
      'true');
  this.domHelper_.getDocument().body.appendChild(liveRegion);
  this.liveRegions_[priority] = liveRegion;
  return liveRegion;
};

// goog.html.SafeScript
goog.provide('goog.html.SafeScript');
goog.html.SafeScript = function() {
  this.privateDoNotAccessOrElseSafeScriptWrappedValue_ = '';
  this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ =
      goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeScript.prototype.implementsGoogStringTypedString = true;
goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeScript.fromConstant = function(script) {
  var scriptString = goog.string.Const.unwrap(script);
  if (scriptString.length === 0) {
    return goog.html.SafeScript.EMPTY;
  }
  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(
      scriptString);
};
goog.html.SafeScript.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeScriptWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeScript.prototype.toString = function() {
    return 'SafeScript{' +
        this.privateDoNotAccessOrElseSafeScriptWrappedValue_ + '}';
  };
}
goog.html.SafeScript.unwrap = function(safeScript) {
  if (safeScript instanceof goog.html.SafeScript &&
      safeScript.constructor === goog.html.SafeScript &&
      safeScript.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ===
          goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeScript.privateDoNotAccessOrElseSafeScriptWrappedValue_;
  } else {
    goog.asserts.fail(
        'expected object of type SafeScript, got \'' + safeScript + '\'');
    return 'type_error:SafeScript';
  }
};
goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse =
    function(script) {
  return new goog.html.SafeScript().initSecurityPrivateDoNotAccessOrElse_(
      script);
};
goog.html.SafeScript.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(
    script) {
  this.privateDoNotAccessOrElseSafeScriptWrappedValue_ = script;
  return this;
};
goog.html.SafeScript.EMPTY =
    goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse('');

// goog.html.uncheckedconversions
goog.provide('goog.html.uncheckedconversions');
goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract =
    function(justification, html, opt_dir) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification),
                            'must provide justification');
  goog.asserts.assert(
      !goog.string.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)),
      'must provide non-empty justification');
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(
      html, opt_dir || null);
};
goog.html.uncheckedconversions.safeScriptFromStringKnownToSatisfyTypeContract =
    function(justification, script) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification),
                            'must provide justification');
  goog.asserts.assert(
      !goog.string.isEmpty(goog.string.Const.unwrap(justification)),
      'must provide non-empty justification');
  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(
      script);
};
goog.html.uncheckedconversions.safeStyleFromStringKnownToSatisfyTypeContract =
    function(justification, style) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification),
                            'must provide justification');
  goog.asserts.assert(
      !goog.string.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)),
      'must provide non-empty justification');
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(
      style);
};
goog.html.uncheckedconversions.
    safeStyleSheetFromStringKnownToSatisfyTypeContract =
    function(justification, styleSheet) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification),
                            'must provide justification');
  goog.asserts.assert(
      !goog.string.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)),
      'must provide non-empty justification');
  return goog.html.SafeStyleSheet.
      createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheet);
};
goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract =
    function(justification, url) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification),
                            'must provide justification');
  goog.asserts.assert(
      !goog.string.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)),
      'must provide non-empty justification');
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.uncheckedconversions.
    trustedResourceUrlFromStringKnownToSatisfyTypeContract =
    function(justification, url) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification),
                            'must provide justification');
  goog.asserts.assert(
      !goog.string.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)),
      'must provide non-empty justification');
  return goog.html.TrustedResourceUrl.
      createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(url);
};

// goog.structs
goog.provide('goog.structs');
goog.structs.getCount = function(col) {
  if (typeof col.getCount == 'function') {
    return col.getCount();
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return col.length;
  }
  return goog.object.getCount(col);
};
goog.structs.getValues = function(col) {
  if (typeof col.getValues == 'function') {
    return col.getValues();
  }
  if (goog.isString(col)) {
    return col.split('');
  }
  if (goog.isArrayLike(col)) {
    var rv = [];
    var l = col.length;
    for (var i = 0; i < l; i++) {
      rv.push(col[i]);
    }
    return rv;
  }
  return goog.object.getValues(col);
};
goog.structs.getKeys = function(col) {
  if (typeof col.getKeys == 'function') {
    return col.getKeys();
  }
  if (typeof col.getValues == 'function') {
    return undefined;
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    var rv = [];
    var l = col.length;
    for (var i = 0; i < l; i++) {
      rv.push(i);
    }
    return rv;
  }
  return goog.object.getKeys(col);
};
goog.structs.contains = function(col, val) {
  if (typeof col.contains == 'function') {
    return col.contains(val);
  }
  if (typeof col.containsValue == 'function') {
    return col.containsValue(val);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.contains( (col), val);
  }
  return goog.object.containsValue(col, val);
};
goog.structs.isEmpty = function(col) {
  if (typeof col.isEmpty == 'function') {
    return col.isEmpty();
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.isEmpty( (col));
  }
  return goog.object.isEmpty(col);
};
goog.structs.clear = function(col) {
  if (typeof col.clear == 'function') {
    col.clear();
  } else if (goog.isArrayLike(col)) {
    goog.array.clear( (col));
  } else {
    goog.object.clear(col);
  }
};
goog.structs.forEach = function(col, f, opt_obj) {
  if (typeof col.forEach == 'function') {
    col.forEach(f, opt_obj);
  } else if (goog.isArrayLike(col) || goog.isString(col)) {
    goog.array.forEach( (col), f, opt_obj);
  } else {
    var keys = goog.structs.getKeys(col);
    var values = goog.structs.getValues(col);
    var l = values.length;
    for (var i = 0; i < l; i++) {
      f.call(opt_obj, values[i], keys && keys[i], col);
    }
  }
};
goog.structs.filter = function(col, f, opt_obj) {
  if (typeof col.filter == 'function') {
    return col.filter(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.filter( (col), f, opt_obj);
  }
  var rv;
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  if (keys) {
    rv = {};
    for (var i = 0; i < l; i++) {
      if (f.call(opt_obj, values[i], keys[i], col)) {
        rv[keys[i]] = values[i];
      }
    }
  } else {
    rv = [];
    for (var i = 0; i < l; i++) {
      if (f.call(opt_obj, values[i], undefined, col)) {
        rv.push(values[i]);
      }
    }
  }
  return rv;
};
goog.structs.map = function(col, f, opt_obj) {
  if (typeof col.map == 'function') {
    return col.map(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.map( (col), f, opt_obj);
  }
  var rv;
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  if (keys) {
    rv = {};
    for (var i = 0; i < l; i++) {
      rv[keys[i]] = f.call(opt_obj, values[i], keys[i], col);
    }
  } else {
    rv = [];
    for (var i = 0; i < l; i++) {
      rv[i] = f.call(opt_obj, values[i], undefined, col);
    }
  }
  return rv;
};
goog.structs.some = function(col, f, opt_obj) {
  if (typeof col.some == 'function') {
    return col.some(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.some( (col), f, opt_obj);
  }
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  for (var i = 0; i < l; i++) {
    if (f.call(opt_obj, values[i], keys && keys[i], col)) {
      return true;
    }
  }
  return false;
};
goog.structs.every = function(col, f, opt_obj) {
  if (typeof col.every == 'function') {
    return col.every(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.every( (col), f, opt_obj);
  }
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  for (var i = 0; i < l; i++) {
    if (!f.call(opt_obj, values[i], keys && keys[i], col)) {
      return false;
    }
  }
  return true;
};

// goog.structs.Collection
goog.provide('goog.structs.Collection');
goog.structs.Collection = function() {};
goog.structs.Collection.prototype.add;
goog.structs.Collection.prototype.remove;
goog.structs.Collection.prototype.contains;
goog.structs.Collection.prototype.getCount;

// goog.iter
// goog.iter.Iterable
// goog.iter.Iterator
// goog.iter.StopIteration
goog.provide('goog.iter');
goog.provide('goog.iter.Iterable');
goog.provide('goog.iter.Iterator');
goog.provide('goog.iter.StopIteration');
goog.iter.Iterable;
goog.iter.StopIteration = ('StopIteration' in goog.global) ?
    goog.global['StopIteration'] :
    { message: 'StopIteration', stack: ''};
goog.iter.Iterator = function() {};
goog.iter.Iterator.prototype.next = function() {
  throw goog.iter.StopIteration;
};
goog.iter.Iterator.prototype.__iterator__ = function(opt_keys) {
  return this;
};
goog.iter.toIterator = function(iterable) {
  if (iterable instanceof goog.iter.Iterator) {
    return iterable;
  }
  if (typeof iterable.__iterator__ == 'function') {
    return iterable.__iterator__(false);
  }
  if (goog.isArrayLike(iterable)) {
    var i = 0;
    var newIter = new goog.iter.Iterator;
    newIter.next = function() {
      while (true) {
        if (i >= iterable.length) {
          throw goog.iter.StopIteration;
        }
        if (!(i in iterable)) {
          i++;
          continue;
        }
        return iterable[i++];
      }
    };
    return newIter;
  }
  throw Error('Not implemented');
};
goog.iter.forEach = function(iterable, f, opt_obj) {
  if (goog.isArrayLike(iterable)) {
    try {
      goog.array.forEach((iterable), f,
                         opt_obj);
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  } else {
    iterable = goog.iter.toIterator(iterable);
    try {
      while (true) {
        f.call(opt_obj, iterable.next(), undefined, iterable);
      }
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  }
};
goog.iter.filter = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    while (true) {
      var val = iterator.next();
      if (f.call(opt_obj, val, undefined, iterator)) {
        return val;
      }
    }
  };
  return newIter;
};
goog.iter.filterFalse = function(iterable, f, opt_obj) {
  return goog.iter.filter(iterable, goog.functions.not(f), opt_obj);
};
goog.iter.range = function(startOrStop, opt_stop, opt_step) {
  var start = 0;
  var stop = startOrStop;
  var step = opt_step || 1;
  if (arguments.length > 1) {
    start = startOrStop;
    stop = opt_stop;
  }
  if (step == 0) {
    throw Error('Range step argument must not be zero');
  }
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if (step > 0 && start >= stop || step < 0 && start <= stop) {
      throw goog.iter.StopIteration;
    }
    var rv = start;
    start += step;
    return rv;
  };
  return newIter;
};
goog.iter.join = function(iterable, deliminator) {
  return goog.iter.toArray(iterable).join(deliminator);
};
goog.iter.map = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    var val = iterator.next();
    return f.call(opt_obj, val, undefined, iterator);
  };
  return newIter;
};
goog.iter.reduce = function(iterable, f, val, opt_obj) {
  var rval = val;
  goog.iter.forEach(iterable, function(val) {
    rval = f.call(opt_obj, rval, val);
  });
  return rval;
};
goog.iter.some = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    while (true) {
      if (f.call(opt_obj, iterable.next(), undefined, iterable)) {
        return true;
      }
    }
  } catch (ex) {
    if (ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return false;
};
goog.iter.every = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    while (true) {
      if (!f.call(opt_obj, iterable.next(), undefined, iterable)) {
        return false;
      }
    }
  } catch (ex) {
    if (ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return true;
};
goog.iter.chain = function(var_args) {
  return goog.iter.chainFromIterable(arguments);
};
goog.iter.chainFromIterable = function(iterable) {
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator();
  var current = null;
  iter.next = function() {
    while (true) {
      if (current == null) {
        var it = iterator.next();
        current = goog.iter.toIterator(it);
      }
      try {
        return current.next();
      } catch (ex) {
        if (ex !== goog.iter.StopIteration) {
          throw ex;
        }
        current = null;
      }
    }
  };
  return iter;
};
goog.iter.dropWhile = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  var dropping = true;
  newIter.next = function() {
    while (true) {
      var val = iterator.next();
      if (dropping && f.call(opt_obj, val, undefined, iterator)) {
        continue;
      } else {
        dropping = false;
      }
      return val;
    }
  };
  return newIter;
};
goog.iter.takeWhile = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator();
  iter.next = function() {
    var val = iterator.next();
    if (f.call(opt_obj, val, undefined, iterator)) {
      return val;
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.toArray = function(iterable) {
  if (goog.isArrayLike(iterable)) {
    return goog.array.toArray((iterable));
  }
  iterable = goog.iter.toIterator(iterable);
  var array = [];
  goog.iter.forEach(iterable, function(val) {
    array.push(val);
  });
  return array;
};
goog.iter.equals = function(iterable1, iterable2, opt_equalsFn) {
  var fillValue = {};
  var pairs = goog.iter.zipLongest(fillValue, iterable1, iterable2);
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  return goog.iter.every(pairs, function(pair) {
    return equalsFn(pair[0], pair[1]);
  });
};
goog.iter.nextOrValue = function(iterable, defaultValue) {
  try {
    return goog.iter.toIterator(iterable).next();
  } catch (e) {
    if (e != goog.iter.StopIteration) {
      throw e;
    }
    return defaultValue;
  }
};
goog.iter.product = function(var_args) {
  var someArrayEmpty = goog.array.some(arguments, function(arr) {
    return !arr.length;
  });
  if (someArrayEmpty || !arguments.length) {
    return new goog.iter.Iterator();
  }
  var iter = new goog.iter.Iterator();
  var arrays = arguments;
  var indicies = goog.array.repeat(0, arrays.length);
  iter.next = function() {
    if (indicies) {
      var retVal = goog.array.map(indicies, function(valueIndex, arrayIndex) {
        return arrays[arrayIndex][valueIndex];
      });
      for (var i = indicies.length - 1; i >= 0; i--) {
        goog.asserts.assert(indicies);
        if (indicies[i] < arrays[i].length - 1) {
          indicies[i]++;
          break;
        }
        if (i == 0) {
          indicies = null;
          break;
        }
        indicies[i] = 0;
      }
      return retVal;
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.cycle = function(iterable) {
  var baseIterator = goog.iter.toIterator(iterable);
  var cache = [];
  var cacheIndex = 0;
  var iter = new goog.iter.Iterator();
  var useCache = false;
  iter.next = function() {
    var returnElement = null;
    if (!useCache) {
      try {
        returnElement = baseIterator.next();
        cache.push(returnElement);
        return returnElement;
      } catch (e) {
        if (e != goog.iter.StopIteration || goog.array.isEmpty(cache)) {
          throw e;
        }
        useCache = true;
      }
    }
    returnElement = cache[cacheIndex];
    cacheIndex = (cacheIndex + 1) % cache.length;
    return returnElement;
  };
  return iter;
};
goog.iter.count = function(opt_start, opt_step) {
  var counter = opt_start || 0;
  var step = goog.isDef(opt_step) ? opt_step : 1;
  var iter = new goog.iter.Iterator();
  iter.next = function() {
    var returnValue = counter;
    counter += step;
    return returnValue;
  };
  return iter;
};
goog.iter.repeat = function(value) {
  var iter = new goog.iter.Iterator();
  iter.next = goog.functions.constant(value);
  return iter;
};
goog.iter.accumulate = function(iterable) {
  var iterator = goog.iter.toIterator(iterable);
  var total = 0;
  var iter = new goog.iter.Iterator();
  iter.next = function() {
    total += iterator.next();
    return total;
  };
  return iter;
};
goog.iter.zip = function(var_args) {
  var args = arguments;
  var iter = new goog.iter.Iterator();
  if (args.length > 0) {
    var iterators = goog.array.map(args, goog.iter.toIterator);
    iter.next = function() {
      var arr = goog.array.map(iterators, function(it) {
        return it.next();
      });
      return arr;
    };
  }
  return iter;
};
goog.iter.zipLongest = function(fillValue, var_args) {
  var args = goog.array.slice(arguments, 1);
  var iter = new goog.iter.Iterator();
  if (args.length > 0) {
    var iterators = goog.array.map(args, goog.iter.toIterator);
    iter.next = function() {
      var iteratorsHaveValues = false;  // false when all iterators are empty.
      var arr = goog.array.map(iterators, function(it) {
        var returnValue;
        try {
          returnValue = it.next();
          iteratorsHaveValues = true;
        } catch (ex) {
          if (ex !== goog.iter.StopIteration) {
            throw ex;
          }
          returnValue = fillValue;
        }
        return returnValue;
      });
      if (!iteratorsHaveValues) {
        throw goog.iter.StopIteration;
      }
      return arr;
    };
  }
  return iter;
};
goog.iter.compress = function(iterable, selectors) {
  var selectorIterator = goog.iter.toIterator(selectors);
  return goog.iter.filter(iterable, function() {
    return !!selectorIterator.next();
  });
};
goog.iter.GroupByIterator_ = function(iterable, opt_keyFunc) {
  this.iterator = goog.iter.toIterator(iterable);
  this.keyFunc = opt_keyFunc || goog.functions.identity;
  this.targetKey;
  this.currentKey;
  this.currentValue;
};
goog.inherits(goog.iter.GroupByIterator_, goog.iter.Iterator);
goog.iter.GroupByIterator_.prototype.next = function() {
  while (this.currentKey == this.targetKey) {
    this.currentValue = this.iterator.next();  // Exits on StopIteration
    this.currentKey = this.keyFunc(this.currentValue);
  }
  this.targetKey = this.currentKey;
  return [this.currentKey, this.groupItems_(this.targetKey)];
};
goog.iter.GroupByIterator_.prototype.groupItems_ = function(targetKey) {
  var arr = [];
  while (this.currentKey == targetKey) {
    arr.push(this.currentValue);
    try {
      this.currentValue = this.iterator.next();
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
      break;
    }
    this.currentKey = this.keyFunc(this.currentValue);
  }
  return arr;
};
goog.iter.groupBy = function(iterable, opt_keyFunc) {
  return new goog.iter.GroupByIterator_(iterable, opt_keyFunc);
};
goog.iter.starMap = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator();
  iter.next = function() {
    var args = goog.iter.toArray(iterator.next());
    return f.apply(opt_obj, goog.array.concat(args, undefined, iterator));
  };
  return iter;
};
goog.iter.tee = function(iterable, opt_num) {
  var iterator = goog.iter.toIterator(iterable);
  var num = goog.isNumber(opt_num) ? opt_num : 2;
  var buffers = goog.array.map(goog.array.range(num), function() {
    return [];
  });
  var addNextIteratorValueToBuffers = function() {
    var val = iterator.next();
    goog.array.forEach(buffers, function(buffer) {
      buffer.push(val);
    });
  };
  var createIterator = function(buffer) {
    var iter = new goog.iter.Iterator();
    iter.next = function() {
      if (goog.array.isEmpty(buffer)) {
        addNextIteratorValueToBuffers();
      }
      goog.asserts.assert(!goog.array.isEmpty(buffer));
      return buffer.shift();
    };
    return iter;
  };
  return goog.array.map(buffers, createIterator);
};
goog.iter.enumerate = function(iterable, opt_start) {
  return goog.iter.zip(goog.iter.count(opt_start), iterable);
};
goog.iter.limit = function(iterable, limitSize) {
  goog.asserts.assert(goog.math.isInt(limitSize) && limitSize >= 0);
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator();
  var remaining = limitSize;
  iter.next = function() {
    if (remaining-- > 0) {
      return iterator.next();
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.consume = function(iterable, count) {
  goog.asserts.assert(goog.math.isInt(count) && count >= 0);
  var iterator = goog.iter.toIterator(iterable);
  while (count-- > 0) {
    goog.iter.nextOrValue(iterator, null);
  }
  return iterator;
};
goog.iter.slice = function(iterable, start, opt_end) {
  goog.asserts.assert(goog.math.isInt(start) && start >= 0);
  var iterator = goog.iter.consume(iterable, start);
  if (goog.isNumber(opt_end)) {
    goog.asserts.assert(goog.math.isInt(opt_end) && opt_end >= start);
    iterator = goog.iter.limit(iterator, opt_end - start );
  }
  return iterator;
};
goog.iter.hasDuplicates_ = function(arr) {
  var deduped = [];
  goog.array.removeDuplicates(arr, deduped);
  return arr.length != deduped.length;
};
goog.iter.permutations = function(iterable, opt_length) {
  var elements = goog.iter.toArray(iterable);
  var length = goog.isNumber(opt_length) ? opt_length : elements.length;
  var sets = goog.array.repeat(elements, length);
  var product = goog.iter.product.apply(undefined, sets);
  return goog.iter.filter(product, function(arr) {
    return !goog.iter.hasDuplicates_(arr);
  });
};
goog.iter.combinations = function(iterable, length) {
  var elements = goog.iter.toArray(iterable);
  var indexes = goog.iter.range(elements.length);
  var indexIterator = goog.iter.permutations(indexes, length);
  var sortedIndexIterator = goog.iter.filter(indexIterator, function(arr) {
    return goog.array.isSorted(arr);
  });
  var iter = new goog.iter.Iterator();
  function getIndexFromElements(index) {
    return elements[index];
  }
  iter.next = function() {
    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);
  };
  return iter;
};
goog.iter.combinationsWithReplacement = function(iterable, length) {
  var elements = goog.iter.toArray(iterable);
  var indexes = goog.array.range(elements.length);
  var sets = goog.array.repeat(indexes, length);
  var indexIterator = goog.iter.product.apply(undefined, sets);
  var sortedIndexIterator = goog.iter.filter(indexIterator, function(arr) {
    return goog.array.isSorted(arr);
  });
  var iter = new goog.iter.Iterator();
  function getIndexFromElements(index) {
    return elements[index];
  }
  iter.next = function() {
    return goog.array.map(
        (sortedIndexIterator.next()), getIndexFromElements);
  };
  return iter;
};

// goog.structs.Map
goog.provide('goog.structs.Map');
goog.structs.Map = function(opt_map, var_args) {
  this.map_ = {};
  this.keys_ = [];
  this.count_ = 0;
  this.version_ = 0;
  var argLength = arguments.length;
  if (argLength > 1) {
    if (argLength % 2) {
      throw Error('Uneven number of arguments');
    }
    for (var i = 0; i < argLength; i += 2) {
      this.set(arguments[i], arguments[i + 1]);
    }
  } else if (opt_map) {
    this.addAll( (opt_map));
  }
};
goog.structs.Map.prototype.getCount = function() {
  return this.count_;
};
goog.structs.Map.prototype.getValues = function() {
  this.cleanupKeysArray_();
  var rv = [];
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    rv.push(this.map_[key]);
  }
  return rv;
};
goog.structs.Map.prototype.getKeys = function() {
  this.cleanupKeysArray_();
  return  (this.keys_.concat());
};
goog.structs.Map.prototype.containsKey = function(key) {
  return goog.structs.Map.hasKey_(this.map_, key);
};
goog.structs.Map.prototype.containsValue = function(val) {
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    if (goog.structs.Map.hasKey_(this.map_, key) && this.map_[key] == val) {
      return true;
    }
  }
  return false;
};
goog.structs.Map.prototype.equals = function(otherMap, opt_equalityFn) {
  if (this === otherMap) {
    return true;
  }
  if (this.count_ != otherMap.getCount()) {
    return false;
  }
  var equalityFn = opt_equalityFn || goog.structs.Map.defaultEquals;
  this.cleanupKeysArray_();
  for (var key, i = 0; key = this.keys_[i]; i++) {
    if (!equalityFn(this.get(key), otherMap.get(key))) {
      return false;
    }
  }
  return true;
};
goog.structs.Map.defaultEquals = function(a, b) {
  return a === b;
};
goog.structs.Map.prototype.isEmpty = function() {
  return this.count_ == 0;
};
goog.structs.Map.prototype.clear = function() {
  this.map_ = {};
  this.keys_.length = 0;
  this.count_ = 0;
  this.version_ = 0;
};
goog.structs.Map.prototype.remove = function(key) {
  if (goog.structs.Map.hasKey_(this.map_, key)) {
    delete this.map_[key];
    this.count_--;
    this.version_++;
    if (this.keys_.length > 2 * this.count_) {
      this.cleanupKeysArray_();
    }
    return true;
  }
  return false;
};
goog.structs.Map.prototype.cleanupKeysArray_ = function() {
  if (this.count_ != this.keys_.length) {
    var srcIndex = 0;
    var destIndex = 0;
    while (srcIndex < this.keys_.length) {
      var key = this.keys_[srcIndex];
      if (goog.structs.Map.hasKey_(this.map_, key)) {
        this.keys_[destIndex++] = key;
      }
      srcIndex++;
    }
    this.keys_.length = destIndex;
  }
  if (this.count_ != this.keys_.length) {
    var seen = {};
    var srcIndex = 0;
    var destIndex = 0;
    while (srcIndex < this.keys_.length) {
      var key = this.keys_[srcIndex];
      if (!(goog.structs.Map.hasKey_(seen, key))) {
        this.keys_[destIndex++] = key;
        seen[key] = 1;
      }
      srcIndex++;
    }
    this.keys_.length = destIndex;
  }
};
goog.structs.Map.prototype.get = function(key, opt_val) {
  if (goog.structs.Map.hasKey_(this.map_, key)) {
    return this.map_[key];
  }
  return opt_val;
};
goog.structs.Map.prototype.set = function(key, value) {
  if (!(goog.structs.Map.hasKey_(this.map_, key))) {
    this.count_++;
    this.keys_.push(key);
    this.version_++;
  }
  this.map_[key] = value;
};
goog.structs.Map.prototype.addAll = function(map) {
  var keys, values;
  if (map instanceof goog.structs.Map) {
    keys = map.getKeys();
    values = map.getValues();
  } else {
    keys = goog.object.getKeys(map);
    values = goog.object.getValues(map);
  }
  for (var i = 0; i < keys.length; i++) {
    this.set(keys[i], values[i]);
  }
};
goog.structs.Map.prototype.forEach = function(f, opt_obj) {
  var keys = this.getKeys();
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var value = this.get(key);
    f.call(opt_obj, value, key, this);
  }
};
goog.structs.Map.prototype.clone = function() {
  return new goog.structs.Map(this);
};
goog.structs.Map.prototype.transpose = function() {
  var transposed = new goog.structs.Map();
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    var value = this.map_[key];
    transposed.set(value, key);
  }
  return transposed;
};
goog.structs.Map.prototype.toObject = function() {
  this.cleanupKeysArray_();
  var obj = {};
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    obj[key] = this.map_[key];
  }
  return obj;
};
goog.structs.Map.prototype.getKeyIterator = function() {
  return this.__iterator__(true);
};
goog.structs.Map.prototype.getValueIterator = function() {
  return this.__iterator__(false);
};
goog.structs.Map.prototype.__iterator__ = function(opt_keys) {
  this.cleanupKeysArray_();
  var i = 0;
  var version = this.version_;
  var selfObj = this;
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if (version != selfObj.version_) {
      throw Error('The map has changed since the iterator was created');
    }
    if (i >= selfObj.keys_.length) {
      throw goog.iter.StopIteration;
    }
    var key = selfObj.keys_[i++];
    return opt_keys ? key : selfObj.map_[key];
  };
  return newIter;
};
goog.structs.Map.hasKey_ = function(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
};

// goog.structs.Set
goog.provide('goog.structs.Set');
goog.structs.Set = function(opt_values) {
  this.map_ = new goog.structs.Map;
  if (opt_values) {
    this.addAll(opt_values);
  }
};
goog.structs.Set.getKey_ = function(val) {
  var type = typeof val;
  if (type == 'object' && val || type == 'function') {
    return 'o' + goog.getUid( (val));
  } else {
    return type.substr(0, 1) + val;
  }
};
goog.structs.Set.prototype.getCount = function() {
  return this.map_.getCount();
};
goog.structs.Set.prototype.add = function(element) {
  this.map_.set(goog.structs.Set.getKey_(element), element);
};
goog.structs.Set.prototype.addAll = function(col) {
  var values = goog.structs.getValues(col);
  var l = values.length;
  for (var i = 0; i < l; i++) {
    this.add(values[i]);
  }
};
goog.structs.Set.prototype.removeAll = function(col) {
  var values = goog.structs.getValues(col);
  var l = values.length;
  for (var i = 0; i < l; i++) {
    this.remove(values[i]);
  }
};
goog.structs.Set.prototype.remove = function(element) {
  return this.map_.remove(goog.structs.Set.getKey_(element));
};
goog.structs.Set.prototype.clear = function() {
  this.map_.clear();
};
goog.structs.Set.prototype.isEmpty = function() {
  return this.map_.isEmpty();
};
goog.structs.Set.prototype.contains = function(element) {
  return this.map_.containsKey(goog.structs.Set.getKey_(element));
};
goog.structs.Set.prototype.containsAll = function(col) {
  return goog.structs.every(col, this.contains, this);
};
goog.structs.Set.prototype.intersection = function(col) {
  var result = new goog.structs.Set();
  var values = goog.structs.getValues(col);
  for (var i = 0; i < values.length; i++) {
    var value = values[i];
    if (this.contains(value)) {
      result.add(value);
    }
  }
  return result;
};
goog.structs.Set.prototype.difference = function(col) {
  var result = this.clone();
  result.removeAll(col);
  return result;
};
goog.structs.Set.prototype.getValues = function() {
  return this.map_.getValues();
};
goog.structs.Set.prototype.clone = function() {
  return new goog.structs.Set(this);
};
goog.structs.Set.prototype.equals = function(col) {
  return this.getCount() == goog.structs.getCount(col) && this.isSubsetOf(col);
};
goog.structs.Set.prototype.isSubsetOf = function(col) {
  var colCount = goog.structs.getCount(col);
  if (this.getCount() > colCount) {
    return false;
  }
  if (!(col instanceof goog.structs.Set) && colCount > 5) {
    col = new goog.structs.Set(col);
  }
  return goog.structs.every(this, function(value) {
    return goog.structs.contains(col, value);
  });
};
goog.structs.Set.prototype.__iterator__ = function(opt_keys) {
  return this.map_.__iterator__(false);
};

// goog.debug
goog.provide('goog.debug');
goog.define('goog.debug.LOGGING_ENABLED', goog.DEBUG);
goog.debug.catchErrors = function(logFunc, opt_cancel, opt_target) {
  var target = opt_target || goog.global;
  var oldErrorHandler = target.onerror;
  var retVal = !!opt_cancel;
  if (goog.userAgent.WEBKIT &&
      !goog.userAgent.isVersionOrHigher('535.3')) {
    retVal = !retVal;
  }
  target.onerror = function(message, url, line, opt_col, opt_error) {
    if (oldErrorHandler) {
      oldErrorHandler(message, url, line, opt_col, opt_error);
    }
    logFunc({
      message: message,
      fileName: url,
      line: line,
      col: opt_col,
      error: opt_error
    });
    return retVal;
  };
};
goog.debug.expose = function(obj, opt_showFn) {
  if (typeof obj == 'undefined') {
    return 'undefined';
  }
  if (obj == null) {
    return 'NULL';
  }
  var str = [];
  for (var x in obj) {
    if (!opt_showFn && goog.isFunction(obj[x])) {
      continue;
    }
    var s = x + ' = ';
    try {
      s += obj[x];
    } catch (e) {
      s += '*** ' + e + ' ***';
    }
    str.push(s);
  }
  return str.join('\n');
};
goog.debug.deepExpose = function(obj, opt_showFn) {
  var str = [];
  var helper = function(obj, space, parentSeen) {
    var nestspace = space + '  ';
    var seen = new goog.structs.Set(parentSeen);
    var indentMultiline = function(str) {
      return str.replace(/\n/g, '\n' + space);
    };
    try {
      if (!goog.isDef(obj)) {
        str.push('undefined');
      } else if (goog.isNull(obj)) {
        str.push('NULL');
      } else if (goog.isString(obj)) {
        str.push('"' + indentMultiline(obj) + '"');
      } else if (goog.isFunction(obj)) {
        str.push(indentMultiline(String(obj)));
      } else if (goog.isObject(obj)) {
        if (seen.contains(obj)) {
          str.push('*** reference loop detected ***');
        } else {
          seen.add(obj);
          str.push('{');
          for (var x in obj) {
            if (!opt_showFn && goog.isFunction(obj[x])) {
              continue;
            }
            str.push('\n');
            str.push(nestspace);
            str.push(x + ' = ');
            helper(obj[x], nestspace, seen);
          }
          str.push('\n' + space + '}');
        }
      } else {
        str.push(obj);
      }
    } catch (e) {
      str.push('*** ' + e + ' ***');
    }
  };
  helper(obj, '', new goog.structs.Set());
  return str.join('');
};
goog.debug.exposeArray = function(arr) {
  var str = [];
  for (var i = 0; i < arr.length; i++) {
    if (goog.isArray(arr[i])) {
      str.push(goog.debug.exposeArray(arr[i]));
    } else {
      str.push(arr[i]);
    }
  }
  return '[ ' + str.join(', ') + ' ]';
};
goog.debug.exposeException = function(err, opt_fn) {
  var html = goog.debug.exposeExceptionAsHtml(err, opt_fn);
  return goog.html.SafeHtml.unwrap(html);
};
goog.debug.exposeExceptionAsHtml = function(err, opt_fn) {
  try {
    var e = goog.debug.normalizeErrorObject(err);
    var viewSourceUrl = goog.debug.createViewSourceUrl_(e.fileName);
    var error = goog.html.SafeHtml.concat(
        goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces(
            'Message: ' + e.message + '\nUrl: '),
        goog.html.SafeHtml.create('a',
            {href: viewSourceUrl, target: '_new'}, e.fileName),
        goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces(
            '\nLine: ' + e.lineNumber + '\n\nBrowser stack:\n' +
            e.stack + '-> ' + '[end]\n\nJS stack traversal:\n' +
            goog.debug.getStacktrace(opt_fn) + '-> '));
    return error;
  } catch (e2) {
    return goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces(
        'Exception trying to expose exception! You win, we lose. ' + e2);
  }
};
goog.debug.createViewSourceUrl_ = function(opt_fileName) {
  if (!goog.isDefAndNotNull(opt_fileName)) {
    opt_fileName = '';
  }
  if (!/^https?:\/\//i.test(opt_fileName)) {
    return goog.html.SafeUrl.fromConstant(
        goog.string.Const.from('sanitizedviewsrc'));
  }
  var sanitizedFileName = goog.html.SafeUrl.sanitize(opt_fileName);
  return goog.html.uncheckedconversions.
      safeUrlFromStringKnownToSatisfyTypeContract(
          goog.string.Const.from('view-source scheme plus HTTP/HTTPS URL'),
          'view-source:' + goog.html.SafeUrl.unwrap(sanitizedFileName));
};
goog.debug.normalizeErrorObject = function(err) {
  var href = goog.getObjectByName('window.location.href');
  if (goog.isString(err)) {
    return {
      'message': err,
      'name': 'Unknown error',
      'lineNumber': 'Not available',
      'fileName': href,
      'stack': 'Not available'
    };
  }
  var lineNumber, fileName;
  var threwError = false;
  try {
    lineNumber = err.lineNumber || err.line || 'Not available';
  } catch (e) {
    lineNumber = 'Not available';
    threwError = true;
  }
  try {
    fileName = err.fileName || err.filename || err.sourceURL ||
        goog.global['$googDebugFname'] || href;
  } catch (e) {
    fileName = 'Not available';
    threwError = true;
  }
  if (threwError || !err.lineNumber || !err.fileName || !err.stack ||
      !err.message || !err.name) {
    return {
      'message': err.message || 'Not available',
      'name': err.name || 'UnknownError',
      'lineNumber': lineNumber,
      'fileName': fileName,
      'stack': err.stack || 'Not available'
    };
  }
  return err;
};
goog.debug.enhanceError = function(err, opt_message) {
  var error;
  if (typeof err == 'string') {
    error = Error(err);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(error, goog.debug.enhanceError);
    }
  } else {
    error = err;
  }
  if (!error.stack) {
    error.stack = goog.debug.getStacktrace(goog.debug.enhanceError);
  }
  if (opt_message) {
    var x = 0;
    while (error['message' + x]) {
      ++x;
    }
    error['message' + x] = String(opt_message);
  }
  return error;
};
goog.debug.getStacktraceSimple = function(opt_depth) {
  if (goog.STRICT_MODE_COMPATIBLE) {
    var stack = goog.debug.getNativeStackTrace_(goog.debug.getStacktraceSimple);
    if (stack) {
      return stack;
    }
  }
  var sb = [];
  var fn = arguments.callee.caller;
  var depth = 0;
  while (fn && (!opt_depth || depth < opt_depth)) {
    sb.push(goog.debug.getFunctionName(fn));
    sb.push('()\n');
    try {
      fn = fn.caller;
    } catch (e) {
      sb.push('[exception trying to get caller]\n');
      break;
    }
    depth++;
    if (depth >= goog.debug.MAX_STACK_DEPTH) {
      sb.push('[...long stack...]');
      break;
    }
  }
  if (opt_depth && depth >= opt_depth) {
    sb.push('[...reached max depth limit...]');
  } else {
    sb.push('[end]');
  }
  return sb.join('');
};
goog.debug.MAX_STACK_DEPTH = 50;
goog.debug.getNativeStackTrace_ = function(fn) {
  var tempErr = new Error();
  if (Error.captureStackTrace) {
    Error.captureStackTrace(tempErr, fn);
    return String(tempErr.stack);
  } else {
    try {
      throw tempErr;
    } catch (e) {
      tempErr = e;
    }
    var stack = tempErr.stack;
    if (stack) {
      return String(stack);
    }
  }
  return null;
};
goog.debug.getStacktrace = function(opt_fn) {
  var stack;
  if (goog.STRICT_MODE_COMPATIBLE) {
    var contextFn = opt_fn || goog.debug.getStacktrace;
    stack = goog.debug.getNativeStackTrace_(contextFn);
  }
  if (!stack) {
    stack = goog.debug.getStacktraceHelper_(
        opt_fn || arguments.callee.caller, []);
  }
  return stack;
};
goog.debug.getStacktraceHelper_ = function(fn, visited) {
  var sb = [];
  if (goog.array.contains(visited, fn)) {
    sb.push('[...circular reference...]');
  } else if (fn && visited.length < goog.debug.MAX_STACK_DEPTH) {
    sb.push(goog.debug.getFunctionName(fn) + '(');
    var args = fn.arguments;
    for (var i = 0; args && i < args.length; i++) {
      if (i > 0) {
        sb.push(', ');
      }
      var argDesc;
      var arg = args[i];
      switch (typeof arg) {
        case 'object':
          argDesc = arg ? 'object' : 'null';
          break;
        case 'string':
          argDesc = arg;
          break;
        case 'number':
          argDesc = String(arg);
          break;
        case 'boolean':
          argDesc = arg ? 'true' : 'false';
          break;
        case 'function':
          argDesc = goog.debug.getFunctionName(arg);
          argDesc = argDesc ? argDesc : '[fn]';
          break;
        case 'undefined':
        default:
          argDesc = typeof arg;
          break;
      }
      if (argDesc.length > 40) {
        argDesc = argDesc.substr(0, 40) + '...';
      }
      sb.push(argDesc);
    }
    visited.push(fn);
    sb.push(')\n');
    try {
      sb.push(goog.debug.getStacktraceHelper_(fn.caller, visited));
    } catch (e) {
      sb.push('[exception trying to get caller]\n');
    }
  } else if (fn) {
    sb.push('[...long stack...]');
  } else {
    sb.push('[end]');
  }
  return sb.join('');
};
goog.debug.setFunctionResolver = function(resolver) {
  goog.debug.fnNameResolver_ = resolver;
};
goog.debug.getFunctionName = function(fn) {
  if (goog.debug.fnNameCache_[fn]) {
    return goog.debug.fnNameCache_[fn];
  }
  if (goog.debug.fnNameResolver_) {
    var name = goog.debug.fnNameResolver_(fn);
    if (name) {
      goog.debug.fnNameCache_[fn] = name;
      return name;
    }
  }
  var functionSource = String(fn);
  if (!goog.debug.fnNameCache_[functionSource]) {
    var matches = /function ([^\(]+)/.exec(functionSource);
    if (matches) {
      var method = matches[1];
      goog.debug.fnNameCache_[functionSource] = method;
    } else {
      goog.debug.fnNameCache_[functionSource] = '[Anonymous]';
    }
  }
  return goog.debug.fnNameCache_[functionSource];
};
goog.debug.makeWhitespaceVisible = function(string) {
  return string.replace(/ /g, '[_]')
      .replace(/\f/g, '[f]')
      .replace(/\n/g, '[n]\n')
      .replace(/\r/g, '[r]')
      .replace(/\t/g, '[t]');
};
goog.debug.runtimeType = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || 'unknown type name';
  } else if (value instanceof Object) {
    return value.constructor.displayName || value.constructor.name ||
        Object.prototype.toString.call(value);
  } else {
    return value === null ? 'null' : typeof value;
  }
};
goog.debug.fnNameCache_ = {};
goog.debug.fnNameResolver_;

// goog.debug.LogRecord
goog.provide('goog.debug.LogRecord');
goog.debug.LogRecord = function(level, msg, loggerName,
    opt_time, opt_sequenceNumber) {
  this.reset(level, msg, loggerName, opt_time, opt_sequenceNumber);
};
goog.debug.LogRecord.prototype.time_;
goog.debug.LogRecord.prototype.level_;
goog.debug.LogRecord.prototype.msg_;
goog.debug.LogRecord.prototype.loggerName_;
goog.debug.LogRecord.prototype.sequenceNumber_ = 0;
goog.debug.LogRecord.prototype.exception_ = null;
goog.define('goog.debug.LogRecord.ENABLE_SEQUENCE_NUMBERS', true);
goog.debug.LogRecord.nextSequenceNumber_ = 0;
goog.debug.LogRecord.prototype.reset = function(level, msg, loggerName,
    opt_time, opt_sequenceNumber) {
  if (goog.debug.LogRecord.ENABLE_SEQUENCE_NUMBERS) {
    this.sequenceNumber_ = typeof opt_sequenceNumber == 'number' ?
        opt_sequenceNumber : goog.debug.LogRecord.nextSequenceNumber_++;
  }
  this.time_ = opt_time || goog.now();
  this.level_ = level;
  this.msg_ = msg;
  this.loggerName_ = loggerName;
  delete this.exception_;
};
goog.debug.LogRecord.prototype.getLoggerName = function() {
  return this.loggerName_;
};
goog.debug.LogRecord.prototype.getException = function() {
  return this.exception_;
};
goog.debug.LogRecord.prototype.setException = function(exception) {
  this.exception_ = exception;
};
goog.debug.LogRecord.prototype.setLoggerName = function(loggerName) {
  this.loggerName_ = loggerName;
};
goog.debug.LogRecord.prototype.getLevel = function() {
  return this.level_;
};
goog.debug.LogRecord.prototype.setLevel = function(level) {
  this.level_ = level;
};
goog.debug.LogRecord.prototype.getMessage = function() {
  return this.msg_;
};
goog.debug.LogRecord.prototype.setMessage = function(msg) {
  this.msg_ = msg;
};
goog.debug.LogRecord.prototype.getMillis = function() {
  return this.time_;
};
goog.debug.LogRecord.prototype.setMillis = function(time) {
  this.time_ = time;
};
goog.debug.LogRecord.prototype.getSequenceNumber = function() {
  return this.sequenceNumber_;
};

// goog.debug.LogBuffer
goog.provide('goog.debug.LogBuffer');
goog.debug.LogBuffer = function() {
  goog.asserts.assert(goog.debug.LogBuffer.isBufferingEnabled(),
      'Cannot use goog.debug.LogBuffer without defining ' +
      'goog.debug.LogBuffer.CAPACITY.');
  this.clear();
};
goog.debug.LogBuffer.getInstance = function() {
  if (!goog.debug.LogBuffer.instance_) {
    goog.debug.LogBuffer.instance_ = new goog.debug.LogBuffer();
  }
  return goog.debug.LogBuffer.instance_;
};
goog.define('goog.debug.LogBuffer.CAPACITY', 0);
goog.debug.LogBuffer.prototype.buffer_;
goog.debug.LogBuffer.prototype.curIndex_;
goog.debug.LogBuffer.prototype.isFull_;
goog.debug.LogBuffer.prototype.addRecord = function(level, msg, loggerName) {
  var curIndex = (this.curIndex_ + 1) % goog.debug.LogBuffer.CAPACITY;
  this.curIndex_ = curIndex;
  if (this.isFull_) {
    var ret = this.buffer_[curIndex];
    ret.reset(level, msg, loggerName);
    return ret;
  }
  this.isFull_ = curIndex == goog.debug.LogBuffer.CAPACITY - 1;
  return this.buffer_[curIndex] =
      new goog.debug.LogRecord(level, msg, loggerName);
};
goog.debug.LogBuffer.isBufferingEnabled = function() {
  return goog.debug.LogBuffer.CAPACITY > 0;
};
goog.debug.LogBuffer.prototype.clear = function() {
  this.buffer_ = new Array(goog.debug.LogBuffer.CAPACITY);
  this.curIndex_ = -1;
  this.isFull_ = false;
};
goog.debug.LogBuffer.prototype.forEachRecord = function(func) {
  var buffer = this.buffer_;
  if (!buffer[0]) {
    return;
  }
  var curIndex = this.curIndex_;
  var i = this.isFull_ ? curIndex : -1;
  do {
    i = (i + 1) % goog.debug.LogBuffer.CAPACITY;
    func( (buffer[i]));
  } while (i != curIndex);
};

// goog.debug.LogManager
// goog.debug.Loggable
// goog.debug.Logger
// goog.debug.Logger.Level
goog.provide('goog.debug.LogManager');
goog.provide('goog.debug.Loggable');
goog.provide('goog.debug.Logger');
goog.provide('goog.debug.Logger.Level');
goog.debug.Loggable;
goog.debug.Logger = function(name) {
  this.name_ = name;
  this.parent_ = null;
  this.level_ = null;
  this.children_ = null;
  this.handlers_ = null;
};
goog.debug.Logger.ROOT_LOGGER_NAME = '';
goog.define('goog.debug.Logger.ENABLE_HIERARCHY', true);
if (!goog.debug.Logger.ENABLE_HIERARCHY) {
  goog.debug.Logger.rootHandlers_ = [];
  goog.debug.Logger.rootLevel_;
}
goog.debug.Logger.Level = function(name, value) {
  this.name = name;
  this.value = value;
};
goog.debug.Logger.Level.prototype.toString = function() {
  return this.name;
};
goog.debug.Logger.Level.OFF =
    new goog.debug.Logger.Level('OFF', Infinity);
goog.debug.Logger.Level.SHOUT = new goog.debug.Logger.Level('SHOUT', 1200);
goog.debug.Logger.Level.SEVERE = new goog.debug.Logger.Level('SEVERE', 1000);
goog.debug.Logger.Level.WARNING = new goog.debug.Logger.Level('WARNING', 900);
goog.debug.Logger.Level.INFO = new goog.debug.Logger.Level('INFO', 800);
goog.debug.Logger.Level.CONFIG = new goog.debug.Logger.Level('CONFIG', 700);
goog.debug.Logger.Level.FINE = new goog.debug.Logger.Level('FINE', 500);
goog.debug.Logger.Level.FINER = new goog.debug.Logger.Level('FINER', 400);
goog.debug.Logger.Level.FINEST = new goog.debug.Logger.Level('FINEST', 300);
goog.debug.Logger.Level.ALL = new goog.debug.Logger.Level('ALL', 0);
goog.debug.Logger.Level.PREDEFINED_LEVELS = [
  goog.debug.Logger.Level.OFF,
  goog.debug.Logger.Level.SHOUT,
  goog.debug.Logger.Level.SEVERE,
  goog.debug.Logger.Level.WARNING,
  goog.debug.Logger.Level.INFO,
  goog.debug.Logger.Level.CONFIG,
  goog.debug.Logger.Level.FINE,
  goog.debug.Logger.Level.FINER,
  goog.debug.Logger.Level.FINEST,
  goog.debug.Logger.Level.ALL];
goog.debug.Logger.Level.predefinedLevelsCache_ = null;
goog.debug.Logger.Level.createPredefinedLevelsCache_ = function() {
  goog.debug.Logger.Level.predefinedLevelsCache_ = {};
  for (var i = 0, level; level = goog.debug.Logger.Level.PREDEFINED_LEVELS[i];
       i++) {
    goog.debug.Logger.Level.predefinedLevelsCache_[level.value] = level;
    goog.debug.Logger.Level.predefinedLevelsCache_[level.name] = level;
  }
};
goog.debug.Logger.Level.getPredefinedLevel = function(name) {
  if (!goog.debug.Logger.Level.predefinedLevelsCache_) {
    goog.debug.Logger.Level.createPredefinedLevelsCache_();
  }
  return goog.debug.Logger.Level.predefinedLevelsCache_[name] || null;
};
goog.debug.Logger.Level.getPredefinedLevelByValue = function(value) {
  if (!goog.debug.Logger.Level.predefinedLevelsCache_) {
    goog.debug.Logger.Level.createPredefinedLevelsCache_();
  }
  if (value in goog.debug.Logger.Level.predefinedLevelsCache_) {
    return goog.debug.Logger.Level.predefinedLevelsCache_[value];
  }
  for (var i = 0; i < goog.debug.Logger.Level.PREDEFINED_LEVELS.length; ++i) {
    var level = goog.debug.Logger.Level.PREDEFINED_LEVELS[i];
    if (level.value <= value) {
      return level;
    }
  }
  return null;
};
goog.debug.Logger.getLogger = function(name) {
  return goog.debug.LogManager.getLogger(name);
};
goog.debug.Logger.logToProfilers = function(msg) {
  if (goog.global['console']) {
    if (goog.global['console']['timeStamp']) {
      goog.global['console']['timeStamp'](msg);
    } else if (goog.global['console']['markTimeline']) {
      goog.global['console']['markTimeline'](msg);
    }
  }
  if (goog.global['msWriteProfilerMark']) {
    goog.global['msWriteProfilerMark'](msg);
  }
};
goog.debug.Logger.prototype.getName = function() {
  return this.name_;
};
goog.debug.Logger.prototype.addHandler = function(handler) {
  if (goog.debug.LOGGING_ENABLED) {
    if (goog.debug.Logger.ENABLE_HIERARCHY) {
      if (!this.handlers_) {
        this.handlers_ = [];
      }
      this.handlers_.push(handler);
    } else {
      goog.asserts.assert(!this.name_,
          'Cannot call addHandler on a non-root logger when ' +
          'goog.debug.Logger.ENABLE_HIERARCHY is false.');
      goog.debug.Logger.rootHandlers_.push(handler);
    }
  }
};
goog.debug.Logger.prototype.removeHandler = function(handler) {
  if (goog.debug.LOGGING_ENABLED) {
    var handlers = goog.debug.Logger.ENABLE_HIERARCHY ? this.handlers_ :
        goog.debug.Logger.rootHandlers_;
    return !!handlers && goog.array.remove(handlers, handler);
  } else {
    return false;
  }
};
goog.debug.Logger.prototype.getParent = function() {
  return this.parent_;
};
goog.debug.Logger.prototype.getChildren = function() {
  if (!this.children_) {
    this.children_ = {};
  }
  return this.children_;
};
goog.debug.Logger.prototype.setLevel = function(level) {
  if (goog.debug.LOGGING_ENABLED) {
    if (goog.debug.Logger.ENABLE_HIERARCHY) {
      this.level_ = level;
    } else {
      goog.asserts.assert(!this.name_,
          'Cannot call setLevel() on a non-root logger when ' +
          'goog.debug.Logger.ENABLE_HIERARCHY is false.');
      goog.debug.Logger.rootLevel_ = level;
    }
  }
};
goog.debug.Logger.prototype.getLevel = function() {
  return goog.debug.LOGGING_ENABLED ?
      this.level_ : goog.debug.Logger.Level.OFF;
};
goog.debug.Logger.prototype.getEffectiveLevel = function() {
  if (!goog.debug.LOGGING_ENABLED) {
    return goog.debug.Logger.Level.OFF;
  }
  if (!goog.debug.Logger.ENABLE_HIERARCHY) {
    return goog.debug.Logger.rootLevel_;
  }
  if (this.level_) {
    return this.level_;
  }
  if (this.parent_) {
    return this.parent_.getEffectiveLevel();
  }
  goog.asserts.fail('Root logger has no level set.');
  return null;
};
goog.debug.Logger.prototype.isLoggable = function(level) {
  return goog.debug.LOGGING_ENABLED &&
      level.value >= this.getEffectiveLevel().value;
};
goog.debug.Logger.prototype.log = function(level, msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED && this.isLoggable(level)) {
    if (goog.isFunction(msg)) {
      msg = msg();
    }
    this.doLogRecord_(this.getLogRecord(level, msg, opt_exception));
  }
};
goog.debug.Logger.prototype.getLogRecord = function(
    level, msg, opt_exception) {
  if (goog.debug.LogBuffer.isBufferingEnabled()) {
    var logRecord =
        goog.debug.LogBuffer.getInstance().addRecord(level, msg, this.name_);
  } else {
    logRecord = new goog.debug.LogRecord(level, String(msg), this.name_);
  }
  if (opt_exception) {
    logRecord.setException(opt_exception);
  }
  return logRecord;
};
goog.debug.Logger.prototype.shout = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.SHOUT, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.severe = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.SEVERE, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.warning = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.WARNING, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.info = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.INFO, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.config = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.CONFIG, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.fine = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.FINE, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.finer = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.FINER, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.finest = function(msg, opt_exception) {
  if (goog.debug.LOGGING_ENABLED) {
    this.log(goog.debug.Logger.Level.FINEST, msg, opt_exception);
  }
};
goog.debug.Logger.prototype.logRecord = function(logRecord) {
  if (goog.debug.LOGGING_ENABLED && this.isLoggable(logRecord.getLevel())) {
    this.doLogRecord_(logRecord);
  }
};
goog.debug.Logger.prototype.doLogRecord_ = function(logRecord) {
  goog.debug.Logger.logToProfilers('log:' + logRecord.getMessage());
  if (goog.debug.Logger.ENABLE_HIERARCHY) {
    var target = this;
    while (target) {
      target.callPublish_(logRecord);
      target = target.getParent();
    }
  } else {
    for (var i = 0, handler; handler = goog.debug.Logger.rootHandlers_[i++]; ) {
      handler(logRecord);
    }
  }
};
goog.debug.Logger.prototype.callPublish_ = function(logRecord) {
  if (this.handlers_) {
    for (var i = 0, handler; handler = this.handlers_[i]; i++) {
      handler(logRecord);
    }
  }
};
goog.debug.Logger.prototype.setParent_ = function(parent) {
  this.parent_ = parent;
};
goog.debug.Logger.prototype.addChild_ = function(name, logger) {
  this.getChildren()[name] = logger;
};
goog.debug.LogManager = {};
goog.debug.LogManager.loggers_ = {};
goog.debug.LogManager.rootLogger_ = null;
goog.debug.LogManager.initialize = function() {
  if (!goog.debug.LogManager.rootLogger_) {
    goog.debug.LogManager.rootLogger_ = new goog.debug.Logger(
        goog.debug.Logger.ROOT_LOGGER_NAME);
    goog.debug.LogManager.loggers_[goog.debug.Logger.ROOT_LOGGER_NAME] =
        goog.debug.LogManager.rootLogger_;
    goog.debug.LogManager.rootLogger_.setLevel(goog.debug.Logger.Level.CONFIG);
  }
};
goog.debug.LogManager.getLoggers = function() {
  return goog.debug.LogManager.loggers_;
};
goog.debug.LogManager.getRoot = function() {
  goog.debug.LogManager.initialize();
  return  (goog.debug.LogManager.rootLogger_);
};
goog.debug.LogManager.getLogger = function(name) {
  goog.debug.LogManager.initialize();
  var ret = goog.debug.LogManager.loggers_[name];
  return ret || goog.debug.LogManager.createLogger_(name);
};
goog.debug.LogManager.createFunctionForCatchErrors = function(opt_logger) {
  return function(info) {
    var logger = opt_logger || goog.debug.LogManager.getRoot();
    logger.severe('Error: ' + info.message + ' (' + info.fileName +
                  ' @ Line: ' + info.line + ')');
  };
};
goog.debug.LogManager.createLogger_ = function(name) {
  var logger = new goog.debug.Logger(name);
  if (goog.debug.Logger.ENABLE_HIERARCHY) {
    var lastDotIndex = name.lastIndexOf('.');
    var parentName = name.substr(0, lastDotIndex);
    var leafName = name.substr(lastDotIndex + 1);
    var parentLogger = goog.debug.LogManager.getLogger(parentName);
    parentLogger.addChild_(leafName, logger);
    logger.setParent_(parentLogger);
  }
  goog.debug.LogManager.loggers_[name] = logger;
  return logger;
};

// goog.log
// goog.log.Level
// goog.log.LogRecord
// goog.log.Logger
goog.provide('goog.log');
goog.provide('goog.log.Level');
goog.provide('goog.log.LogRecord');
goog.provide('goog.log.Logger');
goog.define('goog.log.ENABLED', goog.debug.LOGGING_ENABLED);
goog.log.ROOT_LOGGER_NAME = goog.debug.Logger.ROOT_LOGGER_NAME;
goog.log.Logger = goog.debug.Logger;
goog.log.Level = goog.debug.Logger.Level;
goog.log.LogRecord = goog.debug.LogRecord;
goog.log.getLogger = function(name, opt_level) {
  if (goog.log.ENABLED) {
    var logger = goog.debug.LogManager.getLogger(name);
    if (opt_level && logger) {
      logger.setLevel(opt_level);
    }
    return logger;
  } else {
    return null;
  }
};
goog.log.addHandler = function(logger, handler) {
  if (goog.log.ENABLED && logger) {
    logger.addHandler(handler);
  }
};
goog.log.removeHandler = function(logger, handler) {
  if (goog.log.ENABLED && logger) {
    return logger.removeHandler(handler);
  } else {
    return false;
  }
};
goog.log.log = function(logger, level, msg, opt_exception) {
  if (goog.log.ENABLED && logger) {
    logger.log(level, msg, opt_exception);
  }
};
goog.log.error = function(logger, msg, opt_exception) {
  if (goog.log.ENABLED && logger) {
    logger.severe(msg, opt_exception);
  }
};
goog.log.warning = function(logger, msg, opt_exception) {
  if (goog.log.ENABLED && logger) {
    logger.warning(msg, opt_exception);
  }
};
goog.log.info = function(logger, msg, opt_exception) {
  if (goog.log.ENABLED && logger) {
    logger.info(msg, opt_exception);
  }
};
goog.log.fine = function(logger, msg, opt_exception) {
  if (goog.log.ENABLED && logger) {
    logger.fine(msg, opt_exception);
  }
};

// i18n.input.hwt.CandidateSelectEvent
// i18n.input.hwt.CommitEvent
// i18n.input.hwt.EventType
goog.provide('i18n.input.hwt.CandidateSelectEvent');
goog.provide('i18n.input.hwt.CommitEvent');
goog.provide('i18n.input.hwt.EventType');
i18n.input.hwt.EventType = {
  BACKSPACE: goog.events.getUniqueId('b'),
  CANDIDATE_SELECT: goog.events.getUniqueId('cs'),
  COMMIT: goog.events.getUniqueId('c'),
  COMMIT_START: goog.events.getUniqueId('hcs'),
  COMMIT_END: goog.events.getUniqueId('hce'),
  RECOGNITION_READY: goog.events.getUniqueId('rr'),
  ENTER: goog.events.getUniqueId('e'),
  HANDWRITING_CLOSED: goog.events.getUniqueId('hc'),
  MOUSEUP: goog.events.getUniqueId('m'),
  SPACE: goog.events.getUniqueId('s')
};
i18n.input.hwt.CandidateSelectEvent = function(candidate) {
  i18n.input.hwt.CandidateSelectEvent.base(
      this, 'constructor', i18n.input.hwt.EventType.CANDIDATE_SELECT);
  this.candidate = candidate;
};
goog.inherits(i18n.input.hwt.CandidateSelectEvent, goog.events.Event);
i18n.input.hwt.CommitEvent = function(text, opt_back) {
  i18n.input.hwt.CommitEvent.base(this, 'constructor',
                                  i18n.input.hwt.EventType.COMMIT);
  this.text = text;
  this.back = opt_back || 0;
};
goog.inherits(i18n.input.hwt.CommitEvent, goog.events.Event);

// i18n.input.common.dom
goog.provide('i18n.input.common.dom');
i18n.input.common.dom.sameDomainIframes_ = {};
i18n.input.common.dom.setClasses = function(elem, classes) {
  if (elem) {
    for (var i = 0; i < classes.length; i++) {
      if (i == 0) {
        goog.dom.classlist.set(elem, classes[0]);
      } else {
        goog.dom.classlist.add(elem, classes[i]);
      }
    }
  }
};
i18n.input.common.dom.createIframeWrapper = function(opt_doc) {
  var doc = opt_doc || document;
  var dom = goog.dom.getDomHelper();
  var frame = dom.createDom(goog.dom.TagName.IFRAME, {
    'frameborder': '0',
    'scrolling': 'no',
    'style': 'background-color:transparent;border:0;display:none;'
  });
  dom.append( (doc.body), frame);
  var frameDoc = dom.getFrameContentDocument(frame);
  var css = i18n.input.common.GlobalSettings.alternativeImageUrl ?
      i18n.input.common.GlobalSettings.css.replace(
      /^(?:https?:)?\/\/ssl.gstatic.com\/inputtools\/images/g,
      i18n.input.common.GlobalSettings.alternativeImageUrl) :
      i18n.input.common.GlobalSettings.css;
  goog.style.installStyles(
      'html body{border:0;margin:0;padding:0} html,body{overflow:hidden}' +
      css, (frameDoc.body));
  return frame;
};
i18n.input.common.dom.iframeWrapperProperty_ = ['box-shadow', 'z-index',
  'margin', 'position', 'display'];
i18n.input.common.dom.copyNecessaryStyle = function(element, iframe) {
  goog.style.setContentBoxSize(iframe, goog.style.getSize(element));
  goog.array.forEach(i18n.input.common.dom.iframeWrapperProperty_,
      function(property) {
        goog.style.setStyle(iframe, property,
            goog.style.getComputedStyle(element, property));
      });
};

// i18n.input.hwt.util
goog.provide('i18n.input.hwt.util');
i18n.input.hwt.util.listenPageEvent = function(eventHandler, topDocument,
    eventType, callback) {
  eventHandler.listen(topDocument, goog.events.EventType.MOUSEUP,
      callback, true);
};
i18n.input.hwt.util.DEFAULT_CANDIDATE_MAP = {
  '': [',', '.', '?', '!', ':', '\'', '"', ';', '@'],
  'es': [',', '.', '¿', '?', '¡', '!', ':', '\'', '"'],
  'ja': ['，', '。', '？', '！', '：', '「', '」', '；'],
  'zh-Hans': ['，', '。', '？', '！', '：', '“', '”', '；'],
  'zh-Hant': ['，', '。', '？', '！', '：', '「', '」', '；']
};

// i18n.input.hwt.StrokeHandler
// i18n.input.hwt.StrokeHandler.Point
// i18n.input.hwt.StrokeHandler.StrokeEvent
goog.provide('i18n.input.hwt.StrokeHandler');
goog.provide('i18n.input.hwt.StrokeHandler.Point');
goog.provide('i18n.input.hwt.StrokeHandler.StrokeEvent');
i18n.input.hwt.StrokeHandler = function(canvas, topDocument) {
  i18n.input.hwt.StrokeHandler.base(this, 'constructor');
  this.eventHandler_ = new goog.events.EventHandler(this);
  this.drawing = false;
  this.canvas_ = canvas;
  this.eventHandler_.
      listen(canvas, goog.events.EventType.MOUSEDOWN, this.onStrokeStart_).
      listen(canvas, goog.events.EventType.MOUSEMOVE, this.onStroke_);
  if ('ontouchstart' in window) {
    this.eventHandler_.
        listen(canvas, goog.events.EventType.TOUCHSTART, this.onStrokeStart_).
        listen(canvas, goog.events.EventType.TOUCHEND, this.onStrokeEnd_).
        listen(canvas, goog.events.EventType.TOUCHCANCEL, this.onStrokeEnd_).
        listen(canvas, goog.events.EventType.TOUCHMOVE, this.onStroke_);
  }
  i18n.input.hwt.util.listenPageEvent(this.eventHandler_, topDocument,
      goog.events.EventType.MOUSEUP,
      goog.bind(this.onStrokeEnd_, this));
};
goog.inherits(i18n.input.hwt.StrokeHandler, goog.events.EventTarget);
i18n.input.hwt.StrokeHandler.prototype.onStrokeStart_ = function(e) {
  this.drawing = true;
  this.dispatchEvent(new i18n.input.hwt.StrokeHandler.StrokeEvent(
      i18n.input.hwt.StrokeHandler.EventType.STROKE_START,
      this.getPoint_(e)));
  e.preventDefault();
};
i18n.input.hwt.StrokeHandler.prototype.onStrokeEnd_ = function(e) {
  if (this.drawing) {
    this.drawing = false;
    this.dispatchEvent(new i18n.input.hwt.StrokeHandler.StrokeEvent(
        i18n.input.hwt.StrokeHandler.EventType.STROKE_END,
        this.getPoint_(e)));
    e.preventDefault();
  }
};
i18n.input.hwt.StrokeHandler.prototype.onStroke_ = function(e) {
  if (this.drawing) {
    this.dispatchEvent(new i18n.input.hwt.StrokeHandler.StrokeEvent(
        i18n.input.hwt.StrokeHandler.EventType.STROKE,
        this.getPoint_(e)));
  }
  e.preventDefault();
};
i18n.input.hwt.StrokeHandler.prototype.getPoint_ = function(e) {
  var pos = goog.style.getPageOffset(this.canvas_);
  var nativeEvent = e.getBrowserEvent();
  var scrollX = (document.dir == 'rtl' ? -1 : 1) * (
      document.body.scrollLeft ||
      document.documentElement.scrollLeft || 0);
  var scrollY = document.body.scrollTop ||
      document.documentElement.scrollTop || 0;
  var x, y;
  if (nativeEvent.touches != null && nativeEvent.touches.length > 0) {
    x = nativeEvent.touches[0].clientX + scrollX;
    y = nativeEvent.touches[0].clientY + scrollY;
  } else if (!goog.userAgent.IE && nativeEvent.pageX && nativeEvent.pageY) {
    x = nativeEvent.pageX;
    y = nativeEvent.pageY;
  } else {
    x = nativeEvent.clientX + scrollX;
    y = nativeEvent.clientY + scrollY;
  }
  return new i18n.input.hwt.StrokeHandler.Point(x - pos.x, y - pos.y,
      goog.now());
};
i18n.input.hwt.StrokeHandler.prototype.reset = function() {
  this.drawing = false;
};
i18n.input.hwt.StrokeHandler.prototype.disposeInternal = function() {
  goog.dispose(this.eventHandler_);
  this.eventHandler_ = null;
};
i18n.input.hwt.StrokeHandler.Point = function(x, y, time) {
  this.x = Math.round(x * 100.0) * 0.01;
  this.y = Math.round(y * 100.0) * 0.01;
  this.time = Math.round(time);
};
i18n.input.hwt.StrokeHandler.EventType = {
  STROKE: goog.events.getUniqueId('s'),
  STROKE_END: goog.events.getUniqueId('se'),
  STROKE_START: goog.events.getUniqueId('ss')
};
i18n.input.hwt.StrokeHandler.StrokeEvent = function(type, point) {
  i18n.input.hwt.StrokeHandler.StrokeEvent.base(this, 'constructor', type);
  this.point = point;
};
goog.inherits(i18n.input.hwt.StrokeHandler.StrokeEvent, goog.events.Event);

// i18n.input.hwt.css
goog.provide('i18n.input.hwt.css');
i18n.input.hwt.css = {
  RTL: goog.getCssName('ita-hwt-rtl'),
  LTR: goog.getCssName('ita-hwt-ltr'),
  IME: goog.getCssName('ita-hwt-ime'),
  IME_HOVER: goog.getCssName('ita-hwt-ime-hover'),
  IME_OPAQUE: goog.getCssName('ita-hwt-ime-opaque'),
  IME_ST: goog.getCssName('ita-hwt-ime-st'),
  IME_INIT_OPAQUE: goog.getCssName('ita-hwt-ime-init-opaque'),
  CLOSE: goog.getCssName('ita-hwt-close'),
  GRIP: goog.getCssName('ita-hwt-grip'),
  GRIP_HOVER: goog.getCssName('ita-hwt-grip-hover'),
  CANVAS: goog.getCssName('ita-hwt-canvas'),
  CANDIDATES: goog.getCssName('ita-hwt-candidates'),
  CANDIDATE: goog.getCssName('ita-hwt-candidate'),
  CANDIDATE_HOVER: goog.getCssName('ita-hwt-candidate-hover'),
  SELECTED: goog.getCssName('ita-hwt-selected'),
  DISABLED: goog.getCssName('ita-hwt-disabled'),
  BUTTONS: goog.getCssName('ita-hwt-buttons'),
  DIVIDER: goog.getCssName('ita-hwt-divider'),
  BUTTON: goog.getCssName('ita-hwt-button'),
  BACKSPACE: goog.getCssName('ita-hwt-backspace'),
  BACKSPACE_IMG: goog.getCssName('ita-hwt-backspace-img'),
  SPACE: goog.getCssName('ita-hwt-space'),
  ENTER: goog.getCssName('ita-hwt-enter'),
  ENTER_IMG: goog.getCssName('ita-hwt-enter-img'),
  ENTER_IMG_DARK: goog.getCssName('ita-hwt-enter-img-dark'),
  ENTER_IMG_WHITE: goog.getCssName('ita-hwt-enter-img-white'),
  LANGUAGE: goog.getCssName('ita-hwt-language'),
  CLEAR_TIME: goog.getCssName('ita-hwt-clear-time'),
  INSERT_TIME: goog.getCssName('ita-hwt-insert-time'),
  REMOTE_SPRITE: goog.getCssName('ita-kd-img'),
  MAXIMIZED: goog.getCssName('ita-hwt-ime-full'),
  JFK_BUTTON: goog.getCssName('ita-hwt-jfk'),
  JFK_STANDARD: goog.getCssName('ita-hwt-jfk-standard'),
  JFK_ACTION: goog.getCssName('ita-hwt-jfk-action'),
  JFK_HOVER: goog.getCssName('ita-hwt-jfk-hover'),
  BUTTER_BAR: goog.getCssName('ita-hwt-butterbar'),
  SHOWN: goog.getCssName('shown')
};

// i18n.input.hwt.Canvas
goog.provide('i18n.input.hwt.Canvas');
i18n.input.hwt.Canvas = function(opt_topDocument, opt_domHelper,
    opt_eventTarget, opt_inkWidth, opt_inkColor) {
  i18n.input.hwt.Canvas.base(this, 'constructor', undefined, undefined,
                             opt_domHelper);
  this.setParentEventTarget(opt_eventTarget || null);
  this.strokeHandler_;
  this.topDocument_ = opt_topDocument || document;
  this.writingCanvas_;
  this.writingContext_;
  this.strokeList = [];
  this.stroke_ = [];
  this.startTime_ = 0;
  this.handler_ = new goog.events.EventHandler(this);
  this.announcer_ = new goog.a11y.aria.Announcer(this.getDomHelper());
  this.inkWidth_ = opt_inkWidth || 6;
  this.inkColor_ = opt_inkColor || '#4D90FE';
};
goog.inherits(i18n.input.hwt.Canvas, goog.ui.Container);
i18n.input.hwt.Canvas.prototype.logger_ =
    goog.log.getLogger('i18n.input.hwt.Canvas');
i18n.input.hwt.Canvas.MSG_INPUTTOOLS_HWT_PANEL = goog.getMsg('panel');
i18n.input.hwt.Canvas.MSG_HANDWRITING_HINT = goog.getMsg('Draw a symbol here');
i18n.input.hwt.Canvas.prototype.createDom = function() {
  i18n.input.hwt.Canvas.base(this, 'createDom');
  var dom = this.getDomHelper();
  this.writingCanvas_ = dom.createDom(goog.dom.TagName.CANVAS,
      i18n.input.hwt.css.CANVAS);
  this.writingCanvas_.width = 425;
  this.writingCanvas_.height = 194;
  dom.appendChild(this.getElement(), this.writingCanvas_);
  this.writingContext_ = this.writingCanvas_.getContext('2d');
};
i18n.input.hwt.Canvas.prototype.enterDocument = function() {
  i18n.input.hwt.Canvas.base(this, 'enterDocument');
  this.setFocusable(false);
  this.setFocusableChildrenAllowed(false);
  this.strokeHandler_ = new i18n.input.hwt.StrokeHandler(this.writingCanvas_,
      this.topDocument_);
  this.handler_.
      listen(this.strokeHandler_,
          i18n.input.hwt.StrokeHandler.EventType.STROKE_START,
          this.onStrokeStart_).
      listen(this.strokeHandler_,
          i18n.input.hwt.StrokeHandler.EventType.STROKE,
          this.onStroke_).
      listen(this.strokeHandler_,
          i18n.input.hwt.StrokeHandler.EventType.STROKE_END,
          this.onStrokeEnd_).
      listen(this.writingCanvas_, goog.events.EventType.MOUSEOVER,
          this.onMouseOver_).
      listen(this.writingCanvas_, goog.events.EventType.MOUSEDOWN,
          goog.events.Event.stopPropagation);
};
i18n.input.hwt.Canvas.prototype.showHint = function() {
  this.writingContext_.font = '20px aria,sans-serif';
  this.writingContext_.fontWeight = 'bold';
  this.writingContext_.fillStyle = '#CCC';
  this.writingContext_.fillText(i18n.input.hwt.Canvas.MSG_HANDWRITING_HINT,
      30, 120);
};
i18n.input.hwt.Canvas.prototype.drawPoint_ = function(color, point) {
  this.writingContext_.beginPath();
  this.writingContext_.strokeStyle = color;
  this.writingContext_.fillStyle = color;
  this.writingContext_.arc(point.x, point.y,
      this.inkWidth_ / 2, 0, Math.PI * 2, true);
  this.writingContext_.fill();
};
i18n.input.hwt.Canvas.prototype.drawLine_ = function(color, points, opt_start) {
  var start = opt_start || 0;
  if (start == (points.length - 1)) {
    this.drawPoint_(color, points[0]);
  } else {
    this.writingContext_.beginPath();
    this.writingContext_.strokeStyle = color;
    this.writingContext_.fillStyle = 'none';
    this.writingContext_.lineWidth = this.inkWidth_;
    this.writingContext_.lineCap = 'round';
    this.writingContext_.lineJoin = 'round';
    this.writingContext_.moveTo(points[start].x, points[start].y);
    for (var i = start + 1; i < points.length; i++) {
      this.writingContext_.lineTo(points[i].x, points[i].y);
    }
    this.writingContext_.stroke();
  }
};
i18n.input.hwt.Canvas.prototype.addPoint_ = function(point) {
  point.time -= this.startTime_;
  this.stroke_.push(point);
  var len = this.stroke_.length;
  var start = Math.max(len - 2, 0);
  this.drawLine_(this.inkColor_, this.stroke_, start);
};
i18n.input.hwt.Canvas.prototype.onStrokeStart_ = function(e) {
  this.stroke_ = [];
  var point = e.point;
  if (this.strokeList.length == 0) {
    this.startTime_ = point.time;
  }
  this.addPoint_(e.point);
  e.preventDefault();
  goog.dom.classlist.add(this.getElement(), i18n.input.hwt.css.IME_INIT_OPAQUE);
};
i18n.input.hwt.Canvas.prototype.onStroke_ = function(e) {
  this.addPoint_(e.point);
  e.preventDefault();
};
i18n.input.hwt.Canvas.prototype.onStrokeEnd_ = function(e) {
  this.strokeList.push(this.stroke_);
  e.preventDefault();
  this.dispatchEvent(new goog.events.Event(
      i18n.input.hwt.EventType.RECOGNITION_READY));
};
i18n.input.hwt.Canvas.prototype.reset = function() {
  goog.log.info(this.logger_, 'clear ' + this.writingCanvas_.width + 'x' +
      this.writingCanvas_.height);
  this.writingContext_.clearRect(
      0, 0, this.writingCanvas_.width, this.writingCanvas_.height);
  this.strokeList = [];
  this.stroke_ = [];
  this.strokeHandler_.reset();
};
i18n.input.hwt.Canvas.prototype.disposeInternal = function() {
  goog.dispose(this.handler_);
  i18n.input.hwt.Canvas.base(this, 'disposeInternal');
};
i18n.input.hwt.Canvas.prototype.getWidth = function() {
  return this.writingCanvas_.width;
};
i18n.input.hwt.Canvas.prototype.getHeight = function() {
  return this.writingCanvas_.height;
};
i18n.input.hwt.Canvas.prototype.isDrawing = function() {
  return this.strokeHandler_.drawing;
};
i18n.input.hwt.Canvas.prototype.isClean = function() {
  return !this.strokeHandler_.drawing && this.strokeList.length == 0;
};
i18n.input.hwt.Canvas.prototype.setSize = function(opt_height, opt_width) {
  if (opt_height && this.writingCanvas_.height != opt_height ||
      opt_width && this.writingCanvas_.width != opt_width) {
    this.reset();
  }
  if (opt_height) {
    this.writingCanvas_.height = opt_height;
  }
  if (opt_width) {
    this.writingCanvas_.width = opt_width;
  }
};
i18n.input.hwt.Canvas.prototype.getStrokeHandler = function() {
  return this.strokeHandler_;
};
i18n.input.hwt.Canvas.prototype.onMouseOver_ = function(e) {
  this.announcer_.say(i18n.input.hwt.Canvas.MSG_INPUTTOOLS_HWT_PANEL,
      goog.a11y.aria.LivePriority.ASSERTIVE);
};

// i18n.input.chrome.inputview.ConditionName
goog.provide('i18n.input.chrome.inputview.ConditionName');
i18n.input.chrome.inputview.ConditionName = {
  SHOW_COMPACT_LAYOUT_SWITCHER: 'showCompactLayoutSwitcher',
  SHOW_ALTGR: 'showAltGr',
  SHOW_HANDWRITING_SWITCHER: 'showHandwritingSwitcher',
  SHOW_MENU: 'showMenu',
  SHOW_GLOBE_OR_SYMBOL: 'showGlobeOrSymbol',
  SHOW_EN_SWITCHER_KEY: 'showEnSwitcherKey'
};

// i18n.input.chrome.inputview.Css
goog.provide('i18n.input.chrome.inputview.Css');
i18n.input.chrome.inputview.Css = {
  A11Y: goog.getCssName('inputview-a11y'),
  ACCENT_COMPACT_FONT: goog.getCssName('inputview-compact-font'),
  ACCENT_CONTAINER: goog.getCssName('inputview-accent-container'),
  ACCENT_FULL_FONT: goog.getCssName('inputview-full-font'),
  ACCENT_ROW: goog.getCssName('inputview-accent-row'),
  ACCENT_EMPTY_KEY: goog.getCssName('inputview-accent-empty-key'),
  ACCENT_KEY: goog.getCssName('inputview-accent-key'),
  ALTDATA_COVER: goog.getCssName('inputview-altdata-cover'),
  ALTDATA_KEY: goog.getCssName('inputview-altdata-key'),
  ALTDATA_SEPARATOR: goog.getCssName('inputview-altdata-separator'),
  ALTDATA_VIEW: goog.getCssName('inputview-altdata-view'),
  ALTGR_CONTENT: goog.getCssName('inputview-ac'),
  ARROW_KEY: goog.getCssName('inputview-arrow-key'),
  BACKSPACE_ICON: goog.getCssName('inputview-backspace-icon'),
  BACK_TO_KEYBOARD_ICON: goog.getCssName('inputview-back-to-keyboard'),
  BOLD_ICON: goog.getCssName('inputview-bold-icon'),
  CANDIDATE: goog.getCssName('inputview-candidate'),
  CANDIDATE_NUMBER: goog.getCssName('inputview-candidate-number'),
  CANDIDATES_LINE: goog.getCssName('inputview-candidates-line'),
  CANDIDATES_TOP_LINE: goog.getCssName('inputview-candidates-top-line'),
  CANDIDATE_AUTOCORRECT: goog.getCssName('inputview-candidate-autocorrect'),
  CANDIDATE_BUTTON: goog.getCssName('inputview-candidate-button'),
  CANDIDATE_DEFAULT: goog.getCssName('inputview-candidate-default'),
  CANDIDATE_HIGHLIGHT: goog.getCssName('inputview-candidate-highlight'),
  CANDIDATE_INTER_CONTAINER: goog.getCssName('inputview-candidate-ic'),
  CANDIDATE_INTERNAL_WRAPPER: goog.getCssName(
      'inputview-candidate-internal-wrapper'),
  CANDIDATE_SEPARATOR: goog.getCssName('inputview-candidate-separator'),
  CANDIDATE_VIEW: goog.getCssName('inputview-candidate-view'),
  CANVAS: goog.getCssName('inputview-canvas'),
  CANVAS_LEFT_COLUMN: goog.getCssName('inputview-canvas-left-column'),
  CANVAS_RIGHT_COLUMN: goog.getCssName('inputview-canvas-right-column'),
  CANVAS_VIEW: goog.getCssName('inputview-canvasview'),
  CAPSLOCK_DOT: goog.getCssName('inputview-capslock-dot'),
  CAPSLOCK_DOT_HIGHLIGHT: goog.getCssName('inputview-capslock-dot-highlight'),
  CHARACTER: goog.getCssName('inputview-character'),
  CHARACTER_HIGHLIGHT: goog.getCssName('inputview-ch'),
  CHECKED_MENU_LIST: goog.getCssName('inputview-checked-menu-list'),
  COMPACT_KEY: goog.getCssName('inputview-compact-key'),
  COMPACT_SWITCHER: goog.getCssName('inputview-compact-switcher'),
  COPY_ICON: goog.getCssName('inputview-copy-icon'),
  CUT_ICON: goog.getCssName('inputview-cut-icon'),
  CONTAINER: goog.getCssName('inputview-container'),
  DEFAULT_CONTENT: goog.getCssName('inputview-dc'),
  DELETION_TRACK: goog.getCssName('inputview-deletion-track'),
  DIGIT_CHARACTER: goog.getCssName('inputview-digit-character'),
  DOWN_KEY: goog.getCssName('inputview-down-key'),
  DRAG_BUTTON: goog.getCssName('inputview-drag-button'),
  DRAWING_CANVAS: goog.getCssName('inputview-drawing-canvas'),
  ELEMENT_HIGHLIGHT: goog.getCssName('inputview-element-highlight'),
  EMOJI: goog.getCssName('inputview-emoji'),
  EMOJI_BACK: goog.getCssName('inputview-emoji-back'),
  EMOJI_FONT: goog.getCssName('inputview-emoji-font'),
  EMOJI_KEY: goog.getCssName('inputview-emoji-key'),
  EMOJI_SWITCH: goog.getCssName('inputview-emoji-switch'),
  EMOJI_TABBAR_PLACES_OF_INTERESTS:
      goog.getCssName('inputview-emoji-switch-poi'),
  EMOJI_TABBAR_EMOTION:
      goog.getCssName('inputview-emoji-switch-emotion'),
  EMOJI_TABBAR_EMOTICON:
      goog.getCssName('inputview-emoji-switch-emoticon'),
  EMOJI_TABBAR_HOT:
      goog.getCssName('inputview-emoji-switch-hot'),
  EMOJI_TABBAR_NATURE:
      goog.getCssName('inputview-emoji-switch-nature'),
  EMOJI_SWITCH_HIGHLIGHT:
      goog.getCssName('inputview-emoji-switch-highlight'),
  EMOJI_TABBAR_RECENT:
      goog.getCssName('inputview-emoji-switch-recent'),
  EMOJI_TABBAR_SPECIAL_CHARACTERS:
      goog.getCssName('inputview-emoji-switch-special-characters'),
  EMOJI_TABBAR_ITEMS:
      goog.getCssName('inputview-emoji-switch-items'),
  EMOJI_TABBAR_KEY: goog.getCssName('inputview-emoji-tabbar-key'),
  EMOJI_TABBAR_KEY_HIGHLIGHT:
      goog.getCssName('inputview-emoji-tabbar-key-highlight'),
  EMOJI_TABBAR_SK: goog.getCssName('inputview-emoji-tabbar-sk'),
  EMOTICON: goog.getCssName('inputview-emoticon'),
  ENTER_ICON: goog.getCssName('inputview-enter-icon'),
  EN_SWITCHER_DEFAULT: goog.getCssName('inputview-en-switcher-default'),
  EN_SWITCHER_ENGLISH: goog.getCssName('inputview-en-switcher-english'),
  EXPAND_CANDIDATES_ICON: goog.getCssName('inputview-expand-candidates-icon'),
  EXTENDED_LAYOUT_TRANSITION: goog.getCssName('inputview-extended-transition'),
  FLOAT_LEFT: goog.getCssName('float-left'),
  FLOATING_COVER: goog.getCssName('inputview-floating-cover'),
  FONT: goog.getCssName('inputview-font'),
  FONT_SMALL: goog.getCssName('inputview-font-small'),
  FUNCITONAL_KEY_STICKY: goog.getCssName('inputview-functional-key-sticky'),
  GESTURE_CANVAS_VIEW: goog.getCssName('inputview-gesture-canvas-view'),
  GESTURE_EDITING_FINGER_TRACKER:
      goog.getCssName('inputview-gesture-editing-finger-tracker'),
  GESTURE_PREVIEW_CONTAINER:
      goog.getCssName('inputview-gesture-preview-container'),
  GESTURE_PREVIEW_TEXT:
      goog.getCssName('inputview-gesture-preview-text'),
  GESTURE_RIPPLE: goog.getCssName('inputview-gesture-ripple'),
  GLOBE_ICON: goog.getCssName('inputview-globe-icon'),
  HANDWRITING: goog.getCssName('inputview-handwriting'),
  HANDWRITING_BACK: goog.getCssName('inputview-handwriting-back'),
  HANDWRITING_GOT_IT: goog.getCssName('inputview-handwriting-got-it'),
  HANDWRITING_LAYOUT: goog.getCssName('inputview-handwriting-layout'),
  HANDWRITING_NETWORK_ERROR:
      goog.getCssName('inputview-handwriting-network-error'),
  HANDWRITING_SWITCHER: goog.getCssName('inputview-handwriting-switcher'),
  HANDWRITING_PRIVACY_COVER:
      goog.getCssName('inputview-handwriting-privacy-cover'),
  HANDWRITING_PRIVACY_INFO:
      goog.getCssName('inputview-handwriting-privacy-info'),
  HANDWRITING_PRIVACY_INFO_HIDDEN:
      goog.getCssName('inputview-handwriting-privacy-info-hidden'),
  HIDE_KEYBOARD_ICON: goog.getCssName('inputview-hide-keyboard-icon'),
  HINT_TEXT: goog.getCssName('inputview-hint-text'),
  HOLD: goog.getCssName('inputview-hold'),
  IME_LIST_CONTAINER: goog.getCssName('inputview-ime-list-container'),
  INDICATOR: goog.getCssName('inputview-indicator'),
  INDICATOR_BACKGROUND: goog.getCssName('inputview-indicator-background'),
  INLINE_DIV: goog.getCssName('inputview-inline-div'),
  ITALICS_ICON: goog.getCssName('inputview-italics-icon'),
  JP_IME_SWITCH: goog.getCssName('inputview-jp-ime-switch'),
  KEY_HOLD: goog.getCssName('inputview-key-hold'),
  LANDSCAPE: goog.getCssName('inputview-landscape'),
  LAYOUT_VIEW: goog.getCssName('inputview-layoutview'),
  LEFT_KEY: goog.getCssName('inputview-left-key'),
  LEFT_TO_RIGHT: goog.getCssName('inputview-ltr'),
  LINEAR_LAYOUT: goog.getCssName('inputview-linear'),
  LINEAR_LAYOUT_BORDER: goog.getCssName('inputview-linear-border'),
  MENU_LIST_CHECK_MARK: goog.getCssName('inputview-menu-list-check-mark'),
  MENU_FOOTER: goog.getCssName('inputview-menu-footer'),
  MENU_FOOTER_EMOJI_BUTTON:
      goog.getCssName('inputview-menu-footer-emoji-button'),
  MENU_FOOTER_HANDWRITING_BUTTON:
      goog.getCssName('inputview-menu-footer-handwriting-button'),
  MENU_FOOTER_ITEM: goog.getCssName('inputview-menu-footer-item'),
  MENU_FOOTER_SETTING_BUTTON:
      goog.getCssName('inputview-menu-footer-setting-button'),
  MENU_ICON: goog.getCssName('inputview-menu-icon'),
  MENU_LIST_INDICATOR: goog.getCssName('inputview-menu-list-indicator'),
  MENU_LIST_INDICATOR_NAME:
      goog.getCssName('inputview-menu-list-indicator-name'),
  MENU_LIST_ITEM: goog.getCssName('inputview-menu-list-item'),
  MENU_LIST_NAME: goog.getCssName('inputview-menu-list-name'),
  MENU_VIEW: goog.getCssName('inputview-menu-view'),
  MODIFIER: goog.getCssName('inputview-modifier'),
  MODIFIER_ON: goog.getCssName('inputview-modifier-on'),
  MODIFIER_STATE_ICON: goog.getCssName('inputview-modifier-state-icon'),
  NUMERIC_LAYOUT: goog.getCssName('inputview-numeric'),
  PAGE_DOWN_ICON: goog.getCssName('inputview-page-down-icon'),
  PAGE_UP_ICON: goog.getCssName('inputview-page-up-icon'),
  PAGE_NAVI_INACTIVE: goog.getCssName('inputview-page-navi-inactive'),
  PASTE_ICON: goog.getCssName('inputview-paste-icon'),
  PINYIN: goog.getCssName('inputview-pinyin'),
  PORTRAIT: goog.getCssName('inputview-portrait'),
  REDO_ICON: goog.getCssName('inputview-redo-icon'),
  REGULAR_SWITCHER: goog.getCssName('inputview-regular-switcher'),
  RIGHT_KEY: goog.getCssName('inputview-right-key'),
  SELECT_ALL_ICON: goog.getCssName('inputview-select-all-icon'),
  SELECT_KNOB_LEFT: goog.getCssName('inputview-select-knob-left'),
  SELECT_KNOB_RIGHT: goog.getCssName('inputview-select-knob-right'),
  SELECTION_TRACK: goog.getCssName('inputview-selection-track'),
  SHIFT_ICON: goog.getCssName('inputview-shift-icon'),
  SHRINK_CANDIDATES_ICON: goog.getCssName('inputview-shrink-candidates-icon'),
  SOFT_KEY: goog.getCssName('inputview-sk'),
  SOFT_KEY_VIEW: goog.getCssName('inputview-skv'),
  SPACE_ICON: goog.getCssName('inputview-space-icon'),
  SPACE_WRAPPER: goog.getCssName('inputview-space-wrapper'),
  SPACE_GREY_BG: goog.getCssName('inputview-space-grey-bg'),
  SPECIAL_KEY_BG: goog.getCssName('inputview-special-key-bg'),
  SPECIAL_KEY_HIGHLIGHT: goog.getCssName('inputview-special-key-highlight'),
  SPECIAL_KEY_DISABLE_BG_HIGHLIGHT: goog.getCssName(
      'inputview-special-key-disable-bg-hl'),
  SPECIAL_KEY_NAME: goog.getCssName('inputview-special-key-name'),
  SWIPE_ACTIVE: goog.getCssName('inputview-swipe-active'),
  SWIPE_KEY: goog.getCssName('inputview-swipe-key'),
  SWIPE_PIECE: goog.getCssName('inputview-swipe-piece'),
  SWIPE_SEPARATOR: goog.getCssName('inputview-swipe-separator'),
  SWIPE_VIEW: goog.getCssName('inputview-swipe-view'),
  SWITCHER_CHINESE: goog.getCssName('inputview-switcher-chinese'),
  SWITCHER_ENGLISH: goog.getCssName('inputview-switcher-english'),
  SWITCHER_KEY_NAME: goog.getCssName('inputview-switcher-key-name'),
  TABLE_CELL: goog.getCssName('inputview-table-cell'),
  TAB_ICON: goog.getCssName('inputview-tab-icon'),
  THREE_CANDIDATES: goog.getCssName('inputview-three-candidates'),
  TITLE: goog.getCssName('inputview-title'),
  TITLE_BAR: goog.getCssName('inputview-title-bar'),
  TOOLBAR_SEPARATOR: goog.getCssName('inputview-toolbar-separator'),
  TOOLBAR_BUTTON: goog.getCssName('inputview-toolbar-button'),
  TOOLBAR_CONTAINER: goog.getCssName('inputview-toolbar-container'),
  TOOLTIP: goog.getCssName('inputview-candidate-tooltip'),
  TRACK_COVER: goog.getCssName('inputview-track-cover'),
  UNDERLINE_ICON: goog.getCssName('inputview-underline-icon'),
  UNDO_ICON: goog.getCssName('inputview-undo-icon'),
  UP_KEY: goog.getCssName('inputview-up-key'),
  VERTICAL_LAYOUT: goog.getCssName('inputview-vertical'),
  VIEW: goog.getCssName('inputview-view'),
  VOICE_BOLD: goog.getCssName('inputview-voice-bold'),
  VOICE_BUTTON: goog.getCssName('inputview-voice-btn'),
  VOICE_CANDIDATES: goog.getCssName('inputview-voice-candidates'),
  VOICE_DELETE_BTN: goog.getCssName('inputview-voice-delete-btn'),
  VOICE_HIGHLIGHT: goog.getCssName('inputview-voice-highlight'),
  VOICE_LEVEL: goog.getCssName('inputview-voice-level'),
  VOICE_LINK: goog.getCssName('inputview-voice-link'),
  VOICE_MASK: goog.getCssName('inputview-voice-mask'),
  VOICE_MASK_OPACITY: goog.getCssName('inputview-voice-mask-opacity'),
  VOICE_MIC_BAR: goog.getCssName('inputview-voice-mic-bar'),
  VOICE_MENU: goog.getCssName('inputview-voice-menu'),
  VOICE_MENUITEM: goog.getCssName('inputview-voice-menuitem'),
  VOICE_MIC_ING: goog.getCssName('inputview-voice-mic-ing'),
  VOICE_MIC_OFF: goog.getCssName('inputview-voice-mic-off'),
  VOICE_MIC_ON: goog.getCssName('inputview-voice-mic-on'),
  VOICE_OPACITY: goog.getCssName('inputview-voice-opacity'),
  VOICE_OPACITY_NONE: goog.getCssName('inputview-voice-opacity-none'),
  VOICE_PANEL: goog.getCssName('inputview-voice-panel'),
  VOICE_PRIVACY_INFO: goog.getCssName('inputview-voice-privacy-info'),
  VOICE_GOT_IT: goog.getCssName('inputview-voice-got-it'),
  VOICE_SEPARATOR: goog.getCssName('inputview-voice-separator'),
  VOICE_VIEW: goog.getCssName('inputview-voice-view'),
  WRAPPER: goog.getCssName('inputview-wrapper')
};

// i18n.input.chrome.inputview.MoreKeysShiftOperation
goog.provide('i18n.input.chrome.inputview.MoreKeysShiftOperation');
i18n.input.chrome.inputview.MoreKeysShiftOperation = {
  STABLE: 0,
  TO_UPPER_CASE: 1,
  TO_LOWER_CASE: 2
};

// i18n.input.chrome.inputview.content.Constants
goog.provide('i18n.input.chrome.inputview.content.Constants');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.content.Constants.NON_LETTER_KEYS = {
  BACKSPACE: {
    'iconCssClass': i18n.input.chrome.inputview.Css.BACKSPACE_ICON,
    'type': ElementType.BACKSPACE_KEY,
    'id': 'Backspace'
  },
  ENTER: {
    'iconCssClass': i18n.input.chrome.inputview.Css.ENTER_ICON,
    'type': ElementType.ENTER_KEY,
    'id': 'Enter'
  },
  HIDE: {
    'iconCssClass': i18n.input.chrome.inputview.Css.HIDE_KEYBOARD_ICON,
    'type': ElementType.HIDE_KEYBOARD_KEY,
    'id': 'HideKeyboard'
  },
  LEFT_SHIFT: {
    'toState': i18n.input.chrome.inputview.StateType.SHIFT,
    'iconCssClass': i18n.input.chrome.inputview.Css.SHIFT_ICON,
    'type': ElementType.MODIFIER_KEY,
    'id': 'ShiftLeft',
    'supportSticky': true
  },
  RIGHT_SHIFT: {
    'toState': i18n.input.chrome.inputview.StateType.SHIFT,
    'iconCssClass': i18n.input.chrome.inputview.Css.SHIFT_ICON,
    'type': ElementType.MODIFIER_KEY,
    'id': 'ShiftRight',
    'supportSticky': true
  },
  SPACE: {
    'name': ' ',
    'type': ElementType.SPACE_KEY,
    'id': 'Space'
  },
  SWITCHER: {
    'type': ElementType.SWITCHER_KEY
  },
  MENU: {
    'iconCssClass': i18n.input.chrome.inputview.Css.MENU_ICON,
    'type': ElementType.MENU_KEY,
    'id': 'Menu'
  },
  GLOBE: {
    'iconCssClass': i18n.input.chrome.inputview.Css.GLOBE_ICON,
    'type': ElementType.GLOBE_KEY,
    'id': 'Globe'
  },
  HOTROD_SWITCHER: {
    'iconCssClass': i18n.input.chrome.inputview.Css.BACK_TO_KEYBOARD_ICON,
    'type': ElementType.HOTROD_SWITCHER_KEY,
    'id': 'HotrodSwitch'
  }
};
i18n.input.chrome.inputview.content.Constants.HINT_TEXT_PLACE_HOLDER =
    '%hinttext%';
});  // goog.scope

// i18n.input.chrome.inputview.content.compact.letter
goog.provide('i18n.input.chrome.inputview.content.compact.letter');
goog.scope(function() {
var NON_LETTER_KEYS =
    i18n.input.chrome.inputview.content.Constants.NON_LETTER_KEYS;
var HINT_TEXT_PLACE_HOLDER =
    i18n.input.chrome.inputview.content.Constants.HINT_TEXT_PLACE_HOLDER;
var MoreKeysShiftOperation = i18n.input.chrome.inputview.MoreKeysShiftOperation;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.content.compact.letter.keyQwertyCharacters =
    function() {
  return [
     { 'text': 'q', 'hintText': '1' },
     { 'text': 'w', 'hintText': '2' },
     { 'text': 'e', 'hintText': '3',
      'moreKeys': {
        'characters': ['\u00E9', '\u00E8', '\u00EA', '\u00EB', '\u0113']}},
     { 'text': 'r', 'hintText': '4' },
     { 'text': 't', 'hintText': '5' },
     { 'text': 'y', 'hintText': '6' },
     { 'text': 'u', 'hintText': '7',
      'moreKeys': {
        'characters': ['\u00FA', '\u00FB', '\u00FC', '\u00F9', '\u016B']}},
     { 'text': 'i', 'hintText': '8',
      'moreKeys': {
        'characters': ['\u00ED', '\u00EE', '\u00EF', '\u012B', '\u00EC']}},
     { 'text': 'o', 'hintText': '9',
      'moreKeys': {
        'characters': ['\u00F3', '\u00F4', '\u00F6', '\u00F2', '\u0153',
          '\u00F8', '\u014D', '\u00F5']}},
     { 'text': 'p', 'hintText': '0' },
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': 'a', 'marginLeftPercent': 0.33,
      'moreKeys': {
        'characters': ['\u00E0', '\u00E1', '\u00E2', '\u00E4', '\u00E6',
          '\u00E3', '\u00E5', '\u0101']}},
     { 'text': 's',
      'moreKeys': {'characters': ['\u00DF']}},
     { 'text': 'd' },
     { 'text': 'f' },
     { 'text': 'g' },
     { 'text': 'h' },
     { 'text': 'j' },
     { 'text': 'k' },
     { 'text': 'l' },
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.LEFT_SHIFT,
     { 'text': 'z' },
     { 'text': 'x' },
     { 'text': 'c',
      'moreKeys': {'characters': ['\u00E7']}},
     { 'text': 'v' },
     { 'text': 'b' },
     { 'text': 'n',
      'moreKeys': {'characters': ['\u00F1']}},
     { 'text': 'm' },
     { 'text': '!',
      'moreKeys': {'characters': ['\u00A1']}},
     { 'text': '?',
      'moreKeys': {'characters': ['\u00BF']}},
     NON_LETTER_KEYS.RIGHT_SHIFT,
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.GLOBE,
     NON_LETTER_KEYS.MENU,
     { 'text': '/', 'isGrey': true, 'onContext':
          { 'email' : { 'text' : '@' }}},
     NON_LETTER_KEYS.SPACE,
     { 'text': ',', 'isGrey': true, 'onContext':
          { 'email' : {'text' : '.com', 'textCssClass' : Css.FONT_SMALL,
              'moreKeys': {'characters': ['.net', '.org']}},
          'url' : {'text' : '.com', 'textCssClass' : Css.FONT_SMALL,
              'moreKeys': {'characters': ['.net', '.org']}}}},
     { 'text': '.', 'isGrey': true,
      'moreKeys': {
        'characters': [',', '\'', '#', ')', '(', '/', ';', '@', ':',
          '-', '"', '+', '%', '&'],
        'fixedColumnNumber': 7}},
     NON_LETTER_KEYS.HIDE
  ];
};
i18n.input.chrome.inputview.content.compact.letter.keyNederlandCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyQwertyCharacters();
  data[2]['moreKeys'] = {'characters': ['\u00E9', '\u00EB', '\u00EA', '\u00E8',
    '\u0119', '\u0117', '\u0113']};  // e
  data[5]['moreKeys'] = {'characters': ['\u0133']};  // y
  data[6]['moreKeys'] = {'characters':
        ['\u00FA', '\u00FC', '\u00FB', '\u00F9', '\u016B']};  // u
  data[7]['moreKeys'] = {'characters': ['\u00ED', '\u00EF', '\u00EC', '\u00EE',
    '\u012F', '\u012B', '\u0133']};  // i
  data[8]['moreKeys'] = {'characters': ['\u00F3', '\u00F6', '\u00F4', '\u00F2',
    '\u00F5', '\u0153', '\u00F8', '\u014D']};  // o
  data[11]['moreKeys'] = {'characters': ['\u00E1', '\u00E4', '\u00E2', '\u00E0',
    '\u00E6', '\u00E3', '\u00E5', '\u0101']}; // a
  data[12]['moreKeys'] = undefined;  // s
  data[24]['moreKeys'] = undefined;  // c
  data[27]['moreKeys'] = {'characters': ['\u00F1', '\u0144']};  // n
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyIcelandicCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyQwertyCharacters();
  data[2]['moreKeys'] = {'characters': ['\u00E9', '\u00EB', '\u00E8', '\u00EA',
    '\u0119', '\u0117', '\u0113']};  // e
  data[4]['moreKeys'] = {'characters': ['\u00FE']};  // t
  data[5]['moreKeys'] = {'characters': ['\u00FD', '\u00FF']}; // y
  data[6]['moreKeys'] = {'characters':
        ['\u00FA', '\u00FC', '\u00FB', '\u00F9', '\u016B']};  // u
  data[7]['moreKeys'] = {'characters':
        ['\u00ED', '\u00EF', '\u00EE', '\u00EC', '\u012F', '\u012B']};  // i
  data[8]['moreKeys'] = {'characters': ['\u00F3', '\u00F6', '\u00F4', '\u00F2',
    '\u00F5', '\u0153', '\u00F8', '\u014D']};  // o
  data[11]['moreKeys'] = {'characters': ['\u00E1', '\u00E4', '\u00E6', '\u00E5',
    '\u00E0', '\u00E2', '\u00E3', '\u0101']}; // a
  data[12]['moreKeys'] = undefined;  // s
  data[13]['moreKeys'] = {'characters': ['\u00F0']};  // d
  data[24]['moreKeys'] = undefined;  // c
  data[27]['moreKeys'] = undefined;  // n
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyQwertzCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyQwertyCharacters();
  data[2]['moreKeys'] = {'characters':
        ['\u00E9', '\u00E8', '\u00EA', '\u00EB', '\u0117']};  // e
  data[6]['moreKeys'] = {
    'characters': ['\u00FC', HINT_TEXT_PLACE_HOLDER, '\u00FB', '\u00F9',
      '\u00FA', '\u016B']};  // u
  data[7]['moreKeys'] = undefined;  // i
  data[8]['moreKeys'] = {
    'characters': ['\u00F6', HINT_TEXT_PLACE_HOLDER, '\u00F4', '\u00F2',
      '\u00F3', '\u00F5', '\u0153', '\u00F8', '\u014D']};  // o
  data[11]['moreKeys'] = {
    'characters': ['\u00E4', HINT_TEXT_PLACE_HOLDER, '\u00E2', '\u00E0',
      '\u00E1', '\u00E6', '\u00E3', '\u00E5', '\u0101']}; // a
  data[12]['moreKeys'] = {'characters': ['\u00DF', '\u015B', '\u0161']};  // s
  data[24]['moreKeys'] = undefined;  // c
  data[27]['moreKeys'] = {'characters': ['\u00F1', '\u0144']};
  data[5].text = 'z';
  data[22].text = 'y';
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyAzertyCharacters =
    function() {
  return [
     { 'text': 'a', 'hintText': '1',
      'moreKeys': {
        'characters': ['\u00E0', '\u00E2', HINT_TEXT_PLACE_HOLDER, '\u00E6',
          '\u00E1', '\u00E4', '\u00E3', '\u00E5', '\u0101', '\u00AA']}},
     { 'text': 'z', 'hintText': '2' },
     { 'text': 'e', 'hintText': '3',
      'moreKeys': {
        'characters': ['\u00E9', '\u00E8', '\u00EA', '\u00EB',
          HINT_TEXT_PLACE_HOLDER, '\u0119', '\u0117', '\u0113']}},
     { 'text': 'r', 'hintText': '4' },
     { 'text': 't', 'hintText': '5' },
     { 'text': 'y', 'hintText': '6',
      'moreKeys': {'characters': ['\u00FF']}},
     { 'text': 'u', 'hintText': '7',
      'moreKeys': {
        'characters': ['\u00F9', '\u00FB', HINT_TEXT_PLACE_HOLDER, '\u00FC',
          '\u00FA', '\u016B']}},
     { 'text': 'i', 'hintText': '8',
      'moreKeys': {
        'characters': ['\u00EE', HINT_TEXT_PLACE_HOLDER, '\u00EF', '\u00EC',
          '\u00ED', '\u012F', '\u012B']}},
     { 'text': 'o', 'hintText': '9',
      'moreKeys': {
        'characters': ['\u00F4', '\u0153', HINT_TEXT_PLACE_HOLDER, '\u00F6',
          '\u00F2', '\u00F3', '\u00F5', '\u00F8', '\u014D', '\u00BA']}},
     { 'text': 'p', 'hintText': '0' },
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': 'q' },
     { 'text': 's' },
     { 'text': 'd' },
     { 'text': 'f' },
     { 'text': 'g' },
     { 'text': 'h' },
     { 'text': 'j' },
     { 'text': 'k' },
     { 'text': 'l' },
     { 'text': 'm' },
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.LEFT_SHIFT,
     { 'text': 'w' },
     { 'text': 'x' },
     { 'text': 'c',
      'moreKeys': {
        'characters': ['\u00E7', '\u0107', '\u010D']}},
     { 'text': 'v' },
     { 'text': 'b' },
     { 'text': 'n' },
     { 'text': '\'',
      'moreKeys': {
        'characters': ['\u201A', '\u2018', '\u2019', '\u2039', '\u203A']}},
     { 'text': '!',
      'moreKeys': {
        'characters': ['\u00A1']}},
     { 'text': '?',
      'moreKeys': {
        'characters': ['\u00BF']}},
     NON_LETTER_KEYS.RIGHT_SHIFT,
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.GLOBE,
     NON_LETTER_KEYS.MENU,
     { 'text': '/', 'isGrey': true },
     NON_LETTER_KEYS.SPACE,
     { 'text': ',', 'isGrey': true },
     { 'text': '.', 'isGrey': true,
      'moreKeys': {
        'characters': [',', '\'', '#', ')', '(', '/', ';', '@', ':',
          '-', '"', '+', '%', '&'],
        'fixedColumnNumber': 7}},
     NON_LETTER_KEYS.HIDE
  ];
};
i18n.input.chrome.inputview.content.compact.letter.keyNordicCharacters =
    function() {
  return [
     { 'text': 'q', 'hintText': '1' },
     { 'text': 'w', 'hintText': '2' },
     { 'text': 'e', 'hintText': '3' },
     { 'text': 'r', 'hintText': '4' },
     { 'text': 't', 'hintText': '5' },
     { 'text': 'y', 'hintText': '6' },
     { 'text': 'u', 'hintText': '7',
      'moreKeys': {
        'characters': ['\u00FC']}},
     { 'text': 'i', 'hintText': '8' },
     { 'text': 'o', 'hintText': '9',
      'moreKeys': {
        'characters': ['\u00F8', '\u00F4', '\u00F2', '\u00F3', '\u00F5',
          '\u0153', '\u014D']}},
     { 'text': 'p', 'hintText': '0' },
     { 'text': '\u00e5' },
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': 'a',
      'moreKeys': {
        'characters': ['\u00E6', '\u00E0', '\u00E1', '\u00E2', '\u00E3',
          '\u0101']}},
     { 'text': 's',
      'moreKeys': {
        'characters': ['\u0161', '\u00DF', '\u015B']}},
     { 'text': 'd' },
     { 'text': 'f' },
     { 'text': 'g' },
     { 'text': 'h' },
     { 'text': 'j' },
     { 'text': 'k' },
     { 'text': 'l' },
     { 'text': '\u00f6',
      'moreKeys': {
        'characters': ['\u00F8']}},
     { 'text': '\u00e4',
      'moreKeys': {
        'characters': ['\u00E6']}},
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.LEFT_SHIFT,
     { 'text': 'z', 'marginLeftPercent': 0.33,
      'moreKeys': {
        'characters': ['\u017E', '\u017A', '\u017C']}},
     { 'text': 'x' },
     { 'text': 'c' },
     { 'text': 'v' },
     { 'text': 'b' },
     { 'text': 'n' },
     { 'text': 'm' },
     { 'text': '!',
      'moreKeys': {
        'characters': ['\u00A1']}},
     { 'text': '?', 'marginRightPercent': 0.33,
      'moreKeys': {
        'characters': ['\u00BF']}},
     NON_LETTER_KEYS.RIGHT_SHIFT,
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.GLOBE,
     NON_LETTER_KEYS.MENU,
     { 'text': '/', 'isGrey': true },
     NON_LETTER_KEYS.SPACE,
     { 'text': ',', 'isGrey': true },
     { 'text': '.', 'isGrey': true,
      'moreKeys': {
        'characters': [',', '\'', '#', ')', '(', '/', ';', '@', ':',
          '-', '"', '+', '%', '&'],
        'fixedColumnNumber': 7}},
     NON_LETTER_KEYS.HIDE
  ];
};
i18n.input.chrome.inputview.content.compact.letter.keySwedenCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyNordicCharacters();
  data[2]['moreKeys'] = {
    'characters': ['\u00E9', '\u00E8', '\u00EA', '\u00EB', '\u0119']};  // e
  data[3]['moreKeys'] = {
    'characters': ['\u0159']};  // r
  data[4]['moreKeys'] = {
    'characters': ['\u0165', '\u00FE']};  // t
  data[5]['moreKeys'] = {
    'characters': ['\u00FD', '\u00FF']};  // y
  data[6]['moreKeys'] = {
    'characters': ['\u00FC', '\u00FA', '\u00F9', '\u00FB', '\u016B']};  // u
  data[7]['moreKeys'] = {
    'characters': ['\u00ED', '\u00EC', '\u00EE', '\u00EF']};  // i
  data[8]['moreKeys'] = {
    'characters': ['\u00F3', '\u00F2', '\u00F4', '\u00F5', '\u014D']};  // o
  data[12]['moreKeys'] = {
    'characters': ['\u00E1', '\u00E0', '\u00E2', '\u0105', '\u00E3']};  // a
  data[13]['moreKeys'] = {
    'characters': ['\u015B', '\u0161', '\u015F', '\u00DF']};  // s
  data[14]['moreKeys'] = {
    'characters': ['\u00F0', '\u010F']};  // d
  data[20]['moreKeys'] = {
    'characters': ['\u0142']};  // l
  data[21]['moreKeys'] = {
    'characters': ['\u00F8', '\u0153']};
  data[25]['moreKeys'] = {
    'characters': ['\u017A', '\u017E', '\u017C']};  //z
  data[27]['moreKeys'] = {
    'characters': ['\u00E7', '\u0107', '\u010D']};  //c
  data[30]['moreKeys'] = {
    'characters': ['\u0144', '\u00F1', '\u0148']};  //n
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyNorwayCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyNordicCharacters();
  data[2]['moreKeys'] = {
    'characters': ['\u00E9', '\u00E8', '\u00EA', '\u00EB', '\u0119', '\u0117',
      '\u0113']};  // e
  data[6]['moreKeys'] = {
    'characters': ['\u00FC', '\u00FB', '\u00F9', '\u00FA', '\u016B']};  // u
  data[8]['moreKeys'] = {
    'characters': ['\u00F4', '\u00F2', '\u00F3', '\u00F6', '\u00F5', '\u0153',
      '\u014D']};  // o
  data[12]['moreKeys'] = {
    'characters': ['\u00E0', '\u00E4', '\u00E1', '\u00E2', '\u00E3',
      '\u0101']};  // a
  data[13]['moreKeys'] = undefined;  //s
  data[21]['moreKeys'] = {
    'characters': ['\u00F6']};
  data[22]['moreKeys'] = {
    'characters': ['\u00E4']};
  data[25]['moreKeys'] = undefined;  //z
  data[21]['text'] = '\u00f8';
  data[22]['text'] = '\u00e6';
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyDenmarkCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyNordicCharacters();
  data[2]['moreKeys'] = {
    'characters': ['\u00E9', '\u00EB']};  // e
  data[5]['moreKeys'] = {
    'characters': ['\u00FD', '\u00FF']};  // y
  data[6]['moreKeys'] = {
    'characters': ['\u00FA', '\u00FC', '\u00FB', '\u00F9', '\u016B']};  // u
  data[7]['moreKeys'] = {
    'characters': ['\u00ED', '\u00EF']};  // i
  data[8]['moreKeys'] = {
    'characters': ['\u00F3', '\u00F4', '\u00F2', '\u00F5', '\u0153',
      '\u014D']};  // o
  data[12]['moreKeys'] = {
    'characters': ['\u00E1', '\u00E4', '\u00E0', '\u00E2', '\u00E3',
      '\u0101']};  // a
  data[13]['moreKeys'] = {
    'characters': ['\u00DF', '\u015B', '\u0161']};  // s
  data[14]['moreKeys'] = {
    'characters': ['\u00F0']};  // d
  data[20]['moreKeys'] = {
    'characters': ['\u0142']};  // l
  data[21]['moreKeys'] = {
    'characters': ['\u00E4']};
  data[22]['moreKeys'] = {
    'characters': ['\u00F6']};
  data[25]['moreKeys'] = undefined;  //z
  data[30]['moreKeys'] = {
    'characters': ['\u00F1', '\u0144']};  //n
  data[21]['text'] = '\u00e6';
  data[22]['text'] = '\u00f8';
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyPinyinCharacters =
    function() {
  var data = [
     { 'text': 'q', 'hintText': '1',
      'moreKeys': {
        'characters': ['\u0051', '\u0071']}},
     { 'text': 'w', 'hintText': '2',
      'moreKeys': {
        'characters': ['\u0057', '\u0077']}},
     { 'text': 'e', 'hintText': '3',
      'moreKeys': {
        'characters': ['\u0045', '\u0065']}},
     { 'text': 'r', 'hintText': '4',
      'moreKeys': {
        'characters': ['\u0052', '\u0072']}},
     { 'text': 't', 'hintText': '5',
      'moreKeys': {
        'characters': ['\u0054', '\u0074']}},
     { 'text': 'y', 'hintText': '6',
      'moreKeys': {
        'characters': ['\u0059', '\u0079']}},
     { 'text': 'u', 'hintText': '7',
      'moreKeys': {
        'characters': ['\u0055', '\u0075']}},
     { 'text': 'i', 'hintText': '8',
      'moreKeys': {
        'characters': ['\u0049', '\u0069']}},
     { 'text': 'o', 'hintText': '9',
      'moreKeys': {
        'characters': ['\u004F', '\u006F']}},
     { 'text': 'p', 'hintText': '0',
      'moreKeys': {
        'characters': ['\u0050', '\u0070']}},
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': 'a', 'hintText': '@', 'marginLeftPercent': 0.33,
      'moreKeys': {
        'characters': ['\u0041', '\u0061']}},
     { 'text': 's', 'hintText': '*',
      'moreKeys': {
        'characters': ['\u0053', '\u0073']}},
     { 'text': 'd', 'hintText': '+',
      'moreKeys': {
        'characters': ['\u0044', '\u0064']}},
     { 'text': 'f', 'hintText': '-',
      'moreKeys': {
        'characters': ['\u0046', '\u0066']}},
     { 'text': 'g', 'hintText': '=',
      'moreKeys': {
        'characters': ['\u0047', '\u0067']}},
     { 'text': 'h', 'hintText': '/',
      'moreKeys': {
        'characters': ['\u0048', '\u0068']}},
     { 'text': 'j', 'hintText': '#',
      'moreKeys': {
        'characters': ['\u004a', '\u006a']}},
     { 'text': 'k', 'hintText': '\uff08',
      'moreKeys': {
        'characters': ['\u004b', '\u006b']}},
     { 'text': 'l', 'hintText': '\uff09',
      'moreKeys': {
        'characters': ['\u004c', '\u006c']}},
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.LEFT_SHIFT,
     { 'text': 'z', 'hintText': '\u3001',
      'moreKeys': {
        'characters': ['\u005a', '\u007a']}},
     { 'text': 'x', 'hintText': '\uff1a',
      'moreKeys': {
        'characters': ['\u0058', '\u0078']}},
     { 'text': 'c', 'hintText': '\"',
      'moreKeys': {
        'characters': ['\u0043', '\u0063']}},
     { 'text': 'v', 'hintText': '\uff1f',
      'moreKeys': {
        'characters': ['\u0056', '\u0076']}},
     { 'text': 'b', 'hintText': '\uff01',
      'moreKeys': {
        'characters': ['\u0042', '\u0062']}},
     { 'text': 'n', 'hintText': '\uff5e',
      'moreKeys': {
        'characters': ['\u004e', '\u006e']}},
     { 'text': 'm', 'hintText': '.',
      'moreKeys': {
        'characters': ['\u004d', '\u006d']}},
     { 'text': '\uff01', 'hintText': '%',
      'moreKeys': {
        'characters': ['\u00A1']}},
     { 'text': '\uff1f', 'hintText': '&',
      'moreKeys': {
        'characters': ['\u00BF']}},
     NON_LETTER_KEYS.RIGHT_SHIFT,
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.GLOBE,
     NON_LETTER_KEYS.MENU,
     { 'text': '\uff0c', 'isGrey': true },
     NON_LETTER_KEYS.SPACE,
     { 'text': '\u3002', 'isGrey': true },
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.HIDE
  ];
  for (var i = 0; i <= 9; i++) {
    data[i]['moreKeysShiftOperation'] = MoreKeysShiftOperation.TO_LOWER_CASE;
  }
  for (var i = 11; i <= 19; i++) {
    data[i]['moreKeysShiftOperation'] = MoreKeysShiftOperation.TO_LOWER_CASE;
  }
  for (var i = 22; i <= 28; i++) {
    data[i]['moreKeysShiftOperation'] = MoreKeysShiftOperation.TO_LOWER_CASE;
  }
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyEnCharacters =
    function() {
  var data =
      i18n.input.chrome.inputview.content.compact.letter.keyPinyinCharacters();
  for (var i = 0; i <= 9; i++) {
    data[i]['moreKeys']['characters'].pop();
  }
  for (var i = 11; i <= 19; i++) {
    data[i]['moreKeys']['characters'].pop();
  }
  for (var i = 22; i <= 28; i++) {
    data[i]['moreKeys']['characters'].pop();
  }
  data[12]['hintText'] = '*';
  data[14]['hintText'] = '\u002d';
  data[16]['hintText'] = '/';
  data[18]['hintText'] = '\u0028';
  data[19]['hintText'] = '\u0029';
  data[22]['hintText'] = '\u0027';
  data[23]['hintText'] = '\u003a';
  data[25]['hintText'] = '\u003f';
  data[26]['hintText'] = '\u0021';
  data[27]['hintText'] = '\u007e';
  data[28]['hintText'] = '\u2026';
  data[29]['text'] = '\u0021';
  data[30]['text'] = '\u003f';
  data[35]['text'] = '\u002c';
  data[37]['text'] = '.';
  return data;
};
i18n.input.chrome.inputview.content.compact.letter.keyZhuyinCharacters =
    function() {
  var data = [
     { 'text': '\u3105', 'hintText': '1',
      'moreKeys': {
        'characters': ['\uff01']}},
     { 'text': '\u3109', 'hintText': '2',
      'moreKeys': {
        'characters': ['@']}},
     { 'text': '\u02c7', 'hintText': '3',
      'moreKeys': {
        'characters': ['#']}},
     { 'text': '\u02cb', 'hintText': '4',
      'moreKeys': {
        'characters': ['$']}},
     { 'text': '\u3113', 'hintText': '5',
      'moreKeys': {
        'characters': ['%']}},
     { 'text': '\u02ca', 'hintText': '6',
      'moreKeys': {
        'characters': ['^']}},
     { 'text': '\u02d9', 'hintText': '7',
      'moreKeys': {
        'characters': ['&']}},
     { 'text': '\u311a', 'hintText': '8',
      'moreKeys': {
        'characters': ['*']}},
     { 'text': '\u311e', 'hintText': '9',
      'moreKeys': {
        'characters': ['\uff08']}},
     { 'text': '\u3122', 'hintText': '0',
      'moreKeys': {
        'characters': ['\uff09']}},
     { 'text': '\u3106', 'hintText': 'q',
      'moreKeys': {
        'characters': ['Q'], 'textCode': ['Q']}},
     { 'text': '\u310a', 'hintText': 'w',
      'moreKeys': {
        'characters': ['W'], 'codeKeys': ['Q']}},
     { 'text': '\u310d', 'hintText': 'e',
      'moreKeys': {
        'characters': ['E'], 'textCode': ['Q']}},
     { 'text': '\u3110', 'hintText': 'r',
      'moreKeys': {
        'characters': ['R']}},
     { 'text': '\u3114', 'hintText': 't',
      'moreKeys': {
        'characters': ['T']}},
     { 'text': '\u3117', 'hintText': 'y',
      'moreKeys': {
        'characters': ['Y']}},
     { 'text': '\u3127', 'hintText': 'u',
      'moreKeys': {
        'characters': ['U']}},
     { 'text': '\u311b', 'hintText': 'i',
      'moreKeys': {
        'characters': ['I']}},
     { 'text': '\u311f', 'hintText': 'o',
      'moreKeys': {
        'characters': ['O']}},
     { 'text': '\u3123', 'hintText': 'p',
      'moreKeys': {
        'characters': ['P']}},
     { 'text': '\u3107', 'hintText': 'a',
      'moreKeys': {
        'characters': ['A']}},
     { 'text': '\u310B', 'hintText': 's',
      'moreKeys': {
        'characters': ['S']}},
     { 'text': '\u310e', 'hintText': 'd',
      'moreKeys': {
        'characters': ['D']}},
     { 'text': '\u3111', 'hintText': 'f',
      'moreKeys': {
        'characters': ['F']}},
     { 'text': '\u3115', 'hintText': 'g',
      'moreKeys': {
        'characters': ['G']}},
     { 'text': '\u3118', 'hintText': 'h',
      'moreKeys': {
        'characters': ['H']}},
     { 'text': '\u3128', 'hintText': 'j',
      'moreKeys': {
        'characters': ['J']}},
     { 'text': '\u311c', 'hintText': 'k',
      'moreKeys': {
        'characters': ['K']}},
     { 'text': '\u3120', 'hintText': 'l',
      'moreKeys': {
        'characters': ['L']}},
     { 'text': '\u3124', 'hintText': '\uff1a'},
     { 'text': '\u3108', 'hintText': 'z',
      'moreKeys': {
        'characters': ['Z']}},
     { 'text': '\u310c', 'hintText': 'x',
      'moreKeys': {
        'characters': ['X']}},
     { 'text': '\u310f', 'hintText': 'c',
      'moreKeys': {
        'characters': ['C']}},
     { 'text': '\u3112', 'hintText': 'v',
      'moreKeys': {
        'characters': ['V']}},
     { 'text': '\u3116', 'hintText': 'b',
      'moreKeys': ['B'] },
     { 'text': '\u3119', 'hintText': 'n',
      'moreKeys': {
        'characters': ['N']}},
     { 'text': '\u3129', 'hintText': 'm',
      'moreKeys': {
        'characters': ['M']}},
     { 'text': '\u311d', 'hintText': '\u2026'},
     { 'text': '\u3121', 'hintText': '\uff01'},
     { 'text': '\u3125', 'hintText': '\uff1f'},
     NON_LETTER_KEYS.BACKSPACE,
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.RIGHT_SHIFT,
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.GLOBE,
     NON_LETTER_KEYS.MENU,
     { 'text': '\uff0c', 'isGrey': true },
     NON_LETTER_KEYS.SPACE,
     { 'text': '\u3126', 'isGrey': false },
     { 'text': '\u3002', 'isGrey': true },
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.HIDE
  ];
  for (var i = 0; i <= 39; i++) {
    data[i]['moreKeysShiftOperation'] = MoreKeysShiftOperation.TO_LOWER_CASE;
  }
  for (var i = 0; i <= 39; i++) {
    data[i]['onShift'] = (data[i]['hintText']).toUpperCase();
  }
  return data;
};
});  // goog.scope

// i18n.input.chrome.inputview.content.compact.more
goog.provide('i18n.input.chrome.inputview.content.compact.more');
goog.scope(function() {
var NON_LETTER_KEYS =
    i18n.input.chrome.inputview.content.Constants.NON_LETTER_KEYS;
i18n.input.chrome.inputview.content.compact.more.keyNAMoreCharacters =
    function() {
  return [
     { 'text': '~' },
     { 'text': '`' },
     { 'text': '|' },
     { 'text': '\u2022',
      'moreKeys': {
        'characters': ['\u266A', '\u2665', '\u2660', '\u2666', '\u2663']}},
     { 'text': '\u23B7' },
     { 'text': '\u03C0',
      'moreKeys': {
        'characters': ['\u03A0']}},
     { 'text': '\u00F7' },
     { 'text': '\u00D7' },
     { 'text': '\u00B6',
      'moreKeys': {
        'characters': ['\u00A7']}},
     { 'text': '\u0394' },
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': '\u00A3', 'marginLeftPercent': 0.33 },
     { 'text': '\u00A2' },
     { 'text': '\u20AC' },
     { 'text': '\u00A5' },
     { 'text': '^',
      'moreKeys': {
        'characters': ['\u2191', '\u2193', '\u2190', '\u2192']}},
     { 'text': '\u00B0',
      'moreKeys': {
        'characters': ['\u2032', '\u2033']}},
     { 'text': '=',
      'moreKeys': {
        'characters': ['\u2260', '\u2248', '\u221E']}},
     { 'text': '{' },
     { 'text': '}' },
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.SWITCHER,
     { 'text': '\\' },
     { 'text': '\u00A9' },
     { 'text': '\u00AE' },
     { 'text': '\u2122' },
     { 'text': '\u2105' },
     { 'text': '[' },
     { 'text': ']' },
     { 'text': '\u00A1' },
     { 'text': '\u00BF' },
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.SWITCHER,
     { 'text': '<', 'isGrey': true,
      'moreKeys': {
        'characters': ['\u2039', '\u2264', '\u00AB']}},
     NON_LETTER_KEYS.MENU,
     { 'text': '>', 'isGrey': true,
      'moreKeys': {
        'characters': ['\u203A', '\u2265', '\u00BB']}},
     NON_LETTER_KEYS.SPACE,
     { 'text': ',', 'isGrey': true },
     { 'text': '.', 'isGrey': true,
      'moreKeys': {
        'characters': ['\u2026']}},
     NON_LETTER_KEYS.HIDE
  ];
};
i18n.input.chrome.inputview.content.compact.more.keyUKMoreCharacters =
    function() {
  var data = i18n.input.chrome.inputview.content.compact.more.
      keyNAMoreCharacters();
  data[11]['text'] = '\u20AC';  // pound -> euro
  data[12]['text'] = '\u00A5';  // cent -> yen
  data[13]['text'] = '$';  // euro -> dollar
  data[13]['moreKeys'] = {
        'characters': ['\u00A2']};
  data[14]['text'] = '\u00A2';  // yen -> cent
  return data;
};
i18n.input.chrome.inputview.content.compact.more.keyEUMoreCharacters =
    function() {
  var data = i18n.input.chrome.inputview.content.compact.more.
      keyUKMoreCharacters();
  data[11]['text'] = '\u00A3';  // euro -> pound
  return data;
};
i18n.input.chrome.inputview.content.compact.more.keyPinyinMoreCharacters =
    function() {
  var data = i18n.input.chrome.inputview.content.compact.more.
      keyNAMoreCharacters();
  data[0]['text'] = '\uff5e';
  data[15]['text'] = '\u00B0';
  data[15]['moreKeys'] = {
        'characters': ['\u2032', '\u2033']};
  data[16]['text'] = '\u300e';
  data[16]['moreKeys'] = undefined;
  data[17]['text'] = '\u300f';
  data[17]['moreKeys'] = undefined;
  data[18]['text'] = '\uff5b';
  data[19]['text'] = '\uff5d';
  data[22]['text'] = '\uff0f';
  data[22]['moreKeys'] = undefined;
  data[27]['text'] = '\uff3b';
  data[28]['text'] = '\uff3d';
  data[29]['text'] = '\u3010';
  data[29]['moreKeys'] = undefined;
  data[30]['text'] = '\u3011';
  data[30]['moreKeys'] = undefined;
  data[33]['text'] = '\u300a';
  data[33]['moreKeys'] = {
        'characters': ['\u2039', '\u2264', '\u00AB']};
  data[35]['text'] = '\u300b';
  data[35]['moreKeys'] = {
        'characters': ['\u203A', '\u2265', '\u00BB']};
  data[37]['text'] = '\uff0c';
  data[38]['text'] = '\u3002';
  return data;
};
});  // goog.scope

// i18n.input.chrome.inputview.content.compact.numberpad
goog.provide('i18n.input.chrome.inputview.content.compact.numberpad');
goog.scope(function() {
var NON_LETTER_KEYS =
    i18n.input.chrome.inputview.content.Constants.NON_LETTER_KEYS;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.content.compact.numberpad.keyNumberpadCharacters =
    function() {
  return [
     { 'text': '-',
      'isGrey': true},
     { 'text': '+',
      'isGrey': true},
     { 'text': '.',
      'isGrey': true},
     { 'text': '1'},
     { 'text': '2'},
     { 'text': '3'},
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': '*',
      'isGrey': true},
     { 'text': '/',
      'isGrey': true},
     { 'text': ',',
      'isGrey': true},
     { 'text': '4'},
     { 'text': '5'},
     { 'text': '6'},
     NON_LETTER_KEYS.ENTER,
     { 'text': '(',
      'isGrey': true},
     { 'text': ')',
      'isGrey': true},
     { 'text': '=',
      'isGrey': true},
     { 'text': '7'},
     { 'text': '8'},
     { 'text': '9',
      'marginRightPercent': 0.545454},
     NON_LETTER_KEYS.SPACE,
     { 'text': '*'},
     { 'text': '0'},
     { 'text': '#'},
     NON_LETTER_KEYS.HIDE
  ];
};
i18n.input.chrome.inputview.content.compact.numberpad.keyPhonepadCharacters =
    function() {
  return [
     { 'text': '-',
      'isGrey': true},
     { 'text': '+',
      'isGrey': true},
     { 'title' : 'Pause', // i18n_messages.PAUSE
      'text': ',',
      'isGrey': true,
      'textCssClass': Css.FONT_SMALL},
     { 'text': '1'},
     { 'text': '2',
      'hintText': 'ABC'},
     { 'text': '3',
      'hintText': 'DEF'},
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': ',',
      'isGrey': true},
     { 'text': '.',
      'isGrey': true},
     { 'title': 'Wait', // i18n_messages.WAIT
      'text': ';',
      'isGrey': true,
      'textCssClass': Css.FONT_SMALL},
     { 'text': '4',
      'hintText': 'GHI'},
     { 'text': '5',
      'hintText': 'JKL'},
     { 'text': '6',
      'hintText': 'MNO'},
     NON_LETTER_KEYS.ENTER,
     { 'text': '(',
      'isGrey': true},
     { 'text': ')',
      'isGrey': true},
     { 'text': 'N',
      'isGrey': true},
     { 'text': '7',
      'hintText': 'PQRS'},
     { 'text': '8',
      'hintText': 'TUV'},
     { 'text': '9',
      'hintText': 'WXYZ',
      'marginRightPercent': 0.545454},
     NON_LETTER_KEYS.SPACE,
     { 'text': '*'},
     { 'text': '0'},
     { 'text': '#'},
     NON_LETTER_KEYS.HIDE
  ];
};
});  // goog.scope

// i18n.input.chrome.inputview.content.compact.symbol
goog.provide('i18n.input.chrome.inputview.content.compact.symbol');
goog.scope(function() {
var NON_LETTER_KEYS =
    i18n.input.chrome.inputview.content.Constants.NON_LETTER_KEYS;
i18n.input.chrome.inputview.content.compact.symbol.keyNASymbolCharacters =
    function() {
  return [
     { 'text': '1',
      'moreKeys': {
        'characters': ['\u00B9', '\u00BD', '\u2153', '\u00BC', '\u215B']}},
     { 'text': '2',
      'moreKeys': {
        'characters': ['\u00B2', '\u2154']}},
     { 'text': '3',
      'moreKeys': {
        'characters': ['\u00B3', '\u00BE', '\u215C']}},
     { 'text': '4',
      'moreKeys': {
        'characters': ['\u2074']}},
     { 'text': '5',
      'moreKeys': {
        'characters': ['\u215D']}},
     { 'text': '6' },
     { 'text': '7',
      'moreKeys': {
        'characters': ['\u215E']}},
     { 'text': '8' },
     { 'text': '9' },
     { 'text': '0',
      'moreKeys': {
        'characters': ['\u207F', '\u2205']}},
     NON_LETTER_KEYS.BACKSPACE,
     { 'text': '@', 'marginLeftPercent': 0.33 },
     { 'text': '#' },
     { 'text': '$',
      'moreKeys': {
        'characters': ['\u00A2', '\u00A3', '\u20AC', '\u00A5', '\u20B1']}},
     { 'text': '%',
      'moreKeys': {
        'characters': ['\u2030']}},
     { 'text': '&' },
     { 'text': '-',
      'moreKeys': {
        'characters': ['_', '\u2013', '\u2014', '\u00B7']}},
     { 'text': '+',
      'moreKeys': {
        'characters': ['\u00B1']}},
     { 'text': '(',
      'moreKeys': {
        'characters': ['<', '{', '[']}},
     { 'text': ')',
      'moreKeys': {
        'characters': ['>', '}', ']']}},
     NON_LETTER_KEYS.ENTER,
     NON_LETTER_KEYS.SWITCHER,
     { 'text': '\\' },
     { 'text': '=' },
     { 'text': '*',
      'moreKeys': {
        'characters': ['\u2020', '\u2021', '\u2605']}},
     { 'text': '"',
      'moreKeys': {
        'characters': ['\u201E', '\u201C', '\u201D', '\u00AB', '\u00BB']}},
     { 'text': '\'',
      'moreKeys': {
        'characters': ['\u201A', '\u2018', '\u2019', '\u2039', '\u203A']}},
     { 'text': ':' },
     { 'text': ';' },
     { 'text': '!',
      'moreKeys': {
        'characters': ['\u00A1']}},
     { 'text': '?',
      'moreKeys': {
        'characters': ['\u00BF']}},
     NON_LETTER_KEYS.SWITCHER,
     NON_LETTER_KEYS.SWITCHER,
     { 'text': '_', 'isGrey': true },
     NON_LETTER_KEYS.MENU,
     { 'text': '/', 'isGrey': true },
     NON_LETTER_KEYS.SPACE,
     { 'text': ',', 'isGrey': true },
     { 'text': '.', 'isGrey': true,
      'moreKeys': {
        'characters': ['\u2026']}},
     NON_LETTER_KEYS.HIDE
  ];
};
i18n.input.chrome.inputview.content.compact.symbol.keyUKSymbolCharacters =
    function() {
  var data = i18n.input.chrome.inputview.content.compact.symbol.
      keyNASymbolCharacters();
  data[13] = { 'text': '\u00A3',
               'moreKeys': {
                 'characters': ['\u00A2', '$', '\u20AC', '\u00A5', '\u20B1']}};
  return data;
};
i18n.input.chrome.inputview.content.compact.symbol.keyEUSymbolCharacters =
    function() {
  var data = i18n.input.chrome.inputview.content.compact.symbol.
      keyUKSymbolCharacters();
  data[13] = { 'text': '\u20AC',
               'moreKeys': {
                 'characters': ['\u00A2', '$', '\u00A3', '\u00A5', '\u20B1']}};
  return data;
};
i18n.input.chrome.inputview.content.compact.symbol.keyPinyinSymbolCharacters =
    function() {
  var data = i18n.input.chrome.inputview.content.compact.symbol.
      keyNASymbolCharacters();
  data[13]['text'] = '\u00A5';
  data[13]['moreKeys'] = {
        'characters': ['\u0024', '\u00A2', '\u00A3', '\u20AC', '\u20B1']};
  data[15]['text'] = '&';
  data[18]['text'] = '\uff08';
  data[18]['moreKeys'] = {
        'characters': ['\uff5b', '\u300a', '\uff3b', '\u3010']};
  data[19]['text'] = '\uff09';
  data[19]['moreKeys'] = {
        'characters': ['\uff5d', '\u300b', '\uff3d', '\u3001']};
  data[22]['text'] = '\u3001';
  data[25]['text'] = '\u201C';
  data[25]['moreKeys'] = {
        'characters': ['\u0022', '\u00AB']};
  data[26]['text'] = '\u201D';
  data[26]['moreKeys'] = {
        'characters': ['\u0022', '\u00BB']};
  data[27]['text'] = '\uff1a';
  data[28]['text'] = '\uff1b';
  data[29]['text'] = '\u2018';
  data[29]['moreKeys'] = {
        'characters': ['\u0027', '\u2039']};
  data[30]['text'] = '\u2019';
  data[30]['moreKeys'] = {
        'characters': ['\u0027', '\u203a']};
  data[33]['text'] = ' \u2014';
  data[33]['moreKeys'] = undefined;
  data[35]['text'] = '\u2026';
  data[35]['moreKeys'] = undefined;
  data[37]['text'] = '\uff0c';
  data[38]['text'] = '\u3002';
  return data;
};
});  // goog.scope

// i18n.input.chrome.inputview.SpecNodeName
goog.provide('i18n.input.chrome.inputview.SpecNodeName');
i18n.input.chrome.inputview.SpecNodeName = {
  ALIGN: 'align',
  ARIA_LABEL: 'ariaLabel',
  CHARACTERS: 'characters',
  CHILDREN: 'children',
  CONDITION: 'condition',
  DIRECTION: 'direction',
  DISABLE_LONGPRESS: 'disableLongpress',
  EMOJI_NAMES: 'emojiNames',
  GIVE_WEIGHT_TO: 'giveWeightTo',
  HAS_ALTGR_KEY: 'hasAltGrKey',
  HEIGHT: 'height',
  HEIGHT_IN_WEIGHT: 'heightInWeight',
  HEIGHT_PERCENT: 'heightPercent',
  HINT_TEXT: 'hintText',
  ICON_CSS_CLASS: 'iconCssClass',
  ID: 'id',
  IS_GREY: 'isGrey',
  LAYOUT: 'layout',
  LAYOUT_ID: 'layoutID',
  HEIGHT_PERCENT_OF_WIDTH: 'heightPercentOfWidth',
  MARGIN_LEFT_PERCENT: 'marginLeftPercent',
  MARGIN_RIGHT_PERCENT: 'marginRightPercent',
  MINIMUM_HEIGHT: 'minimumHeight',
  MORE_KEYS: 'moreKeys',
  NO_SHIFT: 'noShift',
  NUMBER_ROW_WEIGHT: 'numberRowWeight',
  KEY_CODE: 'keyCode',
  KEY_LIST: 'keyList',
  MAPPING: 'mapping',
  NAME: 'name',
  ON_CONTEXT: 'onContext',
  PADDING: 'padding',
  RECORD: 'record',
  SHOW_MENU_KEY: 'showMenuKey',
  ENABLE_SHIFT_RENDERING: 'enableShiftRendering',
  SUPPORT_STICKY: 'supportSticky',
  SPEC: 'spec',
  TEXT: 'text',
  TEXT_CSS_CLASS: 'textCssClass',
  TITLE: 'title',
  TYPE: 'type',
  TO_STATE: 'toState',
  TO_KEYSET: 'toKeyset',
  TO_KEYSET_NAME: 'toKeysetName',
  WIDTH: 'width',
  WIDTH_IN_WEIGHT: 'widthInWeight',
  WIDTH_PERCENT: 'widthPercent',
  IS_EMOTICON: 'isEmoticon',
  MORE_KEYS_SHIFT_OPERATION: 'moreKeysShiftOperation',
  ON_SHIFT: 'onShift',
  FIXED_COLUMN_NUMBER: 'fixedColumnNumber'
};

// i18n.input.chrome.inputview.content.compact.util
// i18n.input.chrome.inputview.content.compact.util.CompactKeysetSpec
goog.provide('i18n.input.chrome.inputview.content.compact.util');
goog.provide('i18n.input.chrome.inputview.content.compact.util.CompactKeysetSpec');
goog.scope(function() {
var util = i18n.input.chrome.inputview.content.compact.util;
var NON_LETTER_KEYS =
    i18n.input.chrome.inputview.content.Constants.NON_LETTER_KEYS;
var Css = i18n.input.chrome.inputview.Css;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
util.CompactKeysetSpec = {
  ID: 'id',
  LAYOUT: 'layout',
  DATA: 'data'
};
util.MSG_NUMBER_AND_SYMBOL =
    goog.getMsg('number and symbol layout');
util.MSG_MORE_SYMBOLS =
    goog.getMsg('more symbols layout');
util.MSG_MAIN_LAYOUT = goog.getMsg('main layout');
util.MSG_ENG_MAIN_LAYOUT = goog.getMsg('english main layout');
util.MSG_ENG_MORE_SYMBOLS =
    goog.getMsg('english more symbols layout');
util.MSG_ENG_NUMBER_AND_SYMBOL =
    goog.getMsg('english number and symbol layout');
util.createCompactData = function(keysetSpec, viewIdPrefix, keyIdPrefix) {
  var keyList = [];
  var mapping = {};
  var keysetSpecNode = util.CompactKeysetSpec;
  for (var i = 0; i < keysetSpec[keysetSpecNode.DATA].length; i++) {
    var keySpec = keysetSpec[keysetSpecNode.DATA][i];
    if (keySpec == NON_LETTER_KEYS.MENU) {
      keySpec[SpecNodeName.TO_KEYSET] =
          keysetSpec[keysetSpecNode.ID].split('.')[0];
    }
    var id = keySpec[SpecNodeName.ID] ?
        keySpec[SpecNodeName.ID] :
        keyIdPrefix + i;
    var key = util.createCompactKey(id, keySpec);
    keyList.push(key);
    mapping[key['spec'][SpecNodeName.ID]] = viewIdPrefix + i;
  }
  var compactKeyData = {};
  compactKeyData[SpecNodeName.KEY_LIST] = keyList;
  compactKeyData[SpecNodeName.MAPPING] = mapping;
  compactKeyData[SpecNodeName.LAYOUT] = keysetSpec[keysetSpecNode.LAYOUT];
  return compactKeyData;
};
util.createCompactKey = function(id, keySpec) {
  var spec = keySpec;
  spec[SpecNodeName.ID] = id;
  if (!spec[SpecNodeName.TYPE]) {
    spec[SpecNodeName.TYPE] =
        i18n.input.chrome.ElementType.COMPACT_KEY;
  }
  var newSpec = {};
  for (var key in spec) {
    newSpec[key] = spec[key];
  }
  return {
    'spec': newSpec
  };
};
util.customizeSwitchers = function(keyCharacters, switcherKeys) {
  var switcherKeyIndex = 0;
  for (var i = 0; i < keyCharacters.length; i++) {
    if (keyCharacters[i] == NON_LETTER_KEYS.SWITCHER) {
      if (switcherKeyIndex >= switcherKeys.length) {
        console.error('The number of switcher key spec is less than' +
            ' the number of switcher keys in the keyset.');
        return;
      }
      var newSpec = {};
      goog.object.extend(newSpec, switcherKeys[switcherKeyIndex]);
      goog.object.extend(newSpec, keyCharacters[i]);
      keyCharacters[i] = newSpec;
      switcherKeyIndex++;
    }
  }
  if (switcherKeyIndex < switcherKeys.length) {
    console.error('The number of switcher key spec is more than' +
        ' the number of switcher keys in the keyset.');
  }
};
util.addKeysetToSpacebar_ = function(keyCharacters, letterKeysetId) {
  for (var i = 0; i < keyCharacters.length; i++) {
    if (keyCharacters[i] == NON_LETTER_KEYS.SPACE) {
      keyCharacters[i][SpecNodeName.TO_KEYSET] = letterKeysetId;
      break;
    }
  }
};
util.generateCompactKeyboard =
    function(letterKeysetSpec, symbolKeysetSpec, moreKeysetSpec, onLoaded) {
  var keysetSpecNode = util.CompactKeysetSpec;
  var lettersSwitcherKey = {};
  lettersSwitcherKey[SpecNodeName.NAME] = 'abc';
  lettersSwitcherKey[SpecNodeName.TO_KEYSET] =
      letterKeysetSpec[keysetSpecNode.ID];
  lettersSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_MAIN_LAYOUT;
  var symbolsSwitcherKey = {};
  symbolsSwitcherKey[SpecNodeName.NAME] = '?123';
  symbolsSwitcherKey[SpecNodeName.TO_KEYSET] =
      symbolKeysetSpec[keysetSpecNode.ID];
  symbolsSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_NUMBER_AND_SYMBOL;
  var moreSwitcherKey = {};
  moreSwitcherKey[SpecNodeName.NAME] = '~[<';
  moreSwitcherKey[SpecNodeName.TO_KEYSET] = moreKeysetSpec[keysetSpecNode.ID];
  moreSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_MORE_SYMBOLS;
  util.customizeSwitchers(
      letterKeysetSpec[keysetSpecNode.DATA],
      [symbolsSwitcherKey]);
  var data = util.createCompactData(
      letterKeysetSpec, 'compactkbd-k-', 'compactkbd-k-key-');
  data[SpecNodeName.ID] = letterKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = true;
  onLoaded(data);
  util.customizeSwitchers(
      symbolKeysetSpec[keysetSpecNode.DATA],
      [moreSwitcherKey, moreSwitcherKey, lettersSwitcherKey]);
  util.addKeysetToSpacebar_(
      symbolKeysetSpec[keysetSpecNode.DATA],
      letterKeysetSpec[keysetSpecNode.ID]);
  data = util.createCompactData(
      symbolKeysetSpec, 'compactkbd-k-', 'compactkbd-k-key-');
  data[SpecNodeName.ID] = symbolKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = false;
  data[SpecNodeName.NO_SHIFT] = true;
  onLoaded(data);
  util.customizeSwitchers(
      moreKeysetSpec[keysetSpecNode.DATA],
      [symbolsSwitcherKey, symbolsSwitcherKey, lettersSwitcherKey]);
  data = util.createCompactData(moreKeysetSpec, 'compactkbd-k-',
      'compactkbd-k-key-');
  data[SpecNodeName.ID] = moreKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = false;
  data[SpecNodeName.NO_SHIFT] = true;
  onLoaded(data);
};
util.generatePinyinCompactKeyboard = function(letterKeysetSpec, engKeysetSpec,
    symbolKeysetSpec, engSymbolKeysetSpec,
    moreKeysetSpec, engMoreKeysetSpec, onLoaded) {
  var keysetSpecNode = util.CompactKeysetSpec;
  var lettersSwitcherKey = {};
  lettersSwitcherKey[SpecNodeName.NAME] = 'abc';
  lettersSwitcherKey[SpecNodeName.TO_KEYSET] =
      letterKeysetSpec[keysetSpecNode.ID];
  lettersSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_MAIN_LAYOUT;
  var symbolsSwitcherKey = {};
  symbolsSwitcherKey[SpecNodeName.NAME] = '?123';
  symbolsSwitcherKey[SpecNodeName.TO_KEYSET] =
      symbolKeysetSpec[keysetSpecNode.ID];
  symbolsSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_NUMBER_AND_SYMBOL;
  var moreSwitcherKey = {};
  moreSwitcherKey[SpecNodeName.NAME] = '~[<';
  moreSwitcherKey[SpecNodeName.TO_KEYSET] = moreKeysetSpec[keysetSpecNode.ID];
  moreSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_MORE_SYMBOLS;
  var engLettersSwitcherKey = {};
  engLettersSwitcherKey[SpecNodeName.NAME] = 'abc';
  engLettersSwitcherKey[SpecNodeName.TO_KEYSET] =
      engKeysetSpec[keysetSpecNode.ID];
  engLettersSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_ENG_MAIN_LAYOUT;
  var engSymbolsSwitcherKey = {};
  engSymbolsSwitcherKey[SpecNodeName.NAME] = '?123';
  engSymbolsSwitcherKey[SpecNodeName.TO_KEYSET] =
      engSymbolKeysetSpec[keysetSpecNode.ID];
  engSymbolsSwitcherKey[SpecNodeName.TO_KEYSET_NAME] =
      util.MSG_ENG_NUMBER_AND_SYMBOL;
  var engMoreSwitcherKey = {};
  engMoreSwitcherKey[SpecNodeName.NAME] = '~[<';
  engMoreSwitcherKey[SpecNodeName.TO_KEYSET] =
      engMoreKeysetSpec[keysetSpecNode.ID];
  engMoreSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_ENG_MORE_SYMBOLS;
  var lettersSwitcherKeyWithIcon = {};
  lettersSwitcherKeyWithIcon[SpecNodeName.TO_KEYSET] =
      letterKeysetSpec[keysetSpecNode.ID];
  lettersSwitcherKeyWithIcon[SpecNodeName.TO_KEYSET_NAME] =
      util.MSG_MAIN_LAYOUT;
  lettersSwitcherKeyWithIcon[SpecNodeName.ICON_CSS_CLASS] =
      Css.SWITCHER_ENGLISH;
  var engSwitcherKey = {};
  engSwitcherKey[SpecNodeName.TO_KEYSET] = engKeysetSpec[keysetSpecNode.ID];
  engSwitcherKey[SpecNodeName.TO_KEYSET_NAME] = util.MSG_ENG_MAIN_LAYOUT;
  engSwitcherKey[SpecNodeName.ICON_CSS_CLASS] = Css.SWITCHER_CHINESE;
  util.customizeSwitchers(
      letterKeysetSpec[keysetSpecNode.DATA],
      [symbolsSwitcherKey, engSwitcherKey]);
  var data = util.createCompactData(
      letterKeysetSpec, 'compactkbd-k-', 'compactkbd-k-key-');
  data[SpecNodeName.ID] = letterKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = true;
  onLoaded(data);
  util.customizeSwitchers(
      engKeysetSpec[keysetSpecNode.DATA],
      [engSymbolsSwitcherKey, lettersSwitcherKeyWithIcon]);
  data = util.createCompactData(
      engKeysetSpec, 'compactkbd-k-', 'compactkbd-k-key-');
  data[SpecNodeName.ID] = engKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = true;
  onLoaded(data);
  util.customizeSwitchers(
      symbolKeysetSpec[keysetSpecNode.DATA],
      [moreSwitcherKey, moreSwitcherKey, lettersSwitcherKey]);
  data = util.createCompactData(
      symbolKeysetSpec, 'compactkbd-k-', 'compactkbd-k-key-');
  data[SpecNodeName.ID] = symbolKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = false;
  data[SpecNodeName.NO_SHIFT] = true;
  onLoaded(data);
  util.customizeSwitchers(
      engSymbolKeysetSpec[keysetSpecNode.DATA],
      [engMoreSwitcherKey, engMoreSwitcherKey, engLettersSwitcherKey]);
  data = util.createCompactData(
      engSymbolKeysetSpec, 'compactkbd-k-', 'compactkbd-k-key-');
  data[SpecNodeName.ID] = engSymbolKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = false;
  data[SpecNodeName.NO_SHIFT] = true;
  onLoaded(data);
  util.customizeSwitchers(
      moreKeysetSpec[keysetSpecNode.DATA],
      [symbolsSwitcherKey, symbolsSwitcherKey, lettersSwitcherKey]);
  data = util.createCompactData(moreKeysetSpec, 'compactkbd-k-',
      'compactkbd-k-key-');
  data[SpecNodeName.ID] = moreKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = false;
  data[SpecNodeName.NO_SHIFT] = true;
  onLoaded(data);
  util.customizeSwitchers(
      engMoreKeysetSpec[keysetSpecNode.DATA],
      [engSymbolsSwitcherKey, engSymbolsSwitcherKey, engLettersSwitcherKey]);
  data = util.createCompactData(engMoreKeysetSpec, 'compactkbd-k-',
      'compactkbd-k-key-');
  data[SpecNodeName.ID] = engMoreKeysetSpec[keysetSpecNode.ID];
  data[SpecNodeName.SHOW_MENU_KEY] = false;
  data[SpecNodeName.NO_SHIFT] = true;
  onLoaded(data);
};
});  // goog.scope

// i18n.input.chrome.inputview.content.ContextlayoutUtil
goog.provide('i18n.input.chrome.inputview.content.ContextlayoutUtil');
goog.scope(function() {
var ContextType = i18n.input.chrome.message.ContextType;
var util = i18n.input.chrome.inputview.content.ContextlayoutUtil;
var compact = i18n.input.chrome.inputview.content.compact.util;
var keysetSpecNode = compact.CompactKeysetSpec;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
util.generateContextLayouts = function(inputTypeToKeysetSpecMap, onLoaded) {
  if (inputTypeToKeysetSpecMap) {
    for (var inputType in inputTypeToKeysetSpecMap) {
      var spec = inputTypeToKeysetSpecMap[inputType];
      var data = compact.createCompactData(
          spec, 'compactkbd-k-', 'compactkbd-k-key-');
      data[SpecNodeName.ID] = spec[keysetSpecNode.ID];
      data[SpecNodeName.SHOW_MENU_KEY] = false;
      data[SpecNodeName.NO_SHIFT] = true;
      data[SpecNodeName.ON_CONTEXT] = inputType;
      onLoaded(data);
    }
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.Direction
goog.provide('i18n.input.chrome.inputview.Direction');
i18n.input.chrome.inputview.Direction = {
  UP: 0,
  DOWN: 1,
  LEFT: 2,
  RIGHT: 3
};

// i18n.input.chrome.inputview.content.util
goog.provide('i18n.input.chrome.inputview.content.util');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
i18n.input.chrome.inputview.content.util.keyIdPrefix_ = 'sk-';
i18n.input.chrome.inputview.content.util.createHideKeyboardKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.HIDE_KEYBOARD_ICON;
  spec[SpecNodeName.TYPE] = ElementType.HIDE_KEYBOARD_KEY;
  spec[SpecNodeName.ID] = 'HideKeyboard';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createShiftKey = function(isLeft,
    opt_supportSticky) {
  var spec = {};
  spec[SpecNodeName.TO_STATE] = i18n.input.chrome.inputview.StateType.SHIFT;
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.SHIFT_ICON;
  spec[SpecNodeName.TYPE] = ElementType.MODIFIER_KEY;
  spec[SpecNodeName.ID] = isLeft ? 'ShiftLeft' : 'ShiftRight';
  spec[SpecNodeName.SUPPORT_STICKY] = !!opt_supportSticky;
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createGlobeKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.GLOBE_ICON;
  spec[SpecNodeName.TYPE] = ElementType.GLOBE_KEY;
  spec[SpecNodeName.ID] = 'Globe';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createMenuKey = function(
    opt_toKeyset) {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.MENU_ICON;
  spec[SpecNodeName.TO_KEYSET] = opt_toKeyset;
  spec[SpecNodeName.TYPE] = ElementType.MENU_KEY;
  spec[SpecNodeName.ID] = 'Menu';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createTabBarKey =
    function(id, toKeyset, iconCssClass) {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] = iconCssClass;
  spec[SpecNodeName.TYPE] = ElementType.TAB_BAR_KEY;
  spec[SpecNodeName.ID] = id;
  spec[SpecNodeName.TO_KEYSET] = toKeyset;
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createPageIndicator =
    function(id) {
  var spec = {};
  spec[SpecNodeName.TYPE] = ElementType.PAGE_INDICATOR;
  spec[SpecNodeName.ID] = id;
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createBackKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.EMOJI_BACK;
  spec[SpecNodeName.TYPE] = ElementType.BACK_BUTTON;
  spec[SpecNodeName.ID] = 'backkey';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createBackToKeyboardKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.BACK_TO_KEYBOARD_ICON;
  spec[SpecNodeName.TYPE] = ElementType.BACK_TO_KEYBOARD;
  spec[SpecNodeName.ID] = 'backToKeyboard';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createCtrlKey = function() {
  var spec = {};
  spec[SpecNodeName.TO_STATE] = i18n.input.chrome.inputview.StateType.CTRL;
  spec[SpecNodeName.NAME] = 'ctrl';
  spec[SpecNodeName.TYPE] = ElementType.MODIFIER_KEY;
  spec[SpecNodeName.ID] = 'ControlLeft';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createAltKey = function() {
  var spec = {};
  spec[SpecNodeName.TO_STATE] = i18n.input.chrome.inputview.StateType.ALT;
  spec[SpecNodeName.NAME] = 'alt';
  spec[SpecNodeName.TYPE] = ElementType.MODIFIER_KEY;
  spec[SpecNodeName.ID] = 'AltLeft';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createAltgrKey = function() {
  var spec = {};
  spec[SpecNodeName.TO_STATE] = i18n.input.chrome.inputview.StateType.ALTGR;
  spec[SpecNodeName.NAME] = 'alt gr';
  spec[SpecNodeName.TYPE] = ElementType.MODIFIER_KEY;
  spec[SpecNodeName.ID] = 'AltRight';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createEnSwitcherKey =
    function() {
  var spec = {};
  spec[SpecNodeName.TYPE] = ElementType.EN_SWITCHER;
  spec[SpecNodeName.ID] = 'enSwitcher';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createCapslockKey = function() {
  var spec = {};
  spec[SpecNodeName.TO_STATE] = i18n.input.chrome.inputview.StateType.CAPSLOCK;
  spec[SpecNodeName.NAME] = 'caps lock';
  spec[SpecNodeName.TYPE] = ElementType.MODIFIER_KEY;
  spec[SpecNodeName.ID] = 'OsLeft';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createEnterKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.ENTER_ICON;
  spec[SpecNodeName.TYPE] = ElementType.ENTER_KEY;
  spec[SpecNodeName.ID] = 'Enter';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createTabKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] = i18n.input.chrome.inputview.Css.TAB_ICON;
  spec[SpecNodeName.TYPE] = ElementType.TAB_KEY;
  spec[SpecNodeName.ID] = 'Tab';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createBackspaceKey = function() {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.BACKSPACE_ICON;
  spec[SpecNodeName.TYPE] = ElementType.BACKSPACE_KEY;
  spec[SpecNodeName.ID] = 'Backspace';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createSpaceKey = function() {
  var spec = {};
  spec[SpecNodeName.NAME] = ' ';
  spec[SpecNodeName.TYPE] = ElementType.SPACE_KEY;
  spec[SpecNodeName.ID] = 'Space';
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createIMESwitchKey =
    function(id, name, css) {
  var spec = {};
  spec[SpecNodeName.NAME] = name;
  spec[SpecNodeName.TYPE] = ElementType.IME_SWITCH;
  spec[SpecNodeName.ID] = id;
  spec[SpecNodeName.TEXT_CSS_CLASS] = css;
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createNormalKey = function(spec) {
  spec[SpecNodeName.TYPE] = ElementType.CHARACTER_KEY;
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createArrowKey = function(direction) {
  var spec = {};
  spec[SpecNodeName.ICON_CSS_CLASS] =
      i18n.input.chrome.inputview.Css.ARROW_KEY + ' ';
  if (direction == i18n.input.chrome.inputview.Direction.UP) {
    spec[SpecNodeName.ID] = 'ArrowUp';
    spec[SpecNodeName.ICON_CSS_CLASS] += i18n.input.chrome.inputview.Css.UP_KEY;
    spec[SpecNodeName.TYPE] = ElementType.ARROW_UP;
  } else if (direction == i18n.input.chrome.inputview.Direction.DOWN) {
    spec[SpecNodeName.ID] = 'ArrowDown';
    spec[SpecNodeName.ICON_CSS_CLASS] +=
        i18n.input.chrome.inputview.Css.DOWN_KEY;
    spec[SpecNodeName.TYPE] = ElementType.ARROW_DOWN;
  } else if (direction == i18n.input.chrome.inputview.Direction.LEFT) {
    spec[SpecNodeName.ID] = 'ArrowLeft';
    spec[SpecNodeName.ICON_CSS_CLASS] +=
        i18n.input.chrome.inputview.Css.LEFT_KEY;
    spec[SpecNodeName.TYPE] = ElementType.ARROW_LEFT;
  } else if (direction == i18n.input.chrome.inputview.Direction.RIGHT) {
    spec[SpecNodeName.ID] = 'ArrowRight';
    spec[SpecNodeName.ICON_CSS_CLASS] +=
        i18n.input.chrome.inputview.Css.RIGHT_KEY;
    spec[SpecNodeName.TYPE] = ElementType.ARROW_RIGHT;
  }
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.createKey = function(spec) {
  var newSpec = {};
  for (var key in spec) {
    newSpec[key] = spec[key];
  }
  return {
    'spec': newSpec
  };
};
i18n.input.chrome.inputview.content.util.KEY_CODES_101 = [
  'Backquote',
  'Digit1',
  'Digit2',
  'Digit3',
  'Digit4',
  'Digit5',
  'Digit6',
  'Digit7',
  'Digit8',
  'Digit9',
  'Digit0',
  'Minus',
  'Equal',
  'KeyQ',
  'KeyW',
  'KeyE',
  'KeyR',
  'KeyT',
  'KeyY',
  'KeyU',
  'KeyI',
  'KeyO',
  'KeyP',
  'BracketLeft',
  'BracketRight',
  'Backslash',
  'KeyA',
  'KeyS',
  'KeyD',
  'KeyF',
  'KeyG',
  'KeyH',
  'KeyJ',
  'KeyK',
  'KeyL',
  'Semicolon',
  'Quote',
  'KeyZ',
  'KeyX',
  'KeyC',
  'KeyV',
  'KeyB',
  'KeyN',
  'KeyM',
  'Comma',
  'Period',
  'Slash'
];
i18n.input.chrome.inputview.content.util.KEY_CODES_102 = [
  'Backquote',
  'Digit1',
  'Digit2',
  'Digit3',
  'Digit4',
  'Digit5',
  'Digit6',
  'Digit7',
  'Digit8',
  'Digit9',
  'Digit0',
  'Minus',
  'Equal',
  'KeyQ',
  'KeyW',
  'KeyE',
  'KeyR',
  'KeyT',
  'KeyY',
  'KeyU',
  'KeyI',
  'KeyO',
  'KeyP',
  'BracketLeft',
  'BracketRight',
  'KeyA',
  'KeyS',
  'KeyD',
  'KeyF',
  'KeyG',
  'KeyH',
  'KeyJ',
  'KeyK',
  'KeyL',
  'Semicolon',
  'Quote',
  'Backslash',
  'IntlBackslash',
  'KeyZ',
  'KeyX',
  'KeyC',
  'KeyV',
  'KeyB',
  'KeyN',
  'KeyM',
  'Comma',
  'Period',
  'Slash'
];
i18n.input.chrome.inputview.content.util.createData = function(keyCharacters,
    viewIdPrefix, is102, hasAltGrKey, opt_keyCodes, opt_compactKeyboardId) {
  var keyList = [];
  var mapping = {};
  var keyCodes = opt_keyCodes || [];
  var keyIds = is102 ? i18n.input.chrome.inputview.content.util.KEY_CODES_102 :
      i18n.input.chrome.inputview.content.util.KEY_CODES_101;
  var keysShowShift = 11;
  for (var i = 0; i < keyCharacters.length - 1; i++) {
    var spec = {};
    spec[SpecNodeName.ID] = keyIds[i];
    spec[SpecNodeName.TYPE] = ElementType.CHARACTER_KEY;
    spec[SpecNodeName.CHARACTERS] = keyCharacters[i];
    spec[SpecNodeName.KEY_CODE] = keyCodes[i];
    if (i < keysShowShift) {
      spec[SpecNodeName.ENABLE_SHIFT_RENDERING] = true;
    }
    var key = i18n.input.chrome.inputview.content.util.createKey(spec);
    keyList.push(key);
  }
  i18n.input.chrome.inputview.content.util.insertModifierKeys_(keyList,
      is102, opt_compactKeyboardId);
  for (var i = 0; i < keyList.length; i++) {
    var key = keyList[i];
    mapping[key['spec'][SpecNodeName.ID]] = viewIdPrefix + i;
  }
  var layout = is102 ? '102kbd' : '101kbd';
  var result = {};
  result[SpecNodeName.KEY_LIST] = keyList;
  result[SpecNodeName.MAPPING] = mapping;
  result[SpecNodeName.LAYOUT] = layout;
  result[SpecNodeName.HAS_ALTGR_KEY] = hasAltGrKey;
  result[SpecNodeName.SHOW_MENU_KEY] = true;
  return result;
};
i18n.input.chrome.inputview.content.util.createSwitcherKey = function(
    id, name, toKeyset, toKeysetName, opt_iconCssClass, opt_record) {
  var spec = {};
  spec[SpecNodeName.ID] = id;
  spec[SpecNodeName.NAME] = name;
  spec[SpecNodeName.TO_KEYSET] = toKeyset;
  spec[SpecNodeName.TO_KEYSET_NAME] = toKeysetName;
  spec[SpecNodeName.ICON_CSS_CLASS] = opt_iconCssClass;
  spec[SpecNodeName.TYPE] = ElementType.SWITCHER_KEY;
  spec[SpecNodeName.RECORD] = !!opt_record;
  return i18n.input.chrome.inputview.content.util.createKey(spec);
};
i18n.input.chrome.inputview.content.util.insertModifierKeys_ = function(
    keyList, is102, opt_compactKeyboardId) {
  goog.array.insertAt(keyList, i18n.input.chrome.inputview.content.util.
      createBackspaceKey(), 13);
  goog.array.insertAt(keyList, i18n.input.chrome.inputview.content.util.
      createTabKey(), 14);
  goog.array.insertAt(keyList, i18n.input.chrome.inputview.content.util.
      createCapslockKey(), is102 ? 27 : 28);
  goog.array.insertAt(keyList, i18n.input.chrome.inputview.content.util.
      createEnterKey(), 40);
  goog.array.insertAt(keyList, i18n.input.chrome.inputview.content.util.
      createShiftKey(true), 41);
  keyList.push(i18n.input.chrome.inputview.content.util.createShiftKey(false));
  i18n.input.chrome.inputview.content.util.addLastRowKeys(
      keyList, is102, opt_compactKeyboardId);
};
i18n.input.chrome.inputview.content.util.addLastRowKeys =
    function(keyList, is102, opt_compactKeyboardId) {
  keyList.push(i18n.input.chrome.inputview.content.util.createGlobeKey());
  keyList.push(i18n.input.chrome.inputview.content.util.createMenuKey(
      opt_compactKeyboardId));
  keyList.push(i18n.input.chrome.inputview.content.util.createCtrlKey());
  keyList.push(i18n.input.chrome.inputview.content.util.createAltKey());
  keyList.push(i18n.input.chrome.inputview.content.util.createSpaceKey());
  keyList.push(i18n.input.chrome.inputview.content.util.createEnSwitcherKey());
  keyList.push(i18n.input.chrome.inputview.content.util.createAltgrKey());
  keyList.push(i18n.input.chrome.inputview.content.util.createArrowKey(
      i18n.input.chrome.inputview.Direction.LEFT));
  keyList.push(i18n.input.chrome.inputview.content.util.createArrowKey(
      i18n.input.chrome.inputview.Direction.RIGHT));
  keyList.push(i18n.input.chrome.inputview.content.util.
      createHideKeyboardKey());
};
});  // goog.scope

// goog.Delay
// goog.async.Delay
goog.provide('goog.Delay');
goog.provide('goog.async.Delay');
goog.async.Delay = function(listener, opt_interval, opt_handler) {
  goog.async.Delay.base(this, 'constructor');
  this.listener_ = listener;
  this.interval_ = opt_interval || 0;
  this.handler_ = opt_handler;
  this.callback_ = goog.bind(this.doAction_, this);
};
goog.inherits(goog.async.Delay, goog.Disposable);
goog.Delay = goog.async.Delay;
goog.async.Delay.prototype.id_ = 0;
goog.async.Delay.prototype.disposeInternal = function() {
  goog.async.Delay.base(this, 'disposeInternal');
  this.stop();
  delete this.listener_;
  delete this.handler_;
};
goog.async.Delay.prototype.start = function(opt_interval) {
  this.stop();
  this.id_ = goog.Timer.callOnce(
      this.callback_,
      goog.isDef(opt_interval) ? opt_interval : this.interval_);
};
goog.async.Delay.prototype.startIfNotActive = function(opt_interval) {
  if (!this.isActive()) {
    this.start(opt_interval);
  }
};
goog.async.Delay.prototype.stop = function() {
  if (this.isActive()) {
    goog.Timer.clear(this.id_);
  }
  this.id_ = 0;
};
goog.async.Delay.prototype.fire = function() {
  this.stop();
  this.doAction_();
};
goog.async.Delay.prototype.fireIfActive = function() {
  if (this.isActive()) {
    this.fire();
  }
};
goog.async.Delay.prototype.isActive = function() {
  return this.id_ != 0;
};
goog.async.Delay.prototype.doAction_ = function() {
  this.id_ = 0;
  if (this.listener_) {
    this.listener_.call(this.handler_);
  }
};

// goog.fx.easing
goog.provide('goog.fx.easing');
goog.fx.easing.easeIn = function(t) {
  return goog.fx.easing.easeInInternal_(t, 3);
};
goog.fx.easing.easeInInternal_ = function(t, exp) {
  return Math.pow(t, exp);
};
goog.fx.easing.easeOut = function(t) {
  return goog.fx.easing.easeOutInternal_(t, 3);
};
goog.fx.easing.easeOutInternal_ = function(t, exp) {
  return 1 - goog.fx.easing.easeInInternal_(1 - t, exp);
};
goog.fx.easing.easeOutLong = function(t) {
  return goog.fx.easing.easeOutInternal_(t, 4);
};
goog.fx.easing.inAndOut = function(t) {
  return 3 * t * t - 2 * t * t * t;
};

// i18n.input.chrome.Statistics
goog.provide('i18n.input.chrome.Statistics');
goog.scope(function() {
var TriggerType = i18n.input.chrome.TriggerType;
i18n.input.chrome.Statistics = function() {
};
goog.addSingletonGetter(i18n.input.chrome.Statistics);
var Statistics = i18n.input.chrome.Statistics;
Statistics.LayoutTypes = {
  COMPACT: 0,
  COMPACT_SYMBOL: 1,
  COMPACT_MORE: 2,
  FULL: 3,
  A11Y: 4,
  HANDWRITING: 5,
  EMOJI: 6,
  MAX: 7
};
Statistics.CommitTypes = {
  X_X0: 0, // User types X, and chooses X as top suggestion.
  X_Y0: 1, // User types X, and chooses Y as top suggestion.
  X_X1: 2, // User types X, and chooses X as 2nd suggestion.
  X_Y1: 3, // User types X, and chooses Y as 2nd suggestion.
  X_X2: 4, // User types X, and chooses X as 3rd/other suggestion.
  X_Y2: 5, // User types X, and chooses Y as 3rd/other suggestion.
  PREDICTION: 6,
  REVERT: 7,
  VOICE: 8,
  MAX: 9
};
Statistics.prototype.inputMethodId_ = '';
Statistics.prototype.autoCorrectLevel_ = 0;
Statistics.prototype.MAX_PAUSE_DURATION_ = 3000;
Statistics.prototype.MIN_WORDS_FOR_WPM_ = 10;
Statistics.prototype.lastActivityTimeStamp_ = 0;
Statistics.prototype.isPhysicalKeyboard_ = false;
Statistics.prototype.lastCommitLength_ = 0;
Statistics.prototype.charactersCommitted_ = 0;
Statistics.prototype.droppedKeys_ = 0;
Statistics.prototype.setPhysicalKeyboard = function(isPhysicalKeyboard) {
  this.isPhysicalKeyboard_ = isPhysicalKeyboard;
};
Statistics.prototype.setInputMethodId = function(
    inputMethodId) {
  this.inputMethodId_ = inputMethodId;
};
Statistics.prototype.setAutoCorrectLevel = function(
    level) {
  this.autoCorrectLevel_ = level;
  this.recordEnum('InputMethod.AutoCorrectLevel', level, 3);
};
Statistics.prototype.recordSessionEnd = function() {
  if (this.charactersCommitted_ > 0) {
    this.recordValue('InputMethod.VirtualKeyboard.CharactersCommitted',
        this.charactersCommitted_, 16384, 50);
  }
  this.droppedKeys_ = 0;
  this.charactersCommitted_ = 0;
  this.lastCommitLength_ = 0;
  this.lastActivityTimeStamp_ = 0;
};
Statistics.prototype.recordCommit = function(
    source, target, targetIndex, triggerType) {
  if (!this.inputMethodId_) {
    return;
  }
  var CommitTypes = Statistics.CommitTypes;
  var commitType = -1;
  var length = target.length;
  if (triggerType == TriggerType.REVERT) {
    length -= this.lastCommitLength_;
    commitType = CommitTypes.REVERT;
  } else if (triggerType == TriggerType.VOICE) {
    commitType = CommitTypes.VOICE;
  } else if (triggerType == TriggerType.RESET) {
    length++;
  } else if (triggerType == TriggerType.CANDIDATE ||
      triggerType == TriggerType.SPACE) {
    if (!source && target) {
      commitType = CommitTypes.PREDICTION;
    } else if (targetIndex == 0 && source == target) {
      commitType = CommitTypes.X_X0;
    } else if (targetIndex == 0 && source != target) {
      commitType = CommitTypes.X_Y0;
    } else if (targetIndex == 1 && source == target) {
      commitType = CommitTypes.X_X1;
    } else if (targetIndex == 1 && source != target) {
      commitType = CommitTypes.X_Y1;
    } else if (targetIndex > 1 && source == target) {
      commitType = CommitTypes.X_X2;
    } else if (targetIndex > 1 && source != target) {
      commitType = CommitTypes.X_Y2;
    }
  }
  this.lastCommitLength_ = length;
  this.charactersCommitted_ += length;
  if (commitType < 0) {
    return;
  }
  var name = this.isPhysicalKeyboard_ ?
      'InputMethod.PkCommit.' : 'InputMethod.Commit.';
  var type = this.isPhysicalKeyboard_ ? 'Type' : 'Type2';
  var self = this;
  var record = function(suffix) {
    self.recordEnum(name + 'Index' + suffix, targetIndex + 1, 20);
    self.recordEnum(name + type + suffix, commitType, CommitTypes.MAX);
  };
  record('');
  if (/^pinyin/.test(this.inputMethodId_)) {
    record('.Pinyin');
  } else if (/^xkb:us/.test(this.inputMethodId_)) {
    record('.US');
    record('.US.AC' + this.autoCorrectLevel_);
  } else if (/^xkb:fr/.test(this.inputMethodId_)) {
    record('.FR');
    record('.FR.AC' + this.autoCorrectLevel_);
  }
};
Statistics.prototype.recordLatency = function(
    name, timeInMs) {
  this.recordValue(name, timeInMs, 1000, 50);
};
Statistics.prototype.getLayoutType = function(layoutCode, isA11yMode) {
  var LayoutTypes = Statistics.LayoutTypes;
  var layoutType = LayoutTypes.MAX;
  if (isA11yMode) {
    layoutType = LayoutTypes.A11Y;
  } else if (/compact/.test(layoutCode)) {
    if (/symbol/.test(layoutCode)) {
      layoutType = LayoutTypes.COMPACT_SYMBOL;
    } else if (/more/.test(layoutCode)) {
      layoutType = LayoutTypes.COMPACT_MORE;
    } else {
      layoutType = LayoutTypes.COMPACT;
    }
  } else if (/^hwt/.test(layoutCode)) {
    layoutType = LayoutTypes.HANDWRITING;
  } else if (/^emoji/.test(layoutCode)) {
    layoutType = LayoutTypes.EMOJI;
  }
  return layoutType;
};
Statistics.prototype.recordLayout = function(
    layoutCode, isA11yMode) {
  this.recordEnum('InputMethod.VirtualKeyboard.Layout',
      this.getLayoutType(layoutCode, isA11yMode), Statistics.LayoutTypes.MAX);
};
Statistics.prototype.recordEnum = function(
    name, enumVal, enumCount) {
  if (chrome.metricsPrivate && chrome.metricsPrivate.recordValue) {
    chrome.metricsPrivate.recordValue({
      'metricName': name,
      'type': 'histogram-linear',
      'min': 0,
      'max': enumCount - 1,
      'buckets': enumCount
    }, enumVal);
  }
};
Statistics.prototype.recordValue = function(
    name, count, max, bucketCount) {
  if (chrome.metricsPrivate && chrome.metricsPrivate.recordValue) {
    chrome.metricsPrivate.recordValue({
      'metricName': name,
      'type': 'histogram-log',
      'min': 0,
      'max': max,
      'buckets': bucketCount
    }, count);
  }
};
Statistics.prototype.recordCharacterKey = function() {
  var now = Date.now();
  if (this.lastActivityTimeStamp_) {
    if (now >= (this.lastActivityTimeStamp_ + this.MAX_PAUSE_DURATION_)) {
      this.droppedKeys_++;
    }
  } else {
    this.droppedKeys_++;
  }
  this.lastActivityTimeStamp_ = now;
};
});  // goog.scope

// i18n.input.chrome.inputview.GesturePreviewWindow
goog.provide('i18n.input.chrome.inputview.GesturePreviewWindow');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var FloatingWindow = i18n.input.chrome.FloatingWindow;
var TagName = goog.dom.TagName;
i18n.input.chrome.inputview.GesturePreviewWindow = function(parentWindow) {
  i18n.input.chrome.inputview.GesturePreviewWindow.base(
      this, 'constructor', parentWindow, undefined,
      GesturePreviewWindow.CSS_FILE_);
  this.setVisible(false);
  this.render();
};
var GesturePreviewWindow = i18n.input.chrome.inputview.GesturePreviewWindow;
goog.inherits(GesturePreviewWindow, FloatingWindow);
GesturePreviewWindow.CSS_FILE_ = 'gesturepreviewwindow_css.css';
GesturePreviewWindow.PADDING_SIDE_ = 70;
GesturePreviewWindow.PER_CHAR_WIDTH_ = 10;
GesturePreviewWindow.WINDOW_HEIGHT_ = 68;
GesturePreviewWindow.Y_OFFSET_ = -140;
GesturePreviewWindow.prototype.textDiv_;
GesturePreviewWindow.prototype.createDom = function() {
  GesturePreviewWindow.base(this, 'createDom');
  var container = this.getElement();
  goog.dom.classlist.add(container, Css.GESTURE_PREVIEW_CONTAINER);
};
GesturePreviewWindow.prototype.show = function(word) {
  this.setWord(word);
  this.resize(
      this.calculateWindowWidth_(word.length),
      GesturePreviewWindow.WINDOW_HEIGHT_);
  this.setVisible(true);
};
GesturePreviewWindow.prototype.setWord = function(word) {
  if (!this.textDiv_) {
    var dom = this.getDomHelper();
    this.textDiv_ = dom.createDom(TagName.DIV, Css.GESTURE_PREVIEW_TEXT);
    dom.appendChild(this.getElement(), this.textDiv_);
  }
  this.textDiv_.textContent = word;
};
GesturePreviewWindow.prototype.calculateWindowWidth_ = function(length) {
  return GesturePreviewWindow.PADDING_SIDE_ +
      GesturePreviewWindow.PER_CHAR_WIDTH_ * length;
};
GesturePreviewWindow.prototype.hide = function() {
  this.setVisible(false);
};
GesturePreviewWindow.prototype.reposition = function(position) {
  position.y += Math.round(GesturePreviewWindow.Y_OFFSET_);
  position.x -= Math.round(this.parentWindow.contentWindow.innerWidth / 2);
  GesturePreviewWindow.base(
      this, 'reposition', convertToScreenCoordinate(position));
};
function convertToScreenCoordinate(coordinate) {
  var screenCoordinate = coordinate.clone();
  screenCoordinate.y += screen.height - window.innerHeight;
  return screenCoordinate;
};
});  // goog.scope

// i18n.input.chrome.inputview.PointerConfig
goog.provide('i18n.input.chrome.inputview.PointerConfig');
i18n.input.chrome.inputview.PointerConfig = function(dblClick,
    longPressWithPointerUp, longPressWithoutPointerUp) {
  this.dblClick = dblClick;
  this.dblClickDelay = 0;
  this.longPressWithPointerUp = longPressWithPointerUp;
  this.longPressWithoutPointerUp = longPressWithoutPointerUp;
  this.flickerDirection = 0;
  this.longPressDelay = 0;
  this.stopEventPropagation = true;
  this.preventDefault = true;
};

// i18n.input.chrome.inputview.elements.Element
goog.provide('i18n.input.chrome.inputview.elements.Element');
goog.scope(function() {
i18n.input.chrome.inputview.elements.Element = function(id, type,
    opt_eventTarget) {
  goog.base(this);
  this.setParentEventTarget(opt_eventTarget || null);
  this.id = id;
  this.type = type;
  this.display_ = '';
  this.handler = new goog.events.EventHandler(this);
  this.pointerConfig = new i18n.input.chrome.inputview.PointerConfig(false,
      false, false);
};
goog.inherits(i18n.input.chrome.inputview.elements.Element, goog.ui.Component);
var Element = i18n.input.chrome.inputview.elements.Element;
Element.prototype.width;
Element.prototype.height;
Element.prototype.resize = function(width, height) {
  this.width = width;
  this.height = height;
};
Element.prototype.createDom = function() {
  goog.base(this, 'createDom');
  this.getElement().id = this.id;
  this.getElement()['view'] = this;
};
Element.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.display_ = this.getElement().style.display;
};
Element.prototype.isVisible = function() {
  return goog.style.isElementShown(this.getElement());
};
Element.prototype.setVisible = function(visibility) {
  var element = this.getElement();
  if (element)
    element.style.display = visibility ? this.display_ : 'none';
};
Element.prototype.update = function() {
  this.setHighlighted(false);
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    child.update();
  }
};
Element.prototype.setHighlighted = function(
    highlight) {
  if (highlight) {
    goog.dom.classlist.add(this.getElement(),
        i18n.input.chrome.inputview.Css.ELEMENT_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.getElement(),
        i18n.input.chrome.inputview.Css.ELEMENT_HIGHLIGHT);
  }
};
Element.prototype.disposeInternal = function() {
  this.getElement()['view'] = null;
  goog.dispose(this.handler);
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.inputview.util
goog.provide('i18n.input.chrome.inputview.util');
goog.scope(function() {
var util = i18n.input.chrome.inputview.util;
util.DISPLAY_MAPPING = {
  '\u0300' : '\u0060',
  '\u0301' : '\u00B4',
  '\u0302' : '\u02C6',
  '\u0303' : '\u02DC',
  '\u0304' : '\u02c9',
  '\u0305' : '\u00AF',
  '\u0306' : '\u02D8',
  '\u0307' : '\u02D9',
  '\u0308' : '\u00a8',
  '\u0309' : '\u02C0',
  '\u030A' : '\u02DA',
  '\u030B' : '\u02DD',
  '\u030C' : '\u02C7',
  '\u030D' : '\u02C8',
  '\u030E' : '\u0022',
  '\u0327' : '\u00B8',
  '\u0328' : '\u02DB',
  '\u0345' : '\u037A',
  '\u030F' : '\u030F\u0020',
  '\u031B' : '\u031B\u0020',
  '\u0323' : '\u0323\u0020'
};
util.CASE_LOWER_TO_UPPER_MAPPING_ = {
  '\u00b5': '\u00b5',
  '\u3142': '\u3143',
  '\u3148': '\u3149',
  '\u3137': '\u3138',
  '\u3131': '\u3132',
  '\u3145': '\u3146',
  '\u1162': '\u1164',
  '\u1166': '\u1168'
};
util.CASE_UPPER_TO_LOWER_MAPPING_ = {
  '\u0049': '\u0131'
};
util.KEYSETS_USE_US = [
  'array',
  'cangjie',
  'dayi',
  'jp_us',
  'pinyin-zh-CN',
  'pinyin-zh-TW',
  'quick',
  't13n',
  'wubi',
  'zhuyin.us',
  'ko.set2.us',
  'ko.set390.us',
  'ko.set3final.us',
  'ko.set3sun.us',
  'ko.romaja.us',
  'ko.ahn.us',
  'ko.set2y.us',
  'ko.set3yet.us',
  'ko.set32.us'
];
util.KEYSETS_HAVE_EN_SWTICHER = [
  'array',
  'cangjie',
  'dayi',
  'pinyin-zh-CN',
  'pinyin-zh-TW',
  'quick',
  'wubi',
  'zhuyin',
  'zhuyin.us'
];
util.KEYSETS_SWITCH_WITH_US = [
  'zhuyin',
  'ko.set2',
  'ko.set390',
  'ko.set3final',
  'ko.set3sun',
  'ko.romaja',
  'ko.ahn',
  'ko.set2y',
  'ko.set3yet',
  'ko.set32'
];
util.KEYSETS_HAVE_COMPACT = [
  'ca',
  'ca-eng',
  'de',
  'dk',
  'fi',
  'fr',
  'gb-extd',
  'ie',
  'is',
  'nl',
  'no',
  'pinyin-zh-CN',
  'se',
  'us',
  'zhuyin'
];
util.END_SENTENCE_REGEX_ = /[\.\?!] +$/;
util.REGEX_CHARACTER_SUPPORT_DEADKEY_ =
    /^[a-zA-ZæÆœŒΑΕΗΙΟΥΩαεηιυοωϒ]+$/;
util.REGEX_LANGUAGE_MODEL_CHARACTERS =
    /(?=[^\u00d7\u00f7])[a-z\-\'\u00c0-\u017F]/i;
util.splitValue = function(weightArray, totalValue) {
  if (weightArray.length == 0) {
    return [];
  }
  if (weightArray.length == 1) {
    return [totalValue];
  }
  var totalWeight = 0;
  for (var i = 0; i < weightArray.length; i++) {
    totalWeight += weightArray[i];
  }
  var tmp = totalValue / totalWeight;
  var values = [];
  var totalFlooredValue = 0;
  var diffs = [];
  for (var i = 0; i < weightArray.length; i++) {
    var result = weightArray[i] * tmp;
    values.push(result);
    diffs.push(result - Math.floor(result));
    totalFlooredValue += Math.floor(result);
  }
  var diff = totalValue - totalFlooredValue;
  for (var i = 0; i < diff; i++) {
    var max = 0;
    var index = 0;
    for (var j = 0; j < diffs.length; j++) {
      if (diffs[j] > max) {
        max = diffs[j];
        index = j;
      }
    }
    values[index] += 1;
    diffs[index] = 0;
  }
  for (var i = 0; i < values.length; i++) {
    values[i] = Math.floor(values[i]);
  }
  return values;
};
util.getPropertyValue = function(elem, property) {
  var value = goog.style.getComputedStyle(elem, property);
  if (value) {
    return parseInt(value.replace('px', ''), 10);
  }
  return 0;
};
util.toUpper = function(character) {
  var upper = util.CASE_LOWER_TO_UPPER_MAPPING_[character];
  if (upper) {
    return upper;
  }
  return character.toUpperCase();
};
util.toLower = function(character) {
  var lower = util.CASE_UPPER_TO_LOWER_MAPPING_[character];
  if (lower) {
    return lower;
  }
  return character.toLowerCase();
};
util.isCommitCharacter = function(character) {
  if (util.DISPLAY_MAPPING[character] ||
      util.REGEX_LANGUAGE_MODEL_CHARACTERS.test(
          character)) {
    return false;
  }
  return true;
};
util.getVisibleCharacter = function(invisibleCharacter) {
  var map = util.DISPLAY_MAPPING;
  if (map[invisibleCharacter]) {
    return map[invisibleCharacter];
  }
  if (/[\u0591-\u05cf]/.test(invisibleCharacter)) {
    return '\u00a0' + invisibleCharacter;
  }
  return invisibleCharacter;
};
util.isLetterKey = function(characters) {
  if (characters[1] == util.toUpper(
      characters[0]) || characters[1] == util.
          toLower(characters[0])) {
    return true;
  }
  return false;
};
util.supportDeadKey = function(character) {
  return util.REGEX_CHARACTER_SUPPORT_DEADKEY_.
      test(character);
};
util.needAutoCap = function(text) {
  if (goog.string.isEmptyOrWhitespace(text)) {
    return false;
  } else {
    return util.END_SENTENCE_REGEX_.test(text);
  }
};
util.getConfigName = function(keyboardCode) {
  return keyboardCode.replace(/\..*$/, '');
};
});  // goog.scope

// i18n.input.chrome.inputview.Accents
goog.provide('i18n.input.chrome.inputview.Accents');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var FloatingWindow = i18n.input.chrome.FloatingWindow;
var TagName = goog.dom.TagName;
i18n.input.chrome.inputview.Accents = function(parentWindow) {
  i18n.input.chrome.inputview.Accents.base(this, 'constructor',
      parentWindow, undefined, Accents.CSS_FILE_);
};
var Accents = i18n.input.chrome.inputview.Accents;
goog.inherits(Accents, FloatingWindow);
Accents.CSS_FILE_ = 'accents_css.css';
Accents.prototype.highlightedItem_ = null;
Accents.prototype.createDom = function() {
  Accents.base(this, 'createDom');
  var container = this.getElement();
  goog.dom.classlist.add(container, Css.ACCENT_CONTAINER);
  container.id = 'container';
};
Accents.prototype.getHighlightedAccent = function() {
  return this.highlightedItem_ ?
      this.highlightedItem_.textContent.trim() : '';
};
Accents.prototype.highlightItem = function(x, y, offset) {
  var highlightedItem = this.getHighlightedItem_(x, y, offset);
  if (this.highlightedItem_ != highlightedItem) {
    if (this.highlightedItem_) {
      goog.dom.classlist.remove(this.highlightedItem_, Css.ELEMENT_HIGHLIGHT);
    }
    this.highlightedItem_ = highlightedItem;
    if (this.highlightedItem_ &&
        this.highlightedItem_.textContent.trim()) {
      goog.dom.classlist.add(this.highlightedItem_, Css.ELEMENT_HIGHLIGHT);
    }
  }
};
Accents.prototype.getHighlightedItem_ = function(x, y, offset) {
  var dom = this.getDomHelper();
  var row = null;
  var rows = dom.getElementsByClass(Css.ACCENT_ROW);
  for (var i = 0; i < rows.length; i++) {
    var coordinate = goog.style.getClientPosition(rows[i]);
    var size = goog.style.getSize(rows[i]);
    var screenYStart = (i == 0 ? coordinate.y - offset : coordinate.y);
    var screenYEnd = coordinate.y + size.height;
    screenYEnd = i == rows.length - 1 ? screenYEnd + offset : screenYEnd;
    if (screenYStart < y && screenYEnd > y) {
      row = rows[i];
      break;
    }
  }
  if (row) {
    var children = dom.getChildren(row);
    for (var i = 0; i < children.length; i++) {
      var coordinate = goog.style.getClientPosition(children[i]);
      var size = goog.style.getSize(children[i]);
      var screenXStart = (i == 0 ? coordinate.x - offset : coordinate.x);
      var screenXEnd = coordinate.x + size.width;
      screenXEnd = i == children.length - 1 ? screenXEnd + offset : screenXEnd;
      if (screenXStart < x && screenXEnd > x) {
        return children[i];
      }
    }
  }
  return null;
};
Accents.prototype.setAccents = function(accents, numOfColumns, numOfRows, width,
    height, startKeyIndex, isCompact) {
  var dom = this.getDomHelper();
  var container = this.getElement();
  dom.removeChildren(container);
  var orderedAccents = this.reorderAccents_(accents, numOfColumns, numOfRows,
      startKeyIndex);
  var row = null;
  for (var i = 0; i < orderedAccents.length; i++) {
    var keyElem = dom.createDom(TagName.DIV, Css.ACCENT_KEY);
    var textDiv = dom.createElement(TagName.DIV);
    var text = i18n.input.chrome.inputview.util.getVisibleCharacter(
        orderedAccents[i]);
    textDiv.textContent = text;
    goog.dom.classlist.add(textDiv, text.length > 1 ? Css.FONT_SMALL :
        (isCompact ? Css.ACCENT_COMPACT_FONT : Css.ACCENT_FULL_FONT));
    goog.style.setStyle(textDiv, 'lineHeight', height + 'px');
    dom.appendChild(keyElem, textDiv);
    if (!orderedAccents[i]) {
      goog.dom.classlist.add(keyElem, Css.ACCENT_EMPTY_KEY);
    }
    goog.style.setSize(keyElem, width, height);
    if (i % numOfColumns == 0) {
      if (row) {
        container.appendChild(row);
      }
      row = dom.createDom(TagName.DIV, Css.ACCENT_ROW);
    }
    dom.appendChild(row, keyElem);
  }
  dom.appendChild(container, row);
};
Accents.prototype.reorderAccents_ = function(accents, numOfColumns, numOfRows,
    startKeyIndex) {
  var orderedAccents = new Array(numOfColumns * numOfRows);
  var index = 0;
  var rowOrder = new Array(numOfColumns);
  rowOrder[startKeyIndex] = index;
  for (var i = 1;
      startKeyIndex + i < numOfColumns || startKeyIndex - i >= 0;
      i++) {
    if (startKeyIndex + i < numOfColumns) {
      rowOrder[startKeyIndex + i] = ++index;
    }
    if (startKeyIndex - i >= 0) {
      rowOrder[startKeyIndex - i] = ++index;
    }
  }
  for (var i = numOfRows - 1; i >= 0; i--) {
    for (var j = numOfColumns - 1; j >= 0; j--) {
      index = rowOrder[j] + numOfColumns * (numOfRows - i - 1);
      if (index >= accents.length) {
        orderedAccents[i * numOfColumns + j] = '';
      } else {
        orderedAccents[i * numOfColumns + j] = accents[index];
      }
    }
  }
  return orderedAccents;
};
});  // goog.scope

// i18n.input.chrome.inputview.handler.Util
goog.provide('i18n.input.chrome.inputview.handler.Util');
goog.scope(function() {
var Util = i18n.input.chrome.inputview.handler.Util;
Util.MOUSE_EVENT_IDENTIFIER = -1;
Util.INVALID_EVENT_IDENTIFIER = -2;
Util.getView = function(target) {
  if (!target) {
    return null;
  }
  var element =  (target);
  var view = element['view'];
  while (!view && element) {
    view = element['view'];
    element = goog.dom.getParentElement(element);
  }
  return view;
};
Util.getEventIdentifier = function(e) {
  var nativeEvt = e.getBrowserEvent ? e.getBrowserEvent() : e;
  if (nativeEvt.changedTouches) {
    if (e.type == goog.events.EventType.TOUCHMOVE) {
      console.error('TouchMove is not expected.');
    }
    nativeEvt = nativeEvt.changedTouches[0];
  }
  return nativeEvt.identifier === undefined ?
      Util.MOUSE_EVENT_IDENTIFIER : nativeEvt.identifier;
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.AltDataView
goog.provide('i18n.input.chrome.inputview.elements.content.AltDataView');
goog.scope(function() {
var Accents = i18n.input.chrome.inputview.Accents;
var ElementType = i18n.input.chrome.ElementType;
var Util = i18n.input.chrome.inputview.handler.Util;
function convertToScreenCoordinate(coordinate) {
  var screenCoordinate = coordinate.clone();
  screenCoordinate.y += screen.height - window.innerHeight;
  return screenCoordinate;
};
i18n.input.chrome.inputview.elements.content.AltDataView = function(
    opt_eventTarget) {
  goog.base(this, '', ElementType.ALTDATA_VIEW, opt_eventTarget);
  this.altdataElements_ = [];
  this.altdataWindow_ = null;
  this.useIMEWindow_ = !!(chrome.app.window && chrome.app.window.create);
  this.floatingWndPos_;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.AltDataView,
    i18n.input.chrome.inputview.elements.Element);
var AltDataView = i18n.input.chrome.inputview.elements.content.AltDataView;
AltDataView.PADDING_ = 8;
AltDataView.ACCENTS_WINDOW_URL_ = 'imewindows/accents.html';
AltDataView.INVALIDINDEX_ = -1;
AltDataView.FINGER_DISTANCE_TO_CANCEL_ALTDATA_ = 100;
AltDataView.DEFAULT_MAX_COLUMNS_ = 5;
AltDataView.prototype.coverElement_;
AltDataView.prototype.highlightIndex_ = AltDataView.INVALIDINDEX_;
AltDataView.prototype.triggeredBy;
AltDataView.prototype.identifier = Util.INVALID_EVENT_IDENTIFIER;
AltDataView.prototype.visible_ = false;
AltDataView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.ALTDATA_VIEW);
  this.coverElement_ = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.ALTDATA_COVER);
  dom.appendChild(dom.getDocument().body, this.coverElement_);
  goog.style.setElementShown(this.coverElement_, false);
  this.coverElement_['view'] = this;
};
AltDataView.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  goog.style.setElementShown(this.getElement(), false);
};
AltDataView.prototype.show = function(key, isRTL, identifier) {
  this.triggeredBy = key;
  this.identifier = identifier;
  var parentKeyLeftTop = goog.style.getClientPosition(key.getElement());
  var width = key.availableWidth;
  var height = key.availableHeight;
  var characters;
  var fixedColumns = 0;
  var isCompact = key.type == ElementType.COMPACT_KEY;
  if (key.type == ElementType.CHARACTER_KEY) {
    key = 
 (key);
    characters = key.getAltCharacters();
  } else if (isCompact) {
    key = 
 (key);
    characters = key.getMoreCharacters();
    fixedColumns = key.getFixedColumns();
    if (key.hintText) {
      var index = goog.array.indexOf(characters,
          i18n.input.chrome.inputview.content.Constants.HINT_TEXT_PLACE_HOLDER);
      if (index != -1) {
        goog.array.splice(characters, index, 1, key.hintText);
      } else {
        goog.array.insertAt(characters, key.hintText, 0);
      }
    }
  }
  if (!characters || characters.length == 0) {
    return;
  }
  this.visible_ = true;
  goog.style.setElementShown(this.getElement(), true);
  this.getDomHelper().removeChildren(this.getElement());
  var w = isCompact ? Math.round(width * 0.8) : Math.round(width * 0.9);
  var h = isCompact ? Math.round(height * 0.8) : Math.round(height * 0.9);
  if (this.useIMEWindow_) {
    var numOfKeys = characters.length;
    var maxColumns =
        fixedColumns ? fixedColumns : this.getOptimizedMaxColumns_(numOfKeys);
    var numOfColumns = Math.min(numOfKeys, maxColumns);
    var numOfRows = Math.ceil(numOfKeys / numOfColumns);
    var startKeyIndex = this.getStartKeyIndex_(parentKeyLeftTop.x, numOfColumns,
        width, screen.width);
    var altDataWindowWidth = numOfColumns * w;
    var altDataWindowHeight = numOfRows * h;
    var windowTop = parentKeyLeftTop.y - altDataWindowHeight -
        AltDataView.PADDING_;
    var windowLeft = parentKeyLeftTop.x - startKeyIndex * w;
    this.floatingWndPos_ = convertToScreenCoordinate(
        new goog.math.Coordinate(windowLeft, windowTop));
    if (this.altdataWindow_) {
      this.altdataWindow_.setAccents(characters, numOfColumns,
          numOfRows, w, h, startKeyIndex, isCompact);
      this.highlightItem(Math.ceil(parentKeyLeftTop.x + w / 2),
          Math.ceil(parentKeyLeftTop.y + h / 2),
          identifier);
      this.altdataWindow_.reposition(this.floatingWndPos_);
      this.altdataWindow_.setVisible(true);
    } else {
      i18n.input.chrome.WindowUtil.createWindow(
          function(newWindow) {
            this.altdataWindow_ = new Accents(newWindow);
            this.altdataWindow_.render();
            this.altdataWindow_.setAccents(characters, numOfColumns,
                numOfRows, w, h, startKeyIndex, isCompact);
            this.highlightItem(Math.ceil(parentKeyLeftTop.x + w / 2),
                Math.ceil(parentKeyLeftTop.y + h / 2), identifier);
            this.altdataWindow_.reposition(this.floatingWndPos_);
            this.altdataWindow_.setVisible(this.visible_);
          }.bind(this));
    }
  } else {
    var altDataWindowWidth = w * characters.length;
    var altDataWindowHeight = h;
    var left = parentKeyLeftTop.x;
    if ((left + altDataWindowWidth) > screen.width) {
      left = parentKeyLeftTop.x + w - altDataWindowWidth;
      characters.reverse();
    }
    var elemTop = parentKeyLeftTop.y - altDataWindowHeight -
        AltDataView.PADDING_;
    if (elemTop < 0) {
      elemTop = parentKeyLeftTop.y + h + AltDataView.PADDING_;
    }
    for (var i = 0; i < characters.length; i++) {
      var keyElem = this.addKey_(characters[i], isRTL);
      goog.style.setSize(keyElem, w, h);
      this.altdataElements_.push(keyElem);
      if (i != characters.length - 1) {
        this.addSeparator_(height);
      }
    }
    this.highlightItem(Math.ceil(parentKeyLeftTop.x + w / 2),
                       Math.ceil(parentKeyLeftTop.y + h / 2),
                       identifier);
    goog.style.setPosition(this.getElement(), left, elemTop);
  }
  goog.style.setElementShown(this.coverElement_, true);
  this.triggeredBy.setHighlighted(true);
};
AltDataView.prototype.getStartKeyIndex_ = function(parentKeyLeft, numOfColumns,
    width, screenWidth) {
  var startKeyIndex = Math.floor((numOfColumns - 1) / 2);
  var numOfLeftKeys = startKeyIndex;
  var numOfRightKeys = numOfColumns - startKeyIndex;
  var maxLeftKeys = Math.floor(parentKeyLeft / width);
  var maxRightKeys = Math.floor((screenWidth - parentKeyLeft) / width);
  if (maxLeftKeys + maxRightKeys < numOfColumns) {
    console.error('There are too many keys in a row.');
  } else if (numOfLeftKeys > maxLeftKeys) {
    startKeyIndex = maxLeftKeys;
  } else if (numOfRightKeys > maxRightKeys) {
    startKeyIndex = numOfColumns - maxRightKeys;
  }
  return startKeyIndex;
};
AltDataView.prototype.getTopRowEmptySlots_ = function(numOfKeys, numOfColumns) {
  var remaining = numOfKeys % numOfColumns;
  return remaining == 0 ? 0 : numOfColumns - remaining;
};
AltDataView.prototype.getOptimizedMaxColumns_ = function(numOfKeys) {
  var numOfColumns = Math.min(numOfKeys, AltDataView.DEFAULT_MAX_COLUMNS_);
  var numOfRows = Math.ceil(numOfKeys / AltDataView.DEFAULT_MAX_COLUMNS_);
  while (this.getTopRowEmptySlots_(numOfKeys, numOfColumns) >= numOfRows) {
    numOfColumns--;
  }
  return numOfColumns;
};
AltDataView.prototype.hide = function() {
  this.visible_ = false;
  if (this.useIMEWindow_ && this.altdataWindow_) {
    this.altdataWindow_.dispose();
    this.altdataWindow_ = null;
  } else {
    this.altdataElements_ = [];
  }
  if (this.triggeredBy) {
    this.triggeredBy.setHighlighted(false);
  }
  goog.style.setElementShown(this.getElement(), false);
  goog.style.setElementShown(this.coverElement_, false);
  this.highlightIndex_ = AltDataView.INVALIDINDEX_;
};
AltDataView.prototype.highlightItem = function(x, y, identifier) {
  if (this.identifier != identifier) {
    return;
  }
  if (this.useIMEWindow_) {
    goog.Timer.callOnce(function() {
      if (this.altdataWindow_) {
        var screenCoordinate = convertToScreenCoordinate(
            new goog.math.Coordinate(x, y));
        this.altdataWindow_.highlightItem(
            screenCoordinate.x - this.floatingWndPos_.x,
            screenCoordinate.y - this.floatingWndPos_.y,
            AltDataView.FINGER_DISTANCE_TO_CANCEL_ALTDATA_);
      }
    }, 0, this);
  } else {
    for (var i = 0; i < this.altdataElements_.length; i++) {
      var elem = this.altdataElements_[i];
      var coordinate = goog.style.getClientPosition(elem);
      var size = goog.style.getSize(elem);
      if (coordinate.x < x && (coordinate.x + size.width) > x) {
        this.highlightIndex_ = i;
        this.clearAllHighlights_();
        this.setElementBackground_(elem, true);
      }
      var verticalDist = Math.min(Math.abs(y - coordinate.y),
          Math.abs(y - coordinate.y - size.height));
      if (verticalDist > AltDataView.
          FINGER_DISTANCE_TO_CANCEL_ALTDATA_) {
        this.hide();
        return;
      }
    }
  }
};
AltDataView.prototype.clearAllHighlights_ =
    function() {
  for (var i = 0; i < this.altdataElements_.length; i++) {
    this.setElementBackground_(this.altdataElements_[i], false);
  }
};
AltDataView.prototype.setElementBackground_ =
    function(element, highlight) {
  if (highlight) {
    goog.dom.classlist.add(element, i18n.input.chrome.inputview.Css.
        ELEMENT_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(element, i18n.input.chrome.inputview.Css.
        ELEMENT_HIGHLIGHT);
  }
};
AltDataView.prototype.getHighlightedCharacter = function() {
  if (this.useIMEWindow_) {
    return this.altdataWindow_.getHighlightedAccent();
  } else {
    return goog.dom.getTextContent(this.altdataElements_[this.highlightIndex_]);
  }
};
AltDataView.prototype.addKey_ = function(character, isRTL) {
  var dom = this.getDomHelper();
  var keyElem = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.ALTDATA_KEY,
      i18n.input.chrome.inputview.util.getVisibleCharacter(character));
  keyElem.style.direction = isRTL ? 'rtl' : 'ltr';
  dom.appendChild(this.getElement(), keyElem);
  return keyElem;
};
AltDataView.prototype.addSeparator_ = function(height) {
  var dom = this.getDomHelper();
  var tableCell = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.TABLE_CELL);
  tableCell.style.height = height + 'px';
  var separator = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.ALTDATA_SEPARATOR);
  dom.appendChild(tableCell, separator);
  dom.appendChild(this.getElement(), tableCell);
};
AltDataView.prototype.getCoverElement = function() {
  return this.coverElement_;
};
AltDataView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  this.hide();
  goog.style.setSize(this.coverElement_, width, height);
};
AltDataView.prototype.disposeInternal = function() {
  this.getElement()['view'] = null;
  goog.dispose(this.altdataWindow_);
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.Candidate
goog.provide('i18n.input.chrome.inputview.elements.content.Candidate');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
var Css = i18n.input.chrome.inputview.Css;
var TagName = goog.dom.TagName;
var Name = i18n.input.chrome.message.Name;
i18n.input.chrome.inputview.elements.content.Candidate = function(id,
    candidate, candidateType, height, isDefault, opt_width,
    opt_eventTarget) {
  goog.base(this, id, ElementType.CANDIDATE, opt_eventTarget);
  this.candidate = candidate;
  this.candidateType = candidateType;
  this.width = opt_width || 0;
  this.height = height;
  this.isDefault = isDefault;
};
var Candidate = i18n.input.chrome.inputview.elements.content.Candidate;
goog.inherits(Candidate, i18n.input.chrome.inputview.elements.Element);
Candidate.Type = {
  CANDIDATE: 0,
  NUMBER: 1,
  TOOLTIP: 2
};
Candidate.prototype.wrapper_ = null;
Candidate.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem, Css.CANDIDATE);
  if (this.candidate['isEmoji']) {
    goog.dom.classlist.add(elem, Css.EMOJI_FONT);
  }
  if (this.candidateType == Candidate.Type.NUMBER) {
    goog.dom.classlist.add(elem, Css.CANDIDATE_NUMBER);
  }
  if (this.candidateType == Candidate.Type.TOOLTIP) {
    goog.dom.classlist.add(elem, Css.TOOLTIP);
  }
  this.wrapper_ = dom.createDom('div', {
    'class': Css.CANDIDATE_INTERNAL_WRAPPER
  }, this.candidate[Name.CANDIDATE]);
  dom.appendChild(elem, this.wrapper_);
  this.setSize(this.width, this.height);
  if (this.isDefault) {
    goog.dom.classlist.add(elem, Css.CANDIDATE_DEFAULT);
  }
  if (!!this.candidate[Name.IS_AUTOCORRECT]) {
    goog.dom.classlist.add(elem, Css.CANDIDATE_AUTOCORRECT);
  }
};
Candidate.prototype.setSize = function(opt_width, opt_height) {
  var elem = this.getElement();
  if (opt_width && opt_width > 0) {
    this.width = opt_width;
    this.wrapper_.style.width = opt_width + 'px';
    elem.style.width = opt_width + 'px';
  }
  if (opt_height && opt_height > 0) {
    this.height = opt_height;
    elem.style.height = opt_height + 'px';
  }
};
Candidate.prototype.setHighlighted = function(highlight) {
  if (highlight) {
    goog.dom.classlist.add(this.getElement(), Css.CANDIDATE_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.getElement(), Css.CANDIDATE_HIGHLIGHT);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CandidateButton
goog.provide('i18n.input.chrome.inputview.elements.content.CandidateButton');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.content.CandidateButton = function(
    id, type, iconCss, text, opt_eventTarget, opt_noSeparator) {
  goog.base(this, id, type, opt_eventTarget);
  this.text = text;
  this.iconCss = iconCss;
  this.hasSeperator_ = !opt_noSeparator;
};
var CandidateButton = i18n.input.chrome.inputview.elements.content.
    CandidateButton;
goog.inherits(CandidateButton, i18n.input.chrome.inputview.elements.Element);
CandidateButton.prototype.iconCell;
CandidateButton.prototype.separatorCell;
CandidateButton.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.addAll(elem, [Css.CANDIDATE_INTER_CONTAINER,
    Css.CANDIDATE_BUTTON]);
  if (this.hasSeperator_) {
    this.separatorCell = this.createSeparator_();
  }
  this.iconCell = dom.createDom(goog.dom.TagName.DIV, Css.TABLE_CELL);
  dom.appendChild(elem, this.iconCell);
  var iconElem = dom.createDom(goog.dom.TagName.DIV, Css.INLINE_DIV);
  if (this.iconCss) {
    goog.dom.classlist.add(iconElem, this.iconCss);
  }
  if (this.text) {
    dom.setTextContent(iconElem, this.text);
  }
  dom.appendChild(this.iconCell, iconElem);
};
CandidateButton.prototype.createSeparator_ = function() {
  var dom = this.getDomHelper();
  var tableCell = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.TABLE_CELL);
  var separator = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.CANDIDATE_SEPARATOR);
  separator.style.height = '32%';
  dom.appendChild(tableCell, separator);
  dom.appendChild(this.getElement(), tableCell);
  return tableCell;
};
CandidateButton.prototype.resize = function(width, height) {
  if (this.hasSeperator_) {
    goog.style.setSize(this.separatorCell, 1, height);
  }
  goog.style.setSize(this.iconCell, width - 1, height);
  goog.base(this, 'resize', width, height);
};
CandidateButton.prototype.setVisible = function(visible) {
  var ret = CandidateButton.base(this, 'setVisible', visible);
  if (this.type == ElementType.VOICE_BTN) {
    var elem = this.getElement();
    if (!elem) {
      elem.style.webkitAnimation = (visible ? 'visible' : 'invisible') +
          '-animation .4s ease';
    }
  }
  return ret;
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.DragButton
goog.provide('i18n.input.chrome.inputview.elements.content.DragButton');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.content.DragButton = function(id, type,
    iconCssClass, opt_eventTarget) {
  i18n.input.chrome.inputview.elements.content.DragButton.base(this,
      'constructor', id, type, opt_eventTarget);
  this.iconCssClass_ = iconCssClass;
  this.pointerConfig.stopEventPropagation = false;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.DragButton,
    i18n.input.chrome.inputview.elements.Element);
var DragButton = i18n.input.chrome.inputview.elements.content.DragButton;
DragButton.prototype.dragger_;
DragButton.prototype.iconCell_;
DragButton.prototype.createDom = function() {
  DragButton.base(this, 'createDom');
  var elem = this.getElement();
  var dom = goog.dom.getDomHelper();
  goog.dom.classlist.addAll(elem, [Css.CANDIDATE_INTER_CONTAINER,
    Css.TOOLBAR_BUTTON, Css.FLOAT_LEFT]);
  this.iconCell_ = dom.createDom(goog.dom.TagName.DIV, Css.TABLE_CELL);
  dom.appendChild(elem, this.iconCell_);
  var iconElem = dom.createDom(goog.dom.TagName.DIV, Css.INLINE_DIV);
  goog.dom.classlist.add(iconElem, this.iconCssClass_);
  dom.appendChild(this.iconCell_, iconElem);
  var ariaLabel = chrome.i18n.getMessage('DRAG_BUTTON');
  goog.a11y.aria.setState( (elem),
      goog.a11y.aria.State.LABEL, ariaLabel);
};
DragButton.prototype.enterDocument = function() {
  DragButton.base(this, 'enterDocument');
  this.dragger_ = new i18n.input.chrome.FloatingWindowDragger(window,
      this.getElement());
};
DragButton.prototype.resize = function(width, height) {
  goog.style.setSize(this.iconCell_, width, height);
  DragButton.base(this, 'resize', width, height);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.ToolbarButton
goog.provide('i18n.input.chrome.inputview.elements.content.ToolbarButton');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.content.ToolbarButton = function(
    id, type, iconCss, text, opt_eventTarget, opt_alignLeft) {
  goog.base(this, id, type, opt_eventTarget);
  this.text = text;
  this.iconCss = iconCss;
  this.alignLeft = opt_alignLeft || false;
};
var ToolbarButton = i18n.input.chrome.inputview.elements.content.
    ToolbarButton;
goog.inherits(ToolbarButton, i18n.input.chrome.inputview.elements.Element);
ToolbarButton.prototype.iconCell;
ToolbarButton.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  var css = [Css.CANDIDATE_INTER_CONTAINER,
    Css.TOOLBAR_BUTTON];
  if (this.alignLeft) {
    css.push(Css.FLOAT_LEFT);
  }
  goog.dom.classlist.addAll(elem, css);
  this.iconCell = dom.createDom(goog.dom.TagName.DIV, Css.TABLE_CELL);
  dom.appendChild(elem, this.iconCell);
  var iconElem = dom.createDom(goog.dom.TagName.DIV, Css.INLINE_DIV);
  if (this.iconCss) {
    goog.dom.classlist.add(iconElem, this.iconCss);
  }
  if (this.text) {
    dom.setTextContent(iconElem, this.text);
  }
  dom.appendChild(this.iconCell, iconElem);
};
ToolbarButton.prototype.setHighlighted = function(highlight) {
  if (highlight) {
    goog.dom.classlist.add(this.getElement(), Css.CANDIDATE_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.getElement(), Css.CANDIDATE_HIGHLIGHT);
  }
};
ToolbarButton.prototype.resize = function(width, height) {
  goog.style.setSize(this.iconCell, width, height);
  goog.base(this, 'resize', width, height);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CandidateView
goog.provide('i18n.input.chrome.inputview.elements.content.CandidateView');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var TagName = goog.dom.TagName;
var Candidate = i18n.input.chrome.inputview.elements.content.Candidate;
var Type = i18n.input.chrome.inputview.elements.content.Candidate.Type;
var ElementType = i18n.input.chrome.ElementType;
var content = i18n.input.chrome.inputview.elements.content;
var Name = i18n.input.chrome.message.Name;
var util = i18n.input.chrome.inputview.util;
i18n.input.chrome.inputview.elements.content.CandidateView = function(id,
    adapter, opt_eventTarget) {
  goog.base(this, id, ElementType.CANDIDATE_VIEW, opt_eventTarget);
  this.adapter_ = adapter;
  this.iconButtons_ = [];
  this.iconButtons_[IconType.BACK] = new content.CandidateButton(
      '', ElementType.BACK_BUTTON, '',
      chrome.i18n.getMessage('HANDWRITING_BACK'), this);
  this.iconButtons_[IconType.SHRINK_CANDIDATES] = new content.
      CandidateButton('', ElementType.SHRINK_CANDIDATES,
          Css.SHRINK_CANDIDATES_ICON, '', this);
  this.iconButtons_[IconType.EXPAND_CANDIDATES] = new content.
      CandidateButton('', ElementType.EXPAND_CANDIDATES,
          Css.EXPAND_CANDIDATES_ICON, '', this);
  this.iconButtons_[IconType.VOICE] = new content.CandidateButton('',
      ElementType.VOICE_BTN, Css.VOICE_MIC_BAR, '', this, true);
  this.fvkButtons_ = [];
  this.fvkButtons_.push(new content.
      DragButton('', ElementType.DRAG, Css.DRAG_BUTTON, this));
  this.toolbarButtons_ = [];
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.UNDO, Css.UNDO_ICON, '', this, true));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.REDO, Css.REDO_ICON, '', this, true));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.BOLD, Css.BOLD_ICON, '', this, true));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.ITALICS, Css.ITALICS_ICON, '', this, true));
  this.toolbarButtons_.push(new content.ToolbarButton(
      '', ElementType.UNDERLINE, Css.UNDERLINE_ICON, '', this, true));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.CUT, Css.CUT_ICON, '', this));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.COPY, Css.COPY_ICON, '', this));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.PASTE, Css.PASTE_ICON, '', this));
  this.toolbarButtons_.push(new content.
      ToolbarButton('', ElementType.SELECT_ALL, Css.SELECT_ALL_ICON, '', this));
};
goog.inherits(i18n.input.chrome.inputview.elements.content.CandidateView,
    i18n.input.chrome.inputview.elements.Element);
var CandidateView = i18n.input.chrome.inputview.elements.content.CandidateView;
CandidateView.IconType = {
  BACK: 0,
  SHRINK_CANDIDATES: 1,
  EXPAND_CANDIDATES: 2,
  VOICE: 3
};
var IconType = CandidateView.IconType;
CandidateView.CandidateViewType = {
  NONE: 0,
  CANDIDATES: 1,
  NUMBER_ROW: 2,
  TOOLTIP: 3
};
var CandidateViewType = CandidateView.CandidateViewType;
CandidateView.PADDING_ = 50;
CandidateView.WIDTH_FOR_THREE_CANDIDATES_ = 200;
CandidateView.SMALL_WIDTH_FOR_THREE_CANDIDATES_ = 75;
CandidateView.TOOLBAR_ICON_WIDTH_ = 40;
CandidateView.HANDWRITING_VIEW_CODE_ = 'hwt';
CandidateView.EMOJI_VIEW_CODE_ = 'emoji';
CandidateView.prototype.candidateCount = 0;
CandidateView.prototype.widthInWeight_ = 0;
CandidateView.prototype.backspaceWeight_ = 0;
CandidateView.prototype.iconWidth_ = 120;
CandidateView.prototype.candidateViewType_ = CandidateViewType.NONE;
CandidateView.prototype.tryShowingToolbar = false;
CandidateView.prototype.keyset_ = '';
CandidateView.prototype.isPasswordBox_ = false;
CandidateView.prototype.isRTL_ = false;
CandidateView.prototype.interContainerWidth_ = 0;
CandidateView.prototype.navigation_ = false;
CandidateView.prototype.sumOfCandidates_ = 0;
CandidateView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem, Css.CANDIDATE_VIEW);
  for (var i = 0; i < this.toolbarButtons_.length; i++) {
    var button = this.toolbarButtons_[i];
    button.render(elem);
    button.setVisible(false);
  }
  for (var i = 0; i < this.fvkButtons_.length; i++) {
    var button = this.fvkButtons_[i];
    button.render(elem);
    button.setVisible(false);
  }
  this.interContainer_ = dom.createDom(TagName.DIV,
      Css.CANDIDATE_INTER_CONTAINER);
  dom.appendChild(elem, this.interContainer_);
  for (var i = 0; i < this.iconButtons_.length; i++) {
    var button = this.iconButtons_[i];
    button.render(elem);
    button.setVisible(false);
    if (button.type == ElementType.VOICE_BTN) {
      goog.dom.classlist.add(button.getElement(), Css.VOICE_BUTTON);
    }
  }
  goog.a11y.aria.setState(
      (this.iconButtons_[IconType.SHRINK_CANDIDATES].getElement()),
      goog.a11y.aria.State.LABEL,
      chrome.i18n.getMessage('SHRINK_CANDIDATES'));
  goog.a11y.aria.setState(
      (this.iconButtons_[IconType.EXPAND_CANDIDATES].getElement()),
      goog.a11y.aria.State.LABEL,
      chrome.i18n.getMessage('EXPAND_CANDIDATES'));
};
CandidateView.prototype.hideNumberRow = function() {
  if (this.candidateViewType_ == CandidateViewType.NUMBER_ROW) {
    this.candidateViewType_ = CandidateViewType.NONE;
    this.getDomHelper().removeChildren(this.interContainer_);
  }
};
CandidateView.prototype.showNumberRow = function() {
  this.candidateViewType_ = CandidateViewType.NUMBER_ROW;
  goog.dom.classlist.remove(this.getElement(),
      i18n.input.chrome.inputview.Css.THREE_CANDIDATES);
  var dom = this.getDomHelper();
  dom.removeChildren(this.interContainer_);
  var weightArray = [];
  for (var i = 0; i < 10; i++) {
    weightArray.push(1);
  }
  weightArray.push(this.widthInWeight_ - 10);
  var values = util.splitValue(weightArray, this.width);
  for (var i = 0; i < 10; i++) {
    var candidateElem = new Candidate(String(i), goog.object.create(
        Name.CANDIDATE, String((i + 1) % 10)),
        Type.NUMBER, this.height, false, values[i], this);
    candidateElem.render(this.interContainer_);
  }
};
CandidateView.prototype.showTooltip = function(opt_text) {
  this.clearCandidates();
  this.candidateViewType_ = CandidateViewType.TOOLTIP;
  goog.dom.classlist.remove(this.getElement(),
      i18n.input.chrome.inputview.Css.THREE_CANDIDATES);
  var candidateElem = new Candidate('tooltip', goog.object.create(
      Name.CANDIDATE, opt_text || ''),
      Type.TOOLTIP, this.height, false, this.width, this);
  candidateElem.render(this.interContainer_);
  this.switchToIcon(IconType.VOICE, false);
};
CandidateView.prototype.hideTooltip = function() {
  if (this.candidateViewType_ == CandidateViewType.TOOLTIP) {
    this.candidateViewType_ = CandidateViewType.NONE;
    this.getDomHelper().removeChildren(this.interContainer_);
    this.updateByKeyset(this.keyset_, this.isPasswordBox_, this.isRTL_);
  }
};
CandidateView.prototype.showCandidates = function(candidates,
    showThreeCandidates, opt_expandable) {
  this.clearCandidates();
  this.sumOfCandidates_ = candidates.length;
  if (candidates.length > 0) {
    this.candidateViewType_ = CandidateViewType.CANDIDATES;
    if (showThreeCandidates) {
      this.addThreeCandidates_(candidates);
    } else {
      this.addFullCandidates_(candidates);
      if (!this.iconButtons_[IconType.BACK].isVisible()) {
        this.switchToIcon(IconType.EXPAND_CANDIDATES,
            !!opt_expandable && this.candidateCount < candidates.length);
      }
    }
  }
};
CandidateView.prototype.addThreeCandidates_ = function(candidates) {
  goog.dom.classlist.add(this.getElement(),
      i18n.input.chrome.inputview.Css.THREE_CANDIDATES);
  this.interContainer_.style.width = 'auto';
  var num = Math.min(3, candidates.length);
  var width = CandidateView.WIDTH_FOR_THREE_CANDIDATES_;
  if (this.adapter_.isFloatingVirtualKeyboardEnabled()) {
    width = CandidateView.SMALL_WIDTH_FOR_THREE_CANDIDATES_;
  }
  if (this.tryShowingToolbar && this.hasEnoughSpaceForToolbar_()) {
    width -= this.iconWidth_ / 3;
  }
  for (var i = 0; i < num; i++) {
    var candidateElem = new Candidate(String(i), candidates[i], Type.CANDIDATE,
        this.height, i == 1 || num == 1, width, this);
    candidateElem.render(this.interContainer_);
  }
  this.candidateCount = num;
};
CandidateView.prototype.clearCandidates = function() {
  this.sumOfCandidates_ = 0;
  if (this.candidateViewType_ == CandidateViewType.CANDIDATES) {
    this.candidateViewType_ = CandidateViewType.NONE;
    this.candidateCount = 0;
    this.getDomHelper().removeChildren(this.interContainer_);
  }
};
CandidateView.prototype.addFullCandidates_ = function(candidates) {
  goog.dom.classlist.remove(this.getElement(),
      i18n.input.chrome.inputview.Css.THREE_CANDIDATES);
  var totalWidth = Math.floor(this.width - this.iconWidth_);
  if (this.tryShowingToolbar && this.hasEnoughSpaceForToolbar_()) {
    totalWidth -=
        (CandidateView.TOOLBAR_ICON_WIDTH_ * this.toolbarButtons_.length);
  }
  var w = 0;
  var i;
  for (i = 0; i < candidates.length; i++) {
    var candidateElem = new Candidate(String(i), candidates[i], Type.CANDIDATE,
        this.height, false, undefined, this);
    candidateElem.render(this.interContainer_);
    var size = goog.style.getSize(candidateElem.getElement());
    var candidateWidth = size.width + CandidateView.PADDING_ * 2;
    w += candidateWidth + 1;
    if (w >= totalWidth) {
      if (i == 0) {
        candidateElem.setSize(totalWidth);
        ++i;
      } else {
        this.interContainer_.removeChild(candidateElem.getElement());
      }
      break;
    }
    candidateElem.setSize(candidateWidth);
  }
  this.candidateCount = i;
};
CandidateView.prototype.setWidthInWeight = function(widthInWeight,
    backspaceWeight) {
  this.widthInWeight_ = widthInWeight;
  this.backspaceWeight_ = backspaceWeight;
};
CandidateView.prototype.resize = function(width, height) {
  goog.style.setSize(this.getElement(), width, height);
  var remainingWidth = width;
  if (this.backspaceWeight_ > 0) {
    var weightArray = [Math.round(this.widthInWeight_ - this.backspaceWeight_)];
    weightArray.push(this.backspaceWeight_);
    var values = util.splitValue(weightArray, width);
    this.iconWidth_ = values[values.length - 1];
  }
  for (var i = 0; i < this.iconButtons_.length; i++) {
    var button = this.iconButtons_[i];
    button.resize(this.iconWidth_, height);
  }
  remainingWidth = width - this.iconWidth_;
  for (var i = 0; i < this.fvkButtons_.length; i++) {
    var button = this.fvkButtons_[i];
    if (button.isVisible()) {
      button.resize(height, height);
      remainingWidth -= height;
    }
  }
  if (this.tryShowingToolbar) {
    if (this.hasEnoughSpaceForToolbar_()) {
      for (var i = 0; i < this.toolbarButtons_.length; i++) {
        var button = this.toolbarButtons_[i];
        button.resize(CandidateView.TOOLBAR_ICON_WIDTH_, height);
        button.setVisible(true);
        remainingWidth -= CandidateView.TOOLBAR_ICON_WIDTH_;
      }
    } else {
      for (var i = 0; i < this.toolbarButtons_.length; i++) {
        this.toolbarButtons_[i].setVisible(false);
      }
    }
  }
  if (this.candidateCount > 0) {
    var w = 0;
    for (i = 0; i < this.candidateCount; i++) {
      if (w <= remainingWidth) {
        w += goog.style.getSize(this.interContainer_.children[i]).width;
      }
      goog.style.setElementShown(this.interContainer_.children[i],
          w <= remainingWidth);
    }
  }
  if (!goog.dom.classlist.contains(this.getElement(),
      i18n.input.chrome.inputview.Css.THREE_CANDIDATES)) {
    goog.style.setSize(this.interContainer_, remainingWidth, height);
  }
  goog.base(this, 'resize', width, height);
  if (this.candidateViewType_ == CandidateViewType.NUMBER_ROW) {
    this.showNumberRow();
  }
};
CandidateView.prototype.switchToIcon = function(type, visible) {
  if (visible) {
    for (var i = 0; i < this.iconButtons_.length; i++) {
      if (type != IconType.VOICE) {
        this.iconButtons_[i].setVisible(i == type);
      } else {
        this.iconButtons_[i].setVisible(i == type &&
            this.needToShowVoiceIcon_());
      }
    }
  } else {
    this.iconButtons_[type].setVisible(false);
    if (type != IconType.VOICE && this.needToShowVoiceIcon_()) {
      this.iconButtons_[IconType.VOICE].setVisible(true);
    }
  }
};
CandidateView.prototype.setFloatingVKButtonsVisible = function(visible) {
  for (var i = 0; i < this.fvkButtons_.length; i++) {
    this.fvkButtons_[i].setVisible(visible);
  }
};
CandidateView.prototype.setToolbarVisible = function(visible) {
  this.tryShowingToolbar = visible;
  if (this.hasEnoughSpaceForToolbar_()) {
    for (var i = 0; i < this.toolbarButtons_.length; i++) {
      this.toolbarButtons_[i].setVisible(visible);
    }
  }
};
CandidateView.prototype.hasEnoughSpaceForToolbar_ = function() {
  var toolbarSpace =
      CandidateView.TOOLBAR_ICON_WIDTH_ * this.toolbarButtons_.length;
  var candidatesSpace = CandidateView.WIDTH_FOR_THREE_CANDIDATES_ * 3;
  if (this.adapter_.isFloatingVirtualKeyboardEnabled()) {
    candidatesSpace = CandidateView.SMALL_WIDTH_FOR_THREE_CANDIDATES_ * 3;
  }
  return toolbarSpace + candidatesSpace < this.width;
};
CandidateView.prototype.updateByKeyset = function(
    keyset, isPasswordBox, isRTL) {
  this.keyset_ = keyset;
  this.isPasswordBox_ = isPasswordBox;
  this.isRTL_ = isRTL;
  if (keyset == CandidateView.HANDWRITING_VIEW_CODE_ ||
      keyset == CandidateView.EMOJI_VIEW_CODE_) {
    this.switchToIcon(IconType.VOICE, false);
  } else {
    this.switchToIcon(IconType.VOICE, this.needToShowVoiceIcon_());
  }
  if (isPasswordBox && (keyset.indexOf('compact') != -1 &&
      keyset.indexOf('compact.symbol') == -1)) {
    this.showNumberRow();
  } else {
    this.hideNumberRow();
  }
  this.interContainer_.style.direction = isRTL ? 'rtl' : 'ltr';
};
CandidateView.prototype.disposeInternal = function() {
  goog.disposeAll(this.toolbarButtons_);
  goog.disposeAll(this.iconButtons_);
  goog.base(this, 'disposeInternal');
};
CandidateView.prototype.needToShowVoiceIcon_ = function() {
  return this.adapter_.isVoiceInputEnabled &&
      this.adapter_.contextType != 'password' &&
      this.keyset_ != CandidateView.HANDWRITING_VIEW_CODE_ &&
      this.keyset_ != CandidateView.EMOJI_VIEW_CODE_ &&
      this.candidateViewType_ != CandidateViewType.TOOLTIP &&
      (!this.navigation_ || this.candidateCount == this.sumOfCandidates_);
};
CandidateView.prototype.setNavigation = function(navigation) {
  this.navigation_ = navigation;
};
});  // goog.scope

// goog.positioning.AbstractPosition
goog.provide('goog.positioning.AbstractPosition');
goog.positioning.AbstractPosition = function() {};
goog.positioning.AbstractPosition.prototype.reposition =
    function(movableElement, corner, opt_margin, opt_preferredSize) { };

// goog.positioning.AnchoredPosition
goog.provide('goog.positioning.AnchoredPosition');
goog.positioning.AnchoredPosition = function(anchorElement,
                                             corner,
                                             opt_overflow) {
  this.element = anchorElement;
  this.corner = corner;
  this.overflow_ = opt_overflow;
};
goog.inherits(goog.positioning.AnchoredPosition,
              goog.positioning.AbstractPosition);
goog.positioning.AnchoredPosition.prototype.reposition = function(
    movableElement, movableCorner, opt_margin, opt_preferredSize) {
  goog.positioning.positionAtAnchor(this.element,
                                    this.corner,
                                    movableElement,
                                    movableCorner,
                                    undefined,
                                    opt_margin,
                                    this.overflow_);
};

// goog.positioning.AnchoredViewportPosition
goog.provide('goog.positioning.AnchoredViewportPosition');
goog.positioning.AnchoredViewportPosition = function(anchorElement,
                                                     corner,
                                                     opt_adjust,
                                                     opt_overflowConstraint) {
  goog.positioning.AnchoredPosition.call(this, anchorElement, corner);
  this.lastResortOverflow_ = opt_adjust ?
      (goog.positioning.Overflow.ADJUST_X |
       goog.positioning.Overflow.ADJUST_Y) :
      goog.positioning.Overflow.IGNORE;
  this.overflowConstraint_ = opt_overflowConstraint || undefined;
};
goog.inherits(goog.positioning.AnchoredViewportPosition,
              goog.positioning.AnchoredPosition);
goog.positioning.AnchoredViewportPosition.prototype.getOverflowConstraint =
    function() {
  return this.overflowConstraint_;
};
goog.positioning.AnchoredViewportPosition.prototype.setOverflowConstraint =
    function(overflowConstraint) {
  this.overflowConstraint_ = overflowConstraint;
};
goog.positioning.AnchoredViewportPosition.prototype.getLastResortOverflow =
    function() {
  return this.lastResortOverflow_;
};
goog.positioning.AnchoredViewportPosition.prototype.setLastResortOverflow =
    function(lastResortOverflow) {
  this.lastResortOverflow_ = lastResortOverflow;
};
goog.positioning.AnchoredViewportPosition.prototype.reposition = function(
    movableElement, movableCorner, opt_margin, opt_preferredSize) {
  var status = goog.positioning.positionAtAnchor(this.element, this.corner,
      movableElement, movableCorner, null, opt_margin,
      goog.positioning.Overflow.FAIL_X | goog.positioning.Overflow.FAIL_Y,
      opt_preferredSize, this.overflowConstraint_);
  if (status & goog.positioning.OverflowStatus.FAILED) {
    var cornerFallback = this.adjustCorner(status, this.corner);
    var movableCornerFallback = this.adjustCorner(status, movableCorner);
    status = goog.positioning.positionAtAnchor(this.element, cornerFallback,
        movableElement, movableCornerFallback, null, opt_margin,
        goog.positioning.Overflow.FAIL_X | goog.positioning.Overflow.FAIL_Y,
        opt_preferredSize, this.overflowConstraint_);
    if (status & goog.positioning.OverflowStatus.FAILED) {
      cornerFallback = this.adjustCorner(status, cornerFallback);
      movableCornerFallback = this.adjustCorner(
          status, movableCornerFallback);
      goog.positioning.positionAtAnchor(this.element, cornerFallback,
          movableElement, movableCornerFallback, null, opt_margin,
          this.getLastResortOverflow(), opt_preferredSize,
          this.overflowConstraint_);
    }
  }
};
goog.positioning.AnchoredViewportPosition.prototype.adjustCorner = function(
    status, corner) {
  if (status & goog.positioning.OverflowStatus.FAILED_HORIZONTAL) {
    corner = goog.positioning.flipCornerHorizontal(corner);
  }
  if (status & goog.positioning.OverflowStatus.FAILED_VERTICAL) {
    corner = goog.positioning.flipCornerVertical(corner);
  }
  return corner;
};

// i18n.input.chrome.inputview.elements.content.SoftKey
goog.provide('i18n.input.chrome.inputview.elements.content.SoftKey');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.SoftKey = function(id, type,
    opt_eventTarget) {
  goog.base(this, id, type, opt_eventTarget);
  this.availableWidth = 0;
  this.availableHeight = 0;
  this.nearbyKeys = [];
};
goog.inherits(i18n.input.chrome.inputview.elements.content.SoftKey,
    i18n.input.chrome.inputview.elements.Element);
var SoftKey = i18n.input.chrome.inputview.elements.content.SoftKey;
SoftKey.prototype.centerCoordinate;
SoftKey.prototype.topLeftCoordinate;
SoftKey.prototype.estimator;
SoftKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  goog.dom.classlist.add(this.getElement(),
      i18n.input.chrome.inputview.Css.SOFT_KEY);
};
SoftKey.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  var elem = this.getElement();
  var borderWidth = i18n.input.chrome.inputview.util.getPropertyValue(
      elem, 'borderWidth');
  var marginTop = i18n.input.chrome.inputview.util.getPropertyValue(
      elem, 'marginTop');
  var marginBottom = i18n.input.chrome.inputview.util.getPropertyValue(
      elem, 'marginBottom');
  var marginLeft = i18n.input.chrome.inputview.util.getPropertyValue(
      elem, 'marginLeft');
  var marginRight = i18n.input.chrome.inputview.util.getPropertyValue(
      elem, 'marginRight');
  var w = width - borderWidth * 2 - marginLeft - marginRight;
  var h = height - borderWidth * 2 - marginTop - marginBottom;
  elem.style.width = w + 'px';
  elem.style.height = h + 'px';
  this.availableWidth = w;
  this.availableHeight = h;
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.FunctionalKey
goog.provide('i18n.input.chrome.inputview.elements.content.FunctionalKey');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.elements.content.FunctionalKey = function(id, type,
    text, iconCssClass, opt_eventTarget, opt_textCssClass) {
  goog.base(this, id, type, opt_eventTarget);
  this.text = text;
  this.iconCssClass_ = iconCssClass;
  this.textCssClass_ = opt_textCssClass || '';
};
goog.inherits(i18n.input.chrome.inputview.elements.content.FunctionalKey,
    i18n.input.chrome.inputview.elements.content.SoftKey);
var FunctionalKey = i18n.input.chrome.inputview.elements.content.FunctionalKey;
FunctionalKey.prototype.tableCell;
FunctionalKey.prototype.textElem;
FunctionalKey.prototype.iconElem;
FunctionalKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  this.bgElem = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.SPECIAL_KEY_BG);
  dom.appendChild(elem, this.bgElem);
  this.tableCell = dom.createDom(goog.dom.TagName.DIV);
  goog.dom.classlist.add(this.tableCell,
      i18n.input.chrome.inputview.Css.MODIFIER);
  if (this.text) {
    this.textElem = dom.createDom(goog.dom.TagName.DIV,
        i18n.input.chrome.inputview.Css.SPECIAL_KEY_NAME, this.text);
    if (this.textCssClass_) {
      goog.dom.classlist.add(this.textElem, this.textCssClass_);
    }
    dom.appendChild(this.tableCell, this.textElem);
  }
  if (this.iconCssClass_) {
    this.iconElem = dom.createDom(goog.dom.TagName.DIV,
        this.iconCssClass_);
    dom.appendChild(this.tableCell, this.iconElem);
  }
  dom.appendChild(this.bgElem, this.tableCell);
  this.setAriaLabel(this.getChromeVoxMessage());
};
FunctionalKey.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  this.tableCell.style.width = this.availableWidth + 'px';
  this.tableCell.style.height = this.availableHeight + 'px';
};
FunctionalKey.prototype.setHighlighted = function(highlight) {
  if (highlight) {
    goog.dom.classlist.add(this.bgElem,
        i18n.input.chrome.inputview.Css.SPECIAL_KEY_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.bgElem,
        i18n.input.chrome.inputview.Css.SPECIAL_KEY_HIGHLIGHT);
  }
};
FunctionalKey.prototype.disableBackgroundHighlight = function() {
  goog.dom.classlist.add(this.bgElem, i18n.input.chrome.inputview.Css.
      SPECIAL_KEY_DISABLE_BG_HIGHLIGHT);
};
FunctionalKey.prototype.getChromeVoxMessage = function() {
  switch (this.type) {
    case ElementType.BACKSPACE_KEY:
      return chrome.i18n.getMessage('BACKSPACE');
    case ElementType.ENTER_KEY:
      return chrome.i18n.getMessage('ENTER');
    case ElementType.TAB_KEY:
      return chrome.i18n.getMessage('TAB');
    case ElementType.ARROW_UP:
      return chrome.i18n.getMessage('UP_ARROW');
    case ElementType.ARROW_DOWN:
      return chrome.i18n.getMessage('DOWN_ARROW');
    case ElementType.ARROW_LEFT:
      return chrome.i18n.getMessage('LEFT_ARROW');
    case ElementType.ARROW_RIGHT:
      return chrome.i18n.getMessage('RIGHT_ARROW');
    case ElementType.HIDE_KEYBOARD_KEY:
      return chrome.i18n.getMessage('HIDE_KEYBOARD');
    case ElementType.GLOBE_KEY:
      return chrome.i18n.getMessage('GLOBE');
    case ElementType.MENU_KEY:
      return chrome.i18n.getMessage('MENU_KEY');
  }
  return '';
};
FunctionalKey.prototype.setAriaLabel = function(label) {
  var elem = this.textElem || this.iconElem;
  if (elem) {
    goog.a11y.aria.setState(elem, goog.a11y.aria.State.LABEL, label);
    goog.a11y.aria.setRole(elem, goog.a11y.aria.Role.BUTTON);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.BackspaceKey
goog.provide('i18n.input.chrome.inputview.elements.content.BackspaceKey');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.BackspaceKey = function(id, type,
    text, iconCssClass, opt_eventTarget, opt_textCssClass) {
  goog.base(this, id, type, text, iconCssClass, opt_eventTarget,
      opt_textCssClass);
  this.pointerConfig.longPressWithPointerUp = true;
  this.pointerConfig.longPressDelay = 300;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.BackspaceKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
});  // goog.scope

// i18n.input.chrome.inputview.elements.Weightable
goog.provide('i18n.input.chrome.inputview.elements.Weightable');
i18n.input.chrome.inputview.elements.Weightable = function() {};
i18n.input.chrome.inputview.elements.Weightable.prototype.getWidthInWeight =
    goog.abstractMethod;
i18n.input.chrome.inputview.elements.Weightable.prototype.getHeightInWeight =
    goog.abstractMethod;

// i18n.input.chrome.inputview.elements.content.SpanElement
goog.provide('i18n.input.chrome.inputview.elements.content.SpanElement');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.SpanElement = function(id, type,
    opt_eventTarget) {
  i18n.input.chrome.inputview.elements.content.SpanElement.base(
      this, 'constructor', id, type, opt_eventTarget);
};
var SpanElement = i18n.input.chrome.inputview.elements.content.SpanElement;
goog.inherits(SpanElement, i18n.input.chrome.inputview.elements.Element);
SpanElement.prototype.createDom = function() {
  var elem = this.getDomHelper().createDom(goog.dom.TagName.SPAN);
  this.setElementInternal(elem);
  elem.id = this.id;
  elem['view'] = this;
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CanvasView
goog.provide('i18n.input.chrome.inputview.elements.content.CanvasView');
goog.scope(function() {
var Canvas = i18n.input.hwt.Canvas;
var Css = i18n.input.chrome.inputview.Css;
var ElementType = i18n.input.chrome.ElementType;
var Name = i18n.input.chrome.message.Name;
var SpanElement = i18n.input.chrome.inputview.elements.content.SpanElement;
var EventType = i18n.input.chrome.inputview.events.EventType;
var Type = i18n.input.chrome.message.Type;
i18n.input.chrome.inputview.elements.content.CanvasView = function(id,
    widthInWeight, heightInWeight, opt_eventTarget, opt_adapter) {
  goog.base(this, id, ElementType.CANVAS_VIEW, opt_eventTarget);
  this.canvas_ = new Canvas(document, this.getDomHelper(), opt_eventTarget,
      CanvasView.INK_WIDTH_, CanvasView.INK_COLOR_);
  this.widthInWeight_ = widthInWeight;
  this.heightInWeight_ = heightInWeight;
  this.adapter_ = goog.asserts.assertObject(opt_adapter);
  this.pointerConfig.stopEventPropagation = false;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.CanvasView,
    i18n.input.chrome.inputview.elements.Element);
var CanvasView = i18n.input.chrome.inputview.elements.content.CanvasView;
CanvasView.INK_WIDTH_ = 6;
CanvasView.INK_COLOR_ = '#3974df';
CanvasView.prototype.networkErrorDiv_;
CanvasView.prototype.privacyDiv_;
CanvasView.prototype.coverElement_;
CanvasView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var container = this.getElement();
  var dom = this.getDomHelper();
  goog.dom.classlist.add(container, Css.CANVAS_VIEW);
  this.coverElement_ = dom.createDom(goog.dom.TagName.DIV,
      Css. HANDWRITING_PRIVACY_COVER);
  dom.appendChild(container, this.coverElement_);
  this.canvas_.render(container);
  goog.dom.classlist.add(this.canvas_.getElement(), Css.CANVAS);
  this.networkErrorDiv_ = dom.createDom(
      goog.dom.TagName.DIV, Css.HANDWRITING_NETWORK_ERROR);
  dom.setTextContent(this.networkErrorDiv_,
      chrome.i18n.getMessage('HANDWRITING_NETOWRK_ERROR'));
  goog.style.setElementShown(this.networkErrorDiv_, false);
  dom.appendChild(container, this.networkErrorDiv_);
  this.privacyDiv_ = dom.createDom(goog.dom.TagName.DIV,
      Css.HANDWRITING_PRIVACY_INFO);
  var textSpan = dom.createDom(goog.dom.TagName.SPAN);
  dom.setTextContent(textSpan,
      chrome.i18n.getMessage('HANDWRITING_PRIVACY_INFO'));
  dom.appendChild(this.privacyDiv_, textSpan);
  var spanView = new SpanElement('', ElementType.HWT_PRIVACY_GOT_IT);
  spanView.render(this.privacyDiv_);
  var spanElement = spanView.getElement();
  goog.dom.classlist.add(spanElement, Css.HANDWRITING_GOT_IT);
  dom.setTextContent(spanElement, chrome.i18n.getMessage('GOT_IT'));
  if (localStorage.getItem(Name.HWT_PRIVACY_INFO)) {
    goog.style.setElementShown(this.coverElement_, false);
    goog.dom.classlist.add(this.privacyDiv_,
        Css.HANDWRITING_PRIVACY_INFO_HIDDEN);
  }
  dom.appendChild(container, this.privacyDiv_);
};
CanvasView.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.getHandler().
      listen(this.canvas_.getStrokeHandler(),
          i18n.input.hwt.StrokeHandler.EventType.STROKE_END,
          this.onStrokeEnd_).
      listen(this.adapter_,
          [i18n.input.chrome.DataSource.EventType.CANDIDATES_BACK,
           EventType.HWT_NETWORK_ERROR],
          this.onNetworkState_).
      listen(this.adapter_, Type.HWT_PRIVACY_GOT_IT,
          this.onConfirmPrivacyInfo_);
};
CanvasView.prototype.setHighlighted = goog.nullFunction;
CanvasView.prototype.getWidthInWeight = function() {
  return this.widthInWeight_;
};
CanvasView.prototype.getHeightInWeight = function() {
  return this.heightInWeight_;
};
CanvasView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  var elem = this.getElement();
  elem.style.width = this.coverElement_.style.width = width + 'px';
  elem.style.height = this.coverElement_.style.height = height + 'px';
  var size = goog.style.getSize(this.networkErrorDiv_);
  this.networkErrorDiv_.style.top = elem.offsetTop +
      Math.round((height - size.height) / 2) + 'px';
  this.networkErrorDiv_.style.left = elem.offsetLeft +
      Math.round((width - size.width) / 2) + 'px';
  size = goog.style.getSize(this.privacyDiv_);
  this.privacyDiv_.style.top = elem.offsetTop +
      Math.round((height - size.height) / 2) + 'px';
  this.privacyDiv_.style.left = elem.offsetLeft +
      Math.round((width - size.width) / 2) + 'px';
  this.canvas_.setSize(height, width);
};
CanvasView.prototype.onStrokeEnd_ = function() {
  var strokes = goog.array.map(this.canvas_.strokeList,
      function(stroke) {
        return [goog.array.map(stroke, function(point) { return point.x; }),
          goog.array.map(stroke, function(point) { return point.y; }),
          goog.array.map(stroke, function(point) { return point.time; })];
      });
  var elem = this.getElement();
  var payload = {
    'strokes': strokes,
    'width': elem.style.width,
    'height': elem.style.height
  };
  this.adapter_.sendHwtRequest(payload);
};
CanvasView.prototype.reset = function() {
  this.canvas_.reset();
};
CanvasView.prototype.hasStrokesOnCanvas = function() {
  return this.canvas_.strokeList.length > 0;
};
CanvasView.prototype.onNetworkState_ = function(e) {
  goog.style.setElementShown(
      this.networkErrorDiv_, e.type == EventType.HWT_NETWORK_ERROR);
};
CanvasView.prototype.onConfirmPrivacyInfo_ = function() {
  localStorage.setItem(Name.HWT_PRIVACY_INFO, 'true');
  goog.style.setElementShown(this.coverElement_, false);
  goog.dom.classlist.add(this.privacyDiv_, Css.HANDWRITING_PRIVACY_INFO_HIDDEN);
};
CanvasView.prototype.setPrivacyInfoDirection = function(dir) {
  this.getElement().style.direction = dir;
};
});  // goog.scope

// i18n.input.chrome.inputview.SwipeDirection
goog.provide('i18n.input.chrome.inputview.SwipeDirection');
i18n.input.chrome.inputview.SwipeDirection = {
  UP: 0x1,
  DOWN: 0x2,
  LEFT: 0x4,
  RIGHT: 0x8
};

// i18n.input.chrome.inputview.elements.content.Character
goog.provide('i18n.input.chrome.inputview.elements.content.Character');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.Character = function(
    id, model, isRTL) {
  goog.base(this, id, i18n.input.chrome.ElementType.
      CHARACTER);
  this.characterModel_ = model;
  this.isRTL_ = isRTL;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.Character,
    i18n.input.chrome.inputview.elements.Element);
var Character = i18n.input.chrome.inputview.elements.content.Character;
Character.PADDING_ = 2;
Character.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var elem = this.getElement();
  var dom = this.getDomHelper();
  this.getElement()['view'] = null;
  var character = this.characterModel_.getContent();
  dom.appendChild(elem, dom.createTextNode(character));
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.CHARACTER);
  if (/[0-9]/.test(character)) {
    goog.dom.classlist.add(elem,
        i18n.input.chrome.inputview.Css.DIGIT_CHARACTER);
  }
  elem.style.direction = this.isRTL_ ? 'rtl' : 'ltr';
};
Character.prototype.reposition_ = function() {
  var width = this.width;
  var height = this.height;
  var size = goog.style.getSize(this.getElement());
  var paddingVertical;
  var paddingHorizontal;
  if (this.characterModel_.isHorizontalAlignCenter()) {
    paddingHorizontal = Math.floor((width - size.width) / 2);
  } else {
    paddingHorizontal = Character.PADDING_;
  }
  if (this.characterModel_.isVerticalAlignCenter()) {
    paddingVertical = Math.floor((height - size.height) / 2);
  } else {
    paddingVertical = Character.PADDING_;
  }
  var attributes = this.characterModel_.getPositionAttribute();
  var elem = this.getElement();
  elem.style[attributes[0]] = paddingVertical + 'px';
  elem.style[attributes[1]] = paddingHorizontal + 'px';
};
Character.prototype.highlight = function() {
  if (this.characterModel_.isHighlighted()) {
    goog.dom.classlist.add(this.getElement(),
        i18n.input.chrome.inputview.Css.CHARACTER_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.getElement(),
        i18n.input.chrome.inputview.Css.CHARACTER_HIGHLIGHT);
  }
};
Character.prototype.updateContent = function() {
  var ch = this.characterModel_.getContent();
  goog.dom.setTextContent(this.getElement(),
      i18n.input.chrome.inputview.util.getVisibleCharacter(ch));
};
Character.prototype.setVisible = function(visibility) {
  this.getElement().style.display = visibility ? 'inline-block' : 'none';
};
Character.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  this.update();
};
Character.prototype.update = function() {
  var visible = this.characterModel_.isVisible();
  this.setVisible(visible);
  if (visible) {
    this.highlight();
    this.updateContent();
    this.reposition_();
  }
};
Character.prototype.getContent = function() {
  return this.characterModel_.getContent();
};
Character.prototype.isVisible = function() {
  return this.characterModel_.isVisible();
};
Character.prototype.isHighlighted = function() {
  return this.characterModel_.isHighlighted();
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CharacterModel
goog.provide('i18n.input.chrome.inputview.elements.content.CharacterModel');
goog.scope(function() {
var StateType = i18n.input.chrome.inputview.StateType;
var util = i18n.input.chrome.inputview.util;
i18n.input.chrome.inputview.elements.content.CharacterModel = function(
    character, belongToLetterKey, hasAltGrCharacterInTheKeyset,
    alwaysRenderAltGrCharacter, stateType, stateManager, enableShiftRendering,
    opt_capslockCharacter) {
  this.character_ = character;
  this.capslockCharacter_ = opt_capslockCharacter || '';
  this.belongToLetterKey_ = belongToLetterKey;
  this.stateType_ = stateType;
  this.stateManager_ = stateManager;
  this.alwaysRenderAltGrCharacter_ = alwaysRenderAltGrCharacter;
  this.hasAltGrCharacterInTheKeyset_ = hasAltGrCharacterInTheKeyset;
  this.enableShiftRendering_ = enableShiftRendering;
};
var CharacterModel = i18n.input.chrome.inputview.elements.content.
    CharacterModel;
CharacterModel.AlignType = {
  CENTER: 0,
  CORNER: 1
};
CharacterModel.CORNERS_ = [
  ['bottom', 'left'],
  ['top', 'left'],
  ['bottom', 'right'],
  ['top', 'right']
];
CharacterModel.prototype.isHighlighted = function() {
  var state = this.stateManager_.getState();
  state = state & (StateType.SHIFT | StateType.ALTGR);
  return this.stateType_ == state;
};
CharacterModel.prototype.isVisible = function() {
  var hasShift = this.stateManager_.hasState(StateType.SHIFT);
  var enableShiftLetter = !this.belongToLetterKey_ || hasShift;
  var enableDefaultLetter = !this.belongToLetterKey_ || !hasShift;
  enableShiftLetter = (this.enableShiftRendering_ &&
      !this.belongToLetterKey_) || hasShift;
  enableDefaultLetter = (this.enableShiftRendering_ &&
      !this.belongToLetterKey_) || !hasShift;
  if (this.stateType_ == StateType.DEFAULT) {
    return !this.stateManager_.hasState(StateType.ALTGR) && enableDefaultLetter;
  }
  if (this.stateType_ == StateType.SHIFT) {
    return !this.stateManager_.hasState(StateType.ALTGR) && enableShiftLetter;
  }
  if (this.stateType_ == StateType.ALTGR) {
    return this.stateManager_.hasState(StateType.ALTGR) && enableDefaultLetter;
  }
  if (this.stateType_ == (StateType.ALTGR | StateType.SHIFT)) {
    return this.stateManager_.hasState(StateType.ALTGR) && enableShiftLetter;
  }
  return false;
};
CharacterModel.prototype.toReversedCase_ = function() {
  var upper = util.toUpper(this.character_);
  var lower = util.toLower(this.character_);
  return (upper == this.character_) ? lower : upper;
};
CharacterModel.prototype.getContent = function() {
  if (this.stateManager_.hasState(StateType.CAPSLOCK)) {
    return this.capslockCharacter_ ? this.capslockCharacter_ :
        this.toReversedCase_();
  }
  return this.character_;
};
CharacterModel.prototype.isHorizontalAlignCenter = function() {
  if (this.stateType_ == StateType.DEFAULT ||
      this.stateType_ == StateType.SHIFT) {
    return !this.alwaysRenderAltGrCharacter_ ||
        !this.hasAltGrCharacterInTheKeyset_;
  }
  return true;
};
CharacterModel.prototype.isVerticalAlignCenter = function() {
  if (this.stateType_ == StateType.DEFAULT ||
      this.stateType_ == StateType.SHIFT) {
    return this.belongToLetterKey_;
  }
  return false;
};
CharacterModel.prototype.getPositionAttribute = function() {
  switch (this.stateType_) {
    case StateType.DEFAULT:
      return CharacterModel.CORNERS_[0];
    case StateType.SHIFT:
      return CharacterModel.CORNERS_[1];
    case StateType.ALTGR:
      return CharacterModel.CORNERS_[2];
    default:
      return CharacterModel.CORNERS_[3];
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CharacterKey
goog.provide('i18n.input.chrome.inputview.elements.content.CharacterKey');
goog.scope(function() {
var CharacterModel = i18n.input.chrome.inputview.elements.content.
    CharacterModel;
var Character = i18n.input.chrome.inputview.elements.content.Character;
var StateType = i18n.input.chrome.inputview.StateType;
i18n.input.chrome.inputview.elements.content.CharacterKey = function(id,
    keyCode, characters, isLetterKey, hasAltGrCharacterInTheKeyset,
    alwaysRenderAltGrCharacter, stateManager, isRTL,
    enableShiftRendering, opt_eventTarget) {
  goog.base(this, id, i18n.input.chrome.ElementType.
      CHARACTER_KEY, opt_eventTarget);
  this.keyCode = keyCode;
  this.characters = characters;
  this.isLetterKey = isLetterKey;
  this.hasAltGrCharacterInTheKeyset_ = hasAltGrCharacterInTheKeyset;
  this.stateManager_ = stateManager;
  this.isRTL_ = isRTL;
  this.alwaysRenderAltGrCharacter_ = alwaysRenderAltGrCharacter;
  this.enableShiftRendering_ = enableShiftRendering;
  this.pointerConfig.longPressWithPointerUp = true;
  this.pointerConfig.longPressDelay = 500;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.CharacterKey,
    i18n.input.chrome.inputview.elements.content.SoftKey);
var CharacterKey = i18n.input.chrome.inputview.elements.content.CharacterKey;
CharacterKey.prototype.flickerredCharacter = '';
CharacterKey.STATE_LIST_ = [
  StateType.DEFAULT,
  StateType.SHIFT,
  StateType.ALTGR,
  StateType.ALTGR | StateType.SHIFT
];
CharacterKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  for (var i = 0; i < CharacterKey.STATE_LIST_.length; i++) {
    var ch = this.characters.length > i ? this.characters[i] : '';
    if (ch && ch != '\x00') {
      var model = new CharacterModel(ch, this.isLetterKey,
          this.hasAltGrCharacterInTheKeyset_,
          this.alwaysRenderAltGrCharacter_,
          CharacterKey.STATE_LIST_[i],
          this.stateManager_,
          this.enableShiftRendering_,
          this.getCapslockCharacter_(i));
      var character = new Character(this.id + '-' + i, model, this.isRTL_);
      this.addChild(character, true);
    }
  }
  goog.a11y.aria.setRole(this.getElement(), goog.a11y.aria.Role.BUTTON);
};
CharacterKey.prototype.getCapslockCharacter_ = function(i) {
  var capslockCharacterIndex = i + 4;
  if (this.characters.length > capslockCharacterIndex) {
    return this.characters[capslockCharacterIndex];
  }
  return '';
};
CharacterKey.prototype.resize = function(width,
    height) {
  goog.base(this, 'resize', width, height);
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    child.resize(this.availableWidth, this.availableHeight);
  }
};
CharacterKey.prototype.getAltCharacters =
    function() {
  var altCharacters = [];
  for (var i = 0; i < this.characters.length; i++) {
    var ch = this.characters[i];
    if (ch && ch != '\x00' && ch != this.getActiveCharacter()) {
      goog.array.insert(altCharacters, ch);
    }
  }
  goog.array.removeDuplicates(altCharacters);
  return altCharacters;
};
CharacterKey.prototype.getActiveCharacter = function() {
  if (this.flickerredCharacter) {
    return this.flickerredCharacter;
  }
  for (var i = 0; i < this.getChildCount(); i++) {
    var child = 
 (this.getChildAt(i));
    if (child.isHighlighted()) {
      return child.getContent();
    }
  }
  return '';
};
CharacterKey.prototype.getCharacterByGesture =
    function(upOrDown) {
  var hasAltGrState = this.stateManager_.hasState(StateType.ALTGR);
  var hasShiftState = this.stateManager_.hasState(StateType.SHIFT);
  if (upOrDown == hasShiftState) {
    return '';
  }
  var index = 0;
  if (upOrDown && hasAltGrState) {
    index = 3;
  } else if (upOrDown && !hasAltGrState) {
    index = 1;
  } else if (!upOrDown && hasAltGrState) {
    index = 2;
  }
  var character = index >= this.getChildCount() ? null :
      (this.getChildAt(index));
  if (character && character.isVisible()) {
    return character.getContent();
  }
  return '';
};
CharacterKey.prototype.update = function() {
  goog.base(this, 'update');
  this.pointerConfig.flickerDirection = this.stateManager_.hasState(
      StateType.SHIFT) ?
      i18n.input.chrome.inputview.SwipeDirection.DOWN :
      i18n.input.chrome.inputview.SwipeDirection.UP;
  var ariaLabel = this.getActiveCharacter();
  if (this.isLetterKey &&
      (this.stateManager_.hasState(StateType.SHIFT) ||
          this.stateManager_.hasState(StateType.CAPSLOCK))) {
    ariaLabel = 'cap ' + ariaLabel;
  }
  goog.a11y.aria.setState( (this.getElement()),
      goog.a11y.aria.State.LABEL, ariaLabel);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CompactKey
goog.provide('i18n.input.chrome.inputview.elements.content.CompactKey');
goog.scope(function() {
var CompactKeyModel =
    i18n.input.chrome.inputview.elements.content.CompactKeyModel;
var ContextType = i18n.input.chrome.message.ContextType;
var MoreKeysShiftOperation = i18n.input.chrome.inputview.MoreKeysShiftOperation;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
var StateType = i18n.input.chrome.inputview.StateType;
var util = i18n.input.chrome.inputview.util;
i18n.input.chrome.inputview.elements.content.CompactKey = function(id, text,
    hintText, stateManager, hasShift, compactKeyModel, opt_eventTarget) {
  var textCssClass = compactKeyModel.textCssClass;
  goog.base(this, id, i18n.input.chrome.ElementType.
      COMPACT_KEY, text, '', opt_eventTarget, textCssClass);
  this.hintText = hintText;
  this.hasShift_ = hasShift;
  this.stateManager_ = stateManager;
  this.compactKeyModel_ = compactKeyModel;
  this.pointerConfig.longPressWithPointerUp = true;
  this.pointerConfig.flickerDirection =
      i18n.input.chrome.inputview.SwipeDirection.UP;
  this.pointerConfig.longPressDelay = 500;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.CompactKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
var CompactKey = i18n.input.chrome.inputview.elements.content.CompactKey;
CompactKey.prototype.flickerredCharacter = '';
CompactKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  goog.dom.classlist.add(this.tableCell,
      i18n.input.chrome.inputview.Css.COMPACT_KEY);
  if (!this.compactKeyModel_.isGrey) {
    goog.dom.classlist.remove(this.bgElem,
        i18n.input.chrome.inputview.Css.SPECIAL_KEY_BG);
  }
  if (this.hintText) {
    var dom = this.getDomHelper();
    dom.removeChildren(this.tableCell);
    this.inlineWrap = dom.createDom(goog.dom.TagName.DIV,
        i18n.input.chrome.inputview.Css.INLINE_DIV);
    dom.appendChild(this.tableCell, this.inlineWrap);
    this.hintTextElem = dom.createDom(goog.dom.TagName.DIV,
        i18n.input.chrome.inputview.Css.HINT_TEXT, this.hintText);
    dom.appendChild(this.inlineWrap, this.hintTextElem);
    dom.appendChild(this.inlineWrap, this.textElem);
  }
  goog.a11y.aria.setState( (this.textElem),
      goog.a11y.aria.State.LABEL, this.text);
};
CompactKey.prototype.resize = function(width, height) {
  var elem = this.getElement();
  var marginLeft = Math.floor(width * this.compactKeyModel_.marginLeftPercent);
  if (marginLeft > 0) {
    marginLeft -= 5;
    elem.style.marginLeft = marginLeft + 'px';
  }
  var marginRight =
      Math.floor(width * this.compactKeyModel_.marginRightPercent);
  if (marginRight > 0) {
    marginRight += 5;
    elem.style.marginRight = marginRight + 'px';
  }
  goog.base(this, 'resize', width, height);
};
CompactKey.prototype.getContextOptimizedText_ = function() {
  var context = this.stateManager_.contextType;
  for (var contextType in this.compactKeyModel_.textOnContext) {
    var oldCss =
        this.compactKeyModel_.
        textOnContext[contextType][SpecNodeName.TEXT_CSS_CLASS];
    goog.dom.classlist.remove(this.tableCell, oldCss);
  }
  var text;
  if (context && this.compactKeyModel_.textOnContext[context]) {
    text = this.compactKeyModel_.textOnContext[context][SpecNodeName.TEXT];
    var newCss =
        this.compactKeyModel_.
        textOnContext[context][SpecNodeName.TEXT_CSS_CLASS];
    goog.dom.classlist.add(this.tableCell, newCss);
  } else if (this.hasShift_ && this.stateManager_.hasState(StateType.SHIFT)) {
    text = this.compactKeyModel_.textOnShift ?
        this.compactKeyModel_.textOnShift : this.text.toUpperCase();
  } else {
    text = this.text;
  }
  return text;
};
CompactKey.prototype.getActiveCharacter = function() {
  if (this.flickerredCharacter) {
    return this.flickerredCharacter;
  } else {
    return this.getContextOptimizedText_();
  }
};
CompactKey.prototype.update = function() {
  goog.base(this, 'update');
  var text = this.getContextOptimizedText_();
  var displayHintText = this.stateManager_.contextType != ContextType.PASSWORD;
  if (this.compactKeyModel_.textOnShift) {
    if (this.hasShift_ && this.stateManager_.hasState(StateType.SHIFT)) {
      displayHintText = false;
      text = this.compactKeyModel_.textOnShift;
    }
  }
  this.hintTextElem &&
      goog.style.setElementShown(this.hintTextElem, displayHintText);
  text = this.compactKeyModel_.title ?
      chrome.i18n.getMessage(this.compactKeyModel_.title) : text;
  goog.dom.setTextContent(this.textElem, text);
  var ariaLabel = text;
  if (this.hasShift_ && this.stateManager_.hasState(StateType.SHIFT) &&
      util.toUpper(text) != this.text) {
    ariaLabel = 'cap ' + text;
  }
  goog.a11y.aria.setState( (this.textElem),
      goog.a11y.aria.State.LABEL, ariaLabel);
};
CompactKey.prototype.getMoreCharacters = function() {
  var context = this.stateManager_.contextType;
  var contextMap = context && this.compactKeyModel_.textOnContext[context];
  if (contextMap &&
      contextMap[SpecNodeName.MORE_KEYS] &&
      contextMap[SpecNodeName.MORE_KEYS][SpecNodeName.CHARACTERS]) {
    return goog.array.clone(
        contextMap[SpecNodeName.MORE_KEYS][SpecNodeName.CHARACTERS]);
  } else {
    var moreCharacters = goog.array.clone(this.compactKeyModel_.moreKeys);
    switch (this.compactKeyModel_.moreKeysShiftOperation) {
      case MoreKeysShiftOperation.TO_UPPER_CASE:
        if (this.getActiveCharacter().toLowerCase() !=
            this.getActiveCharacter()) {
          for (var i = 0; i < this.compactKeyModel_.moreKeys.length; i++) {
            moreCharacters[i] = this.compactKeyModel_.moreKeys[i].toUpperCase();
          }
          goog.array.removeDuplicates(moreCharacters);
        }
        return moreCharacters;
      case MoreKeysShiftOperation.TO_LOWER_CASE:
        if (this.hasShift_ && this.stateManager_.hasState(StateType.SHIFT)) {
          for (var i = 0; i < this.compactKeyModel_.moreKeys.length; i++) {
            moreCharacters[i] = this.compactKeyModel_.moreKeys[i].toLowerCase();
          }
          goog.array.removeDuplicates(moreCharacters);
        }
        return moreCharacters;
      case MoreKeysShiftOperation.STABLE:
        break;
    }
    return moreCharacters;
  }
};
CompactKey.prototype.getFixedColumns = function() {
  return this.compactKeyModel_.fixedColumns;
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.CompactKeyModel
goog.provide('i18n.input.chrome.inputview.elements.content.CompactKeyModel');
goog.scope(function() {
var MoreKeysShiftOperation = i18n.input.chrome.inputview.MoreKeysShiftOperation;
i18n.input.chrome.inputview.elements.content.CompactKeyModel =
    function(marginLeftPercent, marginRightPercent, isGrey, moreKeys,
        moreKeysShiftOperation, textOnShift, textOnContext,
        opt_textCssClass, opt_title, opt_fixedColumns) {
  this.marginLeftPercent = marginLeftPercent || 0;
  this.marginRightPercent = marginRightPercent || 0;
  this.isGrey = !!isGrey;
  this.moreKeys = moreKeys || [];
  this.moreKeysShiftOperation = moreKeysShiftOperation ?
      moreKeysShiftOperation : MoreKeysShiftOperation.TO_UPPER_CASE;
  this.textOnShift = textOnShift;
  this.textCssClass = opt_textCssClass || '';
  this.textOnContext = textOnContext || {};
  this.fixedColumns = opt_fixedColumns || 0;
  this.title = opt_title || '';
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.EmojiKey
goog.provide('i18n.input.chrome.inputview.elements.content.EmojiKey');
goog.scope(function() {
var EMOJI_KEY_MARGIN = 6;
i18n.input.chrome.inputview.elements.content.EmojiKey = function(id, type,
    text, isEmoticon, opt_eventTarget) {
  i18n.input.chrome.inputview.elements.content.EmojiKey.base(
      this, 'constructor', id, type, opt_eventTarget);
  this.text = text;
  this.isEmoticon = isEmoticon;
  this.pointerConfig.stopEventPropagation = false;
  this.pointerConfig.dblClick = true;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.EmojiKey,
    i18n.input.chrome.inputview.elements.content.SoftKey);
var EmojiKey = i18n.input.chrome.inputview.elements.content.EmojiKey;
EmojiKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  if (!this.textElem) {
    this.textElem = dom.createDom(goog.dom.TagName.DIV,
        i18n.input.chrome.inputview.Css.SPECIAL_KEY_NAME, this.text);
  }
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.EMOJI_KEY);
  elem.style.margin = EMOJI_KEY_MARGIN + 'px';
  this.updateText(this.text, this.isEmoticon);
  dom.appendChild(elem, this.textElem);
  setTimeout(this.setAriaLable_.bind(this), 0);
};
EmojiKey.prototype.resize = function(width, height) {
  var elem = this.getElement();
  var w = width - EMOJI_KEY_MARGIN * 2;
  var h = height - EMOJI_KEY_MARGIN * 2;
  elem.style.width = w + 'px';
  elem.style.height = h + 'px';
  this.availableWidth = w;
  this.availableHeight = h;
};
EmojiKey.prototype.setHighlighted = function(highlight) {
  if (this.text == '') {
    return;
  }
  goog.base(this, 'setHighlighted', highlight);
};
EmojiKey.prototype.update = function() {
  goog.base(this, 'update');
  goog.dom.setTextContent(this.textElem, this.text);
};
EmojiKey.prototype.updateText = function(text, isEmoticon) {
  this.text = text;
  this.isEmoticon = isEmoticon;
  goog.dom.setTextContent(this.textElem, text);
  var elem = this.getElement();
  if (isEmoticon) {
    goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.EMOTICON);
  } else {
    goog.dom.classlist.remove(elem, i18n.input.chrome.inputview.Css.EMOTICON);
  }
};
EmojiKey.prototype.setAriaLable_ = function() {
  var emojiName = '';
  var lead = this.text.charCodeAt(0);
  if (this.isEmoticon) {
    emojiName = chrome.i18n.getMessage('smiley');
  } else if (lead) {
    var trail = this.text.charCodeAt(1);
    var msgName = lead.toString(16);
    if (!!trail) {
      msgName += '_' + trail.toString(16);
    }
    emojiName = chrome.i18n.getMessage(msgName.toLowerCase());
  }
  if (emojiName) {
    goog.a11y.aria.setState( (this.getElement()),
        goog.a11y.aria.State.LABEL, emojiName);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.EnSwitcherKey
goog.provide('i18n.input.chrome.inputview.elements.content.EnSwitcherKey');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.EnSwitcherKey = function(id, type,
    text, iconCssClass, stateManager, defaultCss, englishCss) {
  i18n.input.chrome.inputview.elements.content.EnSwitcherKey.base(
      this, 'constructor', id, type, text, '');
  this.currentIconCss_ = defaultCss;
  this.stateManager_ = stateManager;
  this.defaultIconCss_ = defaultCss;
  this.enIconCss_ = englishCss;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.EnSwitcherKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
var EnSwitcherKey = i18n.input.chrome.inputview.elements.content.EnSwitcherKey;
EnSwitcherKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  this.iconElem = dom.createDom(goog.dom.TagName.DIV, this.currentIconCss_);
  dom.appendChild(this.tableCell, this.iconElem);
};
EnSwitcherKey.prototype.update = function() {
  goog.base(this, 'update');
  var isEnMode = this.stateManager_.isEnMode;
  goog.dom.classlist.remove(this.iconElem, this.currentIconCss_);
  this.currentIconCss_ = isEnMode ? this.enIconCss_ : this.defaultIconCss_;
  goog.dom.classlist.add(this.iconElem, this.currentIconCss_);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.EnterKey
goog.provide('i18n.input.chrome.inputview.elements.content.EnterKey');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.elements.content.EnterKey = function(id,
    iconCssClass, opt_eventTarget) {
  goog.base(this, id, ElementType.ENTER_KEY, '', iconCssClass,
      opt_eventTarget);
};
goog.inherits(i18n.input.chrome.inputview.elements.content.EnterKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
var EnterKey = i18n.input.chrome.inputview.elements.content.EnterKey;
EnterKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  this.disableBackgroundHighlight();
};
});  // goog.scope

// i18n.input.chrome.inputview.Covariance
goog.provide('i18n.input.chrome.inputview.Covariance');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.Covariance = function() {
  this.breakDown_ = 0;
};
var Covariance = i18n.input.chrome.inputview.Covariance;
Covariance.BreakDown = {
  A11Y: 1,
  HORIZONTAL: 2,
  WIDE_SCREEN: 4
};
Covariance.ElementTypeMap = goog.object.create(
    ElementType.CHARACTER_KEY, 0,
    ElementType.COMPACT_KEY, 1
    );
Covariance.VALUE_ = {
  0: [120, 160],
  1: [130, 0],
  2: [235, 342],
  3: [162, 0],
  4: [160, 213],
  5: [142, 0],
  6: [230, 332],
  7: [162, 0]
};
Covariance.prototype.update = function(isWideScreen, isHorizontal, isA11y) {
  this.breakDown_ = 0;
  if (isWideScreen) {
    this.breakDown_ |= Covariance.BreakDown.WIDE_SCREEN;
  }
  if (isHorizontal) {
    this.breakDown_ |= Covariance.BreakDown.HORIZONTAL;
  }
  if (isA11y) {
    this.breakDown_ |= Covariance.BreakDown.A11Y;
  }
};
Covariance.prototype.getValue = function(type) {
  var index = Covariance.ElementTypeMap[type];
  return Covariance.VALUE_[this.breakDown_][index];
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.GaussianEstimator
goog.provide('i18n.input.chrome.inputview.elements.content.GaussianEstimator');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.GaussianEstimator = function(
    center, covariance, amplitude) {
  this.center_ = center;
  this.cinvX_ = 1 / (amplitude * covariance);
  this.cinvY_ = 1 / covariance;
  this.logNorm_ = Math.log(1 / (2 * Math.PI * Math.sqrt(amplitude *
      covariance * covariance)));
};
var GaussianEstimator = i18n.input.chrome.inputview.elements.content.
    GaussianEstimator;
GaussianEstimator.prototype.estimateInLogSpace = function(x, y) {
  var dx = x - this.center_.x;
  var dy = y - this.center_.y;
  var exponent = this.cinvX_ * dx * dx + this.cinvY_ * dy * dy;
  return this.logNorm_ + (-0.5) * exponent;
};
}); // goog.scope

// i18n.input.chrome.inputview.elements.layout.VerticalLayout
goog.provide('i18n.input.chrome.inputview.elements.layout.VerticalLayout');
goog.scope(function() {
i18n.input.chrome.inputview.elements.layout.VerticalLayout = function(id,
    opt_eventTarget, opt_type) {
  var type = opt_type || i18n.input.chrome.ElementType.
      VERTICAL_LAYOUT;
  goog.base(this, id, type, opt_eventTarget);
};
goog.inherits(i18n.input.chrome.inputview.elements.layout.VerticalLayout,
    i18n.input.chrome.inputview.elements.Element);
var VerticalLayout = i18n.input.chrome.inputview.elements.layout.VerticalLayout;
VerticalLayout.prototype.heightInWeight_ = 0;
VerticalLayout.prototype.widthInWeight_ = 0;
VerticalLayout.prototype.createDom = function() {
  goog.base(this, 'createDom');
  goog.dom.classlist.add(this.getElement(),
      i18n.input.chrome.inputview.Css.VERTICAL_LAYOUT);
  this.getElement()['view'] = null;
};
VerticalLayout.prototype.enterDocument =
    function() {
  goog.base(this, 'enterDocument');
  this.calculate_();
};
VerticalLayout.prototype.calculate_ = function() {
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    if (this.widthInWeight_ < child.getWidthInWeight()) {
      this.widthInWeight_ = child.getWidthInWeight();
    }
    this.heightInWeight_ += child.getHeightInWeight();
  }
};
VerticalLayout.prototype.getHeightInWeight = function() {
  return this.heightInWeight_;
};
VerticalLayout.prototype.getWidthInWeight = function() {
  return this.widthInWeight_;
};
VerticalLayout.prototype.resize = function(
    width, height) {
  goog.base(this, 'resize', width, height);
  this.getElement().style.width = width + 'px';
  var weightArray = [];
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    weightArray.push(child.getHeightInWeight());
  }
  var splitedHeight = i18n.input.chrome.inputview.util.splitValue(weightArray,
      height);
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    child.resize(width, splitedHeight[i]);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.KeyboardView
goog.provide('i18n.input.chrome.inputview.elements.content.KeyboardView');
goog.scope(function() {
var layout = i18n.input.chrome.inputview.elements.layout;
var content = i18n.input.chrome.inputview.elements.content;
var ElementType = i18n.input.chrome.ElementType;
content.KeyboardView = function(id, opt_eventTarget) {
  goog.base(this, id, opt_eventTarget, ElementType.LAYOUT_VIEW);
};
goog.inherits(content.KeyboardView, layout.VerticalLayout);
var KeyboardView = content.KeyboardView;
KeyboardView.prototype.softKeyViewMap_;
KeyboardView.prototype.softKeyMap_;
KeyboardView.prototype.mapping_;
KeyboardView.SQUARED_NEARBY_FACTOR_ = 1.2;
KeyboardView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var elem = this.getElement();
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.LAYOUT_VIEW);
};
KeyboardView.prototype.setUp = function(softKeyList, softKeyViewMap, mapping) {
  this.softKeyMap_ = {};
  this.softKeyViewMap_ = softKeyViewMap;
  this.mapping_ = mapping;
  for (var i = 0; i < softKeyList.length; i++) {
    var sk = softKeyList[i];
    var skv = this.softKeyViewMap_[mapping[sk.id]];
    if (skv) {
      skv.bindSoftKey(sk);
    }
    this.softKeyMap_[sk.id] = sk;
  }
};
KeyboardView.prototype.getViewForKey = function(code) {
  if (code) {
    return this.softKeyMap_[code];
  }
  return null;
};
KeyboardView.prototype.setUpNearbyKeys_ = function() {
  var softKeys = goog.object.getValues(this.softKeyMap_);
  var covariance = new i18n.input.chrome.inputview.Covariance();
  for (var i = 0; i < softKeys.length; i++) {
    var key = softKeys[i];
    key.nearbyKeys = [];
    key.topLeftCoordinate = goog.style.getClientPosition(key.getElement());
    key.centerCoordinate = new goog.math.Coordinate(
        key.topLeftCoordinate.x + key.availableWidth / 2,
        key.topLeftCoordinate.y + key.availableHeight / 2);
    key.estimator = new i18n.input.chrome.inputview.elements.content.
        GaussianEstimator(key.centerCoordinate,
            covariance.getValue(key.type),
            key.availableHeight / key.availableWidth);
  }
  for (var i = 0; i < softKeys.length; i++) {
    var key1 = softKeys[i];
    if (!this.isQualifiedForSpatial_(key1)) {
      continue;
    }
    for (var j = i + 1; j < softKeys.length; j++) {
      var key2 = softKeys[j];
      if (this.isQualifiedForSpatial_(key2) && this.isNearby_(key1, key2)) {
        key1.nearbyKeys.push(key2);
        key2.nearbyKeys.push(key1);
      }
    }
  }
};
KeyboardView.prototype.isQualifiedForSpatial_ = function(key) {
  return key.type == ElementType.CHARACTER_KEY ||
      key.type == ElementType.COMPACT_KEY;
};
KeyboardView.prototype.isNearby_ = function(key1, key2) {
  var key2Center = key2.centerCoordinate;
  var key1Left = key1.topLeftCoordinate.x;
  var key1Right = key1Left + key1.width;
  var key1Top = key1.topLeftCoordinate.y;
  var key1Bottom = key1Top + key1.height;
  var edgeX = key2Center.x < key1Left ? key1Left : (key2Center.x > key1Right ?
      key1Right : key2Center.x);
  var edgeY = key2Center.y < key1Top ? key1Top : (key2Center.y > key1Bottom ?
      key1Bottom : key2Center.y);
  var dx = key2Center.x - edgeX;
  var dy = key2Center.y - edgeY;
  return (dx * dx + dy * dy) < KeyboardView.
      SQUARED_NEARBY_FACTOR_ * (key1.availableWidth * key1.availableWidth);
};
KeyboardView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  goog.Timer.callOnce(this.setUpNearbyKeys_.bind(this));
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.MenuKey
goog.provide('i18n.input.chrome.inputview.elements.content.MenuKey');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.MenuKey = function(id, type,
    text, iconCssClass, toKeyset, opt_eventTarget) {
  goog.base(this, id, type, text, iconCssClass, opt_eventTarget);
  this.toKeyset = toKeyset;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.MenuKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.ModifierKey
goog.provide('i18n.input.chrome.inputview.elements.content.ModifierKey');
goog.scope(function() {
var StateType = i18n.input.chrome.inputview.StateType;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.content.ModifierKey = function(id, name,
    iconCssClass, toState, stateManager, supportSticky, opt_eventTarget) {
  goog.base(this, id,
      i18n.input.chrome.ElementType.MODIFIER_KEY,
      name, iconCssClass, opt_eventTarget);
  this.toState = toState;
  this.stateManager_ = stateManager;
  this.supportSticky = supportSticky;
  if (supportSticky) {
    this.pointerConfig.dblClick = true;
    this.pointerConfig.longPressWithPointerUp = true;
    this.pointerConfig.longPressDelay = 1200;
  }
};
goog.inherits(i18n.input.chrome.inputview.elements.content.ModifierKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
var ModifierKey = i18n.input.chrome.inputview.elements.content.ModifierKey;
ModifierKey.prototype.dotIcon_;
ModifierKey.prototype.isDoubleClicking = false;
ModifierKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  if (this.toState == i18n.input.chrome.inputview.StateType.CAPSLOCK) {
    var dom = this.getDomHelper();
    this.dotIcon_ = dom.createDom(goog.dom.TagName.DIV, Css.CAPSLOCK_DOT);
    dom.appendChild(this.tableCell, this.dotIcon_);
  }
  this.setAriaLabel(this.getChromeVoxMessage());
};
ModifierKey.prototype.update = function() {
  var isStateEnabled = this.stateManager_.hasState(this.toState);
  var isSticky = this.stateManager_.isSticky(this.toState);
  var isFinalSticky = this.stateManager_.isFinalSticky(this.toState);
  this.setHighlighted(isStateEnabled);
  if (this.dotIcon_) {
    if (isStateEnabled && isSticky && isFinalSticky) {
      goog.dom.classlist.add(this.dotIcon_, Css.CAPSLOCK_DOT_HIGHLIGHT);
    } else {
      goog.dom.classlist.remove(this.dotIcon_, Css.CAPSLOCK_DOT_HIGHLIGHT);
    }
  }
  if (isStateEnabled && isSticky && isFinalSticky) {
    goog.dom.classlist.add(this.bgElem, Css.FUNCITONAL_KEY_STICKY);
  } else {
    goog.dom.classlist.remove(this.bgElem, Css.FUNCITONAL_KEY_STICKY);
  }
};
ModifierKey.prototype.getChromeVoxMessage = function() {
  switch (this.toState) {
    case StateType.SHIFT:
      return chrome.i18n.getMessage('SHIFT');
    case StateType.CAPSLOCK:
      return chrome.i18n.getMessage('CAPSLOCK');
    case StateType.ALTGR:
      return chrome.i18n.getMessage('ALTGR');
  }
  return '';
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.PageIndicator
goog.provide('i18n.input.chrome.inputview.elements.content.PageIndicator');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.elements.content.PageIndicator = function(id, type,
    opt_eventTarget) {
  goog.base(this, id, type, opt_eventTarget);
};
goog.inherits(i18n.input.chrome.inputview.elements.content.PageIndicator,
    i18n.input.chrome.inputview.elements.Element);
var PageIndicator = i18n.input.chrome.inputview.elements.content.PageIndicator;
PageIndicator.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem,
      i18n.input.chrome.inputview.Css.INDICATOR_BACKGROUND);
  this.bgElem = goog.dom.createDom(goog.dom.TagName.DIV);
  goog.dom.classlist.add(this.bgElem,
      i18n.input.chrome.inputview.Css.INDICATOR);
  dom.appendChild(elem, this.bgElem);
};
PageIndicator.prototype.slide = function(deltaX, totalPages) {
  var marginLeft = goog.style.getMarginBox(this.bgElem).left +
      deltaX / totalPages;
  this.bgElem.style.marginLeft = marginLeft + 'px';
};
PageIndicator.prototype.gotoPage = function(pageNum, totalPages) {
  var width = goog.style.getSize(this.getElement()).width;
  this.bgElem.style.marginLeft = width / totalPages * pageNum + 'px';
  if (totalPages >= 2) {
    this.bgElem.style.width = width / totalPages + 'px';
  } else {
    this.bgElem.style.width = 0;
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.SpaceKey
goog.provide('i18n.input.chrome.inputview.elements.content.SpaceKey');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var content = i18n.input.chrome.inputview.elements.content;
content.SpaceKey = function(id, stateManager, title, opt_characters,
    opt_eventTarget, opt_iconCss, opt_toKeyset) {
  goog.base(this, id, i18n.input.chrome.ElementType.
      SPACE_KEY, opt_eventTarget);
  this.characters_ = opt_characters || [];
  this.title_ = title;
  this.stateManager_ = stateManager;
  this.iconCss_ = opt_iconCss || '';
  this.toKeyset = opt_toKeyset || '';
  this.pointerConfig.dblClick = true;
  this.pointerConfig.dblClickDelay = 1000;
};
goog.inherits(content.SpaceKey, i18n.input.chrome.inputview.elements.
    content.SoftKey);
var SpaceKey = content.SpaceKey;
SpaceKey.HEIGHT = 43;
SpaceKey.prototype.wrapper_;
SpaceKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  this.wrapper_ = dom.createDom(goog.dom.TagName.DIV, Css.SPACE_WRAPPER);
  dom.appendChild(this.getElement(), this.wrapper_);
  if (this.iconCss_) {
    var iconElem = dom.createDom(goog.dom.TagName.DIV, this.iconCss_);
    dom.appendChild(this.wrapper_, iconElem);
  } else {
    goog.dom.classlist.add(this.wrapper_, Css.SPACE_GREY_BG);
    goog.dom.setTextContent(this.wrapper_, this.title_);
  }
  goog.a11y.aria.setState(
      this.getElement(), goog.a11y.aria.State.LABEL,
      this.getChromeVoxMessage());
  goog.a11y.aria.setRole(this.getElement(), goog.a11y.aria.Role.BUTTON);
};
SpaceKey.prototype.getCharacter = function() {
  if (this.characters_) {
    var index = this.stateManager_.hasState(i18n.input.chrome.inputview.
        StateType.SHIFT) ? 1 : 0 + this.stateManager_.hasState(
            i18n.input.chrome.inputview.StateType.ALTGR) ? 2 : 0;
    if (this.characters_.length > index && this.characters_[index]) {
      return this.characters_[index];
    }
  }
  return ' ';
};
SpaceKey.prototype.updateTitle = function(title, visible) {
  if (this.iconCss_) {
    return;
  }
  this.text = title;
  goog.dom.setTextContent(this.wrapper_, visible ? title : '');
  goog.dom.classlist.add(this.wrapper_,
      i18n.input.chrome.inputview.Css.TITLE);
};
SpaceKey.prototype.setHighlighted = function(highlight) {
  if (highlight) {
    goog.dom.classlist.add(this.wrapper_, i18n.input.chrome.inputview.Css.
        ELEMENT_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.wrapper_, i18n.input.chrome.inputview.Css.
        ELEMENT_HIGHLIGHT);
  }
};
SpaceKey.prototype.getChromeVoxMessage = function() {
  return chrome.i18n.getMessage('SPACE');
};
SpaceKey.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  goog.style.setSize(this.wrapper_, width, SpaceKey.HEIGHT);
  this.wrapper_.style.top = (this.availableHeight - SpaceKey.HEIGHT) / 2 + 'px';
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.SwitcherKey
goog.provide('i18n.input.chrome.inputview.elements.content.SwitcherKey');
goog.scope(function() {
var FunctionalKey = i18n.input.chrome.inputview.elements.content.FunctionalKey;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.content.SwitcherKey = function(id, type,
    text, iconCssClass, toKeyset, toKeysetName, record, opt_eventTarget) {
  goog.base(this, id, type, text, iconCssClass, opt_eventTarget);
  this.toKeyset = toKeyset;
  this.toKeysetName = toKeysetName;
  this.record = record;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.SwitcherKey,
    FunctionalKey);
var SwitcherKey = i18n.input.chrome.inputview.elements.content.SwitcherKey;
SwitcherKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  this.setAriaLabel(this.getChromeVoxMessage());
  if (this.textElem) {
    goog.dom.classlist.add(this.textElem, Css.SWITCHER_KEY_NAME);
  }
};
SwitcherKey.prototype.getChromeVoxMessage = function() {
  return chrome.i18n.getMessage('SWITCH_TO') + this.toKeysetName;
};
});  // goog.scope

// i18n.input.chrome.inputview.EmojiType
goog.provide('i18n.input.chrome.inputview.EmojiType');
i18n.input.chrome.inputview.EmojiType = {
  RECENT: 0,
  HOT: 1,
  EMOTION: 2,
  ITEMS: 3,
  NATURE: 4,
  PLACES_OF_INTERESTS: 5,
  SPECIAL_CHARACTERS: 6,
  EMOTICON: 7
};

// i18n.input.chrome.inputview.elements.content.TabBarKey
goog.provide('i18n.input.chrome.inputview.elements.content.TabBarKey');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var EmojiType = i18n.input.chrome.inputview.EmojiType;
i18n.input.chrome.inputview.elements.content.TabBarKey = function(id, type,
    text, iconCssClass, toCategory, stateManager, opt_eventTarget) {
  goog.base(this, id, type, text, iconCssClass, opt_eventTarget);
  this.toCategory = toCategory;
  this.stateManager = stateManager;
  this.pointerConfig.stopEventPropagation = false;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.TabBarKey,
    i18n.input.chrome.inputview.elements.content.FunctionalKey);
var TabBarKey = i18n.input.chrome.inputview.elements.content.TabBarKey;
TabBarKey.prototype.BORDER_HEIGHT_ = 4;
TabBarKey.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var elem = this.getElement();
  goog.dom.classlist.remove(elem, Css.SOFT_KEY);
  goog.dom.classlist.add(elem, Css.EMOJI_TABBAR_SK);
  goog.dom.classlist.remove(this.bgElem, Css.SPECIAL_KEY_BG);
  goog.dom.classlist.add(this.bgElem, Css.EMOJI_TABBAR_KEY);
  goog.dom.classlist.add(this.iconElem, Css.EMOJI_SWITCH);
  var ariaLabel = '';
  switch (this.toCategory) {
    case EmojiType.RECENT:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_RECENT');
      break;
    case EmojiType.HOT:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_HOT');
      break;
    case EmojiType.EMOTION:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_FACE');
      break;
    case EmojiType.SPECIAL_CHARACTERS:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_SYMBOL');
      break;
    case EmojiType.NATURE:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_NATURE');
      break;
    case EmojiType.PLACES_OF_INTERESTS:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_PLACE');
      break;
    case EmojiType.ITEMS:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_OBJECT');
      break;
    case EmojiType.EMOTICON:
      ariaLabel = chrome.i18n.getMessage('EMOJI_TAB_EMOTICON');
      break;
  }
  goog.a11y.aria.setState( (elem),
      goog.a11y.aria.State.LABEL, ariaLabel);
};
TabBarKey.prototype.resize = function(width,
    height) {
  goog.base(this, 'resize', width, height);
  this.tableCell.style.width = this.availableWidth + 'px';
  this.tableCell.style.height = this.availableHeight -
      this.BORDER_HEIGHT_ + 'px';
};
TabBarKey.prototype.createSeparator_ = function() {
  var dom = this.getDomHelper();
  this.sepTableCell = dom.createDom(goog.dom.TagName.DIV, Css.TABLE_CELL);
  this.separator = dom.createDom(goog.dom.TagName.DIV,
      Css.CANDIDATE_SEPARATOR);
  this.separator.style.height = Math.floor(this.height * 0.32) + 'px';
  dom.appendChild(this.sepTableCell, this.separator);
  dom.appendChild(this.bgElem, this.sepTableCell);
};
TabBarKey.prototype.updateBorder = function(categoryID) {
  if (categoryID == this.toCategory) {
    goog.dom.classlist.add(this.bgElem, Css.EMOJI_TABBAR_KEY_HIGHLIGHT);
    goog.dom.classlist.add(this.iconElem, Css.EMOJI_SWITCH_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.bgElem, Css.EMOJI_TABBAR_KEY_HIGHLIGHT);
    goog.dom.classlist.remove(this.iconElem, Css.EMOJI_SWITCH_HIGHLIGHT);
  }
};
});  // goog.scope

// goog.math.Coordinate3
goog.provide('goog.math.Coordinate3');
goog.math.Coordinate3 = function(opt_x, opt_y, opt_z) {
  this.x = goog.isDef(opt_x) ? opt_x : 0;
  this.y = goog.isDef(opt_y) ? opt_y : 0;
  this.z = goog.isDef(opt_z) ? opt_z : 0;
};
goog.math.Coordinate3.prototype.clone = function() {
  return new goog.math.Coordinate3(this.x, this.y, this.z);
};
if (goog.DEBUG) {
  goog.math.Coordinate3.prototype.toString = function() {
    return '(' + this.x + ', ' + this.y + ', ' + this.z + ')';
  };
}
goog.math.Coordinate3.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.x == b.x && a.y == b.y && a.z == b.z;
};
goog.math.Coordinate3.distance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  var dz = a.z - b.z;
  return Math.sqrt(dx * dx + dy * dy + dz * dz);
};
goog.math.Coordinate3.squaredDistance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  var dz = a.z - b.z;
  return dx * dx + dy * dy + dz * dz;
};
goog.math.Coordinate3.difference = function(a, b) {
  return new goog.math.Coordinate3(a.x - b.x, a.y - b.y, a.z - b.z);
};
goog.math.Coordinate3.prototype.toArray = function() {
  return [this.x, this.y, this.z];
};
goog.math.Coordinate3.fromArray = function(a) {
  if (a.length <= 3) {
    return new goog.math.Coordinate3(a[0], a[1], a[2]);
  }
  throw Error('Conversion from an array requires an array of length 3');
};

// goog.userAgent.product
goog.provide('goog.userAgent.product');
goog.define('goog.userAgent.product.ASSUME_FIREFOX', false);
goog.define('goog.userAgent.product.ASSUME_IPHONE', false);
goog.define('goog.userAgent.product.ASSUME_IPAD', false);
goog.define('goog.userAgent.product.ASSUME_ANDROID', false);
goog.define('goog.userAgent.product.ASSUME_CHROME', false);
goog.define('goog.userAgent.product.ASSUME_SAFARI', false);
goog.userAgent.product.PRODUCT_KNOWN_ =
    goog.userAgent.ASSUME_IE ||
    goog.userAgent.ASSUME_OPERA ||
    goog.userAgent.product.ASSUME_FIREFOX ||
    goog.userAgent.product.ASSUME_IPHONE ||
    goog.userAgent.product.ASSUME_IPAD ||
    goog.userAgent.product.ASSUME_ANDROID ||
    goog.userAgent.product.ASSUME_CHROME ||
    goog.userAgent.product.ASSUME_SAFARI;
goog.userAgent.product.OPERA = goog.userAgent.OPERA;
goog.userAgent.product.IE = goog.userAgent.IE;
goog.userAgent.product.FIREFOX = goog.userAgent.product.PRODUCT_KNOWN_ ?
    goog.userAgent.product.ASSUME_FIREFOX :
    goog.labs.userAgent.browser.isFirefox();
goog.userAgent.product.isIphoneOrIpod_ = function() {
  return goog.labs.userAgent.platform.isIphone() ||
      goog.labs.userAgent.platform.isIpod();
};
goog.userAgent.product.IPHONE = goog.userAgent.product.PRODUCT_KNOWN_ ?
    goog.userAgent.product.ASSUME_IPHONE :
    goog.userAgent.product.isIphoneOrIpod_();
goog.userAgent.product.IPAD = goog.userAgent.product.PRODUCT_KNOWN_ ?
    goog.userAgent.product.ASSUME_IPAD :
    goog.labs.userAgent.platform.isIpad();
goog.userAgent.product.ANDROID = goog.userAgent.product.PRODUCT_KNOWN_ ?
    goog.userAgent.product.ASSUME_ANDROID :
    goog.labs.userAgent.browser.isAndroidBrowser();
goog.userAgent.product.CHROME = goog.userAgent.product.PRODUCT_KNOWN_ ?
    goog.userAgent.product.ASSUME_CHROME :
    goog.labs.userAgent.browser.isChrome();
goog.userAgent.product.isSafariDesktop_ = function() {
  return goog.labs.userAgent.browser.isSafari() &&
      !goog.labs.userAgent.platform.isIos();
};
goog.userAgent.product.SAFARI = goog.userAgent.product.PRODUCT_KNOWN_ ?
    goog.userAgent.product.ASSUME_SAFARI :
    goog.userAgent.product.isSafariDesktop_();

// goog.userAgent.product.isVersion
goog.provide('goog.userAgent.product.isVersion');
goog.userAgent.product.determineVersion_ = function() {
  if (goog.userAgent.product.FIREFOX) {
    return goog.userAgent.product.getFirstRegExpGroup_(/Firefox\/([0-9.]+)/);
  }
  if (goog.userAgent.product.IE || goog.userAgent.product.OPERA) {
    return goog.userAgent.VERSION;
  }
  if (goog.userAgent.product.CHROME) {
    return goog.userAgent.product.getFirstRegExpGroup_(/Chrome\/([0-9.]+)/);
  }
  if (goog.userAgent.product.SAFARI && !goog.labs.userAgent.platform.isIos()) {
    return goog.userAgent.product.getFirstRegExpGroup_(/Version\/([0-9.]+)/);
  }
  if (goog.userAgent.product.IPHONE || goog.userAgent.product.IPAD) {
    var arr = goog.userAgent.product.execRegExp_(
        /Version\/(\S+).*Mobile\/(\S+)/);
    if (arr) {
      return arr[1] + '.' + arr[2];
    }
  } else if (goog.userAgent.product.ANDROID) {
    var version = goog.userAgent.product.getFirstRegExpGroup_(
        /Android\s+([0-9.]+)/);
    if (version) {
      return version;
    }
    return goog.userAgent.product.getFirstRegExpGroup_(/Version\/([0-9.]+)/);
  }
  return '';
};
goog.userAgent.product.getFirstRegExpGroup_ = function(re) {
  var arr = goog.userAgent.product.execRegExp_(re);
  return arr ? arr[1] : '';
};
goog.userAgent.product.execRegExp_ = function(re) {
  return re.exec(goog.userAgent.getUserAgentString());
};
goog.userAgent.product.VERSION = goog.userAgent.product.determineVersion_();
goog.userAgent.product.isVersion = function(version) {
  return goog.string.compareVersions(
      goog.userAgent.product.VERSION, version) >= 0;
};

// goog.style.transform
goog.provide('goog.style.transform');
goog.style.transform.isSupported = goog.functions.cacheReturnValue(function() {
  return !goog.userAgent.IE || goog.userAgent.product.isVersion(9);
});
goog.style.transform.is3dSupported =
    goog.functions.cacheReturnValue(function() {
  return goog.userAgent.WEBKIT ||
      (goog.userAgent.GECKO && goog.userAgent.product.isVersion(10)) ||
      (goog.userAgent.IE && goog.userAgent.product.isVersion(10));
});
goog.style.transform.getTranslation = function(element) {
  var transform = goog.style.getComputedTransform(element);
  var matrixConstructor = goog.style.transform.matrixConstructor_();
  if (transform && matrixConstructor) {
    var matrix = new matrixConstructor(transform);
    if (matrix) {
      return new goog.math.Coordinate(matrix.m41, matrix.m42);
    }
  }
  return new goog.math.Coordinate(0, 0);
};
goog.style.transform.setTranslation = function(element, x, y) {
  if (!goog.style.transform.isSupported()) {
    return false;
  }
  var translation = goog.style.transform.is3dSupported() ?
      'translate3d(' + x + 'px,' + y + 'px,' + '0px)' :
      'translate(' + x + 'px,' + y + 'px)';
  goog.style.setStyle(element,
      goog.style.transform.getTransformProperty_(), translation);
  return true;
};
goog.style.transform.getScale = function(element) {
  var transform = goog.style.getComputedTransform(element);
  var matrixConstructor = goog.style.transform.matrixConstructor_();
  if (transform && matrixConstructor) {
    var matrix = new matrixConstructor(transform);
    if (matrix) {
      return new goog.math.Coordinate3(matrix.m11, matrix.m22, matrix.m33);
    }
  }
  return new goog.math.Coordinate3(0, 0, 0);
};
goog.style.transform.setScale = function(element, x, y, z) {
  if (!goog.style.transform.isSupported()) {
    return false;
  }
  var scale = goog.style.transform.is3dSupported() ?
      'scale3d(' + x + ',' + y + ',' + z + ')' :
      'scale(' + x + ',' + y + ')';
  goog.style.setStyle(element,
      goog.style.transform.getTransformProperty_(), scale);
  return true;
};
goog.style.transform.getTransformProperty_ =
    goog.functions.cacheReturnValue(function() {
  return goog.userAgent.IE && goog.userAgent.DOCUMENT_MODE == 9 ?
      '-ms-transform' : 'transform';
});
goog.style.transform.matrixConstructor_ =
    goog.functions.cacheReturnValue(function() {
  if (goog.isDef(goog.global['WebKitCSSMatrix'])) {
    return goog.global['WebKitCSSMatrix'];
  }
  if (goog.isDef(goog.global['MSCSSMatrix'])) {
    return goog.global['MSCSSMatrix'];
  }
  if (goog.isDef(goog.global['CSSMatrix'])) {
    return goog.global['CSSMatrix'];
  }
  return null;
});

// i18n.input.chrome.inputview.elements.layout.ExtendedLayout
goog.provide('i18n.input.chrome.inputview.elements.layout.ExtendedLayout');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.layout.ExtendedLayout = function(id,
    opt_eventTarget, opt_iconCssClass) {
  goog.base(this, id, i18n.input.chrome.ElementType.
      EXTENDED_LAYOUT, opt_eventTarget);
  this.iconCssClass = Css.LINEAR_LAYOUT;
};
goog.inherits(i18n.input.chrome.inputview.elements.layout.ExtendedLayout,
    i18n.input.chrome.inputview.elements.Element);
var ExtendedLayout = i18n.input.chrome.inputview.elements.layout.ExtendedLayout;
ExtendedLayout.prototype.heightInWeight_ = 0;
ExtendedLayout.prototype.widthInWeight_ = 0;
ExtendedLayout.prototype.xPosition_ = 0;
ExtendedLayout.BASE_TRANSITION_DURATION_ = 0.2;
ExtendedLayout.BASE_TRANSITION_DISTANCE_ = 100;
ExtendedLayout.prototype.getHeightInWeight = function() {
  return this.heightInWeight_;
};
ExtendedLayout.prototype.getWidthInWeight = function() {
  return this.widthInWeight_;
};
ExtendedLayout.prototype.createDom = function() {
  goog.base(this, 'createDom');
  this.elem = this.getElement();
  goog.dom.classlist.addAll(this.elem,
      [this.iconCssClass, Css.EMOJI_FONT]);
};
ExtendedLayout.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.calculate_();
};
ExtendedLayout.prototype.resize = function(width, height) {
  if (width == this.width && height == this.height) {
    return;
  }
  for (var i = 0, len = this.getChildCount(); i < len; i++) {
    var child =   (
        this.getChildAt(i));
    child.resize(width, height);
  }
  this.getElement().style.width = width * this.getChildCount() + 'px';
  goog.base(this, 'resize', width * this.getChildCount(), height);
};
ExtendedLayout.prototype.calculate_ = function() {
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    if (this.heightInWeight_ < child.getHeightInWeight()) {
      this.heightInWeight_ = child.getHeightInWeight();
    }
    this.widthInWeight_ = child.getWidthInWeight();
  }
};
ExtendedLayout.prototype.gotoPage = function(pageNum) {
  var width = goog.style.getSize(this.getElement()).width;
  var childNum = this.getChildCount();
  this.xPosition_ = 0 - width / childNum * pageNum;
  goog.style.transform.setTranslation(this.elem, this.xPosition_, 0);
};
ExtendedLayout.prototype.slide = function(deltaX) {
  this.elem.style.transition = '';
  this.xPosition_ += deltaX;
  goog.style.transform.setTranslation(this.elem, this.xPosition_, 0);
};
ExtendedLayout.prototype.adjustXPosition = function(opt_distance) {
  var childNum = this.getChildCount();
  var width = goog.style.getSize(this.elem).width / childNum;
  var absXPosition = Math.abs(this.xPosition_);
  var prev = Math.floor(absXPosition / width);
  var next = prev + 1;
  var pageNum = 0;
  if (opt_distance) {
    if (opt_distance >= 0) {
      pageNum = prev;
    } else {
      pageNum = next;
    }
  } else if (absXPosition - prev * width < next * width - absXPosition) {
    pageNum = prev;
  } else {
    pageNum = next;
  }
  if (pageNum < 0) {
    pageNum = 0;
  } else if (pageNum >= childNum) {
    pageNum = childNum - 1;
  }
  if (opt_distance) {
    this.elem.style.transition = 'transform ' +
        ExtendedLayout.BASE_TRANSITION_DURATION_ + 's';
  } else {
    var transitionDuration = Math.abs(absXPosition - pageNum * width) /
        ExtendedLayout.BASE_TRANSITION_DISTANCE_ *
        ExtendedLayout.BASE_TRANSITION_DURATION_;
    this.elem.style.transition = 'transform ' +
        transitionDuration + 's ease-in';
  }
  this.gotoPage(pageNum);
  return pageNum;
};
ExtendedLayout.prototype.updateCategory = function(pageNum) {
  this.elem.style.transition = '';
  this.gotoPage(pageNum);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.layout.LinearLayout
goog.provide('i18n.input.chrome.inputview.elements.layout.LinearLayout');
goog.scope(function() {
i18n.input.chrome.inputview.elements.layout.LinearLayout = function(id,
    opt_eventTarget, opt_iconCssClass) {
  goog.base(this, id, i18n.input.chrome.ElementType.
      LINEAR_LAYOUT, opt_eventTarget);
  this.iconCssClass = opt_iconCssClass ||
      i18n.input.chrome.inputview.Css.LINEAR_LAYOUT;
};
goog.inherits(i18n.input.chrome.inputview.elements.layout.LinearLayout,
    i18n.input.chrome.inputview.elements.Element);
var LinearLayout = i18n.input.chrome.inputview.elements.layout.LinearLayout;
LinearLayout.prototype.heightInWeight_ = 0;
LinearLayout.prototype.widthInWeight_ = 0;
LinearLayout.prototype.createDom = function() {
  goog.base(this, 'createDom');
  goog.dom.classlist.add(this.getElement(), this.iconCssClass);
  this.getElement()['view'] = null;
};
LinearLayout.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.calculate_();
};
LinearLayout.prototype.calculate_ = function() {
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    if (this.heightInWeight_ < child.getHeightInWeight()) {
      this.heightInWeight_ = child.getHeightInWeight();
    }
    this.widthInWeight_ += child.getWidthInWeight();
  }
};
LinearLayout.prototype.getHeightInWeight = function() {
  return this.heightInWeight_;
};
LinearLayout.prototype.getWidthInWeight = function() {
  return this.widthInWeight_;
};
LinearLayout.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  var elem = this.getElement();
  var borderBox = goog.style.getBorderBox(elem);
  var paddingBox = goog.style.getPaddingBox(elem);
  var marginBox = goog.style.getMarginBox(elem);
  var w = width - borderBox.left - borderBox.right - paddingBox.left -
      paddingBox.right - marginBox.left - marginBox.right;
  var weightArray = [];
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    weightArray.push(child.getWidthInWeight());
  }
  var splitedWidth = i18n.input.chrome.inputview.util.splitValue(weightArray,
      w);
  for (var i = 0; i < this.getChildCount(); i++) {
    var child =  (
        this.getChildAt(i));
    child.resize(splitedWidth[i], height);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.layout.HandwritingLayout
goog.provide('i18n.input.chrome.inputview.elements.layout.HandwritingLayout');
goog.scope(function() {
i18n.input.chrome.inputview.elements.layout.HandwritingLayout = function(id,
    opt_eventTarget) {
  goog.base(this, id, opt_eventTarget);
  this.type = i18n.input.chrome.ElementType.
      HANDWRITING_LAYOUT;
};
goog.inherits(i18n.input.chrome.inputview.elements.layout.HandwritingLayout,
    i18n.input.chrome.inputview.elements.layout.LinearLayout);
var HandwritingLayout =
    i18n.input.chrome.inputview.elements.layout.HandwritingLayout;
HandwritingLayout.prototype.createDom = function() {
  goog.base(this, 'createDom');
  goog.dom.classlist.add(this.getElement(), i18n.input.chrome.inputview.Css.
      HANDWRITING_LAYOUT);
};
HandwritingLayout.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.layout.SoftKeyView
goog.provide('i18n.input.chrome.inputview.elements.layout.SoftKeyView');
goog.scope(function() {
i18n.input.chrome.inputview.elements.layout.SoftKeyView = function(id,
    opt_widthInWeight, opt_heightInWeight, opt_condition,
    opt_giveWeightTo, opt_eventTarget) {
  goog.base(this, id, i18n.input.chrome.ElementType.
      SOFT_KEY_VIEW, opt_eventTarget);
  this.widthInWeight = opt_widthInWeight || 1;
  this.heightInWeight = opt_heightInWeight || 1;
  this.condition = opt_condition || '';
  this.giveWeightTo = opt_giveWeightTo || '';
};
goog.inherits(i18n.input.chrome.inputview.elements.layout.SoftKeyView,
    i18n.input.chrome.inputview.elements.Element);
var SoftKeyView = i18n.input.chrome.inputview.elements.layout.SoftKeyView;
SoftKeyView.prototype.softKey;
SoftKeyView.prototype.dynamicaGrantedWeight = 0;
SoftKeyView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var elem = this.getElement();
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.SOFT_KEY_VIEW);
};
SoftKeyView.prototype.getWidthInWeight =
    function() {
  return this.isVisible() ? this.widthInWeight + this.dynamicaGrantedWeight : 0;
};
SoftKeyView.prototype.getHeightInWeight =
    function() {
  return this.isVisible() ? this.heightInWeight : 0;
};
SoftKeyView.prototype.resize = function(
    width, height) {
  goog.base(this, 'resize', width, height);
  var elem = this.getElement();
  elem.style.width = width + 'px';
  elem.style.height = height + 'px';
  if (this.softKey) {
    this.softKey.resize(width, height);
  }
};
SoftKeyView.prototype.bindSoftKey = function(
    softKey) {
  this.softKey = softKey;
  this.removeChildren(true);
  this.addChild(softKey, true);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.KeysetView
goog.provide('i18n.input.chrome.inputview.elements.content.KeysetView');
goog.scope(function() {
var ConditionName = i18n.input.chrome.inputview.ConditionName;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
var ElementType = i18n.input.chrome.ElementType;
var content = i18n.input.chrome.inputview.elements.content;
var layout = i18n.input.chrome.inputview.elements.layout;
var Css = i18n.input.chrome.inputview.Css;
var util = i18n.input.chrome.inputview.util;
var CompactKeyModel =
    i18n.input.chrome.inputview.elements.content.CompactKeyModel;
i18n.input.chrome.inputview.elements.content.KeysetView = function(keyData,
    layoutData, keyboardCode, languageCode, model, name, opt_eventTarget,
    opt_adapter) {
  goog.base(this);
  this.setParentEventTarget(opt_eventTarget || null);
  this.keyData_ = keyData;
  this.layoutData_ = layoutData;
  this.keyboardCode_ = keyboardCode;
  this.languageCode = languageCode;
  this.dataModel_ = model;
  this.rows_ = [];
  this.softKeyViewMap_ = {};
  this.softKeyConditionMap_ = {};
  this.title_ = name;
  this.adapter = opt_adapter || null;
  this.conditions_ = {};
  this.disableCandidateView =
      goog.isDef(this.layoutData_['disableCandidateView']) ?
      this.layoutData_['disableCandidateView'] : false;
  this.childMap_ = {};
};
var KeysetView = i18n.input.chrome.inputview.elements.content.KeysetView;
goog.inherits(KeysetView, goog.ui.Container);
KeysetView.prototype.hasShift = true;
KeysetView.prototype.keyboardView_;
KeysetView.prototype.fromKeyset = '';
KeysetView.prototype.canvasView;
KeysetView.prototype.spaceKey;
KeysetView.prototype.backspaceKey;
KeysetView.prototype.outerHeight = 0;
KeysetView.prototype.outerWidth = 0;
KeysetView.prototype.widthPercent_ = 1;
KeysetView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  this.hasShift = !this.keyData_[SpecNodeName.NO_SHIFT];
  var elem = this.getElement();
  elem.id = this.keyboardCode_.replace(/\./g, '-');
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.VIEW);
  var children = this.layoutData_['children'];
  for (var i = 0; i < children.length; i++) {
    var child = children[i];
    var layoutElem = 
        (this.createLayoutElement_(child[i18n.input.chrome.inputview.
            SpecNodeName.SPEC], this));
    if (layoutElem) {
      layoutElem.render(elem);
      this.rows_.push(layoutElem);
    }
  }
  var softKeyList = [];
  var keySpecs = this.keyData_[SpecNodeName.KEY_LIST];
  var hasAltGrCharacterInTheKeyset = this.hasAltGrCharacterInTheKeyset_(
      keySpecs);
  for (var i = 0; i < keySpecs.length; i++) {
    var softKey = this.createKey_(keySpecs[i][SpecNodeName.SPEC],
        hasAltGrCharacterInTheKeyset);
    if (softKey) {
      softKeyList.push(softKey);
    }
  }
  var mapping = this.keyData_[
      SpecNodeName.MAPPING];
  this.keyboardView_.setUp(softKeyList, this.softKeyViewMap_, mapping);
};
KeysetView.prototype.getKeyboardLayoutForGesture = function() {
  var softKeyViewMap = this.softKeyViewMap_;
  var softKeyViews = [];
  for (var key in softKeyViewMap) {
    var skv = softKeyViewMap[key];
    if (skv.softKey && skv.softKey.type == ElementType.COMPACT_KEY &&
        this.isCharacter_(skv.softKey.text)) {
      softKeyViews.push(skv);
    }
  }
  if (softKeyViews.length == 0) {
    return null;
  }
  var ret = {};
  var softKeyView = softKeyViews[0];
  var common_width = softKeyView.softKey.getElement().clientWidth;
  var common_height = softKeyView.softKey.getElement().clientHeight;
  ret['most_common_key_width'] = common_width;
  ret['most_common_key_height'] = common_height;
  var keys = [];
  for (var i = 0; i < softKeyViews.length; i++) {
    softKeyView = softKeyViews[i];
    var codepoint = softKeyView.softKey.text.toLowerCase().charCodeAt(0);
    var width = softKeyView.softKey.getElement().clientWidth;
    var height = softKeyView.softKey.getElement().clientHeight;
    var rect = softKeyView.softKey.getElement().getBoundingClientRect();
    var x = rect.left + (width / 2.0);
    var y = rect.top + (height / 2.0);
    keys.push({
      'codepoint': codepoint,
      'width': width,
      'height': height,
      'x': x,
      'y': y
    });
  }
  ret['keys'] = keys;
  ret['keyboard_width'] = this.getElement().clientWidth;
  ret['keyboard_height'] = window.innerHeight;
  return ret;
};
KeysetView.prototype.update = function() {
  this.keyboardView_.update();
};
KeysetView.prototype.shouldResize = function(outerWidth, outerHeight,
    widthPercent, force) {
  var needResize = force || (this.outerHeight != outerHeight ||
      this.outerWidth != outerWidth || this.widthPercent_ != widthPercent);
  return !!this.getElement() && needResize;
};
KeysetView.prototype.resize = function(outerWidth, outerHeight, widthPercent,
    opt_force) {
  if (this.shouldResize(outerWidth, outerHeight, widthPercent, !!opt_force)) {
    this.outerHeight = outerHeight;
    this.outerWidth = outerWidth;
    this.widthPercent_ = widthPercent;
    var elem = this.getElement();
    var margin = Math.round((outerWidth - outerWidth * widthPercent) / 2);
    var w = outerWidth - 2 * margin - 2;
    elem.style.marginLeft = elem.style.marginRight = margin + 'px';
    goog.style.setSize(elem, w, outerHeight);
    this.resizeRows(w, outerHeight);
  }
};
KeysetView.prototype.resizeRows = function(width, height) {
  var weightArray = [];
  for (var i = 0; i < this.rows_.length; i++) {
    var row = this.rows_[i];
    weightArray.push(row.getHeightInWeight());
  }
  var splitedHeight = i18n.input.chrome.inputview.util.splitValue(weightArray,
      height);
  for (var i = 0; i < this.rows_.length; i++) {
    var row = this.rows_[i];
    row.resize(width, splitedHeight[i]);
  }
};
KeysetView.prototype.getHeightInWeight = function() {
  var heightInWeight = 0;
  for (var i = 0; i < this.rows_.length; i++) {
    var row = this.rows_[i];
    heightInWeight += row.getHeightInWeight();
  }
  return heightInWeight;
};
KeysetView.prototype.applyConditions = function(conditions) {
  this.conditions_ = conditions;
  for (var condition in conditions) {
    var softKeyView = this.softKeyConditionMap_[condition];
    var isConditionEnabled = conditions[condition];
    if (softKeyView) {
      softKeyView.setVisible(isConditionEnabled);
      var softKeyViewGetWeight = this.softKeyViewMap_[softKeyView.
          giveWeightTo];
      if (softKeyViewGetWeight) {
        softKeyViewGetWeight.dynamicaGrantedWeight += isConditionEnabled ?
            0 : softKeyView.widthInWeight;
      }
    }
  }
  var showGlobeKey = conditions[ConditionName.SHOW_GLOBE_OR_SYMBOL];
  var showMenuKey = conditions[ConditionName.SHOW_MENU];
  var menuKeyView = this.softKeyConditionMap_[ConditionName.SHOW_MENU];
  var globeKeyView =
      this.softKeyConditionMap_[ConditionName.SHOW_GLOBE_OR_SYMBOL];
  if (menuKeyView && globeKeyView) {
    var softKeyViewGetWeight =
        this.softKeyViewMap_[menuKeyView.giveWeightTo];
    if (softKeyViewGetWeight) {
      if (showGlobeKey && showMenuKey) {
        globeKeyView.dynamicaGrantedWeight = -0.1;
        menuKeyView.dynamicaGrantedWeight = -0.4;
        softKeyViewGetWeight.dynamicaGrantedWeight += 0.5;
      }
    }
  }
};
KeysetView.prototype.updateCondition = function(name, value) {
  if (this.conditions_[name] === value) {
    return;
  }
  for (var id in this.softKeyViewMap_) {
    var skv = this.softKeyViewMap_[id];
    skv.dynamicaGrantedWeight = 0;
  }
  this.conditions_[name] = value;
  this.applyConditions(this.conditions_);
  this.resize(this.outerWidth, this.outerHeight, this.widthPercent_, true);
  this.update();
};
KeysetView.prototype.isCharacter_ = function(c) {
  return c.length === 1 && c.match(/^[a-z]$/i) != null;
};
KeysetView.prototype.createElement_ = function(spec, opt_eventTarget) {
  var type = spec[SpecNodeName.TYPE];
  var id = spec[SpecNodeName.ID];
  var widthInWeight = spec[
      SpecNodeName.WIDTH_IN_WEIGHT];
  var heightInWeight = spec[
      SpecNodeName.HEIGHT_IN_WEIGHT];
  var elem = null;
  switch (type) {
    case ElementType.SOFT_KEY_VIEW:
      var condition = spec[SpecNodeName.CONDITION];
      var giveWeightTo = spec[SpecNodeName.GIVE_WEIGHT_TO];
      elem = new layout.SoftKeyView(id, widthInWeight,
          heightInWeight, condition, giveWeightTo, opt_eventTarget);
      this.softKeyConditionMap_[condition] = elem;
      break;
    case ElementType.LINEAR_LAYOUT:
      var opt_iconCssClass = spec[SpecNodeName.ICON_CSS_CLASS];
      elem = new layout.LinearLayout(id, opt_eventTarget, opt_iconCssClass);
      break;
    case ElementType.EXTENDED_LAYOUT:
      elem = new layout.ExtendedLayout(id, opt_eventTarget);
      break;
    case ElementType.VERTICAL_LAYOUT:
      elem = new layout.VerticalLayout(id, opt_eventTarget);
      break;
    case ElementType.LAYOUT_VIEW:
      this.keyboardView_ = new content.KeyboardView(id, opt_eventTarget);
      elem = this.keyboardView_;
      break;
    case ElementType.CANVAS_VIEW:
      this.canvasView = new content.CanvasView(id, widthInWeight,
          heightInWeight, opt_eventTarget, this.adapter);
      elem = this.canvasView;
      break;
    case ElementType.HANDWRITING_LAYOUT:
      elem = new layout.HandwritingLayout(id, opt_eventTarget);
      break;
  }
  if (elem) {
    this.childMap_[id] = elem;
  }
  return elem;
};
KeysetView.prototype.createLayoutElement_ = function(spec,
    opt_parentEventTarget) {
  var element = this.createElement_(spec, opt_parentEventTarget);
  if (!element) {
    return null;
  }
  var children = spec[SpecNodeName.CHILDREN];
  if (children) {
    children = goog.array.flatten(children);
    for (var i = 0; i < children.length; i++) {
      var child = children[i];
      var childElem = this.createLayoutElement_(
          child[SpecNodeName.SPEC], element);
      if (childElem) {
        element.addChild(childElem, true);
      }
    }
  }
  if (element.type == ElementType.SOFT_KEY_VIEW) {
    this.softKeyViewMap_[element.id] =
         (element);
  }
  return element;
};
KeysetView.prototype.hasAltGrCharacterInTheKeyset_ = function(keySpecs) {
  var result = [false, false];
  for (var i = 0; i < keySpecs.length; i++) {
    var spec = keySpecs[i];
    var characters = spec[SpecNodeName.CHARACTERS];
    if (characters && (!!characters[2] || !!characters[3])) {
      var index = i18n.input.chrome.inputview.util.isLetterKey(
          characters) ? 0 : 1;
      result[index] = true;
    }
  }
  return result;
};
KeysetView.prototype.createKey_ = function(spec, hasAltGrCharacterInTheKeyset) {
  var type = spec[SpecNodeName.TYPE];
  var id = spec[SpecNodeName.ID];
  var keyCode = spec[SpecNodeName.KEY_CODE]; // Could be undefined.
  var name = spec[SpecNodeName.NAME];
  var characters = spec[SpecNodeName.CHARACTERS];
  var iconCssClass = spec[SpecNodeName.ICON_CSS_CLASS];
  var textCssClass = spec[SpecNodeName.TEXT_CSS_CLASS];
  var toKeyset = spec[SpecNodeName.TO_KEYSET];
  var toKeysetName = spec[SpecNodeName.TO_KEYSET_NAME];
  var elem = null;
  switch (type) {
    case ElementType.MODIFIER_KEY:
      var toState = spec[SpecNodeName.TO_STATE];
      var supportSticky = spec[SpecNodeName.SUPPORT_STICKY];
      elem = new content.ModifierKey(id, name, iconCssClass, toState,
          this.dataModel_.stateManager, supportSticky);
      break;
    case ElementType.SPACE_KEY:
      this.spaceKey = new content.SpaceKey(id,
          this.dataModel_.stateManager, this.title_, characters,
          undefined, iconCssClass, toKeyset);
      elem = this.spaceKey;
      break;
    case ElementType.EN_SWITCHER:
      elem = new content.EnSwitcherKey(id, type, name, iconCssClass,
          this.dataModel_.stateManager, Css.EN_SWITCHER_DEFAULT,
          Css.EN_SWITCHER_ENGLISH);
      break;
    case ElementType.BACKSPACE_KEY:
      elem = new content.BackspaceKey(id, type, name, iconCssClass);
      this.backspaceKey = elem;
      break;
    case ElementType.ENTER_KEY:
      elem = new content.EnterKey(id, iconCssClass);
      break;
    case ElementType.TAB_KEY:
    case ElementType.ARROW_UP:
    case ElementType.ARROW_DOWN:
    case ElementType.ARROW_LEFT:
    case ElementType.ARROW_RIGHT:
    case ElementType.HIDE_KEYBOARD_KEY:
    case ElementType.GLOBE_KEY:
    case ElementType.BACK_TO_KEYBOARD:
    case ElementType.HOTROD_SWITCHER_KEY:
      elem = new content.FunctionalKey(id, type, name, iconCssClass);
      break;
    case ElementType.TAB_BAR_KEY:
      elem = new content.TabBarKey(id, type, name, iconCssClass,
          toKeyset, this.dataModel_.stateManager);
      break;
    case ElementType.EMOJI_KEY:
      var text = spec[SpecNodeName.TEXT];
      var isEmoticon = spec[SpecNodeName.IS_EMOTICON];
      elem = new content.EmojiKey(id, type, text, isEmoticon);
      break;
    case ElementType.PAGE_INDICATOR:
      elem = new content.PageIndicator(id, type);
      break;
    case ElementType.IME_SWITCH:
      elem = new content.FunctionalKey(id, type, name, iconCssClass, undefined,
          textCssClass);
      break;
    case ElementType.MENU_KEY:
      elem = new content.MenuKey(id, type, name, iconCssClass, toKeyset);
      break;
    case ElementType.SWITCHER_KEY:
      var record = spec[SpecNodeName.RECORD];
      elem = new content.SwitcherKey(id, type, name, iconCssClass, toKeyset,
          toKeysetName, record);
      break;
    case ElementType.COMPACT_KEY:
      var hintText = spec[SpecNodeName.HINT_TEXT];
      var text = spec[SpecNodeName.TEXT];
      var marginLeftPercent = spec[SpecNodeName.MARGIN_LEFT_PERCENT];
      var marginRightPercent = spec[SpecNodeName.MARGIN_RIGHT_PERCENT];
      var isGrey = spec[SpecNodeName.IS_GREY];
      var moreKeys = spec[SpecNodeName.MORE_KEYS];
      var moreKeysCharacters =
          moreKeys ? moreKeys[SpecNodeName.CHARACTERS] : undefined;
      var fixedColumns =
          moreKeys ? moreKeys[SpecNodeName.FIXED_COLUMN_NUMBER] : undefined;
      var contextMap = spec[SpecNodeName.ON_CONTEXT];
      var title = spec[SpecNodeName.TITLE];
      var onShift = spec[SpecNodeName.ON_SHIFT];
      var moreKeysShiftType = spec[SpecNodeName.MORE_KEYS_SHIFT_OPERATION];
      var compactKeyModel = new CompactKeyModel(marginLeftPercent,
          marginRightPercent, isGrey, moreKeysCharacters, moreKeysShiftType,
          onShift, contextMap, textCssClass, title, fixedColumns);
      elem = new content.CompactKey(
          id, text, hintText, this.dataModel_.stateManager, this.hasShift,
          compactKeyModel, undefined);
      break;
    case ElementType.CHARACTER_KEY:
      if (characters.length == 1) {
        characters.push(characters[0]);
      }
      var isLetterKey = i18n.input.chrome.inputview.util.isLetterKey(
          characters);
      var enableShiftRendering = !!spec[SpecNodeName.ENABLE_SHIFT_RENDERING];
      elem = new content.CharacterKey(id, keyCode || 0,
          characters, isLetterKey,
          hasAltGrCharacterInTheKeyset[isLetterKey ? 1 : 0],
          this.dataModel_.settings.alwaysRenderAltGrCharacter,
          this.dataModel_.stateManager,
          goog.i18n.bidi.isRtlLanguage(this.languageCode),
          enableShiftRendering);
      break;
    case ElementType.BACK_BUTTON:
      elem = new content.CandidateButton(
          id, ElementType.BACK_BUTTON, iconCssClass,
          chrome.i18n.getMessage('HANDWRITING_BACK'), this);
      break;
  }
  if (elem) {
    this.childMap_[id] = elem;
  }
  return elem;
};
KeysetView.prototype.getViewForKey = function(code) {
  return this.keyboardView_.getViewForKey(code);
};
KeysetView.prototype.getWidthInWeight = function() {
  if (this.rows_.length > 0) {
    return this.rows_[0].getWidthInWeight();
  }
  return 0;
};
KeysetView.prototype.hasStrokesOnCanvas = function() {
  if (this.canvasView) {
    return this.canvasView.hasStrokesOnCanvas();
  } else {
    return false;
  }
};
KeysetView.prototype.cleanStroke = function() {
  if (this.canvasView) {
    this.canvasView.reset();
  }
};
KeysetView.prototype.isHandwriting = function() {
  return this.keyboardCode_ == 'hwt';
};
KeysetView.prototype.getChildViewById = function(id) {
  return this.childMap_[id];
};
KeysetView.prototype.activate = function(rawKeyset) {
  var haveEnSwitcher =
      goog.array.contains(util.KEYSETS_HAVE_EN_SWTICHER, rawKeyset);
  this.updateCondition(ConditionName.SHOW_EN_SWITCHER_KEY, haveEnSwitcher);
  if (haveEnSwitcher) {
    goog.dom.classlist.add(this.getElement(), Css.PINYIN);
  } else {
    goog.dom.classlist.remove(this.getElement(), Css.PINYIN);
  }
};
KeysetView.prototype.deactivate = goog.nullFunction;
});  // goog.scope

// i18n.input.chrome.inputview.handler.SwipeState
goog.provide('i18n.input.chrome.inputview.handler.SwipeState');
i18n.input.chrome.inputview.handler.SwipeState = function() {
  this.offsetX = 0;
  this.offsetY = 0;
  this.previousX = 0;
  this.previousY = 0;
};
i18n.input.chrome.inputview.handler.SwipeState.prototype.reset =
    function() {
  this.offsetX = this.offsetY = this.previousX = this.previousY = 0;
};

// i18n.input.chrome.inputview.handler.PointerActionBundle
goog.provide('i18n.input.chrome.inputview.handler.PointerActionBundle');
goog.scope(function() {
i18n.input.chrome.inputview.handler.PointerActionBundle = function(view,
    opt_parentEventTarget) {
  goog.base(this);
  this.setParentEventTarget(opt_parentEventTarget || null);
  this.view = view;
  this.swipeState_ = new i18n.input.chrome.inputview.handler.SwipeState();
};
goog.inherits(i18n.input.chrome.inputview.handler.PointerActionBundle,
    goog.events.EventTarget);
var PointerActionBundle = i18n.input.chrome.inputview.handler.
    PointerActionBundle;
var Util = i18n.input.chrome.inputview.handler.Util;
PointerActionBundle.prototype.currentTarget_;
PointerActionBundle.DOUBLE_CLICK_INTERVAL_ = 500;
PointerActionBundle.prototype.longPressTimer_;
PointerActionBundle.MINIMUM_SWIPE_DISTANCE_ = 20;
PointerActionBundle.prototype.pointerDownTimeStamp_ = 0;
PointerActionBundle.prototype.pointerUpTimeStamp_ = 0;
PointerActionBundle.prototype.isDBLClicking_ = false;
PointerActionBundle.prototype.isLongPressing_ = false;
PointerActionBundle.prototype.isFlickering_ = false;
PointerActionBundle.prototype.handlePointerMove = function(e) {
  var identifier = Util.getEventIdentifier(e);
  var direction = 0;
  var deltaX = this.swipeState_.previousX == 0 ? 0 : (e.pageX -
      this.swipeState_.previousX);
  var deltaY = this.swipeState_.previousY == 0 ? 0 :
      (e.pageY - this.swipeState_.previousY);
  this.swipeState_.offsetX += deltaX;
  this.swipeState_.offsetY += deltaY;
  this.dispatchEvent(new i18n.input.chrome.inputview.events.DragEvent(
      this.view, direction,  (e.target),
      e.pageX, e.pageY, deltaX, deltaY, identifier));
  var minimumSwipeDist = PointerActionBundle.
      MINIMUM_SWIPE_DISTANCE_;
  if (this.swipeState_.offsetX > minimumSwipeDist) {
    direction |= i18n.input.chrome.inputview.SwipeDirection.RIGHT;
    this.swipeState_.offsetX = 0;
  } else if (this.swipeState_.offsetX < -minimumSwipeDist) {
    direction |= i18n.input.chrome.inputview.SwipeDirection.LEFT;
    this.swipeState_.offsetX = 0;
  }
  if (Math.abs(deltaY) > Math.abs(deltaX)) {
    if (this.swipeState_.offsetY > minimumSwipeDist) {
      direction |= i18n.input.chrome.inputview.SwipeDirection.DOWN;
      this.swipeState_.offsetY = 0;
    } else if (this.swipeState_.offsetY < -minimumSwipeDist) {
      direction |= i18n.input.chrome.inputview.SwipeDirection.UP;
      this.swipeState_.offsetY = 0;
    }
  }
  this.swipeState_.previousX = e.pageX;
  this.swipeState_.previousY = e.pageY;
  if (direction > 0) {
    goog.Timer.clear(this.longPressTimer_);
    this.dispatchEvent(new i18n.input.chrome.inputview.events.SwipeEvent(
        this.view, direction,  (e.target),
        e.pageX, e.pageY, identifier));
    var currentTargetView = Util.getView(this.currentTarget_);
    this.isFlickering_ = !this.isLongPressing_ && !!(this.view.pointerConfig.
        flickerDirection & direction) && currentTargetView == this.view;
  }
  this.maybeSwitchTarget_(
      new goog.math.Coordinate(e.pageX, e.pageY), identifier);
};
PointerActionBundle.prototype.maybeSwitchTarget_ = function(pageOffset,
    identifier) {
  if (!this.isFlickering_) {
    var actualTarget = document.elementFromPoint(pageOffset.x, pageOffset.y);
    var currentTargetView = Util.getView(this.currentTarget_);
    var actualTargetView = Util.getView(actualTarget);
    if (currentTargetView != actualTargetView) {
      if (currentTargetView) {
        this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
            currentTargetView,
            i18n.input.chrome.inputview.events.EventType.POINTER_OUT,
            this.currentTarget_, pageOffset.x, pageOffset.y, identifier));
      }
      if (actualTargetView) {
        this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
            actualTargetView,
            i18n.input.chrome.inputview.events.EventType.POINTER_OVER,
            actualTarget, pageOffset.x, pageOffset.y, identifier));
      }
      this.currentTarget_ = actualTarget;
    }
  }
};
PointerActionBundle.prototype.handlePointerUp = function(e) {
  goog.Timer.clear(this.longPressTimer_);
  var pageOffset = this.getPageOffset_(e);
  var identifier = Util.getEventIdentifier(e);
  this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
      this.view, i18n.input.chrome.inputview.events.EventType.LONG_PRESS_END,
      e.target, pageOffset.x, pageOffset.y, identifier));
  if (this.isDBLClicking_) {
    this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
        this.view, i18n.input.chrome.inputview.events.EventType.
        DOUBLE_CLICK_END, e.target, pageOffset.x, pageOffset.y, identifier));
  } else if (!(this.isLongPressing_ && this.view.pointerConfig.
      longPressWithoutPointerUp)) {
    this.maybeSwitchTarget_(pageOffset, identifier);
    var view = Util.getView(this.currentTarget_);
    var target = this.currentTarget_;
    if (this.isFlickering_) {
      view = this.view;
      target = e.target;
    }
    this.pointerUpTimeStamp_ = new Date().getTime();
    this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
        view, i18n.input.chrome.inputview.events.EventType.POINTER_UP,
        target, pageOffset.x, pageOffset.y, identifier,
        this.pointerUpTimeStamp_));
  }
  if (Util.getView(this.currentTarget_) == this.view) {
    this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
        this.view, i18n.input.chrome.inputview.events.EventType.CLICK,
        e.target, pageOffset.x, pageOffset.y, identifier));
  }
  this.isDBLClicking_ = false;
  this.isLongPressing_ = false;
  this.isFlickering_ = false;
  this.swipeState_.reset();
};
PointerActionBundle.prototype.cancelDoubleClick = function() {
  this.pointerDownTimeStamp_ = 0;
};
PointerActionBundle.prototype.handlePointerDown = function(e) {
  this.currentTarget_ = e.target;
  goog.Timer.clear(this.longPressTimer_);
  var identifier = Util.getEventIdentifier(e);
  if (e.type == goog.events.EventType.TOUCHSTART) {
    this.maybeTriggerKeyDownLongPress_(e, identifier);
  }
  this.maybeHandleDBLClick_(e, identifier);
  if (!this.isDBLClicking_) {
    var pageOffset = this.getPageOffset_(e);
    this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
        this.view, i18n.input.chrome.inputview.events.EventType.POINTER_DOWN,
        e.target, pageOffset.x, pageOffset.y, identifier,
        this.pointerDownTimeStamp_));
  }
};
PointerActionBundle.prototype.getPageOffset_ = function(e) {
  var nativeEvt = e.getBrowserEvent();
  if (nativeEvt.pageX && nativeEvt.pageY) {
    return new goog.math.Coordinate(nativeEvt.pageX, nativeEvt.pageY);
  }
  var touchEventList = nativeEvt['changedTouches'];
  if (!touchEventList || touchEventList.length == 0) {
    touchEventList = nativeEvt['touches'];
  }
  if (touchEventList && touchEventList.length > 0) {
    var touchEvent = touchEventList[0];
    return new goog.math.Coordinate(touchEvent.pageX, touchEvent.pageY);
  }
  return new goog.math.Coordinate(0, 0);
};
PointerActionBundle.prototype.maybeTriggerKeyDownLongPress_ = function(e,
    identifier) {
  if (this.view && (this.view.pointerConfig.longPressWithPointerUp ||
      this.view.pointerConfig.longPressWithoutPointerUp)) {
    this.longPressTimer_ = goog.Timer.callOnce(
        goog.bind(this.triggerLongPress_, this, e, identifier),
        this.view.pointerConfig.longPressDelay, this);
  }
};
PointerActionBundle.prototype.maybeHandleDBLClick_ = function(e, identifier) {
  if (this.view && this.view.pointerConfig.dblClick) {
    var timeInMs = new Date().getTime();
    var interval = this.view.pointerConfig.dblClickDelay ||
        PointerActionBundle.DOUBLE_CLICK_INTERVAL_;
    var nativeEvt = e.getBrowserEvent();
    if ((timeInMs - this.pointerDownTimeStamp_) < interval) {
      this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
          this.view, i18n.input.chrome.inputview.events.EventType.DOUBLE_CLICK,
          e.target, nativeEvt.pageX, nativeEvt.pageY, identifier));
      this.isDBLClicking_ = true;
    }
    this.pointerDownTimeStamp_ = timeInMs;
  }
};
PointerActionBundle.prototype.triggerLongPress_ = function(e, identifier) {
  var nativeEvt = e.getBrowserEvent();
  if (nativeEvt.touches.length > 1) {
    return;
  }
  this.dispatchEvent(new i18n.input.chrome.inputview.events.PointerEvent(
      this.view, i18n.input.chrome.inputview.events.EventType.LONG_PRESS,
      e.target, nativeEvt.pageX, nativeEvt.pageY, identifier));
  this.isLongPressing_ = true;
};
PointerActionBundle.prototype.disposeInternal = function() {
  goog.dispose(this.longPressTimer_);
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.inputview.handler.PointerHandler
goog.provide('i18n.input.chrome.inputview.handler.PointerHandler');
goog.scope(function() {
i18n.input.chrome.inputview.handler.PointerHandler = function(opt_target) {
  goog.base(this);
  this.pointerActionBundles_ = {};
  this.eventHandler_ = new goog.events.EventHandler(this);
  var target = opt_target || document;
  this.eventHandler_.
      listen(target, [goog.events.EventType.MOUSEDOWN,
          goog.events.EventType.TOUCHSTART], this.onPointerDown_, true).
      listen(document, goog.events.EventType.TOUCHEND, this.onPointerUp_, true).
      listen(document, goog.events.EventType.MOUSEUP, this.onPointerUp_, true).
      listen(target, [goog.events.EventType.TOUCHMOVE,
          goog.events.EventType.MOUSEMOVE], this.onPointerMove_,
          true);
};
goog.inherits(i18n.input.chrome.inputview.handler.PointerHandler,
    goog.events.EventTarget);
var PointerHandler = i18n.input.chrome.inputview.handler.PointerHandler;
var PointerActionBundle =
    i18n.input.chrome.inputview.handler.PointerActionBundle;
var Util = i18n.input.chrome.inputview.handler.Util;
PointerHandler.CANVAS_CLASS_NAME_ = 'ita-hwt-canvas';
PointerHandler.prototype.mouseDownTick_ = null;
PointerHandler.prototype.previousPointerActionBundle_ = null;
PointerHandler.prototype.pointerActionBundleForMouseDown_ = null;
PointerHandler.prototype.getPointerActionBundle_ = function(view) {
  var uid = goog.getUid(view);
  if (!this.pointerActionBundles_[uid]) {
    this.pointerActionBundles_[uid] = new i18n.input.chrome.inputview.handler.
        PointerActionBundle(view, this);
  }
  return this.pointerActionBundles_[uid];
};
PointerHandler.prototype.onPointerDown_ = function(e) {
  var view = Util.getView( (e.target));
  if (!view) {
    return;
  }
  var pointerActionBundle = this.getPointerActionBundle_(view);
  if (this.previousPointerActionBundle_ &&
      this.previousPointerActionBundle_ != pointerActionBundle) {
    this.previousPointerActionBundle_.cancelDoubleClick();
  }
  this.previousPointerActionBundle_ = pointerActionBundle;
  pointerActionBundle.handlePointerDown(e);
  if (view.pointerConfig.preventDefault) {
    e.preventDefault();
  }
  if (view.pointerConfig.stopEventPropagation) {
    e.stopPropagation();
  }
  if (e.type == goog.events.EventType.MOUSEDOWN) {
    this.mouseDownTick_ = new Date();
    this.pointerActionBundleForMouseDown_ = pointerActionBundle;
  }
};
PointerHandler.prototype.onPointerUp_ = function(e) {
  var pointerActionBundle;
  if (e.type == goog.events.EventType.MOUSEUP) {
    if (this.mouseDownTick_ && new Date() - this.mouseDownTick_ < 10) {
      goog.Timer.callOnce(this.onPointerUp_.bind(this, e), 50);
      return;
    }
    if (this.pointerActionBundleForMouseDown_) {
      this.pointerActionBundleForMouseDown_.handlePointerUp(e);
      pointerActionBundle = this.pointerActionBundleForMouseDown_;
      this.pointerActionBundleForMouseDown_ = null;
    }
  } else {
    var view = Util.getView( (e.target));
    if (!view) {
      return;
    }
    pointerActionBundle = this.pointerActionBundles_[goog.getUid(view)];
    if (pointerActionBundle) {
      pointerActionBundle.handlePointerUp(e);
    }
    e.preventDefault();
  }
  if (pointerActionBundle && pointerActionBundle.view &&
      pointerActionBundle.view.pointerConfig.stopEventPropagation) {
    e.stopPropagation();
  }
};
PointerHandler.prototype.onPointerMove_ = function(e) {
  if (e.type == goog.events.EventType.MOUSEMOVE) {
    if (this.pointerActionBundleForMouseDown_) {
      this.pointerActionBundleForMouseDown_.handlePointerMove(
           (e.getBrowserEvent()));
    }
    return;
  }
  var touches = e.getBrowserEvent()['touches'];
  if (!touches || touches.length == 0) {
    return;
  }
  if (touches.length > 1) {
    e.preventDefault();
  }
  var shouldPreventDefault = false;
  var shouldStopEventPropagation = false;
  for (var i = 0; i < touches.length; i++) {
    var view = Util.getView( (touches[i].target));
    if (view) {
      var pointerActionBundle = this.pointerActionBundles_[goog.getUid(view)];
      if (pointerActionBundle) {
        pointerActionBundle.handlePointerMove(touches[i]);
      }
      if (view.pointerConfig.preventDefault) {
        shouldPreventDefault = true;
      }
      if (view.pointerConfig.stopEventPropagation) {
        shouldStopEventPropagation = true;
      }
    }
  }
  if (shouldPreventDefault) {
    e.preventDefault();
  }
  if (shouldStopEventPropagation) {
    e.stopPropagation();
  }
};
PointerHandler.prototype.disposeInternal = function() {
  for (var bundle in this.pointerActionBundles_) {
    goog.dispose(bundle);
  }
  goog.dispose(this.eventHandler_);
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.EmojiView
goog.provide('i18n.input.chrome.inputview.elements.content.EmojiView');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
var EventType = i18n.input.chrome.inputview.events.EventType;
var KeysetView = i18n.input.chrome.inputview.elements.content.KeysetView;
var PointerHandler = i18n.input.chrome.inputview.handler.PointerHandler;
var Css = i18n.input.chrome.inputview.Css;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
var PageIndicator = i18n.input.chrome.inputview.elements.content.PageIndicator;
i18n.input.chrome.inputview.elements.content.EmojiView = function(keyData,
    layoutData, keyboardCode, languageCode, model, name, opt_eventTarget,
    opt_adapter) {
  i18n.input.chrome.inputview.elements.content.EmojiView.base(this,
      'constructor', keyData, layoutData, keyboardCode, languageCode, model,
      name, opt_eventTarget, opt_adapter);
  this.keysPerPage_ = 27;
  this.totalTabbars_ = keyData[SpecNodeName.TEXT].length;
  this.pageOffsets_ = [];
  this.pagesInCategory_ = [];
  var pageNum = 0;
  for (var i = 0, len = keyData[SpecNodeName.TEXT].length; i < len; ++i) {
    this.pageOffsets_.push(pageNum);
    pageNum += Math.ceil(
        keyData[SpecNodeName.TEXT][i].length / this.keysPerPage_);
  }
  this.pageToCategory_ = [];
  for (var i = 0, len = keyData[SpecNodeName.TEXT].length; i < len; ++i) {
    var lenJ = Math.ceil(
        keyData[SpecNodeName.TEXT][i].length / this.keysPerPage_);
    for (var j = 0; j < lenJ; ++j) {
      this.pageToCategory_.push(i);
    }
    this.pagesInCategory_.push(lenJ);
  }
  this.recentEmojiList_ = [];
  this.recentEmojiKeys_ = [];
  this.tabbarKeys_ = [];
};
var EmojiView = i18n.input.chrome.inputview.elements.content.EmojiView;
goog.inherits(EmojiView, KeysetView);
EmojiView.prototype.emojiRows_;
EmojiView.prototype.emojiSlider_;
EmojiView.prototype.pageIndicator_;
EmojiView.prototype.isDragging = false;
EmojiView.prototype.emojiWidthPercent_ = 1;
EmojiView.prototype.categoryID_ = 0;
EmojiView.prototype.pointerDownTimeStamp_ = 0;
EmojiView.prototype.dragDistance_ = 0;
EmojiView.EMOJI_DRAG_INTERVAL_ = 300;
EmojiView.EMOJI_DRAG_SCROLL_DISTANCE_ = 60;
EmojiView.EMOJI_DRAG_START_DISTANCE_ = 10;
EmojiView.EMOJI_DEFAULT_CATEGORY_ID_ = 2;
EmojiView.prototype.pointerHandler_;
EmojiView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  this.pointerHandler_ = new PointerHandler();
  this.getHandler().
      listen(this.pointerHandler_, EventType.POINTER_DOWN,
      this.onPointerDown_).
      listen(this.pointerHandler_, EventType.POINTER_UP, this.onPointerUp_).
      listen(this.pointerHandler_, EventType.POINTER_OUT, this.onPointerOut_).
      listen(this.pointerHandler_, EventType.DRAG, this.onDragEvent_);
  this.emojiRows_ =
      (this.getChildViewById('emojiRows'));
  this.emojiSlider_ =
      (this.getChildViewById('emojiSlider'));
  for (var i = 0; i < this.keysPerPage_; i++) {
    this.recentEmojiKeys_.push(
        (this.getChildViewById('emojikey' + i)));
  }
  for (var i = 0; i < this.totalTabbars_; i++) {
    this.tabbarKeys_.push(
        (this.getChildViewById('Tabbar' + i)));
  }
  this.pageIndicator_ = new PageIndicator(
      'indicator-background', ElementType.PAGE_INDICATOR);
  this.pageIndicator_.render();
};
EmojiView.prototype.enterDocument = function() {
  this.pageIndicator_.setVisible(false);
};
EmojiView.prototype.resize = function(outerWidth, outerHeight, widthPercent,
    opt_force) {
  if (this.getElement() && (!!opt_force || this.outerHeight != outerHeight ||
      this.outerWidth != outerWidth ||
      this.emojiWidthPercent_ != widthPercent)) {
    this.outerHeight = outerHeight;
    this.outerWidth = outerWidth;
    goog.style.setSize(this.getElement(), outerWidth, outerHeight);
    this.emojiWidthPercent_ = widthPercent;
    var marginOrPadding = Math.round((outerWidth -
        outerWidth * widthPercent) / 2);
    var tabBar =  (
        this.getChildViewById('tabBar').getElement());
    tabBar.style.paddingLeft = tabBar.style.paddingRight =
        marginOrPadding + 'px';
    var rowsAndKeys =  (
        this.getChildViewById('rowsAndSideKeys').getElement());
    rowsAndKeys.style.marginLeft = rowsAndKeys.style.marginRight =
        marginOrPadding + 'px';
    var spaceRow =  (
        this.getChildViewById('emojiSpaceRow').getElement());
    spaceRow.style.marginLeft = spaceRow.style.marginRight =
        marginOrPadding + 'px';
    this.resizeRows(outerWidth, outerHeight);
  }
  this.repositionIndicator_();
  this.clearEmojiStates();
};
EmojiView.prototype.onPointerDown_ = function(e) {
  var view = e.view;
  if (!view) {
    return;
  }
  if (view.type == ElementType.EMOJI_KEY) {
    this.pointerDownTimeStamp_ = e.timestamp;
    this.dragDistance_ = 0;
    view.setHighlighted(true);
  } else if (view.type == ElementType.PAGE_INDICATOR) {
    this.dragDistance_ = 0;
  }
};
EmojiView.prototype.onDragEnd_ = function(timestamp) {
  var interval = timestamp - this.pointerDownTimeStamp_;
  if (interval < EmojiView.EMOJI_DRAG_INTERVAL_ &&
      Math.abs(this.dragDistance_) >=
      EmojiView.EMOJI_DRAG_SCROLL_DISTANCE_) {
    this.adjustXPosition_(this.dragDistance_);
  } else {
    this.adjustXPosition_();
  }
};
EmojiView.prototype.onPointerOut_ = function(e) {
  if (e.view && e.view.type == ElementType.EMOJI_KEY) {
    e.view.setHighlighted(false);
  }
};
EmojiView.prototype.onPointerUp_ = function(e) {
  var view = e.view;
  if (!view) {
    this.onDragEnd_(e.timestamp);
    return;
  }
  switch (view.type) {
    case ElementType.EMOJI_KEY:
      if (this.pointerDownTimeStamp_ > 0) {
        if (this.isDragging) {
          this.onDragEnd_(e.timestamp);
        } else if (view.text != '') {
          this.setRecentEmoji_(view.text, view.isEmoticon);
        }
        this.update();
      }
      break;
    case ElementType.TAB_BAR_KEY:
      this.updateCategory_(view.toCategory);
      break;
    case ElementType.PAGE_INDICATOR:
      if (this.isDragging) {
        this.adjustXPosition_();
        this.update();
      }
      break;
  }
  this.isDragging = false;
};
EmojiView.prototype.onDragEvent_ = function(e) {
  var view = e.view;
  if (view.type == ElementType.EMOJI_KEY) {
    this.setEmojiMarginLeft_(e.deltaX);
    this.dragDistance_ += e.deltaX;
  } else if (view.type == ElementType.PAGE_INDICATOR) {
    this.pageIndicator_.slide(e.deltaX,
        this.pagesInCategory_[this.categoryID_]);
    this.setEmojiMarginLeft_(-e.deltaX *
        this.pagesInCategory_[this.categoryID_]);
    this.dragDistance_ -= e.deltaX * this.pagesInCategory_[this.categoryID_];
  }
  if (!this.isDragging) {
    this.isDragging = Math.abs(this.dragDistance_) >
        EmojiView.EMOJI_DRAG_START_DISTANCE_;
  }
};
EmojiView.prototype.disposeInternal = function() {
  goog.dispose(this.pointerHandler_);
  goog.base(this, 'disposeInternal');
};
EmojiView.prototype.setEmojiMarginLeft_ = function(deltaX) {
  this.emojiRows_.slide(deltaX);
  this.pageIndicator_.slide(-deltaX,
      this.pagesInCategory_[this.categoryID_]);
};
EmojiView.prototype.updateCategory_ = function(categoryID) {
  this.categoryID_ = categoryID;
  this.emojiRows_.updateCategory(this.pageOffsets_[this.categoryID_]);
  this.pageIndicator_.gotoPage(0,
      this.pagesInCategory_[this.categoryID_]);
  this.updateTabbarBorder_();
};
EmojiView.prototype.adjustXPosition_ = function(opt_distance) {
  var pageNum = this.emojiRows_.adjustXPosition(opt_distance);
  this.categoryID_ = this.pageToCategory_[pageNum];
  this.pageIndicator_.gotoPage(
      pageNum - this.pageOffsets_[this.categoryID_],
      this.pagesInCategory_[this.categoryID_]);
  this.updateTabbarBorder_();
};
EmojiView.prototype.clearEmojiStates = function() {
  this.updateCategory_(this.recentEmojiList_.length > 0 ?
      0 : EmojiView.EMOJI_DEFAULT_CATEGORY_ID_);
};
EmojiView.prototype.setRecentEmoji_ = function(text, isEmoticon) {
  if (goog.array.contains(this.recentEmojiList_, text)) {
    return;
  }
  goog.array.insertAt(this.recentEmojiList_, text, 0);
  var lastRecentEmojiKeyIndex = Math.min(this.keysPerPage_ - 1,
      this.recentEmojiKeys_.length);
  for (var i = lastRecentEmojiKeyIndex; i > 0; i--) {
    var recentEmojiKey = this.recentEmojiKeys_[i];
    var previousKey = this.recentEmojiKeys_[i - 1];
    recentEmojiKey.updateText(previousKey.text, previousKey.isEmoticon);
  }
  this.recentEmojiKeys_[0].updateText(text, isEmoticon);
};
EmojiView.prototype.updateTabbarBorder_ = function() {
  for (var i = 0, len = this.totalTabbars_; i < len; i++) {
    this.tabbarKeys_[i].updateBorder(this.categoryID_);
  }
};
EmojiView.prototype.activate = function(rawKeyset) {
  this.adapter.setController('emoji', this.languageCode);
  goog.dom.classlist.add(this.getElement().parentElement.parentElement,
      Css.EMOJI);
  this.clearEmojiStates();
  this.pageIndicator_.setVisible(true);
};
EmojiView.prototype.deactivate = function(rawKeyset) {
  this.adapter.unsetController();
  this.pointerDownTimeStamp_ = 0;
  goog.dom.classlist.remove(this.getElement().parentElement.parentElement,
      Css.EMOJI);
  this.pageIndicator_.setVisible(false);
};
EmojiView.prototype.repositionIndicator_ = function() {
  var emojiElement = this.emojiSlider_.getElement();
  var elem = this.pageIndicator_.getElement();
  elem.style.width = goog.style.getSize(emojiElement).width + 'px';
  var rowsAndSideKeys =  (
      this.getChildViewById('rowsAndSideKeys').getElement());
  var position = new goog.positioning.AnchoredViewportPosition(
      rowsAndSideKeys, goog.positioning.Corner.BOTTOM_START, true);
  position.reposition(this.pageIndicator_.getElement(),
      goog.positioning.Corner.BOTTOM_START);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.ExpandedCandidateView
goog.provide('i18n.input.chrome.inputview.elements.content.ExpandedCandidateView');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var TagName = goog.dom.TagName;
var Candidate = i18n.input.chrome.inputview.elements.content.Candidate;
var Type = i18n.input.chrome.inputview.elements.content.Candidate.Type;
var ElementType = i18n.input.chrome.ElementType;
var FunctionalKey = i18n.input.chrome.inputview.elements.content.FunctionalKey;
var EnterKey = i18n.input.chrome.inputview.elements.content.EnterKey;
var util = i18n.input.chrome.inputview.util;
i18n.input.chrome.inputview.elements.content.ExpandedCandidateView = function(
    opt_eventTarget) {
  goog.base(this, 'expandedCandidateView', ElementType.
      EXPANDED_CANDIDATE_VIEW, opt_eventTarget);
  this.lines_ = [];
  this.keys_ = {};
  this.pageIndexMap_ = {};
};
var ExpandedCandidateView = i18n.input.chrome.inputview.elements.content.
    ExpandedCandidateView;
goog.inherits(ExpandedCandidateView,
    i18n.input.chrome.inputview.elements.Element);
ExpandedCandidateView.KeyIndex = {
  BACKSPACE: 0,
  ENTER: 1,
  PAGE_UP: 2,
  PAGE_DOWN: 3
};
ExpandedCandidateView.State = {
  NONE: 0,
  COMPLETION_CORRECTION: 1,
  PREDICTION: 2
};
ExpandedCandidateView.prototype.state = ExpandedCandidateView.State.NONE;
ExpandedCandidateView.prototype.pageIndex_ = 0;
ExpandedCandidateView.prototype.candidateStartIndex_ = 0;
ExpandedCandidateView.prototype.candidates_;
ExpandedCandidateView.RIGHT_KEY_WIDTH_ = 120;
ExpandedCandidateView.CELLS_PER_LINE_ = 10;
ExpandedCandidateView.LINES_ = 4;
ExpandedCandidateView.prototype.widthPerCell_ = 0;
ExpandedCandidateView.prototype.heightPerCell_ = 0;
ExpandedCandidateView.prototype.widthInWeight_ = 0;
ExpandedCandidateView.prototype.backspaceWeight_ = 0;
ExpandedCandidateView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var line = this.createCandidateLine_(true);
  this.createKey_(ElementType.BACKSPACE_KEY, Css.BACKSPACE_ICON);
  line = this.createCandidateLine_(false);
  this.createKey_(ElementType.ENTER_KEY, Css.ENTER_ICON);
  line = this.createCandidateLine_(false);
  this.createKey_(ElementType.CANDIDATES_PAGE_UP, Css.PAGE_UP_ICON);
  line = this.createCandidateLine_(false);
  this.createKey_(ElementType.CANDIDATES_PAGE_DOWN, Css.PAGE_DOWN_ICON);
};
ExpandedCandidateView.prototype.createCandidateLine_ = function(isTopLine) {
  var dom = this.getDomHelper();
  var line = dom.createDom(TagName.DIV, [Css.CANDIDATE_INTER_CONTAINER,
    Css.CANDIDATES_LINE]);
  if (isTopLine) {
    goog.dom.classlist.add(line, Css.CANDIDATES_TOP_LINE);
  }
  dom.appendChild(this.getElement(), line);
  this.lines_.push(line);
};
ExpandedCandidateView.prototype.createKey_ = function(type, iconCss) {
  var key;
  if (type == ElementType.ENTER_KEY) {
    key = new EnterKey('', iconCss, this);
  } else {
    key = new FunctionalKey('', type, '', iconCss, this);
  }
  key.render(this.getElement());
  goog.dom.classlist.add(key.getElement(), Css.INLINE_DIV);
  this.keys_[type] = key;
  return key;
};
ExpandedCandidateView.prototype.pageUp = function() {
  if (this.pageIndex_ > 0) {
    this.pageIndex_--;
    this.showCandidates(this.candidates_, this.pageIndexMap_[this.pageIndex_]);
  }
};
ExpandedCandidateView.prototype.pageDown = function() {
  if (this.candidates_.length > this.candidateStartIndex_) {
    this.pageIndex_++;
    this.showCandidates(this.candidates_, this.candidateStartIndex_);
  }
};
ExpandedCandidateView.prototype.close = function() {
  this.candidates_ = [];
  this.pageIndex_ = 0;
  this.pageIndexMap_ = {};
  this.candidateStartIndex_ = 0;
  this.setVisible(false);
};
ExpandedCandidateView.prototype.showCandidates = function(candidates, start) {
  this.setVisible(true);
  var dom = this.getDomHelper();
  for (var i = 0; i < this.lines_.length; i++) {
    dom.removeChildren(this.lines_[i]);
  }
  this.pageIndexMap_[this.pageIndex_] = start;
  this.candidates_ = candidates;
  var lineIndex = 0;
  var line = this.lines_[lineIndex];
  var cellsLeftInLine = ExpandedCandidateView.CELLS_PER_LINE_;
  var previousCandidate = null;
  var previousCandidateWidth = 0;
  var i;
  for (i = start; i < candidates.length; i++) {
    var candidate = candidates[i];
    var candidateElem = new Candidate(String(i), candidate, Type.CANDIDATE,
        this.heightPerCell_, false, undefined, this);
    candidateElem.render(line);
    var size = goog.style.getSize(candidateElem.getElement());
    var cellsOfCandidate = Math.ceil(size.width / this.widthPerCell_);
    if (cellsLeftInLine < cellsOfCandidate && previousCandidate) {
      line.removeChild(candidateElem.getElement());
      i--;
      previousCandidate.setSize(
          cellsLeftInLine * this.widthPerCell_ + previousCandidateWidth,
          this.heightPerCell_);
      cellsLeftInLine = 0;
    } else if ((cellsLeftInLine < cellsOfCandidate && !previousCandidate) ||
        cellsLeftInLine == cellsOfCandidate) {
      candidateElem.setSize(cellsLeftInLine * this.widthPerCell_,
          this.heightPerCell_);
      cellsLeftInLine = 0;
    } else {
      cellsLeftInLine -= cellsOfCandidate;
      candidateElem.setSize(cellsOfCandidate * this.widthPerCell_,
          this.heightPerCell_);
    }
    if (cellsLeftInLine == 0) {
      lineIndex++;
      if (lineIndex == ExpandedCandidateView.LINES_) {
        break;
      }
      cellsLeftInLine = ExpandedCandidateView.CELLS_PER_LINE_;
      line = this.lines_[lineIndex];
      previousCandidateWidth = 0;
      previousCandidate = null;
    } else {
      previousCandidateWidth = size.width;
      previousCandidate = candidateElem;
    }
  }
  this.candidateStartIndex_ = i;
  var pageDownKey = this.keys_[ElementType.CANDIDATES_PAGE_DOWN].getElement();
  var pageUpKey = this.keys_[ElementType.CANDIDATES_PAGE_UP].getElement();
  if (i >= candidates.length) {
    goog.dom.classlist.add(pageDownKey, Css.PAGE_NAVI_INACTIVE);
  } else {
    goog.dom.classlist.remove(pageDownKey, Css.PAGE_NAVI_INACTIVE);
  }
  if (this.pageIndex_ > 0) {
    goog.dom.classlist.remove(pageUpKey, Css.PAGE_NAVI_INACTIVE);
  } else {
    goog.dom.classlist.add(pageUpKey, Css.PAGE_NAVI_INACTIVE);
  }
};
ExpandedCandidateView.prototype.setWidthInWeight = function(widthInWeight,
    backspaceWeight) {
  this.widthInWeight_ = widthInWeight;
  this.backspaceWeight_ = backspaceWeight;
};
ExpandedCandidateView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  goog.style.setSize(this.getElement(), width, height);
  var lastKeyWidth = ExpandedCandidateView.RIGHT_KEY_WIDTH_;
  if (this.backspaceWeight_ > 0) {
    var weightArray = [Math.round(this.widthInWeight_ - this.backspaceWeight_)];
    weightArray.push(this.backspaceWeight_);
    var values = util.splitValue(weightArray, width);
    lastKeyWidth = values[values.length - 1];
  }
  var candidatesWidth = Math.floor(width - lastKeyWidth);
  this.widthPerCell_ = Math.floor(candidatesWidth /
      ExpandedCandidateView.CELLS_PER_LINE_);
  this.heightPerCell_ = Math.floor(height / ExpandedCandidateView.LINES_);
  for (var i = 0; i < this.lines_.length; i++) {
    var line = this.lines_[i];
    goog.style.setSize(line, candidatesWidth, this.heightPerCell_);
  }
  for (var type in this.keys_) {
    type =  (Number(type));
    var key = this.keys_[type];
    key.resize(lastKeyWidth, this.heightPerCell_);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.FloatingView
goog.provide('i18n.input.chrome.inputview.elements.content.FloatingView');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.elements.content.FloatingView = function(
    opt_eventTarget) {
  goog.base(this, '', ElementType.FLOATING_VIEW, opt_eventTarget);
  this.pointerConfig.stopEventPropagation = false;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.FloatingView,
    i18n.input.chrome.inputview.elements.Element);
var FloatingView = i18n.input.chrome.inputview.elements.content.FloatingView;
FloatingView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var elem = this.getElement();
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.FLOATING_COVER);
};
FloatingView.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  goog.style.setElementShown(this.getElement(), false);
};
FloatingView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  goog.style.setSize(this.getElement(), width, height);
};
FloatingView.prototype.show = function() {
  goog.style.setElementShown(this.getElement(), true);
};
FloatingView.prototype.hide = function() {
  goog.style.setElementShown(this.getElement(), false);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.Point
goog.provide('i18n.input.chrome.inputview.elements.content.Point');
goog.scope(function() {
i18n.input.chrome.inputview.elements.content.Point =
    function(x, y, identifier) {
  this.x = x;
  this.y = y;
  this.pointer = 0;
  this.ttl = Point.STARTING_TTL;
  this.time = Date.now();
  this.action = i18n.input.chrome.inputview.elements.content.Point.Action.MOVE;
  this.identifier = identifier;
};
var Point =
    i18n.input.chrome.inputview.elements.content.Point;
Point.STARTING_TTL = 255;
Point.Action = {
  DOWN: 0,
  UP: 1,
  MOVE: 2
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.GestureStroke
goog.provide('i18n.input.chrome.inputview.elements.content.GestureStroke');
goog.scope(function() {
var Point = i18n.input.chrome.inputview.elements.content.Point;
i18n.input.chrome.inputview.elements.content.GestureStroke =
    function() {
  this.points_ = [];
  this.isActive_ = false;
  this.firstTime_ = 0;
};
var GestureStroke =
    i18n.input.chrome.inputview.elements.content.GestureStroke;
GestureStroke.DEGRADATION_RATE_ = 7;
GestureStroke.ACTIVE_THRESHOLD_ = 40;
GestureStroke.STARTING_R_VALUE_ = 68;
GestureStroke.STARTING_G_VALUE_ = 132;
GestureStroke.STARTING_B_VALUE_ = 244;
GestureStroke.STROKE_MAX_WIDTH_ = 9;
GestureStroke.calculateColor_ = function(ttl) {
  var remainingTtlPercentage = ttl / Point.STARTING_TTL;
  var rValue = GestureStroke.STARTING_R_VALUE_;
  var gValue = GestureStroke.STARTING_G_VALUE_;
  var bValue = GestureStroke.STARTING_B_VALUE_;
  return 'rgb(' + rValue + ', ' + gValue + ', ' + bValue + ')';
};
GestureStroke.calculateDistance_ = function(first, second) {
  var a = Math.abs(first.x - second.x);
  var b = Math.abs(first.y - second.y);
  return Math.sqrt(Math.pow(a, 2) + Math.pow(b, 2));
};
GestureStroke.calculateLineWidth_ = function(ttl) {
  var ratio = ttl / Point.STARTING_TTL;
  if (ratio < 0) {
    ratio = 0;
  }
  return GestureStroke.STROKE_MAX_WIDTH_ * ratio;
};
GestureStroke.prototype.degrade = function() {
  var allEmpty = true;
  for (var i = 0; i < this.points_.length; i++) {
    if (this.points_[i].ttl > 0) {
      this.points_[i].ttl -= GestureStroke.DEGRADATION_RATE_;
      allEmpty = false;
    }
  }
  return !allEmpty;
};
GestureStroke.prototype.draw = function(context) {
  if (!this.isActive()) {
    return;
  }
  for (var i = 1; i < this.points_.length; i++) {
    var first = this.points_[i - 1];
    var second = this.points_[i];
    var ttl = second.ttl;
    if (ttl <= 0) {
      continue;
    }
    context.beginPath();
    context.moveTo(first.x, first.y);
    context.lineTo(second.x, second.y);
    context.strokeStyle = GestureStroke.calculateColor_(ttl);
    context.fillStyle = 'none';
    context.lineWidth = GestureStroke.calculateLineWidth_(ttl);
    context.lineCap = 'round';
    context.lineJoin = 'round';
    context.stroke();
  }
};
GestureStroke.prototype.getIdentifierAt = function(i) {
  return this.points_[i].identifier;
};
GestureStroke.prototype.getTimeAt = function(i) {
  return this.points_[i].time;
};
GestureStroke.prototype.getPoints = function() {
  return this.points_;
};
GestureStroke.prototype.isActive = function() {
  if (this.isActive_) {
    return this.isActive_;
  }
  if (this.points_.length < 2) {
    return false;
  }
  this.isActive_ = GestureStroke.calculateDistance_(
      this.points_[0], this.points_[this.points_.length - 1]) >
          GestureStroke.ACTIVE_THRESHOLD_;
  return this.isActive_;
};
GestureStroke.prototype.isDegraded = function() {
  var allPointsDegraded = true;
  for (var i = 0; i < this.points_.length; i++) {
    if (this.points_[i].ttl > 0) {
      allPointsDegraded = false;
      break;
    }
  }
  return allPointsDegraded;
};
GestureStroke.prototype.length = function() {
  return this.points_.length;
};
GestureStroke.prototype.pushPoint = function(p) {
  if (this.points_.length == 0) {
    this.firstTime_ = p.time;
  }
  p.time -= this.firstTime_;
  this.points_.push(p);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.GestureCanvasView
goog.provide('i18n.input.chrome.inputview.elements.content.GestureCanvasView');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var ElementType = i18n.input.chrome.ElementType;
var GestureStroke = i18n.input.chrome.inputview.elements.content.GestureStroke;
var Point = i18n.input.chrome.inputview.elements.content.Point;
var TagName = goog.dom.TagName;
i18n.input.chrome.inputview.elements.content.GestureCanvasView =
    function(opt_eventTarget) {
  GestureCanvasView.base(this, 'constructor', '',
      ElementType.GESTURE_CANVAS_VIEW, opt_eventTarget);
  this.isGesturing = false;
  this.drawingCanvas_;
  this.drawingContext_;
  this.strokeList_ = [];
};
var GestureCanvasView =
    i18n.input.chrome.inputview.elements.content.GestureCanvasView;
goog.inherits(GestureCanvasView, i18n.input.chrome.inputview.elements.Element);
GestureCanvasView.prototype.draw_ = function() {
  this.drawingContext_.clearRect(
      0, 0, this.drawingCanvas_.width, this.drawingCanvas_.height);
  for (var i = 0; i < this.strokeList_.length; i++) {
    this.strokeList_[i].draw(this.drawingContext_);
  }
};
GestureCanvasView.prototype.createDom = function() {
  GestureCanvasView.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem, Css.GESTURE_CANVAS_VIEW);
  this.drawingCanvas_ = dom.createDom(TagName.CANVAS, Css.DRAWING_CANVAS);
  this.drawingContext_ = this.drawingCanvas_.getContext('2d');
  dom.appendChild(elem, this.drawingCanvas_);
  window.requestAnimationFrame(this.animateGestureTrail_.bind(this));
};
GestureCanvasView.prototype.resize = function(width, height) {
  GestureCanvasView.base(this, 'resize', width, height);
  this.drawingCanvas_.width = width;
  this.drawingCanvas_.height = height;
};
GestureCanvasView.prototype.addPoint = function(e) {
  var wasActive = this.latestStrokeActive_();
  if (this.strokeList_.length == 0) {
    this.strokeList_.push(new GestureStroke());
  }
  var lastStroke = this.strokeList_[this.strokeList_.length - 1];
  if (lastStroke.length() > 0 && !this.isActiveIdentifier(e.identifier)) {
    return;
  }
  lastStroke.pushPoint(this.createGesturePoint_(e));
  if (!wasActive && this.latestStrokeActive_()) {
    this.isGesturing = true;
  }
};
GestureCanvasView.prototype.clear = function() {
  this.strokeList_ = [];
  this.draw_();
};
GestureCanvasView.prototype.latestStrokeActive_ = function() {
  if (this.strokeList_.length == 0) {
    return false;
  }
  return this.strokeList_[this.strokeList_.length - 1].isActive();
};
GestureCanvasView.prototype.startStroke = function(e) {
  if (this.strokeList_.length > 0 && !this.isActiveIdentifier(e.identifier)) {
    return;
  }
  this.strokeList_.push(new GestureStroke());
  var point = this.createGesturePoint_(e);
  point.action = Point.Action.DOWN;
  point.pointer = 0;
  this.strokeList_[this.strokeList_.length - 1].pushPoint(point);
};
GestureCanvasView.prototype.endStroke = function(e) {
  if (e.identifier !=
      this.strokeList_[this.strokeList_.length - 1].getIdentifierAt(0)) {
    return;
  }
  var point = this.createGesturePoint_(e);
  point.action = Point.Action.UP;
  this.strokeList_[this.strokeList_.length - 1].pushPoint(point);
  this.isGesturing = false;
};
GestureCanvasView.prototype.getLastStroke = function() {
  if (this.strokeList_.length == 0) {
    return null;
  }
  return this.strokeList_[this.strokeList_.length - 1];
};
GestureCanvasView.prototype.isActiveIdentifier = function(identifier) {
  return identifier == this.strokeList_[this.strokeList_.length - 1]
      .getIdentifierAt(0);
};
GestureCanvasView.prototype.removeEmptyStrokes = function() {
  for (var i = 0; i < this.strokeList_.length; i++) {
    if (this.strokeList_[i].isDegraded()) {
      this.strokeList_.splice(i, 1);
      i--;
    }
  }
};
GestureCanvasView.prototype.animateGestureTrail_ = function() {
  this.draw_();
  this.degradeStrokes_();
  window.requestAnimationFrame(this.animateGestureTrail_.bind(this));
};
GestureCanvasView.prototype.createGesturePoint_ = function(e) {
  var offset = goog.style.getPageOffset(this.drawingCanvas_);
  return new Point(e.x - offset.x, e.y - offset.y, e.identifier);
};
GestureCanvasView.prototype.degradeStrokes_ = function() {
  for (var i = 0; i < this.strokeList_.length; i++) {
    this.strokeList_[i].degrade();
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.HandwritingView
goog.provide('i18n.input.chrome.inputview.elements.content.HandwritingView');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var KeysetView = i18n.input.chrome.inputview.elements.content.KeysetView;
i18n.input.chrome.inputview.elements.content.HandwritingView = function(keyData,
    layoutData, keyboardCode, languageCode, model, name, opt_eventTarget,
    opt_adapter) {
  i18n.input.chrome.inputview.elements.content.HandwritingView.base(this,
      'constructor', keyData, layoutData, keyboardCode, languageCode, model,
      name, opt_eventTarget, opt_adapter);
};
var HandwritingView = i18n.input.chrome.inputview.elements.content.
    HandwritingView;
goog.inherits(HandwritingView, KeysetView);
HandwritingView.prototype.activate = function(rawKeyset) {
  goog.dom.classlist.add(this.getElement().parentElement.parentElement,
      Css.HANDWRITING);
  if (this.canvasView.hasStrokesOnCanvas()) {
    this.canvasView.reset();
  }
};
HandwritingView.prototype.deactivate = function(rawKeyset) {
  this.adapter.unsetController();
  goog.dom.classlist.remove(this.getElement().parentElement.parentElement,
      Css.HANDWRITING);
};
HandwritingView.prototype.setLanguagecode = function(languageCode) {
  this.languageCode = languageCode;
  this.adapter.setController('hwt', this.languageCode);
  this.canvasView.setPrivacyInfoDirection(
      goog.i18n.bidi.isRtlLanguage(languageCode) ? 'rtl' : 'ltr');
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.MenuItem
goog.provide('i18n.input.chrome.inputview.elements.content.MenuItem');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var TagName = goog.dom.TagName;
var ElementType = i18n.input.chrome.ElementType;
i18n.input.chrome.inputview.elements.content.MenuItem = function(id, item,
    menuItemType, ariaLabel, opt_eventTarget) {
  goog.base(this, id, ElementType.MENU_ITEM, opt_eventTarget);
  this.item_ = item;
  this.menuItemType_ = menuItemType;
  this.ariaLabel_ = ariaLabel;
  this.pointerConfig.stopEventPropagation = false;
  this.pointerConfig.preventDefault = false;
};
var MenuItem = i18n.input.chrome.inputview.elements.content.MenuItem;
goog.inherits(MenuItem, i18n.input.chrome.inputview.elements.Element);
MenuItem.Type = {
  LIST_ITEM: 0,
  FOOTER_ITEM: 1
};
MenuItem.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  switch (this.menuItemType_) {
    case MenuItem.Type.LIST_ITEM:
      goog.dom.classlist.add(elem,
          i18n.input.chrome.inputview.Css.MENU_LIST_ITEM);
      var indicatorDiv = dom.createDom(goog.dom.TagName.DIV,
          i18n.input.chrome.inputview.Css.MENU_LIST_INDICATOR);
      if (this.item_['iconURL']) {
        indicatorDiv.style.backgroundImage =
            'url(' + this.item_['iconURL'] + ')';
        goog.a11y.aria.setState(indicatorDiv, goog.a11y.aria.State.LABEL,
            this.ariaLabel_);
      } else {
        var indicatorTextDiv = dom.createDom(goog.dom.TagName.DIV,
            i18n.input.chrome.inputview.Css.MENU_LIST_INDICATOR_NAME);
        indicatorTextDiv.textContent = this.item_['indicator'];
        goog.a11y.aria.setState(indicatorTextDiv, goog.a11y.aria.State.LABEL,
            this.ariaLabel_);
        dom.appendChild(indicatorDiv, indicatorTextDiv);
      }
      dom.appendChild(elem, indicatorDiv);
      var nameDiv = dom.createDom(goog.dom.TagName.DIV,
          i18n.input.chrome.inputview.Css.MENU_LIST_NAME);
      var nameText = dom.createDom(goog.dom.TagName.DIV);
      nameText.innerText = this.item_['name'];
      goog.a11y.aria.setState(nameText, goog.a11y.aria.State.LABEL,
          this.ariaLabel_);
      dom.appendChild(nameDiv, nameText);
      dom.appendChild(elem, nameDiv);
      break;
    case MenuItem.Type.FOOTER_ITEM:
      goog.dom.classlist.add(elem,
          i18n.input.chrome.inputview.Css.MENU_FOOTER_ITEM);
      goog.dom.classlist.add(elem, this.item_['iconCssClass']);
      goog.a11y.aria.setState((elem),
          goog.a11y.aria.State.LABEL, this.ariaLabel_);
  }
};
MenuItem.prototype.getCommand = function() {
  return this.item_['command'];
};
MenuItem.prototype.setHighlighted = function(highlight) {
  if (highlight) {
    goog.dom.classlist.add(this.getElement(), Css.ELEMENT_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(this.getElement(), Css.ELEMENT_HIGHLIGHT);
  }
};
MenuItem.prototype.check = function() {
  goog.dom.classlist.add(this.getElement(), Css.CHECKED_MENU_LIST);
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.MenuView
goog.provide('i18n.input.chrome.inputview.elements.content.MenuView');
goog.scope(function() {
var ElementType = i18n.input.chrome.ElementType;
var MenuItem = i18n.input.chrome.inputview.elements.content.MenuItem;
var Css = i18n.input.chrome.inputview.Css;
i18n.input.chrome.inputview.elements.content.MenuView = function(
    opt_eventTarget) {
  goog.base(this, '', ElementType.MENU_VIEW, opt_eventTarget);
  this.coverElement_ = this.getDomHelper().createDom(goog.dom.TagName.DIV,
      Css.ALTDATA_COVER);
  this.triggeredBy_ = null;
  this.logger_ = goog.log.getLogger(
      'i18n.input.chrome.inputview.elements.content.MenuView');
  this.pointerConfig.stopEventPropagation = false;
  this.pointerConfig.preventDefault = false;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.MenuView,
    i18n.input.chrome.inputview.elements.Element);
var MenuView = i18n.input.chrome.inputview.elements.content.MenuView;
MenuView.Command = {
  SWITCH_IME: 0,
  SWITCH_KEYSET: 1,
  OPEN_EMOJI: 2,
  OPEN_HANDWRITING: 3,
  OPEN_SETTING: 4
};
MenuView.MAX_VISIBLE_ITEMS_ = 4;
MenuView.MAX_VISIBLE_ITEMS_A11Y_ = 3;
MenuView.WIDTH_PX_ = 275;
MenuView.PADDING_LEFT_PX_ = 25;
MenuView.LIST_ITEM_HEIGHT_PX_ = 45;
MenuView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem, Css.MENU_VIEW);
  goog.a11y.aria.setState(this.coverElement_, goog.a11y.aria.State.LABEL,
      chrome.i18n.getMessage('DISMISS_MENU'));
  dom.appendChild(document.body, this.coverElement_);
  goog.style.setElementShown(this.coverElement_, false);
  this.coverElement_['view'] = this;
};
MenuView.prototype.show = function(key, currentKeysetId, isCompact,
    enableCompactLayout, currentInputMethod, inputMethods, hasHwt,
    enableSettings, hasEmoji, isA11y) {
  var ElementType = i18n.input.chrome.ElementType;
  var dom = this.getDomHelper();
  if (key.type != ElementType.MENU_KEY) {
    goog.log.warning(this.logger_,
        'Unexpected key triggered the menu view. Key type = ' + key.type + '.');
    return;
  }
  this.triggeredBy_ = key;
  var coordinate = goog.style.getClientPosition(key.getElement());
  var x = coordinate.x;
  var y = coordinate.y;
  goog.style.setElementShown(this.getElement(), true);
  dom.removeChildren(this.getElement());
  var totalHeight = 0;
  totalHeight += this.addInputMethodItems_(currentInputMethod, inputMethods,
      isA11y);
  totalHeight += this.addLayoutSwitcherItem_(key, currentKeysetId, isCompact,
      enableCompactLayout);
  if (hasHwt || enableSettings || hasEmoji) {
    totalHeight += this.addFooterItems_(hasHwt, enableSettings, hasEmoji);
  }
  var left = x;
  var elemTop = y - totalHeight;
  goog.style.setPosition(this.getElement(), left, elemTop);
  goog.style.setElementShown(this.coverElement_, true);
  this.triggeredBy_.setHighlighted(true);
};
MenuView.prototype.hide = function() {
  goog.style.setElementShown(this.getElement(), false);
  goog.style.setElementShown(this.coverElement_, false);
  if (this.triggeredBy_) {
    this.triggeredBy_.setHighlighted(false);
  }
};
MenuView.prototype.addInputMethodItems_ = function(currentInputMethod,
    inputMethods, isA11y) {
  var dom = this.getDomHelper();
  var container = dom.createDom(goog.dom.TagName.DIV,
      Css.IME_LIST_CONTAINER);
  var visibleItems = isA11y ?
      MenuView.MAX_VISIBLE_ITEMS_A11Y_ : MenuView.MAX_VISIBLE_ITEMS_;
  for (var i = 0; i < inputMethods.length; i++) {
    var inputMethod = inputMethods[i];
    var listItem = {
      'indicator': inputMethod['indicator'],
      'name': inputMethod['name'],
      'command':
        [MenuView.Command.SWITCH_IME, inputMethod['id']]
    };
    var ariaLabel = chrome.i18n.getMessage('SWITCH_TO_KEYBOARD_PREFIX') +
        inputMethod['name'];
    if (currentInputMethod == inputMethod['id']) {
      ariaLabel = chrome.i18n.getMessage('CURRENT_KEYBOARD_PREFIX') +
          inputMethod['name'];
    }
    var imeItem = new MenuItem(String(i), listItem, MenuItem.Type.LIST_ITEM,
        ariaLabel);
    imeItem.render(container);
    if (currentInputMethod == inputMethod['id']) {
      imeItem.check();
    }
    goog.style.setSize(imeItem.getElement(),
        MenuView.WIDTH_PX_ + MenuView.PADDING_LEFT_PX_,
        MenuView.LIST_ITEM_HEIGHT_PX_);
  }
  var containerHeight = inputMethods.length > visibleItems ?
      MenuView.LIST_ITEM_HEIGHT_PX_ * visibleItems :
      MenuView.LIST_ITEM_HEIGHT_PX_ * inputMethods.length;
  goog.style.setSize(container, MenuView.WIDTH_PX_ + MenuView.PADDING_LEFT_PX_,
      containerHeight);
  dom.appendChild(this.getElement(), container);
  return containerHeight;
};
MenuView.prototype.addLayoutSwitcherItem_ = function(key, currentKeysetId,
    isCompact, enableCompactLayout) {
  if (!isCompact && !enableCompactLayout) {
    return 0;
  }
  var layoutSwitcherItem;
  if (isCompact) {
    var fullLayoutId = currentKeysetId.split('.')[0];
    layoutSwitcherItem = new MenuItem('MenuLayoutSwitcher',
        {
          'iconURL': 'images/regular_size.png',
          'name': chrome.i18n.getMessage('SWITCH_TO_FULL_LAYOUT'),
          'command': [MenuView.Command.SWITCH_KEYSET, fullLayoutId]
        },
        MenuItem.Type.LIST_ITEM,
        chrome.i18n.getMessage('SWITCH_TO_FULL_LAYOUT'));
  } else {
    if (goog.array.contains(i18n.input.chrome.inputview.util.KEYSETS_USE_US,
        currentKeysetId)) {
      key.toKeyset = currentKeysetId + '.compact.qwerty';
    }
    layoutSwitcherItem = new MenuItem('MenuLayoutSwitcher',
        {
          'iconURL': 'images/compact.png',
          'name': chrome.i18n.getMessage('SWITCH_TO_COMPACT_LAYOUT'),
          'command': [MenuView.Command.SWITCH_KEYSET, key.toKeyset]
        },
        MenuItem.Type.LIST_ITEM,
        chrome.i18n.getMessage('SWITCH_TO_COMPACT_LAYOUT'));
  }
  layoutSwitcherItem.render(this.getElement());
  goog.style.setSize(layoutSwitcherItem.getElement(), MenuView.WIDTH_PX_,
      MenuView.LIST_ITEM_HEIGHT_PX_);
  return MenuView.LIST_ITEM_HEIGHT_PX_;
};
MenuView.prototype.addFooterItems_ = function(hasHwt, enableSettings,
    hasEmoji) {
  var dom = this.getDomHelper();
  var footer = dom.createDom(goog.dom.TagName.DIV, Css.MENU_FOOTER);
  if (hasEmoji) {
    var emoji = {
      'iconCssClass': Css.MENU_FOOTER_EMOJI_BUTTON,
      'command': [MenuView.Command.OPEN_EMOJI]
    };
    var emojiFooter = new MenuItem('emoji', emoji,
        MenuItem.Type.FOOTER_ITEM,
        chrome.i18n.getMessage('FOOTER_EMOJI_BUTTON'));
    emojiFooter.render(footer);
  }
  if (hasHwt) {
    var handWriting = {
      'iconCssClass': Css.MENU_FOOTER_HANDWRITING_BUTTON,
      'command': [MenuView.Command.OPEN_HANDWRITING]
    };
    var handWritingFooter = new MenuItem('handwriting', handWriting,
        MenuItem.Type.FOOTER_ITEM,
        chrome.i18n.getMessage('FOOTER_HANDWRITING_BUTTON'));
    handWritingFooter.render(footer);
  }
  if (enableSettings) {
    var setting = {
      'iconCssClass': Css.MENU_FOOTER_SETTING_BUTTON,
      'command': [MenuView.Command.OPEN_SETTING]
    };
    var settingFooter = new MenuItem('setting', setting,
        MenuItem.Type.FOOTER_ITEM,
        chrome.i18n.getMessage('FOOTER_SETTINGS_BUTTON'));
    settingFooter.render(footer);
  }
  var elems = dom.getChildren(footer);
  var len = elems.length;
  var subWidth =
      Math.ceil((MenuView.WIDTH_PX_ + MenuView.PADDING_LEFT_PX_) / len);
  for (var i = 0; i < len - 1; i++) {
    elems[i].style.width = subWidth + 'px';
  }
  elems[len - 1].style.width = (MenuView.WIDTH_PX_ + MenuView.PADDING_LEFT_PX_ -
      subWidth * (len - 1)) + 'px';
  dom.appendChild(this.getElement(), footer);
  goog.style.setSize(footer, (MenuView.WIDTH_PX_ + MenuView.PADDING_LEFT_PX_),
      MenuView.LIST_ITEM_HEIGHT_PX_);
  return MenuView.LIST_ITEM_HEIGHT_PX_;
};
MenuView.prototype.getCoverElement = function() {
  return this.coverElement_;
};
MenuView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  goog.style.setSize(this.coverElement_, width, height);
  this.hide();
};
MenuView.prototype.disposeInternal = function() {
  this.coverElement_['view'] = null;
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.inputview.elements.content.SelectView
goog.provide('i18n.input.chrome.inputview.elements.content.SelectView');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var ElementType = i18n.input.chrome.ElementType;
var TagName = goog.dom.TagName;
i18n.input.chrome.inputview.elements.content.SelectView = function(
    opt_eventTarget) {
  goog.base(this, '', ElementType.SELECT_VIEW, opt_eventTarget);
  this.enabled_ = false;
  this.isKeysetSupported_ = false;
};
goog.inherits(i18n.input.chrome.inputview.elements.content.SelectView,
    i18n.input.chrome.inputview.elements.Element);
var SelectView = i18n.input.chrome.inputview.elements.content.SelectView;
SelectView.prototype.left_;
SelectView.prototype.right_;
SelectView.WIDTH_ = 37;
SelectView.PORTRAIT_WIDTH_ = 15;
SelectView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  var knob = dom.createDom(TagName.DIV);
  var knobContainer = dom.createDom(TagName.DIV, undefined, knob);
  this.left_ = dom.createDom(TagName.DIV, Css.SELECT_KNOB_LEFT, knobContainer);
  dom.appendChild(this.getElement(), this.left_);
  knob = dom.createDom(TagName.DIV);
  knobContainer = dom.createDom(TagName.DIV, undefined, knob);
  this.right_ =
      dom.createDom(TagName.DIV, Css.SELECT_KNOB_RIGHT, knobContainer);
  dom.appendChild(this.getElement(), this.right_);
};
SelectView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  var isLandscape = screen.width > screen.height;
  var affordanceWidth = isLandscape ?
      SelectView.WIDTH_ : SelectView.PORTRAIT_WIDTH_;
  if (isLandscape) {
    goog.dom.classlist.addRemove(this.getElement(),
        Css.PORTRAIT, Css.LANDSCAPE);
  } else {
    goog.dom.classlist.addRemove(this.getElement(),
        Css.LANDSCAPE, Css.PORTRAIT);
  }
  this.left_ && goog.style.setStyle(this.left_, {
    'height': height + 'px',
    'width': affordanceWidth + 'px'
  });
  this.right_ && goog.style.setStyle(this.right_, {
    'height': height + 'px',
    'width': affordanceWidth + 'px',
    'left': width - affordanceWidth + 'px'
  });
};
SelectView.prototype.setSettingsEnabled = function(enabled) {
  this.enabled_ = enabled;
  this.update_();
};
SelectView.prototype.setKeysetSupported = function(supported) {
  this.isKeysetSupported_ = supported;
  this.update_();
};
SelectView.prototype.update_ = function() {
  this.setVisible(this.enabled_ && this.isKeysetSupported_);
};
SelectView.prototype.disposeInternal = function() {
  goog.dispose(this.left_);
  goog.dispose(this.right_);
  goog.base(this, 'disposeInternal');
};
SelectView.prototype.setVisible = function(visible) {
  SelectView.base(this, 'setVisible', visible);
  if (this.left_) {
    goog.style.setElementShown(this.left_, visible);
  }
  if (this.right_) {
    goog.style.setElementShown(this.right_, visible);
  }
};
});  // goog.scope

// goog.fx.Transition
// goog.fx.Transition.EventType
goog.provide('goog.fx.Transition');
goog.provide('goog.fx.Transition.EventType');
goog.fx.Transition = function() {};
goog.fx.Transition.EventType = {
  PLAY: 'play',
  BEGIN: 'begin',
  RESUME: 'resume',
  END: 'end',
  STOP: 'stop',
  FINISH: 'finish',
  PAUSE: 'pause'
};
goog.fx.Transition.prototype.play;
goog.fx.Transition.prototype.stop;

// goog.color.names
goog.provide('goog.color.names');
goog.color.names = {
  'aliceblue': '#f0f8ff',
  'antiquewhite': '#faebd7',
  'aqua': '#00ffff',
  'aquamarine': '#7fffd4',
  'azure': '#f0ffff',
  'beige': '#f5f5dc',
  'bisque': '#ffe4c4',
  'black': '#000000',
  'blanchedalmond': '#ffebcd',
  'blue': '#0000ff',
  'blueviolet': '#8a2be2',
  'brown': '#a52a2a',
  'burlywood': '#deb887',
  'cadetblue': '#5f9ea0',
  'chartreuse': '#7fff00',
  'chocolate': '#d2691e',
  'coral': '#ff7f50',
  'cornflowerblue': '#6495ed',
  'cornsilk': '#fff8dc',
  'crimson': '#dc143c',
  'cyan': '#00ffff',
  'darkblue': '#00008b',
  'darkcyan': '#008b8b',
  'darkgoldenrod': '#b8860b',
  'darkgray': '#a9a9a9',
  'darkgreen': '#006400',
  'darkgrey': '#a9a9a9',
  'darkkhaki': '#bdb76b',
  'darkmagenta': '#8b008b',
  'darkolivegreen': '#556b2f',
  'darkorange': '#ff8c00',
  'darkorchid': '#9932cc',
  'darkred': '#8b0000',
  'darksalmon': '#e9967a',
  'darkseagreen': '#8fbc8f',
  'darkslateblue': '#483d8b',
  'darkslategray': '#2f4f4f',
  'darkslategrey': '#2f4f4f',
  'darkturquoise': '#00ced1',
  'darkviolet': '#9400d3',
  'deeppink': '#ff1493',
  'deepskyblue': '#00bfff',
  'dimgray': '#696969',
  'dimgrey': '#696969',
  'dodgerblue': '#1e90ff',
  'firebrick': '#b22222',
  'floralwhite': '#fffaf0',
  'forestgreen': '#228b22',
  'fuchsia': '#ff00ff',
  'gainsboro': '#dcdcdc',
  'ghostwhite': '#f8f8ff',
  'gold': '#ffd700',
  'goldenrod': '#daa520',
  'gray': '#808080',
  'green': '#008000',
  'greenyellow': '#adff2f',
  'grey': '#808080',
  'honeydew': '#f0fff0',
  'hotpink': '#ff69b4',
  'indianred': '#cd5c5c',
  'indigo': '#4b0082',
  'ivory': '#fffff0',
  'khaki': '#f0e68c',
  'lavender': '#e6e6fa',
  'lavenderblush': '#fff0f5',
  'lawngreen': '#7cfc00',
  'lemonchiffon': '#fffacd',
  'lightblue': '#add8e6',
  'lightcoral': '#f08080',
  'lightcyan': '#e0ffff',
  'lightgoldenrodyellow': '#fafad2',
  'lightgray': '#d3d3d3',
  'lightgreen': '#90ee90',
  'lightgrey': '#d3d3d3',
  'lightpink': '#ffb6c1',
  'lightsalmon': '#ffa07a',
  'lightseagreen': '#20b2aa',
  'lightskyblue': '#87cefa',
  'lightslategray': '#778899',
  'lightslategrey': '#778899',
  'lightsteelblue': '#b0c4de',
  'lightyellow': '#ffffe0',
  'lime': '#00ff00',
  'limegreen': '#32cd32',
  'linen': '#faf0e6',
  'magenta': '#ff00ff',
  'maroon': '#800000',
  'mediumaquamarine': '#66cdaa',
  'mediumblue': '#0000cd',
  'mediumorchid': '#ba55d3',
  'mediumpurple': '#9370db',
  'mediumseagreen': '#3cb371',
  'mediumslateblue': '#7b68ee',
  'mediumspringgreen': '#00fa9a',
  'mediumturquoise': '#48d1cc',
  'mediumvioletred': '#c71585',
  'midnightblue': '#191970',
  'mintcream': '#f5fffa',
  'mistyrose': '#ffe4e1',
  'moccasin': '#ffe4b5',
  'navajowhite': '#ffdead',
  'navy': '#000080',
  'oldlace': '#fdf5e6',
  'olive': '#808000',
  'olivedrab': '#6b8e23',
  'orange': '#ffa500',
  'orangered': '#ff4500',
  'orchid': '#da70d6',
  'palegoldenrod': '#eee8aa',
  'palegreen': '#98fb98',
  'paleturquoise': '#afeeee',
  'palevioletred': '#db7093',
  'papayawhip': '#ffefd5',
  'peachpuff': '#ffdab9',
  'peru': '#cd853f',
  'pink': '#ffc0cb',
  'plum': '#dda0dd',
  'powderblue': '#b0e0e6',
  'purple': '#800080',
  'red': '#ff0000',
  'rosybrown': '#bc8f8f',
  'royalblue': '#4169e1',
  'saddlebrown': '#8b4513',
  'salmon': '#fa8072',
  'sandybrown': '#f4a460',
  'seagreen': '#2e8b57',
  'seashell': '#fff5ee',
  'sienna': '#a0522d',
  'silver': '#c0c0c0',
  'skyblue': '#87ceeb',
  'slateblue': '#6a5acd',
  'slategray': '#708090',
  'slategrey': '#708090',
  'snow': '#fffafa',
  'springgreen': '#00ff7f',
  'steelblue': '#4682b4',
  'tan': '#d2b48c',
  'teal': '#008080',
  'thistle': '#d8bfd8',
  'tomato': '#ff6347',
  'turquoise': '#40e0d0',
  'violet': '#ee82ee',
  'wheat': '#f5deb3',
  'white': '#ffffff',
  'whitesmoke': '#f5f5f5',
  'yellow': '#ffff00',
  'yellowgreen': '#9acd32'
};

// goog.color
// goog.color.Hsl
// goog.color.Hsv
// goog.color.Rgb
goog.provide('goog.color');
goog.provide('goog.color.Hsl');
goog.provide('goog.color.Hsv');
goog.provide('goog.color.Rgb');
goog.color.Rgb;
goog.color.Hsv;
goog.color.Hsl;
goog.color.parse = function(str) {
  var result = {};
  str = String(str);
  var maybeHex = goog.color.prependHashIfNecessaryHelper(str);
  if (goog.color.isValidHexColor_(maybeHex)) {
    result.hex = goog.color.normalizeHex(maybeHex);
    result.type = 'hex';
    return result;
  } else {
    var rgb = goog.color.isValidRgbColor_(str);
    if (rgb.length) {
      result.hex = goog.color.rgbArrayToHex(rgb);
      result.type = 'rgb';
      return result;
    } else if (goog.color.names) {
      var hex = goog.color.names[str.toLowerCase()];
      if (hex) {
        result.hex = hex;
        result.type = 'named';
        return result;
      }
    }
  }
  throw Error(str + ' is not a valid color string');
};
goog.color.isValidColor = function(str) {
  var maybeHex = goog.color.prependHashIfNecessaryHelper(str);
  return !!(goog.color.isValidHexColor_(maybeHex) ||
            goog.color.isValidRgbColor_(str).length ||
            goog.color.names && goog.color.names[str.toLowerCase()]);
};
goog.color.parseRgb = function(str) {
  var rgb = goog.color.isValidRgbColor_(str);
  if (!rgb.length) {
    throw Error(str + ' is not a valid RGB color');
  }
  return rgb;
};
goog.color.hexToRgbStyle = function(hexColor) {
  return goog.color.rgbStyle_(goog.color.hexToRgb(hexColor));
};
goog.color.hexTripletRe_ = /#(.)(.)(.)/;
goog.color.normalizeHex = function(hexColor) {
  if (!goog.color.isValidHexColor_(hexColor)) {
    throw Error("'" + hexColor + "' is not a valid hex color");
  }
  if (hexColor.length == 4) { // of the form #RGB
    hexColor = hexColor.replace(goog.color.hexTripletRe_, '#$1$1$2$2$3$3');
  }
  return hexColor.toLowerCase();
};
goog.color.hexToRgb = function(hexColor) {
  hexColor = goog.color.normalizeHex(hexColor);
  var r = parseInt(hexColor.substr(1, 2), 16);
  var g = parseInt(hexColor.substr(3, 2), 16);
  var b = parseInt(hexColor.substr(5, 2), 16);
  return [r, g, b];
};
goog.color.rgbToHex = function(r, g, b) {
  r = Number(r);
  g = Number(g);
  b = Number(b);
  if (isNaN(r) || r < 0 || r > 255 ||
      isNaN(g) || g < 0 || g > 255 ||
      isNaN(b) || b < 0 || b > 255) {
    throw Error('"(' + r + ',' + g + ',' + b + '") is not a valid RGB color');
  }
  var hexR = goog.color.prependZeroIfNecessaryHelper(r.toString(16));
  var hexG = goog.color.prependZeroIfNecessaryHelper(g.toString(16));
  var hexB = goog.color.prependZeroIfNecessaryHelper(b.toString(16));
  return '#' + hexR + hexG + hexB;
};
goog.color.rgbArrayToHex = function(rgb) {
  return goog.color.rgbToHex(rgb[0], rgb[1], rgb[2]);
};
goog.color.rgbToHsl = function(r, g, b) {
  var normR = r / 255;
  var normG = g / 255;
  var normB = b / 255;
  var max = Math.max(normR, normG, normB);
  var min = Math.min(normR, normG, normB);
  var h = 0;
  var s = 0;
  var l = 0.5 * (max + min);
  if (max != min) {
    if (max == normR) {
      h = 60 * (normG - normB) / (max - min);
    } else if (max == normG) {
      h = 60 * (normB - normR) / (max - min) + 120;
    } else if (max == normB) {
      h = 60 * (normR - normG) / (max - min) + 240;
    }
    if (0 < l && l <= 0.5) {
      s = (max - min) / (2 * l);
    } else {
      s = (max - min) / (2 - 2 * l);
    }
  }
  return [Math.round(h + 360) % 360, s, l];
};
goog.color.rgbArrayToHsl = function(rgb) {
  return goog.color.rgbToHsl(rgb[0], rgb[1], rgb[2]);
};
goog.color.hueToRgb_ = function(v1, v2, vH) {
  if (vH < 0) {
    vH += 1;
  } else if (vH > 1) {
    vH -= 1;
  }
  if ((6 * vH) < 1) {
    return (v1 + (v2 - v1) * 6 * vH);
  } else if (2 * vH < 1) {
    return v2;
  } else if (3 * vH < 2) {
    return (v1 + (v2 - v1) * ((2 / 3) - vH) * 6);
  }
  return v1;
};
goog.color.hslToRgb = function(h, s, l) {
  var r = 0;
  var g = 0;
  var b = 0;
  var normH = h / 360; // normalize h to fall in [0, 1]
  if (s == 0) {
    r = g = b = l * 255;
  } else {
    var temp1 = 0;
    var temp2 = 0;
    if (l < 0.5) {
      temp2 = l * (1 + s);
    } else {
      temp2 = l + s - (s * l);
    }
    temp1 = 2 * l - temp2;
    r = 255 * goog.color.hueToRgb_(temp1, temp2, normH + (1 / 3));
    g = 255 * goog.color.hueToRgb_(temp1, temp2, normH);
    b = 255 * goog.color.hueToRgb_(temp1, temp2, normH - (1 / 3));
  }
  return [Math.round(r), Math.round(g), Math.round(b)];
};
goog.color.hslArrayToRgb = function(hsl) {
  return goog.color.hslToRgb(hsl[0], hsl[1], hsl[2]);
};
goog.color.validHexColorRe_ = /^#(?:[0-9a-f]{3}){1,2}$/i;
goog.color.isValidHexColor_ = function(str) {
  return goog.color.validHexColorRe_.test(str);
};
goog.color.normalizedHexColorRe_ = /^#[0-9a-f]{6}$/;
goog.color.isNormalizedHexColor_ = function(str) {
  return goog.color.normalizedHexColorRe_.test(str);
};
goog.color.rgbColorRe_ =
    /^(?:rgb)?\((0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2})\)$/i;
goog.color.isValidRgbColor_ = function(str) {
  var regExpResultArray = str.match(goog.color.rgbColorRe_);
  if (regExpResultArray) {
    var r = Number(regExpResultArray[1]);
    var g = Number(regExpResultArray[2]);
    var b = Number(regExpResultArray[3]);
    if (r >= 0 && r <= 255 &&
        g >= 0 && g <= 255 &&
        b >= 0 && b <= 255) {
      return [r, g, b];
    }
  }
  return [];
};
goog.color.prependZeroIfNecessaryHelper = function(hex) {
  return hex.length == 1 ? '0' + hex : hex;
};
goog.color.prependHashIfNecessaryHelper = function(str) {
  return str.charAt(0) == '#' ? str : '#' + str;
};
goog.color.rgbStyle_ = function(rgb) {
  return 'rgb(' + rgb.join(',') + ')';
};
goog.color.hsvToRgb = function(h, s, brightness) {
  var red = 0;
  var green = 0;
  var blue = 0;
  if (s == 0) {
    red = brightness;
    green = brightness;
    blue = brightness;
  } else {
    var sextant = Math.floor(h / 60);
    var remainder = (h / 60) - sextant;
    var val1 = brightness * (1 - s);
    var val2 = brightness * (1 - (s * remainder));
    var val3 = brightness * (1 - (s * (1 - remainder)));
    switch (sextant) {
      case 1:
        red = val2;
        green = brightness;
        blue = val1;
        break;
      case 2:
        red = val1;
        green = brightness;
        blue = val3;
        break;
      case 3:
        red = val1;
        green = val2;
        blue = brightness;
        break;
      case 4:
        red = val3;
        green = val1;
        blue = brightness;
        break;
      case 5:
        red = brightness;
        green = val1;
        blue = val2;
        break;
      case 6:
      case 0:
        red = brightness;
        green = val3;
        blue = val1;
        break;
    }
  }
  return [Math.floor(red), Math.floor(green), Math.floor(blue)];
};
goog.color.rgbToHsv = function(red, green, blue) {
  var max = Math.max(Math.max(red, green), blue);
  var min = Math.min(Math.min(red, green), blue);
  var hue;
  var saturation;
  var value = max;
  if (min == max) {
    hue = 0;
    saturation = 0;
  } else {
    var delta = (max - min);
    saturation = delta / max;
    if (red == max) {
      hue = (green - blue) / delta;
    } else if (green == max) {
      hue = 2 + ((blue - red) / delta);
    } else {
      hue = 4 + ((red - green) / delta);
    }
    hue *= 60;
    if (hue < 0) {
      hue += 360;
    }
    if (hue > 360) {
      hue -= 360;
    }
  }
  return [hue, saturation, value];
};
goog.color.rgbArrayToHsv = function(rgb) {
  return goog.color.rgbToHsv(rgb[0], rgb[1], rgb[2]);
};
goog.color.hsvArrayToRgb = function(hsv) {
  return goog.color.hsvToRgb(hsv[0], hsv[1], hsv[2]);
};
goog.color.hexToHsl = function(hex) {
  var rgb = goog.color.hexToRgb(hex);
  return goog.color.rgbToHsl(rgb[0], rgb[1], rgb[2]);
};
goog.color.hslToHex = function(h, s, l) {
  return goog.color.rgbArrayToHex(goog.color.hslToRgb(h, s, l));
};
goog.color.hslArrayToHex = function(hsl) {
  return goog.color.rgbArrayToHex(goog.color.hslToRgb(hsl[0], hsl[1], hsl[2]));
};
goog.color.hexToHsv = function(hex) {
  return goog.color.rgbArrayToHsv(goog.color.hexToRgb(hex));
};
goog.color.hsvToHex = function(h, s, v) {
  return goog.color.rgbArrayToHex(goog.color.hsvToRgb(h, s, v));
};
goog.color.hsvArrayToHex = function(hsv) {
  return goog.color.hsvToHex(hsv[0], hsv[1], hsv[2]);
};
goog.color.hslDistance = function(hsl1, hsl2) {
  var sl1, sl2;
  if (hsl1[2] <= 0.5) {
    sl1 = hsl1[1] * hsl1[2];
  } else {
    sl1 = hsl1[1] * (1.0 - hsl1[2]);
  }
  if (hsl2[2] <= 0.5) {
    sl2 = hsl2[1] * hsl2[2];
  } else {
    sl2 = hsl2[1] * (1.0 - hsl2[2]);
  }
  var h1 = hsl1[0] / 360.0;
  var h2 = hsl2[0] / 360.0;
  var dh = (h1 - h2) * 2.0 * Math.PI;
  return (hsl1[2] - hsl2[2]) * (hsl1[2] - hsl2[2]) +
      sl1 * sl1 + sl2 * sl2 - 2 * sl1 * sl2 * Math.cos(dh);
};
goog.color.blend = function(rgb1, rgb2, factor) {
  factor = goog.math.clamp(factor, 0, 1);
  return [
    Math.round(factor * rgb1[0] + (1.0 - factor) * rgb2[0]),
    Math.round(factor * rgb1[1] + (1.0 - factor) * rgb2[1]),
    Math.round(factor * rgb1[2] + (1.0 - factor) * rgb2[2])
  ];
};
goog.color.darken = function(rgb, factor) {
  var black = [0, 0, 0];
  return goog.color.blend(black, rgb, factor);
};
goog.color.lighten = function(rgb, factor) {
  var white = [255, 255, 255];
  return goog.color.blend(white, rgb, factor);
};
goog.color.highContrast = function(prime, suggestions) {
  var suggestionsWithDiff = [];
  for (var i = 0; i < suggestions.length; i++) {
    suggestionsWithDiff.push({
      color: suggestions[i],
      diff: goog.color.yiqBrightnessDiff_(suggestions[i], prime) +
          goog.color.colorDiff_(suggestions[i], prime)
    });
  }
  suggestionsWithDiff.sort(function(a, b) {
    return b.diff - a.diff;
  });
  return suggestionsWithDiff[0].color;
};
goog.color.yiqBrightness_ = function(rgb) {
  return Math.round((rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000);
};
goog.color.yiqBrightnessDiff_ = function(rgb1, rgb2) {
  return Math.abs(goog.color.yiqBrightness_(rgb1) -
                  goog.color.yiqBrightness_(rgb2));
};
goog.color.colorDiff_ = function(rgb1, rgb2) {
  return Math.abs(rgb1[0] - rgb2[0]) + Math.abs(rgb1[1] - rgb2[1]) +
      Math.abs(rgb1[2] - rgb2[2]);
};

// goog.fx.TransitionBase
// goog.fx.TransitionBase.State
goog.provide('goog.fx.TransitionBase');
goog.provide('goog.fx.TransitionBase.State');
goog.fx.TransitionBase = function() {
  goog.fx.TransitionBase.base(this, 'constructor');
  this.state_ = goog.fx.TransitionBase.State.STOPPED;
  this.startTime = null;
  this.endTime = null;
};
goog.inherits(goog.fx.TransitionBase, goog.events.EventTarget);
goog.fx.TransitionBase.State = {
  STOPPED: 0,
  PAUSED: -1,
  PLAYING: 1
};
goog.fx.TransitionBase.prototype.play = goog.abstractMethod;
goog.fx.TransitionBase.prototype.stop = goog.abstractMethod;
goog.fx.TransitionBase.prototype.pause = goog.abstractMethod;
goog.fx.TransitionBase.prototype.getStateInternal = function() {
  return this.state_;
};
goog.fx.TransitionBase.prototype.setStatePlaying = function() {
  this.state_ = goog.fx.TransitionBase.State.PLAYING;
};
goog.fx.TransitionBase.prototype.setStatePaused = function() {
  this.state_ = goog.fx.TransitionBase.State.PAUSED;
};
goog.fx.TransitionBase.prototype.setStateStopped = function() {
  this.state_ = goog.fx.TransitionBase.State.STOPPED;
};
goog.fx.TransitionBase.prototype.isPlaying = function() {
  return this.state_ == goog.fx.TransitionBase.State.PLAYING;
};
goog.fx.TransitionBase.prototype.isPaused = function() {
  return this.state_ == goog.fx.TransitionBase.State.PAUSED;
};
goog.fx.TransitionBase.prototype.isStopped = function() {
  return this.state_ == goog.fx.TransitionBase.State.STOPPED;
};
goog.fx.TransitionBase.prototype.onBegin = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.BEGIN);
};
goog.fx.TransitionBase.prototype.onEnd = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.END);
};
goog.fx.TransitionBase.prototype.onFinish = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.FINISH);
};
goog.fx.TransitionBase.prototype.onPause = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.PAUSE);
};
goog.fx.TransitionBase.prototype.onPlay = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.PLAY);
};
goog.fx.TransitionBase.prototype.onResume = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.RESUME);
};
goog.fx.TransitionBase.prototype.onStop = function() {
  this.dispatchAnimationEvent(goog.fx.Transition.EventType.STOP);
};
goog.fx.TransitionBase.prototype.dispatchAnimationEvent = function(type) {
  this.dispatchEvent(type);
};

// goog.async.AnimationDelay
goog.provide('goog.async.AnimationDelay');
goog.async.AnimationDelay = function(listener, opt_window, opt_handler) {
  goog.async.AnimationDelay.base(this, 'constructor');
  this.id_ = null;
  this.usingListeners_ = false;
  this.listener_ = listener;
  this.handler_ = opt_handler;
  this.win_ = opt_window || window;
  this.callback_ = goog.bind(this.doAction_, this);
};
goog.inherits(goog.async.AnimationDelay, goog.Disposable);
goog.async.AnimationDelay.TIMEOUT = 20;
goog.async.AnimationDelay.MOZ_BEFORE_PAINT_EVENT_ = 'MozBeforePaint';
goog.async.AnimationDelay.prototype.start = function() {
  this.stop();
  this.usingListeners_ = false;
  var raf = this.getRaf_();
  var cancelRaf = this.getCancelRaf_();
  if (raf && !cancelRaf && this.win_.mozRequestAnimationFrame) {
    this.id_ = goog.events.listen(
        this.win_,
        goog.async.AnimationDelay.MOZ_BEFORE_PAINT_EVENT_,
        this.callback_);
    this.win_.mozRequestAnimationFrame(null);
    this.usingListeners_ = true;
  } else if (raf && cancelRaf) {
    this.id_ = raf.call(this.win_, this.callback_);
  } else {
    this.id_ = this.win_.setTimeout(
        goog.functions.lock(this.callback_),
        goog.async.AnimationDelay.TIMEOUT);
  }
};
goog.async.AnimationDelay.prototype.stop = function() {
  if (this.isActive()) {
    var raf = this.getRaf_();
    var cancelRaf = this.getCancelRaf_();
    if (raf && !cancelRaf && this.win_.mozRequestAnimationFrame) {
      goog.events.unlistenByKey(this.id_);
    } else if (raf && cancelRaf) {
      cancelRaf.call(this.win_,  (this.id_));
    } else {
      this.win_.clearTimeout( (this.id_));
    }
  }
  this.id_ = null;
};
goog.async.AnimationDelay.prototype.fire = function() {
  this.stop();
  this.doAction_();
};
goog.async.AnimationDelay.prototype.fireIfActive = function() {
  if (this.isActive()) {
    this.fire();
  }
};
goog.async.AnimationDelay.prototype.isActive = function() {
  return this.id_ != null;
};
goog.async.AnimationDelay.prototype.doAction_ = function() {
  if (this.usingListeners_ && this.id_) {
    goog.events.unlistenByKey(this.id_);
  }
  this.id_ = null;
  this.listener_.call(this.handler_, goog.now());
};
goog.async.AnimationDelay.prototype.disposeInternal = function() {
  this.stop();
  goog.async.AnimationDelay.base(this, 'disposeInternal');
};
goog.async.AnimationDelay.prototype.getRaf_ = function() {
  var win = this.win_;
  return win.requestAnimationFrame ||
      win.webkitRequestAnimationFrame ||
      win.mozRequestAnimationFrame ||
      win.oRequestAnimationFrame ||
      win.msRequestAnimationFrame ||
      null;
};
goog.async.AnimationDelay.prototype.getCancelRaf_ = function() {
  var win = this.win_;
  return win.cancelAnimationFrame ||
      win.cancelRequestAnimationFrame ||
      win.webkitCancelRequestAnimationFrame ||
      win.mozCancelRequestAnimationFrame ||
      win.oCancelRequestAnimationFrame ||
      win.msCancelRequestAnimationFrame ||
      null;
};

// goog.fx.anim
// goog.fx.anim.Animated
goog.provide('goog.fx.anim');
goog.provide('goog.fx.anim.Animated');
goog.fx.anim.Animated = function() {};
goog.fx.anim.Animated.prototype.onAnimationFrame;
goog.fx.anim.TIMEOUT = goog.async.AnimationDelay.TIMEOUT;
goog.fx.anim.activeAnimations_ = {};
goog.fx.anim.animationWindow_ = null;
goog.fx.anim.animationDelay_ = null;
goog.fx.anim.registerAnimation = function(animation) {
  var uid = goog.getUid(animation);
  if (!(uid in goog.fx.anim.activeAnimations_)) {
    goog.fx.anim.activeAnimations_[uid] = animation;
  }
  goog.fx.anim.requestAnimationFrame_();
};
goog.fx.anim.unregisterAnimation = function(animation) {
  var uid = goog.getUid(animation);
  delete goog.fx.anim.activeAnimations_[uid];
  if (goog.object.isEmpty(goog.fx.anim.activeAnimations_)) {
    goog.fx.anim.cancelAnimationFrame_();
  }
};
goog.fx.anim.tearDown = function() {
  goog.fx.anim.animationWindow_ = null;
  goog.dispose(goog.fx.anim.animationDelay_);
  goog.fx.anim.animationDelay_ = null;
  goog.fx.anim.activeAnimations_ = {};
};
goog.fx.anim.setAnimationWindow = function(animationWindow) {
  var hasTimer =
      goog.fx.anim.animationDelay_ && goog.fx.anim.animationDelay_.isActive();
  goog.dispose(goog.fx.anim.animationDelay_);
  goog.fx.anim.animationDelay_ = null;
  goog.fx.anim.animationWindow_ = animationWindow;
  if (hasTimer) {
    goog.fx.anim.requestAnimationFrame_();
  }
};
goog.fx.anim.requestAnimationFrame_ = function() {
  if (!goog.fx.anim.animationDelay_) {
    if (goog.fx.anim.animationWindow_) {
      goog.fx.anim.animationDelay_ = new goog.async.AnimationDelay(
          function(now) {
            goog.fx.anim.cycleAnimations_(now);
          }, goog.fx.anim.animationWindow_);
    } else {
      goog.fx.anim.animationDelay_ = new goog.async.Delay(function() {
        goog.fx.anim.cycleAnimations_(goog.now());
      }, goog.fx.anim.TIMEOUT);
    }
  }
  var delay = goog.fx.anim.animationDelay_;
  if (!delay.isActive()) {
    delay.start();
  }
};
goog.fx.anim.cancelAnimationFrame_ = function() {
  if (goog.fx.anim.animationDelay_) {
    goog.fx.anim.animationDelay_.stop();
  }
};
goog.fx.anim.cycleAnimations_ = function(now) {
  goog.object.forEach(goog.fx.anim.activeAnimations_, function(anim) {
    anim.onAnimationFrame(now);
  });
  if (!goog.object.isEmpty(goog.fx.anim.activeAnimations_)) {
    goog.fx.anim.requestAnimationFrame_();
  }
};

// goog.fx.Animation
// goog.fx.Animation.EventType
// goog.fx.Animation.State
// goog.fx.AnimationEvent
goog.provide('goog.fx.Animation');
goog.provide('goog.fx.Animation.EventType');
goog.provide('goog.fx.Animation.State');
goog.provide('goog.fx.AnimationEvent');
goog.fx.Animation = function(start, end, duration, opt_acc) {
  goog.fx.Animation.base(this, 'constructor');
  if (!goog.isArray(start) || !goog.isArray(end)) {
    throw Error('Start and end parameters must be arrays');
  }
  if (start.length != end.length) {
    throw Error('Start and end points must be the same length');
  }
  this.startPoint = start;
  this.endPoint = end;
  this.duration = duration;
  this.accel_ = opt_acc;
  this.coords = [];
  this.useRightPositioningForRtl_ = false;
  this.fps_ = 0;
  this.progress = 0;
  this.lastFrame = null;
};
goog.inherits(goog.fx.Animation, goog.fx.TransitionBase);
goog.fx.Animation.prototype.enableRightPositioningForRtl =
    function(useRightPositioningForRtl) {
  this.useRightPositioningForRtl_ = useRightPositioningForRtl;
};
goog.fx.Animation.prototype.isRightPositioningForRtlEnabled = function() {
  return this.useRightPositioningForRtl_;
};
goog.fx.Animation.EventType = {
  PLAY: goog.fx.Transition.EventType.PLAY,
  BEGIN: goog.fx.Transition.EventType.BEGIN,
  RESUME: goog.fx.Transition.EventType.RESUME,
  END: goog.fx.Transition.EventType.END,
  STOP: goog.fx.Transition.EventType.STOP,
  FINISH: goog.fx.Transition.EventType.FINISH,
  PAUSE: goog.fx.Transition.EventType.PAUSE,
  ANIMATE: 'animate',
  DESTROY: 'destroy'
};
goog.fx.Animation.TIMEOUT = goog.fx.anim.TIMEOUT;
goog.fx.Animation.State = goog.fx.TransitionBase.State;
goog.fx.Animation.setAnimationWindow = function(animationWindow) {
  goog.fx.anim.setAnimationWindow(animationWindow);
};
goog.fx.Animation.prototype.play = function(opt_restart) {
  if (opt_restart || this.isStopped()) {
    this.progress = 0;
    this.coords = this.startPoint;
  } else if (this.isPlaying()) {
    return false;
  }
  goog.fx.anim.unregisterAnimation(this);
  var now =  (goog.now());
  this.startTime = now;
  if (this.isPaused()) {
    this.startTime -= this.duration * this.progress;
  }
  this.endTime = this.startTime + this.duration;
  this.lastFrame = this.startTime;
  if (!this.progress) {
    this.onBegin();
  }
  this.onPlay();
  if (this.isPaused()) {
    this.onResume();
  }
  this.setStatePlaying();
  goog.fx.anim.registerAnimation(this);
  this.cycle(now);
  return true;
};
goog.fx.Animation.prototype.stop = function(opt_gotoEnd) {
  goog.fx.anim.unregisterAnimation(this);
  this.setStateStopped();
  if (!!opt_gotoEnd) {
    this.progress = 1;
  }
  this.updateCoords_(this.progress);
  this.onStop();
  this.onEnd();
};
goog.fx.Animation.prototype.pause = function() {
  if (this.isPlaying()) {
    goog.fx.anim.unregisterAnimation(this);
    this.setStatePaused();
    this.onPause();
  }
};
goog.fx.Animation.prototype.getProgress = function() {
  return this.progress;
};
goog.fx.Animation.prototype.setProgress = function(progress) {
  this.progress = progress;
  if (this.isPlaying()) {
    var now = goog.now();
    this.startTime = now - this.duration * this.progress;
    this.endTime = this.startTime + this.duration;
  }
};
goog.fx.Animation.prototype.disposeInternal = function() {
  if (!this.isStopped()) {
    this.stop(false);
  }
  this.onDestroy();
  goog.fx.Animation.base(this, 'disposeInternal');
};
goog.fx.Animation.prototype.destroy = function() {
  this.dispose();
};
goog.fx.Animation.prototype.onAnimationFrame = function(now) {
  this.cycle(now);
};
goog.fx.Animation.prototype.cycle = function(now) {
  this.progress = (now - this.startTime) / (this.endTime - this.startTime);
  if (this.progress >= 1) {
    this.progress = 1;
  }
  this.fps_ = 1000 / (now - this.lastFrame);
  this.lastFrame = now;
  this.updateCoords_(this.progress);
  if (this.progress == 1) {
    this.setStateStopped();
    goog.fx.anim.unregisterAnimation(this);
    this.onFinish();
    this.onEnd();
  } else if (this.isPlaying()) {
    this.onAnimate();
  }
};
goog.fx.Animation.prototype.updateCoords_ = function(t) {
  if (goog.isFunction(this.accel_)) {
    t = this.accel_(t);
  }
  this.coords = new Array(this.startPoint.length);
  for (var i = 0; i < this.startPoint.length; i++) {
    this.coords[i] = (this.endPoint[i] - this.startPoint[i]) * t +
        this.startPoint[i];
  }
};
goog.fx.Animation.prototype.onAnimate = function() {
  this.dispatchAnimationEvent(goog.fx.Animation.EventType.ANIMATE);
};
goog.fx.Animation.prototype.onDestroy = function() {
  this.dispatchAnimationEvent(goog.fx.Animation.EventType.DESTROY);
};
goog.fx.Animation.prototype.dispatchAnimationEvent = function(type) {
  this.dispatchEvent(new goog.fx.AnimationEvent(type, this));
};
goog.fx.AnimationEvent = function(type, anim) {
  goog.fx.AnimationEvent.base(this, 'constructor', type);
  this.coords = anim.coords;
  this.x = anim.coords[0];
  this.y = anim.coords[1];
  this.z = anim.coords[2];
  this.duration = anim.duration;
  this.progress = anim.getProgress();
  this.fps = anim.fps_;
  this.state = anim.getStateInternal();
  this.anim = anim;
};
goog.inherits(goog.fx.AnimationEvent, goog.events.Event);
goog.fx.AnimationEvent.prototype.coordsAsInts = function() {
  return goog.array.map(this.coords, Math.round);
};

// goog.fx.dom
// goog.fx.dom.BgColorTransform
// goog.fx.dom.ColorTransform
// goog.fx.dom.Fade
// goog.fx.dom.FadeIn
// goog.fx.dom.FadeInAndShow
// goog.fx.dom.FadeOut
// goog.fx.dom.FadeOutAndHide
// goog.fx.dom.PredefinedEffect
// goog.fx.dom.Resize
// goog.fx.dom.ResizeHeight
// goog.fx.dom.ResizeWidth
// goog.fx.dom.Scroll
// goog.fx.dom.Slide
// goog.fx.dom.SlideFrom
// goog.fx.dom.Swipe
goog.provide('goog.fx.dom');
goog.provide('goog.fx.dom.BgColorTransform');
goog.provide('goog.fx.dom.ColorTransform');
goog.provide('goog.fx.dom.Fade');
goog.provide('goog.fx.dom.FadeIn');
goog.provide('goog.fx.dom.FadeInAndShow');
goog.provide('goog.fx.dom.FadeOut');
goog.provide('goog.fx.dom.FadeOutAndHide');
goog.provide('goog.fx.dom.PredefinedEffect');
goog.provide('goog.fx.dom.Resize');
goog.provide('goog.fx.dom.ResizeHeight');
goog.provide('goog.fx.dom.ResizeWidth');
goog.provide('goog.fx.dom.Scroll');
goog.provide('goog.fx.dom.Slide');
goog.provide('goog.fx.dom.SlideFrom');
goog.provide('goog.fx.dom.Swipe');
goog.fx.dom.PredefinedEffect = function(element, start, end, time, opt_acc) {
  goog.fx.Animation.call(this, start, end, time, opt_acc);
  this.element = element;
  this.rightToLeft_;
};
goog.inherits(goog.fx.dom.PredefinedEffect, goog.fx.Animation);
goog.fx.dom.PredefinedEffect.prototype.updateStyle = goog.nullFunction;
goog.fx.dom.PredefinedEffect.prototype.isRightToLeft = function() {
  if (!goog.isDef(this.rightToLeft_)) {
    this.rightToLeft_ = goog.style.isRightToLeft(this.element);
  }
  return this.rightToLeft_;
};
goog.fx.dom.PredefinedEffect.prototype.onAnimate = function() {
  this.updateStyle();
  goog.fx.dom.PredefinedEffect.superClass_.onAnimate.call(this);
};
goog.fx.dom.PredefinedEffect.prototype.onEnd = function() {
  this.updateStyle();
  goog.fx.dom.PredefinedEffect.superClass_.onEnd.call(this);
};
goog.fx.dom.PredefinedEffect.prototype.onBegin = function() {
  this.updateStyle();
  goog.fx.dom.PredefinedEffect.superClass_.onBegin.call(this);
};
goog.fx.dom.Slide = function(element, start, end, time, opt_acc) {
  if (start.length != 2 || end.length != 2) {
    throw Error('Start and end points must be 2D');
  }
  goog.fx.dom.PredefinedEffect.apply(this, arguments);
};
goog.inherits(goog.fx.dom.Slide, goog.fx.dom.PredefinedEffect);
goog.fx.dom.Slide.prototype.updateStyle = function() {
  var pos = (this.isRightPositioningForRtlEnabled() && this.isRightToLeft()) ?
      'right' : 'left';
  this.element.style[pos] = Math.round(this.coords[0]) + 'px';
  this.element.style.top = Math.round(this.coords[1]) + 'px';
};
goog.fx.dom.SlideFrom = function(element, end, time, opt_acc) {
  this.startPoint;
  var offsetLeft = this.isRightPositioningForRtlEnabled() ?
      goog.style.bidi.getOffsetStart(element) :
       (element).offsetLeft;
  var start = [offsetLeft,  (element).offsetTop];
  goog.fx.dom.Slide.call(this, element, start, end, time, opt_acc);
};
goog.inherits(goog.fx.dom.SlideFrom, goog.fx.dom.Slide);
goog.fx.dom.SlideFrom.prototype.onBegin = function() {
  var offsetLeft = this.isRightPositioningForRtlEnabled() ?
      goog.style.bidi.getOffsetStart(this.element) : this.element.offsetLeft;
  this.startPoint = [offsetLeft,
                      (this.element).offsetTop];
  goog.fx.dom.SlideFrom.superClass_.onBegin.call(this);
};
goog.fx.dom.Swipe = function(element, start, end, time, opt_acc) {
  if (start.length != 2 || end.length != 2) {
    throw Error('Start and end points must be 2D');
  }
  goog.fx.dom.PredefinedEffect.apply(this, arguments);
  this.maxWidth_ = Math.max(this.endPoint[0], this.startPoint[0]);
  this.maxHeight_ = Math.max(this.endPoint[1], this.startPoint[1]);
};
goog.inherits(goog.fx.dom.Swipe, goog.fx.dom.PredefinedEffect);
goog.fx.dom.Swipe.prototype.updateStyle = function() {
  var x = this.coords[0];
  var y = this.coords[1];
  this.clip_(Math.round(x), Math.round(y), this.maxWidth_, this.maxHeight_);
  this.element.style.width = Math.round(x) + 'px';
  var marginX = (this.isRightPositioningForRtlEnabled() &&
      this.isRightToLeft()) ? 'marginRight' : 'marginLeft';
  this.element.style[marginX] = Math.round(x) - this.maxWidth_ + 'px';
  this.element.style.marginTop = Math.round(y) - this.maxHeight_ + 'px';
};
goog.fx.dom.Swipe.prototype.clip_ = function(x, y, w, h) {
  this.element.style.clip =
      'rect(' + (h - y) + 'px ' + w + 'px ' + h + 'px ' + (w - x) + 'px)';
};
goog.fx.dom.Scroll = function(element, start, end, time, opt_acc) {
  if (start.length != 2 || end.length != 2) {
    throw Error('Start and end points must be 2D');
  }
  goog.fx.dom.PredefinedEffect.apply(this, arguments);
};
goog.inherits(goog.fx.dom.Scroll, goog.fx.dom.PredefinedEffect);
goog.fx.dom.Scroll.prototype.updateStyle = function() {
  if (this.isRightPositioningForRtlEnabled()) {
    goog.style.bidi.setScrollOffset(this.element, Math.round(this.coords[0]));
  } else {
    this.element.scrollLeft = Math.round(this.coords[0]);
  }
  this.element.scrollTop = Math.round(this.coords[1]);
};
goog.fx.dom.Resize = function(element, start, end, time, opt_acc) {
  if (start.length != 2 || end.length != 2) {
    throw Error('Start and end points must be 2D');
  }
  goog.fx.dom.PredefinedEffect.apply(this, arguments);
};
goog.inherits(goog.fx.dom.Resize, goog.fx.dom.PredefinedEffect);
goog.fx.dom.Resize.prototype.updateStyle = function() {
  this.element.style.width = Math.round(this.coords[0]) + 'px';
  this.element.style.height = Math.round(this.coords[1]) + 'px';
};
goog.fx.dom.ResizeWidth = function(element, start, end, time, opt_acc) {
  goog.fx.dom.PredefinedEffect.call(this, element, [start],
                                    [end], time, opt_acc);
};
goog.inherits(goog.fx.dom.ResizeWidth, goog.fx.dom.PredefinedEffect);
goog.fx.dom.ResizeWidth.prototype.updateStyle = function() {
  this.element.style.width = Math.round(this.coords[0]) + 'px';
};
goog.fx.dom.ResizeHeight = function(element, start, end, time, opt_acc) {
  goog.fx.dom.PredefinedEffect.call(this, element, [start],
                                    [end], time, opt_acc);
};
goog.inherits(goog.fx.dom.ResizeHeight, goog.fx.dom.PredefinedEffect);
goog.fx.dom.ResizeHeight.prototype.updateStyle = function() {
  this.element.style.height = Math.round(this.coords[0]) + 'px';
};
goog.fx.dom.Fade = function(element, start, end, time, opt_acc) {
  if (goog.isNumber(start)) start = [start];
  if (goog.isNumber(end)) end = [end];
  goog.fx.dom.Fade.base(this, 'constructor',
      element, start, end, time, opt_acc);
  if (start.length != 1 || end.length != 1) {
    throw Error('Start and end points must be 1D');
  }
  this.lastOpacityUpdate_ = goog.fx.dom.Fade.OPACITY_UNSET_;
};
goog.inherits(goog.fx.dom.Fade, goog.fx.dom.PredefinedEffect);
goog.fx.dom.Fade.TOLERANCE_ = 1.0 / 0x400;  // 10-bit color
goog.fx.dom.Fade.OPACITY_UNSET_ = -1;
goog.fx.dom.Fade.prototype.updateStyle = function() {
  var opacity = this.coords[0];
  var delta = Math.abs(opacity - this.lastOpacityUpdate_);
  if (delta >= goog.fx.dom.Fade.TOLERANCE_) {
    goog.style.setOpacity(this.element, opacity);
    this.lastOpacityUpdate_ = opacity;
  }
};
goog.fx.dom.Fade.prototype.onBegin = function() {
  this.lastOpacityUpdate_ = goog.fx.dom.Fade.OPACITY_UNSET_;
  goog.fx.dom.Fade.base(this, 'onBegin');
};
goog.fx.dom.Fade.prototype.onEnd = function() {
  this.lastOpacityUpdate_ = goog.fx.dom.Fade.OPACITY_UNSET_;
  goog.fx.dom.Fade.base(this, 'onEnd');
};
goog.fx.dom.Fade.prototype.show = function() {
  this.element.style.display = '';
};
goog.fx.dom.Fade.prototype.hide = function() {
  this.element.style.display = 'none';
};
goog.fx.dom.FadeOut = function(element, time, opt_acc) {
  goog.fx.dom.Fade.call(this, element, 1, 0, time, opt_acc);
};
goog.inherits(goog.fx.dom.FadeOut, goog.fx.dom.Fade);
goog.fx.dom.FadeIn = function(element, time, opt_acc) {
  goog.fx.dom.Fade.call(this, element, 0, 1, time, opt_acc);
};
goog.inherits(goog.fx.dom.FadeIn, goog.fx.dom.Fade);
goog.fx.dom.FadeOutAndHide = function(element, time, opt_acc) {
  goog.fx.dom.Fade.call(this, element, 1, 0, time, opt_acc);
};
goog.inherits(goog.fx.dom.FadeOutAndHide, goog.fx.dom.Fade);
goog.fx.dom.FadeOutAndHide.prototype.onBegin = function() {
  this.show();
  goog.fx.dom.FadeOutAndHide.superClass_.onBegin.call(this);
};
goog.fx.dom.FadeOutAndHide.prototype.onEnd = function() {
  this.hide();
  goog.fx.dom.FadeOutAndHide.superClass_.onEnd.call(this);
};
goog.fx.dom.FadeInAndShow = function(element, time, opt_acc) {
  goog.fx.dom.Fade.call(this, element, 0, 1, time, opt_acc);
};
goog.inherits(goog.fx.dom.FadeInAndShow, goog.fx.dom.Fade);
goog.fx.dom.FadeInAndShow.prototype.onBegin = function() {
  this.show();
  goog.fx.dom.FadeInAndShow.superClass_.onBegin.call(this);
};
goog.fx.dom.BgColorTransform = function(element, start, end, time, opt_acc) {
  if (start.length != 3 || end.length != 3) {
    throw Error('Start and end points must be 3D');
  }
  goog.fx.dom.PredefinedEffect.apply(this, arguments);
};
goog.inherits(goog.fx.dom.BgColorTransform, goog.fx.dom.PredefinedEffect);
goog.fx.dom.BgColorTransform.prototype.setColor = function() {
  var coordsAsInts = [];
  for (var i = 0; i < this.coords.length; i++) {
    coordsAsInts[i] = Math.round(this.coords[i]);
  }
  var color = 'rgb(' + coordsAsInts.join(',') + ')';
  this.element.style.backgroundColor = color;
};
goog.fx.dom.BgColorTransform.prototype.updateStyle = function() {
  this.setColor();
};
goog.fx.dom.bgColorFadeIn = function(element, start, time, opt_eventHandler) {
  var initialBgColor = element.style.backgroundColor || '';
  var computedBgColor = goog.style.getBackgroundColor(element);
  var end;
  if (computedBgColor && computedBgColor != 'transparent' &&
      computedBgColor != 'rgba(0, 0, 0, 0)') {
    end = goog.color.hexToRgb(goog.color.parse(computedBgColor).hex);
  } else {
    end = [255, 255, 255];
  }
  var anim = new goog.fx.dom.BgColorTransform(element, start, end, time);
  function setBgColor() {
    element.style.backgroundColor = initialBgColor;
  }
  if (opt_eventHandler) {
    opt_eventHandler.listen(
        anim, goog.fx.Transition.EventType.END, setBgColor);
  } else {
    goog.events.listen(
        anim, goog.fx.Transition.EventType.END, setBgColor);
  }
  anim.play();
};
goog.fx.dom.ColorTransform = function(element, start, end, time, opt_acc) {
  if (start.length != 3 || end.length != 3) {
    throw Error('Start and end points must be 3D');
  }
  goog.fx.dom.PredefinedEffect.apply(this, arguments);
};
goog.inherits(goog.fx.dom.ColorTransform, goog.fx.dom.PredefinedEffect);
goog.fx.dom.ColorTransform.prototype.updateStyle = function() {
  var coordsAsInts = [];
  for (var i = 0; i < this.coords.length; i++) {
    coordsAsInts[i] = Math.round(this.coords[i]);
  }
  var color = 'rgb(' + coordsAsInts.join(',') + ')';
  this.element.style.color = color;
};

// i18n.input.chrome.inputview.elements.content.SwipeView
goog.provide('i18n.input.chrome.inputview.elements.content.SwipeView');
goog.scope(function() {
var CandidateView = i18n.input.chrome.inputview.elements.content.CandidateView;
var ContextType = i18n.input.chrome.message.ContextType;
var Css = i18n.input.chrome.inputview.Css;
var ElementType = i18n.input.chrome.ElementType;
var EventType = i18n.input.chrome.inputview.events.EventType;
var KeyCodes = i18n.input.chrome.events.KeyCodes;
var SwipeDirection = i18n.input.chrome.inputview.SwipeDirection;
var content = i18n.input.chrome.inputview.elements.content;
i18n.input.chrome.inputview.elements.content.SwipeView = function(
    adapter, candidateView, opt_eventTarget) {
  i18n.input.chrome.inputview.elements.content.SwipeView.base(
      this, 'constructor', '', ElementType.SWIPE_VIEW, opt_eventTarget);
  this.adapter_ = adapter;
  this.candidateView_ = candidateView;
  this.trackElements_ = [];
  this.surroundingText_ = '';
  this.surroundingTextOffset_ = 0;
  this.deletedWords_ = [];
  this.pointerHandler_ = new i18n.input.chrome.inputview.handler
      .PointerHandler();
  this.coverElement_;
  this.fingerTracker_;
  this.ripple_;
  this.highlightIndex_ = SwipeView.INVALID_INDEX_;
  this.triggeredBy;
  this.tracking_ = false;
  this.armed_ = false;
  this.enabled = false;
  this.isKeysetSupported_ = false;
  this.fadeAnimation_;
  this.scaleAnimation_;
  this.statistics_ = i18n.input.chrome.Statistics.getInstance();
  this.isSelection_ = true;
  this.eventIdentifier_;
  this.initialSurroundingText_ = '';
  this.initialSurroundingTextLength_ = 0;
  this.noopCount_ = 0;
  this.logger_ = goog.log.getLogger(
      'i18n.input.chrome.inputview.elements.content.SwipeView');
};
goog.inherits(i18n.input.chrome.inputview.elements.content.SwipeView,
    i18n.input.chrome.inputview.elements.Element);
var SwipeView = i18n.input.chrome.inputview.elements.content.SwipeView;
SwipeView.LENGTH_ = 15;
SwipeView.INVALID_INDEX_ = -1;
SwipeView.FINGER_DISTANCE_TO_CANCEL_SWIPE_ = 100;
SwipeView.SEGMENT_WIDTH_ = 40;
SwipeView.NBSP_CHAR_ = String.fromCharCode(160);
SwipeView.FINGER_TRACKER_WIDTH_ = 64;
SwipeView.RIPPLE_WIDTH_ = 22;
SwipeView.SCALE_ANIMATION_TIME_ = 220;
SwipeView.RIPPLE_SCALE_FACTOR_ = 24;
SwipeView.FADE_ANIMATION_TIME_ = 200;
SwipeView.Tooltip = {
  SELECTION: chrome.i18n.getMessage('SWIPE_SELECTION_TOOLTIP'),
  DELETION: chrome.i18n.getMessage('SWIPE_DELETION_TOOLTIP'),
  RESTORATION: chrome.i18n.getMessage('SWIPE_RESTORATION_TOOLTIP')
};
var Tooltip = SwipeView.Tooltip;
SwipeView.prototype.isArmed = function() {
  return this.armed_;
};
SwipeView.prototype.onSurroundingTextChanged_ = function(e) {
  if (this.adapter_.isPasswordBox()) {
    this.surroundingText_ = '';
    this.surroundingTextOffset_ = 0;
    return;
  }
  var text = e.textBeforeCursor || '';
  if (this.surroundingText_ == text &&
      this.surroundingTextOffset_ == e.offset) {
    return;
  }
  var oldText = this.surroundingText_;
  var oldOffset = this.surroundingTextOffset_;
  this.surroundingTextOffset_ = e.offset;
  this.surroundingText_ = text;
  if (e.anchor != e.focus) {
    return;
  }
  var diff = '';
  var delta = (oldText.length + oldOffset) -
      (text.length + e.offset);
  if (delta > 0) {
    if (delta <= oldText.length) {
      diff = oldText.slice(-delta);
    } else {
      return;
    }
  } else if (delta < 0) {
    var restored = text.slice(delta);
    var letter = restored[0];
    if (letter == SwipeView.NBSP_CHAR_) {
      var lastDelete = this.deletedWords_.pop();
      if (lastDelete) {
        var firstChar = lastDelete[0] || '';
        if (firstChar != ' ') {
          this.deletedWords_.push(lastDelete);
        } else {
          this.deletedWords_.push(lastDelete.slice(1));
        }
      }
    }
  } else {
    goog.log.warning(this.logger_, 'Unexpected OSTC event.');
  }
  if (diff) {
    this.deletedWords_.push(diff);
  } else if (!this.isVisible()) {
    this.deletedWords_ = [];
  }
};
SwipeView.prototype.restoreOriginalText_ = function() {
  var restoreLength = (this.initialSurroundingTextLength_) -
      (this.surroundingText_.length + this.surroundingTextOffset_);
  if (restoreLength > 0 &&
      restoreLength <= this.initialSurroundingText_.length) {
    this.adapter_.commitText(
        this.initialSurroundingText_.slice(-restoreLength));
    this.initialSurroundingText_ = '';
    this.initialSurroundingTextLength_ = 0;
    return true;
  }
  return false;
};
SwipeView.prototype.swipeToDelete_ = function(e) {
  var alreadyTracking = this.tracking_;
  var previousIndex = this.getHighlightedIndex();
  var direction = this.swipeOnTrack(e.x, e.y);
  if (!direction) {
    if (!alreadyTracking) {
      this.deletedWords_.reverse();
      var word = this.deletedWords_.join('');
      this.deletedWords_ = [word];
      if (e.direction & SwipeDirection.RIGHT) {
        word = this.deletedWords_.pop();
        if (word) {
          this.adapter_.commitText(word);
        }
      } else {
        this.candidateView_.showTooltip(Tooltip.RESTORATION);
      }
    }
    return;
  }
  this.candidateView_.showTooltip(Tooltip.RESTORATION);
  var delta = Math.abs(this.getHighlightedIndex() - previousIndex);
  if (direction & SwipeDirection.LEFT) {
    for (var i = 0; i < delta; i++) {
      if (this.surroundingText_ == '') {
        this.noopCount_++;
      } else {
        this.adapter_.sendKeyDownAndUpEvent(
            '\u0008', KeyCodes.BACKSPACE, undefined, undefined, {
              ctrl: true,
              shift: false
            });
      }
    }
  } else if (direction & SwipeDirection.RIGHT) {
    for (var i = 0; i < delta; i++) {
      if (this.isAtOrigin()) {
        if (!this.restoreOriginalText_() && this.noopCount_ == 0) {
          this.adapter_.sendKeyDownAndUpEvent(
              '\u007a', KeyCodes.KEY_Z, undefined, undefined, {
                ctrl: true,
                shift: false
              });
        }
        this.noopCount_ = 0;
        break;
      }
      if (this.noopCount_ > 0) {
        this.noopCount_--;
      } else {
        this.adapter_.sendKeyDownAndUpEvent(
            '\u007a', KeyCodes.KEY_Z, undefined, undefined, {
              ctrl: true,
              shift: false
            });
      }
    }
  } else {
    goog.log.warning(this.logger_, 'Unexpected swipe direction: ' + direction);
  }
};
SwipeView.prototype.setKeysetSupported = function(supported) {
  this.isKeysetSupported_ = supported;
};
SwipeView.prototype.swipeToSelect_ = function(e) {
  var previousIndex = this.getHighlightedIndex();
  var direction = this.swipeOnTrack(e.x, e.y);
  if (!direction) {
    return;
  }
  var index = this.getHighlightedIndex();
  if (index == -1) {
    goog.log.warning(this.logger_, 'Invalid track index.');
    return;
  }
  var selectWord = false;
  var code;
  if (direction & SwipeDirection.LEFT) {
    code = KeyCodes.ARROW_LEFT;
  } else if (direction & SwipeDirection.RIGHT) {
    code = KeyCodes.ARROW_RIGHT;
  } else {
    goog.log.warning(this.logger_, 'Unexpected swipe direction: ' + direction);
    return;
  }
  var delta = Math.abs(index - previousIndex);
  if (delta < 0) {
    goog.log.warning(this.logger_, 'Swipe index did not change.');
  }
  for (var i = 0; i < delta; i++) {
    this.adapter_.sendKeyDownAndUpEvent(
        '', code, undefined, undefined, {
          ctrl: true,
          shift: selectWord
        });
  }
};
SwipeView.prototype.handleSwipeAction_ = function(e) {
  if (this.eventIdentifier_ != undefined &&
      this.eventIdentifier_ != e.identifier) {
    return;
  }
  if (this.isVisible()) {
    if (e.view.type == ElementType.BACKSPACE_KEY) {
      this.swipeToDelete_(e);
      return;
    }
    if (e.view.type == ElementType.SELECT_VIEW) {
      this.swipeToSelect_(e);
      return;
    }
  }
  if (e.view.type == ElementType.BACKSPACE_KEY) {
    if (!this.armed_) {
      return;
    }
    if (e.direction & SwipeDirection.LEFT) {
      var key =  (e.view);
      if (this.isDeletionEnabled()) {
        this.showDeletionTrack(key, e.identifier, true);
      }
    } else if (e.direction & SwipeDirection.RIGHT) {
      this.restoreOriginalText_();
      this.armed_ = false;
    }
    return;
  }
};
SwipeView.prototype.handlePointerAction_ = function(e) {
  if (!e.view) {
    return;
  }
  if (this.eventIdentifier_ != undefined &&
      e.identifier != this.eventIdentifier_) {
    return;
  }
  switch (e.view.type) {
    case ElementType.BACKSPACE_KEY:
      var key =  (e.view);
      if (e.type == EventType.POINTER_DOWN) {
        if (this.adapter_.contextType != ContextType.URL) {
          this.armed_ = true;
          this.initialSurroundingText_ = this.surroundingText_;
          this.initialSurroundingTextLength_ =
              this.surroundingText_.length + this.surroundingTextOffset_;
        }
        this.deletedWords_ = [];
      } else if (e.type == EventType.POINTER_UP ||
                 e.type == EventType.POINTER_OUT) {
        if (!this.isVisible()) {
          this.armed_ = false;
        }
      } else if (e.type == EventType.LONG_PRESS) {
        if (this.isDeletionEnabled()) {
          this.showDeletionTrack(key, e.identifier, false);
        }
      }
      break;
    case ElementType.SWIPE_VIEW:
      if (e.type == EventType.POINTER_DOWN &&
          e.target == this.getCoverElement()) {
        this.hide_();
      } else if (e.type == EventType.POINTER_UP ||
                 e.type == EventType.POINTER_OUT) {
        this.hide_();
        this.deletedWords_ = [];
      }
      break;
    case ElementType.SELECT_VIEW:
      if (e.type == EventType.POINTER_DOWN) {
        this.showSelectionTrack(e.x, e.y, e.identifier);
      }
      if (e.type == EventType.POINTER_UP) {
        this.hide_();
      }
      break;
  }
};
SwipeView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.style.setElementShown(elem, false);
  goog.dom.classlist.add(elem, i18n.input.chrome.inputview.Css.SWIPE_VIEW);
  this.coverElement_ = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.TRACK_COVER);
  dom.appendChild(document.body, this.coverElement_);
  goog.style.setElementShown(this.coverElement_, false);
  this.coverElement_['view'] = this;
  this.fingerTracker_ = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.GESTURE_EDITING_FINGER_TRACKER);
  goog.style.setSize(this.fingerTracker_,
      SwipeView.FINGER_TRACKER_WIDTH_ + 'px',
      SwipeView.FINGER_TRACKER_WIDTH_ + 'px');
  this.ripple_ = dom.createDom(goog.dom.TagName.DIV,
      i18n.input.chrome.inputview.Css.GESTURE_RIPPLE);
  dom.appendChild(this.coverElement_, this.ripple_);
  this.fadeAnimation_ = new goog.fx.dom.FadeOut(this.ripple_,
      SwipeView.FADE_ANIMATION_TIME_, goog.fx.easing.easeIn);
  this.scaleAnimation_ = new ScaleAtPoint(this.ripple_,
      [1, 1],
      [SwipeView.RIPPLE_SCALE_FACTOR_, SwipeView.RIPPLE_SCALE_FACTOR_],
      [-SwipeView.RIPPLE_WIDTH_, -SwipeView.RIPPLE_WIDTH_],
      SwipeView.SCALE_ANIMATION_TIME_,
      goog.fx.easing.easeOut);
};
SwipeView.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.getHandler()
      .listen(this.adapter_,
          i18n.input.chrome.inputview.events.EventType
              .SURROUNDING_TEXT_CHANGED,
          this.onSurroundingTextChanged_)
      .listen(this.pointerHandler_, [
        EventType.SWIPE], this.handleSwipeAction_)
      .listen(this.pointerHandler_, [
        EventType.LONG_PRESS,
        EventType.POINTER_UP,
        EventType.POINTER_DOWN,
        EventType.POINTER_OUT], this.handlePointerAction_);
};
SwipeView.prototype.showDeletionTrack_ = function(x, y, width, height) {
  this.tracking_ = false;
  goog.style.setElementShown(this.getElement(), true);
  this.getDomHelper().removeChildren(this.getElement());
  goog.dom.classlist.add(this.getElement(), Css.DELETION_TRACK);
  var totalWidth = ((2 * SwipeView.LENGTH_) - 1) * width;
  this.ltr = true;
  this.highlightIndex_ = 0;
  if ((x + totalWidth) > screen.width) {
    x -= totalWidth;
    this.ltr = false;
    this.highlightIndex_ = SwipeView.LENGTH_ - 1;
  }
  if (width == 0) {
    this.highlightIndex_ = SwipeView.INVALID_INDEX_;
  }
  if (this.ltr) {
    goog.dom.classlist.add(this.getElement(), Css.LEFT_TO_RIGHT);
  }
  for (var i = 0; i < SwipeView.LENGTH_; i++) {
    var keyElem = this.addKey_();
    goog.style.setSize(keyElem, width, height);
    this.trackElements_.push(keyElem);
    if (i != (SwipeView.LENGTH_ - 1)) {
      this.addSeparator_(width, height);
    }
  }
  if (this.ltr) {
    goog.style.setStyle(this.getElement(), {
      'right': 'initial',
      'left': x,
      'top': y
    });
  } else {
    goog.style.setStyle(this.getElement(), {
      'left': 'initial',
      'right': screen.width - x - totalWidth,
      'top': y
    });
  }
  if (this.highlightIndex_ != SwipeView.INVALID_INDEX_) {
    var elem = this.trackElements_[this.highlightIndex_];
    this.setElementBackground_(elem, true);
  }
  if (this.adapter_.contextType == ContextType.NUMBER ||
      this.adapter_.contextType == ContextType.PHONE) {
    goog.dom.classlist.add(this.coverElement_, Css.NUMERIC_LAYOUT);
  } else {
    goog.dom.classlist.remove(this.coverElement_, Css.NUMERIC_LAYOUT);
  }
  goog.style.setElementShown(this.coverElement_, true);
  this.triggeredBy && this.triggeredBy.setHighlighted(true);
};
SwipeView.prototype.showFinger_ = function(x, y) {
  var dom = this.getDomHelper();
  dom.appendChild(this.getElement(), this.fingerTracker_);
  goog.style.setPosition(this.fingerTracker_,
      x - (SwipeView.FINGER_TRACKER_WIDTH_ / 2),
      y - (SwipeView.FINGER_TRACKER_WIDTH_ / 2));
  goog.style.setElementShown(this.fingerTracker_, true);
};
SwipeView.prototype.showSelectionTrack_ = function(x, y, width, height) {
  this.tracking_ = false;
  goog.style.setElementShown(this.getElement(), true);
  this.getDomHelper().removeChildren(this.getElement());
  goog.dom.classlist.add(this.getElement(), Css.SELECTION_TRACK);
  var totalWidth = ((2 * SwipeView.LENGTH_)) * width;
  this.ltr = true;
  this.highlightIndex_ = SwipeView.INVALID_INDEX_;
  if ((x + totalWidth) > screen.width) {
    x -= totalWidth;
    this.ltr = false;
  }
  if (this.ltr) {
    goog.dom.classlist.add(this.getElement(), Css.LEFT_TO_RIGHT);
  }
  for (var i = 0; i < SwipeView.LENGTH_; i++) {
    var keyElem;
    if (!this.ltr) {
      keyElem = this.addKey_();
      goog.style.setSize(keyElem, width, height);
      this.trackElements_.push(keyElem);
    }
    keyElem = this.addSeparator_(width, height);
    goog.style.setSize(keyElem, width, height);
    this.trackElements_.push(keyElem || undefined);
    if (this.ltr) {
      keyElem = this.addKey_();
      goog.style.setSize(keyElem, width, height);
      this.trackElements_.push(keyElem);
    }
  }
  if (this.ltr) {
    goog.style.setStyle(this.getElement(), {
      'right': 'initial',
      'left': x,
      'top': y
    });
  } else {
    goog.style.setStyle(this.getElement(), {
      'left': 'initial',
      'right': 0,
      'top': y
    });
  }
  if (this.adapter_.contextType == ContextType.NUMBER ||
      this.adapter_.contextType == ContextType.PHONE) {
    goog.dom.classlist.add(this.coverElement_, Css.NUMERIC_LAYOUT);
  } else {
    goog.dom.classlist.remove(this.coverElement_, Css.NUMERIC_LAYOUT);
  }
  goog.style.setElementShown(this.coverElement_, true);
  this.triggeredBy && this.triggeredBy.setHighlighted(true);
};
SwipeView.prototype.showDeletionTrack = function(key, id, isSwipe) {
  this.eventIdentifier_ = id;
  this.isSelection_ = false;
  this.adapter_.setGestureEditingInProgress(true, isSwipe);
  this.candidateView_.showTooltip(Tooltip.DELETION);
  this.triggeredBy = key;
  var coordinate = goog.style.getClientPosition(key.getElement());
  if (key.type == ElementType.BACKSPACE_KEY) {
    this.showDeletionTrack_(
        coordinate.x + key.availableWidth,
        coordinate.y,
        SwipeView.SEGMENT_WIDTH_,
        SwipeView.SEGMENT_WIDTH_);
  }
  var centerX = coordinate.x + (key.availableWidth / 2);
  var centerY = coordinate.y + (key.availableHeight / 2);
  this.animateRipple_(centerX, centerY);
  this.showFinger_(centerX, centerY);
};
SwipeView.prototype.showSelectionTrack = function(x, y, id) {
  this.eventIdentifier_ = id;
  this.isSelection_ = true;
  this.adapter_.setGestureEditingInProgress(true);
  this.candidateView_.showTooltip(Tooltip.SELECTION);
  var ltr = (x <= (screen.width / 2));
  var halfWidth = SwipeView.SEGMENT_WIDTH_ / 2;
  var trackY = Math.max(y - halfWidth, halfWidth);
  trackY = Math.min(trackY, window.innerHeight - 3 * halfWidth);
  this.showSelectionTrack_(
      ltr ? 0 : screen.width,
      trackY,
      SwipeView.SEGMENT_WIDTH_,
      SwipeView.SEGMENT_WIDTH_);
  this.showFinger_(x, y);
};
var ScaleAtPoint = function(element, start, end, origin, time, opt_acc) {
  if (start.length != 2 || end.length != 2 || origin.length != 2) {
    throw Error('Start, end and origin arrays must be 2D');
  }
  this.origin_ = origin;
  ScaleAtPoint.base(this, 'constructor', element, start, end, time, opt_acc);
};
goog.inherits(ScaleAtPoint, goog.fx.dom.PredefinedEffect);
ScaleAtPoint.prototype.updateStyle = function() {
  var transform = [
    'translate(', this.origin_[0], 'px, ', this.origin_[1], 'px) ',
    'scale(', this.coords[0], ', ', this.coords[1], ')'
  ].join('');
  goog.style.setStyle(this.element, 'transform', transform);
};
SwipeView.prototype.onFadeStarted_ = function() {
  goog.events.unlisten(this.fadeAnimation_,
      goog.fx.Transition.EventType.BEGIN,
      this.onFadeStarted_);
  this.scaleAnimation_.play();
};
SwipeView.prototype.animateRipple_ = function(x, y) {
  goog.style.setPosition(this.ripple_, x, y);
  goog.style.setStyle(this.ripple_, 'transform', '');
  goog.style.setElementShown(this.ripple_, true);
  goog.events.listen(this.fadeAnimation_, goog.fx.Transition.EventType.BEGIN,
      this.onFadeStarted_.bind(this));
  this.fadeAnimation_.play();
};
SwipeView.prototype.hide_ = function() {
  this.adapter_.setGestureEditingInProgress(false);
  this.candidateView_.hideTooltip();
  goog.style.setElementShown(this.ripple_, false);
  this.armed_ = false;
  this.trackElements_ = [];
  this.tracking_ = false;
  this.eventIdentifier_ = undefined;
  this.noopCount_ = 0;
  this.initialSurroundingText_ = '';
  this.initialSurroundingTextLength_ = 0;
  if (this.triggeredBy) {
    this.triggeredBy.setHighlighted(false);
  }
  this.triggeredBy = undefined;
  goog.style.setElementShown(this.getElement(), false);
  goog.style.setElementShown(this.coverElement_, false);
  this.highlightIndex_ = SwipeView.INVALID_INDEX_;
  goog.dom.classlist.removeAll(this.getElement(), [
    Css.SWIPE_ACTIVE, Css.SELECTION_TRACK, Css.DELETION_TRACK,
    Css.LEFT_TO_RIGHT
  ]);
};
SwipeView.prototype.isAtOrigin = function() {
  return this.ltr ? this.highlightIndex_ == 0 :
      this.highlightIndex_ == SwipeView.LENGTH_ - 1;
};
SwipeView.prototype.swipeOnTrack = function(x, y) {
  var previousIndex = this.highlightIndex_;
  for (var i = 0; i < this.trackElements_.length; i++) {
    var elem = this.trackElements_[i];
    var coordinate = goog.style.getClientPosition(elem);
    var size = goog.style.getSize(elem);
    var visible = (goog.style.getComputedStyle(elem, 'display') != 'none');
    if (visible && coordinate.x < x && (coordinate.x + size.width) > x) {
      this.highlightIndex_ = i;
      this.clearAllHighlights_();
      this.setElementBackground_(elem, true);
      goog.dom.classlist.add(this.getElement(), Css.SWIPE_ACTIVE);
    }
  }
  var changed = previousIndex != this.highlightIndex_;
  this.tracking_ = this.tracking_ || changed;
  goog.style.setPosition(this.fingerTracker_,
      x - (SwipeView.FINGER_TRACKER_WIDTH_ / 2),
      y - (SwipeView.FINGER_TRACKER_WIDTH_ / 2));
  if (!changed || previousIndex == SwipeView.INVALID_INDEX_) {
    return undefined;
  }
  return previousIndex < this.highlightIndex_ ?
      SwipeDirection.RIGHT : SwipeDirection.LEFT;
};
SwipeView.prototype.clearAllHighlights_ = function() {
  for (var i = 0; i < this.trackElements_.length; i++) {
    this.setElementBackground_(this.trackElements_[i], false);
  }
};
SwipeView.prototype.setElementBackground_ =
    function(element, highlight) {
  if (highlight) {
    goog.dom.classlist.add(element, Css.ELEMENT_HIGHLIGHT);
  } else {
    goog.dom.classlist.remove(element, Css.ELEMENT_HIGHLIGHT);
  }
};
SwipeView.prototype.addKey_ = function(opt_character, opt_icon_css) {
  var dom = this.getDomHelper();
  var character = opt_character &&
      i18n.input.chrome.inputview.util.getVisibleCharacter(opt_character);
  var keyElem;
  if (character) {
    keyElem = dom.createDom(goog.dom.TagName.DIV, Css.SWIPE_KEY, character);
  } else {
    keyElem = dom.createDom(goog.dom.TagName.DIV, Css.SWIPE_KEY);
  }
  goog.dom.classlist.add(keyElem, Css.SWIPE_PIECE);
  if (opt_icon_css) {
    var child = dom.createDom(goog.dom.TagName.DIV, opt_icon_css);
    dom.appendChild(keyElem, child);
  }
  dom.appendChild(this.getElement(), keyElem);
  return keyElem;
};
SwipeView.prototype.addSeparator_ = function(width, height) {
  var dom = this.getDomHelper();
  var separator = dom.createDom(goog.dom.TagName.DIV, Css.SWIPE_SEPARATOR);
  goog.style.setSize(separator, width + 'px', height + 'px');
  goog.dom.classlist.add(separator, Css.SWIPE_PIECE);
  dom.appendChild(this.getElement(), separator);
  return separator;
};
SwipeView.prototype.getCoverElement = function() {
  return this.coverElement_;
};
SwipeView.prototype.getHighlightedIndex = function() {
  if (this.highlightIndex_ == SwipeView.INVALID_INDEX_) {
    return SwipeView.INVALID_INDEX_;
  }
  if (this.ltr) {
    return this.highlightIndex_;
  }
  return this.trackElements_.length - this.highlightIndex_ - 1;
};
SwipeView.prototype.isDeletionEnabled = function() {
  if (this.adapter_.contextType == ContextType.URL) {
    return false;
  }
  if (this.adapter_.isGoogleMail()) {
    return false;
  }
  if (this.adapter_.isPasswordBox()) {
    return false;
  }
  if (this.adapter_.isA11yMode) {
    return false;
  }
  if (!this.isKeysetSupported_) {
    return false;
  }
  return this.enabled;
};
SwipeView.prototype.resize = function(width, height) {
  goog.base(this, 'resize', width, height);
  goog.style.setSize(this.coverElement_, width, height);
};
SwipeView.prototype.reset = function() {
  this.deletedWords_ = [];
  this.surroundingText_ = '';
  this.hide_();
};
SwipeView.prototype.disposeInternal = function() {
  goog.dispose(this.pointerHandler_);
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.sounds.Sounds
goog.provide('i18n.input.chrome.sounds.Sounds');
i18n.input.chrome.sounds.Sounds = {
  DELETE: 'KeypressDelete',
  RETURN: 'KeypressReturn',
  SPACEBAR: 'KeypressSpacebar',
  STANDARD: 'KeypressStandard',
  NONE: 'none',
  VOICE_RECOG_START: 'audio_initiate',
  VOICE_RECOG_END: 'audio_end',
  AUTO_CORRECTION: 'KeypressStandard'
};

// i18n.input.chrome.inputview.elements.content.VoiceView
goog.provide('i18n.input.chrome.inputview.elements.content.VoiceView');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var ElementType = i18n.input.chrome.ElementType;
var FunctionalKey = i18n.input.chrome.inputview.elements.content.FunctionalKey;
var Name = i18n.input.chrome.message.Name;
var Sounds = i18n.input.chrome.sounds.Sounds;
var SpanElement = i18n.input.chrome.inputview.elements.content.SpanElement;
var TagName = goog.dom.TagName;
var Type = i18n.input.chrome.message.Type;
i18n.input.chrome.inputview.elements.content.VoiceView =
    function(opt_eventTarget, opt_adapter, opt_soundController) {
  VoiceView.base(this, 'constructor', '', ElementType.VOICE_VIEW,
      opt_eventTarget);
  this.adapter_ = goog.asserts.assertObject(opt_adapter);
  this.soundController_ = goog.asserts.assertObject(opt_soundController);
  this.animator_ = new goog.async.Delay(this.animateMicrophoneLevel_, 0, this);
};
var VoiceView = i18n.input.chrome.inputview.elements.content.VoiceView;
goog.inherits(VoiceView, i18n.input.chrome.inputview.elements.Element);
VoiceView.WIDTH_ = 150;
VoiceView.prototype.isPrivacyAllowed_ = false;
VoiceView.prototype.maskElem_ = null;
VoiceView.prototype.voiceMicElem_ = null;
VoiceView.prototype.levelElement_ = null;
VoiceView.prototype.voicePanel_ = null;
VoiceView.prototype.privacyDiv_;
VoiceView.prototype.visible_ = false;
VoiceView.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var dom = this.getDomHelper();
  var elem = this.getElement();
  goog.dom.classlist.add(elem, Css.VOICE_VIEW);
  this.voicePanel_ = dom.createDom(TagName.DIV, Css.VOICE_PANEL);
  this.voiceMicElem_ = dom.createDom(TagName.DIV,
      Css.VOICE_OPACITY + ' ' + Css.VOICE_MIC_ING);
  this.levelElement_ = dom.createDom(
      TagName.DIV, Css.VOICE_LEVEL);
  dom.append( (this.voicePanel_),
      this.voiceMicElem_, this.levelElement_);
  this.maskElem_ = dom.createDom(TagName.DIV,
      [Css.VOICE_MASK, Css.VOICE_OPACITY_NONE]);
  dom.append( (elem), this.maskElem_, this.voicePanel_);
  this.privacyDiv_ = dom.createDom(TagName.DIV,
      Css.VOICE_PRIVACY_INFO);
  var textDiv = dom.createDom(TagName.SPAN);
  dom.setTextContent(textDiv,
      chrome.i18n.getMessage('VOICE_PRIVACY_INFO'));
  dom.appendChild(this.privacyDiv_, textDiv);
  var spanView = new SpanElement('', ElementType.VOICE_PRIVACY_GOT_IT);
  spanView.render(this.privacyDiv_);
  var spanElement = spanView.getElement();
  goog.dom.classlist.add(spanElement, Css.VOICE_GOT_IT);
  dom.setTextContent(spanElement, chrome.i18n.getMessage('GOT_IT'));
  dom.appendChild(elem, this.privacyDiv_);
  this.isPrivacyAllowed_ = !!localStorage.getItem(Name.VOICE_PRIVACY_INFO);
  if (this.isPrivacyAllowed_) {
    goog.dom.classlist.add(this.privacyDiv_,
        Css.HANDWRITING_PRIVACY_INFO_HIDDEN);
    goog.dom.classlist.remove(this.maskElem_, Css.VOICE_OPACITY_NONE);
  }
};
VoiceView.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');
  this.getHandler().listen(this.adapter_, Type.VOICE_PRIVACY_GOT_IT,
      this.onConfirmPrivacyInfo_);
};
VoiceView.prototype.start = function() {
  if (!this.isVisible()) {
    this.soundController_.playSound(Sounds.VOICE_RECOG_START, true);
  }
  if (this.isPrivacyAllowed_) {
    this.adapter_.sendVoiceViewStateChange(true);
    this.animator_.start(600);
  }
  this.setVisible(true);
};
VoiceView.prototype.stop = function() {
  if (this.isVisible()) {
    this.soundController_.playSound(Sounds.VOICE_RECOG_END, true);
  }
  this.animator_.stop();
  this.setVisible(false);
};
VoiceView.prototype.setVisible = function(visible) {
  VoiceView.base(this, 'setVisible', visible);
  this.visible_ = visible;
  var elem = this.getElement();
  goog.style.setElementShown(elem, true);
  elem.style.visibility = visible ? 'visible' : 'hidden';
  elem.style.transition = visible ? '' : 'visibility 0.1s ease 0.4s';
  if (visible) {
    this.voicePanel_.style.transform = 'scale(1)';
    this.voicePanel_.style.transition = 'transform 0.4s ease';
    goog.dom.classlist.add(this.maskElem_, Css.VOICE_MASK_OPACITY);
    goog.style.setElementShown(this.privacyDiv_, true);
  } else {
    goog.dom.classlist.remove(this.maskElem_, Css.VOICE_MASK_OPACITY);
    this.voicePanel_.style.transform = 'scale(0)';
    this.voicePanel_.style.transition = 'transform 0.4s ease';
    this.levelElement_.style.transform = 'scale(0)';
    goog.style.setElementShown(this.privacyDiv_, false);
  }
  var enterKeys = this.getDomHelper().getElementsByClass(Css.ENTER_ICON);
  var stylestr = 'grayscale(' + (visible ? 1 : 0) + ')';
  goog.array.forEach(enterKeys, function(key) {
    key.style.webkitFilter = stylestr;
  });
  this.resize(this.width, this.height);
};
VoiceView.prototype.resize = function(width, height) {
  VoiceView.base(this, 'resize', width, height);
  this.voicePanel_.style.left = (width - VoiceView.WIDTH_) + 'px';
  var elem = this.getElement();
  var size = goog.style.getSize(this.privacyDiv_);
  this.privacyDiv_.style.top = elem.offsetTop +
      Math.round((height - size.height) / 2) + 'px';
  this.privacyDiv_.style.left = elem.offsetLeft +
      Math.round((width - size.width) / 2) + 'px';
};
VoiceView.prototype.animateMicrophoneLevel_ = function() {
  var scale = 1 + 1.5 * Math.random();
  var timeStep = Math.round(110 + Math.random() * 10);
  var transitionInterval = timeStep / 1000;
  this.levelElement_.style.transition = 'transform' + ' ' +
      transitionInterval + 's ease-in-out';
  this.levelElement_.style.transform = 'scale(' + scale + ')';
  this.animator_.start(timeStep);
};
VoiceView.prototype.onConfirmPrivacyInfo_ = function() {
  localStorage.setItem(Name.VOICE_PRIVACY_INFO, 'true');
  this.isPrivacyAllowed_ = true;
  this.adapter_.sendVoiceViewStateChange(true);
  this.animator_.start(200);
  this.soundController_.playSound(Sounds.VOICE_RECOG_START, true);
  goog.dom.classlist.add(this.privacyDiv_, Css.HANDWRITING_PRIVACY_INFO_HIDDEN);
  goog.dom.classlist.remove(this.maskElem_, Css.VOICE_OPACITY_NONE);
};
VoiceView.prototype.isVisible = function() {
  return this.visible_;
};
});  // goog.scope

// i18n.input.chrome.inputview.KeyboardContainer
goog.provide('i18n.input.chrome.inputview.KeyboardContainer');
goog.scope(function() {
var Css = i18n.input.chrome.inputview.Css;
var EmojiView = i18n.input.chrome.inputview.elements.content.EmojiView;
var GesturePreviewWindow = i18n.input.chrome.inputview.GesturePreviewWindow;
var HandwritingView = i18n.input.chrome.inputview.elements.content.
    HandwritingView;
var KeysetView = i18n.input.chrome.inputview.elements.content.KeysetView;
var content = i18n.input.chrome.inputview.elements.content;
var ElementType = i18n.input.chrome.ElementType;
var WindowUtil = i18n.input.chrome.WindowUtil;
i18n.input.chrome.inputview.KeyboardContainer =
    function(adapter, soundController, opt_eventTarget) {
  goog.base(this, '', ElementType.KEYBOARD_CONTAINER_VIEW, opt_eventTarget);
  this.candidateView = new content.CandidateView(
      'candidateView', adapter, this);
  this.altDataView = new content.AltDataView(this);
  WindowUtil.createWindow(
      function(newWindow) {
        this.gesturePreviewWindow = new GesturePreviewWindow(newWindow);
      }.bind(this));
  this.swipeView = new content.SwipeView(adapter, this.candidateView, this);
  this.selectView = new content.SelectView(this);
  this.menuView = new content.MenuView(this);
  this.voiceView = new content.VoiceView(this, adapter, soundController);
  this.expandedCandidateView = new content.ExpandedCandidateView(this);
  this.keysetViewMap = {};
  this.adapter_ = adapter;
};
goog.inherits(i18n.input.chrome.inputview.KeyboardContainer,
    i18n.input.chrome.inputview.elements.Element);
var KeyboardContainer = i18n.input.chrome.inputview.KeyboardContainer;
KeyboardContainer.prototype.currentKeysetView;
KeyboardContainer.PADDING_BOTTOM_ = 7;
KeyboardContainer.TAB_MARGIN_ = 11;
KeyboardContainer.prototype.wrapperDiv_ = null;
KeyboardContainer.prototype.gestureCanvasView = null;
KeyboardContainer.prototype.floatingView = null;
KeyboardContainer.prototype.createDom = function() {
  goog.base(this, 'createDom');
  var elem = this.getElement();
  var dom = this.getDomHelper();
  this.wrapperDiv_ = dom.createDom(goog.dom.TagName.DIV, Css.WRAPPER);
  this.candidateView.render(this.wrapperDiv_);
  dom.appendChild(elem, this.wrapperDiv_);
  this.altDataView.render();
  this.swipeView.render();
  this.selectView.render();
  this.menuView.render();
  this.voiceView.render();
  this.voiceView.setVisible(false);
  this.expandedCandidateView.render(this.wrapperDiv_);
  this.expandedCandidateView.setVisible(false);
  if (this.adapter_.isFloatingVirtualKeyboardEnabled()) {
    inputview.setMode('FLOATING');
    this.floatingView = new content.FloatingView(this);
    this.floatingView.render();
    this.candidateView.setFloatingVKButtonsVisible(true);
  }
  this.gestureCanvasView = new content.GestureCanvasView(this);
  this.gestureCanvasView.render(this.wrapperDiv_);
  goog.dom.classlist.add(elem, Css.CONTAINER);
};
KeyboardContainer.prototype.update = function() {
  this.currentKeysetView && this.currentKeysetView.update();
};
KeyboardContainer.prototype.addKeysetView = function(keysetData, layoutData,
    keyset, languageCode, model, inputToolName, conditions) {
  var view;
  if (keyset == 'emoji') {
    view = new EmojiView(keysetData, layoutData, keyset, languageCode, model,
        inputToolName, this, this.adapter_);
  } else if (keyset == 'hwt') {
    view = new HandwritingView(keysetData, layoutData, keyset, languageCode,
        model, inputToolName, this, this.adapter_);
  } else {
    view = new KeysetView(keysetData, layoutData, keyset, languageCode, model,
        inputToolName, this, this.adapter_);
  }
  view.render(this.wrapperDiv_);
  view.applyConditions(conditions);
  view.setVisible(false);
  this.keysetViewMap[keyset] = view;
};
KeyboardContainer.prototype.switchToKeyset = function(keyset, title,
    isPasswordBox, isA11yMode, rawKeyset, lastRawkeyset, languageCode) {
  if (!this.keysetViewMap[keyset]) {
    return false;
  }
  for (var name in this.keysetViewMap) {
    var view = this.keysetViewMap[name];
    if (name == keyset) {
      this.candidateView.setVisible(!view.disableCandidateView);
      view.activate(rawKeyset);
      view.setVisible(true);
      view.update();
      if (view.spaceKey) {
        view.spaceKey.updateTitle(title, !isPasswordBox &&
            keyset != 'hwt' && keyset != 'emoji');
      }
      if (isA11yMode) {
        goog.dom.classlist.add(this.getElement(), Css.A11Y);
      }
      if (lastRawkeyset != rawKeyset) {
        view.fromKeyset = lastRawkeyset;
      }
      if (view instanceof HandwritingView) {
        view.setLanguagecode(languageCode);
      }
      if (this.currentKeysetView != view) {
        if (this.currentKeysetView) {
          this.currentKeysetView.deactivate(lastRawkeyset);
        }
        this.currentKeysetView = view;
      }
      this.candidateView.updateByKeyset(rawKeyset, isPasswordBox,
          goog.i18n.bidi.isRtlLanguage(languageCode));
    } else {
      view.setVisible(false);
    }
  }
  var isCompact = keyset.indexOf('compact') >= 0;
  this.selectView.setKeysetSupported(isCompact);
  this.swipeView.setKeysetSupported(isCompact);
  return true;
};
KeyboardContainer.prototype.setContainerSize = function(width, height,
    widthPercent, candidateViewHeight) {
  if (!this.currentKeysetView) {
    return;
  }
  var elem = this.getElement();
  var h = height;
  var wrapperMargin = 0;
  this.wrapperDiv_.style.marginTop = this.wrapperDiv_.style.marginBottom =
      wrapperMargin + 'px';
  h -= KeyboardContainer.PADDING_BOTTOM_;
  elem.style.paddingBottom = KeyboardContainer.PADDING_BOTTOM_ + 'px';
  var padding = Math.round((width - width * widthPercent) / 2);
  var w = width - 2 * padding;
  h = this.currentKeysetView.disableCandidateView ? h :
      h - candidateViewHeight;
  var backspaceWeight = this.currentKeysetView.backspaceKey ?
      this.currentKeysetView.backspaceKey.getParent().getWidthInWeight() : 0;
  this.candidateView.setWidthInWeight(
      this.currentKeysetView.getWidthInWeight(), backspaceWeight);
  this.candidateView.resize(w, candidateViewHeight);
  this.expandedCandidateView.setWidthInWeight(
      this.currentKeysetView.getWidthInWeight(), backspaceWeight);
  this.expandedCandidateView.resize(w, h);
  var candidateElem = this.candidateView.getElement();
  candidateElem.style.paddingLeft = candidateElem.style.paddingRight =
      padding + 'px';
  this.currentKeysetView.resize(width, h, widthPercent);
  var expandViewElem = this.expandedCandidateView.getElement();
  expandViewElem.style.marginLeft = expandViewElem.style.marginRight =
      padding + 'px';
  if (this.expandedCandidateView.isVisible()) {
    this.expandedCandidateView.state = content.ExpandedCandidateView.State.NONE;
    this.candidateView.switchToIcon(
        content.CandidateView.IconType.EXPAND_CANDIDATES, true);
    this.expandedCandidateView.setVisible(false);
    this.currentKeysetView.setVisible(true);
  }
  this.altDataView.resize(width, height);
  this.swipeView.resize(width, height);
  this.selectView.resize(width, height);
  this.menuView.resize(width, height);
  this.voiceView.resize(w + padding, height);
  if (this.floatingView) {
    this.floatingView.resize(width, height);
  }
  this.gestureCanvasView.resize(width, height);
};
KeyboardContainer.prototype.disposeInternal = function() {
  goog.dispose(this.candidateView);
  goog.dispose(this.altDataView);
  goog.dispose(this.gesturePreviewWindow);
  goog.dispose(this.swipeView);
  goog.dispose(this.selectView);
  goog.dispose(this.menuView);
  goog.dispose(this.voiceView);
  if (this.floatingView) {
    goog.dispose(this.floatingView);
  }
  goog.dispose(this.gestureCanvasView);
  for (var key in this.keysetViewMap) {
    goog.dispose(this.keysetViewMap[key]);
  }
  goog.base(this, 'disposeInternal');
};
KeyboardContainer.prototype.hasStrokesOnCanvas = function() {
  if (this.currentKeysetView) {
    return this.currentKeysetView.hasStrokesOnCanvas();
  } else {
    return false;
  }
};
KeyboardContainer.prototype.cleanStroke = function() {
  if (this.currentKeysetView) {
    this.currentKeysetView.cleanStroke();
  }
};
});  // goog.scope

// goog.async.Deferred
// goog.async.Deferred.AlreadyCalledError
// goog.async.Deferred.CanceledError
goog.provide('goog.async.Deferred');
goog.provide('goog.async.Deferred.AlreadyCalledError');
goog.provide('goog.async.Deferred.CanceledError');
goog.async.Deferred = function(opt_onCancelFunction, opt_defaultScope) {
  this.sequence_ = [];
  this.onCancelFunction_ = opt_onCancelFunction;
  this.defaultScope_ = opt_defaultScope || null;
  this.fired_ = false;
  this.hadError_ = false;
  this.result_ = undefined;
  this.blocked_ = false;
  this.blocking_ = false;
  this.silentlyCanceled_ = false;
  this.unhandledErrorId_ = 0;
  this.parent_ = null;
  this.branches_ = 0;
  if (goog.async.Deferred.LONG_STACK_TRACES) {
    this.constructorStack_ = null;
    if (Error.captureStackTrace) {
      var target = { stack: '' };
      Error.captureStackTrace(target, goog.async.Deferred);
      if (typeof target.stack == 'string') {
        this.constructorStack_ = target.stack.replace(/^[^\n]*\n/, '');
      }
    }
  }
};
goog.define('goog.async.Deferred.STRICT_ERRORS', false);
goog.define('goog.async.Deferred.LONG_STACK_TRACES', false);
goog.async.Deferred.prototype.cancel = function(opt_deepCancel) {
  if (!this.hasFired()) {
    if (this.parent_) {
      var parent = this.parent_;
      delete this.parent_;
      if (opt_deepCancel) {
        parent.cancel(opt_deepCancel);
      } else {
        parent.branchCancel_();
      }
    }
    if (this.onCancelFunction_) {
      this.onCancelFunction_.call(this.defaultScope_, this);
    } else {
      this.silentlyCanceled_ = true;
    }
    if (!this.hasFired()) {
      this.errback(new goog.async.Deferred.CanceledError(this));
    }
  } else if (this.result_ instanceof goog.async.Deferred) {
    this.result_.cancel();
  }
};
goog.async.Deferred.prototype.branchCancel_ = function() {
  this.branches_--;
  if (this.branches_ <= 0) {
    this.cancel();
  }
};
goog.async.Deferred.prototype.continue_ = function(isSuccess, res) {
  this.blocked_ = false;
  this.updateResult_(isSuccess, res);
};
goog.async.Deferred.prototype.updateResult_ = function(isSuccess, res) {
  this.fired_ = true;
  this.result_ = res;
  this.hadError_ = !isSuccess;
  this.fire_();
};
goog.async.Deferred.prototype.check_ = function() {
  if (this.hasFired()) {
    if (!this.silentlyCanceled_) {
      throw new goog.async.Deferred.AlreadyCalledError(this);
    }
    this.silentlyCanceled_ = false;
  }
};
goog.async.Deferred.prototype.callback = function(opt_result) {
  this.check_();
  this.assertNotDeferred_(opt_result);
  this.updateResult_(true , opt_result);
};
goog.async.Deferred.prototype.errback = function(opt_result) {
  this.check_();
  this.assertNotDeferred_(opt_result);
  this.makeStackTraceLong_(opt_result);
  this.updateResult_(false , opt_result);
};
goog.async.Deferred.prototype.makeStackTraceLong_ = function(error) {
  if (!goog.async.Deferred.LONG_STACK_TRACES) {
    return;
  }
  if (this.constructorStack_ && goog.isObject(error) && error.stack &&
      (/^[^\n]+(\n   [^\n]+)+/).test(error.stack)) {
    error.stack = error.stack + '\nDEFERRED OPERATION:\n' +
        this.constructorStack_;
  }
};
goog.async.Deferred.prototype.assertNotDeferred_ = function(obj) {
  goog.asserts.assert(
      !(obj instanceof goog.async.Deferred),
      'An execution sequence may not be initiated with a blocking Deferred.');
};
goog.async.Deferred.prototype.addCallback = function(cb, opt_scope) {
  return this.addCallbacks(cb, null, opt_scope);
};
goog.async.Deferred.prototype.addErrback = function(eb, opt_scope) {
  return this.addCallbacks(null, eb, opt_scope);
};
goog.async.Deferred.prototype.addBoth = function(f, opt_scope) {
  return this.addCallbacks(f, f, opt_scope);
};
goog.async.Deferred.prototype.addFinally = function(f, opt_scope) {
  var self = this;
  return this.addCallbacks(f, function(err) {
    var result = f.call(self, err);
    if (!goog.isDef(result)) {
      throw err;
    }
    return result;
  }, opt_scope);
};
goog.async.Deferred.prototype.addCallbacks = function(cb, eb, opt_scope) {
  goog.asserts.assert(!this.blocking_, 'Blocking Deferreds can not be re-used');
  this.sequence_.push([cb, eb, opt_scope]);
  if (this.hasFired()) {
    this.fire_();
  }
  return this;
};
goog.async.Deferred.prototype.then = function(opt_onFulfilled, opt_onRejected,
    opt_context) {
  var resolve, reject;
  var promise = new goog.Promise(function(res, rej) {
    resolve = res;
    reject = rej;
  });
  this.addCallbacks(resolve, function(reason) {
    if (reason instanceof goog.async.Deferred.CanceledError) {
      promise.cancel();
    } else {
      reject(reason);
    }
  });
  return promise.then(opt_onFulfilled, opt_onRejected, opt_context);
};
goog.Thenable.addImplementation(goog.async.Deferred);
goog.async.Deferred.prototype.chainDeferred = function(otherDeferred) {
  this.addCallbacks(
      otherDeferred.callback, otherDeferred.errback, otherDeferred);
  return this;
};
goog.async.Deferred.prototype.awaitDeferred = function(otherDeferred) {
  if (!(otherDeferred instanceof goog.async.Deferred)) {
    return this.addCallback(function() {
      return otherDeferred;
    });
  }
  return this.addCallback(goog.bind(otherDeferred.branch, otherDeferred));
};
goog.async.Deferred.prototype.branch = function(opt_propagateCancel) {
  var d = new goog.async.Deferred();
  this.chainDeferred(d);
  if (opt_propagateCancel) {
    d.parent_ = this;
    this.branches_++;
  }
  return d;
};
goog.async.Deferred.prototype.hasFired = function() {
  return this.fired_;
};
goog.async.Deferred.prototype.isError = function(res) {
  return res instanceof Error;
};
goog.async.Deferred.prototype.hasErrback_ = function() {
  return goog.array.some(this.sequence_, function(sequenceRow) {
    return goog.isFunction(sequenceRow[1]);
  });
};
goog.async.Deferred.prototype.fire_ = function() {
  if (this.unhandledErrorId_ && this.hasFired() && this.hasErrback_()) {
    goog.async.Deferred.unscheduleError_(this.unhandledErrorId_);
    this.unhandledErrorId_ = 0;
  }
  if (this.parent_) {
    this.parent_.branches_--;
    delete this.parent_;
  }
  var res = this.result_;
  var unhandledException = false;
  var isNewlyBlocked = false;
  while (this.sequence_.length && !this.blocked_) {
    var sequenceEntry = this.sequence_.shift();
    var callback = sequenceEntry[0];
    var errback = sequenceEntry[1];
    var scope = sequenceEntry[2];
    var f = this.hadError_ ? errback : callback;
    if (f) {
      try {
        var ret = f.call(scope || this.defaultScope_, res);
        if (goog.isDef(ret)) {
          this.hadError_ = this.hadError_ && (ret == res || this.isError(ret));
          this.result_ = res = ret;
        }
        if (goog.Thenable.isImplementedBy(res) ||
            (typeof goog.global['Promise'] === 'function' &&
            res instanceof goog.global['Promise'])) {
          isNewlyBlocked = true;
          this.blocked_ = true;
        }
      } catch (ex) {
        res = ex;
        this.hadError_ = true;
        this.makeStackTraceLong_(res);
        if (!this.hasErrback_()) {
          unhandledException = true;
        }
      }
    }
  }
  this.result_ = res;
  if (isNewlyBlocked) {
    var onCallback = goog.bind(this.continue_, this, true );
    var onErrback = goog.bind(this.continue_, this, false );
    if (res instanceof goog.async.Deferred) {
      res.addCallbacks(onCallback, onErrback);
      res.blocking_ = true;
    } else {
      res.then(onCallback, onErrback);
    }
  } else if (goog.async.Deferred.STRICT_ERRORS && this.isError(res) &&
      !(res instanceof goog.async.Deferred.CanceledError)) {
    this.hadError_ = true;
    unhandledException = true;
  }
  if (unhandledException) {
    this.unhandledErrorId_ = goog.async.Deferred.scheduleError_(res);
  }
};
goog.async.Deferred.succeed = function(opt_result) {
  var d = new goog.async.Deferred();
  d.callback(opt_result);
  return d;
};
goog.async.Deferred.fromPromise = function(promise) {
  var d = new goog.async.Deferred();
  d.callback();
  d.addCallback(function() {
    return promise;
  });
  return d;
};
goog.async.Deferred.fail = function(res) {
  var d = new goog.async.Deferred();
  d.errback(res);
  return d;
};
goog.async.Deferred.canceled = function() {
  var d = new goog.async.Deferred();
  d.cancel();
  return d;
};
goog.async.Deferred.when = function(value, callback, opt_scope) {
  if (value instanceof goog.async.Deferred) {
    return value.branch(true).addCallback(callback, opt_scope);
  } else {
    return goog.async.Deferred.succeed(value).addCallback(callback, opt_scope);
  }
};
goog.async.Deferred.AlreadyCalledError = function(deferred) {
  goog.debug.Error.call(this);
  this.deferred = deferred;
};
goog.inherits(goog.async.Deferred.AlreadyCalledError, goog.debug.Error);
goog.async.Deferred.AlreadyCalledError.prototype.message =
    'Deferred has already fired';
goog.async.Deferred.AlreadyCalledError.prototype.name = 'AlreadyCalledError';
goog.async.Deferred.CanceledError = function(deferred) {
  goog.debug.Error.call(this);
  this.deferred = deferred;
};
goog.inherits(goog.async.Deferred.CanceledError, goog.debug.Error);
goog.async.Deferred.CanceledError.prototype.message = 'Deferred was canceled';
goog.async.Deferred.CanceledError.prototype.name = 'CanceledError';
goog.async.Deferred.Error_ = function(error) {
  this.id_ = goog.global.setTimeout(goog.bind(this.throwError, this), 0);
  this.error_ = error;
};
goog.async.Deferred.Error_.prototype.throwError = function() {
  goog.asserts.assert(goog.async.Deferred.errorMap_[this.id_],
      'Cannot throw an error that is not scheduled.');
  delete goog.async.Deferred.errorMap_[this.id_];
  throw this.error_;
};
goog.async.Deferred.Error_.prototype.resetTimer = function() {
  goog.global.clearTimeout(this.id_);
};
goog.async.Deferred.errorMap_ = {};
goog.async.Deferred.scheduleError_ = function(error) {
  var deferredError = new goog.async.Deferred.Error_(error);
  goog.async.Deferred.errorMap_[deferredError.id_] = deferredError;
  return deferredError.id_;
};
goog.async.Deferred.unscheduleError_ = function(id) {
  var error = goog.async.Deferred.errorMap_[id];
  if (error) {
    error.resetTimer();
    delete goog.async.Deferred.errorMap_[id];
  }
};
goog.async.Deferred.assertNoErrors = function() {
  var map = goog.async.Deferred.errorMap_;
  for (var key in map) {
    var error = map[key];
    error.resetTimer();
    error.throwError();
  }
};

// goog.net.jsloader
// goog.net.jsloader.Error
// goog.net.jsloader.ErrorCode
// goog.net.jsloader.Options
goog.provide('goog.net.jsloader');
goog.provide('goog.net.jsloader.Error');
goog.provide('goog.net.jsloader.ErrorCode');
goog.provide('goog.net.jsloader.Options');
goog.net.jsloader.GLOBAL_VERIFY_OBJS_ = 'closure_verification';
goog.net.jsloader.DEFAULT_TIMEOUT = 5000;
goog.net.jsloader.Options;
goog.net.jsloader.scriptsToLoad_ = [];
goog.net.jsloader.loadMany = function(uris, opt_options) {
  if (!uris.length) {
    return;
  }
  var isAnotherModuleLoading = goog.net.jsloader.scriptsToLoad_.length;
  goog.array.extend(goog.net.jsloader.scriptsToLoad_, uris);
  if (isAnotherModuleLoading) {
    return;
  }
  uris = goog.net.jsloader.scriptsToLoad_;
  var popAndLoadNextScript = function() {
    var uri = uris.shift();
    var deferred = goog.net.jsloader.load(uri, opt_options);
    if (uris.length) {
      deferred.addBoth(popAndLoadNextScript);
    }
  };
  popAndLoadNextScript();
};
goog.net.jsloader.load = function(uri, opt_options) {
  var options = opt_options || {};
  var doc = options.document || document;
  var script = goog.dom.createElement(goog.dom.TagName.SCRIPT);
  var request = {script_: script, timeout_: undefined};
  var deferred = new goog.async.Deferred(goog.net.jsloader.cancel_, request);
  var timeout = null;
  var timeoutDuration = goog.isDefAndNotNull(options.timeout) ?
      options.timeout : goog.net.jsloader.DEFAULT_TIMEOUT;
  if (timeoutDuration > 0) {
    timeout = window.setTimeout(function() {
      goog.net.jsloader.cleanup_(script, true);
      deferred.errback(new goog.net.jsloader.Error(
          goog.net.jsloader.ErrorCode.TIMEOUT,
          'Timeout reached for loading script ' + uri));
    }, timeoutDuration);
    request.timeout_ = timeout;
  }
  script.onload = script.onreadystatechange = function() {
    if (!script.readyState || script.readyState == 'loaded' ||
        script.readyState == 'complete') {
      var removeScriptNode = options.cleanupWhenDone || false;
      goog.net.jsloader.cleanup_(script, removeScriptNode, timeout);
      deferred.callback(null);
    }
  };
  script.onerror = function() {
    goog.net.jsloader.cleanup_(script, true, timeout);
    deferred.errback(new goog.net.jsloader.Error(
        goog.net.jsloader.ErrorCode.LOAD_ERROR,
        'Error while loading script ' + uri));
  };
  var properties = options.attributes || {};
  goog.object.extend(properties, {
    'type': 'text/javascript',
    'charset': 'UTF-8',
    'src': uri
  });
  goog.dom.setProperties(script, properties);
  var scriptParent = goog.net.jsloader.getScriptParentElement_(doc);
  scriptParent.appendChild(script);
  return deferred;
};
goog.net.jsloader.loadAndVerify = function(uri, verificationObjName, options) {
  if (!goog.global[goog.net.jsloader.GLOBAL_VERIFY_OBJS_]) {
    goog.global[goog.net.jsloader.GLOBAL_VERIFY_OBJS_] = {};
  }
  var verifyObjs = goog.global[goog.net.jsloader.GLOBAL_VERIFY_OBJS_];
  if (goog.isDef(verifyObjs[verificationObjName])) {
    return goog.async.Deferred.fail(new goog.net.jsloader.Error(
        goog.net.jsloader.ErrorCode.VERIFY_OBJECT_ALREADY_EXISTS,
        'Verification object ' + verificationObjName + ' already defined.'));
  }
  var sendDeferred = goog.net.jsloader.load(uri, options);
  var deferred = new goog.async.Deferred(
      goog.bind(sendDeferred.cancel, sendDeferred));
  sendDeferred.addCallback(function() {
    var result = verifyObjs[verificationObjName];
    if (goog.isDef(result)) {
      deferred.callback(result);
      delete verifyObjs[verificationObjName];
    } else {
      deferred.errback(new goog.net.jsloader.Error(
          goog.net.jsloader.ErrorCode.VERIFY_ERROR,
          'Script ' + uri + ' loaded, but verification object ' +
          verificationObjName + ' was not defined.'));
    }
  });
  sendDeferred.addErrback(function(error) {
    if (goog.isDef(verifyObjs[verificationObjName])) {
      delete verifyObjs[verificationObjName];
    }
    deferred.errback(error);
  });
  return deferred;
};
goog.net.jsloader.getScriptParentElement_ = function(doc) {
  var headElements = doc.getElementsByTagName(goog.dom.TagName.HEAD);
  if (!headElements || goog.array.isEmpty(headElements)) {
    return doc.documentElement;
  } else {
    return headElements[0];
  }
};
goog.net.jsloader.cancel_ = function() {
  var request = this;
  if (request && request.script_) {
    var scriptNode = request.script_;
    if (scriptNode && scriptNode.tagName == goog.dom.TagName.SCRIPT) {
      goog.net.jsloader.cleanup_(scriptNode, true, request.timeout_);
    }
  }
};
goog.net.jsloader.cleanup_ = function(scriptNode, removeScriptNode,
                                      opt_timeout) {
  if (goog.isDefAndNotNull(opt_timeout)) {
    goog.global.clearTimeout(opt_timeout);
  }
  scriptNode.onload = goog.nullFunction;
  scriptNode.onerror = goog.nullFunction;
  scriptNode.onreadystatechange = goog.nullFunction;
  if (removeScriptNode) {
    window.setTimeout(function() {
      goog.dom.removeNode(scriptNode);
    }, 0);
  }
};
goog.net.jsloader.ErrorCode = {
  LOAD_ERROR: 0,
  TIMEOUT: 1,
  VERIFY_ERROR: 2,
  VERIFY_OBJECT_ALREADY_EXISTS: 3
};
goog.net.jsloader.Error = function(code, opt_message) {
  var msg = 'Jsloader error (code #' + code + ')';
  if (opt_message) {
    msg += ': ' + opt_message;
  }
  goog.net.jsloader.Error.base(this, 'constructor', msg);
  this.code = code;
};
goog.inherits(goog.net.jsloader.Error, goog.debug.Error);

// i18n.input.chrome.vk.EventType
goog.provide('i18n.input.chrome.vk.EventType');
i18n.input.chrome.vk.EventType = {
  LAYOUT_LOADED: 'lld'
};

// i18n.input.chrome.vk.LayoutEvent
goog.provide('i18n.input.chrome.vk.LayoutEvent');
i18n.input.chrome.vk.LayoutEvent = function(type, layoutView) {
  goog.base(this, type);
  this.layoutView = layoutView;
  this.layoutCode = layoutView ? layoutView.id : null;
};
goog.inherits(i18n.input.chrome.vk.LayoutEvent, goog.events.Event);

// i18n.input.chrome.vk.ParsedLayout
goog.provide('i18n.input.chrome.vk.ParsedLayout');
i18n.input.chrome.vk.ParsedLayout = function(layout) {
  this.id = layout['id'];
  this.view = {
    'id': layout['id'],
    'title': layout['title'],
    'isRTL': layout['direction'] == 'rtl',
    'is102': !!layout['is102Keyboard'],
    'mappings': goog.object.create([
      '', null,
      's', null,
      'c', null,
      'l', null,
      'sc', null,
      'cl', null,
      'sl', null,
      'scl', null
    ])
  };
  this.transforms = null;
  this.ambiRegex_ = null;
  this.parseKeyMappings_(layout);
  this.parseTransforms_(layout);
};
i18n.input.chrome.vk.ParsedLayout.prototype.parseKeyMappings_ = function(
    layout) {
  var codes = this.view['is102'] ? i18n.input.chrome.vk.KeyCode.CODES102 :
      i18n.input.chrome.vk.KeyCode.CODES101;
  var mappings = layout['mappings'];
  for (var m in mappings) {
    var map = mappings[m];
    var modes = m.split(/,/);
    if (modes.join(',') != m) {
      modes.push(''); // IE splits 'a,b,' into ['a','b']
    }
    var parsed = {};
    for (var from in map) {
      var to = map[from];
      if (from == '') {
        from = codes;
        if (this.view['is102']) {
          var normalizedTo = to.slice(0, 25);
          normalizedTo += to.slice(26, 37);
          normalizedTo += to.charAt(25);
          normalizedTo += to.slice(37);
          to = normalizedTo;
        }
      }
      from = from.replace('m', '\u00bd');
      from = from.replace('=', '\u00bb');
      from = from.replace(';', '\u00ba');
      if (from.length == 1) {
        parsed[from] = ['S', to, to];
      } else {
        var j = 0;
        for (var i = 0, c; c = from.charAt(i); ++i) {
          var t = to.charAt(j++);
          if (t == to.charAt(j) && t == '{') {
            var k = to.indexOf('}}', j);
            if (k < j) break;
            var s = to.slice(j + 1, k);
            var parts = s.split('||');
            if (parts.length == 3) {
              parsed[c] = parts;
            } else if (parts.length == 1) {
              parsed[c] = ['S', s, s];
            }
            j = k + 2;
          } else {
            parsed[c] = ['S', t, t];
          }
        }
      }
    }
    for (var i = 0, mode; mode = modes[i], mode != undefined; ++i) {
      this.view['mappings'][mode] = parsed;
    }
  }
};
i18n.input.chrome.vk.ParsedLayout.prototype.prefixalizeRegexString_ = function(
    re_str) {
  re_str = re_str.replace(/\\./g, function(m) {
    if (/^\\\[/.test(m)) {
      return '\u0001';
    }
    if (/^\\\]/.test(m)) {
      return '\u0002';
    }
    return m;
  });
  re_str = re_str.replace(/\\.|\[[^\[\]]*\]|\{.*\}|[^\|\\\(\)\[\]\{\}\*\+\?]/g,
      function(m) {
        if (/^\{/.test(m)) {
          return m;
        }
        return '(?:' + m + '|$)';
      });
  re_str = re_str.replace(/\u0001/g, '\\[');
  re_str = re_str.replace(/\u0002/g, '\\]');
  return re_str;
};
i18n.input.chrome.vk.ParsedLayout.prototype.parseTransforms_ = function(
    layout) {
  var transforms = layout['transform'];
  if (transforms) {
    var regobjs = [], regexesalone = [], partialRegexs = [];
    var sum_numgrps = 1;
    for (var regex in transforms) {
      var regobj = new RegExp(regex + '$');
      var repl = transforms[regex];
      regobjs[sum_numgrps] = [regobj, repl];
      regexesalone.push('(' + regex + '$)');
      partialRegexs.push('^(' + this.prefixalizeRegexString_(regex) + ')');
      var grpCountRegexp = new RegExp(regex + '|.*');
      var numgrps = grpCountRegexp.exec('').length;
      sum_numgrps += numgrps;
    }
    var longregobj = new RegExp(regexesalone.join('|'));
    var prefixregobj = new RegExp(partialRegexs.join('|'));
    var prefixregobj2 = new RegExp(partialRegexs.reverse().join('|'));
    this.transforms = [longregobj, regobjs, prefixregobj, prefixregobj2];
  }
  var hisPruReg = layout['historyPruneRegex'];
  if (hisPruReg) {
    this.ambiRegex_ = new RegExp('^(' + hisPruReg + ')$');
  }
};
i18n.input.chrome.vk.ParsedLayout.prototype.predictTransform = function(text) {
  if (!this.transforms || !text) {
    return -1;
  }
  for (var i = 0; i < text.length; i++) {
    var s = text.slice(i - text.length);
    var matches = s.match(this.transforms[2]);
    if (matches && matches[0]) {
      for (var j = 1; j < matches.length && !matches[j]; j++) {}
      var matchedIndex = j;
      matches = s.match(this.transforms[3]);
      if (matches && matches[0]) { // This should always match!
        for (var j = 1; j < matches.length && !matches[j]; j++) {}
        if (matchedIndex != matches.length - j) {
          return i;
        } else {
          var re = this.transforms[1][matchedIndex][0];
          re = new RegExp(re.toString().match(/\/(.*)\//)[1] + '\u0001');
          if (!(s + '\u0001').match(re)) {
            return i;
          }
        }
      }
    }
  }
  return -1;
};
i18n.input.chrome.vk.ParsedLayout.prototype.transform = function(
    prevstr, transat, ch) {
  if (!this.transforms) return null;
  var str;
  if (transat > 0) {
    str = prevstr.slice(0, transat) + '\u001d' +
          prevstr.slice(transat) + ch;
  } else {
    str = prevstr + ch;
  }
  var longr = this.transforms[0];
  var matchArr = longr.exec(str);
  if (matchArr) {
    var rs = this.transforms[1];
    for (var i = 1; i < matchArr.length && !matchArr[i]; i++) {}
    var matchGroup = i;
    var regobj = rs[matchGroup][0];
    var repl = rs[matchGroup][1];
    var m = regobj.exec(str);
    var rmstr = str.slice(m.index);
    var numseps = rmstr.search('\u001d') > -1 ? 1 : 0;
    var backlen = rmstr.length - numseps - ch.length;
    var newstr = str.replace(regobj, repl);
    var replstr = newstr.slice(m.index);
    replstr = replstr.replace('\u001d', '');
    return {back: backlen, chars: replstr};
  }
  return null;
};
i18n.input.chrome.vk.ParsedLayout.prototype.isAmbiChars = function(chars) {
  return this.ambiRegex_ ? !!this.ambiRegex_.exec(chars) : false;
};

// i18n.input.chrome.vk.Model
goog.provide('i18n.input.chrome.vk.Model');
i18n.input.chrome.vk.Model = function() {
  goog.base(this);
  this.layouts_ = {};
  this.activeLayout_ = '';
  this.delayActiveLayout_ = '';
  this.historyState_ = {
    previous: {text: '', transat: -1},
    ambi: '',
    current: {text: '', transat: -1}
  };
  goog.exportSymbol('cros_vk_loadme', goog.bind(this.onLayoutLoaded_, this));
};
goog.inherits(i18n.input.chrome.vk.Model, goog.events.EventTarget);
i18n.input.chrome.vk.Model.prototype.loadLayout = function(layoutCode) {
  if (!layoutCode) return;
  var parsedLayout = this.layouts_[layoutCode];
  if (parsedLayout == undefined) {
    this.layouts_[layoutCode] = false;
    i18n.input.chrome.vk.Model.loadLayoutScript_(layoutCode);
  } else if (parsedLayout) {
    this.dispatchEvent(new i18n.input.chrome.vk.LayoutEvent(
        i18n.input.chrome.vk.EventType.LAYOUT_LOADED,
         (parsedLayout)));
  }
};
i18n.input.chrome.vk.Model.prototype.activateLayout = function(
    layoutCode) {
  if (!layoutCode) return;
  if (this.activeLayout_ != layoutCode) {
    var parsedLayout = this.layouts_[layoutCode];
    if (parsedLayout) {
      this.activeLayout_ = layoutCode;
      this.delayActiveLayout_ = '';
      this.clearHistory();
    } else if (parsedLayout == false) { // Layout being loaded?
      this.delayActiveLayout_ = layoutCode;
    }
  }
};
i18n.input.chrome.vk.Model.prototype.getCurrentLayout = function() {
  return this.activeLayout_;
};
i18n.input.chrome.vk.Model.prototype.predictHistory = function() {
  if (!this.activeLayout_ || !this.layouts_[this.activeLayout_]) {
    return -1;
  }
  var parsedLayout = this.layouts_[this.activeLayout_];
  var history = this.historyState_;
  var text, transat;
  if (history.ambi) {
    text = history.previous.text;
    transat = history.previous.transat;
    if (transat > 0) {
      text = text.slice(0, transat) + '\u001d' + text.slice(transat) +
          history.ambi;
    } else {
      text += history.ambi;
    }
    if (parsedLayout.predictTransform(text) >= 0) {
      return 0;
    }
  }
  text = history.current.text;
  transat = history.current.transat;
  if (transat >= 0) {
    text = text.slice(0, transat) + '\u001d' + text.slice(transat);
  }
  var pos = parsedLayout.predictTransform(text);
  if (transat >= 0 && pos > transat) {
    pos--;
  }
  return pos;
};
i18n.input.chrome.vk.Model.prototype.translate = function(
    chars, charsBeforeCaret) {
  if (!this.activeLayout_ || !chars) {
    return null;
  }
  var parsedLayout = this.layouts_[this.activeLayout_];
  if (!parsedLayout) {
    return null;
  }
  this.matchHistory_(charsBeforeCaret);
  var result, history = this.historyState_;
  if (history.ambi) {
    result = parsedLayout.transform(
        history.previous.text, history.previous.transat,
        history.ambi + chars);
    if (result && result.back < 0) {
      result = null;
    }
  }
  if (result) {
    var prev = history.previous.text;
    prev = prev.slice(0, prev.length - result.back);
    prev += result.chars;
    result.back = history.current.text.length;
    result.chars = prev;
  } else {
    result = parsedLayout.transform(
        history.current.text, history.current.transat, chars);
  }
  if (parsedLayout.isAmbiChars(history.ambi + chars)) {
    if (!history.ambi) {
      history.previous = goog.object.clone(history.current);
    }
    history.ambi += chars;
  } else if (parsedLayout.isAmbiChars(chars)) {
    history.previous = goog.object.clone(history.current);
    history.ambi = chars;
  } else {
    history.previous.text = '';
    history.previous.transat = -1;
    history.ambi = '';
  }
  var text = history.current.text;
  var transat = history.current.transat;
  if (result) {
    text = text.slice(0, text.length - result.back);
    text += result.chars;
    transat = text.length;
  } else {
    text += chars;
    result = {back: 0, chars: chars};
  }
  var spacePos = text.lastIndexOf(' ');
  if (spacePos >= 0) {
    text = text.slice(spacePos + 1);
    if (transat > spacePos) {
      transat -= spacePos + 1;
    } else {
      transat = -1;
    }
  }
  history.current.text = text;
  history.current.transat = transat;
  return result;
};
i18n.input.chrome.vk.Model.prototype.hasTransforms = function() {
  var parsedLayout = this.layouts_[this.activeLayout_];
  return !!parsedLayout && !!parsedLayout.transforms;
};
i18n.input.chrome.vk.Model.prototype.processBackspace = function(
    charsBeforeCaret) {
  this.matchHistory_(charsBeforeCaret);
  var history = this.historyState_;
  var text = history.current.text;
  if (text) {
    text = text.slice(0, text.length - 1);
    history.current.text = text;
    if (history.current.transat > text.length) {
      history.current.transat = text.length;
    }
    text = history.ambi;
    if (text) { // If there is ambi text, remove the last char in ambi.
      history.ambi = text.slice(0, text.length - 1);
    }
    if (!history.ambi) {
      history.previous = {text: '', transat: -1};
    }
  } else {
    history.previous = {text: '', transat: -1};
    history.ambi = '';
    history.current = goog.object.clone(history.previous);
  }
};
i18n.input.chrome.vk.Model.prototype.onLayoutLoaded_ = function(layout) {
  var parsedLayout = new i18n.input.chrome.vk.ParsedLayout(layout);
  if (parsedLayout.id) {
    this.layouts_[parsedLayout.id] = parsedLayout;
  }
  if (this.delayActiveLayout_ == layout.id) {
    this.activateLayout(this.delayActiveLayout_);
    this.delayActiveLayout_ = '';
  }
  this.dispatchEvent(new i18n.input.chrome.vk.LayoutEvent(
      i18n.input.chrome.vk.EventType.LAYOUT_LOADED, parsedLayout));
};
i18n.input.chrome.vk.Model.prototype.matchHistory_ = function(text) {
  var hisText = this.historyState_.current.text;
  if (!hisText || !text || !(goog.string.endsWith(text, hisText) ||
      goog.string.endsWith(hisText, text))) {
    this.clearHistory();
  }
};
i18n.input.chrome.vk.Model.prototype.clearHistory = function() {
  this.historyState_.ambi = '';
  this.historyState_.previous = {text: '', transat: -1};
  this.historyState_.current = goog.object.clone(this.historyState_.previous);
};
i18n.input.chrome.vk.Model.prototype.pruneHistory = function(count) {
  var pruneFunc = function(his) {
    his.text = his.text.slice(count);
    if (his.transat > 0) {
      his.transat -= count;
      if (his.transat <= 0) {
        his.transat = -1;
      }
    }
  };
  pruneFunc(this.historyState_.previous);
  pruneFunc(this.historyState_.current);
};
i18n.input.chrome.vk.Model.loadLayoutScript_ = function(layoutCode) {
  goog.net.jsloader.load('layouts/' + layoutCode + '.js');
};

// i18n.input.chrome.inputview.M17nModel
goog.provide('i18n.input.chrome.inputview.M17nModel');
i18n.input.chrome.inputview.M17nModel = function() {
  goog.base(this);
  this.handler_ = new goog.events.EventHandler(this);
  this.model_ = new i18n.input.chrome.vk.Model();
  this.handler_.listen(this.model_,
      i18n.input.chrome.vk.EventType.LAYOUT_LOADED,
      this.onLayoutLoaded_);
};
goog.inherits(i18n.input.chrome.inputview.M17nModel,
    goog.events.EventTarget);
i18n.input.chrome.inputview.M17nModel.prototype.layoutView_;
i18n.input.chrome.inputview.M17nModel.prototype.loadConfig = function(lang) {
  var m17nMatches = lang.match(/^m17n:(.*)/);
  if (m17nMatches && m17nMatches[1]) {
    this.model_.loadLayout(m17nMatches[1]);
  }
};
i18n.input.chrome.inputview.M17nModel.prototype.onLayoutLoaded_ = function(
    e) {
  var layoutView = 
      (e.layoutView);
  this.layoutView_ = layoutView;
  var is102 = layoutView.view.is102;
  var codes = is102 ? i18n.input.chrome.vk.KeyCode.CODES102 :
      i18n.input.chrome.vk.KeyCode.CODES101;
  var keyCount = is102 ? 48 : 47;
  var keyCharacters = [];
  for (var i = 0; i < keyCount; i++) {
    var characters = this.findCharacters_(layoutView.view.mappings,
        codes[i]);
    keyCharacters.push(characters);
  }
  keyCharacters.push(['\u0020', '\u0020']);
  var hasAltGrKey = !!layoutView.view.mappings['c'] &&
      layoutView.view.mappings['c'] != layoutView.view.mappings[''];
  var skvPrefix = is102 ? '102kbd-k-' : '101kbd-k-';
  var skPrefix = layoutView.view.id + '-k-';
  var data = i18n.input.chrome.inputview.content.util.createData(keyCharacters,
      skvPrefix, is102, hasAltGrKey);
  if (data) {
    data[i18n.input.chrome.inputview.SpecNodeName.TITLE] =
        layoutView.view.title;
    data[i18n.input.chrome.inputview.SpecNodeName.ID] =
        'm17n:' + e.layoutCode;
    this.dispatchEvent(new i18n.input.chrome.inputview.events.
        ConfigLoadedEvent(data));
  }
};
i18n.input.chrome.inputview.M17nModel.prototype.findCharacters_ = function(
    mappings, code) {
  var characters = [];
  var states = [
    '',
    's',
    'c',
    'sc',
    'l',
    'sl',
    'cl',
    'scl'
  ];
  for (var i = 0; i < states.length; i++) {
    if (mappings[states[i]] && mappings[states[i]][code]) {
      characters[i] = mappings[states[i]][code][1];
    } else if (code == '\u0020') {
      characters[i] = '\u0020';
    } else {
      characters[i] = '';
    }
  }
  return characters;
};
i18n.input.chrome.inputview.M17nModel.prototype.disposeInternal = function() {
  goog.dispose(this.handler_);
  goog.base(this, 'disposeInternal');
};

// i18n.input.chrome.inputview.Settings
goog.provide('i18n.input.chrome.inputview.Settings');
goog.scope(function() {
i18n.input.chrome.inputview.Settings = function() {};
var Settings = i18n.input.chrome.inputview.Settings;
Settings.prototype.alwaysRenderAltGrCharacter = false;
Settings.prototype.autoSpace = false;
Settings.prototype.autoCapital = false;
Settings.prototype.autoCorrection = false;
Settings.prototype.enableLongPress = true;
Settings.prototype.doubleSpacePeriod = false;
Settings.prototype.soundOnKeypress = false;
Settings.prototype.gestureEditing = false;
Settings.prototype.gestureTyping = false;
Settings.prototype.candidatesNavigation = false;
Settings.prototype.savePreference = function(preference, value) {
  window.localStorage.setItem(preference, (value));
};
Settings.prototype.getPreference = function(preference) {
  return window.localStorage.getItem(preference);
};
});  // goog.scope

// i18n.input.chrome.inputview.StateManager
goog.provide('i18n.input.chrome.inputview.StateManager');
goog.scope(function() {
i18n.input.chrome.inputview.StateManager = function() {
  this.covariance = new i18n.input.chrome.inputview.Covariance();
};
var StateManager = i18n.input.chrome.inputview.StateManager;
StateManager.prototype.contextType = '';
StateManager.prototype.state_ = 0;
StateManager.prototype.sticky_ = 0;
StateManager.prototype.stateKeyDown_ = 0;
StateManager.prototype.chording_ = 0;
StateManager.prototype.finalSticky_ = 0;
StateManager.prototype.isEnMode = false;
i18n.input.chrome.inputview.StateManager.prototype.setKeyDown = function(
    stateType, isKeyDown) {
  if (isKeyDown) {
    this.stateKeyDown_ |= stateType;
  } else {
    this.stateKeyDown_ &= ~stateType;
    this.chording_ &= ~stateType;
  }
};
i18n.input.chrome.inputview.StateManager.prototype.isKeyDown = function(
    stateType) {
  return (this.stateKeyDown_ & stateType) != 0;
};
i18n.input.chrome.inputview.StateManager.prototype.triggerChording =
    function() {
  this.chording_ |= this.stateKeyDown_;
};
i18n.input.chrome.inputview.StateManager.prototype.isChording = function(
    stateType) {
  return (this.chording_ & stateType) != 0;
};
i18n.input.chrome.inputview.StateManager.prototype.isFinalSticky = function(
    stateType) {
  return (this.finalSticky_ & stateType) != 0;
};
i18n.input.chrome.inputview.StateManager.prototype.setFinalSticky = function(
    stateType, isFinalSticky) {
  if (isFinalSticky) {
    this.finalSticky_ |= stateType;
  } else {
    this.finalSticky_ &= ~stateType;
  }
};
i18n.input.chrome.inputview.StateManager.prototype.setSticky = function(
    stateType, isSticky) {
  if (isSticky) {
    this.sticky_ |= stateType;
  } else {
    this.sticky_ &= ~stateType;
  }
};
i18n.input.chrome.inputview.StateManager.prototype.isSticky = function(
    stateType) {
  return (this.sticky_ & stateType) != 0;
};
i18n.input.chrome.inputview.StateManager.prototype.setState = function(
    stateType, enable) {
  if (enable) {
    this.state_ = this.state_ | stateType;
  } else {
    this.state_ = this.state_ & ~stateType;
  }
};
i18n.input.chrome.inputview.StateManager.prototype.toggleState = function(
    stateType, isSticky) {
  var enable = !this.hasState(stateType);
  this.setState(stateType, enable);
  isSticky = enable ? isSticky : false;
  this.setSticky(stateType, isSticky);
};
i18n.input.chrome.inputview.StateManager.prototype.hasState = function(
    stateType) {
  return (this.state_ & stateType) != 0;
};
i18n.input.chrome.inputview.StateManager.prototype.getState =
    function() {
  return this.state_;
};
i18n.input.chrome.inputview.StateManager.prototype.clearUnstickyState =
    function() {
  this.state_ = this.state_ & this.sticky_;
};
i18n.input.chrome.inputview.StateManager.prototype.hasUnStickyState =
    function() {
  return this.state_ != this.sticky_;
};
i18n.input.chrome.inputview.StateManager.prototype.reset = function() {
  this.state_ = 0;
  this.sticky_ = 0;
};
});  // goog.scope

// i18n.input.chrome.inputview.Model
goog.provide('i18n.input.chrome.inputview.Model');
goog.scope(function() {
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
i18n.input.chrome.inputview.Model = function() {
  goog.base(this);
  this.stateManager = new i18n.input.chrome.inputview.StateManager();
  this.settings = new i18n.input.chrome.inputview.Settings();
  this.loadingResources_ = [];
  goog.exportSymbol('google.ime.chrome.inputview.onLayoutLoaded',
      goog.bind(this.onLayoutLoaded_, this));
  goog.exportSymbol('google.ime.chrome.inputview.onConfigLoaded',
      goog.bind(this.onConfigLoaded_, this));
};
var Model = i18n.input.chrome.inputview.Model;
goog.inherits(Model, goog.events.EventTarget);
Model.LAYOUTS_PATH_ =
    '/inputview_layouts/';
Model.CONTENT_PATH_ =
    '/config/';
Model.prototype.onConfigLoaded_ = function(data) {
  goog.array.remove(this.loadingResources_, this.getConfigUrl_(
      data[SpecNodeName.ID]));
  this.dispatchEvent(new i18n.input.chrome.inputview.events.ConfigLoadedEvent(
      data));
};
Model.prototype.getLayoutUrl_ = function(layout) {
  return Model.LAYOUTS_PATH_ + layout + '.js';
};
Model.prototype.getConfigUrl_ = function(keyset) {
  var configId = keyset.replace(/\..*$/, '');
  return Model.CONTENT_PATH_ + configId + '.js';
};
Model.prototype.onLayoutLoaded_ = function(data) {
  goog.array.remove(this.loadingResources_, this.getLayoutUrl_(data[
      SpecNodeName.LAYOUT_ID]));
  this.dispatchEvent(new i18n.input.chrome.inputview.events.LayoutLoadedEvent(
      data));
};
Model.prototype.loadLayout = function(layout) {
  var url = this.getLayoutUrl_(layout);
  if (!goog.array.contains(this.loadingResources_, url)) {
    this.loadingResources_.push(url);
    goog.net.jsloader.load(url);
  }
};
Model.prototype.loadConfig = function(keyboardCode) {
  var url = this.getConfigUrl_(keyboardCode);
  if (!goog.array.contains(this.loadingResources_, url)) {
    this.loadingResources_.push(url);
    goog.net.jsloader.load(url);
  }
};
});  // goog.scope

// i18n.input.chrome.inputview.PerfTracker
goog.provide('i18n.input.chrome.inputview.PerfTracker');
goog.scope(function() {
i18n.input.chrome.inputview.PerfTracker = function(
    htmlLoadedTickName) {
  this.startInMs_ = new Date().getTime();
  this.tick(htmlLoadedTickName,
      window['InputViewPageStartLoading'],
      'Time elapsed before 0');
};
var PerfTracker = i18n.input.chrome.inputview.PerfTracker;
PerfTracker.prototype.stopped_ = false;
PerfTracker.TickName = {
  BACKGROUND_HTML_LOADED: 'BackgroundHtmlLoaded',
  NACL_LOADED: 'NaclLoaded',
  BACKGROUND_SETTINGS_FETCHED: 'BackgroundSettingsFetched',
  HTML_LOADED: 'HtmlLoaded',
  KEYBOARD_CREATED: 'KeyboardCreated',
  KEYBOARD_SHOWN: 'KeyboardShown',
  KEYSET_LOADED: 'KeysetLoaded',
  LAYOUT_LOADED: 'LayoutLoaded'
};
PerfTracker.prototype.restart = function() {
  this.startInMs_ = new Date().getTime();
  this.stopped_ = false;
};
PerfTracker.prototype.stop = function() {
  this.stopped_ = true;
};
PerfTracker.prototype.tick = function(tickName, opt_startInMs, opt_msg) {
  if (this.stopped_) {
    return;
  }
  var startInMs = opt_startInMs || this.startInMs_;
  var cost = new Date().getTime() - startInMs;
  var msg = tickName + '  -  ' + cost;
  if (opt_msg) {
    msg += '  -  ' + opt_msg;
  }
  console.log(msg);
  i18n.input.chrome.Statistics.getInstance().recordLatency(
      'InputMethod.VirtualKeyboard.InitLatency.' + tickName, cost);
};
});  // goog.scope

// i18n.input.chrome.inputview.SizeSpec
goog.provide('i18n.input.chrome.inputview.SizeSpec');
goog.scope(function() {
var SizeSpec = i18n.input.chrome.inputview.SizeSpec;
SizeSpec.A11Y_HEIGHT = 280;
SizeSpec.NON_A11Y_HEIGHT = 372;
SizeSpec.A11Y_CANDIDATE_VIEW_HEIGHT = 30;
SizeSpec.NON_A11Y_CANDIDATE_VIEW_HEIGHT = 45;
SizeSpec.A11Y_WIDTH_PERCENT = {
  LANDSCAPE: 0.74,
  PORTRAIT: 1.0
};
SizeSpec.NON_A11Y_WIDTH_PERCENT = {
  'LANDSCAPE': 0.84,
  'LANDSCAPE_WIDE_SCREEN': 0.788,
  'PORTRAIT': 1.0
};
});  // goog.scope

// i18n.input.chrome.sounds.SoundController
goog.provide('i18n.input.chrome.sounds.SoundController');
goog.scope(function() {
var Sounds = i18n.input.chrome.sounds.Sounds;
var ElementType = i18n.input.chrome.ElementType;
var keyToSoundIdOnKeyUp = {};
var keyToSoundIdOnKeyRepeat = {};
i18n.input.chrome.sounds.SoundController = function(enabled, opt_volume) {
  this.sounds_ = {};
  this.enabled_ = enabled;
  this.volume_ = opt_volume || this.DEFAULT_VOLUME;
  if (enabled) {
    this.initialize();
  }
};
goog.inherits(i18n.input.chrome.sounds.SoundController, goog.Disposable);
var Controller = i18n.input.chrome.sounds.SoundController;
Controller.prototype.POOL_SIZE = 10;
Controller.prototype.DEFAULT_VOLUME = 0.6;
Controller.prototype.initialized_ = false;
Controller.prototype.initialize = function() {
  if (!this.initialized_) {
    for (var sound in Sounds) {
      this.addSound_(Sounds[sound]);
    }
    keyToSoundIdOnKeyUp[ElementType.BACKSPACE_KEY] = Sounds.NONE;
    keyToSoundIdOnKeyUp[ElementType.ENTER_KEY] = Sounds.RETURN;
    keyToSoundIdOnKeyUp[ElementType.SPACE_KEY] = Sounds.SPACEBAR;
    keyToSoundIdOnKeyRepeat[ElementType.BACKSPACE_KEY] = Sounds.DELETE;
    this.initialized_ = true;
  }
};
Controller.prototype.addSound_ = function(soundId) {
  if (soundId == Sounds.NONE || this.sounds_[soundId])
    return;
  var pool = [];
  for (var i = 0; i < this.POOL_SIZE; i++) {
    var audio = goog.dom.createDom('audio', {
      preload: 'auto',
      id: soundId,
      src: 'sounds/' + soundId + '.wav',
      volume: this.volume_
    });
    pool.push(audio);
  }
  this.sounds_[soundId] = pool;
};
Controller.prototype.setVolume = function(soundId, volume) {
  var pool = this.sounds_[soundId];
  if (!pool) {
    console.error('Cannot find sound: ' + soundId);
    return;
  }
  for (var i = 0; i < pool.length; i++) {
    pool[i].volume = volume;
  }
};
Controller.prototype.setEnabled = function(enabled) {
  this.enabled_ = enabled;
  if (this.enabled_) {
    this.initialize();
  }
};
Controller.prototype.getEnabled = function() {
  return this.enabled_;
};
Controller.prototype.setMasterVolume = function(volume) {
  this.volume_ = volume;
  for (var id in this.sounds_) {
    this.setVolume(id, volume);
  }
};
Controller.prototype.playSound = function(soundId, opt_force) {
  if (opt_force) {
    this.initialize();
  }
  if (!opt_force && !this.enabled_ || this.volume_ == 0 ||
      soundId == Sounds.NONE) {
    return;
  }
  var pool = this.sounds_[soundId];
  if (!pool) {
    console.error('Cannot find sound: ' + soundId);
    return;
  }
  for (var i = 0; i < pool.length; i++) {
    if (pool[i].paused) {
      pool[i].play();
      return;
    }
  }
};
Controller.prototype.onKeyUp = function(key) {
  var sound = keyToSoundIdOnKeyUp[key] || Sounds.STANDARD;
  this.playSound(sound);
};
Controller.prototype.onKeyRepeat = function(key) {
  var sound = keyToSoundIdOnKeyRepeat[key] || Sounds.NONE;
  this.playSound(sound);
};
Controller.prototype.disposeInternal = function() {
  for (var soundId in this.sounds_) {
    var pool = this.sounds_[soundId];
    for (var i = 0; i < pool.length; i++) {
      var tag = pool[i];
      if (tag && tag.loaded) {
        tag.pause();
        tag.autoplay = false;
        tag.loop = false;
        tag.currentTime = 0;
      }
    }
    delete this.sounds_[soundId];
  }
  this.sounds_ = {};
  keyToSoundIdOnKeyUp = {};
  keyToSoundIdOnKeyRepeat = {};
  goog.base(this, 'disposeInternal');
};
});  // goog.scope

// i18n.input.chrome.inputview.Controller
goog.provide('i18n.input.chrome.inputview.Controller');
goog.scope(function() {
var CandidateType = i18n.input.chrome.inputview.elements.content.Candidate.Type;
var CandidateView = i18n.input.chrome.inputview.elements.content.CandidateView;
var ConditionName = i18n.input.chrome.inputview.ConditionName;
var ContextType = i18n.input.chrome.message.ContextType;
var Css = i18n.input.chrome.inputview.Css;
var ElementType = i18n.input.chrome.ElementType;
var EventType = i18n.input.chrome.inputview.events.EventType;
var ExpandedCandidateView = i18n.input.chrome.inputview.elements.content.
    ExpandedCandidateView;
var FeatureName = i18n.input.chrome.FeatureName;
var InputToolCode = i18n.input.lang.InputToolCode;
var KeyCodes = i18n.input.chrome.events.KeyCodes;
var MenuView = i18n.input.chrome.inputview.elements.content.MenuView;
var Name = i18n.input.chrome.message.Name;
var PerfTracker = i18n.input.chrome.inputview.PerfTracker;
var SizeSpec = i18n.input.chrome.inputview.SizeSpec;
var SpecNodeName = i18n.input.chrome.inputview.SpecNodeName;
var StateType = i18n.input.chrome.inputview.StateType;
var SoundController = i18n.input.chrome.sounds.SoundController;
var Type = i18n.input.chrome.message.Type;
var events = i18n.input.chrome.inputview.events;
var util = i18n.input.chrome.inputview.util;
var BACKSPACE_REPEAT_START_TIME_MS = 300;
var MINIMUM_BACKSPACE_REPEAT_TIME_MS = 25;
var MAXIMUM_BACKSPACE_REPEAT_TIME_MS = 75;
var BACKSPACE_REPEAT_LIMIT = 255;
var GESTURE_PREVIEW_LINGER_TIME_MS = 250;
var MAXIMUM_DISTANCE_FROM_TOP_FOR_GESTURES = 40;
var HOTROD_DEFAULT_KEYSET = 'hotrod';
i18n.input.chrome.inputview.Controller = function(keyset, languageCode,
    passwordLayout, name) {
  this.model_ = new i18n.input.chrome.inputview.Model();
  this.perfTracker_ = new i18n.input.chrome.inputview.PerfTracker(
      PerfTracker.TickName.HTML_LOADED);
  this.layoutDataMap_ = {};
  this.elementTypeToKeyCode_ = goog.object.create(
      ElementType.BOLD, KeyCodes.KEY_B,
      ElementType.ITALICS, KeyCodes.KEY_I,
      ElementType.UNDERLINE, KeyCodes.KEY_U,
      ElementType.COPY, KeyCodes.KEY_C,
      ElementType.PASTE, KeyCodes.KEY_V,
      ElementType.CUT, KeyCodes.KEY_X,
      ElementType.SELECT_ALL, KeyCodes.KEY_A,
      ElementType.REDO, KeyCodes.KEY_Y,
      ElementType.UNDO, KeyCodes.KEY_Z
      );
  this.keysetDataMap_ = {};
  this.handler_ = new goog.events.EventHandler(this);
  this.m17nModel_ = new i18n.input.chrome.inputview.M17nModel();
  this.pointerHandler_ = new i18n.input.chrome.inputview.handler.
      PointerHandler();
  this.statistics_ = i18n.input.chrome.Statistics.getInstance();
  this.readyState_ = new i18n.input.chrome.inputview.ReadyState();
  this.adapter_ = new i18n.input.chrome.inputview.Adapter(this.readyState_);
  this.soundController_ = new SoundController(false);
  this.container_ = new i18n.input.chrome.inputview.KeyboardContainer(
      this.adapter_, this.soundController_);
  this.contextTypeToKeysetMap_ = {};
  this.contextTypeToLastKeysetMap_ = {};
  this.statsForClosing_ = {};
  this.lastPointTime_ = 0;
  this.lastResizeHeight_ = -1;
  this.showTimeStamp_ = new Date();
  this.initialize(keyset, languageCode, passwordLayout, name);
  this.candidatesInfo_ = i18n.input.chrome.inputview.CandidatesInfo.getEmpty();
  this.registerEventHandler_();
};
goog.inherits(i18n.input.chrome.inputview.Controller, goog.Disposable);
var Controller = i18n.input.chrome.inputview.Controller;
var Statistics = i18n.input.chrome.Statistics;
Controller.DISABLE_DELAY_LOADING_FOR_TEST = false;
Controller.DISABLE_HWT = false;
Controller.prototype.shiftForAutoCapital_ = false;
Controller.DEV = false;
Controller.HANDWRITING_VIEW_CODE_ = 'hwt';
Controller.EMOJI_VIEW_CODE_ = 'emoji';
Controller.prototype.backspaceRepeated_ = 0;
Controller.HANDWRITING_CODE_SUFFIX_ = '-t-i0-handwrit';
Controller.US_COMPACT_QWERTY_CODE_ = 'us.compact.qwerty';
Controller.SUBSAMPLING_TIME_THRESHOLD = 100;
Controller.prototype.isSettingReady = false;
Controller.prototype.isKeyboardReady = false;
Controller.prototype.isKeysetUSCompact_ = false;
Controller.prototype.backspaceAutoRepeat_;
Controller.prototype.initialKeyset_ = '';
Controller.prototype.currentKeyset_ = '';
Controller.prototype.currentInputmethod_ = '';
Controller.CandidatesOperation = {
  NONE: 0,
  EXPAND: 1,
  SHRINK: 2
};
Controller.MATERIAL_KEYSETS_ = [
  'emoji',
  'hwt'
];
Controller.prototype.lang_;
Controller.prototype.passwordKeyset_ = '';
Controller.prototype.softKeyList_;
Controller.prototype.mapping_;
Controller.prototype.title_;
Controller.prototype.returnToLetterKeysetOnSpace_ = false;
Controller.prototype.gestureResultsCache_;
Controller.prototype.registerEventHandler_ = function() {
  this.handler_.
      listen(this.model_,
          EventType.LAYOUT_LOADED,
          this.onLayoutLoaded_).
      listen(this.model_,
          EventType.CONFIG_LOADED,
          this.onConfigLoaded_).
      listen(this.m17nModel_,
          EventType.CONFIG_LOADED,
          this.onConfigLoaded_).
      listen(this.pointerHandler_, [
            EventType.LONG_PRESS,
            EventType.CLICK,
            EventType.DOUBLE_CLICK,
            EventType.DOUBLE_CLICK_END,
            EventType.POINTER_UP,
            EventType.POINTER_DOWN,
            EventType.POINTER_OVER,
            EventType.POINTER_OUT,
            EventType.SWIPE
          ], this.onPointerEvent_).
      listen(this.pointerHandler_,
          EventType.DRAG,
          this.onDragEvent_).
      listen(window, goog.events.EventType.RESIZE, this.resize).
      listen(this.adapter_,
          EventType.SURROUNDING_TEXT_CHANGED, this.onSurroundingTextChanged_).
      listen(this.adapter_,
          i18n.input.chrome.DataSource.EventType.CANDIDATES_BACK,
          this.onCandidatesBack_).
      listen(this.adapter_,
          i18n.input.chrome.DataSource.EventType.GESTURES_BACK,
          this.onGesturesBack_).
      listen(this.adapter_, EventType.URL_CHANGED, this.onURLChanged_).
      listen(this.adapter_, EventType.CONTEXT_FOCUS, this.onContextFocus_).
      listen(this.adapter_, EventType.CONTEXT_BLUR, this.onContextBlur_).
      listen(this.adapter_, EventType.VISIBILITY_CHANGE,
          this.onVisibilityChange_).
      listen(this.adapter_, EventType.SETTINGS_READY, this.onSettingsReady_).
      listen(this.adapter_, EventType.UPDATE_SETTINGS, this.onUpdateSettings_).
      listen(this.adapter_, EventType.FRONT_TOGGLE_LANGUAGE_STATE,
          this.onUpdateToggleLanguageState_).
      listen(this.adapter_, EventType.VOICE_STATE_CHANGE,
          this.onVoiceStateChange_).
      listen(this.adapter_, EventType.REFRESH, this.onRefresh_);
};
Controller.prototype.onVoiceStateChange_ = function(e) {
  if (!e.msg[Name.VOICE_STATE]) {
    this.container_.candidateView.switchToIcon(
        CandidateView.IconType.VOICE, true);
    this.container_.voiceView.stop();
  }
};
Controller.prototype.onRefresh_ = function() {
  window.location.reload();
};
Controller.prototype.setDefaultKeyset_ = function(newKeyset) {
  var keysetMap = this.contextTypeToKeysetMap_[this.currentInputMethod_];
  for (var context in keysetMap) {
    if (context != ContextType.DEFAULT &&
        keysetMap[context] == keysetMap[ContextType.DEFAULT]) {
      keysetMap[context] = newKeyset;
    }
  }
  keysetMap[ContextType.DEFAULT] = this.initialKeyset_ = newKeyset;
};
Controller.prototype.onUpdateSettings_ = function(e) {
  var settings = this.model_.settings;
  if (goog.isDef(e.msg['autoSpace'])) {
    settings.autoSpace = e.msg['autoSpace'];
  }
  if (goog.isDef(e.msg['autoCapital'])) {
    settings.autoCapital = e.msg['autoCapital'];
  }
  if (goog.isDef(e.msg['candidatesNavigation'])) {
    settings.candidatesNavigation = e.msg['candidatesNavigation'];
    this.container_.candidateView.setNavigation(settings.candidatesNavigation);
  }
  if (goog.isDef(e.msg[Name.KEYSET])) {
    this.setDefaultKeyset_(e.msg[Name.KEYSET]);
  }
  if (goog.isDef(e.msg['enableLongPress'])) {
    settings.enableLongPress = e.msg['enableLongPress'];
  }
  if (goog.isDef(e.msg['doubleSpacePeriod'])) {
    settings.doubleSpacePeriod = e.msg['doubleSpacePeriod'];
  }
  if (goog.isDef(e.msg['soundOnKeypress'])) {
    settings.soundOnKeypress = e.msg['soundOnKeypress'];
    this.soundController_.setEnabled(settings.soundOnKeypress);
  }
  if (goog.isDef(e.msg['gestureEditing'])) {
    settings.gestureEditing = e.msg['gestureEditing'];
    var enabled = settings.gestureEditing && !this.adapter_.isA11yMode &&
        !this.adapter_.isHotrod &&
        !this.adapter_.isFloatingVirtualKeyboardEnabled();
    this.container_.swipeView.enabled = enabled;
    this.container_.selectView.setSettingsEnabled(enabled);
  }
  if (goog.isDef(e.msg['gestureTyping'])) {
    settings.gestureTyping = e.msg['gestureTyping'];
  } else {
    settings.gestureTyping = false;
  }
  this.perfTracker_.tick(PerfTracker.TickName.BACKGROUND_SETTINGS_FETCHED);
  this.model_.stateManager.contextType = this.adapter_.contextType;
  this.maybeCreateViews_();
};
Controller.prototype.onURLChanged_ = function() {
  this.container_.candidateView.setToolbarVisible(this.shouldShowToolBar_());
};
Controller.prototype.onSettingsReady_ = function() {
  if (this.isSettingReady) {
    return;
  }
  this.isSettingReady = true;
  if (!this.container_.isInDocument()) {
    this.container_.render();
  }
  var keysetMap = this.contextTypeToKeysetMap_[this.currentInputMethod_];
  var newKeyset = '';
  if (this.