// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{ConnectionStateTypeSpec as chromeos_networkConfig_mojom_ConnectionStateTypeSpec}from"//resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js";import{JSTimeSpec as mojoBase_mojom_JSTimeSpec,TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec}from"//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import{ValueSpec as mojoBase_mojom_ValueSpec}from"//resources/mojo/mojo/public/mojom/base/values.mojom-webui.js";import{BitmapN32Spec as skia_mojom_BitmapN32Spec}from"//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export const MaterialTypeSpec={$:mojo.internal.Enum()};export var MaterialType;(function(MaterialType){MaterialType[MaterialType["MIN_VALUE"]=0]="MIN_VALUE";MaterialType[MaterialType["MAX_VALUE"]=4]="MAX_VALUE";MaterialType[MaterialType["kUnknown"]=0]="kUnknown";MaterialType[MaterialType["kSharedDriveFile"]=1]="kSharedDriveFile";MaterialType[MaterialType["kYoutubeVideo"]=2]="kYoutubeVideo";MaterialType[MaterialType["kLink"]=3]="kLink";MaterialType[MaterialType["kForm"]=4]="kForm"})(MaterialType||(MaterialType={}));export const AssignmentTypeSpec={$:mojo.internal.Enum()};export var AssignmentType;(function(AssignmentType){AssignmentType[AssignmentType["MIN_VALUE"]=0]="MIN_VALUE";AssignmentType[AssignmentType["MAX_VALUE"]=3]="MAX_VALUE";AssignmentType[AssignmentType["kUnspecified"]=0]="kUnspecified";AssignmentType[AssignmentType["kAssignment"]=1]="kAssignment";AssignmentType[AssignmentType["kShortAnswerQuestion"]=2]="kShortAnswerQuestion";AssignmentType[AssignmentType["kMultipleChoiceQuestion"]=3]="kMultipleChoiceQuestion"})(AssignmentType||(AssignmentType={}));export const NetworkTypeSpec={$:mojo.internal.Enum()};export var NetworkType;(function(NetworkType){NetworkType[NetworkType["MIN_VALUE"]=0]="MIN_VALUE";NetworkType[NetworkType["MAX_VALUE"]=3]="MAX_VALUE";NetworkType[NetworkType["kCellular"]=0]="kCellular";NetworkType[NetworkType["kEthernet"]=1]="kEthernet";NetworkType[NetworkType["kWiFi"]=2]="kWiFi";NetworkType[NetworkType["kUnsupported"]=3]="kUnsupported"})(NetworkType||(NetworkType={}));export const PermissionSpec={$:mojo.internal.Enum()};export var Permission;(function(Permission){Permission[Permission["MIN_VALUE"]=0]="MIN_VALUE";Permission[Permission["MAX_VALUE"]=1]="MAX_VALUE";Permission[Permission["kMicrophone"]=0]="kMicrophone";Permission[Permission["kCamera"]=1]="kCamera"})(Permission||(Permission={}));export const PermissionSettingSpec={$:mojo.internal.Enum()};export var PermissionSetting;(function(PermissionSetting){PermissionSetting[PermissionSetting["MIN_VALUE"]=0]="MIN_VALUE";PermissionSetting[PermissionSetting["MAX_VALUE"]=2]="MAX_VALUE";PermissionSetting[PermissionSetting["kAllow"]=0]="kAllow";PermissionSetting[PermissionSetting["kAsk"]=1]="kAsk";PermissionSetting[PermissionSetting["kBlock"]=2]="kBlock"})(PermissionSetting||(PermissionSetting={}));export const NavigationTypeSpec={$:mojo.internal.Enum()};export var NavigationType;(function(NavigationType){NavigationType[NavigationType["MIN_VALUE"]=0]="MIN_VALUE";NavigationType[NavigationType["MAX_VALUE"]=6]="MAX_VALUE";NavigationType[NavigationType["kUnknown"]=0]="kUnknown";NavigationType[NavigationType["kOpen"]=1]="kOpen";NavigationType[NavigationType["kBlock"]=2]="kBlock";NavigationType[NavigationType["kDomain"]=3]="kDomain";NavigationType[NavigationType["kLimited"]=4]="kLimited";NavigationType[NavigationType["kSameDomainOpenOtherDomainLimited"]=5]="kSameDomainOpenOtherDomainLimited";NavigationType[NavigationType["kWorkspace"]=6]="kWorkspace"})(NavigationType||(NavigationType={}));export const JoinMethodSpec={$:mojo.internal.Enum()};export var JoinMethod;(function(JoinMethod){JoinMethod[JoinMethod["MIN_VALUE"]=0]="MIN_VALUE";JoinMethod[JoinMethod["MAX_VALUE"]=1]="MAX_VALUE";JoinMethod[JoinMethod["kRoster"]=0]="kRoster";JoinMethod[JoinMethod["kAccessCode"]=1]="kAccessCode"})(JoinMethod||(JoinMethod={}));export const BocaValidPrefSpec={$:mojo.internal.Enum()};export var BocaValidPref;(function(BocaValidPref){BocaValidPref[BocaValidPref["MIN_VALUE"]=0]="MIN_VALUE";BocaValidPref[BocaValidPref["MAX_VALUE"]=4]="MAX_VALUE";BocaValidPref[BocaValidPref["kNavigationSetting"]=0]="kNavigationSetting";BocaValidPref[BocaValidPref["kCaptionEnablementSetting"]=1]="kCaptionEnablementSetting";BocaValidPref[BocaValidPref["kDefaultMediaStreamSetting"]=2]="kDefaultMediaStreamSetting";BocaValidPref[BocaValidPref["kOOBEAccessCount"]=3]="kOOBEAccessCount";BocaValidPref[BocaValidPref["kKioskReceiverCodes"]=4]="kKioskReceiverCodes"})(BocaValidPref||(BocaValidPref={}));export const StudentStatusDetailSpec={$:mojo.internal.Enum()};export var StudentStatusDetail;(function(StudentStatusDetail){StudentStatusDetail[StudentStatusDetail["MIN_VALUE"]=0]="MIN_VALUE";StudentStatusDetail[StudentStatusDetail["MAX_VALUE"]=9]="MAX_VALUE";StudentStatusDetail[StudentStatusDetail["kUnknown"]=0]="kUnknown";StudentStatusDetail[StudentStatusDetail["kNotFound"]=1]="kNotFound";StudentStatusDetail[StudentStatusDetail["kAdded"]=2]="kAdded";StudentStatusDetail[StudentStatusDetail["kActive"]=3]="kActive";StudentStatusDetail[StudentStatusDetail["kRemovedByOtherSession"]=4]="kRemovedByOtherSession";StudentStatusDetail[StudentStatusDetail["kRemovedByBeingTeacher"]=5]="kRemovedByBeingTeacher";StudentStatusDetail[StudentStatusDetail["kRemovedByTeacher"]=6]="kRemovedByTeacher";StudentStatusDetail[StudentStatusDetail["kNotAddedConfiguredAsTeacher"]=7]="kNotAddedConfiguredAsTeacher";StudentStatusDetail[StudentStatusDetail["kNotAddedNotConfigured"]=8]="kNotAddedNotConfigured";StudentStatusDetail[StudentStatusDetail["kMultipleDeviceSignedIn"]=9]="kMultipleDeviceSignedIn"})(StudentStatusDetail||(StudentStatusDetail={}));export const GetSessionErrorSpec={$:mojo.internal.Enum()};export var GetSessionError;(function(GetSessionError){GetSessionError[GetSessionError["MIN_VALUE"]=0]="MIN_VALUE";GetSessionError[GetSessionError["MAX_VALUE"]=1]="MAX_VALUE";GetSessionError[GetSessionError["kHTTPError"]=0]="kHTTPError";GetSessionError[GetSessionError["kEmpty"]=1]="kEmpty"})(GetSessionError||(GetSessionError={}));export const UpdateSessionErrorSpec={$:mojo.internal.Enum()};export var UpdateSessionError;(function(UpdateSessionError){UpdateSessionError[UpdateSessionError["MIN_VALUE"]=0]="MIN_VALUE";UpdateSessionError[UpdateSessionError["MAX_VALUE"]=2]="MAX_VALUE";UpdateSessionError[UpdateSessionError["kInvalid"]=0]="kInvalid";UpdateSessionError[UpdateSessionError["kHTTPError"]=1]="kHTTPError";UpdateSessionError[UpdateSessionError["kPreconditionFailed"]=2]="kPreconditionFailed"})(UpdateSessionError||(UpdateSessionError={}));export const RemoveStudentErrorSpec={$:mojo.internal.Enum()};export var RemoveStudentError;(function(RemoveStudentError){RemoveStudentError[RemoveStudentError["MIN_VALUE"]=0]="MIN_VALUE";RemoveStudentError[RemoveStudentError["MAX_VALUE"]=1]="MAX_VALUE";RemoveStudentError[RemoveStudentError["kInvalid"]=0]="kInvalid";RemoveStudentError[RemoveStudentError["kHTTPError"]=1]="kHTTPError"})(RemoveStudentError||(RemoveStudentError={}));export const RenotifyStudentErrorSpec={$:mojo.internal.Enum()};export var RenotifyStudentError;(function(RenotifyStudentError){RenotifyStudentError[RenotifyStudentError["MIN_VALUE"]=0]="MIN_VALUE";RenotifyStudentError[RenotifyStudentError["MAX_VALUE"]=1]="MAX_VALUE";RenotifyStudentError[RenotifyStudentError["kInvalid"]=0]="kInvalid";RenotifyStudentError[RenotifyStudentError["kHTTPError"]=1]="kHTTPError"})(RenotifyStudentError||(RenotifyStudentError={}));export const AddStudentsErrorSpec={$:mojo.internal.Enum()};export var AddStudentsError;(function(AddStudentsError){AddStudentsError[AddStudentsError["MIN_VALUE"]=0]="MIN_VALUE";AddStudentsError[AddStudentsError["MAX_VALUE"]=1]="MAX_VALUE";AddStudentsError[AddStudentsError["kInvalid"]=0]="kInvalid";AddStudentsError[AddStudentsError["kHTTPError"]=1]="kHTTPError"})(AddStudentsError||(AddStudentsError={}));export const SubmitAccessCodeErrorSpec={$:mojo.internal.Enum()};export var SubmitAccessCodeError;(function(SubmitAccessCodeError){SubmitAccessCodeError[SubmitAccessCodeError["MIN_VALUE"]=0]="MIN_VALUE";SubmitAccessCodeError[SubmitAccessCodeError["MAX_VALUE"]=1]="MAX_VALUE";SubmitAccessCodeError[SubmitAccessCodeError["kInvalid"]=0]="kInvalid";SubmitAccessCodeError[SubmitAccessCodeError["kNetworkRestriction"]=1]="kNetworkRestriction"})(SubmitAccessCodeError||(SubmitAccessCodeError={}));export const ViewStudentScreenErrorSpec={$:mojo.internal.Enum()};export var ViewStudentScreenError;(function(ViewStudentScreenError){ViewStudentScreenError[ViewStudentScreenError["MIN_VALUE"]=0]="MIN_VALUE";ViewStudentScreenError[ViewStudentScreenError["MAX_VALUE"]=0]="MAX_VALUE";ViewStudentScreenError[ViewStudentScreenError["kHTTPError"]=0]="kHTTPError"})(ViewStudentScreenError||(ViewStudentScreenError={}));export const EndViewScreenSessionErrorSpec={$:mojo.internal.Enum()};export var EndViewScreenSessionError;(function(EndViewScreenSessionError){EndViewScreenSessionError[EndViewScreenSessionError["MIN_VALUE"]=0]="MIN_VALUE";EndViewScreenSessionError[EndViewScreenSessionError["MAX_VALUE"]=0]="MAX_VALUE";EndViewScreenSessionError[EndViewScreenSessionError["kHTTPError"]=0]="kHTTPError"})(EndViewScreenSessionError||(EndViewScreenSessionError={}));export const SetViewScreenSessionActiveErrorSpec={$:mojo.internal.Enum()};export var SetViewScreenSessionActiveError;(function(SetViewScreenSessionActiveError){SetViewScreenSessionActiveError[SetViewScreenSessionActiveError["MIN_VALUE"]=0]="MIN_VALUE";SetViewScreenSessionActiveError[SetViewScreenSessionActiveError["MAX_VALUE"]=0]="MAX_VALUE";SetViewScreenSessionActiveError[SetViewScreenSessionActiveError["kHTTPError"]=0]="kHTTPError"})(SetViewScreenSessionActiveError||(SetViewScreenSessionActiveError={}));export const SpeechRecognitionInstallStateSpec={$:mojo.internal.Enum()};export var SpeechRecognitionInstallState;(function(SpeechRecognitionInstallState){SpeechRecognitionInstallState[SpeechRecognitionInstallState["MIN_VALUE"]=0]="MIN_VALUE";SpeechRecognitionInstallState[SpeechRecognitionInstallState["MAX_VALUE"]=4]="MAX_VALUE";SpeechRecognitionInstallState[SpeechRecognitionInstallState["kUnknown"]=0]="kUnknown";SpeechRecognitionInstallState[SpeechRecognitionInstallState["kSystemLanguageUnsupported"]=1]="kSystemLanguageUnsupported";SpeechRecognitionInstallState[SpeechRecognitionInstallState["kInProgress"]=2]="kInProgress";SpeechRecognitionInstallState[SpeechRecognitionInstallState["kFailed"]=3]="kFailed";SpeechRecognitionInstallState[SpeechRecognitionInstallState["kReady"]=4]="kReady"})(SpeechRecognitionInstallState||(SpeechRecognitionInstallState={}));export const CreateSessionErrorSpec={$:mojo.internal.Enum()};export var CreateSessionError;(function(CreateSessionError){CreateSessionError[CreateSessionError["MIN_VALUE"]=0]="MIN_VALUE";CreateSessionError[CreateSessionError["MAX_VALUE"]=1]="MAX_VALUE";CreateSessionError[CreateSessionError["kHTTPError"]=0]="kHTTPError";CreateSessionError[CreateSessionError["kNetworkRestriction"]=1]="kNetworkRestriction"})(CreateSessionError||(CreateSessionError={}));export const CrdConnectionStateSpec={$:mojo.internal.Enum()};export var CrdConnectionState;(function(CrdConnectionState){CrdConnectionState[CrdConnectionState["MIN_VALUE"]=0]="MIN_VALUE";CrdConnectionState[CrdConnectionState["MAX_VALUE"]=4]="MAX_VALUE";CrdConnectionState[CrdConnectionState["kUnknown"]=0]="kUnknown";CrdConnectionState[CrdConnectionState["kConnecting"]=1]="kConnecting";CrdConnectionState[CrdConnectionState["kConnected"]=2]="kConnected";CrdConnectionState[CrdConnectionState["kDisconnected"]=3]="kDisconnected";CrdConnectionState[CrdConnectionState["kFailed"]=4]="kFailed"})(CrdConnectionState||(CrdConnectionState={}));export class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.boca.mojom.PageHandler",scope)}}export class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}authenticateWebview(){return this.proxy.sendMessage(0,PageHandler_AuthenticateWebview_ParamsSpec.$,PageHandler_AuthenticateWebview_ResponseParamsSpec.$,[],false)}getWindowsTabsList(){return this.proxy.sendMessage(1,PageHandler_GetWindowsTabsList_ParamsSpec.$,PageHandler_GetWindowsTabsList_ResponseParamsSpec.$,[],false)}listCourses(){return this.proxy.sendMessage(2,PageHandler_ListCourses_ParamsSpec.$,PageHandler_ListCourses_ResponseParamsSpec.$,[],false)}listStudents(courseId){return this.proxy.sendMessage(3,PageHandler_ListStudents_ParamsSpec.$,PageHandler_ListStudents_ResponseParamsSpec.$,[courseId],false)}listAssignments(courseId){return this.proxy.sendMessage(4,PageHandler_ListAssignments_ParamsSpec.$,PageHandler_ListAssignments_ResponseParamsSpec.$,[courseId],false)}createSession(config){return this.proxy.sendMessage(5,PageHandler_CreateSession_ParamsSpec.$,PageHandler_CreateSession_ResponseParamsSpec.$,[config],false)}getSession(){return this.proxy.sendMessage(6,PageHandler_GetSession_ParamsSpec.$,PageHandler_GetSession_ResponseParamsSpec.$,[],false)}endSession(){return this.proxy.sendMessage(7,PageHandler_EndSession_ParamsSpec.$,PageHandler_EndSession_ResponseParamsSpec.$,[],false)}extendSessionDuration(extendedDuration){return this.proxy.sendMessage(8,PageHandler_ExtendSessionDuration_ParamsSpec.$,PageHandler_ExtendSessionDuration_ResponseParamsSpec.$,[extendedDuration],false)}removeStudent(studentId){return this.proxy.sendMessage(9,PageHandler_RemoveStudent_ParamsSpec.$,PageHandler_RemoveStudent_ResponseParamsSpec.$,[studentId],false)}renotifyStudent(studentId){return this.proxy.sendMessage(10,PageHandler_RenotifyStudent_ParamsSpec.$,PageHandler_RenotifyStudent_ResponseParamsSpec.$,[studentId],false)}addStudents(students){return this.proxy.sendMessage(11,PageHandler_AddStudents_ParamsSpec.$,PageHandler_AddStudents_ResponseParamsSpec.$,[students],false)}updateOnTaskConfig(onTaskConfig){return this.proxy.sendMessage(12,PageHandler_UpdateOnTaskConfig_ParamsSpec.$,PageHandler_UpdateOnTaskConfig_ResponseParamsSpec.$,[onTaskConfig],false)}updateCaptionConfig(captionConfig){return this.proxy.sendMessage(13,PageHandler_UpdateCaptionConfig_ParamsSpec.$,PageHandler_UpdateCaptionConfig_ResponseParamsSpec.$,[captionConfig],false)}setFloatMode(isFloatMode){return this.proxy.sendMessage(14,PageHandler_SetFloatMode_ParamsSpec.$,PageHandler_SetFloatMode_ResponseParamsSpec.$,[isFloatMode],false)}submitAccessCode(accessCode){return this.proxy.sendMessage(15,PageHandler_SubmitAccessCode_ParamsSpec.$,PageHandler_SubmitAccessCode_ResponseParamsSpec.$,[accessCode],false)}viewStudentScreen(id){return this.proxy.sendMessage(16,PageHandler_ViewStudentScreen_ParamsSpec.$,PageHandler_ViewStudentScreen_ResponseParamsSpec.$,[id],false)}endViewScreenSession(id){return this.proxy.sendMessage(17,PageHandler_EndViewScreenSession_ParamsSpec.$,PageHandler_EndViewScreenSession_ResponseParamsSpec.$,[id],false)}setViewScreenSessionActive(id){return this.proxy.sendMessage(18,PageHandler_SetViewScreenSessionActive_ParamsSpec.$,PageHandler_SetViewScreenSessionActive_ResponseParamsSpec.$,[id],false)}getUserPref(pref){return this.proxy.sendMessage(19,PageHandler_GetUserPref_ParamsSpec.$,PageHandler_GetUserPref_ResponseParamsSpec.$,[pref],false)}setUserPref(pref,value){return this.proxy.sendMessage(20,PageHandler_SetUserPref_ParamsSpec.$,PageHandler_SetUserPref_ResponseParamsSpec.$,[pref,value],false)}setSitePermission(url,permission,setting){return this.proxy.sendMessage(21,PageHandler_SetSitePermission_ParamsSpec.$,PageHandler_SetSitePermission_ResponseParamsSpec.$,[url,permission,setting],false)}closeTab(tabId){return this.proxy.sendMessage(22,PageHandler_CloseTab_ParamsSpec.$,PageHandler_CloseTab_ResponseParamsSpec.$,[tabId],false)}openFeedbackDialog(){return this.proxy.sendMessage(23,PageHandler_OpenFeedbackDialog_ParamsSpec.$,PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,[],false)}refreshWorkbook(){return this.proxy.sendMessage(24,PageHandler_RefreshWorkbook_ParamsSpec.$,PageHandler_RefreshWorkbook_ResponseParamsSpec.$,[],false)}getSpeechRecognitionInstallationStatus(){return this.proxy.sendMessage(25,PageHandler_GetSpeechRecognitionInstallationStatus_ParamsSpec.$,PageHandler_GetSpeechRecognitionInstallationStatus_ResponseParamsSpec.$,[],false)}startSpotlight(crdConnectionCode){return this.proxy.sendMessage(26,PageHandler_StartSpotlight_ParamsSpec.$,PageHandler_StartSpotlight_ResponseParamsSpec.$,[crdConnectionCode],false)}presentStudentScreen(student,receiverId){return this.proxy.sendMessage(27,PageHandler_PresentStudentScreen_ParamsSpec.$,PageHandler_PresentStudentScreen_ResponseParamsSpec.$,[student,receiverId],false)}stopPresentingStudentScreen(){return this.proxy.sendMessage(28,PageHandler_StopPresentingStudentScreen_ParamsSpec.$,PageHandler_StopPresentingStudentScreen_ResponseParamsSpec.$,[],false)}presentOwnScreen(receiverId){return this.proxy.sendMessage(29,PageHandler_PresentOwnScreen_ParamsSpec.$,PageHandler_PresentOwnScreen_ResponseParamsSpec.$,[receiverId],false)}stopPresentingOwnScreen(){return this.proxy.sendMessage(30,PageHandler_StopPresentingOwnScreen_ParamsSpec.$,PageHandler_StopPresentingOwnScreen_ResponseParamsSpec.$,[],false)}}export class PageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_AuthenticateWebview_ParamsSpec.$,PageHandler_AuthenticateWebview_ResponseParamsSpec.$,impl.authenticateWebview.bind(impl),false);this.helper_internal_.registerHandler(1,PageHandler_GetWindowsTabsList_ParamsSpec.$,PageHandler_GetWindowsTabsList_ResponseParamsSpec.$,impl.getWindowsTabsList.bind(impl),false);this.helper_internal_.registerHandler(2,PageHandler_ListCourses_ParamsSpec.$,PageHandler_ListCourses_ResponseParamsSpec.$,impl.listCourses.bind(impl),false);this.helper_internal_.registerHandler(3,PageHandler_ListStudents_ParamsSpec.$,PageHandler_ListStudents_ResponseParamsSpec.$,impl.listStudents.bind(impl),false);this.helper_internal_.registerHandler(4,PageHandler_ListAssignments_ParamsSpec.$,PageHandler_ListAssignments_ResponseParamsSpec.$,impl.listAssignments.bind(impl),false);this.helper_internal_.registerHandler(5,PageHandler_CreateSession_ParamsSpec.$,PageHandler_CreateSession_ResponseParamsSpec.$,impl.createSession.bind(impl),false);this.helper_internal_.registerHandler(6,PageHandler_GetSession_ParamsSpec.$,PageHandler_GetSession_ResponseParamsSpec.$,impl.getSession.bind(impl),false);this.helper_internal_.registerHandler(7,PageHandler_EndSession_ParamsSpec.$,PageHandler_EndSession_ResponseParamsSpec.$,impl.endSession.bind(impl),false);this.helper_internal_.registerHandler(8,PageHandler_ExtendSessionDuration_ParamsSpec.$,PageHandler_ExtendSessionDuration_ResponseParamsSpec.$,impl.extendSessionDuration.bind(impl),false);this.helper_internal_.registerHandler(9,PageHandler_RemoveStudent_ParamsSpec.$,PageHandler_RemoveStudent_ResponseParamsSpec.$,impl.removeStudent.bind(impl),false);this.helper_internal_.registerHandler(10,PageHandler_RenotifyStudent_ParamsSpec.$,PageHandler_RenotifyStudent_ResponseParamsSpec.$,impl.renotifyStudent.bind(impl),false);this.helper_internal_.registerHandler(11,PageHandler_AddStudents_ParamsSpec.$,PageHandler_AddStudents_ResponseParamsSpec.$,impl.addStudents.bind(impl),false);this.helper_internal_.registerHandler(12,PageHandler_UpdateOnTaskConfig_ParamsSpec.$,PageHandler_UpdateOnTaskConfig_ResponseParamsSpec.$,impl.updateOnTaskConfig.bind(impl),false);this.helper_internal_.registerHandler(13,PageHandler_UpdateCaptionConfig_ParamsSpec.$,PageHandler_UpdateCaptionConfig_ResponseParamsSpec.$,impl.updateCaptionConfig.bind(impl),false);this.helper_internal_.registerHandler(14,PageHandler_SetFloatMode_ParamsSpec.$,PageHandler_SetFloatMode_ResponseParamsSpec.$,impl.setFloatMode.bind(impl),false);this.helper_internal_.registerHandler(15,PageHandler_SubmitAccessCode_ParamsSpec.$,PageHandler_SubmitAccessCode_ResponseParamsSpec.$,impl.submitAccessCode.bind(impl),false);this.helper_internal_.registerHandler(16,PageHandler_ViewStudentScreen_ParamsSpec.$,PageHandler_ViewStudentScreen_ResponseParamsSpec.$,impl.viewStudentScreen.bind(impl),false);this.helper_internal_.registerHandler(17,PageHandler_EndViewScreenSession_ParamsSpec.$,PageHandler_EndViewScreenSession_ResponseParamsSpec.$,impl.endViewScreenSession.bind(impl),false);this.helper_internal_.registerHandler(18,PageHandler_SetViewScreenSessionActive_ParamsSpec.$,PageHandler_SetViewScreenSessionActive_ResponseParamsSpec.$,impl.setViewScreenSessionActive.bind(impl),false);this.helper_internal_.registerHandler(19,PageHandler_GetUserPref_ParamsSpec.$,PageHandler_GetUserPref_ResponseParamsSpec.$,impl.getUserPref.bind(impl),false);this.helper_internal_.registerHandler(20,PageHandler_SetUserPref_ParamsSpec.$,PageHandler_SetUserPref_ResponseParamsSpec.$,impl.setUserPref.bind(impl),false);this.helper_internal_.registerHandler(21,PageHandler_SetSitePermission_ParamsSpec.$,PageHandler_SetSitePermission_ResponseParamsSpec.$,impl.setSitePermission.bind(impl),false);this.helper_internal_.registerHandler(22,PageHandler_CloseTab_ParamsSpec.$,PageHandler_CloseTab_ResponseParamsSpec.$,impl.closeTab.bind(impl),false);this.helper_internal_.registerHandler(23,PageHandler_OpenFeedbackDialog_ParamsSpec.$,PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,impl.openFeedbackDialog.bind(impl),false);this.helper_internal_.registerHandler(24,PageHandler_RefreshWorkbook_ParamsSpec.$,PageHandler_RefreshWorkbook_ResponseParamsSpec.$,impl.refreshWorkbook.bind(impl),false);this.helper_internal_.registerHandler(25,PageHandler_GetSpeechRecognitionInstallationStatus_ParamsSpec.$,PageHandler_GetSpeechRecognitionInstallationStatus_ResponseParamsSpec.$,impl.getSpeechRecognitionInstallationStatus.bind(impl),false);this.helper_internal_.registerHandler(26,PageHandler_StartSpotlight_ParamsSpec.$,PageHandler_StartSpotlight_ResponseParamsSpec.$,impl.startSpotlight.bind(impl),false);this.helper_internal_.registerHandler(27,PageHandler_PresentStudentScreen_ParamsSpec.$,PageHandler_PresentStudentScreen_ResponseParamsSpec.$,impl.presentStudentScreen.bind(impl),false);this.helper_internal_.registerHandler(28,PageHandler_StopPresentingStudentScreen_ParamsSpec.$,PageHandler_StopPresentingStudentScreen_ResponseParamsSpec.$,impl.stopPresentingStudentScreen.bind(impl),false);this.helper_internal_.registerHandler(29,PageHandler_PresentOwnScreen_ParamsSpec.$,PageHandler_PresentOwnScreen_ResponseParamsSpec.$,impl.presentOwnScreen.bind(impl),false);this.helper_internal_.registerHandler(30,PageHandler_StopPresentingOwnScreen_ParamsSpec.$,PageHandler_StopPresentingOwnScreen_ResponseParamsSpec.$,impl.stopPresentingOwnScreen.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"ash.boca.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{helper_internal_;$;router_;authenticateWebview;getWindowsTabsList;listCourses;listStudents;listAssignments;createSession;getSession;endSession;extendSessionDuration;removeStudent;renotifyStudent;addStudents;updateOnTaskConfig;updateCaptionConfig;setFloatMode;submitAccessCode;viewStudentScreen;endViewScreenSession;setViewScreenSessionActive;getUserPref;setUserPref;setSitePermission;closeTab;openFeedbackDialog;refreshWorkbook;getSpeechRecognitionInstallationStatus;startSpotlight;presentStudentScreen;stopPresentingStudentScreen;presentOwnScreen;stopPresentingOwnScreen;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.authenticateWebview=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_AuthenticateWebview_ParamsSpec.$,PageHandler_AuthenticateWebview_ResponseParamsSpec.$,this.authenticateWebview.createReceiverHandler(true),false);this.getWindowsTabsList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageHandler_GetWindowsTabsList_ParamsSpec.$,PageHandler_GetWindowsTabsList_ResponseParamsSpec.$,this.getWindowsTabsList.createReceiverHandler(true),false);this.listCourses=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PageHandler_ListCourses_ParamsSpec.$,PageHandler_ListCourses_ResponseParamsSpec.$,this.listCourses.createReceiverHandler(true),false);this.listStudents=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PageHandler_ListStudents_ParamsSpec.$,PageHandler_ListStudents_ResponseParamsSpec.$,this.listStudents.createReceiverHandler(true),false);this.listAssignments=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PageHandler_ListAssignments_ParamsSpec.$,PageHandler_ListAssignments_ResponseParamsSpec.$,this.listAssignments.createReceiverHandler(true),false);this.createSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PageHandler_CreateSession_ParamsSpec.$,PageHandler_CreateSession_ResponseParamsSpec.$,this.createSession.createReceiverHandler(true),false);this.getSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,PageHandler_GetSession_ParamsSpec.$,PageHandler_GetSession_ResponseParamsSpec.$,this.getSession.createReceiverHandler(true),false);this.endSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,PageHandler_EndSession_ParamsSpec.$,PageHandler_EndSession_ResponseParamsSpec.$,this.endSession.createReceiverHandler(true),false);this.extendSessionDuration=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,PageHandler_ExtendSessionDuration_ParamsSpec.$,PageHandler_ExtendSessionDuration_ResponseParamsSpec.$,this.extendSessionDuration.createReceiverHandler(true),false);this.removeStudent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,PageHandler_RemoveStudent_ParamsSpec.$,PageHandler_RemoveStudent_ResponseParamsSpec.$,this.removeStudent.createReceiverHandler(true),false);this.renotifyStudent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,PageHandler_RenotifyStudent_ParamsSpec.$,PageHandler_RenotifyStudent_ResponseParamsSpec.$,this.renotifyStudent.createReceiverHandler(true),false);this.addStudents=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,PageHandler_AddStudents_ParamsSpec.$,PageHandler_AddStudents_ResponseParamsSpec.$,this.addStudents.createReceiverHandler(true),false);this.updateOnTaskConfig=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,PageHandler_UpdateOnTaskConfig_ParamsSpec.$,PageHandler_UpdateOnTaskConfig_ResponseParamsSpec.$,this.updateOnTaskConfig.createReceiverHandler(true),false);this.updateCaptionConfig=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,PageHandler_UpdateCaptionConfig_ParamsSpec.$,PageHandler_UpdateCaptionConfig_ResponseParamsSpec.$,this.updateCaptionConfig.createReceiverHandler(true),false);this.setFloatMode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,PageHandler_SetFloatMode_ParamsSpec.$,PageHandler_SetFloatMode_ResponseParamsSpec.$,this.setFloatMode.createReceiverHandler(true),false);this.submitAccessCode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,PageHandler_SubmitAccessCode_ParamsSpec.$,PageHandler_SubmitAccessCode_ResponseParamsSpec.$,this.submitAccessCode.createReceiverHandler(true),false);this.viewStudentScreen=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,PageHandler_ViewStudentScreen_ParamsSpec.$,PageHandler_ViewStudentScreen_ResponseParamsSpec.$,this.viewStudentScreen.createReceiverHandler(true),false);this.endViewScreenSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,PageHandler_EndViewScreenSession_ParamsSpec.$,PageHandler_EndViewScreenSession_ResponseParamsSpec.$,this.endViewScreenSession.createReceiverHandler(true),false);this.setViewScreenSessionActive=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,PageHandler_SetViewScreenSessionActive_ParamsSpec.$,PageHandler_SetViewScreenSessionActive_ResponseParamsSpec.$,this.setViewScreenSessionActive.createReceiverHandler(true),false);this.getUserPref=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,PageHandler_GetUserPref_ParamsSpec.$,PageHandler_GetUserPref_ResponseParamsSpec.$,this.getUserPref.createReceiverHandler(true),false);this.setUserPref=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(20,PageHandler_SetUserPref_ParamsSpec.$,PageHandler_SetUserPref_ResponseParamsSpec.$,this.setUserPref.createReceiverHandler(true),false);this.setSitePermission=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(21,PageHandler_SetSitePermission_ParamsSpec.$,PageHandler_SetSitePermission_ResponseParamsSpec.$,this.setSitePermission.createReceiverHandler(true),false);this.closeTab=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(22,PageHandler_CloseTab_ParamsSpec.$,PageHandler_CloseTab_ResponseParamsSpec.$,this.closeTab.createReceiverHandler(true),false);this.openFeedbackDialog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(23,PageHandler_OpenFeedbackDialog_ParamsSpec.$,PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,this.openFeedbackDialog.createReceiverHandler(true),false);this.refreshWorkbook=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(24,PageHandler_RefreshWorkbook_ParamsSpec.$,PageHandler_RefreshWorkbook_ResponseParamsSpec.$,this.refreshWorkbook.createReceiverHandler(true),false);this.getSpeechRecognitionInstallationStatus=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(25,PageHandler_GetSpeechRecognitionInstallationStatus_ParamsSpec.$,PageHandler_GetSpeechRecognitionInstallationStatus_ResponseParamsSpec.$,this.getSpeechRecognitionInstallationStatus.createReceiverHandler(true),false);this.startSpotlight=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(26,PageHandler_StartSpotlight_ParamsSpec.$,PageHandler_StartSpotlight_ResponseParamsSpec.$,this.startSpotlight.createReceiverHandler(true),false);this.presentStudentScreen=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(27,PageHandler_PresentStudentScreen_ParamsSpec.$,PageHandler_PresentStudentScreen_ResponseParamsSpec.$,this.presentStudentScreen.createReceiverHandler(true),false);this.stopPresentingStudentScreen=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(28,PageHandler_StopPresentingStudentScreen_ParamsSpec.$,PageHandler_StopPresentingStudentScreen_ResponseParamsSpec.$,this.stopPresentingStudentScreen.createReceiverHandler(true),false);this.presentOwnScreen=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(29,PageHandler_PresentOwnScreen_ParamsSpec.$,PageHandler_PresentOwnScreen_ResponseParamsSpec.$,this.presentOwnScreen.createReceiverHandler(true),false);this.stopPresentingOwnScreen=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(30,PageHandler_StopPresentingOwnScreen_ParamsSpec.$,PageHandler_StopPresentingOwnScreen_ResponseParamsSpec.$,this.stopPresentingOwnScreen.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.boca.mojom.Page",scope)}}export class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onStudentActivityUpdated(activities){this.proxy.sendMessage(0,Page_OnStudentActivityUpdated_ParamsSpec.$,null,[activities],false)}onSessionConfigUpdated(config){this.proxy.sendMessage(1,Page_OnSessionConfigUpdated_ParamsSpec.$,null,[config],false)}onActiveNetworkStateChanged(activeNetworks){this.proxy.sendMessage(2,Page_OnActiveNetworkStateChanged_ParamsSpec.$,null,[activeNetworks],false)}onLocalCaptionDisabled(){this.proxy.sendMessage(3,Page_OnLocalCaptionDisabled_ParamsSpec.$,null,[],false)}onSpeechRecognitionInstallStateUpdated(state){this.proxy.sendMessage(4,Page_OnSpeechRecognitionInstallStateUpdated_ParamsSpec.$,null,[state],false)}onSessionCaptionDisabled(isError){this.proxy.sendMessage(5,Page_OnSessionCaptionDisabled_ParamsSpec.$,null,[isError],false)}onFrameDataReceived(frameData){this.proxy.sendMessage(6,Page_OnFrameDataReceived_ParamsSpec.$,null,[frameData],false)}onSpotlightCrdSessionStatusUpdated(state){this.proxy.sendMessage(7,Page_OnSpotlightCrdSessionStatusUpdated_ParamsSpec.$,null,[state],false)}onPresentStudentScreenEnded(){this.proxy.sendMessage(8,Page_OnPresentStudentScreenEnded_ParamsSpec.$,null,[],false)}onPresentOwnScreenEnded(){this.proxy.sendMessage(9,Page_OnPresentOwnScreenEnded_ParamsSpec.$,null,[],false)}}export class PageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Page_OnStudentActivityUpdated_ParamsSpec.$,null,impl.onStudentActivityUpdated.bind(impl),false);this.helper_internal_.registerHandler(1,Page_OnSessionConfigUpdated_ParamsSpec.$,null,impl.onSessionConfigUpdated.bind(impl),false);this.helper_internal_.registerHandler(2,Page_OnActiveNetworkStateChanged_ParamsSpec.$,null,impl.onActiveNetworkStateChanged.bind(impl),false);this.helper_internal_.registerHandler(3,Page_OnLocalCaptionDisabled_ParamsSpec.$,null,impl.onLocalCaptionDisabled.bind(impl),false);this.helper_internal_.registerHandler(4,Page_OnSpeechRecognitionInstallStateUpdated_ParamsSpec.$,null,impl.onSpeechRecognitionInstallStateUpdated.bind(impl),false);this.helper_internal_.registerHandler(5,Page_OnSessionCaptionDisabled_ParamsSpec.$,null,impl.onSessionCaptionDisabled.bind(impl),false);this.helper_internal_.registerHandler(6,Page_OnFrameDataReceived_ParamsSpec.$,null,impl.onFrameDataReceived.bind(impl),false);this.helper_internal_.registerHandler(7,Page_OnSpotlightCrdSessionStatusUpdated_ParamsSpec.$,null,impl.onSpotlightCrdSessionStatusUpdated.bind(impl),false);this.helper_internal_.registerHandler(8,Page_OnPresentStudentScreenEnded_ParamsSpec.$,null,impl.onPresentStudentScreenEnded.bind(impl),false);this.helper_internal_.registerHandler(9,Page_OnPresentOwnScreenEnded_ParamsSpec.$,null,impl.onPresentOwnScreenEnded.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Page{static get $interfaceName(){return"ash.boca.mojom.Page"}static getRemote(){let remote=new PageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageCallbackRouter{helper_internal_;$;router_;onStudentActivityUpdated;onSessionConfigUpdated;onActiveNetworkStateChanged;onLocalCaptionDisabled;onSpeechRecognitionInstallStateUpdated;onSessionCaptionDisabled;onFrameDataReceived;onSpotlightCrdSessionStatusUpdated;onPresentStudentScreenEnded;onPresentOwnScreenEnded;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onStudentActivityUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnStudentActivityUpdated_ParamsSpec.$,null,this.onStudentActivityUpdated.createReceiverHandler(false),false);this.onSessionConfigUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_OnSessionConfigUpdated_ParamsSpec.$,null,this.onSessionConfigUpdated.createReceiverHandler(false),false);this.onActiveNetworkStateChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_OnActiveNetworkStateChanged_ParamsSpec.$,null,this.onActiveNetworkStateChanged.createReceiverHandler(false),false);this.onLocalCaptionDisabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Page_OnLocalCaptionDisabled_ParamsSpec.$,null,this.onLocalCaptionDisabled.createReceiverHandler(false),false);this.onSpeechRecognitionInstallStateUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,Page_OnSpeechRecognitionInstallStateUpdated_ParamsSpec.$,null,this.onSpeechRecognitionInstallStateUpdated.createReceiverHandler(false),false);this.onSessionCaptionDisabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,Page_OnSessionCaptionDisabled_ParamsSpec.$,null,this.onSessionCaptionDisabled.createReceiverHandler(false),false);this.onFrameDataReceived=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,Page_OnFrameDataReceived_ParamsSpec.$,null,this.onFrameDataReceived.createReceiverHandler(false),false);this.onSpotlightCrdSessionStatusUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,Page_OnSpotlightCrdSessionStatusUpdated_ParamsSpec.$,null,this.onSpotlightCrdSessionStatusUpdated.createReceiverHandler(false),false);this.onPresentStudentScreenEnded=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,Page_OnPresentStudentScreenEnded_ParamsSpec.$,null,this.onPresentStudentScreenEnded.createReceiverHandler(false),false);this.onPresentOwnScreenEnded=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,Page_OnPresentOwnScreenEnded_ParamsSpec.$,null,this.onPresentOwnScreenEnded.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class BocaPageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.boca.mojom.BocaPageHandlerFactory",scope)}}export class BocaPageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(BocaPageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}create(handler,page){this.proxy.sendMessage(0,BocaPageHandlerFactory_Create_ParamsSpec.$,null,[handler,page],false)}}export class BocaPageHandlerFactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BocaPageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,BocaPageHandlerFactory_Create_ParamsSpec.$,null,impl.create.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class BocaPageHandlerFactory{static get $interfaceName(){return"ash.boca.mojom.BocaPageHandlerFactory"}static getRemote(){let remote=new BocaPageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class BocaPageHandlerFactoryCallbackRouter{helper_internal_;$;router_;create;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BocaPageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.create=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,BocaPageHandlerFactory_Create_ParamsSpec.$,null,this.create.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const TabInfoSpec={$:{}};export const IdentitySpec={$:{}};export const CourseSpec={$:{}};export const MaterialSpec={$:{}};export const AssignmentSpec={$:{}};export const WindowSpec={$:{}};export const NetworkInfoSpec={$:{}};export const ConfigSpec={$:{}};export const CaptionConfigSpec={$:{}};export const ControlledTabSpec={$:{}};export const OnTaskConfigSpec={$:{}};export const SessionSpec={$:{}};export const StudentActivitySpec={$:{}};export const IdentifiedActivitySpec={$:{}};export const PageHandler_AuthenticateWebview_ParamsSpec={$:{}};export const PageHandler_AuthenticateWebview_ResponseParamsSpec={$:{}};export const PageHandler_GetWindowsTabsList_ParamsSpec={$:{}};export const PageHandler_GetWindowsTabsList_ResponseParamsSpec={$:{}};export const PageHandler_ListCourses_ParamsSpec={$:{}};export const PageHandler_ListCourses_ResponseParamsSpec={$:{}};export const PageHandler_ListStudents_ParamsSpec={$:{}};export const PageHandler_ListStudents_ResponseParamsSpec={$:{}};export const PageHandler_ListAssignments_ParamsSpec={$:{}};export const PageHandler_ListAssignments_ResponseParamsSpec={$:{}};export const PageHandler_CreateSession_ParamsSpec={$:{}};export const PageHandler_CreateSession_ResponseParamsSpec={$:{}};export const PageHandler_GetSession_ParamsSpec={$:{}};export const PageHandler_GetSession_ResponseParamsSpec={$:{}};export const PageHandler_EndSession_ParamsSpec={$:{}};export const PageHandler_EndSession_ResponseParamsSpec={$:{}};export const PageHandler_ExtendSessionDuration_ParamsSpec={$:{}};export const PageHandler_ExtendSessionDuration_ResponseParamsSpec={$:{}};export const PageHandler_RemoveStudent_ParamsSpec={$:{}};export const PageHandler_RemoveStudent_ResponseParamsSpec={$:{}};export const PageHandler_RenotifyStudent_ParamsSpec={$:{}};export const PageHandler_RenotifyStudent_ResponseParamsSpec={$:{}};export const PageHandler_AddStudents_ParamsSpec={$:{}};export const PageHandler_AddStudents_ResponseParamsSpec={$:{}};export const PageHandler_UpdateOnTaskConfig_ParamsSpec={$:{}};export const PageHandler_UpdateOnTaskConfig_ResponseParamsSpec={$:{}};export const PageHandler_UpdateCaptionConfig_ParamsSpec={$:{}};export const PageHandler_UpdateCaptionConfig_ResponseParamsSpec={$:{}};export const PageHandler_SetFloatMode_ParamsSpec={$:{}};export const PageHandler_SetFloatMode_ResponseParamsSpec={$:{}};export const PageHandler_SubmitAccessCode_ParamsSpec={$:{}};export const PageHandler_SubmitAccessCode_ResponseParamsSpec={$:{}};export const PageHandler_ViewStudentScreen_ParamsSpec={$:{}};export const PageHandler_ViewStudentScreen_ResponseParamsSpec={$:{}};export const PageHandler_EndViewScreenSession_ParamsSpec={$:{}};export const PageHandler_EndViewScreenSession_ResponseParamsSpec={$:{}};export const PageHandler_SetViewScreenSessionActive_ParamsSpec={$:{}};export const PageHandler_SetViewScreenSessionActive_ResponseParamsSpec={$:{}};export const PageHandler_GetUserPref_ParamsSpec={$:{}};export const PageHandler_GetUserPref_ResponseParamsSpec={$:{}};export const PageHandler_SetUserPref_ParamsSpec={$:{}};export const PageHandler_SetUserPref_ResponseParamsSpec={$:{}};export const PageHandler_SetSitePermission_ParamsSpec={$:{}};export const PageHandler_SetSitePermission_ResponseParamsSpec={$:{}};export const PageHandler_CloseTab_ParamsSpec={$:{}};export const PageHandler_CloseTab_ResponseParamsSpec={$:{}};export const PageHandler_OpenFeedbackDialog_ParamsSpec={$:{}};export const PageHandler_OpenFeedbackDialog_ResponseParamsSpec={$:{}};export const PageHandler_RefreshWorkbook_ParamsSpec={$:{}};export const PageHandler_RefreshWorkbook_ResponseParamsSpec={$:{}};export const PageHandler_GetSpeechRecognitionInstallationStatus_ParamsSpec={$:{}};export const PageHandler_GetSpeechRecognitionInstallationStatus_ResponseParamsSpec={$:{}};export const PageHandler_StartSpotlight_ParamsSpec={$:{}};export const PageHandler_StartSpotlight_ResponseParamsSpec={$:{}};export const PageHandler_PresentStudentScreen_ParamsSpec={$:{}};export const PageHandler_PresentStudentScreen_ResponseParamsSpec={$:{}};export const PageHandler_StopPresentingStudentScreen_ParamsSpec={$:{}};export const PageHandler_StopPresentingStudentScreen_ResponseParamsSpec={$:{}};export const PageHandler_PresentOwnScreen_ParamsSpec={$:{}};export const PageHandler_PresentOwnScreen_ResponseParamsSpec={$:{}};export const PageHandler_StopPresentingOwnScreen_ParamsSpec={$:{}};export const PageHandler_StopPresentingOwnScreen_ResponseParamsSpec={$:{}};export const Page_OnStudentActivityUpdated_ParamsSpec={$:{}};export const Page_OnSessionConfigUpdated_ParamsSpec={$:{}};export const Page_OnActiveNetworkStateChanged_ParamsSpec={$:{}};export const Page_OnLocalCaptionDisabled_ParamsSpec={$:{}};export const Page_OnSpeechRecognitionInstallStateUpdated_ParamsSpec={$:{}};export const Page_OnSessionCaptionDisabled_ParamsSpec={$:{}};export const Page_OnFrameDataReceived_ParamsSpec={$:{}};export const Page_OnSpotlightCrdSessionStatusUpdated_ParamsSpec={$:{}};export const Page_OnPresentStudentScreenEnded_ParamsSpec={$:{}};export const Page_OnPresentOwnScreenEnded_ParamsSpec={$:{}};export const BocaPageHandlerFactory_Create_ParamsSpec={$:{}};export const SessionResultSpec={$:{}};export const ConfigResultSpec={$:{}};mojo.internal.Struct(TabInfoSpec.$,"TabInfo",[mojo.internal.StructField("id_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"id_$value",originalFieldName:"id"},undefined),mojo.internal.StructField("id_$value",4,0,mojo.internal.Int32,0,false,0,{isPrimary:false,originalFieldName:"id"},undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",16,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("favicon",24,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(IdentitySpec.$,"Identity",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("email",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("photoUrl",24,0,url_mojom_UrlSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(CourseSpec.$,"Course",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("section",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(MaterialSpec.$,"Material",[mojo.internal.StructField("title",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("type",8,0,MaterialTypeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AssignmentSpec.$,"Assignment",[mojo.internal.StructField("title",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastUpdateTime",16,0,mojoBase_mojom_JSTimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("materials",24,0,mojo.internal.Array(MaterialSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("type",32,0,AssignmentTypeSpec.$,0,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(WindowSpec.$,"Window",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("tabList",8,0,mojo.internal.Array(TabInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(NetworkInfoSpec.$,"NetworkInfo",[mojo.internal.StructField("state",0,0,chromeos_networkConfig_mojom_ConnectionStateTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("type",4,0,NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("signalStrength",16,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ConfigSpec.$,"Config",[mojo.internal.StructField("sessionDuration",0,0,mojoBase_mojom_TimeDeltaSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("sessionStartTime",8,0,mojoBase_mojom_JSTimeSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("teacher",16,0,IdentitySpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("students",24,0,mojo.internal.Array(IdentitySpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("studentsJoinViaCode",32,0,mojo.internal.Array(IdentitySpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("onTaskConfig",40,0,OnTaskConfigSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("captionConfig",48,0,CaptionConfigSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("accessCode",56,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(CaptionConfigSpec.$,"CaptionConfig",[mojo.internal.StructField("sessionCaptionEnabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("localCaptionEnabled",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("sessionTranslationEnabled",0,2,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ControlledTabSpec.$,"ControlledTab",[mojo.internal.StructField("tab",0,0,TabInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("navigationType",8,0,NavigationTypeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OnTaskConfigSpec.$,"OnTaskConfig",[mojo.internal.StructField("isLocked",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isPaused",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("tabs",8,0,mojo.internal.Array(ControlledTabSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SessionSpec.$,"Session",[mojo.internal.StructField("config",0,0,ConfigSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("activities",8,0,mojo.internal.Array(IdentifiedActivitySpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(StudentActivitySpec.$,"StudentActivity",[mojo.internal.StructField("studentStatusDetail",0,0,StudentStatusDetailSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("isActive",4,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("activeTab",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("isCaptionEnabled",4,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isHandRaised",4,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("joinMethod",16,0,JoinMethodSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("viewScreenSessionCode",24,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(IdentifiedActivitySpec.$,"IdentifiedActivity",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("activity",8,0,StudentActivitySpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_AuthenticateWebview_ParamsSpec.$,"PageHandler_AuthenticateWebview_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_AuthenticateWebview_ResponseParamsSpec.$,"PageHandler_AuthenticateWebview_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetWindowsTabsList_ParamsSpec.$,"PageHandler_GetWindowsTabsList_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetWindowsTabsList_ResponseParamsSpec.$,"PageHandler_GetWindowsTabsList_ResponseParams",[mojo.internal.StructField("windowList",0,0,mojo.internal.Array(WindowSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ListCourses_ParamsSpec.$,"PageHandler_ListCourses_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_ListCourses_ResponseParamsSpec.$,"PageHandler_ListCourses_ResponseParams",[mojo.internal.StructField("courses",0,0,mojo.internal.Array(CourseSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ListStudents_ParamsSpec.$,"PageHandler_ListStudents_Params",[mojo.internal.StructField("courseId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ListStudents_ResponseParamsSpec.$,"PageHandler_ListStudents_ResponseParams",[mojo.internal.StructField("students",0,0,mojo.internal.Array(IdentitySpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ListAssignments_ParamsSpec.$,"PageHandler_ListAssignments_Params",[mojo.internal.StructField("courseId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ListAssignments_ResponseParamsSpec.$,"PageHandler_ListAssignments_ResponseParams",[mojo.internal.StructField("assignments",0,0,mojo.internal.Array(AssignmentSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CreateSession_ParamsSpec.$,"PageHandler_CreateSession_Params",[mojo.internal.StructField("config",0,0,ConfigSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CreateSession_ResponseParamsSpec.$,"PageHandler_CreateSession_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,CreateSessionErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetSession_ParamsSpec.$,"PageHandler_GetSession_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetSession_ResponseParamsSpec.$,"PageHandler_GetSession_ResponseParams",[mojo.internal.StructField("result",0,0,SessionResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_EndSession_ParamsSpec.$,"PageHandler_EndSession_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_EndSession_ResponseParamsSpec.$,"PageHandler_EndSession_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,UpdateSessionErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ExtendSessionDuration_ParamsSpec.$,"PageHandler_ExtendSessionDuration_Params",[mojo.internal.StructField("extendedDuration",0,0,mojoBase_mojom_TimeDeltaSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ExtendSessionDuration_ResponseParamsSpec.$,"PageHandler_ExtendSessionDuration_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,UpdateSessionErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RemoveStudent_ParamsSpec.$,"PageHandler_RemoveStudent_Params",[mojo.internal.StructField("studentId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RemoveStudent_ResponseParamsSpec.$,"PageHandler_RemoveStudent_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,RemoveStudentErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RenotifyStudent_ParamsSpec.$,"PageHandler_RenotifyStudent_Params",[mojo.internal.StructField("studentId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RenotifyStudent_ResponseParamsSpec.$,"PageHandler_RenotifyStudent_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,RenotifyStudentErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddStudents_ParamsSpec.$,"PageHandler_AddStudents_Params",[mojo.internal.StructField("students",0,0,mojo.internal.Array(IdentitySpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddStudents_ResponseParamsSpec.$,"PageHandler_AddStudents_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,AddStudentsErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_UpdateOnTaskConfig_ParamsSpec.$,"PageHandler_UpdateOnTaskConfig_Params",[mojo.internal.StructField("onTaskConfig",0,0,OnTaskConfigSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_UpdateOnTaskConfig_ResponseParamsSpec.$,"PageHandler_UpdateOnTaskConfig_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,UpdateSessionErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_UpdateCaptionConfig_ParamsSpec.$,"PageHandler_UpdateCaptionConfig_Params",[mojo.internal.StructField("captionConfig",0,0,CaptionConfigSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_UpdateCaptionConfig_ResponseParamsSpec.$,"PageHandler_UpdateCaptionConfig_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,UpdateSessionErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetFloatMode_ParamsSpec.$,"PageHandler_SetFloatMode_Params",[mojo.internal.StructField("isFloatMode",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetFloatMode_ResponseParamsSpec.$,"PageHandler_SetFloatMode_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SubmitAccessCode_ParamsSpec.$,"PageHandler_SubmitAccessCode_Params",[mojo.internal.StructField("accessCode",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SubmitAccessCode_ResponseParamsSpec.$,"PageHandler_SubmitAccessCode_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,SubmitAccessCodeErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ViewStudentScreen_ParamsSpec.$,"PageHandler_ViewStudentScreen_Params",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ViewStudentScreen_ResponseParamsSpec.$,"PageHandler_ViewStudentScreen_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,ViewStudentScreenErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_EndViewScreenSession_ParamsSpec.$,"PageHandler_EndViewScreenSession_Params",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_EndViewScreenSession_ResponseParamsSpec.$,"PageHandler_EndViewScreenSession_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,EndViewScreenSessionErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetViewScreenSessionActive_ParamsSpec.$,"PageHandler_SetViewScreenSessionActive_Params",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetViewScreenSessionActive_ResponseParamsSpec.$,"PageHandler_SetViewScreenSessionActive_ResponseParams",[mojo.internal.StructField("error_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_$value",originalFieldName:"error"},undefined),mojo.internal.StructField("error_$value",4,0,SetViewScreenSessionActiveErrorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"error"},undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetUserPref_ParamsSpec.$,"PageHandler_GetUserPref_Params",[mojo.internal.StructField("pref",0,0,BocaValidPrefSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetUserPref_ResponseParamsSpec.$,"PageHandler_GetUserPref_ResponseParams",[mojo.internal.StructField("value",0,0,mojoBase_mojom_ValueSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_SetUserPref_ParamsSpec.$,"PageHandler_SetUserPref_Params",[mojo.internal.StructField("pref",0,0,BocaValidPrefSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("value",8,0,mojoBase_mojom_ValueSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_SetUserPref_ResponseParamsSpec.$,"PageHandler_SetUserPref_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PageHandler_SetSitePermission_ParamsSpec.$,"PageHandler_SetSitePermission_Params",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("permission",8,0,PermissionSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("setting",12,0,PermissionSettingSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_SetSitePermission_ResponseParamsSpec.$,"PageHandler_SetSitePermission_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CloseTab_ParamsSpec.$,"PageHandler_CloseTab_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CloseTab_ResponseParamsSpec.$,"PageHandler_CloseTab_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ParamsSpec.$,"PageHandler_OpenFeedbackDialog_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,"PageHandler_OpenFeedbackDialog_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PageHandler_RefreshWorkbook_ParamsSpec.$,"PageHandler_RefreshWorkbook_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RefreshWorkbook_ResponseParamsSpec.$,"PageHandler_RefreshWorkbook_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetSpeechRecognitionInstallationStatus_ParamsSpec.$,"PageHandler_GetSpeechRecognitionInstallationStatus_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetSpeechRecognitionInstallationStatus_ResponseParamsSpec.$,"PageHandler_GetSpeechRecognitionInstallationStatus_ResponseParams",[mojo.internal.StructField("state",0,0,SpeechRecognitionInstallStateSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_StartSpotlight_ParamsSpec.$,"PageHandler_StartSpotlight_Params",[mojo.internal.StructField("crdConnectionCode",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_StartSpotlight_ResponseParamsSpec.$,"PageHandler_StartSpotlight_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PageHandler_PresentStudentScreen_ParamsSpec.$,"PageHandler_PresentStudentScreen_Params",[mojo.internal.StructField("student",0,0,IdentitySpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("receiverId",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_PresentStudentScreen_ResponseParamsSpec.$,"PageHandler_PresentStudentScreen_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_StopPresentingStudentScreen_ParamsSpec.$,"PageHandler_StopPresentingStudentScreen_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_StopPresentingStudentScreen_ResponseParamsSpec.$,"PageHandler_StopPresentingStudentScreen_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_PresentOwnScreen_ParamsSpec.$,"PageHandler_PresentOwnScreen_Params",[mojo.internal.StructField("receiverId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_PresentOwnScreen_ResponseParamsSpec.$,"PageHandler_PresentOwnScreen_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_StopPresentingOwnScreen_ParamsSpec.$,"PageHandler_StopPresentingOwnScreen_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_StopPresentingOwnScreen_ResponseParamsSpec.$,"PageHandler_StopPresentingOwnScreen_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnStudentActivityUpdated_ParamsSpec.$,"Page_OnStudentActivityUpdated_Params",[mojo.internal.StructField("activities",0,0,mojo.internal.Array(IdentifiedActivitySpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnSessionConfigUpdated_ParamsSpec.$,"Page_OnSessionConfigUpdated_Params",[mojo.internal.StructField("config",0,0,ConfigResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_OnActiveNetworkStateChanged_ParamsSpec.$,"Page_OnActiveNetworkStateChanged_Params",[mojo.internal.StructField("activeNetworks",0,0,mojo.internal.Array(NetworkInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnLocalCaptionDisabled_ParamsSpec.$,"Page_OnLocalCaptionDisabled_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnSpeechRecognitionInstallStateUpdated_ParamsSpec.$,"Page_OnSpeechRecognitionInstallStateUpdated_Params",[mojo.internal.StructField("state",0,0,SpeechRecognitionInstallStateSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnSessionCaptionDisabled_ParamsSpec.$,"Page_OnSessionCaptionDisabled_Params",[mojo.internal.StructField("isError",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnFrameDataReceived_ParamsSpec.$,"Page_OnFrameDataReceived_Params",[mojo.internal.StructField("frameData",0,0,skia_mojom_BitmapN32Spec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnSpotlightCrdSessionStatusUpdated_ParamsSpec.$,"Page_OnSpotlightCrdSessionStatusUpdated_Params",[mojo.internal.StructField("state",0,0,CrdConnectionStateSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnPresentStudentScreenEnded_ParamsSpec.$,"Page_OnPresentStudentScreenEnded_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnPresentOwnScreenEnded_ParamsSpec.$,"Page_OnPresentOwnScreenEnded_Params",[],[[0,8]]);mojo.internal.Struct(BocaPageHandlerFactory_Create_ParamsSpec.$,"BocaPageHandlerFactory_Create_Params",[mojo.internal.StructField("handler",0,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("page",4,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Union(SessionResultSpec.$,"SessionResult",{error:{ordinal:0,type:GetSessionErrorSpec.$},session:{ordinal:1,type:SessionSpec.$}});export var SessionResultFieldTags;(function(SessionResultFieldTags){SessionResultFieldTags[SessionResultFieldTags["ERROR"]=0]="ERROR";SessionResultFieldTags[SessionResultFieldTags["SESSION"]=1]="SESSION"})(SessionResultFieldTags||(SessionResultFieldTags={}));export function whichSessionResult(u){if(u.error!==null&&u.error!==undefined){return SessionResultFieldTags.ERROR}if(u.session!==null&&u.session!==undefined){return SessionResultFieldTags.SESSION}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(ConfigResultSpec.$,"ConfigResult",{error:{ordinal:0,type:GetSessionErrorSpec.$},config:{ordinal:1,type:ConfigSpec.$}});export var ConfigResultFieldTags;(function(ConfigResultFieldTags){ConfigResultFieldTags[ConfigResultFieldTags["ERROR"]=0]="ERROR";ConfigResultFieldTags[ConfigResultFieldTags["CONFIG"]=1]="CONFIG"})(ConfigResultFieldTags||(ConfigResultFieldTags={}));export function whichConfigResult(u){if(u.error!==null&&u.error!==undefined){return ConfigResultFieldTags.ERROR}if(u.config!==null&&u.config!==undefined){return ConfigResultFieldTags.CONFIG}throw new Error("no union field has been set, this is an illegal state")}