// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Declare navigation enum type
 */
export var NavigationType;
(function (NavigationType) {
    NavigationType[NavigationType["UNKNOWN"] = 0] = "UNKNOWN";
    NavigationType[NavigationType["OPEN"] = 1] = "OPEN";
    NavigationType[NavigationType["BLOCK"] = 2] = "BLOCK";
    NavigationType[NavigationType["DOMAIN"] = 3] = "DOMAIN";
    NavigationType[NavigationType["LIMITED"] = 4] = "LIMITED";
    NavigationType[NavigationType["SAME_DOMAIN_OPEN_OTHER_DOMAIN_LIMITED"] = 5] = "SAME_DOMAIN_OPEN_OTHER_DOMAIN_LIMITED";
    NavigationType[NavigationType["WORKSPACE_NAVIGATION"] = 6] = "WORKSPACE_NAVIGATION";
})(NavigationType || (NavigationType = {}));
export var JoinMethod;
(function (JoinMethod) {
    JoinMethod[JoinMethod["ROSTER"] = 0] = "ROSTER";
    JoinMethod[JoinMethod["ACCESS_CODE"] = 1] = "ACCESS_CODE";
})(JoinMethod || (JoinMethod = {}));
export var SubmitAccessCodeResult;
(function (SubmitAccessCodeResult) {
    SubmitAccessCodeResult[SubmitAccessCodeResult["UNKNOWN"] = 0] = "UNKNOWN";
    SubmitAccessCodeResult[SubmitAccessCodeResult["SUCCESS"] = 1] = "SUCCESS";
    SubmitAccessCodeResult[SubmitAccessCodeResult["INVALID_CODE"] = 2] = "INVALID_CODE";
    SubmitAccessCodeResult[SubmitAccessCodeResult["NETWORK_RESTRICTION"] = 3] = "NETWORK_RESTRICTION";
})(SubmitAccessCodeResult || (SubmitAccessCodeResult = {}));
export var CreateSessionResult;
(function (CreateSessionResult) {
    CreateSessionResult[CreateSessionResult["UNKNOWN"] = 0] = "UNKNOWN";
    CreateSessionResult[CreateSessionResult["SUCCESS"] = 1] = "SUCCESS";
    CreateSessionResult[CreateSessionResult["HTTP_ERROR"] = 2] = "HTTP_ERROR";
    CreateSessionResult[CreateSessionResult["NETWORK_RESTRICTION"] = 3] = "NETWORK_RESTRICTION";
})(CreateSessionResult || (CreateSessionResult = {}));
export var StudentStatusDetail;
(function (StudentStatusDetail) {
    StudentStatusDetail[StudentStatusDetail["STUDENT_STATE_UNKNOWN"] = 0] = "STUDENT_STATE_UNKNOWN";
    StudentStatusDetail[StudentStatusDetail["NOT_FOUND"] = 1] = "NOT_FOUND";
    StudentStatusDetail[StudentStatusDetail["ADDED"] = 2] = "ADDED";
    StudentStatusDetail[StudentStatusDetail["ACTIVE"] = 3] = "ACTIVE";
    StudentStatusDetail[StudentStatusDetail["REMOVED_BY_OTHER_SESSION"] = 4] = "REMOVED_BY_OTHER_SESSION";
    StudentStatusDetail[StudentStatusDetail["REMOVED_BY_BEING_TEACHER"] = 5] = "REMOVED_BY_BEING_TEACHER";
    StudentStatusDetail[StudentStatusDetail["REMOVED_BY_TEACHER"] = 6] = "REMOVED_BY_TEACHER";
    StudentStatusDetail[StudentStatusDetail["NOT_ADDED_CONFIGURED_AS_TEACHER"] = 7] = "NOT_ADDED_CONFIGURED_AS_TEACHER";
    StudentStatusDetail[StudentStatusDetail["NOT_ADDED_NOT_CONFIGURED"] = 8] = "NOT_ADDED_NOT_CONFIGURED";
    StudentStatusDetail[StudentStatusDetail["MULTIPLE_DEVICE_SIGNED_IN"] = 9] = "MULTIPLE_DEVICE_SIGNED_IN";
})(StudentStatusDetail || (StudentStatusDetail = {}));
/**
 * Declare network state enum type
 */
export var NetworkState;
(function (NetworkState) {
    NetworkState[NetworkState["ONLINE"] = 0] = "ONLINE";
    NetworkState[NetworkState["CONNECTED"] = 1] = "CONNECTED";
    NetworkState[NetworkState["PORTAL"] = 2] = "PORTAL";
    NetworkState[NetworkState["CONNECTING"] = 3] = "CONNECTING";
    NetworkState[NetworkState["NOTCONNECTED"] = 4] = "NOTCONNECTED";
})(NetworkState || (NetworkState = {}));
/**
 * Declare network type enum type
 */
export var NetworkType;
(function (NetworkType) {
    NetworkType[NetworkType["CELLULAR"] = 0] = "CELLULAR";
    NetworkType[NetworkType["ETHERNET"] = 1] = "ETHERNET";
    NetworkType[NetworkType["WIFI"] = 2] = "WIFI";
    NetworkType[NetworkType["UNSUPPORTED"] = 3] = "UNSUPPORTED";
})(NetworkType || (NetworkType = {}));
/**
 * Declare permission type enum type
 */
export var Permission;
(function (Permission) {
    Permission[Permission["MICROPHONE"] = 0] = "MICROPHONE";
    Permission[Permission["CAMERA"] = 1] = "CAMERA";
})(Permission || (Permission = {}));
/**
 * Declare permission setting type enum type
 */
export var PermissionSetting;
(function (PermissionSetting) {
    PermissionSetting[PermissionSetting["ALLOW"] = 0] = "ALLOW";
    PermissionSetting[PermissionSetting["ASK"] = 1] = "ASK";
    PermissionSetting[PermissionSetting["BLOCK"] = 2] = "BLOCK";
})(PermissionSetting || (PermissionSetting = {}));
/**
 * Declare boca user pref type.
 */
export var BocaValidPref;
(function (BocaValidPref) {
    BocaValidPref[BocaValidPref["NAVIGATION_SETTING"] = 0] = "NAVIGATION_SETTING";
    BocaValidPref[BocaValidPref["CAPTION_ENABLEMENT_SETTING"] = 1] = "CAPTION_ENABLEMENT_SETTING";
    BocaValidPref[BocaValidPref["DEFAULT_MEDIASTREAM_SETTING"] = 2] = "DEFAULT_MEDIASTREAM_SETTING";
})(BocaValidPref || (BocaValidPref = {}));
/**
 * Declare course assignment material type enum type
 */
export var MaterialType;
(function (MaterialType) {
    MaterialType[MaterialType["UNKNOWN"] = 0] = "UNKNOWN";
    MaterialType[MaterialType["SHARED_DRIVE_FILE"] = 1] = "SHARED_DRIVE_FILE";
    MaterialType[MaterialType["YOUTUBE_VIDEO"] = 2] = "YOUTUBE_VIDEO";
    MaterialType[MaterialType["LINK"] = 3] = "LINK";
    MaterialType[MaterialType["FORM"] = 4] = "FORM";
})(MaterialType || (MaterialType = {}));
/**
 * Declare course assignment type enum type
 */
export var AssignmentType;
(function (AssignmentType) {
    AssignmentType[AssignmentType["UNSPECIFIED"] = 0] = "UNSPECIFIED";
    AssignmentType[AssignmentType["ASSIGNMENT"] = 1] = "ASSIGNMENT";
    AssignmentType[AssignmentType["SHORT_ANSWER_QUESTION"] = 2] = "SHORT_ANSWER_QUESTION";
    AssignmentType[AssignmentType["MULTIPLE_CHOICE_QUESTION"] = 3] = "MULTIPLE_CHOICE_QUESTION";
})(AssignmentType || (AssignmentType = {}));
/**
 * Declare Speech Recognition install state enum type
 */
export var SpeechRecognitionInstallState;
(function (SpeechRecognitionInstallState) {
    SpeechRecognitionInstallState[SpeechRecognitionInstallState["UNKNOWN"] = 0] = "UNKNOWN";
    SpeechRecognitionInstallState[SpeechRecognitionInstallState["SYSTEM_LANGUAGE_NOT_SUPPORTED"] = 1] = "SYSTEM_LANGUAGE_NOT_SUPPORTED";
    SpeechRecognitionInstallState[SpeechRecognitionInstallState["IN_PROGRESS"] = 2] = "IN_PROGRESS";
    SpeechRecognitionInstallState[SpeechRecognitionInstallState["FAILED"] = 3] = "FAILED";
    SpeechRecognitionInstallState[SpeechRecognitionInstallState["READY"] = 4] = "READY";
})(SpeechRecognitionInstallState || (SpeechRecognitionInstallState = {}));
/**
 * Declare Speech Recognition install state enum type
 */
export var CrdConnectionState;
(function (CrdConnectionState) {
    CrdConnectionState[CrdConnectionState["UNKNOWN"] = 0] = "UNKNOWN";
    CrdConnectionState[CrdConnectionState["CONNECTING"] = 1] = "CONNECTING";
    CrdConnectionState[CrdConnectionState["CONNECTED"] = 2] = "CONNECTED";
    CrdConnectionState[CrdConnectionState["DISCONNECTED"] = 3] = "DISCONNECTED";
    CrdConnectionState[CrdConnectionState["FAILED"] = 4] = "FAILED";
})(CrdConnectionState || (CrdConnectionState = {}));
