// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assertExists } from './assert.js';
import { ChromeHelper } from './mojo/chrome_helper.js';
import { convertMojoToAspectRatio } from './mojo/type_utils.js';
let aspectRatioOrder = null;
/**
 *  Setup `aspectRatioOrder` from private API.
 */
export async function setup() {
    const mojoAspectRatioOrder = await ChromeHelper.getInstance().getAspectRatioOrder();
    aspectRatioOrder = mojoAspectRatioOrder.map((mojoAspectRatio) => convertMojoToAspectRatio(mojoAspectRatio));
}
/**
 *  Get the aspect ratio order. `setup` must be done before calling this
 *  function.
 */
export function getAspectRatioOrder() {
    return assertExists(aspectRatioOrder);
}
