// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import * as comlink from '../lib/comlink.js';
/**
 * A barcode worker to detect barcode from images.
 */
class BarcodeWorkerImpl {
    constructor() {
        // BarcodeDetector should always be available on ChromeOS. The check is used
        // for local development server.
        this.detector = 'BarcodeDetector' in self ?
            new BarcodeDetector({ formats: ['qr_code'] }) :
            null;
    }
    async detect(bitmap) {
        if (this.detector === null) {
            return [];
        }
        try {
            // TODO(chuhsuan): Check why this cannot be returned directly
            // (@typescript-eslint/return-await).
            const codes = await this.detector.detect(bitmap);
            return codes;
        }
        catch {
            // Barcode detection service unavailable.
            return [];
        }
    }
}
comlink.expose(new BarcodeWorkerImpl());
