// ash/webui/camera_app_ui/camera_app_helper.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { CameraIntentActionSpec as arc_mojom_CameraIntentActionSpec } from '../../../chromeos/ash/experiences/arc/mojom/camera_intent.mojom-webui.js';
import { RotationSpec as chromeos_machineLearning_mojom_RotationSpec } from '../../../chromeos/services/machine_learning/public/mojom/document_scanner_param_types.mojom-webui.js';
import { EventsSenderRemote as ash_cameraApp_mojom_EventsSenderRemote } from './events_sender.mojom-webui.js';
import { OcrResultSpec as ash_cameraApp_mojom_OcrResultSpec } from './ocr.mojom-webui.js';
import { PdfBuilderPendingReceiver as ash_cameraApp_mojom_PdfBuilderPendingReceiver } from './pdf_builder.mojom-webui.js';
import { WifiEapMethodSpec as ash_cameraApp_mojom_WifiEapMethodSpec, WifiEapPhase2MethodSpec as ash_cameraApp_mojom_WifiEapPhase2MethodSpec, WifiSecurityTypeSpec as ash_cameraApp_mojom_WifiSecurityTypeSpec } from './types.mojom-webui.js';
import { BigBufferSpec as mojoBase_mojom_BigBufferSpec } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import { PointFSpec as gfx_mojom_PointFSpec } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const ScreenStateSpec = { $: mojo.internal.Enum() };
export var ScreenState;
(function (ScreenState) {
    ScreenState[ScreenState["MIN_VALUE"] = 0] = "MIN_VALUE";
    ScreenState[ScreenState["MAX_VALUE"] = 2] = "MAX_VALUE";
    ScreenState[ScreenState["kOn"] = 0] = "kOn";
    ScreenState[ScreenState["kOff"] = 1] = "kOff";
    ScreenState[ScreenState["kOffAuto"] = 2] = "kOffAuto";
})(ScreenState || (ScreenState = {}));
export const LidStateSpec = { $: mojo.internal.Enum() };
export var LidState;
(function (LidState) {
    LidState[LidState["MIN_VALUE"] = 0] = "MIN_VALUE";
    LidState[LidState["MAX_VALUE"] = 2] = "MAX_VALUE";
    LidState[LidState["kOpen"] = 0] = "kOpen";
    LidState[LidState["kClosed"] = 1] = "kClosed";
    LidState[LidState["kNotPresent"] = 2] = "kNotPresent";
})(LidState || (LidState = {}));
export const WindowStateTypeSpec = { $: mojo.internal.Enum() };
export var WindowStateType;
(function (WindowStateType) {
    WindowStateType[WindowStateType["MIN_VALUE"] = 0] = "MIN_VALUE";
    WindowStateType[WindowStateType["MAX_VALUE"] = 3] = "MAX_VALUE";
    WindowStateType[WindowStateType["kMinimized"] = 0] = "kMinimized";
    WindowStateType[WindowStateType["kMaximized"] = 1] = "kMaximized";
    WindowStateType[WindowStateType["kFullscreen"] = 2] = "kFullscreen";
    WindowStateType[WindowStateType["kRegular"] = 3] = "kRegular";
})(WindowStateType || (WindowStateType = {}));
export const FileMonitorResultSpec = { $: mojo.internal.Enum() };
export var FileMonitorResult;
(function (FileMonitorResult) {
    FileMonitorResult[FileMonitorResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    FileMonitorResult[FileMonitorResult["MAX_VALUE"] = 2] = "MAX_VALUE";
    FileMonitorResult[FileMonitorResult["kDeleted"] = 0] = "kDeleted";
    FileMonitorResult[FileMonitorResult["kCanceled"] = 1] = "kCanceled";
    FileMonitorResult[FileMonitorResult["kError"] = 2] = "kError";
})(FileMonitorResult || (FileMonitorResult = {}));
export const StorageMonitorStatusSpec = { $: mojo.internal.Enum() };
export var StorageMonitorStatus;
(function (StorageMonitorStatus) {
    StorageMonitorStatus[StorageMonitorStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    StorageMonitorStatus[StorageMonitorStatus["MAX_VALUE"] = 4] = "MAX_VALUE";
    StorageMonitorStatus[StorageMonitorStatus["kNormal"] = 0] = "kNormal";
    StorageMonitorStatus[StorageMonitorStatus["kLow"] = 1] = "kLow";
    StorageMonitorStatus[StorageMonitorStatus["kCriticallyLow"] = 2] = "kCriticallyLow";
    StorageMonitorStatus[StorageMonitorStatus["kCanceled"] = 3] = "kCanceled";
    StorageMonitorStatus[StorageMonitorStatus["kError"] = 4] = "kError";
})(StorageMonitorStatus || (StorageMonitorStatus = {}));
export const AspectRatioSpec = { $: mojo.internal.Enum() };
export var AspectRatio;
(function (AspectRatio) {
    AspectRatio[AspectRatio["MIN_VALUE"] = 0] = "MIN_VALUE";
    AspectRatio[AspectRatio["MAX_VALUE"] = 2] = "MAX_VALUE";
    AspectRatio[AspectRatio["kOthers"] = 0] = "kOthers";
    AspectRatio[AspectRatio["k4To3"] = 1] = "k4To3";
    AspectRatio[AspectRatio["k16To9"] = 2] = "k16To9";
})(AspectRatio || (AspectRatio = {}));
export class TabletModeMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.TabletModeMonitor', scope);
    }
}
export class TabletModeMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TabletModeMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(isTabletMode) {
        this.proxy.sendMessage(0, TabletModeMonitor_Update_ParamsSpec.$, null, [
            isTabletMode
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TabletModeMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TabletModeMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabletModeMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TabletModeMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TabletModeMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.TabletModeMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TabletModeMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TabletModeMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TabletModeMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabletModeMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TabletModeMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ScreenStateMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.ScreenStateMonitor', scope);
    }
}
export class ScreenStateMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ScreenStateMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(state) {
        this.proxy.sendMessage(0, ScreenStateMonitor_Update_ParamsSpec.$, null, [
            state
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ScreenStateMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ScreenStateMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScreenStateMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ScreenStateMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ScreenStateMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.ScreenStateMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ScreenStateMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ScreenStateMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ScreenStateMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScreenStateMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ScreenStateMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ScreenLockedMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.ScreenLockedMonitor', scope);
    }
}
export class ScreenLockedMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ScreenLockedMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(isScreenLocked) {
        this.proxy.sendMessage(0, ScreenLockedMonitor_Update_ParamsSpec.$, null, [
            isScreenLocked
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ScreenLockedMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ScreenLockedMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScreenLockedMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ScreenLockedMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ScreenLockedMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.ScreenLockedMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ScreenLockedMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ScreenLockedMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ScreenLockedMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScreenLockedMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ScreenLockedMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ExternalScreenMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.ExternalScreenMonitor', scope);
    }
}
export class ExternalScreenMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ExternalScreenMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(hasExternalScreen) {
        this.proxy.sendMessage(0, ExternalScreenMonitor_Update_ParamsSpec.$, null, [
            hasExternalScreen
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ExternalScreenMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ExternalScreenMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ExternalScreenMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ExternalScreenMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ExternalScreenMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.ExternalScreenMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ExternalScreenMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ExternalScreenMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ExternalScreenMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ExternalScreenMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ExternalScreenMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraUsageOwnershipMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.CameraUsageOwnershipMonitor', scope);
    }
}
export class CameraUsageOwnershipMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraUsageOwnershipMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onCameraUsageOwnershipChanged(hasUsage) {
        return this.proxy.sendMessage(0, CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ParamsSpec.$, CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ResponseParamsSpec.$, [
            hasUsage
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CameraUsageOwnershipMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraUsageOwnershipMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraUsageOwnershipMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ParamsSpec.$, CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ResponseParamsSpec.$, impl.onCameraUsageOwnershipChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraUsageOwnershipMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.CameraUsageOwnershipMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraUsageOwnershipMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraUsageOwnershipMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraUsageOwnershipMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraUsageOwnershipMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onCameraUsageOwnershipChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ParamsSpec.$, CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ResponseParamsSpec.$, this.onCameraUsageOwnershipChanged.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class LidStateMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.LidStateMonitor', scope);
    }
}
export class LidStateMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(LidStateMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(lidStatus) {
        this.proxy.sendMessage(0, LidStateMonitor_Update_ParamsSpec.$, null, [
            lidStatus
        ], false);
    }
}
;
/**
 * An object which receives request messages for the LidStateMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LidStateMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, LidStateMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class LidStateMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.LidStateMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new LidStateMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the LidStateMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LidStateMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, LidStateMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SWPrivacySwitchMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.SWPrivacySwitchMonitor', scope);
    }
}
export class SWPrivacySwitchMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SWPrivacySwitchMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(isSwPrivacySwitchOn) {
        this.proxy.sendMessage(0, SWPrivacySwitchMonitor_Update_ParamsSpec.$, null, [
            isSwPrivacySwitchOn
        ], false);
    }
}
;
/**
 * An object which receives request messages for the SWPrivacySwitchMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SWPrivacySwitchMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SWPrivacySwitchMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SWPrivacySwitchMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SWPrivacySwitchMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.SWPrivacySwitchMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SWPrivacySwitchMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SWPrivacySwitchMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SWPrivacySwitchMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SWPrivacySwitchMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SWPrivacySwitchMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class WindowStateMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.WindowStateMonitor', scope);
    }
}
export class WindowStateMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WindowStateMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onWindowStateChanged(states) {
        this.proxy.sendMessage(0, WindowStateMonitor_OnWindowStateChanged_ParamsSpec.$, null, [
            states
        ], false);
    }
    onWindowFocusChanged(isFocus) {
        this.proxy.sendMessage(1, WindowStateMonitor_OnWindowFocusChanged_ParamsSpec.$, null, [
            isFocus
        ], false);
    }
}
;
/**
 * An object which receives request messages for the WindowStateMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WindowStateMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WindowStateMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WindowStateMonitor_OnWindowStateChanged_ParamsSpec.$, null, impl.onWindowStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, WindowStateMonitor_OnWindowFocusChanged_ParamsSpec.$, null, impl.onWindowFocusChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WindowStateMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.WindowStateMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WindowStateMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WindowStateMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WindowStateMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WindowStateMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onWindowStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WindowStateMonitor_OnWindowStateChanged_ParamsSpec.$, null, this.onWindowStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onWindowFocusChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WindowStateMonitor_OnWindowFocusChanged_ParamsSpec.$, null, this.onWindowFocusChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class StorageMonitorPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.StorageMonitor', scope);
    }
}
export class StorageMonitorRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(StorageMonitorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    update(status) {
        this.proxy.sendMessage(0, StorageMonitor_Update_ParamsSpec.$, null, [
            status
        ], false);
    }
}
;
/**
 * An object which receives request messages for the StorageMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StorageMonitorReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StorageMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, StorageMonitor_Update_ParamsSpec.$, null, impl.update.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class StorageMonitor {
    static get $interfaceName() {
        return "ash.camera_app.mojom.StorageMonitor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new StorageMonitorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the StorageMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StorageMonitorCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StorageMonitorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, StorageMonitor_Update_ParamsSpec.$, null, this.update.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class WindowStateControllerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.WindowStateController', scope);
    }
}
export class WindowStateControllerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WindowStateControllerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addMonitor(monitor) {
        return this.proxy.sendMessage(0, WindowStateController_AddMonitor_ParamsSpec.$, WindowStateController_AddMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    getWindowState() {
        return this.proxy.sendMessage(1, WindowStateController_GetWindowState_ParamsSpec.$, WindowStateController_GetWindowState_ResponseParamsSpec.$, [], false);
    }
    minimize() {
        return this.proxy.sendMessage(2, WindowStateController_Minimize_ParamsSpec.$, WindowStateController_Minimize_ResponseParamsSpec.$, [], false);
    }
    restore() {
        return this.proxy.sendMessage(3, WindowStateController_Restore_ParamsSpec.$, WindowStateController_Restore_ResponseParamsSpec.$, [], false);
    }
    maximize() {
        return this.proxy.sendMessage(4, WindowStateController_Maximize_ParamsSpec.$, WindowStateController_Maximize_ResponseParamsSpec.$, [], false);
    }
    fullscreen() {
        return this.proxy.sendMessage(5, WindowStateController_Fullscreen_ParamsSpec.$, WindowStateController_Fullscreen_ResponseParamsSpec.$, [], false);
    }
    focus() {
        return this.proxy.sendMessage(6, WindowStateController_Focus_ParamsSpec.$, WindowStateController_Focus_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the WindowStateController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WindowStateControllerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WindowStateControllerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WindowStateController_AddMonitor_ParamsSpec.$, WindowStateController_AddMonitor_ResponseParamsSpec.$, impl.addMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(1, WindowStateController_GetWindowState_ParamsSpec.$, WindowStateController_GetWindowState_ResponseParamsSpec.$, impl.getWindowState.bind(impl), false);
        this.helper_internal_.registerHandler(2, WindowStateController_Minimize_ParamsSpec.$, WindowStateController_Minimize_ResponseParamsSpec.$, impl.minimize.bind(impl), false);
        this.helper_internal_.registerHandler(3, WindowStateController_Restore_ParamsSpec.$, WindowStateController_Restore_ResponseParamsSpec.$, impl.restore.bind(impl), false);
        this.helper_internal_.registerHandler(4, WindowStateController_Maximize_ParamsSpec.$, WindowStateController_Maximize_ResponseParamsSpec.$, impl.maximize.bind(impl), false);
        this.helper_internal_.registerHandler(5, WindowStateController_Fullscreen_ParamsSpec.$, WindowStateController_Fullscreen_ResponseParamsSpec.$, impl.fullscreen.bind(impl), false);
        this.helper_internal_.registerHandler(6, WindowStateController_Focus_ParamsSpec.$, WindowStateController_Focus_ResponseParamsSpec.$, impl.focus.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WindowStateController {
    static get $interfaceName() {
        return "ash.camera_app.mojom.WindowStateController";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WindowStateControllerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WindowStateController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WindowStateControllerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WindowStateControllerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WindowStateController_AddMonitor_ParamsSpec.$, WindowStateController_AddMonitor_ResponseParamsSpec.$, this.addMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.getWindowState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WindowStateController_GetWindowState_ParamsSpec.$, WindowStateController_GetWindowState_ResponseParamsSpec.$, this.getWindowState.createReceiverHandler(true /* expectsResponse */), false);
        this.minimize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WindowStateController_Minimize_ParamsSpec.$, WindowStateController_Minimize_ResponseParamsSpec.$, this.minimize.createReceiverHandler(true /* expectsResponse */), false);
        this.restore =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WindowStateController_Restore_ParamsSpec.$, WindowStateController_Restore_ResponseParamsSpec.$, this.restore.createReceiverHandler(true /* expectsResponse */), false);
        this.maximize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WindowStateController_Maximize_ParamsSpec.$, WindowStateController_Maximize_ResponseParamsSpec.$, this.maximize.createReceiverHandler(true /* expectsResponse */), false);
        this.fullscreen =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WindowStateController_Fullscreen_ParamsSpec.$, WindowStateController_Fullscreen_ResponseParamsSpec.$, this.fullscreen.createReceiverHandler(true /* expectsResponse */), false);
        this.focus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WindowStateController_Focus_ParamsSpec.$, WindowStateController_Focus_ResponseParamsSpec.$, this.focus.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraAppHelperPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.CameraAppHelper', scope);
    }
}
export class CameraAppHelperRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraAppHelperPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    handleCameraResult(intentId, action, data) {
        return this.proxy.sendMessage(0, CameraAppHelper_HandleCameraResult_ParamsSpec.$, CameraAppHelper_HandleCameraResult_ResponseParamsSpec.$, [
            intentId,
            action,
            data
        ], false);
    }
    isTabletMode() {
        return this.proxy.sendMessage(1, CameraAppHelper_IsTabletMode_ParamsSpec.$, CameraAppHelper_IsTabletMode_ResponseParamsSpec.$, [], false);
    }
    startPerfEventTrace(event) {
        this.proxy.sendMessage(2, CameraAppHelper_StartPerfEventTrace_ParamsSpec.$, null, [
            event
        ], false);
    }
    stopPerfEventTrace(event) {
        this.proxy.sendMessage(3, CameraAppHelper_StopPerfEventTrace_ParamsSpec.$, null, [
            event
        ], false);
    }
    setTabletMonitor(monitor) {
        return this.proxy.sendMessage(4, CameraAppHelper_SetTabletMonitor_ParamsSpec.$, CameraAppHelper_SetTabletMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    setScreenStateMonitor(monitor) {
        return this.proxy.sendMessage(5, CameraAppHelper_SetScreenStateMonitor_ParamsSpec.$, CameraAppHelper_SetScreenStateMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    isMetricsAndCrashReportingEnabled() {
        return this.proxy.sendMessage(6, CameraAppHelper_IsMetricsAndCrashReportingEnabled_ParamsSpec.$, CameraAppHelper_IsMetricsAndCrashReportingEnabled_ResponseParamsSpec.$, [], false);
    }
    setExternalScreenMonitor(monitor) {
        return this.proxy.sendMessage(7, CameraAppHelper_SetExternalScreenMonitor_ParamsSpec.$, CameraAppHelper_SetExternalScreenMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    openFileInGallery(name) {
        this.proxy.sendMessage(8, CameraAppHelper_OpenFileInGallery_ParamsSpec.$, null, [
            name
        ], false);
    }
    openFeedbackDialog(placeholder) {
        this.proxy.sendMessage(9, CameraAppHelper_OpenFeedbackDialog_ParamsSpec.$, null, [
            placeholder
        ], false);
    }
    openUrlInBrowser(url) {
        this.proxy.sendMessage(10, CameraAppHelper_OpenUrlInBrowser_ParamsSpec.$, null, [
            url
        ], false);
    }
    getWindowStateController() {
        return this.proxy.sendMessage(11, CameraAppHelper_GetWindowStateController_ParamsSpec.$, CameraAppHelper_GetWindowStateController_ResponseParamsSpec.$, [], false);
    }
    sendNewCaptureBroadcast(isVideo, name) {
        this.proxy.sendMessage(12, CameraAppHelper_SendNewCaptureBroadcast_ParamsSpec.$, null, [
            isVideo,
            name
        ], false);
    }
    monitorFileDeletion(name) {
        return this.proxy.sendMessage(13, CameraAppHelper_MonitorFileDeletion_ParamsSpec.$, CameraAppHelper_MonitorFileDeletion_ResponseParamsSpec.$, [
            name
        ], false);
    }
    isDocumentScannerSupported() {
        return this.proxy.sendMessage(14, CameraAppHelper_IsDocumentScannerSupported_ParamsSpec.$, CameraAppHelper_IsDocumentScannerSupported_ResponseParamsSpec.$, [], false);
    }
    checkDocumentModeReadiness() {
        return this.proxy.sendMessage(15, CameraAppHelper_CheckDocumentModeReadiness_ParamsSpec.$, CameraAppHelper_CheckDocumentModeReadiness_ResponseParamsSpec.$, [], false);
    }
    scanDocumentCorners(jpegData) {
        return this.proxy.sendMessage(16, CameraAppHelper_ScanDocumentCorners_ParamsSpec.$, CameraAppHelper_ScanDocumentCorners_ResponseParamsSpec.$, [
            jpegData
        ], false);
    }
    convertToDocument(jpegData, corners, rotation) {
        return this.proxy.sendMessage(17, CameraAppHelper_ConvertToDocument_ParamsSpec.$, CameraAppHelper_ConvertToDocument_ResponseParamsSpec.$, [
            jpegData,
            corners,
            rotation
        ], false);
    }
    maybeTriggerSurvey() {
        this.proxy.sendMessage(18, CameraAppHelper_MaybeTriggerSurvey_ParamsSpec.$, null, [], false);
    }
    startStorageMonitor(monitor) {
        return this.proxy.sendMessage(19, CameraAppHelper_StartStorageMonitor_ParamsSpec.$, CameraAppHelper_StartStorageMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    stopStorageMonitor() {
        this.proxy.sendMessage(20, CameraAppHelper_StopStorageMonitor_ParamsSpec.$, null, [], false);
    }
    openStorageManagement() {
        this.proxy.sendMessage(21, CameraAppHelper_OpenStorageManagement_ParamsSpec.$, null, [], false);
    }
    openWifiDialog(config) {
        this.proxy.sendMessage(22, CameraAppHelper_OpenWifiDialog_ParamsSpec.$, null, [
            config
        ], false);
    }
    setLidStateMonitor(monitor) {
        return this.proxy.sendMessage(23, CameraAppHelper_SetLidStateMonitor_ParamsSpec.$, CameraAppHelper_SetLidStateMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    setSWPrivacySwitchMonitor(monitor) {
        return this.proxy.sendMessage(24, CameraAppHelper_SetSWPrivacySwitchMonitor_ParamsSpec.$, CameraAppHelper_SetSWPrivacySwitchMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    getEventsSender() {
        return this.proxy.sendMessage(25, CameraAppHelper_GetEventsSender_ParamsSpec.$, CameraAppHelper_GetEventsSender_ResponseParamsSpec.$, [], false);
    }
    setScreenLockedMonitor(monitor) {
        return this.proxy.sendMessage(26, CameraAppHelper_SetScreenLockedMonitor_ParamsSpec.$, CameraAppHelper_SetScreenLockedMonitor_ResponseParamsSpec.$, [
            monitor
        ], false);
    }
    renderPdfAsJpeg(pdfData) {
        return this.proxy.sendMessage(27, CameraAppHelper_RenderPdfAsJpeg_ParamsSpec.$, CameraAppHelper_RenderPdfAsJpeg_ResponseParamsSpec.$, [
            pdfData
        ], false);
    }
    performOcr(jpegData) {
        return this.proxy.sendMessage(28, CameraAppHelper_PerformOcr_ParamsSpec.$, CameraAppHelper_PerformOcr_ResponseParamsSpec.$, [
            jpegData
        ], false);
    }
    performOcrInline(jpegData) {
        return this.proxy.sendMessage(29, CameraAppHelper_PerformOcrInline_ParamsSpec.$, CameraAppHelper_PerformOcrInline_ResponseParamsSpec.$, [
            jpegData
        ], false);
    }
    createPdfBuilder(builder) {
        this.proxy.sendMessage(30, CameraAppHelper_CreatePdfBuilder_ParamsSpec.$, null, [
            builder
        ], false);
    }
    getAspectRatioOrder() {
        return this.proxy.sendMessage(31, CameraAppHelper_GetAspectRatioOrder_ParamsSpec.$, CameraAppHelper_GetAspectRatioOrder_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the CameraAppHelper
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraAppHelperReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppHelperRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraAppHelper_HandleCameraResult_ParamsSpec.$, CameraAppHelper_HandleCameraResult_ResponseParamsSpec.$, impl.handleCameraResult.bind(impl), false);
        this.helper_internal_.registerHandler(1, CameraAppHelper_IsTabletMode_ParamsSpec.$, CameraAppHelper_IsTabletMode_ResponseParamsSpec.$, impl.isTabletMode.bind(impl), false);
        this.helper_internal_.registerHandler(2, CameraAppHelper_StartPerfEventTrace_ParamsSpec.$, null, impl.startPerfEventTrace.bind(impl), false);
        this.helper_internal_.registerHandler(3, CameraAppHelper_StopPerfEventTrace_ParamsSpec.$, null, impl.stopPerfEventTrace.bind(impl), false);
        this.helper_internal_.registerHandler(4, CameraAppHelper_SetTabletMonitor_ParamsSpec.$, CameraAppHelper_SetTabletMonitor_ResponseParamsSpec.$, impl.setTabletMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(5, CameraAppHelper_SetScreenStateMonitor_ParamsSpec.$, CameraAppHelper_SetScreenStateMonitor_ResponseParamsSpec.$, impl.setScreenStateMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(6, CameraAppHelper_IsMetricsAndCrashReportingEnabled_ParamsSpec.$, CameraAppHelper_IsMetricsAndCrashReportingEnabled_ResponseParamsSpec.$, impl.isMetricsAndCrashReportingEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(7, CameraAppHelper_SetExternalScreenMonitor_ParamsSpec.$, CameraAppHelper_SetExternalScreenMonitor_ResponseParamsSpec.$, impl.setExternalScreenMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(8, CameraAppHelper_OpenFileInGallery_ParamsSpec.$, null, impl.openFileInGallery.bind(impl), false);
        this.helper_internal_.registerHandler(9, CameraAppHelper_OpenFeedbackDialog_ParamsSpec.$, null, impl.openFeedbackDialog.bind(impl), false);
        this.helper_internal_.registerHandler(10, CameraAppHelper_OpenUrlInBrowser_ParamsSpec.$, null, impl.openUrlInBrowser.bind(impl), false);
        this.helper_internal_.registerHandler(11, CameraAppHelper_GetWindowStateController_ParamsSpec.$, CameraAppHelper_GetWindowStateController_ResponseParamsSpec.$, impl.getWindowStateController.bind(impl), false);
        this.helper_internal_.registerHandler(12, CameraAppHelper_SendNewCaptureBroadcast_ParamsSpec.$, null, impl.sendNewCaptureBroadcast.bind(impl), false);
        this.helper_internal_.registerHandler(13, CameraAppHelper_MonitorFileDeletion_ParamsSpec.$, CameraAppHelper_MonitorFileDeletion_ResponseParamsSpec.$, impl.monitorFileDeletion.bind(impl), false);
        this.helper_internal_.registerHandler(14, CameraAppHelper_IsDocumentScannerSupported_ParamsSpec.$, CameraAppHelper_IsDocumentScannerSupported_ResponseParamsSpec.$, impl.isDocumentScannerSupported.bind(impl), false);
        this.helper_internal_.registerHandler(15, CameraAppHelper_CheckDocumentModeReadiness_ParamsSpec.$, CameraAppHelper_CheckDocumentModeReadiness_ResponseParamsSpec.$, impl.checkDocumentModeReadiness.bind(impl), false);
        this.helper_internal_.registerHandler(16, CameraAppHelper_ScanDocumentCorners_ParamsSpec.$, CameraAppHelper_ScanDocumentCorners_ResponseParamsSpec.$, impl.scanDocumentCorners.bind(impl), false);
        this.helper_internal_.registerHandler(17, CameraAppHelper_ConvertToDocument_ParamsSpec.$, CameraAppHelper_ConvertToDocument_ResponseParamsSpec.$, impl.convertToDocument.bind(impl), false);
        this.helper_internal_.registerHandler(18, CameraAppHelper_MaybeTriggerSurvey_ParamsSpec.$, null, impl.maybeTriggerSurvey.bind(impl), false);
        this.helper_internal_.registerHandler(19, CameraAppHelper_StartStorageMonitor_ParamsSpec.$, CameraAppHelper_StartStorageMonitor_ResponseParamsSpec.$, impl.startStorageMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(20, CameraAppHelper_StopStorageMonitor_ParamsSpec.$, null, impl.stopStorageMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(21, CameraAppHelper_OpenStorageManagement_ParamsSpec.$, null, impl.openStorageManagement.bind(impl), false);
        this.helper_internal_.registerHandler(22, CameraAppHelper_OpenWifiDialog_ParamsSpec.$, null, impl.openWifiDialog.bind(impl), false);
        this.helper_internal_.registerHandler(23, CameraAppHelper_SetLidStateMonitor_ParamsSpec.$, CameraAppHelper_SetLidStateMonitor_ResponseParamsSpec.$, impl.setLidStateMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(24, CameraAppHelper_SetSWPrivacySwitchMonitor_ParamsSpec.$, CameraAppHelper_SetSWPrivacySwitchMonitor_ResponseParamsSpec.$, impl.setSWPrivacySwitchMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(25, CameraAppHelper_GetEventsSender_ParamsSpec.$, CameraAppHelper_GetEventsSender_ResponseParamsSpec.$, impl.getEventsSender.bind(impl), false);
        this.helper_internal_.registerHandler(26, CameraAppHelper_SetScreenLockedMonitor_ParamsSpec.$, CameraAppHelper_SetScreenLockedMonitor_ResponseParamsSpec.$, impl.setScreenLockedMonitor.bind(impl), false);
        this.helper_internal_.registerHandler(27, CameraAppHelper_RenderPdfAsJpeg_ParamsSpec.$, CameraAppHelper_RenderPdfAsJpeg_ResponseParamsSpec.$, impl.renderPdfAsJpeg.bind(impl), false);
        this.helper_internal_.registerHandler(28, CameraAppHelper_PerformOcr_ParamsSpec.$, CameraAppHelper_PerformOcr_ResponseParamsSpec.$, impl.performOcr.bind(impl), false);
        this.helper_internal_.registerHandler(29, CameraAppHelper_PerformOcrInline_ParamsSpec.$, CameraAppHelper_PerformOcrInline_ResponseParamsSpec.$, impl.performOcrInline.bind(impl), false);
        this.helper_internal_.registerHandler(30, CameraAppHelper_CreatePdfBuilder_ParamsSpec.$, null, impl.createPdfBuilder.bind(impl), false);
        this.helper_internal_.registerHandler(31, CameraAppHelper_GetAspectRatioOrder_ParamsSpec.$, CameraAppHelper_GetAspectRatioOrder_ResponseParamsSpec.$, impl.getAspectRatioOrder.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraAppHelper {
    static get $interfaceName() {
        return "ash.camera_app.mojom.CameraAppHelper";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraAppHelperRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraAppHelper
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraAppHelperCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppHelperRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.handleCameraResult =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraAppHelper_HandleCameraResult_ParamsSpec.$, CameraAppHelper_HandleCameraResult_ResponseParamsSpec.$, this.handleCameraResult.createReceiverHandler(true /* expectsResponse */), false);
        this.isTabletMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CameraAppHelper_IsTabletMode_ParamsSpec.$, CameraAppHelper_IsTabletMode_ResponseParamsSpec.$, this.isTabletMode.createReceiverHandler(true /* expectsResponse */), false);
        this.startPerfEventTrace =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CameraAppHelper_StartPerfEventTrace_ParamsSpec.$, null, this.startPerfEventTrace.createReceiverHandler(false /* expectsResponse */), false);
        this.stopPerfEventTrace =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CameraAppHelper_StopPerfEventTrace_ParamsSpec.$, null, this.stopPerfEventTrace.createReceiverHandler(false /* expectsResponse */), false);
        this.setTabletMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CameraAppHelper_SetTabletMonitor_ParamsSpec.$, CameraAppHelper_SetTabletMonitor_ResponseParamsSpec.$, this.setTabletMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.setScreenStateMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CameraAppHelper_SetScreenStateMonitor_ParamsSpec.$, CameraAppHelper_SetScreenStateMonitor_ResponseParamsSpec.$, this.setScreenStateMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.isMetricsAndCrashReportingEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CameraAppHelper_IsMetricsAndCrashReportingEnabled_ParamsSpec.$, CameraAppHelper_IsMetricsAndCrashReportingEnabled_ResponseParamsSpec.$, this.isMetricsAndCrashReportingEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.setExternalScreenMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CameraAppHelper_SetExternalScreenMonitor_ParamsSpec.$, CameraAppHelper_SetExternalScreenMonitor_ResponseParamsSpec.$, this.setExternalScreenMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.openFileInGallery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, CameraAppHelper_OpenFileInGallery_ParamsSpec.$, null, this.openFileInGallery.createReceiverHandler(false /* expectsResponse */), false);
        this.openFeedbackDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, CameraAppHelper_OpenFeedbackDialog_ParamsSpec.$, null, this.openFeedbackDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.openUrlInBrowser =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, CameraAppHelper_OpenUrlInBrowser_ParamsSpec.$, null, this.openUrlInBrowser.createReceiverHandler(false /* expectsResponse */), false);
        this.getWindowStateController =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, CameraAppHelper_GetWindowStateController_ParamsSpec.$, CameraAppHelper_GetWindowStateController_ResponseParamsSpec.$, this.getWindowStateController.createReceiverHandler(true /* expectsResponse */), false);
        this.sendNewCaptureBroadcast =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, CameraAppHelper_SendNewCaptureBroadcast_ParamsSpec.$, null, this.sendNewCaptureBroadcast.createReceiverHandler(false /* expectsResponse */), false);
        this.monitorFileDeletion =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, CameraAppHelper_MonitorFileDeletion_ParamsSpec.$, CameraAppHelper_MonitorFileDeletion_ResponseParamsSpec.$, this.monitorFileDeletion.createReceiverHandler(true /* expectsResponse */), false);
        this.isDocumentScannerSupported =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, CameraAppHelper_IsDocumentScannerSupported_ParamsSpec.$, CameraAppHelper_IsDocumentScannerSupported_ResponseParamsSpec.$, this.isDocumentScannerSupported.createReceiverHandler(true /* expectsResponse */), false);
        this.checkDocumentModeReadiness =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, CameraAppHelper_CheckDocumentModeReadiness_ParamsSpec.$, CameraAppHelper_CheckDocumentModeReadiness_ResponseParamsSpec.$, this.checkDocumentModeReadiness.createReceiverHandler(true /* expectsResponse */), false);
        this.scanDocumentCorners =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, CameraAppHelper_ScanDocumentCorners_ParamsSpec.$, CameraAppHelper_ScanDocumentCorners_ResponseParamsSpec.$, this.scanDocumentCorners.createReceiverHandler(true /* expectsResponse */), false);
        this.convertToDocument =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, CameraAppHelper_ConvertToDocument_ParamsSpec.$, CameraAppHelper_ConvertToDocument_ResponseParamsSpec.$, this.convertToDocument.createReceiverHandler(true /* expectsResponse */), false);
        this.maybeTriggerSurvey =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, CameraAppHelper_MaybeTriggerSurvey_ParamsSpec.$, null, this.maybeTriggerSurvey.createReceiverHandler(false /* expectsResponse */), false);
        this.startStorageMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, CameraAppHelper_StartStorageMonitor_ParamsSpec.$, CameraAppHelper_StartStorageMonitor_ResponseParamsSpec.$, this.startStorageMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.stopStorageMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, CameraAppHelper_StopStorageMonitor_ParamsSpec.$, null, this.stopStorageMonitor.createReceiverHandler(false /* expectsResponse */), false);
        this.openStorageManagement =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, CameraAppHelper_OpenStorageManagement_ParamsSpec.$, null, this.openStorageManagement.createReceiverHandler(false /* expectsResponse */), false);
        this.openWifiDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, CameraAppHelper_OpenWifiDialog_ParamsSpec.$, null, this.openWifiDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.setLidStateMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, CameraAppHelper_SetLidStateMonitor_ParamsSpec.$, CameraAppHelper_SetLidStateMonitor_ResponseParamsSpec.$, this.setLidStateMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.setSWPrivacySwitchMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, CameraAppHelper_SetSWPrivacySwitchMonitor_ParamsSpec.$, CameraAppHelper_SetSWPrivacySwitchMonitor_ResponseParamsSpec.$, this.setSWPrivacySwitchMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.getEventsSender =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, CameraAppHelper_GetEventsSender_ParamsSpec.$, CameraAppHelper_GetEventsSender_ResponseParamsSpec.$, this.getEventsSender.createReceiverHandler(true /* expectsResponse */), false);
        this.setScreenLockedMonitor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(26, CameraAppHelper_SetScreenLockedMonitor_ParamsSpec.$, CameraAppHelper_SetScreenLockedMonitor_ResponseParamsSpec.$, this.setScreenLockedMonitor.createReceiverHandler(true /* expectsResponse */), false);
        this.renderPdfAsJpeg =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(27, CameraAppHelper_RenderPdfAsJpeg_ParamsSpec.$, CameraAppHelper_RenderPdfAsJpeg_ResponseParamsSpec.$, this.renderPdfAsJpeg.createReceiverHandler(true /* expectsResponse */), false);
        this.performOcr =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(28, CameraAppHelper_PerformOcr_ParamsSpec.$, CameraAppHelper_PerformOcr_ResponseParamsSpec.$, this.performOcr.createReceiverHandler(true /* expectsResponse */), false);
        this.performOcrInline =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(29, CameraAppHelper_PerformOcrInline_ParamsSpec.$, CameraAppHelper_PerformOcrInline_ResponseParamsSpec.$, this.performOcrInline.createReceiverHandler(true /* expectsResponse */), false);
        this.createPdfBuilder =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(30, CameraAppHelper_CreatePdfBuilder_ParamsSpec.$, null, this.createPdfBuilder.createReceiverHandler(false /* expectsResponse */), false);
        this.getAspectRatioOrder =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(31, CameraAppHelper_GetAspectRatioOrder_ParamsSpec.$, CameraAppHelper_GetAspectRatioOrder_ResponseParamsSpec.$, this.getAspectRatioOrder.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const WifiConfigSpec = { $: {} };
export const TabletModeMonitor_Update_ParamsSpec = { $: {} };
export const ScreenStateMonitor_Update_ParamsSpec = { $: {} };
export const ScreenLockedMonitor_Update_ParamsSpec = { $: {} };
export const ExternalScreenMonitor_Update_ParamsSpec = { $: {} };
export const CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ParamsSpec = { $: {} };
export const CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ResponseParamsSpec = { $: {} };
export const LidStateMonitor_Update_ParamsSpec = { $: {} };
export const SWPrivacySwitchMonitor_Update_ParamsSpec = { $: {} };
export const WindowStateMonitor_OnWindowStateChanged_ParamsSpec = { $: {} };
export const WindowStateMonitor_OnWindowFocusChanged_ParamsSpec = { $: {} };
export const StorageMonitor_Update_ParamsSpec = { $: {} };
export const WindowStateController_AddMonitor_ParamsSpec = { $: {} };
export const WindowStateController_AddMonitor_ResponseParamsSpec = { $: {} };
export const WindowStateController_GetWindowState_ParamsSpec = { $: {} };
export const WindowStateController_GetWindowState_ResponseParamsSpec = { $: {} };
export const WindowStateController_Minimize_ParamsSpec = { $: {} };
export const WindowStateController_Minimize_ResponseParamsSpec = { $: {} };
export const WindowStateController_Restore_ParamsSpec = { $: {} };
export const WindowStateController_Restore_ResponseParamsSpec = { $: {} };
export const WindowStateController_Maximize_ParamsSpec = { $: {} };
export const WindowStateController_Maximize_ResponseParamsSpec = { $: {} };
export const WindowStateController_Fullscreen_ParamsSpec = { $: {} };
export const WindowStateController_Fullscreen_ResponseParamsSpec = { $: {} };
export const WindowStateController_Focus_ParamsSpec = { $: {} };
export const WindowStateController_Focus_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_HandleCameraResult_ParamsSpec = { $: {} };
export const CameraAppHelper_HandleCameraResult_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_IsTabletMode_ParamsSpec = { $: {} };
export const CameraAppHelper_IsTabletMode_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_StartPerfEventTrace_ParamsSpec = { $: {} };
export const CameraAppHelper_StopPerfEventTrace_ParamsSpec = { $: {} };
export const CameraAppHelper_SetTabletMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_SetTabletMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_SetScreenStateMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_SetScreenStateMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_IsMetricsAndCrashReportingEnabled_ParamsSpec = { $: {} };
export const CameraAppHelper_IsMetricsAndCrashReportingEnabled_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_SetExternalScreenMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_SetExternalScreenMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_OpenFileInGallery_ParamsSpec = { $: {} };
export const CameraAppHelper_OpenFeedbackDialog_ParamsSpec = { $: {} };
export const CameraAppHelper_OpenUrlInBrowser_ParamsSpec = { $: {} };
export const CameraAppHelper_GetWindowStateController_ParamsSpec = { $: {} };
export const CameraAppHelper_GetWindowStateController_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_SendNewCaptureBroadcast_ParamsSpec = { $: {} };
export const CameraAppHelper_MonitorFileDeletion_ParamsSpec = { $: {} };
export const CameraAppHelper_MonitorFileDeletion_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_IsDocumentScannerSupported_ParamsSpec = { $: {} };
export const CameraAppHelper_IsDocumentScannerSupported_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_CheckDocumentModeReadiness_ParamsSpec = { $: {} };
export const CameraAppHelper_CheckDocumentModeReadiness_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_ScanDocumentCorners_ParamsSpec = { $: {} };
export const CameraAppHelper_ScanDocumentCorners_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_ConvertToDocument_ParamsSpec = { $: {} };
export const CameraAppHelper_ConvertToDocument_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_MaybeTriggerSurvey_ParamsSpec = { $: {} };
export const CameraAppHelper_StartStorageMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_StartStorageMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_StopStorageMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_OpenStorageManagement_ParamsSpec = { $: {} };
export const CameraAppHelper_OpenWifiDialog_ParamsSpec = { $: {} };
export const CameraAppHelper_SetLidStateMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_SetLidStateMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_SetSWPrivacySwitchMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_SetSWPrivacySwitchMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_GetEventsSender_ParamsSpec = { $: {} };
export const CameraAppHelper_GetEventsSender_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_SetScreenLockedMonitor_ParamsSpec = { $: {} };
export const CameraAppHelper_SetScreenLockedMonitor_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_RenderPdfAsJpeg_ParamsSpec = { $: {} };
export const CameraAppHelper_RenderPdfAsJpeg_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_PerformOcr_ParamsSpec = { $: {} };
export const CameraAppHelper_PerformOcr_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_PerformOcrInline_ParamsSpec = { $: {} };
export const CameraAppHelper_PerformOcrInline_ResponseParamsSpec = { $: {} };
export const CameraAppHelper_CreatePdfBuilder_ParamsSpec = { $: {} };
export const CameraAppHelper_GetAspectRatioOrder_ParamsSpec = { $: {} };
export const CameraAppHelper_GetAspectRatioOrder_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(WifiConfigSpec.$, 'WifiConfig', [
    mojo.internal.StructField('ssid', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('security', 8, 0, ash_cameraApp_mojom_WifiSecurityTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('password', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('eap_method_$flag', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "eap_method_$value",
        originalFieldName: "eapMethod",
    }, undefined),
    mojo.internal.StructField('eap_method_$value', 24, 0, ash_cameraApp_mojom_WifiEapMethodSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "eapMethod",
    }, undefined),
    mojo.internal.StructField('eap_phase2_method_$flag', 12, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "eap_phase2_method_$value",
        originalFieldName: "eapPhase2Method",
    }, undefined),
    mojo.internal.StructField('eap_phase2_method_$value', 28, 0, ash_cameraApp_mojom_WifiEapPhase2MethodSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "eapPhase2Method",
    }, undefined),
    mojo.internal.StructField('eapIdentity', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('eapAnonymousIdentity', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(TabletModeMonitor_Update_ParamsSpec.$, 'TabletModeMonitor_Update_Params', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScreenStateMonitor_Update_ParamsSpec.$, 'ScreenStateMonitor_Update_Params', [
    mojo.internal.StructField('state', 0, 0, ScreenStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScreenLockedMonitor_Update_ParamsSpec.$, 'ScreenLockedMonitor_Update_Params', [
    mojo.internal.StructField('isScreenLocked', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ExternalScreenMonitor_Update_ParamsSpec.$, 'ExternalScreenMonitor_Update_Params', [
    mojo.internal.StructField('hasExternalScreen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ParamsSpec.$, 'CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_Params', [
    mojo.internal.StructField('hasUsage', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ResponseParamsSpec.$, 'CameraUsageOwnershipMonitor_OnCameraUsageOwnershipChanged_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(LidStateMonitor_Update_ParamsSpec.$, 'LidStateMonitor_Update_Params', [
    mojo.internal.StructField('lidStatus', 0, 0, LidStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SWPrivacySwitchMonitor_Update_ParamsSpec.$, 'SWPrivacySwitchMonitor_Update_Params', [
    mojo.internal.StructField('isSwPrivacySwitchOn', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WindowStateMonitor_OnWindowStateChanged_ParamsSpec.$, 'WindowStateMonitor_OnWindowStateChanged_Params', [
    mojo.internal.StructField('states', 0, 0, mojo.internal.Array(WindowStateTypeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WindowStateMonitor_OnWindowFocusChanged_ParamsSpec.$, 'WindowStateMonitor_OnWindowFocusChanged_Params', [
    mojo.internal.StructField('isFocus', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(StorageMonitor_Update_ParamsSpec.$, 'StorageMonitor_Update_Params', [
    mojo.internal.StructField('status', 0, 0, StorageMonitorStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WindowStateController_AddMonitor_ParamsSpec.$, 'WindowStateController_AddMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(WindowStateMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WindowStateController_AddMonitor_ResponseParamsSpec.$, 'WindowStateController_AddMonitor_ResponseParams', [
    mojo.internal.StructField('states', 0, 0, mojo.internal.Array(WindowStateTypeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WindowStateController_GetWindowState_ParamsSpec.$, 'WindowStateController_GetWindowState_Params', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_GetWindowState_ResponseParamsSpec.$, 'WindowStateController_GetWindowState_ResponseParams', [
    mojo.internal.StructField('states', 0, 0, mojo.internal.Array(WindowStateTypeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WindowStateController_Minimize_ParamsSpec.$, 'WindowStateController_Minimize_Params', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Minimize_ResponseParamsSpec.$, 'WindowStateController_Minimize_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Restore_ParamsSpec.$, 'WindowStateController_Restore_Params', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Restore_ResponseParamsSpec.$, 'WindowStateController_Restore_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Maximize_ParamsSpec.$, 'WindowStateController_Maximize_Params', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Maximize_ResponseParamsSpec.$, 'WindowStateController_Maximize_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Fullscreen_ParamsSpec.$, 'WindowStateController_Fullscreen_Params', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Fullscreen_ResponseParamsSpec.$, 'WindowStateController_Fullscreen_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Focus_ParamsSpec.$, 'WindowStateController_Focus_Params', [], [[0, 8],]);
mojo.internal.Struct(WindowStateController_Focus_ResponseParamsSpec.$, 'WindowStateController_Focus_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_HandleCameraResult_ParamsSpec.$, 'CameraAppHelper_HandleCameraResult_Params', [
    mojo.internal.StructField('intentId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('action', 4, 0, arc_mojom_CameraIntentActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppHelper_HandleCameraResult_ResponseParamsSpec.$, 'CameraAppHelper_HandleCameraResult_ResponseParams', [
    mojo.internal.StructField('isSuccess', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_IsTabletMode_ParamsSpec.$, 'CameraAppHelper_IsTabletMode_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_IsTabletMode_ResponseParamsSpec.$, 'CameraAppHelper_IsTabletMode_ResponseParams', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_StartPerfEventTrace_ParamsSpec.$, 'CameraAppHelper_StartPerfEventTrace_Params', [
    mojo.internal.StructField('event', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_StopPerfEventTrace_ParamsSpec.$, 'CameraAppHelper_StopPerfEventTrace_Params', [
    mojo.internal.StructField('event', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetTabletMonitor_ParamsSpec.$, 'CameraAppHelper_SetTabletMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(TabletModeMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetTabletMonitor_ResponseParamsSpec.$, 'CameraAppHelper_SetTabletMonitor_ResponseParams', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetScreenStateMonitor_ParamsSpec.$, 'CameraAppHelper_SetScreenStateMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(ScreenStateMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetScreenStateMonitor_ResponseParamsSpec.$, 'CameraAppHelper_SetScreenStateMonitor_ResponseParams', [
    mojo.internal.StructField('initialState', 0, 0, ScreenStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_IsMetricsAndCrashReportingEnabled_ParamsSpec.$, 'CameraAppHelper_IsMetricsAndCrashReportingEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_IsMetricsAndCrashReportingEnabled_ResponseParamsSpec.$, 'CameraAppHelper_IsMetricsAndCrashReportingEnabled_ResponseParams', [
    mojo.internal.StructField('isEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetExternalScreenMonitor_ParamsSpec.$, 'CameraAppHelper_SetExternalScreenMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(ExternalScreenMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetExternalScreenMonitor_ResponseParamsSpec.$, 'CameraAppHelper_SetExternalScreenMonitor_ResponseParams', [
    mojo.internal.StructField('hasExternalScreen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_OpenFileInGallery_ParamsSpec.$, 'CameraAppHelper_OpenFileInGallery_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_OpenFeedbackDialog_ParamsSpec.$, 'CameraAppHelper_OpenFeedbackDialog_Params', [
    mojo.internal.StructField('placeholder', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_OpenUrlInBrowser_ParamsSpec.$, 'CameraAppHelper_OpenUrlInBrowser_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_GetWindowStateController_ParamsSpec.$, 'CameraAppHelper_GetWindowStateController_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_GetWindowStateController_ResponseParamsSpec.$, 'CameraAppHelper_GetWindowStateController_ResponseParams', [
    mojo.internal.StructField('controller', 0, 0, mojo.internal.InterfaceProxy(WindowStateControllerRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SendNewCaptureBroadcast_ParamsSpec.$, 'CameraAppHelper_SendNewCaptureBroadcast_Params', [
    mojo.internal.StructField('isVideo', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppHelper_MonitorFileDeletion_ParamsSpec.$, 'CameraAppHelper_MonitorFileDeletion_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_MonitorFileDeletion_ResponseParamsSpec.$, 'CameraAppHelper_MonitorFileDeletion_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, FileMonitorResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_IsDocumentScannerSupported_ParamsSpec.$, 'CameraAppHelper_IsDocumentScannerSupported_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_IsDocumentScannerSupported_ResponseParamsSpec.$, 'CameraAppHelper_IsDocumentScannerSupported_ResponseParams', [
    mojo.internal.StructField('isSupported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_CheckDocumentModeReadiness_ParamsSpec.$, 'CameraAppHelper_CheckDocumentModeReadiness_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_CheckDocumentModeReadiness_ResponseParamsSpec.$, 'CameraAppHelper_CheckDocumentModeReadiness_ResponseParams', [
    mojo.internal.StructField('isLoaded', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_ScanDocumentCorners_ParamsSpec.$, 'CameraAppHelper_ScanDocumentCorners_Params', [
    mojo.internal.StructField('jpegData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_ScanDocumentCorners_ResponseParamsSpec.$, 'CameraAppHelper_ScanDocumentCorners_ResponseParams', [
    mojo.internal.StructField('corners', 0, 0, mojo.internal.Array(gfx_mojom_PointFSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_ConvertToDocument_ParamsSpec.$, 'CameraAppHelper_ConvertToDocument_Params', [
    mojo.internal.StructField('jpegData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('corners', 8, 0, mojo.internal.Array(gfx_mojom_PointFSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rotation', 16, 0, chromeos_machineLearning_mojom_RotationSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(CameraAppHelper_ConvertToDocument_ResponseParamsSpec.$, 'CameraAppHelper_ConvertToDocument_ResponseParams', [
    mojo.internal.StructField('docData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_MaybeTriggerSurvey_ParamsSpec.$, 'CameraAppHelper_MaybeTriggerSurvey_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_StartStorageMonitor_ParamsSpec.$, 'CameraAppHelper_StartStorageMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(StorageMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_StartStorageMonitor_ResponseParamsSpec.$, 'CameraAppHelper_StartStorageMonitor_ResponseParams', [
    mojo.internal.StructField('initialStatus', 0, 0, StorageMonitorStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_StopStorageMonitor_ParamsSpec.$, 'CameraAppHelper_StopStorageMonitor_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_OpenStorageManagement_ParamsSpec.$, 'CameraAppHelper_OpenStorageManagement_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_OpenWifiDialog_ParamsSpec.$, 'CameraAppHelper_OpenWifiDialog_Params', [
    mojo.internal.StructField('config', 0, 0, WifiConfigSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetLidStateMonitor_ParamsSpec.$, 'CameraAppHelper_SetLidStateMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(LidStateMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetLidStateMonitor_ResponseParamsSpec.$, 'CameraAppHelper_SetLidStateMonitor_ResponseParams', [
    mojo.internal.StructField('lidStatus', 0, 0, LidStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetSWPrivacySwitchMonitor_ParamsSpec.$, 'CameraAppHelper_SetSWPrivacySwitchMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(SWPrivacySwitchMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetSWPrivacySwitchMonitor_ResponseParamsSpec.$, 'CameraAppHelper_SetSWPrivacySwitchMonitor_ResponseParams', [
    mojo.internal.StructField('isSwPrivacySwitchOn', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_GetEventsSender_ParamsSpec.$, 'CameraAppHelper_GetEventsSender_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_GetEventsSender_ResponseParamsSpec.$, 'CameraAppHelper_GetEventsSender_ResponseParams', [
    mojo.internal.StructField('eventsSender', 0, 0, mojo.internal.InterfaceProxy(ash_cameraApp_mojom_EventsSenderRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetScreenLockedMonitor_ParamsSpec.$, 'CameraAppHelper_SetScreenLockedMonitor_Params', [
    mojo.internal.StructField('monitor', 0, 0, mojo.internal.InterfaceProxy(ScreenLockedMonitorRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_SetScreenLockedMonitor_ResponseParamsSpec.$, 'CameraAppHelper_SetScreenLockedMonitor_ResponseParams', [
    mojo.internal.StructField('isScreenLocked', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_RenderPdfAsJpeg_ParamsSpec.$, 'CameraAppHelper_RenderPdfAsJpeg_Params', [
    mojo.internal.StructField('pdfData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_RenderPdfAsJpeg_ResponseParamsSpec.$, 'CameraAppHelper_RenderPdfAsJpeg_ResponseParams', [
    mojo.internal.StructField('jpegData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_PerformOcr_ParamsSpec.$, 'CameraAppHelper_PerformOcr_Params', [
    mojo.internal.StructField('jpegData', 0, 0, mojoBase_mojom_BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppHelper_PerformOcr_ResponseParamsSpec.$, 'CameraAppHelper_PerformOcr_ResponseParams', [
    mojo.internal.StructField('ocrResult', 0, 0, ash_cameraApp_mojom_OcrResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_PerformOcrInline_ParamsSpec.$, 'CameraAppHelper_PerformOcrInline_Params', [
    mojo.internal.StructField('jpegData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_PerformOcrInline_ResponseParamsSpec.$, 'CameraAppHelper_PerformOcrInline_ResponseParams', [
    mojo.internal.StructField('ocrResult', 0, 0, ash_cameraApp_mojom_OcrResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_CreatePdfBuilder_ParamsSpec.$, 'CameraAppHelper_CreatePdfBuilder_Params', [
    mojo.internal.StructField('builder', 0, 0, mojo.internal.InterfaceRequest(ash_cameraApp_mojom_PdfBuilderPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppHelper_GetAspectRatioOrder_ParamsSpec.$, 'CameraAppHelper_GetAspectRatioOrder_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppHelper_GetAspectRatioOrder_ResponseParamsSpec.$, 'CameraAppHelper_GetAspectRatioOrder_ResponseParams', [
    mojo.internal.StructField('order', 0, 0, mojo.internal.Array(AspectRatioSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
