// ash/webui/camera_app_ui/events_sender.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { WifiSecurityTypeSpec as ash_cameraApp_mojom_WifiSecurityTypeSpec } from './types.mojom-webui.js';
export const LaunchTypeSpec = { $: mojo.internal.Enum() };
export var LaunchType;
(function (LaunchType) {
    LaunchType[LaunchType["MIN_VALUE"] = 0] = "MIN_VALUE";
    LaunchType[LaunchType["MAX_VALUE"] = 1] = "MAX_VALUE";
    LaunchType[LaunchType["kDefault"] = 0] = "kDefault";
    LaunchType[LaunchType["kAssistant"] = 1] = "kAssistant";
})(LaunchType || (LaunchType = {}));
export const ModeSpec = { $: mojo.internal.Enum() };
export var Mode;
(function (Mode) {
    Mode[Mode["MIN_VALUE"] = 0] = "MIN_VALUE";
    Mode[Mode["MAX_VALUE"] = 3] = "MAX_VALUE";
    Mode[Mode["kPhoto"] = 0] = "kPhoto";
    Mode[Mode["kVideo"] = 1] = "kVideo";
    Mode[Mode["kScan"] = 2] = "kScan";
    Mode[Mode["kPortrait"] = 3] = "kPortrait";
})(Mode || (Mode = {}));
export const FacingSpec = { $: mojo.internal.Enum() };
export var Facing;
(function (Facing) {
    Facing[Facing["MIN_VALUE"] = 0] = "MIN_VALUE";
    Facing[Facing["MAX_VALUE"] = 3] = "MAX_VALUE";
    Facing[Facing["kEnvironment"] = 0] = "kEnvironment";
    Facing[Facing["kUser"] = 1] = "kUser";
    Facing[Facing["kExternal"] = 2] = "kExternal";
    Facing[Facing["kUnknown"] = 3] = "kUnknown";
})(Facing || (Facing = {}));
export const GridTypeSpec = { $: mojo.internal.Enum() };
export var GridType;
(function (GridType) {
    GridType[GridType["MIN_VALUE"] = 0] = "MIN_VALUE";
    GridType[GridType["MAX_VALUE"] = 3] = "MAX_VALUE";
    GridType[GridType["kNone"] = 0] = "kNone";
    GridType[GridType["k3X3"] = 1] = "k3X3";
    GridType[GridType["k4X4"] = 2] = "k4X4";
    GridType[GridType["kGolden"] = 3] = "kGolden";
})(GridType || (GridType = {}));
export const TimerTypeSpec = { $: mojo.internal.Enum() };
export var TimerType;
(function (TimerType) {
    TimerType[TimerType["MIN_VALUE"] = 0] = "MIN_VALUE";
    TimerType[TimerType["MAX_VALUE"] = 2] = "MAX_VALUE";
    TimerType[TimerType["kNone"] = 0] = "kNone";
    TimerType[TimerType["k3Seconds"] = 1] = "k3Seconds";
    TimerType[TimerType["k10Seconds"] = 2] = "k10Seconds";
})(TimerType || (TimerType = {}));
export const ShutterTypeSpec = { $: mojo.internal.Enum() };
export var ShutterType;
(function (ShutterType) {
    ShutterType[ShutterType["MIN_VALUE"] = 0] = "MIN_VALUE";
    ShutterType[ShutterType["MAX_VALUE"] = 5] = "MAX_VALUE";
    ShutterType[ShutterType["kUnknown"] = 0] = "kUnknown";
    ShutterType[ShutterType["kAssistant"] = 1] = "kAssistant";
    ShutterType[ShutterType["kKeyboard"] = 2] = "kKeyboard";
    ShutterType[ShutterType["kMouse"] = 3] = "kMouse";
    ShutterType[ShutterType["kTouch"] = 4] = "kTouch";
    ShutterType[ShutterType["kVolumeKey"] = 5] = "kVolumeKey";
})(ShutterType || (ShutterType = {}));
export const PressureSpec = { $: mojo.internal.Enum() };
export var Pressure;
(function (Pressure) {
    Pressure[Pressure["MIN_VALUE"] = 0] = "MIN_VALUE";
    Pressure[Pressure["MAX_VALUE"] = 3] = "MAX_VALUE";
    Pressure[Pressure["kNominal"] = 0] = "kNominal";
    Pressure[Pressure["kFair"] = 1] = "kFair";
    Pressure[Pressure["kSerious"] = 2] = "kSerious";
    Pressure[Pressure["kCritical"] = 3] = "kCritical";
})(Pressure || (Pressure = {}));
export const AndroidIntentResultTypeSpec = { $: mojo.internal.Enum() };
export var AndroidIntentResultType;
(function (AndroidIntentResultType) {
    AndroidIntentResultType[AndroidIntentResultType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AndroidIntentResultType[AndroidIntentResultType["MAX_VALUE"] = 2] = "MAX_VALUE";
    AndroidIntentResultType[AndroidIntentResultType["kNotIntent"] = 0] = "kNotIntent";
    AndroidIntentResultType[AndroidIntentResultType["kConfirmed"] = 1] = "kConfirmed";
    AndroidIntentResultType[AndroidIntentResultType["kCanceled"] = 2] = "kCanceled";
})(AndroidIntentResultType || (AndroidIntentResultType = {}));
export const ResolutionLevelSpec = { $: mojo.internal.Enum() };
export var ResolutionLevel;
(function (ResolutionLevel) {
    ResolutionLevel[ResolutionLevel["MIN_VALUE"] = 0] = "MIN_VALUE";
    ResolutionLevel[ResolutionLevel["MAX_VALUE"] = 7] = "MAX_VALUE";
    ResolutionLevel[ResolutionLevel["kUnknown"] = 0] = "kUnknown";
    ResolutionLevel[ResolutionLevel["k4K"] = 1] = "k4K";
    ResolutionLevel[ResolutionLevel["kQuadHD"] = 2] = "kQuadHD";
    ResolutionLevel[ResolutionLevel["kFullHD"] = 3] = "kFullHD";
    ResolutionLevel[ResolutionLevel["kHD"] = 4] = "kHD";
    ResolutionLevel[ResolutionLevel["k360P"] = 5] = "k360P";
    ResolutionLevel[ResolutionLevel["kFull"] = 6] = "kFull";
    ResolutionLevel[ResolutionLevel["kMedium"] = 7] = "kMedium";
})(ResolutionLevel || (ResolutionLevel = {}));
export const AspectRatioSetSpec = { $: mojo.internal.Enum() };
export var AspectRatioSet;
(function (AspectRatioSet) {
    AspectRatioSet[AspectRatioSet["MIN_VALUE"] = 0] = "MIN_VALUE";
    AspectRatioSet[AspectRatioSet["MAX_VALUE"] = 3] = "MAX_VALUE";
    AspectRatioSet[AspectRatioSet["kOthers"] = 0] = "kOthers";
    AspectRatioSet[AspectRatioSet["k4To3"] = 1] = "k4To3";
    AspectRatioSet[AspectRatioSet["k16To9"] = 2] = "k16To9";
    AspectRatioSet[AspectRatioSet["kSquare"] = 3] = "kSquare";
})(AspectRatioSet || (AspectRatioSet = {}));
export const RecordTypeSpec = { $: mojo.internal.Enum() };
export var RecordType;
(function (RecordType) {
    RecordType[RecordType["MIN_VALUE"] = 0] = "MIN_VALUE";
    RecordType[RecordType["MAX_VALUE"] = 3] = "MAX_VALUE";
    RecordType[RecordType["kNotRecording"] = 0] = "kNotRecording";
    RecordType[RecordType["kNormal"] = 1] = "kNormal";
    RecordType[RecordType["kGif"] = 2] = "kGif";
    RecordType[RecordType["kTimelapse"] = 3] = "kTimelapse";
})(RecordType || (RecordType = {}));
export const GifResultTypeSpec = { $: mojo.internal.Enum() };
export var GifResultType;
(function (GifResultType) {
    GifResultType[GifResultType["MIN_VALUE"] = 0] = "MIN_VALUE";
    GifResultType[GifResultType["MAX_VALUE"] = 3] = "MAX_VALUE";
    GifResultType[GifResultType["kNotGif"] = 0] = "kNotGif";
    GifResultType[GifResultType["kRetake"] = 1] = "kRetake";
    GifResultType[GifResultType["kShare"] = 2] = "kShare";
    GifResultType[GifResultType["kSave"] = 3] = "kSave";
})(GifResultType || (GifResultType = {}));
export const DocScanActionTypeSpec = { $: mojo.internal.Enum() };
export var DocScanActionType;
(function (DocScanActionType) {
    DocScanActionType[DocScanActionType["MIN_VALUE"] = 0] = "MIN_VALUE";
    DocScanActionType[DocScanActionType["MAX_VALUE"] = 2] = "MAX_VALUE";
    DocScanActionType[DocScanActionType["kAddPage"] = 0] = "kAddPage";
    DocScanActionType[DocScanActionType["kDeletePage"] = 1] = "kDeletePage";
    DocScanActionType[DocScanActionType["kFix"] = 2] = "kFix";
})(DocScanActionType || (DocScanActionType = {}));
export const DocScanResultTypeSpec = { $: mojo.internal.Enum() };
export var DocScanResultType;
(function (DocScanResultType) {
    DocScanResultType[DocScanResultType["MIN_VALUE"] = 0] = "MIN_VALUE";
    DocScanResultType[DocScanResultType["MAX_VALUE"] = 3] = "MAX_VALUE";
    DocScanResultType[DocScanResultType["kCancel"] = 0] = "kCancel";
    DocScanResultType[DocScanResultType["kSaveAsPdf"] = 1] = "kSaveAsPdf";
    DocScanResultType[DocScanResultType["kSaveAsPhoto"] = 2] = "kSaveAsPhoto";
    DocScanResultType[DocScanResultType["kShare"] = 3] = "kShare";
})(DocScanResultType || (DocScanResultType = {}));
export const DocScanFixTypeSpec = { $: mojo.internal.Enum() };
export var DocScanFixType;
(function (DocScanFixType) {
    DocScanFixType[DocScanFixType["MIN_VALUE"] = 1] = "MIN_VALUE";
    DocScanFixType[DocScanFixType["MAX_VALUE"] = 2] = "MAX_VALUE";
    DocScanFixType[DocScanFixType["kCorner"] = 1] = "kCorner";
    DocScanFixType[DocScanFixType["kRotation"] = 2] = "kRotation";
})(DocScanFixType || (DocScanFixType = {}));
export const LowStorageActionTypeSpec = { $: mojo.internal.Enum() };
export var LowStorageActionType;
(function (LowStorageActionType) {
    LowStorageActionType[LowStorageActionType["MIN_VALUE"] = 0] = "MIN_VALUE";
    LowStorageActionType[LowStorageActionType["MAX_VALUE"] = 4] = "MAX_VALUE";
    LowStorageActionType[LowStorageActionType["kManageStorageAutoStop"] = 0] = "kManageStorageAutoStop";
    LowStorageActionType[LowStorageActionType["kManageStorageCannotStart"] = 1] = "kManageStorageCannotStart";
    LowStorageActionType[LowStorageActionType["kShowAutoStopDialog"] = 2] = "kShowAutoStopDialog";
    LowStorageActionType[LowStorageActionType["kShowCannotStartDialog"] = 3] = "kShowCannotStartDialog";
    LowStorageActionType[LowStorageActionType["kShowWarningMessage"] = 4] = "kShowWarningMessage";
})(LowStorageActionType || (LowStorageActionType = {}));
export const BarcodeContentTypeSpec = { $: mojo.internal.Enum() };
export var BarcodeContentType;
(function (BarcodeContentType) {
    BarcodeContentType[BarcodeContentType["MIN_VALUE"] = 0] = "MIN_VALUE";
    BarcodeContentType[BarcodeContentType["MAX_VALUE"] = 2] = "MAX_VALUE";
    BarcodeContentType[BarcodeContentType["kText"] = 0] = "kText";
    BarcodeContentType[BarcodeContentType["kUrl"] = 1] = "kUrl";
    BarcodeContentType[BarcodeContentType["kWiFi"] = 2] = "kWiFi";
})(BarcodeContentType || (BarcodeContentType = {}));
export const PerfEventTypeSpec = { $: mojo.internal.Enum() };
export var PerfEventType;
(function (PerfEventType) {
    PerfEventType[PerfEventType["MIN_VALUE"] = 0] = "MIN_VALUE";
    PerfEventType[PerfEventType["MAX_VALUE"] = 16] = "MAX_VALUE";
    PerfEventType[PerfEventType["kCameraSwitching"] = 0] = "kCameraSwitching";
    PerfEventType[PerfEventType["kGifCapturePostProcessing"] = 1] = "kGifCapturePostProcessing";
    PerfEventType[PerfEventType["kLaunchingFromLaunchAppCold"] = 2] = "kLaunchingFromLaunchAppCold";
    PerfEventType[PerfEventType["kLaunchingFromLaunchAppWarm"] = 3] = "kLaunchingFromLaunchAppWarm";
    PerfEventType[PerfEventType["kLaunchingFromWindowCreation"] = 4] = "kLaunchingFromWindowCreation";
    PerfEventType[PerfEventType["kModeSwitching"] = 5] = "kModeSwitching";
    PerfEventType[PerfEventType["kPhotoCapturePostProcessingSaving"] = 6] = "kPhotoCapturePostProcessingSaving";
    PerfEventType[PerfEventType["kPhotoCaptureShutter"] = 7] = "kPhotoCaptureShutter";
    PerfEventType[PerfEventType["kPortraitModeCapturePostProcessingSaving"] = 9] = "kPortraitModeCapturePostProcessingSaving";
    PerfEventType[PerfEventType["kTimelapseCapturePostProcessingSaving"] = 10] = "kTimelapseCapturePostProcessingSaving";
    PerfEventType[PerfEventType["kVideoCapturePostProcessingSaving"] = 11] = "kVideoCapturePostProcessingSaving";
    PerfEventType[PerfEventType["kSnapshotTaking"] = 12] = "kSnapshotTaking";
    PerfEventType[PerfEventType["kDocumentCapturePostProcessing"] = 13] = "kDocumentCapturePostProcessing";
    PerfEventType[PerfEventType["kDocumentPdfSaving"] = 14] = "kDocumentPdfSaving";
    PerfEventType[PerfEventType["kOcrScanning"] = 15] = "kOcrScanning";
    PerfEventType[PerfEventType["kGifCaptureSaving"] = 16] = "kGifCaptureSaving";
})(PerfEventType || (PerfEventType = {}));
export const UserBehaviorSpec = { $: mojo.internal.Enum() };
export var UserBehavior;
(function (UserBehavior) {
    UserBehavior[UserBehavior["MIN_VALUE"] = 1] = "MIN_VALUE";
    UserBehavior[UserBehavior["MAX_VALUE"] = 64] = "MAX_VALUE";
    UserBehavior[UserBehavior["kTakeNormalPhoto"] = 1] = "kTakeNormalPhoto";
    UserBehavior[UserBehavior["kTakePortraitPhoto"] = 2] = "kTakePortraitPhoto";
    UserBehavior[UserBehavior["kScanBarcode"] = 4] = "kScanBarcode";
    UserBehavior[UserBehavior["kScanDocument"] = 8] = "kScanDocument";
    UserBehavior[UserBehavior["kRecordNormalVideo"] = 16] = "kRecordNormalVideo";
    UserBehavior[UserBehavior["kRecordGifVideo"] = 32] = "kRecordGifVideo";
    UserBehavior[UserBehavior["kRecordTimelapseVideo"] = 64] = "kRecordTimelapseVideo";
})(UserBehavior || (UserBehavior = {}));
export const OcrEventTypeSpec = { $: mojo.internal.Enum() };
export var OcrEventType;
(function (OcrEventType) {
    OcrEventType[OcrEventType["MIN_VALUE"] = 0] = "MIN_VALUE";
    OcrEventType[OcrEventType["MAX_VALUE"] = 1] = "MAX_VALUE";
    OcrEventType[OcrEventType["kCopyText"] = 0] = "kCopyText";
    OcrEventType[OcrEventType["kTextDetected"] = 1] = "kTextDetected";
})(OcrEventType || (OcrEventType = {}));
export class EventsSenderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.EventsSender', scope);
    }
}
export class EventsSenderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(EventsSenderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    sendStartSessionEvent(params) {
        this.proxy.sendMessage(0, EventsSender_SendStartSessionEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendCaptureEvent(params) {
        this.proxy.sendMessage(1, EventsSender_SendCaptureEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendAndroidIntentEvent(params) {
        this.proxy.sendMessage(2, EventsSender_SendAndroidIntentEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendOpenPTZPanelEvent(params) {
        this.proxy.sendMessage(3, EventsSender_SendOpenPTZPanelEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendDocScanActionEvent(params) {
        this.proxy.sendMessage(4, EventsSender_SendDocScanActionEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendDocScanResultEvent(params) {
        this.proxy.sendMessage(5, EventsSender_SendDocScanResultEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendOpenCameraEvent(params) {
        this.proxy.sendMessage(6, EventsSender_SendOpenCameraEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendLowStorageActionEvent(params) {
        this.proxy.sendMessage(7, EventsSender_SendLowStorageActionEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendBarcodeDetectedEvent(params) {
        this.proxy.sendMessage(8, EventsSender_SendBarcodeDetectedEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendPerfEvent(params) {
        this.proxy.sendMessage(9, EventsSender_SendPerfEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendUnsupportedProtocolEvent() {
        this.proxy.sendMessage(10, EventsSender_SendUnsupportedProtocolEvent_ParamsSpec.$, null, [], false);
    }
    updateMemoryUsageEventParams(params) {
        this.proxy.sendMessage(11, EventsSender_UpdateMemoryUsageEventParams_ParamsSpec.$, null, [
            params
        ], false);
    }
    sendOcrEvent(params) {
        this.proxy.sendMessage(12, EventsSender_SendOcrEvent_ParamsSpec.$, null, [
            params
        ], false);
    }
}
;
/**
 * An object which receives request messages for the EventsSender
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EventsSenderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(EventsSenderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, EventsSender_SendStartSessionEvent_ParamsSpec.$, null, impl.sendStartSessionEvent.bind(impl), false);
        this.helper_internal_.registerHandler(1, EventsSender_SendCaptureEvent_ParamsSpec.$, null, impl.sendCaptureEvent.bind(impl), false);
        this.helper_internal_.registerHandler(2, EventsSender_SendAndroidIntentEvent_ParamsSpec.$, null, impl.sendAndroidIntentEvent.bind(impl), false);
        this.helper_internal_.registerHandler(3, EventsSender_SendOpenPTZPanelEvent_ParamsSpec.$, null, impl.sendOpenPTZPanelEvent.bind(impl), false);
        this.helper_internal_.registerHandler(4, EventsSender_SendDocScanActionEvent_ParamsSpec.$, null, impl.sendDocScanActionEvent.bind(impl), false);
        this.helper_internal_.registerHandler(5, EventsSender_SendDocScanResultEvent_ParamsSpec.$, null, impl.sendDocScanResultEvent.bind(impl), false);
        this.helper_internal_.registerHandler(6, EventsSender_SendOpenCameraEvent_ParamsSpec.$, null, impl.sendOpenCameraEvent.bind(impl), false);
        this.helper_internal_.registerHandler(7, EventsSender_SendLowStorageActionEvent_ParamsSpec.$, null, impl.sendLowStorageActionEvent.bind(impl), false);
        this.helper_internal_.registerHandler(8, EventsSender_SendBarcodeDetectedEvent_ParamsSpec.$, null, impl.sendBarcodeDetectedEvent.bind(impl), false);
        this.helper_internal_.registerHandler(9, EventsSender_SendPerfEvent_ParamsSpec.$, null, impl.sendPerfEvent.bind(impl), false);
        this.helper_internal_.registerHandler(10, EventsSender_SendUnsupportedProtocolEvent_ParamsSpec.$, null, impl.sendUnsupportedProtocolEvent.bind(impl), false);
        this.helper_internal_.registerHandler(11, EventsSender_UpdateMemoryUsageEventParams_ParamsSpec.$, null, impl.updateMemoryUsageEventParams.bind(impl), false);
        this.helper_internal_.registerHandler(12, EventsSender_SendOcrEvent_ParamsSpec.$, null, impl.sendOcrEvent.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class EventsSender {
    static get $interfaceName() {
        return "ash.camera_app.mojom.EventsSender";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new EventsSenderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the EventsSender
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EventsSenderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(EventsSenderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.sendStartSessionEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, EventsSender_SendStartSessionEvent_ParamsSpec.$, null, this.sendStartSessionEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendCaptureEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, EventsSender_SendCaptureEvent_ParamsSpec.$, null, this.sendCaptureEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendAndroidIntentEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, EventsSender_SendAndroidIntentEvent_ParamsSpec.$, null, this.sendAndroidIntentEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendOpenPTZPanelEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, EventsSender_SendOpenPTZPanelEvent_ParamsSpec.$, null, this.sendOpenPTZPanelEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendDocScanActionEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, EventsSender_SendDocScanActionEvent_ParamsSpec.$, null, this.sendDocScanActionEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendDocScanResultEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, EventsSender_SendDocScanResultEvent_ParamsSpec.$, null, this.sendDocScanResultEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendOpenCameraEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, EventsSender_SendOpenCameraEvent_ParamsSpec.$, null, this.sendOpenCameraEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendLowStorageActionEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, EventsSender_SendLowStorageActionEvent_ParamsSpec.$, null, this.sendLowStorageActionEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendBarcodeDetectedEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, EventsSender_SendBarcodeDetectedEvent_ParamsSpec.$, null, this.sendBarcodeDetectedEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendPerfEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, EventsSender_SendPerfEvent_ParamsSpec.$, null, this.sendPerfEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.sendUnsupportedProtocolEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, EventsSender_SendUnsupportedProtocolEvent_ParamsSpec.$, null, this.sendUnsupportedProtocolEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.updateMemoryUsageEventParams =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, EventsSender_UpdateMemoryUsageEventParams_ParamsSpec.$, null, this.updateMemoryUsageEventParams.createReceiverHandler(false /* expectsResponse */), false);
        this.sendOcrEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, EventsSender_SendOcrEvent_ParamsSpec.$, null, this.sendOcrEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const StartSessionEventParamsSpec = { $: {} };
export const PhotoDetailsSpec = { $: {} };
export const NormalVideoDetailsSpec = { $: {} };
export const GifVideoDetailsSpec = { $: {} };
export const TimelapseVideoDetailsSpec = { $: {} };
export const VideoDetailsSpec = { $: {} };
export const CaptureEventParamsSpec = { $: {} };
export const AndroidIntentEventParamsSpec = { $: {} };
export const OpenPTZPanelEventParamsSpec = { $: {} };
export const DocScanActionEventParamsSpec = { $: {} };
export const DocScanResultEventParamsSpec = { $: {} };
export const MipiCameraModuleSpec = { $: {} };
export const UsbCameraModuleSpec = { $: {} };
export const OpenCameraEventParamsSpec = { $: {} };
export const LowStorageActionEventParamsSpec = { $: {} };
export const BarcodeDetectedEventParamsSpec = { $: {} };
export const PerfEventParamsSpec = { $: {} };
export const MemoryUsageEventParamsSpec = { $: {} };
export const OcrEventParamsSpec = { $: {} };
export const EventsSender_SendStartSessionEvent_ParamsSpec = { $: {} };
export const EventsSender_SendCaptureEvent_ParamsSpec = { $: {} };
export const EventsSender_SendAndroidIntentEvent_ParamsSpec = { $: {} };
export const EventsSender_SendOpenPTZPanelEvent_ParamsSpec = { $: {} };
export const EventsSender_SendDocScanActionEvent_ParamsSpec = { $: {} };
export const EventsSender_SendDocScanResultEvent_ParamsSpec = { $: {} };
export const EventsSender_SendOpenCameraEvent_ParamsSpec = { $: {} };
export const EventsSender_SendLowStorageActionEvent_ParamsSpec = { $: {} };
export const EventsSender_SendBarcodeDetectedEvent_ParamsSpec = { $: {} };
export const EventsSender_SendPerfEvent_ParamsSpec = { $: {} };
export const EventsSender_SendUnsupportedProtocolEvent_ParamsSpec = { $: {} };
export const EventsSender_UpdateMemoryUsageEventParams_ParamsSpec = { $: {} };
export const EventsSender_SendOcrEvent_ParamsSpec = { $: {} };
export const RecordTypeDetailsSpec = { $: {} };
export const CaptureDetailsSpec = { $: {} };
export const CameraModuleSpec = { $: {} };
mojo.internal.Struct(StartSessionEventParamsSpec.$, 'StartSessionEventParams', [
    mojo.internal.StructField('launchType', 0, 0, LaunchTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PhotoDetailsSpec.$, 'PhotoDetails', [
    mojo.internal.StructField('isVideoSnapshot', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NormalVideoDetailsSpec.$, 'NormalVideoDetails', [], [[0, 8],]);
mojo.internal.Struct(GifVideoDetailsSpec.$, 'GifVideoDetails', [
    mojo.internal.StructField('gifResultType', 0, 0, GifResultTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TimelapseVideoDetailsSpec.$, 'TimelapseVideoDetails', [
    mojo.internal.StructField('timelapseSpeed', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VideoDetailsSpec.$, 'VideoDetails', [
    mojo.internal.StructField('isMuted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fps', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('everPaused', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duration', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('recordTypeDetails', 16, 0, RecordTypeDetailsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(CaptureEventParamsSpec.$, 'CaptureEventParams', [
    mojo.internal.StructField('mode', 0, 0, ModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('facing', 4, 0, FacingSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isMirrored', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('gridType', 12, 0, GridTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timerType', 16, 0, TimerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shutterType', 20, 0, ShutterTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('androidIntentResultType', 24, 0, AndroidIntentResultTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isWindowMaximized', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isWindowPortrait', 8, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutionWidth', 28, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutionHeight', 32, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutionLevel', 36, 0, ResolutionLevelSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('aspectRatioSet', 40, 0, AspectRatioSetSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('captureDetails', 48, 0, CaptureDetailsSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('zoomRatio', 64, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(AndroidIntentEventParamsSpec.$, 'AndroidIntentEventParams', [
    mojo.internal.StructField('mode', 0, 0, ModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shouldHandleResult', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shouldDownscale', 4, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSecure', 4, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OpenPTZPanelEventParamsSpec.$, 'OpenPTZPanelEventParams', [
    mojo.internal.StructField('supportPan', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportTilt', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportZoom', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DocScanActionEventParamsSpec.$, 'DocScanActionEventParams', [
    mojo.internal.StructField('actionType', 0, 0, DocScanActionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DocScanResultEventParamsSpec.$, 'DocScanResultEventParams', [
    mojo.internal.StructField('resultType', 0, 0, DocScanResultTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fixTypesMask', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fixCount', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageCount', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MipiCameraModuleSpec.$, 'MipiCameraModule', [], [[0, 8],]);
mojo.internal.Struct(UsbCameraModuleSpec.$, 'UsbCameraModule', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OpenCameraEventParamsSpec.$, 'OpenCameraEventParams', [
    mojo.internal.StructField('cameraModule', 0, 0, CameraModuleSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LowStorageActionEventParamsSpec.$, 'LowStorageActionEventParams', [
    mojo.internal.StructField('actionType', 0, 0, LowStorageActionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BarcodeDetectedEventParamsSpec.$, 'BarcodeDetectedEventParams', [
    mojo.internal.StructField('contentType', 0, 0, BarcodeContentTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('wifiSecurityType', 4, 0, ash_cameraApp_mojom_WifiSecurityTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PerfEventParamsSpec.$, 'PerfEventParams', [
    mojo.internal.StructField('eventType', 0, 0, PerfEventTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duration', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('facing', 8, 0, FacingSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutionWidth', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutionHeight', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageCount', 20, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pressure', 24, 0, PressureSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(MemoryUsageEventParamsSpec.$, 'MemoryUsageEventParams', [
    mojo.internal.StructField('behaviorsMask', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('memoryUsage', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OcrEventParamsSpec.$, 'OcrEventParams', [
    mojo.internal.StructField('eventType', 0, 0, OcrEventTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isPrimaryLanguage', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lineCount', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('wordCount', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(EventsSender_SendStartSessionEvent_ParamsSpec.$, 'EventsSender_SendStartSessionEvent_Params', [
    mojo.internal.StructField('params', 0, 0, StartSessionEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendCaptureEvent_ParamsSpec.$, 'EventsSender_SendCaptureEvent_Params', [
    mojo.internal.StructField('params', 0, 0, CaptureEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendAndroidIntentEvent_ParamsSpec.$, 'EventsSender_SendAndroidIntentEvent_Params', [
    mojo.internal.StructField('params', 0, 0, AndroidIntentEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendOpenPTZPanelEvent_ParamsSpec.$, 'EventsSender_SendOpenPTZPanelEvent_Params', [
    mojo.internal.StructField('params', 0, 0, OpenPTZPanelEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendDocScanActionEvent_ParamsSpec.$, 'EventsSender_SendDocScanActionEvent_Params', [
    mojo.internal.StructField('params', 0, 0, DocScanActionEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendDocScanResultEvent_ParamsSpec.$, 'EventsSender_SendDocScanResultEvent_Params', [
    mojo.internal.StructField('params', 0, 0, DocScanResultEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendOpenCameraEvent_ParamsSpec.$, 'EventsSender_SendOpenCameraEvent_Params', [
    mojo.internal.StructField('params', 0, 0, OpenCameraEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendLowStorageActionEvent_ParamsSpec.$, 'EventsSender_SendLowStorageActionEvent_Params', [
    mojo.internal.StructField('params', 0, 0, LowStorageActionEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendBarcodeDetectedEvent_ParamsSpec.$, 'EventsSender_SendBarcodeDetectedEvent_Params', [
    mojo.internal.StructField('params', 0, 0, BarcodeDetectedEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendPerfEvent_ParamsSpec.$, 'EventsSender_SendPerfEvent_Params', [
    mojo.internal.StructField('params', 0, 0, PerfEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendUnsupportedProtocolEvent_ParamsSpec.$, 'EventsSender_SendUnsupportedProtocolEvent_Params', [], [[0, 8],]);
mojo.internal.Struct(EventsSender_UpdateMemoryUsageEventParams_ParamsSpec.$, 'EventsSender_UpdateMemoryUsageEventParams_Params', [
    mojo.internal.StructField('params', 0, 0, MemoryUsageEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EventsSender_SendOcrEvent_ParamsSpec.$, 'EventsSender_SendOcrEvent_Params', [
    mojo.internal.StructField('params', 0, 0, OcrEventParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(RecordTypeDetailsSpec.$, 'RecordTypeDetails', {
    'normalVideoDetails': {
        'ordinal': 0,
        'type': NormalVideoDetailsSpec.$,
    },
    'gifVideoDetails': {
        'ordinal': 1,
        'type': GifVideoDetailsSpec.$,
    },
    'timelapseVideoDetails': {
        'ordinal': 2,
        'type': TimelapseVideoDetailsSpec.$,
    },
});
export var RecordTypeDetailsFieldTags;
(function (RecordTypeDetailsFieldTags) {
    RecordTypeDetailsFieldTags[RecordTypeDetailsFieldTags["NORMAL_VIDEO_DETAILS"] = 0] = "NORMAL_VIDEO_DETAILS";
    RecordTypeDetailsFieldTags[RecordTypeDetailsFieldTags["GIF_VIDEO_DETAILS"] = 1] = "GIF_VIDEO_DETAILS";
    RecordTypeDetailsFieldTags[RecordTypeDetailsFieldTags["TIMELAPSE_VIDEO_DETAILS"] = 2] = "TIMELAPSE_VIDEO_DETAILS";
})(RecordTypeDetailsFieldTags || (RecordTypeDetailsFieldTags = {}));
export function whichRecordTypeDetails(u) {
    if (u.normalVideoDetails !== null && u.normalVideoDetails !== undefined) {
        return RecordTypeDetailsFieldTags.NORMAL_VIDEO_DETAILS;
    }
    if (u.gifVideoDetails !== null && u.gifVideoDetails !== undefined) {
        return RecordTypeDetailsFieldTags.GIF_VIDEO_DETAILS;
    }
    if (u.timelapseVideoDetails !== null && u.timelapseVideoDetails !== undefined) {
        return RecordTypeDetailsFieldTags.TIMELAPSE_VIDEO_DETAILS;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(CaptureDetailsSpec.$, 'CaptureDetails', {
    'photoDetails': {
        'ordinal': 0,
        'type': PhotoDetailsSpec.$,
    },
    'videoDetails': {
        'ordinal': 1,
        'type': VideoDetailsSpec.$,
    },
});
export var CaptureDetailsFieldTags;
(function (CaptureDetailsFieldTags) {
    CaptureDetailsFieldTags[CaptureDetailsFieldTags["PHOTO_DETAILS"] = 0] = "PHOTO_DETAILS";
    CaptureDetailsFieldTags[CaptureDetailsFieldTags["VIDEO_DETAILS"] = 1] = "VIDEO_DETAILS";
})(CaptureDetailsFieldTags || (CaptureDetailsFieldTags = {}));
export function whichCaptureDetails(u) {
    if (u.photoDetails !== null && u.photoDetails !== undefined) {
        return CaptureDetailsFieldTags.PHOTO_DETAILS;
    }
    if (u.videoDetails !== null && u.videoDetails !== undefined) {
        return CaptureDetailsFieldTags.VIDEO_DETAILS;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(CameraModuleSpec.$, 'CameraModule', {
    'mipiCamera': {
        'ordinal': 0,
        'type': MipiCameraModuleSpec.$,
    },
    'usbCamera': {
        'ordinal': 1,
        'type': UsbCameraModuleSpec.$,
    },
});
export var CameraModuleFieldTags;
(function (CameraModuleFieldTags) {
    CameraModuleFieldTags[CameraModuleFieldTags["MIPI_CAMERA"] = 0] = "MIPI_CAMERA";
    CameraModuleFieldTags[CameraModuleFieldTags["USB_CAMERA"] = 1] = "USB_CAMERA";
})(CameraModuleFieldTags || (CameraModuleFieldTags = {}));
export function whichCameraModule(u) {
    if (u.mipiCamera !== null && u.mipiCamera !== undefined) {
        return CameraModuleFieldTags.MIPI_CAMERA;
    }
    if (u.usbCamera !== null && u.usbCamera !== undefined) {
        return CameraModuleFieldTags.USB_CAMERA;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
