// ash/webui/camera_app_ui/pdf_builder.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BigBufferSpec as mojoBase_mojom_BigBufferSpec } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
export class PdfBuilderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.camera_app.mojom.PdfBuilder', scope);
    }
}
export class PdfBuilderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PdfBuilderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addPage(jpeg, pageIndex) {
        this.proxy.sendMessage(0, PdfBuilder_AddPage_ParamsSpec.$, null, [
            jpeg,
            pageIndex
        ], false);
    }
    addPageInline(jpeg, pageIndex) {
        this.proxy.sendMessage(1, PdfBuilder_AddPageInline_ParamsSpec.$, null, [
            jpeg,
            pageIndex
        ], false);
    }
    deletePage(pageIndex) {
        this.proxy.sendMessage(2, PdfBuilder_DeletePage_ParamsSpec.$, null, [
            pageIndex
        ], false);
    }
    save() {
        return this.proxy.sendMessage(3, PdfBuilder_Save_ParamsSpec.$, PdfBuilder_Save_ResponseParamsSpec.$, [], false);
    }
    saveInline() {
        return this.proxy.sendMessage(4, PdfBuilder_SaveInline_ParamsSpec.$, PdfBuilder_SaveInline_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the PdfBuilder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PdfBuilderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PdfBuilderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PdfBuilder_AddPage_ParamsSpec.$, null, impl.addPage.bind(impl), false);
        this.helper_internal_.registerHandler(1, PdfBuilder_AddPageInline_ParamsSpec.$, null, impl.addPageInline.bind(impl), false);
        this.helper_internal_.registerHandler(2, PdfBuilder_DeletePage_ParamsSpec.$, null, impl.deletePage.bind(impl), false);
        this.helper_internal_.registerHandler(3, PdfBuilder_Save_ParamsSpec.$, PdfBuilder_Save_ResponseParamsSpec.$, impl.save.bind(impl), false);
        this.helper_internal_.registerHandler(4, PdfBuilder_SaveInline_ParamsSpec.$, PdfBuilder_SaveInline_ResponseParamsSpec.$, impl.saveInline.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PdfBuilder {
    static get $interfaceName() {
        return "ash.camera_app.mojom.PdfBuilder";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PdfBuilderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PdfBuilder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PdfBuilderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PdfBuilderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PdfBuilder_AddPage_ParamsSpec.$, null, this.addPage.createReceiverHandler(false /* expectsResponse */), false);
        this.addPageInline =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PdfBuilder_AddPageInline_ParamsSpec.$, null, this.addPageInline.createReceiverHandler(false /* expectsResponse */), false);
        this.deletePage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PdfBuilder_DeletePage_ParamsSpec.$, null, this.deletePage.createReceiverHandler(false /* expectsResponse */), false);
        this.save =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PdfBuilder_Save_ParamsSpec.$, PdfBuilder_Save_ResponseParamsSpec.$, this.save.createReceiverHandler(true /* expectsResponse */), false);
        this.saveInline =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PdfBuilder_SaveInline_ParamsSpec.$, PdfBuilder_SaveInline_ResponseParamsSpec.$, this.saveInline.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PdfBuilder_AddPage_ParamsSpec = { $: {} };
export const PdfBuilder_AddPageInline_ParamsSpec = { $: {} };
export const PdfBuilder_DeletePage_ParamsSpec = { $: {} };
export const PdfBuilder_Save_ParamsSpec = { $: {} };
export const PdfBuilder_Save_ResponseParamsSpec = { $: {} };
export const PdfBuilder_SaveInline_ParamsSpec = { $: {} };
export const PdfBuilder_SaveInline_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(PdfBuilder_AddPage_ParamsSpec.$, 'PdfBuilder_AddPage_Params', [
    mojo.internal.StructField('jpeg', 0, 0, mojoBase_mojom_BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageIndex', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PdfBuilder_AddPageInline_ParamsSpec.$, 'PdfBuilder_AddPageInline_Params', [
    mojo.internal.StructField('jpeg', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageIndex', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PdfBuilder_DeletePage_ParamsSpec.$, 'PdfBuilder_DeletePage_Params', [
    mojo.internal.StructField('pageIndex', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PdfBuilder_Save_ParamsSpec.$, 'PdfBuilder_Save_Params', [], [[0, 8],]);
mojo.internal.Struct(PdfBuilder_Save_ResponseParamsSpec.$, 'PdfBuilder_Save_ResponseParams', [
    mojo.internal.StructField('pdf', 0, 0, mojoBase_mojom_BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PdfBuilder_SaveInline_ParamsSpec.$, 'PdfBuilder_SaveInline_Params', [], [[0, 8],]);
mojo.internal.Struct(PdfBuilder_SaveInline_ResponseParamsSpec.$, 'PdfBuilder_SaveInline_ResponseParams', [
    mojo.internal.StructField('pdf', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
