// media/capture/mojom/image_capture.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const BackgroundBlurModeSpec = { $: mojo.internal.Enum() };
export var BackgroundBlurMode;
(function (BackgroundBlurMode) {
    BackgroundBlurMode[BackgroundBlurMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    BackgroundBlurMode[BackgroundBlurMode["MAX_VALUE"] = 1] = "MAX_VALUE";
    BackgroundBlurMode[BackgroundBlurMode["OFF"] = 0] = "OFF";
    BackgroundBlurMode[BackgroundBlurMode["BLUR"] = 1] = "BLUR";
})(BackgroundBlurMode || (BackgroundBlurMode = {}));
export const EyeGazeCorrectionModeSpec = { $: mojo.internal.Enum() };
export var EyeGazeCorrectionMode;
(function (EyeGazeCorrectionMode) {
    EyeGazeCorrectionMode[EyeGazeCorrectionMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    EyeGazeCorrectionMode[EyeGazeCorrectionMode["MAX_VALUE"] = 2] = "MAX_VALUE";
    EyeGazeCorrectionMode[EyeGazeCorrectionMode["OFF"] = 0] = "OFF";
    EyeGazeCorrectionMode[EyeGazeCorrectionMode["ON"] = 1] = "ON";
    EyeGazeCorrectionMode[EyeGazeCorrectionMode["STARE"] = 2] = "STARE";
})(EyeGazeCorrectionMode || (EyeGazeCorrectionMode = {}));
export const MeteringModeSpec = { $: mojo.internal.Enum() };
export var MeteringMode;
(function (MeteringMode) {
    MeteringMode[MeteringMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    MeteringMode[MeteringMode["MAX_VALUE"] = 3] = "MAX_VALUE";
    MeteringMode[MeteringMode["NONE"] = 0] = "NONE";
    MeteringMode[MeteringMode["MANUAL"] = 1] = "MANUAL";
    MeteringMode[MeteringMode["SINGLE_SHOT"] = 2] = "SINGLE_SHOT";
    MeteringMode[MeteringMode["CONTINUOUS"] = 3] = "CONTINUOUS";
})(MeteringMode || (MeteringMode = {}));
export const RedEyeReductionSpec = { $: mojo.internal.Enum() };
export var RedEyeReduction;
(function (RedEyeReduction) {
    RedEyeReduction[RedEyeReduction["MIN_VALUE"] = 0] = "MIN_VALUE";
    RedEyeReduction[RedEyeReduction["MAX_VALUE"] = 2] = "MAX_VALUE";
    RedEyeReduction[RedEyeReduction["NEVER"] = 0] = "NEVER";
    RedEyeReduction[RedEyeReduction["ALWAYS"] = 1] = "ALWAYS";
    RedEyeReduction[RedEyeReduction["CONTROLLABLE"] = 2] = "CONTROLLABLE";
})(RedEyeReduction || (RedEyeReduction = {}));
export const FillLightModeSpec = { $: mojo.internal.Enum() };
export var FillLightMode;
(function (FillLightMode) {
    FillLightMode[FillLightMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    FillLightMode[FillLightMode["MAX_VALUE"] = 2] = "MAX_VALUE";
    FillLightMode[FillLightMode["OFF"] = 0] = "OFF";
    FillLightMode[FillLightMode["AUTO"] = 1] = "AUTO";
    FillLightMode[FillLightMode["FLASH"] = 2] = "FLASH";
})(FillLightMode || (FillLightMode = {}));
export class ImageCapturePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'media.mojom.ImageCapture', scope);
    }
}
export class ImageCaptureRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ImageCapturePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getPhotoState(sourceId) {
        return this.proxy.sendMessage(0, ImageCapture_GetPhotoState_ParamsSpec.$, ImageCapture_GetPhotoState_ResponseParamsSpec.$, [
            sourceId
        ], false);
    }
    setPhotoOptions(sourceId, settings) {
        return this.proxy.sendMessage(1, ImageCapture_SetPhotoOptions_ParamsSpec.$, ImageCapture_SetPhotoOptions_ResponseParamsSpec.$, [
            sourceId,
            settings
        ], false);
    }
    takePhoto(sourceId) {
        return this.proxy.sendMessage(2, ImageCapture_TakePhoto_ParamsSpec.$, ImageCapture_TakePhoto_ResponseParamsSpec.$, [
            sourceId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ImageCapture
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ImageCaptureReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ImageCaptureRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ImageCapture_GetPhotoState_ParamsSpec.$, ImageCapture_GetPhotoState_ResponseParamsSpec.$, impl.getPhotoState.bind(impl), false);
        this.helper_internal_.registerHandler(1, ImageCapture_SetPhotoOptions_ParamsSpec.$, ImageCapture_SetPhotoOptions_ResponseParamsSpec.$, impl.setPhotoOptions.bind(impl), false);
        this.helper_internal_.registerHandler(2, ImageCapture_TakePhoto_ParamsSpec.$, ImageCapture_TakePhoto_ResponseParamsSpec.$, impl.takePhoto.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ImageCapture {
    static get $interfaceName() {
        return "media.mojom.ImageCapture";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ImageCaptureRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ImageCapture
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ImageCaptureCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ImageCaptureRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getPhotoState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ImageCapture_GetPhotoState_ParamsSpec.$, ImageCapture_GetPhotoState_ResponseParamsSpec.$, this.getPhotoState.createReceiverHandler(true /* expectsResponse */), false);
        this.setPhotoOptions =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ImageCapture_SetPhotoOptions_ParamsSpec.$, ImageCapture_SetPhotoOptions_ResponseParamsSpec.$, this.setPhotoOptions.createReceiverHandler(true /* expectsResponse */), false);
        this.takePhoto =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ImageCapture_TakePhoto_ParamsSpec.$, ImageCapture_TakePhoto_ResponseParamsSpec.$, this.takePhoto.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const RangeSpec = { $: {} };
export const PhotoStateSpec = { $: {} };
export const Point2DSpec = { $: {} };
export const PhotoSettingsSpec = { $: {} };
export const BlobSpec = { $: {} };
export const ImageCapture_GetPhotoState_ParamsSpec = { $: {} };
export const ImageCapture_GetPhotoState_ResponseParamsSpec = { $: {} };
export const ImageCapture_SetPhotoOptions_ParamsSpec = { $: {} };
export const ImageCapture_SetPhotoOptions_ResponseParamsSpec = { $: {} };
export const ImageCapture_TakePhoto_ParamsSpec = { $: {} };
export const ImageCapture_TakePhoto_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(RangeSpec.$, 'Range', [
    mojo.internal.StructField('max', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('min', 8, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('current', 16, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('step', 24, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PhotoStateSpec.$, 'PhotoState', [
    mojo.internal.StructField('supportedWhiteBalanceModes', 0, 0, mojo.internal.Array(MeteringModeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('currentWhiteBalanceMode', 8, 0, MeteringModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedExposureModes', 16, 0, mojo.internal.Array(MeteringModeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('currentExposureMode', 12, 0, MeteringModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedFocusModes', 24, 0, mojo.internal.Array(MeteringModeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('currentFocusMode', 32, 0, MeteringModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pointsOfInterest', 40, 0, mojo.internal.Array(Point2DSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('exposureCompensation', 48, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('exposureTime', 56, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorTemperature', 64, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('iso', 72, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('brightness', 80, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contrast', 88, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('saturation', 96, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sharpness', 104, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('focusDistance', 112, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pan', 120, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tilt', 128, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('zoom', 136, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportsTorch', 36, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('torch', 36, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('redEyeReduction', 144, 0, RedEyeReductionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 152, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 160, 0, RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fillLightMode', 168, 0, mojo.internal.Array(FillLightModeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedBackgroundBlurModes', 176, 0, mojo.internal.Array(BackgroundBlurModeSpec.$, false), null, true /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('backgroundBlurMode', 148, 0, BackgroundBlurModeSpec.$, 0, false /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('supportedFaceFramingModes', 184, 0, mojo.internal.Array(MeteringModeSpec.$, false), null, true /* nullable */, 2, undefined, undefined),
    mojo.internal.StructField('currentFaceFramingMode', 192, 0, MeteringModeSpec.$, 0, false /* nullable */, 2, undefined, undefined),
    mojo.internal.StructField('supportedEyeGazeCorrectionModes', 200, 0, mojo.internal.Array(EyeGazeCorrectionModeSpec.$, false), null, true /* nullable */, 3, undefined, undefined),
    mojo.internal.StructField('currentEyeGazeCorrectionMode', 196, 0, EyeGazeCorrectionModeSpec.$, 0, false /* nullable */, 3, undefined, undefined),
    mojo.internal.StructField('supportedBackgroundSegmentationMaskStates', 208, 0, mojo.internal.Array(mojo.internal.Bool, false), null, true /* nullable */, 4, undefined, undefined),
    mojo.internal.StructField('currentBackgroundSegmentationMaskState', 36, 2, mojo.internal.Bool, false, false /* nullable */, 4, undefined, undefined),
], [[0, 184], [1, 192], [2, 208], [3, 216], [4, 224],]);
mojo.internal.Struct(Point2DSpec.$, 'Point2D', [
    mojo.internal.StructField('x', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('y', 8, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PhotoSettingsSpec.$, 'PhotoSettings', [
    mojo.internal.StructField('hasWhiteBalanceMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('whiteBalanceMode', 4, 0, MeteringModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasExposureMode', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('exposureMode', 8, 0, MeteringModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasFocusMode', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('focusMode', 12, 0, MeteringModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pointsOfInterest', 16, 0, mojo.internal.Array(Point2DSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasExposureCompensation', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('exposureCompensation', 24, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasExposureTime', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('exposureTime', 32, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasColorTemperature', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorTemperature', 40, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasIso', 0, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('iso', 48, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasBrightness', 0, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('brightness', 56, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasContrast', 1, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contrast', 64, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasSaturation', 1, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('saturation', 72, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasSharpness', 1, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sharpness', 80, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasFocusDistance', 1, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('focusDistance', 88, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasPan', 1, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pan', 96, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasTilt', 1, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tilt', 104, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasZoom', 1, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('zoom', 112, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasTorch', 1, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('torch', 2, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasFillLightMode', 2, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fillLightMode', 120, 0, FillLightModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasWidth', 2, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 128, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasHeight', 2, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 136, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasRedEyeReduction', 2, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('redEyeReduction', 2, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasBackgroundBlurMode', 2, 6, mojo.internal.Bool, false, false /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('backgroundBlurMode', 124, 0, BackgroundBlurModeSpec.$, 0, false /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('hasFaceFramingMode', 2, 7, mojo.internal.Bool, false, false /* nullable */, 2, undefined, undefined),
    mojo.internal.StructField('faceFramingMode', 144, 0, MeteringModeSpec.$, 0, false /* nullable */, 2, undefined, undefined),
    mojo.internal.StructField('eye_gaze_correction_mode_$flag', 3, 0, mojo.internal.Bool, false, false /* nullable */, 3, {
        isPrimary: true,
        linkedValueFieldName: "eye_gaze_correction_mode_$value",
        originalFieldName: "eyeGazeCorrectionMode",
    }, undefined),
    mojo.internal.StructField('eye_gaze_correction_mode_$value', 148, 0, EyeGazeCorrectionModeSpec.$, 0, false /* nullable */, 3, {
        isPrimary: false,
        originalFieldName: "eyeGazeCorrectionMode",
    }, undefined),
    mojo.internal.StructField('background_segmentation_mask_state_$flag', 3, 1, mojo.internal.Bool, false, false /* nullable */, 4, {
        isPrimary: true,
        linkedValueFieldName: "background_segmentation_mask_state_$value",
        originalFieldName: "backgroundSegmentationMaskState",
    }, undefined),
    mojo.internal.StructField('background_segmentation_mask_state_$value', 3, 2, mojo.internal.Bool, false, false /* nullable */, 4, {
        isPrimary: false,
        originalFieldName: "backgroundSegmentationMaskState",
    }, undefined),
], [[0, 152], [1, 152], [2, 160], [3, 160], [4, 160],]);
mojo.internal.Struct(BlobSpec.$, 'Blob', [
    mojo.internal.StructField('mimeType', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ImageCapture_GetPhotoState_ParamsSpec.$, 'ImageCapture_GetPhotoState_Params', [
    mojo.internal.StructField('sourceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ImageCapture_GetPhotoState_ResponseParamsSpec.$, 'ImageCapture_GetPhotoState_ResponseParams', [
    mojo.internal.StructField('state', 0, 0, PhotoStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ImageCapture_SetPhotoOptions_ParamsSpec.$, 'ImageCapture_SetPhotoOptions_Params', [
    mojo.internal.StructField('sourceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, PhotoSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ImageCapture_SetPhotoOptions_ResponseParamsSpec.$, 'ImageCapture_SetPhotoOptions_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ImageCapture_TakePhoto_ParamsSpec.$, 'ImageCapture_TakePhoto_Params', [
    mojo.internal.StructField('sourceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ImageCapture_TakePhoto_ResponseParamsSpec.$, 'ImageCapture_TakePhoto_ResponseParams', [
    mojo.internal.StructField('blob', 0, 0, BlobSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
