// media/capture/video/chromeos/mojom/camera3.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Camera3StreamEffectSpec as cros_mojom_Camera3StreamEffectSpec } from './camera_features.mojom-webui.js';
import { CameraMetadataSpec as cros_mojom_CameraMetadataSpec } from './camera_metadata.mojom-webui.js';
export const GRALLOC_USAGE_SW_READ_NEVER = 0x00000000;
export const GRALLOC_USAGE_SW_READ_OFTEN = 0x00000003;
export const GRALLOC_USAGE_SW_WRITE_NEVER = 0x00000000;
export const GRALLOC_USAGE_SW_WRITE_OFTEN = 0x00000030;
export const GRALLOC_USAGE_HW_COMPOSER = 0x00000800;
export const GRALLOC_USAGE_HW_VIDEO_ENCODER = 0x00010000;
export const GRALLOC_USAGE_HW_CAMERA_WRITE = 0x00020000;
export const GRALLOC_USAGE_HW_CAMERA_READ = 0x00040000;
export const GRALLOC_USAGE_FORCE_I420 = 0x10000000;
export const GRALLOC_USAGE_STILL_CAPTURE = 0x20000000;
export const NO_BUFFER_BUFFER_ID = BigInt('18446744073709551615');
export const HalPixelFormatSpec = { $: mojo.internal.Enum() };
export var HalPixelFormat;
(function (HalPixelFormat) {
    HalPixelFormat[HalPixelFormat["MIN_VALUE"] = 1] = "MIN_VALUE";
    HalPixelFormat[HalPixelFormat["MAX_VALUE"] = 842094169] = "MAX_VALUE";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_RGBA_8888"] = 1] = "HAL_PIXEL_FORMAT_RGBA_8888";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_RGBX_8888"] = 2] = "HAL_PIXEL_FORMAT_RGBX_8888";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_BGRA_8888"] = 5] = "HAL_PIXEL_FORMAT_BGRA_8888";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_YCrCb_420_SP"] = 17] = "HAL_PIXEL_FORMAT_YCrCb_420_SP";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_YCbCr_422_I"] = 20] = "HAL_PIXEL_FORMAT_YCbCr_422_I";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_BLOB"] = 33] = "HAL_PIXEL_FORMAT_BLOB";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED"] = 34] = "HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_YCbCr_420_888"] = 35] = "HAL_PIXEL_FORMAT_YCbCr_420_888";
    HalPixelFormat[HalPixelFormat["HAL_PIXEL_FORMAT_YV12"] = 842094169] = "HAL_PIXEL_FORMAT_YV12";
})(HalPixelFormat || (HalPixelFormat = {}));
export const Camera3StreamTypeSpec = { $: mojo.internal.Enum() };
export var Camera3StreamType;
(function (Camera3StreamType) {
    Camera3StreamType[Camera3StreamType["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3StreamType[Camera3StreamType["MAX_VALUE"] = 2] = "MAX_VALUE";
    Camera3StreamType[Camera3StreamType["CAMERA3_STREAM_OUTPUT"] = 0] = "CAMERA3_STREAM_OUTPUT";
    Camera3StreamType[Camera3StreamType["CAMERA3_STREAM_INPUT"] = 1] = "CAMERA3_STREAM_INPUT";
    Camera3StreamType[Camera3StreamType["CAMERA3_STREAM_BIDIRECTIONAL"] = 2] = "CAMERA3_STREAM_BIDIRECTIONAL";
})(Camera3StreamType || (Camera3StreamType = {}));
export const Camera3StreamRotationSpec = { $: mojo.internal.Enum() };
export var Camera3StreamRotation;
(function (Camera3StreamRotation) {
    Camera3StreamRotation[Camera3StreamRotation["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3StreamRotation[Camera3StreamRotation["MAX_VALUE"] = 3] = "MAX_VALUE";
    Camera3StreamRotation[Camera3StreamRotation["CAMERA3_STREAM_ROTATION_0"] = 0] = "CAMERA3_STREAM_ROTATION_0";
    Camera3StreamRotation[Camera3StreamRotation["CAMERA3_STREAM_ROTATION_90"] = 1] = "CAMERA3_STREAM_ROTATION_90";
    Camera3StreamRotation[Camera3StreamRotation["CAMERA3_STREAM_ROTATION_180"] = 2] = "CAMERA3_STREAM_ROTATION_180";
    Camera3StreamRotation[Camera3StreamRotation["CAMERA3_STREAM_ROTATION_270"] = 3] = "CAMERA3_STREAM_ROTATION_270";
})(Camera3StreamRotation || (Camera3StreamRotation = {}));
export const Camera3StreamConfigurationModeSpec = { $: mojo.internal.Enum() };
export var Camera3StreamConfigurationMode;
(function (Camera3StreamConfigurationMode) {
    Camera3StreamConfigurationMode[Camera3StreamConfigurationMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3StreamConfigurationMode[Camera3StreamConfigurationMode["MAX_VALUE"] = 1] = "MAX_VALUE";
    Camera3StreamConfigurationMode[Camera3StreamConfigurationMode["CAMERA3_STREAM_CONFIGURATION_NORMAL_MODE"] = 0] = "CAMERA3_STREAM_CONFIGURATION_NORMAL_MODE";
    Camera3StreamConfigurationMode[Camera3StreamConfigurationMode["CAMERA3_STREAM_CONFIGURATION_CONSTRAINED_HIGH_SPEED_MODE"] = 1] = "CAMERA3_STREAM_CONFIGURATION_CONSTRAINED_HIGH_SPEED_MODE";
})(Camera3StreamConfigurationMode || (Camera3StreamConfigurationMode = {}));
export const Camera3BufferStatusSpec = { $: mojo.internal.Enum() };
export var Camera3BufferStatus;
(function (Camera3BufferStatus) {
    Camera3BufferStatus[Camera3BufferStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3BufferStatus[Camera3BufferStatus["MAX_VALUE"] = 1] = "MAX_VALUE";
    Camera3BufferStatus[Camera3BufferStatus["CAMERA3_BUFFER_STATUS_OK"] = 0] = "CAMERA3_BUFFER_STATUS_OK";
    Camera3BufferStatus[Camera3BufferStatus["CAMERA3_BUFFER_STATUS_ERROR"] = 1] = "CAMERA3_BUFFER_STATUS_ERROR";
})(Camera3BufferStatus || (Camera3BufferStatus = {}));
export const Camera3MsgTypeSpec = { $: mojo.internal.Enum() };
export var Camera3MsgType;
(function (Camera3MsgType) {
    Camera3MsgType[Camera3MsgType["MIN_VALUE"] = 1] = "MIN_VALUE";
    Camera3MsgType[Camera3MsgType["MAX_VALUE"] = 2] = "MAX_VALUE";
    Camera3MsgType[Camera3MsgType["CAMERA3_MSG_ERROR"] = 1] = "CAMERA3_MSG_ERROR";
    Camera3MsgType[Camera3MsgType["CAMERA3_MSG_SHUTTER"] = 2] = "CAMERA3_MSG_SHUTTER";
})(Camera3MsgType || (Camera3MsgType = {}));
export const Camera3ErrorMsgCodeSpec = { $: mojo.internal.Enum() };
export var Camera3ErrorMsgCode;
(function (Camera3ErrorMsgCode) {
    Camera3ErrorMsgCode[Camera3ErrorMsgCode["MIN_VALUE"] = 1] = "MIN_VALUE";
    Camera3ErrorMsgCode[Camera3ErrorMsgCode["MAX_VALUE"] = 4] = "MAX_VALUE";
    Camera3ErrorMsgCode[Camera3ErrorMsgCode["CAMERA3_MSG_ERROR_DEVICE"] = 1] = "CAMERA3_MSG_ERROR_DEVICE";
    Camera3ErrorMsgCode[Camera3ErrorMsgCode["CAMERA3_MSG_ERROR_REQUEST"] = 2] = "CAMERA3_MSG_ERROR_REQUEST";
    Camera3ErrorMsgCode[Camera3ErrorMsgCode["CAMERA3_MSG_ERROR_RESULT"] = 3] = "CAMERA3_MSG_ERROR_RESULT";
    Camera3ErrorMsgCode[Camera3ErrorMsgCode["CAMERA3_MSG_ERROR_BUFFER"] = 4] = "CAMERA3_MSG_ERROR_BUFFER";
})(Camera3ErrorMsgCode || (Camera3ErrorMsgCode = {}));
export const Camera3BufferRequestStatusSpec = { $: mojo.internal.Enum() };
export var Camera3BufferRequestStatus;
(function (Camera3BufferRequestStatus) {
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["MAX_VALUE"] = 4] = "MAX_VALUE";
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["CAMERA3_BUF_REQ_OK"] = 0] = "CAMERA3_BUF_REQ_OK";
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["CAMERA3_BUF_REQ_FAILED_PARTIAL"] = 1] = "CAMERA3_BUF_REQ_FAILED_PARTIAL";
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["CAMERA3_BUF_REQ_FAILED_CONFIGURING"] = 2] = "CAMERA3_BUF_REQ_FAILED_CONFIGURING";
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["CAMERA3_BUF_REQ_FAILED_ILLEGAL_ARGUMENTS"] = 3] = "CAMERA3_BUF_REQ_FAILED_ILLEGAL_ARGUMENTS";
    Camera3BufferRequestStatus[Camera3BufferRequestStatus["CAMERA3_BUF_REQ_FAILED_UNKNOWN"] = 4] = "CAMERA3_BUF_REQ_FAILED_UNKNOWN";
})(Camera3BufferRequestStatus || (Camera3BufferRequestStatus = {}));
export const Camera3StreamBufferReqStatusSpec = { $: mojo.internal.Enum() };
export var Camera3StreamBufferReqStatus;
(function (Camera3StreamBufferReqStatus) {
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["MAX_VALUE"] = 4] = "MAX_VALUE";
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["CAMERA3_PS_BUF_REQ_OK"] = 0] = "CAMERA3_PS_BUF_REQ_OK";
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["CAMERA3_PS_BUF_REQ_NO_BUFFER_AVAILABLE"] = 1] = "CAMERA3_PS_BUF_REQ_NO_BUFFER_AVAILABLE";
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["CAMERA3_PS_BUF_REQ_MAX_BUFFER_EXCEEDED"] = 2] = "CAMERA3_PS_BUF_REQ_MAX_BUFFER_EXCEEDED";
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["CAMERA3_PS_BUF_REQ_STREAM_DISCONNECTED"] = 3] = "CAMERA3_PS_BUF_REQ_STREAM_DISCONNECTED";
    Camera3StreamBufferReqStatus[Camera3StreamBufferReqStatus["CAMERA3_PS_BUF_REQ_UNKNOWN_ERROR"] = 4] = "CAMERA3_PS_BUF_REQ_UNKNOWN_ERROR";
})(Camera3StreamBufferReqStatus || (Camera3StreamBufferReqStatus = {}));
export const Camera3RequestTemplateSpec = { $: mojo.internal.Enum() };
export var Camera3RequestTemplate;
(function (Camera3RequestTemplate) {
    Camera3RequestTemplate[Camera3RequestTemplate["MIN_VALUE"] = 1] = "MIN_VALUE";
    Camera3RequestTemplate[Camera3RequestTemplate["MAX_VALUE"] = 7] = "MAX_VALUE";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_PREVIEW"] = 1] = "CAMERA3_TEMPLATE_PREVIEW";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_STILL_CAPTURE"] = 2] = "CAMERA3_TEMPLATE_STILL_CAPTURE";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_VIDEO_RECORD"] = 3] = "CAMERA3_TEMPLATE_VIDEO_RECORD";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_VIDEO_SNAPSHOT"] = 4] = "CAMERA3_TEMPLATE_VIDEO_SNAPSHOT";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_ZERO_SHUTTER_LAG"] = 5] = "CAMERA3_TEMPLATE_ZERO_SHUTTER_LAG";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_MANUAL"] = 6] = "CAMERA3_TEMPLATE_MANUAL";
    Camera3RequestTemplate[Camera3RequestTemplate["CAMERA3_TEMPLATE_COUNT"] = 7] = "CAMERA3_TEMPLATE_COUNT";
})(Camera3RequestTemplate || (Camera3RequestTemplate = {}));
export class Camera3CallbackOpsPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.Camera3CallbackOps', scope);
    }
}
export class Camera3CallbackOpsRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(Camera3CallbackOpsPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    processCaptureResult(result) {
        this.proxy.sendMessage(0, Camera3CallbackOps_ProcessCaptureResult_ParamsSpec.$, null, [
            result
        ], false);
    }
    notify(msg) {
        this.proxy.sendMessage(1, Camera3CallbackOps_Notify_ParamsSpec.$, null, [
            msg
        ], false);
    }
    requestStreamBuffers(bufferReqs) {
        return this.proxy.sendMessage(2, Camera3CallbackOps_RequestStreamBuffers_ParamsSpec.$, Camera3CallbackOps_RequestStreamBuffers_ResponseParamsSpec.$, [
            bufferReqs
        ], false);
    }
    returnStreamBuffers(buffers) {
        this.proxy.sendMessage(3, Camera3CallbackOps_ReturnStreamBuffers_ParamsSpec.$, null, [
            buffers
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Camera3CallbackOps
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class Camera3CallbackOpsReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(Camera3CallbackOpsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Camera3CallbackOps_ProcessCaptureResult_ParamsSpec.$, null, impl.processCaptureResult.bind(impl), false);
        this.helper_internal_.registerHandler(1, Camera3CallbackOps_Notify_ParamsSpec.$, null, impl.notify.bind(impl), false);
        this.helper_internal_.registerHandler(2, Camera3CallbackOps_RequestStreamBuffers_ParamsSpec.$, Camera3CallbackOps_RequestStreamBuffers_ResponseParamsSpec.$, impl.requestStreamBuffers.bind(impl), false);
        this.helper_internal_.registerHandler(3, Camera3CallbackOps_ReturnStreamBuffers_ParamsSpec.$, null, impl.returnStreamBuffers.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Camera3CallbackOps {
    static get $interfaceName() {
        return "cros.mojom.Camera3CallbackOps";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new Camera3CallbackOpsRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Camera3CallbackOps
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class Camera3CallbackOpsCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(Camera3CallbackOpsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.processCaptureResult =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Camera3CallbackOps_ProcessCaptureResult_ParamsSpec.$, null, this.processCaptureResult.createReceiverHandler(false /* expectsResponse */), false);
        this.notify =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Camera3CallbackOps_Notify_ParamsSpec.$, null, this.notify.createReceiverHandler(false /* expectsResponse */), false);
        this.requestStreamBuffers =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Camera3CallbackOps_RequestStreamBuffers_ParamsSpec.$, Camera3CallbackOps_RequestStreamBuffers_ResponseParamsSpec.$, this.requestStreamBuffers.createReceiverHandler(true /* expectsResponse */), false);
        this.returnStreamBuffers =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Camera3CallbackOps_ReturnStreamBuffers_ParamsSpec.$, null, this.returnStreamBuffers.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class Camera3DeviceOpsPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.Camera3DeviceOps', scope);
    }
}
export class Camera3DeviceOpsRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(Camera3DeviceOpsPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    initialize(callbackOps) {
        return this.proxy.sendMessage(0, Camera3DeviceOps_Initialize_ParamsSpec.$, Camera3DeviceOps_Initialize_ResponseParamsSpec.$, [
            callbackOps
        ], false);
    }
    configureStreams(config) {
        return this.proxy.sendMessage(1, Camera3DeviceOps_ConfigureStreams_ParamsSpec.$, Camera3DeviceOps_ConfigureStreams_ResponseParamsSpec.$, [
            config
        ], false);
    }
    constructDefaultRequestSettings(type) {
        return this.proxy.sendMessage(2, Camera3DeviceOps_ConstructDefaultRequestSettings_ParamsSpec.$, Camera3DeviceOps_ConstructDefaultRequestSettings_ResponseParamsSpec.$, [
            type
        ], false);
    }
    processCaptureRequest(request) {
        return this.proxy.sendMessage(3, Camera3DeviceOps_ProcessCaptureRequest_ParamsSpec.$, Camera3DeviceOps_ProcessCaptureRequest_ResponseParamsSpec.$, [
            request
        ], false);
    }
    dump(fd) {
        this.proxy.sendMessage(4, Camera3DeviceOps_Dump_ParamsSpec.$, null, [
            fd
        ], false);
    }
    flush() {
        return this.proxy.sendMessage(5, Camera3DeviceOps_Flush_ParamsSpec.$, Camera3DeviceOps_Flush_ResponseParamsSpec.$, [], false);
    }
    registerBuffer(bufferId, type, fds, drmFormat, halPixelFormat, width, height, strides, offsets) {
        return this.proxy.sendMessage(6, Camera3DeviceOps_RegisterBuffer_ParamsSpec.$, Camera3DeviceOps_RegisterBuffer_ResponseParamsSpec.$, [
            bufferId,
            type,
            fds,
            drmFormat,
            halPixelFormat,
            width,
            height,
            strides,
            offsets
        ], false);
    }
    close() {
        return this.proxy.sendMessage(7, Camera3DeviceOps_Close_ParamsSpec.$, Camera3DeviceOps_Close_ResponseParamsSpec.$, [], false);
    }
    configureStreamsAndGetAllocatedBuffers(config) {
        return this.proxy.sendMessage(8, Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ParamsSpec.$, Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ResponseParamsSpec.$, [
            config
        ], false);
    }
    signalStreamFlush(streamIds) {
        this.proxy.sendMessage(9, Camera3DeviceOps_SignalStreamFlush_ParamsSpec.$, null, [
            streamIds
        ], false);
    }
    onNewBuffer(buffer) {
        return this.proxy.sendMessage(10, Camera3DeviceOps_OnNewBuffer_ParamsSpec.$, Camera3DeviceOps_OnNewBuffer_ResponseParamsSpec.$, [
            buffer
        ], false);
    }
    onBufferRetired(bufferId) {
        this.proxy.sendMessage(11, Camera3DeviceOps_OnBufferRetired_ParamsSpec.$, null, [
            bufferId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Camera3DeviceOps
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class Camera3DeviceOpsReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(Camera3DeviceOpsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Camera3DeviceOps_Initialize_ParamsSpec.$, Camera3DeviceOps_Initialize_ResponseParamsSpec.$, impl.initialize.bind(impl), false);
        this.helper_internal_.registerHandler(1, Camera3DeviceOps_ConfigureStreams_ParamsSpec.$, Camera3DeviceOps_ConfigureStreams_ResponseParamsSpec.$, impl.configureStreams.bind(impl), false);
        this.helper_internal_.registerHandler(2, Camera3DeviceOps_ConstructDefaultRequestSettings_ParamsSpec.$, Camera3DeviceOps_ConstructDefaultRequestSettings_ResponseParamsSpec.$, impl.constructDefaultRequestSettings.bind(impl), false);
        this.helper_internal_.registerHandler(3, Camera3DeviceOps_ProcessCaptureRequest_ParamsSpec.$, Camera3DeviceOps_ProcessCaptureRequest_ResponseParamsSpec.$, impl.processCaptureRequest.bind(impl), false);
        this.helper_internal_.registerHandler(4, Camera3DeviceOps_Dump_ParamsSpec.$, null, impl.dump.bind(impl), false);
        this.helper_internal_.registerHandler(5, Camera3DeviceOps_Flush_ParamsSpec.$, Camera3DeviceOps_Flush_ResponseParamsSpec.$, impl.flush.bind(impl), false);
        this.helper_internal_.registerHandler(6, Camera3DeviceOps_RegisterBuffer_ParamsSpec.$, Camera3DeviceOps_RegisterBuffer_ResponseParamsSpec.$, impl.registerBuffer.bind(impl), false);
        this.helper_internal_.registerHandler(7, Camera3DeviceOps_Close_ParamsSpec.$, Camera3DeviceOps_Close_ResponseParamsSpec.$, impl.close.bind(impl), false);
        this.helper_internal_.registerHandler(8, Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ParamsSpec.$, Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ResponseParamsSpec.$, impl.configureStreamsAndGetAllocatedBuffers.bind(impl), false);
        this.helper_internal_.registerHandler(9, Camera3DeviceOps_SignalStreamFlush_ParamsSpec.$, null, impl.signalStreamFlush.bind(impl), false);
        this.helper_internal_.registerHandler(10, Camera3DeviceOps_OnNewBuffer_ParamsSpec.$, Camera3DeviceOps_OnNewBuffer_ResponseParamsSpec.$, impl.onNewBuffer.bind(impl), false);
        this.helper_internal_.registerHandler(11, Camera3DeviceOps_OnBufferRetired_ParamsSpec.$, null, impl.onBufferRetired.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Camera3DeviceOps {
    static get $interfaceName() {
        return "cros.mojom.Camera3DeviceOps";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new Camera3DeviceOpsRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
export const Camera3DeviceOps_BufferTypeSpec = { $: mojo.internal.Enum() };
export var Camera3DeviceOps_BufferType;
(function (Camera3DeviceOps_BufferType) {
    Camera3DeviceOps_BufferType[Camera3DeviceOps_BufferType["MIN_VALUE"] = 0] = "MIN_VALUE";
    Camera3DeviceOps_BufferType[Camera3DeviceOps_BufferType["MAX_VALUE"] = 1] = "MAX_VALUE";
    Camera3DeviceOps_BufferType[Camera3DeviceOps_BufferType["DMABUF"] = 0] = "DMABUF";
    Camera3DeviceOps_BufferType[Camera3DeviceOps_BufferType["SHM"] = 1] = "SHM";
})(Camera3DeviceOps_BufferType || (Camera3DeviceOps_BufferType = {}));
/**
 * An object which receives request messages for the Camera3DeviceOps
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class Camera3DeviceOpsCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(Camera3DeviceOpsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.initialize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Camera3DeviceOps_Initialize_ParamsSpec.$, Camera3DeviceOps_Initialize_ResponseParamsSpec.$, this.initialize.createReceiverHandler(true /* expectsResponse */), false);
        this.configureStreams =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Camera3DeviceOps_ConfigureStreams_ParamsSpec.$, Camera3DeviceOps_ConfigureStreams_ResponseParamsSpec.$, this.configureStreams.createReceiverHandler(true /* expectsResponse */), false);
        this.constructDefaultRequestSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Camera3DeviceOps_ConstructDefaultRequestSettings_ParamsSpec.$, Camera3DeviceOps_ConstructDefaultRequestSettings_ResponseParamsSpec.$, this.constructDefaultRequestSettings.createReceiverHandler(true /* expectsResponse */), false);
        this.processCaptureRequest =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Camera3DeviceOps_ProcessCaptureRequest_ParamsSpec.$, Camera3DeviceOps_ProcessCaptureRequest_ResponseParamsSpec.$, this.processCaptureRequest.createReceiverHandler(true /* expectsResponse */), false);
        this.dump =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Camera3DeviceOps_Dump_ParamsSpec.$, null, this.dump.createReceiverHandler(false /* expectsResponse */), false);
        this.flush =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Camera3DeviceOps_Flush_ParamsSpec.$, Camera3DeviceOps_Flush_ResponseParamsSpec.$, this.flush.createReceiverHandler(true /* expectsResponse */), false);
        this.registerBuffer =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Camera3DeviceOps_RegisterBuffer_ParamsSpec.$, Camera3DeviceOps_RegisterBuffer_ResponseParamsSpec.$, this.registerBuffer.createReceiverHandler(true /* expectsResponse */), false);
        this.close =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Camera3DeviceOps_Close_ParamsSpec.$, Camera3DeviceOps_Close_ResponseParamsSpec.$, this.close.createReceiverHandler(true /* expectsResponse */), false);
        this.configureStreamsAndGetAllocatedBuffers =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ParamsSpec.$, Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ResponseParamsSpec.$, this.configureStreamsAndGetAllocatedBuffers.createReceiverHandler(true /* expectsResponse */), false);
        this.signalStreamFlush =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, Camera3DeviceOps_SignalStreamFlush_ParamsSpec.$, null, this.signalStreamFlush.createReceiverHandler(false /* expectsResponse */), false);
        this.onNewBuffer =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, Camera3DeviceOps_OnNewBuffer_ParamsSpec.$, Camera3DeviceOps_OnNewBuffer_ResponseParamsSpec.$, this.onNewBuffer.createReceiverHandler(true /* expectsResponse */), false);
        this.onBufferRetired =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, Camera3DeviceOps_OnBufferRetired_ParamsSpec.$, null, this.onBufferRetired.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const CropRotateScaleInfoSpec = { $: {} };
export const Camera3StreamSpec = { $: {} };
export const Camera3StreamConfigurationSpec = { $: {} };
export const CameraBufferHandleSpec = { $: {} };
export const Camera3StreamBufferSpec = { $: {} };
export const Camera3ErrorMsgSpec = { $: {} };
export const Camera3ShutterMsgSpec = { $: {} };
export const Camera3NotifyMsgSpec = { $: {} };
export const Camera3BufferRequestSpec = { $: {} };
export const Camera3StreamBufferRetSpec = { $: {} };
export const Camera3PhyscamMetadataSpec = { $: {} };
export const Camera3CaptureRequestSpec = { $: {} };
export const Camera3CaptureResultSpec = { $: {} };
export const Camera3CallbackOps_ProcessCaptureResult_ParamsSpec = { $: {} };
export const Camera3CallbackOps_Notify_ParamsSpec = { $: {} };
export const Camera3CallbackOps_RequestStreamBuffers_ParamsSpec = { $: {} };
export const Camera3CallbackOps_RequestStreamBuffers_ResponseParamsSpec = { $: {} };
export const Camera3CallbackOps_ReturnStreamBuffers_ParamsSpec = { $: {} };
export const Camera3DeviceOps_Initialize_ParamsSpec = { $: {} };
export const Camera3DeviceOps_Initialize_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_ConfigureStreams_ParamsSpec = { $: {} };
export const Camera3DeviceOps_ConfigureStreams_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_ConstructDefaultRequestSettings_ParamsSpec = { $: {} };
export const Camera3DeviceOps_ConstructDefaultRequestSettings_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_ProcessCaptureRequest_ParamsSpec = { $: {} };
export const Camera3DeviceOps_ProcessCaptureRequest_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_Dump_ParamsSpec = { $: {} };
export const Camera3DeviceOps_Flush_ParamsSpec = { $: {} };
export const Camera3DeviceOps_Flush_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_RegisterBuffer_ParamsSpec = { $: {} };
export const Camera3DeviceOps_RegisterBuffer_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_Close_ParamsSpec = { $: {} };
export const Camera3DeviceOps_Close_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ParamsSpec = { $: {} };
export const Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_SignalStreamFlush_ParamsSpec = { $: {} };
export const Camera3DeviceOps_OnNewBuffer_ParamsSpec = { $: {} };
export const Camera3DeviceOps_OnNewBuffer_ResponseParamsSpec = { $: {} };
export const Camera3DeviceOps_OnBufferRetired_ParamsSpec = { $: {} };
export const Camera3NotifyMsgMessageSpec = { $: {} };
mojo.internal.Struct(CropRotateScaleInfoSpec.$, 'CropRotateScaleInfo', [
    mojo.internal.StructField('cropRotateScaleDegrees', 0, 0, Camera3StreamRotationSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3StreamSpec.$, 'Camera3Stream', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('streamType', 8, 0, Camera3StreamTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('format', 20, 0, HalPixelFormatSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('usage', 24, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxBuffers', 28, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dataSpace', 32, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rotation', 36, 0, Camera3StreamRotationSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cropRotateScaleInfo', 40, 0, CropRotateScaleInfoSpec.$, null, true /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('physicalCameraId', 48, 0, mojo.internal.String, null, true /* nullable */, 4, undefined, undefined),
    mojo.internal.StructField('effects', 56, 0, mojo.internal.Array(cros_mojom_Camera3StreamEffectSpec.$, false), null, true /* nullable */, 6, undefined, undefined),
], [[0, 48], [1, 56], [4, 64], [6, 72],]);
mojo.internal.Struct(Camera3StreamConfigurationSpec.$, 'Camera3StreamConfiguration', [
    mojo.internal.StructField('streams', 0, 0, mojo.internal.Array(Camera3StreamSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('operationMode', 8, 0, Camera3StreamConfigurationModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sessionParameters', 16, 0, cros_mojom_CameraMetadataSpec.$, null, true /* nullable */, 4, undefined, undefined),
], [[0, 24], [4, 32],]);
mojo.internal.Struct(CameraBufferHandleSpec.$, 'CameraBufferHandle', [
    mojo.internal.StructField('bufferId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fds', 8, 0, mojo.internal.Array(mojo.internal.Handle, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('drmFormat', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('halPixelFormat', 20, 0, HalPixelFormatSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 24, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 28, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('strides', 32, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('offsets', 40, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sizes', 48, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, true /* nullable */, 3, undefined, undefined),
    mojo.internal.StructField('hasModifier', 56, 0, mojo.internal.Bool, false, false /* nullable */, 7, undefined, undefined),
    mojo.internal.StructField('modifier', 64, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 7, undefined, undefined),
], [[0, 56], [3, 64], [7, 80],]);
mojo.internal.Struct(Camera3StreamBufferSpec.$, 'Camera3StreamBuffer', [
    mojo.internal.StructField('streamId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bufferId', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('status', 16, 0, Camera3BufferStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('acquireFence', 20, 0, mojo.internal.Handle, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('releaseFence', 24, 0, mojo.internal.Handle, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bufferHandle', 32, 0, CameraBufferHandleSpec.$, null, true /* nullable */, 2, undefined, undefined),
], [[0, 40], [2, 48],]);
mojo.internal.Struct(Camera3ErrorMsgSpec.$, 'Camera3ErrorMsg', [
    mojo.internal.StructField('frameNumber', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('errorStreamId', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('errorCode', 4, 0, Camera3ErrorMsgCodeSpec.$, 1, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Camera3ShutterMsgSpec.$, 'Camera3ShutterMsg', [
    mojo.internal.StructField('frameNumber', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timestamp', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Camera3NotifyMsgSpec.$, 'Camera3NotifyMsg', [
    mojo.internal.StructField('type', 0, 0, Camera3MsgTypeSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('message', 8, 0, Camera3NotifyMsgMessageSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Camera3BufferRequestSpec.$, 'Camera3BufferRequest', [
    mojo.internal.StructField('streamId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numBuffersRequested', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Camera3StreamBufferRetSpec.$, 'Camera3StreamBufferRet', [
    mojo.internal.StructField('streamId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('status', 8, 0, Camera3StreamBufferReqStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputBuffers', 16, 0, mojo.internal.Array(Camera3StreamBufferSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Camera3PhyscamMetadataSpec.$, 'Camera3PhyscamMetadata', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('metadata', 8, 0, cros_mojom_CameraMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Camera3CaptureRequestSpec.$, 'Camera3CaptureRequest', [
    mojo.internal.StructField('frameNumber', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, cros_mojom_CameraMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputBuffer', 16, 0, Camera3StreamBufferSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputBuffers', 24, 0, mojo.internal.Array(Camera3StreamBufferSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('physcamSettings', 32, 0, mojo.internal.Array(Camera3PhyscamMetadataSpec.$, false), null, true /* nullable */, 4, undefined, undefined),
], [[0, 40], [4, 48],]);
mojo.internal.Struct(Camera3CaptureResultSpec.$, 'Camera3CaptureResult', [
    mojo.internal.StructField('frameNumber', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('result', 8, 0, cros_mojom_CameraMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputBuffers', 16, 0, mojo.internal.Array(Camera3StreamBufferSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputBuffer', 24, 0, Camera3StreamBufferSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('partialResult', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('physcamMetadata', 32, 0, mojo.internal.Array(Camera3PhyscamMetadataSpec.$, false), null, true /* nullable */, 4, undefined, undefined),
], [[0, 40], [4, 48],]);
mojo.internal.Struct(Camera3CallbackOps_ProcessCaptureResult_ParamsSpec.$, 'Camera3CallbackOps_ProcessCaptureResult_Params', [
    mojo.internal.StructField('result', 0, 0, Camera3CaptureResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3CallbackOps_Notify_ParamsSpec.$, 'Camera3CallbackOps_Notify_Params', [
    mojo.internal.StructField('msg', 0, 0, Camera3NotifyMsgSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3CallbackOps_RequestStreamBuffers_ParamsSpec.$, 'Camera3CallbackOps_RequestStreamBuffers_Params', [
    mojo.internal.StructField('bufferReqs', 0, 0, mojo.internal.Array(Camera3BufferRequestSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3CallbackOps_RequestStreamBuffers_ResponseParamsSpec.$, 'Camera3CallbackOps_RequestStreamBuffers_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, Camera3BufferRequestStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('returnedBufReqs', 8, 0, mojo.internal.Array(Camera3StreamBufferRetSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Camera3CallbackOps_ReturnStreamBuffers_ParamsSpec.$, 'Camera3CallbackOps_ReturnStreamBuffers_Params', [
    mojo.internal.StructField('buffers', 0, 0, mojo.internal.Array(Camera3StreamBufferSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_Initialize_ParamsSpec.$, 'Camera3DeviceOps_Initialize_Params', [
    mojo.internal.StructField('callbackOps', 0, 0, mojo.internal.InterfaceProxy(Camera3CallbackOpsRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_Initialize_ResponseParamsSpec.$, 'Camera3DeviceOps_Initialize_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ConfigureStreams_ParamsSpec.$, 'Camera3DeviceOps_ConfigureStreams_Params', [
    mojo.internal.StructField('config', 0, 0, Camera3StreamConfigurationSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ConfigureStreams_ResponseParamsSpec.$, 'Camera3DeviceOps_ConfigureStreams_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updatedConfig', 8, 0, Camera3StreamConfigurationSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Camera3DeviceOps_ConstructDefaultRequestSettings_ParamsSpec.$, 'Camera3DeviceOps_ConstructDefaultRequestSettings_Params', [
    mojo.internal.StructField('type', 0, 0, Camera3RequestTemplateSpec.$, 1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ConstructDefaultRequestSettings_ResponseParamsSpec.$, 'Camera3DeviceOps_ConstructDefaultRequestSettings_ResponseParams', [
    mojo.internal.StructField('settings', 0, 0, cros_mojom_CameraMetadataSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ProcessCaptureRequest_ParamsSpec.$, 'Camera3DeviceOps_ProcessCaptureRequest_Params', [
    mojo.internal.StructField('request', 0, 0, Camera3CaptureRequestSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ProcessCaptureRequest_ResponseParamsSpec.$, 'Camera3DeviceOps_ProcessCaptureRequest_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_Dump_ParamsSpec.$, 'Camera3DeviceOps_Dump_Params', [
    mojo.internal.StructField('fd', 0, 0, mojo.internal.Handle, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_Flush_ParamsSpec.$, 'Camera3DeviceOps_Flush_Params', [], [[0, 8],]);
mojo.internal.Struct(Camera3DeviceOps_Flush_ResponseParamsSpec.$, 'Camera3DeviceOps_Flush_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_RegisterBuffer_ParamsSpec.$, 'Camera3DeviceOps_RegisterBuffer_Params', [
    mojo.internal.StructField('bufferId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 8, 0, Camera3DeviceOps_BufferTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fds', 16, 0, mojo.internal.Array(mojo.internal.Handle, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('drmFormat', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('halPixelFormat', 24, 0, HalPixelFormatSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 28, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 32, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('strides', 40, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('offsets', 48, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(Camera3DeviceOps_RegisterBuffer_ResponseParamsSpec.$, 'Camera3DeviceOps_RegisterBuffer_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_Close_ParamsSpec.$, 'Camera3DeviceOps_Close_Params', [], [[0, 8],]);
mojo.internal.Struct(Camera3DeviceOps_Close_ResponseParamsSpec.$, 'Camera3DeviceOps_Close_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ParamsSpec.$, 'Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_Params', [
    mojo.internal.StructField('config', 0, 0, Camera3StreamConfigurationSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ResponseParamsSpec.$, 'Camera3DeviceOps_ConfigureStreamsAndGetAllocatedBuffers_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updatedConfig', 8, 0, Camera3StreamConfigurationSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('allocatedBuffers', 16, 0, mojo.internal.Map(mojo.internal.Uint64, mojo.internal.Array(Camera3StreamBufferSpec.$, false), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Camera3DeviceOps_SignalStreamFlush_ParamsSpec.$, 'Camera3DeviceOps_SignalStreamFlush_Params', [
    mojo.internal.StructField('streamIds', 0, 0, mojo.internal.Array(mojo.internal.Uint64, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_OnNewBuffer_ParamsSpec.$, 'Camera3DeviceOps_OnNewBuffer_Params', [
    mojo.internal.StructField('buffer', 0, 0, CameraBufferHandleSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_OnNewBuffer_ResponseParamsSpec.$, 'Camera3DeviceOps_OnNewBuffer_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Camera3DeviceOps_OnBufferRetired_ParamsSpec.$, 'Camera3DeviceOps_OnBufferRetired_Params', [
    mojo.internal.StructField('bufferId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(Camera3NotifyMsgMessageSpec.$, 'Camera3NotifyMsgMessage', {
    'error': {
        'ordinal': 0,
        'type': Camera3ErrorMsgSpec.$,
    },
    'shutter': {
        'ordinal': 1,
        'type': Camera3ShutterMsgSpec.$,
    },
    'generic': {
        'ordinal': 2,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
    },
});
export var Camera3NotifyMsgMessageFieldTags;
(function (Camera3NotifyMsgMessageFieldTags) {
    Camera3NotifyMsgMessageFieldTags[Camera3NotifyMsgMessageFieldTags["ERROR"] = 0] = "ERROR";
    Camera3NotifyMsgMessageFieldTags[Camera3NotifyMsgMessageFieldTags["SHUTTER"] = 1] = "SHUTTER";
    Camera3NotifyMsgMessageFieldTags[Camera3NotifyMsgMessageFieldTags["GENERIC"] = 2] = "GENERIC";
})(Camera3NotifyMsgMessageFieldTags || (Camera3NotifyMsgMessageFieldTags = {}));
export function whichCamera3NotifyMsgMessage(u) {
    if (u.error !== null && u.error !== undefined) {
        return Camera3NotifyMsgMessageFieldTags.ERROR;
    }
    if (u.shutter !== null && u.shutter !== undefined) {
        return Camera3NotifyMsgMessageFieldTags.SHUTTER;
    }
    if (u.generic !== null && u.generic !== undefined) {
        return Camera3NotifyMsgMessageFieldTags.GENERIC;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
