// media/capture/video/chromeos/mojom/camera_app.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BlobSpec as media_mojom_BlobSpec } from '../../../mojom/image_capture.mojom-webui.js';
import { CameraInfoSpec as cros_mojom_CameraInfoSpec } from './camera_common.mojom-webui.js';
import { CameraMetadataSpec as cros_mojom_CameraMetadataSpec } from './camera_metadata.mojom-webui.js';
import { PointFSpec as gfx_mojom_PointFSpec, RectSpec as gfx_mojom_RectSpec, SizeSpec as gfx_mojom_SizeSpec } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { RangeSpec as gfx_mojom_RangeSpec } from '//resources/mojo/ui/gfx/range/mojom/range.mojom-webui.js';
export const EffectSpec = { $: mojo.internal.Enum() };
export var Effect;
(function (Effect) {
    Effect[Effect["MIN_VALUE"] = 0] = "MIN_VALUE";
    Effect[Effect["MAX_VALUE"] = 1] = "MAX_VALUE";
    Effect[Effect["kNoEffect"] = 0] = "kNoEffect";
    Effect[Effect["kPortraitMode"] = 1] = "kPortraitMode";
})(Effect || (Effect = {}));
export const StreamTypeSpec = { $: mojo.internal.Enum() };
export var StreamType;
(function (StreamType) {
    StreamType[StreamType["MIN_VALUE"] = 0] = "MIN_VALUE";
    StreamType[StreamType["MAX_VALUE"] = 4] = "MAX_VALUE";
    StreamType[StreamType["kPreviewOutput"] = 0] = "kPreviewOutput";
    StreamType[StreamType["kJpegOutput"] = 1] = "kJpegOutput";
    StreamType[StreamType["kJpegPortraitOutput"] = 2] = "kJpegPortraitOutput";
    StreamType[StreamType["kRecordingOutput"] = 3] = "kRecordingOutput";
    StreamType[StreamType["kUnknown"] = 4] = "kUnknown";
})(StreamType || (StreamType = {}));
export const GetCameraAppDeviceStatusSpec = { $: mojo.internal.Enum() };
export var GetCameraAppDeviceStatus;
(function (GetCameraAppDeviceStatus) {
    GetCameraAppDeviceStatus[GetCameraAppDeviceStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    GetCameraAppDeviceStatus[GetCameraAppDeviceStatus["MAX_VALUE"] = 1] = "MAX_VALUE";
    GetCameraAppDeviceStatus[GetCameraAppDeviceStatus["kSuccess"] = 0] = "kSuccess";
    GetCameraAppDeviceStatus[GetCameraAppDeviceStatus["kErrorInvalidId"] = 1] = "kErrorInvalidId";
})(GetCameraAppDeviceStatus || (GetCameraAppDeviceStatus = {}));
export const CaptureIntentSpec = { $: mojo.internal.Enum() };
export var CaptureIntent;
(function (CaptureIntent) {
    CaptureIntent[CaptureIntent["MIN_VALUE"] = 0] = "MIN_VALUE";
    CaptureIntent[CaptureIntent["MAX_VALUE"] = 3] = "MAX_VALUE";
    CaptureIntent[CaptureIntent["kDefault"] = 0] = "kDefault";
    CaptureIntent[CaptureIntent["kVideoRecord"] = 1] = "kVideoRecord";
    CaptureIntent[CaptureIntent["kStillCapture"] = 2] = "kStillCapture";
    CaptureIntent[CaptureIntent["kPortraitCapture"] = 3] = "kPortraitCapture";
})(CaptureIntent || (CaptureIntent = {}));
export class CameraAppDeviceProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraAppDeviceProvider', scope);
    }
}
export class CameraAppDeviceProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraAppDeviceProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getCameraAppDevice(sourceId) {
        return this.proxy.sendMessage(0, CameraAppDeviceProvider_GetCameraAppDevice_ParamsSpec.$, CameraAppDeviceProvider_GetCameraAppDevice_ResponseParamsSpec.$, [
            sourceId
        ], false);
    }
    isSupported() {
        return this.proxy.sendMessage(1, CameraAppDeviceProvider_IsSupported_ParamsSpec.$, CameraAppDeviceProvider_IsSupported_ResponseParamsSpec.$, [], false);
    }
    isDeviceInUse(sourceId) {
        return this.proxy.sendMessage(2, CameraAppDeviceProvider_IsDeviceInUse_ParamsSpec.$, CameraAppDeviceProvider_IsDeviceInUse_ResponseParamsSpec.$, [
            sourceId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CameraAppDeviceProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraAppDeviceProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppDeviceProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraAppDeviceProvider_GetCameraAppDevice_ParamsSpec.$, CameraAppDeviceProvider_GetCameraAppDevice_ResponseParamsSpec.$, impl.getCameraAppDevice.bind(impl), false);
        this.helper_internal_.registerHandler(1, CameraAppDeviceProvider_IsSupported_ParamsSpec.$, CameraAppDeviceProvider_IsSupported_ResponseParamsSpec.$, impl.isSupported.bind(impl), false);
        this.helper_internal_.registerHandler(2, CameraAppDeviceProvider_IsDeviceInUse_ParamsSpec.$, CameraAppDeviceProvider_IsDeviceInUse_ResponseParamsSpec.$, impl.isDeviceInUse.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraAppDeviceProvider {
    static get $interfaceName() {
        return "cros.mojom.CameraAppDeviceProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraAppDeviceProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraAppDeviceProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraAppDeviceProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppDeviceProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getCameraAppDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraAppDeviceProvider_GetCameraAppDevice_ParamsSpec.$, CameraAppDeviceProvider_GetCameraAppDevice_ResponseParamsSpec.$, this.getCameraAppDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.isSupported =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CameraAppDeviceProvider_IsSupported_ParamsSpec.$, CameraAppDeviceProvider_IsSupported_ResponseParamsSpec.$, this.isSupported.createReceiverHandler(true /* expectsResponse */), false);
        this.isDeviceInUse =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CameraAppDeviceProvider_IsDeviceInUse_ParamsSpec.$, CameraAppDeviceProvider_IsDeviceInUse_ResponseParamsSpec.$, this.isDeviceInUse.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraAppDeviceBridgePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraAppDeviceBridge', scope);
    }
}
export class CameraAppDeviceBridgeRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraAppDeviceBridgePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getCameraAppDevice(deviceId) {
        return this.proxy.sendMessage(0, CameraAppDeviceBridge_GetCameraAppDevice_ParamsSpec.$, CameraAppDeviceBridge_GetCameraAppDevice_ResponseParamsSpec.$, [
            deviceId
        ], false);
    }
    isSupported() {
        return this.proxy.sendMessage(1, CameraAppDeviceBridge_IsSupported_ParamsSpec.$, CameraAppDeviceBridge_IsSupported_ResponseParamsSpec.$, [], false);
    }
    setVirtualDeviceEnabled(deviceId, enabled) {
        return this.proxy.sendMessage(2, CameraAppDeviceBridge_SetVirtualDeviceEnabled_ParamsSpec.$, CameraAppDeviceBridge_SetVirtualDeviceEnabled_ResponseParamsSpec.$, [
            deviceId,
            enabled
        ], false);
    }
    isDeviceInUse(deviceId) {
        return this.proxy.sendMessage(3, CameraAppDeviceBridge_IsDeviceInUse_ParamsSpec.$, CameraAppDeviceBridge_IsDeviceInUse_ResponseParamsSpec.$, [
            deviceId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CameraAppDeviceBridge
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraAppDeviceBridgeReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppDeviceBridgeRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraAppDeviceBridge_GetCameraAppDevice_ParamsSpec.$, CameraAppDeviceBridge_GetCameraAppDevice_ResponseParamsSpec.$, impl.getCameraAppDevice.bind(impl), false);
        this.helper_internal_.registerHandler(1, CameraAppDeviceBridge_IsSupported_ParamsSpec.$, CameraAppDeviceBridge_IsSupported_ResponseParamsSpec.$, impl.isSupported.bind(impl), false);
        this.helper_internal_.registerHandler(2, CameraAppDeviceBridge_SetVirtualDeviceEnabled_ParamsSpec.$, CameraAppDeviceBridge_SetVirtualDeviceEnabled_ResponseParamsSpec.$, impl.setVirtualDeviceEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(3, CameraAppDeviceBridge_IsDeviceInUse_ParamsSpec.$, CameraAppDeviceBridge_IsDeviceInUse_ResponseParamsSpec.$, impl.isDeviceInUse.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraAppDeviceBridge {
    static get $interfaceName() {
        return "cros.mojom.CameraAppDeviceBridge";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraAppDeviceBridgeRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraAppDeviceBridge
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraAppDeviceBridgeCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppDeviceBridgeRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getCameraAppDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraAppDeviceBridge_GetCameraAppDevice_ParamsSpec.$, CameraAppDeviceBridge_GetCameraAppDevice_ResponseParamsSpec.$, this.getCameraAppDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.isSupported =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CameraAppDeviceBridge_IsSupported_ParamsSpec.$, CameraAppDeviceBridge_IsSupported_ResponseParamsSpec.$, this.isSupported.createReceiverHandler(true /* expectsResponse */), false);
        this.setVirtualDeviceEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CameraAppDeviceBridge_SetVirtualDeviceEnabled_ParamsSpec.$, CameraAppDeviceBridge_SetVirtualDeviceEnabled_ResponseParamsSpec.$, this.setVirtualDeviceEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.isDeviceInUse =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CameraAppDeviceBridge_IsDeviceInUse_ParamsSpec.$, CameraAppDeviceBridge_IsDeviceInUse_ResponseParamsSpec.$, this.isDeviceInUse.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraAppDevicePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraAppDevice', scope);
    }
}
export class CameraAppDeviceRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraAppDevicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    takePortraitModePhoto(observer) {
        return this.proxy.sendMessage(0, CameraAppDevice_TakePortraitModePhoto_ParamsSpec.$, CameraAppDevice_TakePortraitModePhoto_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    setFpsRange(fpsRange) {
        return this.proxy.sendMessage(1, CameraAppDevice_SetFpsRange_ParamsSpec.$, CameraAppDevice_SetFpsRange_ResponseParamsSpec.$, [
            fpsRange
        ], false);
    }
    setStillCaptureResolution(resolution) {
        return this.proxy.sendMessage(2, CameraAppDevice_SetStillCaptureResolution_ParamsSpec.$, CameraAppDevice_SetStillCaptureResolution_ResponseParamsSpec.$, [
            resolution
        ], false);
    }
    setCaptureIntent(intent) {
        return this.proxy.sendMessage(3, CameraAppDevice_SetCaptureIntent_ParamsSpec.$, CameraAppDevice_SetCaptureIntent_ResponseParamsSpec.$, [
            intent
        ], false);
    }
    addResultMetadataObserver(observer, streamType) {
        return this.proxy.sendMessage(4, CameraAppDevice_AddResultMetadataObserver_ParamsSpec.$, CameraAppDevice_AddResultMetadataObserver_ResponseParamsSpec.$, [
            observer,
            streamType
        ], false);
    }
    addCameraEventObserver(observer) {
        return this.proxy.sendMessage(5, CameraAppDevice_AddCameraEventObserver_ParamsSpec.$, CameraAppDevice_AddCameraEventObserver_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    setCameraFrameRotationEnabledAtSource(isEnabled) {
        return this.proxy.sendMessage(6, CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ParamsSpec.$, CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ResponseParamsSpec.$, [
            isEnabled
        ], false);
    }
    getCameraFrameRotation() {
        return this.proxy.sendMessage(7, CameraAppDevice_GetCameraFrameRotation_ParamsSpec.$, CameraAppDevice_GetCameraFrameRotation_ResponseParamsSpec.$, [], false);
    }
    registerDocumentCornersObserver(observer) {
        return this.proxy.sendMessage(8, CameraAppDevice_RegisterDocumentCornersObserver_ParamsSpec.$, CameraAppDevice_RegisterDocumentCornersObserver_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    setMultipleStreamsEnabled(enabled) {
        return this.proxy.sendMessage(9, CameraAppDevice_SetMultipleStreamsEnabled_ParamsSpec.$, CameraAppDevice_SetMultipleStreamsEnabled_ResponseParamsSpec.$, [
            enabled
        ], false);
    }
    registerCameraInfoObserver(observer) {
        return this.proxy.sendMessage(10, CameraAppDevice_RegisterCameraInfoObserver_ParamsSpec.$, CameraAppDevice_RegisterCameraInfoObserver_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    setCropRegion(cropRegion) {
        return this.proxy.sendMessage(11, CameraAppDevice_SetCropRegion_ParamsSpec.$, CameraAppDevice_SetCropRegion_ResponseParamsSpec.$, [
            cropRegion
        ], false);
    }
    resetCropRegion() {
        return this.proxy.sendMessage(12, CameraAppDevice_ResetCropRegion_ParamsSpec.$, CameraAppDevice_ResetCropRegion_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the CameraAppDevice
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraAppDeviceReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppDeviceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraAppDevice_TakePortraitModePhoto_ParamsSpec.$, CameraAppDevice_TakePortraitModePhoto_ResponseParamsSpec.$, impl.takePortraitModePhoto.bind(impl), false);
        this.helper_internal_.registerHandler(1, CameraAppDevice_SetFpsRange_ParamsSpec.$, CameraAppDevice_SetFpsRange_ResponseParamsSpec.$, impl.setFpsRange.bind(impl), false);
        this.helper_internal_.registerHandler(2, CameraAppDevice_SetStillCaptureResolution_ParamsSpec.$, CameraAppDevice_SetStillCaptureResolution_ResponseParamsSpec.$, impl.setStillCaptureResolution.bind(impl), false);
        this.helper_internal_.registerHandler(3, CameraAppDevice_SetCaptureIntent_ParamsSpec.$, CameraAppDevice_SetCaptureIntent_ResponseParamsSpec.$, impl.setCaptureIntent.bind(impl), false);
        this.helper_internal_.registerHandler(4, CameraAppDevice_AddResultMetadataObserver_ParamsSpec.$, CameraAppDevice_AddResultMetadataObserver_ResponseParamsSpec.$, impl.addResultMetadataObserver.bind(impl), false);
        this.helper_internal_.registerHandler(5, CameraAppDevice_AddCameraEventObserver_ParamsSpec.$, CameraAppDevice_AddCameraEventObserver_ResponseParamsSpec.$, impl.addCameraEventObserver.bind(impl), false);
        this.helper_internal_.registerHandler(6, CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ParamsSpec.$, CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ResponseParamsSpec.$, impl.setCameraFrameRotationEnabledAtSource.bind(impl), false);
        this.helper_internal_.registerHandler(7, CameraAppDevice_GetCameraFrameRotation_ParamsSpec.$, CameraAppDevice_GetCameraFrameRotation_ResponseParamsSpec.$, impl.getCameraFrameRotation.bind(impl), false);
        this.helper_internal_.registerHandler(8, CameraAppDevice_RegisterDocumentCornersObserver_ParamsSpec.$, CameraAppDevice_RegisterDocumentCornersObserver_ResponseParamsSpec.$, impl.registerDocumentCornersObserver.bind(impl), false);
        this.helper_internal_.registerHandler(9, CameraAppDevice_SetMultipleStreamsEnabled_ParamsSpec.$, CameraAppDevice_SetMultipleStreamsEnabled_ResponseParamsSpec.$, impl.setMultipleStreamsEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(10, CameraAppDevice_RegisterCameraInfoObserver_ParamsSpec.$, CameraAppDevice_RegisterCameraInfoObserver_ResponseParamsSpec.$, impl.registerCameraInfoObserver.bind(impl), false);
        this.helper_internal_.registerHandler(11, CameraAppDevice_SetCropRegion_ParamsSpec.$, CameraAppDevice_SetCropRegion_ResponseParamsSpec.$, impl.setCropRegion.bind(impl), false);
        this.helper_internal_.registerHandler(12, CameraAppDevice_ResetCropRegion_ParamsSpec.$, CameraAppDevice_ResetCropRegion_ResponseParamsSpec.$, impl.resetCropRegion.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraAppDevice {
    static get $interfaceName() {
        return "cros.mojom.CameraAppDevice";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraAppDeviceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraAppDevice
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraAppDeviceCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraAppDeviceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.takePortraitModePhoto =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraAppDevice_TakePortraitModePhoto_ParamsSpec.$, CameraAppDevice_TakePortraitModePhoto_ResponseParamsSpec.$, this.takePortraitModePhoto.createReceiverHandler(true /* expectsResponse */), false);
        this.setFpsRange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CameraAppDevice_SetFpsRange_ParamsSpec.$, CameraAppDevice_SetFpsRange_ResponseParamsSpec.$, this.setFpsRange.createReceiverHandler(true /* expectsResponse */), false);
        this.setStillCaptureResolution =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CameraAppDevice_SetStillCaptureResolution_ParamsSpec.$, CameraAppDevice_SetStillCaptureResolution_ResponseParamsSpec.$, this.setStillCaptureResolution.createReceiverHandler(true /* expectsResponse */), false);
        this.setCaptureIntent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CameraAppDevice_SetCaptureIntent_ParamsSpec.$, CameraAppDevice_SetCaptureIntent_ResponseParamsSpec.$, this.setCaptureIntent.createReceiverHandler(true /* expectsResponse */), false);
        this.addResultMetadataObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CameraAppDevice_AddResultMetadataObserver_ParamsSpec.$, CameraAppDevice_AddResultMetadataObserver_ResponseParamsSpec.$, this.addResultMetadataObserver.createReceiverHandler(true /* expectsResponse */), false);
        this.addCameraEventObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CameraAppDevice_AddCameraEventObserver_ParamsSpec.$, CameraAppDevice_AddCameraEventObserver_ResponseParamsSpec.$, this.addCameraEventObserver.createReceiverHandler(true /* expectsResponse */), false);
        this.setCameraFrameRotationEnabledAtSource =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ParamsSpec.$, CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ResponseParamsSpec.$, this.setCameraFrameRotationEnabledAtSource.createReceiverHandler(true /* expectsResponse */), false);
        this.getCameraFrameRotation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CameraAppDevice_GetCameraFrameRotation_ParamsSpec.$, CameraAppDevice_GetCameraFrameRotation_ResponseParamsSpec.$, this.getCameraFrameRotation.createReceiverHandler(true /* expectsResponse */), false);
        this.registerDocumentCornersObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, CameraAppDevice_RegisterDocumentCornersObserver_ParamsSpec.$, CameraAppDevice_RegisterDocumentCornersObserver_ResponseParamsSpec.$, this.registerDocumentCornersObserver.createReceiverHandler(true /* expectsResponse */), false);
        this.setMultipleStreamsEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, CameraAppDevice_SetMultipleStreamsEnabled_ParamsSpec.$, CameraAppDevice_SetMultipleStreamsEnabled_ResponseParamsSpec.$, this.setMultipleStreamsEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.registerCameraInfoObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, CameraAppDevice_RegisterCameraInfoObserver_ParamsSpec.$, CameraAppDevice_RegisterCameraInfoObserver_ResponseParamsSpec.$, this.registerCameraInfoObserver.createReceiverHandler(true /* expectsResponse */), false);
        this.setCropRegion =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, CameraAppDevice_SetCropRegion_ParamsSpec.$, CameraAppDevice_SetCropRegion_ResponseParamsSpec.$, this.setCropRegion.createReceiverHandler(true /* expectsResponse */), false);
        this.resetCropRegion =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, CameraAppDevice_ResetCropRegion_ParamsSpec.$, CameraAppDevice_ResetCropRegion_ResponseParamsSpec.$, this.resetCropRegion.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ResultMetadataObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.ResultMetadataObserver', scope);
    }
}
export class ResultMetadataObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ResultMetadataObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onMetadataAvailable(cameraMetadata) {
        this.proxy.sendMessage(0, ResultMetadataObserver_OnMetadataAvailable_ParamsSpec.$, null, [
            cameraMetadata
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ResultMetadataObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ResultMetadataObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ResultMetadataObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ResultMetadataObserver_OnMetadataAvailable_ParamsSpec.$, null, impl.onMetadataAvailable.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ResultMetadataObserver {
    static get $interfaceName() {
        return "cros.mojom.ResultMetadataObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ResultMetadataObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ResultMetadataObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ResultMetadataObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ResultMetadataObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onMetadataAvailable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ResultMetadataObserver_OnMetadataAvailable_ParamsSpec.$, null, this.onMetadataAvailable.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraEventObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraEventObserver', scope);
    }
}
export class CameraEventObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraEventObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onShutterDone() {
        this.proxy.sendMessage(0, CameraEventObserver_OnShutterDone_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the CameraEventObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraEventObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraEventObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraEventObserver_OnShutterDone_ParamsSpec.$, null, impl.onShutterDone.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraEventObserver {
    static get $interfaceName() {
        return "cros.mojom.CameraEventObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraEventObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraEventObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraEventObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraEventObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onShutterDone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraEventObserver_OnShutterDone_ParamsSpec.$, null, this.onShutterDone.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DocumentCornersObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.DocumentCornersObserver', scope);
    }
}
export class DocumentCornersObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DocumentCornersObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onDocumentCornersUpdated(corners) {
        this.proxy.sendMessage(0, DocumentCornersObserver_OnDocumentCornersUpdated_ParamsSpec.$, null, [
            corners
        ], false);
    }
}
;
/**
 * An object which receives request messages for the DocumentCornersObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DocumentCornersObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DocumentCornersObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DocumentCornersObserver_OnDocumentCornersUpdated_ParamsSpec.$, null, impl.onDocumentCornersUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DocumentCornersObserver {
    static get $interfaceName() {
        return "cros.mojom.DocumentCornersObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DocumentCornersObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DocumentCornersObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DocumentCornersObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DocumentCornersObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onDocumentCornersUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DocumentCornersObserver_OnDocumentCornersUpdated_ParamsSpec.$, null, this.onDocumentCornersUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraInfoObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraInfoObserver', scope);
    }
}
export class CameraInfoObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraInfoObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onCameraInfoUpdated(cameraInfo) {
        this.proxy.sendMessage(0, CameraInfoObserver_OnCameraInfoUpdated_ParamsSpec.$, null, [
            cameraInfo
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CameraInfoObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraInfoObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraInfoObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraInfoObserver_OnCameraInfoUpdated_ParamsSpec.$, null, impl.onCameraInfoUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraInfoObserver {
    static get $interfaceName() {
        return "cros.mojom.CameraInfoObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraInfoObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraInfoObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraInfoObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraInfoObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onCameraInfoUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraInfoObserver_OnCameraInfoUpdated_ParamsSpec.$, null, this.onCameraInfoUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class StillCaptureResultObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.StillCaptureResultObserver', scope);
    }
}
export class StillCaptureResultObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(StillCaptureResultObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onStillCaptureDone(effect, status, blob) {
        this.proxy.sendMessage(0, StillCaptureResultObserver_OnStillCaptureDone_ParamsSpec.$, null, [
            effect,
            status,
            blob
        ], false);
    }
}
;
/**
 * An object which receives request messages for the StillCaptureResultObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StillCaptureResultObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StillCaptureResultObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, StillCaptureResultObserver_OnStillCaptureDone_ParamsSpec.$, null, impl.onStillCaptureDone.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class StillCaptureResultObserver {
    static get $interfaceName() {
        return "cros.mojom.StillCaptureResultObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new StillCaptureResultObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the StillCaptureResultObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StillCaptureResultObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StillCaptureResultObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onStillCaptureDone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, StillCaptureResultObserver_OnStillCaptureDone_ParamsSpec.$, null, this.onStillCaptureDone.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const CameraAppDeviceProvider_GetCameraAppDevice_ParamsSpec = { $: {} };
export const CameraAppDeviceProvider_GetCameraAppDevice_ResponseParamsSpec = { $: {} };
export const CameraAppDeviceProvider_IsSupported_ParamsSpec = { $: {} };
export const CameraAppDeviceProvider_IsSupported_ResponseParamsSpec = { $: {} };
export const CameraAppDeviceProvider_IsDeviceInUse_ParamsSpec = { $: {} };
export const CameraAppDeviceProvider_IsDeviceInUse_ResponseParamsSpec = { $: {} };
export const CameraAppDeviceBridge_GetCameraAppDevice_ParamsSpec = { $: {} };
export const CameraAppDeviceBridge_GetCameraAppDevice_ResponseParamsSpec = { $: {} };
export const CameraAppDeviceBridge_IsSupported_ParamsSpec = { $: {} };
export const CameraAppDeviceBridge_IsSupported_ResponseParamsSpec = { $: {} };
export const CameraAppDeviceBridge_SetVirtualDeviceEnabled_ParamsSpec = { $: {} };
export const CameraAppDeviceBridge_SetVirtualDeviceEnabled_ResponseParamsSpec = { $: {} };
export const CameraAppDeviceBridge_IsDeviceInUse_ParamsSpec = { $: {} };
export const CameraAppDeviceBridge_IsDeviceInUse_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_TakePortraitModePhoto_ParamsSpec = { $: {} };
export const CameraAppDevice_TakePortraitModePhoto_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_SetFpsRange_ParamsSpec = { $: {} };
export const CameraAppDevice_SetFpsRange_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_SetStillCaptureResolution_ParamsSpec = { $: {} };
export const CameraAppDevice_SetStillCaptureResolution_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_SetCaptureIntent_ParamsSpec = { $: {} };
export const CameraAppDevice_SetCaptureIntent_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_AddResultMetadataObserver_ParamsSpec = { $: {} };
export const CameraAppDevice_AddResultMetadataObserver_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_AddCameraEventObserver_ParamsSpec = { $: {} };
export const CameraAppDevice_AddCameraEventObserver_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ParamsSpec = { $: {} };
export const CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_GetCameraFrameRotation_ParamsSpec = { $: {} };
export const CameraAppDevice_GetCameraFrameRotation_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_RegisterDocumentCornersObserver_ParamsSpec = { $: {} };
export const CameraAppDevice_RegisterDocumentCornersObserver_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_SetMultipleStreamsEnabled_ParamsSpec = { $: {} };
export const CameraAppDevice_SetMultipleStreamsEnabled_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_RegisterCameraInfoObserver_ParamsSpec = { $: {} };
export const CameraAppDevice_RegisterCameraInfoObserver_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_SetCropRegion_ParamsSpec = { $: {} };
export const CameraAppDevice_SetCropRegion_ResponseParamsSpec = { $: {} };
export const CameraAppDevice_ResetCropRegion_ParamsSpec = { $: {} };
export const CameraAppDevice_ResetCropRegion_ResponseParamsSpec = { $: {} };
export const ResultMetadataObserver_OnMetadataAvailable_ParamsSpec = { $: {} };
export const CameraEventObserver_OnShutterDone_ParamsSpec = { $: {} };
export const DocumentCornersObserver_OnDocumentCornersUpdated_ParamsSpec = { $: {} };
export const CameraInfoObserver_OnCameraInfoUpdated_ParamsSpec = { $: {} };
export const StillCaptureResultObserver_OnStillCaptureDone_ParamsSpec = { $: {} };
mojo.internal.Struct(CameraAppDeviceProvider_GetCameraAppDevice_ParamsSpec.$, 'CameraAppDeviceProvider_GetCameraAppDevice_Params', [
    mojo.internal.StructField('sourceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceProvider_GetCameraAppDevice_ResponseParamsSpec.$, 'CameraAppDeviceProvider_GetCameraAppDevice_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, GetCameraAppDeviceStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('device', 4, 0, mojo.internal.InterfaceProxy(CameraAppDeviceRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppDeviceProvider_IsSupported_ParamsSpec.$, 'CameraAppDeviceProvider_IsSupported_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDeviceProvider_IsSupported_ResponseParamsSpec.$, 'CameraAppDeviceProvider_IsSupported_ResponseParams', [
    mojo.internal.StructField('isSupported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceProvider_IsDeviceInUse_ParamsSpec.$, 'CameraAppDeviceProvider_IsDeviceInUse_Params', [
    mojo.internal.StructField('sourceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceProvider_IsDeviceInUse_ResponseParamsSpec.$, 'CameraAppDeviceProvider_IsDeviceInUse_ResponseParams', [
    mojo.internal.StructField('inUse', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceBridge_GetCameraAppDevice_ParamsSpec.$, 'CameraAppDeviceBridge_GetCameraAppDevice_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceBridge_GetCameraAppDevice_ResponseParamsSpec.$, 'CameraAppDeviceBridge_GetCameraAppDevice_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, GetCameraAppDeviceStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('device', 4, 0, mojo.internal.InterfaceProxy(CameraAppDeviceRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppDeviceBridge_IsSupported_ParamsSpec.$, 'CameraAppDeviceBridge_IsSupported_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDeviceBridge_IsSupported_ResponseParamsSpec.$, 'CameraAppDeviceBridge_IsSupported_ResponseParams', [
    mojo.internal.StructField('isSupported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceBridge_SetVirtualDeviceEnabled_ParamsSpec.$, 'CameraAppDeviceBridge_SetVirtualDeviceEnabled_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enabled', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppDeviceBridge_SetVirtualDeviceEnabled_ResponseParamsSpec.$, 'CameraAppDeviceBridge_SetVirtualDeviceEnabled_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceBridge_IsDeviceInUse_ParamsSpec.$, 'CameraAppDeviceBridge_IsDeviceInUse_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDeviceBridge_IsDeviceInUse_ResponseParamsSpec.$, 'CameraAppDeviceBridge_IsDeviceInUse_ResponseParams', [
    mojo.internal.StructField('inUse', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_TakePortraitModePhoto_ParamsSpec.$, 'CameraAppDevice_TakePortraitModePhoto_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(StillCaptureResultObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_TakePortraitModePhoto_ResponseParamsSpec.$, 'CameraAppDevice_TakePortraitModePhoto_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_SetFpsRange_ParamsSpec.$, 'CameraAppDevice_SetFpsRange_Params', [
    mojo.internal.StructField('fpsRange', 0, 0, gfx_mojom_RangeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetFpsRange_ResponseParamsSpec.$, 'CameraAppDevice_SetFpsRange_ResponseParams', [
    mojo.internal.StructField('isSuccess', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetStillCaptureResolution_ParamsSpec.$, 'CameraAppDevice_SetStillCaptureResolution_Params', [
    mojo.internal.StructField('resolution', 0, 0, gfx_mojom_SizeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetStillCaptureResolution_ResponseParamsSpec.$, 'CameraAppDevice_SetStillCaptureResolution_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_SetCaptureIntent_ParamsSpec.$, 'CameraAppDevice_SetCaptureIntent_Params', [
    mojo.internal.StructField('intent', 0, 0, CaptureIntentSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetCaptureIntent_ResponseParamsSpec.$, 'CameraAppDevice_SetCaptureIntent_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_AddResultMetadataObserver_ParamsSpec.$, 'CameraAppDevice_AddResultMetadataObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ResultMetadataObserverRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('streamType', 8, 0, StreamTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraAppDevice_AddResultMetadataObserver_ResponseParamsSpec.$, 'CameraAppDevice_AddResultMetadataObserver_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_AddCameraEventObserver_ParamsSpec.$, 'CameraAppDevice_AddCameraEventObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(CameraEventObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_AddCameraEventObserver_ResponseParamsSpec.$, 'CameraAppDevice_AddCameraEventObserver_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ParamsSpec.$, 'CameraAppDevice_SetCameraFrameRotationEnabledAtSource_Params', [
    mojo.internal.StructField('isEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ResponseParamsSpec.$, 'CameraAppDevice_SetCameraFrameRotationEnabledAtSource_ResponseParams', [
    mojo.internal.StructField('isSuccess', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_GetCameraFrameRotation_ParamsSpec.$, 'CameraAppDevice_GetCameraFrameRotation_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_GetCameraFrameRotation_ResponseParamsSpec.$, 'CameraAppDevice_GetCameraFrameRotation_ResponseParams', [
    mojo.internal.StructField('rotation', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_RegisterDocumentCornersObserver_ParamsSpec.$, 'CameraAppDevice_RegisterDocumentCornersObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(DocumentCornersObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_RegisterDocumentCornersObserver_ResponseParamsSpec.$, 'CameraAppDevice_RegisterDocumentCornersObserver_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_SetMultipleStreamsEnabled_ParamsSpec.$, 'CameraAppDevice_SetMultipleStreamsEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetMultipleStreamsEnabled_ResponseParamsSpec.$, 'CameraAppDevice_SetMultipleStreamsEnabled_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_RegisterCameraInfoObserver_ParamsSpec.$, 'CameraAppDevice_RegisterCameraInfoObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(CameraInfoObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_RegisterCameraInfoObserver_ResponseParamsSpec.$, 'CameraAppDevice_RegisterCameraInfoObserver_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_SetCropRegion_ParamsSpec.$, 'CameraAppDevice_SetCropRegion_Params', [
    mojo.internal.StructField('cropRegion', 0, 0, gfx_mojom_RectSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraAppDevice_SetCropRegion_ResponseParamsSpec.$, 'CameraAppDevice_SetCropRegion_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_ResetCropRegion_ParamsSpec.$, 'CameraAppDevice_ResetCropRegion_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraAppDevice_ResetCropRegion_ResponseParamsSpec.$, 'CameraAppDevice_ResetCropRegion_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(ResultMetadataObserver_OnMetadataAvailable_ParamsSpec.$, 'ResultMetadataObserver_OnMetadataAvailable_Params', [
    mojo.internal.StructField('cameraMetadata', 0, 0, cros_mojom_CameraMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraEventObserver_OnShutterDone_ParamsSpec.$, 'CameraEventObserver_OnShutterDone_Params', [], [[0, 8],]);
mojo.internal.Struct(DocumentCornersObserver_OnDocumentCornersUpdated_ParamsSpec.$, 'DocumentCornersObserver_OnDocumentCornersUpdated_Params', [
    mojo.internal.StructField('corners', 0, 0, mojo.internal.Array(gfx_mojom_PointFSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraInfoObserver_OnCameraInfoUpdated_ParamsSpec.$, 'CameraInfoObserver_OnCameraInfoUpdated_Params', [
    mojo.internal.StructField('cameraInfo', 0, 0, cros_mojom_CameraInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(StillCaptureResultObserver_OnStillCaptureDone_ParamsSpec.$, 'StillCaptureResultObserver_OnStillCaptureDone_Params', [
    mojo.internal.StructField('effect', 0, 0, EffectSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('status', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('blob', 8, 0, media_mojom_BlobSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
