// media/capture/video/chromeos/mojom/camera_common.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Camera3DeviceOpsPendingReceiver as cros_mojom_Camera3DeviceOpsPendingReceiver } from './camera3.mojom-webui.js';
import { CameraMetadataSpec as cros_mojom_CameraMetadataSpec } from './camera_metadata.mojom-webui.js';
export const CAMERA_DEVICE_API_VERSION_3_0 = 0x300;
export const CAMERA_DEVICE_API_VERSION_3_1 = 0x301;
export const CAMERA_DEVICE_API_VERSION_3_2 = 0x302;
export const CAMERA_DEVICE_API_VERSION_3_3 = 0x303;
export const CAMERA_DEVICE_API_VERSION_3_4 = 0x304;
export const CAMERA_DEVICE_API_VERSION_3_5 = 0x305;
export const CAMERA_DEVICE_API_VERSION_3_6 = 0x306;
export const CameraFacingSpec = { $: mojo.internal.Enum() };
export var CameraFacing;
(function (CameraFacing) {
    CameraFacing[CameraFacing["MIN_VALUE"] = 0] = "MIN_VALUE";
    CameraFacing[CameraFacing["MAX_VALUE"] = 5] = "MAX_VALUE";
    CameraFacing[CameraFacing["CAMERA_FACING_BACK"] = 0] = "CAMERA_FACING_BACK";
    CameraFacing[CameraFacing["CAMERA_FACING_FRONT"] = 1] = "CAMERA_FACING_FRONT";
    CameraFacing[CameraFacing["CAMERA_FACING_EXTERNAL"] = 2] = "CAMERA_FACING_EXTERNAL";
    CameraFacing[CameraFacing["CAMERA_FACING_VIRTUAL_BACK"] = 3] = "CAMERA_FACING_VIRTUAL_BACK";
    CameraFacing[CameraFacing["CAMERA_FACING_VIRTUAL_FRONT"] = 4] = "CAMERA_FACING_VIRTUAL_FRONT";
    CameraFacing[CameraFacing["CAMERA_FACING_VIRTUAL_EXTERNAL"] = 5] = "CAMERA_FACING_VIRTUAL_EXTERNAL";
})(CameraFacing || (CameraFacing = {}));
export const CameraDeviceStatusSpec = { $: mojo.internal.Enum() };
export var CameraDeviceStatus;
(function (CameraDeviceStatus) {
    CameraDeviceStatus[CameraDeviceStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    CameraDeviceStatus[CameraDeviceStatus["MAX_VALUE"] = 2] = "MAX_VALUE";
    CameraDeviceStatus[CameraDeviceStatus["CAMERA_DEVICE_STATUS_NOT_PRESENT"] = 0] = "CAMERA_DEVICE_STATUS_NOT_PRESENT";
    CameraDeviceStatus[CameraDeviceStatus["CAMERA_DEVICE_STATUS_PRESENT"] = 1] = "CAMERA_DEVICE_STATUS_PRESENT";
    CameraDeviceStatus[CameraDeviceStatus["CAMERA_DEVICE_STATUS_ENUMERATING"] = 2] = "CAMERA_DEVICE_STATUS_ENUMERATING";
})(CameraDeviceStatus || (CameraDeviceStatus = {}));
export const TorchModeStatusSpec = { $: mojo.internal.Enum() };
export var TorchModeStatus;
(function (TorchModeStatus) {
    TorchModeStatus[TorchModeStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    TorchModeStatus[TorchModeStatus["MAX_VALUE"] = 2] = "MAX_VALUE";
    TorchModeStatus[TorchModeStatus["TORCH_MODE_STATUS_NOT_AVAILABLE"] = 0] = "TORCH_MODE_STATUS_NOT_AVAILABLE";
    TorchModeStatus[TorchModeStatus["TORCH_MODE_STATUS_AVAILABLE_OFF"] = 1] = "TORCH_MODE_STATUS_AVAILABLE_OFF";
    TorchModeStatus[TorchModeStatus["TORCH_MODE_STATUS_AVAILABLE_ON"] = 2] = "TORCH_MODE_STATUS_AVAILABLE_ON";
})(TorchModeStatus || (TorchModeStatus = {}));
export class CameraModuleCallbacksPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraModuleCallbacks', scope);
    }
}
export class CameraModuleCallbacksRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraModuleCallbacksPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    cameraDeviceStatusChange(cameraId, newStatus) {
        this.proxy.sendMessage(0, CameraModuleCallbacks_CameraDeviceStatusChange_ParamsSpec.$, null, [
            cameraId,
            newStatus
        ], false);
    }
    torchModeStatusChange(cameraId, newStatus) {
        this.proxy.sendMessage(1, CameraModuleCallbacks_TorchModeStatusChange_ParamsSpec.$, null, [
            cameraId,
            newStatus
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CameraModuleCallbacks
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraModuleCallbacksReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraModuleCallbacksRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraModuleCallbacks_CameraDeviceStatusChange_ParamsSpec.$, null, impl.cameraDeviceStatusChange.bind(impl), false);
        this.helper_internal_.registerHandler(1, CameraModuleCallbacks_TorchModeStatusChange_ParamsSpec.$, null, impl.torchModeStatusChange.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraModuleCallbacks {
    static get $interfaceName() {
        return "cros.mojom.CameraModuleCallbacks";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraModuleCallbacksRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraModuleCallbacks
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraModuleCallbacksCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraModuleCallbacksRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.cameraDeviceStatusChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraModuleCallbacks_CameraDeviceStatusChange_ParamsSpec.$, null, this.cameraDeviceStatusChange.createReceiverHandler(false /* expectsResponse */), false);
        this.torchModeStatusChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CameraModuleCallbacks_TorchModeStatusChange_ParamsSpec.$, null, this.torchModeStatusChange.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class VendorTagOpsPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.VendorTagOps', scope);
    }
}
export class VendorTagOpsRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(VendorTagOpsPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getTagCount() {
        return this.proxy.sendMessage(0, VendorTagOps_GetTagCount_ParamsSpec.$, VendorTagOps_GetTagCount_ResponseParamsSpec.$, [], false);
    }
    getAllTags() {
        return this.proxy.sendMessage(1, VendorTagOps_GetAllTags_ParamsSpec.$, VendorTagOps_GetAllTags_ResponseParamsSpec.$, [], false);
    }
    getSectionName(tag) {
        return this.proxy.sendMessage(2, VendorTagOps_GetSectionName_ParamsSpec.$, VendorTagOps_GetSectionName_ResponseParamsSpec.$, [
            tag
        ], false);
    }
    getTagName(tag) {
        return this.proxy.sendMessage(3, VendorTagOps_GetTagName_ParamsSpec.$, VendorTagOps_GetTagName_ResponseParamsSpec.$, [
            tag
        ], false);
    }
    getTagType(tag) {
        return this.proxy.sendMessage(4, VendorTagOps_GetTagType_ParamsSpec.$, VendorTagOps_GetTagType_ResponseParamsSpec.$, [
            tag
        ], false);
    }
}
;
/**
 * An object which receives request messages for the VendorTagOps
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VendorTagOpsReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(VendorTagOpsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, VendorTagOps_GetTagCount_ParamsSpec.$, VendorTagOps_GetTagCount_ResponseParamsSpec.$, impl.getTagCount.bind(impl), false);
        this.helper_internal_.registerHandler(1, VendorTagOps_GetAllTags_ParamsSpec.$, VendorTagOps_GetAllTags_ResponseParamsSpec.$, impl.getAllTags.bind(impl), false);
        this.helper_internal_.registerHandler(2, VendorTagOps_GetSectionName_ParamsSpec.$, VendorTagOps_GetSectionName_ResponseParamsSpec.$, impl.getSectionName.bind(impl), false);
        this.helper_internal_.registerHandler(3, VendorTagOps_GetTagName_ParamsSpec.$, VendorTagOps_GetTagName_ResponseParamsSpec.$, impl.getTagName.bind(impl), false);
        this.helper_internal_.registerHandler(4, VendorTagOps_GetTagType_ParamsSpec.$, VendorTagOps_GetTagType_ResponseParamsSpec.$, impl.getTagType.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class VendorTagOps {
    static get $interfaceName() {
        return "cros.mojom.VendorTagOps";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new VendorTagOpsRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the VendorTagOps
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VendorTagOpsCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(VendorTagOpsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getTagCount =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, VendorTagOps_GetTagCount_ParamsSpec.$, VendorTagOps_GetTagCount_ResponseParamsSpec.$, this.getTagCount.createReceiverHandler(true /* expectsResponse */), false);
        this.getAllTags =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, VendorTagOps_GetAllTags_ParamsSpec.$, VendorTagOps_GetAllTags_ResponseParamsSpec.$, this.getAllTags.createReceiverHandler(true /* expectsResponse */), false);
        this.getSectionName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, VendorTagOps_GetSectionName_ParamsSpec.$, VendorTagOps_GetSectionName_ResponseParamsSpec.$, this.getSectionName.createReceiverHandler(true /* expectsResponse */), false);
        this.getTagName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, VendorTagOps_GetTagName_ParamsSpec.$, VendorTagOps_GetTagName_ResponseParamsSpec.$, this.getTagName.createReceiverHandler(true /* expectsResponse */), false);
        this.getTagType =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, VendorTagOps_GetTagType_ParamsSpec.$, VendorTagOps_GetTagType_ResponseParamsSpec.$, this.getTagType.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CameraModulePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'cros.mojom.CameraModule', scope);
    }
}
export class CameraModuleRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CameraModulePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    openDevice(cameraId, deviceOpsReceiver) {
        return this.proxy.sendMessage(0, CameraModule_OpenDevice_ParamsSpec.$, CameraModule_OpenDevice_ResponseParamsSpec.$, [
            cameraId,
            deviceOpsReceiver
        ], false);
    }
    getNumberOfCameras() {
        return this.proxy.sendMessage(1, CameraModule_GetNumberOfCameras_ParamsSpec.$, CameraModule_GetNumberOfCameras_ResponseParamsSpec.$, [], false);
    }
    getCameraInfo(cameraId) {
        return this.proxy.sendMessage(2, CameraModule_GetCameraInfo_ParamsSpec.$, CameraModule_GetCameraInfo_ResponseParamsSpec.$, [
            cameraId
        ], false);
    }
    setCallbacks(callbacks) {
        return this.proxy.sendMessage(3, CameraModule_SetCallbacks_ParamsSpec.$, CameraModule_SetCallbacks_ResponseParamsSpec.$, [
            callbacks
        ], false);
    }
    setTorchMode(cameraId, enabled) {
        return this.proxy.sendMessage(4, CameraModule_SetTorchMode_ParamsSpec.$, CameraModule_SetTorchMode_ResponseParamsSpec.$, [
            cameraId,
            enabled
        ], false);
    }
    init() {
        return this.proxy.sendMessage(5, CameraModule_Init_ParamsSpec.$, CameraModule_Init_ResponseParamsSpec.$, [], false);
    }
    getVendorTagOps(vendorTagOpsReceiver) {
        return this.proxy.sendMessage(6, CameraModule_GetVendorTagOps_ParamsSpec.$, CameraModule_GetVendorTagOps_ResponseParamsSpec.$, [
            vendorTagOpsReceiver
        ], false);
    }
    setCallbacksAssociated(callbacks) {
        return this.proxy.sendMessage(7, CameraModule_SetCallbacksAssociated_ParamsSpec.$, CameraModule_SetCallbacksAssociated_ResponseParamsSpec.$, [
            callbacks
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CameraModule
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CameraModuleReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraModuleRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CameraModule_OpenDevice_ParamsSpec.$, CameraModule_OpenDevice_ResponseParamsSpec.$, impl.openDevice.bind(impl), false);
        this.helper_internal_.registerHandler(1, CameraModule_GetNumberOfCameras_ParamsSpec.$, CameraModule_GetNumberOfCameras_ResponseParamsSpec.$, impl.getNumberOfCameras.bind(impl), false);
        this.helper_internal_.registerHandler(2, CameraModule_GetCameraInfo_ParamsSpec.$, CameraModule_GetCameraInfo_ResponseParamsSpec.$, impl.getCameraInfo.bind(impl), false);
        this.helper_internal_.registerHandler(3, CameraModule_SetCallbacks_ParamsSpec.$, CameraModule_SetCallbacks_ResponseParamsSpec.$, impl.setCallbacks.bind(impl), false);
        this.helper_internal_.registerHandler(4, CameraModule_SetTorchMode_ParamsSpec.$, CameraModule_SetTorchMode_ResponseParamsSpec.$, impl.setTorchMode.bind(impl), false);
        this.helper_internal_.registerHandler(5, CameraModule_Init_ParamsSpec.$, CameraModule_Init_ResponseParamsSpec.$, impl.init.bind(impl), false);
        this.helper_internal_.registerHandler(6, CameraModule_GetVendorTagOps_ParamsSpec.$, CameraModule_GetVendorTagOps_ResponseParamsSpec.$, impl.getVendorTagOps.bind(impl), false);
        this.helper_internal_.registerHandler(7, CameraModule_SetCallbacksAssociated_ParamsSpec.$, CameraModule_SetCallbacksAssociated_ResponseParamsSpec.$, impl.setCallbacksAssociated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CameraModule {
    static get $interfaceName() {
        return "cros.mojom.CameraModule";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CameraModuleRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CameraModule
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CameraModuleCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CameraModuleRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.openDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CameraModule_OpenDevice_ParamsSpec.$, CameraModule_OpenDevice_ResponseParamsSpec.$, this.openDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.getNumberOfCameras =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CameraModule_GetNumberOfCameras_ParamsSpec.$, CameraModule_GetNumberOfCameras_ResponseParamsSpec.$, this.getNumberOfCameras.createReceiverHandler(true /* expectsResponse */), false);
        this.getCameraInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CameraModule_GetCameraInfo_ParamsSpec.$, CameraModule_GetCameraInfo_ResponseParamsSpec.$, this.getCameraInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.setCallbacks =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CameraModule_SetCallbacks_ParamsSpec.$, CameraModule_SetCallbacks_ResponseParamsSpec.$, this.setCallbacks.createReceiverHandler(true /* expectsResponse */), false);
        this.setTorchMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CameraModule_SetTorchMode_ParamsSpec.$, CameraModule_SetTorchMode_ResponseParamsSpec.$, this.setTorchMode.createReceiverHandler(true /* expectsResponse */), false);
        this.init =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CameraModule_Init_ParamsSpec.$, CameraModule_Init_ResponseParamsSpec.$, this.init.createReceiverHandler(true /* expectsResponse */), false);
        this.getVendorTagOps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CameraModule_GetVendorTagOps_ParamsSpec.$, CameraModule_GetVendorTagOps_ResponseParamsSpec.$, this.getVendorTagOps.createReceiverHandler(true /* expectsResponse */), false);
        this.setCallbacksAssociated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CameraModule_SetCallbacksAssociated_ParamsSpec.$, CameraModule_SetCallbacksAssociated_ResponseParamsSpec.$, this.setCallbacksAssociated.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const CameraResourceCostSpec = { $: {} };
export const CameraInfoSpec = { $: {} };
export const CameraModuleCallbacks_CameraDeviceStatusChange_ParamsSpec = { $: {} };
export const CameraModuleCallbacks_TorchModeStatusChange_ParamsSpec = { $: {} };
export const VendorTagOps_GetTagCount_ParamsSpec = { $: {} };
export const VendorTagOps_GetTagCount_ResponseParamsSpec = { $: {} };
export const VendorTagOps_GetAllTags_ParamsSpec = { $: {} };
export const VendorTagOps_GetAllTags_ResponseParamsSpec = { $: {} };
export const VendorTagOps_GetSectionName_ParamsSpec = { $: {} };
export const VendorTagOps_GetSectionName_ResponseParamsSpec = { $: {} };
export const VendorTagOps_GetTagName_ParamsSpec = { $: {} };
export const VendorTagOps_GetTagName_ResponseParamsSpec = { $: {} };
export const VendorTagOps_GetTagType_ParamsSpec = { $: {} };
export const VendorTagOps_GetTagType_ResponseParamsSpec = { $: {} };
export const CameraModule_OpenDevice_ParamsSpec = { $: {} };
export const CameraModule_OpenDevice_ResponseParamsSpec = { $: {} };
export const CameraModule_GetNumberOfCameras_ParamsSpec = { $: {} };
export const CameraModule_GetNumberOfCameras_ResponseParamsSpec = { $: {} };
export const CameraModule_GetCameraInfo_ParamsSpec = { $: {} };
export const CameraModule_GetCameraInfo_ResponseParamsSpec = { $: {} };
export const CameraModule_SetCallbacks_ParamsSpec = { $: {} };
export const CameraModule_SetCallbacks_ResponseParamsSpec = { $: {} };
export const CameraModule_SetTorchMode_ParamsSpec = { $: {} };
export const CameraModule_SetTorchMode_ResponseParamsSpec = { $: {} };
export const CameraModule_Init_ParamsSpec = { $: {} };
export const CameraModule_Init_ResponseParamsSpec = { $: {} };
export const CameraModule_GetVendorTagOps_ParamsSpec = { $: {} };
export const CameraModule_GetVendorTagOps_ResponseParamsSpec = { $: {} };
export const CameraModule_SetCallbacksAssociated_ParamsSpec = { $: {} };
export const CameraModule_SetCallbacksAssociated_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(CameraResourceCostSpec.$, 'CameraResourceCost', [
    mojo.internal.StructField('resourceCost', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraInfoSpec.$, 'CameraInfo', [
    mojo.internal.StructField('facing', 0, 0, CameraFacingSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('orientation', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceVersion', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('staticCameraCharacteristics', 16, 0, cros_mojom_CameraMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resourceCost', 24, 0, CameraResourceCostSpec.$, null, true /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('conflictingDevices', 32, 0, mojo.internal.Array(mojo.internal.String, false), null, true /* nullable */, 1, undefined, undefined),
], [[0, 32], [1, 48],]);
mojo.internal.Struct(CameraModuleCallbacks_CameraDeviceStatusChange_ParamsSpec.$, 'CameraModuleCallbacks_CameraDeviceStatusChange_Params', [
    mojo.internal.StructField('cameraId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('newStatus', 4, 0, CameraDeviceStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModuleCallbacks_TorchModeStatusChange_ParamsSpec.$, 'CameraModuleCallbacks_TorchModeStatusChange_Params', [
    mojo.internal.StructField('cameraId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('newStatus', 4, 0, TorchModeStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetTagCount_ParamsSpec.$, 'VendorTagOps_GetTagCount_Params', [], [[0, 8],]);
mojo.internal.Struct(VendorTagOps_GetTagCount_ResponseParamsSpec.$, 'VendorTagOps_GetTagCount_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetAllTags_ParamsSpec.$, 'VendorTagOps_GetAllTags_Params', [], [[0, 8],]);
mojo.internal.Struct(VendorTagOps_GetAllTags_ResponseParamsSpec.$, 'VendorTagOps_GetAllTags_ResponseParams', [
    mojo.internal.StructField('tagArray', 0, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetSectionName_ParamsSpec.$, 'VendorTagOps_GetSectionName_Params', [
    mojo.internal.StructField('tag', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetSectionName_ResponseParamsSpec.$, 'VendorTagOps_GetSectionName_ResponseParams', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetTagName_ParamsSpec.$, 'VendorTagOps_GetTagName_Params', [
    mojo.internal.StructField('tag', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetTagName_ResponseParamsSpec.$, 'VendorTagOps_GetTagName_ResponseParams', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetTagType_ParamsSpec.$, 'VendorTagOps_GetTagType_Params', [
    mojo.internal.StructField('tag', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VendorTagOps_GetTagType_ResponseParamsSpec.$, 'VendorTagOps_GetTagType_ResponseParams', [
    mojo.internal.StructField('type', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_OpenDevice_ParamsSpec.$, 'CameraModule_OpenDevice_Params', [
    mojo.internal.StructField('cameraId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceOpsReceiver', 4, 0, mojo.internal.InterfaceRequest(cros_mojom_Camera3DeviceOpsPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_OpenDevice_ResponseParamsSpec.$, 'CameraModule_OpenDevice_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_GetNumberOfCameras_ParamsSpec.$, 'CameraModule_GetNumberOfCameras_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraModule_GetNumberOfCameras_ResponseParamsSpec.$, 'CameraModule_GetNumberOfCameras_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_GetCameraInfo_ParamsSpec.$, 'CameraModule_GetCameraInfo_Params', [
    mojo.internal.StructField('cameraId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_GetCameraInfo_ResponseParamsSpec.$, 'CameraModule_GetCameraInfo_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cameraInfo', 8, 0, CameraInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CameraModule_SetCallbacks_ParamsSpec.$, 'CameraModule_SetCallbacks_Params', [
    mojo.internal.StructField('callbacks', 0, 0, mojo.internal.InterfaceProxy(CameraModuleCallbacksRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_SetCallbacks_ResponseParamsSpec.$, 'CameraModule_SetCallbacks_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_SetTorchMode_ParamsSpec.$, 'CameraModule_SetTorchMode_Params', [
    mojo.internal.StructField('cameraId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enabled', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_SetTorchMode_ResponseParamsSpec.$, 'CameraModule_SetTorchMode_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_Init_ParamsSpec.$, 'CameraModule_Init_Params', [], [[0, 8],]);
mojo.internal.Struct(CameraModule_Init_ResponseParamsSpec.$, 'CameraModule_Init_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_GetVendorTagOps_ParamsSpec.$, 'CameraModule_GetVendorTagOps_Params', [
    mojo.internal.StructField('vendorTagOpsReceiver', 0, 0, mojo.internal.InterfaceRequest(VendorTagOpsPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_GetVendorTagOps_ResponseParamsSpec.$, 'CameraModule_GetVendorTagOps_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(CameraModule_SetCallbacksAssociated_ParamsSpec.$, 'CameraModule_SetCallbacksAssociated_Params', [
    mojo.internal.StructField('callbacks', 0, 0, mojo.internal.AssociatedInterfaceProxy(CameraModuleCallbacksRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CameraModule_SetCallbacksAssociated_ResponseParamsSpec.$, 'CameraModule_SetCallbacksAssociated_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
