// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{COLOR_PROVIDER_CHANGED,ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{assert}from"chrome://resources/js/assert.js";import{getRGBAFromComputedStyle}from"./utils.js";import{startObservingWallpaperColors}from"./wallpaper_colors.js";const CROS_TOKENS_JSON_URL="color_internals_tokens.json";function appendTokenRowToTable(table,token){const newRow=table.insertRow();function appendColorCell(color){const colorSwatch=document.createElement("span");const cell=document.createElement("td");const text=document.createElement("span");colorSwatch.classList.add("color-swatch");colorSwatch.style.backgroundColor=color;cell.classList.add("monospace");cell.appendChild(colorSwatch);newRow.append(cell);text.textContent=getRGBAFromComputedStyle(colorSwatch);cell.appendChild(text)}function appendFormulaCell(formula){const cell=document.createElement("td");cell.textContent=formula;newRow.append(cell)}const header=document.createElement("td");header.textContent=token.token_name;header.classList.add("monospace");newRow.append(header);const cssVariableString=`var(${token.css_variable})`;appendColorCell(cssVariableString);if(token.mode_values){appendFormulaCell(token.mode_values.light);appendFormulaCell(token.mode_values.dark)}}async function requestJSON(){return new Promise((function(resolve,reject){const xhr=new XMLHttpRequest;xhr.open("GET",CROS_TOKENS_JSON_URL,true);xhr.responseType="json";xhr.onload=()=>{resolve(xhr.response)};xhr.onerror=()=>{reject(xhr.response)};xhr.send()}))}async function populateTokenTable(){function addTokens(table,tokens){Object.values(tokens).forEach((t=>appendTokenRowToTable(table,t)))}const json=await requestJSON();const tokens=json;const refTable=document.querySelector("table#ref-tokens").querySelector("tbody");const sysTable=document.querySelector("table#sys-tokens").querySelector("tbody");addTokens(refTable,tokens.ref_tokens);addTokens(sysTable,tokens.sys_tokens)}function onColorChange(){const formatter=new Intl.DateTimeFormat("en",{hour:"numeric",minute:"numeric",second:"numeric"});const span=document.querySelector("#last-updated");assert(span);span.innerText=formatter.format(new Date)}window.onload=()=>{populateTokenTable();ColorChangeUpdater.forDocument().start();startObservingWallpaperColors();ColorChangeUpdater.forDocument().eventTarget.addEventListener(COLOR_PROVIDER_CHANGED,onColorChange);onColorChange()};