// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-flex-layout/iron-flex-layout-classes.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import"//resources/ash/common/cr_elements/cr_input/cr_input.js";import"./base_page.js";import"./cellular_setup_icons.html.js";import{I18nMixin}from"//resources/ash/common/cr_elements/i18n_mixin.js";import{MojoInterfaceProviderImpl}from"//resources/ash/common/network/mojo_interface_provider.js";import{assert}from"//resources/js/assert.js";import{focusWithoutInk}from"//resources/js/focus_without_ink.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{NetworkType}from"//resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js";import{afterNextRender,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./activation_code_page.html.js";const QR_CODE_DETECTION_INTERVAL_MS=1e3;var PageState;(function(PageState){PageState[PageState["MANUAL_ENTRY"]=1]="MANUAL_ENTRY";PageState[PageState["SCANNING_USER_FACING"]=2]="SCANNING_USER_FACING";PageState[PageState["SCANNING_ENVIRONMENT_FACING"]=3]="SCANNING_ENVIRONMENT_FACING";PageState[PageState["SWITCHING_CAM_USER_TO_ENVIRONMENT"]=4]="SWITCHING_CAM_USER_TO_ENVIRONMENT";PageState[PageState["SWITCHING_CAM_ENVIRONMENT_TO_USER"]=5]="SWITCHING_CAM_ENVIRONMENT_TO_USER";PageState[PageState["SCANNING_SUCCESS"]=6]="SCANNING_SUCCESS";PageState[PageState["SCANNING_FAILURE"]=7]="SCANNING_FAILURE";PageState[PageState["MANUAL_ENTRY_INSTALL_FAILURE"]=8]="MANUAL_ENTRY_INSTALL_FAILURE";PageState[PageState["SCANNING_INSTALL_FAILURE"]=9]="SCANNING_INSTALL_FAILURE"})(PageState||(PageState={}));var UiElement;(function(UiElement){UiElement[UiElement["START_SCANNING"]=1]="START_SCANNING";UiElement[UiElement["VIDEO"]=2]="VIDEO";UiElement[UiElement["SWITCH_CAMERA"]=3]="SWITCH_CAMERA";UiElement[UiElement["SCAN_FINISH"]=4]="SCAN_FINISH";UiElement[UiElement["SCAN_SUCCESS"]=5]="SCAN_SUCCESS";UiElement[UiElement["SCAN_FAILURE"]=6]="SCAN_FAILURE";UiElement[UiElement["CODE_DETECTED"]=7]="CODE_DETECTED";UiElement[UiElement["SCAN_INSTALL_FAILURE"]=8]="SCAN_INSTALL_FAILURE"})(UiElement||(UiElement={}));const QR_CODE_FORMAT="qr_code";const ACTIVATION_CODE_PREFIX="LPA:1$";const ActivationCodePageElementBase=I18nMixin(PolymerElement);export class ActivationCodePageElement extends ActivationCodePageElementBase{static get is(){return"activation-code-page"}static get template(){return getTemplate()}static get properties(){return{activationCode:{type:String,notify:true,observer:"onActivationCodeChanged_"},showError:{type:Boolean,notify:true,observer:"onShowErrorChanged_"},isFromQrCode:{type:Boolean,notify:true,value:false},showNoProfilesFound:{type:Boolean,notify:true},uiElementEnum_:{type:Object,value:UiElement},state_:{type:Object,value:PageState,observer:"onStateChanged_"},cameraCount_:{type:Number,value:0,observer:"onHasCameraCountChanged_"},qrCodeDetector_:{type:Object,value:null},expanded_:{type:Boolean,value:false,reflectToAttribute:true},qrCodeCameraA11yString_:{type:String,value:""},isDeviceCarrierLocked_:{type:Boolean,value:false},isActivationCodeInvalidFormat_:{type:Boolean,value:false}}}constructor(){super();this.qrCodeDetector_=null;this.networkConfig_=null;this.mediaDevices_=null;this.stream_=null;this.qrCodeDetectorTimer_=null;this.setIntervalFunction_=setInterval.bind(window);this.barcodeDetectorClass_=BarcodeDetector;this.imageCaptureClass_=ImageCapture;this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();this.networkConfig_.getDeviceStateList().then((response=>{const devices=response.result;const deviceState=devices.find((device=>device.type==NetworkType.kCellular))||null;if(deviceState){this.isDeviceCarrierLocked_=deviceState.isCarrierLocked}}))}ready(){super.ready();this.setMediaDevices(navigator.mediaDevices);this.initBarcodeDetector_();this.state_=PageState.MANUAL_ENTRY}disconnectedCallback(){super.disconnectedCallback();this.stopStream_(this.stream_);if(this.qrCodeDetectorTimer_){this.clearQrCodeDetectorTimer_()}this.mediaDevices_.removeEventListener("devicechange",this.updateCameraCount_.bind(this))}playVideo_(){const videoElement=this.shadowRoot.querySelector("#video");if(videoElement){assert(this.stream_);videoElement.srcObject=this.stream_;videoElement.play()}}stopStream_(stream){if(stream){for(const track of stream.getTracks()){track.stop()}}}isScanningAvailable_(){return this.cameraCount_>0&&!!this.qrCodeDetector_}shouldShowCarrierLockWarning_(){return this.isDeviceCarrierLocked_}async initBarcodeDetector_(){const formats=await this.barcodeDetectorClass_.getSupportedFormats();if(!formats||formats.length===0){this.qrCodeDetector_=null;return}const qrCodeFormat=formats.find((format=>format===QR_CODE_FORMAT));if(qrCodeFormat){this.qrCodeDetector_=new this.barcodeDetectorClass_({formats:[QR_CODE_FORMAT]})}}setMediaDevices(mediaDevices){this.mediaDevices_=mediaDevices;this.updateCameraCount_();this.mediaDevices_.addEventListener("devicechange",this.updateCameraCount_.bind(this))}async setFakesForTesting(barcodeDetectorClass,imageCaptureClass,setIntervalFunction,playVideoFunction){this.barcodeDetectorClass_=barcodeDetectorClass;await this.initBarcodeDetector_();this.imageCaptureClass_=imageCaptureClass;this.setIntervalFunction_=setIntervalFunction;this.playVideo_=playVideoFunction}getQrCodeDetectorTimerForTest(){return this.qrCodeDetectorTimer_}attemptToFocusOnPageContent(){if(this.isScanningAvailable_()){const useCameraBtn=this.shadowRoot.querySelector("#startScanningButton");if(useCameraBtn){useCameraBtn.focus();return true}}const activationCodeInput=this.shadowRoot.querySelector("#activationCode");if(activationCodeInput){activationCodeInput.focus();return true}return false}computeActivationCodeClass_(){return this.isScanningAvailable_()?"relative":"center"}updateCameraCount_(){if(!this.mediaDevices_||!this.mediaDevices_.enumerateDevices){this.cameraCount_=0;return}this.mediaDevices_.enumerateDevices().then((devices=>{this.cameraCount_=devices.filter((device=>device.kind==="videoinput")).length})).catch((()=>{this.cameraCount_=0}))}onHasCameraCountChanged_(){if(this.state_===PageState.SCANNING_ENVIRONMENT_FACING&&this.cameraCount_===1){this.state_=PageState.SWITCHING_CAM_ENVIRONMENT_TO_USER;this.startScanning_()}}startScanning_(){if(this.qrCodeDetectorTimer_){this.clearQrCodeDetectorTimer_()}if(this.stream_){this.stopStream_(this.stream_)}const useUserFacingCamera=this.state_!==PageState.SWITCHING_CAM_USER_TO_ENVIRONMENT;this.mediaDevices_.getUserMedia({video:{height:130,width:482,facingMode:useUserFacingCamera?"user":"environment"},audio:false}).then((stream=>{this.stream_=stream;if(this.stream_){this.playVideo_()}this.activationCode="";this.state_=useUserFacingCamera?PageState.SCANNING_USER_FACING:PageState.SCANNING_ENVIRONMENT_FACING;if(this.stream_){this.detectQrCode_()}})).catch((()=>{this.state_=PageState.SCANNING_FAILURE}))}detectQrCode_(){try{this.qrCodeDetectorTimer_=this.setIntervalFunction_((async()=>{assert(!!this.stream_);const capturer=new this.imageCaptureClass_(this.stream_.getVideoTracks()[0]);const frame=await capturer.grabFrame();const activationCode=await this.detectActivationCode_(frame);if(activationCode){if(this.qrCodeDetectorTimer_){this.clearQrCodeDetectorTimer_()}this.activationCode=activationCode;this.stopStream_(this.stream_);if(this.validateActivationCode_(activationCode)){this.state_=PageState.SCANNING_SUCCESS}else{this.state_=PageState.SCANNING_INSTALL_FAILURE}}}),QR_CODE_DETECTION_INTERVAL_MS)}catch(error){this.state_=PageState.SCANNING_FAILURE}}async detectActivationCode_(frame){if(!this.qrCodeDetector_){return null}const qrCodes=await this.qrCodeDetector_.detect(frame);if(qrCodes.length>0){return qrCodes[0].rawValue}return null}onActivationCodeChanged_(){const event=new CustomEvent("activation-code-updated",{bubbles:true,composed:true,detail:{activationCode:this.validateActivationCode_(this.activationCode)?this.activationCode:null}});this.dispatchEvent(event)}clearQrCodeDetectorTimer_(){assert(!!this.qrCodeDetectorTimer_);clearTimeout(this.qrCodeDetectorTimer_);this.qrCodeDetectorTimer_=null}validateActivationCode_(activationCode){if(activationCode.length<=ACTIVATION_CODE_PREFIX.length){this.isActivationCodeInvalidFormat_=activationCode!==ACTIVATION_CODE_PREFIX.substring(0,activationCode.length);return false}else{this.isActivationCodeInvalidFormat_=activationCode.substring(0,ACTIVATION_CODE_PREFIX.length)!==ACTIVATION_CODE_PREFIX}if(this.isActivationCodeInvalidFormat_){return false}return true}onSwitchCameraButtonPressed_(){if(this.state_===PageState.SCANNING_USER_FACING){this.state_=PageState.SWITCHING_CAM_USER_TO_ENVIRONMENT}else if(this.state_===PageState.SCANNING_ENVIRONMENT_FACING){this.state_=PageState.SWITCHING_CAM_ENVIRONMENT_TO_USER}this.startScanning_()}onShowErrorChanged_(){if(this.showError){if(this.state_===PageState.MANUAL_ENTRY){this.state_=PageState.MANUAL_ENTRY_INSTALL_FAILURE;afterNextRender(this,(()=>{focusWithoutInk(this.$.activationCode)}))}else if(this.state_===PageState.SCANNING_SUCCESS){this.state_=PageState.SCANNING_INSTALL_FAILURE}}}onStateChanged_(){this.qrCodeCameraA11yString_="";if(this.state_!==PageState.MANUAL_ENTRY_INSTALL_FAILURE&&this.state_!==PageState.SCANNING_INSTALL_FAILURE){this.showError=false}if(this.state_===PageState.MANUAL_ENTRY){this.isFromQrCode=false;if(this.qrCodeDetectorTimer_){this.clearQrCodeDetectorTimer_()}afterNextRender(this,(()=>{this.stopStream_(this.stream_)}))}if(this.state_===PageState.SCANNING_USER_FACING||this.state_===PageState.SCANNING_ENVIRONMENT_FACING){this.qrCodeCameraA11yString_=this.i18n("qrCodeA11YCameraOn");this.expanded_=true;return}if(this.state_===PageState.SCANNING_SUCCESS){this.isFromQrCode=true;this.qrCodeCameraA11yString_=this.i18n("qrCodeA11YCameraScanSuccess");this.dispatchEvent(new CustomEvent("focus-default-button",{bubbles:true,composed:true}))}this.expanded_=false}onKeyDown_(e){if(e.key==="Enter"){this.dispatchEvent(new CustomEvent("forward-navigation-requested",{bubbles:true,composed:true}))}if(e.key==="Tab"){return}this.state_=PageState.MANUAL_ENTRY;e.stopPropagation()}isUiElementHidden_(uiElement,state){switch(uiElement){case UiElement.START_SCANNING:return state!==PageState.MANUAL_ENTRY&&state!==PageState.MANUAL_ENTRY_INSTALL_FAILURE;case UiElement.VIDEO:return state!==PageState.SCANNING_USER_FACING&&state!==PageState.SCANNING_ENVIRONMENT_FACING;case UiElement.SWITCH_CAMERA:const isScanning=state===PageState.SCANNING_USER_FACING||state===PageState.SCANNING_ENVIRONMENT_FACING;return!(isScanning&&this.cameraCount_>1);case UiElement.SCAN_FINISH:return state!==PageState.SCANNING_SUCCESS&&state!==PageState.SCANNING_FAILURE&&state!==PageState.SCANNING_INSTALL_FAILURE;case UiElement.SCAN_SUCCESS:return state!==PageState.SCANNING_SUCCESS&&state!==PageState.SCANNING_INSTALL_FAILURE;case UiElement.SCAN_FAILURE:return state!==PageState.SCANNING_FAILURE;case UiElement.CODE_DETECTED:return state!==PageState.SCANNING_SUCCESS;case UiElement.SCAN_INSTALL_FAILURE:return state!==PageState.SCANNING_INSTALL_FAILURE}}isUiElementDisabled_(uiElement,state){switch(uiElement){case UiElement.SWITCH_CAMERA:return state===PageState.SWITCHING_CAM_USER_TO_ENVIRONMENT||state===PageState.SWITCHING_CAM_ENVIRONMENT_TO_USER;default:return false}}getDescription_(){if(!this.isScanningAvailable_()){if(this.showNoProfilesFound){return this.i18n("enterActivationCodeNoProfilesFound")}return this.i18n("enterActivationCode")}if(this.showNoProfilesFound){return this.i18n("scanQRCodeNoProfilesFound")}return this.i18n("scanQRCode")}shouldActivationCodeInputBeInvalid_(state){if(this.isActivationCodeInvalidFormat_){return true}return state===PageState.MANUAL_ENTRY_INSTALL_FAILURE}getInputSubtitle_(){return loadTimeData.getString("scanQrCodeInputSubtitle")}getInputErrorMessage_(){return loadTimeData.getString("scanQrCodeInputError")}}customElements.define(ActivationCodePageElement.is,ActivationCodePageElement);