// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"//resources/ash/common/cr_elements/cr_shared_vars.css.js";import{I18nMixin}from"//resources/ash/common/cr_elements/i18n_mixin.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{focusWithoutInk}from"//resources/js/focus_without_ink.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./button_bar.html.js";import{Button,ButtonState}from"./cellular_types.js";const ButtonBarElementBase=I18nMixin(PolymerElement);export class ButtonBarElement extends ButtonBarElementBase{static get is(){return"button-bar"}static get template(){return getTemplate()}static get properties(){return{buttonState:{type:Object,value:{}},buttonEnum_:{type:Object,value:Button},forwardButtonLabel:{type:String,value:""}}}isButtonHidden_(buttonName){const state=this.getButtonBarState_(buttonName);return state===ButtonState.HIDDEN}isButtonDisabled_(buttonName){const state=this.getButtonBarState_(buttonName);return state===ButtonState.DISABLED}focusDefaultButton(){const buttons=this.shadowRoot.querySelectorAll("cr-button");for(let i=buttons.length-1;i>=0;i--){const button=buttons.item(i);if(!button.disabled&&!button.hidden){focusWithoutInk(button);return}}}onCancelButtonClicked_(){this.dispatchEvent(new CustomEvent("cancel-requested",{bubbles:true,composed:true}))}onForwardButtonClicked_(){this.dispatchEvent(new CustomEvent("forward-nav-requested",{bubbles:true,composed:true}))}getButtonBarState_(button){assert(this.buttonState);switch(button){case Button.CANCEL:return this.buttonState.cancel;case Button.FORWARD:return this.buttonState.forward;default:assertNotReached()}}}customElements.define(ButtonBarElement.is,ButtonBarElement);