// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-pages/iron-pages.js";import"./setup_loading_page.js";import"./activation_code_page.js";import"./activation_verification_page.js";import"./final_page.js";import"./profile_discovery_consent_page.js";import"./profile_discovery_list_page.js";import"./confirmation_code_page.js";import{I18nMixin}from"//resources/ash/common/cr_elements/i18n_mixin.js";import{hasActiveCellularNetwork}from"//resources/ash/common/network/cellular_utils.js";import{MojoInterfaceProviderImpl}from"//resources/ash/common/network/mojo_interface_provider.js";import{NetworkListenerBehavior}from"//resources/ash/common/network/network_listener_behavior.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{ESimOperationResult,ProfileInstallMethod,ProfileInstallResult,ProfileState}from"//resources/mojo/chromeos/ash/services/cellular_setup/public/mojom/esim_manager.mojom-webui.js";import{FilterType,NO_LIMIT}from"//resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js";import{ConnectionStateType,NetworkType}from"//resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js";import{mixinBehaviors,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ButtonState}from"./cellular_types.js";import{getTemplate}from"./esim_flow_ui.html.js";import{getEuicc}from"./esim_manager_utils.js";import{getESimManagerRemote}from"./mojo_interface_provider.js";import{SubflowMixin}from"./subflow_mixin.js";export var EsimPageName;(function(EsimPageName){EsimPageName["PROFILE_LOADING"]="profileLoadingPage";EsimPageName["PROFILE_DISCOVERY_CONSENT"]="profileDiscoveryConsentPage";EsimPageName["PROFILE_DISCOVERY"]="profileDiscoveryPage";EsimPageName["ACTIVATION_CODE"]="activationCodePage";EsimPageName["CONFIRMATION_CODE"]="confirmationCodePage";EsimPageName["PROFILE_INSTALLING"]="profileInstallingPage";EsimPageName["FINAL"]="finalPage"})(EsimPageName||(EsimPageName={}));export var EsimUiState;(function(EsimUiState){EsimUiState["PROFILE_SEARCH"]="profile-search";EsimUiState["PROFILE_SEARCH_CONSENT"]="profile-search-consent";EsimUiState["ACTIVATION_CODE_ENTRY"]="activation-code-entry";EsimUiState["ACTIVATION_CODE_ENTRY_READY"]="activation-code-entry-ready";EsimUiState["ACTIVATION_CODE_ENTRY_INSTALLING"]="activation-code-entry-installing";EsimUiState["CONFIRMATION_CODE_ENTRY"]="confirmation-code-entry";EsimUiState["CONFIRMATION_CODE_ENTRY_READY"]="confirmation-code-entry-ready";EsimUiState["CONFIRMATION_CODE_ENTRY_INSTALLING"]="confirmation-code-entry-installing";EsimUiState["PROFILE_SELECTION"]="profile-selection";EsimUiState["PROFILE_SELECTION_INSTALLING"]="profile-selection-installing";EsimUiState["SETUP_FINISH"]="setup-finish"})(EsimUiState||(EsimUiState={}));export var EsimSetupFlowResult;(function(EsimSetupFlowResult){EsimSetupFlowResult[EsimSetupFlowResult["SUCCESS"]=0]="SUCCESS";EsimSetupFlowResult[EsimSetupFlowResult["INSTALL_FAIL"]=1]="INSTALL_FAIL";EsimSetupFlowResult[EsimSetupFlowResult["CANCELLED_NEEDS_CONFIRMATION_CODE"]=2]="CANCELLED_NEEDS_CONFIRMATION_CODE";EsimSetupFlowResult[EsimSetupFlowResult["CANCELLED_INVALID_ACTIVATION_CODE"]=3]="CANCELLED_INVALID_ACTIVATION_CODE";EsimSetupFlowResult[EsimSetupFlowResult["ERROR_FETCHING_PROFILES"]=4]="ERROR_FETCHING_PROFILES";EsimSetupFlowResult[EsimSetupFlowResult["CANCELLED_WITHOUT_ERROR"]=5]="CANCELLED_WITHOUT_ERROR";EsimSetupFlowResult[EsimSetupFlowResult["CANCELLED_NO_PROFILES"]=6]="CANCELLED_NO_PROFILES";EsimSetupFlowResult[EsimSetupFlowResult["NO_NETWORK"]=7]="NO_NETWORK"})(EsimSetupFlowResult||(EsimSetupFlowResult={}));export const ESIM_SETUP_RESULT_METRIC_NAME="Network.Cellular.ESim.SetupFlowResult";export const SUCCESSFUL_ESIM_SETUP_DURATION_METRIC_NAME="Network.Cellular.ESim.CellularSetup.Success.Duration";export const FAILED_ESIM_SETUP_DURATION_METRIC_NAME="Network.Cellular.ESim.CellularSetup.Failure.Duration";const EsimFlowUiElementBase=mixinBehaviors([NetworkListenerBehavior],SubflowMixin(I18nMixin(PolymerElement)));export class EsimFlowUiElement extends EsimFlowUiElementBase{static get is(){return"esim-flow-ui"}static get template(){return getTemplate()}static get properties(){return{delegate:Object,header:{type:String,notify:true,computed:"computeHeader_(selectedEsimPageName_, showError_)"},forwardButtonLabel:{type:String,notify:true},state_:{type:String,value:EsimUiState.PROFILE_SEARCH_CONSENT,observer:"onStateChanged_"},selectedEsimPageName_:String,hasConsentedForDiscovery_:{type:Boolean,value:false},shouldSkipDiscovery_:{type:Boolean,value:false},showError_:{type:Boolean,value:false},pendingProfileProperties_:Array,selectedProfileProperties_:{type:Object,observer:"onSelectedProfilePropertiesChanged_"},activationCode_:{type:String,value:""},confirmationCode_:{type:String,value:"",observer:"onConfirmationCodeUpdated_"},hasHadActiveCellularNetwork_:{type:Boolean,value:false},isActivationCodeFromQrCode_:Boolean}}constructor(){super();this.euicc_=null;this.lastProfileInstallResult_=null;this.hasFailedFetchingProfiles_=false;this.isOffline_=false;this.timeOnAttached_=null;this.eSimManagerRemote_=getESimManagerRemote();const networkConfig=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();const filter={filter:FilterType.kActive,limit:NO_LIMIT,networkType:NetworkType.kAll};networkConfig.getNetworkStateList(filter).then((response=>{this.onActiveNetworksChanged(response.result)}))}connectedCallback(){super.connectedCallback();this.timeOnAttached_=new Date}disconnectedCallback(){super.disconnectedCallback();let resultCode=null;switch(this.lastProfileInstallResult_){case null:if(this.hasFailedFetchingProfiles_){resultCode=EsimSetupFlowResult.ERROR_FETCHING_PROFILES}else if(this.noProfilesFound_()){resultCode=EsimSetupFlowResult.CANCELLED_NO_PROFILES}else{resultCode=EsimSetupFlowResult.CANCELLED_WITHOUT_ERROR}break;case ProfileInstallResult.kSuccess:resultCode=EsimSetupFlowResult.SUCCESS;break;case ProfileInstallResult.kFailure:resultCode=EsimSetupFlowResult.INSTALL_FAIL;break;case ProfileInstallResult.kErrorNeedsConfirmationCode:resultCode=EsimSetupFlowResult.CANCELLED_NEEDS_CONFIRMATION_CODE;break;case ProfileInstallResult.kErrorInvalidActivationCode:resultCode=EsimSetupFlowResult.CANCELLED_INVALID_ACTIVATION_CODE;break;default:break}if(this.isOffline_&&resultCode!==EsimSetupFlowResult.SUCCESS){resultCode=EsimSetupFlowResult.NO_NETWORK}assert(resultCode!==null);chrome.metricsPrivate.recordEnumerationValue(ESIM_SETUP_RESULT_METRIC_NAME,resultCode,Object.keys(EsimSetupFlowResult).length);const elapsedTimeMs=(new Date).getTime()-this.timeOnAttached_.getTime();if(resultCode===EsimSetupFlowResult.SUCCESS){chrome.metricsPrivate.recordLongTime(SUCCESSFUL_ESIM_SETUP_DURATION_METRIC_NAME,elapsedTimeMs);return}chrome.metricsPrivate.recordLongTime(FAILED_ESIM_SETUP_DURATION_METRIC_NAME,elapsedTimeMs)}ready(){super.ready();this.addEventListener("activation-code-updated",(event=>{this.onActivationCodeUpdated_(event)}));this.addEventListener("forward-navigation-requested",this.onForwardNavigationRequested_)}onActiveNetworksChanged(activeNetworks){this.isOffline_=!activeNetworks.some((network=>network.connectionState===ConnectionStateType.kOnline))}initSubflow(){this.refreshInstalledProfiles_();this.onNetworkStateListChanged()}async fetchProfiles_(){await this.getEuicc_();if(!this.euicc_){return}await this.getAvailableProfileProperties_();if(this.noProfilesFound_()){this.state_=EsimUiState.ACTIVATION_CODE_ENTRY}else{this.state_=EsimUiState.PROFILE_SELECTION}}async getEuicc_(){const euicc=await getEuicc();if(!euicc){this.hasFailedFetchingProfiles_=true;this.showError_=true;this.state_=EsimUiState.SETUP_FINISH;console.warn("No Euiccs found");return}this.euicc_=euicc}async getAvailableProfileProperties_(){assert(this.euicc_);const requestAvailableProfilesResponse=await this.euicc_.requestAvailableProfiles();if(requestAvailableProfilesResponse.result===ESimOperationResult.kFailure){this.hasFailedFetchingProfiles_=true;console.warn("Error requesting available profiles: ",requestAvailableProfilesResponse);this.pendingProfileProperties_=[]}this.pendingProfileProperties_=requestAvailableProfilesResponse.profiles.filter((properties=>properties.state===ProfileState.kPending&&properties.activationCode))}async refreshInstalledProfiles_(){await this.getEuicc_();if(!this.euicc_){return}await this.euicc_.refreshInstalledProfiles()}handleProfileInstallResponse_(response){this.lastProfileInstallResult_=response.result;if(response.result===ProfileInstallResult.kErrorNeedsConfirmationCode){this.state_=EsimUiState.CONFIRMATION_CODE_ENTRY;return}this.showError_=response.result!==ProfileInstallResult.kSuccess;if(response.result===ProfileInstallResult.kFailure&&this.state_===EsimUiState.CONFIRMATION_CODE_ENTRY_INSTALLING){this.state_=EsimUiState.CONFIRMATION_CODE_ENTRY_READY;return}if(response.result===ProfileInstallResult.kErrorInvalidActivationCode&&this.state_!==EsimUiState.PROFILE_SELECTION_INSTALLING){this.state_=EsimUiState.ACTIVATION_CODE_ENTRY_READY;return}if(response.result===ProfileInstallResult.kSuccess||response.result===ProfileInstallResult.kFailure){this.state_=EsimUiState.SETUP_FINISH}}onStateChanged_(newState,oldState){this.updateButtonBarState_();this.updateSelectedPage_();if(this.hasConsentedForDiscovery_&&newState===EsimUiState.PROFILE_SEARCH){this.fetchProfiles_()}this.initializePageState_(newState,oldState)}updateSelectedPage_(){const oldSelectedEsimPageName=this.selectedEsimPageName_;switch(this.state_){case EsimUiState.PROFILE_SEARCH:this.selectedEsimPageName_=EsimPageName.PROFILE_LOADING;break;case EsimUiState.PROFILE_SEARCH_CONSENT:this.selectedEsimPageName_=EsimPageName.PROFILE_DISCOVERY_CONSENT;break;case EsimUiState.ACTIVATION_CODE_ENTRY:case EsimUiState.ACTIVATION_CODE_ENTRY_READY:this.selectedEsimPageName_=EsimPageName.ACTIVATION_CODE;break;case EsimUiState.ACTIVATION_CODE_ENTRY_INSTALLING:this.selectedEsimPageName_=EsimPageName.PROFILE_INSTALLING;break;case EsimUiState.CONFIRMATION_CODE_ENTRY:case EsimUiState.CONFIRMATION_CODE_ENTRY_READY:this.selectedEsimPageName_=EsimPageName.CONFIRMATION_CODE;break;case EsimUiState.CONFIRMATION_CODE_ENTRY_INSTALLING:this.selectedEsimPageName_=EsimPageName.PROFILE_INSTALLING;break;case EsimUiState.PROFILE_SELECTION:this.selectedEsimPageName_=EsimPageName.PROFILE_DISCOVERY;break;case EsimUiState.PROFILE_SELECTION_INSTALLING:this.selectedEsimPageName_=EsimPageName.PROFILE_INSTALLING;break;case EsimUiState.SETUP_FINISH:this.selectedEsimPageName_=EsimPageName.FINAL;break;default:assertNotReached()}if(oldSelectedEsimPageName!==this.selectedEsimPageName_){this.dispatchEvent(new CustomEvent("focus-default-button",{bubbles:true,composed:true}))}}generateButtonStateForActivationPage_(enableForwardBtn,cancelButtonStateIfEnabled){this.forwardButtonLabel=this.i18n("next");return{cancel:cancelButtonStateIfEnabled,forward:enableForwardBtn||loadTimeData.valueExists("isESimEmptyActivationCodeSupportEnabled")&&loadTimeData.getBoolean("isESimEmptyActivationCodeSupportEnabled")?ButtonState.ENABLED:ButtonState.DISABLED}}generateButtonStateForConfirmationPage_(enableForwardBtn,cancelButtonStateIfEnabled){this.forwardButtonLabel=this.i18n("confirm");return{cancel:cancelButtonStateIfEnabled,forward:enableForwardBtn?ButtonState.ENABLED:ButtonState.DISABLED}}updateButtonBarState_(){let buttonState;const cancelButtonStateIfEnabled=this.delegate.shouldShowCancelButton()?ButtonState.ENABLED:ButtonState.HIDDEN;const cancelButtonStateIfDisabled=this.delegate.shouldShowCancelButton()?ButtonState.DISABLED:ButtonState.HIDDEN;switch(this.state_){case EsimUiState.PROFILE_SEARCH:this.forwardButtonLabel=this.i18n("next");buttonState={cancel:cancelButtonStateIfEnabled,forward:ButtonState.DISABLED};break;case EsimUiState.PROFILE_SEARCH_CONSENT:this.forwardButtonLabel=this.i18n("profileDiscoveryConsentScan");buttonState={cancel:ButtonState.ENABLED,forward:ButtonState.ENABLED};break;case EsimUiState.ACTIVATION_CODE_ENTRY:buttonState=this.generateButtonStateForActivationPage_(false,cancelButtonStateIfEnabled);break;case EsimUiState.ACTIVATION_CODE_ENTRY_READY:buttonState=this.generateButtonStateForActivationPage_(true,cancelButtonStateIfEnabled);break;case EsimUiState.ACTIVATION_CODE_ENTRY_INSTALLING:buttonState=this.generateButtonStateForActivationPage_(false,cancelButtonStateIfDisabled);break;case EsimUiState.CONFIRMATION_CODE_ENTRY:buttonState=this.generateButtonStateForConfirmationPage_(false,cancelButtonStateIfEnabled);break;case EsimUiState.CONFIRMATION_CODE_ENTRY_READY:buttonState=this.generateButtonStateForConfirmationPage_(true,cancelButtonStateIfEnabled);break;case EsimUiState.CONFIRMATION_CODE_ENTRY_INSTALLING:buttonState=this.generateButtonStateForConfirmationPage_(false,cancelButtonStateIfDisabled);break;case EsimUiState.PROFILE_SELECTION:this.updateForwardButtonLabel_();buttonState={cancel:cancelButtonStateIfEnabled,forward:ButtonState.ENABLED};break;case EsimUiState.PROFILE_SELECTION_INSTALLING:buttonState={cancel:cancelButtonStateIfDisabled,forward:ButtonState.DISABLED};break;case EsimUiState.SETUP_FINISH:this.forwardButtonLabel=this.i18n("done");buttonState={cancel:ButtonState.HIDDEN,forward:ButtonState.ENABLED};break;default:assertNotReached()}this.set("buttonState",buttonState)}updateForwardButtonLabel_(){this.forwardButtonLabel=this.selectedProfileProperties_?this.i18n("next"):this.i18n("skipDiscovery")}initializePageState_(newState,oldState){if(newState===EsimUiState.CONFIRMATION_CODE_ENTRY&&oldState!==EsimUiState.CONFIRMATION_CODE_ENTRY_READY){this.confirmationCode_=""}if(newState===EsimUiState.ACTIVATION_CODE_ENTRY&&oldState!==EsimUiState.ACTIVATION_CODE_ENTRY_READY){this.activationCode_=""}}onActivationCodeUpdated_(event){if(this.state_!==EsimUiState.ACTIVATION_CODE_ENTRY&&this.state_!==EsimUiState.ACTIVATION_CODE_ENTRY_READY){return}this.state_=event.detail.activationCode?EsimUiState.ACTIVATION_CODE_ENTRY_READY:EsimUiState.ACTIVATION_CODE_ENTRY}onSelectedProfilePropertiesChanged_(){if(this.state_!==EsimUiState.PROFILE_SELECTION){return}this.updateForwardButtonLabel_()}onConfirmationCodeUpdated_(){if(this.state_!==EsimUiState.CONFIRMATION_CODE_ENTRY&&this.state_!==EsimUiState.CONFIRMATION_CODE_ENTRY_READY){return}this.state_=this.confirmationCode_?EsimUiState.CONFIRMATION_CODE_ENTRY_READY:EsimUiState.CONFIRMATION_CODE_ENTRY}navigateForward(){this.showError_=false;switch(this.state_){case EsimUiState.PROFILE_SEARCH_CONSENT:if(this.shouldSkipDiscovery_){this.state_=EsimUiState.ACTIVATION_CODE_ENTRY;break}this.hasConsentedForDiscovery_=true;this.state_=EsimUiState.PROFILE_SEARCH;break;case EsimUiState.ACTIVATION_CODE_ENTRY_READY:assert(this.euicc_);const confirmationCode="";this.state_=EsimUiState.ACTIVATION_CODE_ENTRY_INSTALLING;this.euicc_.installProfileFromActivationCode(this.activationCode_,confirmationCode,this.computeProfileInstallMethod_()).then(this.handleProfileInstallResponse_.bind(this));break;case EsimUiState.PROFILE_SELECTION:if(this.selectedProfileProperties_){assert(this.euicc_);this.state_=EsimUiState.PROFILE_SELECTION_INSTALLING;const confirmationCode="";this.euicc_.installProfileFromActivationCode(this.selectedProfileProperties_.activationCode,confirmationCode,ProfileInstallMethod.kViaSmds).then(this.handleProfileInstallResponse_.bind(this))}else{this.state_=EsimUiState.ACTIVATION_CODE_ENTRY}break;case EsimUiState.CONFIRMATION_CODE_ENTRY_READY:this.state_=EsimUiState.CONFIRMATION_CODE_ENTRY_INSTALLING;assert(this.euicc_);const fromQrCode=this.selectedProfileProperties_?true:false;const activationCode=fromQrCode?this.selectedProfileProperties_.activationCode:this.activationCode_;this.euicc_.installProfileFromActivationCode(activationCode,this.confirmationCode_,this.computeProfileInstallMethod_()).then(this.handleProfileInstallResponse_.bind(this));break;case EsimUiState.SETUP_FINISH:this.dispatchEvent(new CustomEvent("exit-cellular-setup",{bubbles:true,composed:true}));break;case EsimUiState.ACTIVATION_CODE_ENTRY:if(loadTimeData.valueExists("isESimEmptyActivationCodeSupportEnabled")&&loadTimeData.getBoolean("isESimEmptyActivationCodeSupportEnabled")){this.state_=EsimUiState.SETUP_FINISH}break;default:assertNotReached()}}maybeFocusPageElement(){switch(this.state_){case EsimUiState.ACTIVATION_CODE_ENTRY:case EsimUiState.ACTIVATION_CODE_ENTRY_READY:const activationCodePage=this.shadowRoot.querySelector("#activationCodePage");if(!activationCodePage){return false}return activationCodePage.attemptToFocusOnPageContent();case EsimUiState.PROFILE_SELECTION:const profileDiscoveryPage=this.shadowRoot.querySelector("#profileDiscoveryPage");if(!profileDiscoveryPage){return false}return profileDiscoveryPage.attemptToFocusOnFirstProfile();default:return false}}onForwardNavigationRequested_(){if(this.state_===EsimUiState.ACTIVATION_CODE_ENTRY_READY||this.state_===EsimUiState.CONFIRMATION_CODE_ENTRY_READY||this.state_===EsimUiState.PROFILE_SEARCH_CONSENT||this.state_===EsimUiState.PROFILE_SELECTION){this.navigateForward()}}async onNetworkStateListChanged(){const hasActive=await hasActiveCellularNetwork();if(hasActive){this.hasHadActiveCellularNetwork_=hasActive}}computeHeader_(){if(this.selectedEsimPageName_===EsimPageName.FINAL&&!this.showError_){return this.i18n("eSimFinalPageSuccessHeader")}if(this.selectedEsimPageName_===EsimPageName.PROFILE_DISCOVERY_CONSENT){return this.i18n("profileDiscoveryConsentTitle")}if(this.selectedEsimPageName_===EsimPageName.PROFILE_DISCOVERY){return this.i18n("profileDiscoveryPageTitle")}if(this.selectedEsimPageName_==EsimPageName.CONFIRMATION_CODE){return this.i18n("confimationCodePageTitle")}if(this.selectedEsimPageName_==EsimPageName.PROFILE_LOADING){return this.i18n("profileLoadingPageTitle")}return""}computeProfileInstallMethod_(){if(this.isActivationCodeFromQrCode_){return this.hasConsentedForDiscovery_?ProfileInstallMethod.kViaQrCodeAfterSmds:ProfileInstallMethod.kViaQrCodeSkippedSmds}return this.hasConsentedForDiscovery_?ProfileInstallMethod.kViaActivationCodeAfterSmds:ProfileInstallMethod.kViaActivationCodeSkippedSmds}noProfilesFound_(){return this.hasConsentedForDiscovery_&&!!this.pendingProfileProperties_&&this.pendingProfileProperties_.length===0}profilesFound_(){return this.hasConsentedForDiscovery_&&!!this.pendingProfileProperties_&&this.pendingProfileProperties_.length>0}getSelectedEsimPageNameForTest(){return this.selectedEsimPageName_}}customElements.define(EsimFlowUiElement.is,EsimFlowUiElement);