// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./setup_loading_page.js";import"./provisioning_page.js";import"./final_page.js";import"//resources/polymer/v3_0/iron-pages/iron-pages.js";import{I18nMixin}from"//resources/ash/common/cr_elements/i18n_mixin.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{ActivationDelegateReceiver,ActivationResult,CarrierPortalStatus}from"//resources/mojo/chromeos/ash/services/cellular_setup/public/mojom/cellular_setup.mojom-webui.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ButtonState}from"./cellular_types.js";import{getCellularSetupRemote}from"./mojo_interface_provider.js";import{getTemplate}from"./psim_flow_ui.html.js";import{SubflowMixin}from"./subflow_mixin.js";export var PsimPageName;(function(PsimPageName){PsimPageName["SIM_DETECT"]="simDetectPage";PsimPageName["PROVISIONING"]="provisioningPage";PsimPageName["FINAL"]="finalPage"})(PsimPageName||(PsimPageName={}));export var PsimUiState;(function(PsimUiState){PsimUiState["IDLE"]="idle";PsimUiState["STARTING_ACTIVATION"]="starting-activation";PsimUiState["WAITING_FOR_ACTIVATION_TO_START"]="waiting-for-activation-to-start";PsimUiState["TIMEOUT_START_ACTIVATION"]="timeout-start-activation";PsimUiState["FINAL_TIMEOUT_START_ACTIVATION"]="final-timeout-start-activation";PsimUiState["WAITING_FOR_PORTAL_TO_LOAD"]="waiting-for-portal-to-load";PsimUiState["TIMEOUT_PORTAL_LOAD"]="timeout-portal-load";PsimUiState["WAITING_FOR_USER_PAYMENT"]="waiting-for-user-payment";PsimUiState["WAITING_FOR_ACTIVATION_TO_FINISH"]="waiting-for-activation-to-finish";PsimUiState["TIMEOUT_FINISH_ACTIVATION"]="timeout-finish-activation";PsimUiState["ACTIVATION_SUCCESS"]="activation-success";PsimUiState["ALREADY_ACTIVATED"]="already-activated";PsimUiState["ACTIVATION_FAILURE"]="activation-failure"})(PsimUiState||(PsimUiState={}));export var PsimSetupFlowResult;(function(PsimSetupFlowResult){PsimSetupFlowResult[PsimSetupFlowResult["SUCCESS"]=0]="SUCCESS";PsimSetupFlowResult[PsimSetupFlowResult["CANCELLED"]=1]="CANCELLED";PsimSetupFlowResult[PsimSetupFlowResult["CANCELLED_NO_SIM"]=2]="CANCELLED_NO_SIM";PsimSetupFlowResult[PsimSetupFlowResult["CANCELLED_COLD_SIM_DEFER"]=3]="CANCELLED_COLD_SIM_DEFER";PsimSetupFlowResult[PsimSetupFlowResult["CANCELLED_CARRIER_PORTAL"]=4]="CANCELLED_CARRIER_PORTAL";PsimSetupFlowResult[PsimSetupFlowResult["CANCELLED_PORTAL_ERROR"]=5]="CANCELLED_PORTAL_ERROR";PsimSetupFlowResult[PsimSetupFlowResult["CARRIER_PORTAL_TIMEOUT"]=6]="CARRIER_PORTAL_TIMEOUT";PsimSetupFlowResult[PsimSetupFlowResult["NETWORK_ERROR"]=7]="NETWORK_ERROR"})(PsimSetupFlowResult||(PsimSetupFlowResult={}));function getTimeoutMsForPsimUiState(state){if(state===PsimUiState.STARTING_ACTIVATION){return 1e4}if(state===PsimUiState.WAITING_FOR_PORTAL_TO_LOAD){return 1e4}if(state===PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH){return 1e3}return null}const MAX_START_ACTIVATION_ATTEMPTS=3;export const PSIM_SETUP_RESULT_METRIC_NAME="Network.Cellular.PSim.SetupFlowResult";export const SUCCESSFUL_PSIM_SETUP_DURATION_METRIC_NAME="Network.Cellular.PSim.CellularSetup.Success.Duration";export const FAILED_PSIM_SETUP_DURATION_METRIC_NAME="Network.Cellular.PSim.CellularSetup.Failure.Duration";const PsimFlowUiElementBase=SubflowMixin(I18nMixin(PolymerElement));export class PsimFlowUiElement extends PsimFlowUiElementBase{static get is(){return"psim-flow-ui"}static get template(){return getTemplate()}static get properties(){return{delegate:Object,nameOfCarrierPendingSetup:{type:String,notify:true,computed:"getCarrierText("+"selectedPsimPageName_, cellularMetadata_.*)"},forwardButtonLabel:{type:String,notify:true},state_:{type:String,value:PsimUiState.IDLE,observer:"handlePsimUiStateChange_"},selectedPsimPageName_:{type:String,value:PsimPageName.SIM_DETECT,notify:true},selectedPage_:Object,showError_:{type:Boolean,value:false},cellularMetadata_:{type:Object,value:null},startActivationAttempts_:{type:Number,value:0}}}constructor(){super();this.cellularSetupRemote_=null;this.activationDelegateReceiver_=null;this.currentTimeoutId_=null;this.carrierPortalHandler_=null;this.didCarrierPortalResultFail_=false;this.setTimeoutFunction_=setTimeout.bind(window);this.timeOnAttached_=null;this.cellularSetupRemote_=getCellularSetupRemote()}connectedCallback(){super.connectedCallback();this.timeOnAttached_=new Date}disconnectedCallback(){super.disconnectedCallback();let resultCode=null;switch(this.state_){case PsimUiState.IDLE:case PsimUiState.STARTING_ACTIVATION:resultCode=PsimSetupFlowResult.CANCELLED;break;case PsimUiState.WAITING_FOR_ACTIVATION_TO_START:resultCode=PsimSetupFlowResult.CANCELLED_COLD_SIM_DEFER;break;case PsimUiState.TIMEOUT_START_ACTIVATION:case PsimUiState.FINAL_TIMEOUT_START_ACTIVATION:resultCode=PsimSetupFlowResult.CANCELLED_NO_SIM;break;case PsimUiState.WAITING_FOR_PORTAL_TO_LOAD:resultCode=PsimSetupFlowResult.CANCELLED;break;case PsimUiState.TIMEOUT_PORTAL_LOAD:resultCode=PsimSetupFlowResult.CARRIER_PORTAL_TIMEOUT;break;case PsimUiState.WAITING_FOR_USER_PAYMENT:resultCode=PsimSetupFlowResult.CANCELLED_CARRIER_PORTAL;break;case PsimUiState.ACTIVATION_SUCCESS:case PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH:case PsimUiState.TIMEOUT_FINISH_ACTIVATION:case PsimUiState.ALREADY_ACTIVATED:resultCode=PsimSetupFlowResult.SUCCESS;break;case PsimUiState.ACTIVATION_FAILURE:resultCode=this.didCarrierPortalResultFail_?PsimSetupFlowResult.CANCELLED_PORTAL_ERROR:PsimSetupFlowResult.NETWORK_ERROR;break;default:assertNotReached()}assert(resultCode!==null);chrome.metricsPrivate.recordEnumerationValue(PSIM_SETUP_RESULT_METRIC_NAME,resultCode,Object.keys(PsimSetupFlowResult).length);const elapsedTimeMs=Date.now()-this.timeOnAttached_.getTime();if(resultCode===PsimSetupFlowResult.SUCCESS){chrome.metricsPrivate.recordLongTime(SUCCESSFUL_PSIM_SETUP_DURATION_METRIC_NAME,elapsedTimeMs);return}chrome.metricsPrivate.recordLongTime(FAILED_PSIM_SETUP_DURATION_METRIC_NAME,elapsedTimeMs)}onActivationStarted(metadata){this.clearTimer_();this.cellularMetadata_=metadata;this.state_=PsimUiState.WAITING_FOR_PORTAL_TO_LOAD}initSubflow(){this.state_=PsimUiState.STARTING_ACTIVATION;this.startActivationAttempts_=0;this.updateButtonBarState_();this.dispatchEvent(new CustomEvent("focus-default-button",{bubbles:true,composed:true}))}navigateForward(){switch(this.state_){case PsimUiState.WAITING_FOR_PORTAL_TO_LOAD:case PsimUiState.TIMEOUT_PORTAL_LOAD:case PsimUiState.WAITING_FOR_USER_PAYMENT:case PsimUiState.ACTIVATION_SUCCESS:this.state_=PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH;break;case PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH:case PsimUiState.TIMEOUT_FINISH_ACTIVATION:case PsimUiState.FINAL_TIMEOUT_START_ACTIVATION:case PsimUiState.ALREADY_ACTIVATED:case PsimUiState.ACTIVATION_FAILURE:this.dispatchEvent(new CustomEvent("exit-cellular-setup",{bubbles:true,composed:true}));break;case PsimUiState.TIMEOUT_START_ACTIVATION:this.state_=PsimUiState.STARTING_ACTIVATION;break;default:assertNotReached()}}setTimerFunctionForTest(timerFunction){this.setTimeoutFunction_=timerFunction}getSelectedPsimPageNameForTest(){return this.selectedPsimPageName_}getCurrentTimeoutIdForTest(){return this.currentTimeoutId_}setCurrentPsimUiStateForTest(state){this.state_=state}getCurrentPsimUiStateForTest(){return this.state_}updateButtonBarState_(){let buttonState;switch(this.state_){case PsimUiState.IDLE:case PsimUiState.STARTING_ACTIVATION:case PsimUiState.WAITING_FOR_ACTIVATION_TO_START:case PsimUiState.WAITING_FOR_PORTAL_TO_LOAD:case PsimUiState.TIMEOUT_PORTAL_LOAD:case PsimUiState.WAITING_FOR_USER_PAYMENT:this.forwardButtonLabel=this.i18n("next");buttonState={cancel:ButtonState.ENABLED,forward:ButtonState.DISABLED};break;case PsimUiState.TIMEOUT_START_ACTIVATION:this.forwardButtonLabel=this.i18n("tryAgain");buttonState={cancel:ButtonState.ENABLED,forward:ButtonState.ENABLED};break;case PsimUiState.ACTIVATION_SUCCESS:this.forwardButtonLabel=this.i18n("next");buttonState={cancel:ButtonState.ENABLED,forward:ButtonState.ENABLED};break;case PsimUiState.ALREADY_ACTIVATED:case PsimUiState.ACTIVATION_FAILURE:case PsimUiState.FINAL_TIMEOUT_START_ACTIVATION:this.forwardButtonLabel=this.i18n("done");buttonState={cancel:ButtonState.ENABLED,forward:ButtonState.ENABLED};break;case PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH:case PsimUiState.TIMEOUT_FINISH_ACTIVATION:this.forwardButtonLabel=this.i18n("done");buttonState={cancel:ButtonState.HIDDEN,forward:ButtonState.ENABLED};break;default:assertNotReached()}this.set("buttonState",buttonState)}onActivationFinished(result){this.closeActivationConnection_();switch(result){case ActivationResult.kSuccessfullyStartedActivation:this.state_=PsimUiState.ACTIVATION_SUCCESS;break;case ActivationResult.kAlreadyActivated:this.state_=PsimUiState.ALREADY_ACTIVATED;break;case ActivationResult.kFailedToActivate:this.state_=PsimUiState.ACTIVATION_FAILURE;break;default:assertNotReached()}}getCarrierText(){if(this.selectedPsimPageName_===PsimPageName.PROVISIONING&&this.cellularMetadata_){return this.cellularMetadata_.carrier}return""}updateShowError_(){switch(this.state_){case PsimUiState.TIMEOUT_PORTAL_LOAD:case PsimUiState.TIMEOUT_FINISH_ACTIVATION:case PsimUiState.ACTIVATION_FAILURE:this.showError_=true;return;default:this.showError_=false;return}}updateSelectedPage_(){switch(this.state_){case PsimUiState.IDLE:case PsimUiState.STARTING_ACTIVATION:case PsimUiState.WAITING_FOR_ACTIVATION_TO_START:case PsimUiState.TIMEOUT_START_ACTIVATION:case PsimUiState.FINAL_TIMEOUT_START_ACTIVATION:this.selectedPsimPageName_=PsimPageName.SIM_DETECT;return;case PsimUiState.WAITING_FOR_PORTAL_TO_LOAD:case PsimUiState.TIMEOUT_PORTAL_LOAD:case PsimUiState.WAITING_FOR_USER_PAYMENT:case PsimUiState.ACTIVATION_SUCCESS:this.selectedPsimPageName_=PsimPageName.PROVISIONING;return;case PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH:case PsimUiState.TIMEOUT_FINISH_ACTIVATION:case PsimUiState.ALREADY_ACTIVATED:case PsimUiState.ACTIVATION_FAILURE:this.selectedPsimPageName_=PsimPageName.FINAL;return;default:assertNotReached()}}handlePsimUiStateChange_(){this.updateShowError_();this.updateSelectedPage_();this.clearTimer_();const timeoutMs=getTimeoutMsForPsimUiState(this.state_);if(timeoutMs!==null){this.currentTimeoutId_=this.setTimeoutFunction_(this.onTimeout_.bind(this),timeoutMs)}if(this.state_===PsimUiState.STARTING_ACTIVATION){this.startActivation_()}this.updateButtonBarState_()}onTimeout_(){this.closeActivationConnection_();switch(this.state_){case PsimUiState.STARTING_ACTIVATION:this.startActivationAttempts_++;if(this.startActivationAttempts_<MAX_START_ACTIVATION_ATTEMPTS){this.state_=PsimUiState.TIMEOUT_START_ACTIVATION}else{this.state_=PsimUiState.FINAL_TIMEOUT_START_ACTIVATION}return;case PsimUiState.WAITING_FOR_PORTAL_TO_LOAD:this.state_=PsimUiState.TIMEOUT_PORTAL_LOAD;return;case PsimUiState.WAITING_FOR_ACTIVATION_TO_FINISH:this.state_=PsimUiState.TIMEOUT_FINISH_ACTIVATION;return;default:assertNotReached()}}startActivation_(){assert(!this.activationDelegateReceiver_);this.activationDelegateReceiver_=new ActivationDelegateReceiver(this);this.cellularSetupRemote_.startActivation(this.activationDelegateReceiver_.$.bindNewPipeAndPassRemote()).then((params=>{this.carrierPortalHandler_=params.observer}))}closeActivationConnection_(){assert(!!this.activationDelegateReceiver_);this.activationDelegateReceiver_.$.close();this.activationDelegateReceiver_=null;this.carrierPortalHandler_=null;this.cellularMetadata_=null}clearTimer_(){if(this.currentTimeoutId_){clearTimeout(this.currentTimeoutId_)}this.currentTimeoutId_=null}onCarrierPortalLoaded_(){this.state_=PsimUiState.WAITING_FOR_USER_PAYMENT;this.carrierPortalHandler_.onCarrierPortalStatusChange(CarrierPortalStatus.kPortalLoadedWithoutPaidUser)}onCarrierPortalResult_(event){const success=event.detail;this.didCarrierPortalResultFail_=!success;this.state_=success?PsimUiState.ACTIVATION_SUCCESS:PsimUiState.ACTIVATION_FAILURE}getLoadingMessage_(){if(this.state_===PsimUiState.TIMEOUT_START_ACTIVATION){return this.i18n("simDetectPageErrorMessage")}else if(this.state_===PsimUiState.FINAL_TIMEOUT_START_ACTIVATION){return this.i18n("simDetectPageFinalErrorMessage")}return this.i18n("establishNetworkConnectionMessage")}isSimDetectError_(){return this.state_===PsimUiState.TIMEOUT_START_ACTIVATION||this.state_===PsimUiState.FINAL_TIMEOUT_START_ACTIVATION}getLoadingTitle_(){if(this.delegate.shouldShowPageTitle()&&this.isSimDetectError_()){return this.i18n("simDetectPageErrorTitle")}return""}}customElements.define(PsimFlowUiElement.is,PsimFlowUiElement);