// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert,assertNotReached}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./cr_lottie.html.js";let workerLoaderPolicy=null;function getLottieWorkerURL(){if(workerLoaderPolicy===null){workerLoaderPolicy=window.trustedTypes.createPolicy("lottie-worker-script-loader",{createScriptURL:_ignore=>{const script=`import 'chrome://resources/lottie/lottie_worker.min.js';`;const blob=new Blob([script],{type:"text/javascript"});return URL.createObjectURL(blob)},createHTML:()=>assertNotReached(),createScript:()=>assertNotReached()})}return workerLoaderPolicy.createScriptURL("")}export class CrLottieElement extends PolymerElement{constructor(){super(...arguments);this.canvasElement_=null;this.isAnimationLoaded_=false;this.offscreenCanvas_=null;this.hasTransferredCanvas_=false;this.resizeObserver_=null;this.playState_=false;this.workerNeedsSizeUpdate_=false;this.workerNeedsPlayControlUpdate_=false;this.worker_=null;this.xhr_=null}static get is(){return"cr-lottie"}static get template(){return getTemplate()}static get properties(){return{animationUrl:{type:String,value:"",observer:"animationUrlChanged_"},autoplay:{type:Boolean,value:false},hidden:{type:Boolean,value:false},singleLoop:{type:Boolean,value:false}}}connectedCallback(){super.connectedCallback();this.worker_=new Worker(getLottieWorkerURL(),{type:"module"});this.worker_.onmessage=this.onMessage_.bind(this);this.initialize_()}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.disconnect()}if(this.worker_){this.worker_.terminate();this.worker_=null}if(this.xhr_){this.xhr_.abort();this.xhr_=null}}setPlay(shouldPlay){this.playState_=shouldPlay;if(this.isAnimationLoaded_){this.sendPlayControlInformationToWorker_()}else{this.workerNeedsPlayControlUpdate_=true}}sendPlayControlInformationToWorker_(){assert(this.worker_);this.worker_.postMessage({control:{play:this.playState_}})}initialize_(){this.canvasElement_=this.$.canvas;this.offscreenCanvas_=this.canvasElement_.transferControlToOffscreen();this.resizeObserver_=new ResizeObserver(this.onCanvasElementResized_.bind(this));this.resizeObserver_.observe(this.canvasElement_);if(this.isAnimationLoaded_){return}this.sendXmlHttpRequest_(this.animationUrl,"json",this.initAnimation_.bind(this))}animationUrlChanged_(){if(!this.worker_){return}if(this.xhr_){this.xhr_.abort();this.xhr_=null}if(this.isAnimationLoaded_){this.worker_.postMessage({control:{stop:true}});this.isAnimationLoaded_=false}this.sendXmlHttpRequest_(this.animationUrl,"json",this.initAnimation_.bind(this))}getCanvasDrawBufferSize_(){const canvasElement=this.$.canvas;const devicePixelRatio=window.devicePixelRatio;const clientRect=canvasElement.getBoundingClientRect();const drawSize={width:clientRect.width*devicePixelRatio,height:clientRect.height*devicePixelRatio};return drawSize}isValidUrl_(maybeValidUrl){const url=new URL(maybeValidUrl,document.location.href);return url.protocol==="chrome:"||url.protocol==="data:"&&url.pathname.startsWith("application/json;")}sendXmlHttpRequest_(url,responseType,successCallback){assert(this.isValidUrl_(url),"Invalid scheme or data url used.");assert(!this.xhr_);this.xhr_=new XMLHttpRequest;this.xhr_.open("GET",url,true);this.xhr_.responseType=responseType;this.xhr_.send();this.xhr_.onreadystatechange=()=>{assert(this.xhr_);if(this.xhr_.readyState===4&&this.xhr_.status===200){const response=this.xhr_.response;this.xhr_=null;successCallback(response)}}}onCanvasElementResized_(){if(this.isAnimationLoaded_){this.sendCanvasSizeToWorker_()}else{this.workerNeedsSizeUpdate_=true}}sendCanvasSizeToWorker_(){assert(this.worker_);this.worker_.postMessage({drawSize:this.getCanvasDrawBufferSize_()})}initAnimation_(animationData){const message={animationData:animationData,drawSize:this.getCanvasDrawBufferSize_(),params:{loop:!this.singleLoop,autoplay:this.autoplay}};assert(this.worker_);if(!this.hasTransferredCanvas_){message.canvas=this.offscreenCanvas_;this.hasTransferredCanvas_=true;this.worker_.postMessage(message,[this.offscreenCanvas_])}else{this.worker_.postMessage(message)}}fire_(eventName,eventData){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:eventData}))}onMessage_(event){if(event.data.name==="initialized"&&event.data.success){this.isAnimationLoaded_=true;this.sendPendingInfo_();this.fire_("cr-lottie-initialized")}else if(event.data.name==="playing"){this.fire_("cr-lottie-playing")}else if(event.data.name==="paused"){this.fire_("cr-lottie-paused")}else if(event.data.name==="stopped"){this.fire_("cr-lottie-stopped")}else if(event.data.name==="resized"){this.fire_("cr-lottie-resized",event.data.size)}}sendPendingInfo_(){if(this.workerNeedsSizeUpdate_){this.workerNeedsSizeUpdate_=false;this.sendCanvasSizeToWorker_()}if(this.workerNeedsPlayControlUpdate_){this.workerNeedsPlayControlUpdate_=false;this.sendPlayControlInformationToWorker_()}}}customElements.define(CrLottieElement.is,CrLottieElement);