// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../cr_input/cr_input.js";import"../cr_hidden_style.css.js";import"../icons.html.js";import"../cr_shared_style.css.js";import"../cr_shared_vars.css.js";import"//resources/polymer/v3_0/iron-dropdown/iron-dropdown.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./cr_searchable_drop_down.html.js";export class CrSearchableDropDownElement extends PolymerElement{constructor(){super(...arguments);this.openDropdownTimeoutId_=0;this.resizeObserver_=null}static get is(){return"cr-searchable-drop-down"}static get template(){return getTemplate()}static get properties(){return{autofocus:{type:Boolean,value:false,reflectToAttribute:true},readonly:{type:Boolean,reflectToAttribute:true},errorMessageAllowed:{type:Boolean,value:false,reflectToAttribute:true},errorMessage:String,loadingMessage:String,placeholder:String,invalid:{type:Boolean,value:false,notify:true},items:{type:Array,observer:"onItemsChanged_"},value:{type:String,notify:true,observer:"updateInvalid_"},label:{type:String,value:""},updateValueOnInput:Boolean,showLoading:{type:Boolean,value:false},searchTerm_:String,dropdownRefitPending_:Boolean,opened_:{type:Boolean,value:false,reflectToAttribute:true}}}connectedCallback(){super.connectedCallback();this.pointerDownListener_=this.onPointerDown_.bind(this);document.addEventListener("pointerdown",this.pointerDownListener_);this.resizeObserver_=new ResizeObserver((()=>{this.resizeDropdown_()}));this.resizeObserver_.observe(this.$.search)}ready(){super.ready();this.addEventListener("mousemove",this.onMouseMove_.bind(this))}disconnectedCallback(){super.disconnectedCallback();document.removeEventListener("pointerdown",this.pointerDownListener_);this.resizeObserver_.unobserve(this.$.search)}enqueueDropdownRefit_(){const dropdown=this.$.dropdown;if(!this.dropdownRefitPending_&&dropdown.opened){this.dropdownRefitPending_=true;setTimeout((()=>{dropdown.refit();this.dropdownRefitPending_=false}),0)}}resizeDropdown_(){const dropdown=this.$.dropdown.containedElement;const dropdownWidth=Math.max(dropdown.offsetWidth,this.$.search.offsetWidth);dropdown.style.width=`${dropdownWidth}px`;this.enqueueDropdownRefit_()}openDropdown_(){this.$.dropdown.open();this.opened_=true}closeDropdown_(){if(this.openDropdownTimeoutId_){clearTimeout(this.openDropdownTimeoutId_)}this.$.dropdown.close();this.opened_=false}enqueueOpenDropdown_(){if(this.opened_){return}if(this.openDropdownTimeoutId_){clearTimeout(this.openDropdownTimeoutId_)}this.openDropdownTimeoutId_=setTimeout(this.openDropdown_.bind(this))}onItemsChanged_(){this.enqueueDropdownRefit_()}onFocus_(){if(this.readonly){return}this.openDropdown_()}onMouseMove_(event){const item=event.composedPath().find((elm=>{const element=elm;return element.classList&&element.classList.contains("list-item")}));if(!item){return}const selectedItem=this.findSelectedItem_();if(item===selectedItem){return}if(selectedItem){selectedItem.removeAttribute("selected_")}item.setAttribute("selected_","")}onPointerDown_(event){if(this.readonly){return}const paths=event.composedPath();const searchInput=this.$.search.inputElement;if(paths.includes(this.$.dropdown)){searchInput.focus();event.preventDefault()}else if(paths.includes(searchInput)){this.enqueueOpenDropdown_()}else{this.closeDropdown_()}}onKeyDown_(event){const dropdown=this.$.dropdown;if(!dropdown.opened){if(this.readonly){return}if(event.key==="Enter"){this.openDropdown_();event.preventDefault()}return}event.stopPropagation();switch(event.key){case"Tab":this.closeDropdown_();break;case"ArrowUp":case"ArrowDown":{const selected=this.findSelectedItemIndex_();const items=dropdown.querySelectorAll(".list-item");if(items.length===0){break}this.updateSelected_(items,selected,event.key==="ArrowDown");break}case"Enter":{const selected=this.findSelectedItem_();if(!selected){break}selected.removeAttribute("selected_");this.value=dropdown.querySelector("dom-repeat").modelForElement(selected).item;this.searchTerm_="";this.closeDropdown_();event.preventDefault();break}}}findSelectedItem_(){const items=Array.from(this.$.dropdown.querySelectorAll(".list-item"));return items.find((item=>item.hasAttribute("selected_")))}findSelectedItemIndex_(){const items=Array.from(this.$.dropdown.querySelectorAll(".list-item"));return items.findIndex((item=>item.hasAttribute("selected_")))}updateSelected_(items,currentIndex,moveDown){const numItems=items.length;let nextIndex=0;if(currentIndex===-1){nextIndex=moveDown?0:numItems-1}else{const delta=moveDown?1:-1;nextIndex=(numItems+currentIndex+delta)%numItems;items[currentIndex].removeAttribute("selected_")}items[nextIndex].setAttribute("selected_","");items[nextIndex].scrollIntoViewIfNeeded()}onInput_(){this.searchTerm_=this.$.search.value;if(this.updateValueOnInput){this.value=this.$.search.value}this.openDropdown_();this.enqueueDropdownRefit_();this.updateInvalid_()}onSelect_(event){this.closeDropdown_();this.value=event.model.item;this.searchTerm_="";const selected=this.findSelectedItem_();if(selected){selected.removeAttribute("selected_")}}filterItems_(searchTerm){if(!searchTerm){return null}return function(item){return item.toLowerCase().includes(searchTerm.toLowerCase())}}shouldShowErrorMessage_(errorMessage,errorMessageAllowed){return!!this.getErrorMessage_(errorMessage,errorMessageAllowed)}getErrorMessage_(errorMessage,errorMessageAllowed){if(!errorMessageAllowed){return""}return errorMessage}onBlur_(){if(!this.updateValueOnInput){this.$.search.value=this.value}this.updateInvalid_()}updateInvalid_(){this.invalid=!this.updateValueOnInput&&this.value!==this.$.search.value}}customElements.define(CrSearchableDropDownElement.is,CrSearchableDropDownElement);