// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{CustomElement}from"//resources/js/custom_element.js";import{FocusOutlineManager}from"//resources/js/focus_outline_manager.js";import{getTemplate}from"./cr_tab_box.html.js";export class CrTabBoxElement extends CustomElement{static get template(){return getTemplate()}static get observedAttributes(){return["selected-index"]}constructor(){super();const tabs=this.$("#tablist");assert(tabs);this.tabs_=tabs;this.tabs_.addEventListener("keydown",(e=>this.onKeydown_(e)));this.tabs_.addEventListener("click",(e=>{const tabs=this.getTabs_();for(let i=0;i<e.composedPath().length;i++){const el=e.composedPath()[i];const index=tabs.findIndex((tab=>tab===el));if(index!==-1){this.setAttribute("selected-index",index.toString());break}}}));const panels=this.$("#tabpanels");assert(panels);this.panels_=panels;this.focusOutlineManager_=FocusOutlineManager.forDocument(document)}connectedCallback(){this.setAttribute("selected-index","0")}attributeChangedCallback(name,_oldValue,newValue){assert(name==="selected-index");const newIndex=Number(newValue);assert(!Number.isNaN(newIndex));this.getPanels_().forEach(((panel,index)=>{panel.toggleAttribute("selected",index===newIndex)}));this.getTabs_().forEach(((tab,index)=>{const isSelected=index===newIndex;tab.toggleAttribute("selected",isSelected);tab.setAttribute("tabindex",isSelected?"0":"-1");const firstSelection=!tab.hasAttribute("aria-selected");tab.setAttribute("aria-selected",isSelected?"true":"false");if(isSelected&&!firstSelection){tab.focus()}}));this.dispatchEvent(new CustomEvent("selected-index-change",{bubbles:true,composed:true,detail:newIndex}))}getTabs_(){return Array.from(this.tabs_.querySelector("slot").assignedElements())}getPanels_(){return Array.from(this.panels_.querySelector("slot").assignedElements())}onKeydown_(e){let delta=0;switch(e.key){case"ArrowLeft":case"ArrowUp":delta=-1;break;case"ArrowRight":case"ArrowDown":delta=1;break}if(!delta){return}if(document.documentElement.dir==="rtl"){delta*=-1}const count=this.getTabs_().length;const newIndex=(Number(this.getAttribute("selected-index"))+delta+count)%count;this.setAttribute("selected-index",newIndex.toString());this.focusOutlineManager_.visible=true}}customElements.define("cr-tab-box",CrTabBoxElement);