// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{afterNextRender,dedupingMixin}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{assert}from"//resources/js/assert.js";import{focusWithoutInk}from"//resources/js/focus_without_ink.js";import{FocusRow}from"//resources/js/focus_row.js";class FocusRowMixinDelegate{constructor(listItem){this.listItem_=listItem}onFocus(_row,e){const element=e.composedPath()[0];const focusableElement=FocusRow.getFocusableElement(element);if(element!==focusableElement){focusableElement.focus()}this.listItem_.lastFocused=focusableElement}onKeydown(_row,e){if(e.key==="Enter"){e.stopPropagation()}return false}getCustomEquivalent(sampleElement){return this.listItem_.overrideCustomEquivalent?this.listItem_.getCustomEquivalent(sampleElement):null}}class VirtualFocusRow extends FocusRow{constructor(root,delegate){super(root,null,delegate)}getCustomEquivalent(sampleElement){const equivalent=this.delegate?this.delegate.getCustomEquivalent(sampleElement):null;return equivalent||super.getCustomEquivalent(sampleElement)}}export const FocusRowMixin=dedupingMixin((superClass=>{class FocusRowMixin extends superClass{constructor(){super(...arguments);this.firstControl_=null;this.controlObservers_=[];this.boundOnFirstControlKeydown_=null}static get properties(){return{row_:Object,mouseFocused_:Boolean,id:{type:String,reflectToAttribute:true},isFocused:{type:Boolean,notify:true},focusRowIndex:{type:Number,observer:"focusRowIndexChanged"},lastFocused:{type:Object,notify:true},ironListTabIndex:{type:Number,observer:"ironListTabIndexChanged_"},listBlurred:{type:Boolean,notify:true}}}connectedCallback(){super.connectedCallback();this.classList.add("no-outline");this.boundOnFirstControlKeydown_=this.onFirstControlKeydown_.bind(this);afterNextRender(this,(()=>{const rowContainer=this.root.querySelector("[focus-row-container]");assert(rowContainer);this.row_=new VirtualFocusRow(rowContainer,new FocusRowMixinDelegate(this));this.addItems_();this.addEventListener("focus",this.onFocus_);this.addEventListener("dom-change",this.addItems_);this.addEventListener("mousedown",this.onMouseDown_);this.addEventListener("blur",this.onBlur_)}))}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("focus",this.onFocus_);this.removeEventListener("dom-change",this.addItems_);this.removeEventListener("mousedown",this.onMouseDown_);this.removeEventListener("blur",this.onBlur_);this.removeObservers_();if(this.firstControl_&&this.boundOnFirstControlKeydown_){this.firstControl_.removeEventListener("keydown",this.boundOnFirstControlKeydown_);this.boundOnFirstControlKeydown_=null}if(this.row_){this.row_.destroy()}}computeId_(index){return index!==undefined?`frb${index}`:undefined}focusRowIndexChanged(newIndex,oldIndex){this.setAttribute("aria-rowindex",(newIndex+1).toString());if(this.id===this.computeId_(oldIndex)){this.id=this.computeId_(newIndex)||""}}getFocusRow(){assert(this.row_);return this.row_}updateFirstControl_(){const newFirstControl=this.row_.getFirstFocusable();if(newFirstControl===this.firstControl_){return}if(this.firstControl_){this.firstControl_.removeEventListener("keydown",this.boundOnFirstControlKeydown_)}this.firstControl_=newFirstControl;if(this.firstControl_){this.firstControl_.addEventListener("keydown",this.boundOnFirstControlKeydown_)}}removeObservers_(){if(this.controlObservers_.length>0){this.controlObservers_.forEach((observer=>{observer.disconnect()}))}this.controlObservers_=[]}addItems_(){this.ironListTabIndexChanged_();if(this.row_){this.removeObservers_();this.row_.destroy();const controls=this.root.querySelectorAll("[focus-row-control]");controls.forEach((control=>{assert(control);this.row_.addItem(control.getAttribute("focus-type"),FocusRow.getFocusableElement(control));this.addMutationObservers_(control)}));this.updateFirstControl_()}}createObserver_(){return new MutationObserver((mutations=>{const mutation=mutations[0];if(mutation.attributeName==="style"&&mutation.oldValue){const newStyle=window.getComputedStyle(mutation.target);const oldDisplayValue=mutation.oldValue.match(/^display:(.*)(?=;)/);const oldVisibilityValue=mutation.oldValue.match(/^visibility:(.*)(?=;)/);if(oldDisplayValue&&newStyle.display===oldDisplayValue[1].trim()&&oldVisibilityValue&&newStyle.visibility===oldVisibilityValue[1].trim()){return}}this.updateFirstControl_()}))}addMutationObservers_(control){let current=control;while(current&&current!==this.root){const currentObserver=this.createObserver_();currentObserver.observe(current,{attributes:true,attributeFilter:["hidden","disabled","style"],attributeOldValue:true});this.controlObservers_.push(currentObserver);current=current.parentNode}}onFocus_(e){if(this.mouseFocused_){this.mouseFocused_=false;return}const restoreFocusToFirst=this.listBlurred&&e.composedPath()[0]===this;if(this.lastFocused&&!restoreFocusToFirst){focusWithoutInk(this.row_.getEquivalentElement(this.lastFocused))}else{assert(this.firstControl_);const firstFocusable=this.firstControl_;focusWithoutInk(firstFocusable)}this.listBlurred=false;this.isFocused=true}onFirstControlKeydown_(e){const keyEvent=e;if(keyEvent.shiftKey&&keyEvent.key==="Tab"){this.focus()}}ironListTabIndexChanged_(){if(this.row_){this.row_.makeActive(this.ironListTabIndex===0)}if(this.ironListTabIndex===0){this.listBlurred=false}}onMouseDown_(){this.mouseFocused_=true}onBlur_(e){this.mouseFocused_=false;this.isFocused=false;const node=e.relatedTarget?e.relatedTarget:null;if(!this.parentNode.contains(node)){this.listBlurred=true}}}return FocusRowMixin}));