// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../cr_shared_vars.css.js";import"../cr_shared_style.css.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{sanitizeInnerHtml}from"//resources/js/parse_html_subset.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./localized_link.html.js";export class LocalizedLinkElement extends PolymerElement{static get is(){return"localized-link"}static get template(){return getTemplate()}static get properties(){return{localizedString:String,linkUrl:{type:String,value:""},linkDisabled:{type:Boolean,value:false,reflectToAttribute:true,observer:"updateAnchorTagTabIndex_"},containerInnerHTML_:{type:String,value:"",computed:"getAriaLabelledContent_(localizedString, linkUrl)",observer:"setContainerInnerHtml_"}}}getAriaLabelledContent_(localizedString,linkUrl){const tempEl=document.createElement("div");tempEl.innerHTML=sanitizeInnerHtml(localizedString,{attrs:["id"]});const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){const element=node;element.id=`id${index}`;ariaLabelledByIds.push(element.id);return}assertNotReached("localized-link has invalid node types")}));const anchorTags=tempEl.querySelectorAll("a");if(anchorTags.length===0){return localizedString}assert(anchorTags.length===1,"localized-link should contain exactly one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.tabIndex=this.linkDisabled?-1:0;if(linkUrl!==""){anchorTag.href=linkUrl;anchorTag.target="_blank"}return tempEl.innerHTML}setContainerInnerHtml_(){this.$.container.innerHTML=sanitizeInnerHtml(this.containerInnerHTML_,{attrs:["aria-hidden","aria-labelledby","id","tabindex"]});const anchorTag=this.shadowRoot.querySelector("a");if(anchorTag){anchorTag.addEventListener("click",(event=>this.onAnchorTagClick_(event)));anchorTag.addEventListener("auxclick",(event=>{if(event.button===1){this.onAnchorTagClick_(event)}}))}}onAnchorTagClick_(event){if(this.linkDisabled){event.preventDefault();return}this.dispatchEvent(new CustomEvent("link-clicked",{bubbles:true,composed:true,detail:{event:event}}));event.stopPropagation()}updateAnchorTagTabIndex_(){const anchorTag=this.shadowRoot.querySelector("a");if(!anchorTag){return}anchorTag.tabIndex=this.linkDisabled?-1:0}}customElements.define(LocalizedLinkElement.is,LocalizedLinkElement);