// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_auto_img/cr_auto_img.js";import"./personalization_shared_icons.html.js";import"./common.css.js";import"./wallpaper.css.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./wallpaper_grid_item_element.html.js";function isSelectionEvent(event){return event instanceof MouseEvent&&event.type==="click"||event instanceof KeyboardEvent&&event.key==="Enter"}function getDataIndex(event){const dataIndex=event.currentTarget.dataset["index"];assert(typeof dataIndex==="string","data-index property required");const index=parseInt(dataIndex,10);assert(!isNaN(index),`could not parseInt on ${dataIndex}`);return index}function shouldShowPlaceholder(imageStatus){return imageStatus.length===0||imageStatus.includes("loading")&&!imageStatus.includes("error")}function getLoadingPlaceholderAnimationDelay(index){const rippleIndex=index%48;const animationDelay=83;return`--animation-delay: ${rippleIndex*animationDelay}ms;`}const wallpaperGridItemSelectedEventName="wallpaper-grid-item-selected";export class WallpaperGridItemSelectedEvent extends CustomEvent{constructor(){super(wallpaperGridItemSelectedEventName,{bubbles:true,composed:true,detail:null})}}export class WallpaperGridItemElement extends PolymerElement{static get is(){return"wallpaper-grid-item"}static get template(){return getTemplate()}static get properties(){return{src:{type:Object,observer:"onImageSrcChanged_",value:null},index:Number,primaryText:String,secondaryText:String,infoText:String,isGooglePhotos:{type:Boolean,value:false},dataSeaPenImage:{type:Boolean,value:false},selected:{type:Boolean,observer:"onSelectedChanged_"},disabled:{type:Boolean,value:false,observer:"onDisabledChanged_"},collage:{type:Boolean,value:false,reflectToAttribute:true,observer:"onCollageChanged_"},imageStatus_:{type:Array,value(){return[]},observer:"onImageStatusChanged_"}}}ready(){super.ready();this.addEventListener("click",this.onUserSelection_);this.addEventListener("keydown",this.onUserSelection_)}onUserSelection_(event){if(!isSelectionEvent(event)||this.disabled){return}event.preventDefault();event.stopPropagation();this.dispatchEvent(new WallpaperGridItemSelectedEvent)}onImageSrcChanged_(src,old){const oldSrcArray=this.getSrcArray_(old,this.collage);this.imageStatus_=this.getSrcArray_(src,this.collage).map((({url:url},i)=>{if(oldSrcArray.length>i&&oldSrcArray[i].url===url){return this.imageStatus_[i]}return"loading"}))}onSelectedChanged_(selected){if(typeof selected==="boolean"){this.setAttribute("aria-selected",selected.toString())}else{this.removeAttribute("aria-selected")}}onDisabledChanged_(disabled){this.setAttribute("aria-disabled",disabled.toString())}onCollageChanged_(collage){if(collage){const imageStatus=this.getSrcArray_(this.src,collage).map(((_,index)=>this.imageStatus_.length>index?this.imageStatus_[index]:"loading"));this.imageStatus_=imageStatus;return}this.imageStatus_.length=Math.min(2,this.imageStatus_.length)}onImageStatusChanged_(imageStatus){if(shouldShowPlaceholder(imageStatus)){this.setAttribute("placeholder","")}else{this.removeAttribute("placeholder")}}onImgError_(event){const targetIndex=getDataIndex(event);this.imageStatus_=this.imageStatus_.map(((status,index)=>index===targetIndex?"error":status))}onImgLoad_(event){const targetIndex=getDataIndex(event);this.imageStatus_=this.imageStatus_.map(((status,index)=>index===targetIndex?"ready":status))}getSrcArray_(src,collage){if(!src){return[]}if(Array.isArray(src)){const max=collage?4:2;return src.slice(0,max)}return[src]}isImageHidden_(imageStatus){assert(Array.isArray(imageStatus),"image status must be an array");return imageStatus.length===0||imageStatus.some((status=>status!=="ready"))}getItemPlaceholderAnimationDelay_(index){return getLoadingPlaceholderAnimationDelay(index)}isPrimaryTextVisible_(){return!!this.primaryText&&!!this.primaryText.length}isSecondaryTextVisible_(){return!!this.secondaryText&&!!this.secondaryText.length}isTextVisible_(){if(shouldShowPlaceholder(this.imageStatus_)){return false}return this.isSecondaryTextVisible_()||this.isPrimaryTextVisible_()}shouldShowInfoText_(){return typeof this.infoText==="string"&&this.infoText.length>0&&!shouldShowPlaceholder(this.imageStatus_)}getCheckMarkIcon_(){return this.dataSeaPenImage?"personalization-shared:sea-pen-circle-checkmark":"personalization-shared:circle-checkmark"}}customElements.define(WallpaperGridItemElement.is,WallpaperGridItemElement);