import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="cr-shared-style cros-color-overrides">
  cr-icon-button {
    --cr-icon-button-icon-size: 20px;
    --cr-icon-button-size: 32px;
    --cr-icon-button-margin-start: 0;
    --cr-icon-button-margin-end: 0;
  }
  /* When the first input is invalid, we hide the hint and show the
     error message. We remove the spacing for the error message when
     the input is valid.
  */
  #firstInput:not([invalid]) {
    --cr-input-error-display: none;
  }
  #firstInputHint {
    margin: 8px 0;
    font-size: var(--cr-form-field-label-font-size);
    height: var(--cr-form-field-label-height);
    line-height: var(--cr-form-field-label-line-height);
  }
  :host-context(.jelly-enabled)
    cr-input#firstInput,
    cr-input#confirmInput{
      --cr-input-background-color: var(--cros-sys-input_field_on_shaded);
  }
</style>
<cr-input
    id="firstInput"
    type="[[getPasswordInputType(isFirstPasswordVisible_)]]"
    required
    placeholder="[[i18nDynamic(locale, 'setLocalPasswordPlaceholder')]]"
    aria-label="[[firstInputAriaLabel]]"
    aria-description$="[[i18nDynamic(locale, 'setLocalPasswordMinCharsHint')]]"
    on-input="onInput"
    on-blur="onBlur"
    on-keyup="onKeyup"
    invalid="[[showFirstInputError(firstInputValidity_)]]"
    error-message="[[i18nDynamic(locale, 'setLocalPasswordMinCharsHint')]]">
  <cr-icon-button id="showPasswordButton" slot="inline-suffix"
      title="[[getShowHideButtonLabel(isFirstPasswordVisible_)]]"
      iron-icon="[[getShowHideButtonIcon(isFirstPasswordVisible_)]]"
      on-click="onFirstShowHidePasswordButtonClick">
</cr-input>
<div id="firstInputHint" hidden$="[[showFirstInputError(firstInputValidity_)]]">
  [[i18nDynamic(locale, 'setLocalPasswordMinCharsHint')]]
</div>
<cr-input
    id="confirmInput"
    type="[[getPasswordInputType(isConfirmPasswordVisible_)]]"
    required
    placeholder="[[i18nDynamic(locale, 'setLocalPasswordConfirmPlaceholder')]]"
    on-input="onInput"
    on-blur="onBlur"
    on-keyup="onKeyup"
    invalid="[[showConfirmInputError(confirmInputValidity_)]]"
    error-message="[[i18nDynamic(locale, 'setLocalPasswordNoMatchError')]]">
  <cr-icon-button id="showPasswordButton" slot="inline-suffix"
      title="[[getShowHideButtonLabel(isConfirmPasswordVisible_)]]"
      iron-icon="[[getShowHideButtonIcon(isConfirmPasswordVisible_)]]"
      on-click="onConfirmShowHidePasswordButtonClick">
</cr-input>
<!--_html_template_end_-->`;
}