import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="iron-positioning cros-color-overrides">
  :host ::slotted([slot='page-body']) {
    color: var(--cr-primary-text-color);
    height: 292px;
  }

  paper-progress {
    left: 0;
    position: absolute;
    top: 0;
    width: 100%;
    --paper-progress-active-color: var(--cros-icon-color-prominent);
    --paper-progress-container-color: rgba(var(--cros-icon-color-prominent-rgb),
                                           var(--cros-second-tone-opacity));
  }

  :host-context(body.jelly-enabled) paper-progress {
    --paper-progress-active-color: var(--cros-color-primary);
    --paper-progress-container-color: var(--cros-highlight-color);
  }

  #buttonBar {
    align-self: flex-end;
    margin-top: 30px;
  }

  #container {
    display: flex;
    flex-direction: column;
    height: 100%;
    margin: 0 8px 8px 8px;
  }

  #title {
    color: var(--cr-primary-text-color);
    font-weight: normal;
    line-height: 24px;
    margin: 24px 0 8px 0;
  }

  .cancel-button {
    margin-inline-end: 0;
  }

  .action-button {
    margin-inline-end: 0;
    margin-inline-start: 8px;
  }
</style>
<div id="container">
  <template is="dom-if" if="[[showScanProgress]]" restamp>
    <paper-progress indeterminate>
    </paper-progress>
  </template>
  <h3 id="title">[[i18n('bluetoothPairNewDevice')]]</h3>
  <slot name="page-body" id="pageBody"></slot>
  <div id="buttonBar">
    <template  is="dom-if"
        if="[[shouldShowButton_(ButtonName.CANCEL, buttonBarState.*)]]" restamp>
      <cr-button
          id="cancel"
          class="cancel-button"
          on-click="onCancelClick_"
          disabled$="[[isButtonDisabled_(ButtonName.CANCEL, buttonBarState.*)]]">
        [[i18n('cancel')]]
      </cr-button>
    </template>
    <template is="dom-if"
        if="[[shouldShowButton_(ButtonName.PAIR, buttonBarState.*)]]" restamp>
      <cr-button
          id="pair"
          class="action-button"
          on-click="onPairClick_"
          disabled$="[[isButtonDisabled_(ButtonName.PAIR, buttonBarState.*)]]">
        [[i18n('bluetoothPair')]]
      </cr-button>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}