import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style">
</style>
<template is="dom-if" if="[[!showMultipleBatteries_]]" restamp>
  <bluetooth-battery-icon-percentage
      id="defaultBattery"
      device="[[device]]"
      battery-type="[[BatteryType.DEFAULT]]"
      is-type-labeled>
  </bluetooth-battery-icon-percentage>
</template>

<template is="dom-if" if="[[showMultipleBatteries_]]" restamp>
  <div>
    <template is="dom-if"
        if="[[shouldShowBattery_(device, BatteryType.LEFT_BUD)]]" restamp>
      <bluetooth-battery-icon-percentage
          id="leftBudBattery"
          device="[[device]]"
          battery-type="[[BatteryType.LEFT_BUD]]"
          is-type-labeled>
      </bluetooth-battery-icon-percentage>
    </template>

    <template is="dom-if"
        if="[[shouldShowBattery_(device, BatteryType.CASE)]]" restamp>
      <bluetooth-battery-icon-percentage
          id="caseBattery"
          device="[[device]]"
          battery-type="[[BatteryType.CASE]]"
          is-type-labeled>
      </bluetooth-battery-icon-percentage>
    </template>

    <template is="dom-if"
        if="[[shouldShowBattery_(device, BatteryType.RIGHT_BUD)]]" restamp>
      <bluetooth-battery-icon-percentage
          id="rightBudBattery"
          device="[[device]]"
          battery-type="[[BatteryType.RIGHT_BUD]]"
          is-type-labeled>
      </bluetooth-battery-icon-percentage>
    </template>
  </div>
</template>
<!--_html_template_end_-->`;
}