import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-hidden-style iron-flex">
  span {
    background-color: var(--cros-bg-color-dropped-elevation-2);
    border-radius: 4px;
    font-size: 20px;
    height: 40px;
    text-align: center;
  }

  span.next {
    background-color: var(--cros-text-color-secondary);
    color: var(--cros-slider-label-text-color);
  }

  span.typed {
    background: var(--cros-bg-color-dropped-elevation-1);
    color: var(--cros-text-color-secondary);
  }

  #code {
    display: flex;
    flex-wrap: wrap;
    margin-inline: 30px;
  }

  #message {
    margin-bottom: 24px;
  }

  .center {
    align-items: center;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }

  .enter {
    font-weight: 500;
    margin-bottom: 8px;
    padding: 0 12px;
  }

  .key {
    border-radius: 4px;
    font-weight: 400;
    margin-bottom: 16px;
    margin-inline-end: 8px;
    margin-top: 8px;
    width: 40px;
  }
</style>
<bluetooth-base-page
    on-pair="onPairClicked_"
    focus-default
    button-bar-state="[[buttonBarState_]]">
  <div slot="page-body" id="pageBody" class="center" aria-live="polite">
    <div id="message">
      [[getMessage_(deviceName)]]
    </div>
    <div id="code" class="layout horizontal center center-justified">
      <dom-repeat items="[[keys_]]">
        <template>
          <span class$="center key [[getKeyClass_(index, numKeysEntered)]]">
            [[getKeyAt_(index, keys_)]]
          </span>
        </template>
      </dom-repeat>
      <span id="enter"
          class$="center enter [[getEnterClass_(numKeysEntered, keys_)]]">
        [[i18n('bluetoothEnterKey')]]
      </span>
    </div>
  </div>
</bluetooth-base-page>
<!--_html_template_end_-->`;
}