import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style iron-flex">[slot='page-body']{height:282px;margin-top:-20px}#container{height:230px;margin-top:20px;overflow-x:hidden;overflow-y:auto}#carrierLockWarningContainer{color:var(--cros-text-color-alert);display:flex;margin-bottom:24px;margin-top:20px}#carrierLockWarningIcon{--iron-icon-fill-color:var(--cros-icon-color-alert);--iron-icon-height:24px;--iron-icon-width:24px;margin-inline-end:4px}[scrollable] iron-list>:not(.no-outline):focus{background-color:transparent !important}
  </style>
  <base-page>
    <div slot="page-body">
      <localized-link
        id="profileListMessage"
        localized-string="[[i18nAdvanced('profileListPageMessageWithLink')]]"
        on-link-clicked="enterManuallyClicked_">
      </localized-link>
      <template is="dom-if"
        if="[[shouldShowCarrierLockWarning_(isDeviceCarrierLocked_)]]" restamp>
          <div id="carrierLockWarningContainer" aria-live="alert">
            <iron-icon id="carrierLockWarningIcon" icon="cellular-setup:warning">
            </iron-icon>
            [[i18n('eSimCarrierLockedDevice')]]
          </div>
      </template>
      <div id="container" class="layout vertical flex" scrollable>
        <iron-list id="profileList" items="[[pendingProfileProperties]]"
            scroll-target="container"
            preserve-focus
            selection-enabled
            selected-item="{{selectedProfileProperties}}"
            role="listbox">
          <template>
            <profile-discovery-list-item profile-properties="[[item]]"
                selected="[[isProfilePropertiesSelected_(item, selectedProfileProperties)]]"
                tabindex="0"
                role="option"
                aria-selected="[[isProfilePropertiesSelected_(item, selectedProfileProperties)]]">
            </profile-discovery-list-item>
          </template>
        </iron-list>
      </div>
    </div>
  </base-page>
<!--_html_template_end_-->`;
}
