import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="iron-flex cr-hidden-style">#animationContainer{align-items:flex-end;display:flex;height:216px;justify-content:center;margin-bottom:54px}#simDetectError,#simDetectErrorJelly{height:100%;width:100%}#simDetectError{background-image:url(chrome://resources/ash/common/cellular_setup/sim_detect_error.svg);background-position:center center;background-repeat:no-repeat;background-size:contain}@media (prefers-color-scheme:dark){#simDetectError{background-image:url(chrome://resources/ash/common/cellular_setup/sim_detect_error_dark.svg)}}:host-context(body.jelly-enabled) #simDetectError{display:none}:host-context(body:not(.jelly-enabled)) #simDetectErrorJelly{display:none}#pageBody{height:222px}cros-lottie-renderer{height:85%}base-page{--base-page-message-height:40px}</style>
<base-page title="[[loadingTitle]]" message="[[loadingMessage]]">
  <div slot="page-body" id="pageBody" class="layout vertical center-center">
    <iron-media-query query="(prefers-color-scheme: dark)"
        query-matches="{{isDarkModeActive_}}">
    </iron-media-query>
    <template is="dom-if" if="[[!isSimDetectError]]" restamp>
      <div id="animationContainer">
        <cros-lottie-renderer id="spinner"
            asset-url="chrome://resources/ash/common/cellular_setup/spinner.json"
            autoplay dynamic aria-hidden>
        </cros-lottie-renderer>
      </div>
    </template>
    <div id="simDetectError" hidden$="[[!isSimDetectError]]">
    </div>
    <iron-icon id="simDetectErrorJelly"
        icon="cellular-setup-illo:sim-detect-error"
        hidden$="[[!isSimDetectError]]">
    </iron-icon>
  </div>
</base-page>
<!--_html_template_end_-->`;
}
