import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>
  :host {
    --cr-toast-background: var(--cros-toast-background-color);
    --cr-toast-button-color: var(--cros-toast-button-color);
    --cr-toast-text-color: var(--cros-toast-text-color);
    --iron-icon-fill-color: var(--cros-toast-icon-color);
  }

  :host {
    align-items: center;
    background: var(--cr-toast-background);
    border-radius: 4px;
    bottom: 0;
    box-shadow: 0 2px 4px 0 rgba(0, 0, 0, 0.28);
    box-sizing: border-box;
    display: flex;
    margin: 24px;
    max-width: 568px;
    min-height: 52px;
    min-width: 288px;
    opacity: 0;
    padding: 0 24px;
    position: fixed;
    transform: translateY(100px);
    transition: opacity 300ms, transform 300ms;
    visibility: hidden;
    z-index: 1;
  }

  :host-context([chrome-refresh-2023]):host {
    border-radius: 8px;
    line-height: 20px;
    padding: 0 16px;
  }

  :host-context([dir=ltr]) {
    left: 0;
  }

  :host-context([dir=rtl]) {
    right: 0;
  }

  :host([open]) {
    opacity: 1;
    transform: translateY(0);
    visibility: visible;
  }

  /* Note: this doesn't work on slotted text nodes. Something like
   * <cr-toast>hey!</cr-toast> wont get the right text color. */
  :host ::slotted(*) {
    color: var(--cr-toast-text-color);
  }

  :host ::slotted(cr-button) {
    background-color: transparent !important;
    border: none !important;
    color: var(--cr-toast-button-color) !important;
    margin-inline-start: 32px !important;
    min-width: 52px !important;
    padding: 8px !important;
  }

  :host ::slotted(cr-button:hover) {
    background-color: transparent !important;
  }

  :host-context([chrome-refresh-2023]) ::slotted(cr-button:last-of-type) {
    margin-inline-end: -8px;
  }
</style>
<slot></slot>
<!--_html_template_end_-->`;
}
