import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style>
  :host {
    --diagram-bg-color: var(--cros-bg-color);
    --grid-gap: 4px;
    --key-travel: 3px;

    --rows: minmax(18px, 1fr) repeat(5, 2fr);
  }

  #keyboard {
    column-gap: var(--grid-gap);
    /*
     * Noto Sans Arabic has to be specified for certain Arabic diacritics to
     * display properly.
     */
    font-family: 'Noto Sans Arabic', 'Noto Sans', sans-serif;
    height: 250px;  /* Overriden by JavaScript */
    line-height: 13px;
    width: 100%;
  }

  .main-cluster {
    display: inline-grid;
    grid-gap: var(--grid-gap);
    grid-template-columns: repeat(29, 1fr);
    grid-template-rows: var(--rows);
    height: 100%;
    width: 100%;
  }

  keyboard-key {
    --keyboard-key-travel: var(--key-travel);
    grid-column: span 2;
  }

  #topRow {
    column-gap: var(--grid-gap);
    display: flex;
    grid-column: 1 / -1;
  }

  #topRow keyboard-key {
    flex-basis: 0;
    flex-grow: 1;
  }

  #arrowKeyCluster {
    display: grid;
    grid-column: span 6;
    grid-gap: var(--grid-gap);
    grid-template-columns: repeat(3, 1fr);
    grid-template-rows: repeat(2, 1fr);
  }

  #arrowKeyCluster keyboard-key {
    grid-column: span 1;
    grid-row: 2;
  }

  #arrowKeyCluster #upArrow {
    grid-column: 2;
    grid-row: 1;
  }

  /* Default (ANSI) key sizes */

  #backspaceKey,
  #tabKey,
  #enterKey {
    grid-column: span 3;
  }

  #launcherKey,
  #rightShiftKey,
  #leftAltKey {
    grid-column: span 4;
  }

  #leftShiftKey,
  #leftCtrlKey {
    grid-column: span 5;
  }

  #spacebar {
    grid-column: span 10;
  }

  /* Split modifier keyboard adjustments */

  [data-physical-layout='acer-split-modifier-with-numpad'] #launcherKey,
  [data-physical-layout='split-modifier'] #launcherKey {
    display: none;
  }

  [data-physical-layout='acer-split-modifier-with-numpad'] #assistantKey,
  [data-physical-layout='split-modifier'] #assistantKey {
    grid-column: span 4;
  }

  [data-bottom-left-layout='3keys'] #leftAltKey,
  [data-bottom-left-layout='4keys'] #leftAltKey {
    grid-column: span 2;
  }

  [data-bottom-left-layout='4keys'] #leftCtrlKey {
    grid-column: span 3;
  }

  [data-bottom-right-layout='3keys'] #spacebar {
    grid-column: span 8;
  }

  [data-bottom-right-layout='4keys'] #spacebar{
    grid-column: span 6;
  }

  /*
   * For ANSI Canadian Bilingual keyboard, the usual right ctrl key is
   * replaced by another key.
   */
  #caHybridKey {
    display: none;
  }
  [data-region-code='ca.hybridansi'] #rightCtrlKey {
    display: none;
  }
  [data-region-code='ca.hybridansi'] #caHybridKey {
    display: block;
  }

  /*
   * On ISO and JIS, the Enter key is L-shaped (with the backslash key moved
   * down one row). To achieve this with elements that fit in the grid, two
   * separate elements are placed on the grid, with their corners and
   * positioning tweaked to make them look like one key.
   */
  [data-mech-layout='iso'] #enterKey,
  [data-mech-layout='jis'] #enterKey {
    --keyboard-key-bottom-right-radius: 0;
    grid-column: 28 / -1;
    grid-row: 3;
  }

  #enterKeyLowerPart {
    display: none;
  }

  [data-mech-layout='iso'] #enterKeyLowerPart,
  [data-mech-layout='jis'] #enterKeyLowerPart {
    --keyboard-key-border-top-width: 0;
    --keyboard-key-top-radii: 0;
    display: block;
    grid-column: 29 / -1;
    /*
     * Expand the element upwards so that it overlaps the grid gap, key travel
     * area, and border of the actual Enter key on the row above.
     */
    margin-top: calc(-1 * var(--grid-gap) - var(--key-travel) - 1px);
  }

  [data-mech-layout='iso'] #backslashKey,
  [data-mech-layout='jis'] #backslashKey {
    grid-column: 27 / span 2;
    grid-row: 4;
  }

  /* Modifications for ISO */

  #isoKey {
    display: none;
  }

  [data-mech-layout='iso'] #isoKey {
    display: block;
  }

  [data-mech-layout='iso'] #leftShiftKey {
    grid-column: span 3;
  }

  /* Modifications for JIS */

  .jis-only {
    display: none;
  }

  [data-mech-layout='jis'] .jis-only {
    display: block;
  }

  /*
   * JIS crams in a few more keys, most notably an additional one on the number
   * row, so a 30-column grid makes more sense for it.
   */
  .main-cluster[data-mech-layout='jis'] {
    grid-template-columns: repeat(30, 1fr);
  }

  [data-mech-layout='jis'] #backspaceKey {
    grid-column: span 2;
  }

  [data-mech-layout='jis'] #spacebar {
    grid-column: span 6;
  }

  [data-mech-layout='jis'][data-bottom-right-layout='4keys'] #spacebar {
    grid-column: span 4;
  }

  [data-mech-layout='jis'] #rightShiftKey {
    grid-column: span 3;
  }

  [data-mech-layout='jis'][data-bottom-right-layout='2keys'] #arrowKeyCluster {
    grid-column: span 7;
  }

  [data-mech-layout='jis'] #arrowKeyCluster {
    grid-column: span 5;
  }

  /* Modifications for Dell Enterprise keyboards */

  [data-show-fn-and-globe-keys] #leftCtrlKey {
    grid-column: span 3;
  }

  [data-show-fn-and-globe-keys] #leftAltKey {
    grid-column: span 2;
  }

  #arrowKeyCluster #dellPageUpKey,
  #arrowKeyCluster #dellPageDownKey {
    grid-row: 1;
  }

  #layoutSwitchKey {
    --keyboard-key-icon-size: 60%;
  }

  /* Modifications for Assistant key */

  [data-show-assistant-key] #leftCtrlKey {
    grid-column: span 3;
  }

  /* Number pad */

  #numberPad {
    display: none;
  }

  [data-show-number-pad] .main-cluster {
    width: 77%;
  }

  [data-show-number-pad][data-number-pad-layout='3columns'] .main-cluster {
    width: 82%;
  }

  [data-show-number-pad][data-number-pad-layout='3columns'][data-physical-layout='acer-split-modifier-with-numpad'] .main-cluster {
    width: 85%;
  }

  [data-show-number-pad] #numberPad {
    box-sizing: border-box;
    display: inline-grid;
    grid-gap: var(--grid-gap);
    grid-template-columns: repeat(4, 1fr);
    grid-template-rows: var(--rows);
    height: 100%;
    /*
     * The number pad will always be on the right, even in RTL locales, so
     * disable the lint warning.
     */
    padding-left:  /* csschecker-disable-line left-right */
        calc(var(--grid-gap) * 3);
    width: 23%;
  }

  [data-show-number-pad][data-number-pad-layout='3columns'] #numberPad {
    box-sizing: border-box;
    display: inline-grid;
    grid-gap: var(--grid-gap);
    grid-template-columns: repeat(3, 1fr);
    grid-template-rows: var(--rows);
    height: 100%;
    /*
     * The number pad will always be on the right, even in RTL locales, so
     * disable the lint warning.
     */
    padding-left:  /* csschecker-disable-line left-right */
        calc(var(--grid-gap) * 3);
    width: 18%;
  }

  [data-show-number-pad][data-number-pad-layout='3columns'][data-physical-layout='acer-split-modifier-with-numpad'] #numberPad {
    box-sizing: border-box;
    display: inline-grid;
    grid-gap: var(--grid-gap);
    grid-template-columns: repeat(3, 1fr);
    grid-template-rows: var(--rows);
    height: 100%;
    /*
     * The number pad will always be on the right, even in RTL locales, so
     * disable the lint warning.
     */
    padding-left:  /* csschecker-disable-line left-right */
        calc(var(--grid-gap) * 1);
    width: 15%;
  }

  #numberPad keyboard-key {
    grid-column: span 1;
  }

  #numberPad .double-height {
    grid-row: span 2;
  }

  #numberPad .double-width {
    grid-column: span 2;
  }
</style>
<div id="widthChangeDetector">
  <!--
    We don't want to both observe and modify the size of #keyboard, so instead
    we observe the size of this empty element, which will change widths at the
    same time as #keyboard.
  -->
</div>
<div id="keyboard"
    data-show-number-pad$="[[showNumberPad]]"
    data-number-pad-layout$="[[numberPadLayout]]"
    data-physical-layout$="[[physicalLayout]]">
  <div class="main-cluster"
      data-mech-layout$="[[mechanicalLayout]]"
      data-show-assistant-key$="[[showAssistantKey]]"
      data-show-fn-and-globe-keys$="[[showFnAndGlobeKeys_]]"
      data-bottom-left-layout$="[[bottomLeftLayout]]"
      data-bottom-right-layout$="[[bottomRightLayout]]"
      data-region-code$="[[regionCode]]">
    <!--
      Most keys aren't labelled here, as their glyphs are set from the
      appropriate layout in keyboard_layouts.js. The exceptions are keys that
      have the same labels on all (or almost all) layouts on which they are
      present.
    -->

    <div id="topRow">
      <keyboard-key main-glyph="esc" data-code="1"></keyboard-key>
      <dom-repeat items="[[topRowKeys]]" as="key">
        <template>
          <keyboard-key
              icon="[[key.icon]]"
              main-glyph="[[key.text]]"
              aria-name="[[optionalI18n_(key.ariaNameI18n)]]">
          </keyboard-key>
        </template>
      </dom-repeat>
      <template is="dom-if" if="[[isEqual_(physicalLayout, 'acer-split-modifier-with-numpad')]]">
        <keyboard-key main-glyph="pg up" data-code="104"></keyboard-key>
        <keyboard-key main-glyph="pg dn" data-code="109"></keyboard-key>
      </template>
      <template is="dom-if" if="[[!isEqual_(numberPadLayout, '3columns')]]">
        <keyboard-key id="topRightKey" class="disabled"></keyboard-key>
      </template>

    </div>

    <keyboard-key data-code="41"></keyboard-key>
    <keyboard-key data-code="2"></keyboard-key>
    <keyboard-key data-code="3"></keyboard-key>
    <keyboard-key data-code="4"></keyboard-key>
    <keyboard-key data-code="5"></keyboard-key>
    <keyboard-key data-code="6"></keyboard-key>
    <keyboard-key data-code="7"></keyboard-key>
    <keyboard-key data-code="8"></keyboard-key>
    <keyboard-key data-code="9"></keyboard-key>
    <keyboard-key data-code="10"></keyboard-key>
    <keyboard-key data-code="11"></keyboard-key>
    <keyboard-key data-code="12"></keyboard-key>
    <keyboard-key data-code="13"></keyboard-key>
    <keyboard-key id="jisYenKey" class="jis-only" data-code="124">
    </keyboard-key>
    <keyboard-key
        id="backspaceKey"
        class="right"
        icon="keyboard:backspace"
        data-code="14"
        aria-name="[[i18n('keyboardDiagramAriaNameBackspace')]]">
    </keyboard-key>

    <keyboard-key
        id="tabKey"
        class="left"
        icon="keyboard:tab"
        data-code="15"
        aria-name="[[i18n('keyboardDiagramAriaNameTab')]]">
    </keyboard-key>
    <keyboard-key data-code="16"></keyboard-key>
    <keyboard-key data-code="17"></keyboard-key>
    <keyboard-key data-code="18"></keyboard-key>
    <keyboard-key data-code="19"></keyboard-key>
    <keyboard-key data-code="20"></keyboard-key>
    <keyboard-key data-code="21"></keyboard-key>
    <keyboard-key data-code="22"></keyboard-key>
    <keyboard-key data-code="23"></keyboard-key>
    <keyboard-key data-code="24"></keyboard-key>
    <keyboard-key data-code="25"></keyboard-key>
    <keyboard-key data-code="26"></keyboard-key>
    <keyboard-key data-code="27"></keyboard-key>
    <keyboard-key id="backslashKey" data-code="43"></keyboard-key>
    <keyboard-key
        id="launcherKey"
        class="left"
        icon="keyboard:launcher"
        data-code="125"
	aria-name="[[i18n('keyboardDiagramAriaNameLauncher')]]">
    </keyboard-key>
    <template is="dom-if" if="[[isEqual_(physicalLayout, 'split-modifier')]]">
      <keyboard-key
          id="assistantKey"
          class="left"
          icon="keyboard:caps"
          data-code="583"
          aria-name="[[i18n('keyboardDiagramAriaNameAssistant')]]"
          bottom-right-glyph="caps">
      </keyboard-key>
    </template>
    <template is="dom-if" if="[[isEqual_(physicalLayout, 'acer-split-modifier-with-numpad')]]">
      <keyboard-key
          id="assistantKey"
          class="left"
          icon="keyboard:caps"
          data-code="583"
          aria-name="[[i18n('keyboardDiagramAriaNameAssistant')]]"
          bottom-right-glyph="caps">
      </keyboard-key>
    </template>
    <keyboard-key data-code="30"></keyboard-key>
    <keyboard-key data-code="31"></keyboard-key>
    <keyboard-key data-code="32"></keyboard-key>
    <keyboard-key data-code="33"></keyboard-key>
    <keyboard-key data-code="34"></keyboard-key>
    <keyboard-key data-code="35"></keyboard-key>
    <keyboard-key data-code="36"></keyboard-key>
    <keyboard-key data-code="37"></keyboard-key>
    <keyboard-key data-code="38"></keyboard-key>
    <keyboard-key data-code="39"></keyboard-key>
    <keyboard-key data-code="40"></keyboard-key>
    <keyboard-key
        id="enterKey"
        class="right"
        icon="keyboard:return"
        data-code="28"
        aria-name="[[i18n('keyboardDiagramAriaNameEnter')]]">
    </keyboard-key>
    <keyboard-key id="enterKeyLowerPart" data-code="28" aria-hidden="true"></keyboard-key>

    <keyboard-key
        id="leftShiftKey"
        class="left"
        icon="keyboard:shift"
        data-code="42"
        aria-name="[[i18n('keyboardDiagramAriaNameShiftLeft')]]">
    </keyboard-key>
    <keyboard-key
        id="isoKey"
        bottom-left-glyph="&lt;"
        top-left-glyph="&gt;"
        data-code="86">
    </keyboard-key>
    <keyboard-key data-code="44"></keyboard-key>
    <keyboard-key data-code="45"></keyboard-key>
    <keyboard-key data-code="46"></keyboard-key>
    <keyboard-key data-code="47"></keyboard-key>
    <keyboard-key data-code="48"></keyboard-key>
    <keyboard-key data-code="49"></keyboard-key>
    <keyboard-key data-code="50"></keyboard-key>
    <keyboard-key data-code="51"></keyboard-key>
    <keyboard-key data-code="52"></keyboard-key>
    <keyboard-key data-code="53"></keyboard-key>
    <keyboard-key id="jisBackslashKey" class="jis-only" data-code="89"></keyboard-key>
    <keyboard-key
        id="rightShiftKey"
        class="right"
        icon="keyboard:shift"
        data-code="54"
        aria-name="[[i18n('keyboardDiagramAriaNameShiftRight')]]">
    </keyboard-key>

    <keyboard-key id="leftCtrlKey" class="left" main-glyph="ctrl" data-code="29"></keyboard-key>
    <template is="dom-if" if="[[showFnAndGlobeKeys_]]">
      <keyboard-key id="fnKey" class="disabled" main-glyph="fn"></keyboard-key>
      <keyboard-key
          id="layoutSwitchKey"
          icon="keyboard:layout-switch"
          data-code="584"
          aria-name="[[i18n('keyboardDiagramAriaNameLayoutSwitch')]]">
      </keyboard-key>
    </template>
    <template is="dom-if" if="[[showAssistantKey]]">
      <keyboard-key
          icon="keyboard:assistant"
          data-code="583"
          aria-name="[[i18n('keyboardDiagramAriaNameAssistant')]]">
      </keyboard-key>
    </template>
    <template is="dom-if" if="[[isEqual_(physicalLayout, 'split-modifier')]]">
      <keyboard-key id="fnKey" class="disabled" main-glyph="fn"></keyboard-key>
    </template>
    <template is="dom-if" if="[[isEqual_(physicalLayout, 'acer-split-modifier-with-numpad')]]">
      <keyboard-key id="fnKey" class="disabled" main-glyph="fn"></keyboard-key>
    </template>
    <template is="dom-if" if="[[isEqual_(bottomLeftLayout, '4keys')]]">
      <keyboard-key
          icon="keyboard:g-logo"
          data-code="125"
          aria-name="[[i18n('keyboardDiagramAriaNameLayoutSwitch')]]">
      </keyboard-key>
    </template>

    <keyboard-key id="leftAltKey" main-glyph="alt" data-code="56"></keyboard-key>
    <keyboard-key
        id="jisAlphanumericKey"
        class="jis-only"
        main-glyph="英数"
        data-code="94">
    </keyboard-key>
    <keyboard-key id="spacebar" main-glyph="" data-code="57"></keyboard-key>
    <keyboard-key
        id="jisKanaKey"
        class="jis-only"
        main-glyph="かな"
        data-code="92">
    </keyboard-key>
    <keyboard-key id="rightAltKey" main-glyph="alt" data-code="100"></keyboard-key>
    <template is="dom-if" if="[[isEqual_(bottomRightLayout, '3keys')]]">
      <keyboard-key id="fnKey" class="disabled" main-glyph="fn"></keyboard-key>
    </template>
    <template is="dom-if" if="[[isEqual_(bottomRightLayout, '4keys')]]">
      <keyboard-key
          id="layoutSwitchKey"
          icon="keyboard:layout-switch"
          data-code="584"
          aria-name="[[i18n('keyboardDiagramAriaNameLayoutSwitch')]]">
      </keyboard-key>
      <keyboard-key id="fnKey" class="disabled" main-glyph="fn"></keyboard-key>
    </template>

    <keyboard-key id="rightCtrlKey" main-glyph="ctrl" data-code="97"></keyboard-key>
    <keyboard-key id="caHybridKey" data-code="86"></keyboard-key>

    <div id="arrowKeyCluster">
      <template is="dom-if"
          if="[[isEqual_(physicalLayout, 'dell-enterprise-wilco')]]">
        <keyboard-key id="dellPageUpKey" main-glyph="pg up" data-code="104"></keyboard-key>
      </template>
      <keyboard-key
          id="upArrow"
          icon="keyboard:arrow-up"
          data-code="103"
          aria-name="[[i18n('keyboardDiagramAriaNameArrowUp')]]">
      </keyboard-key>
      <template is="dom-if"
          if="[[isEqual_(physicalLayout, 'dell-enterprise-wilco')]]">
        <keyboard-key id="dellPageDownKey" main-glyph="pg dn" data-code="109"></keyboard-key>
      </template>
      <keyboard-key
          icon="keyboard:arrow-left"
          data-code="105"
          aria-name="[[i18n('keyboardDiagramAriaNameArrowLeft')]]">
      </keyboard-key>
      <keyboard-key
          icon="keyboard:arrow-down"
          data-code="108"
          aria-name="[[i18n('keyboardDiagramAriaNameArrowDown')]]">
      </keyboard-key>
      <keyboard-key
          icon="keyboard:arrow-right"
          data-code="106"
          aria-name="[[i18n('keyboardDiagramAriaNameArrowRight')]]">
      </keyboard-key>
    </div>
  </div>
  <template is="dom-if" if="[[!isEqual_(numberPadLayout, '3columns')]]">
    <div id="numberPad">
      <keyboard-key main-glyph="pg up" data-code="104"></keyboard-key>
      <keyboard-key main-glyph="pg dn" data-code="109"></keyboard-key>
      <keyboard-key main-glyph="home" data-code="102"></keyboard-key>
      <keyboard-key main-glyph="end" data-code="107"></keyboard-key>

      <keyboard-key main-glyph="del" data-code="111"></keyboard-key>
      <keyboard-key main-glyph="/" data-code="98"></keyboard-key>
      <keyboard-key main-glyph="*" data-code="55"></keyboard-key>
      <keyboard-key main-glyph="-" data-code="74"></keyboard-key>

      <keyboard-key main-glyph="7" data-code="71"></keyboard-key>
      <keyboard-key main-glyph="8" data-code="72"></keyboard-key>
      <keyboard-key main-glyph="9" data-code="73"></keyboard-key>
      <keyboard-key class="double-height" main-glyph="+" data-code="78"></keyboard-key>

      <keyboard-key main-glyph="4" data-code="75"></keyboard-key>
      <keyboard-key main-glyph="5" data-code="76"></keyboard-key>
      <keyboard-key main-glyph="6" data-code="77"></keyboard-key>

      <keyboard-key main-glyph="1" data-code="79"></keyboard-key>
      <keyboard-key main-glyph="2" data-code="80"></keyboard-key>
      <keyboard-key main-glyph="3" data-code="81"></keyboard-key>
      <keyboard-key class="double-height" main-glyph="enter" data-code="96"></keyboard-key>

      <keyboard-key class="double-width" main-glyph="0" data-code="82"></keyboard-key>
      <keyboard-key main-glyph="." data-code="83"></keyboard-key>
    </div>
  </template>
  <template is="dom-if" if="[[isEqual_(numberPadLayout, '3columns')]]">
    <div id="numberPad">
      <template is="dom-if" if="[[isEqual_(physicalLayout, 'acer-split-modifier-with-numpad')]]">
        <keyboard-key main-glyph="home" data-code="102"></keyboard-key>
        <keyboard-key main-glyph="end" data-code="107"></keyboard-key>
        <keyboard-key class="disabled"></keyboard-key>
      </template>

      <template is="dom-if" if="[[!isEqual_(physicalLayout, 'acer-split-modifier-with-numpad')]]">
        <keyboard-key main-glyph="/" data-code="98"></keyboard-key>
        <keyboard-key main-glyph="*" data-code="55"></keyboard-key>
        <keyboard-key class="disabled"></keyboard-key>
      </template>

      <keyboard-key main-glyph="-" data-code="74"></keyboard-key>
      <keyboard-key main-glyph="+" data-code="78"></keyboard-key>
      <keyboard-key main-glyph="del" data-code="111"></keyboard-key>

      <keyboard-key main-glyph="7" data-code="71"></keyboard-key>
      <keyboard-key main-glyph="8" data-code="72"></keyboard-key>
      <keyboard-key main-glyph="9" data-code="73"></keyboard-key>

      <keyboard-key main-glyph="4" data-code="75"></keyboard-key>
      <keyboard-key main-glyph="5" data-code="76"></keyboard-key>
      <keyboard-key main-glyph="6" data-code="77"></keyboard-key>

      <keyboard-key main-glyph="1" data-code="79"></keyboard-key>
      <keyboard-key main-glyph="2" data-code="80"></keyboard-key>
      <keyboard-key main-glyph="3" data-code="81"></keyboard-key>

      <keyboard-key main-glyph="0" data-code="82"></keyboard-key>
      <keyboard-key main-glyph="." data-code="83"></keyboard-key>
      <keyboard-key main-glyph="enter" data-code="96"></keyboard-key>
    </div>
  </template>

</div>
<!--_html_template_end_-->`;
}