import '//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js';
import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';

const template = html`<iron-iconset-svg name="keyboard" size="24">
  <svg>
    <defs>
      <!-- Keep icons sorted alphabetically. -->
      <g id="arrow-down"><path d="M7.41 7.84L12 12.42l4.59-4.58L18 9.25l-6 6-6-6z"></g>
      <g id="arrow-left"><path d="M15.41 16.09l-4.58-4.59 4.58-4.59L14 5.5l-6 6 6 6z"></g>
      <g id="arrow-right"><path d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z"></g>
      <g id="arrow-up"><path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z"></g>
      <g id="assistant">
        <path d="m 8.36364,4.72725 c 2.41018,0 4.36366,1.95418 4.36366,4.36364 0,2.40945 -1.95348,4.36366 -4.36366,4.36366 C 5.95345,13.45455 4,11.50034 4,9.09089 4,6.68143 5.95345,4.72725 8.36364,4.72725 Z"></path>
        <path d="m 20,8.72722 c 0,0.60218 -0.4887,1.09091 -1.0909,1.09091 -0.6022,0 -1.0909,-0.48873 -1.0909,-1.09091 0,-0.60219 0.4887,-1.09091 1.0909,-1.09091 0.6022,0 1.0909,0.48872 1.0909,1.09091 z"></path>
        <path d="m 17.8182,11.27272 c 0,1.20513 -0.9768,2.18183 -2.1819,2.18183 -1.205,0 -2.1818,-0.9767 -2.1818,-2.18183 0,-1.2051 0.9768,-2.18182 2.1818,-2.18182 1.2051,0 2.1819,0.97672 2.1819,2.18182 z"></path>
        <path d="m 15.6363,19.27275 c 1.4059,0 2.5455,-1.1396 2.5455,-2.5455 0,-1.4058 -1.1396,-2.5454 -2.5455,-2.5454 -1.4058,0 -2.5454,1.1396 -2.5454,2.5454 0,1.4059 1.1396,2.5455 2.5454,2.5455 z"></path>
      </g>
      <g id="back"><path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"></g>
      <g id="backspace"><path fill-rule="evenodd" clip-rule="evenodd" d="M8 12.59L10.59 10L8 7.41L9.41 6L12 8.59L14.59 6L16 7.41L13.41 10L16 12.59L14.59 14L12 11.41L9.41 14L8 12.59ZM7 5L2.5 10L7.5 15H18V5H7ZM20 5V15C20 16.1 19.1 17 18 17H7C6.37 17 5.78 16.7 5.4 16.2L0 10L5.4 3.8C5.78 3.3 6.37 3 7 3H18C19.1 3 20 3.9 20 5Z"></path></g>
      <g id="control-panel" viewbox="0 0 20 20"><path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path></g>
      <g id="display-brightness-down" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M9.99982 4.13281L11.7889 5.87499H14.1285V8.15322L15.7799 9.76139L14.1285 11.5036V13.7818H11.7889L9.99982 15.39L8.34836 13.7818H6.00878V11.5036L4.21973 9.76139L6.00878 8.15322V5.87499H8.34836L9.99982 4.13281ZM9.99982 6.41105L8.89883 7.48315H7.66025V8.68928L6.5593 9.76139L7.66025 10.9675V12.0396H8.89883L9.99982 13.2457L11.2384 12.0396H12.3394V10.9675L13.5779 9.76139L12.3394 8.68928V7.48315H11.2384L9.99982 6.41105Z"></g>
      <g id="display-brightness-up" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M10.0686 2.64844L12.2706 4.92667H15.2982V7.87497L17.5002 10.0192L15.2982 12.1634V15.2457H12.2706L10.0686 17.3899L7.72908 15.2457H4.70145V12.1634L2.49951 10.0192L4.70145 7.87497V4.92667H7.72908L10.0686 2.64844ZM10.0686 4.92667L8.2796 6.53484H6.4905V8.27701L4.70145 10.0192L6.4905 11.7614V13.5035H8.2796L10.0686 15.2457L11.7201 13.5035H13.5092V11.7614L15.2982 10.0192L13.5092 8.27701V6.53484H11.7201L10.0686 4.92667Z"></g>
      <g id="electronic-privacy-screen" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M18 3V17H2V3H18ZM16 15H5.07314L15.0731 5H16V15ZM4 10.8284V13.2447L12.2447 5H9.82838L4 10.8284ZM6.99995 5L4 7.99995V5H6.99995Z"></g>
      <g id="forward"><path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"></g>
      <g id="fullscreen"><path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z"></g>
      <g id="jis-letter-switch" viewbox="0 0 28 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M23.1035 1.10156H23.0035C22.9239 1.10156 22.8476 1.13316 22.7914 1.18942C22.7351 1.24568 22.7035 1.32199 22.7035 1.40155L21.1035 5.90155C21.1035 6.10155 21.1035 6.20156 21.2035 6.30156L21.5035 6.50156H21.6035L22.8199 6.24814C23.1529 7.63802 23.3159 9.06553 23.3037 10.4992C23.3103 11.9252 23.1474 13.3447 22.82 14.7281L21.6035 14.5H21.5034H21.2035C21.1239 14.6173 21.0885 14.759 21.1035 14.9L22.7035 19.5L23.0034 19.7H23.4035L26.6035 16.1C26.683 15.9827 26.7184 15.841 26.7035 15.7L26.4035 15.4L25.147 15.1644C25.8918 12.0762 25.8864 8.85302 25.1307 5.76673L26.4035 5.50156L26.7035 5.30156V5.30155C26.7035 5.10156 26.7035 5.00155 26.6035 4.90155L23.4035 1.20155L23.1035 1.10156Z"></path>
        <path d="M5.8999 1.29845C5.8999 1.49845 5.7999 1.79844 5.7999 1.99844C5.7999 2.19844 5.6999 2.59844 5.5999 2.89844H6.2999C7.2999 2.89844 7.8999 3.29845 7.8999 4.59845C7.95316 5.68805 7.78301 6.77703 7.3999 7.79845C7.30865 8.08852 7.11859 8.33741 6.8628 8.50185C6.60702 8.66628 6.30168 8.73585 5.9999 8.69844L4.8999 8.49844L4.6999 7.39844H5.7999C6.0999 7.39844 6.2999 7.39845 6.4999 7.09845C6.72346 6.28463 6.82457 5.44206 6.7999 4.59845C6.7999 3.89845 6.4999 3.79845 5.9999 3.79845H5.3999C5.00318 5.48227 4.36312 7.09928 3.4999 8.59845L2.3999 8.09845C3.26504 6.86421 3.87684 5.47067 4.1999 3.99844H2.3999V2.79845H4.4999C4.6107 2.17054 4.67753 1.53565 4.6999 0.898438L5.8999 1.29845ZM8.9999 2.09845C9.65348 3.13598 10.1901 4.24272 10.5999 5.39844L9.3999 5.89844C9.15234 4.70031 8.63982 3.57278 7.8999 2.59845L8.9999 2.09845Z"></path>
        <path d="M16.3998 3.10001L14.7998 3.39999C14.35 4.75039 13.7102 6.02989 12.8998 7.2L11.7998 6.7C12.533 5.71391 13.1378 4.63863 13.5998 3.5H11.9998V2.5H13.9998C14.1156 2.00778 14.1826 1.50535 14.1998 1H15.3998C15.3843 1.4165 15.2821 1.82518 15.0998 2.2L16.2998 2L16.3998 3.10001ZM17.4998 3.89999V5C17.4907 5.40241 17.5242 5.80465 17.5998 6.2C18.2591 6.45935 18.8682 6.83159 19.3998 7.3L18.7998 8.3C18.4428 7.91818 18.0397 7.58226 17.5998 7.3V7.3C17.5998 8.1 17.1998 8.8 15.8998 8.8C14.5998 8.8 13.8998 8.3 13.8998 7.3C13.8998 6.3 14.5998 5.8 15.8998 5.8H16.4998C16.4998 5.1 16.3998 4.3 16.3998 3.8L17.4998 3.89999ZM16.4998 6.89999H15.7998C15.2998 6.89999 14.9998 7.09999 14.9998 7.39999C15.024 7.56782 15.1083 7.72116 15.2371 7.83151C15.3658 7.94187 15.5302 8.00174 15.6998 8C16.2998 8 16.4998 7.60001 16.4998 7.10001V6.89999ZM19.0998 4.39999L16.8998 3.10001L17.4998 2.2L19.6998 3.39999L19.0998 4.39999Z"></path>
        <path d="M7.2 16.707C8.0792 17.5943 9.25343 18.128 10.5 18.207C10.2422 18.5021 10.0391 18.8407 9.9 19.207C9.19538 19.1364 8.51261 18.9225 7.89357 18.5786C7.27453 18.2347 6.73225 17.768 6.3 17.207C5.8 18.007 4.7 18.707 2.7 19.207C2.53766 18.8292 2.2994 18.4889 2 18.207C4 17.907 4.9 17.307 5.3 16.707H2.2V15.707H3.1V13.607H5.7V12.707H6.8V13.607H9.5V15.707H10.3V16.707H7.2ZM4.1 12.407H2.3V11.407H4.1V10.707H5.1V11.407H7.4V10.707H8.4V11.407H10.2V12.407H8.4V13.207H7.4V12.407H5.1V13.207H4.1V12.407ZM5.7 15.707V14.607H4.1V15.707H5.7ZM6.8 14.607V15.707H8.4V14.607H6.8Z"></path>
        <path d="M19.5001 13.5008C19.3762 14.6855 19.0373 15.8376 18.5001 16.9008C18.9047 17.5225 19.4536 18.0371 20.1001 18.4008C19.782 18.6508 19.5111 18.9556 19.3001 19.3008C18.7087 18.9428 18.1979 18.4661 17.8001 17.9008C17.2793 18.5289 16.6319 19.04 15.9001 19.4008C15.9001 19.2008 15.7001 19.0008 15.6001 18.8008L15.2001 19.2008L14.2001 18.5008C13.5387 18.9344 12.7855 19.2083 12.0001 19.3008C11.9748 18.9925 11.8315 18.7059 11.6001 18.5008C12.189 18.4222 12.7624 18.2536 13.3001 18.0008L12.8001 17.7008V17.9008L11.9001 17.6008L12.5001 16.5008H11.7001V15.6008H13.0001L13.3001 15.0008H13.5001V14.1008C13.1045 14.5499 12.63 14.9227 12.1001 15.2008C11.9703 14.9128 11.8021 14.6437 11.6001 14.4008C12.199 14.14 12.7421 13.7665 13.2001 13.3008H11.7001V12.4008H12.4001C12.2738 12.0487 12.106 11.713 11.9001 11.4008L12.7001 11.1008C12.9074 11.4476 13.0751 11.8166 13.2001 12.2008L12.6001 12.4008H13.4001V10.9008H14.4001V12.4008H15.1001L14.5001 12.2008L15.1001 11.0008L16.0001 11.4008L15.2001 12.4008H16.1001V13.3008H14.6001L15.9001 14.0008L15.3001 14.8008L14.4001 14.0008V15.1008H14.2001L14.0001 15.5008H16.1001L15.4001 14.9008C16.1937 13.6685 16.6742 12.2611 16.8001 10.8008L17.9001 11.0008L17.6001 12.4008H20.0001V13.4008L19.5001 13.5008ZM13.3001 16.9008L14.0001 17.3008C14.1921 17.0677 14.3289 16.7942 14.4001 16.5008H13.5001L13.3001 16.9008ZM15.4001 16.5008C15.3146 16.93 15.1447 17.3379 14.9001 17.7008L15.7001 18.2008C16.3164 17.8809 16.8608 17.4385 17.3001 16.9008C17.0238 16.3184 16.7898 15.7168 16.6001 15.1008L16.2001 15.7008H16.1001V16.6008L15.4001 16.5008ZM17.3001 13.5008C17.3926 14.2593 17.5948 15.0003 17.9001 15.7008C18.1248 14.9819 18.292 14.2462 18.4001 13.5008H17.3001Z"></path>
      </g>
      <g id="keyboard-brightness-down" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L3.08636 8.06095L4.36619 6.88287L6 8.37845ZM3.45455 12V14H1V12H3.45455ZM11 5V7.22176H9V5H11ZM16.9136 8.06463L15.2838 9.56488L14 8.38312L15.6298 6.88287L16.9136 8.06463ZM16.5454 12H19V14H16.5454V12Z"></g>
      <g id="keyboard-brightness-toggle" viewbox="0 0 20 20">
        <path d="M 9.15049 2 L 10.8508 2 L 10.8508 7.03443 L 9.15049 7.03443 Z"></path>
        <path d="M 5.74972 12.0689 L 0.649957 12.0689 L 0.649957 10.3903 L 5.74972 10.3903 Z"></path>
        <path d="M 19.3501 12.0689 L 14.2503 12.0689 L 14.2503 10.3903 L 19.3501 10.3903 Z"></path>
        <path d="M 16.1818 3.7734 L 17.3838 4.95997 L 14.0176 8.28251 L 12.8156 7.09593 Z"></path>
        <path d="M 13.2192 15.6192 L 14.2571 16.6571 L 15.1208 17.5207 L 15.5999 18 L 16.7468 16.8545 L 11.9673 12.0698 L 12.5323 12.0698 L 12.5323 10.3913 L 10.2887 10.3899 L 3.28479 3.38476 L 2.138 4.52385 L 2.13032 4.53029 Z"></path>
      </g>
      <g id="keyboard-brightness-up" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L1.08636 6.06095L2.36619 4.88287L6 8.37845ZM3.45455 12V14H0V12H3.45455ZM11 2V7.22176H9V2H11ZM18.9136 6.06463L15.2838 9.56488L14 8.38312L17.6298 4.88287L18.9136 6.06463ZM16.5454 12H20V14H16.5454V12Z"></g>
      <g id="last-track" viewbox="0 0 20 20">
        <!--
          This is actually the rewind icon, to match the Chrome OS keyboard
          spec. Once the spec has been fixed this icon will be updated to match
          the Material "last track" icon.
        -->
        <path d="M10 10L16 14V6L10 10Z"></path>
        <path d="M10 10V14L4 10L10 6V10Z"></path>
      </g>
      <g id="launcher" viewbox="0 0 20 20">
        <path d="M10 15C12.7614 15 15 12.7614 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15Z"></path>
        <path fill-rule="evenodd" d="M10 18.5C14.6944 18.5 18.5 14.6944 18.5 10C18.5 5.30558 14.6944 1.5 10 1.5C5.30558 1.5 1.5 5.30558 1.5 10C1.5 14.6944 5.30558 18.5 10 18.5ZM17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z"></path>
      </g>
      <g id="layout-switch"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zm6.93 6h-2.95c-.32-1.25-.78-2.45-1.38-3.56 1.84.63 3.37 1.91 4.33 3.56zM12 4.04c.83 1.2 1.48 2.53 1.91 3.96h-3.82c.43-1.43 1.08-2.76 1.91-3.96zM4.26 14C4.1 13.36 4 12.69 4 12s.1-1.36.26-2h3.38c-.08.66-.14 1.32-.14 2 0 .68.06 1.34.14 2H4.26zm.82 2h2.95c.32 1.25.78 2.45 1.38 3.56-1.84-.63-3.37-1.9-4.33-3.56zm2.95-8H5.08c.96-1.66 2.49-2.93 4.33-3.56C8.81 5.55 8.35 6.75 8.03 8zM12 19.96c-.83-1.2-1.48-2.53-1.91-3.96h3.82c-.43 1.43-1.08 2.76-1.91 3.96zM14.34 14H9.66c-.09-.66-.16-1.32-.16-2 0-.68.07-1.35.16-2h4.68c.09.65.16 1.32.16 2 0 .68-.07 1.34-.16 2zm.25 5.56c.6-1.11 1.06-2.31 1.38-3.56h2.95c-.96 1.65-2.49 2.93-4.33 3.56zM16.36 14c.08-.66.14-1.32.14-2 0-.68-.06-1.34-.14-2h3.38c.16.64.26 1.31.26 2s-.1 1.36-.26 2h-3.38z"></path></g>
      <g id="lock" viewBox="0 0 20 20">
        <path d="M11.75 12.5C11.75 13.4665 10.9665 14.25 10 14.25C9.0335 14.25 8.25 13.4665 8.25 12.5C8.25 11.5335 9.0335 10.75 10 10.75C10.9665 10.75 11.75 11.5335 11.75 12.5Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14 7H13.5V5C13.5 3.34315 11.6569 2 10 2C8.34315 2 6.5 3.34315 6.5 5V7H6C4.89543 7 4 7.89543 4 9V16C4 17.1046 4.89543 18 6 18H14C15.1046 18 16 17.1046 16 16V9C16 7.89543 15.1046 7 14 7ZM12 5.5V7H8V5.5C8 5 8.5 3.5 10 3.5C11.5 3.5 12 5 12 5.5ZM6 9V16H14V9H6Z"></path>
      </g>
      <g id="microphone-mute" viewbox="0 0 20 20"><path d="M 15.4894 8.94314 L 13.9775 8.94314 C 13.9775 9.69794 13.8293 10.3021 13.5269 10.9057 L 14.5823 11.9623 C 15.187 11.2075 15.4894 10.1509 15.4894 8.94314 Z M 2.96096 2.6036 L 1.90551 3.66019 L 10.9595 12.7171 C 10.6572 12.7171 10.3548 12.8682 10.2065 12.8682 C 8.08988 12.8682 6.28133 11.0569 6.28133 8.94314 L 4.76949 8.94314 C 4.76949 11.6605 6.73206 13.9249 9.4477 14.3773 L 9.4477 16.7928 L 10.9595 16.7928 L 10.9595 14.3773 C 11.4102 14.3773 11.8666 14.2266 12.169 14.0754 L 16.0942 18 L 17.1496 16.9434 Z M 12.4714 8.94314 L 12.4714 4.26379 C 12.4714 2.9054 11.4102 2 10.2065 2 C 8.84865 2 7.94154 3.05659 7.94154 4.26379 L 7.94154 5.16975 L 12.4714 9.69794 C 12.3173 9.5473 12.4714 9.24551 12.4714 8.94314 Z"></path></g>
      <g id="next-track" viewbox="0 0 20 20">
        <!--
          This is actually the fast forward icon, to match the Chrome OS
          keyboard spec. Once the spec has been fixed this icon will be updated
          to match the Material "next track" icon.
        -->
        <path d="M10 10L4 14V6L10 10Z"></path>
        <path d="M10 10V14L16 10L10 6V10Z"></path>
      </g>
      <g id="overview" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M0.164062 15.3381H13.1281V4.65625H0.164062V15.3381ZM1.80029 6.28995H11.4919V13.7044H1.80029V6.28995ZM14.803 15.3381H16.4806V4.65625H14.803V15.3381ZM18.1583 4.65625H19.8359V15.3255H18.1583V4.65625Z"></g>
      <g id="play-pause" viewbox="0 0 20 20">
        <path fill-rule="evenodd" d="M3.53027 13.9683L10.1413 10.0017L3.53027 6.03516V13.9683Z"></path>
        <rect x="11.521" y="5.67969" width="2" height="8.28929"></rect>
        <rect x="14.5444" y="5.67969" width="2" height="8.28929"></rect>
      </g>
      <g id="power"><path d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z"></g>
      <g id="refresh"><path d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"></g>
      <g id="return"><path d="M9 18 3 12 9 6 10.4 7.4 6.8 11H19V7H21V13H6.8L10.4 16.6Z"></path></g>
      <g id="screen-mirror" viewbox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.1327 12.0716H15.0166V10.5716H16.6327V5.28516H9.57471V5.97091H8.07471V4.78516C8.07471 4.23287 8.52242 3.78516 9.07471 3.78516H17.1327C17.685 3.78516 18.1327 4.23287 18.1327 4.78516V11.0716C18.1327 11.6239 17.685 12.0716 17.1327 12.0716ZM14.228 15.0129H13.5443V7.49229C13.5443 7.30349 13.4678 7.13257 13.344 7.00884C13.2203 6.88512 13.0494 6.80859 12.8606 6.80859H3.28888C2.91128 6.80859 2.60518 7.11469 2.60518 7.49229V15.0129H1.92149C1.54389 15.0129 1.23779 15.319 1.23779 15.6966C1.23779 16.0742 1.54389 16.3803 1.92149 16.3803H14.228C14.6056 16.3803 14.9117 16.0742 14.9117 15.6966C14.9117 15.319 14.6056 15.0129 14.228 15.0129ZM12.1769 8.17598V12.9618H3.97257V8.17598H12.1769ZM6.70735 15.0129V14.3292H9.44213V15.0129H6.70735Z"></path></g>
      <g id="screenshot" viewbox="0 0 20 20"><path fill-rule="evenodd" d="M15.211 13.9537V6.04687H4.47659V13.9537H15.211ZM2.6875 4.30469H17V15.6958H2.6875V4.30469ZM10.8731 8.79554C10.5634 8.49395 10.1433 8.32451 9.70535 8.32451C9.26736 8.32451 8.84734 8.49395 8.53763 8.79554C8.22793 9.09713 8.05394 9.50617 8.05394 9.93268C8.05394 10.3592 8.22793 10.7682 8.53763 11.0698C8.84734 11.3714 9.26736 11.5408 9.70535 11.5408C10.1433 11.5408 10.5634 11.3714 10.8731 11.0698C11.1828 10.7682 11.3568 10.3592 11.3568 9.93268C11.3568 9.50617 11.1828 9.09713 10.8731 8.79554ZM8.02328 7.48126C8.52117 7.1573 9.10654 6.98438 9.70535 6.98438C10.5083 6.98438 11.2784 7.29501 11.8462 7.84792C12.414 8.40083 12.733 9.15074 12.733 9.93268C12.733 10.5158 12.5554 11.0858 12.2228 11.5707C11.8901 12.0555 11.4172 12.4334 10.864 12.6566C10.3108 12.8797 9.70199 12.9381 9.11469 12.8243C8.52739 12.7106 7.98792 12.4298 7.5645 12.0174C7.14107 11.6051 6.85274 11.0798 6.73591 10.5079C6.61909 9.93595 6.67904 9.34315 6.90819 8.80442C7.13734 8.26568 7.52539 7.80523 8.02328 7.48126Z"></g>
      <g id="shift" viewBox="0 0 20 20"><path d="M12.79 15.41H6.61V11.71H2L9.72 4L17.44 11.71H12.79V15.41ZM7.79 14.16H11.51V10.43H14.35L9.65 5.73001L4.95 10.43H7.79V14.16Z"></path></g>
      <g id="tab"><path d="M12 18 10.575 16.6 14.175 13H2V11H14.175L10.6 7.4L12 6L18 12ZM20 18V6H22V18Z"></path></g>
      <g id="volume-down"><path d="M18.5 12c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM5 9v6h4l5 5V4L9 9H5z"></g>
      <g id="volume-mute"><path d="M16.5 12c0-1.77-1.02-3.29-2.5-4.03v2.21l2.45 2.45c.03-.2.05-.41.05-.63zm2.5 0c0 .94-.2 1.82-.54 2.64l1.51 1.51C20.63 14.91 21 13.5 21 12c0-4.28-2.99-7.86-7-8.77v2.06c2.89.86 5 3.54 5 6.71zM4.27 3L3 4.27 7.73 9H3v6h4l5 5v-6.73l4.25 4.25c-.67.52-1.42.93-2.25 1.18v2.06c1.38-.31 2.63-.95 3.69-1.81L19.73 21 21 19.73l-9-9L4.27 3zM12 4L9.91 6.09 12 8.18V4z"></g>
      <g id="volume-up"><path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z"></g>
      <g id="accessibility"><path d="M9.99986 5.08337C10.4626 5.07903 10.9052 4.89326 11.2325 4.566C11.5597 4.23875 11.7455 3.79615 11.7499 3.33337C11.7512 3.04499 11.6813 2.76075 11.5463 2.50593C11.4113 2.2511 11.2154 2.03359 10.976 1.87273C10.7367 1.71188 10.4613 1.61266 10.1743 1.58391C9.8874 1.55516 9.5978 1.59777 9.33129 1.70795C9.06479 1.81812 8.82964 1.99245 8.64677 2.21542C8.46389 2.4384 8.33895 2.70311 8.28306 2.98603C8.22717 3.26894 8.24206 3.56127 8.3264 3.83704C8.41075 4.11281 8.56194 4.36346 8.76653 4.5667C8.92529 4.73331 9.11684 4.86523 9.3291 4.95415C9.54137 5.04307 9.76975 5.08707 9.99986 5.08337ZM17.1666 5C16.0351 5.30177 14.8815 5.51355 13.7166 5.63333C12.4808 5.74135 11.24 5.7803 9.9999 5.75C8.79161 5.74893 7.58427 5.68217 6.38323 5.55C5.22057 5.45758 4.067 5.27368 2.93324 5H2.8499L2.3999 6.66667C3.25512 6.9134 4.12305 7.11369 4.9999 7.26667C5.83323 7.4 6.66657 7.5 7.46657 7.58333V18.4167H9.2999V13.4167H10.7999V18.4167H12.6332V7.58333C13.4499 7.5 14.2999 7.4 15.0999 7.26667C15.9304 7.13656 16.7537 6.96411 17.5666 6.75H17.6499L17.1666 5Z"></path></g>
      <g id="dictation"><path xmlns="http://www.w3.org/2000/svg" d="M9.63018 2.0835V3.91683H17.1302V17.0835H7.29685V15.4168H5.46351V18.9168H18.9635V2.0835H9.63018ZM6.38019 8.83349C6.59953 8.83475 6.81697 8.79271 7.02003 8.70977C7.2231 8.62683 7.40779 8.50462 7.56352 8.35015C7.71799 8.19442 7.8402 8.00973 7.92314 7.80666C8.00608 7.6036 8.04812 7.38616 8.04685 7.16682V3.83349C8.04812 3.61414 8.00608 3.3967 7.92314 3.19364C7.8402 2.99058 7.71799 2.80589 7.56352 2.65015C7.40779 2.49568 7.2231 2.37347 7.02003 2.29053C6.81697 2.20759 6.59953 2.16555 6.38019 2.16682C6.16005 2.15968 5.94088 2.19903 5.73699 2.28231C5.53309 2.3656 5.34904 2.49094 5.19685 2.65015C5.04238 2.80589 4.92018 2.99058 4.83723 3.19364C4.75429 3.3967 4.71225 3.61414 4.71352 3.83349V7.16682C4.71225 7.38616 4.75429 7.6036 4.83723 7.80666C4.92018 8.00973 5.04238 8.19442 5.19685 8.35015C5.35259 8.50462 5.53728 8.62683 5.74034 8.70977C5.9434 8.79271 6.16084 8.83475 6.38019 8.83349M8.88019 13.8335H15.5469V15.5001H8.88019V13.8335ZM15.5469 11.3335H10.5469V13.0001H15.5469V11.3335ZM7.29685 11.7335V13.9168H5.46352L5.43019 11.7335C4.38412 11.5427 3.4394 10.9877 2.76352 10.1668C2.0882 9.31622 1.73941 8.25212 1.78019 7.16681H3.61352C3.60949 7.53778 3.67965 7.90581 3.8199 8.24927C3.96015 8.59273 4.16764 8.90469 4.43019 9.16681C4.69034 9.43313 5.00156 9.64421 5.34522 9.7874C5.68888 9.93059 6.0579 10.0029 6.43019 10.0001C6.80275 10.0049 7.17235 9.93341 7.51628 9.79011C7.86022 9.6468 8.17122 9.43469 8.43019 9.16681C8.69807 8.90784 8.91018 8.59684 9.05349 8.25291C9.19679 7.90897 9.26827 7.53937 9.26352 7.16681H11.0969C11.0957 8.27121 10.6929 9.33749 9.96352 10.1668C9.28209 10.9812 8.33992 11.5347 7.29685 11.7335Z"></path></g>
      <g id="g-logo"><path d="M10.151 16.2131C9.3458 16.2141 8.54882 16.0517 7.80826 15.7357C6.3193 15.1283 5.12487 13.9657 4.47742 12.4937C4.16226 11.7373 4 10.926 4 10.1066C4 9.28717 4.16226 8.47586 4.47742 7.71948C5.12487 6.24748 6.3193 5.0849 7.80826 4.47746C9.26728 3.86889 10.9038 3.84109 12.3826 4.39975C13.0831 4.68229 13.7293 5.08425 14.2923 5.58774L12.5492 7.28647C12.2246 6.99057 11.8482 6.75719 11.4389 6.5981C10.7797 6.34923 10.0624 6.29755 9.37431 6.44935C8.68627 6.60116 8.05726 6.94989 7.564 7.45301C6.88124 8.16775 6.50024 9.11815 6.50024 10.1066C6.50024 11.095 6.88124 12.0454 7.564 12.7602C7.89644 13.1152 8.29907 13.3972 8.74633 13.5884C9.19358 13.7795 9.6757 13.8756 10.1621 13.8704C10.9623 13.886 11.7445 13.6318 12.3826 13.1487C12.9797 12.6986 13.378 12.0335 13.4929 11.2946H10.1621V8.9963H15.8689C15.8689 9.22946 15.9577 9.44042 15.991 9.62916C16.003 9.83254 16.003 10.0364 15.991 10.2398C16.0246 11.0281 15.9005 11.8152 15.6259 12.5549C15.3514 13.2947 14.932 13.9722 14.3922 14.5477C13.8392 15.1039 13.1766 15.5392 12.4465 15.8259C11.7164 16.1125 10.9347 16.2444 10.151 16.2131Z"></path></g>
      <g id="caps"><path d="M2 10L10 2L18 10L10 18L2 10ZM10 3.78238L3.78238 10L10 16.2176L16.2176 10L10 3.78238ZM10.6011 9.46115H13.2436V10.7047H10.6011V13.3472H9.35755V10.7047H6.7047V9.46115H9.35755V6.80831H10.6011V9.46115Z"></g>
      <g id="split-modifier-overview"><path d="M4 5.94995H8.23001V9.29994H4V5.94995ZM5 6.94994V8.29994H7.2V6.94994H5Z M9.63 9.29994V5.94995H16.1V9.29994H9.63ZM10.63 6.94994V8.29994H15.1V6.94994H10.63Z M11.88 14.0499H16.1V10.7H11.88V14.0499ZM15.1 11.6999V13.0499H12.9V11.6999H15.1Z M10.48 14.0499H4V10.7H10.48V14.0499ZM9.38 13.0499V11.6999H5V13.0499H9.38Z"></g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template.content);
