import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style">
    @media (min-width: 600px) {
      :host {
        --keyboard-key-icon-size: 10px;
      }
      #key {
        font-size: 10px;
        line-height: 10px;
      }
    }

    @media (min-width: 768px) {
      :host {
        --keyboard-key-icon-size: 12px;
      }
      #key {
        font-size: 11px;
        line-height: 16px;
      }
    }

    @media (min-width: 960px) {
      :host {
        --keyboard-key-icon-size: 14px;
      }
      #key {
        font-size: 12px;
        line-height: 18px;
      }
    }

    @media (min-width: 1280px) {
      :host {
        --keyboard-key-icon-size: 20px;
      }
      #key {
        font-size: 13px;
        line-height: 20px;
      }
    }

  :host {
    --background-color-disabled: var(--cros-bg-color-dropped-elevation-2);
    --background-color-pressed: var(--google-blue-800);
    --background-color-unpressed: var(--cros-highlight-color);
    --background-color-tested: rgba(var(--cros-icon-color-selection-rgb),
        .85);
    --border-color: var(--cros-text-color-selection);
    --border-radius:
        var(--keyboard-key-top-radii, 4px)
        var(--keyboard-key-top-radii, 4px)
        var(--keyboard-key-bottom-right-radius, 4px)
        4px;
    --host-bg-color: var(--diagram-bg-color);
    --icon-size: min(100%, var(--keyboard-key-icon-size, 100%));
    --travel: var(--keyboard-key-travel, 4px);
    --text-color-unpressed: var(--cros-text-color-selection);
    --text-color-pressed: var(--cros-button-icon-color-primary);
    --text-color-tested: var(--cros-button-icon-color-primary);
    position: relative;
  }

  /* TODO(276493287): Remove host-context and replace default colors with jelly
                      colors once experiment launches. */
  :host-context(body.jelly-enabled) {
    --background-color-disabled: var(--cros-sys-disabled_container);
    --background-color-pressed: var(--cros-button-background-color-primary);
    --background-color-unpressed: var(--cros-sys-highlight_shape);
    --background-color-tested: var(--cros-sys-highlight_text);
    --border-color: var(--cros-icon-color-prominent);
    --text-color-unpressed: var(--cros-icon-color-prominent);
    --text-color-pressed: var(--cros-button-icon-color-primary);
    --text-color-tested: var(--cros-icon-color-prominent);
  }

  @media (prefers-color-scheme: dark) {
    :host {
      --background-color-disabled: var(--cros-bg-color-elevation-4);
      --background-color-pressed: var(--cros-icon-color-selection);
      --background-color-unpressed: var(--cros-button-active-shadow-color-ambient-primary);
      --background-color-tested: rgba(var(--cros-icon-color-selection-rgb),
        .65);
    }

    /* TODO(276493287): Remove host-context and replace default colors with
                        jelly colors once experiment launches. */
    :host-context(body.jelly-enabled) {
      --background-color-disabled: var(--cros-sys-disabled_container);
      --background-color-tested: var(--cros-sys-highlight_text);
    }
  }

  #key {
    background-color: var(--background-color-unpressed);
    border: 1px solid var(--border-color);
    border-radius: var(--border-radius);
    border-top-width: var(--keyboard-key-border-top-width, 1px);
    bottom: var(--travel);
    color: var(--text-color-unpressed);
    display: grid;
    font-family: 'Google Sans', sans-serif;
    grid-auto-columns: 1fr;
    grid-auto-flow: column;
    grid-template-columns: 1fr;
    grid-template-rows: repeat(2, 1fr);
    left: 0;
    position: absolute;
    right: 0;
    top: 0;
    transition: all 150ms ease-in-out;
  }

  #key-background {
    background-color: var(--host-bg-color);
    border: 1px solid var(--border-color);
    border-radius: var(--border-radius);
    border-top-width: var(--keyboard-key-border-top-width, 1px);
    bottom: var(--travel);
    left: 0;
    position: absolute;
    right: 0;
    top: 0;
    transition: all 150ms ease-in-out;
  }

  iron-icon {
    --iron-icon-fill-color: var(--text-color-unpressed);
    --iron-icon-height: var(--icon-size);
    --iron-icon-width: var(--icon-size);
    align-self: center;
    grid-row: span 2;
    justify-self: center;
  }

  :host(.left) iron-icon,
  :host(.right) iron-icon {
    --iron-icon-width: 24px;
    padding: 0 5px;
  }

  :host(.left) iron-icon {
    justify-self: left;
  }

  :host(.right) iron-icon {
    justify-self: right;
  }

  #mainGlyph {
    left: 0;
    overflow: clip visible;
    position: absolute;
    right: 0;
    text-overflow: ellipsis;
    white-space: nowrap;
  }

  #mainGlyph:not(:empty) {
    padding: 0 5px;
  }

  /* Key labels won't change sides in RTL locales, so disable lint warning. */
  :host(.left) #mainGlyph {
    text-align: left;  /* csschecker-disable-line left-right */
  }

  :host(.right) #mainGlyph {
    text-align: right;  /* csschecker-disable-line left-right */
  }

  span {
    align-self: center;
    text-align: center;
  }

  :host([state='pressed']) #key {
    background-color: var(--background-color-pressed);
    border-color: var(--background-color-pressed);
    bottom: 0;
    color: var(--text-color-pressed);
    top: var(--travel);
  }

  :host([state='pressed']) #key-background {
    bottom: 0;
    top: var(--travel);
  }

  :host([state='pressed']) iron-icon {
    --iron-icon-fill-color: var(--text-color-pressed);
  }

  :host([state='tested']) #key {
    background-color: var(--background-color-tested);
    color: var(--text-color-tested);
  }

  :host([state='tested']) iron-icon {
    --iron-icon-fill-color: var(--text-color-tested);
  }

  #shadow {
    background-color: var(--border-color);
    border-radius: var(--border-radius);
    bottom: 0;
    left: 0;
    position: absolute;
    right: 0;
    top: var(--travel);
  }

  :host(.disabled) {
    --travel: 0;
  }

  :host(.disabled) #key {
    background-color: var(--background-color-disabled);
    border-color: transparent;
    bottom: 0;
    color: var(--cros-icon-color-disabled);
    top: var(--travel);
  }

  :host(.disabled) #key-background {
    border-color: transparent;
    bottom: 0;
    top: var(--travel);
  }

  :host(.disabled) #shadow {
    background-color: var(--background-color-disabled);
  }
</style>
<div id="shadow"></div>
<div id="key-background"></div>
<div id="key" aria-label="[[ariaLabel_]]" role="img">
  <!--
    Child elements are aria-hidden to make ChromeVox treat the whole key as
    one unit with an aria-label, rather than individual labels that don't
    reflect the key's state.
  -->
  <template is="dom-if" if="[[icon]]">
    <iron-icon aria-hidden="true" icon="[[icon]]"></iron-icon>
  </template>
  <template is="dom-if" if="[[mainGlyph]]">
    <span aria-hidden="true" id="mainGlyph">[[mainGlyph]]</span>
  </template>
  <template is="dom-if" if="[[showCornerGlyphs_]]">
    <span aria-hidden="true">[[topLeftGlyph]]</span>
    <span aria-hidden="true">[[bottomLeftGlyph]]</span>
    <template is="dom-if" if="[[showSecondColumn_]]">
      <span aria-hidden="true">[[topRightGlyph]]</span>
      <span aria-hidden="true">[[bottomRightGlyph]]</span>
    </template>
  </template>
</div>
<!--_html_template_end_-->`;
}