import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="multidevice-setup-shared">
  :host {
    display: block;
    height: 100%;
    overflow: scroll;
    width: 100%;
  }

  #container {
    background-color: var(--cros-sys-app_base);
    box-sizing: border-box;
    color: var(--cros-sys-on_surface_variant);
    display: flex;
    flex-direction: column;
    font-family: var(--cros-font-family-google-sans);
    font-size: 13px;
    height: 100%;
    line-height: 16px;
    margin: auto;
  }

  iron-pages {
    height: 100%;
    overflow: var(--iron-pages-overflow, visible);
  }

  button-bar {
    padding: 24px;
  }

  @media screen and (orientation: portrait) {
    :host-context([screen=oobe]) button-bar,
    :host-context([screen=gaia-signin]) button-bar {
      align-items: center;
    }
  }
</style>
<div id="container">
  <iron-pages id="ironPages"
      attr-for-selected="is"
      selected="[[visiblePageName]]"
      selected-item="{{visiblePage_}}"
      aria-live="assertive">
    <template is="dom-if" if="[[shouldPasswordPageBeIncluded_(delegate)]]"
        restamp>
      <password-page class="ui-page"
          auth-token="{{authToken_}}"
          forward-button-disabled="{{passwordPageForwardButtonDisabled_}}"
          password-field-valid="{{passwordFieldValid}}"
          on-user-submitted-password="onUserSubmittedPassword_">
      </password-page>
    </template>
    <template is="dom-if"
        if="[[shouldSetupSucceededPageBeIncluded_(delegate)]]" restamp>
      <setup-succeeded-page class="ui-page"></setup-succeeded-page>
    </template>
    <start-setup-page class="ui-page"
        devices="[[devices_]]"
        selected-instance-id-or-legacy-device-id="{{selectedInstanceIdOrLegacyDeviceId_}}"
        delegate="[[delegate]]">
    </start-setup-page>
  </iron-pages>
  <div class="flex"></div>
  <button-bar id="buttonBar"
      forward-button-text-id="[[forwardButtonTextId]]"
      backward-button-text-id="[[backwardButtonTextId]]"
      cancel-button-text-id="[[cancelButtonTextId]]"
      should-show-shadow="[[isScrolledToBottom_]]"
      forward-button-disabled="[[forwardButtonDisabled]]">
  </button-bar>
</div>
<!--_html_template_end_-->`;
}