import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="multidevice-setup-shared">
  #user-info-container  {
    align-items: center;
    color: var(--cros-sys-on_surface_variant);
    display: flex;
    padding-top: 32px;
  }

  #profile-photo {
    border-radius: 50%;
    height: 20px;
    margin-inline-end: 8px;
    width: 20px;
  }

  #passwordInput {
    height: 32px;
    margin-top: 48px;
    width: 100%;
  }

  :host-context([orientation=horizontal]) #passwordInput {
    width: min(calc(var(--multidevice-setup-dialog-width) -
        2 * var(--multidevice-setup-dialog-content-padding)), 640px);
  }

  :host-context([orientation=vertical]) #passwordInput {
    width: min(calc(var(--multidevice-setup-dialog-width) -
        2 * var(--multidevice-setup-dialog-content-padding)), 480px);
  }

  :host-context([orientation=vertical]) #content-container {
    align-items: center;
    display: flex;
    flex-direction: column;
  }

  :host-context([orientation=horizontal]) #user-info-container {
    padding-top: 0;
  }
</style>
<ui-page header-text="[[passwordPageHeader_]]"
    icon-name="google-g">
  <div id="content-container" slot="message">
    <div id="user-info-container">
      <img id="profile-photo" src="[[profilePhotoUrl_]]" aria-hidden="true"></img>
      <span id="email">[[email_]]</span>
    </div>
    <cr-input id="passwordInput" type="password"
        placeholder="[[authPrompt_]]"
        invalid="[[passwordInvalid_]]"
        error-message="[[authError_]]"
        value="{{inputValue_}}"
        aria-disabled="false"
        on-keypress="onInputKeypress_">
    </cr-input>
  </div>
</ui-page>
<!--_html_template_end_-->`;
}