import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><!--
Copyright 2025 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style>
  :host {
    height: 100%;
    width: 100%;
  }
  #container {
    height: 100%;
    position: relative;
    width: 100%;
  }
  #animation {
    height: 100%;
    position: absolute;
    width: 100%;
  }
  #playPauseIcon {
    bottom: 0;
    left: 0;
    margin: auto;
    opacity: 0; /* We use opacity to hide/show the element so it stays in
                    the tab index */
    position: absolute;
    right: 0;
    top: 0;
  }
  #playPauseIcon:focus,
  :host(:hover) #playPauseIcon {
    opacity: 1;
  }
  cr-icon-button {
    --cr-icon-button-icon-size: 40px;
    --cr-icon-button-size: 48px;
  }
</style>
<div id="container">
  <!-- <cros-lottie-renderer> created dynamically -->
  <div id="playPauseIconContainer" hidden="[[hidePlayPauseIcon]]" >
    <cr-icon-button id="playPauseIcon" iron-icon="[[getIcon(playing)]]"
        aria-label$="[[getAria(locale, playing)]]"></cr-icon-button>
  </div>

</div><!--_html_template_end_-->`;
}