import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="multidevice-setup-shared">
  #singleDeviceName {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
    font-family: var(--cros-font-family-google-sans);
  }

  .offline-device-name {
    color: var(--cros-sys-on_surface_variant);
    font: var(--cros-body-2-font);
    font-family: var(--cros-font-family-google-sans);
  }

  #animation-container {
    padding-top: 16px;
  }

  :host-context([orientation=horizontal]) #animation-container {
    height: 172px;
    transform: translateX(-20px);
  }

  :host-context([orientation=vertical]) #animation-container {
    margin-bottom: -20px;
  }

  .footnote {
    padding-top: 16px;
  }

  #deviceSelectionContainer {
    display: flex;
    flex-direction: column;
  }

  #deviceDropdown {
    margin-top: 8px;
  }

  #singleDeviceName {
    margin-top: 8px;
  }

  .feature-detail {
    align-items: center;
    box-sizing: border-box;
    display: flex;
    min-height: 48px;
    padding: 18px 0;
    gap: 20px;
  }

  #feature-details-container-header {
    margin-bottom: 16px;
  }

  .feature-detail-text {
    display: flex;
    justify-content: flex-start;
    flex-direction: column;
    max-width: 60%;
  }

  .feature-detail-text > span:first-of-type {
    font-weight: bold;
  }

  :host-context([orientation=horizontal]) #additional-content-container {
    display: flex;
    flex-direction: column;
    justify-content: center;
  }

  #feature-details-container {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-1-font);
    font-family: var(--cros-font-family-google-sans);
    padding-top: 40px;
  }

  .feature-detail:not(:last-of-type) {
    border-bottom: 1px solid var(--cros-sys-separator);
  }

  .feature-detail iron-icon {
    --iron-icon-fill-color: var(--cros-sys-primary);
    --iron-icon-height: 20px;
    --iron-icon-width: 20px;
    min-width: 20px;
  }

  /* Hide the animation when not enough space in vertical mode. */
  @media screen and (max-height: 1048px) {
    :host-context([orientation=vertical][screen=oobe])
        #animation-container {
      display: none;
    }
  }

  @media screen and (max-height: 832px) {
    :host-context([orientation=vertical][screen=gaia-signin])
        #animation-container {
      display: none;
    }
  }
</style>

<ui-page header-text="[[i18nDynamic(locale, headerTextId)]]"
    icon-name="google-g">
  <span slot="message">
    <div id="animation-container">
      <pausable-lottie id="multideviceSetupAnimation"
        animation-url="[[getAnimationUrl_()]]">
      </pausable-lottie>
    </div>
  </span>
  <div id="additional-content-container" slot="additional-content"
      class="flex">
    <div id="selector-and-details-container">
      <div id="deviceSelectionContainer" class="flex">
        <div id="device-selection-header">
          [[getDeviceSelectionHeader_(devices)]]
        </div>
        <div id="singleDeviceName"
            hidden$="[[!doesDeviceListHaveOneElement_(devices)]]">
          [[getFirstDeviceNameInList_(devices)]]
        </div>
        <div hidden$="[[!doesDeviceListHaveMultipleElements_(devices)]]">
          <select id="deviceDropdown"
              class="md-select"
              on-change="onDeviceDropdownSelectionChanged_"
              aria-labelledby="device-selection-header">
            <template is="dom-repeat" items="[[devices]]">
              <option
                  class$="[[getDeviceOptionClass_(item.connectivityStatus)]]"
                  value$="[[getInstanceIdOrLegacyDeviceId_(item)]]">
                [[getDeviceNameWithConnectivityStatus_(item)]]
              </option>
            </template>
          </select>
        </div>
      </div>
      <div id="feature-details-container" class="flex">
        <div id="feature-details-container-header">
          [[i18nDynamic(locale, 'startSetupPageFeatureListHeader')]]
        </div>
        <!-- Feature: Phone Hub -->
        <template is="dom-if" if="[[phoneHubEnabled_]]">
          <div class="feature-detail">
            <iron-icon icon="multidevice-setup-icons-20:phonehub">
            </iron-icon>
            <div class="feature-detail-text">
              <span>[[i18nDynamic(locale, 'startSetupPageFeaturePhoneHubTitle')]]</span>
              <span>[[i18nDynamic(locale, 'startSetupPageFeaturePhoneHubDescription')]]</span>
            </div>
          </div>
        </template>
        <!-- Feature: Smart Lock -->
        <div class="feature-detail">
          <iron-icon icon="multidevice-setup-icons-20:smart-lock">
          </iron-icon>
          <div class="feature-detail-text">
            <span>[[i18nDynamic(locale, 'startSetupPageFeatureSmartLockTitle')]]</span>
            <span>[[i18nDynamic(locale, 'startSetupPageFeatureSmartLockDescription')]]</span>
          </div>
        </div>
        <!-- Feature: Wifi Sync -->
        <template is="dom-if" if="[[wifiSyncEnabled_]]">
          <div class="feature-detail">
            <iron-icon icon="multidevice-setup-icons-20:wifi-sync">
            </iron-icon>
            <div class="feature-detail-text">
              <span>[[i18nDynamic(locale, 'startSetupPageFeatureWifiSyncTitle')]]</span>
              <span>[[i18nDynamic(locale, 'startSetupPageFeatureWifiSyncDescription')]]</span>
            </div>
          </div>
        </template>
        <!-- Feature: Instant Tethering -->
        <div class="feature-detail">
          <iron-icon icon="multidevice-setup-icons-20:instant-tethering">
          </iron-icon>
          <div class="feature-detail-text">
            <span>[[i18nDynamic(locale, 'startSetupPageFeatureInstantTetheringTitle')]]</span>
            <span>[[i18nDynamic(locale, 'startSetupPageFeatureInstantTetheringDescription')]]</span>
          </div>
        </div>
      </div>
      <div class="footnote">
        [[i18nAdvancedDynamic_(locale, 'startSetupPageFootnote')]]
      </div>
    </div>
  </div>
</ui-page>
<!--_html_template_end_-->`;
}