import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="multidevice-setup-shared">
  :host {
    --multidevice-setup-dialog-height: var(--oobe-oobe-dialog-height-base);
    --multidevice-setup-dialog-width: var(--oobe-oobe-dialog-width-base);
    --multidevice-setup-dialog-content-padding: 40px;
  }

  :host-context([orientation=horizontal]) {
    --multidevice-setup-dialog-content-direction: row;
    --multidevice-setup-dialog-item-alignment: unset;
    --multidevice-setup-text-alignment: start;
    --multidevice-setup-dialog-content-width: calc(
        var(--multidevice-setup-dialog-width) -
        4 * var(--multidevice-setup-dialog-content-padding) -
        var(--multidevice-setup-dialog-header-width));
    /* Header takes 40% of the width remaining after applying padding */
    --multidevice-setup-dialog-header-width: clamp(302px,
        calc(0.4 * (var(--multidevice-setup-dialog-width) -
        4 * var(--multidevice-setup-dialog-content-padding))) , 346px);
  }

  :host-context([orientation=vertical]) {
    --multidevice-setup-dialog-content-direction: column;
    --multidevice-setup-dialog-item-alignment: center;
    --multidevice-setup-text-alignment: center;
    --multidevice-setup-dialog-content-width: calc(
        var(--multidevice-setup-dialog-width) -
        2 * var(--multidevice-setup-dialog-content-padding));
    /* Header takes 60% of the width remaining after applying padding */
    --multidevice-setup-dialog-header-width: clamp(346px,
        calc(0.6 * (var(--multidevice-setup-dialog-width) -
        2 * var(--multidevice-setup-dialog-content-padding))) , 520px);
  }

  iron-icon {
    --iron-icon-width: 32px;
    --iron-icon-height: 32px;
  }

  h1 {
    color: var(--cros-sys-on_surface);
    font-family: var(--cros-font-family-google-sans);
    font-size: 28px;
    font-weight: normal;
    line-height: 36px;
    margin: 0;
    padding-top: 40px;
    text-align: var(--multidevice-setup-text-alignment);
  }

  #message-container {
    color: var(--cros-sys-on_surface_variant);
    font: var(--cros-body-1-font);
    font-family: var(--cros-font-family-google-sans);
    line-height: 18px;
    min-height: 32px;
    overflow-wrap: break-word;
    padding-top: 16px;
    text-align: var(--multidevice-setup-text-alignment);
  }

  #main-container {
    align-items: var(--multidevice-setup-dialog-item-alignment);
    display: flex;
    flex-direction: var(--multidevice-setup-dialog-content-direction);
    height: 100%;
  }

  #header-container {
    align-items: var(--multidevice-setup-dialog-item-alignment);
    display: flex;
    flex-direction: column;
    padding-bottom: 0;
    padding-inline-end: var(--multidevice-setup-dialog-content-padding);
    padding-inline-start: var(--multidevice-setup-dialog-content-padding);
    padding-top: var(--multidevice-setup-dialog-content-padding);
    width: var(--multidevice-setup-dialog-header-width);
  }

  :host-context([screen=oobe]) #header-container,
  :host-context([screen=gaia-signin]) #header-container {
    overflow-y: hidden;
    padding-top: calc(var(--multidevice-setup-dialog-content-padding)
      + 2 * clamp(20px, calc(var(--multidevice-setup-dialog-height)
      * 0.035), 40px) + 34px);
  }

  #additional-content-container {
    border: transparent;
    display: flex;
    flex: 1;
    padding-bottom: 0;
    padding-inline-end: var(--multidevice-setup-dialog-content-padding);
    padding-inline-start: var(--multidevice-setup-dialog-content-padding);
    padding-top: 0;
    width: var(--multidevice-setup-dialog-content-width);
  }

  :host-context([orientation=vertical]) #additional-content-container {
    margin-top: 40px;
  }

  :host-context([orientation=horizontal][screen=oobe])
      #additional-content-container,
  :host-context([orientation=horizontal][screen=gaia-signin])
      #additional-content-container {
    margin-top: 80px;
  }

  :host-context([screen=oobe]) #additional-content-container,
  :host-context([screen=gaia-signin]) #additional-content-container {
    overflow-y: auto;
  }
</style>
<div id="main-container">
  <div id="header-container">
    <iron-icon icon="[[computeIconIdentifier_(iconName)]]"></iron-icon>
    <h1>[[headerText]]</h1>
    <div id="message-container">
      <slot name="message"></slot>
    </div>
  </div>
  <div id="additional-content-container">
    <slot name="additional-content"></slot>
  </div>
</div>
<!--_html_template_end_-->`;
}