import 'chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js';
export {};

const sheet = new CSSStyleSheet();
sheet.replaceSync(`
html {
  --areas-no-header-nav: "sideNav main";
  --areas-no-header-nav-banner: "banner banner"
                                "sideNav main";
  --iron-icon-fill-color: var(--cros-icon-color-primary);
  --iron-icon-height: 20px;
  --iron-icon-width: 20px;
  --left-aligned-top-offset: 64px;
}

/* calc formula: (viewport width - (padding + side nav size)) */
@media (min-width: 600px) {
  html {
    --areas-nav: "head head"
             "main main";
    --areas-nav-banner: "head head"
                        "banner banner"
                        "main main";
    --columns-nav: 1fr 1fr;
    --container-padding-nav: 24px;
    --container-max-width-nav: calc(100vw - 48px);
    }
}

@media (min-width: 769px) {
  html {
    --areas-nav: "head head"
             "sideNav main";
    --areas-nav-banner: "head head"
                        "banner banner"
                        "sideNav main";
    --columns-nav: 192px 1fr;
    --container-padding-nav: 40px;
    --container-max-width-nav: calc(100vw - 272px);
    }
}

@media (min-width: 961px) {
  html {
    --columns-nav: 248px 1fr;
    --container-padding-nav: 48px;
    --container-max-width-nav: calc(100vw - 344px);

  }
}`);
document.adoptedStyleSheets = [...document.adoptedStyleSheets, sheet];