import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style">
  ::slotted([slot=bottom-nav-content-drawer]) {
    position: absolute;
  }

  ::slotted([slot=bottom-nav-content-panel]) {
    position: fixed;
  }

  ::slotted([slot=bottom-nav-content-drawer]),
  ::slotted([slot=bottom-nav-content-panel]) {
    bottom: 24px;
    inset-inline-start: 16px;
  }

  ::slotted([slot=banner]) {
    grid-area: banner;
  }

  :host([show-banner]) {
    --left-aligned-top-offset: 120px;
  }

  :host {
    --navigation-view-panel-bg-color: var(--cros-bg-color);
    --navigation-view-panel-toolbar-height: 56px;
  }

  :host([show-banner][show-tool-bar]) #container {
    display: grid;
    grid-template-areas: var(--areas-nav-banner);
    grid-template-columns: var(--columns-nav);
    grid-template-rows: auto auto 1fr;
    width: 100%;
  }

  :host([show-banner]:not([show-tool-bar])) #container {
    display: grid;
    grid-template-areas: var(--areas-no-header-nav-banner);
    grid-template-columns: var(--columns-nav);
    grid-template-rows: auto 1fr;
    width: 100%;
  }

  :host([show-tool-bar]) #container {
    display: grid;
    grid-template-areas: var(--areas-nav);
    grid-template-columns: var(--columns-nav);
    grid-template-rows: auto 1fr;
    width: 100%;
  }

  :host(:not([show-tool-bar])) #container {
    display: grid;
    grid-template-areas: var(--areas-no-header-nav);
    grid-template-columns: var(--columns-nav);
  }

  :host([show-tool-bar]) #topNav {
    grid-area: head;
    position: sticky;
    top: 0;
    z-index: 3;
  }

  :host([show-banner]) #banner {
    grid-area: banner;
    position: sticky;
    top: 56px;
    z-index: 3;
  }

  #container {
    height: 100%;
    overflow: hidden;
  }

  cr-drawer {
    --cr-separator-line: none;
    --cr-drawer-background-color: var(--navigation-view-panel-bg-color);
    --cr-drawer-header-color: var(--cros-text-color-secondary);
    --cr-drawer-header-font-weight: 500;
    --cr-drawer-header-padding: 20px;
    --iron-icon-fill-color: var(--cros-text-color-secondary);
  }

  #iconButton {
    cursor: pointer;
    margin-inline-end: 14px;
    margin-inline-start: 0;
    outline: none;
  }

  #sideNav {
    display: flex;
    flex-direction: column;
    grid-area: sideNav;
    justify-content: flex-start;
    min-width: 0;
  }

  #navigationBody {
    box-sizing: border-box;
    grid-area: main;
    height: 100%;
    min-width: 0;
    overflow: overlay;
    padding-inline: var(--container-padding-nav);
    width: 100%;
  }

  .left-aligned {
    position: sticky;
    top: var(--left-aligned-top-offset);
  }

  page-toolbar {
    font-size: 0.7rem;
  }

  page-toolbar[shadow] {
    box-shadow: 0 5px 6px -3px rgb(var(--cros-shadow-color-key) / .4);
  }
</style>

<div id="container">
  <iron-media-query query="(min-width: 769px)" query-matches="{{showNav}}">
  </iron-media-query>
  <template is="dom-if" if="[[showToolBar]]">
    <div id="topNav" part="top-nav">
      <page-toolbar
          title="[[title]]"
          is-narrow="[[!showNav]]"
          has-search="[[hasSearch]]"
          exportparts="title">
        <slot slot="toolbar-main" name="toolbar-main"></slot>
      </page-toolbar>
    </div>
  </template>
  <template is="dom-if" if="[[showBanner]]">
    <div id="banner">
      <slot name="banner"></slot>
    </div>
  </template>
  <cr-drawer id="drawer" heading="[[title]]">
    <div slot="header-icon">
      <iron-icon id="iconButton" icon="cr20:menu"
          on-click="onMenuButtonTap_" title="[[title]]"
          aria-hidden="true">
      </iron-icon>
    </div>
    <div slot="body">
      <navigation-selector selector-items={{selectorItems_}}
          selected-item="{{selectedItem}}"
          exportparts="navigation-item">
      </navigation-selector>
      <slot name="bottom-nav-content-drawer"></slot>
    </div>
  </cr-drawer>
  <template is="dom-if" if="[[showNav]]">
    <div id="sideNav" part="side-nav">
      <div id="navigationSelector" class="left-aligned">
        <div part="nav-spacer"></div>
        <navigation-selector selector-items={{selectorItems_}}
            selected-item="{{selectedItem}}" exportparts="navigation-item">
        </navigation-selector>
        <slot name="bottom-nav-content-panel"></slot>
      </div>
    </div>
  </template>

  <div id="navigationBody" class="right-aligned" part="nav-body">
    <slot name="top-navigation-body"></slot>
  </div>
</div><!--_html_template_end_-->`;
}